### FILE="Main.annotation"
# Copyright:	Public domain.
# Filename:	P20-P25.agc
# Purpose:	Part of the source code for Artemis (i.e., Colossus 3),
#		build 072.  This is for the Command Module's (CM)
#		Apollo Guidance Computer (AGC), we believe for
#		Apollo 15-17.
# Assembler:	yaYUL
# Contact:	Jim Lawton <jim DOT lawton AT gmail DOT com>
# Website:	www.ibiblio.org/apollo/index.html
# Page scans:	www.ibiblio.org/apollo/ScansForConversion/Artemis072/
# Mod history:	2010-01-26 JL	Started Artemis072 conversion based on Comanche055 module.
# 		2010-01-31 JL	Finished Artemis072 conversion. Fixed build errors.
# 		2010-02-01 JL	Fixed build errors.
# 		2010-02-02 JL	Fixed page numbers. Removed duplicated code section on page 611.
# 		2010-02-06 JL	Added missing "DEC 18" instruction. Added missing code on page 618. Added missing line 
#				on page 601. Fixed line 5 on p580, which is overprinted in the scan. Fixed an EQUALS on
#				p589. Removed spurious PUSH on p598.
#		2010-02-13 JL	Fixed errors on pages 563, 589, 604, 619, 629.
#		2010-02-20 RSB	Un-##'d this header.

## Page 552

# RENDEZVOUS NAVIGATION PROGRAM 20
# PROGRAM DESCRIPTION
# MOD NO -1
# MOD BY - N. BRODEUR
#
# FUNCTIONAL DESCRIPTION
#
# TO INITIALIZE THE RENDEZVOUS NAVIGATION SUBROUTINES R22, R61CSM, AND
# R52, WHICH IN TURN CONTROL THE CSM ATTITUDE AND OPTICS POSITIONING.
# PROCESS BOTH OPTICS AND VHF TRACKING DATA, AND UPDATE EITHER THE LM
# OR THE CSM STATE VECTOR.
#
# CALLING SEQUENCE
#   V37E20E
#
# SUBROUTINES CALLED
#   R22 (RENDEZVOUS TRACK DATA PROCESSING)
#   R52 (AUTO OPTICS POSITIONING)
#   R61CSM (PREFERRED TRACKING ATTITUDE)
#   R02BOTH	       BANKCALL		   UPFLAG
#   DOWNFLAG	       2PHSCHNG		   LOADTIME
#   PRIOCHNG	       UPSTATE		   INTPRET
#   ENDOFJOB	       MKRLEES		   FINDVAC
#
# NORMAL EXIT MODES
#   RENDEZVOUS BAVIGATION MAY BE TERMINATED BY THE SELECTION OF
#   P00, P06, P22, P23, V34E FROM R60, AND V56E
#
# ALARM OR ABORT EXIT MODES
#   NONE DIRECTLY FROM P20
#
# OUTPUT
#   NONE DIRECTLY FROM P20
#
# FLAGS SET + RESET
#   RNDVZFLG, VEHUPFLG, UPDATFLG, TRACKFLG, TARG1FLG
#   PRFTRKAT, V50N18FL
#
		SETLOC	P20S7
		BANK
		
		EBANK=	R61CNTR
		COUNT*	$$/P20

PROG20		TC	BANKCALL
		CADR	R02BOTH		# IMU STATUS CHECK
					# BLOCKING OF UPLINK IS DONE BY UPLINK PRG
		CA	ADB
		TS	DBPTC
## Page 553
		TC	INTPRET
		CLEAR	SET
			VEHUPFLG	# UPDATE LM
			V50N18FL
		SET	SSP
			TRACKFLG
			OPTION2
			0
		BON	EXIT
			AUTOSEQ
			PRELOD78	# MINKEY  (PRELOAD N78)
		CAF	OCT24
		TC	BANKCALL
		CADR	GOPERF4
		TC	GOTOPOOH
		TCF	+2
		TCF	-5

		CA	OPTION2
		MASK	THREE
		CCS	A
		TC	DOV6N78		# OPTIONS 1,2,5  (DO NOT PRELOAD N78)
		TC	INTPRET		# OPTIONS 0,4           (PRELOAD N78)
PRELOD78	DLOAD
			35DEGANG
		STODL	UTPIT
			ZEROVECS
		STORE	UTYAW
		STORE	AZIMANGL
		BON	EXIT
			AUTOSEQ
			P20OPT		# MINKEY, BYPASS V04N06 AND V06N78
DOV6N78		CAF	V06N78UT
		TC	VNFLASH
		CAF	V06N79UT
		TC	VNFLASHR

		TCF	ENDV6N79

		CA	OPTION2
		MASK	BIT2
		CCS	A
		TC	ENDOFJOB	# OPTION 2, BLANK ONLY R31
		CAF	FIVE		# BLANK BOTH R1,R3
		TC	BLANKET
		TC	ENDOFJOB
ENDV6N79	CA	OPTION2
		MASK	BIT3
		EXTEND
		BZF	NOAZIM
## Page 554
		TC	UPFLAG
		ADRES	AZIMFLAG
		
		TCF	COMAZM
		
P20OPT		EXIT
NOAZIM		TC	DOWNFLAG
		ADRES	AZIMFLAG

COMAZM		CA	OPTION2
		MASK	THREE
		CCS	A
		TCF	UTKINPUT
		TC	DOWNFLAG
		ADRES	UTFLAG
		
		TC	UPFLAG
		ADRES	UPDATFLG
		
NOUTINPT	TC	2PHSCHNG
		OCT	00004
		OCT	05022
		OCT	26000
		CAF	UTBIT
		MASK	FLAGWRD8
		CCS	A
		TCF	INTSETUP
		
		TC	INTPRET
		RTB
			LOADTIME
		STCALL	MARKTIME
			UPSTATE
		EXIT
		
		TC	UPFLAG
		ADRES	RNDVZFLG
		
		CAF	PRIO26
		TC	FINDVAC
		EBANK=	MRKBUF1
		2CADR	R22
		TC	2PHSCHNG
		OCT	00072
		OCT	00111
1P11SPT3	=	1.11SPOT
2P7SPT1		=	2.7SPOT
		TC	AUTOCHK
## Page 555
		TCF	PIKUP20
		
INTSETUP	CAF	PRIO5
		TC	FINDVAC
		EBANK=	RRECTCSM
		2CADR	STATINT1
		
		TC	2PHSCHNG
		OCT	0052
		OCT	00111
		
1P11SPT4	=	1.11SPOT
2P5SPT3		=	2.5SPOT
PIKUP20		CAF	PRIO14		# ALLOW HIGHER PRIO THAN LAMBERT
		TC	PRIOCHNG
		CAF	TRACKBIT
		MASK	FLAGWRD1	# IS TRACK FLAG SET
		EXTEND
		BZF	FIXDB
		CAF	REFSMBIT
		MASK	FLAGWRD3	# IS REFSMFLAG SET
		EXTEND
		BZF	FIXDB
		
		CAF	ZERO
		TS	R61CNTR		# INITIALIZE R61 COUNTER
		CA	FLAGWRD8
		MASK	UTBIT
		CCS	A
		TC	CALLR6X
		
		TC	UPFLAG
		ADRES	R21MARK
		TC	BANKCALL
		CADR	R61CSM
		CS	FLGWRD10	# CHECK IF PC MANEUVER TO TRACK
		MASK	PCMANBIT	#      ATTITUDE
		EXTEND
		BZF	AUTOCHK1
P20TRACK	TC	UPFLAG		# SET TARG FLAG TO LEM FOR R52
		ADRES	TARG1FLG	# BIT 10  FLAG 1
P20R52JB	TC	INTPRET
		CALL
			R52		# SET UP AUTO OPTICS JOB
		EXIT
		TC	BANKCALL
		CADR	MKRLEES
		TCF	FIXDB
		
UTKINPUT	TS	OPTNTYPE
## Page 556
		TC	UPFLAG
		ADRES	UTFLAG
		
		TC	DOWNFLAG
		ADRES	RNDVZFLG
		
		CCS	OPTNTYPE
		TC	TYPE2IN
		
V1N70DSP	CAF	V01N70UT
		TC	VNFLASH
		CCS	STARCODE
		AD	NEG47UT
		CCS	A
		TCF	NOGOOD
		
		TCF	+2
		TCF	+1
		CA	STARCODE
		TS	UTSTARNO
		
		CCS	A
		TCF	NOUTINPT
		
		CAF	V06N88UT
		TC	VNFLASH
		TC	INTPRET
		VLOAD
			STARSAV3
		STORE	PLANVCUT
		EXIT
		TC	NOUTINPT
		
NOGOOD		TC	FALTON
		TC	V1N70DSP
		
TYPE2IN		CAF	V06N34UT
		TC	VNFLASH
		EXTEND
		DCA	DSPTEM1
		DXCH	R67TIME
		TCF	NOUTINPT
		
CALLR6X		TC	DOWNFLAG
		ADRES	R21MARK
		
		CCS	OPTNTYPE
		TCF	TYPE2
		
		TC	POSTJUMP
## Page 557
		CADR	R66CSM
		
TYPE2		EXTEND
		DCS	TIME2
		DXCH	MPAC
		EXTEND
		DCA	R67TIME
		DAS	MPAC
		TC	DPAGREE
		CCS	MPAC
		TCF	DODELAY
		
		TCF	+3
		CAF	ZERO
		TS	MPAC +1
		CCS	MPAC +1
		TCF	+1
		AD	ONE
		TC	WAITLIST
		EBANK=	R61CNTR
		2CADR	R67
		
		TC	ENDOFJOB
		
DODELAY		CAF	POSMAX
		TC	BANKCALL
		CADR	DELAYJOB
		TCF	TYPE2
		
R67		CAF	PRIO26
		TC	FINDVAC
		EBANK=	R61CNTR
		2CADR	R67START
		
		TC	UPFLAG
		ADRES	R67FLAG
		
		TC	TASKOVER
		
R67START	TC	INTPRET
		BON	RTB
			STIKFLAG
			NOGOM3
			READCDUK
		STCALL	BCDU
			UTPRFAX
		STORE	COF
		EXIT
		
		INHINT
## Page 558
		CAF	MINDB
		TS	ADB
		CCS	DBPTC
		AD	ONE
		TC	+2
		AD	ONE
		EXTEND
		BZF	+2
		TS	ADB
		
		TC	INTPRET
		SLOAD	DMP
			RATEPTC
			TUFITS		# SCALING FACTOR(.4 DEC)
		SR4	CALL		# COMPUTE THE INCREMENTAL ROTATION MATRIX
			DELCOMP		# DEL CORRESPONDING TO A  1 SEC ROTATION
		SLOAD	DMP		# ABOUT COF
			RATEPTC
			TUFITS
		VXSC	MXV
			COF
			QUADROT
		STOVL	BRATE
			ZEROVECS
		STORE	BIASTEMP
		EXIT
		
		TC	PHASCHNG
		OCT	00131
		
1P13SPT1	=	1.13SPOT
R67RSTRT	CA	FLAGWRD1
		MASK	TRACKBIT
		EXTEND
		BZF	FIXDB
		CAF	BIT12
		TS	R61CNTR
		
		CAF	PRIO26
		TC	PRIOCHNG
		
		TC	INTPRET
		AXC,2	TLOAD
			MIS
			BCDU
		SET	CALL
			R67FLAG
			CDUTODCM
		SETGO
			CALCMAN2	# SET CALCMAN2 TO START MANEUVER
## Page 559
			NEWANGL +1
			
FIXDB		CA	FLAGWRD9	# RESTORE DAP DEADBAND
		INHINT
		MASK	MAXDBBIT
		CCS	A
		TCF	+4
		
		TC	BANKCALL
		CADR	SETMINDB
		TCF	+3
		
		TC	BANKCALL
		CADR	SETMAXDB
		
		TC	DOWNFLAG
		ADRES	R67FLAG
		TC	PHASCHNG
		OCT	00111
1P11SPT5	=	1.11SPOT
STOPVEH		INHINT
		TC	STOPRATE
		TCF	ENDOFJOB
		
UTPRFAX		DLOAD	SIN		# COMPUTE PREFERRED UNIT VECTOR
			UTPIT		# 		      MPAC   =COS(P)COS(Y)
		DCOMP	PDDL		# PDX=-SIN(P)	      MPAC +2=COS(P)SIN(Y)
			UTPIT		# 		      MPAC +4=-SIN(P)
		COS	PUSH		# PDX+2=COS(P) USED WITH SECOND DMP BELOW
		PDDL	SIN		# PDX+4=COS(P) USED WITH FIRST  DMP BELOW
			UTYAW
		DMP	SL1		# MPAC=COS(P)SIN(Y)
		PDDL			# REPLACE PDX+2 WITH COS(P)SIN(Y)
		PDDL	COS		# REPLACE PDX+4 WITH COS(P) IN ORDER TO
			UTYAW		#  POSITION PD COUNTER FOR DMP
		DMP	SL1
		VDEF	RVQ		# PUSHUP FOR Y,Z COMPONENTS
		
R66CSM		CS	FLAGWRD1	# R66 CONTROL
		MASK	TRACKBIT
		CCS	A
		TCF	FIXDB
		
		TC	BANKCALL	# TRACKFLG SET, CONTINUE R66
		CADR	R61CSM		# CALL R61
		
		CAF	.5SEC
		TC	BANKCALL	# WAIT .5 SEC AND REPEAT
		CADR	DELAYJOB
## Page 560
		TC	R66CSM

35DEGANG	2DEC	-.097222222222
V06N78UT	VN	0678
V01N70UT	VN	0170
V06N88UT	=	V06N88
V06N79UT	VN	0679
V06N34UT	=	V06N34
TUFITS		2DEC	.4
NEG47UT		OCT	77730

## Page 561
# ORBITAL NAVIGATION PROGRAM 22
		SETLOC	P20S1
		BANK

		EBANK=	LANDMARK
		COUNT*	$$/P22

PROG22		TC	BANKCALL
		CADR	R02BOTH
		TC	INTPRET
		BOFF	SET
			UTFLAG
			+2
			TRACKFLG
		CLEAR	RTB
			RNDVZFLG
			LOADTIME
		STCALL	TDEC1
			CSMCONIC	# INTEGRATE TO PRESENT TIME
		VLOAD	VXV		# CROSS PRODUCT BETWEEN V AND R
			VATT
			RATT
		UNIT	DOT
			REFSMMAT +6
		ABS
		SL1	ARCCOS
		STORE	+MGA
		EXIT
		CAF	V06N45B
		TC	VNFLASHR
		TC	PROG22A
		CAF	THREE
		TC	BLANKET		# BLANK OUT R1 + R2
		TC	ENDOFJOB
PROG22A		CS	PRIO7		# RESULT=70777  SET OFFSET NO.=0
		MASK	LANDMARK
		TS	LANDMARK
		TC	2PHSCHNG
		OCT	00004
		OCT	05022
		OCT	13000
		TC	UPFLAG
		ADRES	TARG2FLG	# SET =1 FOR SIGHTING LMK
		TC	UPFLAG
		ADRES	VEHUPFLG	# VEH.=CSM
		TC	INTPRET
		CLEAR	CLEAR
			LUNAFLAG
			P22MKFLG
		SET	BOFF
## Page 562
			ERADFLAG
			CMOONFLG
			PROG22B		# EARTH
		SET			# MOON
			LUNAFLAG
		DLOAD	CALL		# MPAC=V05N70,MPAC+1=NONZERO FOR N70
			V05N7022
			S22N7071
		GOTO
			CALLR52
PROG22B		CALL			# GET LAT/LONG/ALT FROM ASTRO
			P22SUBRB
CALLR52		CALL
			R52
DOV5N71		SLOAD	CALL		# MPAC=V05N71,MPAC+1=0 FOR N71
			V05N7122
			S22N7071
PROG22C		SET	SSP
			P22MKFLG	# FOR DOWNLINK
			8KK
		DEC	1
		SSP	EXIT
			S22LOC
		ECADR	SVMRKDAT
		TC	S22.1
		
V06N45B		VN	0645
V05N7022	=	V05N70
V05N7122	=	V05N71
S22LSITE	RTB			# CONVERT RLS FROM MOON-FIXED TO BASIC REF
			LOADTIME
		STOVL	6D		# 6-7D= TIME
			RLS
		STODL	0D		# 0-5D= LANDING SITE VECTOR
			HIDPHALF	# MPAC= ANY NON-ZERO FOR MOON
		CALL
			RP-TO-R		# RLS IN BASIC REF B-27 IN MPAC
		VSR2			# LUNAFLAG AND ERADFLAG SET ABOVE
		STORE	ALPHAV		# SCALE RLS B-29 FOR LAT-LONG
		RTB	
			LOADTIME	# SET PRESENT TIME IN MPAC FOR LAT-LONG
		CALL
			LAT-LONG
		GOTO
			S22TOFF		# EXIT
OBTAINLL	CALL			# GET LAT/LONG/ALT FROM ASTRO
			P22SUBRB
		GOTO
			S22TOFF		# EXIT
P22SUBRB	STQ	EXIT		# GET LAT/LONG/ALT FROM ASTRO
## Page 563
			S22TOFF +1
 +2		CAF	V06N89B
		TC	VNFLASH
		TC	INTPRET
		DLOAD	ABS		# TEST LAT/LONG GREATER THAN 90
			LANDLAT
		BDSU	BMN		# 1/4 REV - LAT
			DP1/4TH
			N89ERRX
		DLOAD	ABS
			LANDLONG
		BDSU	BPL
			DP1/4TH
			N89ERRX +3
N89ERRX		EXIT
		TC	FALTON
		TC	P22SUBRB +2	# LONG GR. THAN 90  REDISPLAY
 +3		CALL
			LLASRDA
		GOTO
			S22TOFF +1	# EXIT
S22N7071	STORE	8KK		# 8KK=V05N71,V05N70 8KK+1=0 N71,NOT 0 N70
		STQ	EXIT
			S22TOFF
S22DSPPA	CA	8KK		# V05N70 OR V05N71
		TC	VNFLASHR
		TC	+4
		CAF	FIVE		# IMMEDIATE RETURN BLANK OUT R1,R3
		TC	BLANKET
		TC	ENDOFJOB
		CA	LANDMARK
		MASK	PRIO7		# 07000
		EXTEND
		MP	BIT6
		TS	CXOFF		# 08000 = OFFSET INDICATOR
		CS	FIVE
		AD	CXOFF
		EXTEND
		BZMF	+2		# OFF=0 THRU 5 OK
		TC	S22DSPP		# OFF=6.7 ILLEGAL REDISPLAY
		TC	DOWNFLAG
		ADRES	KNOWNFLG	# CLEAR KNOWNFLG
		CA	LANDMARK	# MASK A FROM ABCDE
		MASK	13,14,15
		EXTEND
		BZMF	S22DSPP		# A=0,4,5,6,7  ILLEGAL REDISPLAY
		TS	22SUBSCL	# TEMP
		CS	BIT14
		AD	22SUBSCL
		CCS	A
## Page 564
S22DSPP		TC	FALTON		# +  A=3 ILLEGAL REDISPLAY
		TC	S22DSPPA	# COMMON ERROR EXIT BACK TO DISPLAY
		TC	+2		# -   A=1 KNOWN LMK  CHECK DE
		TC	S22ABDE		# -0  A=2 UNKNOWN LMK,DE MEANINGLESS
		TC 	UPFLAG
		ADRES	KNOWNFLG	# SET KNOWNFLG
		CS	HIGH9		# RESULT= 00077
		MASK	LANDMARK
		TS	22SUBSCL	# 000DE
		CS	BIT1
		AD	22SUBSCL
		EXTEND
		BZMF	S22ABDE		# DE=0,1 OK FOR BOTH N70,N71
		CA	8KK +1		# =0 FOR N71, NOT =0 FOR N70
		EXTEND
		BZF	S22DSPP		# N71 REDISPLAY  DE MUST= 0 OR 1
		CA	BIT5		# N70 TEST DE= 50-57 OCTAL FOR ADV. ORBIT
		AD	OCT50		# SUM=00070
		MASK	22SUBSCL	# 00D0
		CS	A
		AD	OCT50
		EXTEND
		BZF	DE-GR-50	# D=5 OR DE=50-57,OK FOR N70
		TC	S22DSPP		# DE NOT 50-57  ILLEGAL,REDISPLAY
S22ABDE		TC	INTPRET
		BOFF	SLOAD
			KNOWNFLG	# UNKNOWN LMK, DE MEANINGLESS
			S22TOFF
			22SUBSCL	# =0 GET LLA FROM ASTRO,NOT=0 USE RLS
		BHIZ	GOTO
			OBTAINLL	# GET LAT/LONG/ALT FROM ASTRO  N89
			S22LSITE	# GET LAT/LONG/ALT FROM RLS
DE-GR-50	TC	INTPRET		# ADVANCED ORBIT OPTION IN R52
		SET	CALL		# ADVANCED ORBIT ENTRANCE TO R52
			ADVTRK
			R52VRB
		GOTO
			DOV5N71
		SETLOC	P24PROG
		BANK

## Page 565
		COUNT*	$$/P24
PROG24		CA	NO.PASS
		TS	PASSCNT
		TC	2PHSCHNG
		OCT	00004
		OCT	05022
		OCT	13000
		TC	BANKCALL
		CADR	R02BOTH		# IMU STATUS CHECK
		TC	INTPRET
		BOFF	SET
			UTFLAG
			+2
			TRACKFLG
		CLEAR	CLEAR
			P24MKFLG
			NEWLMFLG
		CLEAR	CLEAR
			ORBWFLAG
			RENDWFLG
		SSP	AXT,1		# ZERO P22 DOWNLIST MARK BUFFER
			S1
		DEC	6
		DEC	36
		SET	VLOAD
			P24FLAG
			ZEROVEC
ZERODNLK	STORE	SVMRKDAT +36D,1
		TIX,1	CLEAR
			ZERODNLK
			P22MKFLG
		CLEAR	RTB
			RNDVZFLG
			LOADTIME
		STCALL	MARKTIME
			SETINTG
		CALL
			INTEGRV		# UPDATE STATE VEC TO CURRENT TIME
		SET	CLEAR
			ERADFLAG
			LUNAFLAG
		BOFF	SET
			CMOONFLG
			+2
			LUNAFLAG
		CALL
			P22SUBRB
		EXIT
		TC	2PHSCHNG
## Page 566
		OCT	00004
		OCT	05022
		OCT	13000
		TC	INTPRET
		SET	CALL
			TARG2FLG
			R52
		EXIT
		TC	GOTOPOOH

## Page 567

# PROGRAM NAME-  OPTICS CALIBRATION ROUTINE
# MOD NO- 1
# MOD BY- TOM KNATT
#
# FUNCTIONAL DESCRIPTION- TO MEASURE THE EFFECT OF SOLAR RADIATION ON
#   THE SXT TRUNNION ANGLE AND STORE THE MEASURED TRUNNION BIAS FOR P23
#
# CALLING SEQUENCE- CALL
#			  R57
#
# SUBROUTINES CALLED- DISPLAY ROUTINES
#
# NORMAL EXIT MODES-VIA EGRESS
#
# ALARMS- NONE
#
# ABORT MODES- P23ABORT IF MARKING SYSTEM OR EXTENDED VERB ACTIVE
# INPUT- NONE REQUIRED, NORMALLY CALLED BY P23
# OUTPUT- TRUNNION BIAS ANGLE- ANGLE DETERMINED WHEN SHAFT LINE OF SIGHT
# (SLOS) AND LANDMARK LINE OF SIGHT (LLOS) ARE SUPERIMPOSED. THIS ANGLE
# MAY NOT BE EXACTLY ZERO BECAUSE OF UNEVEN HEATING OF THE OPTICS,FOR
# EXAMPLE.
#
# ERASABLE INITIALIZATION REQUIRED- MRKBUF1, EXTVBACT
#
# DEBRIS- RUPTREGS USED BY MARKRUPT AND ERASABLES USED BY DISPLAYS
		SETLOC	P20S
		BANK
		COUNT*	$$/R57
		EBANK=	MRKBUF1
R57		STQ	EXIT
			EGRESS
R57A		CS	FLAGWRD3	# IS THE IMU ALIGNED
		MASK	REFSMBIT
		CCS	A
		TCF	R57C		# NO
		CAF	ALRM15		# YES SHOULD AUTO ACQUISITION OF STAR
		TC	BANKCALL	#     BE PERFORMED
		CADR	GOPERF1
		TC	GOTOPOOH	# TERM
		TC	+2		# PRO YES
		TC	R57C		# ENTER NO
		TC	INTPRET
		CALL
			R51DSPA
		CALL
			DOR60
		EXIT
		TC	PHASCHNG
		OCT	04022
## Page 568
R57C		TC	BANKCALL
		CADR	TESTMARK
		TC	UPFLAG		# SET V59FLAG (BIT 12 FLAG 5 TO INDICATE
		ADRES	V59FLAG		# CALIBRATION MARK
		CAF	V59NB
		TC	BANKCALL
		CADR	GOMARKFR
		TC	GOTOPOOH	# TERMINATE
		TC	ENDR57
		TC	ENDR57
		CAF	SEVEN
		TC	BLANKET		# BLANK OUT R1,R2,R3
		TC	ENDOFJOB
# STORE TRUNNION ANGLE (OCDU)
MARKDISP	CAF	V06N87NB
		TC	BANKCALL
		CADR	GOMARKFR
		TC	GOTOPOOH	# TERMINATE
		TC	R57B		# PROCEED
		TC	R57D		# RECYCLE
		CAF	FIVE
		TC	BLANKET		# BLANK OUT R1,R3
		TC	ENDOFJOB
R57B		CA	19.77DEG	# PUT FIXED INTO ERASABLE FOR MSU
		TS	L		# INSTRUCTION COMING UP
		CA	MRKBUF1 +5	# CONTAINS TRUNNION
		EXTEND
		MSU	L		# CORRECTS TRUNBIAS FROM 2'S TO 1'S
		TS	TRUNBIAS
ENDR57		TC	DOWNFLAG	# RESET V59FLAG
		ADRES	V59FLAG		# BIT 12  FLAG 5
		TC	CLEARMRK	# ALLOW R53 IN
		
		TC	INTPRET
		GOTO
			EGRESS
R57D		TC	CLEARMRK
		TCF	R57A
V06N87NB	VN	0687
V59NB		VN	5900
V51N45		VN	5145
19.77DEG	OCT	61740

## Page 569

# RENDEZVOUS TRACKING SIGHTING MARK ROUTINE (R21)
# AND BACKUP SIGHTING MARK ROUTINE (R23)
#
# PROGRAM DESCRIPTION
# MOD NO - 1
# MOD BY - N.BRODEUR
# FUNCTIONAL DESCRIPTION
#
#   TO PERFORM SIGHTING MARKS IN CONJUNCTION WITH THE RENDEZVOUS NAVIG-
# ATION PROGRAM. CALLED BY ASTRONAUT VIA EXTENDED VERB.
# CALLING SEQUENCE -
#	  R21 VIA V 57
#	  R23 VIA V 54
# SUBROUTINES CALLED -
#   FLAGUP	  FLAGDOWN	  BANKCALL
#   ENDOFJOB	  GOMARK2	  GOMARKF
#   INTPRET	  GENTRAN	  KLEENEX
#   ENDMARK
# NORMAL EXIT MODES-
#   MARKRUPT USED BY SXTMARK HAS BEEN MODIFIED TO STORE MARK IN MRKBUF2
# FOR USE BY R22. WHEN ASTRONAUT IS FINISHED TAKING MARKS, HE HITS AN
# PROCEED ,   R21 IS TERMINATED THUS CAUSING THE FINAL MARK TO BE TRANSFRD
# TO MRKBUF2 FOR PROCESSING BY R22
# ALARM OR ABORT EXIT MODES -
#   NONE
# OUTPUT -
#   7 REGISTER MRKBUF2 CONTAINING TIME2,TIME1,CDUY,OPTICS X,CDUZ, OPTICS Y,
# CDUX.
# ERASABLE INTIALIZATION REQUIRED
# FLAGS SET AND RESET
#   R21MARK   (COMMUNICATION TO MARKRUPT TO STORE MARKS IN MRKBUF1 + 2)
#   R23FLG  INDICATES COAS MARKING
# DEBRIS
		EBANK=	MRKBUF1
		SETLOC	RENDEZ
		BANK
		
		COUNT*	$$/R23
		
R23CSM		TC	DOWNFLAG
		ADRES	R21MARK
		CAF	NEGONE
		TS	MRKBUF1
		CAF	PRIO27
		TC	PRIOCHNG	# HIGHER THAN R22

		CAF	V0694		# R23 BACKUP MARKING
		TC	BANKCALL	# DISPLAY SHAFT + TRUNNION
		CADR	GOMARKF
		TC	R21END		# TERM
		TC	+2		# PROC
## Page 570
		TC	-5		# ENTER
R23CSM1		CAF	V53N45		# PERFORM ALT LOS SIGHT MARK
		TC	BANKCALL
		CADR	MARKMONR
		TC	R21END		# V34-TERMINATE R23
		TCF	R21END		# PRO END BACK-UP MARKING (R23)
		INHINT
		EXTEND
		DCA	TIME2
		DXCH	MRKBUF1		# READ TIME
		CA	CDUY		# READ CDU ANGLES
		TS	MRKBUF1 +2
		CA	CDUZ
		TS	MRKBUF1 +4
		CA	CDUX
		TS	MRKBUF1 +6
		RELINT
		TC	R23CSM1
R21END		TC	BANKCALL
		CADR	KLEENEX
		CA	NEGONE
		TS	MRKBUF1		# CLEAR BUFFERS FOR REGULAR MARKING
		CAF	PRIO16
		TC	PRIOCHNG	# LOWER THAN R22
		
		TC	UPFLAG		# SET R21MARK TO ALLOW REG OPTICS MARKING
		ADRES	R21MARK		# BIT 14  FLAG 2
		TC	ENDMARK		# END MARKING AND ENDJOB
V53N45		VN	5345
V0694		VN	0694

## Page 571

# PREFERRED TRACKING ATTITUDE ROUTINE R61CSM
# PROGRAM DESCRIPTION
# MOD NO - 2
# MOD BY - N.BRODEUR
# FUNCTIONAL DESCRIPTION-
#   TO COMPUTE THE PREFERRED TRACKING ATTITUDE OF THE CSM TO ENABLE OPTICS
# TRACKING OF THE LM AND TO PERFORM THE MANEUVER TO THE PREFERRED
# OR X-AXIS TRACKING ATTITUDE.
# CALLING SEQUENCE-
#	   TC	  BANKCALL
#	   CADR	  R61CSM
# SUBROUTINES CALLED
#   MAKECADR	     BANKCALL
#   INTPRET	  FLAGUP	  FLAGDOWN
#   BANKJUMP	  CRS61.1	  R60CSM
#   PHASCHNG
# NORMAL EXIT MODES-
#   NORMAL RETURN IS TO CALLER + 1
# OUTPUT -
#   SEE OUTPUT FOR CRS61.1 & ATTITUDE MANEUVER ROUTINE (R60CSM)
# ERASABLE INITIALIZATION REQUIRED
#   GENRET USED TO SAVE Q FOR RETURN
#   R61CNTR MUST BE PRESET TO ZERO
# FLAGS SET + RESET
#   3-AXIS FLAG
# DEBRIS
#   SEE SUBROUTINES
		EBANK=	GENRET
		COUNT*	$$/R61		# ROUTINES - NAVIGATION - PREF. TR. 9TT=

R61CSM		TC	E6SETTER	# SWITCH TO E6 - RETURNS WITH OLD SETTING
		TS	SAVBNK		# SAVE EBANK
		TC	MAKECADR
		TS	GENRET
		CCS	R61CNTR		# TEST R61CNTR
		TC	DECRM61		# NOT READY TO DO R61.
		TC	+2		# DO R61
		TC	DECRM61 +1
		INHINT
		CAF	MINDB
		TS	ADB
		CCS	DBPTC
		AD	ONE
		TCF	+2
		AD	ONE
		EXTEND
		BZF	+2		# IGNOR ZERO DEADBAND
		TS	ADB

		TC	INTPRET
## Page 572
		CALL
			CRS61.1		# LOS DETERMINATION + VEH ATTITUDE
R61DMPTG	EXIT			# DEFINE TAG FOR P20 EDIT DUMP
		TC	DOWNFLAG	# RESET FLAG TO INHIBIT FURTHER R60
		ADRES	V50N18FL	#    ATTITUDE MANEUVERS
		INDEX	MPAC
		TC	+1
		TC	R61END		# SUBROUTINE DRIVING DAP (EXIT R61)
					# OR AUTO MODE NOT SET (EXIT R61)
					# OR SKIKFLAG SET      (EXIT R61)
R61C1		TC	DOWNFLAG	# RESET 3-AXIS FLAG
		ADRES	3AXISFLG	# BIT 6  FLAG 5
		CS	FLGWRD11
		MASK	AZIMBIT
		CCS	A
		TC	+3		# AZIMFLAG NOT SET,CLEAR 3AXISFLA7
		
		TC	UPFLAG		# AZIMFLAG SET    ,SET   3AXISFLAG
		ADRES	3AXISFLG
		
		CS	ONE		# SET R61CNTR NEG. TO INDICATE KALCMANU
		TS	R61CNTR
		
		TC	UPFLAG		# SET FLAG FOR PROIRITY DISPLAYS FOR R60
		ADRES	PDSPFLAG	# BIT 12  FLAG 4
		TC	BANKCALL
		CADR	R60CSM
		TC	DOWNFLAG	# RESET FLAG FOR PRIORITY DISPLAYS IN R60
		ADRES	PDSPFLAG	# BIT 12  FLAG 4
		CAF	ZERO
		TC	BANKCALL
		CADR	PRIODSP		# RELEASE DISPLAY
		TC	PHASCHNG
		OCT	00111
1P11SPT6	=	1.11SPOT
		CAF	ZERO
		TC	DECRM61
R61END		CAF	THREE

DECRM61		TS	R61CNTR

 +1		CAE	GENRET
		LXCH	A		# RETURN IS IN L
		CA	SAVBNK		# RESTORE EBANK
		XCH	EBANK
		LXCH	A		# RETURN IS NOW BACK IN A
		TC	BANKJUMP	# EXIT R61
		SETLOC	P20S2
		BANK
## Page 573
		EBANK=	MRKBUF1

## Page 574

#  BVECTOR PERFORMS COMPUTATIONS FOR
# DELTAQ,THE MEASURED DEVIATION BASED ON THE DIFFERENCE BETWEEN THE CSM-LE
# M STATE VECTOR ESTIMATES AND THE ACTUAL TRACKING MEASUREMENT.
# US,THE MODIFIED FICTITIOUS STAR DIRECTION VECTOR
# GEOMETRY VECTORY B ASSOCIATED WITH EACH TRACKING MEASUREMENT.
# INPUT
#    UM,1/2 UNIT VECTOR ALONG THE CSM-LM LINE-OF-SIGHT (BASIC REF.SYSTEM)
#    USTAR,FICTITIOUS STAR DIRECTION (1/2 UNIT VECTOR)
#    RCLP,RELATIVE CSM TO LM POSITION VECTOR
# OUTPUT
#    USTAR,MODIFIED FICTITIOUS STAR DIRECTION (1/2 UNIT VECTOR)
#    BVECTOR = 9 DIMENTIONAL BVECTOR (1/2 UNIT VEC.)
#    DELTAQ = MEASURED DEVIATION
# CALLING SEQUENCE
#    L  CALL BVECTORS
# NORMAL EXIT
#    L+1 OF CALLING SEQUENCE

		COUNT*	$$/INCOR
BVECTORS	STQ
			EGRESS
		VLOAD	UNIT
			RCLP		# RELATIVE POSITION VECTOR
		STODL	26D		# RCLP UNIT VEC
			36D		# RCLP ABS VALUE
		STOVL	TEMPOR1		# MOVE TO SAFE LOCATION
			USTAR
		VXV	UNIT
			26D		# USTAR = UNIT(US X UCL)
		STCALL	BVECTOR
			GRP2PC		# PHASE CHANGE
		VLOAD
			BVECTOR
		STORE	USTAR
		DOT	SL1
			UM		# USTAR DOT UM
		ACOS	DSU
			DP1/4TH
		NORM	DMP
			X1
			PI/4.0
		DMP	SRR*
			TEMPOR1		# RCLP ABS VALUE
			0 -3,1		# ADJUST SCALING
		STOVL	DELTAQ
			ZEROVECS
		STORE	BVECTOR +6
		STORE	BVECTOR +12D
		GOTO
			EGRESS
## Page 575
PI/4.0		2DEC	.785398164

## Page 576

#  GETUM-DETERMINES THE LINE OF SIGHT UNIT VECTOR UM IN THE BASIC REFERENC
# E COORDINATE SYSTEM FROM THE OPTICS SHAFT AND TRUNNION ANGLES AND THE IM
# U GIMBAL ANGLES.
# INPUT
#    MARKDATA,BASE ADDRESS OF MARK DATA
#    REFSMMAT,ROTATION MATRIX FROM STABLE MEMBER TO BASIC REF.COORD.SYSTEM
#
# SUROUTINES CALLED-
#    SXTNB - SEXT. ANGULAR READINGS TO NAV. BASE COOR.
#    NBSM  - TRANSFORM FROM NAV. BASE TO STABLE MEMBER
# OUTPUT
#    MPAC = LINE OF SIGHT 1/2 UNIT VECTOR IN BASIC REFERENCE SYSTEM
# CALLING SEQUENCE
#    L  CALL GETUM
#
# NORMAL EXIT
#    L+1 OF CALLING SEQUENCE
	
GETUM		STQ	SETPD
			EGRESS
			0
		CALL	
			SXTSM1
		VXM	VSL1		
			REFSMMAT
		GOTO			# MPAC = (UM)LINE OF SIGHT VECTOR
			EGRESS		# EXIT
			
## Page 577

# RENDEZVOUS TRACKING DATA PROCESSING ROUTINE (R22)
#
# FUNCTIONAL DESCRIPTION
#
# TO PROCESS RENDEZVOUS SIGHTING MARK AND VHF RANGING DATA TO UPDATE 
# THE STATE VECTOR OF EITHER THE CSM OR LM AS DEFINED BY VEHUPFLG.
# (VEHUPFLG IS SET TO LM BY P20, CSM BY V81E, AND LM BY V80E.)
#
# CALLING SEQUENCE
#   AUTOMATICALLY SELECTED BY P20
#
# SUBROUTINES CALLED
#   PRIOCHNG	       INTPRET		   GRP2PC
#   GETUM	       BVECTORS		   INCORP1
#   INCORP2	       INTEGRV		   PHASCHNG
#   NOVAC	       BANKCALL		   GOTOV56
#   ENDOFJOB	       INSTALL		   DOWNFLAG
#   TRFAILOF	       TRFAILON		   TASKOVER
#   POSTJUMP
#
# NORMAL EXIT MODES
#   RENDEZVOUS NAVIGATION MAY BE TERMINATED BY THE SELECTION OF
#   P00, P06, P22, P23, V34E FROM R60, AND V56E
#
# ALARMS OR ABORT EXIT MODES
#   NONE
#
# INPUT
#   MARK DATA. SEE R21 AND R23
#   VHF RANGING DATA
#
# OUTPUT
#   TRKMKCNT, NO OF RENDEZVOUS TRACKING MARKS INCORPORATED (COUNTER)
#   VHFCNT, NO OF VHF RANGING MARKS INCORPORATED (COUNTER)
#   V06N49, EXCESSIVE UPDATE PARAMETERS-DELTA R AND DELTA V
#
# FLAGS SET + RESET
#   SOURCFLG, VINTFLAG, DIM0FLAG, INCORFLG, ORBWFLAG, RENDWFLG
#   STATEFLG, D6OR9FLG, SKIPVHF, DMENFLG				 AT THE INTERRUPTED DISPLAY.

		SETLOC	P20S3
		BANK
		
		COUNT*	$$/R22
R22		CAF	PRIO26
		TS	PHSPRDT2
		TC	PRIOCHNG
		CA	NEG3
		TS	MRKBUF1
		TC	INTPRET
## Page 578
		RTB
			LOADTIME
		STORE	VHFTIME		# PRESENT TIME
REND1		CALL
			GRP2PC
		CALL	
			WAITONE
REND1A		EXIT
		CA	MRKBUF1
		EXTEND
		BZF	REND2
		EXTEND
		BZMF	REND3A
REND2		CAF	SIX
		TC	GENTRAN
		ADRES	MRKBUF1
		ADRES	MARKTIME	# MARKTIME MUST BE CONTIGUOUS WITH VTEMP
		CAF	NEG3		# NEG VALUE TO INDICATE VALUES USED
		TS	MRKBUF1
		TC	UPFLAG		# SET FLAG TO INDICATE THAT OPTICS MARK IS
		ADRES	R22CAFLG	#   BEING PROCESSED (TESTED IN MARK REJCT)
		TC	INTPRET
		CLEAR	CALL
			SOURCFLG	# 0 = OPTICS DATA
			GRP2PC
		GOTO
			REND4
REND3A		TC	INTPRET
REND3		CALL
			GRP2PC
		CALL	
			WAITONE
		BOFF	BOFF
			VHFRFLAG
			REND1A
			RANGFLAG	# RANGE > 200 N.M. DONT READ
			REND1A
		RTB
			LOADTIME	# PRESENT TIME
		DSU	DSU
			60SECDP		# 1 MIN
			VHFTIME		# LAST READING OF RADAR
		BMN	EXIT
			REND1A
RANGER0		INHINT			# READ RADAR RANGE
		CS	OCT17
		EXTEND
		WAND	CHAN13		# ZERO OUT BITS 1-4 OF CHANNEL 13
RADSTART	EXTEND
		READ	LOSCALAR	# READ PRESENT TIME
## Page 579
		TS	L
		
		MASK	LOW5		# ONLY THE 5 BITS MATTER
		COM
		AD	BIT6		# COMPUTE DELTA TIME TO NEXT T5 TICK
		MASK	LOW5
		
		TS	RADDEL
		AD	NEG2		# IF A TICK OF T5 IS NEAR, WAIT TILL IT
		EXTEND			# HAS TICKED.  MAX DELAY HERE IS
		BZMF	RADSTART	# 937.5 MICROSEC.

		CA	OCT11		# SET RADAD BITS NOW
		EXTEND
		WOR	CHAN13
		CS	L
		TS	RADTIME		# SAVE NEG TIME OF READ
		
		RELINT
		EXTEND
		DCA	TIME2
		DXCH	MARKTIME	# READ PRESENT TIME
		TC	DOWNFLAG
		ADRES	SKIPVHF		# CLEAR VHF RESTART FLAG
		TC	ENDOFJOB	# WAIT FOR RADAR READ
RANGERD1	TC	TRFAILOF	# TURN TRACKER LIGHT OFF
		CCS	RM		# 15 BIT UNSIGNED RANGE
		TC	RANGERD4	# GR + 0
		TC	LIGHTON +4	# =  + 0
		TC	RANGERD3	# L  - 0
		TC	RANGERD3	# =  - 0
RANGERD4	TC	INTPRET
		SLOAD	DMP
			RM
			CONVRNGE	# CONVERT RANGE TO METERS B-27
RANGERD2	STORE	VHFRANGE
		SET	DLOAD
			SOURCFLG	# SOURCE OF DATA TO VHF RADAR
			MARKTIME
		STORE	VHFTIME		# FOR DOWNLINK
REND4		CALL
			UPSTATE		# INTEGRATE CSM,LM,W MATRIX
		CALL
			SHIFTNDX	# SET EARTH MOON SCALING INDEX
		CLEAR	CALL
			ORBWFLAG	# CLEAR FOR P22 AND P23
			CMPOS		# SET CSM POSITION
		SET	CALL
			INCORFLG	# SET FOR FIRST PASS
			LMPOS		# SET LM POSITION
## Page 580
		BON
			AUTOSEQ
			AUTOW		# AUTOMATIC W MATRIX REINITIALIZATION
REND5B		BON
			RENDWFLG
			REND6
REND5C		DLOAD
			ZEROVECS
		STODL	VHFCNT		# ZERO OUT VHFCNT AND TRKMKCNT
			WRENDPOS
		STCALL	0		# 0=WRENDPOS  1=WRENDVEL
			INITIALW	# INITIALIZE W MATRIX
		CLEAR	DLOAD
			P35FLAG
			MARKTIME
		STORE	AGEOFW
		CLEAR	SSP
			PTV93FLG
			COUNT3MK
			1
REND6		SET
			RENDWFLG
REND7		VLOAD	VSU
			LEMPOS
			CSMPOS
		STORE	RCLP		# LM - CSM
		UNIT	BON
			SOURCFLG
			REND14		# BRANCH IF DATA IS RADAR
		STORE	UCL
		BOFF	AXC,1
			INCORFLG
			REND9
			MARKTIME
		CALL
			GETUM		# CALCULATE UM LINE OF SIGHT
		STOVL	UM
			UCL
		VXV	BOV
			UM		# UCL X UM
			REND8
REND8		UNIT	BOV
			RENDISP3	# IGNORE MARK RESET FLAGS FOR REJECT
		STORE	USTAR
REND9		CALL
			BVECTORS
		BON	VLOAD
			VEHUPFLG
			REND9A
			BVECTOR
## Page 581
		VCOMP
		STORE	BVECTOR
REND9A		CALL
			GRP2PC
		BOFF
			R21MARK
			REND15		# BRANCH IF BACKUP OPTICS (R23 WORKING)
		DLOAD	DAD
			SXTVAR
			IMUVAR
REND10		STOVL	VARIANCE	# TEMP STORAGE FOR VARIANCE CALC.
			RCLP
		ABVAL	NORM
			X1
		DSQ	DMP
			VARIANCE
		XAD,1	CALL
			X1
			SHIFTNDX	# GET EARTH MOON SCALING INDEX
		XAD,1	XAD,1
			X2
			X2
		SR*	TLOAD
			0 -2,1		# ADJUST SCALING TO B-40
			MPAC
		STORE	VARIANCE
		SLOAD	SR
			INTVAR		# INTEGRATION VARIANCE SCALED B-15
			25D		# SCALE IT B-40
		TAD	RTB
			VARIANCE
			TPMODE
		STORE	VARIANCE
		BOFF	TAD
			SOURCFLG	# BRANCH IF NOT VHF RADAR
			REND10A
			RVARMIN		# VHF RADAR MIN. VARIANCE
		BPL	TLOAD
			REND10A
			RVARMIN
		ABS			# MIN. VALUE WAS STORED AS NEG.
		STORE	VARIANCE	# STORE MIN. VALUE
REND10A		CLEAR	CALL
			DMENFLG		# CLEAR FOR 6 X 6 W MATRIX
			INCORP1		# CALCULATE UPDATE
		CALL
			GRP2PC
		BOFF	CALL
			INCORFLG
			REND12
## Page 582
			SHIFTNDX	# GET EARTH MOON SCALING INDEX
		VLOAD	ABVAL
			DELTAX +6
		SR*
			0,2
		STOVL	N49DISP +2
			DELTAX
		ABVAL	SR*
			0,2
		STORE	N49DISP
		SSP	BON
			N49DISP +4
		OCT	2
			SOURCFLG
			REND10B		# VHF MARK CODE
		BON	SSP
			REJCTFLG
			RENDISP3
			N49DISP +4	# OPTICS MARK CODE
		OCT	1
REND10B		SLOAD
			RMAX
		SR	DSU
			10D
			N49DISP
		BMN	SLOAD
			RENDISP		# BRANCH IF POS UP.GREATER THAN MAX.
			VMAX
		DSU	BMN
			N49DISP +2
			RENDISP		# BRANCH IF VEL.UPDATE GREATER THAN MAX.
REND12		CALL
			INCORP2		# INCORPORATE UPDATE VALUES INTO STATE VEC
		BOFF	DLOAD
			INCORFLG
			REND12A		# BRANCH IF 1ST PASS OPTICS
			MARKTIME
		STORE	OLDMKTME	# SAVE OLD MARK TIME
		CLEAR	SLOAD
			MANEUFLG	# CLEAR MANEUVER FLAG
			COUNT3MK
		BZE	DSU
			REND12A
			HIGH3		# CHECK IF 3 MARKS TAKEN
		BMN	SSP
			REND13A		# BRANCH IF NOT 3 YET
			COUNT3MK	# SET COUNT EQUAL TO 0
		DEC	0
REND12A		BON	BOFF
			SOURCFLG
## Page 583
			REND16		# BRANCH IF DATA IS RADAR
			INCORFLG
			REND17
		CALL
			SHIFTNDX	# GET EARTH MOON SCALING INDEX
		BON	CALL
			VEHUPFLG
			REND18		# BRANCH IF CSM UPDATE
			LMPOS		# GET LM POSITION
REND13		CALL
			GRP2PC		# PHASE CHANGE
		CLRGO
			INCORFLG
			REND7		# BRANCH FOR 2ND PASS THIS OPTICS MARK
REND13A		SLOAD
			COUNT3MK
		STCALL	CNT3TEMP
			GRP2PC		# PHASE CHANGE
		LXA,1	INCR,1
			CNT3TEMP
		DEC	1		# ADD ONE TO MARK COUNT
		SXA,1	GOTO
			COUNT3MK
			REND12A
		SETLOC	P20S1
		BANK
		
		COUNT*	$$/R22
UPSTATE		STQ	CALL		# INTEGRATE NON-UPDATED VEHICLE STATE
			POINTEX		#   VECTOR
			SETINTG		# SET INTEGRV FLAGS   VINTFLAG=1 FOR CSM
		BOFF	CLEAR
			VEHUPFLG	# 0=LM 1=CSM FOR UPDATE VEHICLE
			REND4A		# INTEGRATE CSM
			VINTFLAG	# INTEGRATE LM
REND4A		CALL
			INTEGRV
		CALL
			GRP2PC		# PHASE CHANGE
		CALL			# INTEGRATE UPDATED VEHICLE
			SETINTG		# SET INTEGRV FLAGS   VINTFLAG=1 FOR CSM
		BOFF	SET
			RENDWFLG
			REND5		# IF FLAG=0 DO NOT INTEGRATE W MATRIX
			DIM0FLAG	# INTEGRATE VALID W MATRIX
REND5		BON	CLEAR
			VEHUPFLG
			REND5A		# INTEGRATE CSM
			VINTFLAG	# INTEGRATE LM
REND5A		CALL
## Page 584
			INTEGRV
		GOTO
			POINTEX
		SETLOC	P20S3
		BANK

		COUNT*	$$/R22
REND14		STOVL	BVECTOR		# VHF RADAR BVECTOR
			ZEROVECS
		STORE	BVECTOR +6
		STOVL	BVECTOR +12D
			RCLP
		UNIT	DLOAD
			VHFRANGE	# VHFRANGE SCALED B-27
		BON	SR2
			MOONTHIS
			+1
		DSU	SET
			36D		# ABVAL (RCLP)
			INCORFLG
		STORE	DELTAQ
		BOFF	VLOAD
			VEHUPFLG
			REND14A
			BVECTOR
		VCOMP
		STORE	BVECTOR
REND14A		CALL
			GRP2PC
		DLOAD	GOTO
			RVAR
			REND10
REND15		SLOAD	DAD		# GET ALT LOS VARIANCE
			ALTVAR		# BACKUP OPTICS
			IMUVAR		# IMU VARIANCE
		GOTO
			REND10
REND16		LXA,1	INCR,1
			VHFCNT		# VHF RADAR UPDATE COUNT
		DEC	1
		SXA,1	GOTO
			VHFCNT		# UPDATE COUNT
			RENDISP3
REND17		LXA,1	INCR,1
			TRKMKCNT	# OPTICS MARK COUNT
		DEC	1
		SXA,1	GOTO
			TRKMKCNT	# UPDATE COUNT
			RENDISP3
REND18		CALL
## Page 585
			CMPOS		# GET CSM POSITION
		GOTO
			REND13
		SETLOC	P20S3
		BANK
		
		COUNT*	$$/R22
CMPOS		VLOAD	VSR*
			DELTACSM
			7,2
		VAD
			RCVCSM
		STORE	CSMPOS		# CSM POSITION SCALED B-27 OR B-29
		RVQ
LMPOS		VLOAD	VSR*
			DELTALEM
			7,2
		VAD
			RCVLEM
		STORE	LEMPOS		# LM POSITION SCALED B-27 OR B-29
		RVQ
		SETLOC	P20S3
		BANK
		
		COUNT*	$$/R22
RENDISP		EXIT
		CAF	ZERO		# SET TEMPOR1 > ZERO TO INDICATE
		TS	TEMPOR1		# V06 N49 DISPLAY HASNT BEEN ANSWERED
		TC	PHASCHNG
		OCT	04022
		CAF	PRIO27		# SET UP DISPLAY JOB WITH HIGHER PRIORITY
		TC	NOVAC
		EBANK=	MRKBUF1		# THAN PRESENT JOB
		2CADR	RENDISP2

RENDISP7	TC	INTPRET
		STORE	MPAC
		SLOAD	BZE
			TEMPOR1
			RENDISP7 +1	# DISPLAY HAS NOT BEEN ANSWERED YET
		BMN	GOTO
			REND12		# NEG INDICATES PROCEED
			RENDISP3	# POS INDICATES RECYCLE
RENDISP2	CAF	V06N49
		TC	BANKCALL
		CADR	PRIODSP
		TC	GOTOV56		# TERM EXIT P20 VIA V56
		CS	ONE		# NEG INDICATES PROCEED RENDISP7 JOB
		TS	TEMPOR1		# POS INDICATES RECYCLE RENDISP7 JOB
		TC	ENDOFJOB	# GO COMPLETE ABOVE JOB
## Page 586
RENDISP3	CALL
			GRP2PC
		CLEAR	CLEAR		# RESET FLAGS
			R22CAFLG
			REJCTFLG
		BON	GOTO
			SOURCFLG
			REND1		# DATA WAS RADAR GO LOOK FOR OPTICS NEXT
			REND3
		SETLOC	P20S2
		BANK
		
		COUNT*	$$/R22
		
AUTOW		BON	SLOAD
			MANEUFLG	# MANEUVER DONE IF SET
			AUTOW3
			COUNT3MK	# COUNT OF MARKS SINCE W REINITIALIZED
		BZE	GOTO
			AUTOW1A
			AUTOW2
AUTOW1A		BOFF
			TPIMNFLG	# NOT AFTER TPI
			AUTOW1		# NOT AFTER TPI
		BOFF	GOTO
			P35FLAG
			AUTOW2
			REND5C
AUTOW1		SETPD	DLOAD		# PUT TIG
			0		#	 OR
			TIG		#	   TCDH IF P. C.
		BOFF	DLOAD
			PCFLAG		#		   PUSH LIST 0
			AUTOW11
			TCDH
AUTOW11		PUSH	SLOAD		# PD 0,1 = TIG OR TCDH IF P C
			WRDTIME
		PUSH	SLOAD		# PD 2,3 = WRDTIME
			MINBLKTM
		PUSH	SLOAD		# PD 4,5 = MINBLKTM
			TBEFCOMP
		PUSH	SLOAD		# PD 6,7 = TBEFCOMP
			BRNBLKTM
		PUSH	SLOAD		# PD 8,9 = BRNBLKTM
			MAXWTIME
		PUSH	SLOAD		# PD 10,11 == MAXWTIME
			FINCMPTM
		PUSH	DLOAD		# PD 12,13 = FINCMPTM
			MARKTIME
		DSU	DSU
			2		# WRDTIME
## Page 587
			AGEOFW
		BMN	DLOAD
			AUTOW2		# AGEOFW GR WRDTIME
			OLDMKTME
		DSU	DAD
			MARKTIME	# MARK TIME
			4		# MINBLKTM
		BMN	DLOAD
			AUTOW4		# (TIME - OLDMKTME) GR MIN
			MARKTIME
		DSU	BPL
			0D		# TIG
			AUTOW5		# REINITIALIZE - TIG IS IN THE PAST
		DAD
			12D		# FINCMPTM
		DAD	BMN
			6D		# TBEFCOMP
			AUTOW5		# (FINCMPTM - TIME) GR TBEFCOMP
		DLOAD	DAD
			0
			3MINCON		# 3 MIN CONSTANT (APPROX)
		DSU	DAD
			12D		# FINCMPTM
			8D		# BRNBLKTM
		DSU	DSU
			AGEOFW
			10D		# MAXWTIME
		BMN	SET
			AUTOW2		# FINCOM + BRNBLK+3MIN+AGE GR MAXWTIME
			PTV93FLG	# POST BURN V93 REQUEST FLAG
AUTOW2		CLEAR	GOTO
			ORBWFLAG	# P22 W MATRIX FLAG
			REND5B
3MINCON		DEC	1.0 B-14	# 2.74 MIN
HIGH2		2DEC	2.0 B-14
HIGH3		2DEC	3.0 B-14

		SETLOC	P20S5
		BANK
		
		COUNT*	$$/R22
AUTOW3		BON	BOFF
			PTV93FLG
			REND5C
			TPIMNFLG
			AUTOW4
		BOFF
			FULTKFLG
			REND5C		# BRANCH IF VHF AND OPTICS MARKING
## Page 588
AUTOW4		SSP	GOTO
			COUNT3MK	# SET 3 MARK COUNTER EQ 1
		DEC	1
			AUTOW2		# BYPASS REINITIALIZING W MATRIX
AUTOW5		CLEAR	GOTO
			PTV93FLG
			REND5C

		SETLOC	R22S1
		BANK
		
		COUNT*	$$/R22
SXTVAR		2DEC	0.04 E-6 B+16	# SXT ERROR VARIANCE = .04 (MR)SQ
IMUVAR		2DEC	0.04 E-6 B+16	# IMU ERROR VARIANCE = .04 (MR)SQ
SETINTG		STQ	CALL
			EGRESS
			INTSTALL	# RESERVE INTEGRATION
		DLOAD	SET
			MARKTIME
			STATEFLG
		STORE	TDEC1		# MARKTIME
		CLEAR	CLEAR
			INTYPFLG	# PRECISION INTEGRATION
			DIM0FLAG
		SET	CLRGO
			VINTFLAG	# SET VEHICLE EQ. CSM
			D6OR9FLG	# SET W MATRIX DIM. EQ 6
			EGRESS		# EXIT
CONTCHK		BOFF	BOFF
			RNDVZFLG
			ENDPLAC
			
			REFSMFLG	# BRANCH TO END OF JOB IF REFSMMAT NO GOOD
			ENDPLAC
		SLOAD	BMN
			R61CNTR
			WAITONE1
		BON	BOFF		# IS TRACK FLAG SET
			UPDATFLG
			POINTEX
			TRACKFLG
			ENDPLAC
		EXIT
REDOR22		TC	PHASCHNG
		OCT	00132
2P13SPT1	=	2.13SPOT
		CAF	PRIO26
		TC	PRIOCHNG
## Page 589
		TCF	WAITONE1 +1

WAITONE		STQ
			POINTEX
WAITONE1	EXIT
 +1		CAF	4SECS		# WAIT 4 SECS.
		TC	BANKCALL
		CADR	DELAYJOB
		TC	INTPRET
		GOTO
			CONTCHK		# CHECK AGAIN NOW
		SETLOC	P20S3
		BANK
		
		COUNT*	$$/R22
RANGERD3	CA	RM
		MASK	POSMAX
		TS	MPAC		# MASK OUT NEG. SIGN BIT
		TC	INTPRET
		SLOAD	DMP
			MPAC		# CLEAR MPAC +1
			CONVRNGE	# CONVERT FROM NM TO METERS AND SCALE B-27
		DAD	GOTO
			CONVRNGE	# VALUE IN METERS OF SIGN BIT SCALED B-27
			RANGERD2
LIGHTON		CA	VHFRANGE
		EXTEND
		BZF	+2
		TC	TRFAILON
 +4		TC	INTPRET
		DLOAD
			MARKTIME
		STORE	VHFTIME
		GOTO
			REND1
OCT17		EQUALS	LOW4
		SETLOC	R22S1
		BANK
		
		COUNT*	$$/R22
CONVRNGE	2DEC	18.52 B-13	# VHF INPUT RANGE CONV.FROM.01 NM TO M
#				AND 16384 X 18.52 = METERS FOR SIGN BIT
VHFREAD		EXTEND
		ROR	SUPERBNK	# MUST SAVE SBANK BECAUSE OF RUPT
		TS	BANKRUPT	# EXITS VIA RESUME, LIGHTON, RANGERD1
		EXTEND	
		QXCH	QRUPT
		CS	FLAGWRD2
		MASK	SKIPVBIT	# SKIPVHF FLAG
## Page 590
		EXTEND
		BZF	RESUME		# BRANCH IF VHF RESTART BIT SET
		CAF	UPDATBIT
		MASK	FLAGWRD1	# UPDATEFLG
		EXTEND
		BZF	BYPASS1
		CS	FLAGWRD4
		MASK	PDSPFBIT	# PDSPFLAG
		EXTEND
		BZF	BYPASS1
		CA	RNRAD
		TS	RM		# SAVE RANGE
		CAF	BIT2
		EXTEND
		RAND	CHAN33		# READ DATA GOOD BIT
		EXTEND
		BZF	VHFGOOD		# BRANCH IF DATA GOOD BIT EQUALS GOOD
BYPASS		TS	VHFRANGE	# STORE NON ZERO VALUE
		CAF	PRIO26
		TC	FINDVAC
		EBANK=	MRKBUF1
		2CADR	LIGHTON

		TC	RESUME
		
BYPASS1		CAF	ZERO
		TC	BYPASS		
VHFGOOD		CAF	PRIO26
		TC	FINDVAC
		EBANK=	MRKBUF1
		2CADR	RANGERD1
		
		TC	RESUME
		
SHIFTNDX	AXT,2
			0
		BON	RVQ
			CMOONFLG	# MOON ORB.
			+1
		INCR,2	RVQ
		DEC	-2
INITIALW	AXT,1	SSP
			36D
			S1
			6
		VLOAD
			ZEROVECS
INITA		STORE	W +36D,1	# CLEAR 0 - 35
		STORE	W +90D,1	# CLEAR 54-89
		TIX,1	SLOAD
## Page 591
			INITA
			0		# POSITION VALUE
		STORE	W		# INITIALIZE DIAGONAL W  POSITION
		STORE	W +8D
		STORE	W +16D
		SLOAD
			1		# VELOCITY VALUE
		STORE	W +72D		# INITIALIZE DIAGONAL W VELOCITY
		STORE	W +80D
		STORE	W +88D
		RVQ

## Page 592

#	STALL ROUTINE FOR USERS OF CHANNEL 13.


		SETLOC	FFTAG12
		BANK
		
		COUNT*	$$/CHN13
C13STALL	CAF	PRIO10		# = BANK 04
		XCH	FBANK
		TS	RUPTREG2
		TCF	C13STAL1
		SETLOC	C13BANK
		BANK
		
		COUNT*	$$/CHN13
C13STAL1	CAF	BIT4
		EXTEND
		RAND	CHAN13
		EXTEND
		BZF	TCQSTAL		# NO RADAR ACTIVITY. OK TO WRITE.
		
C13SLOOP	NOOP			# TO PREVENT TC TRAP
		EXTEND
		READ	LOSCALAR
		AD	RADTIME		# COMPUTE DELTA T SINCE LAST RADAR READ
		AD	HALF
		AD	HALF		# FOR OVERFLOW
		XCH	L
		
		CA	90MSCALR
		AD	RADDEL
		EXTEND
		SU	L
		
		EXTEND
		BZMF	TCQSTAL		# GR THAN 90 MS.  OK
		
		AD	-DTSCALR
		EXTEND
		BZMF	C13SLOOP	# IN FORBIDDEN PERIOD.  LOOP UNTIL OK
		
TCQSTAL		CA	RUPTREG2
		LXCH	Q
		DTCF
		
90MSCALR	OCT	440		# 90 MILLISEC IN SCALAR
-DTSCALR	OCT	77754		# -5.9375 MS IN SCALAR

# CRS61.1	R/10/68
#   TO COMPUTE THE PREFERRED TRACKING ATTITUDE OF THE CSM WHICH ENABLES
## Page 593
# OPTICS TRACKING OF THE LM AND LM TRACKING OF THE CSM RADAR TRANSPONDER
# AND TO COMPUTE THE &X-AXIS TRACKING ATTITUDE OF THE CSM WHICH ENABLES
# COAS TRACKING OF THE LM.
#   TO PERFORM THE MANEUVER TO THE SELECTED TRACKING ATTITUDE IF THE 
# MANEUVER IS LESS THAN 10 DEGREES BUT TO CALL R60 IF THE MANEUVER IS
# GREATER THAN 10 DEGREES OR IF THE R60FLAG IS SET.
#	   (1) EXTRAPOLATE LM AND CSM STATE VECTORS TO PRESENT TIME USING
#	       CONIC EQUATIONS.
#
#	   (2) CALCULATE LOS FROM CSM TO LM = RL - RC.
#
#	   (3) THE PRERFERRED TRACKING ATTITUDE IS DEFINED AS FOLLOWS:
#	       THE TRACK AXIS (I) IS ALIGNED ALONG THE LOS TO THE LM. THE
#	       TRACK AXIS (I) IS DEFINED AS:
#
#	       UNIT(I)=UNIT(Z  )COS55 &UNIT(X  )SIN55
#		     -       -SC             -SC
#	   (4) COMPUTE DESIRED CDU ANGLES, USING VECPOINT.
#	   (7) FORM DIFFERENCE BETWEEN DESIRED AND ACTUAL CDUS.
#	       IF ANY OF THE THREE ANGLE DIFFERENCES EXCEEDS 10 DEGREES,
#	       GROSS MANEUVER IS REQUIRED. SIGNAL R61 (SET MPAC=1) TO
#	       OPERATE KALCMANU AND EXIT CRS61.1.
#	       IF ALL DIFFERENCES ARE LESS THAN 10 DEGREES, CONTINUE.
#
#	   (8) CALCULATE ORTHOGONAL LOS RATE IN REF COORDS AS
#
#	       OMEGATH = (UNITLOS(B1) X UNITDV(B1))(ABSDV(B7)/ABSLOS(B29))
#	       CONVERSION FACTOR OF 100/2PI (B4) REV CSEC PER RAD SEC IS
#	       APPLIED TO YIELD UNITS OF REVS/SEC. SCALE IS CARRIED AS
#	       B+1+1+7-29+4+1 PLUS RESULTS OF NORMALIZING ABSDV, ABSLOS.
#	       THE EXTRA B+1 RESULTS FROM RESCALING ABSDV B8 AFTER NORM
#	       TO AVOID OVFLOW ON DIVIDE.
#
#	       UNITLOS = UNIT( RL - RC) B1.
#	       UNITDY  = UNIT( VL - VC) B1.
#	       ABSLOS  = LENGTH OF LOS, METERS B29.
#	       ABSDV   = LENGTH OF DV , METERS/CSEC B7.
#
#	   (9) OBTAIN RATE IN SM COORDS.
#
#	       OMETATHSM = (REFSMMAT)(OMEGATH).
#
#	   (10)OBTAIN GIMBAL ANGLE INCREMETNS FOR 0.1 SECOND.
#
#	       DTHETASM = (0.1)(OMEGATHSM)
#
#	   (11)OBTAIN DELCDUX,Y,Z USING SUBR SMCDURES.
#	       INPUT CONSISTS OF
#
#	       (A) VECTOR OF ANGULAR INCREMENTS, DTHETASM, STORED
## Page 594
#		   IN V(DTHETASM).
#
#	       (B) SIN,COS CDUX,Y,Z FROM  SUBR CDUTRIG.
#
#	       TRANSFER OUTPUT OF SMCDURES FROM V(DCDU) TO VAC14D.
#
#	   (12)CALCULATE ANG LOS RATE IN BODY(NB) COORDS USING SUBR SMNB.
#
#	       OMEGANB = (SMNB)(OMETATHSM)
#
#	       SUBR SMNB REQUIRES  OMEGATHSM IN V(VAC32D) AND ACTUAL CDUS
#	       (Y,X,Z ORDER) IN V(VAC20D) WITH S1 OF VAC = BASE ADDRESS
#	       OF CDUS (FIXLOC + 20D).
#
#	   (13)CALCULATE ANG LOS RATE IN CONTROL COORDS AS FOLLOWS
#
#	       WBODY = (MBDYTCTL)(OMEGANB)   UNITS=REVS/SEC(B0).
#
#			      ( 0.5       0             0      ) BODY TO
#	       MBDYTCTL(B1) = (  0   COS(7.25)B1  -SIN(7.25)B1 )=CONTROL
#			      (  0   SIN(7.25)B1   COS(7.25)B1 ) AXES
#								CONVERSION
#								 MATRIX
#
#	   (14)RESCALE WBODY TO UNITS OF 450 DEG/SEC BY APPLYING FACTOR
#	       OF 0.8 TO REVS/SEC.
#
#	   (15)ADDRESS LIVE AUTOPILOT REGISTERS IN BASIC (UNDER INHINT).
#
#	       TRANSFER DESIRED CDUS, SCALED 180 DEGREES, FROM T(SAVEDCDU)
#	       TO V(CDUXD).
#	       TRANSFER DELCDUS, SCALED 180 DEG, FROM V(VAC14D)
#	       TO V(DELCDUX).
#	       TRANSFER OMEGA CONTROL, SCALED 450 DEG/SEC, FROM V(MPAC)
#	       TO V(WBODY).
#	       RELINT, SET MPAC=0, EXIT CRS61.1
#
# CALL:	   L  CALL CRS61.1
#
# RETURNS  ALL TO L+1.
#
#	   (1) S(MPAC)=0. NORMAL EXIT. 3 SETS OF INPUTS FED TO DAP.
#	   (2) S(MPAC)=1. CALCULATED DESIRED CDUS,SP, SET IN T(CPHI)
#	       FOR KALCMANU. ABS(ACDU - DCDU) EXCEEDS 10 DEGREES.
#	   (3) S(MPAC)=2. GNCS AUTO MODE NOT SELECTED (BIT10=1).
#	   (4) S(MPAC)=3. DAP HOLD FLAG (HOLDFLAG) NOT EQUAL -1.
#
# INPUT	   (1) TIME2,TIME1. COMPUTER CLOCK TIME,DP, CENTISEC B28.
#	   (2) CDUX,Y,Z. PRESENT CDU ANGLES,SP,2S COMPL HALF-REVS B0.
#	   (3) M(REFSMMAT),STABLE MEMBER COORDS B1.
## Page 595
#
# OUTPUT   NORMAL. EXIT WITH S(MPAC) = 0.
#
#	   (1) CDUXD,CDUYD,CDUZD, DESIRED OUTER, INNER, MIDDLE CDU ANGLES,
#	       DP, 1S COMPL, SCALED 180 DEGREES (HALF-REVS B0).
#	   (2) DELCDUX,DELCDUY,DELCDUZ. 0.1 SEC DCU ANGULAR INCREMENTS,
#	       DP, 1S COMPL, SCALED 180 DEG.
#	   (3) WBODY,WBODY1,WBODY2. LOS ANGULAR RATE IN CONTROL COORDS,
#	       DP, 1S COMPL, SCALED 450 DEG/SEC.
#
#	       SPECIAL. EXIT WITH S(MPAC) = 1.
#
#	   (1) CPHI,CTHETA,CPSI. DESIRED OUTER, INNER, MIDDLE CDU ANGLES,
#	       SP, 2S COMPL, SCALED 180 DEGREES.
#
# EXTERNAL SUBROUTINES USED   (B)=BASIC
#
#	   (1) CALCGA    (5) LOADTIME(B)  (9) SMNB
#	   (2) CDUTRIG   (6) MATMOVE
#	   (3) CSMCONIC  (7) RCDUS(B)
#	   (4) LEMCONIC  (8) SMCDURES
#
# ERASABLE (1) S(Q611),EBANK7  CRS61.1 EXIT .
#	   (2) S(Q6111)EBANK7  CALCDCDU EXIT.
#	   (3) T(SAVEDCDU) E6  SP VECTOR OF CDUDS.
#	   (4) V(SAVEPOS)  E7  CSM POS VEC AND  D(SAVEPOS)= LENGTH OF LOS.
#	   (5) V(SAVEVEL) E7  CSM VEL VEC.
#
# FLAGWDS  HOLDFLAG. USED, NOT SET.
#
# MISC     (1) ERASABLE ITEMP1 USED TO TEMP STORE EBANK UNDER INHINT.
#          (2) ERASABLE P21TIME USED AS TEMP STORE DURING CRS61.1
#          (3) ERAS DTHETASM USED AS TEMP STORE DURING EARLY CRS61.1
#
# DEBRIS - CURRENT VAC AREA, CRS61.1 ERASABLES, ITEMP1, P21TIME

		SETLOC	P20S4
		BANK
		
		EBANK=	CDUXD
		COUNT*	$$/CRS61
		
CRS61.1		STQ	SETPD
			Q611
			0
		RTB
			LOADTIME	# LOAD CLOCK TIME2,1 INTO MPAC.
			
STORT		STCALL	R63TIME		# STORE CLOCK TIME FOR SUBR R63
			R63		# SUBR TO CALC DCDU(T=PRESENT,PASS1)
		CLEAR	DLOAD
## Page 596
			RANGFLAG
			R63TIME
		DSU	BPL
			328NM
			+3
		SET
			RANGFLAG
 +3		EXIT
STEP2CK		TC	CHECKMM		# CHECK MAJOR MODE = 27 (UPDATE PROG)
		MM	27
		TC	UPACTOFF	# NO TURN OFF UPLINK LITE
					# YES  LEAVE UPLINK AS IS
		CCS	HOLDFLAG
		TC	ASET		# EXIT IF HOLDFLAG IS + NONZERO
		TC	+2
		TC	+1
		CS	FLGWRD11
		MASK	AZIMBIT
		CCS	A
		TC	NOAZFLG1	# AZIMFLAG NOT SET
		
		CAF	TWO		# AZIMFLAG SET
CDULOOP		TS	DTHETASM
		INDEX	DTHETASM
		CA	CDUX
		EXTEND
		INDEX	DTHETASM
		MSU	THETAD
		TS	MPAC
		
		TC	INTPRET
		ABS	DSU
			DEGREE10
		BPL	EXIT
			STKTEST
		
		CCS	DTHETASM
		TC	CDULOOP
		
		TC	AUTOCK

NOAZFLG1	CA	THETADX
		TS	CDUSPOT +4
		CA	THETADY
		TS	CDUSPOT
		CA	THETADZ
		TS	CDUSPOT +2	# STORE IN CDUSPOT FOR TRG*NBSM
		TC	INTPRET
		VLOAD	CALL
			SCAXIS
## Page 597
			TRG*NBSM
		PUSH	DOT		# PD 0-5
			POINTVSM
		DSU	BMN		# BRANCH IF GR. 10 DEG.
			COSTEN
			STKTEST
		VLOAD	VXV
			0		# SCAXIS IN S.M.
			POINTVSM
		VXSC	PUSH		# PD 6-11 B2
			DELTYME		# 1/(DELTA TIME) B-2
		ABVAL	DSU
			MAXRATE		# .1 DEG. / SEC. B0
		BMN	VLOAD		# PUSH UP 6-11
			STEP2CKB	# BRANCH IF LESS .1 DEG./SEC.
		UNIT	VXSC
			MAXRATE
		VSL1	PUSH		# PD 6-11 .1 DEG./SEC DISTRIBUTED
STEP2CKB	VLOAD	VXSC
			6
			RADTOREV	# RAD. TO REV. B0
		STORE	DTHETASM	# B0
		EXIT
AUTOCK		CAF	FURST3		# BITS 15,14,13 OF CHAN31 = 011
		TC	C31BTCHK	# FOR AUTO AND G&N CONTROL
		TCF	+1
		AD	NEG30000
		EXTEND			# AUTO MODE SELECTED (BITS 15-13=011)
		BZF	DAPCK		#    YES-CONTINUE.
		TC	ASET
DAPCK		CS	FLAGWRD1	# IS STIKFLAG SET (I.E. IS SOMEONE ON RHC)
		MASK	STIKBIT
		CCS	A
		TC	STEP3CK
ASET		TC	INTPRET
		CLEAR
			CYC61FLG
		SLOAD	GOTO
			ZEROVECS
			Q611
STKTEST		BOFINV
			CYC61FLG
			KALCMAN3 +1
		BON	EXIT
			V50N18FL
			MANUEXIT
		CAF	BIT3
		EXTEND			# STIKFLG IS SET
		WOR	DSALMOUT	# TURN ON UPACTY LIGHT
## Page 598
		TC	ASET		# EXIT AND SET R61CNTR
STEP3CK		TC	INTPRET
		SETPD	BOFF
			0D
			UTFLAG
			CRS61.2		# NORMAL P-20 (OPTION 0) IF UTFLAG NOT SET
		
		DLOAD	BZE		# OPTION 1,TEST FOR STAR OR PLANET
			R63TIME		# =0 IF STAR
			UTSTAR1
					# USE NORMAL P20 PATH FOR PLANET
					# WITH VL AND RL = 0
					# NOW HAVE DCDUS STORED IN T(SAVEDCDU).
					# GO CALC OTHER DAP INPUTS (DELCDU,WBODY)
CRS61.2		VLOAD	VSU
			DCDU
			SAVEVEL		# DV = VL - VC
		UNIT	VCOMP		# V(MPAC)=-UNITDV.VAC36D=ABSDV.
		VXV	VXSC		# (-UNITDV)CROSS(UNITLOS).
			SAVEPOS
			RVCS/RDS	# (UNITLOS B1)(UNITDV B1)(CONST B4)=CROSS.
		PDDL	NORM
			R63TIME		# R63TIME IS TEMP STORE FOR ABS(LOS)
			X1
		PDDL	NORM
			36D		# NORM ABS VALUE OF DV(NUM).
			S1
		
		XSU,1	SR1		# X1 = X1(N DENOM)-S1(N NUM).
			S1		# SR1 TO AVOID OFLOW ON DDV.
		DDV	VXSC		# ABSDV(MPAC)/ABSLOS(PUSH1) = QUOT.
		MXV	VSL*
			REFSMMAT
			0 -14D,1	# UNNORMALIZE,ADJUST FOR REF. AND SCALE B0
		BON	VAD
			AZIMFLAG
			+2
			DTHETASM	# SCALED B0
		STORE	20D
		VXSC
			TENTH
		STCALL	DTHETASM	# STORE SM INCREM. ANGLES FOR SMCDURES
			CDUTRIG		# OBTAIN SIN,COSCDUS FOR SMCDURES.
		SETPD	CALL		# SMCDURES USES PUSH
			0
			SMCDURES	# OBTAIN DELCDU IN V(DCDU).
		VLOAD	VSR2
			DCDU
		STCALL	14D
			CDUTRIG
## Page 599
		VLOAD	CALL		# LOAD VECTOR AND CALL TRANSFORMATION
			20D		# VECTOR FOR TRG*SMNB INTO MPAC
			*SMNB*		# OBTAIN ANG. RATE REFERRED TO NB (BODY)
		MXV
			MBDYTCTL	# CONVERT RATE(OMEGA) TO CONTROL COORDS.
		VXSC	VSL1		# MULT. BY 0.8 TO RESCALE REVS TO 450 DEG.
			POINT8

CRS61.2A	EXIT
		INHINT
		CS	FLGWRD11
		MASK	AZIMBIT
		CCS	A
		TC	THTDXYZ		# AZIMFLAG NOT SET,USE THETADX,Y,Z
		
		CAF	TWO		# AZIMFLAG SET, MODIFY DELCDUS
DCDULOOP	TS	DTHETASM
		DOUBLE
		AD	FIXLOC
		TS	DTHETASM +1
		INDEX	DTHETASM
		CA	THETAD
		EXTEND
		INDEX	DTHETASM
		MSU	THETADX
		EXTEND
		MP	1/200
		INDEX	DTHETASM +1
		DAS	14D
		CCS	DTHETASM
		TCF	DCDULOOP
THTDXYZ		CA	THETADX
		TS	CDUXD
		CA	THETADY
		TS	CDUYD
		CA	THETADZ
		TS	CDUZD

THTD123		EXTEND			# TRANSFER OMEGA CONTROL (ANG LOS RATE)
		DCA	MPAC		# FROM V(MPAC) TO V(WBODY ).
		DXCH	WBODY
		EXTEND
		DCA	MPAC +3
		DXCH	WBODY1
		EXTEND
		DCA	MPAC +5
		DXCH	WBODY2

		EXTEND			# TRANSFER CDU INCREMENTS
		INDEX	FIXLOC		# FROM V(VAC14D) TO V(DELCDUX).
## Page 600
		DCA	14D
		DXCH	DELCDUX
		EXTEND
		INDEX	FIXLOC
		DCA	16D
		DXCH	DELCDUY
		EXTEND
		INDEX	FIXLOC
		DCA	18D
		DXCH	DELCDUZ
		CS	ONE		# NOW DAP VARIABLES LOADED. SET HOLDFLAG.
		TS	HOLDFLAG	# TO -1.
		RELINT
		TC	ASET

RCYCLR61	RTB	DAD
			LOADTIME
			20.48SEC
		DAD	GOTO
			TM
			STORT
20.48SEC	EQUALS	1RTEB17
1/200		DEC	.005
		SETLOC	P20S8
		BANK
		
		COUNT*	$$/CRS61
328NM		2DEC	606844.84 B-29	# 327.67 N.M.
UTSTAR1		VLOAD			# STAR, N88 PATH SET WCA, DELTA GA = 0
			ZEROVECS
		STCALL	14D		# DELTA GA AT PD1J (INCR GIMB CHANGES)
			CRS61.2A	# WCA IS IN MPAC (LOS RATE). SET RCS DAP

MANUEXIT	SLOAD	GOTO
			LOONE		# OCTAL 00001
			Q611

R63		STQ	DLOAD		# SUBR TO CALL DESIRED CDUS(T)
			Q6111
			R63TIME
		STCALL	TDEC1
			CSMCONIC
		VLOAD			# SAVE CSM POSITION AND VEL
			RATT		# RC B-29
		STOVL	SAVEPOS
			VATT		# VC B-7
		STORE	SAVEVEL
		VXV
			SAVEPOS
## Page 601
		STORE	POINTVSM	# SAVE VXR
		BON	DLOAD
			UTFLAG
			UTAREA1		# UT OPTION 1 PROCESSING
			R63TIME		# NORMAL P-20 PATH
		STCALL	TDEC1
			LEMCONIC
		VLOAD			# SAVE LM VEL
			VATT		# VL B-7
		STOVL	DCDU
			RATT		# RL B-29
		VSU	UNIT
			SAVEPOS
		STODL	SAVEPOS		# SAVE UNITLOS FOR CRS61.2 RATE CALC.
			36D
		STOVL	R63TIME		# SAVE ABS VAL OF LOS FOR CRS61.2
			SAVEPOS
R63COM1		BON
			AZIMFLAG
			UTOPT45		# OPTIONS 4,5
		MXV	VSL1		# COMMON PATH NORMAL P20,OPTION 1
			REFSMMAT
		STCALL	POINTVSM	# ULOS IN STABLE MEM
			UTPRFAX		# COMPUTE UNIT PREFERRED VECTOR
		STCALL	SCAXIS
			VECPOINT
		STORE	THETAD		# DESIRED GIMBALS
		GOTO
			Q6111
		
		SETLOC	P20S
		BANK
		
		COUNT*	$$/CRS61
UTAREA1		DLOAD	CALL		# UT OPTION 1 PATH
			R63TIME
			LSPOS
		STORE	14D		# RM B-29
		BON	VSU
			CMOONFLG
			UTMNCNTR
			SAVEPOS		# RC B-29
		UNIT
		STOVL	SCAXIS		# VMOON = UNIT(RM-RC)
			SAVEPOS
		UNIT	VCOMP
		STOVL	8D		# VEARTH=-UNIT(RC)
			2D		# RS B-38
		UNIT	GOTO
			SAVEVSUN		# VSUN = UNIT(RS)
## Page 602
UTMNCNTR	VAD	UNIT		# MOON PATH
			SAVEPOS
		VCOMP
		STOVL	8D		# VEARTH = -UNIT(RM+RC)
			SAVEPOS
		UNIT	VCOMP
		STOVL	SCAXIS		# VMOON = -UNIT(RC)
			14D		# RM B-29
		VSR8	VSR1		# SCALE RM B-38
		BVSU	UNIT		# VSUN = UNIT(RS-RM)
			2D
SAVEVSUN	STCALL	2D
			SAVESTAR
		
		SETLOC	STARTAB
		BANK
		
		COUNT*	$$/CRS61
SAVESTAR	SETPD	VXV
			0D
			ECLIPOL
		STOVL	VEL/C
			SAVEVEL
		VXSC	VAD
			1/C
			VEL/C
		STOVL	VEL/C
			ZEROVEC
		STOVL	DCDU		# VL=0  FOR STAR AND PLANET
			SAVEPOS
		VCOMP	UNIT
		STODL	SAVEPOS		# UNIT(0-RC))  FOR PLANET
			36D
		STORE	R63TIME		# ABS(O-RC) FOR PLANET
		SLOAD	PUSH		# PD0= STARCODE
			UTSTARNO	# STARCODE
		BZE	SLOAD
			UTVIAN88	# UNITLOS WAS VIA N88
			UTSP46
		BDSU			# STARCODE-46(OCTAL)
		BPL	VLOAD		# BRANCH IF STARCODE=46,47,50 OCTAL
			UTST4650
			ZEROVEC
		STODL	SAVEVEL		# VC=0 FOR STAR
			ZEROVEC
		STORE	R63TIME		# STAR INDICATOR USED LATER IN CRS61.2
		SLOAD	DMP
			UTSP6
			0D		# 0D STILL = STARCODE
		LXA,1	VLOAD*
## Page 603
			MPAC +1		# STARCODE*6
			CATLOG,1	# MPAC= UNIT STAR VECTOR
UTABERR		VAD	UNIT		# CORRECT FOR ABERRATION
			VEL/C
		GOTO			# GOTO COMMON AREA
			R63COM1

UTSP6		OCT	6		# SINGLE PRE 6 FOR MULT STARCODE
UTSP46		OCT	46		# SINGLE PRE 46 FOR DETERMINING PLANET

		SETLOC	P20S8
		BANK
		
		COUNT*	$$/CRS61
UTST4650	BZE	SR1		# SUN,EARTH,MOON  OR PLANET PATH
			UTSUN		# STARCODE=46 OCTAL (SUN)
		BHIZ	VLOAD
			UTEARTH		# STARCODE=47 OCTAL (EARTH)
			SCAXIS		# VMOON     STARCODE= 50 OCTAL
		GOTO
			UTABERR

UTSUN		VLOAD	GOTO
			2D		# VSUN
			UTABERR

UTEARTH		VLOAD	GOTO
			8D		# VEARTH
			UTABERR

UTVIAN88	VLOAD			# UNITLOS IN STARSAV3 VIA N88
			ZEROVECS
		STODL	SAVEVEL		# VC = 0 FOR N88 VECTOR
			ZEROVECS
		STOVL	R63TIME		# STAR INDICATOR USED LATER IN CRS61.2
			PLANVCUT	# N88 UNIT VECTOR BAS REF
		VXSC	UNIT
			1/SQRT3
		GOTO
			UTABERR

1/SQRT3		2DEC	.57735021	# 1/SQUARE ROOT 3  B-0


		SETLOC	P20S
		BANK
		
		COUNT*	$$/CRS61
UT166		EQUALS	.166...
## Page 604
UTSAP		=	0D		# SA PRIME
UTSBP		=	6D		# SB PRIME
UTSA		=	18D		# SA
UTSB		=	24D		# SB
UTUXP		=	0D		# UX PRIME
UTUYP		=	6D		# UY PRIME
UTUZP		=	12D		# UZ PRIME
UTUX		=	18D		# UX
UTUY		=	24D		# UY
UTUZ		=	30D		# UZ
#UTX		=	SCAXIS		# X
#UTY		=	POINTVSM	# Y
UTZ		=	0D		# Z AFTER UNIT
UTZINIT		=	36D		# Z BEFORE UNIT
UTAMG		=	6D		# AMG
UTOGA		=	24D		# OGA REVS B-0
UTIGA		=	UTOGA +2	# IGA REVS B-0
UTMGA		=	UTOGA +4	# MGA REVS B-0

UTOPT45		STCALL	UTSB		# SB= ULOS BASIC REF. IN MPAC B-1
			UTPRFAX
		STORE	UTSBP		# SB PRIME NAV BASE B-1
		
		VXV	UNIT
			UNITY
		STOVL	UTSAP		# SA PRIME=(SB PRIME)X(0,1,0) B-1 NAV B
			UTSB
		VXV	UNIT
			POINTVSM	# VXR   SAVED ABOVE
		STODL	POINTVSM	# ULOS X (VXR) B-1
			AZIMANGL
		COS	VXSC
			POINTVSM
		STOVL	SCAXIS		# B-2
			UTSB
		VXV	UNIT
			POINTVSM
		STODL	POINTVSM	# ULOS X (ULOS X (VXR)) B-1
			AZIMANGL
		SIN	VXSC		# B-2
			POINTVSM
		VAD	VSL1
			SCAXIS
		STOVL	UTSA		# SA B-1
			UTSAP		# 			  START AXISGEN
		VXV	UNIT		# UX PRIME ALREADY IN UTUXP B-1
			UTSBP		# UY       ALREADY IN UTUX  B-1
		STOVL	UTUYP		# UZ PRIME B-1
			UTUXP
		VXV	VSL1
## Page 605
			UTUYP
		STOVL	UTUZP		# UZ PRIME B-1
			UTSA
		VXV	UNIT
			UTSB
		STOVL	UTUY		# UY B-1
			UTUX
		VXV	VSL1
			UTUY
		STOVL	UTUZ		# UZ B-1
			UTUX
		VXSC
			UTUXP
		STCALL	UTX
			UTOPT45A
		
		SETLOC	P20S8
		BANK
		
		COUNT*	$$/CRS61
UTOPT45A	VLOAD
			UTUY
		VXSC	VAD
			UTUYP
			UTX
		STOVL	UTX
			UTUZ
		VXSC	VAD
			UTUZP
			UTX
		STOVL	UTX		# UX NOT UNIT YET
			UTUX
		VXSC
			UTUXP +2
		STOVL	UTY
			UTUY
		VXSC	VAD
			UTUYP +2
			UTY
		STOVL	UTY
			UTUZ
		VXSC	VAD
			UTUZP +2
			UTY
		STOVL	UTY		# UY NOT UNIT YET
			UTUX
		VXSC
			UTUXP +4
		STOVL	UTZINIT
			UTUY
## Page 606
		VXSC	VAD
			UTUYP +4
			UTZINIT
		STOVL	UTZINIT
			UTUZ
		VXSC	VAD
			UTUZP +4
			UTZINIT
		UNIT			# UTUZ AND UTZINIT ARE CLOBBERED BY UNIT
		STOVL	UTZ		# UZ B-1
			UTY
		UNIT
		STOVL	UTY		# UY B-1
			UTX
		UNIT
		STORE	UTX		# UX B-1    END AXISGEN
		VXV	UNIT		# 	    STATR CALCGA
			REFSMMAT +6	# YSM
		STORE	UTAMG		# AMG B-1
		DOT
			UTZ
		STOVL	COSTH		# COS(OGA)= AMG.ZNB B-2
			UTAMG
		DOT
			UTY
		STCALL	SINTH		# SIN(OGA)= AMG.YNB B-2
			ARCTRIG
		STOVL	UTOGA		# OGA REVS B-0
			UTAMG
		VXV	DOT
			UTX
			REFSMMAT +6
		SL1
		STOVL	COSTH		# COS(MGA)= YSM.(AMG X XNB) B-2
			REFSMMAT +6
		DOT
			UTX
		STCALL	SINTH		# SIN(MGS)= YSM.XNB B-2
			ARCTRIG
		STORE	UTMGA		# MGA REVS B-0
		ABS	DSU
			UT166
		BPL
			UTGMLOCK
UTCGA1		VLOAD	DOT
			REFSMMAT +12D
			UTAMG
		STOVL	COSTH		# COS(IGA)= AMG.ZSM B-2
			REFSMMAT
		DOT
## Page 607
			UTAMG
		STCALL	SINTH		# SIN(IGA)= ANG.XSM B-2
			ARCTRIG
		STORE	UTIGA		# IGA REVS B-0
		VLOAD	RTB
			UTOGA		# CONVERT TO 2S COMP
			V1STO2S		# ORDER IS OGA,IGA,MGA
		STORE	THETAD		# TRIPLE PREC
		GOTO
			Q6111		# EXIT R63

UTGMLOCK	EXIT			# GIMBAL LOCK HAS OCCURED
		TC	ALARM
		OCT	00401
		
		TC	INTPRET
		GOTO
			UTCGA1
		
		SETLOC	R22S1
		BANK
		
		COUNT*	$$/CRS61
RADTOREV	2DEC	0.15915494	# RADIANS TO REV
COSTEN		DEC	0.98481 B-2	# COSINE OF 10 DEG.
MAXRATE		2DEC	0.00174		# .1 DEG./SEC. RATE
DELTYME		DEC	0.05 B2		# 1/DELTA TIME  = 1/20 SEC
DEGREE10	DEC	.05556		# 10 DEG IN REV
RVCS/RDS	2DEC	15.915494 B-4	# 100/2PI REV-CSEC/RAD-SEC.
TENTH		2DEC	.1 B+3		# .1 B-3 (TO SCALE ANG.RATE TO .1 INREMS)
MBDYTCTL	2DEC	.5		# 		  7.25 DEG NEGATIVE
		2DEC	0		#		  X-AXIS ROTATION MATRIX
		2DEC	0		#		  CONVERTS BODY TO CTL
		2DEC	0		#		  AXES. SAME AS QUADROT
		2DEC	.99200495 B-1	# COS7.25 B1	 BUT SCALED B1
		2DEC	-.12619897 B-1	# -SIN7.25 B1
		2DEC	0
		2DEC	.12619897 B-1	# SIN7.25 B1
## Page 608
		2DEC	.99200495 B-1	# COS7.25 B1
LOONE		OCT	00001		# TO SET MPAC = 00001 FOR SPECIAL EXIT.
FURST3		EQUALS	13,14,15	# CONSTANT FOR AUTOCK (OCT 70000).

## Page 609

# ..... S22.1 ORBITAL NAVIGATION ROUTINE
# MOD 1
#
# FUNCTONAL DESCRIPTION
#  1. UPDATE CSM STATE VECTOR
#  2. UPDATE LANDMARK POSITION
#  3. CONVERT W MATRIX FROM 9 TO 6 DIMENSIONS
#
# SUBROUTINES CALLED
#  INTSTALL,INTEGRV,GETNUM,SETRE,R-TO-TP,RP-TO-R,BVECTORS,INCORP1,INCORP2
#  LALOTORV,S22F2410,LAT-LONG,ROWDOT
#
# ERASABLE INITIALIZATION
#  W=9X9 MATRIX
#  ORBWFLAG=0 FOR INVALID W MATRIX,=1 FOR VALID W MATRIX
#  ASTRONAUT ENTRY OF KNOWN,L,OFF
#  8NN= NUMBER OF MARKS  DECIMAL INTEGER B-14
#  REFSMMAT= TRANSFORMATION MATRIX
#  MARKSTAT= ADDRESS OF START OF MARK DATA (MARK DATA OF EACH MARK IS
#	     STORED AS FOLLOWS,  TIME,AIG,SA,AMG,PA,AOG) TIME IS IN DOUBLE
#	     PRECISION,ALL OTHERS ARE IN SINGLE PRECISION
#  CSM STATE VECTOR
#
# OUTPUT
#  UPDATED CSM STATE VECTOR
#  UPDATED LANDMARK POSITION
#  NEW 6 DIMENSIONAL W MATRIX
#
# DEBRIS
#  PUSH LIST,CSMPOS,ALPHAV,ERADM,UM,RCLP,USTAR,VARIANCE,X789,BVECTOR,8KK,
#  S22LOC,SVMRKDAT TABLE,22SUBSCL,LANDMARK,CXOFF,S22C,LAT,LOG,ALT,
#  TEMPOR1,S22TOFF,S221OFF,DSPTEM1,S22EORM,S22TPRIM

		SETLOC	P20S6
		BANK
		
		EBANK=	LANDMARK
		COUNT*	$$/P22
S22.1		TC	2PHSCHNG
		OCT	00004
		OCT	05022
		OCT	13000
		TC	INTPRET
		SETPD	CALL
			0D
			SHIFTNDX
FIG2EXIT	SXA,2	CALL
			S22EORM		# SET =0 EARTH,=2 MOON FOR SHIFTING
			SETINTG
#		FLOWCHART D=0   THEN DIM0FLAG=0  D6OR9FLG NOT TESTED
## Page 610
#		FLOWCHART D=6   THEN DIM0FLAG=1  D6OR9FLG=0
#		FLOWCHART D=9   THEN DIM0FLAG=1  D6OR9FLG=1

		BOFF	SETGO
			ORBWFLAG
			SETWW5D		# BRANCH TO SET W0-W5,ORBWFLAG,D
			DIM0FLAG	# FLOWCHART D=6 PATH
			SETVANDI
SETWW5D		CLEAR	DLOAD
			RENDWFLG	# FLOWCHART D=0 PATH
			WORBPOS
		STCALL	0
			INITIALW
SETVANDI	AXT,1	VLOAD
		DEC	18
			ZEROVECS
		SSP
			S1
		DEC	6
NEXTW2W8	STORE	W +54D,1	# CLEAR W2
		STORE	W +108D,1	# 	W5
		STORE	W +126D,1	#	W6
		STORE	W +144D,1	#	W7
		STORE	W +162D,1	# 	W8
		TIX,1	CLEAR
			NEXTW2W8
			DMENFLG		# 0=6X6W, 1=9X9W
S22NXTIN	CALL
			GETTF
		STCALL	TDEC1
			INTEGRV
		LXA,2	CALL
			S22EORM
			CMPOS
		LXC,1	CALL
			S22LOC		# SETUP ADDR. OF MARK DATA FOR GETUM SUBR.
S2GETUM			GETUM
		STORE	UM
DMPINTEG	SLOAD	PUSH		# TEST OFF=I
			8KK
		SLOAD	DSU
			CXOFF		# BEFORE SUBT.
		BHIZ	BON
			S22OFF=I	# BRANCH HERE IF OFF=I
			DMENFLG		# 0=6X6W, 1=9X9W
			S22D=9
		CALL
			GRP2PC
		SET	
			ORBWFLAG
## Page 611
		SET	SET
			DMENFLG		# =0 ON FIRST PASS THRU HERE FOR D=0,OR6
			22DSPFLG	# =1 TO DISPLAY DR,DV ON FIRST PASS
		BON
			KNOWNFLG
			S22BOX22
		VLOAD	UNIT		# UNIT ALSO PUTS ABVAL(RC) IN 36D
			CSMPOS
		STCALL	ALPHAV		# ALPHAV +4=SINL FOR SETRE
			SETRE		# ERADM= R0 METERS B-29 BOTH EARTH/MOON
		CALL			# COMPUTE RL FROM EQUATION 2.4.10
			S22F2410	# STORED IN X789,MPAC  B-27,B-29
		BOFF	VSR2		# SCALE RL B-29 FOR BOTH EARTH/MOON
			CMOONFLG
			+1
		STORE	S22RL
		DOT	SL1
			UM
		STOVL	S22D		# D= UM.RL B-29
			ZEROVECS
		SETPD	PUSH
			0D
		PUSH	PDDL		# SET 0-18D = I BACKWARDS
			HIDPHALF	# PD 18
		SR2			# B-3
		STORE	4D
		STORE	8D
		STOVL	12D
			UM		# B-1
		STOVL	S223X1
			S22RL		# B-29
		CALL			# (UM)(RL T) B-30 STORED IN S22UMRL THRU
			S2231X13	# S22UMRL +17D
		AXT,1	SSP
		DEC	18
			S1
		DEC	6
S22NXTU		VLOAD*	VSR2		# (UM)(RL T) B-32
			S22UMRL +18D,1
		V/SC
			S22D		# D B-29
		BVSU	STADR		# SUBTRACT FROM I B-3
		STORE	S22UMRL +18D,1	# U MATRIX B-3
		TIX,1	AXT,1		# PD 0 AFTER TIX
			S22NXTU
		DEC	36		# S1 STILL 6 FROM ABOVE
S22NXTWI	VLOAD*	MXV
			W +36D,1	# B-19
			S22UMRL		# B-3
		VSL3
## Page 612
		STORE	W +144D,1	# W(I+18)= UW(I) B-19
		TIX,1	DLOAD
			S22NXTWI
			S22RHO		# B-28,B-30
		BOFF	SR2		# MAKE RHO B-30
			CMOONFLG
			+1
		NORM	XAD,2
			X2
			X2
		DSQ	DMP
			SCTVAR		# B+18
		SR1	AXT,1		# ACCOUNTS FOR 1/2 IN NEXT FORMULA
		DEC	18
		STORE	S22RHO		# 1/2(RHO SQ)(VARSCT)
S22NXXA		VLOAD*	MXV
			S22UMRL +18D,1	# B-3
			S22UMRL		# B-3
		VXSC	VSR*
			S22RHO
			0 -12D,2	# WITH VARRP SCALED B-28
		STORE	S22UUT +18D,1	# 1/2(RHO SQ)(VARSCT)(U)(U T)
		TIX,1	VLOAD
			S22NXXA
			UM
		STCALL	S223X1		# UM ALSO IN MPAC FOR S2231X13 SUBR.
			S2231X13	# (UM)(UM T) B-2 IN S22UMRL,P17D
		DLOAD	SR3
			ERADM		# B0 B-29
		DDV	DSQ
			S22D		# B-29
		DMP	AXT,1
			RPVAR		# ***** METERS SQ
		DEC	18
		STORE	S22RHO		# TEMP (VARRP)(R0/D)
S22NXXB		VLOAD*	VXSC
			S22UMRL +18D,1	# (UM)(UM T) B-2
			S22RHO
		VAD*
			S22UUT +18D,1
		STORE	S22UUT +18D,1	# SMALL E MATRIX
		TIX,1	BOV
			S22NXXB
			+1
		DLOAD	BMN
			S22UUT +16D	# E5
			S22W76X
		SQRT	BZE
			S22W76X
		SR1			# B-19
## Page 613
		STODL	W +148D		# W74= SQ ROOT E5
			S22UUT +14D	# E4
		DDV	BOV
			W +148D
			S22W72X
		SR2			# B-19
		STORE	W +146D		# W73= E4/W74
S22W72X		DLOAD	DDV
			S22UUT +12D	# E3
			W +148D
		SR2	BOV		# B-19
			S22W76X
		STORE	W +144D		# W72= E4/W74
S22W76X		DLOAD	DSQ
			W +146D
		SL2	BDSU
			S22UUT +8D	# E2
		BMN	SQRT
			S22W78X
		BZE	SR1		# B-19
			S22W78X
		STODL	W +152D		# W76= SQ ROOT (E2-W73 SQ)
			W +144D		# W72
		DMP	SL2
			W +146D		# W73
		BDSU	DDV
			S22UUT +6D	# E1
			W +152D		# W76
		BOV	SR2		# B-19
			S22W78X
		STORE	W +150D		# W75= (E1-W72W73)/W76
S22W78X		DLOAD	DSQ
			W +150D
		PDDL	DSQ
			W +144D		# W72
		DAD	SL2
		BDSU	BMN	
			S22UUT		# E0
			S22SAVET
		SQRT	SR1		# B-19
		STORE	W +156D		# W78= SQ RT(E0-W72 SQ-W75 SQ)
S22SAVET	CALL
			GETTF
		STORE	S22TPRIM	# SAVE PRESENT TIME FOR PIOS
S22I=N		EXIT			# TEST I=N
		TC	PHASCHNG
		OCT	04022
		CS	8KK
		AD	8NN
		EXTEND
## Page 614
		BZMF	S22F244X	# EXIT TO FIGURE 2.4-4
		CA	8KK		# I=I+1
		AD	ONE
		TS	TEMPOR1
		CA	S22LOC		# ADD 7 TO LOC TO GET ADDR. OF NEXT MARK
		AD	SEVEN
		TS	TEMPOR1 +1
		TC	PHASCHNG
		OCT	04022
		CA	TEMPOR1
		TS	8KK
		CA	TEMPOR1 +1
		TS	S22LOC
		TC	INTPRET
		CALL			# FOR ALL INTEGRATIONS OTHER THAN FIRST
S2INTS1			SETINTG
		BOFF	SET
			DMENFLG		# =0 D=0 OR 6, =1 D=9
			S22D6Z
			DIM0FLAG
		SETGO			# D=9 PATH
			D6OR9FLG
			S22NXTIN	# RETURN ALWAYS EXCEPT OFFSET POINT MARK 1
S22D6Z		BOFF	SETGO
			ORBWFLAG
			S22NXTIN	# D=0,OFFSET MARK 1,NO W INTEGRATION
			DIM0FLAG
			S22NXTIN	# D=6,OFFSET MARK 1, INTEGRATE W 6X6
S22OFF=I	CALL
			GETTF
		STOVL	S22TOFF		# TIME SUB OFF
			UM
		STCALL	S22UOFF		# U SUB OFF
			S22I=N		# TEST I=N
S22D=9		VLOAD			# D=9 PATH
			X789
		STODL	0D		# CALL PIOS TWICE TO TRANSFORM RL TO TIME
			S22TPRIM	# T(SUB F) FROM TIME T PRIME
		STORE	6D
		SLOAD	CALL
			S22EORM		# 0=EARTH, NON-ZERO=MOON
S2RTRP			R-TO-RP
		PUSH	CALL		# R-TO-RP LEAVES PUSHLOC AT 0
			GETTF
		STORE	6D
		SLOAD	CALL
			S22EORM
S2RPTR			RP-TO-R
S22BOX32	STORE	X789
		SET	BOV
## Page 615
			INCORFLG	# FLAG=1
			+1		# CLEAR OVERFLOW
		VSU
			CSMPOS
		STORE	RCLP		# RCL=RL-RC
		UNIT	VXV		# USTAR=UNIT(UNIT(RCL)XUM)
			UM
		UNIT	BOV
			S22SAVET	# COMPUTATION OVERFLOW,SAVE TF
		STORE	USTAR
S22BOX12	DLOAD	DAD
			SCTVAR		# B+18
			IMUVARR		#  B+18
		STOVL	VARIANCE
			RCLP		#  B-29 OR B-27
		ABVAL	NORM
			X1
		DSQ	DMP
			VARIANCE
		XAD,1	XAD,1
			X1		# DOUBLE NORM SHIFT SINCE RCLP WAS SQUARED
			S22EORM		# DOUBLE EARTH OR MOON SHIFT,SAME REASON
		XAD,1	SR*
			S22EORM
			0,1		# SCALE VARIANCE B-40 FOR BOTH EARTH,MOON
		TLOAD			# CHANGE MODE TO TRIPLE
			MPAC
		STCALL	VARIANCE	# CALC B0,B1,DELTAQ, NEW USTAR
S2BVTRS			BVECTORS
		VLOAD	VCOMP
			BVECTOR
		STCALL	BVECTOR +12D	# B2=-B0
S2INCP1			INCORP1
		CALL
			GRP2PC
		BOFCLR	CALL
			22DSPFLG	# =1 DISPLAY DELTA R,V  =0 DO NOT
			S22BOX42
			GRP2PC
		VLOAD	ABVAL
			DELTAX		# DELTA R
		LXA,1	SR*
			S22EORM		# SCALE DELTA R ALWAYS METERS B-29
			0,1
		STOVL	N49DISP
			DELTAX +6	# DELTA V
		ABVAL	SR*		# DELTA V=METERS/CSEC B-7 ALWAYS
			0,1
		STORE	N49DISP +2
		EXIT
## Page 616
		CAF	V06N49EE
		TC	BANKCALL
		CADR	GOFLASHR
		TC	GOTOPOOH	# V34E TERMINATE
		TC	+5		# INCORPORATE CHANGES
		TC	P22OVER +1	# V32E RECYCLE WITHOUT CONVERTING W
		CAF	BIT3
		TC	BLANKET
		TC	ENDOFJOB
		TC	INTPRET
S22BOX42	CALL
			INCORP2
		LXA,2	CALL
			S22EORM
			CMPOS
DMPINCP2	BOFF	CALL
			INCORFLG
			S22SAVET	# SAVE TF AND TEST I=N
			GRP2PC
		CLEAR	VLOAD
			INCORFLG	# FLAG=0
			X789
		VSU
			CSMPOS
		STCALL	RCLP		# RCL=RL-RC
			S22BOX12
S22BOX22	SLOAD
			S22WSUBL
		STORE	W +144D
		STORE	W +152D
		STCALL	W +160D
			GETTF
		CALL			# COMPUTE RL
			LALOTORV
		VLOAD	BOFF
			ALPHAV		# RL B-29
			CMOONFLG
			S22BOX32
		VSL2	GOTO		# SCALE RL B-27 FOR MOON
			S22BOX32
S22F244X	TC	INTPRET
S22F244		SLOAD	BHIZ		# FIG 2.4-4   TEST OFF=0
			CXOFF
			S22BOX44
		PUSH	SLOAD
			8NN
		DSU
		BMN	CALL		# OFFSET GR. NO. MARKS, FORGET IT
			S22BOX44
			GRP2PC		# GROUP 2 PHASE CHANGE
## Page 617
		DLOAD
			S22TOFF
		STCALL	TDEC1		# CALC RC AT OFFSET TIME
			CSMPREC
		VLOAD
			RATT1		# RC METERS B-29 OR B-27
		STOVL	CSMPOS
			S22UOFF
		STOVL	UM		# U=UOFF
			X789
		ABVAL	BOFF
			CMOONFLG
			+2
		SR2			# SCALE MOON R0 B-29 FOR S22F2410 SUBR
		STCALL	ERADM
			S22F2410
		GOTO
			S22BX44A
S22BOX44	CALL
			GETTF
		STORE	S22TOFF		# PRESENT TIME FOR LAT-LONG SETUP
S22BX44A	VLOAD	BOFF
			X789
			CMOONFLG
			S22BX44B
		VSR2			# SCALE RL MOON B-29 FOR LAT-LONG
S22BX44B	STODL	ALPHAV		# RL SCALED B-29 FOR LAT-LONG
			S22TOFF		# EITHER PRESENT OR OFFSET TIME
		CALL
			LAT-LONG	# **** ALT OUTPUT ALWAYS B-29
		CALL			# DISPLAY LAT/LONG/ALT
			LLASRD
		EXIT
		CAF	V06N89B
		TC	BANKCALL
		CADR	GOFLASH
		TC	S22GTP		# V34E TERMINATE
		TC	S22.981X	# PROCEED POINT  A IN GSOP
		TC 	INTPRET		# RECYCLE SAVE LANDING SITE COORD
		DLOAD
			S22TOFF		# EITHER PRESENT OR OFFSET TIME
		STOVL	6D		# 6-7D= LANDING SITE TIME FOR R-TO-RP
			X789
		STORE	0D		# 0-5D= LANDING SITE VEC  FOR R-TO-RP
		SLOAD	CALL
			HIDPHALF	# ANY NON-ZERO FOR MOON
			R-TO-RP		# CONVERT RLS TO MOON-FIXED COORD
		STORE	RLS		# LANDING SITE VECTOR
		EXIT
S22.981X	TC	INTPRET
## Page 618
		CALL
			9DWTO6DW
P22OVER		EXIT
		TC	PHASCHNG
		OCT	04022
		TC	PROG22A
S22GTP		TC	INTPRET		# CONVERT W BEFORE TC GOTOPOOH
		CALL
			9DWTO6DW
		EXIT
		TC	GOTOPOOH
S22F2410	SETPD	VLOAD		# COMPUTE FORMULA 2.4.10
			0D
			CSMPOS		# RC B-29 EARTH,B-27 MOON
		UNIT	DOT		# UNIT ALSO SETS 36D=ABVAL(RC) USED BELOW
			UM
		SL1	DCOMP		# GSOP CHANGE 8/18/67
		PUSH	DSQ		# PD 2D 0D=COSA=-(UM.RC)/ABVAL(RC) B-1
		BDSU	PDDL		# PD 4D 2D=1-COSA SQ=SINA SQ B-2
			DEC1B2
			ERADM		# R0 ALWAYS B-29 FROM SETRE
		BOFF	SL2		# SCALE R0 B-27 FOR MOON
			CMOONFLG
			+1
		SR1R	DDV		# (R0/RC) B-1
			36D
		DSQ	DSU		# PD 2D (R0/RC) SQ - SINA SQ  B-2
		SQRT	BDSU		# PD 0D COSA-SQRT((R0/RC)SQ-SINA SQ) B-1
		DMP			# DMP RESULT B-28 MOON,B-30 EARTH
			36D		# VXSC RESULT B-29 MOON, B-31 EARTH
		STORE	S22RHO		# RHO FOR W INIT. OF UNKNOWN LMK B-28,B-30
		VXSC	
			UM
		VSL2	VAD		# SCALE B-27 MOON,B-29 EARTH AND ADD RC
			CSMPOS
		STORE	X789
		RVQ			# B-27 FOR EARTH OR B-29 FOR MOON
		SETLOC	P22S
		BANK

		COUNT*	$$/P22
S2231X13	STORE	S221X3		# MULT 3X1 BY 1X3,STORE RESULTING 3X3 IN
		SSP	AXT,2		# S22UMRL- S22UMRL +17D
			S2
		DEC	2
		DEC	6
		AXT,1
		DEC	18
S2231NXT	VLOAD	VXSC*
			S221X3
## Page 619
			S223X1 +6,2
		STORE	S22UMRL +18D,1
		INCR,1	TIX,2
		DEC	-6
			S2231NXT
		RVQ
GETTF		LXC,1	DLOAD*		# SET MPAC= TF
			S22LOC
			0,1
		RVQ
			
# SUBROUTINE TO MODIFY ALT AND STORE LAT TO LAT+5 IN LANDLAT TO LANDLAT+5
# PRIOR TO DISPLAY.

LLASRD		DLOAD	SR1
			LONG
		STODL	LANDLONG
			ALT
		STORE	LANDALT
		RVQ
# SUBROUTINE TO MODIFY LANDALT AND STORE LANDALT TO LANDALT+5 IN LAT TO
# LAT+5 AFTER LMK DATA LOADED BY ASTRONAUT.

LLASRDA		DLOAD	SL1
			LANDLONG
		STODL	LONG
			LANDALT
		STORE	ALT
		RVQ
		SETLOC	P20S6
		BANK
		
		COUNT*	$$/P22
9DWTO6DW	STQ	SETPD
			9DWXX
			0D
		VLOAD	PUSH		# CLEAR WORKING AREA OF PUSHLIST
			HI6ZEROS	# INCLUDING P
		PUSH	PUSH		# PD 18D
		SSP
			9DWJ		# J=29   USE 2*29 FOR DP WORDS
		DEC	58
9DWI=J		LXA,1	SXA,1		# SET I=J
			9DWJ
			9DWI
9DWEPCAL	CALL
			ROWDOT
		LXA,1			# P VARIES 0-20 INSTEAD OF 20-0
			9DWP
		STORE	EMATRIX +40D,1
## Page 620
		INCR,1	SXA,1
		DEC	2
			9DWP
		SLOAD	BHIZ		# TEST I=0
			9DWI
			9DWTESTJ
		DSU			# I=I-1
			9DWID
		STORE	9DWI
		DSU	BHIZ		# TEST I=26
			9DW26D
			9DWSETI2
		GOTO			# NEXT E SUB P
			9DWEPCAL
9DWSETI2	SSP	GOTO		# I=2
			9DWI
		DEC	4
			9DWEPCAL
9DWTESTJ	SLOAD	BHIZ		# TEST J=0
			9DWJ
			9DWFIG6
		DSU
			9DWID
		STORE	9DWJ		# J=J-1
		DSU	BHIZ		# TEST J=26
			9DW26D
			9DWSETJ2
		GOTO
			9DWI=J
9DWSETJ2	SSP	GOTO		# SET J=2
			9DWJ
		DEC	4
			9DWI=J
9DWFIG6		CALL
			GRP2PC
		SSP	VLOAD		# START OF FIGURE 2.4-6
			9DWJ		# J=29
		DEC	58
			HI6ZEROS
		STORE	9DWP		# P,N,I=0
		AXT,1	SSP
		DEC	108		# CLEAR WO TO W54
			S1
			6
CLEARW54	STORE	W +108D,1
		TIX,1
			CLEARW54
9DWI=JA		LXA,1	SXA,1		# I=J
			9DWJ
			9DWI
## Page 621
		CALL
			ROWDOT
		LXA,1	BDSU*
			9DWP
			EMATRIX +40D,1
		INCR,1	SXA,1		# -(P+1)
			2
			9DWP
		LXC,1	XSU,1		# -(I+N)
			9DWI
			9DWN
		BPL	DLOAD		# TEST WSQ LTE 0
			9DWAAA
			HI6ZEROS	# W=0
9DWAAA		SQRT			# W= SQRT(WSQ)
9DWAAB		STORE	W,1
		STODL	WORKW
			9DWJ		# TEST J=0
		BHIZ
			9DWEXITX	# EXIT
TST2I=0		SLOAD	BHIZ		# TEST I=0
			9DWI
			9DWN=N+3
		DSU
			9DWID
		STORE	9DWI		# I=I-1
		DSU	BHIZ		# TEST I=26
			9DW26D
			9DWAAC
		GOTO
			9DWNEXEP
9DWAAC		SSP			# I=2
			9DWI
			4
9DWNEXEP	CALL
			ROWDOT
		LXA,1	BDSU*		# (EP-ROWI*ROWJ)/W
			9DWP
			EMATRIX +40D,1
		DDV	INCR,1		# P=P+1
			WORKW
			2
		SXA,1	LXC,1
			9DWP
			9DWI
		XSU,1	BOV		# -(I+N)
			9DWN
			SETWIN=0
		GOTO
			9DWSETWX
## Page 622
SETWIN=0	DLOAD			# W(I+N)=0
			HI6ZEROS
9DWSETWX	STORE	W,1
		GOTO
			TST2I=0
9DWN=N+3	LXA,1	INCR,1		# N=N+3
			9DWN
			6
		SXA,1	SLOAD		# J=J-1
			9DWN
			9DWJ
		DSU
			9DWID
		STORE	9DWJ
		DSU	BHIZ		# TEST J=26
			9DW26D
			SETJ=2A
		GOTO
			9DWI=JA
SETJ=2A		SSP	GOTO		# J=2
			9DWJ
			4
			9DWI=JA
9DWEXITX	CALL
			GRP2PC
		AXT,1	SSP		# CLEAR W6,W7,W8 USED TEMP FOR EMATRIX
		DEC	54
			S1
			6
		VLOAD
			HI6ZEROS
9DWEXXXA	STORE	W +162D,1
		TIX,1	GOTO
			9DWEXXXA
			9DWXX
ROWDOT		SSP	BOV
			XTMP1
		OCT	377
			+1
		LXC,1	LXC,2
			9DWI
			9DWJ
		DLOAD	PUSH
			HI6ZEROS
ROWDOT1		DLOAD*	DMPR*
			W,1
			W,2
		DAD	PUSH
		BOV	INCR,1
			ROWDOT3
## Page 623
		DEC	-6
		INCR,2	SLOAD
		DEC	-6
			XTMP1
		BHIZ	SR1
			ROWDOT2
		STORE	XTMP1
		GOTO
			ROWDOT1
ROWDOT2		DLOAD
		RVQ
ROWDOT3		CLRGO
			ORBWFLAG
			ROWDOT2
WORKW		=	0D
XTMP1		=	6D
9DWP		=	8D		# P
9DWI		=	10D		# I
9DWN		=	12D		# N
9DWJ		=	14D		# J
S223X1		=	18D		# 6
S221X3		=	24D		# 6
S22D		=	30D		# 2
S22RHO		=	32D		# 2
		SETLOC	P20S9
		BANK
		
		COUNT*	$$/P22
9DW26D		2DEC	52 B-14
9DWID		2DEC	2 B-14
SCTVAR		2DEC	1.0 E-6 B+18
IMUVARR		2DEC	0.04 E-6 B+18
DEC1B2		=	DP1/4TH		# 1 B-2
V06N49EE	=	V06N49
V06N89B		=	V06N89
		SETLOC	P20S2
		BANK
		COUNT*	$$/R63
## Page 624
## Empty page.

## Page 625

# SUBROUTINE NAME:   V89CALL
# MOD NO:  0			  DATE: 8 FEB 1968
# MOD BY:  DIGITAL DEVEL GROUP    LOG SECTION:  P20-P25
#
# FUNCTIONAL DESCRIPTION:
#
# CALLED BY VERB 89 ENTER DURING P00. PRIO 10 USED. CALCULATES AND
# DISPLAYS FINAL GIMBAL ANGLES TO POINT CSM +X AXIS OR PREFERRED AXIS
# (UNIT(Z)COS55 DEG + UNIT(X)SIN55 DEG) AT LM.
#
# 1. KEY IN V 89 E ONLY IF IN PROG 00. IF NOT IN P00, OPERATOR ERROR AND
# EXIT R63, OTHERWISE CONTINUE.
#
# 2. IF IN P00, DO IMU STATUS CHECK (R02BOTH). IF IMU ON AND ITS
# ORIENTATION KNOWN TO CGC, CONTINUE.
#
# 3. FLASH DISPLAY V 04 N 06. R2 INDICATES WHICH SPACECRAFT AXIS IS TO
# BE POINTED AT LM.  INITIAL CHOICE IS PREFERRED AXIS. (R2=1).
# ASTRONAUT CAN CHANGE TO (+X) AXIS (R2 NOT= 1) BY V22 E 2 E.  CONTINUE
# AFTER KEYING IN PROCEED.
#
# 4. SET PREFERRED ATTITUDE FLAG ACCORDING TO OPTION DESIRED. SET FLAG
# FOR PREFERRED AXIS. RESET FLAG FOR X AXIS.
#
# 5. CURRENT TIME IS STORED AND R63COMP IS CALLED
#
#     R63COMP JOB:
#	
#	UPDATES CSM AND LM STATE VECTORS USING CONIC EQUATIONS
#
#	CALCULATES BOTH PREFERRED AND X AXIS TRACKING ATT FROM 3SM TO LM.
#
#	DESIRED GIMBAL ANGLES AS INDICATED BY PREFERRED ATTITUDE FLAG
#	ARE STORED FOR LATER R60CSM CALL.
#
# 6. FLASH DISPLAY V 06 N18 AND AWAIT RESPONSE.
#
# 7. RECYCLE- RETURN TO STEP 5.
#    TERMINATE- EXIT R63 ROUTINE
#    PROCEED- RESET 3AXISFLG AND CALL R60CSM FOR ATTITUDE MANEUVER.
#
#
# CALLING SEQUENCE: V 89 E
#
# SUBROUTINES CALLED: CHKPOOH, R02BOTH, GOXDSPF, R63COMP, R60CSM
#
# ALARMS   1. OPERATOR ERROR IF NOT IN P00
#	   2. PROGRAM ALARM IF IMU IS OFF
#	   3. PROGRAM ALARM IF IMU ORIENTATION IS UNKNOWN
## Page 626
#
# ERASABLE INITIALIZATION REQUIRED: NONE
#
# DEBRIS:  OPTION1, OPTION1+1, PRFTRKAT(PREF ATT FLAG),P21TIME, 3AXISFLG

DP1MIN		2DEC	6000

		EBANK=	R63TIME
		SETLOC	V89TAG
		BANK
		COUNT*	$$/R63
		
		
V89CALL		TC	BANKCALL	# IMU STATUS CHECK. RETURNS IF ORIENTATION
		CADR	R02BOTH		# KNOWN. ALARMS IF NOT.
		TC	INTPRET
		CLEAR	DLOAD
			AZIMFLAG
			ZEROVECS
		STORE	UTPIT
		STORE	UTYAW
		EXIT
		
		CAF	VB06N78
		TC	BANKCALL
		CADR	GOFLASHR
		TC	ENDEXT
		TCF	V89RECL
		TC	-5
		
		CAF	BIT3
		TC	BLANKET
		TC	ENDOFJOB
		
V89RECL		TC	INTPRET
		RTB	DAD
			LOADTIME	# READ PRESENT TIME
			DP1MIN		# INTEGRATE TO 1 MIN FROM NOW
		STCALL	R63TIME		# STORE TIME FOR CALL TO R63COMP. R63COMP
			R63COMP		# LEAVES DESIRED GIM ANGS IN THETAD,LOS IN
		EXIT			# POINTVSM, AND SELECTED AXIS IN SCAXIS.
		CAF	VB06N18		# V 06 N 18
		TC	BANKCALL	# NOUN 18 REFERS TO THE DESIRED GIMBAL
		CADR	GOFLASH
		TC	ENDEXT		# TERMINATE
		TC	+2		# PROCEED
		TC	V89RECL		# RECYCLE
		TC	DOWNFLAG	# RESET 3 AXIS FLAG
## Page 627
		ADRES	3AXISFLG	# RESET BIT 6 FLAG 5
		TC	BANKCALL	# PERFORMS CSM MANEUVER TO ALIGN SELECTED
		CADR	R60CSM		# SPACECRAFT AXIS TO LOS.
		TCF	ENDEXT
		
		
VB06N78		VN	0678

VB06N18		=	V06N18

R63COMP		EQUALS	R63

## Page 628

# PROGRAM NAME- P23 CISLUNAR MIDCOURSE NAVIGATION
# MOD NO
# MOD BY- TOM KNATT
# FUNCTIONAL DESCRIPTION- DO MIDCOURSE NAVIGATION BY INCORPORATION OF STAR 
# /EARTH AND STAR/MOON OPTICAL MEASUREMENTS.
# CALLING SEQUENCE- ASTRONAUT OPERATED
# SUBROUTINES CALLED-R52,R53,R57,R60,ORBITAL INTEGRATION (INTEGRV)
# INCORP1,INCORP2,LALOTORV,LUNPOS  ,AND DISPLAY INTERFACE ROuTINES.
# N0RMAL EXIT MODES- VIA R00
# ALARMS- NONE
# ABORT MODES- NONE
# ERASABLE INITIALIZATION REQUIRED- PAD-LOADED ERASABLES,ORBWFLAG RESET,
# REFSMFLG=0 IF IMU OFF AND REFSMFLG=1 IF IMU ON
# INPUTS BY USER REQUIRED- STAR NUMBER,LANDMARK LAT,LONG/2,ALT
# IF LANDMARK IS USED,        NEAR OR FAR HORIZON IF HORIZON IS USED, AND 
# BODY TO BE MARKED ON (EARTH OR MOON).  SEE GSOP CHAPT 4.
# OUTPUT-UPDATED CMC STATE VECTOR. VECTOR FROM S/C TO HORIZON OR LANDMARK
# IN POINTAXS. POINTAXS CAN BE USED TO GENERATE THIS VECTOR APART FROM
# P23 IF DESIRED.
# DEBRIS-NO USABLE DEBRIS IS GENERATED. RENDWFLG IS RESET FOR P20 UPON
# ENTRY INTO P23.    RUPTREGS AND ERASABLES USED BY DISPLAYS ARE DEBRIS.
		SETLOC	RT23
		BANK
		COUNT*	$$/P23
		EBANK=	MRKBUF1
P23		TC	DOWNFLAG
		ADRES	RNDVZFLG
		
		TC	2PHSCHNG
		OCT	00004		# LEAVE GROUP 4
		OCT	00012		# ENTER GROUP 2
		CAF	PRIO13
		TS	PHSPRDT2
		TC	DOWNFLAG
		ADRES	RENDWFLG
P23.00		TC	INTPRET
		BON	CALL
			REFSMFLG	# SET NOW AS INPUT, NORMALLY EXTERNAL CONT
			P23.05		# WHEN ALIGNED,PERFORM MEASUREMENT
			R57		# DO OPTICS CALIBRATION IF IMU NOT ALIGNED.
		CALL
			R53
		GOTO
			P23.60
P23.05		CLEAR	CALL
			SAVECFLG
			R57		# PERFORM MARK CALIBRATION
P23.06		SLOAD	CALL
			V05N70
			P23N7071
## Page 629
V94ENTER	RTB
			LOADTIME	# READ CLOCK
		STCALL	MARKTIME
			POINTAXS	# RETURN LOS IN MPAC
		STORE	UCLSTAR		# TEMP
		EXIT
		CAF	V50N25P
		TC	BANKCALL
		CADR	GOPERF1		# GOPERF1 BLANKS OUT R2 AND R3.
		TC	GOTOPOOH
		TC	+2		# PRO DO 3AXIS MANEUVER
		TC	DOVECPT		# ENTER DO VECPOINT MANEUVER
		TC	INTPRET
		VLOAD	UNIT
			UCLSTAR
		STCALL	ZSM		# UCL
			R23.55		# COMPUTE STAR VECTOR AND LEAVE IN MPAC

OCCLCOMP	VXV	UNIT		# COMPUTE CONSTRAINED BRSB MATRIX(SHAFT
			ZSM		#				 =180)
		STORE	YSM		# UNIT(US* X UCL)
		VXV	UNIT
			ZSM
		STORE	XSM		# UNIT(UNIT(US* X UCL) X UCL)
		SSP	AXT,1
			S1
			6
			18D
NEXTVEC1	VLOAD*	VXM		# COMPUTE BRNB = (SBNB)(BRSB)
			NB1NB2 +18D,1
			XSM
		UNIT
		STORE	XNB +18D,1	# STORE IN XNB FOR CALCGA
		TIX,1	AXT,1
			NEXTVEC1
			18D
NEXTVEC2	VLOAD*			# LOAD REFSMMAT INTO XSM FOR CALCGA
			REFSMMAT +18D,1
		STORE	XSM +18D,1
		TIX,1	CALL
			NEXTVEC2
			CALCGA		# COMPUTE DESIRED CDUS
		SET	CALL
			3AXISFLG
			DOR60B
		GOTO
			P23.57A
DOVECPT		TC	INTPRET
		VLOAD	CALL
			UCLSTAR
## Page 630
			DOR60
P23.57A		CALL
			GRP2PC
P23.57		CLEAR	SET
			TARG2FLG
			V94FLAG
		CALL
			R52
		CLEAR
			V94FLAG
P23.60		EXIT
		INHINT
		EXTEND
		DCA	MRKBUF1
		DXCH	MARKTIME
		CA	MRKBUF1 +5
		XCH	TRUNION
		RELINT
		CAF	SIX
		TC	GENTRAN
		ADRES	MRKBUF1
		ADRES	MARKDOWN
		TC	INTPRET
		SET	CALL
			SAVECFLG
			GRP2PC
		SLOAD	CALL
			V05N71
			P23N7071
P23.85		CALL
			POINTAXS
R23.55		UNIT	PDVL		# RCLL IS IN MPAC
			34D		# RCLL * RCLL
		STOVL	30D		# PUSH 30-31 =RCLL*RCLL 32-33=ABVAL RCLL
			VZC
		VXSC	VSR
			ONE/C
			15D
		VAD			# PUSH UP RCLL(UNIT)
		UNIT
		STOVL	UCLSTAR
			VZC
		VSR2	VSU
			VESO
		VXSC	VSR
			ONE/C
			13D
		VAD	UNIT
			US
		BOFF
## Page 631
			SAVECFLG
			OCCLCOMP
		STORE	USSTAR
		DOT	SL1
			UCLSTAR
		PDVL	VXSC		# PD 0,1 = USSTAR(DOT)UCLSTAR
			UCLSTAR
		VSL1	BVSU
			USSTAR
		UNIT
		STOVL	BVECTOR		# USSTAR - COSQ(UCLSTAR
			ZEROVECS
		STORE	BVECTOR +6
		STODL	BVECTOR +12D
			0
		ACOS	DCOMP
		PDDL	EXIT
			ZEROVECS
		CA	VARSUBL		# PUT FIXED INTO ERASABLE FOR MSU
		TS	L		# INSTRUCTION COMING UP
		CA	TRUNION		# REQUIRED TO CHANGE 2'S COMPLEMENT
		EXTEND			# TRUNION TO 1'S COMPLEMENT
		MSU	L		# TRUNION (2'S)-00000 CONVERTS TRUNION TO
		TS	MPAC		# 1'S. VARSUBL=00000
		TC	INTPRET
		PUSH	SLOAD		# PUSH IS DP. WHEN BDSU IS EXECUTED, 2ND
			TRUNBIAS	# HALF OF PUSHLIST IS GUARANTEED ZERO FROM
		BDSU			# DLOAD ZEROVECS ABOVE
		SR3	DAD
		DAD	DMP
			TRUN19
			32D
		DMP	SL3
			PI/4.0
		BOFF	SL2
			CMOONFLG
			R23.51
R23.51		STODL	DELTAQ
			30D		# RCLL * RCLL
		DMP	RTB
			TRUNVAR
			TPMODE
		TAD	CLEAR
			VARSUBL
			DMENFLG
		STCALL	VARIANCE
			INCORP1
		CALL
			GRP2PC
		VLOAD	ABVAL
## Page 632
			DELTAX +6
		BOF	SR2		# DISPLAY IS 2-27 IF IN LUNAR SPHERE
			CMOONFLG
			R23.52
R23.52		STOVL	N49DISP +2
			DELTAX
		ABVAL
		BOF	SR2
			CMOONFLG
			R23.53
R23.53		STORE	N49DISP
		EXIT
R23.6		CAF	V06N49
		TC	BANKCALL
		CADR	GOFLASHR
		TC	GOTOPOOH
		TC	R23.7		# INCORPORATE DATA
		TC	GOTOPOOH
		CAF	BIT3		# BLAN OUT R3
		TC	BLANKET
		TC	PHASCHNG
		OCT	00012
		TC	ENDOFJOB
R23.7		TC	INTPRET
R23.8		SET	CALL
			VEHUPFLG
			INCORP2
		EXIT
R23.END		TC	GOTOPOOH
DOR60		MXV	UNIT
			REFSMMAT
		STOVL	POINTVSM
			JCAXIS
		STORE	SCAXIS
		CLEAR
			3AXISFLG	# SET UP FOR VECPOINT IN R60
DOR60B		STQ	EXIT
			SRTEMP
		CAF	R60ADRS
		TS	TEMPFLSH
		TC	PHASCHNG
		OCT	00012
R60CALL		TC	E6SETTER
		TC	BANKCALL
		CADR	R60CSM
 +3		TC	E7SETTER
		TC	INTPRET
		GOTO
			SRTEMP
## Page 633

# POINTAXIS SUBROUTINE

POINTAXS	STQ	
			POINTEX
R23.05		BON	DLOAD
			ORBWFLAG
			R23.1
			WMIDPOS
		STCALL	0
			INITIALW	# INITIALIZE W-MATRIX FIRST PASS IN P23
R23.1		CALL
			SETINTG		# SETUP FOR CSM INTEGRATION
		BOFSET	SET
			ORBWFLAG
			R23.2
			DIM0FLAG
R23.2		CALL
			INTEGRV		# INTEGRATE CSM STATE VEC. TO MARKTIME
		EXIT
		TC	PHASCHNG
		OCT	04022
		TC	INTPRET
RECT.1		BOFF	AXT,2		# SR TO SET ZMEASURE = 0 IF MEASUREMENT
			CMOONFLG	#  PLANET AND PRIMARY PLANET ARE THE SAME
			RECT.3		#   OTHERWISE = 1
		DEC	-2
		BOFF			#     VEC. AND SCALE B29 AND B7
			LUNAFLAG
			RECT.4
RECT.2		CLEAR	GOTO
			ZMEASURE
			RECT.5
RECT.3		AXT,2	BOFF
			0
			LUNAFLAG
			RECT.2
RECT.4		SET
			ZMEASURE
RECT.5		VLOAD	VSR7
			DELTACSM	# SCALED B22  OR  B18
		VSR*	VAD
			0,2
			RCVCSM		# SCALED B29  OR  B27
		VSR*
			0,2
		STOVL	RZC		# NOW SCALED B29
			NUVCSM		# SCALED B3  OR  B-1
		VSR4	VSR*
			0,2
		VAD	VSR*
## Page 634
			VCVCSM		# SCALED B7  OR  B5
			0,2
		STORE	VZC		# NOW SCALED B7
		BOFF	
			ZMEASURE	# IN SPHERE OF INFLUENCE OF PRIMARY BODY
			R23.3
		DLOAD	CALL
			MARKTIME
			LUNPOS
		BON	VCOMP
			CMOONFLG
			+1
		VAD
			RZC	
		STORE	RZC
R23.3		SETPD	SLOAD
			0
			LANDMARK	# IF LANDMARK = 0, USE HORIZ SUBR
		BHIZ	SET
			R23.4
			ERADFLAG
		DLOAD	CALL
			MARKTIME
			LALOTORV
		GOTO
			R23.5
R23.4		DLOAD	PDDL		# PUSH 0-1 = -AYO SCALED B0
			-AYO
			AXO
		PDDL	PDVL		# PUSH 2-3 = +AX SCALED B0
			DPPOSMAX
			US
		VXV	UNIT
			RZC
		STOVL	UBAR2
		VXV	UNIT		# PUSH UP
			UBAR2
		STOVL	UBAR0
			UBAR2
		VXV	UNIT
			UBAR0
		STORE	UBAR1
		BON	DOT
			LUNAFLAG
			HORIZ.6
			0		# UBAR1 DOT UZ
		STOVL	ALPHAV +4
			RZC
		ABVAL	DMP
			HORISLP
## Page 635
		DCOMP	DAD
			HORIZALT
		STCALL	RATETEMP
			GETERAD
		DAD	PDDL		# MPAC HAS RADIUS OF FISHER ELLIPSOID
			RATETEMP	# PUSH 0-1 = BH SCALED B29
			AEARTH
		DAD	PUSH		# PUSH 2-3 = AH B29
			RATETEMP
HORIZ.1		VLOAD	MXV
			RZC		# B29
			UBAR0		# B1
		VSL1	PDVL		# PUSH 4-9 = RH(XH,YH,ZH) B29
			US
		MXV	VSL1
			UBAR0
		PDDL			# PUSH 10-15 = USH B1
			2		# AH
		STODL	34D
			4		# XH
		CALL
			DIVIDE
		SR*	DSQ
			8D,1		# NOW SCALED B9
		STODL	30D
			0
		STODL	34D
			6		# YH
		CALL
			DIVIDE
		SR*	DSQ
			8D,1		# B9
		DAD	PUSH		# PUSH 16-17 =A SCALED B18
			30D
		DSU	SQRT
			1.0B18
		PDDL			# PUSH 18-19  SQRT(A-1) B9
			16D
		STODL	34D
			4		# XH
		CALL
			DIVIDE
		SR*	PDDL
			17D,1		# PUSH 20-21 = XH/A B29
			6		# YH
		CALL
			DIVIDE
		SR*	PDDL
			17D,1		# PUSH 22-23 = YH/A B29
			18D		# SQRT(A-1)
## Page 636
		CALL
			DIVIDE
		SR*
			8D,1
		STODL	28D
			0		# BH
		STODL	34D
			2		# AH
		CALL
			DIVIDE
		SR*	DMP		# AH/BH  SCALED  B1
			0,1
			28D		# SQRT(A-1)/A
		DMP	SL1
			6		# YH
		PDDL	
			2		# AH
		STODL	34D
			0
		CALL
			DIVIDE
		SR*	DMP		# BH/AH  SCALED  B1
			0,1
			28D		# SQRT (A-1)/A
		DMP	SL1
			4		# XH
		PDDL	DAD
			20D		# XH/A
			24D		# ALPHA
		PDDL	DSU
			22D		# YH/A
			26D		# BETA
		PUSH	SETPD
			16D
		DLOAD	DSU
			20D		# XH/A
			24D		# ALPHA
		PDDL	DAD		
			22D		# YH/A
			26D		# BETA
		PDDL	PUSH
			ZEROVECS
		STOVL	32D		# ZERO THIRD COMP. OF T-0 VECTOR
			28D
		VSU	UNIT
			4		# RH VECTOR
		DOT	PDVL		# PUSH 22-23 A-SUB-ZERO
			10D		# USH VECTOR
			16D		# T1 VECTOR
		VSU	UNIT
## Page 637
			4		# RH VECTOR
		DOT	PUSH		# PUSH 24-25 A-SUB-ONE
			10D
		BDSU	BMN
			22D		# A-SUB-ZERO
			HORIZ.3
		BON
			NORFHOR
			HORIZ.4
HORIZ.2		VLOAD	GOTO
			28D		# T-0 VECTOR
			HORIZ.5
HORIZ.6		DLOAD	PUSH
			RADMOON
		PUSH	GOTO
			HORIZ.1
HORIZ.3		BON
			NORFHOR
			HORIZ.2
HORIZ.4		VLOAD
			16D		# T1 VECTOR
HORIZ.5		VXM	VSL1
			UBAR0
R23.5		VSU	SETPD
			RZC
			0
		GOTO
			POINTEX
DIVIDE		NORM	SR1
			X1
		STODL	36D
			34D
		NORM	BDDV
			S1
			36D
		XSU,1	RVQ
			S1
P23N7071	STORE	22SUBSCL
		STQ	EXIT
			POINTEX
DISP7071	CA	22SUBSCL
		TC	VNFLASH
P23.15		TC	UPFLAG
		ADRES	LUNAFLAG
		CA	LANDMARK	# IF C=2,LUNAFLAG=1. IF C=1,LUNAFLAG=0
		EXTEND
		BZF	P23.151
		CA	HORIZON
		EXTEND
		BZF	+2
## Page 638
		TC	R23.10		# OPERATOR DSKY ERROR
		CA	LANDMARK
		TC	P23.152
P23.151		CA	HORIZON
		EXTEND
		BZF	R23.10
P23.152		MASK	BITS7-9		# IS C EQUAL TO 1 OR 2
		AD	NEG100
		EXTEND
		BZF	P23.16
		AD	NEG100
		EXTEND
		BZF	P23.176
		TC	R23.10
P23.16		TC	DOWNFLAG
		ADRES	LUNAFLAG
P23.176		TC	UPFLAG
		ADRES	NORFHOR
		CA	HORIZON
		EXTEND
		BZF	P23.20
		MASK	BITS4-6
		AD	-OCT10
		EXTEND
		BZF	P23.18
		AD	-OCT10
		EXTEND
		BZF	P23.30
		TC	R23.10
P23.20		TC	INTPRET
		CALL
			P22SUBRB
		EXIT
P23.18		TC	DOWNFLAG
		ADRES	NORFHOR
P23.30		CA	STARCODE	# IS STARCODE GREATER THAN OR
		EXTEND			# EQUAL TO 0 AND LESS THAN 37
		BZF	LDPLANET
		EXTEND
		BZMF	R23.10
		AD	NEG37
		EXTEND
		BZMF	P23.170
R23.10		TC	FALTON
		TC	DISP7071
P23.170		TC	INTPRET
P23.17		SLOAD	PUSH
			STARCODE
		SLOAD	DMP
			SPSIX
## Page 639
		LXA,1	SXA,1
			MPAC +1
			BESTI		# BESTI = 6XSTAR NUMBER
		CALL
			LOWMEMRY	# NEEDED TO RETRIEVE STAR VECTOR FROM LOW
P23.31		STORE	STARSAV2	# STORE FOR R53,P23. US(IN P23)=STARSAV2
		GOTO
			POINTEX
LDPLANET	CAF	V06N88
		TC	VNFLASH
		TC	INTPRET
		VLOAD	VXSC
			STARSAV3
			1DSQR3
		UNIT	GOTO
			P23.31
ONE/C		2DEC*	.333564049 E-6 B+21*
AEARTH		2DEC	6378166 B-29	# A AXIS OF EARTH(METERS B-29)
RADMOON		2DEC	1738090 B-29	# RADIUS MOON IN METERS
1.0B18		2DEC	1.0 B-18
TRUN19		OCT	01604
VARSUBL		DEC	0
VARSUBL3	2DEC*	3.4299040 E+6 B-26*
TRUNVAR		2DEC	2.5 E-9 B+18
V05N70		VN	0570
V05N71		VN	0571
V50N25P		OCT	00202
SPSIX		OCT	00006
JCAXIS		2DEC	.2688190620	# 1/2(SIN 32.523 DEG)  TRACK AXIS
		2DEC	0
		2DEC	.4215878460	# 1/2(COS 32.523 DEG)
R60ADRS		CADR	R60CALL +3
NEG37		DEC	-37
BITS7-9		OCT	700
BITS4-6		OCT	70
1DSQR3		2DEC	0.57735021

V94NTR		TC	INTPRET
		GOTO
			V94ENTER
		SETLOC	RT53
## Page 640
		BANK
		COUNT*	$$/STARS
LOWMEMRY	VLOAD*	RVQ
			CATLOG,1
		SETLOC	FFTAG2
		BANK
		
		COUNT*	$$/R22
GOTOV56		EXTEND			# P20 TERMINATES BY GOTOV56 INSTEAD OF
		DCA	VB56CADR	#  GOTOPOOH
		TCF	SUPDXCHZ
		EBANK=	WHOCARES
VB56CADR	2CADR	TRACKTRM

		SETLOC	PINBALL1
		BANK
		COUNT*	$$/EXTVB
V67CALL		TC	INTPRET
		CALL
			V67WW
		EXIT
V06N99DS	CAF	V06N99A
		TC	BANKCALL
		CADR	GOXDSPF
		TCF	ENDEXT
		TC	V06N9933
		TC	V06N99DS
V06N9933	TC	INTPRET
		SLOAD	BHIZ		# IF R3 OF V67 = 0 EXIT
			WWOPT
			V67COMEX
V6N99INP	LXA,1	LXA,2
			WWPOS
			WWVEL
		SLOAD	DSU
			WWOPT
			V67DEC2
		BHIZ	BPL
			V67WORB
			V67WMID
		SXA,1	SXA,2
			WRENDPOS
			WRENDVEL
		GOTO
			V67EXITX
V67WORB		SXA,1	SXA,2
			WORBPOS
			WORBVEL
		GOTO
			V67EXITX
## Page 641
V67WMID		SXA,1	SXA,2
			WMIDPOS
			WMIDVEL
V67EXITX	CLEAR
			ORBWFLAG
V67COMEX	EXIT
		TCF	ENDEXT
V67WW		STQ	BOV
			S2
			+1
		CALL
			INTSTALL
		SSP	DLOAD
			S1
		DEC	6
			ZEROVECS
		STORE	WWPOS
		STORE	WWVEL
		STORE	WWOPT
		AXT,1
		DEC	36
NXPOSVEL	VLOAD*	VSQ
			W +36D,1
		DAD
			WWPOS
		STORE	WWPOS
		VLOAD*	VSQ
			W +90D,1
		DAD
			WWVEL
		STORE	WWVEL
		TIX,1	SQRT
			NXPOSVEL
		STODL	WWVEL
			WWPOS
		SQRT
		STORE	WWPOS
		BOV	GOTO
			+2
			V67XXX
		DLOAD
			DPPOSMAX
		STORE	WWPOS
		STORE	WWVEL
V67XXX		DLOAD	DSU
			WWPOS
			FT99999
		BMN	DLOAD
			+3
			FT99999
## Page 642
		STORE	WWPOS
		LXA,1	SXA,1
			S2
			QPRET
		EXIT
		TC	POSTJUMP
		CADR	INTWAKE
V06N99A		VN	0699
FT99999		2DEC	30479 B-19
V67DEC2		2DEC	2 B-14
		SBANK=	LOWSUPER
