### FILE="Main.annotation"
# Copyright:	Public domain.
# Filename:	P40-P47.agc
# Purpose:	Part of the source code for Artemis (i.e., Colossus 3),
#		build 072.  This is for the Command Module's (CM)
#		Apollo Guidance Computer (AGC), we believe for
#		Apollo 15-17.
# Assembler:	yaYUL
# Contact:	Jim Lawton <jim DOT lawton AT gmail DOT com>
# Website:	www.ibiblio.org/apollo/index.html
# Page scans:	www.ibiblio.org/apollo/ScansForConversion/Artemis072/
# Mod history:	2009-08-14 JL	Adapted from corresponding Comanche 055 file.
# 		2009-09-03 JL	Comment out MINDB declaration, it's a comment line in the page scan.
# 		2010-01-31 JL	Fixed build errors.
# 		2010-02-01 JL	Fixed build errors.
# 		2010-02-02 JL	Fixed page number.
#		2010-02-13 JL	Fix errors on pages 699 and 711.
#		2010-02-14 JL	Fixed errors on pages 724 and 725.
#		2010-02-20 RSB	Un-##'d this header.

## Page 691

# NAME		P40 - TVC (SPS BURN)
#		MOD BY ALBERT, BEALS, AND DEMERY TO REORGANIZE
#		AND REDUCE CODING 15AUG69
#
# FUNCTION	TO CONTROL THE SEQUENCE OF THE CMC DURING THE COUNTDOWN
#		AND THRUSTING MANEUVER OF AN SPS BURN
#
#		CLOKTASK	COMPUTE TIME-TO-GO TO IGNITION (FOR N35/40),
#				RECALL CLOKTASK, AND AFTER S40.6 COMPLETION
#				CALL CLOCKJOB TO DISPLAY V06N40
#
#		R02BOTH		CHECK STATUS OF IMU
#
#		S40.1		COMPUTE: INITIAL THRUST DIRECTION AND
#					 INITIAL VALUE OF VELOCITY-TO-BE-
#					 GAINED VECTOR (VGTIG)
#
#		S40.2,3		COMPUTE: GIMBAL ANGLES IF THRUSTING WILL
#					 OCCUR WITH PRESENT IMU ORIENTATION,
#					 XAXIS OF ENGINE BELL, 
#					 PREFERRED IMU ORIENTATION, AND
#					 DESIRED THRUST DIRECTION IN SM COORDS
#
#		R60CSM		PERFORM ATTITUDE MANEUVER
#
#		S40.6		HANDLE GIMBAL TEST AND TRIM OR TRIM ONLY
#
#		MIDTOAV1	EXTRAPOLATE CSM STATE VECTOR TO TIG-29.96 SECS
#
#		TIGBLNK		BLANK DSKY AT TIG-35 SECS AND
#				WAITLIST TIGAVEG IN 5 SECS
#
#		TIGAVEG		UNBLANK DSKY, 
#				WAITLIST TIG-5 IN 24.96 SECS, AND
#				START SERVICER
#
#		TIG-5		DISPLAY FLASHING V99N40:
#				ENGINE IGNITION ENABLE,
#				WAITLIST TIG-0 IN 5 SECS, AND
#				FINDVAC S40.13 TO DETERMINE IF THIS IS
#				AN IMPULSIVE OR STEERING BURN.
#
#		TIG-0		CHECK IF ASTRONAUT HAS O.K.ED IGNITION (PRIOR
#				PROCEED TO V99N40) - IF NOT, IGNITION WILL BE
#				ENTERED BY CLOCKJOB IN RESPONSE TO V99N40
#
#		CLOCKJOB	(CALLED EVERY SEC)
#				DISPLAY V06N40 EXCEPT WHEN SIGNALLED BY TIG-5
#				TO FLAHS V99N40 AND
#				CALL IGNITION WHEN PROCEED RESPONSE TO V99N40
#				HAS OCCURRED AND TIG HAS PASSED
## Page 692
#		IGNITION	TURN ON ENGINE,
#				CHECK IF IMPULSIVE BURN, AND IF SO
#				SET UP ENGINOFF COMMAND
#
#		S40.8		UPDATE VELOCITY TO-BE-GAINED VECTOR,
#				GENERATE ANGULAR RATE STEERING COMMANDS
#				FOR AUTO PILOT,
#				UPDATE CSMMASS,
#				ESTABLISH ENGINE CUT-OFF SIGNAL AT
#				APPROPRIATE TIME, AND
#				INITIATE R40, IF THRUST FAILS
#
#		S40.9		(AIMPOINT MANEUVERS ONLY)
#				GENERATE REQUIRED VEL-TO-BE-GAINED VECTOR AND
#				UPDATE B-VECTOR WHICH IS USED IN FINAL
#				CALCULATION OF EXTRAPOLATING THE VG VECTOR
#
#		ENGINOFF	WIPE OUT TVC,
#				TURN OFF CLOKTASK,
#				SHUT DOWN ENGINE,
#				ADJUST VEHICLE MASS PROPERTIES,
#				TURN ON RCS DAP, AND
#				UPDATE ENGINE TRIMS
#
#		POSTBURN	DISPLAY FLASHING V16N40,
#				CLEAN UP AFTER ENGINE CUT-OFF, AND
#				MAINTAIN VG COMP FOR POSSIBLE RCS TRIM
#
#		*************************************************
#		PROVIDE RESTART PROTECTION AT ALL CRITICAL POINTS
#		*************************************************
#
# INPUT		XDELVFLG = 1 EXTERNAL DELTA V
#
#		    DELVSIN	CHANGE OF VELOCITY (VECTOR)
#		    RTIG	CSM POSITION AT TIG
#		    VTIG	CSM VELOCITY AT TIG
#		    TIG		IGNITION TIME
#		    CSTEER = 	0
#
# 		XDELVFLG = 0 LAMBERT (AIMPOINT)
#
#		    RTARG	AIMPOINT POSITION VECTOR
#		    TPASS4	TIME OF ARRIVAL AT AIMPOINT
#		    TIG		IGNITION TIME
#		    CSTEER = 	1
#
# ALARMS	1407		VG INCREASING
#		1703		INSUFFICIENT TIME FOR INTEGRATION
#				TIG WAS SLIPPED

## Page 693
		EBANK=	DAPDATR1
		SETLOC	P40S
		BANK
		COUNT*	$$/P40
P40CSM		TC	INTPRET
		CLEAR	SLOAD
			ENG2FLAG
			ECSTEER
		BOFF	DLOAD
			XDELVFLG	# EXTERNAL DELTA V ?
			P40S/C		# NO CSTEER = ECSTEER
			HI6ZEROS	# YES CSTEER = ZERO
P40S/C		STODL	CSTEER
			FENG		# SET UP THRUST FOR S40.1
P40S/F		STODL	F		# P41 ENTERS HERE
			TIG		# ORIGINAL TIG MAY BE SLIPPED BY P40S/SV
		STODL	NOMTIG		# SET ORIGINAL TIME OF IGNITION FOR S40.9
			SEC29.96
		STORE	AVEGDT		# START AVERAGEG AT TIG-29.96
		CLEAR	EXIT
			BURNFLAG

TFIGINIT	TC	POSTJUMP	# START CLOKTASK TO
		CADR	STARTTGO	# CALCULATE TFI FOR N35/40
 +2		TC	BANKCALL
		CADR	R02BOTH		# IMU STATUS CHECK

## Page 694
# NAME	S40.1
#
# FUNCTIONAL DESCRIPTION
#	COMPUTE INITIAL THRUST DIRECTION (UT) AND INITIAL VALUE OF VG
#	VECTOR (VGTIG).
#
# SUBROUTINES CALLED
#	CSMPREC
#	INITVEL
#	CALCGRAV
#	MIDGIM
#
# ERASABLE INITIALIZATION REQUIRED
#	WEIGHT/G	ANTICIPATED MAG. OF VEHICLE MASS	SP 	B16 KGM
#	XDELVFLG	1=DELTA-V MANEUVER, 0=AIMPT STEER
#   IF DELTA-V MANEUVER:
#	DELVSIN		SPECIFIED DELTA-V REQUIRED IN
#			INERTIAL COORDS. OF ACTIVE VEHICLE
#			AT TIME OF IGNITION			VECTOR 	B7 M/CS
#	RTIG		POSITION AT TIME OF IGNITION		VECTOR 	B29 M
#	VTIG		VELOCITY AT TIME OF IGNITION		VECTOR 	B7 M/CS.
#	CSTEER = 0						DP
#   IF AIMPOINT STEERING:
#	TIG		TIME OF IGNITION			DP 	B28 CS
#	RTARG		POSITION TARGET TIME			VECTOR 	B29 M
#	TPASS4		TIME OF ARRIVAL AT AIMPOINT
#	CSTEER = ECSTEER (GR 0) 				DP 	B1
#	TPASS4 -- TIME OF ARRIVAL AT AIMPOINT
#
# OUTPUT
#	UT		1/2 UNIT VECTOR ALIGNED WITH THRUST DIRECTION IN REF COOR
#	VGTIG		INITIAL VALUE OF VELOCITY
#			TO BE GAINED (INERT. COORD.)		VECTOR 	B7 M/CS
#	DELVLVC		VGTIG IN LOC. VERT. COORDS.
#	F		NOMINAL THRUST FOR ENGINE		DP 	B7 M-NEWT
#	BDT		V REQUIRED AT TIG -V REQUIRED AT (TIG-2SEC)
#	-GDT		FOR S40.13				VECT 	B7 M/CS
#	RTIG		CALC IN S40.1B (AIMPT) FOR S40.2,3	VECTOR 	B29M
#			POSITION AT TIME OF IGNITION

		COUNT*	$$/S40.1
S40.1		TC	INTPRET
		SET	VLOAD
			FIRSTFLG
			HI6ZEROS
		STORE	BDT
		BOFF
			XDELVFLG
			S40.1B		# LAMBERT
		VLOAD	ABVAL		# EXTERNAL DELTA-V
			DELVSIN
		STOVL	DELVSAB
			VTIG
		STORE	VINIT
		VXV	UNIT
## Page 695
			RTIG
		STOVL	UT		# UP IN UT
			RTIG
		STORE	RINIT
		VSQ	PDDL
			36D
		DMPR	DDV
			THETACON
		DMP	DMP
			DELVSAB
			WEIGHT/G
		DDV
			F
		STOVL	14D
			DELVSIN
		DOT	VXSC
			UT
			UT
		VSL2	PUSH		# (DELTAV.UP)UP SCALED AT 2(+7) P.D.L. 0
		BVSU	PDDL		# DELTA VP SCALED AT 2(+7) P.D.L. 6
			DELVSIN
			14D
		SIN	PDVL
			6D
		VXV	UNIT
			UT
		VXSC	STADR
		STOVL	VGTIG		# UNIT(VP X UP)SIN(THETAT) IN VGTIG
		UNIT	PDDL		# UNIT(DELTA VP) IN P.D.L. 6
			14D
		COS	VXSC
		VAD	VXSC
			VGTIG
			36D
		VSL2 	VAD
		STADR
		STORE	VGTIG		# VG IGNITION SCALED AT 2(+7) M/CS
		UNIT
		STOVL	UT		# THRUST DIRECTION SCALED AT 2(+1)
			VGTIG
		PUSH	CALL
			GET.LVC		# VGTIG IN LV COOR AT 2(+7)M/CS IN DELVLVC

## Page 696
# NAME	S40.2,3
#
# FUNCTIONAL DESCRIPTION
#	COMPUTE GIMBAL ANGLES IF THRUSTING OCCURRED WITH PRESENT IMU
#	ORIENTATION, WINGS LEVEL SPACECRAFT, HEADS UP
#	COMPUTE X AXIS OF ENGINE BELL
#	COMPUTE PREFERRED IMU ORIENTATION (XSCREF)
#	FOR THIS CALCULATION, ASSUME X AXIS OF SC ALONG UT INITIALLY,
#	YSC=UNIT(XXR), ZSC=UNIT(XX(XXR)) AND ROTATE ENGINE BELL ALONG UT.
#	NEW SC AXES WILL BE APPROX. WINGS LEVEL AND NEW SC AXES IN REF.
#	COORDS. WILL BE PREFERRED IMU ORIENTATION.
#	COMPUTE DESIRED THRUST DIRECTION IN SM COORDS.
#
# SUBROUTINES CALLED
#	CALCGA
#
# ERASABLE INITIALIZATION REQUIRED
#	PACTOFF		TOTAL PITCH TRIM ANGLE			SP AT 1.0795111 REV.
#	YACTOFF		TOTAL YAW   TRIM ANGLE			SP AT 1.0795111 REV.
#	UT		DESIRED THRUST DIRECTION		VECT. 	B2 M/(CS.CS)
#	RTIG		POSITION AT TIME OF IGNITION		VECT. 	B29 M
#	ENG2FLAG	ON=RCS OFF=SPS
#
# OUTPUT
#	SCAXIS		UNIT VECT. ALIGNED WITH ENG BELL IN SC COOR.	B1
#	XSCREF		UNIT VECTORS ALIGNED WTH PREFERRED IMU		B1
#	YSCREF
#	ZSCREF
#	GIMBAL ANGLES IN THETAD
#	POINTVSM	UNIT VECT ALONG DESIRED THRUST DIRECTION IN SM	B1

		COUNT*	$$/S40.2
S40.2,3		VLOAD	MXV
			UT
			REFSMMAT
		VSL1	SETPD
			00D
		STODL	POINTVSM
			HI6ZEROS
		BON	PUSH
			ENG2FLAG
			S40.2,3B
		SLOAD	DMP
			YACTOFF
			TRIMSCAL
		SL1	DAD
			YBIAS
		PUSH	COS
		PDDL	SIN
		PUSH	SLOAD
			PACTOFF
		DMP	SL1
			TRIMSCAL
		DAD	PUSH
## Page 697
			PBIAS
		COS	PDDL		# COS(P +P0) PDL 6
		SIN	PUSH		# SIN(P +P0) PDL 8D
		STODL	ZSCREF		# SIN(P +P0)
			6
		DMP	SL1
			4
		DCOMP	PDDL		# -SIN(Y+Y0)COS(P+P0) PDL 10
			6
		DMP	SL1
			2
		VDEF
		STODL	XSCREF		# PD POINTER AT 6 NEW SC X AXIS SCALED AT 
			ZSCREF
		DMP	SL1
			4
		PDDL	DMP
			ZSCREF
			2
		SL1	DCOMP
		VDEF
		STODL	ZSCREF		# PD POINTER AT 4 NEW SC Z AXIS SCALED AT 2
		VDEF
		STODL	YSCREF		# PD POINTER AT 0 NEW SC Y AXIS SCALED AT 2
			ZSCREF
		PDDL	PDDL
			YSCREF
			XSCREF
		VDEF
		STOVL	SCAXIS		# ENGINE BELL SCALED AT 2
			UT
		PDVL	UNIT
			RTIG
		VXV	VCOMP
			0
		UNIT	PUSH
		CALL
			TSTRXUT
		VXV	VCOMP
			0
		VSL1	PDVL		# 2 RF/SC IN PDL 12D
			XSCREF
		VXM	VSL1
			0
		STOVL	XSCREF		# X OF PREF IMU,X OF SC IN REF COOR. AT 2
			YSCREF
		VXM	VSL1
			0
		STOVL	YSCREF		# Y OF PREF.IMU,Y OF SC IN REF COOR. AT 2
			ZSCREF
## Page 698
		VXM	VSL1
			0
		STORE	ZSCREF		# Z OF PREF. IMU,Z OF SC IN REF COOR. AT 2
		COUNT*	$$/P40

P40SXTY		SET	EXIT
			PFRATFLG
		TCR	SETMINDB -1	# NARROW DEADBAND FOR MANEUVER (EBANK6)
		TC	DOWNFLAG
		ADRES	3AXISFLG
		TC	BANKCALL
		CADR	R60CSM		# ATTITUDE MANEUVER
		TC	PHASCHNG	# COMPTGO DESTROYS
		OCT	00014		# 4.1 RESTART SETUP
		CS	ONE		# FOR UPDATEVG
		TS	NBRCYCLS
		TC	INTPRET
		BON
			ENG2FLAG	# P40 OR P41 ?
			P41/DSP
		VLOAD	ABVAL		# FOR R2
			VGTIG
		STODL	VGDISP
			HI6ZEROS
		STODL	DVTOTAL
			S40.8ADS
		STORE	AVEGEXIT
		EXIT
P40GMB		CAF	P40CKLS2	# (4.1 PROTECTION)
		TC	BANKCALL
		CADR	GOPERF1
		TCF	POST41		# V34
		TCF	TST,TRIM	# V33
TRIMONLY	CS	BIT1		# SET MRKRTEMP FOR GIMBAL TRIM (-1)
 +1		TS	MRKRTMP		# ENTRY FROM TST,TRIM
		CAF	ZERO		# SET CNTR  +0 FOR RESTART LOGIC IN S40.6
		TS	CNTR		#	+0 SAYS NORMAL ENTRY
					#	+1 (PRE40.6) SAYS RESTART ENTRY
		CAF	ONE
		TC	WAITLIST
		EBANK=	DAPDATR1
		2CADR	S40.6
		
		CCS	MRKRTMP		# TEST TO FIND TIME TO WAIT FOR GIMBAL TEST
		CAF	18SEC		# PLUS, DELAY FOR 18 SECONDS
		TCF	+2		# HOLE
		CAF	5SEC		# DELAY FOR TRIM ONLY TASK
		TC	BANKCALL
		CADR	DELAYJOB
		CAF	V06N40
## Page 699
		TS	NVWORD1		# FORCE CLOCKJOB
		TC	2PHSCHNG
		OCT	00026		# 6.2 = PRE40.6(-0CS), CLOKTASK(100CS)
		OCT	00234		# 4.23 = P40S/SV (PRIO12)
4P23SPT1	=	4.23SPOT
6P2SPT1		=	6.2SPOT
P40S/SV		TCR	E7SETTER	# JOB, 4.23 PROTECTS, PRIO12
		EBANK=	TIG
		TC	INTPRET
		DLOAD	DSU
			TIG
			AVEGDT		# 29.96 SEC (P40) 100.00 SEC (P15)
		STORE	TDEC1
		CALRB			# RETURN IN BASIC
			MIDTOAV1
		TC	P40SET		# P15 INTEGRATION ALWAYS RETURNS HERE
P40SNEWM	EXTEND			# INTEGRATION TIME GREATER THAN ALLOWED
		DCA	PIPTIME1
		DXCH	TIG
		EXTEND
		DCA	SEC29.96
		DAS	TIG		# SET NEW TIG FOR V06N40
P40SET		EXTEND
		DCA	MPAC		# DELTA TIME TO PREREAD
		DXCH	P40TMP
		EXTEND
		DCS	5SECDP		# FOR TIGBLNK
		DAS	P40TMP
		EXTEND
		DCA	P40TMP
		TC	LONGCALL
		EBANK=	TIG
		2CADR	TIGBLNK
		
		TC	PHASCHNG
		OCT	20214		# 4.21 = TIGBLNK (P40TMP CS)
4P21SPT1	=	4.21SPOT
		TCF	ENDOFJOB

TST,TRIM	CAF	BIT1		# SET UP FOR GIMB DRIVE TEST AND TRIM (+1)
		TCF	TRIMONLY +1

P40BLNKR	TC	BANKCALL
		CADR	CLEANDSP	# REMOVE RESIDUE
		TCF	ENDOFJOB

## Page 700
TIGBLNK		CAF	5SEC		# CALL TIGAVEG IN FIVE SEC AT TIG - AVEGDT
		TC	TWIDDLE
		ADRES	TIGAVEG
		CAF	ZERO		# DISABLE HERE, NOT IN P40BLNKR
		TS	NVWORD1
		CAF	PRIO14
		TC	NOVAC
		EBANK=	TIG
		2CADR	P40BLNKR	# DONT PROTECT - RESTARTS BLANK DSKY

		CS	OCT37		# 4.37 = TIGAVEG (500CS)
P40TSK		TC	NEWPHASE
		OCT	4
4P37SPT1	=	4.37SPOT
		TC	TASKOVER

		EBANK=	TIG
TIGAVEG		CAE	MODREG		# TASK (4.37 PROTECTS)
		MASK	BIT6
		EXTEND
		BZF	P15AVEG		# P15
		CS	PFRATBIT	# P40/P41
		MASK	FLAGWRD2
		TS	FLAGWRD2
		CAE	FLAGWRD1
		MASK	ENG2BIT
		CCS	A		# P40 OR P41 ?
		TCF	P41REDSP
		CAF	V06N40		# UNBLANK DISPLAY
		TS	NVWORD1
		CAF	SEC24.96
		TC	TWIDDLE
		ADRES	TIG-5
		CS	SIX		# 4.6 = TIG-5 (2496CS), PRECHECK (-0CS)
TTGPHS		TC	NEWPHASE	# ENTRY FROM P41REDSP (P41) WITH A=-4, OR
		OCT	4		#       FROM TIGON    (P47) WITH A=-2
4P2SPT1		=	4.2SPOT
4P4SPT1		=	4.4SPOT
4P6SPT1		=	4.6SPOT
PRECHECK	CCS	PHASE5		# HAS SERVICER BEEN RESTARTED
		TCF	TASKOVER	# YES, DONT START ANOTHER ONE
		TC	POSTJUMP
		CADR	PREREAD

P15AVEG		CAF	V06N95B
		TS	NVWORD1		# UNBLANK DISPLAY
		TCF	PRECHECK

## Page 701

		EBANK=	TIG
TIG-5		CAF	5SEC
		TC	WAITLIST
		EBANK=	DAPDATR1
		2CADR	TIG-0

		CS	BIT9		# WILL CAUSE V99 FLASH
		TS	NVWORD1
		TC	2PHSCHNG
		OCT	40074		# A, 4.7 = TIG-0 (500CS)
		OCT	00033		# A, 3.3 = S40.13 (PRIO20)
3P3SPT1		=	3.3SPOT
4P7SPT1		=	4.7SPOT
		TC	FINVAC20
		EBANK=	TGO
		2CADR	S40.13

		TCF	TASKOVER

## Page 702

		EBANK=	DAPDATR1	# TASK, 4.7 PHASE, OR 4.11 (-0CS IN R40)
TIG-0		CS	FLAGWRD7	# SET IGN FLAG
		MASK	IGNFLBIT
		ADS	FLAGWRD7
		CAE	FLAGWRD7	# CHECK ASTN FLAG FOR V99 RESPONSE
		MASK	BIT12
		EXTEND
		BZF	TASKOVER	# WAIT FOR V99P
		CAF	V06N40		# CLEAR THE V99 (IN CASE OF A RESTART
		TS	NVWORD1		#	DURING THE V99 SEQUENCE)
		TC	PHASCHNG	# V99P HAS COME ALREADY, DO IGNITION NOW
		OCT	00274		# A, 4.27 = IGNITION (-0CS) TBASE OLD
4P27SPT1	=	4.27SPOT
IGNITION	CAE	CDUX		# SAVE FOR ROLL DAP REFERENCE OGAD
		TS	OGAD		#	V99PJOB (CLOCKJOB) SETS UP IGNITION
		EXTEND			# 	TASK (4.61 PROTECTION)
		DCA	TIME2		#	FOR RESTARTS
		DXCH	TEVENT
		CS	FLAGWRD5	# SET ENGONFLG
		MASK	ENGONBIT
		ADS	FLAGWRD5
SPSON		CAF	BIT13		# TURN ON SPS ENGINE
		EXTEND
		WOR	DSALMOUT
		CS	FLGWRD10	# SET BURNFLAG TO INDICATE
		MASK	BURNBIT		# THAT THEN CSM DID THE BURN
		ADS	FLGWRD10

IMPULCHK	CAF	IMPULBIT	# CHECK FOR IMPULSIVE BURN
		MASK	FLAGWRD2
		CCS	A
		TCF	IMPLBURN	# IMPULSIVE
		CS	FLAGWRD6	# NON-IMPULSIVE, SET STRULLSW FOR STEERULL
		MASK	STRULBIT
		ADS	FLAGWRD6
PREPTVC		CS	DPCONFIG	# RESET T5 BITS
		MASK	FLAGWRD6
		TS	FLAGWRD6
		EXTEND			# KILL RCS
		DCA	T5IDL24
		DXCH	T5LOC
		CS	THREE		# 4.3 = DOTVCON (40CS)
		TC	NEWPHASE
		OCT	4
4P3SPT1		=	4.3SPOT
		TC	FIXDELAY
		DEC	40		# 0.4 SECOND DELAY FOR THRUST BUILDUP
DOTVCON		CS	BIT1		# SET TVCPHASE = TVCDAPON CALL (FRESHDAP)
		TS	TVCPHASE
## Page 703
		CAF	ZERO		# SET TVCEXECUTIVE PHASE
		TS	TVCEXPHS
		CS	DPCONFIG	# SET T5 BITS TO INDICATE TVC TAKEOVER....
		MASK	FLAGWRD6	#	BITS 15,14 = 10
		AD	DAP1BIT
		TS	FLAGWRD6
		CAF	THREE		# 6.3 = CLOKTASK (100CS), DROPPING PRE40.6
		TS	L		#	WHICH IS HANDLED NOW BY REDOTVC
		COM
		DXCH	-PHASE6
6P3SPT2		=	6.3SPOT
		EXTEND			# STORE RCS ATTITUDE ERRORS FOR USE IN
		DCS	ERRORY		# INITIALIZING TVC ATTITUDE ERRORS
		DXCH	ERRBTMP
		CS	FIVE		# 4.5 = DOSTRULL (160 CS)
		TC	NEWPHASE
		OCT	4
4P5SPT1		=	4.5SPOT
		CAF	POSMAX		# SET TIME5 FOR STARTING RIGHT AWAY
		TS	TIME5
		EXTEND
		DCA	TVCON2C		# (TVCDAPON)
		DXCH	T5LOC		# (KILLS RCS DAP)
		TC	FIXDELAY	# 0.4 + 1.6 = 2.0 SEC FOR ULLAGE-OFF AND
		DEC	160		# 	STEERING (IF NON-IMPULSIVE)
DOSTRULL	CS	FLAGWRD6	# CHECK STRULLSW FOR IMPULSIVE BURN
		MASK	STRULBIT
		CCS	A
		TC	ULAGEOFF	# ULLAGE OFF
STEERULL	CS	FLAGWRD2	# SET STEERSW
		MASK	STEERBIT
		ADS	FLAGWRD2
ULAGEOFF	CAF	ZERO
		EXTEND
		WRITE	CHAN5		# ZERO CHANNEL 5
		EXTEND
		DCA	NEG0		# KILL GROUP 4 (DP NEG0 = -0, +0)
		DXCH	-PHASE4
ENDIGN		TCF	TASKOVER

IMPLBURN	CS	STRULBIT	# RESET STRULLSW (COULD BE AN IMPULSIVE
		MASK	FLAGWRD6	#	ENGINE FAIL)
		TS	FLAGWRD6
		TCR	E7SETTER
		EBANK=	TIG
		EXTEND			# PREPARE FOR R1 OF V06N40 (CLOCKTASK)
		DCA	TGO
		DXCH	TIG
		EXTEND
		DCA	TIME2
## Page 704
		DAS	TIG
		TC	2PHSCHNG
		OCT	40053		# A, 3.5 = ENGINOFF (TGO+1)....NOTE GROUP
		OCT	07014		# C, DELTAT AND 2CADR FOLLOW FOR TASK BELO
3P5SPT1		=	3.5SPOT
		DEC	-0		# -0 CS
		EBANK=	DAPDATR1
		2CADR	IMPLCONT

		CAE	TGO +1		# (TPAGREE IN S40.13, LESS THAN 600CS)
		TC	TWIDDLE
		ADRES	ENGINOFF
IMPLCONT	CS	IMPULBIT	# RESET IMPULSW, ENGINOFF IS NOW SET UP
		MASK	FLAGWRD2
		TS	FLAGWRD2
		TCR	E6SETTER
		EBANK=	DAPDATR1
		TCF	PREPTVC
		
		EBANK=	TGO		# E7 FORCED BY 3.15SPOT VARIABLE DELTA-T
ENGINOFF	TCR	E6SETTER	# TASK, 3.15 PHASE (TGO+1 CS)	GET E6
		EBANK=	DAPDATR1
DOSPSOFF	TCR	SPSOFF		# SHUT DOWN SPS
		TC	FIXDELAY	# 2.5 SECOND DELAY FOR SPS TAILOFF
		DEC	250		# RESTART MAY DOUBLE THE DELAY, HIT TEVENT
DOTVCRCS	TCR	SETMAXDB	# WIDE DEADBAND FOR CUTOFF TRANSIENT
		TC	IBNKCALL	# SET UP RCS DAP (KILLS TVCDAPS, SETS T5
		CADR	RCSDAPON	#	BITS, WAITS 0.6SEC FOR TVCEXEC DIE)
		TC	IBNKCALL	# UPDATE WEIGHT/G AND MASS-PROPERTIES FOR
		CADR	MASSPROP	#	RCS DAP STARTUP IN 0.6 SECONDS
		TCR	TVCZAP		# WIPE OUT TVC, TURN OFF CLOKTASK
		TC	2PHSCHNG
		OCT	00003		# KILL GROUP 3 PROTECTION OF ENGINOFF
		OCT	00354		# A, 4.35 = POSTBURN (NOVAC, PRIO12)
4P35SPT1	=	4.35SPOT
		CAF	PRIO12		# SET UP POSTBURN V16N40 JOB
		TC	NOVAC
		EBANK=	DAPDATR1	# (SET MAXDB IN POST41)
		2CADR	POSTBURN

		TCF	TASKOVER

		EBANK=	DAPDATR1
SPSOFF		INHINT
		EXTEND			# ESTABLISH SPSOFF TEVENT
		DCA	TIME2
		DXCH	TEVENT
		CS	ENGONBIT	# RESET ENGONFLG
		MASK	FLAGWRD5
		TS	FLAGWRD5	# (RESTARTS WILL SHUT DOWN SPS NOW)
## Page 705
		CS	BIT13		# SHUT DOWN SPS ENGINE
		EXTEND
		WAND	DSALMOUT
		CAF	BIT14		# ISSUE SIV CUTOFF COMMAND
		EXTEND			# FOR POSSIBLE BACK-UP USE
		WOR	CHAN12
		CA	TVCPHASE	# CHECK IF OK FOR TRIM UPDATE
		AD	ONE		#	THESE CHECKS ARE ONLY NEEDED
		EXTEND			#	FOR A LESS THAN 0.4 SEC BURN
		BZF	BTRIMR		# NO, INITIALIZATION NOT COMPLETE
		CS	FLAGWRD6	# YES, CHECK IF TVC
		MASK	DPCONFIG
		EXTEND
		BZMF	BTRIMR		# NO, NOT TVC YET	
		CAE	REPFRAC		# NO TRIM UPDATES IF R40 (ENGFAIL) ACTIVE
		EXTEND
		BZF	BTRIMR
BESTTRIM	CAE	DELPBAR		# UPDATE TRIMS WITH DELFILTER VALUES
		TS	PACTOFF
		CAE	DELYBAR
		TS	YACTOFF
BTRIMR		TC	Q

## Page 706
		COUNT*	$$/S40.8
		EBANK=	CNTR
S40.81		VLOAD			# TGO LESS THAN 4 SECONDS
			HI6ZEROS
RATEZRO		STORE	OMEGAC		# TVC TO ATTITUDE HOLD
		EXIT
		CAF	POSMAX		# INHIBIT SWITCHOVER/TVC EG TRACKING
		TS	CNTR
		TCR	E7SETTER
		EBANK=	TIG
		INHINT
		EXTEND
		DCA	TIG
		DXCH	MPAC
		EXTEND
		DCS	TIME2
		DAS	MPAC
		TCR	DPAGREE
		CAE	MPAC +1		# (LESS THAN 6 (OR 4) SECONDS TO GO)
		EXTEND
		BZMF	+2
		TCF	+2
		CAF	ONE
		TS	TGO +1
		TC	TWIDDLE
		ADRES	ENGINOFF
		TC	2PHSCHNG
		OCT	40053		# A,3.5 = ENGINOFF (TGO+1)....NOTE GROUP
		OCT	10035		# B, 5.3 = REREADAC, AND START BELOW
3P5SPT2		=	3.5SPOT
5P3SPT2		=	5.3SPOT
CLEARSTR	TC	DOWNFLAG	# CLEAR IMPULSW, ENGINOFF IS NOW SET UP
		ADRES	STEERSW		# RESTARTS OK
		TCF	SERVXT

INCRSVG		EXIT			# ALARM INDICATING THAT THRUST IS POINTING
		TC	ALARM		# IN WRONG DIRECTION.
		OCT	01407
		TCF	SERVXT

		COUNT*	$$/R40
LOTHRUST	BOFF
			STEERSW
			SERVXT1		# NO STEERING. EXIT
R40CHECK	BON	VLOAD		# THRUST FAILURE (LO-OR-NO) INDICATED
			IDLEFAIL	# SET BY V97P. ALLOWS 1 BYPASS IN CASE OF
			SERVXT1		# UNFAVORABLE STEERING SYNCH
R40START		HI6ZEROS	# START OF ENGINE-FAIL (R40) OPERATIONS
		STORE	OMEGAC		# PUT TVC IN ATTITUDE HOLD
## Page 707
		EXIT
		EBANK=	DAPDATR1
		CS	ZERO
		TS	REPFRAC		# KILL TVCDAP CG TRIM TRACKING
		TS	NVWORD1		# SET UP ENGINE-FAIL V97FLASH (CLOCKJOB)
		TCF	CLEARSTR

## Page 708
		COUNT*	$$/P40
 -1		INHINT
TVCZAP		CS	OCT02202	# DISABLE TVC AND OPT ERR CNTRLS, REENGAGE
		EXTEND			#	OPTICS DAC
		WAND	CHAN12
		CS	BIT1		# ENABLE T4RUPT OPTICS MONITOR....PERMIT
		TS	OPTIND		#	OPTICS-ZERO BUT NOT OPTICS-DRIVE
		CAF	ZERO		# CLEAR NVWORD1 IN CASE CLOCKJOB WAITING
		TS	NVWORD1
		CS	TIMRBIT		# CLEAR TIMRFLAG TO STOP CLOKTASK
		MASK	FLAGWRD7
		TS	FLAGWRD7
		TC	Q

		EBANK=	DAPDATR1
POSTBURN	CAF	V16N40		# NOVAC, PRIO 12
		TC	BANKCALL
		CADR	REFLASH
		TCF	POST41		# V34 GO FINISH
		TCF	P40RCS		# PROCEED
		TCF	POSTBURN	# RECYCLE

		EBANK=	DAPDATR1
 -1		INHINT
SETMINDB	CA	CDUX		# ROUTINE FOR SETTING
		TS	THETADX		# THE MINIMUM DEADBAND
		EXTEND			# IN AUTOPILOT
		DCA	CDUY
		DXCH	THETADY
		CA	MINDB		# SHOULD BE CALLED UNDER
		TS	ADB		# INTERRUPT INHIBITED
		CS	BIT4		# EBANK = E6
		MASK	DAPDATR1
		TS	DAPDATR1
		TC	Q
		
		EBANK=	DAPDATR1
 -1		INHINT
SETMAXDB	CA	MAXDB		# ROUTINE FOR SETTING
		TS	ADB		# THE MAXIMUM DEADBAND IN AUTOPILOT
		CS	DAPDATR1
		MASK	BIT4		# SHOULD BE CALLED UNDER
		ADS	DAPDATR1	# INTERRUPT INHIBITED
		TC	Q		# EBANK = E6

## Page 709
		EBANK=	TIG
CLOKTASK	CAF	TIMRBIT		# IS TIMRFLAG SET
		MASK	FLAGWRD7
		CCS	A
		TCF	CLOCKON
		TC	PHASCHNG
		OCT	00006		# KILL RESTART
		TC	TASKOVER
CLOCKON		EXTEND
		DCA	TIME2
		DXCH	TTOGO
		EXTEND
		DCS	TIG
		DAS	TTOGO
SETCLOCK	CAF	1SEC
		TC	TWIDDLE
		ADRES	CLOKTASK
		CCS	NVWORD1
		TCF	+3
		TCF	SETTB6
		TCF	+1
		CS	V06N85B		# CHECK FOR V06N85B (P41)
		AD	NVWORD1
		EXTEND
		BZF	SETUPDYN	# V06N85, SO UPDATE N85 FOR DYNAMIC DISP
		CAF	PRIO27
		TC	NOVAC
		EBANK=	DAPDATR1
		2CADR	CLOCKJOB

SETTB6		CS	TIME1		# SET GROUP6 TIMEBASE
		TS	TBASE6
		TCF	TASKOVER

SETUPDYN	CAF	PRIO27		# SET UP A JOB TO UPDATE N85 (FOR P41=V06)
		TC	FINDVAC
		EBANK=	DAPDATR1
		2CADR	DYNDISP

		TCF	SETTB6		# CLOSE OUT CLOCKTASK

DYNDISP		TC	INTPRET		# UPDATE N85 FOR A DYNAMIC V06N85 IN P41.
		CALL			#	PRIOR TO BLANKING AND AVEG (V16N85)
			P40CNV85
		EXIT
		TCF	CKNVWRD1

## Page 710
		EBANK=	DAPDATR1
CLOCKJOB	CA	CDUX		# NOVAC, PRIO27
		TS	CDUSPOTX
		CA	CDUY
		TS	CDUSPOTY
		CA	CDUZ
		TS	CDUSPOTZ
		TC	BANKCALL
		CADR	QUICTRIG
CKNVWRD1	INHINT
		CCS	NVWORD1		# DETERMINE FUNCTION, INDICATED BY NVWORD1
		TCF	NOFLASH
		TCF	ENDOFJOB
		TCF	ENGREQST
FAILDSP		CAF	V06N40		# SPS ENGINE FAILED - FLASH V97
		TC	BANKCALL
		CADR	CLOCPLAY
		TCF	V97T		# TERMINATE
		TCF	V97P		# PROCEED
V97E		TC	PHASCHNG	# ENTER
		OCT	00534		# A, 4.53 = V97EJOB (PRIO 30 NOVAC)
4P53SPT1	=	4.53SPOT
					# IF RESTART, FORCE V97EJOB BEFORE CLOCKJOB
V97EJOB		CAF	V06N40		# REDISPLAY V06N40
		TS	NVWORD1
		TCR	E7SETTER
		EBANK=	TIG
		CS	OCT24		# FORCE R1 OF V06N40 TO READ  59X59
		TS	TIG
		TCR	E6SETTER
		EBANK=	CSMMASS
SPSOFF97	TCR	SPSOFF
		CAF	SEC2.5		# DELAY 2.5 SECONDS FOR POSSIBLE TAILOFF
		TC	BANKCALL
		CADR	DELAYJOB	# **** RESTART CAN DOUBLE DELAY ****
					# **** RESTART WILL ALTER TEVENT ****
V97E40.6	CAF	BIT1
		TC	WAITLIST
		EBANK=	CNTR
		2CADR	PRE40.6		# USE S40.6 RESTART ENTRY TO TRIM ENGINE

		TC	IBNKCALL	# RCS DAP IN 0.6SEC, SETTING T5 BITS TO
		CADR	RCSDAPON	#	KILL TVCEXEC/TVCROLLDAP STARTS.
					#	LEAVE NARROW DEADBAND FOR REIGNITE.
		TC	2PHSCHNG
		OCT	00026		# A, 6.2 = PRE40.6 (-0 CS), CLOKTASK (1 SEC)
		OCT	05024		# NOVAC BELOW, PRIO NEXT
		OCT	50777		# PRIO 27 NOVAC
## Page 711
6P2SPT2		=	6.2SPOT
QUICKIGN	TC	DOWNFLAG	# CLEAR ASTNFLAG AND SET IGNFLAG FOR
		ADRES	ASTNFLAG
		TC	UPFLAG		# AND SET IGNFLAG
		ADRES	IGNFLAG		# FOR IMMEDIATE V99 RESPONSE
V99FLASH	CS	BIT9		# CAUSE V99 TO FLASH
		TS	NVWORD1
		TC	2PHSCHNG
		OCT	40114		# A, 4.11 = TIG-0 (-0 CS) TBASE FOR PREPTVC
		OCT	00033		# A, 3.3 = S40.13 (PRIO 20)
3P3SPT2		=	3.3SPOT
4P11SPT1	=	4.11SPOT
		TC	FINVAC20	# SET UP TIMEBURN
		EBANK=	TGO
		2CADR	S40.13
		
ENDV97E		TCF	ENDOFJOB	# WAIT FOR CLOCKJOB (IMMEDIATE) REACTION

		EBANK=	CSMMASS
V97T		TC	PHASCHNG	# KILL CLOKTASK
		OCT	00076		# A, 6.7 = V97TJOB (PRIO 27 NOVAC)
6P7SPT1		=	6.7SPOT
V97TJOB		CAF	ZERO		# DISABLE CLOCKJOB
		TS	NVWORD1
		TCR	SPSOFF		# SHUTDOWN SPS ENGINE
		CAF	SEC2.5		# DELAY 2.5 SECS FOR POSSIBLE TAILOFF :
		TC	BANKCALL	# FALSE THRUST LOSS
		CADR	DELAYJOB	# **** RESTART CAN DOUBLE DELAY ****
					# **** RESTART WILL ALTER TEVENT ****
		INHINT
V97TRCS		TC	IBNKCALL	# RCS DAP IN 0.6SEC, SETTING T5 BITS TO
		CADR	RCSDAPON	#	KILL TVCEXEC/TVCROLLDAP STARTS
V99T		TC	2PHSCHNG	# (ENTRY FROM V97T FLOW TOO)
		OCT	00006		# KILL PRE40.6/CLOKTASK PROTECTION
		OCT	05024		# C, PRIORITY NEXT, JOB BELOW
		OCT	50777		# PRIO 27 NOVAC
V99TJOB		TCR	TVCZAP -1	# WIPE OUT TVC, CLOKTASK
POST41		EXTEND
		DCA	SERVCADR
		DXCH	AVEGEXIT
		TCF	GOTOPOOH

		EBANK=	CSMMASS
V97P		TC	PHASCHNG
		OCT	00134		# A, 4.13 = V97PJOB (PRIO 30 NOVAC)
4P13SPT1	=	4.13SPOT
					# IF RESTART, FORCE V97PJOB BEFORE CLOCKJOB
V97PJOB		CAF	V06N40		# REDISPLAY V06N40
		TS	NVWORD1
		TC	UPFLAG		# SET IDLEFAIL TO ALLOW R41-BYPASS, IN
## Page 712
		ADRES	IDLEFAIL	#	CASE OF UNFAVORABLE STEERING SYNCH
		TC	UPFLAG		# SET STEERSW TO RE-ENABLE STEERING
		ADRES	STEERSW
		CAF	2SECS
		TC	BANKCALL
		CADR	DELAYJOB	# WAIT 2 SECONDS
					# **** RESTART CAN DOUBLE DELAY ****
					# **** RESTART WILL ALTER TEVENT ****
R40ENABL	TC	DOWNFLAG	# RE-ENABLE R40 BY CLEARING IDLEFAIL
		ADRES	IDLEFAIL
		TC	PHASCHNG
		OCT	00004		# KILL GROUP 4
ENDV97P		TCF	ENDOFJOB


ENGREQST	CAF	V06N40
		TC	BANKCALL
		CADR	CLOCPLAY
		TCF	V99T		# TERMINATE
		TCF	V99P		# PROCEED
V99E		TC	2PHSCHNG	# ENTER
		OCT	00006		# KILL PRE40.6/CLOKTASK PROTECTION
		OCT	05024		# C, PRIORITY NEXT, JOB BELOW
		OCT	50777		# PRIO 27 NOVAC
V99EJOB		TCR	TVCZAP -1	# WIPE OUT TVC, CLOKTASK
P40RCS		EXTEND			# V16N40 ENTERS HERE
		DCA	ACADN85
		DXCH	AVEGEXIT
		CAF	2SECS
		TC	BANKCALL
		CADR	DELAYJOB
P40MINDB	TCR	SETMINDB -1
		RELINT
TIGNOW		TC	PHASCHNG
		OCT	05024		# TYPE C GROUP 4 BELOW FOR NOUN 85
		OCT	57777		# PRIO 20 NOVAC
		CAF	V16N85B
		TC	BANKCALL
		CADR	REFLASH
		TCF	POST41		# FINISH P40/P41
		TCF	MNKPST41
		TCF	TIGNOW		# V32 NOT GSOP RESPONSE BUT REDISPLAY N85

MNKPST41	EXTEND
		DCA	SERVCADR
		DXCH	AVEGEXIT
		TCF	MNKGOPOO

NOFLASH		CAE	NVWORD1		# DISPLAY NVWORD1 NORMALLY
		TC	BANKCALL
## Page 713
		CADR	REGODSP

		SETLOC	FFTAG12
		BANK

		COUNT*	$$/R40
E7SETTER	CAF	EBANK7
		XCH	EBANK
		EBANK=	TIG
		TC	Q
		
E6SETTER	CAF	EBANK6		# SET UP EBANK6
		XCH	EBANK
		EBANK=	DAPDATR1
		TC	Q
		
		SETLOC	P40S
		BANK

		COUNT*	$$/R40
		EBANK=	DAPDATR1
V99P		INHINT
		CAE	FLAGWRD7	# CHECK ASTN FLAG FOR PRIOR V99P
		MASK	ASTNBIT
		CCS	A
		TCF	V99P/TIG	# YES, THIS MUST BE A RESTART ENTRY
		
ASTNV99P	CAF	ASTNBIT		# SET ASTNFLAG
		ADS	FLAGWRD7
		CAE	FLAGWRD7	# CHECK IGN FLAG FOR TIG-0 ARRIVAL
		MASK	IGNFLBIT
		EXTEND
		BZF	V99P/TIG	# NO, CLEAR THE V99 AND WAIT FOR TIG-0
		
ENDV99P1	TC	TWIDBIT1	# TIG-0 HAS COME ALREADY SET UP IGNTN HERE
		ADRES	IGNITION
V99P/TIG	CAF	V06N40		# CLEAR THE V99 FLASH AND WAIT FOR TIG-0
		TS	NVWORD1
ENDV99P		TCF	ENDOFJOB

		COUNT*	$$/P40
## Page 714
V06N85B		VN	0685
V16N85B		VN	1685
V06N95B		VN	0695
V06N40		VN	0640
V16N40		VN	1640
V1683		VN	1683
OCT12		=	TEN
P40CKLS2	OCT	204
OCT27/24	=	VBSP3LD
OCT02202	OCT	02202		# BITS 2,8,11 FOR CHANNEL 12 TVC/OPTICS
#MINDB		DEC	46
MAXDB		DEC	455
SEC24.96	DEC	2496
18SEC		DEC	1800
5SECDP		DEC	0		# MAKE DP 5SEC
5SEC		DEC	500
SEC2.5		DEC	250
SEC29.96	2DEC	2996
FENG		2DEC	9.1188544 B-7	# SPS THRUST (20500LBS), SC.AT B+7 NEWT/E4

FRCS2		2DEC	.087437837 B-7	# RCS ULLAGE (199.6COS10 LBS), SC.AT
					#	B+7 NEWTONS/E+4
EP4(45)H	2DEC	.125

EP4(10)H	2DEC	.027777777

TRIMSCAL	2DEC	1.07975111 B-1

YBIAS		2DEC	+.00263888889	# YAW	MECH BIAS (+0.95 DEG, THRUST ON)

PBIAS		2DEC	-.00597222222	# PITCH	MECH BIAS (-2.15 DEG, THRUST ON)

					# REFERENCE, TRW 68.6520.3.3-40 27FEB,1968
		EBANK=	DAPDATR1
T5IDL24		2CADR	T5IDLOC
		
		EBANK=	TIG
ACADN83		2CADR	CALCN83

		EBANK=	TIG
SERVCADR	2CADR	SERVEXIT

		EBANK=	DAPDATR1
ACADN85		2CADR	CALCN85

		EBANK=	DAPDATR1
S40.8ADS	2CADR	S40.8

## Page 715
		EBANK=	DAPDATR1
TVCON2C		2CADR	TVCDAPON

## Page 716
		SETLOC	P40S3
		BANK
		COUNT*	$$/P40
AGAIN		STQ	CALL
			QTEMP1
			THISPREC
		SXA,2	SXA,1
			RTX2
			RTX1
		VLOAD	SETPD
			RATT
			00D
		STORE	RTIG
		STOVL	RINIT
			VATT
		STORE	VTIG
		STORE	VINIT
		SLOAD	PDDL
			HI6ZEROS
			EP4(45)H
		BON	DLOAD
			NORMSW
			+2
			EP4(10)H
		PUSH	CALL
			INITVEL
		SETPD	GOTO
			0
			QTEMP1

TSTRXUT		DLOAD	BHIZ
			36D
			BADVCTOR
		VLOAD	RVQ
			6D
BADVCTOR	VLOAD	UNIT
			RTIG
		PDVL	UNIT
			VTIG
		VSR3	VAD
		VXV	UNIT
			UT
		VCOMP
		STORE	6D
		RVQ

## Page 717

SETUP.9		BON	SLOAD
			FIRSTFLG
			SURELY.9
			NBRCYCLP
		NORM	VXSC		# (NORM HANDLES ZERO PROPERLY)
			X1
			BDT
		VSR*	VAD
			0 -14D,1
			VGTEMP
		VSU
			DELVSUM
		STORE	VGPREV
SURELY.9	EXIT
		CAF	PRIO10
		TC	FINDVAC
		EBANK=	DAPDATR1
		2CADR	S40.9
		
		TC	2PHSCHNG
		OCT	00051		# A, 1.5 = REDO40.9, PRIO 10
		OCT	10035
1P5SPT1		=	1.5SPOT
5P3SPT3		=	5.3SPOT
		TC	INTPRET
		VLOAD
			RN		# ACTIVE VEHICLE RADIUS VECTOR AT T1
		STOVL	RINIT
			VN		# ACTIVE VEHICLE VELOCITY VECTOR AT T1
		STODL	VINIT
			PIPTIME
		STORE	TNIT
		BDSU
			TPASS4
		STOVL	DELLT4
			HI6ZEROS
		STODL	DELVSUM
			HI6ZEROS
		STORE	NBRCYCLS
		GOTO
			VGCOMP

## Page 718
# NAME		S40.6 GIMBAL DRIVE TEST AND/OR GIMBAL TRIM
#
# FUNCTIONAL DESCRIPTION
#	GIMBAL DRIVE TEST....0,+2,-2,0 DEGREE ENGINE COMMANDS, AT 2 SECOND
#		INTERVALS, FIRST IN PITCH, THEN IN YAW. ASTRONAUT VERIFICATION
#		OF GIMBAL MOTION ON GPI
#	GIMBAL TRIM....AFTER A 4 SECOND DELAY, ENGINE COMMANDED TO
#		PRE-COMPUTED TRIM POSITION. ASTRONAUT VERIFICATION ON GPI.
#	PRE40.6....RESTART ENTRY TO RE-DO S40.6, ONLY IF RCS IS ON - IF TVC
#		IS NOT ON - PRIMARILY TO GET ACTUATORS TRIMMED FOR IGNITION.
#		BYPASS 4 SEC DELAY. SPEED IS CRITICAL NEAR IGNITION.
#		IF TVC IS ON (TVCDAPON OR LATER)  THEN REDOTVC WILL TAKE CARE
#		OF RESTARTING ACTUATORS.
#
# CALLING SEQUENCE....
#	WAITLIST, WITH 2CADR FOR S40.6 (OR PRE40.6), WITH EBANK= CNTR
#
# NORMAL EXIT MODE - FIXDELAY, TASKOVER
#
# SUBROUTINES CALLED....
#	FIXDELAY
#
# ERASABLE INITIALIZATION REQUIRED
#	CNTR = +0, NORMALLY SET BY THE P40 CALL AT TST,TRIM.
#	MRKRTMP....POSITIVE FOR GIMBAL DRIVE TEST AND GIMBAL TRIM (BOTH)
#		   NEGATIVE FOR GIMBAL TRIM ONLY
#	PACTOFF, YACTOFF SC.AT 85.41 ARCSEC/BIT (V48N48 P,YTRIM)
#	"SC CONT" SWITCH AT "CMC" (A/P CONTROL SWITCH AT "GNC")
#	ACTIVE SPS GIMBAL MOTOR POWER(S), PITCH, YAW
#
# OUTPUT
#	TVCYAW, TVCPITCH (BITS RELEASED)
#	TVC ENABLE  AND  OPTICS ERROR COUNTER ENABLE

		SETLOC	DAPS6
		BANK
		EBANK=	CNTR
		COUNT*	$$/S40.6
PRE40.6		CS	FLAGWRD6	# RESTART ENTRY TO S40.6 (DO NOT PERMIT
		MASK	DPCONFIG	# IF TVC, BITS 15,14 = 1,0)
		EXTEND
		BZMF	+2
		TCF	TASKOVER	# TVC, REDOTVC WILL REESTABLISH INTERFACE
		CS	BIT1		# RCS, SO DO S40.6, GIMTRIM ONLY
		TS	MRKRTMP
		CAF	BIT1		# FOR REVISED S40.6 TIMING FOR RESTARTS...
		TS	CNTR		# TO INDICATE A RESTART ENTRY (CNTR 1S
					#	NORMALLY +0, BY S40.6)
		EBANK=	CNTR
S40.6		CS	ZERO		# INHIBIT OPTICS ACTIVITY
		TS	OPTIND
		CS	BIT2		# DISABLE OPTICS ERROR COUNTERS
		EXTEND
		WAND	CHAN12
		
		CAF	OCT02200	# TVC ENABLE (SPS SERVO AMPS SEE DAC
## Page 719
		EXTEND			#	VOLTAGES) AND DISENGAGE OPTICS/DAC
		WOR	CHAN12
		TC	FIXDELAY	# 60MS PROCEDURAL DELAY (40MS MINIMUM) FOR
		DEC	6		#	RELAY LATCHING
		CAF	BIT2		# ENABLE OPTICS ERROR COUNTERS
		EXTEND
		WOR	CHAN12
		TC	FIXDELAY	# 20MS PROCEDURAL DELAY (4MS MINIMUM) FOR
		DEC	2		#	RELAY LATCHING
RSTRTST		CCS	CNTR		# CHECK FOR RESTART ENTRY (PRE40.6)
		TCF	GIMTRIM +2	# RESTART ENTRY....BYPASS 4 SECOND DELAY
					#	TST,TRIM SETS +0 ON NORMAL ENTRY			
		CAE	MRKRTMP		# CHECK FOR TEST/TRIM OR TRIM ONLY
		TS	CNTR		#	MRKRTMP SAVES CNTR FOR RESTARTS
		EXTEND
		BZMF	GIMTRIM		# (TRIM ONLY)
GDTSETUP	CS	ZERO		# GIMBAL DRIVE TEST SETUP, FOR PITCH
		TS	CNTR
GIMDTEST	CAF	+2ACTDEG	# GIMBAL DRIVE TEST, 1ST INCREMENT
		TC	OUTPUT		#	(LEAVES GIMBAL AT +2 DEG)
		CAF	-4ACTDEG	# 2ND INCREMENT (LEAVES GIMBAL AT -2)
		TC	OUTPUT
		CAF	+2ACTDEG	# 3RD INCREMENT (LEAVES GIMBAL AT -0)
		TC	OUTPUT
		CS	CNTR		# CHECK FOR COMPLETION OF YAW TEST.
		CCS	A
		TCF	GIMTRIM		# COMPLETED, GO TO GIMBAL TRIM ROUTINE
		CS	BIT1		# SET UP YAW TEST
		TS	CNTR
		TCF	GIMDTEST	# FOR YAW TEST
OUTPUT		EXTEND			# OUTPUT THE INCREMENT....SAVE Q
		QXCH	TEMPR60
		INDEX	CNTR
		TS	TVCPITCH
		INDEX	CNTR
		CAF	BIT11
		EXTEND
		WOR	CHAN14
		TC	FIXDELAY	# WAIT 2SEC, WHILE ASTRONAUT VERIFIES
		DEC	200		# 	GIMBAL MOTION ON GPI
		TC	TEMPR60
GIMTRIM		TC	FIXDELAY	# WAIT 4 SECONDS BEFORE GIMBAL TRIM
		DEC	400
 +2		CS	ZERO		# PICK UP TRIM VALUES AND OUTPUT THEM
		AD	PACTOFF		#	(AVOID +0) ENTRY POINT FROM RSTRTST
		TS	TVCPITCH	#	ON A RESTART, TO AVOID 4SEC DELAY
		CS	ZERO
		AD	YACTOFF
		TS	TVCYAW
		CAF	PRIO6		# RELEASE THE COUNTERS, BITS 11,12
## Page 720
		EXTEND
		WOR	CHAN14
ENDS40.6	TCF	TASKOVER

OCT02200	OCT	02200		# BITS 8,11 FOR CHANNEL 12 TVC/OPTICS
-4ACTDEG	DEC	-168		# -2(+2ACTDEG), WHOLE BITS, NO ROUNDUP
+2ACTDEG	DEC	+84		# +2 DEG, SC.AT 85.41 ARCSEC/BIT (+84D)

		
		SETLOC	P40S5
		BANK
		COUNT*	$$/S41.1		
S41.1		STQ	CALL
			QTEMP
			CDUTRIG
		VLOAD
		MXV	CALL
			REFSMMAT
			*SMNB*
		MXV	VXSC
			QUADROT
			TENBNK14	# VG IN CONTROL COORD IN MPAC SCALED AT
		VSL5	GOTO		# VG IN CONTROL COORDS. IN MPAC AT 2(+7)
			QTEMP
TENBNK14	2DEC	10. B-4

THETACON	2DEC	.31830989 B-8


# CALLED BY "DONOUN46" (VERB 48), OR DIRECTLY BY "FRESHDAP" (RCS DAP)

		SETLOC	DAPS6
		BANK
		COUNT*	$$/S41.2
S41.2		CA	DAPDATR1
		MASK	THREE
		AD	A
		TS	RATEINDX
		INHINT
		CAE	DAPDATR1	# IS LEM ATTACHED (BITS 14,13 OF DAPDATR1
		MASK	PRIO30		#			=10)
		AD	-BIT14		# (OCT57777)
		EXTEND
		BZF	TOGETHER	# YES
		CS	ATTCHBIT	# NO, UNSET FLAG
		MASK	FLAGWRD7
		TS	FLAGWRD7
		TCF	+4
TOGETHER	CS	FLAGWRD7	# ATTACHED, SET FLAG FOR INTEGRATION
		MASK	ATTCHBIT
## Page 721
		ADS	FLAGWRD7
		RELINT
		CA	DAPDATR1
		MASK	BIT4
		EXTEND
		BZMF	+2		# DEC 46 MEANS NARROW DB
		CA	DEC409
		AD	DEC46		# DEC 455 MEANS WIDE DB
		TS	ADB
		CA	DAPDATR1
		MASK	BIT7		# QUAD BD
		EXTEND
		BZMF	+2
		CA	ONE
		TS	XTRANS
		CA	DAPDATR1
		MASK	BIT10		# QUAD AC
		EXTEND
		BZMF	+2
		CS	ONE
		ADS	XTRANS
		INHINT
		EXTEND
		BZF	+5		# CLEAR NJETSFLG (4 JETS, OR NO JETS)
		CS	FLAGWRD1	# SET NJETSFLG 	 (2 JETS, AC OR BD QUADS)
		MASK	NJETSBIT	# NJETSFLG=1 FOR 2 JET ULLAGE (AC OR BD)
		ADS	FLAGWRD1
		TCF	+4
		CS	NJETSBIT	# NJETSFLG=0 FOR 4 JET (OR 0 JET) ULLAGE
		MASK	FLAGWRD1
		TS	FLAGWRD1
		RELINT
		CA	DAPDATR2
		MASK	BIT13
		EXTEND
		BZMF	+2
		TCF	+2
		CS	ONE
		COM
		TS	ACORBD		# MINUS FOR A-C, PLUS FOR B-D
		CA	DAPDATR2
		MASK	BIT10
		CCS	A
		TCF	+4
		CA	ONE
		TS	RACFAIL
		TCF	BDFAIL
		CA	ZERO
		TS	RACFAIL
		CA	DAPDATR2
## Page 722
		MASK	BIT4
		CCS	A
		TCF	BDFAIL
		CS	ONE
		TS	RACFAIL
BDFAIL		CA	DAPDATR2
		MASK	BIT7
		CCS	A
		TCF	+4
		CA	ONE
		TS	RBDFAIL
		TC	Q
		CA	ZERO
		TS	RBDFAIL
		CA	DAPDATR2
		MASK	BIT1
		CCS	A
		TC	Q
		CS	ONE
		TS	RBDFAIL
		TC	Q

## Page 723
		SETLOC	P40S1
		BANK
		EBANK=	NBRCYCLS
		COUNT*	$$/S40.1
S40.1B		DLOAD	DSU		# LAMBERT
			TIG
			TWODT
		STODL	TDEC1
			TPASS4
		DSU	
			TDEC1
		STCALL	DELLT4
			AGAIN
		VLOAD
			VIPRIME
		STODL	UT
			TIG
		STORE	TDEC1
		BDSU
			TPASS4
		STCALL	DELLT4
			AGAIN
		VLOAD	PUSH
			DELVEET3
		STCALL	VGTIG
			GET.LVC
		SETPD
			00D
CALCUT		VLOAD	CALL
			RTIG
			CALCGRAV	# GDELTAT IN MPAC AT 2(+7) M/CS
		VSL1	V/SC
			200CS		# G AT 2(-5) M/CS.CS
		PDVL	VSU
			VIPRIME
			UT
		V/SC	VSU
			200CS
		VXSC	VSL2
			CSTEER
		STOVL	12D		# B.C SCALED AT 2(-5) PDL 12D
			VGTIG
		UNIT	PUSH		# UG PDL 0 SCALED AT 2(+1)
		DOT	VXSC
			12D
			0
		VSL2	BVSU
			12D
		STODL	12D		# Q PDL SCALED AT 2(-5)
## Page 724
			F
		SRR	DDV
			4
			WEIGHT/G
		DSQ	PDVL		# F/MASS SQUARED PDL 6 AT 2(-10)M/(CS.CS)
			12D
		VSQ
		BDSU	SQRT
		VXSC	VSL1
		VAD	UNIT
			12D
		STCALL	UT
			S40.2,3		# **** NO RETURN **** SAME AS GOTO S40.2,3

		COUNT*	$$/S40.2
S40.2,3B	VLOAD
			XUNIT
		STOVL	SCAXIS
			UT
		STORE	XSCREF
		VXV	UNIT
			RTIG
		STCALL	6D
			TSTRXUT
		STORE	YSCREF
		VXV	VCOMP
			XSCREF
		VSL1
		STCALL	ZSCREF		# ZNB AXIS IN REF COOR
			P40SXTY		# **** NO RETURN **** SAME AS GOTO P40SXTY

## Page 725

# NAME		S40.8 - CROSS PRODUCT STEERING
# FUNCTION	(1) UPDATES THE VELOCITY-TO-BE-GAINED VECTOR.
#		(2) GENERATES ANGULAR RATE STEERING COMMANDS FOR AUTOPILOT.
#		(3) ESTABLISHES ENGINE CUT-OFF SIGNALS AT APPROPRIATE TIMES.
#		(4) INITIATES THRUST-FAIL ROUTINE, R40
#		(5) UPDATES CSMMASS
#
# INPUT		VGPREV  - LAST VALUE OF THE VELOCITY-TO-BE-GAINED VECTOR
#			  PRIOR TO UPDATING IN METERS/CS AT +7.
#		DELVREF - CHANGE IN VEHICLE VELOCITY SINCE LAST MEASUREMENT
#			  IN METERS/CS AT +7.
#		BDT	- EFFECT OF RATE OF CHANGE OF REQUIRED VELOCITY AND
#			  GRAVITY DURING DT UPON VELOCITY-TO-BE-GAINED IN
#			  METERS/CS AT +7.
#		CSTEER	- A SCALAR OF THE STEERING LAW, SC.AT B+1, USED FOR
#			  SPS AIMPOINT STEERING MANEUVERS
#		IDLEFAIL- A FLAG TO INHIBIT (IDLE) THE THRUST-FAIL ROUTINE
#		STEERSW	- A SWITCH TO PRECLUDE NEEDLESS CONDUCT OF STEERING
#		REFSMMAT, DAPDATR1, PIPTIME
#		EREPFRAC, ETDECAY, KPRIMEDT FOR TVC
#
# OUTPUT	TTOGO	- TIME REMAINING FOR ENGINE BURN IN CS AT +28
#		OMEGAC	- DP VECTOR RATE COMMAND, SC.AT 1/(2TVCDT) REVS/SEC
#		VG, VGPREV, VGDISP, TGO, TIG, SCALED AS NOTED IN CODING
#		STEERSW, IMPULSW, NVWORD1
#		REPFRAC, CNTR, VCNTR, VCNTRTMP FOR TVC (R40 INTERFACING)
#
# SUBROUTINES USED  	- *SMNB*, ALARM

		EBANK=	DAPDATR1
		COUNT*	$$/S40.8
S40.8		TC	INTPRET
		SETPD	CALL
			00D
			UPDATEVG
		DLOAD
			CSMMASS		#				KG	B-16
		STORE	MASSTMP
		EXIT
		TC	PHASCHNG
		OCT	10035		# TYPE B RESTART RESTART BELOW AND 5.3 REREADAC
5P3SPT4		=	5.3SPOT
		TC	INTPRET
		VLOAD	ABVAL
			DELVREF		# DELTA V			M/CS	B-7
		PUSH	SLOAD		# 00D = DELTA V MAG		M/CS	B-7
			DVTHRESH	# 				M/CS	B+2
		DMP	BDSU
			DPB-9		# DVTHRESH			M/CS	B-7
LOCHECK		BMN	SLOAD
			LOTHRUST	# ** MAYBE THRUST BAD **
					# THRUST GOOD : UPDATE CSMMASS
			EMDOT		# FLOW RATE			KG/CS	B-3
## Page 726
		DMP	BDSU
			FOURSEC +1	# 20D B-13 : MPAC = 2 SECS MASS LOSS
			MASSTMP
UPD8MASS	STORE	CSMMASS		# CSMMASS UPDATED FOR LAST 2 SECS
		BOFF
			STEERSW		# NO STEERING :
			SERVXT1		# BYPASS TGOCALC AND X-PRODUT
CGTRACK		BON	EXIT		# ENABLE TVCDAP CG TRACKING
			SWTOVER
			FREPSET		# V46 SWITCHOVER HAS OCCURRED (CSM/LM)
		CAE	DAPDATR1	# ENABLE TVCDAP CG TRACKING
		MASK	BIT14
		CCS	A
		CAF	BIT1
		INDEX	A		# LM-OFF, LM-ON VALUE
		CAE	EREPFRAC
REPFRACS	TS	REPFRAC
		
		TC	INTPRET
TGOCALC		VLOAD	BVSU		# GET DELVG
			DELVREF
			BDT
		UNIT
		DOT	PUSH		# (00D)
			VG
		BPL	DDV		# ANGLE SHOULD BE GREATER THAN PI/2
			INCRSVG		#	DISPLAY ALARM IF NOT
			2VEXHUST
		DAD	DMP		# (DOT PRODUCT UP FROM 00D)
			LODPHALF
		NORM	SR1
			X1
		PDDL	NORM
			36D		# (MAG DELVG)
			X2
		BDDV
		XSU,2	SL*
			X1
			0 -9D,2
		DMP	PUSH		# (00D)
			-FOURDT
		SLOAD	SR
			ETDECAY		# ETDECAY SC.AT B+14 CS
			14D
		BDSU	STADR
		STORE	TGO		# TIME TO GO IN CS. AT +28
		DAD
			PIPTIME
		STODL	TIG
			TGO
## Page 727
		DSU	BMN
			FOURSEC
			S40.81
			
XPRODUCT	VLOAD	VXSC
STEERING		BDT
			CSTEER
		VSL2	VSU
			DELVREF
		UNIT	PDVL
			VG
		UNIT	VXV
		MXV	CALL
			REFSMMAT	# (REFSMMAT/2)
			*SMNB*
		VXSC
			KPRIMEDT	# (KPRIMEDT SCIAT PI/8 RAD)
OMEGACLC	STCALL	OMEGAC
			SERVXT1
FREPSET		DLOAD	EXIT		# POST-SQITCHOVER CSM/LM.  LOAD FROM LOW-
			FREPFRAC	#	BANDWIDTH PARAMETER IN FIXED MEMORY
		CAE	MPAC
		TCF	REPFRACS

## Page 728

UPDATEVG	STQ	BON
			R61CNTR
			XDELVFLG
			VGCOMP
		SLOAD	BMN
			NBRCYCLS
			SETUP.9
		VLOAD	VAD
			DELVSUM
			DELVREF
		STORE	DELVSUMP
		EXIT
		CA	ONE
		AD	NBRCYCLS
		TS	NBRCYCLP
		TC	PHASCHNG	# TYPE B RESTART RESTART BELOW AND 5.3 REREADACCS
		OCT	10035
5P3SPT5		=	5.3SPOT
		CA	NBRCYCLP
		TS	NBRCYCLS
		TC	INTPRET
		VLOAD
			DELVSUMP
		STORE	DELVSUM
VGCOMP		VLOAD
			DELVREF		# CONSTRUCT DELVG, SC.AT B-7 M/CS
		BVSU	VAD
			BDT
			VGPREV
		STORE	VG		# VELOCITY-TO-BE-GAINED, SC.AT B-7  M/CS
		ABVAL
		STORE	VGDISP		# FOR DISPLAY PURPOSES
		EXIT
		TC	PHASCHNG
		OCT	10035		# TYPE B RESTART RESTART BELOW AND 5.3 REREADACCS
5P3SPT6		=	5.3SPOT
		TC	INTPRET
		VLOAD
			VG
		STCALL	VGPREV
			R61CNTR

## Page 729

# NAME		S40.9 - VTOGAIN (AIMPOINT MANEUVERS ONLY)
#
# FUNCTION	(1) GENERATES REQUIRED VELOCITY AND VELOCITY-TO-BE-GAINED
#		VECTORS FOR USE DURING AIMPOINT MANEUVERS
#		(2) UPDATES THE B VECTOR WHICH IS USED IN THE FINAL 
#		CALCULATION OF EXTRAPOLATING THE VELOCITY-TO-BE-GAINED
#
# CALLING SEQ	VIA FINDVAC AS NEW JOB.
#
# INPUT		RNIT	- ACTIVE VEHICLE RADIUS VECTOR IN METERS AT +29.
#		VNIT	- ACTIVE VEHICLE VELOCITY VECTOR IN METERS/CS AT +7
#		VRPREV	- LAST COMPUTED VELOCITY REQUIRED VECTOR IN
#			  METERS/CS AT +7.
#		NOMTIG	- TIME OF IGN. USED IN TARGETTING ROUTINES B+28
#		DELLT4	- TRANSFER TIME FROM PIPTIME TO TARGET B+28
#		TNIT	- TIME OF RNIT AND VNIT IN CS AT +28
#		GDT/2	- HALF OF VELOCITY GAINED IN DELTA T TIME DUE TO
#			  ACCELERATION OF GRAVITY IN METERS/CS AT +7.
#		DELVREF	- CHANGE IN VELOCITY DURING LAST 2 SEC IN
#			  METERS/CS AT +7.
#		NORMSW	SET=CENTRAL ANGLE BETWEEN RTARG AND RTIG IS BETWEEN
#			165 TO 195 DEGREES
#			RESET=CENTRAL ANGLE OUTSIDE CONE DESCRIBED ABOVE
#
# OUTPUT	VGTEMP	- VELOCITY TO BE GAINED VECTOR IN METERS/CS AT +7.
#		COGA	- INPUT OF INITIAL GUESS FOR LAMBERT FROM S40.1
#			  OR PREVIOUS PASS THRU S40.9
#		GOBL/2	- OBLATENESS TERM IN AVG GRAV CALC - GOBL*RSQ/MU
#		VRPREV	- VELOCITY REQUIRED VECTOR IN METERS/CS AT +7.
#		BDT	- B VECTOR IN METERS/CS AT +7.
#
# SUBROUTINES USED  -  INITVEL

		COUNT*	$$/S40.9
S40.9		TC	INTPRET
		SETPD	DLOAD
			00D
			LO6ZEROS
		PDDL	BON
			EP4(45)L
			NORMSW
			+3
		DLOAD
			EP4(10)L
		PUSH
		CLEAR	CALL
			GUESSW
			HAVEGUES
		EXIT
		TC	PHASCHNG	# SAVE TIME BY NOT REDOING LAMBERT CALCS
		OCT	05021		# C, PRIORITY NEXT, JOB BELOW
		OCT	10000
		TC	INTPRET
ENDLAMB		BON	VLOAD
			FIRSTFLG
## Page 730
			FIRSTTME
			VIPRIME
		VSU	PDDL
			VRPREV
			TNIT
		DSU	SL
			TNITPREV
			17D
		BDDV	VXSC
			200CS
		VSU	VSL1
			GDT/2
		STORE	BDT
FIRSTTME	SLOAD	DCOMP
			RTX2
		BMN
			MOONCASE
		VLOAD	UNIT
			RN
		DLOAD	DSU
			PIPTIME
			NOMTIG
		DMP	DDV
			EARTHMU
			34D
		VXSC	VAD
			GOBL/2
			VGTEMP		# NOTE  NO TEST IS MADE TO SUBTRACT GOBL
		STORE	VGTEMP		# INSIDE 165-195 DEGREE CONE AREA.
MOONCASE	EXIT
		TC	PHASCHNG
		OCT	04021		# C, JOB BELOW
COPY40.9	TC	INTPRET
		DLOAD
			TNIT
		STOVL	TNITPREV
			VIPRIME
		STORE	VRPREV
		CLEAR	EXIT
			FIRSTFLG
 -2		CS	ONE		# REDO40.9 (RESTART) ENTRY TO END S40.9
		TS	NBRCYCLS
ENDS40.9	TC	PHASCHNG
		OCT	00001
		TCF	ENDOFJOB

REDO40.9	TC	INTPRET		# S40.9 RESTARTS COME HERE TO GRACEFULLY
		VLOAD			#	TERMINATE S40.9 SO THAT IT CAN BE
			LO6ZEROS	#	SET UP WITH LATEST R,V,T NEXT PASS
		STODL	DELVSUM		#	(TYPE C PHASE POINTS '04021' WILL
## Page 731
			LO6ZEROS	#	FORCE NORMAL S40.9 TERMINATIONS,
		STOVL	NBRCYCLS	#	RATHER THAN LOSE TIME OF BRAND NEW
			VGPREV		#	PASS -- QUICK OLD DATA BETTER THAN
		STORE	VGTEMP		#	NONE) NOW CAN GO THRU SETUP.9
		EXIT			#	WITHOUT DISTURBING VGPREV
		TCF	ENDS40.9 -2	# STORE 0,0 COVERED NBRCYCLS,P -- FIX UP S
		
EARTHMU		2DEC*	-3.986032 E10 B-36*

EP4(45)L	2DEC	.125

EP4(10)L	2DEC	.027777777

200CS		2DEC	200 B-12

-FOURDT		2DEC	-800 B-18	# -4(200CS), AT B+18CS (-4 FOR SCALING)

FOURSEC		2DEC	400.0 B-28	# 4 SEC

TWODT		2DEC	200.0 B-28	# **** MUST FOLLOW 2DEC FOURSEC TO   ****
					# **** MAKE FOURSEC +1 2DEC 200 B-13 ****

DPB-9		2DEC	1 B-9

## Page 732

# NAME:  		S40.13 - TIMEBURN
#
# FUNCTION		TO DETERMINE
#			(1) WHETHER A GIVEN COMBINATION OF VELOCITY-TO-
#			BE-GAINED AND ENGINE CHOICE RESULT IN A BURN TIME SUFFICIENT 
#			TO ALLOW STEERING AT THE VEHICLE DURING THE BURN
#			(2) THE MAGNITUDE OF THE RESULTING BURN TIME, AND
#			(3) IF THE BURN TIME IS < 6 SECONDS,
#			THE ASSOCIATED TIME OF THE ENGINE-OFF SIGNAL.
#
# CALLING SEQUENCE	VIA FINDVAC AS A NEW JOB.
#
# INPUT			VGTIG 	 - MAGNITUDE OF VGTIG IN METERS/CS) AT +7
#			WEIGHT/G - MASS OF VEHICLE IN KG AT TIG (+16)
#			F 	 - ENGINE THRUST IN M.NEWTONS AT +7
#			MDOT 	 - RATE OF DECREASE OF VEHICLE MASS DURING 
#				   BURN IN KG/CS AT +3
#
# OUTPUT		IMPULSW	 - ZERO FOR STEERING
#				 - ONE FOR ATTITUDE HOLD
#			TGO	 - BURN TIME IN CS AT +28
#
#	THE QUANTITY M.NEWTON SHALL BE USED TO EXPRESS WEIGHT IN TERMS OF
#	(KILOGRAM*METER)/(CENTISECOND*CENTISECOND)
#	(1) M.NEWTON = (10000) NEWTONS

		COUNT*	$$/40.13
S40.13		CAF	BIT7		# TEST +X TRANSLATION
		EXTEND
		RXOR	CHAN31
		MASK	BIT7
		TS	MPAC +3
		TC	INTPRET
		DLOAD	PUSH		# 00D = |VGTIG| AT +7
			VGDISP
		SLOAD	BZE
			MPAC +3		# BIT7 CHAN31
			S40.130 +1	# DO NOT COMPENSATE FOR 7 SECS OF ULLAGE
		DLOAD	DDV
			S40.135		# COMPENSATION FOR 2 JET ULLAGE AT +24
			WEIGHT/G	# MASS IN KGMS AT +16
		BON	SL1		# DOUBLE CORRECTION IF FOUR JETS
			NJETSFLG
			S40.130
S40.130		BDSU	PUSH		# 00D = MAG(VGTIG) @ B+7 M/CS, ADJUSTED 
					#	FOR ULLAGE.
 +1		DLOAD	DDV		# ENTRY POINT IF ULLAGE OFF
			00D		# MAKE SURE MPAC CONTAINS MAG(VGTIG)
			2VEXHUST	# 2 VEXHUST (=2G ISP) @ B+7 M/CS
		SR1	BDSU
			LODPHALF	# 0.5
		DMP	DMP
			WEIGHT/G	# TOTAL MASS @ B+16 KG
			00D		# MAG(VGTIG) @ B+7 M/CS
		SL	BOV
			10D		# SCALING
## Page 733
			S40.133		# LARGE VG : STEERING BURN INDICATED
		DSU	DMP
			EIMP1SEC	# IMP BURN LOGIC B.P. @ E+2B+14 NEWT-SEC
			100B-14		# 1SEC @ B+14CS
		DDV	PUSH		# 02D=(DELTET-1SEC) @ B+14CS, FIMP16 SLOPE
			EFIMP16		# IMP B.LOGIC 1-6SEC SLOPE @ E+2B+14 NEWT
		DSU	BPL
			500B-14		# 5SEC @ B+14CS
			S40.133		# STEERING BURN INDICATED, DELTAT > 6 SEC
		DLOAD	BPL
			02D		# (DELTAT-1SEC) @ B+14CS, FIMP16 SLOPE
			S40.132		# 1<DELTAT<6SEC, SO FIMP16 SLOPE USE IS OK
		DMP	DDV		# 0<DELTAT<1SEC, SO USE FIMP01 NOT FIMP16
			EFIMP16		# IMP B.LOGIC 1-6SEC SLOPE @ E+2B+14 NEWT
			EFIMP01		# IMP B.LOGIC 0-1SEC SLOPE @ E+2B+14 NEWT
S40.132		SET	EXIT
			IMPULSW		# IMPULSIVE BURN
		TC	DPAGREE
		TC	INTPRET
		DAD	SR		# MPAC CONTAINS (DELTA-1SEC), GET DELTAT
			100B-14		# 1SEC @ B+14CS
			14D		# DELTAT @ B+28CS
		STORE	TGO
S40.133		EXIT
		TC	PHASCHNG
		OCT	3
		TCF	ENDOFJOB
		
		COUNT	17/40.13

100B-14		2DEC	100.00 B-14	# 1SEC @ AT B+14CS

1SEC2D		=	100B-14

500B-14		2DEC	500.00 B-14	# 5SEC @ AT B+14CS
5SECOND		=	500B-14
S40.135		2DEC	69.6005183 B-23	# IMPULSE FROM 7.96 SECS OF 2-JET FIRING
					# 	7.96 (199.6)COS(10) LB-SEC, SC.AT
					#	B+23 NEWTON-SEC/E+2 (7 SEC ULLAGE
					#	TO GO, PLUS 0.96 SEC FROM PIPTIME)

2VEXHUST	2DEC	63.020792 B-7	# 2(10338.0564 FPS), SC.AT B+7 M/CS

		SBANK=	LOWSUPER
		SETLOC	DAPS6
		BANK

		COUNT*	$$/40.14
DEC409		DEC	409
DEC46		DEC	46

## Page 734

# CALLED BY "DONOUN47" (VERB 48), OR DIRECTLY BY "FRESHDAP" (RCS DAP)

		EBANK=	DAPDATR1
S40.14		CAE	IXX		# RCS ENTRY
		EXTEND
		MP	CONTONE
		TS	J/M
		CA	IAVG
		EXTEND
		MP	CONTONE
		TS	J/M1
		TS	J/M2
		EXTEND
		DCA	CONTTWO
		EXTEND
		DV	IXX
		TS	KMJ
		EXTEND
		DCA	CONTTWO
		EXTEND
		DV	IAVG
		TS	KMJ1
		
		TS	KMJ2
		TC	Q
		
CONTONE		DEC	.662034		# 2PI/M
CONTTWO		2DEC	.00118

		SETLOC	DAPS3
		BANK
		COUNT*	$$/RCSUP
RCSUP		LXCH	BANKRUPT
		EXTEND
		QXCH	QRUPT
		TCR	RCSDAPON	# ACTIVATE RCS DAP
		TCF	RESUME
		
		EBANK=	DAPDATR1
RCSADDR		2CADR	RCSATT

0.6SECT5	OCT	37704

		EBANK=	DAPDATR1
					# RCSDAPON ENTRY MUST BE UNDER INT-INHIBIT
RCSDAPON	CAF	0.6SECT5	# 0.6 SEC ALLOWS TVCEXEC/ROLLDAP TO DIE
## Page 735
 +1		TS	TIME5		# ENTRY FROM ROOTOPOO
		TS	T5PHASE		# WILL CAUSE FRESHDAP (+1)
		CS	RCSFLAGS	# SET BIT3 TO REINITIALIZE FDAI ERROR
		MASK	BIT3		#	DISPLAY, IN CASE SC CONT SWITCH
		ADS	RCSFLAGS	#	IN SCS NOT GNC (GUIDEMODE PRIMARY)
		EXTEND
		DCA	RCSADDR		# (RCSATT)
		DXCH	T5LOC
		CS	DPCONFIG	# SET BITS 15,14 TO 01 TO INDICATE
		MASK	FLAGWRD6	#	T5 TAKEOVER BY RCSDAP
		AD	DAP2BIT
		TS	FLAGWRD6	# KILLS TVCEXEC AND ROLLDAP STARTS
		TC	Q		# RETURN TO CALLER (TVCDAPOFF OR RCSDAPUP)
		SETLOC	P30S1
		BANK
		COUNT*	$$/P40
STARTTGO	TC	COMPTGO		# COMPTGO CAN NOT BE CALLED DIRECTLY
		TC	POSTJUMP	# VIA BANKCALL DUE TO RESTART PROBLEMS
		CADR	TFIGINIT +2

## Page 736

# NAME:  	P41 - RCS BURN
#
# FUNCTION	TO CONTROL THE SEQUENCE OF THE CMC DURING THE COUNTDOWN
#		AND THRUSTING MANEUVER OF AN RCS BURN
#
#			R02BOTH		CHECK STATUS OF IMU
#
#			S40.1		COMPUTE: INITIAL THRUST DIRECTION AND
#						 INITIAL VALUE OF VELOCITY-TO-BE-
#						 GAINED VECTOR (VGTIG)
#
#			S40.2,3		COMPUTE: GIMBAL ANGLES IF THRUSTING WILL
#						 OCCUR WITH PRESENT IMU ORIENTATION,
#						 PREFERRED IMU ORIENTATION, AND
#						 DESIRED THRUST DIRECTION IN SM COORDS
#
#			R60CSM		PERFORM ATTITUDE MANEUVER
#
#			MIDTOAV1	EXTRAPOLATE CSM STATE VECTOR TO TIG-29.96 SECS
#
#			CLOKTASK	COMPUTE TIME-TO-GO TO IGNITION, 
#					RECALL CLOKTASK, 
#					UPDATE N 85, AND
#					CALL CLOCKJOB TO DISPLAY V06N85
#
#			TIGBLNK		BLANK DSKY AT TIG-35 SECS AND
#					WAITLIST TIGAVEG IN 5 SECS
#
#			TIGAVEG		UNBLANK DSKY,
#					CAUSE CLOCKJOB TO DISPLAY NON FLASH V16N85,
#					WAITLIST TTG/0 IN 29.96 SECS, AND
#					START SERVICER
#
#			CLOCKJOB	(CALLED EVERY SEC)
#					DISPLAY NON FLASH V06N85 UNTIL TIG - 29.96:
#					THEN DISPLAY NON FLASH V16N85
#
#			TTG/0		NOVAC TIGNOW
#
#			TIGNOW		DISPLAY FLASHING V16N85
#
#			POST41		CLEAN UP AFTER BURN
#
#			*************************************************
#			PROVIDE RESTART PROTECTION AT ALL CRITICAL POINTS
#			*************************************************
#
# INPUT		SAME AS P40
#
# ALARMS	1703		INSUFFICIENT TIME FOR INTEGRATION
#				TIG WAS SLIPPED

## Page 737
		EBANK=	DAPDATR1
		SETLOC	P40S
		BANK
		COUNT*	$$/P41
P41CSM		TC	INTPRET
		SET	DLOAD
			ENG2FLAG	# SET FOR RCS
			HI6ZEROS	# CSTEER = 0 FOR P41
		STORE	CSTEER
		DLOAD	BON
			FRCS2		# 2JET THRUST FOR S40.1
			NJETSFLG
			P40S/F		# NJETS = 1 2-JET
		SL1	GOTO		# NJETS = 0 4-JET
			P40S/F			
		EBANK=	DAPDATR1
CALCN85		TC	INTPRET
		CALL
			UPDATEVG	# NEW VG FROM VCOMP (+ MAYBE S40.9)
		CALL
			P40CNV85	# COMPUTE VGBODY
SERVXT1		EXIT
		CAF	NEJETBTS
		EXTEND
		RXOR	CHAN31		# ARE ANY RCS JETS FIRING
		MASK	NEJETBTS	# NULLING OUT RESIDUAL VG'S FROM P40?
		EXTEND			# OR PERFORMING P41?
		BZF	SERVXT		# NO

		TC	UPFLAG		# YES - SET BURNFLAG TO INDICATE
		ADRES	BURNFLAG	# THAT THE CSM DID THE BURN

SERVXT		TC	POSTJUMP
		CADR	SERVEXIT

NEJETBTS	OCT	07700

TTG/0		CAF	PRIO20		# TASK (4.4 PROTECTS IN P41)
		TC	NOVAC
		EBANK=	DAPDATR1
		2CADR	TIGNOW
		
P40CLK		TC	DOWNFLAG
		ADRES	TIMRFLAG
		TCF	TASKOVER
		
P41/DSP		CALL			# COMPUTE
			P40CNV85	#	VGTIG IN CTRL COORDS
		EXIT
## Page 738
		EXTEND			# DO CONTROL COORD CALCULATION AFTER AVEG
		DCA	ACADN85
		DXCH	AVEGEXIT
		CAF	V06N85B
		TS	NVWORD1		# FORCE CLOCKJOB
		TC	2PHSCHNG
		OCT	40036		# 6.3=CLOKTASK(100CS)
		OCT	234		# 4.23=P40S/SV(PRIO12)
4P23SPT2	=	4.23SPOT
6P3SPT3		=	6.3SPOT
		TCF	P40S/SV
P41REDSP	CAF	V16N85B		# ENTER FROM P41 SIDE OF TIGAVEG
		TS	NVWORD1		# REDISPLAY NONFLASHING
		CAF	SEC29.96 +1
		TC	TWIDDLE
		ADRES	TTG/0
		CS	BIT3		# 4.4 = TTG/0(2996CS), PRECHECK(-0CS)
		TCF	TTGPHS

P40CNV85	STQ	SETPD
			QTEMP1
			0
		VLOAD	PUSH
			VGPREV		# EQUALS VGTIG (TARGETTING INPUT)
		CALL
			S41.1
		STCALL	VGBODY
			QTEMP1

## Page 739

# NAME:  	P47 - DELTA V MONITOR
#
# FUNCTION	TO MONITOR VEHICLE ACCELERATION AND
#		DISPLAY ACCUMULATED VG IN CONTROL COORDINATES
#
#			R02BOTH		CHECK STATUS OF IMU
#
#			MIDTOAV2	EXTRAPOLATE STATE VECTOR TO CURRENT TIME
#					+ INCREMENT OF TIMEDELT
#
#			SETUPTIG	WAITLIST TIGON IN NO. OF CS FOUND
#					IN MPAC +1 AFTER MIDTOAV2 RETURN
#
#			TIGON		SET CALCN83 INTO AVGEXIT,
#					NOVAC P47BODY, AND
#					START SERVICER
#
#			CALCN83		ADD PIPA CONTENTS TO ACCUMULATED DELTA V AND
#					CONVERT TO CONTROL COORDINATES AND
#					CALCULATE INERTIAL VELOCITY, R, AND
#					HDOT FOR NOUN 62
#
#			P47BODY		ZERO DELVIMU INITIALLY AND
#					GENERATE MONITORING DISPLAY OF ACCUMULATED
#					DELTA V IN CONTROL COORDINATES
#
#			*************************************************
#			PROVIDE RESTART PROTECTION AT ALL CRITICAL POINTS
#			*************************************************

## Page 740
		COUNT*	$$/P47
		EBANK=	TIG
P47CSM		TC	BANKCALL	# IMU STATUS CHECK
		CADR	R02BOTH
		TC	INTPRET
		CALRB
			MIDTOAV2
SETUPTIG	CAE	MPAC +1		# DELTA TIME TO RPEREAD (LESS THAN 100
		TS	P40TMP		#	CS, WITH A TPAGREE, INT.INIT.)
		TC	TWIDDLE
		ADRES	TIGON
		TC	PHASCHNG
		OCT 	40574		# A, 4.57 = TIGON (P40TMP CS)
4P57SPT1	=	4.57SPOT
		TCF	ENDOFJOB

		EBANK=	P40TMP
TIGON		EXTEND
		DCA	ACADN83
		DXCH	AVEGEXIT
		TC	NOVAC30		# FORCE ZEROING OF N83 BEFORE SERVICER
		EBANK=	TIG
		2CADR	P47BODY

		CS	BIT2		# 4.2 = PRECHECK (-0CS), P47BODY (PRIO30)
		TCF	TTGPHS
		
		EBANK=	TIG
CALCN83		TC	INTPRET
		SETPD	VLOAD
			0
			DELVCTL
		VAD	PUSH
			DELVREF
		STCALL	DV47TEMP
			S41.1
		STCALL	DELVIMU
			S11.1		# CALC. VI, H, HDOT FOR NOUN 62
		EXIT
		TC	PHASCHNG
		OCT	10035
5P3SPT7		=	5.3SPOT
		CAF	FIVE
		TC	GENTRAN
		ADRES	DV47TEMP
		ADRES	DELVCTL
		TC	SERVXT

P47BODY		TC	INTPRET
## Page 741
		VLOAD
			HI6ZEROS
		STORE	DELVIMU		# CLEAR DISPLAY AND ACCUMULATOR STORAGE
		STORE	DELVCTL		# UPON INITIATION OR-ENTER-RESPONSE
		EXIT
P47BOD		CAF	PRIO15		# LOWER PRIO THAN CALCN83 (20)
		TC	PRIOCHNG	#	TO PREVENT INTERRUPTION OF CALCN83
		TC	PHASCHNG
		OCT	05024		# TYPE C GROUP 4 BELOW FOR NOUN 83
		OCT	62777		# PRIO 15 NOVAC
P47/DSP		CAF	V1683
		TC	BANKCALL
		CADR	GOFLASH
		TC	GOTOPOOH
		TC	GOTOPOOH
		TCF	P47BODY		# RECYCLE - CLEAR ACCUMULATED VELOCITY
