# Copyright:	Public domain.
# Filename:	GROUND_TRACKING_DETERMINATION_PROGRAM.agc
# Purpose:	A section of Luminary 1C, revision 131.
#		It is part of the source code for the Lunar Module's (LM)
#		Apollo Guidance Computer (AGC) for Apollo 13 and Apollo 14.
#		This file is intended to be a faithful transcription, except
#		that the code format has been changed to conform to the
#		requirements of the yaYUL assembler rather than the 
#		original YUL assembler.
# Reference:	pp. 661-664 of 1729.pdf.
# Contact:	Ron Burkey <info@sandroid.org>.
# Website:	www.ibiblio.org/apollo/index.html
# Mod history:	05/21/03 RSB.	Began transcribing. 
#		05/14/05 RSB	Corrected website reference above.

# Page 661
# GROUND TRACKING DETERMINATION PROGRAM -- P21
#
# PROGRAM DESCRIPTION
#	MOD NO -- 1
#	MOD BY -- N. M. NEVILLE
#
# FUNCTIONAL DESCRIPTION --
#	TO PROVIDE THE ASTRONAUT DETAILS OF THE LM OR CSM GROUND TRACK WITHOUT
#	THE NEED FOR GROUND COMMUNICATION (REQUESTED BY DSKY).
#
# CALLING SEQUENCE --
#	ASTRONAUT REQUEST THROUGH DSKY V37E21E
#
# SUBROUTINES CALLED --
#	GOPERF4
#	GOFLASH
#	THISPREC
#	OTHPREC
#	LAT-LONG
#
# NORMAL EXIT MODES --
#	ASTRONAUT REQUEST THROUGH DSKY TO TERMINATE PROGRAM V34E
#
# ALARM OR ABORT EXIT MODES --
#	NONE
#
# OUTPUT --
#	OCTAL DISPLAY OF OPTION CODE AND VEHICLE WHOSE GROUND TRACK IS TO BE
#	COMPUTED
#		OPTION CODE	00002
#		THIS		00001
#		OTHER		00002
#	DECIMAL DISPLAY OF TIME TO BE INTEGRATED TO HOURS, MINUTES, SECONS
#	DECIMAL DISPLAY OF LAT,LONG,ALT
#
# ERASABLE INITIALIZATION REQUIRED
#	AX0	2DEC	4.652459653 E-5 RADIANS
#	-AY0	2DEC	2.137535898 E-5 RADIANS
#	AZ0	2DEC	.7753206164	REVOLUTIONS
# 	FOR LUNAR ORBITS 504LM VECTOR IS NEEDED:
#	504LM	2DEC	-2.700340600 E-5 RADIANS
#	504LM+2	2DEC	-7.514128400 E-4 RADIANS
#	504LM+4	2DEC	-2.553198641 E-4 RADIANS
#
# DEBRIS
# Page 662
#	CENTRALS -- A,C,L
#	OTHER -- THOSE USED BY THE ABOVE LISTED SUBROUTINES
#	SEE LEMPREC, LAT-LONG

		SBANK=	LOWSUPER	# FOR LOW 2CADR'S.

		BANK	33
		SETLOC	P20S
		BANK

		EBANK=	P21TIME
		COUNT*	$$/P21
PROG21		CAF	ONE
		TS	OPTION2		# ASSUMED VEHICLE IS LM, R2 = 00001
		CAF	BIT2		# OPTION 2
		TC	BANKCALL
		CADR	GOPERF4
		TC	GOTOP00H	# TERMINATE
		TC	+2		# PROCEED VALUE OF ASSUMED VEHICLE OK
		TC	-5		# R2 LOADED THROUGH DSKY
		CAF	ZERO		# INITIAL TIME = PRESENT TIME
		TS	DSPTEM1
		TS	DSPTEM1 +1
P21PROG1	CAF	V6N34		# LOAD DESIRED TIME OF LAT-LONG.
		TC	BANKCALL
		CADR	GOFLASH
		TC	GOTOP00H	# TERM
		TC	+2		# PROCEED VALUES OK
		TC	-5		# TIME LOADED THROUGH DSKY
		TC	INTPRET
		DLOAD	BZE
			DSPTEM1
			P21PRTM
P21PROG2	STCALL	TDEC1		# INTEG TO TIME SPECIFIED IN TDEC1
			INTSTALL
		BON	CLEAR
			P21FLAG
			P21CONT		# ON -- RECYCLE USING BASE VECTOR
			VINTFLAG	# OFF -- 1ST PASS CALL BASE VECTOR
		SLOAD	SR1
			OPTION2
		BHIZ	SET
			+2		# ZERO -- THIS VEHICLE (LM)
			VINTFLAG	# ONE -- OTHER VEHICLE (CM)
		CLEAR	CLEAR
			DIM0FLAG
			INTYPFLG	# PRECISION
		CALL
			INTEGRV		#     CALCULATE
		GOTO			#       AND
# Page 663
			P21VSAVE	# SAVE BASE VECTOR
P21CONT		VLOAD
			P21BASER	# RECYCLE -- INTEG FROM BASE VECTOR
		STOVL	RCV		# --POS
			P21BASEV
		STODL	VCV		# --VEL
			P21TIME
		STORE	TET		# --TIME
		CLEAR	CLEAR
			DIM0FLAG
			MOONFLAG
		SLOAD	BZE
			P21ORIG
			+3		# ZERO = EARTH
		SET			#    2 = MOON
			MOONFLAG
 +3		CALL
 			INTEGRVS
P21VSAVE	DLOAD			# SAVE CURRENT BASE VECTOR
			TAT
		STOVL	P21TIME		# --TIME
			RATT1
		STOVL	P21BASER	# --POS B-29 OR B-27
			VATT1
		STORE	P21BASEV	# --VEL B-07 OR B-05
		ABVAL	SL*
			0,2
		STOVL	P21VEL		# VEL/ FOR N91 DISP
			RATT
		UNIT	DOT
			VATT		# U(R).V
		DDV	ASIN		# U(R).U(V)
			P21VEL
		STORE	P21GAM		# SIN-1 U(R).U(V) , -90 TO +90
		SXA,2	SLOAD
			P21ORIG		# 0 = EARTH
			OPTION2
		SR1	BHIZ
			+3
		GOTO
			+4
 +3		BON
 			SURFFLAG
			P21DSP
 +4		SET
 			P21FLAG
P21DSP		CLEAR	SLOAD		# GENERATE DISPLAY DATA
			LUNAFLAG
			X2
		BZE	SET
# Page 664
			+2		# 0 = EARTH
			LUNAFLAG
		VLOAD
			RATT
		STODL	ALPHAV
			TAT
		CLEAR	CALL
			ERADFLAG
			LAT-LONG
		DMP			# MPAC = ALT, METERS B-29
			K.01
		STORE	P21ALT		# ALT/100 FOR N91 DISP
		EXIT
		CAF	V06N43		# DISPLAY LAT, LONG, ALT
		TC	BANKCALL	# LAT, LONG = 1/2 REVS B0
		CADR	GOFLASH		# ALT = KM B14
		TC	GOTOP00H	# TERM
		TC	GOTOP00H
		TC	INTPRET		# V32E RECYCLE
		DLOAD	DAD
			P21TIME
			600SEC		# 600 SECONDS OR 10 MIN
		STORE	DSPTEM1
		RTB
			P21PROG1
P21PRTM		RTB	GOTO
			LOADTIME
			P21PROG2
600SEC		2DEC	60000		# 10 MIN

V06N43		VN	00643
V6N34		VN	00634
K.01		2DEC	.01

