# Copyright:	Public domain.
# Filename:	SampleCodeAGS.s
# Purpose:	This is the sample program from Appendix A of the
#		AGS programmer's mannual, by H. L. Stiverson.
# Assembler:	yaLEMAP
# Contact:	Ron Burkey <info@sandroid.org>.
# Website:	www.ibiblio.org/apollo/yaAGS.html.
# Mod history:	2005-01-10 RSB.	Began.
#
# Note that the purpose of the program is partially to illustrate
# the kinds of messages displayed by the LEMAP cross-assembler.
# Since yaLEMAP doesn't display exactly the same messages, the
# comments explaining the messages aren't extremely interesting.
# However, the program is still useful, since it helps wring out
# yaLEMAP and is very short.  For convenience of reference, the
# page numbers from the programmer's manual (from which the code
# is taken) have been added as comments.

# Page A-25.
# THERE ARE FOUR FORMS FOR THE OCTAL PORTION OF THE LEMAP
# LISTING.
#
# (1)	THE LEM MACHINE OPERATIONS HAVE THE FOLLOWING FORM
#		BC EF  LLLL  OO R AAAA
#	WHERE	B=X DRIVER
#		C=Y DRIVER
#		E=X SWITCH
#		F=Y SWITCH
#		LLLL=LOCATION OF THE GIVEN INSTRUCTION
#		OO=OPERATION CODE
#		R=INDEX REGISTER BIT
#		AAAA=VALUE OF TEH ADDRESS FIELD
#
# (2)	THE DATA GENERATING PSEUDO-OPERATIONS, I.E., DEC AND OCT,
#	HAVE THE FOLLOWING FORM
#		BC EF  LLLL DDDDDD
#	WHERE	B=X DRIVER
#		C=Y DRIVER
#		E=X SWITCH
#		F=Y SWITCH
#		LLLL=LOCATION OF THE GIVEN INSTRUCTION
#		DDDDDD=DATA GENERATED
#
# (3) 	ALL NON DATA GENERATION PSEUDO-OPERATIONS, EXCEPT BSS
#	AND BES, HAVE THE FOLLOWING FORM
#		AAAA
#	WHERE	AAAA=VALUE OF THE ADDRESS FIELD
#
# (4)	THE PSEUDO-OPERATIONS BSS AND BES HAVE THE FOLLOWING FORM
#		LLLL
#	WHERE	LLLL=LOCATION OF THE FIRST CELL OF THE BLOCK
#		     FOR A BSS
#	  AND	LLLL=LOCATION OF THE CELL IMMEDIATELY FOLLOWING
#		     THE LAST CELL OF THE BLOCK FOR A BES
# Page A-26
#
# CHECKSUM
#	THE VALUE PRINTED AFTER THE END CARD AS THE CHECKSUM IS
#	THE 2'S COMPLEMENT OF THE SUM, DISREGARDING OVERFLOW,
#	OF THE CONTENTS OF LOCATIONS 4000(8) TO 7776(8),
#	INCLUSIVE, AND IS STORED IN LOCATION 7777(8).
#
# THE FOLLOWING PROGRAM IS NOT MEANT TO BE EXECUTED.  ITS PURPOSE
# IS TO FAMILIARIZE THE READER WITH THE FORMAT AND ERROR CODES
# OF THE LEMAP LISTING.

X1	OCT	10000,1000
A	OCT	-1,1,-3,3
	OCT	252525
	OCT	525252,-125252
B	OCT	0
C	BSS	8
C1	BSS	8
C2	BSS	32
# THE NEXT INSTRUCTION SPECIFIES A NUMBER THAT IS TOO LARGE FOR
# THE LEM COMPUTER, I.E., IT CANNOT BE REPRESENTED BY 18 BITS.
	OCT	1252525
M	DEFINE	200
IEQU	EQU	A+1
	AXT	B-A,1
	
# Page A-27
L1	CLA	A,1
	ADD	X1
	STO	C,1
	TIX	L1,1
	AXT	B-A,1
	CLA	C,1
	TMI	NEG
	TIX	*-2,1
	TRA	NEG+2
NEG	LDQ	C,1
	STQ	B
	CLA	B
# THE NEXT INSTRUCTION HAS AN UNDEFINED SYMBOL IN ITS ADDRESS
# FIELD.
	TMI	NEGC
	AXT	7,1
L2	CLA	A,1
	ADD	X1+1
	STO	C,1
# THE NEXT INSTRUCTION IS A TIX WITH THE TAG FIELD OMITTED.
	TIX	L2
	CLA	A
	ADD	B
	STO	C+2
	CLA	A+7
# THE NEXT INSTRUCTION HAS A NEGATIVE ADDRESS FIELD.
	STO	A-4
	
	ORG	310
L3	AXT	7,1
	CLA	A,1
	MPY	DC1
	TMI	*+6
	TIX	L3+1,1
	CLA	DC1

# Page A-28
	ADD	DC+10
	STO	DC1
	TRA	L3
	STO	DC1+1
# THE NEXT INSTRUCTION IS AN AXT WITH AN ADDRESS FIELD THAT
# EXCEEDS THE CAPACITY OF THE INDEX REGISTER (3 BITS).
	AXT	10,1
D	CLA	A+3
	SUB	A+4
	SUB	A+8
E	ADD	A+10
KING	EQU	A
	CLA	M
	STO	KING
IAD	DEFINE	10000
# THE NEXT INSTRUCTION HAS AN ADDRESS FIELD THAT EXCEEDS THE
# MEMORY CAPACITY OF THE LEM COMPUTER.
	CLA	IAD
OCTOP1	ALS	1
	STO	B-4
	CLA	IEQU
	STO	C2+5
# THE NEXT INSTRUCTION IS AN AXT WITH THE TAG FIELD OMITTED.
	AXT	7
L4	CLA	A,1
	LDQ	C,1
	DVP	DC+16
	STO	C1,1
	TIX	L4,1
# THE NEXT INSTRUCTION HAS AN ILLEGAL MNEMONIC IN ITS OPERATION
# FIELD.
	RNT	A
	OUT	13
	
# Page A-29
	TRA	L5
DC1	DEC	0,0
	DEC	-.5B1
	DEC	-.5B+1
	DEC	-5E-1B1
	DEC	-5E-1B+1
	DEC	.5B1
DC	DEC	+.3E5B23
	DEC	-.5B1,-.2121B-2,309.6B10
# THE NEXT INSTRUCTION SPECIFIES A NUMBER THAT IS TOO LARGE FOR
# THE GIVEN BINARY SCALING.
	DEC	309.6B7
	DEC	.2121B-2
	DEC	-.2121B-2
	DEC	.1414B-2
	DEC	-.1414B-2
# THE NEXT INSTRUCTION SPECIFIES A NUMBER THAT IS TOO LARGE FOR
# THE LEM COMPUTER, I.E., IT CANNOT BE REPRESENTED BY 18 BITS.
	DEC	262144
	DEC	15082.B+16
	DEC	.749E-1B-3
	DEC	-1200.B18
	DEC	3.B+6
	DEC	-.398E-1B-3
	DEC	-.5B1,-.2121B-2,309.6B10
	DEC	-309.6B10
	DEC	98,602,786
	
# THE NEXT INSTRUCTION SPECIFIES A FIXED POINT NUMBER WITH THE
# Page A-30
# B FIELD (BINARY POINT) OMITTED.
	DEC	-.5
	DEC	-.5B1,581,309.6B10
	DEC	98,309.6B10,602
C3	BES	8
	DEC	109,-.2121B10,778
	DEC	-.45B0,309.6B10,309.6B10
	DEC	309.6B10,-.5B1,-.2121B-2
	DEC	-.5B1,-.2121B-2,309.6B10
	DEC	-.5B1,-.2121B-2,309.6B10
	
	ORG	3774
	DEC	326.848B13
	DEC	-326.848B13
	DEC	.01B0
	DEC	-.01B0
	DEC	.5000025B0	# NO ROUND
	DEC	-.5000025B0
	DEC	.500004B0	# ROUND
	DEC	-.500004B0
	DEC	.173139971E15B48
	DEC	-.173139971E15B48
	
# Page A-31
	DEC	.497291E-4B-12
	DEC	-.497291E-4B-12
	DEC	.3815E-5B17
	DEC	-.3815E-5B17
	DEC	.156B14
	DEC	-.156B14
	DEC	-.18488E-3B-6
	DEC	.18488E-3B-6
	DEC	.16665554B-2
	DEC	-.16665554B-2
	
	ORG	7774
L5	AXT	7,1
	CLA	A,1
	SUB	X1+1
#	STO	C5,1
# THE NEXT INSTRUCTION IS TO BE STORED IN A LOCATION THAT
# EXCEEDS THE MEMORY CAPACITY OF THE LEM COMPUTER.
#	TIX	L5+1,1
#C5	SYN	C3
	END
	
