# Copyright:	Public domain.
# Filename:	FP6.s
# Purpose:	This is the Apollo lunar module's firmware for the 
#		Abort Guidance System (AGS).  This is Flight Program 6.
# Assembler:	yaLEMAP
# Contact:	Ron Burkey <info@sandroid.org>.
# Website:	www.ibiblio.org/apollo/yaAGS.html
# Reference:	http://www.ibiblio.org/apollo/Pultorak_files/FP6_AGS_AssemblyListing.pdf.
# Mod history:	2005-01-22 RSB	Began adapting from FP8.s.
#		2005-01-23 RSB	Data entry complete.  It assembles without
#				errors or warnings, but only the checksum
#				for 4000-7777 is correct so far.  Not yet
#				proofed.
#		2005-01-24 RSB	Proofed 0000-3777.  The checksums all match
#				now.  4000-7777 isn't proofed, even though
#				its checksum is correct.
#		2005-05-14 RSB	Corrected website reference above.
#		2005-06-12 RSB	Fixed comments on p. 116.
#
# The contents have been taken (by means of manual data entry) from 
# an assembly listing of Flight Program 6 scanned by John Pultorak from
# a physical copy preserved by supplied by Davis Peticolas.  (The WWW link
# for the scan is referenced above.)  However, I have not simply slavishly
# entered the code directly from viewing the scan.  Rather, I have started
# with FP8 source code, and only changed it as needed.  There are several 
# reasons for this:
#
#	1.	FP8 and FP6 are extremely similar.  In fact, the checksum
#		of the entire upper half of memory (4000-7777 octal) is 
#		identical, leading us to believe that huge hunks of the
#		code are unchanged.
#	2.	FP8 source code, as mentioned, has previously been entered
#		and therefore is available.
#	3.	Pages 90 and 96 are missing from the physical copy of the
#		FP6 source code which was scanned, and therefore we have
#		little choice but to take them from the only available other
#		version of the program (namely, from FP8).  Fortunately,
#		pages 90 and 96 are in the 4000-7777 address range, which
#		we belive has not changed.
#	4.	The physical copy of FP6 from which the scan has been taken
#		is much lighter and harder to read than FP8.
#	5.	And finally, it's just easier for me to do it this way and
#		save myself some time.
#
# The danger of this approach is mainly not catching changes to the program
# comments (which, of course, were rather uncertain to begin with, since the
# method of proofing the FP8 source code did not proof the comments).  So,
# anybody who wants to volunteer to proof the comments has may backing!
#
# This file contains the entire source code for FP6.  I have not split the
# source code into many smaller chunks as has been done for AGC source code.
# The page references are to the scanned PDF of the assembly listing, but 
# the page markings on the physical copy match the PDF pages, because I have
# specifically manipulated them to do so.  In addition 
# to the comments containing the page references, I've also added some 
# blank lines for readability.  So don't expect the line numbers in the 
# scanned version to match the line numbers in an assembly listing created
# by processing this source file with the yaLEMAP cross-assembler.

# Page 1
# FLIGHT PROGRAM X -- LMAGS FPX S03 0151 -- 02/14/69
#     LM ABORT ELECTRONICS ASSEMBLY
#
#		SCRATCH PAD STORAGE
	ORG	0000
TS0	DEC	0
TS1	DEC	0
TS2	DEC	0
TS3	DEC	0
TS4	DEC	0
TS5	DEC	0
TS6	DEC	0
TS7	DEC	0
TS10	DEC	0
TS11	DEC	0
TS12	DEC	0
TS13	DEC	0
TS14	DEC	0
TS15	DEC	0
TS16	DEC	0
TS17	DEC	0
B11	EQU	TS10		# B3	B13 FOR RATE
B21	EQU	TS11		# B3	B13 FOR RATE
B31	EQU	TS12		# B-7	B3 FOR RATE
B41	EQU	TS13		# B-7	B3 FOR RATE
B12	EQU	TS14		# B3	ZERO FOR RATE
B22	EQU	TS15		# B3 	ZERO FOR RATE
B32	EQU	TS16		# B-7	ZERO FOR RATE
B42	EQU	TS17		# B-7	ZERO FOR RATE
SREX3	DEC	0
SREX2	DEC	0
SREX1	DEC	0
SREX	DEC	0
TVARBR	DEC	0		# TEMP STORE FOR CK SUM.
	TRA	RETURN		# SERV ROUT, STARTUP
#
#		TAPE LOAD STARTUP CHECKSUM
#
SF	OUT	6402		# DEDA INPUT SCALE FACTOR

# Page 2
OCTF	INP	2040		# DEDA OCTAL INPUT
#
#		THE NEXT 16 LOCATIONS ARE SHARED
#		WITH A RR FILTER TEMPORARY MATRIX
#
U2X	ALS	1		# B1	UNIT RADIAL VECTOR TO
U2Y	TMI	*+2		# B1	TRIAL RENDEZ PT.
U2Z	TRA	*-3		# B1
VFX	EQU	U2X		# 	BRAKING VEL VECTOR AT 13.
RDOTX	EQU	U2X		# 0B13	RANGE RATE CSM-LSM
RDOTY	EQU	U2Y
RDOTZ	EQU	U2Z
C2	DLY	*+1		# B1	RENDEZ ANGLE SINE
V1X	OUT	7012		# B1	HORIZ UNIT VECTOR
V1Y	INP	6200
V1Z	CLZ	SUM
DLSC	CLA	V2Z		#	DOWNLINK SHIFT COUNTER
W1X	STO	TVARBR		# B1	U1 X V1
D31	EQU	W1X
W1Y	CLZ	WRDCNT
W1Z	TSQ	TVARBR
SI	ADZ	SUM		# B0 	E(SIN(E0))
A31S	STO	SUM		# B1	RADAR NULL DIR COS
A32S	CLA	TVARBR
A33S	SUB	CLAFR
SIDELL	TMI	U1X		# B1	SIN DELTA L
V6X	CLZ	SUM 		# B13	TEMP STORAGE FOR TPI QUANT
V6Y	TMI	*+3
V6Z	SUB	1B17
DQSX	EQU	V6X		# 	ACCUM VEL IN XDV
CODELL	TMI	EXIT40		# B1	COS DELTA L
WCX	CLA	10B4		# B1	UNIT VECTOR NORMAL
WCY	STO	S12		# 	TO CSM ORBIT
WCZ 	OUT	6410
TMPBR	TRA	SINITC		#	TEMP BRANCH STORE
U1X	CLZ	WRDCNT		# B1	LEM UNIT RAD VECTGOR
U1Y	ADD	1B17
U1Z	STO	WRDCNT
BRANCH	SUB	1B11		#	GUIDANCE BRANCH
V2X	TMI	W1Z		# B1	HORZ UNIT VECTOR AT
V2Y	DLY	W1Y		#	RENDEZ POINT
V2Z	CLA	0206

# Page 3
#
#	END OF TAPE LOAD CHECKSUM PROGRAM
#
VGX	EQU	V2X		#	VEL TO GAIN VECTOR AT L3
AT	DEC	0B7
EX	DEC	0B2		#	ATTITUDE ERRORS.
EY	DEC	0
EZ	DEC	0
X3	DEC	0B0		#	XFR ORB PARAM.
Q11	EQU	X3		# B30	B10 FOR RATE
DVXM1	DEC	0B1		#	BODY DELTA VS
DVYM1	DEC	0		# 	PREVIOUS CYCLE.
DVZM1	DEC	0
NI	DEC	0B-9		#	PREDICTION ANGULAR FREQUENCY
NE	EQU	NI		# 	CSM PRED. ANGULAR FREQ.
VD2X	DEC	0B2		# 	DELTA V EXP LS
VD2Y	DEC	0
VD2Z	DEC	0
CI	DEC	0B0		#	E(COS(E0))
DRX	DEC	0B14		#	LRM POS REMAINDERS
DRY	DEC	0
DRZ	DEC	0
THEP	DEC	0		#	PGNS THETA IN COUNTS.
DIGX	DEC	0B7		# 	PREDICTED CHANGE IN
DIGY	DEC	0		#	INTEGRATED GRAVITY.
DIGZ	DEC	0
PSIP	DEC	0		#	PGNS PSI IN COUNTS.
GXDT	DEC	0B7		#	GRAVITY TIMES MAJOR
GYDT	DEC	0
GZDT	DEC	0
PHIP	DEC	0		#	PGNS PHI IN COUNTS.
DVSX	DEC	0B7
DVSY	DEC	0
DVSZ	DEC	0
SIGA	DEC	0B1		# 	SIN FDAI GAMMA.
RRX	DEC	0B23		# 	COMPUTED LM-CSM RANGE
RRY	DEC	0

# Page 4
RRZ	DEC	0
COGA	DEC	0B1		#	COS FDAI GAMMA.
A11	DEC	1.0B1		#	XB DIRECTION COSINES.
A12	DEC	0
A13	DEC	0
TS8	DEC	0
A31	DEC	0		#	ZB DIRECTION COSINES
A32	DEC	0
A33	DEC	1.0B1
SUM	DEC	0		# 	RUNNING MEMORY SUM
A21	DEC	0		#	YB DIRECTION COSINES
A22	DEC	1.0B1
A23	DEC	0
X4	DEC	0B0		#	XFR ORB PARAM.
VHSQ	EQU	X4		# 0B26	VH SQUARED
Q12	EQU	X4		# B30
E1	DEC	0		#	-6 OR -9 XB NORM ERROR
E3	DEC	0		#	ZB NORMALITY ERROR.
E13	DEC	0		#	XB,ZB ORTHOG ERROR.
T1	DEC	0B18		#	TA1 AT RADAR NULL
DA11	DEC	0B-5		#	DIR COSINE REMAINDERS
DA12	DEC	0
DA13	DEC	0
WRDCNT	DEC	0		#	CKSUM WORD COUNT
DA31	DEC	0
DA32	DEC	0
DA33	DEC	0
TSEX	DEC	0		#	EXIT FROM NORTON
A11D	DEC	0B1		#	XD DIRECTION COSINES.
A12D	DEC	0
A13D	DEC	0
	DEC	0		#	** UNUSED -- INDEXED BY A11D **
A31D	DEC	0B1		#	ZD DIRECTION COSINES.
A32D	DEC	0
A33D	DEC	0
MU17	DEC	0B3		#	RADAR FILTER ENTRY COUNTER
P	DEC	0B23		#	TRIAL SEMI-PARAMETER

# Page 5
Q22	EQU	P		# B30
ALPHA	DEC	0B23		#	XFR ORBIT SEMI-MAJOR AXIS
Q1	DEC	0B23		#	XFR ORBIT PERILUNE
ESQ	EQU	Q1
AI	DEC	0B23		#	PRED. SEMI-MAJOR AXIS
AE	EQU	AI		#	CSM PRED. SEMI-MAJOR AXIS
R5X	DEC	0B23		#	LM PRED POS AHEAD TDEL
R5Y	DEC	0
R5Z	DEC	0
AL	DEC	0B23		#	LM PRED. SEMI-MAJOR AXIS
REX	DEC	0B23		#	CSM EPOCH POSITION
REY	DEC	0
REZ	DEC	0
RT	DEC	0B23		#	CSM PRED POS. MAG.
R0X	DEC	0B23		#	PRED EPOCH POS VECTOR
R0Y	DEC	0
#	SEE REAR OF LISTING FOR CHECKSUM
#	Note that the CHECKSUM pseudo-op is not defined in the AGS
#	programmer's manual.  I have decided for the purposes of 
#	implementing yaLEMAT that the following syntax will be
#	used.  It means that the cross-assembler will compute a
#	checksum of the address range 0207-1004 (octal), and will
#	store it right here.
	CHECKSUM RANGE 0207-1004
R0Z	DEFINE	0206
R0	DEC	0B23		# 	PRED EPOCH POS. MAG.
R	DEC	0B23		#	LM POS MAGNITUDE
Y	DEC	0B23		#	OUT OF PLANE POSITION
PP	DEC	0B23		#	P PRIME/EXIT FOR MXM
DELTA	EQU	PP		# B60	B10 FOR RATE
POUTFS	DEC	7.684096E4B23	#	MAX P DISPLAYABLE
POUT	DEC	0		#	DISPLAY POSITION.
DPOUT	DEC	0		# 	DISPLAY POSITION INCREMENT.
2K3	DEC	1048576.B23	#	QL SET ON O.F.
2K14	DEC	5.E4B23		#	INITIAL P PERTURBATION
RIX	DEC	0B23		#	ELLIPSE PRED POS OUTPUT
RIY	DEC	0
RIZ	DEC	0
DELR1	EQU	RIX		#	MEASURED MINUS COMPUTED RANGE
DELR3	EQU	RIY		# B23
DELR2	EQU	RIZ
25J	DEC	0B23		#	DEDA ALTITUDE UPDATE
7J	DEC	6055605B23	#	TERM IN AL(O.I.)

# Page 6
8J	DEC	5823542B23	#	AL LOWER LIMIT (O.I.)
9J	DEC	7031200B23	#	AL UPPER LIMIT (O.I.)
4K10	DEC	-651361.1B20	#	TERM IN AL (O.I.)
2K19	DEC	5.E5B23		#	DELTA P LIMITER
5J	DEC	5.7024E6B23	#	LANDING SITE RADIUS
16J	DEC	60000B23	#	ORBIT INSERTION ALTITUDE
21J	DEC	25000B23	#	PITCH STEERING ALT THRESHOLD
RRSX	DEC	0B23		#	CALCULATED RANGE AT TIME
RRSY	DEC	0		#	OF RADAR RANGE MEASUREMENT.
RRSZ	DEC	0
L12	EQU	RRSX		# B30	ZERO FOR RATE
L22	EQU	RRSY		# B30	ZERO FOR RATE
L32	EQU	RRSZ		# B30	ZERO FOR RATE
L42	DEC	0		# B20	ZERO FOR RATE
#
#	INITIALIZE DATA FROM DOWNLINK ADDRESSES
#		LOCATIONS 0240-0257 USED
1J1	DEC	0B23		#	LM EPHEMERIS POS
1J2	DEC	0
1J3	DEC	0
	DEC	0
2J1	DEC	0		# 	CSM EPHEMERIS POS
2J2	DEC	0
2J3	DEC	0
	DEC	0
	DEC	0
	DEC	0
	DEC	0
	DEC	0
1J7	DEC	0B18		#	LM EPOCH TIME
1J7LS	DEC	0B1
	DEC	0
	DEC	0
1J4	DEC	0B13		#	LM EPHEMERIS VEL
1J5	DEC	0
1J6	DEC	0
VPY	DEC	0B13		#	OUT-OF-PLANE VELOCITY

# Page 7
2J4	DEC	0		#	CSM EPHEMERIS VEL
2J5	DEC	0
2J6	DEC	0
DELVG	DEC	0B13		#	VEL-TO-BE-GAINED FOR 40 MS
VY0	DEC	0B13		#	LM OUT-OF-PLANE VEL
RB	DEC	0B23		#	RF SAVED FOR ORBIT INSERT
2J7	DEC	0		#	CSM EPOCH TIME
2J7LS	DEC	0
29J	DEC	-2000.B18	#	INITIAL FILTER TIME FOR T1
1J	DEC	0B18		#	NOMINAL TPI TIME (CSI)
DELTAT	DEC	0B18		#	TIME OF LAST RADAR UPDATE
XI	DEC	0B3		#	Z-AXIS/LOCAL HORIZ ANGLE
A31BD	DEC	0B1		#	UNIT VECTOR (LM-CSM)
A32BD	DEC	0
A33BD	DEC	0
TLOS	DEC	0B3		#	DXFR LOS COMPUTED
THETAF	EQU	TLOS		#	LM-CSM CENTRAL ANG AT CSI/CDH
6K8	DEC	.22B10		#	RANGE RATE ERROR VARIANCE
	DEC	0		#	**UNUSED**
4J	DEC	0B13		#	TIME OF NODE PRIOR TO RENDEZ
6J	DEC	2576.0B13	#	DESIRED TRANSFER TIME
TDEL	DEC	0B13		#	TIME TIL NEXT MANEUVER
TR	DEC	0B13		#	TIME TIL RENDEZVOUS
3J	DEC	0B13		#	TARGET OFFSET TIME
TPERG	DEC	0B13		#	LM TIME TO PERIGEE
DELRP	DEC	0B23		#	DIFF. ALT. AT TIG(CSI-CDH)
QA	DEC	0B23		#	LM APOFOCUS ALTITUDE
18J	DEC	0B23		#	MEASURED RADAR RANGE
RR	DEC	0B23		#	COMPUTED RANGE
READP	DEC	0
ENTERP	DEC	0
HOLDP	DEC	0
CLEARP	DEC	0
HMF	DEC	0
#		START OF TELEMETRY LIST
RMF	DEC	0		#	READOUT MODE FLAG
DD	DEC	0		#	DEDA DATA

# Page 8
CMF	DEC	0		#	CLEAR MODE FLAG
A11T	DEC	1.B1		#	TM DIR COSINES
A12T	DEC	0
A13T	DEC	0
ADST	DEC	0		#	DEDA ADDRESS
A31T	DEC	0
A32T	DEC	0
A33T	DEC	1.B1
H	DEC	0B23		#	ALTITUDE
RX	DEC	0B23		#	LM POSITION
RY	DEC	0
RZ	DEC	0
QL	DEC	0B23		#	PRESENT LM PERICYNTHION
EONS10	EQU	QL		#	ENG ON+S10 FOR TM
RCX	DEC	0B23		#	CSM PRESENT POSITION
RCY	DEC	0
RCZ	DEC	0
RF	DEC	0B23		#	PREDICTED BURNOUT ALT.
DVX	DEC	0B1		#	BODY DELTA VS
DVY	DEC	0		#	THIS CYCLE.
DVZ	DEC	0
TA2	DEC	0B1		#	ABS TIME LS.
DAX	DEC	0B-6		#	DELTA ALPHAS
DAY	DEC	0
DAZ	DEC	0
TBO	DEC	0B9		# 	TIME TO BURNOUT.
VX	DEC	0B13		#	LM VELOCITY
VY	DEC 	0
VZ	DEC 	0
MU8S12	DEC	0		#	MU8/S12
VCX	DEC	0B13		#	CSM PRESENT VELOCITY
VCY	DEC	0
VCZ	DEC	0
HDOT	DEC	0B13		#	ALTITUDE RATE
VG	DEC	0B13		#	VELOCITY TO GAIN
VT	DEC	0B13		#	TOTAL VEL REQ FOR DXFER
VP0	EQU	VT		#	VEL. TO-BE-GAINED AT CDH

# Page 9
TA0	DEC	0B18		#	TIME FROM CSI TO CDH
TIG	DEC	0B18		#	ABSOLUTE TIME OF MANEUVER
A11BD	DEC	0B1		#	CMD XB POINTING DIR
A12BD	DEC	0
A13BD	DEC	0
TA1	DEC	0B18		#	ABS TIME MS.
S0	DEC	0		#	AGS FUNCTION SELECTOR
DISC1C	DEC	0		#	DISCRETE WD 1-TRUE STATE
Q1DEDA	DEC	0B23		#	TRANS ORBIT PERICYN ALT
DELH	EQU	Q1DEDA		#	DIFF. ALT. AFTER CDH(CSI-CDH)
QLTELE	DEC	0B23		#	QL FOR TELE AND DEDA
VD1X	DEC	0B13		#	40MS VEL ACCUMULATION
VD1Y	DEC	0
VD1Z	DEC	0
#		END OF TELEMETRY LIST
S7	DEC	0		#	ENGINE ON FOR EXT DELTA V
S10	DEC	0		#	GUIDANCE MODE SELECTOR
S11	DEC	0		#	AUTO RADAR SWITCH
S12	DEC	0		#	TEST STATUS
S13	DEC	0		#	STORE LUNAR AZIMUTH
S14	DEC	0		#	NAVIGATION INITIALIZE
S15	DEC	0		# 	RADAR GIMBAL NULL
S16	DEC	0		#	CDH APSIDAL SELECTION
S17	DEC	0		#	RADAR FILTER INIT. SWITCH
VEX	DEC	0B13		#	CSM EPOCH VEL
VEY	DEC	0
VEZ	DEC	0
RFDOT	DEC	0B13		#	DESIRED ALT RATE
V0X	DEC	0B13		#	PRED EPOCH VEL VECTOR
V0Y	DEC	0
V0Z	DEC	0
VH	DEC	0B13		#	LM HORIZONTAL VEL
VIX	DEC	0B13		#	ELLIPSE PRED VEL OUTPUT
VIY	DEC	0
VIZ	DEC	0
V	DEC	0B13		#	LM TOTAL VELOCITY
TP	DEC	0B13		#	TRIAL XFR ORB. TIME.

# Page 10
T	DEC	0B13		#	TIME TO RENDEZ.
TB	DEC	0B13		#	TA-TE.
PDOTM1	DEC	0B13		#	DISPLAY POS RATE(-1)
RRDOT	DEC	0B13		#	RANGE RATE
RDOTS	DEC	0B13		#	R. R. STORED AT RADAR INPUT
TI	DEC	0B13		#	PREDICTION TIME/RR FILTER TEMP
DPDOUT	DEC	0B13		#	DISPLAY POS RATE INCREMENT
PDOUT	DEC	0B13		#	DSP POS RATE CONV TO FPS AT 13
TCSM	DEC	0B13		#	CSM PERIOD (SEC)
BACCSF	DEC	0.762939B0	#	.001 FT/SEC2 TO FPS/20MS AT 1
2K18	DEC	15.B13		#	PARTIAL DERIV PROTECTOR.
28J1	DEC	0B13		#	DELTA V DOWNRANGE
28J2	DEC	0B13		#	DELTA V CROSSRANGE
28J3	DEC	0B13		#	DELTA V RADIAL
2K20	DEC	2.B13		#	CONVERGENCE CHECK.
4K26	DEC	100.0B13	#	VG THRESHOLD
DDF	DEC	0		#	DEDA DATA RECEIVED FLAG
6K4	DEC	.1E3B10		#	INITIAL VALUE OF P33 AND P44
6K2	DEC	.1E9B30		#	INIT VALUE OF P11,P22
V5X	DEC	0B13		#	TPI-PREDICTED V AT TPI TIME
V5Y	DEC	0
V5Z	DEC	0
DVGXX	EQU	V5X		#	VEL TO GAIN IN EXT DELTA V
VHA	DEC	0B13
22J	DEC	50B13		#	PITCH STEERING ALT RATE THRESH
23J	DEC	0B13		#	RFDOT LOWER LIMIT
5K26	DEC	15B13		#	PSEUDO ATT HOLD IN STEER
PART	DEC	0B14		#	PARTIAL DERIVATIVE
VDX	DEC	0B13		#	VD1 AT NAV UPDATE
VDY	DEC	0
VDZ	DEC	0
4K27	DEC	-7332.B13	#	OVERFLOW PROTECTION FOR VD1X
VSMGX	DEC	0B13		#	VD1 CUTOFF
VSMGY	DEC	0
VSMGZ	DEC	0
RADOT	DEC	0B13		#	PRED. RDOT AT TIG
DELVGX	DEC	0B13		#	THRUST VEL TO GAIN

# Page 11
DELVGY	DEC	0
DELVGZ	DEC	0
17J	DEC	0B13		#	RANGE RATE INPUT
RD3DOT	DEC	0B-2		#	DESIRED RADIAL JERK
YD3DOT	DEC	0B-2		#	DESIRED OUT-OF-PLANE JERK
4K12	DEC	5B7		#	ACCEL THRESH IN O.I. STEER
S507	DEC	0B3		#	ACQ STEER SEL OF PT DIR
DAXREM	DEC	0B-13		#	INCRE. GYRO INPUT REMAINDERS
DAYREM	DEC	0
DAZREM 	DEC	0
C1 	DEC	0B1		#	RENDEZ ANGLE COSINE.
WBX	DEC	0B1		#	UNIT VECTOR FOR
WBY	DEC	0		#	GUIDANCE STEERING
WBZ	DEC	0
6K10	DEC	.625E7B28	#	VARIANCE OF RADAR RANGE ERROR
TE1	DEC	0B18		#	CSM EPOCH TIME MS.
TL1	DEC	0B18		#	LEM EPOCH TIME MS.
6K6	DEC	-.24B8		#	Y-VELOCITY FILTER WEIGHT
5K20	DEC	0B-2		#	RD3DOT LOWER LIMIT
TE2	DEC	0		#	CSM EPOCH TIME LS.
TL2	DEC	0		#	LEM EPOCH TIME LS.
2K11	DEC	6000B13		#	VF IF OVERFLOW
4K6	DEC	80.B13		#	RFDOT UPPER LIMIT
DAXA	DEC	0B-6		#	ALIGN INCREMENTS
DAYA	DEC	0
DAZA	DEC	0
DISC1	DEC	0		#	DISCRETE WORD
1K18	DEC	.003125B-8	#	ACCEL SCALE FACTOR
1K20	DEC	.003125B-8
1K22	DEC	.003125B-8
1K14	DEC	0B-14		#	X-AXIS MASS UNBAL COMP
1K19	DEC	0B1		#	ACCEL BIAS
1K21	DEC	0B1		#	COMPENSATION
1K23	DEC	0B1
DSPSC	DEC	0		#	DISPLAY SHIFT COUNTER
1K1	DEC	0B-13		#	GYRO BIAS
1K6	DEC	0		#	COMPENSATIONS

# Page 12
1K11	DEC	0
DDEL	DEC	0B0		#	LUNAR ALIGN CORRECTION
1K3	DEC	0B-7		#	GYRO SCALE FACTOR
1K8	DEC	0		#	COMPENSATIONS
1K13	DEC	0
HRF	DEC	0		#	HIGH RATE FLAG
RD2DOT	DEC	0B7		# 	DESIRED RADIAL ACCEL
YD2DOT	DEC	0B7		#	DESIRED OUT-OF-PLANE ACCEL
L11	EQU	RD2DOT		# B30	B20  INTERMEDIATE RESULTS
L21	EQU	YD2DOT		# B30	B20  USED TO COMPUTE
L31	DEC	0		# B20	B10  RADAR FILTER
L41	DEC	0		# B20	B10  WEIGHTS
LILA	EQU	RD2DOT		# 	INTERMEDIATE RESULTS FOR
LILE	EQU	YD2DOT		#	COVARIANCE MATRIX COMPUTATION
LILJ	EQU	L31		# B-15
LILC	EQU	L41
5K14	DEC	0B-2		#	RD3DOT UPPER LIMIT
5K16	DEC	.008B-2		#	YD3DOT UPPER LIMIT
DLWN	DEC	0		#	DOWNLINK WORD COUNTER
DLIF	DEC	0		#	DOWNLINK INITIALIZE FLAG
5K18	DEC	-.1B-2		#	RD3DOT LOWER LIMIT
4K4	DEC	.004B-7		#	FACTOR IN RFDOT(OI)
4K7	DEC	.0873B0		#	PITCH CANT ANGLE
DSPF1	DEC	0		#	DISPLAY FLAG1.
ID1F	DEC	0		#	DOWNLINK ID RECEIVED
IDRF	DEC	0		#	DOWNLINK INPUT COMPLETE
FLAGT	DEC	0		#	MEMORY TEST
FLAG1	DEC	0		#	20MS BRANCH CONTROL
DEL2	OCT	0		#	STAGED FLAG.
DEL5	OCT	0		#	ATTHLD LOCK FLAG.
DEL6	DEC	0		#	CALIBRATE I.C. FLAG
DEL10	DEC	0		#	TPI LOGIC FLAG
RD3DTL	DEC	0B-2		#	RD3DOT LOWER LIMIT
5K17	DEC	-.008B-2	#	YD3DOT LOWER LIMIT
4K8	DEC	.034B0		#	POLL CANT ANGLE
DEL20	DEC	0		#	LOGIC FLAG FOR ENG CONTROL
DEL21	OCT	0		#	LUNAR SURFACE FLAG.

# Page 13
2J	DEC	1.9970B7	#	COTAN OF DESIRED LOS AT TPI
DEL42	OCT	0		#	LUNAR ALINE COMPLETE FLAG
K55	OCT	377777		#	S.F. FOR HDOT DISPLAY
MU3	DEC	0		#	P-ITER COUNTER.
6K9	DEC	.3029E-4B-15	#	VARIANCE OF RADAR ANGULAR ERROR
MU6	DEC	0		#	STAGING COUNTER
3K4	DEC	.17365B1	#	CENTRAL ANGLE LIMIT ON TPI
MU8	DEC	0		#	ULLAGE COUNTER
MU10	DEC	0		#	GYRO CALIBRATE DURATION
1K9	DEC	3.0B17		#	ULLAGE COUNTER LIMIT
1K30	DEC	150.B17		#	GYRO CALIBRATE DURATION
2K17	DEC	5.B17		#	NO OF P-ITERATIONS-3
1K37	DEC	15.B17		#	ACCEL CAL DURATION
4K23	DEC	25.0B17		#	STAGING TIME DELAY
S623	DEC	0B3		#	EX SELECTION IN G. S
1K4	DEC	.1B0		#	DISPLAY INTERPOLATION
1K24	DEC	.87E-3B1	#	SINGULARITY THRESHOLD
1K26	DEC	-.142857E3B8	#	NEG INV OF ALIGN GAIN CONSTANT
1K27	DEC	.435E-1B-4	#	ALIGN CONSTANT
1K28	DEC	107.9378B7	#	ALIGN CONSTANT
1K29	DEC	.001B-4		#	LUN ALIGN STOP CRITERION
1K33	DEC	.08B-3		#	CALIBRATE GAIN
1K34	DEC	.00002B-15	#	CALIBRATE GAIN
1K35	DEC	.25B7		#	ACCEL BIAS THRESHOLD
1K36	DEC	-.66667E-3B0	#	ACCEL CAL GAIN
2K1	DEC	.173189E15B48	#	GRAVITY CONST (LUNAR)
2K2	DEC	.57740387E-14B-47 #	1/2K1
#	
#	ELEMENTS OF LM STATE ERROR COVARIANCE MATRIX
#
P11	DEC	0B30		#	VARIANCE OF X-POS ERROR
P12	DEC	0B30		# 	COVARIANCE OF X AND Y POS ERROR
P13	DEC	0B20		#	COVAR OF X-POS AND X-VEL ERROR
P14	DEC	0B20		#	COVAR OF X-POS AND Z-VEL ERROR
P21	DEC	0B30		#	COVAR OF X AND Z POS ERROR
P22	DEC	0B30		#	VARIANCE OF Z-POS ERROR
P23	DEC	0B20		#	COVAR OF Z-POS AND X-VEL ERROR

# Page 14
P24	DEC	0B20		#	COVAR OF Z-POS AND Z-VEL ERROR
P33	DEC	0B10		#	VARIANCE OF X-VEL ERROR
P34	DEC	0B10		#	COVAR OF X-VEL AND Z-VEL ERROR
P43	DEC	0B10		#	COVAR OF X-VEL AND Z-VEL ERROR
P44	DEC	0B10		#	VARIANCE OF Z-VEL ERROR
4K2	DEC	-.499286E-4B-12	#	FACTOR IN TB COMP
4K3	DEC	.12464325E-8B-25 #	FACTOR IN TB COMP
6K5	DEC	-.73B0		#	Y-POSITION FILTER WEIGHT
4K25	DEC	2.1B13		#	ENG CUTOFF COMP
4K34	DEC	1.B7		#	AT LOWER LIMIT
4K35	DEC	.1B7		#	ULLAGE THRESHOLD
4K5	DEC	5.742395E6B23	#	NOMINAL BURNOUT ALTITUDE
SUMLIM	DEC	0		#	LAST CELL FOR CHECKSUM
WORDS	DEC	28
VY0FS	DEC	200B13		#	MAX VY0 DISPLAYABLE
4K21	DEC	.26179938B2	#	SC FACTOR FOR ATT ERR OUTPUT
M25B16	DEC	-25.B16		#	CYCLE COUNT TO SECONDS
DTB	DEC	1.25B1		#	1 SEC + DEDA TIME BIAS
ID1	OCT	077776		#	DOWNLINK ID1 CODE
DLWNL	STO	1J1+15		#	END OF DOWNLINK BUFFER
1K56	DEC	-.532333E-7B-14	#	NEG LUNAR RATE-RAD/20MS
2K4	DEC	-.173189E15B48	#	(-2.)(2K1) B49
KDT	DEC	1.B1		#	DELTA T/2 AT 1
#
#	DEDA CONVERSION SCALE FACTORS
#
BM13SF	DEC	.96049535B0	#	.01 DEG/HR TO RAD/20MS AT -13
B23SF	DEC	.64B0		#	100 FT TO FT AT 23
B18SF	DEC	.333333B0	#	.1 MIN TO SEC AT 18
B13VSF	DEC	.625B0		#	.1 FPS TO FPS AT 13
B3SF	DEC	.34971155B0	#	.01 DEG TO RAD AT 3
B23RSF	DEC	.10533045B0	#	.1 NMI TO FT AT 23
B13SF	DEC	.10416666B0	#	.01 MIN TO SEC AT 13
ADDMS	AXT	2,1
	CLA	TS10,1
	ABS
	ADD	MS
	
# Page 15
	TIX	*-3,1
	TRA	EX3+1
SFLO	OCT	000026
SDVX	DEC	0B3		#	DV SUM FOR ACCEL CAL
SDVY	DEC	0		#	(ADDR OF SDVX MUST END IN 4)
SDVZ	DEC	0
MU7	DEC	0B17		#	CALIBRATION COUNTER
SFL1	OCT	145
SFL2	OCT	24
SFL3	OCT	20
TMID	DEC	0		#	TELEMETRY ID
SFL8	OCT	34
SFL7	OCT	62
SFL4	OCT	64
DEDASC	DEC	0		#	DEDA SHIFT COUNTER
DIAK1	OCT	377363
DIAK2	OCT	377401
ORBRET	TRA	DX10P		#	RETURN FROM NORTON IN O.I.
SFL6	OCT	45
#
#
EX36P	STQ	DEL10
#		SAVE QUANTITIES FOR LATER USE IN
#		T/B COMPUTATIONS
	STO	V6Z
	CLA	TS12
	STO	V6X
	CLA	TS13
	STO	V6Y
	CLA	TI
	SUB	4J
	TRA	DXFR14-2
EX34P	CLZ	DEL10
	TMI	EX33PP+1
	TRA	EX34+1
EX37	ADD	VG
	TMI	EX35
	
# Page 16
	TRA	EX35+1
THEF	CLA	RF
	LRS	1		# B24
	ADZ	TS3
	LDQ	TS4
	STO	TS4		# =RF+RX B24
	STQ	TS3		# =RZ B24
	TSQ	ARCTAE
	STO	TS0		# THETAF B8
	SUB	PI
	TMI	*+2
	SUB	2PIB3
	ADD	PI
	STO	THETAF		# THETAF B3
	CLA	TS0		# B3
	SUB	2PIB3
	MPY	M1B1		# B4
	DVP	NI
	ADD	TI		# B13
	TRA	DXFR14-2
#
#
	ORG	1000
CLADD	DEC	0		# PICKUP DEDA DATA
	TRA	ROR
RND	STQ	SREX		# DIRECTION COSINE ROUND
	ADD	1B9
	LRS	9
	TRA	SREX
TMCLA	CLA	0324		# CLA FOR TELEM
TCLTH	CLA	1005
DLSTO	STO	1J1-1
IC1BR	TRA	IC1		# IC1 TRA.
BR1	TRA	NAV1P
DEDABR	TRA	DEDAE		# DEDA BRANCH TRA.
BR50	TRA	EXEC2		# BRANCH 50 TRA.
#

# Page 17
#		HARDWIRE ESCAPE POINTS
#
EXIT1	TRA	EX1+1
EXIT2	TRA	UBCOMP
EXIT3	TRA	ADDMS
EXIT4	TRA	EX4+1
EXIT5	TRA	PGNSDE
EXIT6	TRA	TME
EXIT7	TRA	PGNSD1+5
EXIT8	TRA	EX8+1
EXIT9	TRA	TVTG
EXIT10	TSQ	SOFT1
EXIT11	TSQ	SOFT1		# ASCENT ENG ON
EXIT12	TRA	AHE1
EXIT13	TRA	EROUT+1
EXIT14	TSQ	SOFT2
EXIT15	TRA	LUNAL1		# GAIN CHANGE
EXIT16	TRA	EX16+1
EXIT17	TRA	FDAI1
EXIT18	TRA	NOC
EXIT19	TRA	DELAY
EXIT20	TRA	DLDC
EXIT21	TRA	TIMEA
EXIT22	TRA	IDLE-1
25B17	DEC	25B17
EXIT23	CLZ	VD1X
	CLZ	VD1Y
	CLZ	VD1Z
	TRA	NAV3
EXIT24	TRA	NAV2
EXIT25	TRA	NAV3
SINITC	CLA	4K27
	STO	VD1X
	STO	VDX
	TRA	EXEC1+7
EXIT26	TRA	XDVS
EXIT27	TRA	EX27+1

# Page 18
EXIT28	TRA	EX28+1
STGCTR	CLZ	MU6		# STAGING DELAY COUNTER
	ADD	1B17
	STO	MU6
	TRA	AHE
EXIT29	TRA	EX29+1
PI	DEC	3.14159266B3
EXIT30	TRA	EX30+1
EXIT31	TRA	ALTUP
EXIT32	TRA	LMORB2
EXIT33	TRA	EX33P
EXIT34	TRA	EX34P
EXIT35	TRA	EX35
EXIT36	TSQ	EX36P
EXIT37	TRA	EX37
EXIT38	TRA	Q5
EXIT39	TRA	EXECM
EXIT40	CLZ	S0		# SOFT INITIALIZE
	CLZ	DEL5
	CLZ	FLAGT
	AXT	7,1		# ZERO S SWITCHES
	CLZ	S10,1
	TIX	*-1,1
	TRA	SINITC		# CONTINUE INITIALIZE
EXIT41	TRA	DSP1
EXIT42	TRA	DSP2CP
EXIT43	SUB	25B17		# CHECK FOR TM RESET
	ABS
	COM
	TMI	EXEC1+4		# NOT 25TH CYCLE
	TSQ	TMIE1		# RESET TM AT 25TH CYCLE
	TRA	DELAY
EXIT44	TRA	EX44+1
EXIT45	TRA	EX45+1
EXIT46	TRA	EX46+1
EXIT47	TRA	DEXIT
EXIT48	TRA	CLEARM+1

# Page 19
EXIT49	TRA	SFTEST
EXIT50	TRA	EX50+1
EXIT51	TSQ	DIAT
EXIT52	TRA	EXEC+1
EXIT53	TRA	EXEC+1
TMIE1	STQ	SREX		# INITIALIZE TELEMETRY
	TSQ	TMIE2
	CLA	S12
	ADD	MU8
	STO	MU8S12		# SAVE MU8/S12 FOR TM
	SUB	3B3		# TEST FOR SELF TEST FAILURE
	TMI	*+2
	OUT	6410		# SET FAILURE INDICATOR
	TRA	SREX
#
#	ORBIT ALIGN COMPUTATIONS
#
ORBLIN	AXT	6,1
	CLZ	A11,1
	CLZ	DA11,1		# ZERO REMAINDERS
	TIX	*-2,1
	CLA	1B1
	STO	A11
	STO	A33
	TRA	COA21-2
#
#	MASS UNBALANCE COMPENSATION
#
UBCOMP	MPR	1K14		# 1K14(DVX)	3-16=-13
	ADZ	DAXREM
	STO	DAXREM
#
#		20MS MODE CHECK.
#
MODCK	CLA	S0		# CHECK FOR ALIGNMENT
	SUB	3B3		# SUBMODES
	TMI	GYCOM-2		# -- IS INERT REF
	
# Page 20
	SUB	1B3
	TMI	ZNOC		# IMU ALIGN
	SUB	1B3
	TMI	GYCOM-2		# -- IS LUNAR ALIGN
	SUB	1B3
	TMI	ORBLIN		# ORBIT ALIGN
	CLA	DEL21		# CALIBRATE MODE.
	AXT	2,1
	TMI	*+6		# -- IS LUNAR SURF
	CLZ	SDVX,1	
	ADD	DVX,1	
	STO	SDVX,1		# DV SUM AT 1.
	TIX	*-3,1
	TRA	GYCOM-2
	CLA	A32
	TSQ	HUGH
	CLA	A22
	TSQ	HUGH
	CLA	A12
HUGH	STQ	SREX
	MPR	1K56
	ADZ	DAXREM,1
	STO	DAXREM,1
	TIX	SREX,1
	TRA	GYCOM-2
#
#		DEDA MODE SELECTION
#
DEDAE	CLZ	CLEARP
	TMI	CLEARM		# SET CLEAR
	CLA	CMF
	TMI	RPT		# CLEAR MODE
	CLA	RMF
	TMI	HET		# READOUT IN PROGRESS
	CLA	HMF
	TMI	RRT		# HOLD IN PROGRESS
DEXIT	AXT	3,1		# NORMAL EXIT

# Page 21
	TRA	*+4
CLEARM	STO	CMF
	INP	DEDA
	AXT	5,1		# CLEAR EXIT
	CLZ	READP,1		# RESET FLAGS
	TIX	*-1,1
	CLZ	TMPBR		# SET BRANCH FOR NEXT
	STO 	BRANCH		# GUIDANCE CYCLE
	CLA	1B11		# INITIALIZE COUNTER
	STO	DEDASC
	TRA	DSP1		# TO DISPLAY
RPT	CLZ	READP		# TEST FOR
	TMI	RME		# READOUT MODE
	CLZ	ENTERP		# OR ENTER MODE
	TMI	RME+1		# ENTRY.
	TRA	DEXIT		# EXIT
HET	CLZ	HOLDP		# READOUT TEST FOR
	TMI	*+2		# HOLD COMMANDED
	TRA	ADOUT		# TO OUTPUT ROUTINE
	STO	HMF		# SET HOLD MODE
	CLZ	RMF
	TRA	DEXIT
#
# 	DEDA SCALE FACTOR SELECTION
#
SFTEST	SUB	SFLO
	TMI	CLEARM+1	# -- IF OCT LOC BELOW 0026
	SUB	SFL1		# LESS THAN 173 IS OCTAL
	TMI 	NOTDD
	SUB	49B17		# 173-253 IS 100 FEET
	TMI	SFP
	SUB	4B17		# 254(255-257) IS .1 MIN
	TMI	SFT
	SUB	10B17		# 260-266(267-271) IS .1 FPS
	TMI	SFV
	SUB	5B17		# 272-276 IS .1 MIN
	TMI	SFT
	
# Page 22
	SUB	7B17		# 277(300-302),303(304-305)
#				  	IS .01 DEG
	TMI	SFA
	SUB	6B17		# 306-313 IS .01 MIN
	TMI	SFT1
	SUB	SFL2		# 314-317,337(320-336) IS .1 NMI
	TMI	SFR
	SUB	10B17		# 340-347(350-351) IS 100 FEET
	TMI	SFP
	SUB	SFL3		# (352-357)360-371 IS .1 FPS
	TMI	SFV
	SUB	6B17		# (372)373(374-376)377 IS .1 MIN
	TMI	SFT
	SUB	2B17		# 400-401 IS OCTAL
	TMI	NOTDD
	SUB	4B17		# 402-403(404-405) IS .1 NMI
	TMI	SFR
	SUB	10B17		# 406-417 IS OCTAL
	TMI	NOTDD
	SUB	SFL4		# 420-454,46-463,467-503
#				  (455,464-466) IS .1 FPS
	TMI	SFV
	SUB	SFL8		# 504-537 IS OCTAL
	TMI	NOTDD
	SUB	4B17		# 540-542(543) IS .001 FT/SEC2
	TMI	SFACC
	SUB	3B17		# 544-546 IS .01 DEG/HR
	TMI	SFG
	SUB	SFL6		# 547-613 IS OCTAL
	TMI	NOTDD
	SUB	7B17		# 614-622 IS 1 COUNT
	TMI	SF1
	SUB	SFL7		# 623-704 IS OCTAL
	TMI	NOTDD
	TRA	CLEARM+1	# ILLEGAL ADDRESS
SFP	CLA	B23SF		# PICK UP SCALE FACTOR
	TRA	SFG+1		# TO DECIMAL SET UP
	
# Page 23
SFT	CLA	B18SF
	TRA	SFG+1
SFV	CLA	B13VSF
	TRA	SFG+1
SFA	CLA	B3SF
	TRA	SFG+1
SFT1	CLA	B13SF
	TRA	SFG+1
SFR	CLA	B23RSF
	TRA	SFG+1
SF1	CLA	PMAX
	TRA	SFG+1
SFACC	CLA	BACCSF
	TRA	SFG+1
SFG	CLA	BM13SF
	STO	SF		# SET SCALE FACTOR
	TRA	DDIN		# TO INPUT ROUTINE
DIAT	AXT	1,1		# IMMEDIATE ACTION TEST
	CLA	ADST		# IMMED. ACTION IF
	ADD	DIAK1,1		# ACCUMULATOR = 400000
	ABS
	TMI	*+4
	TIX	DIAT+1,1
	STQ	DDF
	TRA	DEXIT
	TIX	ATI,1
	AXT	2,1
	CLA	A31,1		# STORE DIRECTION COSINES
	STO	A31S,1
	CLA	RRX,1		# SAVE RANGE FOR FILTER
	STO	RRSX,1
	TIX	*-4,1
	CLA	TA1
	SUB	T1
	STO	DELTAT		# DELTA T = TA1 - T1 	B18
	CLA	RRDOT
	STO	RDOTS
	
# Page 24
	TRA	DEXIT
#
#		DOWNLINK FORMATTING
#
DLDC	AXT	2,1
	CLZ	0244,1		# LEM VEL
	STO	1J4,1
	CLZ	0250,1		# CSM POS
	STO	2J1,1
	CLZ	0254,1		# CSM VEL
	STO	2J4,1
	TIX	DLDC+1,1
	CLZ	0247
	LRS	14
	ADZ	0243
	STO	1J7
	STQ	1J7LS
	CLZ	0257
	LRS	14
	ADZ	0253
	STO	2J7
	STQ	2J7LS
	TSQ	CSMPV
	TRA	IC1+3
#
#		DELTA V ACCUMULATION AND THRUST VEL TO GAIN.
#
TVTG	AXT	2,1
	CLA	DVX,1		# 1
	LRS	1		# TO 2
	ADZ	VD2X,1
	STO	VD2X,1
	CLA	DVXM1,1
	LRS	1		# TO 2
	ADZ	VD2X,1
	STO	VD2X,1
	LRS	11		# TO 13
	
# Page 25
	STO	TS1
	ALS	11
	COM
	ADZ	VD2X,1
	STO	VD2X,1		# REMAINDER AT 2
	CLA	VD1X,1		# DV EXPENDED MS.
	ADZ	TS1
	STO	VD1X,1		# VD1 AT 13
	COM
	ADD	VSMGX,1		# VSMG-VD1
	STO	DELVGX,1	# THRUST VEL TO GAIN
	CLZ	EX,1
	TIX	TVTG+1,1
	TRA	EX9+1
#
#	SOFT 40MS COMPUTATIONS
#
SOFT1	CLA	S0		# TEST MODE
	SUB	3B3
	STO	TS1		# SAVE
	TMI	IR		# -- IS INTERT. REF.
ZERR	CLA	ZERO
	OUT	6007		# ZERO ATTITUDE ERRORS
	CLZ	DEL5		# RESET ATT HOLD INIT FLAG
	CLZ	TS1
	TMI	ENCOM1		# -- IS INERTIAL REF
	SUB	1B3
	TMI	SOFT3
	SUB	1B3
	TMI	LUNAL
SOFT3	OUT	7040		# RESET ENG ON
	OUT	6420		# SET ENG OFF
	CLA	ZERO		# SET ENG TM FLAG PLUS
	ADD	S10
	STO	EONS10	
	TRA	FDAI		# TO ATTITUDE DISPLAY
ENCOM1	CLA	DISC1		# FOLLUP ENG. COMMANDS

# Page 26
	LLS	5
	TMI	*+4		# -- DESCENT ENG ON
	LLS	1
	TMI	*+2		# -- ASCENT ENG ON
	TRA	SOFT3		# ENG OFF
	OUT	7020		# RESET ENG OFF
	OUT	6440		# SET ENG ON
	CLA	MS		# SET ENG TM FLAG NG
	TRA	SOFT3+3
IR	CLA	DISC1		# TEST FOR AUTO RADAR DATA
	ALS	3
	TMI	IR1		# -- IS FOLLOWUP
	ALS	1
	TMI	IR2		# -- IS AUTOMATIC
	STQ	DEL20
	TRA	AHE		# TO ATT HOLD
IR1	CLA	DISC1C
	ALS	4
	TMI	ZERR		# PLUS IS AUTOMATIC
	CLZ	DEL5
	STQ	DEL20
	TRA	MODE
RSTE	AXT	2,1
	CLA	S623
	ALS	3
	TMI	*+3
	CLA	WCX,1
	TRA	*+2
	CLA	WBX,1
	MPR	A31,1
	COM
	ADZ	EX
	STO	EX
	CLA	S11
	ALS	3
	TMI	*+4
	CLA	DISC1C
	
# Page 27
	ALS	6
	TMI	*+5
	CLA	A11,1
	MPR	A11BD,1
	ADZ	EY
	STO	EY
	TIX	RSTE+1,1
	CLA	EY
	MPR	4K8
	COM
	STO	EZ
	CLZ	EY
	MPR	4K7
	STO	EY
RST1	TRA	RST
IR2	ALS	4
	TMI	IR3		# -- IS ABORT STAGE
	CLA	DEL21		# IF ON LUNAR SURFACE
	TMI	ZERR		# OUTPUT ZERO ATT ERRORS
	CLA	DISC1
	ALS	7
	TMI	MODE		# -- IS ABORT
	TSQ	IR1+4
IR3	CLA	DEL21
	TMI	AHE
	CLA	DISC1C
	ALS	6
	TMI	MODE
	CLA	MU6
	SUB	4K23
	TMI	STGCTR		# STAGING ATT HOLD
MODE	CLA	S0		# TEST STEERING MODE
	SUB	1B3
	TMI	AHE		# ATT HOLD
	SUB	1B3
	TMI	RSTE		# RENDEZVOUS STEERING
	CLZ	DEL5		# ACQUISITION STEERING
	
# Page 28
	AXT	2,1
MODE1	CLA	WCX,1
	MPR	A11,1
	ADZ	EZ
	STO	EZ
	CLA	S507		# ORIENT LM Z-BODY ASIX
	SUB	1B3		# IN DESIRED THRUST DIR.
	TMI	*+3		# OR ESTIMATED CSM DIR.
	CLA	A11BD,1
	STO	A31BD,1
	CLA	A31BD,1
	MPR	A11,1		# XB
	ADZ	EY
	STO	EY
	CLA	A31BD,1		# ZBD
	MPR	A21,1		# YB
	COM
	ADZ	EX
	STO	EX
	TIX	MODE1,1
	TRA	EROUT
SOFT2	CLZ	DEL20		# FIRST TIME FOLLOW
	TMI	ENCOM1		# PREVIOUS ENGINE STATE
	CLA	S0		# IF NOT GUIDANCE STEERING
	SUB	1B3		# TURN ENGINE OFF
	TMI	SOFT3
	SUB	1B3
	TMI	*+2
	TRA	SOFT3
	CLA	MU8		# TEST FOR ULLAGE
	SUB	1K9
	TMI 	SOFT3
	CLA 	4K25		# TEST CEL TO BE
	SUB	DELVGX		# GAINED GREATER THAN
	TMI	ENCOM1+6	# SHUTDOWN THRESHOLD
	CLA	4K26
	SUB	DELVG
	
# Page 29
	TMI	ENCOM1+6
	CLZ	S0		# SET ATT HOLD
	CLZ	S11		# DPS-RCS/APS
	TRA	SOFT3
LUNAL1	CLZ	DAYA		# CHANGE GAIN
	LRS	2		# 1/4
	STO	DAYA
	CLZ	DAZA
	LRS	2
	STO	DAZA
	TRA	SOFT3
#
#		START OF NAVIGATION
#
NAV1P	CLA	DEL21
	TMI	NAV1		# -- IS ON LUNAR SURFACE
	CLA	VD1X		# COMPUTE THRUST ACCEL
	SUB	VDX		# 13
	ALS	5		# 1/2(VD1-VD) AT 7
	TRA	5166		# TO HARD NAV
XDVS	AXT	2,1
	CLA	DVSX,1
	ADD	1B12
	LRS	6
	ADZ	DQSX,1
	STO	DQSX,1
	CLA	VD1X,1
	STO	VDX,1
	TIX	XDVS+1,1
	TRA	NAV4
ALTUP	TSQ	EXEC
#
	AXT	2,1
	CLA	25J		# ALTITUDE ENTRY TEST
	SUB	1B17
	TMI	FLTR		# IF NO 25J ENTRY
	CLA	25J
	
# Page 30
	ADD	5J
	STO	R		# R=5J+25J
	MPY	U1X,1
	LLS	1
	STO	RX,1		# NEW R COMPONENTS
#
# 	RANGE AND RANGE RATE COMPUTATIONS
#
FLTR	CLA	RCX,1		# RELATIVE RANGE
	SUB	RX,1
	STO	RRX,1
	STO	TS4,1
	TIX	ALTUP+2,1
	TSQ	DPVMAG		# DP COMP OF RR MAG
	STO	RR		# B23 RANGE VECTOR MAG
	CLA	2K1		# 48
	LRS	1		# 49
	DVP	R		# 26
	DVP	R		# 3
	DVP	R		# -20
	STO	25J		# 2K1/R**3 B-20
	CLZ	RRDOT		# ZEROED FOR SUM
	AXT	2,1
FLTRA	CLA	RRX,1
	MPY	1B1		# B24
	DVP	RR
	STO	A31BD,1		# B1 UNIT POINTING VECTOR
	CLA	VCX,1		# B13
	SUB	VX,1
	STO	RDOTX,1
	MPR	A31BD,1
	ALS	1
	ADZ	RRDOT
	STO	RRDOT
	CLA	U1X,1
	MPR	U1X,1		# B2
	MPR	3B3
	
# Page 31
	SUB	1B5
	MPR	25J
	STO	LILA,1		# B-15
	TIX	FLTRA,1
	CLA	U1X
	MPR	U1Z
	MPR	3B3		# B5
	MPZ	25J
	STO	LILC		# B-15
	TSQ	EXEC		# END OF FIRST BR. OF FILTER
#
PUPDAT	CLZ	MU17		# ZERO MU17 IF FILTER TIME
	ADD	1B3
	TMI	FLTRTM
	STO	MU17
	TSQ	EXEC
FLTRX	TSQ	EXEC
	TRA	5444
#				  COVARIANCE UPDATE
FLTRTM	TOV	*+1		# RESET OVERFLOW DISCRETE
	AXT	3,1
FLTRB	CLA	P11,1		# 30, 30, 20, 20
	MPR	LILA
	STO	TS4		# 15, 15, 5, 5
	CLA	P21,1		# 30, 30, 20, 2
	MPR	LILC		# B-15
	ADZ	TS4
	STO	TS10,1		# TS10 A*P11+C*P21	B15
	CLA	P11,1		# TS11 A*P12+C*P22	B15
	MPR	LILC		# TS12 A*P13+C*P23	B5
	STO	TS4		# TS13 A*P14+C*P24	B5
	CLA	P21,1		# TS14 C*P11+J*P21	B15
	MPR	LILJ		# TS15 C*P12+J*P22	B15
	ADZ	TS4		# TS16 C*P13+J*P23	B5
	STO	TS14,1		# TS17 C*P14+J*P24	B5
	TIX	FLTRB,1
	CLA	P13		# B20	32XB25
	
# Page 32
	LRS	5		# MPY BY 32,SCALE AT B30
	ADD	1B17		# ADD 2**13
	ADD	P11
	STO	P11		# B30
	CLA	P14
	ADD	P23		# B20	16XB24
	LRS	6		# MPY BY 16,SCALE AT B30
	ADD	P12
	STO	P12		# B30
	STO	P21
	CLA	P24		# B20	32XB25
	LRS	5		# MPY BY 32,SCALE AT B30
	ADD	1B17		# ADD 2**13
	ADD	P22
	STO	P22		# B30
	CLA	TS11		# EXCHANGE TS11,TS14
	LDQ	TS14
	STQ	TS11
	STO	TS14
	AXT	1,1
FLTRC	CLA	P33,1		# P34	B10
	LRS	5		# MPY BY 16, SCALE AT B19
	ADD	TS10,1		# B15	16XB19
	LRS	1		# SCALE AT B10
	ADD	P13,1
	STO	P13,1		# B20
	CLA	P43,1		# P44	B10
	LRS	5		# MPY BY 16, SCALE AT B19
	ADD	TS14,1		# B15	16XB19
	LRS	1		# SCALE AT B20
	ADD	P23,1
	STO	P23,1		# B20
	TIX	FLTRC,1
	CLA	TS12		# B5	32XB10
	ADD	1B17		# ADD 2**(-7)
	ADD	P33
	STO	P33		# B10
	
# Page 33
	CLA	TS13
	ADD	TS16		# B5	16XB9
	LRS	1		# SCALE AT B10
	ADD	P34
	STO	P34		# B10
	STO	P43
	CLA	TS17		# B5	32XB10
	ADD	1B17		# ADD 2**(-7)
	ADD	P44
	STO	P44		# B10
	CLZ	S17		# IS FILTER INIT. REQUIRED
	ALS	3		# FORCE OVERFLOW IF =1B3
	TOV	PINIT
	TRA	FLTRD
PINIT	AXT	3,1		# INITIALIZE P MATRIX
	CLZ	P11,1
	CLZ	P21,1
	CLZ	P33,1
	TIX	*-3,1
	CLA	6K2
	STO	P11
	STO	P22
	CLA	6K4
	STO	P33
	STO	P44
	CLA	29J
	STO	T1	
FLTRD	CLA	17J
	ABS
	SUB	1B17
	TMI	FLTRH		# NO RATE CHECK RANGE
RATE	CLZ	17J
	SUB	RDOTS
	STO	DELR1		# B13
#				  NOT, DELR2 IS ALREADY
#				  ZERO SINCE IT IS TIME
#				  SHARED WITH RIZ

# Page 34
	CLZ	Q12
	CLA	PMAX		# =1B0
	STO	Q22
	AXT	3,1
FLTRE	CLA	RRDOT		# B13
	MPR	A31BD,1		# B14
	ALS	1
	SUB	RDOTX,1		# B13
	MPY	1B1		# SCALE AT B14
	DVP	RR		# B22
	STO	TS0,1		# B-1
	CLZ	L11,1
	CLZ	L12,1
	TIX	FLTRE,1
	CLZ	TS2
	STO	TS1
	CLA	A31BD
	COM			# TS0 = M11	B-9
	STO	TS2		# TS1 = M12	B-9
	CLA	A33BD		# TS2 = M13	B1
	COM			# TS3 = M14	B1
	STO	TS3
	AXT	1,1
FLTRF	CLA	P13,1		# B20
	MPR	TS2,1		# B1
	ADZ	L11
	STO	L11		# L11=P13(M13)+P14(M14)  B21
	CLA	P23,1		# B20
	MPR	TS2,1		# B1
	ADZ	L21
	STO	L21		# L21 = P23(M13)+P24(M14)  B21
	CLA	P33,1		# B10
	MPR	TS2,1
	ADZ	L31
	STO	L31		# L31 = P33(M13)+P24(M14)  B11
	CLA	P43,1		# B10
	MPR	TS2,1
	
# Page 35
	ADZ	L41
	STO	L41		# L41 = P43(M13)+P44(M11)  B11
	TIX	FLTRF,1
	CLZ	DELTA
	AXT	3,1
FLTRG	CLA	P11,1		# B30,30,20,20
	MPR	TS0		# M11  B=9
	STO	TS10		# B21
	CLA	P21,1
	MPR	TS1		# M12  B-9
	ADZ	TS10		# B21,21,11,11
	ADZ	L11,1
	ALS	1		# B20,20,10,10
	STO	L11,1		# L11=P11M11+P21M12+P13M13+P14M14
	MPR	TS0,1
	ALS	1
	ADZ	DELTA		# DELTA=M1J DOT PJ1  B10
	STO	DELTA
	TIX	FLTRG,1
	ADD	6K8
	STO	DELTA
	STO	Q11
	TRA	FLTRJ-1
#
#
FLTRH	CLA	18J		# CHECK RANGE
	SUB	1B17
	TMI	FLTRX-1
RANGE	AXT	2,1
FLTRI	CLA	A31S,1		# ZB B1
	MPR	18J	
	ALS	1
	SUB	RRSX,1
	STO	DELR1,1		# B23
	CLA	RRX,1
	MPR	6K9		# B8
	ALS	1		# B7
	
# Page 36
	STO	TS1		# TRICKY, YES
	MPR	RRX,1		# B30
	STO	TS0,1		# B30
	CLA	A31BD,1		# B1
	MPR	A31BD,1		# B2
	MPR	6K10		# 2+28	B30
	STO	TS4,1
	TIX	FLTRI,1
	ADZ	TS2
	ADD	P11
	STO	Q11		# B30(?)
	CLA	TA1
	STO	T1		# T1 = TA1
	CLA	TS1		# (RRX)(6K9)  B7
	MPR	RRZ		# B30
	COM
	ADD	P12
	STO	Q12		# B30  Q12=P12-6K9(RRX)(RRZ)
	MPR	Q12
	STO	TS1		# B60
	CLZ	TS0
	ADZ	TS6
	ADD	P22
	STO	Q22		# B30
	MPR	Q11		# B60
	SUB	TS1
	STO	DELTA		# B60
	AXT	3,1
	CLA	P11,1
	COM
	STO	L11,1
	CLA	P21,1
	STO	L12,1
	TIX	*-5,1
	CLA	6K5		# B0
	MPR	DELR3		# B23
	ADD	RY		# Y=Y+6K5*DELR3  B23
	
# Page 37
	STO	RY
	CLA	6K6		# B8
	MPY	DELR3
	DVP	DELTAT		# TO B13
	ADD	VY		# VY=VY+6K6*DELR3/DELTAT
	STO	VY		# UPDATED VY AT B13
	TSQ	EXEC		# END OF 2ND BR.OF FILTER
#				  POINT B
#			  	  SCALING COMMENTS
#				  RANGE, RATE
FLTRJ	AXT	3,1
	CLA	L12,1		# B30,30,20,20
	MPY	Q12		# AT B30
	LRS	3
	DVP	DELTA		# AT B60
	STO	TS1		# B3,3,-7,-7
	CLA	L11,1		# B30,30,20,20	20,20,10,10
	MPY	Q22		# AT B30	B0 FOR RATE
	LRS	3
	DVP	DELTA		# AT B60	B10 FOR RATE
	ADD	TS1
	STO	B11,1		# B3,3,-7,-7	13,13,3,3
	MPR	DELR1		# B23	B13 FOR RATE
	STO	TS4,1		# B26,26,16,16	26,26,16,16
	CLA	L11,1		# B30,30,20,20	B20,20,10,10
	MPY	Q12		# B30	ZERO
	LRS	3
	DVP	DELTA		# B60
	STO	TS1		# B3,3,-7,-7
	CLA	L12,1		# B30,30,20,20	ZERO
	COM
	MPY	Q11		# B30
	LRS	3
	DVP	DELTA
	SUB	TS1
	STO	B12,1		# B3,3,-7,-7	ZERO FOR RATE
	MPY	DELR2
	
# Page 38
	ADD	TS4,1		# DRX,DRZ,DVX,DVZ
	ALS	3
	STO	TS4,1		# B23,23,13,13
	TIX	FLTRJ+1,1
	ADD	RX
	STO	RX
	CLA	TS5
	ADD	RZ
	STO	RZ
	CLA	TS6
	ADD	VX
	STO	VX
	CLA	TS7
	ADD	VZ
	STO	VZ
	AXT	3,1
FLTRK	CLA	B11		# B3		B13
	MPR	L11,1		# B30,30,10,10	B20,20,10,20
	STO	TS0
	CLA	B12		# B3	ZERO FOR RATE
	MPR	L12,1
	SUZ	TS0
	ALS	3
	ADD	P11,1
	STO	P11,1		# B30,30,20,20 FOR BOTH
	CLA	B21		# B3	B13 FOR RATE
	MPR	L11,1		# B30,30,20,20	20,20,10,10
	STO	TS0
	CLA	B22		# B3	ZERO FOR RATE
	MPR	L12,1		# B30,30,20,20	ZERO
	SUZ	TS0
	ALS	3
	ADD	P21,1
	STO	P21,1		# B30,30,20,20 FOR BOTH
	TIX	FLTRK,1
	AXT	1,1
FLTRL	CLA	B31		# B-7	3

# Page 39
	MPR	L31,1		# B20,20	10,10
	STO	TS0
	CLA	B32		# B-7	ZERO FOR RATE
	MPR	L32,1		# B20,B20	ZERO FOR RATE
	SUZ	TS0
	ALS	3
	ADD	P33,1		# B10,10 FOR BOTH
	STO	P33,1
	TIX	FLTRL,1
	CLA	B41		# B-7	B3
	MPR	L41
	STO	TS0
	CLA	B42		# B-7	ZERO
	MPR	L42
	SUZ	TS0
	ALS	3
	ADD	P44		# B10 FOR BOTH
	STO	P44
	CLA	P34
	STO	P43
	CLA	P12
	STO	P21
	CLZ	18J
	TRA	FLTRX
LMORB2	SUB	5J		# QL-5J AT B23
	STO	QLTELE		# PERIC. ALT
	CLZ	TS7		# = VH SQ AT B26
	STO	VHSQ		# SAVE FOR ORB INS
	TSQ	EXEC
#
ORBLM	AXT	2,1
	CLA	RX,1
	STO	R0X,1
	CLA	VX,1
	STO	V0X,1
	TIX	ORBLM+1,1
	TSQ	ORBPM		# COMPUTE LM ORBIT PARAMETERS
	
# Page 40
#				  RETURN FROM ORBPM W/ ACC=SI
	STO	TS3		# B0
	LRS	3		# TO B3
	STO	Y		# SAVE FOR TPERG
	CLA	CI
	STO	TS4
	TSQ	ARCTAE		# RTN W/ ACCU=E
	COM
	ADD	2PIB3
	ADZ	Y		# 2*PI-E+SI AT B3, ZERO Y
	MPY	1B1		# TO B4
	DVP	NI		# AT B-9
	STO	TPERG		# B13
	CLA	AI
	SUB	5J
	ALS	1		# MPY BY 2
	SUB	QLTELE
	STO	QA		# LM APOFOCUS ALT. AT B23
	TSQ	EXEC
#
#				  Y ZEROED IN PREVIOUS BR
	CLZ	VY0
	AXT	2,1
KINGK	CLA	RX,1
	STO	RIX,1		# SAVE R FOR ORBIT INS.
	MPR	WCX,1
	ALS	1
	ADZ	Y
	STO	Y		# Y=(WCX)DOT(RX)
	CLA	VX,1
	STO	VIX,1		# SAVE V FOR ORBIT INS.
	MPR	WCX,1
	ALS	1
	ADZ	VY0
	STO	VY0		# VY0=(WCX)DOT(VX)
	CLA	WCX,1		# SET UP FOR CROSS
	COM			# PRODUCT SUBROUTINE
	
# Page 41
	STO	TS10,1		# WC X U1 = U1 X -WC
	CLA	U1X,1
	STO	TS4,1
	TIX	KINGK,1
	TSQ	CRSPRD
	TSQ	NORMV		# V1 VECTOR TO TSB
	TSQ	CRSPRD
	CLZ	TS3
	CLZ	TS4
	AXT	2,1
	CLZ	TS10,1
	STO	V1X,1		# V1 AT 1
	MPR	A31,1
	ADD	TS4		# TS4 = V1 DOT ZB AT B2
	STO	TS4
	CLZ	TS14,1
	ALS	1
	STO	W1X,1
	CLA	A31,1
	MPR	U1X,1
	ADD	TS3
	STO	TS3		# TS3 = U1 DOT ZB AT B2
	TIX	*-12,1
	TSQ	ARCTAE
	STO	XI
	TSQ	EXEC		# END OF LEM ORB PAR BRANCH
#
#	GUIDANCE MODE CHECK
#
GM	CLA	S10
	ADD	3B3
	TMI	XDV		# EXTERNAL DELTA V
	ADD	2B3
	ABS
	TMI	DXFR1		# TPI SEARCH
	CLA	S10
	COM
	
# Page 42
	TMI	*+5
	CLZ	TDEL		# TDEL=0
	CLA	ORBRET		# =TRA DX10P
	STO	TSEX		# SET UP RETURN FROM NORTON
	TRA	NORTON+5
#		CSI,CDH,TPI EXECUTE, OR EXT DV
	CLA	TIG		# COMPUTE TDEL FOR
	SUB	TA1		# CSI, CDH, OR TPI(S10=4)
	ALS	5
	STO	TDEL
DXFR1	CLA	TDEL
	LRS	5
	ADD	TA1
	STO	TIG
	CLA	TDEL		# TDEL = OR GTR 0 AFTER TR CALC
	ADD	6J
	STO	TR		# TIME UNTIL RENDEZVOUS (TPI)
	CLZ	TDEL		# LIMIT TDEL POSITIVE
	TMI	*+2
	STO	TDEL
	CLZ	S7		# ZERO S7 WHEN NOT IN XDV
	CLA	TDEL
DXFR10	TSQ	NORTON
DX10P	STO	RF		# PRED. BURNOUT ALTITUDE
	ADD	2K14
	STO	P
	CLZ	RADOT
	CLZ	VPY
DXFRR5	CLZ	RIX,1		# R5 STORE
	STO	R5X,1
	CLZ	VIX,1
	STO	TS14,1
	STO	V5X,1		# V5 STORE
	MPR	WCX,1
	ALS	1		# TO 13
	ADZ	VPY		# VPY = V5 DOT WC
	STO	VPY
	
# Page 43
	CLZ	TS10,1
	STO	U1X,1		# U1 STORE
	MPR	V5X,1		# RADOT = R5 DOT U1
	ALS	1		# TO 13
	ADZ	RADOT
	STO	RADOT
	CLA	REX,1		# CSM POS AND VEL FOR
	STO	R0X,1		# ELLIPSE PREDICTOR
	CLA	VEX,1		# AND ORBIT PARAMETERS
	STO	V0X,1
	TIX	DXFRR5,1
	TSQ	NORMV
	CLA	TS13
	STO	VHA
	TSQ	EXEC
ORBIT3	TSQ	ORBPM		# CSM ORBIT PARAMETERS
	CLA	TB
	SUB	TCSM
	ADD	TDEL		# +TIME INC. TO DXFR
	TMI	*+2
	SUB	TCSM
	TSQ	NORTON
DXFR13	CLZ	TS3
	CLA	RIX,1
	SUB	R5X,1
	STO	VIX,1		# RC-R5
	CLA	WCX,1
	STO	TS4,1
	CLA	U1X,1
	STO	TS10,1
	MPR	VIX,1		# U1 DOT (RC-R5)
	ADZ	TS3		# SCALE BOTH RX AND RZ
	STO	TS3		# AT 24 FOR ARCTAE
	TIX	DXFR13+1,1
	TSQ	CRSPRD
	TSQ	NORMV
	CLZ	TS4
	
# Page 44
VRUP1	AXT	2,1
	CLA	TS10,1
	MPR	VIX,1
	ADZ	TS4
	STO	TS4		# RZ AT 24
	TIX	VRUP1+1,1
	CLA	S10
	SUB	3B3
	TMI	THEF		# S10 = 1 OR 2
	TSQ	ARCTAE		# TLOS=ARCTAN(RX/RZ)
	STO	TLOS		# LINE OF SIGHT (DEDA)
	CLA	TR
	SUB	TDEL
	STO	T
	CLA	TB
	SUB	TCSM
	ADD	TR		# TIME INC. TPI TO REND.
	SUB	3J		# TARGET OFFSET
	STO	TI
	TSQ	EXEC
DXFR14	CLA	S10
	COM
	TMI	CSMT1		# TO ELLIPX
#
#		ORBIT INSERTION SECTION
#
	CLA	VY0
	COM
	MPR	VY0
	ADD	VHSQ		# VH SQ
	TSQ	SQRTE
	STO	VHA		# B13
	CLA	4K5		# COMPUTE DESIRED BURNOUT
	SUB	RB		# ALTITUDE RATE
	MPY	4K4
	LLS	3
	STO	RFDOT
	
# Page 45
	SUB	4K6		# LIMIT RFDOT BETWEEN
	TMI	*+3		# 23J AND 4K6
	CLA	4K6
	TRA	*+5
	CLA	23J
	SUB	RFDOT
	TMI 	*+3
	CLA	23J
	STO	RFDOT
	CLA	RB
	STO	RF
	CLA	4K10
	MPR	THETAF
	ADD	7J
	STO	AL
	SUB	9J		# LIMIT AL BETWEEN
	TMI	*+3		# 8J AND 9J
	CLA	9J
	TRA	*+5
	CLA	8J
	SUB	AL
	TMI	*+3
	CLA	8J
	TRA	CDH3		# AL IN ACCUM
	CLA	AL
	TRA	CDH3+1
# 	EXTERNAL DELTA V
XDV	CLA	S7
	ALS	3
	TMI	XDV1
	CLA	MU8
	SUB	1B17
	TMI	XDV2
	CLA	1B3		# ULLAGE DETECTED SET S7
	STO	S7
XDV1	AXT	2,1
	CLA	DVGXX,1		# INPUT VEL TO GAIN
	
# Page 46
	SUB	DQSX,1		# ACCUM DELTA V
	STO	TS4,1
	STO	VGX,1
	TIX	XDV1+1,1
	TSQ	DPVMAG
	STO	VG		# VEL TO GAIN MAG
	TRA	Q7		# TO STEERING			
XDV2	AXT	2,1		# LOAD NDX FOR STEER/XDV
	CLA	28J1		# IF IN TPI, DELV = VG
	SUB	2K11		# IF IN EXT DELTA V EQUAL
	TMI	*+4		# FUNCTIONOF 28J
	CLZ	DQSX,1		# ZERO DQS VECTOR
	CLA	VGX,1
	TRA	XDV2P
	CLA	28J3		# RADIAL COMPONENT
	MPR	U1X,1		# 13+1=14
	STO	DQSX,1
	CLA	28J2		# CROSSRANGE COMPONENT
	MPR	W1X,1
	ADZ	DQSX,1
	STO	DQSX,1
	CLA	28J1		# DOWNRANGE COMPONENT
	MPR	V1X,1
	SUZ	DQSX,1
	ALS	1		# TO 13
XDV2P	STO	DVGXX,1		# VELOCITY TO GAIN
	TIX	XDV2+1,1
	TRA	XDV1
#
Q5	CLA	RFDOT		# GUIDANCE LAW
	STO	TS4		# SET FOR INDEXING
	CLZ	TS5
	CLA	RADOT
	STO	TS10
	CLA	VY0
	STO	TS11
	AXT	1,1
	
# Page 47
	TOV	*+1
	CLA	RD3DOT,1	# -2
	MPR	TBO		# 9-2=7
	LRS	1		# TO 8
	STO	TS1		# 1/2 AT 7
	CLA	TS4,1		# RFDOT OR ZERO
	SUB	TS10,1		# RDOT OR VY0
	STO	TS2
	MPY	1B3		# B16
	DVP	TBO		# 16-9=7
	SUZ	TS1		# R OR YD2DOT
	STO	TS0		# TEST FOR OVERFLOW
	CLZ	TS2		# SIGN IF OVERFLOW
	TSQ	OVFLT
	STO	RD2DOT,1
	CLA	SIXTH		# -2
	MPR 	RD3DOT,1	# -4
	MPR	TBO		# 5
	LRS	1		# TO 6
	ADD	RD2DOT,1	# +1/2 2DOT AT 6
	MPR 	TBO		# 15
	ALS	1		# TO 14
	STO	TS1
	CLA	TS10,1
	LRS	1		# TO 14
	ADZ	TS1
	MPR	TBO		# 23
	ADD	R,1
	STO	TS14,1		# RF OR YF
	TIX	Q5+8,1
	STO	RF		# 23
	STO	RB		# SAVE RF FOR ORBIT INSERT.
	SUB	5J		# -LUNAR RADIUS
	SUB	16J		# BURNOUT ALT ERROR
	STO 	TS14
	LDQ	5K20
	CLA	4K12
	
# Page 48
	SUB	AT
	TMI	*+3		# IF AT GT 4K12
	CLA	DEL2	
	TMI	*+2		# IF AT LE 4K12 AND DEL2=1
	LDQ	5K18
	STQ	RD3DTL		# RD3DOT LOWER LIMIT
	CLA	TBO
	MPR	TBO
	MPR	TBO		# TB CUBED
	STO	TS1		# 27
	AXT	1,1
GDLAW3	TOV	*+1
	CLA	TS14,1		# BURNOUT ERROR
	MPY	12B4		# 27
	LLS	2		# TO 25
	DVP	TS1		# -2
	ADZ	RD3DOT,1	# DESIRED ACCEL RATE
	STO	TS0		# TEST FOR OVERFLOW
	CLA	TS14,1
	TSQ	OVFLT
	STO	RD3DOT,1
	TMI	*+5
	SUB	5K14,1		# UPPER LIMIT TEST
	TMI	*+5
	CLA	5K14,1		# SET AT UPPER LIMIT
	TRA	LL3DOT+1
	SUB	RD3DTL,1	# LOWER LIMIT TEST
	TMI	LL3DOT
GDLAW4	TIX	GDLAW3,1
	CLA	2K1		# 48
	MPY	1B1		# B49
	DVP	R		# 49-23-26
	SUZ	VHSQ		# VH SQ
	MPY	1B4		# B30
	DVP	R		# -ORBITAL RAD ACCEL AT 7
	ADZ	RD2DOT
	STO	RD2DOT		# CMD RAD ACCEL AT 7
	
# Page 49
	TSQ	EXEC
#
#		STEERING EQUATIONS.
#
STEER	CLA	21J
	SUB	H
	TMI	STEER1
	CLA	22J
	SUB	HDOT
	TMI	STEER1
	CLA	1B3		# =1024B13	COMMAND X-AXIS VERT
	STO	VG
	CLA	PMAX		# PSIP=1
	TRA	*+9
STEER1	AXT	1,1
	TOV	*+1
	CLA	RD2DOT,1	# PSIP AND PSIY COMPS
	LDQ	ZERO
	DVP	AT		# PSIP OR Y AT ZERO
	STO	TS0		# TEST FOR OVERFLOW
	CLA	RD2DOT,1	# SIGN IF OVERFLOW
	TSQ	OVFLT
	STO	TS10,1		# PSIP OR PSIY AT 0
	TIX	STEER1+1,1
	MPR	TS10
	STO	TS14		# (PSIP)SQ AT 0
Q7	CLA	MU8		# TEST IF ENG ON
	SUB	1B17
	TMI	*+4
	CLA	VG
	SUB	5K26		# CONSTANT STEERING IF
	TMI	STEER5
	CLA	S10
	SUB	1B17
	TMI	STEER2
	AXT	2,1		# XBD FOR EXT DELTA V
	CLA	VGX,1
	
# Page 50
	MPY	1B1		# B14
	DVP	VG		# RESULT AT B1
	STO	A11BD,1
	TIX	*-4,1
STEER5	CLZ	TS0
	CLZ	TS1
	CLZ	TS2
	AXT	2,1		# COMPUTE VELOCITY TO BE
	CLA	A11BD,1		# GAINED COMPONENTS
	MPR	A11,1
	ADZ	TS0
	STO	TS0
	CLA	A11BD,1
	MPR	A21,1
	ADZ	TS1
	STO	TS1
	CLA	A11BD,1
	MPR	A31,1
	ADZ	TS2
	STO	TS2
	TIX	*-12,1
	AXT	2,1
	CLA	VG
	STO	DELVG
	MPY	TS0,1
	LLS	2		# TO 13
	ADD	VDX,1
	STO	VSMGX,1		# 13
	TIX	*-6,1
	TSQ	EXEC
IDLE	TRA	TEST
STEER2	CLA	PMAX
	SUZ	TS14
	STO	TS14		# 1-(PSIP)SQ
	TSQ	SQRTE
	STO	TS15
	CLA	TS11
	
# Page 51
	ABS
	SUB	TS15
	TMI	STEER3
	CLA	TS11
	TMI	*+3
	CLA	TS15
	TRA	*+3
	CLA	TS15
	COM
	STO	TS11
STEER3	CLA	TS11
	MPR	TS11
	COM
	ADZ	TS14
	TSQ	SQRTE
	STO	TS12
STEER4	AXT	2,1
	CLA	TS10
	MPR	U1X,1
	STO	TS1
	CLA	28J1
OUT1	TMI	OUT		# IF 28J1 NEGATIVE
	CLA	TS12
	MPR	V1X,1
	ADZ	TS1
	STO	TS1
	CLA	TS11
	MPR	W1X,1
	ADZ	TS1
	STO	A11BD,1
	TIX	STEER4+1,1
	TRA	STEER5
OUT	CLA	TS12
	COM
	TRA	OUT1+2
OVFLT	TOV	*+3
	CLA	TS0
	
# Page 52
	TRA	EXIT		# EXIT WITH COMPUTED VALUE
	TMI	*+3
	CLA	PMAX		# POSITIVE LIMIT
	TRA	*+2
	CLA	NMAX
	TRA	EXIT
#
#		DISPLAY ROUTINE SOFT PORTION.
#
DSP1	TOV	*+1		# CL. O.F.
	CLZ	DSPF1		# H,HDOT MODE.
	TMI	*+2		# -- IS INITIALIZE
	TRA	DSPLY		# TO COUNTER CHECK. (HARD)
	CLA	H
	STO	POUT
	CLA	HDOT
#		Q REGISTER DOES NOT NEED TO BE ZERO
#		SINCE DVP K55 IS AT WORST A LEFT
#		SHIFT OF 2 AND THE ALT RATE REGISTER
#		IS ONLY 15 BITS LONG
	DVP	K55
	TRA	DSPLY1
DSP2CP	CLA	VY0		# OUT-OF-CSM PLANE VEL.
	LRS	17		# SET SIGN OF Q AND USE
	LLS	17		#	UP TIME
	STQ	TS10		# SAVE SIGN
	ABS
	DVP	VY0FS		# =FULL-SCALE VALUE(200 FPS)
	TOV	*+2
	TRA	*+2
	CLA	PMAX
	ADZ	TS10		# VY0 IN SIGN-MAGNITUDE
	TRA	DSPLY3-1	# TO OUTPUT,(HARD)
#
#		EXECUTIVE PART 2. (BRANCH 50)
#
EXEC2	CLA	BR1		# SET NAV BRANCH

# Page 53
	STO	BRANCH
	TSQ	TMIE1		# RESET TM
	CLZ	DDF		# DEDA DATA FLAG.
	TMI	NEWDD
EXECM	CLZ	IDRF		# TEST IF DOWNLINK DATA
	TMI	EXECM2		# HAS BEEN RECEIVED
EXECM1	CLA	S0
	SUB	3B3
	TMI	EXECA		# S0-3(--IS INER. REF)
	SUB	1B3		
	TMI	EXEC6		# S0-4(--IS IMU ALIGN)
	SUB	1B3
	TMI	DELAY		# S0-5(--IS LUN ALIGN)
	SUB	1B3
	TMI	EXECA		# S0-6(--IS ORB ALIGN)
	ADD	7B3		# S0+1
	TMI	INCMU7		# S0=7
CAL	CLA	DEL21		# CALIBRATE MODE
	TMI	*+2
	TSQ	EADICS		# IMU DIR COSINES
	TSQ	ATTERR		# COMPUTE ATTITUDE ERRORS
	AXT	2,1
	CLA	1K33		# -3
	MPY	EX,1		# 2
	LLS	12		# -3+2-12=-13
	ADZ	DAXREM,1
	STO	DAXREM,1	# -13
	CLA	1K34		# -15
	MPR	EX,1		# 2
	ADZ	1K1,1
	STO	1K1,1		# GYRO BIAS AT -13
	TIX	*-9,1
INCMU7	CLZ	MU7		# INCR. COUNTER
	ADD	1B17
	STO	MU7
	SUB	1K37		# ACCEL. CAL. DURATION
	ABS
	
# Page 54
	COM
	TMI	*+7		# + IS TIME FOR ACCEL CAL
	AXT	2,1
	CLZ	SDVX,1
	MPR	1K36
	ADZ	1K19,1
	STO	1K19,1		# NEW BIAS CORRECTION
	TIX	*-4,1
	CLA	MU7
	SUB	1K30
	TMI	EXECA
	CLZ	S0		# CAL COMPLETE, SET ATT HOLD
EXECA	CLZ	DAXA		# ZERO ALIGNMENT INCREMENTS
	CLZ	DAYA
	CLZ	DAZA
	TRA	DELAY		# END MAJOR CYCLE
	STQ	SREX		# STORE NEW DEDA DATA.
	TRA	SREX1
NEWDD	CLA	STOCOM		# EQU TO STORE
	ADD	ADST		# DEDA ADDRESS
	STO	SREX1
	CLA	DD		# DEDA DATA
	TSQ	*-6
	CLA	BR1		# PROTECT BRANCH FROM DEDA
	STO	BRANCH
	CLA	ADST
	SUB	1B9		# S0 ADDRESS
	TMI	EXECM
	SUB	1B17
	TMI	EXEC3		# NEW WD IS S0
	SUB	10B17
	TMI	EXECM		# NEW WD BTWN S0PS13
	SUB	1B17
	TMI	LUNAZ		# NEW WD IS S13
	SUB	1B17
	TMI	*+2		# NEW WD IS S14
	TRA	EXECM
	
# Page 55
	CLA	S14		# NEW WD IS S14
	SUB	2B3
	TMI	*+3		# S14-2 (--IS S14=1)
	SUB	1B3
	TMI	EXECM2		# S14-3 (--IS S14=2)
	STO	DLIF		# ENABLE DL IF S14=1
	TRA	EXECM1		# -- S14=3
EXEC3	CLA	S0
	ADD	1B3		# NEG IF S0=7
	TMI	MABEE
	SUB	7B3
	TMI	EXECA
	CLA	DEL21		# CALIBRATE I.C.
	TMI	MABEE
	CLA	3B3		# IMU ALINE FOR 2SECS.
	STO	S0
	STQ	DEL6
MABEE	AXT	6,1
	CLZ	SDVX,1		# ZERO MU7 AND DV SJMS
	CLA	A11,1
	STO	A11D,1
	TIX	*-3,1
	TRA	EXECA
EXECM2	CLA	IC1BR		# SET IC1 BRANCH
	STO	BRANCH
	TRA	EXECM1
EXEC6	CLZ	DEL6		# IMU ALINE.
	TMI	*+2		# -- IS CALIBRATE
	TRA	*+2
	CLA	6B3
	STO	S0
	TRA	DELAY
FDAI1	CLA	A21
	MPR	COGA
	STO	TS1
	CLA	A23
	MPR	SIGA
	
# Page 56
	TRA	EX17+6
LL3DOT	CLA	RD3DTL,1
	STO	RD3DOT,1
	TRA	GDLAW4
NORTON	STO	TI
	STQ	TSEX		# SUBR TO GO TO EXEC.
	TSQ	EXEC
	TSQ	ELPRD		# ELPR AND COMPT
	TSQ	EXEC		# LENGTH OF VECTOR
	AXT	2,1		# RIX
	CLA	RIX,1
	STO	TS14,1
	TIX	*-2,1
	TSQ	NORMV
	AXT	2,1
	CLA	TS13		# LENGTH OF RI
	TRA	TSEX
RRT	CLZ	READP		# TEST FOR EXIT
	TMI	*+2		# FROM HOLD
	TRA	DEXIT		# EXIT
	STO	RMF		# TO READ OUT
	TRA	ADOUT
EX33P	CLA	S10
	SUB	3B3
	TMI	CSICDH
	CLA	2K11
	STO	28J1
	CLA	3K4
	SUB	C2
	TMI	EX33+1
	CLZ	DEL10
	TMI	EX33PP
EX35	CLA	2K11
	STO	VT
	CLZ	Q1
	SUB	5J
	STO	Q1DEDA
	
# Page 57
	TSQ	EXEC
	TRA	XDV
EX33PP	CLZ	4J
#		RESTORE SAVED QUANTITIES FO T/B COMPUTATIONS
#		IN HARD MEMORY.
	CLZ	V6X
	STO	TS12
	CLZ	V6Y
	STO	TS13
	CLZ	V6Z
	STO	TS14
	TRA	EX36+1
CSICDH	TSQ	EXEC
	CLA	RT
	SUB	RF
	STO	DELH
	STO	DELRP		# LITTLE DELTA R AT 23
	CLZ	RFDOT
	AXT	2,1
	CLA	VIX,1
	MPR	U2X,1
	ALS	1
	ADZ	RFDOT
	STO	RFDOT		# RFDOT = U2 DOT VT B13
	TIX	*-5,1
	CLA	S10
	ADD	6B3
	TMI	CDH		# S10 = 2
CSI	CLA	S16
	MPY	3PID4		# A=3/4(PI)(S16) AT B6
	STO	TS1
	DVP	AE
	MPR	DELH
	STO	TS2		# A(DELH/AE) B6
	CLA	TS1
	MPR	1B1
	STO	TS5		# A AT B7
	
# Page 58
	CLA	1J
	SUB	TIG
	ALS	3
	MPR	NE		# NE(1J-TIG) AT B6
	ADD	TS2
	MPR	6B3		# =1.5B1  3/2(NE)(1J-TIG)+
#				          3/2(A)(DELH/AE)
	SUB	TS5
	ADD	2J
	STO	TS7		# B AT AB7
	CLA	RADOT
	SUB	RFDOT
	STO	TS5		# VERTICAL COMP. OF VP0
	MPY	1B4
	DVP	VHA		# 4(RADOT-REDOT)/VHA  B6
	SUB	TS2
	STO	TS10
	CLA	THETAF
	LRS	3
	ADD	TS10
	MPY	1B1		# ACC = C  AT B7
	DVP	TS7		# C/B B0
	STO	TS11
	MPR	AE
	STO	DELH		# DELH  B23
	SUB	DELRP		# LITTLE DELTA R
	MPR	NE		# TO B14
	LRS	1		# B13 (DIVIDE BY 4)
	STO	TS4		# HORIZ COMP. OF VP0
	CLA	TS11		# C/B = DELH/AE  B0
	MPR	TS1		# A(DELH/AE)  B6
	ADD	TS2
	STO	TS1
	CLA	PI
	MPR	S16
	SUB	TS1
	MPY	1B3		# TO B9
	
# Page 59
	DVP	NE
	STO	TA0
	CLZ	TS6
	TSQ	DPVMAG		# COMPUTE VP0
	STO	VP0		# VEL-TO-BE-GAINED AT CDH
	CLA	RADOT
	STO	RFDOT
CDH2	CLA	DELRP		# LITTLE DELTA R
	ADD	DELH
	MPR	M1B1		# -.5B0 = -1B1
	ADD	AE
CDH3	STO	AL
	MPR	RF
	STO	TS7
	CLA	AL	
	SUB	RF
	ADD	AL
	MPY	2K1
	LRS	1
	DVP	TS7
	TSQ	SQRTE
	SUB	VHA
	STO	28J1		# 28J1 = VHF - VHA
	TSQ	EXEC
	CLA	RADOT
	SUB	RFDOT
	STO	28J3
	STO	TS4+1
	CLA	S10
	COM
	TMI	XDV
	CLA	28J1
	STO	TS4
	CLA	VY0
	STO	TS4+2
	TSQ	DPVMAG
	STO	VG
	
# Page 60
	TRA	GDLAW
CDH	CLZ	TA0
	ADD	TIG
	STO	TIG		# TIG = TIG + TAO
	TRA	CDH2
#	SEE REAR OF LISTING FOR CHECKSUM
#	START OF HARDWIRED MEMORY 
#		CONSTANTS
#
	CHECKSUM RANGE 1005-3776
	ORG	4000
7B17	DEC	7.B17		# CONSTANTS FOR NORMALIZE
6B17	DEC	6.B17
5B17	DEC	5.B17
4B17	DEC	4.B17
3B17	DEC	3.B17
2B17	DEC	2.B17
1B17	DEC	1.B17
ZERO	DEC	0
2B3	EQU	1B2
5B3	EQU	10B4
6B3	EQU	12B4
1B4	DEC	1.B4
1B5	DEC	1.B5
1B6	DEC	1.B6
1B9	DEC	1.B9
1B11	DEC	1.B11
1B12	DEC	1.B12
1B13	DEC	1.B13
1B14	DEC	1.B14
8B17	EQU	1B14
SIXTH	OCT	252525
2PIB3	DEC	6.2831853B3
1K25	EQU	2PIB3
3PID4	DEC	2.3561945B3
PID2	DEC	1.57079633B3
PID4	DEC	.78539816B3

# Page 61
K173	DEC	-.18488E-3B-6
K172	DEC	.83119E-2B-4
K171	DEC	-.16665554B-2
K170	OCT	377777		# 1B0
PMAX	EQU	K170
K183	DEC	-.0389929B-3
K182	DEC	.1462766B-1
K181	DEC	-.3211819B1
K180	DEC	.999215B2
SHDUM	LRS	0
MS	OCT	400000
NMAX	OCT	400001
49B17	DEC	49.B17
10B17	DEC	10.B17
BCDL	DEC	100000.B17
TRNSFR	TRA	EROUT		# EXIT FROM ATT ERROR COMPS
BACK	TRA	RETURN
TMOUT	OUT	6100
CLAFR	CLA	4000
CLATEN	EQU	SICO2		# CLA 0,1
TRACOM	EQU	MS		# LOOKS LIKE TRA 0
STOCOM	EQU	1B2		# LOOKS LIKE STO 0
DUMCLA	EQU	1B1		# LOOKS LIKE CLA 0
#
# **	20 MILLISECOND COMPUTATIONS
#
DELAY	DLY	*+1
	INP	2001		# INPUT PGNS ANGLES
	STO	THEP
	INP	2002
	STO	PHIP
	INP	2004
	STO	PSIP
	INP	6010		# INPUT GYRO DATA
	STO	DAX
	INP	6002
	STO	DAY
	
# Page 62
	INP	6004
	STO	DAZ
	INP	6020		# INPUT ACCELEROMETER DATA
1B2	STO	TS0		# VALUE USED AS CONSTANT
	INP	6040
	STO	TS1
	INP	6100
	STO	TS2
EX1	TRA	EXIT1
#	PROCESS ACCELEROMETER INPUTS
	AXT	2,1
DVS	CLZ	DVX,1		# SAVE PREVIOUS VALUE
	STO	DVXM1,1
	CLZ	TS0,1
	SUB	1K7		# 11
	ALS	1
	MPR	1K18,1		# SCALE FACTOR
	ALS	1		# SCALE AT 1
	ADD	1K19,1		# BIAS COMPENSATION
	STO	DVX,1		# AT 1
	TIX	DVS,1
	TRA	EXIT2		# TO MODE CHECK.
# 	PROCESS GYRO INPUTS
	AXT	2,1
	TOV	*+1		# RESET
GYCOM	CLZ	DAX,1	
	SUB	1K7	
	ALS	1		# RADIANS AT -6
	STO	DAX,1
	MPR	1K3,1		# SCALE FACTOR COMP
	ADD	1K1,1		# AT -13
	ADZ	DAXREM,1
	STO	DAXREM,1
	ADD	1B4		# ROUND
	LRS	14		# TO +1
	ALS	7		# TO -6, QUANTIZED AT -16
	STO	TS6
	
# Page 63
	ALS	7
M1B1	COM			# INSTRUCTION LOOKS LIKE -1B1
	ADZ	DAXREM,1
	STO	DAXREM,1
	CLZ	TS6
	ADZ	DAX,1
	ADD	DAXA,1
	STO	DAX,1		# -6
	ALS	3		# TO -9
	STO	TS10,1
	ABS
	ADD	1B6		# TEST FOR POSSIBLE OVERFL
	TIX	GYCOM,1
EX3	TRA	EXIT3
	TOV	HRC
	CLZ	HRF
	TMI	LRI
#	COMPUTE DIRECTION COSINE CHANGE
CDCC	CLA	TS10		# DAX AT -6 OR -9
	MPY	TS11		# DAY
	LRS	1		# 1/2DAX(DAY) AT -12 OR -18
	TSQ	RND
	ADD	TS12		# DAZ
	STO 	TS1
	CLA	TS10
	MPY	TS12
	LRS	1		# 1/2DAX(DAZ) AT -12 OR -18
	TSQ	RND
	SUZ	E13
	STO	TS7
	SUB	TS11
	STO	TS2
	CLA	TS11
	MPR	TS11
	LRS	1
	STO	TS8
	CLA	TS12
	
# Page 64
	MPR	TS12
	LRS	1		# 1/2DAZ(DAZ) AT -12 OR -18
	ADD	TS8
	TSQ	RND
	COM
	ADZ	E1		# NORMALITY CONSTRAINT
	STO	TS3
	CLZ	TS7
	ADD	TS11
	STO	TS4
	CLA	TS11
	MPY	TS12
	LRS	1		# 1/2DAY(DAZ) AT -12 OR -18
	TSQ	RND
	SUB	TS10
	STO	TS5
	CLA	TS10
	MPR	TS10
	LRS	1		# 1/2DAX(DAX) AT -12 OR -18
	ADZ	TS8
	TSQ	RND
	COM
	ADZ	E3
	STO	TS6
EX4	TRA	EXIT4
	AXT	2,1		# COMPUTE EQUATIONS
DICOS	CLA	TS1
	MPR	A21,1		# 1
	ADZ	DA11,1
	STO	DA11,1		# -5 OR -8
	CLA	TS2
	MPR	A31,1
	ADZ	DA11,1
	STO	DA11,1		# -5 OR -8
	CLA	TS3
	MPR	A11,1
	ADZ	DA11,1
	
# Page 65
	STO	DA11,1		# -5 OR -8
	CLA	TS4		# ROW 3
	MPR	A11,1
	ADZ	DA31,1
	STO	DA31,1
	CLA	TS5
	MPR	A21,1
	ADZ	DA31,1
	STO	DA31,1
	CLA	TS6
	MPR	A31,1
	ADZ	DA31,1
	STO	DA31,1
	TIX	DICOS,1
# 	INTEGRATE DIRECTION COSINES
	AXT	6,1
INTAS	CLA	HRF
	TMI	HRINT		# -5 OR -8 TEST
	CLA	DA11,1
RND1	ADD	1B9		# ROUND
SHFT1	LRS	9		# TO 1
	STO	TS1
	ALS	9
	COM
	ADZ	DA11,1
	STO	DA11,1		# SAVE REMAINDER
	CLZ	A11,1
	ADZ	TS1
	STO	A11,1
	TIX	INTAS,1
	TSQ	EXIT5		# DOWNLINK INPUT
	TSQ	EXIT6		# TELEMETRY OUTPUT
#	COMPUTE ROW 2
COA21	CLA	A12
	MPR	A33		# 2
	STO	TS1
	CLA	A13
	
# Page 66
	MPR	A32
	SUZ	TS1
	ALS	1		# TO 1
	STO	A21		# A21
	CLA	A13
	MPR	A31
	STO	TS1
	CLA	A11
	MPR	A33
	SUZ	TS1
	ALS	1
	STO	A22		# A22
	CLA	A11
	MPR	A32
	STO	TS1
	CLA	A12
	MPR	A31
	SUZ	TS1
	ALS	1
	STO	A23		# A23,DIR COS UPDATE COMPLETE
EX8	TRA	EXIT8
#	VELOCITY RESOLUTION
DVINT	AXT	2,1		# RESOLVE BODY DVS TO
	CLA	A11,1		# INERTIAL FRAME AND
	MPR	DVX		# ACCUMULATE.
	STO	TS1		# 2
	CLA	A21,1
	MPR	DVY
	ADZ	TS1
	STO	TS1
	CLA	A31,1
	MPR	DVZ
	ADZ	TS1		# 2
	ADD	1B13		# ROUND
	LRS	5
	ADZ	DVSX,1
	STO	DVSX,1		# 7
	
# Page 67
	TIX	DVINT+1,1
	TSQ	EXIT5		# DOWNLINK INPUT
	TSQ	EXIT6		# TELEMETRY OUTPUT
#
	CLZ	FLAG1
	TMI	BRANCH		# -- IS GUID/NAV CYCLE.
	CLA	MS
	STO	FLAG1
EX9	TRA	EXIT9
#
#	HARDWIRED 40 MS COMPUTATIONS
#	DISCRETE INPUT AND STAGING RECOGNITION COMPS.
#
	INP	DISC1I		# INPUT DISCRETE WD 1
	STO	DISC1C
	ADD	1B17		# OBTAIN TWO'S COMP OF INPUT WD
	COM
	STO	DISC1
	CLA	DEL2		# TEST FOR STAGING
	TMI	EXIT10		# -- IS STAGED
	CLA	DISC1C		# TEST FOR ASCENT ENG ON
	ALS	6
	TMI	EXIT10		# -- IS OFF.
	CLZ	DEL21		# RESET LUNAR SURFACE FLAG
	CLA	MS
	STO	DEL2		# SET STAGED FLAG
	TRA	EXIT11
#
#	DIRECTION COSINE LOGIC
LRI	AXT	6,1
	CLZ	DA11,1		# REMAINDERS
	ALS	3		# TO -8
	STO	DA11,1
	TIX	*-3,1
	CLA	RND1
	STO	RND+1
	CLA	SHFT1
	
# Page 68
	STO	RND+2
	TRA	CDCC
#
HRC	CLA	HRF
	TMI	HRC1
	CLA	RND2		# SET UP FOR HIGH RATE
	STO	RND+1
	CLA	SHFT2
	STO	RND+2
	STO	HRF
	AXT	6,1
	CLZ	DA11,1
	LRS	3		# TO -5
	STO	DA11,1
	TIX	*-3,1
HRC1	AXT	2,1
	CLA	DAX,1
	STO	TS10,1		# AT -6
	CLZ	E1,1
	LRS	3		# TO -6
	STO	E1,1
	TIX	*-5,1
	TRA	CDCC
#
HRINT	CLA	DA11,1
RND2	ADD	1B12		# ROUND
SHFT2	LRS	6		# TO 1
	STO	TS1
	ALS	6
	TRA	INTAS+7
#
#		ATTITUDE HOLD. (40 MS)
AHE	CLA	DEL5		# ATTITUDE HOLD ENTRY
	TMI	AHE1		# IF MINUS -- DRIVE TO REF COSINES
	CLA	MS		# FIRST CYCLE IN
	STO	DEL5		# ATTITUDE HOLD
	AXT	6,1		# SET DESIRED ATTITUDE
	
# Page 69
	CLA	A11,1
	STO	A11D,1
	TIX	*-2,1
#
	TSQ	EXIT12		# TO ACQUISITION RESET.
AHE1	LDQ	TRNSFR		# TRA EROUT INTO Q
ATTERR	STQ	SREX		# ENTER HERE FROM CALIBRATE
	AXT	2,1		# COMPUTE EX
	CLA	A31D,1
	MPR	A21,1		# 1+1=+2
	COM
	ADZ	EX
	STO	EX		# +2
	TIX	*-5,1
EYEZ	AXT	2,1		# COMPUTE EY AND EZ
	CLA	A11D,1
	MPR	A21,1		# 1+1=+2
	ADZ	EZ
	STO	EZ
	CLA	A11D,1
	MPR	A31,1		# 1+1=+2
	COM
	ADZ	EY
	STO	EY
	TIX	*-9,1
	TRA	SREX
#
# 	LIMIT AND OUTPUT ATTITUDE ERRORS
EROUT	TRA	EXIT13
	AXT	2,1
	CLZ	EX,1
	LDQ	MS
	TMI	*+2
	TRA	*+2
	STQ	EX,1
	ABS
	SUB	4K21		# +2
	TMI	*+3		# LESS THAN MAX
	
# Page 70
	CLA	PMAX		# SET MAX OUTPUT
	TRA	*+3
	ADD	4K21
	DVP	4K21		# SCALE FACTOR
	ADZ	EX,1
	STO	EX,1
	TIX	EROUT+2,1
	OUT	EXO		# AT 0
	CLA	EY
	OUT	EYO		# AT 0
	CLA	EZ
	OUT	EZO		# AT 0
	TRA	EXIT14
#
# 	RENDEZVOUS STEERING
RST	CLZ	DEL5		# CLEAR ATT HLD 1ST CYCLE FLAG
	AXT	2,1
	CLA	A11BD,1
	STO	A11D,1
	TIX	*-2,1
	CLA	TRNSFR		# TRA EROUT INTO SREX
	STO	SREX
	TRA	EYEZ
#
#	LUNAR ALIGN COMPS
LUNAL	CLA	A31
	MPR	A31
	COM
	ADD	1B2
	TSQ	SQRTE
	STO	TS1
	CLA	SIDELL		# COMPUTE COS DEL A
	MPR	DDEL
	ADD	CODELL
	MPY	TS1		# A32D AT 2
	LLS	1
	MPR	A22
	
# Page 71
	STO	TS2
	CLA	CODELL		# COMPUTE SIN DEL A
	MPR	DDEL
	COM
	ADD	SIDELL
	MPY	TS1		# A33D AT 2
	LLS	1
	MPR	A23
	ADZ	TS2
	STO	TS2
	CLA	A31
	MPR	A21
	ADZ	TS2
	LDQ	ZERO
	DVP	1K26
	STO	DAXA		# -6
	CLA	A31
	LDQ	ZERO
	DVP	1K28		# 1-7=-6
	STO	TS1
	CLA	DVZ
	ADD	DVZM1
	MPY	1K27		# 1-4=-3
	LLS	3		# TO -6
	SUZ	TS1
	STO	DAYA
	CLA	DVY
	ADD	DVYM1
	MPY	1K27		# 1-4=-3
	LLS	3		# TO -6
	STO	TS1
	CLA	A21
	LDQ	ZERO
	DVP	1K28
	SUZ	TS1
	STO	DAZA
	AXT	2,1
	
# Page 72
	CLA	DAXA,1
	ABS
	LRS	2		# TO -4
	ADZ	TS2
	STO	TS2
	TIX	*-5,1
	SUB	1K29		# TEST FOR LUNAR ALIGN COMPLETE
	STO	DEL42		# DEL42 NEG IS LUNAL COMPLETE
	TRA	EXIT15
#
#	FDAI COMPUTATIONS
FDAI	CLA	A32		# TOTAL ATTITUDE
	COM			# -A32
	TSQ	FDAIL		# LIMIT ROUTINE
	OUT	SIBEO		# SIN BETA AT 0
	CLA	A33
	MPR	A33
	STO	TS1
	CLA	A31
	MPR	A31
	ADZ	TS1
	TSQ	SQRTE
	STO	TS2		# COS BETA
	TSQ	FDAIL
	OUT	COBEO
EX16	TRA	EXIT16
	CLA	TS2
	SUB	1K24
	TMI	EXIT17		# USE OLD VALUE OF SIGA AND COGA
	LDQ	ZERO
	CLA	A31
	LRS	1
	DVP	TS2
	STO	SIGA
	TSQ	FDAIL
	OUT	SIGAO
	LDQ	ZERO
	
# Page 73
	CLA	A33
	LRS	1
	DVP	TS2
	STO	COGA
	TSQ	FDAIL
	OUT	COGAO
EX17	TRA	EXIT17
#		THE NEXT 5 CELLS ARE BYPASSED AND
#		RE-WRITTEN IN SOFT MEMORY
	CLA	A23		# GAMMA OUTPUT
	MPR	SIGA
	STO	TS1
	CLA	A21
	MPR	COGA
	SUZ	TS1
	ALS	1
	TSQ	FDAIL
	OUT	SIALO
	CLA	A13
	MPR	SIGA
	STO	TS1
	CLA	A11
	MPR	COGA
	SUZ	TS1
	ALS	1
	TSQ	FDAIL
	OUT	COALO
#
#	DEDA DISCRETE SAMPLING
#
	INP	DISC2I
	ADD	1B17
	COM
	ALS	1		# IS TAPE LOAD REQUESTED
	TMI	GSESR		# IF MINUS -- TRANSFER TO GSE SERV
	ALS	3
	AXT	3,1
	
# Page 74
	TMI	SPULSE
	ALS	1
	TIX	*-2,1
	TRA	SPULSE+1
#
#		FDAI LIMITING SUBROUTINE
FDAIL	STQ	SREX
	LDQ	MS
	TMI	*+2
	LDQ	ZERO
	STQ	TS1		# SET SIGN
	ABS
	ADD	1B11		# ROUND
	ALS	1
	TMI	*+2		# -- SET MAX VALUE
	TRA	*+2
	CLA	PMAX
	ADZ	TS1
	TRA	SREX
#
SPULSE	STO	READP,1		# SET DEDA FLAG
	TRA	EXIT18
#
#	COMPUTE NORMALITY AND ORTHOGONALITY CONSTRAINTS
NOC	AXT	2,1
	CLA	A11,1
	MPR	A11,1
	ADZ	E1
	STO	E1		# AT 2
	CLA	A31,1
	MPR	A31,1
	ADZ	E3		# AT 2
	STO	E3
	CLA	A11,1
	MPR	A31,1
	ADZ	E13
	STO	E13		# AT 2
	
# Page 75
	TIX	NOC+1,1
	ALS	10		# DIV BY 2, SCALE AT -9
	STO	E13
	AXT	1,1
	CLA	1B2
	SUZ	E1,1		# 1-E
	ALS	10		# TO -9
	STO	E1,1
	TIX	*-4,1
	TRA	EXIT19
#
#	EULER ANGLE DIRECTION COSINES SUBROUTINE
EADICS	STQ	SREX1
	CLA	THEP
	MPR	2PIB3		# RADIANS AT 3
	TSQ	SICOE
	CLZ	TS1
	STO	TS5
12B4	CLZ	TS0		# VALUE USED AS CONSTANT
	STO	TS6
	CLA	PSIP
	MPR	2PIB3
	TSQ	SICOE
	CLZ	TS1
	STO	A12D		# 1
	CLZ	TS0
	STO	TS7
	CLA	PHIP
	MPR	2PIB3
	TSQ	SICOE		# INPUTS COMPLETE
	CLA	TS7
	MPR	TS6
	ALS	1
	STO	A11D		# 1
	CLA	TS7
	MPR	TS5
	ALS	1
	
# Page 76
	COM
	STO	A13D		# 1
	CLA	TS1
	MPR	A12D
	ALS	1
	STO	TS3
	MPR	TS6
	STO	TS4
1B1	CLA	TS0		# COSINE PHI
	MPR	TS5
	ADZ	TS4
	ALS	1
	STO	A31D		# 1
	CLZ	TS1
	MPZ	TS7
	ALS	1
	COM
	STO	A32D		# 1
	CLZ	TS3
	MPZ	TS5
	STO	TS4
	CLZ	TS0
	MPZ	TS6
	SUZ	TS4
	ALS	1
	STO	A33D		# DI-COS COMPLETE
	TRA	SREX1		# EXIT
#
#	IMU ALIGN COMPUTATIONS
ZNOC	CLZ	E1
	CLZ	E3
	CLZ	E13
IMUDC	TSQ	EADICS
	AXT	6,1
	CLA	A11D,1		# REPLACE DIR COSINES
	STO	A11,1		# WITH IMU DIR COSINES.
	CLZ	DA11,1		# ZERO REMAINDERS
	
# Page 77
	TIX	*-3,1
	TRA	COA21-2
#
#		INITIALIZE BRANCHES.
#
IC1	CLZ	S14
	SUB	2B3
	TMI	EXIT20		# TO DL FORMATTIG
	AXT	2,1		# LEM POS AND VEL DATA
	CLZ	1J1,1		# LEM POS
	STO	R0X,1
	CLZ	1J4,1		# LEM VEL
	STO	V0X,1
	TIX	*-4,1
	CLZ	1J7		# EPOCH TIME MS
	STO	TL1
	CLZ	1J7LS		# EPOCH TIME LS
	STO	TL2
	TSQ	ORBPM
	CLZ	DSPSC		# CLEAR DISPLAY COUNTER
	TSQ	EXIT21
#
IC2	AXT	1,1
	TSQ	DPTSB		# COMPUTE DBL PREC TA - TL
	CLA	DEL21
	TMI	RVCOMP
	TSQ	ELPRD		# TRNSFR TO ELLIPSE PRED
	AXT	2,1
	CLZ	RIX,1
	STO	RX,1
	CLZ	VIX,1
	STO	VX,1
	TIX	*-4,1
	TRA	*+9
RVCOMP	AXT	2,1
	CLZ	V0X,1
	STO	VX,1

# Page 78
	MPY	TI		# 13+13=26
	LLS	3
	ADZ	R0X,1
	STO	RX,1		# AT 23
	TIX	*-6,1
	TSQ	EXEC		# IC3 NEXT
#
IC3	TSQ	GRAV		# TO GRAVITY
	AXT	2,1
	CLZ	DVSX,1
	CLZ	DRX,1
	CLA	GXDT,1
	STO	DIGX,1
	TIX	*-4,1
	TRA	EXIT22
#
#		CSM DL OR DEDA INPUTS TO EPOCH CELLS.
CSMPV	AXT	2,1
	CLZ	2J1,1		# CSM POS
	STO	REX,1
	CLZ	2J4,1		# CSM VEL
	STO	VEX,1
	TIX	*-4,1
	CLZ	2J7		# CSM EPOCH MS
	STO	TE1
	CLZ	2J7LS		# CSM EPOCH LS
	STO	TE2
	CLZ	TB
	TRA	EXIT
#
#		NEXT 5 INSTRUCTIONS BYPASSED
#
NAV	CLA	DEL21
	TMI	NAV1		# -- IS ON LUNAR SURFACE
	CLA	0464
	SUB	VDX
	ALS	6
	
# Page 79
#
#		HARDWIRED NAVIGATION
#
	STO	AT		# 1/2(VD1-VD) AT 7
	SUB	4K35		# ULLAGE THRESHOLD
	TMI	NAV2-2		# AT-4K35
	CLZ	MU8		# INCR ULLAGE COUNTER.
	ADD	1B17
	STO	MU8
	TRA	EXIT24
NAV1	CLZ	DIGX		# LUNAR SURFACE NAV.
	CLZ	DIGY
	CLZ	DIGZ
	CLA	1K9		# ULLAGE COUNT LIMIT
	STO	MU8
	TRA	EXIT23
	CLZ	MU8		# RESET ULLAGE COUNTER.
	TRA	EXIT24
NAV2	CLZ	TS1		# ACCEL DRIFT TEST.
	AXT	2,1
	CLA	DVSX,1
	ABS
	ADZ	TS1
	STO	TS1
	TIX	*-4,1
	SUB	1K35
	TMI	EXIT25		# COAST PHASE
	TRA	EXIT26
NAV3	CLZ	DVSX
	CLZ	DVSY
	CLZ	DVSZ
	TRA	EXIT26
NAV4	AXT	2,1		# VEL AND POS UPDATE.
	CLZ	DVSX,1		# SENSED VEL AT 7
	ADZ	DIGX,1		# PREDICTED INTG GRAVITY.
	STO	DIGX,1		# 7
	ADD	1B12		# ROUND
	
# Page 80
	LRS	6
	STO	TS2		# DV AT 13
	ADD	VX,1
	STO	TS1		# NEW V AT 13
	MPR	KDT		# DT/2 AT 1.
	STO	TS4
	CLZ	VX,1		# V(N-1)
	MPR	KDT
	ADZ	TS4
	ADZ	DRX,1
	STO	DRX,1		# 14
	ADD	1B9		# ROUND
	LRS	9
	STO	TS3		# DR AT 23
	ADZ	RX,1
	STO	RX,1		# NEW R AT 23
	CLZ	TS2		# DV AT 13
	ALS	6
	COM
	ADZ	DIGX,1
	STO	DIGX,1		# VEL REMAINDER AT 7
	CLZ	TS3		# DR AT 23
	ALS	9
	COM
	ADZ	DRX,1
	STO	DRX,1		# POS REMAINDER AT 14
	CLZ	TS1
	STO	VX,1		# NEW V AT 13
	TIX	NAV4+1,1
	TSQ	GRAV		# TO GRAVITY COMP.
EX28	TRA	EXIT28
	CLA	4K34		# LIMIT AT.
	SUB	AT
	TMI	*+3
	CLA	4K34
	STO	AT
	CLA	MS		# SET IC DISPLAY.
	
# Page 81
	STO	DSPF1
	TSQ	TIMEA		# TO TA UPDATE
#
#		CSM ORBIT PARAMETERS
#
ORBPAR	CLA	S14
	SUB	3B3
	TMI	*+4
	CLZ	S14
	TSQ	CSMPV
EX29	TRA	EXIT29
	AXT	2,1
	CLA	REX,1
	STO	TS4,1
	STO	R0X,1
	CLA	VEX,1
	STO	TS10,1
	STO	V0X,1
	TIX	*-6,1
	TSQ	CRSPRD
	TSQ	NORMV
	AXT	2,1
	CLZ	TS10,1
	STO	WCX,1
	TIX	*-2,1
	TSQ	ORBPM		# COMPUTE CSM ORB PARAMS FROM EPD
	CLA	2PIB3
	LDQ	ZERO
	LRS	1
	DVP	NI		# 4-(-9)=13
	STO	TCSM
EX30	TRA	EXIT30
	CLA	TB
	SUB	TCSM
	TMI	BR2EX
	CLA	TCSM
	LDQ	ZERO
	
# Page 82
	LRS	5		# TO +18
	STQ	TS1
	ADZ	TE1
	STO	TE1
	CLZ	TS1
	ADZ	TE2
	STO	TE2
	TMI	*+2		# OVERFLOW
	TRA	BR2EX
	SUB	MS
	STO	TE2
	CLZ	TE1
	ADD	1B17
	STO	TE1
BR2EX	TSQ	EXEC
#
#		CSM PRESENT POS AND VEL.
#
	AXT	0,1
	TSQ	DPTSB		# COMPUTE DBL PREC TA-TE
	STO	TB		# +13
	TSQ	ELPRD		# TRANSFER TO ELLIPSE PRED
	AXT	2,1
	CLZ	RIX,1
	STO	RCX,1		# 23
	CLZ	VIX,1
	STO	VCX,1		# 13
	TIX	*-4,1
	TSQ	EXEC
#
	AXT	2,1
	CLA	VX,1		# COMPUTE MAGNITUDE OF VEL VECTOR
	STO	TS4,1
	TIX	*-2,1
	TSQ	DPVMAG
	STO	V		# 13
	TRA	EXIT31
	
# Page 83
#
#		GRAVITY AND H, HDOT COMPUTATIONS.
#
GRAV	STQ	SREX3
	AXT	2,1
	CLA	RX,1
	STO	TS14,1
	TIX	*-2,1
	TSQ	NORMV		# COMPUTE U1 AND R.
	CLZ	TS13
	STO	R		# 23
	SUB	5J		# MEAN LUNAR RADIUS
	STO	H		# ALTITUDE AT 23
EX27	TRA	EXIT27
	CLA	2K4
	LDQ	ZERO
	LRS	3		# 52
	DVP	TS17		# R SQ AT 46
	STO	TS7		# -GRAV VECT MAG AT 6
	AXT	2,1
GRAV1	CLZ	GXDT,1
	STO	TS0		# G(N-1)DT
	CLZ	TS10,1		# UNIT VECTOR FR NORMV
	STO	U1X,1		# 1
	MPR	TS7		# -MUDT/(R SQ) AT 6
	STO	GXDT,1		# 7
7B3	SUZ	TS0		# G(N-1)DT
	LRS	1
	ADD	GXDT,1		# PREDICTED INTG GRAV IN A
	ADZ	DIGX,1		# VEL REMAINDER
	STO	DIGX,1		# INTG GRAV+VEL REM AT
	CLA	VX,1		# 13
	MPR	U1X,1		# FORM V DOT U1.
	ADZ	TS13
	STO	TS13
	TIX	GRAV1,1
	ALS	1
	
# Page 84
	STO	HDOT		# ALT RATE AT 13.
	TRA	SREX3
#
#		LEM ORBIT PARAMETERS.
#
LMORB	CLA	HDOT		# B13
	MPY	HDOT
	STO	TS14
	STQ	TS15
	CLA	V		# 13
	MPR	V
	SUB	TS14
	STO	TS7		# VH SQ AT 26
	TSQ	SQRTE
	STO	VH		# 13
	TOV	*+1		# CL. O.F.
	CLA	R		# 23
	MPR	R
	MPR	2K2
	MPY	TS7		# 46-47+26=25
	LLS	2
	STO	TS10		# PL AT 23
	LRS	1
	STO	TS11		# SAVE PL AT 24
	STQ	TS12
	DVP	R
	SUB	1B1
	ALS	4		# -3
	STO	TS0
	MPZ	TS0
	STO	TS13		# (PL/R-1) SQ AT -6.
	CLZ	TS14		# HDOT SQ AT 26
	LDQ	TS15
	LLS	8		# 1B
	MPR	2K2
	MPR	TS10		# PL
	ADZ	TS13		# EL SQ IN A AT -6.
	
# Page 85
	TOV	LMORB1+2
	TSQ	SQRTE
	LRS	4		# EL AT 1
	ADD	1B1
	STO	TS1		# 1+EL AT 1.
	CLZ	TS11		# OL AT 24
	LDQ	TS12
	DVP	TS1
LMORB1	STO	QL		# LM PERICYNTHION AT 23
	TRA	EXIT32
	CLA	2K3		# SET QL=CONST
	TRA	LMORB1
#
#		CSM PREDICTION.
#
CSMT1	TSQ	ELPRD		# TO ELLIPSE PREDICTOR.
	TSQ	EXEC
#
#		TRANSFER ORBIT VECTORS.
#
	AXT	2,1
	CLA	RIX,1		# CSM PRED POS
	STO	TS14,1
	TIX	*-2,1
	TSQ	NORMV		# NORMALIZE RT
	CLZ	TS13
	STO	RT		# 23
	AXT	2,1
XORBV1	CLA	TS10,1		# C1X=BX
	STO	U2X,1
	CLA	U1X,1
	STO	TS4,1
	MPR	U2X,1
	ADZ	TS13
	STO	TS13
	TIX	XORBV1,1
	ALS	1
	
# Page 86
	STO	C1		# U1 DOT U2 AT 1.
	MPR	C1
	COM
	ADD	1B2
	TSQ	SQRTE
	STO	C2		# 1
EX33	TRA	EXIT33
	TSQ	CRSPRD		# U1XU2 AT 2.
	CLA	TS14+1
	MPY	WCY
	TMI	*+2		# -- IS REND ANG GREAT 180.
	TRA	*+4
	CLZ	C2
	COM
	STO	C2
	AXT	2,1		# NORMALIZE W1 AND
XORBV2	CLZ	TS14,1
	LDQ	ZERO
	DVP	C2
	STO	W1X,1		# 1
	CLA	U1X,1
	MPR	C1
	STO	TS1
	CLA	U2X,1		# 1
	LRS	1
	SUZ	TS1
	LDQ	ZERO
	DVP	C2
	STO	V1X,1		# 1
	CLA	U1X,1		# 1
	LRS	1
	STO	TS1		# 2
	CLA	U2X,1
	MPR	C1
	SUZ	TS1
	LDQ	ZERO
	DVP	C2
	
# Page 87
	STO	V2X,1		# 1
	TIX	XORBV2,1
	CLZ	MU3		# P-ITERATION INDEX.
	TSQ	EXEC
#
#		P-ITERATOR
#
EX34	TRA	EXIT34
	TOV	*+1		# CL. O.F.
	CLA	P		# ITERATION P AT 23
	SUB	RF
	LDQ	ZERO
	DVP	RF
	STO	TS11		# X1 AT 0.
	MPY	TS11
	LLS	2
	STO	TS1		# X1 SQ. AT -2
	CLA	P
	SUB	RT
	LDQ	ZERO
	DVP	RT
	STO	TS12		# X2 AT .0
	MPR	C1
	STO	TS2		# 1
	CLA	TS11		# X1
	LRS	1
	SUZ	TS2
	LDQ	ZERO
	DVP	C2
	STO	X4		# AT 0.
	CLA	TS12		# X2
	LRS	1
	STO	TS2		# 1
	CLA	TS11		# X1
	MPR	C1
	SUZ	TS2
	LDQ	ZERO
	
# Page 88
	DVP	C2		# 1
	STO	X3		# AT 0.
	MPY	X3
	LLS	2
	ADZ	TS1		# -2
	TOV	EXIT35		# O.F. IF E TOO LARGE.
	STO	ESQ		# E SQ AT -2.
	LRS	2
	STO	TS13		# E SQ AT 0.
	COM
	ADD	PMAX
	STO	TS14		# (1-E SQ) AT 0.
	TSQ	SQRTE
	STO	TS15		# ROOT(1-E SQ) AT 0.
	CLA	X4
	SUB	X3
	LRS	1		# 1
	ADD	C2
	MPR	TS15
	STO	TS3		# SIN(DELTA E) AT 1.
	CLA	X3
	MPR	X4
	COM
	ADZ	TS13
	LRS	1		# 1
	STO	TS13 		# E SQ-X3(X4) AT 1.
	CLZ	TS11
	ADZ	TS12		# X1+X2
	LRS	1		# 1
	ADZ	TS13
	ADD	C1
	STO	TS4		# COS(DELTA E) AT 1.
	TSQ	ARCTAE
	STO	TS16		# DELTA E AT 3.
	CLA	RT
	MPR	X4
	STO	TS1		# 23
	
# Page 89
	CLA	RF
	MPR	X3
	SUZ	TS1
	MPY	TS15
	LRS	3		# 26
	DVP	P
	ADZ	TS16
	STO	TS16		# DELTAE + X7-X8 AT 3.
	CLA	P
	LDQ	ZERO
	DVP	TS14		# 1-E SQ
	STO	ALPHA		# 23
	MPR	2K2		# 1/2K1 AT -47
	TSQ	SQRTE		# (-47+23)/2=-12
	MPR	ALPHA		# 1/N AT 11 IN A.
	MPZ	TS16		# 11+3=14
	ALS	1		# NEW TP AT 13.
	SUB	TP
	STO	TS2		# DELTA TP
	ADZ	TP
	STO	TP		# 13
	CLA	T
	SUB	TP
	STO	TS0		# T-TP
	CLZ	MU3		# INCREMENT ITER COUNTER.
	ADD	1B17
	STO	MU3
	SUB	2B17		# ITERATION SCHEME.
	TMI	PITER2		# -- IS MU3=1.
	SUB	1B17
	TMI	PITER1		# -- IS MU3=2.
	SUB	2K17		# MU3-NO. ITERATIONS IN A.
	TMI	*+6		# -- IS NOT DONE.
	CLZ	TS0		# DONE. T-TP
	ABS
	SUB	2K20
	TMI	PITER3+5	# -- IS CONVERGED.
	
# Page 90
# This page is missing from the only available listing of FP6,
# and so has simply been duplicated from the corresponding section
# of FP8.  There is good reason to believe that this is valid.
# Refer to the website or the header of this file.
	TRA	EXIT35
	CLA	TS2		# DELTA TP.
	ABS
	SUB	2K18
	TMI	DELP		# -- IS SKIP PARTIAL
PITER1	CLA	P		# COMPUTE PARTIAL T.
	SUZ	PP
	STO	TS1		# 23
	LDQ	ZERO
	LRS	4		# 27
	TOV	*+1		# CL. O.F.
	TRA	*+2
	DLY	INIT		# TO TURN ON SEQUENCE
	DVP	TS2		# 27-13=14
	TOV	*+2
	TRA	*+7
	CLZ	TS1		# DET SIGN OF PART
	MPY	TS2		# NUM X DENOM
	TMI	*+3
	CLA	PMAX
	TRA	*+2
	CLA	NMAX
	STO	PART		# PARTIAL T AT 14
DELP	CLZ	TS0		# T-TP
	MPY	PART
	LLS	4		# 13+14-4=23
	STO	TS3		# DELTA P
	ABS
	SUB	2K19
	TMI	PITER3
	CLZ	TS3
	TMI	*+5
	CLA	2K19
	TRA	*+5
PITER2	CLA	2K14
	TRA	*+2
	CLA	2K19
	
# Page 91
	COM
	STO	TS3		# DELTA P
PITER3	CLZ	P
	STO	PP
	ADZ	TS3
	STO	P		# NEW P
	TRA	EXEC+1
	TSQ	EXEC
#
#		IMPULSE AND BRAKING VELOCITIES
#
TBRAKE	CLA	2K1		# 48
	LDQ	ZERO
	LRS	1
	DVP	P		# 49-23=26
	TSQ	SQRTE
	STO	TS1		# ROOT(MU/P) AT 13
	MPZ	X3
	STO	RFDOT		# 13
	CLA	TS1
	MPZ	X4
	STO	TS13		# 13
	CLZ	TS1
	MPY	P
	STO	TS1		# ROOT(PXMU) AT 36
	STQ	TS2
	DVP	RF
	STO	TS12		# 13
	CLZ	TS1
	LDQ	TS2
	DVP	RT
	STO	TS14		# 13
EX36	TRA	EXIT36
	TOV	*+1		# CL. O.F.
	AXT	2,1
IMPBK1	CLA	TS13		# ROOT(MU/P)X(X4) AT 13
	MPZ	U2X,1		# 1
	
# Page 92
	STO	TS7
	CLA	TS14		# ROOT(PXMU)/RT AT 13
	MPZ	V2X,1		# 1
	ADZ	TS7
	ALS	1		# 13
	SUB	VIX,1
	STO	VFX,1		# -BRAKING VEL AT 13
	CLA	RFDOT		# 13
	MPR	U1X,1		# 1
	STO	TS7
	CLA	TS12		# ROOT(PXMU)/RF AT 13
	MPR	V1X,1		# 1
	ADZ	TS7
	ALS	1		# 13
	SUB	V5X,1
	STO	VGX,1		# VEL TO GAIN AT 13
	STO	TS4,1
	TIX	IMPBK1,1
	TOV	EXIT35		# CHECK VG OR VF D.F.
	TSQ 	DPVMAG
	STO	VG		# 13
	CLZ	ESQ		# E SQ ER P ITER AT -2.
	TSQ	SQRTE
	LRS	1		# E AT 0.
	COM	
	ADD	PMAX		# 1-E AT 0.
	MPR	ALPHA
	STO	Q1		# Q OF TRANS ORB AT 23
	TSQ	EXEC
# 		COMPLETE VF ON FOLLOWING CYCLE.
	AXT	2,1
	CLA	VFX,1		# 13
	STO	TS4,1
	TIX	*-2,1
	TSQ	DPVMAG
	TRA	EXIT37		# VF IN A AT 8.
#

# Page 93
#		GUIDANCE LAW COMPUTATIONS.
#
GDLAW	TOV	*+1		# TIME TO BURN COMP.
	CLA	VG		# 13
	MPR	4K3		# AT -25
	ADD	4K2		# AT -12
	MPR	VG
	ADD	1B1
	MPY	VG
	LRS	2		# 16
	DVP	AT		# 16-7=9
	TOV	*+2
	TRA	*+2
	CLA	PMAX
	STO	TBO		# TIME TO BURN AT 9.
	TRA	EXIT38
#
#	COMPUTE LUNAR AZIMUTH
#
LUNAZ	CLA	A31
	MPR	A31		# +2
	COM
	ADD	1B2
	TSQ	SQRTE
	STO	TS1		# +1
	LDQ	ZERO
	CLA	A32
	LRS	1		# TO 2
	DVP	TS1
	STO	CODELL
	LDQ	ZERO
	CLA	A33
	LRS	1		# TO 2
	DVP	TS1
	STO	SIDELL		# AT 1
	CLA	MS
	STO	DEL21
	
# Page 94
	TRA	EXIT39
#
# 	POWER ON INITIALIZATION
#
INIT	OUT	3050		# RESET CARRY INHIBIT
	INP	6200
	INP	DEDA
	OUT	7057		# RESET DISCRETES
	CLA	BACK
	STO	TVARBR+1
	CLA	CLAFR		# PRIME HARDWIRED CORES
	STO	TVARBR
	TSQ	TVARBR
	CLA	TVARBR
	SUB	CLATEN
	TMI	*-3
	OUT	7010		# RESET FAILURE INDICATOR
#	GSF SERVICE ROUTINE
GSESR	INP	2040
	ALS	1
	TMI	EXIT40		# INITIALIZE
	INP	6200
	ADD	1B5
	STO	TS7
	ADD	STOCOM		# SET UP VARIABLE STORE
	STO	TVARBR
WRDLP	OUT	6402		# SET GSE 5
	INP	2040
	ALS	1
	TMI	*+2
	TRA	*-3
	OUT	7012		# RESET GSE 5 AND FAIL INDIC.
	INP	2040
	ALS	1
	TMI	*-3		# WAIT FOR NEXT WORD
	ALS	1
	TMI	*+5
	
# Page 95
	CLZ	TS7		# END OF BLOCK
	ADD	TRACOM
	STO	TVARBR
	TRA	TVARBR
	INP	6200		# INPUT WORD AND STORE
	TSQ	TVARBR
	TRA	WRDLP
RETURN	STO	TS0		# INCREMENT OF VARIABLE
	CLZ	TVARBR
	ADD	1B17
	STO	TVARBR
	CLZ	TS0
	TRA	EXIT
#
#		TIME UPDATE AND EXECUTIVE PART 1.
#
TIMEA	CLZ	TA1		# UPDATE ABS TIME.
	ADD	1B17		# EQU TO 2 SECS.
	STO	TA1
	CLA	1B11		# I.C. DEDA COUNTER
	STO 	DEDASC
EXEC	STQ	BRANCH		# SET NEXT BRANCH.
	CLZ	DEDASC
	ALS	1
	TMI	*+3		# -- IS TIME TO DEDA.
	STO	DEDASC
	TRA	EXIT41
	CLZ	BRANCH		# SAVE BRANCH IN
	STO	TMPBR		# TEMPORARY BRANCH
	CLA	DEDABR		# DEDA START
	STO	BRANCH
	TRA	EXIT41		# TO SOFT DISPLAY
#
#		DISPLAY SUBROUTINE
#
DSPLY	CLZ	DSPSC
	ALS	1
	
# Page 96
# This page is missing from the only available listing of FP6,
# and so has simply been duplicated from the corresponding section
# of FP8.  There is good reason to believe that this is valid.
# Refer to the website or the header of this file.
	TOV	*+2		# O.F. IS TIME TO DISPLAY
	TRA	DSPLY4	
	CLZ	PDOUT		# INCREMENT DISPLAY VARIABLES.
	ADD	DPDOUT
	STO	PDOUT		# 13
	CLZ	POUT
	ADD	DPOUT
	TRA	DSPLY2-5
DSPLY1	STO	PDOUT		# I.C. DISPLAY COMPS.
	SUZ	PDOTM1
	MPR	1K4		# .1
	STO	DPDOUT		# DELTA PDOT AT 13.
	CLA	PDOUT		# 13
	STO	PDOTM1
	MPY	1K4		# .1
	LRS	9		# 0.2 PDOT AT 23.
	DVP	POUTFS		# =76840 FT B28
	STO	DPOUT		# DELTA P AT DISPLAY SCALE.
	CLA	POUT		# 23
	LDQ	ZERO
	DVP	POUTFS		# =76840 FT B23
	TOV	*+2
	TRA	*+3
	CLZ	DPOUT
	CLA	PMAX
	STO	POUT		# OUTPUT P AT DISPLAY SCALE.
DSPLY2	CLA	PDOUT		# DISPLAY POSITION RATE.
	ABS
	STO	TS10
	CLA	PDOUT
	TMI	*+3
	CLA	MS		# 1 IS +
	TRA	*+2
	CLA	ZERO		# 0 IS -
	ADZ	TS10		# SIGN MAGNITUDE.
	OUT	3040		# RESET
	OUT	2440		# SELECT ALT RATE.
	
# Page 97
	OUT	6010		# OUTPUT ALT RATE.
	TRA	EXIT42		# COMPUTE VY0 FOR OUTPUT
	OUT	6020		# OUTPUT SAME.
DSPLY3	CLA	POUT		# DISPLAY POSITION
	TMI	*+2
	TRA	*+2
	CLA	ZERO		# ALT NEG.
	ALS	1		# SIGN BIT USED
	OUT	3040		# RESET
	OUT	2420		# SELECT ALT.
	OUT	6010		# OUTPUT ALT.
	CLA	1B5
DSPLY4	STO	DSPSC		# RESET COUNTER.
#
#	CYCLE COUNTING
#
EXEC1	CLZ	MU10		# UPDATE MINOR CYCLE COUNT.
	ADD	1B17
	STO	MU10
	TRA	EXIT43
	CLA	MU10		# CHECK FOR END.
	SUB	49B17
	TMI	DELAY		# -- IS NOT END.
	CLZ	MU10
	CLA	BR50		# BR50 START.
	STO	BRANCH
	TRA	DELAY
#
#		CROSS PRODUCT SUBROUTINE.  AXB=C.
#
CRSPRD	STQ	SREX
	CLA	TS4+2		# AZ
	MPR	TS10+1		# BY
	STO	TS7
	CLA	TS4+1		# AY
	MPR	TS10+2		# BZ
	SUZ	TS7
	
# Page 98
	STO	TS14		# CX
	CLA	TS4		# AX
	MPR	TS10+2		# BZ
	STO	TS7
	CLA	TS4+2		# AZ
	MPR	TS10
	SUZ	TS7
	STO	TS14+1		# CY
	CLA	TS4+1		# AY
	MPR	TS10		# BX
	STO	TS7
	CLA	TS4		# AX
	MPR	TS10+1		# BY
	SUZ	TS7
	STO	TS14+2		# CZ
	TRA	SREX
#
#		NORMALIZE VECTOR SUBROUTINE.
#
NORMV	STQ	SREX2
	CLZ	TS17
	AXT	2,1
	CLA	TS14,1		# INPUT VECTOR
	MPR	TS14,1
	ADZ	TS17
	STO	TS17
	TIX	*-4,1
	TSQ	SQRTE
	STO	TS13
	AXT	2,1
	CLA	TS14,1
	LDQ	ZERO
	LRS	1
	DVP	TS13
	STO	TS10,1		# UNIT VECTOR AT 1.
	TIX	*-5,1
	TRA	SREX2
	
# Page 99
#
#		ORBIT PARAMETERS FROM EPOCH SUBROUTINE
#
ORBPM	STQ	SREX2
	CLZ	TS11
	CLZ	TS12
	CLZ	TS13
	TOV	*+1
	AXT	2,1
ORBPM1	CLA	R0X,1		# 23
	MPR	V0X,1		# 13
	ADZ	TS13
	STO	TS13		# R0 DOT V0 AT 36
	CLA	V0X,1
	MPR	V0X,1
	ADZ	TS12
	STO	TS12		# V0 DOT V0 AT 26
	CLA	R0X,1
	MPR	R0X,1
	ADZ	TS11
	STO	TS11		# R0 DOT R0 AT 46
	TIX	ORBPM1,1
EX44	TRA	EXIT44
	TSQ	SQRTE
	STO	R0		# 23
	MPY 	TS12		# 23+26=49
	TOV	*+1
	DVP	2K1		# 48
	COM
	ADD	PMAX		# 2B1
	STO	TS1
	CLA	R0
	LDQ	ZERO
	LRS	1
	DVP	TS1
EX45	TRA	EXIT45
	STO	AI		# ALPHA I AT 23
	
# Page 100
	CLA	2K1
	LDQ	ZERO
	LRS	1		# 49
	DVP	AI		# 49-23=26
	TSQ	SQRTE
	STO	TS1		# ROOT(MU/ALPHA) AT 15
	LDQ	ZERO
	LRS	1
	DVP	AI
	STO	NI		# ANG FREQ AT -9.
	CLA	AI
	SUB	R0
	LDQ	ZERO
	DVP	AI
	STO	CI		# 0
	CLA	AI
	MPZ	TS1
	STO	TS1		# ROOT(ALPHA X MU) AT 36
	CLZ	TS13
	LDQ 	ZERO
	DVP	TS1
	STO	SI		# 0
	TRA	SREX2
#
#		ELLIPSE PREDICTOR SUBROUTINE.
#
ELPRD	STQ	SREX2
	CLZ	TS7		# ITERATION COUNTER.
	CLA	TI		# 13
	MPR	NI		# AT -9.
	ALS	1
	STO	TS10		# DEL M AT 3.
ELPRD1	STO	TS11		# DEL E AT 3.
	TSQ	SICOE
	CLA	TS0
	MPR	CI		# AT 0.
	STO	TS13		# 1
	
# Page 101
	CLA	TS1		# 1
	MPR	SI		# 0+1=1
	SUZ	TS13
	ADD	1B1
	STO	TS12		# X12 AT 1.
	CLZ	TS7
	SUB	2B17		# 2 ITERATIONS.
	TMI	ELPRD3		# -- IS NOT DONE.
	CLA	CI		# 0
	LRS	1		# 1
	COM
	ADD	TS0
	MPY	AI		# 23+1=24
	DVP	R0		# 23
	STO	TS3		# F AT 1.
	CLZ	TS10		# 3
	SUZ	TS11
	ALS	2		# 1
	ADD	TS1
	LDQ 	ZERO
	LRS	1
	DVP	NI		# AT -9.
	STO	TS7		# G AT 11.
	CLA	R0
	MPR	TS12
	STO	TS14		# 24
	CLA	AI
	MPR	NI
	MPY	TS1		# 23-9+1=15
	DVP	TS14
	COM	
	STO	TS13		# F DOT AT -9.
	CLA	TS12		# X12
	SUB	1B1
	ADZ	TS0
	LDQ	ZERO
	LRS	1		# 2
	
# Page 102
	DVP	TS12
	STO	TS17		# G DOT AT 1.
	AXT	2,1
ELPRD2	CLA	R0X,1		# 23
	MPR	TS3		# 1
	STO	TS2		# 24
	CLA	V0X,1		# 13
	MPR	TS7		# 11+13=24
	ADZ	TS2
	ALS	1		# 23
	STO	RIX,1		# PRED POS AT 23
	CLA	R0X,1		# 23
	MPR	TS13		# -9
	STO	TS2		# 14
	CLA	V0X,1		# 13
	MPR	TS17		# 1
	ADZ	TS2
	ALS	1
	STO	VIX,1		# PRED VEL AT 13
	TIX	ELPRD2,1
	TRA	SREX2
ELPRD3	ADD	3B17
	STO	TS7
	CLA	TS10		# 3
	SUB	TS11
	ALS	2
	STO	TS13		# DEL(M)-DEL(E) AT 1.
	CLA	TS0		# 1
	LRS	1		# 2
	SUB	1B2
	MPR	SI		# 0+2=2
	ALS	1
	STO	TS14		# 1
	CLA	TS1
	MPR	CI		# 0+1=1
	ADZ	TS14		
	ADZ	TS13		# X11 IN A AT 1.
	
# Page 103
	LDQ	ZERO
	LRS	3		# 4
	DVP	TS12		# DEL E CORRECTION AT 3.
	ADZ	TS11		# DEL 3
	TRA	ELPRD1
#
#		DOUBLE PRECISION SQUARE SUBROUTINE
#
DPSQ	STQ	SREX
	CLZ	TS1		# A SQ MS
	CLZ	TS2		# A SQ LS
	AXT	2,1
DPSQ1	CLA	TS4,1
	MPY	TS4,1
	ADZ	TS1
	TMI	DPSQ3		# CHECK FOR O.F.
	STO	TS1
	STQ	TS3
	CLZ	TS2
	ADZ	TS3
	STO	TS2
	TMI	*+2		# CHECK FOR O.F.
	TRA	DPSQ2
	SUB	MS
	STO	TS2
	CLZ	TS1
	ADD	1B17
	TMI	DPSQ3		# CHECK FOR O.F.
	STO	TS1
DPSQ2	TIX	DPSQ1,1
	TRA	SREX
DPSQ3	CLA	PMAX		# O.F. DETECTED.
	STO	TS1
	TRA	SREX
#
#		NORMALIZE SUBROUTINE.
#

# Page 104
NORM	STQ	SREX1
	TOV	*+1		# CLEAR O.F.
	LDQ	TS2		# A SQ LS
	AXT	7,1		# 8 SHIFTS(16 PLACES) POSSIBLE
	CLA	TS1		# A SQ MS
	LLS	2
	TOV	NORM1
	STO	TS1		# NORMALIZED A.
	TIX	*-4,1
	CLA	8B17
	ADD	SHDUM		# LRS 0
	TRA	SREX1
NORM1	CLA	7B17,1
	TRA	*-3
#
#		DOUBLE PRECISION VECTOR MAGNITUDE
#
DPVMAG	STQ	SREX2		# SAVE RET ADDRS.
	TSQ	DPSQ		# TO DOUB PREC SQ.
	TSQ	NORM		# TO NORMALIZE.
	STO	SREX3		# LRS(I/2)
	CLZ	TS1		# NORMALIZED SQ.
	TSQ	SQRTE
	TRA	SREX3		# RE-NORMALIZE A-REG.
#
#		DOUBLE PRECISION TIME SUBTRACT
#
DPTSB	STQ	SREX
	CLA	TA1		# ABS TIME MS AT 18.
	SUB	TE1,1		# EPOCH TIME MS AT 18.
	ALS	5		# 13
	STO	TS1
	CLA	TE2,1		# EPOCH TIME LS AT 1.
	LRS	12		# 13
	STO	TS2
	CLA	TA2		# ABS TIME LS AT 1.
	LRS	12		# 13
	
# Page 105
	SUZ	TS2
	ADZ	TS1
	STO	TI		# TIME DIFF AT 13.
	TRA	SREX
#
EXIT	STQ	SREX2
	TRA	SREX2
#
#		SINE-COSINE SUBROUTINE ENTER WITH ANGLE IN
#		RADIANS AT B3 IN ACC AND RETURN IN Q
#
	ADD	2PIB3
SICOE	TMI	*-1		# SET PLUS
	STQ	SREX
	STO	TS1
	SUB	2PIB3		# SET BETWEEN 0-2PI
	TMI	*+2
	STO	TS1
	CLA	PID2		# PI/2
	SUB	TS1
	STO	TS0		# PI/2-ALPHA
	TMI	SICO1		# -- IS GREATER THAN 90
	AXT	1,1
SICO2	CLA	TS0,1
	ALS	2		# TO 1
	STO	TS0,1
	MPR	TS0,1
	STO	TS2		# ALPHA SQUARED AT 2
	MPR	K173		# 2-6=-4
	ADD	K172
	MPR	TS2		# -2
	ADD	K171
	MPR	TS2		# 0
	ADD	K170
	MPR	TS0,1		# 1
	STO	TS0,1
	TIX	SICO2,1
	
# Page 106
	TRA	SREX		# EXIT
SICO1	ADD	PID2
	STO	TS1		# PI-ALPHA
	TMI	*+2		# -- IS GREATER THAN 180
	TRA	SICO2-1
	ADD	PID2
	COM
	STO	TS0		# ALPHA-3PI/2
	TMI	SICO2-1		# -- IS BETWEEN 180 AND 270
	SUB	PID2
	STO	TS1		# ALPHA-2PI
	TRA	SICO2-1
#
#		ARCTANGENT SUBROUTINE ENTER WITH SINE AND 
#		COSINE AT 1 IN TS3 AND TS4
#
ARCTAE	STQ	SREX		# SET EXIT
	CLA	TS3
	ABS
	STO	TS1
	CLA	TS4
	TOV	*+1
	ABS
	ADD	TS1		# KCOS+KSIN
	TOV	*+3		# O.F. CHECK.
	CLA	TS4
	TRA	*+7
	CLZ	TS1		# O.F. RE-SCALE.
	LRS	1
	STO	TS1		# ABS SIN.
	CLZ	TS4
	LRS	1
	STO	TS4		# COS
	TMI	ARCTA2		# -- IS 2ND OR 3RD QUAD
	ADD	TS1
	STO	TS2
	CLA	PID4
	
# Page 107
	STO	TS5		# 1/4 PI
	CLA	TS1
	SUB	TS4		# SIN-COS
ARCTA1	LDQ	ZERO
	LRS	1
	DVP	TS2
	STO	TS6		# =X AT 1
	MPY	TS6
	STO	TS7		# X SQUARED AT 2
	MPR	K183		# -1
	ADD	K182
	MPY	TS7		# 1
	ADD	K181
	MPY	TS7		# 3
	LLS	1		# 2
	ADD	K180
	MPR	TS6		# 3
	ADD	TS5
	STO	TS1
	CLA	TS3
	TMI	*+3
	CLA	TS1
	TRA	SREX		# EXIT
	CLA	2PIB3		# PHI GREATER THAN 180
	SUB	TS1
	TRA	SREX
ARCTA2	CLA	3PID4
	STO	TS5		# 3/4 PI
	CLA	TS4
	SUB	TS1
	STO	TS2
	CLA	TS1
	ADD	TS4
	TRA	ARCTA1
#
#		SQUARE ROOT SUBROUTINE ENTER WITH
#		SQUARE IN ACC AND RETURN IN Q

# Page 108
#
SQRTE	STQ	SREX
	STO	TS1
	COM			# TEST FOR ZERO OR NEG
	TMI	*+3
	CLA	ZERO		# SET ROOT EQUAL ZERO
	TRA	SREX
	CLZ	TS2		# SET TS2=0
	TSQ	NORM		# TO NORMALIZE
	STO	SREX1		# SAVE SHIFT
	CLA	TS1
	LRS	1		# .5SQ
	STO	TS8
	STQ	TS1
	LRS	2		# .125SQ
	ADD	TS8		# .625SQ
	ADD	KSR		# .375+.625SQ=RN-1
	AXT	1,1		# 2 ITERATIONS
SQRT1	STO	TS2	
	LRS	1		# .5 RN-1
	STO	TS0
KSR	LDQ	TS1		# KSR=.375+DELTA
	CLA	TS8
	DVP	TS2
	ADZ	TS0		# .5SQ/RN-1+.5RN-1=RN
	TIX	SQRT1,1
	TRA	SREX1		# TO SHIFT
#
#		ANGLE BETWEEN VECTORS SUBROUTINE.
#
ABVEC	STQ	SREX1
	CLA	TS10		# BX
	MPR	TS4+2		# AZ
	LRS	1
	STO	TS2
	CLA	TS4		# AX
	MPR	TS10+2		# BZ
	
# Page 109
	LRS	1
	SUZ	TS2
	STO	TS3		# SIN THETA
	CLA	TS4		# AX
	MPR	TS10		# BX
	LRS	1
	STO	TS2
	CLA	TS4+2		# AZ
	MPR	TS10+2		# BZ
	LRS	1
	ADZ	TS2
	STO	TS4		# COS THETA
	TSQ	ARCTAE
	TRA	SREX1		# THETA IN A AT 3.
#
#	DEDA PROCESSING ENTRY
#
ADOUT	CLA	ADST		# OUTPUT ADDRESS
	ADD	DUMCLA
	STO	CLADD		# SET CLA OF DATA
	LRS	9
	AXT	2,1
	LLS	3		# 3 BITS PER PASS
	OUT	DEDA
	OUT	SHOUT		# SET SHIFT OUT
	ALS	18		# TIME DELAY
	TIX	*-4,1
	TRA	CLADD		# GET DATA
ROR	STO	DD
	TMI	SNS		# TEST SIGN
	CLA	ZERO		# POSITIVE
	
SOUT	OUT	DEDA		# OUTPUT SIGN
	OUT	SHOUT
	CLA	OCTF		# OCTAL OR DECIMAL OUTPUT
	TMI	OCTO
EX46	TRA	EXIT46
	CLA	DD		# DECIMAL OUTPUT
	
# Page 110
	MPR	SF		# SCALE FACTOR
	ABS			# MAGNITUDE
	AXT	4,1		# OUTPUT 5 DIGITS
	TOV	*+1
	LDQ	ZERO
	DVP	BCDL		# DIVIDE BY 100K
	STQ	TS1
	CLZ	TS1		# UNROUNDED QUOTIENT
	ADD	1B17		# ROUND UP
	TOV	MAX		# TEST FOR TOO LARGE
DOUT	MPY	10B17		# EXTRACT DIGIT
	OUT	DEDA		# OUTPUT
	OUT	SHOUT
	STQ	TS1		# REMAINDER
	CLZ	TS1
	TIX	*-5,1
	TRA	EXIT47
OCTO	LDQ	DD		# OCTAL OUTPUT
	AXT	4,1		# OUTPUT 5 OCTAL DIGITS
	LLS	3		# EXTRACT DIGIT
	OUT	DEDA		# OUTPUT
	OUT	SHOUT
	ALS	18		# TIME DELAY
	TIX	*-4,1
	TRA	EXIT47
RME	STO	RMF		# READOUT ENTRY
	OUT	SHIN		# ENTER ENTRY	SET SHIFT IN
	CLZ	CMF		# RESET CLEAR MODE
	CLZ	OCTF		# OCTAL FLAG
	CLZ	DD		# CLEAR DEDA DATA
	CLA	ZERO
	AXT	2,1		# INPUT 3 DIGIT ADDRESS
	ALS	3
	STO	ADST
	INP	DEDA		# INPUT DIGIT
	OUT	SHIN		# SET SHIFT IN
	LRS	13
	
# Page 111
	SUB	8B17		# TEST FOR ERROR
	TMI	*+2
	TRA	EXIT48		# ERROR EXIT
	ADD	8B17
	ADZ	ADST		# ASSEMBLE ADDRESS
	TIX	*-10,1
	STO	ADST
	INP	DEDA
	OUT	SHIN
	ALS	4
	STO	TS2		# SIGN
	CLA	ADST
	TRA	EXIT49		# SCALE FACTOR SELECT
NOTDD	CLA	MS		# SET OCTAL FLAG
	STO	OCTF
	CLA	RMF		# EXIT IF READOUT
	TMI	EXIT47
	AXT	4,1		# INPUT 5 OCTAL DIGITS
	INP	DEDA
	OUT	SHIN
	LRS	14
	ADZ	DD		# ASSEMBLE WORD
	LLS	3
	STO	DD
	TIX	*-6,1
	ADZ	TS2		# ADD SIGN
	TRA	STDD
DDIN	CLA	RMF		# DECIMAL DATA
	TMI	EXIT47		# EXIT IF READOUT
	AXT	4,1		# READ 5 DIGITS
	TRA	*+5
	OUT	SHIN
	MPY	10B4		# MULTIPLY BY 10
	LLS	4		# SCALE
	STO	DD
	INP	DEDA
	LRS	13
	
# Page 112
	ADZ	DD		# ASSEMBLE WORD
	TIX	*-7,1
EX50	TRA	EXIT50
	DVP	SF		# SCALE FACTOR
STDD	STO	DD
	CLZ	TS2
	TMI	*+2		# COMPLEMENT IF MINUS
	TRA	EXIT51		# IMMEDIATE ACTION TEST
	CLZ	DD		# COMPLEMENT
	COM
	TRA	STDD
SNS	CLA	1B17		# PICK UP NEGATIVE SIGN
	TRA	SOUT
MAX	CLA	PMAX		# GET MAXIMUM NUMBER
	TRA	DOUT
#
#	ABSOLUTE TIME INITIALIZE
#
ATI	CLA	MU10		# CYCLE COUNT
	LDQ	ZERO
	DVP	M25B16		# MINUS SEC AT 1
	ADD	DTB		# 1+TIME BIAS
	ADD	1B1		# +1 SEC
	STO	TA2		# 2+BIAS-CYCLE COUNT
	CLA	DD		# INPUT TIME
	SUB	1B17		# T-2 SEC
	STO	TA1		# MOST SIG ABS TIME
	TRA	EXIT47
#
#	AGS TELEMETRY OUTPUT
#
TME	STQ	SREX
	INP	DISC1I
	ALS	2		# TEST FOR STOP
	TMI	SREX		# EXIT IF NOT
	CLZ	TMID
	ADD	1B17		# INCREMENT IDENT NUMBER
	
# Page 113
	STO	TMID
	ADD	TMCLA		# SET UP TO GET WORD
	STO	SREX-2
	SUB	TMCLA		# GET ID
	ALS	12
	OUT	TMIDO		# OUTPUT IDENTIFICATION
	CLA	TMOUT		# OUTPUT INSTRUCTION
	STO	SREX-1
	TRA	SREX-2
#
#	TELEMETRY INITIALIZE
#
TMIE2	CLZ	TMID		# RESET TO FIRST WORD
	AXT	2,1
	CLA	A11,1		# SAVE DIRECTION COSINES
	STO	A11T,1		# FOR TELEMETRY
	CLA	A31,1
	STO	A31T,1
	TIX	*-4,1
	TRA	EXIT
#
#	PGNS DOWNLINK INPUT
#
PGNSDE	STQ	SREX
	CLA	DLIF		# DOWNLINK INITIALIZE FLAG
	TMI	*+2
	TRA	SREX		# EXIT
	INP	DISC1I
	ALS	1		# TEST FOR STOP
	TMI	SREX		# PULSE RECEIVED
	INP	DLREG		# INPUT WORD
	LRS	2		# DISCARD UNWANTED BITS
	STO	TS12		# SAVE INPUT
	CLA	ID1F		# TEST FOR PRIOR ID
	TMI	PGNSD1		# NUMBER 1 FOUND
	CLZ	TS12		# TEST IF CURRENT
	TMI	SREX		# WORD IS AN ID
	
# Page 114
	SUB	ID1		# TEST FOR PROPER ID
	ABS
	COM
	TMI	SREX
	CLA	K173		# IS IDAI OR IDRP
	STO	ID1F		# SET FLAG
	CLZ	DLWN		# ZERO WORD NUMBER
PBNSD2	CLA	1B5
	STO	DLSC		# SET SHIFT COUNT
	TRA	SREX		# EXIT
PGNSD1	TRA	EXIT7
	CLZ	DLSC
	ALS	1		# TEST FOR ID
	TMI	PBNSD2		# WORD EXPECTED
	STO	DLSC
	CLZ	DLWN
	ADD	1B17		# INCREMENT WORD NUMBER
	STO	DLWN
	ADD	DLSTO		# FORM STORE COMMAND
	STO	SREX-1
	SUB	DLWNL		# TEST FOR LAST WORD
	TMI	*+4
	CLZ	ID1F		# RESET ID1 FLAG
	CLZ	DLIF		# RESET INITIALIZE FLAG
	STO	IDRF		# SET DATA RECEIVED FLAG
	CLZ	TS12
	ALS	3
	TRA	SREX-1
#
# 	SELF-TEST ROUTINE
TEST	CLA	FLAGT
	TMI	CKSUM
	CLA	S12
	SUB	1B3
	TMI	*+4
	SUB	1B2
	TMI	*+3		# -- IS LESS THAN 3
	
# Page 115
	TRA	EXIT52
	OUT	7010
#	LOGIC TEST
	TOV	*+1		# ACCUM.   Q REG.   OPER.
	LDQ	K170		#          377777   377777
	CLA	SIXTH		# 252525   377777   252525
	ALS	1		# 525252
1K7	STQ	TS0
	TSQ	OVFLW		# TEST FOR OVERFLOW
	LRS	17		# 777777   525252
10B4	SUB	TS0		# 400000   525252   377777
	STQ	TS0
	TOV	ERROR		# TEST RESET OF OVERFLOW
	COM			# 400000
	TMI	*+2
	TRA	ERROR
3B3	LDQ	TS0		# 400000   525252   525252
	LLS	17		# 125252   000000
	STQ	TS1
	TSQ	OVFLW
	SUB	TS1		# 125252            000000
	SUB	TS0		# 400000            525252
	ALS	1		# 000000
	TSQ	OVFLW
	LDQ	4B17		# 000000   000004   000004
	LLS	31		# 200000   000000
	TOV	ERROR		# NO OVERFLOW
	LDQ	MS		# 200000   400000   400000
	STQ	TS1
	LRS	16		# 000001   000000
	ADD	TS1		# 400001   000000   400000
	STQ	TS2
	ADD	TS2
	TMI	*+2
	TRA	ERROR
	ADD	K170		# 000000   000000   377777
	TMI	ERROR
	
# Page 116
	TOV	ERROR
	COM			# 000000
	TSQ	ACCUM		# 777777
	COM			# 000001
	ABS			# 000001
	AXT	7,1
	STO	TS0,1		# STORE 8 NUMBERS IN
	SUB	1B17		# SEQUENCE
	TIX	*-2,1
	CLA	1B17		# 000001            000001
	# 2005-06-12 RSB.  In the comment field, the OPER
	# entry was incorrectly shown as 777776.  Since 
	# CLZ clears the operand, this is impossible.
	CLZ	TS4		# 777776            000000
	ALS	15		# 600000
	TOV	ERROR
	# 2005-06-12 RSB.  Same, but was 777777
	MPZ	TS5		# 000001   200000   000000
	# 2005-06-12 RSB.  Same, but was 000001
	SUZ	TS7		# 000000   200000   000000
	LLS	3		# 000004   000000
	# 2005-06-12 RSB.  Same, but was 777774
	ADZ	TS2		# 000000   000000   000000
	AXT	3,1
	ADD	TS4,1
	TIX	*-1,1
	AXT	7,1
	AXT	0,1
	# 2005-06-12 RSB.  Same, but was 777775
	SUZ	TS3,1		# 000003   000000   000000
	TIX	ERROR,1
	AXT	2,1
	# 2005-06-12 RSB.  Same, but was 777773
	ADZ	TS1		# 777776   000000   000000
	TIX	*+1,1
	TIX	*+1,1
	# 2005-06-12 RSB.  Same, but was 777772
	SUZ	TS0,1		# 000004   000000   000000
	AXT	3,1
	ADZ	TS0,1
	TIX	*-1,1
	ADD	MS		# 400004            400000
	ABS			# 377774
	ADD	K170		# 777773            377777
	TSQ	OVFLW
	ABS			# 000005
	
# Page 117
	LLS	0
	SUB	5B17		# 000000            000005
	TSQ	ACCUM		# 777777
	CLA	TS0		# 000000            000000
	TRA	*+3
	TSQ	ACCUM		# 777777
	TRA	*+2
	TRA	*-2
	STO	TS0
	ADD	1B17		# 000000            000001
	CLA	TS0		# 777777            777777
	SUB	TS0		# 000000            777777
	TSQ	ACCUM		# 777777
	ALS	16		# 600000
	MPY	TS0		# 000000   200000   777777
	STQ	TS1
	ADD	TS1		# 200000   200000   200000
	SUB	1B1		# 000000   200000   200000
	ADD	SIXTH		# 252525   200000   252525
	MPR	3B17		# 000002   377777   000003
	ADD	TS0		# 000001   377777   777777
	DVP	2B17		# 377777   377777   000002
	TOV	ERROR
	STQ	TS2
	SUB	K170		# 000000   377777   377777
	SUB	K170		# 400001   377777   377777
	ADD	TS2		# 000000   377777   377777
	ADD	SIXTH		# 252525   377777   252525
	SUB	5B17		# 252520   377777   000005
	MPR	SIXTH		# 161612   161620   252525
	STQ	TS2
	SUB	TS2		# 777772   161620   161620
	LRS	17		# 777777   777772
	DVP	4B17		# 777777   777776   000004
	STQ	TS2
	ADD	TS2		# 777775   777776   777776
	ADD	3B17		# 000000   777776   000003
	
# Page 118
	SUB	SIXTH		# 525253   777776   252525
	STO	TS3	
	MPR	TS3		# 161616   307071   525253
	DVP	TS3		# 525251   525251   525253
	MPY	SIXTH		# 616160   743435   252525
	DVP	SIXTH		# 525251   525251   252525
	ADD	2B17		# 525253   525251   000002
	ADD	TS3		# 252526            525253
	TSQ	OVFLW
	SUB	TS3		# 525253            525253
	TSQ	OVFLW
	SUB	SIXTH		# 252526            252525
	TSQ	OVFLW
	COM
	ADD	SIXTH		# 777777            252525
	LDQ	TS6		# 777777   000000   000000
	ADD	TS0		# 777776   000000   777777
	LRS	2		# 777777   600000
1B3	DVP	TS0		# 200000   177777   777777
	STQ	TS0
	TSQ	OVFLW
	SUB	TS0		# 000001            177777
	SUB	1B17		# 000000            000001
	TSQ	ACCUM		# 777777
	CLA	3B17
	DVP	2B17
	TSQ	OVFLW		# END OF LOGIC TEST
SETFG	CLA	MS
	STO	FLAGT		# SET TEST FLAG
	CLZ	SUM
	CLA	TCLTH		# INITIALIZE MEMORY
	STO	TVARBR		# TEST
	CLA	CLATEN
	STO	SUMLIM
	TRA	EXIT52
#	MEMORY CHECKSUM ROUTINE
CKSUM	TSQ	MEMSUM		# PERFORM SUMMATION

# Page 119
	CLZ	SUM		# TEST SUM
	TMI	*+3
	SUB	1B17
	TMI	COREX
	CLA	S12		# INCORRECT SUM
	SUB	3B3		# SET TEST WORD BITS
	TMI	*+4		# AND TEST MODE FAILURE
	CLA	7B3		# INDICATOR
	STO	S12
	TRA	*+3
	CLA	1B1
	OUT	6410
	STO	S12
	CLZ	FLAGT		# RESET FLAG
	TRA	EXIT52
COREX	CLA	S12		# CORRECT SUM
	SUB	1B17
	TMI	*+2
	TRA	*-5
	CLA	1B3
	TRA	COREX-3
MEMSUM	STQ	SREX		# MEMORY SUMMATION SUBRT.
	CLZ	WRDCNT
	TSQ	TVARBR
	ADZ	SUM		# FORM SUM
	STO	SUM
	CLA	TVARBR
	SUB	SUMLIM		# TEST FOR LIMIT 
	TMI	*+2
	TRA	SREX
	CLZ	WRDCNT
	ADD	1B17
	STO	WRDCNT		# INCREMENT WORD COUNTER
	SUB	WORDS
	TMI	MEMSUM+2
	TRA	EXIT53
ACCUM	TMI	ERROR		# SUBROUTINE TO TEST FOR

# Page 120
	SUB	1B17
	TMI	EXIT
ERROR	CLA	3B3
	STO	S12
	TRA	SETFG
OVFLW	TOV	EXIT		# OVERFLOW TEST
	TRA	ERROR
#
#		INPUT-OUTPUT ADDRESSES
#
	CHECKSUM RANGE 4000-7776
DLREG	DEFINE	6200		
DISC1I	DEFINE	2020		# DISCRETE INPUT WORD 1
DISC2I	DEFINE	2040		# DISCRETE INPUT WORD 2
DEDA	DEFINE	2200
SIALO	DEFINE	2001		# DEFINE OUTPUT REGISTERS
COALO	DEFINE	2002		# FOR FDAI ANGLES
SIBEO	DEFINE	2004
COBEO	DEFINE	2010
SIGAO	DEFINE	2020
COGAO	DEFINE	2040
EXO	DEFINE	6001		# DEFINE THE ATT ERROR
EYO	DEFINE	6002		# OUTPUT REGISTERS
EZO	DEFINE	6004
TMIDO	DEFINE	6200
SHOUT	DEFINE	2600
SHIN	DEFINE	2500
	END
	
	
