# Copyright:	Public domain.
# Filename:	TVCEXECUTIVE.s
# Purpose:	Part of the source code for Colossus, build 249.
#		It is part of the source code for the Command Module's (CM)
#		Apollo Guidance Computer (AGC), possibly for Apollo 8 and 9.
# Assembler:	yaYUL
# Reference:	Begins at p. 907 of 1701.pdf.
# Contact:	Ron Burkey <info@sandroid.org>.
# Website:	www.sandroid.org/Apollo.
# Mod history:	08/22/04 RSB.	Transcribed.
#
# The contents of the "Colossus249" files, in general, are transcribed 
# from a scanned document obtained from MIT's website,
# http://hrst.mit.edu/hrs/apollo/public/archive/1701.pdf.  Notations on this
# document read, in part:
#
#	Assemble revision 249 of AGC program Colossus by NASA
#	2021111-041.  October 28, 1968.  
#
#	This AGC program shall also be referred to as
#				Colossus 1A
#
#	Prepared by
#			Massachussets Institute of Technology
#			75 Cambridge Parkway
#			Cambridge, Massachusetts
#	under NASA contract NAS 9-4065.
#
# Refer directly to the online document mentioned above for further information.
# Please report any errors (relative to 1701.pdf) to info@sandroid.org.
#
# In some cases, where the source code for Luminary 131 overlaps that of 
# Colossus 249, this code is instead copied from the corresponding Luminary 131
# source file, and then is proofed to incorporate any changes.

# Page 907
# PROGRAM NAME....	DVCEXECUTIVE, CONSISTING OF TVCEXEC, NEEDLEUP, VARGAINS
#			REPCHEK, SWTCHOVER, CG.CORR, STRKUP, TVCEXFIN, ETC.
# LOG SECTION....	TVCEXECUTIVE	SUBROUTINE ....DAPCSM
# MOD BY ENGEL				DATE 23 OCT, 1967
#
# FUNCTIONAL DESCRIPTION....
#      *A SELF-PERPETUATING WAITLIST TASK AT 1/2 SECOND INTERVALS WHICH:
#	PREPARES THE ROLL TVC DAP LADDERS
#	PREPARES THE ROLL FDAI NEEDLE (FLY-TO  OGA ERROR)
#	PREPARES THE ROLL PHASE PLANE  OGAERR  (FLY-FROM  OGA ERROR)
#	PREPARES THE TVC ROLLDAP TASK WAITLIST CALL (3 CS DELAY)
#	UPDATES THE NEEDLES DISPLAY
#	IMPLEMENTS VARIABLE GAINS AND VARIABLE VEHICLE MASS
#	PROVIDES FOR SWITCHOVER
#	PROVIDES FOR A SINGLE-SHOT THRUST MISALIGNMENT CORRECTION AT SWTOVR
#	PROVIDES FOR REPETITIVE THRUST MISALIGNMENT CORRECTIONS FOLLOWING
#		SWITCHOVER
#	PERFORMS CERTAIN STROKE TEST FUNCTIONS
#
# CALLING SEQUENCE....
#      *TVCEXEC CALLED AS A WAITLIST TASK, IN PARTICULAR BY TVCINIT4 AND BY
#	ITSELF, BOTH AT 1/2 SECOND INTERVALS
#
# NORMAL EXIT MODE.... TASKOVER
#
# ALARM OR ABORT EXIT MODES.... NONE
#
# SUBROUTINES CALLED....NEEDLER, S40.15, MASSPROP, TASKOVER, IBNKCALL
#
# OTHER INTERFACES....
#      *TVCRESTART PACKAGE FOR RESTARTS
#      *PITCHDAP, YAWDAP FOR VARIABLE GAINS AND ENGINE TRIM ANGLES
#      *S40.6 KPRIMEDT AT SWITCHOVER
#
# ERASABLE INITIALIZATION REQUIRED....
#      *SEE TVCDAPON....TVCINIT4
#      *VARK AND 1/CONACC (S40.15 OF R03)
#      *V68 INITIALIZATION PRIOR TO SWITCHOVER OR FOLLOWING A RESTART
#	DURING A STROKE TEST, IF STROKE TEST FUNCTIONS ARE TO BE TESTED
#      *PAD LOADS EREPFRAC, ECORFRAC ETC.
#      *BITS 15,14 OF FLAGWRD6 (T5 BITS)
#      *TVCEXPHS FOR RESTARTS
#      *ENGINE-ON BIT (11.13) FOR RESTARTS
#      *CDUX, OGAD
#
# OUTPUT....
# Page 908
#      *ROLL TVC DAP LADDERS, FDAI NEEDLE (AK), AND PHASE PLANE OGAERR
#      *VARIABLE GAINS FOR PITCH/YAW AND ROLL TVC DAPS
#      *SINGLE-SHOT AND REPETITIVE CORRECTIONS TO ENGINE TRIM ANGLES
#	PACTOFF AND YACTOFF
#      *CHANGES TO DAP SAMPLE RATES, DAP GAINS, AND STEERING-GAIN SCALING
#	AT (LEM-ON) SWITCHOVER
#      *STROKER, 4 SECONDS AFTER SWITCHOVER WHEN PRIOR V66, OR 2.5
#	SECONDS AFTER RESTART DURING A STROKE TEST
#
# DEBRIS....	MUCH, BUT SHAREABLE WITH RCS/ENTRY, ALL IN EBANK6

		BANK	16
		SETLOC	DAPROLL
		BANK
		EBANK=	BZERO
		COUNT*	$$/TVCX
TVCEXEC		CS	FLAGWRD6	# CHECK FOR TERMINATION (BITS 15,14 READ
		MASK	OCT60000	#	10 FROM TVCDAPON TO RCSDAPON)
		EXTEND
		BZMF	TVCEXFIN	# TERMINATE
		
		CAF	.5SEC		# W.L. CALL TO PERPETUATE TVCEXEC
		TC	WAITLIST
		EBANK=	BZERO
		2CADR	TVCEXEC
		
ROLLPREP	CAE	CDUX		# UPDATE ROLL LADDERS (NO NEED TO RESTART-
		XCH	OGANOW		# 	PROTECT, SINCE ROLL DAPS RE-START)
		XCH	OGAPAST
		
		CAE	OGAD		# PREPARE ROLL FDAI NEEDLE WTIH FLY-TO
		EXTEND			#	ERROR (COMMAND - MEASURED)
		MSU	OGANOW
		TS	AK		# FLY-TO OGA ERROR, SC.AT B-1 REVS
		
		EXTEND			# PREPARE ROLL DAP PHASE PLANE OGAERR
		MP	-BIT14	
		TS	OGAERR		# PHASE-PLANE (FLY-FROM) OGAERROR,
					#	SC.AT B+0 REVS
		
		CAF	THREE		# SET UP ROLL DAP TASK (ALLOW SOME TIME)
		TC	WAITLIST
		EBANK=	BZERO
		2CADR	ROLLDAP
		
NEEDLEUP	TC	IBNKCALL	# DO A NEEDLES UPDATE (RETURNS AFTER CADR)
		CADR	NEEDLER		#	(NEEDLES RESTARTS ITSELF)

# Page 909
VARGAINS	CAF	BIT13		# CHECK ENGINE-ON BIT TO INHIBIT VARIABLE
		EXTEND			#	GAINS AND MASS IF ENGINE OFF
		RAND	DSALMOUT	# CHANNEL 11
		CCS	A
		TCF	+4		#	ON, SO OK TO UPDATE GAINS AND MASS
	+5	CAF	TWO		#	OFF, SO BYPASS MASS/GAIN UPDATES,
		TS	TVCEXPHS	#		ALSO ENTRY FROM CCS BELOW WITH
		TCF	SWT/COR		#		VCNTR = -0 (V97 R40 ENGFAIL)
		
		CCS	VCNTR		# 	TEST FOR GAIN OF UPDATE TIME
		TCF	+4		#		NOT YET
		TCF	GAINCHNG	#		NOW
		TCF	+0		#		NOT USED
		TCF	VARGAINS +5	#		NO, LOTHRUST (S40.6 R40)
		
	+4	TS	VCNTRTMP	#	PROTECT VCNTR AND
		CAE	CSMMASS		#	CSMMASS DURING AN IMPULSIVE BURN
		TS	MASSTMP
		TCF	EXECCOPY
		
GAINCHNG	TC	IBNKCALL	# UPDATE IXX, IAVG, IAVG/TLX
		CADR	FIXCW		# MASSPROP ENTRY (ALREADY INITIALIZED)
		TC	S40.15		# UPDATE 1/CONACC, VARK
		CS	TENMDOT		# UPDATE MASS FOR NEXT 10 SEC. OF BURN
		AD	CSMMASS
		TS	MASSTMP		# KG B+16
		
		CAF	NINETEEN	# RESET THE VARIABLE-GAIN UPDATE COUNTER
NOUPDATE	TS	VCNTRTMP	# (COUNTDOWN, FROM VARGAINS +1)

EXECCOPY	INCR	TVCEXPHS	# RESTART-PROTECT TEH COPYCYCLE		(1)

		CAE	MASSTMP		# CSMMASS KG B+16
		TS	CSMMASS
		
		CAE	VCNTRTMP	# VCNTR
		TS	VCNTR
		TS	V97VCNTR	# FOR ENGFAIL (R41) MASS UPATES AT SPSOFF
		
		INCR	TVCEXPHS	# COPYCYCLE OVER			(2)
		
SWT/COR		CCS	CNTR		# CHECK FOR SWITCHOVER/CG.CORRECTION
		TCF	+4		#	NOT YET
		TCF	SWTCHOVR	#	NOW
		TCF	REPCHEK		#	PRIOR SWITCHOVER (OR NONE)
		TCF	SWTCHOVR	#	NOW (1/2 SEC SWITCHOVER, ONLY)
		
	+4	TS	CNTRTMP		# COUNT DOWN
		CAF	SEVEN		# SETUP TVCEXPHS FOR ENTRY AT CNTRCOPY
		TS	TVCEXPHS
# Page 910
		TCF	CNTRCOPY
		
REPCHEK		CAE	REPFRAC		# CHECK FOR REPETITIVE UPDATES
		EXTEND
		BZMF	+5		#	NO  (NEG OR +-ZERO)
		TS	TEMPDAP +1	#	YES, SET UP CORRECTION FUNCTION
		CAF	FIVE		# 		ADVANCE TVCEXPHS
		TS	TVCEXPHS
		TCF	CORSETUP
		
	+5	CAF	EIGHT
		TS	TVCEXPHS
		TCF	STRKUP
		
SWTCHOVR	CAF	BIT13		# CHECK ENGINE-ON BIT, NOT PERMITTING
		EXTEND			#	SWITCHOVER DURING ENGINE-SHUTDOWN
		RAND	DSALMOUT	#	TAILOFF
		CCS	A
		TCF	+2		# OK TO SWITCHOVER
		TCF	TVCEXFIN	# DON'T SWITCHOVER, TERMINATE
		
		CS	FLAGWRD9	# SET SWITCHOVER FLAG (SWTOVER) FOR DWNLNK
		MASK	BIT15		#	AND POST-BURN TRIM UPDATES (SEE
		ADS	FLAGWRD9	#	"BESTTRIM" (P40-P47))
		
		CAE	DAPDATR1	# SWITCHOVER.... CHECK FOR LEM-OFF/ON
		MASK	BIT13		# (NOTE, SHOWS LEM-OFF)
		EXTEND
		BZF	GAINDOWN	# LEM-ON....FULL SWITCHOVER/CG.CORRECTION
		
		CAF	FOUR		# LEM-OFF....NO SWITCHOVER, JUST CG.CORR
		TS	TVCEXPHS
		TCF	TEMPSET
		
GAINDOWN	CAE	ETVCDT/2	# LEM-ON.... DROP GAIN BY (OLDTVCDT/8CS)SQ
		EXTEND
		MP	BIT5
		LXCH	A
		EXTEND
		MP	A
		LXCH	A		# (TVCDT/8CS)SQD, SC.AT 8+2
		
		EXTEND			# PREPARE NEW GAIN CONSTANT
		MP	KTLX/I
		DDOUBL
		DDOUBL
		TS	TKTLX/I		# (FOR COPYCYCLE)
		
SWTCOPY		INCR	TVCEXPHS	# RESTART-PROTECT THE COPYCYCLE		(3)
# Page 911
		CAF	OCT37774	# LEM-ON ONLY..... T5 TIMER
		TS	T5TVCDT
		
		CAE	EKPRIME +1	# PREPARE KPRIMEDT FOR 80MS DAP, USING
		DOUBLE
		DOUBLE
		TS	KPRIMEDT	#	(KPRIMEDT+1 IS ZERO)
		
					# SCALING OF OMEGAC HAS CHANGED, BUT NO
					#	CHANGE OF REGISTERS.  RATE COMMANDS
					#	ARE LOW BY (OLD TVCDT)/80, UNTIL
					#	NEXT S40.6 COMPUTATION, WHICH USES
					#	THE NEW  KPRIMEDT.
					
		CAE	TKTLX/I		# GAIN CONSTANT
		TS	KTLX/I
		
		TC	S40.15 +7	# UPDATE VARK (ONLY, NO CHANGE 1/CONACC)
		
STRKCALL	CCS	STROKER		# CHECK STROKER FOR VERB 68 INDICATION
		TCF	+5		#	STROKE TEST IN PROGRESS (80MS DAP)
		TCF	+4		#	+0 SAYS NO VERB 68 YET
		TCF	+3		# 	STROKE TEST IN PROGRESS (80MS DAP)
		CAF	EIGHT		#	-0 SAYS PRIOR VERB68, SO START
		TS	STRKTIME	#		STROKE TEST IN 4 SECONDS
		
	+543	INCR	TVCEXPHS	# COPYCYCLE OVER (SWITCHOVR ENTRY NEXT)	(4)
	
TEMPSET		CAE	ECORFRAC	# 	SET UP CORRECTION FRACTION
		TS	TEMPDAP +1
		
		INCR	TVCEXPHS	# ENTRY FROM REPCHECK AT NEXT LOCATION	(5)
		
CORSETUP	CAE	DAPDATR1	# CHECK FOR LEM-OFF/ON
		MASK	BIT13		# (NOTE, SHOWS LEM-OFF)
		EXTEND
		BZF	+2		# LEM IS ON,  PICK UP   TEMPDAP+1
		CAE	TEMPDAP +1	# LEM IS OFF, PICK UP 2(TEMPDAP+1)
		AD	TEMPDAP +1
		TS	TEMPDAP		# CG.CORR USES TEMPDAP
		
		CAF	NEGONE		# SET UP FOR CNTR = -1 (SWTCHOVR DONE)
		TS	CNTRTMP		#	(COPYCYCLE AT "CNTRCOPY")
		
CG.CORR		EXTEND			# PITCH TRIM-TRACKER CORRECTION
		DCA	PDELOFF
		DXCH	PACTTMP
		CS	PACTOFF
		AD	DELPBAR
		EXTEND
# Page 912
		MP	TEMPDAP
		DDOUBL
		DDOUBL
		DAS	PACTTMP
		
		EXTEND
		DCA	YDELOFF
		DXCH	YACTTMP
		CS	YACTOFF
		AD	DELYBAR
		EXTEND
		MP	TEMPDAP
		DDOUBL
		DDOUBL
		DAS	YACTTMP
		
CORCOPY		INCR	TVCEXPHS	# RESTART-PROTECT THE COPYCYCLE		(6)

		EXTEND			# TRIM-ESTIMATES, AND
		DCA	PACTTMP
		TS	PACTOFF		#	TRIMS
		DXCH	PDELOFF
		
		EXTEND
		DCA	YACTTMP
		TS	YACTOFF
		DXCH	YDELOFF
		
		INCR	TVCEXPHS	# COPYCYCLE OVER (SWT/COR ENTRY NEXT)	(7)
		
CNTRCOPY	CAE	CNTRTMP		# UPDATE CNTR (RESTARTS OK, FOLLOWS CPYCY)
		TS	CNTR
		
		INCR	TVCEXPHS	# ENTRY FROM REPCHECK AT NEXT LOCATION	(8)
		
STRKUP		CCS	STRKTIME	# CHECK STROKE TEST START TIME
		TCF	+3		#	IN 4SEC DELAY AFTER SWITCHOVER
		TCF	STRKNOW		#	START STROKE TEST NOW....
		TCF	TVCEXFIN	# 	NO STROKE TEST REQUEST YET
		
		TS	STRKTTMP	# COUNT DOWN
		TCF	STRKTCPY
		
STRKNOW		CAE	ESTROKER	# START THE STROKE TEST NOW....
		TS	STROKER
		CAF	NEGONE		# KILL THE STROKE TEST CALL
		TS	STRKTTMP
		
STRKTCPY	INCR	TVCEXPHS	# RESTART-PROTECT THE COPYCYCLE		(9)
# Page 913
		CAE	STRKTTMP
		TS	STRKTIME
		
TVCEXFIN	CAF	ZERO		# RESET TVCEXPHS
		TS	TVCEXPHS
		
		TCF	TASKOVER	# OVER AND OUT
		
# Page 914
# NAME 		S40.15 INERTIA COMPUTATIONS
		
		EBANK=	1/CONACC
		
S40.15		CAE	IXX		# COMPUTE 1/CONACC (RACC)....IXX SC.AT
		EXTEND			#	B+20	KG M SQD
		MP	2PI/M		# 2PI/M, SC.AT 1/(B+8 N M)
		DDOUBL
		DDOUBL
		DDOUBL
		TS	1/CONACC	# SC.AT B+9 SEC SQD / REV
		
	+7	CAE	KTLX/I		# COMPUTE VARK, SCALING IN THE KTLX/I FOR
		EXTEND			# 	LM-OFF,ON.  ENTRY FROM SWITCHOVER
		MP	IAVG/TLX	#	SCALED AT B+2 SECONDS-SQUARED
		DDOUBL			#	SCALING
		DDOUBL
		DDOUBL
		TS	VARK		#	LEM-OFF KPGEN3(0) OR LEM-ON VARK(0)
		
		TC	Q
		
2PI/M		DEC	.00331017 B+8	# 2PI/M, SC.AT 1/(B+8 N M)


