// -*- C++ -*- generated by wxGlade 0.6.3 on Wed Apr  8 12:58:54 2009
/*
  Copyright 2009 Ronald S. Burkey <info@sandroid.org>
  
  This file is part of yaAGC. 

  yaAGC is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  yaAGC is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with yaAGC; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	jWiz.cpp
  Purpose:	Helps users to configure joystick parameters.
  Reference:	http://www.ibiblio.org/apollo/index.html
  Mode:		2009-04-08 RSB	Began.
  		2009-04-11 RSB	On Mac OS, disabled yaACA2, since I can't
				get it to work.  Made other Mac tweaks
				to get the visual appearance right.  Also
				on Mac, replaced all use of xterm by 
				Terminator.  
*/

#include "jWiz.h"

#include <wx/textfile.h>
#include <math.h>

// This program is designed to be run from the Resources subdirectory of the
// installation directory.
#if defined (WIN32)
//#include <wx/file.h>
//#include <wx/filefn.h>
#define EXE_DIR "..\\bin\\"
#define EXE_DIR2 "..\\bin\\"
#elif defined (__APPLE__)
#define EXE_DIR "../MacOS/"
#define EXE_DIR2 "../MacOS/yaACA2.app/Contents/MacOS/"
#else
#define EXE_DIR "../bin/"
#define EXE_DIR2 "../bin/"
#endif


// begin wxGlade: ::extracode
// end wxGlade



MainFrameClass::MainFrameClass(wxWindow* parent, int id, const wxString& title, const wxPoint& pos, const wxSize& size, long style):
    wxFrame(parent, id, title, pos, size, wxDEFAULT_FRAME_STYLE)
{
    // begin wxGlade: MainFrameClass::MainFrameClass
    panel_3 = new wxPanel(this, wxID_ANY);
    panel_1_copy_copy_copy_1_copy = new wxPanel(panel_3, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER|wxTAB_TRAVERSAL);
    Panel2 = new wxPanel(this, wxID_ANY);
    panel_1_copy_copy_copy_1_copy_copy_copy = new wxPanel(Panel2, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER|wxTAB_TRAVERSAL);
    Panel3 = new wxPanel(this, wxID_ANY);
    panel_1_copy_copy_copy_copy = new wxPanel(Panel3, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER|wxTAB_TRAVERSAL);
    panel_1 = new wxPanel(this, wxID_ANY);
    sizer_7_copy_3_staticbox = new wxStaticBox(panel_1, -1, wxT("Roll Settings"));
    sizer_7_copy_copy_staticbox = new wxStaticBox(panel_1, -1, wxT("Pitch Settings"));
    sizer_7_copy_1_copy_staticbox = new wxStaticBox(panel_1, -1, wxT("Yaw Settings"));
    sizer_3_copy_copy_staticbox = new wxStaticBox(panel_1, -1, wxT("Configure Default Joystick Handler (yaACA3)"));
    sizer_7_copy_2_copy_2_staticbox = new wxStaticBox(Panel3, -1, wxT("Roll Settings"));
    sizer_7_copy_2_copy_copy_staticbox = new wxStaticBox(Panel3, -1, wxT("Pitch Settings"));
    sizer_7_copy_2_copy_1_copy_staticbox = new wxStaticBox(Panel3, -1, wxT("Yaw Settings"));
    sizer_4_copy_copy_staticbox = new wxStaticBox(Panel3, -1, wxT("Configure Last-Resort Joystick Handler (yaACA)"));
    sizer_9_copy_staticbox = new wxStaticBox(Panel2, -1, wxT("Configure Alternative Joystick Handler (yaACA2)"));
    panel_1_copy_copy_copy_2 = new wxPanel(panel_1, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxSIMPLE_BORDER|wxTAB_TRAVERSAL);
    Label1a_copy = new wxStaticText(panel_1_copy_copy_copy_2, wxID_ANY, wxT("Step\n#1"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    Label1b_copy = new wxStaticText(panel_1, wxID_ANY, wxT("Always try this first!\nRepeat as necessary."));
    Checkmark3 = new wxStaticBitmap(panel_1, wxID_ANY, wxBitmap(wxT("Check.jpg"), wxBITMAP_TYPE_ANY));
    label_1_copy_2 = new wxStaticText(panel_1, wxID_ANY, wxT("Axis:"));
    Roll3Axis = new wxSpinCtrl(panel_1, ID_ROLL3AXIS, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 9);
    const wxString Roll3Sense_choices[] = {
        wxT("Positive"),
        wxT("Negative")
    };
    Roll3Sense = new wxRadioBox(panel_1, ID_ROLL3SENSE, wxT("Sense"), wxDefaultPosition, wxDefaultSize, 2, Roll3Sense_choices, 0, wxRA_SPECIFY_ROWS);
    label_1_copy_copy = new wxStaticText(panel_1, wxID_ANY, wxT("Axis:"));
    Pitch3Axis = new wxSpinCtrl(panel_1, ID_PITCH3AXIS, wxT("1"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 9);
    const wxString Pitch3Sense_choices[] = {
        wxT("Positive"),
        wxT("Negative")
    };
    Pitch3Sense = new wxRadioBox(panel_1, ID_PITCH3SENSE, wxT("Sense"), wxDefaultPosition, wxDefaultSize, 2, Pitch3Sense_choices, 0, wxRA_SPECIFY_ROWS);
    label_1_copy_1_copy = new wxStaticText(panel_1, wxID_ANY, wxT("Axis:"));
    Yaw3Axis = new wxSpinCtrl(panel_1, ID_YAW3AXIS, wxT("2"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 9);
    const wxString Yaw3Sense_choices[] = {
        wxT("Positive"),
        wxT("Negative")
    };
    Yaw3Sense = new wxRadioBox(panel_1, ID_YAW3SENSE, wxT("Sense"), wxDefaultPosition, wxDefaultSize, 2, Yaw3Sense_choices, 0, wxRA_SPECIFY_ROWS);
    Default3Button = new wxButton(panel_1, ID_DEFAULT3BUTTON, wxT("Default"));
    Test3Button = new wxButton(panel_1, ID_TEST3BUTTON, wxT("Test"));
    Set3Button = new wxButton(panel_1, ID_SET3BUTTON, wxT("Set"));
    Label2a = new wxStaticText(panel_1_copy_copy_copy_copy, wxID_ANY, wxT("Step\n#3"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    Label2b = new wxStaticText(Panel3, wxID_ANY, wxT("Try this only when steps #1-2 fail!\nRepeat as necessary."));
    Checkmark1 = new wxStaticBitmap(Panel3, wxID_ANY, wxBitmap(wxT("Check.jpg"), wxBITMAP_TYPE_ANY));
    RollStickLabel_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Stick:"));
    RollStick = new wxSpinCtrl(Panel3, ID_ROLLSTICK, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 9);
    RollAxisLabel_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Axis: "));
    RollAxis = new wxSpinCtrl(Panel3, ID_ROLLAXIS, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 1);
    label_1_copy_2_copy_copy_copy_2 = new wxStaticText(Panel3, wxID_ANY, wxT("Scale:"));
    RollFactor = new wxSpinCtrl(Panel3, ID_ROLLFACTOR, wxT("100"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, -300, 300);
    label_1_copy_2_copy_copy_1_copy_2 = new wxStaticText(Panel3, wxID_ANY, wxT("Offset:"));
    RollOffset = new wxSpinCtrl(Panel3, ID_ROLLOFFSET, wxT("0"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, -255, 255);
    label_1_copy_2_copy_1_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Stick:"));
    PitchStick = new wxSpinCtrl(Panel3, ID_PITCHSTICK, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 9);
    label_1_copy_2_copy_copy_2_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Axis: "));
    PitchAxis = new wxSpinCtrl(Panel3, ID_PITCHAXIS, wxT("1"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 1);
    label_1_copy_2_copy_copy_copy_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Scale:"));
    PitchFactor = new wxSpinCtrl(Panel3, ID_PITCHFACTOR, wxT("100"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, -300, 300);
    label_1_copy_2_copy_copy_1_copy_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Offset:"));
    PitchOffset = new wxSpinCtrl(Panel3, ID_PITCHOFFSET, wxT("0"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, -255, 255);
    label_1_copy_2_copy_2_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Stick:"));
    YawStick = new wxSpinCtrl(Panel3, ID_YAWSTICK, wxT("1"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 9);
    label_1_copy_2_copy_copy_3_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Axis: "));
    YawAxis = new wxSpinCtrl(Panel3, ID_YAWAXIS, wxT(""), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 1);
    label_1_copy_2_copy_copy_copy_1_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Scale:"));
    YawFactor = new wxSpinCtrl(Panel3, ID_YAWFACTOR, wxT("-100"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, -300, 300);
    label_1_copy_2_copy_copy_1_copy_1_copy = new wxStaticText(Panel3, wxID_ANY, wxT("Offset:"));
    YawOffset = new wxSpinCtrl(Panel3, ID_YAWOFFSET, wxT("0"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, -255, 255);
    DefaultButton = new wxButton(Panel3, ID_DEFAULTBUTTON, wxT("Default"));
    TestButton = new wxButton(Panel3, ID_TESTBUTTON, wxT("Test/Set"));
    Label3a_copy_copy_copy = new wxStaticText(panel_1_copy_copy_copy_1_copy_copy_copy, wxID_ANY, wxT("Step\n#2"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    Label3b_copy_copy_copy = new wxStaticText(Panel2, wxID_ANY, wxT("Try this only when step #1 fails!"));
    Checkmark2 = new wxStaticBitmap(Panel2, wxID_ANY, wxBitmap(wxT("Check.jpg"), wxBITMAP_TYPE_ANY));
    Test2Button = new wxButton(Panel2, ID_TEST2BUTTON, wxT("Test/Set"));
    Label3a_copy = new wxStaticText(panel_1_copy_copy_copy_1_copy, wxID_ANY, wxT("Step\n#4"), wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE);
    Label3b_copy = new wxStaticText(panel_3, wxID_ANY, wxT("Finish up!"));
    FinishButton = new wxButton(panel_3, ID_FINISHBUTTON, wxT("Finish"));

    set_properties();
    do_layout();
    // end wxGlade
    
    Set3Button->Disable ();
    GetParameters3 (0);
    GetParameters (0);
    Checkmark1->Hide ();
    Checkmark2->Hide ();
    Checkmark3->Hide ();
    if (wxFileExists (wxT ("yaACA2-0.cfg")))
      Checkmark2->Show ();
    else if (wxFileExists (wxT ("yaACA-0.cfg")))
      Checkmark1->Show ();
    else
      Checkmark3->Show ();
    
#if defined (WIN32) || defined (__FreeBSD__)
    // I can't get yaACA to work right in Windows.
    Panel3->Disable ();
#endif    
#if defined (__APPLE__) || defined (__FreeBSD__)
    // I can't get yaACA2 to work right in Mac OS X 10.5.  (Haven't tried it in 10.4.)
    Panel2->Disable ();
#endif    
}


BEGIN_EVENT_TABLE(MainFrameClass, wxFrame)
    // begin wxGlade: MainFrameClass::event_table
    EVT_SPINCTRL(ID_ROLL3AXIS, MainFrameClass::Roll3AxisEvent)
    EVT_RADIOBOX(ID_ROLL3SENSE, MainFrameClass::Roll3SenseEvent)
    EVT_SPINCTRL(ID_PITCH3AXIS, MainFrameClass::Pitch3AxisEvent)
    EVT_RADIOBOX(ID_PITCH3SENSE, MainFrameClass::Pitch3SenseEvent)
    EVT_SPINCTRL(ID_YAW3AXIS, MainFrameClass::Yaw3AxisEvent)
    EVT_RADIOBOX(ID_YAW3SENSE, MainFrameClass::Yaw3SenseEvent)
    EVT_BUTTON(ID_DEFAULT3BUTTON, MainFrameClass::Default3Clicked)
    EVT_BUTTON(ID_TEST3BUTTON, MainFrameClass::Test3Clicked)
    EVT_BUTTON(ID_SET3BUTTON, MainFrameClass::Set3Clicked)
    EVT_SPINCTRL(ID_ROLLSTICK, MainFrameClass::RollStickEvent)
    EVT_SPINCTRL(ID_ROLLAXIS, MainFrameClass::RollAxisEvent)
    EVT_SPINCTRL(ID_ROLLFACTOR, MainFrameClass::RollFactorEvent)
    EVT_SPINCTRL(ID_ROLLOFFSET, MainFrameClass::RollOffsetEvent)
    EVT_SPINCTRL(ID_PITCHSTICK, MainFrameClass::PitchStickEvent)
    EVT_SPINCTRL(ID_PITCHAXIS, MainFrameClass::PitchAxisEvent)
    EVT_SPINCTRL(ID_PITCHFACTOR, MainFrameClass::PitchFactorEvent)
    EVT_SPINCTRL(ID_PITCHOFFSET, MainFrameClass::PitchOffsetEvent)
    EVT_SPINCTRL(ID_YAWSTICK, MainFrameClass::YawStickEvent)
    EVT_SPINCTRL(ID_YAWAXIS, MainFrameClass::YawAxisEvent)
    EVT_SPINCTRL(ID_YAWFACTOR, MainFrameClass::YawFactorEvent)
    EVT_SPINCTRL(ID_YAWOFFSET, MainFrameClass::YawOffsetEvent)
    EVT_BUTTON(ID_DEFAULTBUTTON, MainFrameClass::DefaultClicked)
    EVT_BUTTON(ID_TESTBUTTON, MainFrameClass::TestClicked)
    EVT_BUTTON(ID_TEST2BUTTON, MainFrameClass::Test2Clicked)
    EVT_BUTTON(ID_FINISHBUTTON, MainFrameClass::FinishClicked)
    // end wxGlade
END_EVENT_TABLE();


void MainFrameClass::Test2Clicked(wxCommandEvent &event)
{
  wxString Dummy;
  Dummy = wxT (EXE_DIR2);
  Dummy += wxT ("yaACA2");
  Hide ();
  wxExecute (Dummy, wxEXEC_SYNC);
  Checkmark1->Hide ();
  Checkmark2->Show ();
  Checkmark3->Hide ();
  InvalidateBestSize ();
  Layout ();
  Fit ();
  Refresh ();
  Update ();
  Show ();
  Raise ();
  wxRemoveFile (wxT ("yaACA-0.cfg"));
}


void MainFrameClass::Test3Clicked(wxCommandEvent &event)
{
  int Axis;
  char Sense;
  wxString Dummy;
  Dummy = wxT (EXE_DIR);
  Dummy += wxT ("yaACA3");
  Axis = Roll3Axis->GetValue ();
  if (Roll3Sense->GetSelection ())
    Sense = '-';
  else
    Sense = '+';
  Dummy += wxString::Format (wxT (" --roll=%c%d"), Sense, Axis);
  Axis = Pitch3Axis->GetValue ();
  if (Pitch3Sense->GetSelection ())
    Sense = '-';
  else
    Sense = '+';
  Dummy += wxString::Format (wxT (" --pitch=%c%d"), Sense, Axis);
  Axis = Yaw3Axis->GetValue ();
  if (Yaw3Sense->GetSelection ())
    Sense = '-';
  else
    Sense = '+';
  Dummy += wxString::Format (wxT (" --yaw=%c%d"), Sense, Axis);
#if defined (WIN32)
  Dummy = wxT ("cmd /C start /WAIT ") + Dummy;
#elif defined (__APPLE__)
  wxString Prefix;
  Prefix = wxT ("../MacOS/Terminator.app/Contents/MacOS/Terminator --working-directory ");
  Prefix += wxGetCwd ();
  Prefix += wxT (" ");
  Dummy = Prefix + Dummy;
#else
  Dummy = wxT ("xterm -e ") + Dummy;
#endif
  //wxMessageBox (Dummy);
  Hide ();
  wxExecute (Dummy, wxEXEC_SYNC);
  Show ();
  //wxMessageBox (Dummy);
  Set3Button->Enable ();
}


void MainFrameClass::Set3Clicked(wxCommandEvent &event)
{
  wxRemoveFile (wxT ("yaACA-0.cfg"));
  wxRemoveFile (wxT ("yaACA2-0.cfg"));
  //Hide ();
  Checkmark1->Hide ();
  Checkmark2->Hide ();
  Checkmark3->Show ();
  InvalidateBestSize ();
  Layout ();
  Fit ();
  Refresh ();
  Update ();
  //Show ();
}


void MainFrameClass::TestClicked(wxCommandEvent &event)
{
  int Stick, Axis, Factor, Offset;
  wxString Dummy;
  Dummy = wxT (EXE_DIR);
#ifdef WIN32  
  Dummy += wxT ("yaACA-cfg");
#else
  Dummy += wxT ("yaACA");
#endif  
  Stick = RollStick->GetValue ();
  Axis = RollAxis->GetValue ();
  Factor = RollFactor->GetValue ();
  Offset = RollOffset->GetValue ();
  Dummy += wxString::Format (wxT (" --roll=0,%d,%d,%f,%d"), Stick, Axis, Factor / 100.0, Offset);
  Stick = PitchStick->GetValue ();
  Axis = PitchAxis->GetValue ();
  Factor = PitchFactor->GetValue ();
  Offset = PitchOffset->GetValue ();
  Dummy += wxString::Format (wxT (" --pitch=0,%d,%d,%f,%d"), Stick, Axis, Factor / 100.0, Offset);
  Stick = YawStick->GetValue ();
  Axis = YawAxis->GetValue ();
  Factor = YawFactor->GetValue ();
  Offset = YawOffset->GetValue ();
  Dummy += wxString::Format (wxT (" --yaw=0,%d,%d,%f,%d"), Stick, Axis, Factor / 100.0, Offset);
#if defined (WIN32)
  Dummy = wxT ("cmd /C start /WAIT ") + Dummy;
#elif defined (__APPLE__)
  wxString Prefix;
  Prefix = wxT ("../MacOS/Terminator.app/Contents/MacOS/Terminator --working-directory ");
  Prefix += wxGetCwd ();
  Prefix += wxT (" ");
  Dummy = Prefix + Dummy;
#else
  Dummy = wxT ("xterm -e ") + Dummy;
#endif
  //wxMessageBox (Dummy);
  Hide ();
  wxExecute (Dummy, wxEXEC_SYNC);
  Checkmark1->Show ();
  Checkmark2->Hide ();
  Checkmark3->Hide ();
  InvalidateBestSize ();
  Layout ();
  Fit ();
  Refresh ();
  Update ();
  Show ();
  Raise ();
  //wxMessageBox (Dummy);
  wxRemoveFile (wxT ("yaACA2-0.cfg"));
}


void MainFrameClass::FinishClicked(wxCommandEvent &event)
{
  Close ();
}


void MainFrameClass::DefaultClicked(wxCommandEvent &event)
{
  DefaultParameters ();
}


void MainFrameClass::Default3Clicked(wxCommandEvent &event)
{
  DefaultParameters3 ();
}


void MainFrameClass::Roll3AxisEvent(wxSpinEvent &event)
{
    Set3Button->Disable ();
}


void MainFrameClass::Roll3SenseEvent(wxCommandEvent &event)
{
    Set3Button->Disable ();
}


void MainFrameClass::Pitch3AxisEvent(wxSpinEvent &event)
{
    Set3Button->Disable ();
}


void MainFrameClass::Pitch3SenseEvent(wxCommandEvent &event)
{
    Set3Button->Disable ();
}


void MainFrameClass::Yaw3AxisEvent(wxSpinEvent &event)
{
    Set3Button->Disable ();
}


void MainFrameClass::Yaw3SenseEvent(wxCommandEvent &event)
{
    Set3Button->Disable ();
}


void MainFrameClass::RollStickEvent(wxSpinEvent &event)
{
}


void MainFrameClass::RollAxisEvent(wxSpinEvent &event)
{
}


void MainFrameClass::RollFactorEvent(wxSpinEvent &event)
{
}


void MainFrameClass::RollOffsetEvent(wxSpinEvent &event)
{
}


void MainFrameClass::PitchStickEvent(wxSpinEvent &event)
{
}


void MainFrameClass::PitchAxisEvent(wxSpinEvent &event)
{
}


void MainFrameClass::PitchFactorEvent(wxSpinEvent &event)
{
}


void MainFrameClass::PitchOffsetEvent(wxSpinEvent &event)
{
}


void MainFrameClass::YawStickEvent(wxSpinEvent &event)
{
}


void MainFrameClass::YawAxisEvent(wxSpinEvent &event)
{
}


void MainFrameClass::YawFactorEvent(wxSpinEvent &event)
{
}


void MainFrameClass::YawOffsetEvent(wxSpinEvent &event)
{
}


// wxGlade: add MainFrameClass event handlers


void MainFrameClass::set_properties()
{
    // begin wxGlade: MainFrameClass::set_properties
    SetTitle(wxT("Virtual AGC Joystick Configurator Helper"));
    SetBackgroundColour(wxColour(255, 255, 255));
    Label1a_copy->SetMinSize(wxSize(60, 60));
    Label1a_copy->SetFont(wxFont(16, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Label1b_copy->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Roll3Axis->SetMinSize(wxSize(50, 25));
    Roll3Axis->SetToolTip(wxT("Select which joystick physical axis corresponds to \"Roll\"."));
    Roll3Sense->SetToolTip(wxT("Determine +/- sense of the joystick."));
    Roll3Sense->SetSelection(0);
    Pitch3Axis->SetMinSize(wxSize(50, 25));
    Pitch3Axis->SetToolTip(wxT("Select which joystick physical axis corresponds to \"Pitch\"."));
    Pitch3Sense->SetToolTip(wxT("Determine +/- sense of the joystick."));
    Pitch3Sense->SetSelection(0);
    Yaw3Axis->SetMinSize(wxSize(50, 25));
    Yaw3Axis->SetToolTip(wxT("Select which joystick physical axis corresponds to \"Yaw\"."));
    Yaw3Sense->SetToolTip(wxT("Determine +/- sense of the joystick."));
    Yaw3Sense->SetSelection(1);
    Default3Button->SetToolTip(wxT("Return to default settings.  Must click \"Set\" to actually use these settings."));
    Test3Button->SetToolTip(wxT("Test the yaACA3 configuration.  Must click \"Set\" to actually use these settings."));
    Set3Button->SetToolTip(wxT("Set yaACA3, with the settings shown, as the joystick handler for Virtual AGC."));
    Label2a->SetMinSize(wxSize(60, 60));
    Label2a->SetFont(wxFont(16, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Label2b->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    RollStick->SetMinSize(wxSize(75, 25));
    RollStick->SetToolTip(wxT("Select which joystick \"stick\" corresponds to \"Roll\"."));
    RollAxis->SetMinSize(wxSize(75, 25));
    RollAxis->SetToolTip(wxT("Select which joystick \"axis\" corresponds to \"Roll\"."));
    RollFactor->SetMinSize(wxSize(75, 25));
    RollFactor->SetToolTip(wxT("Select a numerical multiplier (in hundredths) which should be applied to the \"Roll\" reading."));
    RollOffset->SetMinSize(wxSize(75, 25));
    RollOffset->SetToolTip(wxT("Select an offset value which should be added to the \"Roll\" reading."));
    PitchStick->SetMinSize(wxSize(75, 25));
    PitchStick->SetToolTip(wxT("Select which joystick \"stick\" corresponds to \"Pitch\"."));
    PitchAxis->SetMinSize(wxSize(75, 25));
    PitchAxis->SetToolTip(wxT("Select which joystick \"axis\" corresponds to \"Pitch\"."));
    PitchFactor->SetMinSize(wxSize(75, 25));
    PitchFactor->SetToolTip(wxT("Select a numerical multiplier (in hundredths) which should be applied to the \"Pitch\" reading."));
    PitchOffset->SetMinSize(wxSize(75, 25));
    PitchOffset->SetToolTip(wxT("Select an offset value which should be added to the \"Pitch\" reading."));
    YawStick->SetMinSize(wxSize(75, 25));
    YawStick->SetToolTip(wxT("Select which joystick \"stick\" corresponds to \"Yaw\"."));
    YawAxis->SetMinSize(wxSize(75, 25));
    YawAxis->SetToolTip(wxT("Select which joystick \"axis\" corresponds to \"Yaw\"."));
    YawFactor->SetMinSize(wxSize(75, 25));
    YawFactor->SetToolTip(wxT("Select a numerical multiplier (in hundredths) which should be applied to the \"Yaw\" reading."));
    YawOffset->SetMinSize(wxSize(75, 25));
    YawOffset->SetToolTip(wxT("Select an offset value which should be added to the \"Yaw\" reading."));
    DefaultButton->SetToolTip(wxT("Return to default settings.  Must click \"Test/Set\" to actually use these settings."));
    TestButton->SetToolTip(wxT("Test AND set the yaACA configuration parameters shown."));
    Label3a_copy_copy_copy->SetMinSize(wxSize(60, 60));
    Label3a_copy_copy_copy->SetFont(wxFont(16, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Label3b_copy_copy_copy->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Label3a_copy->SetMinSize(wxSize(60, 60));
    Label3a_copy->SetFont(wxFont(16, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    Label3b_copy->SetFont(wxFont(10, wxDEFAULT, wxNORMAL, wxBOLD, 0, wxT("")));
    // end wxGlade
}


void MainFrameClass::do_layout()
{
    // begin wxGlade: MainFrameClass::do_layout
    wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    wxFlexGridSizer* grid_sizer_1 = new wxFlexGridSizer(5, 5, 0, 0);
    wxBoxSizer* sizer_14 = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer* sizer_12_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_10_copy_copy_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_14_copy = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_9_copy = new wxStaticBoxSizer(sizer_9_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_12_copy_1_copy_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_10_copy_copy_copy_1_copy_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_14_copy_2 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_4_copy_copy = new wxStaticBoxSizer(sizer_4_copy_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_5_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_6_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7_copy_2_copy_1_copy = new wxStaticBoxSizer(sizer_7_copy_2_copy_1_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_1_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_3_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_2_copy = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7_copy_2_copy_copy = new wxStaticBoxSizer(sizer_7_copy_2_copy_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_1_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_2_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7_copy_2_copy_2 = new wxStaticBoxSizer(sizer_7_copy_2_copy_2_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_1_copy_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_copy_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_copy_4 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_8_copy_2_copy_3 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_12_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_10_copy_copy_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_14_copy_1 = new wxBoxSizer(wxVERTICAL);
    wxStaticBoxSizer* sizer_3_copy_copy = new wxStaticBoxSizer(sizer_3_copy_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_5_copy_1 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_6_copy_1 = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7_copy_1_copy = new wxStaticBoxSizer(sizer_7_copy_1_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8_copy_1_copy = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7_copy_copy = new wxStaticBoxSizer(sizer_7_copy_copy_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8_copy_copy = new wxBoxSizer(wxHORIZONTAL);
    wxStaticBoxSizer* sizer_7_copy_3 = new wxStaticBoxSizer(sizer_7_copy_3_staticbox, wxVERTICAL);
    wxBoxSizer* sizer_8_copy_3 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_12_copy_2 = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer* sizer_10_copy_copy_copy_2 = new wxBoxSizer(wxHORIZONTAL);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    sizer_10_copy_copy_copy_2->Add(Label1a_copy, 0, 0, 0);
    panel_1_copy_copy_copy_2->SetSizer(sizer_10_copy_copy_copy_2);
    sizer_12_copy_2->Add(panel_1_copy_copy_copy_2, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_2->Add(20, 20, 0, 0, 0);
    sizer_12_copy_2->Add(Label1b_copy, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_2->Add(2, 20, 1, wxEXPAND, 0);
    sizer_12_copy_2->Add(Checkmark3, 0, 0, 0);
    sizer_14_copy_1->Add(sizer_12_copy_2, 0, wxEXPAND, 0);
    sizer_14_copy_1->Add(20, 10, 0, 0, 0);
    sizer_3_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_6_copy_1->Add(5, 20, 0, 0, 0);
    sizer_7_copy_3->Add(20, 20, 0, 0, 0);
    sizer_8_copy_3->Add(20, 20, 1, 0, 0);
    sizer_8_copy_3->Add(label_1_copy_2, 0, 0, 0);
    sizer_8_copy_3->Add(Roll3Axis, 0, 0, 0);
    sizer_8_copy_3->Add(20, 20, 1, 0, 0);
    sizer_7_copy_3->Add(sizer_8_copy_3, 0, wxEXPAND, 0);
    sizer_7_copy_3->Add(20, 20, 0, 0, 0);
    sizer_7_copy_3->Add(Roll3Sense, 0, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_7_copy_3->Add(20, 20, 0, 0, 0);
    sizer_6_copy_1->Add(sizer_7_copy_3, 1, wxEXPAND, 0);
    sizer_6_copy_1->Add(5, 20, 0, 0, 0);
    sizer_7_copy_copy->Add(20, 20, 0, 0, 0);
    sizer_8_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_copy->Add(label_1_copy_copy, 0, 0, 0);
    sizer_8_copy_copy->Add(Pitch3Axis, 0, 0, 0);
    sizer_8_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_copy->Add(sizer_8_copy_copy, 0, wxEXPAND, 0);
    sizer_7_copy_copy->Add(20, 20, 0, 0, 0);
    sizer_7_copy_copy->Add(Pitch3Sense, 0, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_7_copy_copy->Add(20, 20, 0, 0, 0);
    sizer_6_copy_1->Add(sizer_7_copy_copy, 1, wxEXPAND, 0);
    sizer_6_copy_1->Add(5, 20, 0, 0, 0);
    sizer_7_copy_1_copy->Add(20, 20, 0, 0, 0);
    sizer_8_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_1_copy->Add(label_1_copy_1_copy, 0, 0, 0);
    sizer_8_copy_1_copy->Add(Yaw3Axis, 0, 0, 0);
    sizer_8_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_1_copy->Add(sizer_8_copy_1_copy, 0, wxEXPAND, 0);
    sizer_7_copy_1_copy->Add(20, 20, 0, 0, 0);
    sizer_7_copy_1_copy->Add(Yaw3Sense, 0, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_7_copy_1_copy->Add(20, 20, 0, 0, 0);
    sizer_6_copy_1->Add(sizer_7_copy_1_copy, 1, wxEXPAND, 0);
    sizer_6_copy_1->Add(5, 20, 0, 0, 0);
    sizer_3_copy_copy->Add(sizer_6_copy_1, 1, wxEXPAND, 0);
    sizer_3_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_5_copy_1->Add(20, 20, 1, 0, 0);
    sizer_5_copy_1->Add(Default3Button, 0, 0, 0);
    sizer_5_copy_1->Add(20, 20, 0, 0, 0);
    sizer_5_copy_1->Add(Test3Button, 0, 0, 0);
    sizer_5_copy_1->Add(20, 20, 0, 0, 0);
    sizer_5_copy_1->Add(Set3Button, 0, 0, 0);
    sizer_5_copy_1->Add(20, 20, 1, 0, 0);
    sizer_3_copy_copy->Add(sizer_5_copy_1, 0, wxEXPAND, 0);
    sizer_3_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_14_copy_1->Add(sizer_3_copy_copy, 1, wxEXPAND, 0);
    panel_1->SetSizer(sizer_14_copy_1);
    grid_sizer_1->Add(panel_1, 1, wxEXPAND, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    sizer_10_copy_copy_copy_copy->Add(Label2a, 0, 0, 0);
    panel_1_copy_copy_copy_copy->SetSizer(sizer_10_copy_copy_copy_copy);
    sizer_12_copy_copy->Add(panel_1_copy_copy_copy_copy, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_copy->Add(20, 20, 0, 0, 0);
    sizer_12_copy_copy->Add(Label2b, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_copy->Add(2, 20, 1, wxEXPAND, 0);
    sizer_12_copy_copy->Add(Checkmark1, 0, 0, 0);
    sizer_14_copy_2->Add(sizer_12_copy_copy, 0, wxEXPAND, 0);
    sizer_14_copy_2->Add(20, 10, 0, 0, 0);
    sizer_4_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_6_copy_copy->Add(5, 20, 0, 0, 0);
    sizer_7_copy_2_copy_2->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_3->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_3->Add(RollStickLabel_copy, 0, 0, 0);
    sizer_8_copy_2_copy_3->Add(RollStick, 0, 0, 0);
    sizer_8_copy_2_copy_3->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_2->Add(sizer_8_copy_2_copy_3, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_2->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_4->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_4->Add(RollAxisLabel_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_4->Add(RollAxis, 0, 0, 0);
    sizer_8_copy_2_copy_copy_4->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_2->Add(sizer_8_copy_2_copy_copy_4, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_2->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_2->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_copy_2->Add(label_1_copy_2_copy_copy_copy_2, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_2->Add(RollFactor, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_2->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_2->Add(sizer_8_copy_2_copy_copy_copy_2, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_2->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_2->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_2->Add(label_1_copy_2_copy_copy_1_copy_2, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_2->Add(RollOffset, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_2->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_2->Add(sizer_8_copy_2_copy_copy_1_copy_2, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_2->Add(20, 10, 0, 0, 0);
    sizer_6_copy_copy->Add(sizer_7_copy_2_copy_2, 1, wxEXPAND, 0);
    sizer_6_copy_copy->Add(5, 20, 0, 0, 0);
    sizer_7_copy_2_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_1_copy->Add(label_1_copy_2_copy_1_copy, 0, 0, 0);
    sizer_8_copy_2_copy_1_copy->Add(PitchStick, 0, 0, 0);
    sizer_8_copy_2_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_copy->Add(sizer_8_copy_2_copy_1_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_2_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_2_copy->Add(label_1_copy_2_copy_copy_2_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_2_copy->Add(PitchAxis, 0, 0, 0);
    sizer_8_copy_2_copy_copy_2_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_copy->Add(sizer_8_copy_2_copy_copy_2_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_copy_copy->Add(label_1_copy_2_copy_copy_copy_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_copy->Add(PitchFactor, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_copy->Add(sizer_8_copy_2_copy_copy_copy_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_copy->Add(label_1_copy_2_copy_copy_1_copy_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_copy->Add(PitchOffset, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_copy->Add(sizer_8_copy_2_copy_copy_1_copy_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_6_copy_copy->Add(sizer_7_copy_2_copy_copy, 1, wxEXPAND, 0);
    sizer_6_copy_copy->Add(5, 20, 0, 0, 0);
    sizer_7_copy_2_copy_1_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_2_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_2_copy->Add(label_1_copy_2_copy_2_copy, 0, 0, 0);
    sizer_8_copy_2_copy_2_copy->Add(YawStick, 0, 0, 0);
    sizer_8_copy_2_copy_2_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_1_copy->Add(sizer_8_copy_2_copy_2_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_1_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_3_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_3_copy->Add(label_1_copy_2_copy_copy_3_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_3_copy->Add(YawAxis, 0, 0, 0);
    sizer_8_copy_2_copy_copy_3_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_1_copy->Add(sizer_8_copy_2_copy_copy_3_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_1_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_copy_1_copy->Add(label_1_copy_2_copy_copy_copy_1_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_1_copy->Add(YawFactor, 0, 0, 0);
    sizer_8_copy_2_copy_copy_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_1_copy->Add(sizer_8_copy_2_copy_copy_copy_1_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_1_copy->Add(20, 10, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_1_copy->Add(label_1_copy_2_copy_copy_1_copy_1_copy, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_1_copy->Add(YawOffset, 0, 0, 0);
    sizer_8_copy_2_copy_copy_1_copy_1_copy->Add(20, 20, 1, 0, 0);
    sizer_7_copy_2_copy_1_copy->Add(sizer_8_copy_2_copy_copy_1_copy_1_copy, 0, wxEXPAND, 0);
    sizer_7_copy_2_copy_1_copy->Add(20, 10, 0, 0, 0);
    sizer_6_copy_copy->Add(sizer_7_copy_2_copy_1_copy, 1, wxEXPAND, 0);
    sizer_6_copy_copy->Add(5, 20, 0, 0, 0);
    sizer_4_copy_copy->Add(sizer_6_copy_copy, 1, wxEXPAND, 0);
    sizer_4_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_5_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_5_copy_copy->Add(DefaultButton, 0, 0, 0);
    sizer_5_copy_copy->Add(20, 20, 0, 0, 0);
    sizer_5_copy_copy->Add(TestButton, 0, 0, 0);
    sizer_5_copy_copy->Add(20, 20, 1, 0, 0);
    sizer_4_copy_copy->Add(sizer_5_copy_copy, 0, wxEXPAND, 0);
    sizer_4_copy_copy->Add(20, 10, 0, 0, 0);
    sizer_14_copy_2->Add(sizer_4_copy_copy, 1, wxEXPAND, 0);
    Panel3->SetSizer(sizer_14_copy_2);
    grid_sizer_1->Add(Panel3, 1, wxEXPAND, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    sizer_10_copy_copy_copy_1_copy_copy_copy->Add(Label3a_copy_copy_copy, 0, 0, 0);
    panel_1_copy_copy_copy_1_copy_copy_copy->SetSizer(sizer_10_copy_copy_copy_1_copy_copy_copy);
    sizer_12_copy_1_copy_copy_copy->Add(panel_1_copy_copy_copy_1_copy_copy_copy, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_1_copy_copy_copy->Add(20, 20, 0, 0, 0);
    sizer_12_copy_1_copy_copy_copy->Add(Label3b_copy_copy_copy, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_1_copy_copy_copy->Add(2, 20, 1, wxEXPAND, 0);
    sizer_12_copy_1_copy_copy_copy->Add(Checkmark2, 0, 0, 0);
    sizer_14_copy->Add(sizer_12_copy_1_copy_copy_copy, 0, wxEXPAND, 0);
    sizer_14_copy->Add(20, 10, 0, 0, 0);
    sizer_9_copy->Add(20, 10, 0, 0, 0);
    sizer_9_copy->Add(Test2Button, 0, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_9_copy->Add(20, 10, 0, 0, 0);
    sizer_14_copy->Add(sizer_9_copy, 0, wxEXPAND, 0);
    Panel2->SetSizer(sizer_14_copy);
    grid_sizer_1->Add(Panel2, 1, wxEXPAND, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    sizer_10_copy_copy_copy_1_copy->Add(Label3a_copy, 0, 0, 0);
    panel_1_copy_copy_copy_1_copy->SetSizer(sizer_10_copy_copy_copy_1_copy);
    sizer_12_copy_1_copy->Add(panel_1_copy_copy_copy_1_copy, 0, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    sizer_12_copy_1_copy->Add(20, 20, 0, 0, 0);
    sizer_12_copy_1_copy->Add(Label3b_copy, 0, wxALIGN_CENTER_VERTICAL, 0);
    sizer_14->Add(sizer_12_copy_1_copy, 0, 0, 0);
    sizer_14->Add(20, 10, 1, 0, 0);
    sizer_14->Add(FinishButton, 0, wxALIGN_CENTER_HORIZONTAL, 0);
    sizer_14->Add(20, 20, 0, 0, 0);
    panel_3->SetSizer(sizer_14);
    grid_sizer_1->Add(panel_3, 1, wxEXPAND, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    grid_sizer_1->Add(20, 20, 0, 0, 0);
    sizer_1->Add(grid_sizer_1, 1, wxEXPAND, 0);
    SetSizer(sizer_1);
    sizer_1->Fit(this);
    Layout();
    Centre();
    // end wxGlade
}



class jWizClass: public wxApp {
public:
    bool OnInit();
};

IMPLEMENT_APP(jWizClass)

bool jWizClass::OnInit()
{
    wxInitAllImageHandlers();
    MainFrameClass* MainFrame = new MainFrameClass(NULL, wxID_ANY, wxEmptyString);
    SetTopWindow(MainFrame);
    MainFrame->Show();
    return true;
}

// Functions to set yaACA3 defaults.

// Sets parameters to all defaults.  These parameters are
// for my Logitech 3D Extreme.
void
MainFrameClass::DefaultParameters3 (void)
{
    Roll3Axis->SetValue (0);
    Roll3Sense->SetSelection (0);
    Pitch3Axis->SetValue (1);
    Pitch3Sense->SetSelection (0);
#if defined (WIN32) || defined (__FreeBSD__)
    Yaw3Axis->SetValue (3);
#else
    Yaw3Axis->SetValue (2);
#endif
    Yaw3Sense->SetSelection (1);
}


// Gets parameters from a cfg file if available, from defaults otherwise.
void
MainFrameClass::GetParameters3 (int ControllerNumber)
{

  DefaultParameters3 ();
  
  wxTextFile File;
  wxString Filename;
  Filename = wxString::Format (wxT ("yaACA3-%d.cfg"), ControllerNumber);
  if (wxFileExists (Filename))
    {
      wxString Dummy, Name, Value;
      int LineCount, i;
      long iValue;
      
      File.Open (Filename);
      LineCount = File.GetLineCount ();
      for (i = 0; i < LineCount; i++)
        {
	  Dummy = File.GetLine (i);
	  Name = Dummy.BeforeLast ('=');
	  Value = Dummy.AfterLast ('=');
	  if (!Value.ToLong (&iValue))
	    iValue = 0;
	  if (Name.IsSameAs (wxT ("Roll.Axis")))
	    Roll3Axis->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Roll.PositiveSense")))
	    Roll3Sense->SetSelection (iValue ? 0 : 1);
	  else if (Name.IsSameAs (wxT ("Pitch.Axis")))
	    Pitch3Axis->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Pitch.PositiveSense")))
	    Pitch3Sense->SetSelection (iValue ? 0 : 1);
	  else if (Name.IsSameAs (wxT ("Yaw.Axis")))
	    Yaw3Axis->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Yaw.PositiveSense")))
	    Yaw3Sense->SetSelection (iValue ? 0 : 1);
	}
      
      File.Close ();
    }
}


// Functions to set yaACA defaults.

// Sets parameters to all defaults.  These parameters are
// for my Logitech 3D Extreme.
void
MainFrameClass::DefaultParameters (void)
{
    RollStick->SetValue (0);
    RollAxis->SetValue (0);
    PitchStick->SetValue (0);
    PitchAxis->SetValue (1);
#ifdef __APPLE__
    YawStick->SetValue (2);
#else
    YawStick->SetValue (1);
#endif
    YawAxis->SetValue (0);
    RollFactor->SetValue (100);
    PitchFactor->SetValue (100);
    YawFactor->SetValue (-100);
    RollOffset->SetValue (0);
    PitchOffset->SetValue (0);
#ifdef WIN32
    YawOffset->SetValue (128);
#else
    YawOffset->SetValue (0);
#endif
}


// Gets parameters from a cfg file if available, from defaults otherwise.
void
MainFrameClass::GetParameters (int ControllerNumber)
{

  DefaultParameters ();
  
  wxTextFile File;
  wxString Filename;
  Filename = wxString::Format (wxT ("yaACA-%d.cfg"), ControllerNumber);
  if (wxFileExists (Filename))
    {
      wxString Dummy, Name, Value;
      int LineCount, i;
      long iValue;
      double dValue;
      
      File.Open (Filename);
      LineCount = File.GetLineCount ();
      for (i = 0; i < LineCount; i++)
        {
	  Dummy = File.GetLine (i);
	  Name = Dummy.BeforeLast ('=');
	  Value = Dummy.AfterLast ('=');
	  if (!Value.ToLong (&iValue))
	    iValue = 0;
	  if (!Value.ToDouble (&dValue))
	    dValue = 1.0;
	  if (Name.IsSameAs (wxT ("Roll.Stick")))
	    RollStick->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Roll.Axis")))
	    RollAxis->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Roll.Factor")))
	    RollFactor->SetValue (lround (dValue * 100));
	  else if (Name.IsSameAs (wxT ("Roll.Offset")))
	    RollOffset->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Pitch.Stick")))
	    PitchStick->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Pitch.Axis")))
	    PitchAxis->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Pitch.Factor")))
	    PitchFactor->SetValue (lround (dValue * 100));
	  else if (Name.IsSameAs (wxT ("Pitch.Offset")))
	    PitchOffset->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Yaw.Stick")))
	    YawStick->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Yaw.Axis")))
	    YawAxis->SetValue (iValue);
	  else if (Name.IsSameAs (wxT ("Yaw.Factor")))
	    YawFactor->SetValue (lround (dValue * 100));
	  else if (Name.IsSameAs (wxT ("Yaw.Offset")))
	    YawOffset->SetValue (iValue);
	}
      
      File.Close ();
    }
}

































