// -*- C++ -*- generated by wxGlade 0.6.3 on Thu Mar  5 10:11:10 2009
/*
  Copyright 2009 Ronald S. Burkey <info@sandroid.org>

  This file is part of yaAGC.

  yaAGC is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  yaAGC is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with yaAGC; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	VirtualAGC.h
  Purpose:	This is a class-definition header file for VirtualAGC.cpp.
  		The purpose of VirtualAGC is to provide a cross-platform
		GUI front-end that can be used to start up a Virtual AGC
		simulation (yaAGC, yaDSKY, yaAGS, etc.) in a convenient
		way.
  Mods:		2009-03-02 RSB	Began.
  		2009-03-11 RSB	Added yaTelemetry.
		2009-03-15 RSB	Added missing IDs for some simulation-type
				radio buttons.  Added the source-view
				buttons.
		2009-03-17 RSB	Added the script info to the Simulation
				run window.
		2009-03-23 RSB	Added digital-upload stuff.
		2009-04-21 RSB	Main screen rework/resize.
   
  This file is partially generated by wxGlade from VirtualAGC.wxg.
  (Of course, I wrote VirtualAGC.wxg and there's no way to embed any
  copyright or licensing info in it, but I assert the same copyright
  and licensing for it as for this file.  Conversely, even though 
  this file is partially machine-generated, it is generated from 
  my instructions in VirtualAGC.wxg, so I can assert copyright.)  
  However, this section of the file is not overwritten, and is 
  maintained manually.
*/

#include <wx/wx.h>
#include <wx/image.h>
// begin wxGlade: ::dependencies
#include <wx/statline.h>
// end wxGlade


#ifndef VIRTUALAGC_H
#define VIRTUALAGC_H

// Constants for identifying widgets.
enum { 
  ID_AGCFILENAMELABEL = 0,
  ID_AGCCUSTOMFILENAME,
  ID_AGCFILENAMEBROWSE,
  ID_AEAFILENAMELABEL,
  ID_AEACUSTOMFILENAME,
  ID_AEAFILENAMEBROWSE,
  ID_DEVICEAGCCHECKBOX,
  ID_DEVICEDSKYCHECKBOX,
  ID_DEVICEACACHECKBOX,
  ID_DEVICETELEMETRYCHECKBOX,
  ID_DEVICEAEACHECKBOX,
  ID_DEVICEDEDACHECKBOX,
  ID_DEVICECPUMONCHECKBOX,
  ID_DEVICEIMUCHECKBOX,
  ID_DEVICEDISCOUTCHECKBOX,
  ID_DEVICECREWINCHECKBOX,
  ID_DEVICESYSINCHECKBOX,
  ID_DEVICEPROPULSIONCHECKBOX,
  ID_NOVICEBUTTON,
  ID_EXPERTBUTTON,
  ID_RUNBUTTON,
  ID_DEFAULTSBUTTON,
  ID_EXITBUTTON,
  ID_AGCSOURCEBUTTON,
  ID_AEASOURCEBUTTON,
  ID_JOYSTICKCONFIGURE,
  ID_AGCSIMTYPEBOX = 100,
  ID_APOLLO1CMBUTTON,
  ID_APOLLO7CMBUTTON,
  ID_COLOSSUS249BUTTON,
  ID_APOLLO9CMBUTTON,
  ID_APOLLO9LMBUTTON,
  ID_APOLLO10CMBUTTON,
  ID_APOLLO10LMBUTTON,
  ID_COMANCHE55BUTTON,
  ID_LUMINARY99BUTTON,
  ID_APOLLO12CMBUTTON,
  ID_APOLLO12LMBUTTON,
  ID_APOLLO13CMBUTTON,
  ID_LUMINARY131BUTTON,
  ID_APOLLO14LMBUTTON,
  ID_APOLLO14CMBUTTON,
  ID_ARTEMIS72BUTTON,
  ID_APOLLO15LMBUTTON,
  ID_SKYLABCMBUTTON,
  ID_VALIDATIONBUTTON,
  ID_AGCCUSTOMBUTTON,
  ID_AEASIMTYPEBOX = 200,
  ID_FLIGHTPROGRAM4BUTTON,
  ID_FLIGHTPROGRAM5BUTTON,
  ID_FLIGHTPROGRAM6BUTTON,
  ID_FLIGHTPROGRAM7BUTTON,
  ID_FLIGHTPROGRAM8BUTTON,
  ID_AEACUSTOMBUTTON,
  ID_STARTUPOPTIONSBOX = 300,
  ID_STARTUPWIPEBUTTON,
  ID_STARTUPPRESERVEBUTTON,
  ID_STARTUPRESUMEBUTTON,
  ID_CUSTOMRESUMEBUTTON,
  ID_COREBROWSE,
  ID_CORESAVEBUTTON,
  ID_DSKYTYPEBOX = 400,
  ID_DSKYFULLBUTTON,
  ID_DSKYHALFBUTTON,
  ID_DSKYLITEBUTTON,
  ID_AGCDEBUGBOX = 500,
  ID_AGCDEBUGNORMALBUTTON,
  ID_AGCDEBUGMONITORBUTTON,
  ID_DEDATYPEBOX = 600,
  ID_DEDAFULLBUTTON,
  ID_DEDAHALFBUTTON,
  ID_AEADEBUGBOX = 700,
  ID_AEADEBUGNORMALBUTTON,
  ID_AEADEBUGMONITORBUTTON,
  ID_SIMULATIONLABEL = 800,
  ID_MORE,
  ID_LESS,
  ID_UPLOAD
};


class TimerClass: public wxTimer {
public:
    int IoErrorCount;
    int Portnum;
    int KeycodeIndex;

private:
    virtual void Notify();
};


// begin wxGlade: ::extracode
// end wxGlade


class Simulation: public wxFrame {
public:
    // begin wxGlade: Simulation::ids
    // end wxGlade

    Simulation(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_FRAME_STYLE);
    void WriteSimulationLabel (wxString Label);
    unsigned char Keycodes[8192];
    int NumKeycodes;
    bool MoreEnabled, LessEnabled, DetailShown;
    enum { UT_UNKNOWN, UT_CM, UT_LM, UT_AEA } UnitType;

private:
    // begin wxGlade: Simulation::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    void Upload (wxString &Filename);
    TimerClass *Timer;

public:
    // begin wxGlade: Simulation::attributes
    wxStaticBox* sizer_32_staticbox;
    wxStaticBox* sizer_33_staticbox;
    wxStaticBitmap* PatchBitmap;
    wxStaticText* SimulationLabel;
    wxButton* MoreButton;
    wxButton* LessButton;
    wxButton* UploadButton;
    wxTextCtrl* UplinkText;
    wxPanel* UplinkPanel;
    wxTextCtrl* ScriptText;
    wxPanel* ScriptPanel;
    wxPanel* DetailPanel;
    // end wxGlade

    DECLARE_EVENT_TABLE();

public:
    virtual void MoreEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void LessEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void UploadEvent(wxCommandEvent &event); // wxGlade: <event_handler>
}; // wxGlade: end class

class VirtualAGC: public wxFrame {
public:
    // begin wxGlade: VirtualAGC::ids
    // end wxGlade

    VirtualAGC(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_FRAME_STYLE);
    
    // For keeping track of a running simulation.
    Simulation *SimulationWindow;
    void EnableRunButton (void);
    long SimulationProcessID;
    void SetSize (void);
    int Points, StartingPoints;
    int ReallySmall;
    wxString ResourceDirectory;		// Where the images, cfg files, etc. are stored.
    bool IsLM;
    bool CmSim, LmSim, AeaSim;
    bool FunkyYaACA;

private:
    // begin wxGlade: VirtualAGC::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    bool FormLmsIni (void);
    bool FormCommands (void);
    bool FormScript (void);
    wxString AgcDirectory;
    wxString AeaDirectory;
    wxString ExecutableDirectory;	// Where the executables are stored.
    wxString RunDirectory;		// A directory in which to run the simulation.
    wxString PathDelimiter;
    // Command lines for other executables.
    wxString yaAGC, yaDSKY, yaACA, yaAGS, yaDEDA, LM_Simulator, yaTelemetry;
    
    void EnableLM (bool YesNo);		// Enables/disables LM-specific settings
    void EnableAEA (bool YesNo);	// Enables/disables AEA-specific settings
    void EnableDEDA (bool YesNo);	// Enables/disables DEDA-specific settings
    void EnableCustomAGC (bool YesNo);	// Enables/disables custom AGC software settings
    void EnableCustomAEA (bool YesNo);	// Enables/disables custom AGS software settings
    void EnableCpumon (bool YesNo);	// Enables/disables LM-Simulator settings.
    void EnforceConsistency (void);	// Enable/disable all controls to be consistent.
    void SetDefaultConfiguration (void);
    void ReadConfigurationFile (void);
    void WriteConfigurationFile (void);

protected:
    // begin wxGlade: VirtualAGC::attributes
    wxStaticBox* sizer_20_staticbox;
    wxStaticBox* sizer_38_staticbox;
    wxStaticBox* sizer_22_staticbox;
    wxStaticBox* sizer_18_staticbox;
    wxStaticBox* sizer_1_copy_staticbox;
    wxStaticBox* sizer_19_staticbox;
    wxStaticBitmap* Patch1Bitmap;
    wxStaticBitmap* Patch7Bitmap;
    wxStaticBitmap* Patch8Bitmap;
    wxStaticBitmap* Patch9Bitmap;
    wxStaticBitmap* Patch10Bitmap;
    wxStaticBitmap* Patch11Bitmap;
    wxStaticBitmap* PatchBitmap;
    wxStaticBitmap* Patch12Bitmap;
    wxStaticBitmap* Patch13Bitmap;
    wxStaticBitmap* Patch14Bitmap;
    wxStaticBitmap* Patch15Bitmap;
    wxStaticBitmap* Patch16Bitmap;
    wxStaticBitmap* Patch17Bitmap;
    wxStaticLine* TopLine;
    wxStaticText* SimTypeLabel;
    wxRadioButton* Apollo1CmButton;
    wxRadioButton* Apollo7CmButton;
    wxRadioButton* Colossus249Button;
    wxRadioButton* Apollo9CmButton;
    wxRadioButton* Apollo9LmButton;
    wxRadioButton* Apollo10CmButton;
    wxRadioButton* Apollo10LmButton;
    wxRadioButton* Comanche55Button;
    wxRadioButton* Luminary99Button;
    wxRadioButton* Apollo12CmButton;
    wxRadioButton* Apollo12LmButton;
    wxRadioButton* Apollo13CmButton;
    wxRadioButton* Luminary131Button;
    wxRadioButton* Apollo14CmButton;
    wxRadioButton* Apollo14LmButton;
    wxRadioButton* Artemis72Button;
    wxRadioButton* Apollo15LmButton;
    wxRadioButton* SkylabCmButton;
    wxRadioButton* ValidationButton;
    wxRadioButton* AgcCustomButton;
    wxTextCtrl* AgcCustomFilename;
    wxButton* AgcFilenameBrowse;
    wxStaticLine* static_line_2;
    wxStaticText* DeviceListLabel;
    wxCheckBox* DeviceAgcCheckbox;
    wxCheckBox* DeviceDskyCheckbox;
    wxCheckBox* DeviceAcaCheckbox;
    wxButton* JoystickConfigure;
    wxCheckBox* DeviceTelemetryCheckbox;
    wxCheckBox* DeviceAeaCheckbox;
    wxCheckBox* DeviceDedaCheckbox;
    wxCheckBox* DeviceCpumonCheckbox;
    wxStaticLine* static_line_4;
    wxCheckBox* DeviceImuCheckbox;
    wxCheckBox* DeviceDiscoutCheckbox;
    wxCheckBox* DeviceCrewinCheckbox;
    wxCheckBox* DeviceSysinCheckbox;
    wxCheckBox* DevicePropulsionCheckbox;
    wxButton* NoviceButton;
    wxButton* ExpertButton;
    wxStaticLine* static_line_3;
    wxStaticLine* static_line_5;
    wxButton* AgcSourceButton;
    wxButton* AeaSourceButton;
    wxStaticText* OptionList;
    wxRadioButton* StartupWipeButton;
    wxRadioButton* StartupPreserveButton;
    wxRadioButton* StartupResumeButton;
    wxRadioButton* CustomResumeButton;
    wxTextCtrl* CoreFilename;
    wxButton* CoreBrowse;
    wxButton* CoreSaveButton;
    wxStaticText* DskyLabel;
    wxRadioButton* DskyFullButton;
    wxRadioButton* DskyHalfButton;
    wxRadioButton* DskyLiteButton;
    wxStaticText* DownlinkLabel;
    wxRadioButton* TelemetryResizable;
    wxRadioButton* TelemetryRetro;
    wxStaticText* DedaLabel;
    wxRadioButton* DedaFullButton;
    wxRadioButton* DedaHalfButton;
    wxStaticText* AgcDebugLabel;
    wxRadioButton* AgcDebugNormalButton;
    wxRadioButton* AgcDebugMonitorButton;
    wxStaticText* AeaDebugLabel;
    wxRadioButton* AeaDebugNormalButton;
    wxRadioButton* AeaDebugMonitorButton;
    wxRadioButton* FlightProgram4Button;
    wxRadioButton* FlightProgram5Button;
    wxRadioButton* FlightProgram6Button;
    wxRadioButton* FlightProgram7Button;
    wxRadioButton* FlightProgram8Button;
    wxRadioButton* AeaCustomButton;
    wxTextCtrl* AeaCustomFilename;
    wxButton* AeaFilenameBrowse;
    wxStaticLine* static_line_1;
    wxButton* RunButton;
    wxButton* DefaultsButton;
    wxButton* ExitButton;
    // end wxGlade

    DECLARE_EVENT_TABLE();

public:
    virtual void Colossus249Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Comanche55Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Luminary99Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Luminary131Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Artemis72Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AgcCustomEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AgcFilenameBrowseEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void FlightProgram6Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void FlightProgram8Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AeaCustomEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AeaFilenameBrowseEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceAgcEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceDskyEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceAcaEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceTelemetryEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceAeaEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceDedaEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceCpumonEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceImuEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceDiscoutEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceCrewinEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DeviceSysinEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DevicePropulsionEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void NoviceButtonEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void ExpertButtonEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void StartupWipeEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void StartupResumeEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DskyFullEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DskyHalfEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DskyLiteEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AgcDebugNormalEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AgcDebugMonitorEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DedaFullEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DedaHalfEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AeaDebugNormalEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AeaDebugMonitorEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void RunButtonEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void DefaultsButtonEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void ExitButtonEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void StartupPreserveEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo7CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo9CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo9LmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo10CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo10LmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo12CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo12LmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo13CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo14CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo14LmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo15LmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void ValidationEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AgcSourceEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void AeaSourceEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void FlightProgram4Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void FlightProgram5Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void FlightProgram7Event(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void CoreBrowseEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void CoreSaveEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void CustomCoreClick(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void JoystickConfigureClicked(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void Apollo1CmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void SkylabCmEvent(wxCommandEvent &event); // wxGlade: <event_handler>
}; // wxGlade: end class


#endif // VIRTUALAGC_H
