// -*- C++ -*- generated by wxGlade 0.6.3 on Fri Mar  6 23:28:00 2009
/*
  Copyright 2009 Ronald S. Burkey <info@sandroid.org>
  
  This file is part of yaAGC.

  yaAGC is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  yaAGC is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with yaAGC; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  
  Filename:	yaDSKY2.h
  Contact:	Ron Burkey <info@sandroid.org>
  Reference:	http://www.ibiblio.org/apollo/index.html
  Mods:		2009-03-06 RSB	Began.
  		2009-03-12 RSB	First working version.
*/

#include <wx/wx.h>
#include <wx/image.h>
// begin wxGlade: ::dependencies
// end wxGlade


#ifndef YADSKY2_H
#define YADSKY2_H


// begin wxGlade: ::extracode
// end wxGlade

// IDs for objects with events.
enum {
  ID_VERBBUTTON,
  ID_NOUNBUTTON,
  ID_PLUSBUTTON,
  ID_MINUSBUTTON,
  ID_ZEROBUTTON,
  ID_ONEBUTTON,
  ID_TWOBUTTON,
  ID_THREEBUTTON,
  ID_FOURBUTTON,
  ID_FIVEBUTTON,
  ID_SIXBUTTON,
  ID_SEVENBUTTON,
  ID_EIGHTBUTTON,
  ID_NINEBUTTON,
  ID_CLRBUTTON,
  ID_PROBUTTON,
  ID_KEYRELBUTTON,
  ID_ENTRBUTTON,
  ID_RSETBUTTON, 
  ID_PULSE
};


typedef struct {
  const char *GraphicOn;	// Filename of graphic for "lit" condition.
  const char *GraphicOff;	// Filename of graphic for "dark" condition.
  int Channel;			// CPU i/o channel.
  int Bitmask;			// Mask selecting bitflag within i/o channel.
  int Polarity;			// Mask for flipping the polarity. (Either 0 or Bitmask.)
  int State;			// Whether currently on or off.  (Either 0 or Bitmask.)
  wxStaticBitmap *Widget;	// The widget corresponding to the lamp.
  // Stuff mainly for indicators controlled by channel 10.
  int Latched;			// Following stuff ignored if Latched==0.
  int RowMask;
  int Row;
} Ind_t;


class TimerClass: public wxTimer {
public:
    int IoErrorCount;

private:
    virtual void Notify();
    void ActOnIncomingIO (unsigned char *Packet);
};


class MainFrame: public wxFrame {
public:
    // begin wxGlade: MainFrame::ids
    // end wxGlade

    MainFrame(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_FRAME_STYLE);
    wxString 
      CurrentVD1, CurrentVD2, CurrentND1,
      CurrentND2, CurrentBlank,
      CurrentOprErr, CurrentKeyRel,
      BlankOprErr, BlankKeyRel;
    TimerClass *Timer;
    void ImageSet (wxStaticBitmap *StaticBitmap, wxString &Filename);
    void ImageSet (wxStaticBitmap *StaticBigmap, char *Filename);
    void ImageSet (wxStaticBitmap *StaticBigmap, const char *Filename);
    void ImageSet (wxBitmapButton *BitmapButton, wxString &Filename);
    void ImageSet (wxBitmapButton *BitmapButton, char *Filename);
    void ImageSet (wxBitmapButton *BitmapButton, const char *Filename);
    wxStaticBitmap *KeyRelAnnunciator, *OprErrAnnunciator;
    wxBitmapButton *iLastButton;
    int ParseCfg (wxString &Filename);
    void HalveTheWindow (void);
      
private:
    // begin wxGlade: MainFrame::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    wxTimer *PulseTimer;
    void OutputKeycode (int Keycode);
    void OutputPro (int OffOn);

//protected:
public:
    // begin wxGlade: MainFrame::attributes
    wxStaticBitmap* bitmap_5;
    wxStaticBitmap* bitmap_6_copy;
    wxStaticBitmap* Annunciator11;
    wxStaticBitmap* Annunciator21;
    wxStaticBitmap* Annunciator12;
    wxStaticBitmap* Annunciator22;
    wxStaticBitmap* Annunciator13;
    wxStaticBitmap* Annunciator23;
    wxStaticBitmap* Annunciator14;
    wxStaticBitmap* Annunciator24;
    wxStaticBitmap* Annunciator15;
    wxStaticBitmap* Annunciator25;
    wxStaticBitmap* Annunciator16;
    wxStaticBitmap* Annunciator26;
    wxStaticBitmap* Annunciator17;
    wxStaticBitmap* Annunciator27;
    wxStaticBitmap* bitmap_6;
    wxStaticBitmap* bitmap_5_copy;
    wxStaticBitmap* bitmap_5_copy_1;
    wxStaticBitmap* bitmap_6_copy_copy;
    wxStaticBitmap* CompActyAnnunciator;
    wxStaticBitmap* ModeAnnunciator;
    wxStaticBitmap* MD1Digit;
    wxStaticBitmap* MD2Digit;
    wxStaticBitmap* VerbAnnunciator;
    wxStaticBitmap* VD1Digit;
    wxStaticBitmap* VD2Digit;
    wxStaticBitmap* NounAnnunciator;
    wxStaticBitmap* ND1Digit;
    wxStaticBitmap* ND2Digit;
    wxStaticBitmap* bitmap_2_copy_1;
    wxStaticBitmap* R1PlusMinus;
    wxStaticBitmap* R1D1Digit;
    wxStaticBitmap* R1D2Digit;
    wxStaticBitmap* R1D3Digit;
    wxStaticBitmap* R1D4Digit;
    wxStaticBitmap* R1D5Digit;
    wxStaticBitmap* bitmap_2_copy;
    wxStaticBitmap* R2PlusMinus;
    wxStaticBitmap* R2D1Digit;
    wxStaticBitmap* R2D2Digit;
    wxStaticBitmap* R2D3Digit;
    wxStaticBitmap* R2D4Digit;
    wxStaticBitmap* R2D5Digit;
    wxStaticBitmap* bitmap_2;
    wxStaticBitmap* R3PlusMinus;
    wxStaticBitmap* R3D1Digit;
    wxStaticBitmap* R3D2Digit;
    wxStaticBitmap* R3D3Digit;
    wxStaticBitmap* R3D4Digit;
    wxStaticBitmap* R3D5Digit;
    wxPanel* panel_1;
    wxStaticBitmap* bitmap_6_copy_copy_copy;
    wxStaticBitmap* bitmap_5_copy_2;
    wxBitmapButton* VerbButton;
    wxBitmapButton* NounButton;
    wxBitmapButton* PlusButton;
    wxBitmapButton* MinusButton;
    wxBitmapButton* ZeroButton;
    wxBitmapButton* SevenButton;
    wxBitmapButton* FourButton;
    wxBitmapButton* OneButton;
    wxBitmapButton* EightButton;
    wxBitmapButton* FiveButton;
    wxBitmapButton* TwoButton;
    wxBitmapButton* NineButton;
    wxBitmapButton* SixButton;
    wxBitmapButton* ThreeButton;
    wxBitmapButton* ClrButton;
    wxBitmapButton* ProButton;
    wxBitmapButton* KeyRelButton;
    wxBitmapButton* EntrButton;
    wxBitmapButton* RsetButton;
    // end wxGlade

    DECLARE_EVENT_TABLE();

public:
    virtual void on_VerbButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_NounButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_PlusButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_MinusButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_ZeroButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_SevenButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_FourButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_OneButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_EightButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_FiveButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_TwoButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_NineButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_SixButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_ClrButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_ProButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_KeyRelButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_EntrButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_RsetButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void on_ThreeButton_pressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void HotkeyEvent (wxKeyEvent &event);
}; // wxGlade: end class


#endif // YADSKY2_H
