// -*- C++ -*- generated by wxGlade 0.6.3 on Mon Mar 16 15:10:36 2009
/*
  Copyright 2009 Ronald S. Burkey <info@sandroid.org>
  
  This file is part of yaAGC. 

  yaAGC is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  yaAGC is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with yaAGC; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  Filename:	yaACA2.h
  Purpose:	Header file for yaACA2.cpp.
  Reference:	http://www.ibiblio.org/apollo/index.html
  Mode:		2009-03-19 RSB.	Began.
*/

#include <wx/wx.h>
#include <wx/image.h>
// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
// end wxGlade
#include <wx/joystick.h>


#ifndef YAACA2_H
#define YAACA2_H


// begin wxGlade: ::extracode
// end wxGlade

// Relationship between numerical axis identification (0...)
// and the identifications used by wxJoystick.
enum {
  AXIS_X = 0, AXIS_Y, AXIS_Z, AXIS_U, AXIS_V, AXIS_RUDDER, NUM_AXES
};

// Info read back from wxJoystick about axes 0..5.
typedef struct {
  bool Has;
  int Maximum, Minimum;
  int CurrentRawReading;
  // The following parameters are derived from Maximum and Minimum.
  // The are used to convert the raw reading to an adjusted reading
  // by:
  //	1. Cutting out about a +/- 10% deadzone around the middle
  // 	   position.
  //	2. Converting the remainder to a -57 to +57 range.
  int Midpoint;
  int Deadzone;
  int Divisor;
  // The notion of "sticks" and "axes" is specific to Allegro,
  // and so the following fields are used only for Allegro.
  // Each logical axis refers to a unique aStick,aAxis pair.
  int aStick;
  int aAxis;
} jAxis_t;

// Settings for Pitch, Roll, Yaw degrees of freedom. 
typedef struct {
  int Axis;
  bool PositiveSense;
  int CurrentAdjustedReading;
  int LastRawReading;
} Axis_t;

class TimerClass: public wxTimer {
public:
    int IoErrorCount;
    jAxis_t Axes[NUM_AXES];
    void Translate (Axis_t *AxisPtr);
    void ServiceJoystick_wxWidgets (void);
    void ServiceJoystick_Allegro (void);
    void ServiceJoystick_sdl (void);
    int Initialization;

private:
    virtual void Notify();
};


class yaAcaFrameClass: public wxFrame {
public:
    // begin wxGlade: yaAcaFrameClass::ids
    // end wxGlade

    yaAcaFrameClass(wxWindow* parent, int id, const wxString& title, const wxPoint& pos=wxDefaultPosition, const wxSize& size=wxDefaultSize, long style=wxDEFAULT_FRAME_STYLE);

    enum { ID_DEFAULT, ID_SET };
    TimerClass *Timer;
    void DefaultParameters (void);
    void GetParameters (int ControllerNumber);
    void WriteParameters (int ControllerNumber);
    Axis_t Pitch, Roll, Yaw;
    void UpdateJoystick (void);
    void TimerStop(wxCloseEvent& event);

private:
    // begin wxGlade: yaAcaFrameClass::methods
    void set_properties();
    void do_layout();
    // end wxGlade

public:
    // begin wxGlade: yaAcaFrameClass::attributes
    wxStaticBox* YawBox_staticbox;
    wxStaticBox* PitchBox_staticbox;
    wxStaticBox* RollBox_staticbox;
    wxStaticBox* ControllerSizer_staticbox;
    wxStaticText* label_4;
    wxStaticText* ToolkitLabel;
    wxPanel* panel_2;
    wxStaticText* label_1;
    wxStaticText* ControllerNumberLabel;
    wxPanel* ControllerNumberPanel;
    wxStaticText* label_1_copy_3;
    wxStaticText* ControllerModelLabel;
    wxPanel* ModelPanel;
    wxStaticText* label_3;
    wxCheckBox* BoxAxis0;
    wxCheckBox* BoxAxis1;
    wxCheckBox* BoxAxis2;
    wxCheckBox* BoxAxis3;
    wxCheckBox* BoxAxis4;
    wxCheckBox* BoxAxis5;
    wxCheckBox* BoxAxis6;
    wxPanel* panel_1;
    wxStaticText* label_1_copy_1;
    wxStaticText* ControllerPitchLabel;
    wxPanel* ControllerPitchPanel;
    wxStaticText* label_1_copy_4;
    wxStaticText* ControllerRollLabel;
    wxPanel* ControllerPositionPanel_copy;
    wxStaticText* label_1_copy;
    wxStaticText* ControllerYawLabel;
    wxPanel* ControllerPositionPanel_copy_1;
    wxStaticText* label_2;
    wxSpinCtrl* RollAxisCtrl;
    wxRadioBox* RollPolarityBox;
    wxStaticText* label_2_copy;
    wxSpinCtrl* PitchAxisCtrl;
    wxRadioBox* PitchPolarityBox;
    wxStaticText* label_2_copy_1;
    wxSpinCtrl* YawAxisCtrl;
    wxRadioBox* YawPolarityBox;
    wxButton* DefaultButton;
    wxButton* SetButton;
    wxStaticText* StatusLabel;
    wxPanel* StatusPanel;
    // end wxGlade

    DECLARE_EVENT_TABLE()
    
protected:
    virtual void OnDefaultPressed(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnSetPressed(wxCommandEvent &event); // wxGlade: <event_handler>

}; // wxGlade: end class


#endif // YAACA2_H
