# Copyright 2005 Stephan Hotto <stephan.hotto@web.de>
#
# This file is part of yaAGC.
#
# yaAGC is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# yaAGC is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with yaAGC; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# ********************************************************************************************
# **** Module:         AGC_Crew_Inputs.tcl                                                ****
# **** Main Program:   lm_system_simulator                                                ****
# **** Author:         Stephan Hotto                                                      ****
# **** Date:           29.05.05                                                           ****
# **** Version:        v0.01                                                              ****
# ********************************************************************************************

# ********************************************************************************************
# **** Function:  Create AGC Crew Inputs GUI                                              ****
# ********************************************************************************************
proc create_crewinp {} {
 global bo font1 font2 font3

 if {[winfo exists .crewinp] == 1} {destroy .crewinp}

 toplevel .crewinp
 wm title .crewinp "AGC Crew Inputs (Switches & Buttons)"
 wm geometry .crewinp +250+250
 wm geometry .crewinp 450x500
 wm minsize  .crewinp 450 500
 wm iconname .crewinp "AGC Crew Inputs"
 
 frame .crewinp.fma; frame .crewinp.fmb; frame .crewinp.fmc; frame .crewinp.fmd;
 
 pack .crewinp.fma .crewinp.fmb .crewinp.fmc .crewinp.fmd -side left -anchor n -pady 1 -padx 15
 
 # --------------------- Checkbutton as Signal Indicator --------------------------
 # --------------------- 1st column -----------------------------------------------
 label .crewinp.l0a -text "ENGINE:" -font ${font3}
 pack  .crewinp.l0a -side top -in .crewinp.fma -anchor w
 
 checkbutton .crewinp.cb1a -text "ENGINE ARMED SIGNAL" -variable b(30,3) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(30) "000000000000100"; write_socket b 30}
 pack .crewinp.cb1a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb2a -text "AUTO THROTTLE\nCOMPUTER CONTROL OF DESCENT" -variable b(30,5) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(30) "000000000010000"; write_socket b 30} -justify left
 pack .crewinp.cb2a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb3a -text "DESCENT ENGINE\nDISABLED BY CREW" -variable b(32,9) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000100000000"; write_socket b 32} -justify left
 pack .crewinp.cb3a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb4a -text "APPARENT DESCENT ENGINE\nGIMBAL FAILURE" -variable b(32,10) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000001000000000"; write_socket b 32} -justify left
 pack .crewinp.cb4a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 label .crewinp.l41a -text "" -font ${font1}
 pack  .crewinp.l41a -side top -in .crewinp.fma -anchor w -fill x
 
 label .crewinp.l5a -text "THRUSTERS:" -font ${font3}
 pack  .crewinp.l5a -side top -in .crewinp.fma -anchor w
 
 checkbutton .crewinp.cb6a -text "THRUSTERS 2&4 DISABLED" -variable b(32,1) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000000000001"; write_socket b 32} -justify left
 pack .crewinp.cb6a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb7a -text "THRUSTERS 5&8 DISABLED" -variable b(32,2) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000000000010"; write_socket b 32} -justify left
 pack .crewinp.cb7a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb8a -text "THRUSTERS 1&3 DISABLED" -variable b(32,3) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000000000100"; write_socket b 32} -justify left
 pack .crewinp.cb8a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb9a -text "THRUSTERS 6&7 DISABLED" -variable b(32,4) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000000001000"; write_socket b 32} -justify left
 pack .crewinp.cb9a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb10a -text "THRUSTERS 14&16 DISABLED" -variable b(32,5) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000000010000"; write_socket b 32} -justify left
 pack .crewinp.cb10a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb11a -text "THRUSTERS 13&15 DISABLED" -variable b(32,6) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000000100000"; write_socket b 32} -justify left
 pack .crewinp.cb11a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb12a -text "THRUSTERS 9&12 DISABLED" -variable b(32,7) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000001000000"; write_socket b 32} -justify left
 pack .crewinp.cb12a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 checkbutton .crewinp.cb13a -text "THRUSTERS 10&11 DISABLED" -variable b(32,8) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 2 -onvalue "0" -offvalue "1" -command {set bmask(32) "000000010000000"; write_socket b 32} -justify left
 pack .crewinp.cb13a -side top -in .crewinp.fma -anchor w -fill x -pady 2
 
 label .crewinp.l0b -text "RADAR:" -font ${font3}
 pack  .crewinp.l0b -side top -in .crewinp.fmb -anchor w
  
 checkbutton .crewinp.cb1b -text "RR AUTO-POWER ON" -variable b(33,2) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 4 -onvalue "0" -offvalue "1" -command {set bmask(33) "000000000000010"; write_socket b 33}
 pack .crewinp.cb1b -side top -in .crewinp.fmb -anchor w -fill x
 
 label .crewinp.l11b -text "" -font ${font1}
 pack  .crewinp.l11b -side top -in .crewinp.fmb -anchor w -fill x
 
 label .crewinp.l2b -text "IMU:" -font ${font3}
 pack  .crewinp.l2b -side top -in .crewinp.fmb -anchor w
 
 checkbutton .crewinp.cb3b -text "DISPLAY INERTIAL DATA" -variable b(30,6) -relief raised -borderwidth 2 -anchor w -font ${font1} -pady 4 -onvalue "0" -offvalue "1" -command {set bmask(30) "000000000100000"; write_socket b 30}
 pack .crewinp.cb3b -side top -in .crewinp.fmb -anchor w -fill x

 
}
 
 