# Copyright 2005 Stephan Hotto <stephan.hotto@web.de>
#
# This file is part of yaAGC.
#
# yaAGC is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# yaAGC is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with yaAGC; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# ********************************************************************************************
# **** Module:         AGC_IMU.tcl                                                        ****
# **** Main Program:   lm_system_simulator                                                ****
# **** Author:         Stephan Hotto                                                      ****
# **** Date:           29.05.05                                                           ****
# **** Version:        v0.01                                                              ****
# ********************************************************************************************

# ********************************************************************************************
# **** Function:  Create AGC IMU GUI                                                      ****
# ********************************************************************************************
proc create_imugui {} {
 global bo font1 font2 font3
 global CDUX_INC_DEC_FLAG CDUY_COUNT_FLAG CDUY_INC_DEC_FLAG CDUZ_COUNT_FLAG CDUZ_INC_DEC_FLAG CDUX_COUNT_FLAG
 global IMUX_ANGLE IMUY_ANGLE IMUZ_ANGLE

 if {[winfo exists .imu] == 1} {destroy .imu}

 toplevel .imu
 wm title .imu "AGC IMU - Inertial Measurement Unit"
 wm geometry .imu +300+300
 wm geometry .imu 450x300
 wm minsize  .imu 450 300
 wm iconname .imu "AGC IMU"
 
 frame .imu.fma; frame .imu.fmb; frame .imu.fmc; frame .imu.fmd;
 
 pack .imu.fma .imu.fmb .imu.fmc .imu.fmd -side left -anchor n -pady 1 -padx 15
 
 frame .imu.f0a; frame .imu.f1a; frame .imu.f2a; frame .imu.f3a; frame .imu.f4a
 frame .imu.f5a; frame .imu.f6a; frame .imu.f7a; frame .imu.f8a
 pack .imu.f0a .imu.f1a .imu.f2a .imu.f3a .imu.f4a .imu.f5a -in .imu.fma -side top -anchor w -pady 2
 pack .imu.f6a .imu.f7a .imu.f8a -in .imu.fma -side top -anchor w -pady 2
 
 # --------------------- Checkbutton as Signal Indicator --------------------------
 # --------------------- 1st column -----------------------------------------------
 label .imu.l0a -text "IMU ANGLES:" -font ${font3}
 pack  .imu.l0a -side left -in .imu.f0a -anchor w
 
 label .imu.l1a -text "CDUX:" -font ${font1}
 radiobutton .imu.rb1a -text "INC" -variable CDUX_INC_DEC_FLAG -value "INC" -font ${font1}
 radiobutton .imu.rb11a -text "DEC" -variable CDUX_INC_DEC_FLAG -value "DEC" -font ${font1}
 button .imu.b1a -text "Single" -command {imu_count "CDUX"} -font ${font1}
 checkbutton .imu.cb1a -text "Loop" -variable CDUX_COUNT_FLAG -relief raised -borderwidth 2 -anchor w -font ${font1} -onvalue "LOOP" -offvalue "SINGLE" -padx 2
 entry .imu.e1a -width 7 -relief groove -bd 2 -textvariable IMUX_ANGLE -font ${font1}
 label .imu.l11a -text "°" -font ${font3}
 pack  .imu.l1a .imu.rb1a .imu.rb11a .imu.b1a .imu.cb1a .imu.e1a .imu.l11a -side left -in .imu.f1a -padx 2 -fill y
 
 label .imu.l2a -text "CDUY:" -font ${font1}
 radiobutton .imu.rb2a -text "INC" -variable CDUY_INC_DEC_FLAG -value "INC" -font ${font1}
 radiobutton .imu.rb21a -text "DEC" -variable CDUY_INC_DEC_FLAG -value "DEC" -font ${font1}
 button .imu.b2a -text "Single" -command {imu_count "CDUY"} -font ${font1}
 checkbutton .imu.cb2a -text "Loop" -variable CDUY_COUNT_FLAG -relief raised -borderwidth 2 -anchor w -font ${font1} -onvalue "LOOP" -offvalue "SINGLE" -padx 2
 entry .imu.e2a -width 7 -relief groove -bd 2 -textvariable IMUY_ANGLE -font ${font1}
 label .imu.l21a -text "°" -font ${font3}
 pack  .imu.l2a .imu.rb2a .imu.rb21a .imu.b2a .imu.cb2a .imu.e2a .imu.l21a -side left -in .imu.f2a -padx 2 -fill y
 
 label .imu.l3a -text "CDUZ:" -font ${font1}
 radiobutton .imu.rb3a -text "INC" -variable CDUZ_INC_DEC_FLAG -value "INC" -font ${font1}
 radiobutton .imu.rb31a -text "DEC" -variable CDUZ_INC_DEC_FLAG -value "DEC" -font ${font1}
 button .imu.b3a -text "Single" -command {imu_count "CDUZ"} -font ${font1}
 checkbutton .imu.cb3a -text "Loop" -variable CDUZ_COUNT_FLAG -relief raised -borderwidth 2 -anchor w -font ${font1} -onvalue "LOOP" -offvalue "SINGLE" -padx 2
 entry .imu.e3a -width 7 -relief groove -bd 2 -textvariable IMUZ_ANGLE -font ${font1}
 label .imu.l31a -text "°" -font ${font3}
 pack  .imu.l3a .imu.rb3a .imu.rb31a .imu.b3a .imu.cb3a .imu.e3a .imu.l31a -side left -in .imu.f3a -padx 2 -fill y
 
 label .imu.l4b -text "" -font ${font3}
 pack  .imu.l4b -side left -in .imu.f4a -anchor w
 label .imu.l5b -text "IMU PIPA VELOCITY:" -font ${font3}
 pack  .imu.l5b -side left -in .imu.f5a -anchor w
 
 label .imu.l6a -text "PIPAX:" -font ${font1}
 button .imu.b6a -text "Increase" -command {write_socket "PINC" 37} -font ${font1}
 button .imu.b61a -text "Decrease" -command {write_socket "MINC" 37} -font ${font1}
 pack  .imu.l6a .imu.b6a .imu.b61a -side left -in .imu.f6a -padx 2
 
 label .imu.l7a -text "PIPAY:" -font ${font1}
 button .imu.b7a -text "Increase" -command {write_socket "PINC" 40} -font ${font1}
 button .imu.b71a -text "Decrease" -command {write_socket "MINC" 40} -font ${font1}
 pack  .imu.l7a .imu.b7a .imu.b71a -side left -in .imu.f7a -padx 2
 
 label .imu.l8a -text "PIPAZ:" -font ${font1}
 button .imu.b8a -text "Increase" -command {write_socket "PINC" 41} -font ${font1}
 button .imu.b81a -text "Decrease" -command {write_socket "MINC" 41} -font ${font1}
 pack  .imu.l8a .imu.b8a .imu.b81a -side left -in .imu.f8a -padx 2

}
 

# *********************************************************************************************
# **** Function: IMU incrementation and decrementation (Single Shot and Loop)              ****
# *********************************************************************************************
proc imu_count {par0} {
 global CDUX_INC_DEC_FLAG CDUY_COUNT_FLAG CDUY_INC_DEC_FLAG CDUZ_COUNT_FLAG CDUZ_INC_DEC_FLAG CDUX_COUNT_FLAG
 global IMUX_ANGLE IMUY_ANGLE IMUZ_ANGLE ANGLE_INCR
 
 if {$CDUX_COUNT_FLAG == "LOOP" && $par0 == "LOOP"} {
  if {$CDUX_INC_DEC_FLAG == "INC"} {set IMUX_ANGLE [expr $IMUX_ANGLE + $ANGLE_INCR]; write_socket "PCDU" 32}
  if {$CDUX_INC_DEC_FLAG == "DEC"} {set IMUX_ANGLE [expr $IMUX_ANGLE - $ANGLE_INCR]; write_socket "MCDU" 32}
 } elseif {$par0 == "CDUX"} {
  if {$CDUX_INC_DEC_FLAG == "INC"} {set IMUX_ANGLE [expr $IMUX_ANGLE + $ANGLE_INCR]; write_socket "PCDU" 32}
  if {$CDUX_INC_DEC_FLAG == "DEC"} {set IMUX_ANGLE [expr $IMUX_ANGLE - $ANGLE_INCR]; write_socket "MCDU" 32}
 }
 
 if {$CDUY_COUNT_FLAG == "LOOP" && $par0 == "LOOP"} {
  if {$CDUY_INC_DEC_FLAG == "INC"} {set IMUY_ANGLE [expr $IMUY_ANGLE + $ANGLE_INCR]; write_socket "PCDU" 33}
  if {$CDUY_INC_DEC_FLAG == "DEC"} {set IMUY_ANGLE [expr $IMUY_ANGLE - $ANGLE_INCR]; write_socket "MCDU" 33}
 } elseif {$par0 == "CDUY"} {
  if {$CDUY_INC_DEC_FLAG == "INC"} {set IMUY_ANGLE [expr $IMUY_ANGLE + $ANGLE_INCR]; write_socket "PCDU" 33}
  if {$CDUY_INC_DEC_FLAG == "DEC"} {set IMUY_ANGLE [expr $IMUY_ANGLE - $ANGLE_INCR]; write_socket "MCDU" 33}
 }
 
 if {$CDUZ_COUNT_FLAG == "LOOP" && $par0 == "LOOP"} {
  if {$CDUZ_INC_DEC_FLAG == "INC"} {set IMUZ_ANGLE [expr $IMUZ_ANGLE + $ANGLE_INCR]; write_socket "PCDU" 34}
  if {$CDUZ_INC_DEC_FLAG == "DEC"} {set IMUZ_ANGLE [expr $IMUZ_ANGLE - $ANGLE_INCR]; write_socket "MCDU" 34}
 } elseif {$par0 == "CDUZ"} {
  if {$CDUZ_INC_DEC_FLAG == "INC"} {set IMUZ_ANGLE [expr $IMUZ_ANGLE + $ANGLE_INCR]; write_socket "PCDU" 34}
  if {$CDUZ_INC_DEC_FLAG == "DEC"} {set IMUZ_ANGLE [expr $IMUZ_ANGLE - $ANGLE_INCR]; write_socket "MCDU" 34}
 }
   
}
