# Copyright 2005 Stephan Hotto <stephan.hotto@web.de>
#
# This file is part of yaAGC.
#
# yaAGC is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# yaAGC is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with yaAGC; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# ********************************************************************************************
# **** Module:         AGC_Outputs.tcl                                                    ****
# **** Main Program:   lm_system_simulator                                                ****
# **** Author:         Stephan Hotto                                                      ****
# **** Date:           29.05.05                                                           ****
# **** Version:        v0.01                                                              ****
# ********************************************************************************************

# ********************************************************************************************
# **** Function:  Create AGC Outputs GUI                                                  ****
# ********************************************************************************************
proc create_lmsys {} {
 global bo font1 font2 font3

 if {[winfo exists .lmsys] == 1} {destroy .lmsys}

 toplevel .lmsys
 wm title .lmsys "AGC Outputs"
 wm geometry .lmsys +150+150
 wm geometry .lmsys 855x470
 wm minsize  .lmsys 855 470
 wm iconname .lmsys "AGC Outputs"
 
 frame .lmsys.fma; frame .lmsys.fmb; frame .lmsys.fmc; frame .lmsys.fmd;
 
 pack .lmsys.fma .lmsys.fmb .lmsys.fmc .lmsys.fmd -side left -anchor n -pady 1 -padx 15
 
 # --------------------- Checkbutton as Signal Indicator --------------------------
 # --------------------- 1st column -----------------------------------------------
 label .lmsys.l0a -text "DSKY:" -font ${font3}
 pack  .lmsys.l0a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb1a -text "COMPUTER ACTIVITY" -variable bo(11,2) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb1a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb2a -text "UPLINK ACTIVITY" -variable bo(11,3) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb2a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb3a -text "TEMPERATURE CAUTION" -variable bo(11,4) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb3a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb4a -text "KEYBOARD RELEASE" -variable bo(11,5) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb4a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb5a -text "FLASH VERB & NOUN" -variable bo(11,6) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb5a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb6a -text "OPERATOR ERROR" -variable bo(11,7) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb6a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb7a -text "TEST ALARMS,\nTEST DSKY LIGHTS" -variable bo(13,10) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb7a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb8a -text "ISS Warning" -variable bo(11,1) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb8a -side top -in .lmsys.fma -anchor w
 
 label .lmsys.l81a -text "" -font ${font1}
 pack  .lmsys.l81a -side top -in .lmsys.fma -anchor w
 
 label .lmsys.l9a -text "COMMON:" -font ${font3}
 pack  .lmsys.l9a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb10a -text "TEST CONNECTOR OUTBIT" -variable bo(11,9) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb10a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb11a -text "CAUTION RESET" -variable bo(11,10) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb11a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb12a -text "ENABLE STANDBY" -variable bo(13,11) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb12a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb13a -text "RESET TRAP 31-A" -variable bo(13,12) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb13a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb14a -text "RESET TRAP 31-B" -variable bo(13,13) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb14a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb15a -text "RESET TRAP 32" -variable bo(13,14) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb15a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb16a -text "ENABLE T6 RUPT" -variable bo(13,15) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb16a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb17a -text "ISS TURN ON\nDELAY COMPLETE" -variable bo(12,15) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb17a -side top -in .lmsys.fma -anchor w
 
 checkbutton .lmsys.cb18a -text "DOWNLINK TELEMETRY\nWORD ORDER CODE BIT" -variable bo(13,7) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb18a -side top -in .lmsys.fma -anchor w
  
 # --------------------- 2nd column --------------------------------------------- 
 label .lmsys.l0b -text "Engine (DESCENT/ASCENT):" -font ${font3}
 pack  .lmsys.l0b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb1b -text "ENGINE ON" -variable bo(11,13) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb1b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb2b -text "ENGINE OFF" -variable bo(11,14) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb2b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb3b -text "-PITCH GIMBAL TRIM" -variable bo(12,9) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb3b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb4b -text "+PITCH GIMBAL TRIM" -variable bo(12,10) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb4b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb5b -text "-ROLL GIMBAL TRIM" -variable bo(12,11) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb5b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb6b -text "+ROLL GIMBAL TRIM" -variable bo(12,12) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb6b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb7b -text "THRUST DRIVE ACTIVITY\nFOR DESCENT ENGINE" -variable bo(14,4) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb7b -side top -in .lmsys.fmb -anchor w
 
 label .lmsys.l71b -text "" -font ${font1}
 pack  .lmsys.l71b -side top -in .lmsys.fmb -anchor w
 
 label .lmsys.l8b -text "PITCH RCS JET CONTROL:" -font ${font3} -justify left
 pack  .lmsys.l8b -side top -in .lmsys.fmb -anchor w
 
 frame .lmsys.f1b
 pack  .lmsys.f1b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb9b -text "J1" -variable bo(5,1) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb9b -side left -in .lmsys.f1b -anchor w
 
 checkbutton .lmsys.cb10b -text "J2" -variable bo(5,2) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb10b -side left -in .lmsys.f1b -anchor w -padx 2
 
 checkbutton .lmsys.cb11b -text "J3" -variable bo(5,3) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb11b -side left -in .lmsys.f1b -anchor w -padx 2
 
 checkbutton .lmsys.cb12b -text "J4" -variable bo(5,4) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb12b -side left -in .lmsys.f1b -anchor w -padx 2
 
 frame .lmsys.f2b
 pack  .lmsys.f2b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb13b -text "J5" -variable bo(5,5) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb13b -side left -in .lmsys.f2b -anchor w
 
 checkbutton .lmsys.cb14b -text "J6" -variable bo(5,6) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb14b -side left -in .lmsys.f2b -anchor w -padx 2
 
 checkbutton .lmsys.cb15b -text "J7" -variable bo(5,7) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb15b -side left -in .lmsys.f2b -anchor w -padx 2
 
 checkbutton .lmsys.cb16b -text "J8" -variable bo(5,8) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb16b -side left -in .lmsys.f2b -anchor w -padx 2
 
 label .lmsys.l161b -text "" -font ${font1}
 pack  .lmsys.l161b -side top -in .lmsys.fmb -anchor w
 
 label .lmsys.l17b -text "ROLL RCS JET CONTROL:" -font ${font3} -justify left
 pack  .lmsys.l17b -side top -in .lmsys.fmb -anchor w
 
 frame .lmsys.f3b
 pack  .lmsys.f3b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb18b -text "J1" -variable bo(6,1) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb18b -side left -in .lmsys.f3b -anchor w
 
 checkbutton .lmsys.cb19b -text "J2" -variable bo(6,2) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb19b -side left -in .lmsys.f3b -anchor w -padx 2
 
 checkbutton .lmsys.cb20b -text "J3" -variable bo(6,3) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb20b -side left -in .lmsys.f3b -anchor w -padx 2
 
 checkbutton .lmsys.cb21b -text "J4" -variable bo(6,4) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb21b -side left -in .lmsys.f3b -anchor w -padx 2
 
 frame .lmsys.f4b
 pack  .lmsys.f4b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb22b -text "J5" -variable bo(6,5) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb22b -side left -in .lmsys.f4b -anchor w
 
 checkbutton .lmsys.cb23b -text "J6" -variable bo(6,6) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb23b -side left -in .lmsys.f4b -anchor w -padx 2
 
 checkbutton .lmsys.cb24b -text "J7" -variable bo(6,7) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb24b -side left -in .lmsys.f4b -anchor w -padx 2
 
 checkbutton .lmsys.cb25b -text "J8" -variable bo(6,8) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb25b -side left -in .lmsys.f4b -anchor w -padx 2
 
 label .lmsys.l251b -text "" -font ${font1}
 pack  .lmsys.l251b -side top -in .lmsys.fmb -anchor w
 
 label .lmsys.26b -text "HAND CONTROLLER:" -font ${font3} -justify left
 pack  .lmsys.26b -side top -in .lmsys.fmb -anchor w
 
 checkbutton .lmsys.cb27b -text "RHC COUNTER ENABLE\nREAD ANGLES" -variable bo(13,8) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb27b -side top -in .lmsys.fmb -anchor w
 
  checkbutton .lmsys.cb28b -text "START RHC READ INTO\nCOUNTERS" -variable bo(13,9) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb28b -side top -in .lmsys.fmb -anchor w
 
 # --------------------- 3rd column ---------------------------------------------
 label .lmsys.l0c -text "CDU:" -font ${font3} -justify left
 pack  .lmsys.l0c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb1c -text "ZERO RRADAR CDU" -variable bo(12,1) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb1c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb2c -text "ENABLE CDU RADAR\nERROR COUNTER" -variable bo(12,2) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb2c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb3c -text "ZERO IMU CDU" -variable bo(12,5) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb3c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb4c -text "ENABLE CDU IMU\nERROR COUNTER" -variable bo(12,6) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb4c -side top -in .lmsys.fmc -anchor w
  
 checkbutton .lmsys.cb41c -text "DRIVE CDU S" -variable bo(14,11) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb41c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb42c -text "DRIVE CDU T" -variable bo(14,12) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb42c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb43c -text "DRIVE CDU Z" -variable bo(14,13) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb43c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb44c -text "DRIVE CDU Y" -variable bo(14,14) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb44c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb45c -text "DRIVE CDU X" -variable bo(14,15) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb45c -side top -in .lmsys.fmc -anchor w
 
 label .lmsys.l41c -text "" -font ${font1}
 pack  .lmsys.l41c -side top -in .lmsys.fmc -anchor w
 
 label .lmsys.l5c -text "IMU:" -font ${font3} -justify left
 pack  .lmsys.l5c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb6c -text "COARSE ALIGN\nENABLE OF IMU" -variable bo(12,4) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb6c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb7c -text "DISPLAY INERTIAL DATA" -variable bo(12,8) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb7c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb8c -text "GYRO ENABLE POWER\nFOR PULSES" -variable bo(14,6) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb8c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb9c -text "GYRO SELECT B" -variable bo(14,7) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb9c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb10c -text "GYRO SELECT A" -variable bo(14,8) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb10c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb11c -text "GYRO TORQUING COMMAND\nIN NEGATIVE DIRECTION" -variable bo(14,9) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb11c -side top -in .lmsys.fmc -anchor w
 
 checkbutton .lmsys.cb12c -text "GYRO ACTIVITY" -variable bo(14,10) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb12c -side top -in .lmsys.fmc -anchor w
 
 # --------------------- 4th column ---------------------------------------------
 label .lmsys.l0d -text "RADAR:" -font ${font3}
 pack  .lmsys.l0d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb1d -text "LR POSITION 2 COMMAND" -variable bo(12,13) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb1d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb2d -text "ENABLE RENDEZVOUS RADAR\nLOCK-ON; AUTO ANGLE TRACK'G" -variable bo(12,14) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb2d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb3d -text "RADAR C" -variable bo(13,1) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb3d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb4d -text "RADAR B" -variable bo(13,2) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb4d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb5d -text "RADAR A" -variable bo(13,3) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb5d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb6d -text "RADAR ACTIVITY" -variable bo(13,4) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb6d -side top -in .lmsys.fmd -anchor w
 
 label .lmsys.l61d -text "" -font ${font1}
 pack  .lmsys.l61d -side top -in .lmsys.fmd -anchor w
 
 label .lmsys.l7d -text "ALTITUDE:" -font ${font3}
 pack  .lmsys.l7d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb8d -text "ALTITUDE RATE OR\nALTITUDE SELECTOR" -variable bo(14,2) -relief flat -font ${font1} -onvalue 1 -offvalue 0 -justify left
 pack .lmsys.cb8d -side top -in .lmsys.fmd -anchor w
 
 checkbutton .lmsys.cb9d -text "ALTITUDE METER ACTIVITY" -variable bo(14,3) -relief flat -font ${font1} -onvalue 1 -offvalue 0
 pack .lmsys.cb9d -side top -in .lmsys.fmd -anchor w
 
}
 