//I05MACUP JOB 1,'I05MACUP HASP 4',MSGLEVEL=(1,1),CLASS=A,MSGCLASS=A
//*********************************************************************
//*                                                                 ***
//*    Job:      I05MACUP                                           ***
//*    Product:  HASP V4 for MVT.                                   ***
//*    Purpose:  Update MVT sysgen macros in SYS1.GENLIB and        ***
//*              SYS1.MODGEN to add HASP support.                   ***
//*    Update:   2006/08/28                                         ***
//*                                                                 ***
//*    Note:     Did not run this job on ASP system, usermods       ***
//*              THAS801 and THAS810 install this support.          ***
//*                                                                 ***
//*    Note:     The IOS source IEAASU00 must be reassembled,       ***
//*              the nucleus relinked, and the system re-IPLed,     ***
//*              after IECXCP and IECIOS are modified.              ***
//*                                                                 ***
//*********************************************************************
//*
/*JOBPARM LINES=9999
//*
//*-----------------------------------------------------------------***
//*    Use IEBDG to build IEBUPDTE control statements.              ***
//*-----------------------------------------------------------------***
//IEBDG   EXEC PGM=IEBDG,COND=(0,NE),REGION=128K
//SYSPRINT  DD SYSOUT=A
//CIECIOS   DD DSN=&&CIOS,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE) 
//CIECIUCB  DD DSN=&&CIUCB,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//CIECXCP   DD DSN=&&CXCP,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//CIODEV    DD DSN=&&CIODEV,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//CGGBLPAK  DD DSN=&&CGBLPAK,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//CGIEC202  DD DSN=&&CIEC202,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//CGPAK248  DD DSN=&&CPAK248,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//CGPAK768  DD DSN=&&CPAK768,DISP=(NEW,PASS),UNIT=SYSDA,
//             DCB=SYS1.HASPSUP,SPACE=(TRK,(5,5),RLSE)
//SYSIN     DD *
  DSD OUTPUT=(CIECIOS)
    FD NAME=KOP,STARTLOC=1,LENGTH=15,PICTURE=15,'./ CHANGE NAME='
    FD NAME=KIOS,STARTLOC=16,LENGTH=8,PICTURE=8,'IECIOS  '
    CREATE NAME=(KOP,KIOS),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CIECIUCB)
    FD NAME=KIUCB,STARTLOC=16,LENGTH=8,PICTURE=8,'IECIUCB '
    CREATE NAME=(KOP,KIUCB),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CIECXCP)
    FD NAME=KXCP,STARTLOC=16,LENGTH=8,PICTURE=8,'IECXCP  '
    CREATE NAME=(KOP,KXCP),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CIODEV)
    FD NAME=NKIODEV,STARTLOC=16,LENGTH=8,PICTURE=8,'IODEVICE'
    CREATE NAME=(KOP,NKIODEV),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CGGBLPAK)
    FD NAME=KGBLPAK,STARTLOC=16,LENGTH=8,PICTURE=8,'SGGBLPAK'
    CREATE NAME=(KOP,KGBLPAK),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CGIEC202)
    FD NAME=KC202,STARTLOC=16,LENGTH=8,PICTURE=8,'SGIEC202'
    CREATE NAME=(KOP,KC202),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CGPAK248)
    FD NAME=KPAK248,STARTLOC=16,LENGTH=8,PICTURE=8,'SGPAK248'
    CREATE NAME=(KOP,KPAK248),QUANTITY=1,FILL=X'40'
  END
  DSD OUTPUT=(CGPAK768)
    FD NAME=KPAK768,STARTLOC=16,LENGTH=8,PICTURE=8,'SGPAK768'
    CREATE NAME=(KOP,KPAK768),QUANTITY=1,FILL=X'40'
  END
//*
//*-----------------------------------------------------------------***
//*    Update IODEVICE, SGGBLPAK, SGIEC202, SGPAK248 and SGPAK768   ***
//*    macros in SYS1.GENLIB.                                       ***
//*-----------------------------------------------------------------***
//GENLIB   EXEC PGM=IEBGENER,REGION=96K,COND=(0,NE)
//SYSPRINT  DD SYSOUT=A
//SYSUT2    DD SYSOUT=A,DCB=BLKSIZE=80
//SYSIN     DD DUMMY
//SYSUT1    DD DISP=(OLD,DELETE),DSN=&&CIODEV,DCB=SYS1.HASPSUP
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IODEVICE)
//          DD DISP=(OLD,DELETE),DSN=&&CGBLPAK
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGGBLPAK)
//          DD DISP=(OLD,DELETE),DSN=&&CIEC202
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGIEC202)
//          DD DISP=(OLD,DELETE),DSN=&&CPAK248
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGPAK248)
//          DD DISP=(OLD,DELETE),DSN=&&CPAK768
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGPAK768)
//*
//*-----------------------------------------------------------------***
//*    Update IECIOS, IECIUCB and IECXCP macros in SYS1.MODGEN.     ***
//*-----------------------------------------------------------------***
//MODGEN   EXEC PGM=IEBGENER,REGION=96K,COND=(0,NE)
//SYSPRINT  DD SYSOUT=A
//SYSUT2    DD SYSOUT=A,DCB=BLKSIZE=80
//SYSIN     DD DUMMY
//SYSUT1    DD DISP=(OLD,DELETE),DSN=&&CIOS,DCB=SYS1.HASPSUP
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IECIOS)
//          DD DISP=(OLD,DELETE),DSN=&&CIUCB
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IECIUCB)
//          DD DISP=(OLD,DELETE),DSN=&&CXCP
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IECXCP)
//
//*
//*-----------------------------------------------------------------***
//*    Update IODEVICE, SGGBLPAK, SGIEC202, SGPAK248 and SGPAK768   ***
//*    macros in SYS1.GENLIB.                                       ***
//*-----------------------------------------------------------------***
//GENLIB   EXEC PGM=IEBUPDTE,PARM=MOD,REGION=96K,COND=(0,NE)
//SYSPRINT  DD SYSOUT=A
//SYSUT1    DD DISP=OLD,DSN=SYS1.GENLIB
//SYSUT2    DD DISP=OLD,DSN=SYS1.GENLIB
//SYSIN     DD DISP=(OLD,DELETE),DSN=&&CIODEV,DCB=SYS1.HASPSUP
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IODEVICE)
//          DD DISP=(OLD,DELETE),DSN=&&CGBLPAK
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGGBLPAK)
//          DD DISP=(OLD,DELETE),DSN=&&CIEC202
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGIEC202)
//          DD DISP=(OLD,DELETE),DSN=&&CPAK248
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGPAK248)
//          DD DISP=(OLD,DELETE),DSN=&&CPAK768
//          DD DISP=SHR,DSN=SYS1.HASPSUP(SGPAK768)
//*
//*-----------------------------------------------------------------***
//*    Update IECIOS, IECIUCB and IECXCP macros in SYS1.MODGEN.     ***
//*-----------------------------------------------------------------***
//MODGEN   EXEC PGM=IEBUPDTE,PARM=MOD,REGION=96K,COND=(0,NE)
//SYSPRINT  DD SYSOUT=A
//SYSUT1    DD DISP=OLD,DSN=SYS1.MODGEN
//SYSUT2    DD DISP=OLD,DSN=SYS1.MODGEN
//SYSIN     DD DISP=(OLD,DELETE),DSN=&&CIOS,DCB=SYS1.HASPSUP
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IECIOS)
//          DD DISP=(OLD,DELETE),DSN=&&CIUCB
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IECIUCB)
//          DD DISP=(OLD,DELETE),DSN=&&CXCP
//          DD DISP=SHR,DSN=SYS1.HASPSUP(IECXCP)
//
/*EOF
