//SY20ZR26 JOB 1,TIMETEST,CLASS=A,MSGLEVEL=(1,1),REGION=512K
//*
//* 2006/07/15 @kl interval timer test
//*
//STEP1 EXEC PGM=IEUASM,PARM=(DECK,NOLOAD),REGION=300K
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB
//SYSUT1   DD UNIT=SYSDA,SPACE=(CYL,(10,2)),VOL=SER=WORK00
//SYSUT2   DD UNIT=SYSDA,SPACE=(CYL,(10,2)),VOL=SER=WORK00
//SYSUT3   DD UNIT=SYSDA,SPACE=(CYL,(10,2)),VOL=SER=WORK00
//SYSPRINT DD SYSOUT=A
//SYSPUNCH DD DSN=&&LOADSET,DISP=(,PASS),VOL=SER=WORK00,
//            UNIT=SYSDA,SPACE=(CYL,(10,2)),
//            DCB=(RECFM=FB,LRECL=80,BLKSIZE=800)
//SYSIN    DD *
KLTEST1  CSECT ,
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         SPACE 1
INIT     DS    0H                  INITIALIZATION
         SAVE  (14,12),,*          SAVE CALLER'S REGISTERS
         LR    R12,R15             SET BASE REGISTER
         USING KLTEST1,R12         ADDRESSABILITY FOR PROGRAM
         SPACE 1
*---------------------------------------------------------------------*
*        INITIALIZE ECBS TO ZERO.
*---------------------------------------------------------------------*
         XC    TECB,TECB           CLEAR TIMER ECB
         XC    WECB,WECB           CLEAR WTOR ECB
         SPACE 1
*---------------------------------------------------------------------*
*        Build the message displaying timer interval.
*---------------------------------------------------------------------*
         MVC   M4HH(2),INTERVAL+0  Set hours in message
         MVC   M4MM(2),INTERVAL+2  Set minutes in message
         MVC   M4SS(2),INTERVAL+4  Set seconds in message
         MVC   M4TH(2),INTERVAL+6  Set thousandths in message
         OI    M4TH+1,X'F0'        Force printable sign
         SPACE 1
*---------------------------------------------------------------------*
*        SET THE TIMER.
*---------------------------------------------------------------------*
         STIMER REAL,TIMEEXIT,DINTVL=INTERVAL
         SPACE 1
*---------------------------------------------------------------------*
*        Display the timer interval.
*---------------------------------------------------------------------*
         WTO   MF=(E,MSG4)         Display timer interval
         SPACE 1
*---------------------------------------------------------------------*
*        ISSUE WTOR.
*---------------------------------------------------------------------*
         WTOR  'TST999A WAITING',REPLY,L'REPLY,WECB,ROUTCDE=2
         SPACE 1
*---------------------------------------------------------------------*
*        WAIT FOR SOMETHING TO HAPPEN.
*---------------------------------------------------------------------*
         WAIT  ECBLIST=ECBLIST     WAIT
         SPACE 1
*---------------------------------------------------------------------*
*        CANCEL ANY REMAINING TIME INTERVAL
*---------------------------------------------------------------------*
         TTIMER CANCEL             CANCEL TIMER
         SPACE 1
*---------------------------------------------------------------------*
*        SAY HOW MUCH REMAINED IN TIMER INTERVAL.
*---------------------------------------------------------------------*
         SRDL  R0,32               TIME IN R0/R1
         D     R0,=F'26042'        DIVIDE BY TIMER UNITS
*          R1 CONTAINS SECONDS, R0 REMAINDER
         CVD   R1,DWORK            CONVERT SECONDS TO PACKED
         OI    DWORK+7,X'0F'       FORCE PRINTABLE SIGN
         UNPK  OUTSEC(8),DWORK     UNPACK INTO MESSAGE
         CVD   R0,DWORK            CONVERT FRACTION TO PACKED
         OI    DWORK+7,X'0F'       FORCE PRINTABLE SIGN
         UNPK  OUTFRAC(8),DWORK    UNPACK INTO MESSAGE
         WTO   MF=(E,MSG3)         SAY "TIME REMAINING"
         SPACE 1
*---------------------------------------------------------------------*
*        DETERMINE WHAT CAUSED US TO GET HERE.
*---------------------------------------------------------------------*
         TM    WECB,X'40'          WAS WTOR ECB POSTED?
         BZ    CHECKT              Check timer ECB if not
         SPACE 1
*---------------------------------------------------------------------*
*        SAY WTOR ECB WAS POSTED.
*---------------------------------------------------------------------*
WPOSTED  DS    0H                  WTOR ECB POSTED
         WTO   'TST901I WTOR ECB WAS POSTED',ROUTCDE=2
         SPACE 1
*---------------------------------------------------------------------*
*        Check if timer ECB was posted.
*---------------------------------------------------------------------*
CHECKT   DS    0H
         TM    TECB,X'40'          WAS TIMER ECB POSTED?
         BO    TPOSTED             BRANCH IF SO
*        WTO   'TST904I NO ECBS WERE POSTED',ROUTCDE=2
         B     RETURN              GO TO EXIT
         SPACE 1
*---------------------------------------------------------------------*
*        SAY TIMER ECB WAS POSTED.
*---------------------------------------------------------------------*
TPOSTED  DS    0H                  TIMER ECB POSTED
         WTO   'TST902I TIMER ECB WAS POSTED',ROUTCDE=2
         B     RETURN              GO TO EXIT
         SPACE 1
*---------------------------------------------------------------------*
*        RETURN TO SYSTEM.
*---------------------------------------------------------------------*
RETURN   DS    0H
         RETURN (14,12),RC=0       RETURN TO CALLER
DWORK    DS    D                   DOUBLEWORK WORK AREA
         DS    0D
INTERVAL DC    Z'00000500'         TIMER INTERVAL - 5 seconds
*                HHMMSSTH
ECBLIST  DS    0F                  ECB LIST
         DC    A(WECB)             -- ADDRESS OF WTOR ECB
         DC    XL1'80'             -- VL BIT
         DC    AL3(TECB)           -- ADDRESS OF TIMER ECB
WECB     DS    F                   ECB FOR WTOR
TECB     DS    F                   ECB FOR TIMER
REPLY    DC    CL1' '              WTOR REPLY
MSG4     WTO   'TST904I TIMER INTERVAL SET TO XX:XX:XX.XX',            +
               ROUTCDE=2,MF=L
*               0123456789012345678901234567890123456789012345678901234
M4INT    EQU   MSG4+4+30           SECONDS IN MESSAGE
M4HH     EQU   MSG4+4+30           Hours in message
M4MM     EQU   MSG4+4+33           Minutes in message
M4SS     EQU   MSG4+4+36           Seconds in message
M4TH     EQU   MSG4+4+39           Thousandths in message
MSG3     WTO   'TST903I REMAINING SECONDS=XXXXXXXX FRACTION=XXXXXXXX', +
               ROUTCDE=2,MF=L
*               0123456789012345678901234567890123456789012345678901234
OUTSEC   EQU   MSG3+4+26           SECONDS IN MESSAGE
OUTFRAC  EQU   MSG3+4+44           FRACTION IN MESSAGE
         SPACE 1
         DROP  R12                 END ALL ADDRESSABILITY
         SPACE 1
TIMEEXIT DS    0H                  STIMER EXIT
*        STIMER EXIT ROUTINE
         USING *,R15               BASE REG FOR EXIT ROUTINE
         STM   R14,R12,12(R13)     SAVE CALLER'S REGISTERS
         L     R12,AMAIN           RESTORE MAIN PROGRAM BASE
         DROP  R15                 END TEMPORARY ADDRESSABILITY
         USING KLTEST1,R12         MAIN PROGRAM ADDRESSABILITY
         POST  TECB                GO POST THE TIMER ECB
         WTO   'TST900I TIMER POPPED',ROUTCDE=2
         LM    R14,R12,12(R13)     RESTORE CALLER'S REGISTERS
         BR    R14                 RETURN
         SPACE 1
AMAIN    DC    A(KLTEST1)          MAIN PROGRAM BASE REGISTER
         END   ,
//*
//LKED   EXEC PGM=IEWL,COND=(8,LT),REGION=200K,
//            PARM='NCAL,LET,LIST,XREF,RENT,SIZE=(128K,18K)'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD UNIT=SYSDA,SPACE=(CYL,(10,2)),DSN=&SYSUT1
//SYSLMOD  DD DSN=&&GOSET(GO),DISP=(,PASS),VOL=SER=WORK00,
//            UNIT=SYSDA,SPACE=(TRK,(5,2,1))
//SYSLIN   DD DSN=&&LOADSET,DISP=(OLD,DELETE)
//*
//GO     EXEC PGM=*.LKED.SYSLMOD,COND=(0,NE)
//SYSABEND DD SYSOUT=A
//
BACK DS 0H
 TTIMER
         SRDL  R0,32               TIME IN R0/R1
         D     R0,=F'26042'        DIVIDE BY TIMER UNITS
*          R1 CONTAINS SECONDS, R0 REMAINDER
         CVD   R1,DWORK            CONVERT SECONDS TO PACKED
         OI    DWORK+7,X'0F'       FORCE PRINTABLE SIGN
         UNPK  OUTSEC(8),DWORK     UNPACK INTO MESSAGE
         CVD   R0,DWORK            CONVERT FRACTION TO PACKED
         OI    DWORK+7,X'0F'       FORCE PRINTABLE SIGN
         UNPK  OUTFRAC(8),DWORK    UNPACK INTO MESSAGE
         WTO   MF=(E,MSG3)         SAY "TIME REMAINING"
 CLI WECB,X'40' WTOR ECB POSTED?
 BNE BACK       NO
