//SY20ZR05 JOB 1,CATPTPCH,REGION=128K,CLASS=A,MSGCLASS=A
//ASM1   EXEC PGM=IFOX00,PARM=(NOLOAD,DECK),REGION=768K
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSALLDA,SPACE=(1700,(600,100))
//SYSUT2   DD DSN=&&SYSUT2,UNIT=SYSALLDA,SPACE=(1700,(600,100))
//SYSUT3   DD DSN=&&SYSUT3,UNIT=SYSALLDA,SPACE=(1700,(600,100))
//SYSPRINT DD SYSOUT=*
//SYSPUNCH DD DSN=&&OBJSET,UNIT=SYSDA,SPACE=(80,(200,50)),
//            DISP=(MOD,PASS)
//SYSGO    DD DUMMY
//SYSLIN   DD DUMMY
//SYSIN    DD *
         MACRO
&NAME    CTLG  &REQ,&ADDR .
         GBLC  &CTLGNAM .
.* SEE 'CTLGACCS' FOR DOCUMENTATION ON THIS MACRO
.*  AUTHOR         DARRELL D. WILCOX
.*  INSTALLATION   KING COUNTY SYSTEMS SERVICES
.*                 ROOM E-208 KING COUNTY COURTHOUSE
.*                 THIRD AT JAMES STREETS
.*                 SEATTLE, WA  98104
.*  IF MODIFICATIONS OR CORRECTIONS ARE MADE, I WOULD GREATLY
.*       APPRECIATE GETTING A COPY OF THEM.
         AIF   ('&REQ' EQ 'GET').GET
         AIF   ('&REQ' EQ 'GETBYTTR').GETBTTR
         AIF   ('&REQ' EQ 'OPEN').OPEN
         AIF   ('&REQ' EQ 'OPENWKEY').OPENKEY
         AIF   ('&REQ' EQ 'CLOSE').CLOSE
         MNOTE *,' '
         MNOTE *,' '
         MNOTE 8,'INVALID REQUEST TYPE - MUST BE OPEN, OPENWKEY, GET, GX
               ETBYTTR, OR CLOSE'
         MNOTE *,' '
         MNOTE *,' '
         MEXIT
.OPEN    ANOP
&NAME    LA    0,1 .                    SET R0='OPEN REQ.' CODE
         AGO   .DONE .
.OPENKEY ANOP
&NAME    LA    0,2 .                    SET R0='OPENWKEY REQ.' CODE
         AGO   .DONE .
.GET     ANOP
&NAME    LA    0,3 .                    SET R0='GET REQ.' CODE
         AGO   .FINISH .
.GETBTTR ANOP
&NAME    LA    0,4 .                    SET R0='GETBYTTR REQ.' CODE
         AGO   .DONE .
.CLOSE   ANOP
&NAME    LA    0,5 .                    SET R0='CLOSE REQ.' CODE
         AGO   .FINISH .
.DONE    ANOP
         AIF   ('&ADDR' EQ '').ASSUME
         AIF   ('&ADDR'(1,1) NE '(').NOREG
         AIF   ('&ADDR' EQ '(1)').FINISH
         LR    1,&ADDR(1) .                 PUT ADDRESS INTO REGISTER 1
         AGO   .FINISH .
.ASSUME  ANOP
         MNOTE 4,'ADDRESS NOT CODED;  ASSUMED IN REGISTER ONE'
         AGO   .FINISH .
.NOREG   ANOP
         LA    1,&ADDR .                LOAD ADDRESS INTO REGISTER 1
.FINISH  ANOP
         AIF   ('&CTLGNAM' NE '').GOTNAME
&CTLGNAM SETC  'CTLG&SYSNDX' .
         CNOP  2,4 .                    ALIGN HALF-AND-NOT-FULL WORD
         LA    14,*+22 .                LOAD RETURN ADDRESS
&CTLGNAM L     15,*+14 .                LOAD MODULE ENTRY POINT ADDRESS
         LTR   15,15 .                  WAS MODULE INCLUDED/Q
         BCR   7,15 .                   BRANCH TO MODULE IF INCLUDED
         LA    15,40 .                  SET RETURN CODE TO NOT INCLUDED
         BR    14 .                     RETURN TO USER
         DC    V(CTLGACCS) .            MODULE ENTRY POINT ADDRESS
         MEXIT
.GOTNAME ANOP
         BAL   14,&CTLGNAM .            GO TO COMMON CODE FOR ACCESS
         MEND
         MACRO
         CATPTPCH &SYSTEM=360 .
         AIF   ('&SYSTEM' EQ '360' OR '&SYSTEM' EQ '370').SYSOK
         MNOTE 8,'SYSTEM=&SYSTEM INCORRECT - MUST BE 360 OR 370'
         MEXIT
.SYSOK   ANOP
CATP TITLE 'CATPTPCH - CATALOG PRINT AND/OR PUNCH PROGRAM'
         MNOTE *,'THIS GENERATION HAS SYSTEM=&SYSTEM'
*****                                                             *****
*  THIS PROGRAM WILL PRINT AND/OR PUNCH THE INDEXES,ALIASES,CVOL      *
*  POINTERS,AND DATA SETS IN ANY ONE SYSCATLG DATA SET. PUNCHING      *
*  IS IN THE FORM OF CONTROL CARDS FOR IEHPROGM TO RECONSTRUCT THE    *
*  CATALOG OR TO REORGANIZE IT. LISTING ALSO INCLUDES SOME STATIS-    *
*  TICAL INFORMATION ABOUT THE CATALOG.                               *
*****                                                             *****
*
*   AUTHOR         DARRELL D. WILCOX
*   INSTALLATION   KING COUNTY SYSTEMS SERVICES
*                  ROOM E-208 KING COUNTY COURTHOUSE
*                  THIRD AT JAMES STREETS
*                  SEATTLE, WA  98104
*   IF MODIFICATIONS OR CORRECTIONS ARE MADE, I WOULD GREATLY
*        APPRECIATE GETTING A COPY OF THEM.
*
*  DATE OF LATEST REVISION -
*
*        9/19/74 - R001      ADDED MORE 370 INSTRUCTIONS, IMPROVED
*                            DD ENTRY LOOKUP CODE, AND CHANGED THE
*                            'BLOCKS IN USE' AND 'BLOCKS FREE' CODE TO
*                            COUNT INSTEAD OF ESTIMATE SAME.
*        9/20/74 - R002      CHANGED PRINT LINE WIDTH TO 80 COLUMNS SO
*                            THAT CHEAPER PAPER COULD BE USED, MADE
*                            MINOR CODE IMPROVEMENTS, AND CAUSED ERROR
*                            MESSAGES TO PRINT ON A NEW PAGE.
*        10/31/74 - R003     ADDED PARM FIELD LINE COUNT .  CODE
*                            'LC=NNN' IN THE PARM FIELD TO CHANGE THE
*                            NUMBER OF LINES WRITTEN PER PAGE.   NNN
*                            MUST BE GREATER THAN 10, OR 10 IS USED.
*
*
CATPTPCH CSECT
R00      EQU   0 .
R01      EQU   1 .
R02      EQU   2 .
R03      EQU   3 .
R04      EQU   4 .
R05      EQU   5 .
R06      EQU   6 .
R12      EQU   12 .
R13      EQU   13 .
R14      EQU   14 .
R15      EQU   15 .
*
* SYMBOLIC REGISTER NOTATIONS(SPECIAL)
*
RETURNR  EQU   7 .  *RETURN ADDRESS LINKAGE REGISTER
INDEXPTR EQU   8 .  *BLOCK AREA INDEX POINTER
PCHPTR   EQU   9 .  *PUNCH LINE INDEX
QUEUEPTR EQU   10 . *QUEUE TABLE INDEX
BLKPTR   EQU   11 . *DATA BLOCK ADDRESS
*
SPACE2   EQU   C'0' .
SPACE3   EQU   C'-' .
SKPTOCH1 EQU   C'1' .
DCBBUFCB EQU   21 .
DCBDDNAM EQU   40 .
DCBOFLGS EQU   48 .
DCBBLKSI EQU   62 .
DCBLRECL EQU   82 .
DASD     EQU   X'20' .
SORTSEQ1 EQU   C'1' .
SORTSEQ2 EQU   C'2' .
SORTSEQ3 EQU   C'3' .
SORTSEQ4 EQU   C'4' .
SORTSEQ5 EQU   C'5' .
PRINTBIT EQU   X'80' .
PUNCHBIT EQU   X'40' .
CATLGBIT EQU   X'20' .
NOHITBIT EQU   X'10' .
VCBBIT   EQU   X'08' .
XFF      EQU   X'FF' .
* USING STATEMENTS FOR DSECTS
*
         USING ENTDSECT,INDEXPTR .
         USING QELEMENT,QUEUEPTR .
         USING VOLINFO,R03 .
*
         EJECT
         B     72(,R15) .                   *BRANCH AROUND SAVE AREA
         DS    17F .                        *REGISTER SAVE AREA
         STM   R14,R12,12(R13) .            *SAVE REGISTERS
         ST    R13,4(,R15) .                *SAVE REG 13
         ST    R15,8(,R13) .                *BACK-CHAIN
         LR    R13,R15 .                    *LOAD BASE AND SAVE REG
         LA    R12,2048(,R13) .             *ESTABLISH REGISTER AS
         LA    R12,2048(,R12) .             *  A SECOND BASE REGISTER
         USING CATPTPCH,R13,R12 .
         L     R01,0(,R01) .                *LOAD A(PARM FIELD)    R003
         LH    R15,0(,R01) .                *LOAD L'PARM FIELD     R003
         LTR   R15,R15 .                    *NO PARM AT ALL/Q      R003
         BZ    NOPARM .                     *BRANCH IF NO PARM     R003
         SH    R15,=H'3' .                  *MINUS L'C'LC='        R003
         BNP   PARMERR .                    *BRANCH IF WRONG LENGTHR003
         CH    R15,=H'3' .                  *THREE OR FEWER LEFT/Q R003
         BH    PARMERR .                    *TOO MANY LEFT         R003
         CLC   =C'LC=',2(R01) .             *IS THIS A LINE COUNT/QR003
         BNE   PARMERR .                    *BRANCH IF NOT         R003
         MVI   MAXLINES+1,C'0' .            *RESET MAXLINES=0      R003
         LA    R02,MAXLINES+L'MAXLINES-1 .  *A(FIRST OUTPUT DIGIT) R003
NNNLOOP  EQU   * .                          *                      R003
         LA    R14,4(R01,R15) .             *A(LAST N, LAST-1 N, ..R003
         CLI   0(R14),C'0' .                *BELOW ZERO/Q          R003
         BL    PARMERR .                    *TOO LOW               R003
         CLI   0(R14),C'9' .                *ABOVE NINE/Q          R003
         BH    PARMERR .                    *TOO HIGH              R003
         MVC   0(1,R02),0(R14) .            *MOVE ONE DIGIT        R003
         BCTR  R02,0 .                      *BACK UP ONE BYTE      R003
         BCT   R15,NNNLOOP .                *DO UP TO THREE DIGITS R003
NOPARM   EQU   * .                                                 R003
         PACK  MAXLINES,MAXLINES .          *PACK FOR USE LETER    R003
         CP    MAXLINES,=P'10' .            *AT LEAST MINIMUM/Q    R003
         BNL   USEASIS .                    *YES, USE IT           R003
         ZAP   MAXLINES,=P'10' .            *USE DEFAULT MINIMUM   R003
         EJECT
USEASIS  EQU   * .                                                 R003
*        TIME  DEC . R00 IS TIME - HHMMSSTH   R01 IS DATE - 00YYDDDF
*        TIME  DEC . R00 IS TIME - HHMMSSTH   R01 IS DATE - 00YYDDDF
         LA    1,2(0,0)                LOAD 1 TO SPECIFY UNIT
         SVC   11                      ISSUE TIME SVC
         STM   R00,R01,SEQNUMCV .                                  R002
         ED    HDAT,SEQNUMCV+4 .            *DATE - YY.DDD         R002
         ED    HTIM,SEQNUMCV .              *TIME - HH.MM.SS       R002
         L     R01,16 .                     *A(CVT)
         L     R01,0(,R01) .                *A(TCB POINTERS)
         L     R01,4(,R01) .                *A(CURRENT TCB)
         L     R01,12(,R01) .               *A(TIOT)
         ST    R01,DDNTRYAD .               *SAVE FOR LATER
*        OPEN  (READER,,PRINTER,(OUTPUT))   *OPEN  READER AND PRINTER
         OPEN  (READER,,PRINTER,(OUTPUT)) . *OPEN  READER AND PRINTER
         TM    PRINTER+DCBOFLGS,X'10' .     *IS DCB OPEN/Q
         BZ    NOTOPEN1 .                   *BRANCH IF NOT
         TM    READER+DCBOFLGS,X'10' .      *IS DCB OPEN/Q
         LA    R15,READER+DCBDDNAM .        *LOAD DDNAME ADDRESS
         BZ    ERR09RTN .                   *BRANCH IF NOT OPEN
         EJECT
*        GETMAIN EC,LV=12288,A=BLKTABLE     *IS MINIMUM CORE AVAILABLE/
         GETMAIN EC,LV=12288,A=BLKTABLE .   *IS MINIMUM CORE AVAILABLE/
         LTR   R15,R15 .                    *  FOR PUSH/POP OF DATA BLK
         BZ    GOTMAIN .                    *BRANCH IF PUSH/POP OKAY
         XC    BLKTABLE,BLKTABLE .          *ZERO TABLE ADDRESS
         B     RDCARD .                     *GO READ CONTROL CARD
GOTMAIN  EQU   * .
*        FREEMAIN E,LV=12288,A=BLKTABLE     *RELEASE LARGE CHUNK
         FREEMAIN E,LV=12288,A=BLKTABLE .   *RELEASE LARGE CHUNK
         LH    R00,H5376 .                  *LOAD LENGTH REQUIRED
*        GETMAIN R,LV=(0)                   *ASK FOR CORE STORAGE
         GETMAIN R,LV=(0) .                 *ASK FOR CORE STORAGE
         ST    R01,BLKTABLE .               *SAVE TABLE ADDRESS
         LH    R15,H5376 .                  *LOAD LENGTH OF AREA
         AIF   ('&SYSTEM' NE '370').NOT370A
         LR    R14,R01 .                    *PUT A(TABLE) INTO R14
         SR    R01,R01 .                    *USE ZERO FILLER
         MVCL  R14,R00 .                    *ZERO TABLE AREA
         AGO   .END360A .
.NOT370A ANOP
         AR    R15,R01 .                ADD ADDRESS TO LENGTH = A(END)
         LA    R14,256 .                MAXIMUM LENGTH FOR XC INST.
* GETMAIN AREA MUST BE 256 BYTES OR MORE
         SR    R15,R14 .                BACK UP 256 BYTES INTO AREA
         XC    0(256,R01),0(R01) .      ZERO 256 BYTES OF AREA
         BXLE  R01,R14,*-6 .            BRANCH UNTIL WHOLE AREA ZERO
         AR    R15,R14 .                GET TO VERY END AGAIN
         SR    R15,R01 .                MINUS NEXT ADDRESS TO ZERO
         BNP   *+10 .                   BRANCH IF NO FRACTION OF 256
         BCTR  R15,0 .                  SUBTRACT 1 FOR EX TO XC INST.
         EX    R15,XCLR .               ZERO REMAINING BYTES
.END360A ANOP
         EJECT
*
* END OF CHAIN ROUTINE
*
CHAINEND EQU   * .
         OC    NOQENTS,NOQENTS .            *CHK FOR FINISH
         BNZ   CKCTLGSW .
RDCARD   EQU   * .
*        CTLG  CLOSE                        *REQUEST FILE CLOSE
         CTLG  CLOSE .                      *REQUEST FILE CLOSE
         LA    R02,PUNCHER .                *LOAD DCB ADDRESS
         BAL   RETURNR,CLOSE .              *CLOSE AND FREEPOOL IF OPEN
         MVI   NAMEAREA-1,C' ' .            *RESET TO BLANK
         MVC   NAMEAREA,NAMEAREA-1 .        *CLEAR NAME AREA
         ZAP   SRTCOUNT,P0 .                *RESET SEQUENCE NUMBER
         ZAP   LINECTR,P0 .                 *ZERO LINE COUNTER
         ZAP   PAGENUMP,P0 .                *ZERO PAGE COUNTER
         XC    NAMELGTH,NAMELGTH .          *ZERO NAME LENGTH
         NI    FLAGS,XFF-PRINTBIT-PUNCHBIT-CATLGBIT-NOHITBIT-VCBBIT .
*        GET   READER                       *GET A CONTROL CARD
         GET   READER .                     *GET A CONTROL CARD
         MVC   FUNCTION,0(R01) .            *SAVE FUNCTION REQUEST
         MVC   DEVSER,6(R01) .              *SAVE TARGET VOLSER
         L     R01,DDNTRYAD .               *LOAD A(TIOT)          R001
         LA    R15,24 .                     *INDEX TO DD ENTRIES   R001
TIOTLOOP EQU   * .
         AR    R01,R15 .                    *ADD LENGTH TO START ADDR
         AIF   ('&SYSTEM' NE '370').NOT370B                        R001
         ICM   R15,1,0(R01) .               *INSERT ENTRY LENGTH   R001
         AGO   .END360B .                                          R001
.NOT370B ANOP  , .                                                 R001
         IC    R15,0(,R01) .                *LOAD ENTRY LENGTH
         LTR   R15,R15 .                    *IS LENGTH ZERO/Q
.END360B ANOP  , .                                                 R001
         BZ    ERR04RTN .                   *NO DD ENTRY FOUND
         AIF   ('&SYSTEM' NE '370').NOT370C                        R001
         ICM   R14,15,16(R01) .             *A(UCB), TEST DUMMY    R001
         AGO   .END360C .                                          R001
.NOT370C ANOP  , .                                                 R001
         L     R14,16(,R01) .               *A(UCB)
         LTR   R14,R14 .                    *TEST FOR DD DUMMY
.END360C ANOP  , .                                                 R001
         BZ    TIOTLOOP .                   *NO SYSCTLG ON A DD DUMR001
         CLC   DEVSER,28(R14) .             *SERIAL NUMBERS THE SAME/Q
         BNE   TIOTLOOP .                   *BRANCH IF NOT         R001
         CLC   PGMEQDD,4(R01) .             *WRONG TYPE DDCARD/Q
         BE    TIOTLOOP .                   *YES, DISCARD          R001
         CLC   NAMEAREA(8),4(R01) .         *IS DD A CONCATENATION/Q
         BE    TIOTLOOP .                   *NO GOOD WITHOUT DDNAMER001
         EJECT
         MVC   DDNAME,4(R01) .              *MOVE DDNAME FROM TIOT
         LA    R03,16(,R14) .               *A(DEVTYPE)
         LA    PCHPTR,CVOLOP+5 .            *OUTPUT LOCATION
         BAL   RETURNR,MOVEDEVT .           *GO MOVE DEVICE UNIT TYPE
         TM    FLAGS,NOHITBIT .             *TEST FOR SUCCESS
         BO    ERR10RTN .                   *DEVICE UNIT TYPE NOT FND
         MVI   0(PCHPTR),C'=' .
         MVC   1(6,PCHPTR),DEVSER .         *MOVE SERIAL NUMBER
         MVI   7(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,8(,PCHPTR) .          *LAST BYTE USED + 1
         LA    R15,CVOLOP .                 *START OF CVOL OPERAND
         SR    PCHPTR,R15 .                 *GET TRUE LENGTH
         STH   PCHPTR,CVOLENTH .            *SAVE FOR MOVING LATER
         BCTR  PCHPTR,0 .                   *TRUE - 1 = MACHINE LENGTH
         STC   PCHPTR,CVOLMVC+1 .           *STORE MACH.LENGTH IN MVC
         OI    FLAGS,PRINTBIT .             *ASSUME PRINT REQUESTED
         CLC   FUNCTION,KPRINT .            *PRINT ONLY/Q
         BE    READVICE .
         OI    FLAGS,PUNCHBIT .             *ASSUME PUNCH REQUESTED TOO
         CLC   FUNCTION,KPTPCH .            *PRINT AND PUNCH/Q
         BE    OPENPCHF .                   *YES, BOTH REQUESTED
         NI    FLAGS,XFF-PRINTBIT .         *MUST BE PUNCH-ONLY
         CLC   FUNCTION,KPUNCH .            *PUNCH ONLY/Q
         BNE   ERR01RTN .                   *INVALID FUNCTION
OPENPCHF EQU   * .
         TM    DDMODFR,XFF .                *IS MODIFIER ALL ONE BITS/Q
         BO    ERR11RTN .                   *TOO MANY PUNCH REQUESTES
         IC    R15,DDMODFR .                *LOAD CURRENT
         LA    R15,1(,R15) .                *ADD ONE TO IT
         STC   R15,DDMODFR .                *STORE FOR NEXT TIME
         STC   R15,PUNCHER+DCBDDNAM+7 .     *PUT IN DCB DDNAME FIELD
         TR    PUNCHER+DCBDDNAM+7(1),HEXTABLE .MAKE EBCDIC
*        OPEN  (PUNCHER,OUTPUT)
         OPEN  (PUNCHER,OUTPUT) .
         TM    PUNCHER+DCBOFLGS,X'10' .     *IS DCB OPEN/Q
         BO    READVICE .                   *IF OPEN GO DO IT
         LA    R15,PUNCHER+DCBDDNAM .       *LOAD DDNAME ADDRESS
         B     ERR09RTN .                   *GIVE MSG AND SET RETCODE
         EJECT
READVICE EQU   * .
*        CTLG  OPENWKEY,DDNAME .            *REQUEST AN OPEN       R001
         CTLG  OPENWKEY,DDNAME .            *REQUEST AN OPEN       R001
         LTR   R15,R15 .                    *WAS OPEN SUCCESSFUL/Q
         LA    R15,DDNAME .                 *LOAD A(DDNAME) B-4 ANSWER
         BNZ   ERR09RTN .                   *NON-ZERO MEANS ERROR
         TM    FLAGS,PRINTBIT .             *IS PRINTING REQUESTED/Q
         BZ    NOPRINT .                    *NO PRINTING           R001
         BAL   RETURNR,HEADING1 .           *PRINT PAGE HEADING
         MVI   FORMCTRL,SPACE3 .
         MVC   PRINTWRK(L'STATHEAD),STATHEAD .
         BAL   RETURNR,PRINT .              *PRINT STAT HEADING
         MVI   FORMCTRL,SPACE2 .
         MVC   PRINTWRK+9(6),VOLIDHDG .
         MVC   PRINTWRK+19(37),BLKHEADS .   *MOVE HEADINGS TO PRINTR002
         BAL   RETURNR,PRINT .              *PRINT STAT COL HEADINGS
         MVC   PRINTWRK+9(6),DEVSER .       *MOVE VOLSER TO PRINT LINE
         SR    R03,R03 .                    *ZERO COUNTER REG      R001
         SR    R05,R05 .                    *ZERO COUNTER REG      R001
*GET     CTLG  GET .                        *READ SEQUENTIALLY     R001
GET      CTLG  GET .                        *READ SEQUENTIALLY     R001
         CH    R15,H4 .                     *TEST RETURN CODE      R001
         BL    GETOK .                      *BRANCH IF NORMAL      R001
         BE    GETEOF .                     *BRANCH END-OF-FILE    R001
         DC    H'0' .                       *YECH                  R001
GETOK    EQU   * .                                                 R001
         LA    R03,1(,R03) .                *+1 TO TOTAL READ      R001
         OC    0(8,R01),0(R01) .            *BLOCK IN USE/Q        R001
         BNZ   GET .                        *BRANCH IF YES         R001
         LA    R05,1(,R05) .                *+1 TO FREE COUNTER    R001
         B     GET .                        *GO READ NEXT BLOCK    R001
GETEOF   EQU   * .                                                 R001
         SR    R03,R05 .                    *TOTAL-FREE=USED       R001
         CVD   R03,SEQNUMCV .
         OI    SEQNUMCV+7,X'0F' .           *CHANGE SIGN
         UNPK  PRINTWRK+22(7),SEQNUMCV+4(4) *MOVE BLKS USED TO PRINT
         CVD   R05,SEQNUMCV .
         OI    SEQNUMCV+7,X'0F' .           *CHANGE SIGN
         UNPK  PRINTWRK+42(7),SEQNUMCV+4(4) *MOVE BLKS LEFT TO PRINT
         BAL   RETURNR,PRINT .              *PRINT STATISTICS
         BAL   RETURNR,HEADING2 .           *PRINT ENTRY HEADINGS
NOPRINT  EQU   * .                                                 R001
*        CTLG  CLOSE .                      *REQUEST A CLOSE       R001
         CTLG  CLOSE .                      *REQUEST A CLOSE       R001
*        CTLG  OPEN,DDNAME                  *REQUEST AN OPEN
         CTLG  OPEN,DDNAME .                *REQUEST AN OPEN
         MVC   TTR,CNTRLNAM+5 .             *TTR=000001 OF FIRST BLOCK
         BAL   RETURNR,READBLK .            *READ FIRST BLOCK
         LA    INDEXPTR,2(,BLKPTR) .        *POINT TO V.I.C.E.
         EJECT
*
* LOCATE NEXT ENTRY ROUTINE-INDEXPTR MUST BE SET AT FIRST BYTE OF LAST
*                           ENTRY EXAMINED-REGISTER 3 IS USED
*
LOCNXTEN EQU   * .
         SR    R03,R03 .                    *CLEAR REG
         IC    R03,ENTHWCT .                *NO OF HALFWORDS LEFT
         AR    R03,R03 .                    *MULTIPLY BY 2
         LA    INDEXPTR,12(R03,INDEXPTR) .  *LOCATE NEXT ENTRY
         CLC   ENTNAME,LINKENT .            *CHK FOR LINK ENTRY
         BNE   IXPTRCHK .
         OC    ENTTTR,ENTTTR .              *CHK FOR END-OF-CHAIN
         BZ    CHAINEND .                   *END OF CHAIN, DO NEXT
         MVC   TTR,ENTTTR .                 *ADDRESS OF NEXT BLK
         BAL   RETURNR,READBLK .            *READ NEXT BLOCK IN CHAIN
         LA    INDEXPTR,2(,BLKPTR) .        *SET INDEX POINTER
         CLC   ENTNAME,CNTRLNAM .           *CHK FOR INDEX CTRL ENTRY
         BE    ERR02RTN .                   *WRONG BLOCK
         CLC   ENTNAME,LINKENT .            *CHK FOR LINK ENTRY FIRST
         BE    CHAINEND .                   *BLK EMPTY IF LINK FIRST
*
* DETERMINE TYPE OF ENTRY
*
IXPTRCHK EQU   * .
         CLI   ENTHWCT,X'20' .              *CHK FOR TOO LARGE
         BNL   ERR03RTN .                   *NOT LEGAL
         SR    R15,R15 .                    *ZERO REGISTER 15
         IC    R15,ENTHWCT .                *NUMBER OF HALFWORDS FOLLOW
         IC    R15,HWCTTABL(R15) .          *SELECT BRANCH INDEX
         B     *+4(R15) .                   *GO TO PROPER ROUTINE
         B     ERR03RTN .                   *INDEX = 0  DONT MOVE CARD
         B     DSPTRRTN .                   *INDEX = 4  DONT MOVE CARD
         B     CVOLPRTN .                   *INDEX = 8  DONT MOVE CARD
         B     IXPTRRTN .                   *INDEX = 12 DONT MOVE CARD
         B     VCBPTRTN .                   *INDEX = 16 DONT MOVE CARD
         B     GENIXRTN .                   *INDEX = 20 DONT MOVE CARD
         B     ALIASRTN .                   *INDEX = 24 DONT MOVE CARD
*
* DATA SET POINTER ROUTINE
*
DSPTRRTN EQU   * .
         BAL   RETURNR,DSPRTRTN .           *INITIAL PRINT ROUTINE
         LA    R03,14(INDEXPTR) .           *ADDR OF FIRST VOL ENTRY
         LH    R04,DSPVOLCT .               *LOAD NO OF VOLUMES
         BAL   RETURNR,PRINTVOL .           *PRINT VOL INFO
         TM    FLAGS,PUNCHBIT .             *IS PUNCHING REQUESTED/Q
         BZ    LOCNXTEN .                   *NO, GO DO NEXT ENTRY
         B     PCHDSRTN .                   *YES, GO PUNCH IT
         EJECT
*
* CVOL POINTER ROUTINE
*
CVOLPRTN EQU   * .
         NI    FLAGS,XFF-CATLGBIT .         *TURN CATLG SWITCH OFF
         TM    FLAGS,PRINTBIT .             *IS PRINTING REQUESTED/Q
         BZ    PCHCVOLP .                   *NO, GO PUNCH IT THEN
         MVC   PRINTWRK(8),ENTNAME .
         MVC   PRINTWRK+45(8),KCVOLPTR .                           R002
         MVC   PRINTWRK+63(6),CVOLSRNO .                           R002
         CLI   ENTHWCT,X'05' .              *CHK FOR NEW TYPE CVOL
         BNE   OLDCVOL1 .                   *BRANCH IF OLD TYPE CVOL
         MVC   PRINTWRK+63(6),NCVOLSER .    *MOVE TRUE VOLSER NUMBER002
         LA    PCHPTR,PRINTWRK+56 .         *OUTPUT DESTINATION    R002
         LA    R03,NCVOLDVT .               *SET POINTER TO A(DEVTYPE)
         BAL   RETURNR,MOVEDEVT .           *GO FIND UNIT TYPE
         TM    FLAGS,NOHITBIT .             *WAS UNIT TYPE FOUND/Q
         BZ    OLDCVOL1 .                   *YES, GO PRINT LINE
         NI    FLAGS,XFF-NOHITBIT .         *RESET NOT FOUND BIT
         UNPK  PRINTWRK+54(9),NCVOLDVT(5) . *PUT DEVTYPE INTO PRINTR002
         TR    PRINTWRK+54(8),HEXTABLE .    *MAKE PRINTABLE        R002
         MVI   PRINTWRK+62,C' ' .           *BLANK OUT LAST CHARACTR002
OLDCVOL1 EQU   * .
         BAL   RETURNR,PRINT .              *PRINT CVOL PTR ENTRY
         TM    FLAGS,PUNCHBIT .             *IS PUNCHING REQUESTED/Q
         BZ    LOCNXTEN .                   *NO, GO DO NEXT ENTRY
PCHCVOLP EQU   * .
         MVC   PUNCHREC+1(7),KCONNECT .     *BUILD CONNECT CARD
         MVI   SORTCODE,SORTSEQ1 .          *CONNECT CARDS 1ST
         MVC   PUNCHREC+9(6),KINDEX .       *INDEX PARAMETER
         LA    PCHPTR,PUNCHREC+15 .         *SET UP PUNCH LINE PTR
         LA    R03,ENTNAME .
         LR    R06,PCHPTR .
         BAL   RETURNR,MOVERTN .            *MOVE NAME TO PUNCH AREA
         AR    PCHPTR,R05 .                 *INCREMENT PTR
         MVI   0(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,1(PCHPTR) .           *INCREMENT PTR
         EX    0,CVOLMVC .                  *MOVE ''CVOL='' PARAMETER
         AH    PCHPTR,CVOLENTH .            *ADD TRUE LENGTH TO PTR
         MVC   0(4,PCHPTR),KVOL .           *VOL PARAMETER
         MVC   4(L'DFLTCVDT,PCHPTR),DFLTCVDT MOVE DEFAULT DEVTYPE
         MVC   4+L'DFLTCVDT(6,PCHPTR),CVOLSRNO MOVE SERIAL NUMBER
         CLI   ENTHWCT,X'05' .              *CHK FOR NEW TYPE CVOL
         BNE   OLDCVOL2 .                   *BRANCH IF OLD TYPE CVOL
         LA    PCHPTR,4(,PCHPTR) .          *MOVE UP TO UNUSED COLUMN
         LA    R03,NCVOLDVT .               *SET POINTER TO DEVTYPE
         BAL   RETURNR,MOVEDEVT .           *GO FIND UNIT TYPE
         MVI   0(PCHPTR),C'=' .             *PUT IN THE EQUAL SIGN
         MVC   1(6,PCHPTR),NCVOLSER .       *MOVE VOLSER NUMBER
OLDCVOL2 EQU   * .
         BAL   RETURNR,CNTNPCH .            *UPDATE SORT CNT & PUNCH
         BAL   RETURNR,NOHITEST .           *CHECK DEVTYPE SEARCH
         B     LOCNXTEN .                   *LOCATE NEXT ENTRY
         EJECT
*
* INDEX POINTER ENTRY ROUTINE
*
IXPTRRTN EQU   * .
         NI    FLAGS,XFF-CATLGBIT .         *TURN SWITCH OFF
         BAL   RETURNR,NEXTQEL .            *GO GET NEXT AVAILABLE QEL
RDDSBLK  EQU   * .
         MVC   TTR,ENTTTR .                 *TTR OF NEXT BLOCK TO READ
         BAL   RETURNR,PUSHBLK .            *SAVE THIS, READ NEXT BLOCK
         LA    INDEXPTR,2(,BLKPTR) .        *SET UP ENTRY POINTER
         CLC   ENTNAME,CNTRLNAM .           *CHK FOR INDEX CNTRL ENTRY
         BE    LOCNXTEN .
         B     ERR06RTN .                   *NO INDEX CNTRL ENTRY
*
* VOLUME CONTROL BLOCK POINTER ROUTINE
*
VCBPTRTN EQU   * .
         OI    FLAGS,VCBBIT .               *SET SW ON
         BAL   RETURNR,DSPRTRTN .           *INITIAL PRINT ROUTINE
         MVC   SAVETTR,TTR .                *SAVE BLOCK ADDR
         MVC   TTR,ENTTTR .                 *ADDRESS OF VCB
         SR    INDEXPTR,BLKPTR .            *GET DISPLACEMENT ONLY
         BAL   RETURNR,PUSHBLK .            *SAVE THIS, READ NEXT BLOCK
         LH    R04,0(,BLKPTR) .             *LOAD COUNT OF VOLUMES
         LA    R03,2(,BLKPTR) .             *POINT TO FIRST VOL INFO
         BAL   RETURNR,PRINTVOL .           *PRINT VOL INFO
         MVC   TTR,SAVETTR .                *ADDRESS OF VCB PTR
         BAL   RETURNR,POPBLK .             *RETRIEVE PRIOR BLOCK
         AR    INDEXPTR,BLKPTR .            *DISPLACE INTO DATA BLOCK
         TM    FLAGS,PUNCHBIT .             *IS PUNCHING REQUESTED/Q
         BO    PCHDSRTN .                   *YES, GO PUNCH IT
         NI    FLAGS,XFF-VCBBIT .           *RESET SWITCH TO OFF
         B     LOCNXTEN .                   *LOCATE NEXT ENTRY
         EJECT
*
* GENERATION INDEX ROUTINE
*
GENIXRTN EQU   * .
         BAL   RETURNR,NEXTQEL .            *GO GET NEXT AVAILABLE QEL
         TM    FLAGS,CATLGBIT .             *CHK CATLG SWITCH ON
         BO    ADDNAME .                    *BRANCH IF ON
         CLC   NOQENTS,H1 .                 *CHK FOR MORE NAMES
         BNH   ADDNAME .
         BAL   RETURNR,BLDNAME .            *BUILD INDEX NAME
         B     CHKPUNCH .
ADDNAME  EQU   * .
         LH    R04,NAMELGTH .               *LOAD LENGTH OF NAME
         LA    R06,NAMEAREA(R04) .          *SET PTR TO POS IN NAMEAREA
         LR    R03,INDEXPTR .
         BAL   RETURNR,MOVERTN .            *MOVE INDEX NAME TO AREA
         AR    R06,R05 .
         MVI   0(R06),C'.' .                *PERIOD
         LA    R04,1(R05,R04) .             *UPDATE LGTH
         STH   R04,NAMELGTH .
CHKPUNCH EQU   * .
         SR    R03,R03 .
         IC    R03,GIMXENTS .               *MAX NO OF ENTRIES
         CVD   R03,SEQNUMCV .
         TM    FLAGS,PUNCHBIT .             *IS PUNCHING REQUESTED/Q
         BZ    PRTGDG .                     *NO, MUST BE PRINT THEN
         MVC   PUNCHREC+1(4),KBLDG .        *BUILD BLDG CARD
         MVI   SORTCODE,SORTSEQ3 .          *BLDG CARDS ARE 3RD
         MVC   PUNCHREC+6(6),KINDEX .       *INDEX POINTER
         LA    R06,PUNCHREC+12 .            *SET POINTER
         LH    R05,NAMELGTH .               *LGTH OF NAME
         BCTR  R05,0 .                      *SUBTRACT ONE FROM R05
         BCTR  R05,0 .                      *NOW TO MACHINE LENGTH
         EX    R05,NAMEMOVE .               *MOVE NAME TO PCH
         LA    PCHPTR,1(R05,R06) .          *SET POINTER
         MVI   0(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,1(PCHPTR) .           *INCREMENT PTR
         LH    R06,CVOLENTH .               *NEEDED NUMBER OF COLUMNS
         BAL   RETURNR,CHKSPACE .           *GET NEW CARD IF NEEDED
         EX    0,CVOLMVC .                  *MOVE ''CVOL='' PARAMETER
         AR    PCHPTR,R06 .                 *ADD TRUE LENGTH TO PTR
         LA    R06,12 .                     *NUMBER OF NEEDED COLUMNS
         BAL   RETURNR,CHKSPACE .           *SEE IF NEW CARD NEEDED
         MVC   0(8,PCHPTR),KENTRIES .       *ENTRIES PARAMETER
         LA    PCHPTR,8(PCHPTR) .           *INCREMENT PTR
         UNPK  0(3,PCHPTR),SEQNUMCV+6(2) .
         OI    2(PCHPTR),X'F0' .            *F SIGN
         CLI   GIFLAGS,X'00' .              *CHK FOR NO MORE PARMS
         BE    THATSALL .
         LA    PCHPTR,3(PCHPTR) .           *INCREMENT PTR
         TM    GIFLAGS,X'FC' .              *MORE BITS THAN EXPECTED/Q
         BNZ   ERR07RTN .                   *LATER OPTION MAYBE
         TM    GIFLAGS,X'01' .              *IS EMPTY BIT ON/Q
         BZ    TRYDLEET .                   *NOT EMPTY, TRY DELETE
         MVI   0(PCHPTR),C',' .             *COMMA TO CONTINUE
         LA    PCHPTR,1(,PCHPTR) .          *INCREMENT POINTER
         LA    R06,5 .                      *NUMBER OF COLUMNS NEEDED
         BAL   RETURNR,CHKSPACE .           *SEE IF ROOM ON CARD
         MVC   0(5,PCHPTR),KEMPTY .         *EMPTY PARAMETER
         LA    PCHPTR,5(PCHPTR) .           *INCREMENT PTR
TRYDLEET EQU   * .
         TM    GIFLAGS,X'02' .              *IS DELETE BIT ON/Q
         BZ    THATSALL .                   *NOPE
         MVI   0(PCHPTR),C',' .             *COMMA TO CONTINUE
         LA    PCHPTR,1(,PCHPTR) .          *INCREMENT POINTER
         LA    R06,6 .                      *NUMBER OF COLUMNS NEEDED
         BAL   RETURNR,CHKSPACE .           *SEE IF NEW CARD REQUIRED
         MVC   0(6,PCHPTR),KDELETE .        *DELETE PARAMETER
THATSALL EQU   * .
         BAL   RETURNR,CNTNPCH .            *UPDATE SORT CNT & PUNCH
         TM    FLAGS,PRINTBIT .             *IS PRINTING REQUESTED/Q
         BZ    READNXT .                    *NO
PRTGDG   EQU   * .
         LH    R05,NAMELGTH .               *LOAD LENGTH OF NAME SO FAR
         BCTR  R05,0 .                      *MINUS 1 TO GET TO MACHINE
         EX    R05,NAMEPRNT .               *MOVE NAME TO PRINT AREA
         MVC   PRINTWRK+45(16),GENINDEX .   *INDICATE TYPE OF ENTRYR002
         UNPK  PRINTWRK+61(3),SEQNUMCV+6(2) *UNPACK INTO PRINT LINER002
         OI    PRINTWRK+63,X'F0' .          *MAKE SURE LAST IS EBCDR002
         MVI   PRINTWRK+66,C'-' .           *PUT A 'DASH' INTO LINER002
         MVC   PRINTWRK+68(11),PRINTWRK+66 .*PUT MORE 'DASHES' IN  R002
         TM    GIFLAGS,X'02' .              *IS DELETE SPECIFIED/Q
         BZ    TRYEMPTY .                   *NO, TRY EMPTY
         MVC   PRINTWRK+65(6),KDELETE .     *INDICATE DELETE OPTIONR002
TRYEMPTY EQU   * .
         TM    GIFLAGS,X'01' .              *IS EMPTY SPECIFIED/Q
         BZ    NOTEMPTY .                   *NO, NOT EMPTY
         MVC   PRINTWRK+74(5),KEMPTY .      *INDICATE EMPTY OPTION R002
NOTEMPTY EQU   * .
         BAL   RETURNR,PRINT .              *PRINT GDG INDEX
READNXT  EQU   * .
         OI    FLAGS,CATLGBIT .             *SET SWITCH ON
         OC    GICURENT,GICURENT .          *CHK FOR ENTRIES
         BNZ   RDDSBLK .                    *YES, GO READ DATA SET BLK
         BAL   RETURNR,ADJQUEUE .           *GET PRIOR QEL, ADJ. NAME
         B     LOCNXTEN .                   *GO DO NEXT ENTRY
         EJECT
*
* ALIAS ROUTINE
*
ALIASRTN EQU   * .
         NI    FLAGS,XFF-CATLGBIT .         *TURN CATLG SWITCH OFF
         TM    FLAGS,PRINTBIT .             *IS PRINTING REQUESTED/Q
         BZ    PCHALIAS .                   *NO, GO PUNCH IT THEN
         MVC   PRINTWRK(8),ENTNAME .
         MVC   PRINTWRK+9(14),ALIASOF .                            R002
         MVC   PRINTWRK+24(8),ALIASTRN .                           R002
         BAL   RETURNR,PRINT .              *PRINT ALIAS ENTRY
         TM    FLAGS,PUNCHBIT .             *IS PUNCHING REQUESTED/Q
         BZ    LOCNXTEN .                   *NO, GO DO NEXT ENTRY
PCHALIAS EQU   * .
         MVC   PUNCHREC+1(4),KBLDA .        *BLDA CARD
         MVI   SORTCODE,SORTSEQ5 .          *BLDA CARDS 5TH
         MVC   PUNCHREC+6(6),KINDEX .       *INDEX PARAMETER
         LA    PCHPTR,PUNCHREC+11 .         *SET PTR TO PARM FIELD
         LR    R06,PCHPTR .
         LA    R03,ALIASTRN .
         BAL   RETURNR,MOVERTN .            *MOVE TRUE NAME
         AR    PCHPTR,R05 .                 *INCREMENT PTR
         MVI   0(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,1(,PCHPTR) .          *INCREMENT POINTER
         EX    0,CVOLMVC .                  *MOVE ''CVOL='' PARAMETER
         AH    PCHPTR,CVOLENTH .            *ADD TRUE LENGTH TO PTR
         MVI   0(PCHPTR),C',' .             *COMMA
         MVC   1(6,PCHPTR),KALIAS .         *ALIAS PARAMETER
         LA    PCHPTR,7(PCHPTR) .
         LR    R06,PCHPTR .
         LA    R03,ENTNAME .
         BAL   RETURNR,MOVERTN .            *MOVE ALIAS NAME
         BAL   RETURNR,CNTNPCH .            *UPDATE SORT CNT & PUNCH
         B     LOCNXTEN .                   *LOCATE NEXT ENTRY
         EJECT
*
* DSNAME INITIAL PRINT ROUTINE
*
DSPRTRTN EQU   * .
         ST    RETURNR,SAVERTN8 .           *SAVE RETURN ADDRESS
         OC    NOQENTS,NOQENTS .            *CHK FOR EMPTY QUEUE
         BZ    CHKPCHSW .
         TM    FLAGS,CATLGBIT .             *IS NAME ALREADY BUILT/Q
         BO    CHKPCHSW .                   *BRANCH IF BUILT
         BAL   RETURNR,BLDNAME .            *BUILD INDEX NAME
         OI    FLAGS,CATLGBIT .             *SET ON, NAME IS BUILT
CHKPCHSW EQU   * .
         TM    FLAGS,PRINTBIT .             *IS PRINTING REQUESTED/Q
         BZ    PCHDSRTN .                   *NO, MUST BE PUNCH THEN
         MVC   PRINTWRK+45(8),KDATASET .                           R002
         LA    R06,PRINTWRK .               *SET PTR TO PRINT AREA
         LH    R05,NAMELGTH .
         LTR   R05,R05 .                    *CHK FOR NO INDEX
         BZ    MOVDSNAM .                   *NO INDEX
         BCTR  R05,0 .                      *ADJUST TO MACH LGTH
         EX    R05,NAMEMOVE .               *MOVE INDEX TO PRINT
         LA    R06,1(R05,R06) .             *INCREMENT POINTER
MOVDSNAM EQU   * .
         LR    R03,INDEXPTR .               *LOAD A(NAME)
         BAL   RETURNR,MOVERTN .            *MOVE DSNAME TO PRINT
         L     RETURNR,SAVERTN8 .           *LOAD RETURN ADDRESS
         CLI   0(INDEXPTR),C'G' .           *CHK FOR GDG NAME
         BNER  RETURNR .                    *NOT GDG
         TM    1(INDEXPTR),X'F0' .          *IS IT A GDG/Q
         BNZR  RETURNR .                    *NOT GDG
         TM    2(INDEXPTR),X'F0' .          *IS IT A GDG/Q
         BNZR  RETURNR .                    *NOT GDG
         TM    3(INDEXPTR),X'F0' .          *IS IT A GDG/Q
         BNZR  RETURNR .                    *NOT GDG
         TM    4(INDEXPTR),X'F0' .          *IS IT A GDG/Q
         BNZR  RETURNR .                    *NOT GDG
         CLI   5(INDEXPTR),C'V' .           *IS IT A GDG/Q
         BNER  RETURNR .                    *NOT GDG
         TM    6(INDEXPTR),X'F0' .          *IS IT A GDG/Q
         BNOR  RETURNR .                    *NOT GDG
         TM    7(INDEXPTR),X'F0' .          *IS IT A GDG/Q
         BNOR  RETURNR .                    *NOT GDG
         XC    1(4,R06),LINKENT .           *CHANGE GEN. NO. TO TRUE
         BR    RETURNR .
         EJECT
*
* PRINT DATA SET VOLUME INFORMATION ROUTINE
*
PRINTVOL EQU   * .
         ST    RETURNR,SAVERTN5 .           *SAVE RETURN ADDRESS
PAST     EQU   * .
         LA    R05,20 .                     *LOAD LOOP COUNTER
         CR    R04,R05 .                    *CHK FOR MORE THAN 1 BLOCK
         BNH   ONEBLOCK .
         SR    R04,R05 .                    *DECREMENT VOL COUNT
         B     STARTPRT .
ONEBLOCK EQU   * .
         LR    R05,R04 .                    *LOAD LOOP COUNTER
         SR    R04,R04 .                    *CLEAR VOL COUNT REGISTER
STARTPRT EQU   * .
         LA    PCHPTR,PRINTWRK+56 .         *OUTPUT DESTINATION    R002
         BAL   RETURNR,MOVEDEVT .           *GO FIND UNIT TYPE
         TM    FLAGS,NOHITBIT .             *WAS UNIT TYPE FOUND/Q
         BZ    MOVSERNO .                   *YES, GO MOVE SERIAL NUMBER
         NI    FLAGS,XFF-NOHITBIT .         *RESET NOT FOUND BIT
         UNPK  PRINTWRK+54(9),VOLDEVCD(5) .                        R002
         TR    PRINTWRK+54(8),HEXTABLE .    *MAKE PRINTABLE        R002
         MVI   PRINTWRK+62,C' '                                    R002
MOVSERNO EQU   * .
         MVC   PRINTWRK+63(6),VOLSRNUM .    *VOLUME SERIAL NO      R002
         CLI   VOLDEVCD+2,DASD .            *IS THIS A D.A.S.D./Q
         BE    NOSEQ .                      *YES, NO SEQUENCE NUMBER
         LH    R01,VOLSEQNO .               *SEQUENCE NO
         CVD   R01,SEQNUMCV .
         OI    SEQNUMCV+7,X'0F' .           *CLEAR SIGN TO F
         UNPK  PRINTWRK+72(3),SEQNUMCV+6(2) .                      R002
NOSEQ    EQU   * .
         BAL   RETURNR,PRINT .              *PRINT VOLUME INFO
         LA    R03,12(R03) .                *INCREMENT PTR
         BCT   R05,STARTPRT .               *REPEAT
         LTR   R04,R04 .                    *CHK FOR MOVE VOL CTRL BLKS
         BZ    FINISHED .
         MVC   TTR,10(R03) .                *ADDRESS OF NEXT BLK
         BAL   RETURNR,READBLK .            *READ NEXT BLK
         LA    R03,2(,BLKPTR) .             *ADDRESS OF 1ST ENTRY
         B     PAST .                       *REPEAT
FINISHED EQU   * .
         L     RETURNR,SAVERTN5 .           *RESTORE RETURN ADDRESS
         BR    RETURNR .                    *RETURN
         EJECT
*
* DATA SET CATLG CARD PUNCH ROUTINE
*
PCHDSRTN EQU   * .
         MVC   PUNCHREC+1(5),KCATLG .       *CATLG CARD
         MVI   SORTCODE,SORTSEQ4 .          *CATLG CARDS ARE 4TH
         MVC   PUNCHREC+7(7),KDSNAME .      *DSNAME PARAMETER
         LA    R06,PUNCHREC+14 .            *SET OUTPUT POINTER UP
         LA    RETURNR,RETURNAD .           *SET UP RETURN ADDRESS
         ST    RETURNR,SAVERTN8 .
         LH    R05,NAMELGTH .               *INDEX LGTH
         LTR   R05,R05 .                    *CHK FOR NO INDEX
         BZ    MOVDSNAM .                   *BRANCH IF UNQUALIFIED
         BCTR  R05,0 .                      *ADJUST TO MACH LGTH
         EX    R05,NAMEMOVE .               *MOVE INDEX TO PUNCH
         LA    R06,1(R05,R06) .             *INCREMENT POINTER
         B     MOVDSNAM .                   *MOVE SIMPLE PART OF NAME
RETURNAD EQU   * .
         LA    PCHPTR,0(R05,R06) .          *INCREMENT PTR
         MVI   0(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,1(PCHPTR) .           *INCREMENT PTR
         LH    R06,CVOLENTH .               *NEEDED NUMBER OF COLUMNS
         BAL   RETURNR,CHKSPACE .           *GET NEW CARD IF NEEDED
         EX    0,CVOLMVC .                  *MOVE ''CVOL='' PARAMETER
         AR    PCHPTR,R06 .                 *ADD TRUE LENGTH TO PTR
         TM    FLAGS,VCBBIT .               *CHK FOR VOL CTRL BLK
         BZ    DSPTR .                      *NOT VCB, DATASET POINTER
         MVC   SAVETTR,TTR .                *SAVE PRESENT BLOCK ADDR
         MVC   TTR,ENTTTR .                 *ADDRESS OF VCB
         SR    INDEXPTR,BLKPTR .            *GET DISPLACEMENT ONLY
         BAL   RETURNR,PUSHBLK .            *SAVE THIS, READ NEXT BLOCK
         LR    R03,BLKPTR .                 *LOAD BLOCK START ADDRESS
         B     ACOUPLE .
DSPTR    EQU   * .
         LA    R03,12(INDEXPTR) .           *SET PTR
ACOUPLE  EQU   * .
         LH    R04,0(R03) .                 *LOAD VOL COUNT
         LA    R03,2(R03) .                 *INCREMENT PTR
         BAL   RETURNR,PUNCHVOL .           *PUNCH VOL INFO
         TM    FLAGS,VCBBIT .               *CHK FOR VCB
         BZ    LOCNXTEN .                   *NO, GO DO NEXT ENTRY
         MVC   TTR,SAVETTR .                *ADDRESS OF VCB PTR
         BAL   RETURNR,POPBLK .             *RETRIEVE PRIOR BLOCK
         AR    INDEXPTR,BLKPTR .            *DISPLACE INTO DATA BLOCK
         NI    FLAGS,XFF-VCBBIT .           *TURN OFF VCB SWITCH
         B     LOCNXTEN .                   *LOCATE NEXT ENTRY
         EJECT
*
* PUNCH DATA SET VOLUME INFORMATION ROUTINE
*
PUNCHVOL EQU   * .
         ST    RETURNR,SAVERTN6 .           *SAVE RETURN ADDRESS
         MVI   SORTCODE,SORTSEQ4 .          *CATLG CARDS ARE 4TH
         LA    R06,19 .                     *NEEDED NUMBER OF COLUMNS
         CLI   VOLDEVCD+2,DASD .            *IS THIS A D.A.S.D./Q
         BE    FIRSTCHK .                   *YES IT IS, NO SEQ. NUM.
         LA    R06,24 .                     *NEEDED NUMBER OF COLUMNS
FIRSTCHK EQU   * .
         BAL   RETURNR,CHKSPACE .           *GET NEW CARD IF NEEDED
         MVC   0(4,PCHPTR),KVOL .           *VOL PARAMETER
         LA    PCHPTR,4(PCHPTR) .           *INCREMENT PTR
         BAL   RETURNR,MOVEDEVT .           *GO MOVE UNIT TYPE
         MVC   0(2,PCHPTR),KEQPAREN .       *START VOL LIST
         LA    PCHPTR,2(PCHPTR) .           *INCREMENT PTR
         B     STARTPCH .
NEXTSET  EQU   * .
         MVC   0(6,PCHPTR),VOLSRNUM .       *MOVE VOL SER TO PUNCH AREA
         MVI   6(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,7(PCHPTR) .           *INCREMENT PTR
         CLI   VOLDEVCD+2,DASD .            *IS THIS A D.A.S.D./Q
         BE    NOSEQNUM .                   *YES, NO SEQUENCE NUMBER
         LH    R02,VOLSEQNO .               *LOAD SEQ NO
         LTR   R02,R02 .                    *CHK FOR ZERO
         BNZ   CVD .                        *BRANCH IF NON-ZERO
         LA    R02,1 .                      *MUST NOT BE ZERO
CVD      EQU   * .
         CVD   R02,SEQNUMCV .
         OI    SEQNUMCV+7,X'0F' .
         UNPK  0(4,PCHPTR),SEQNUMCV+5(3) .  *MOVE SEQ NO TO CARD
         MVI   4(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,5(PCHPTR) .           *INCREMENT PTR
NOSEQNUM EQU   * .
         LA    R03,12(R03) .                *INDEX PTR
         BCT   R05,CHKROOM .
         LTR   R04,R04 .                    *TEST FOR FINISHED
         BZ    FINI .
         MVC   TTR,10(R03) .                *ADDRESS OF NEXT VCB
         BAL   RETURNR,READBLK .            *READ NEXT BLOCK
         LA    R03,2(,BLKPTR) .             *LOAD DATA START ADDRESS
STARTPCH EQU   * .
         LA    R05,20 .                     *LOAD LOOP COUNTER VALUE
         CR    R04,R05 .                    *CHK FOR MORE THAN 20 VOLS
         BNH   LASTBLK .
         SR    R04,R05 .                    *DECREMENT VOL COUNT
CHKROOM  EQU   * .
         LA    R06,7 .                      *NUMBER OF REQUIRED COLUMNS
         CLI   VOLDEVCD+2,DASD .            *IS THIS A D.A.S.D./Q
         BE    GOCHK .                      *YES, LESS REQUIRED
         LA    R06,12 .                     *NEEDED NUMBER OF COLUMNS
GOCHK    EQU   * .
         BAL   RETURNR,CHKSPACE .           *GET NEW CARD IF NEEDED
         B     NEXTSET .
         EJECT
LASTBLK  EQU   * .
         LR    R05,R04 .                    *LOAD LOOP COUNTER
         SR    R04,R04 .                    *CLEAR VOL COUNT
         B     CHKROOM .
FINI     EQU   * .
         BCTR  PCHPTR,0 .                   *DECREMENT PTR
         MVI   0(PCHPTR),C')' .             *CLOSE PARENS
         BAL   RETURNR,CNTNPCH .            *UPDATE SORT CNT & PUNCH
         BAL   RETURNR,NOHITEST .           *CHECK DEVTYPE SEARCH
         L     RETURNR,SAVERTN6 .           *LOAD RETURN ADDRESS
         BR    RETURNR .                    *RETURN
         EJECT
CKCTLGSW EQU   * .
         TM    FLAGS,CATLGBIT .             *CHK CATLG SWITCH ON
         BO    ADJUSTQ .                    *BRANCH IF ON
         BAL   RETURNR,BLDNAME .            *BUILD INDEX NAME
         LH    R05,NAMELGTH .
         BCTR  R05,0 .                      *SUBTRACT ONE FROM R05
         TM    FLAGS,PRINTBIT .             *IS PRINTING REQUESTED/Q
         BZ    PCHINDX .                    *NO, MUST BE PUNCH ONLY
         EX    R05,NAMEPRNT .               *MOVE NAME TO PRINT AREA
         MVC   PRINTWRK+47(5),KINDEX .                             R002
         BAL   RETURNR,PRINT .
         TM    FLAGS,PUNCHBIT .             *IS PUNCHING REQUESTED/Q
         BZ    ADJUSTQ .                    *NO
PCHINDX  EQU   * .
         MVC   PUNCHREC+1(4),KBLDX .        *BUILD BLDX CARD
         MVI   SORTCODE,SORTSEQ2 .          *BLDX CARDS ARE 2ND
         MVC   PUNCHREC+6(6),KINDEX .       *INDEX PARAMETER
         LA    PCHPTR,PUNCHREC+12 .         *SET PTR
         LR    R06,PCHPTR .
         BCTR  R05,0 .                      *SUBTRACT ONE AGAIN
         EX    R05,NAMEMOVE .               *MOVE INDEX NAME TO PUNCH
         LA    PCHPTR,1(R05,PCHPTR) .       *INCREMENT PTR
         MVI   0(PCHPTR),C',' .             *COMMA
         LA    PCHPTR,1(,PCHPTR) .          *NEXT COLUMN
         LH    R06,CVOLENTH .               *NUMBER REQUIRED
         BCTR  R06,0 .                      *NO COMMA NEEDED, THOUGH
         BAL   RETURNR,CHKSPACE .           *SEE IF ROOM ON CARD
         EX    0,CVOLMVC .                  *MOVE ''CVOL='' PARAMETER
         AR    PCHPTR,R06 .                 *ADD TRUE LENGTH-1 TO PTR
         MVI   0(PCHPTR),C' ' .             *COMMA NOT NEEDED HERE
         BAL   RETURNR,CNTNPCH .            *UPDATE SORT CNT & PUNCH
ADJUSTQ  EQU   * .
         BAL   RETURNR,ADJQUEUE .           *GET PRIOR QEL, ADJ. NAME
         MVC   TTR,QELTTR .
         BAL   RETURNR,POPBLK .             *RETRIEVE PRIOR BLOCK
         LR    INDEXPTR,BLKPTR .            *LOAD BLOCK START ADDRESS
         AH    INDEXPTR,QELDISP .           *DISPLACE TO PROPER SPOT
         B     LOCNXTEN .                   *LOCATE NEXT ENTRY
         EJECT
MOVEDEVT EQU   * .
         LA    R01,DEVCDTBL .               *START OF DEVICE TABLE
         LA    R15,LSTENTRY-1 .             LAST BYTE USED
DEVTLOOP EQU   * .
         LH    R14,4(,R01) .                *LOAD VARIABLE LENGTH PART
         CLC   VOLDEVCD,0(R01) .            *IS THIS THE ONE/Q
         BE    HITDEVCD .                   *BRANCH IF YES
         LA    R14,6(,R14) .                *ADD FIXED PORTION
         BXLE  R01,R14,DEVTLOOP .           *DO ENTIRE TABLE
         OI    FLAGS,NOHITBIT .             *DID NOT FIND IT
         LA    PCHPTR,6(,PCHPTR) .          *LEAVE ROOM FOR ONE
         BR    RETURNR .                    *RETURN
HITDEVCD EQU   * .
         BCTR  R14,0 .                      *GET MACHINE LENGTH
         EX    R14,DEVCDMVC .               *MOVE UNIT TYPE
         LA    PCHPTR,1(R14,PCHPTR) .       *NEXT AVAILABLE COLUMN
         BR    RETURNR .                    *RETURN
*
* END OF FILE ROUTINE
*
EOFRDR   EQU   * .
*        CTLG  CLOSE                        CLOSE AND RELEASE CORE
         CTLG  CLOSE .                      CLOSE AND RELEASE CORE
         LA    R02,READER .                 *LOAD DCB ADDRESS
         BAL   RETURNR,CLOSE .              *GO CLOSE AND FREEPOOL
         LA    R02,PUNCHER .                *LOAD DCB ADDRESS
         BAL   RETURNR,CLOSE .              *GO CLOSE AND FREEPOOL
         LA    R02,PRINTER .                *LOAD DCB ADDRESS
         BAL   RETURNR,CLOSE .              *GO CLOSE AND FREEPOOL
         L     R13,4(R13) .                 *LOAD SAVE AREA PTR
         LM    R14,R12,12(R13) .            *RESTORE REGISTERS
RTNCODE  LA    R15,0 .                      *LEAVE LABEL ON THIS CARD
         BR    R14 .                        *RETURN
*
* READ CATALOG BLOCK ROUTINE
*
READBLK  EQU   * .
*        CTLG  GETBYTTR,TTR                 *GET SPECIFIC RECORD
         CTLG  GETBYTTR,TTR .               *GET SPECIFIC RECORD
         LTR   R15,R15 .                    *CHK RETURN CODE
         BZ    READOKAY .                   *ALL RIGHT
         DC    H'0' .                       STOP HERE *****************
READOKAY EQU   * .
         LR    BLKPTR,R01 .                 *LOAD CURRENT BLOCK ADDRESS
         BR    RETURNR .                    *RETURN
         EJECT
PUSHBLK  EQU   * .
         LM    R14,R15,BLKINDEX .           *LOAD F'INDEX',A(TABLE)
         LTR   R15,R15 .                    *ARE WE USING PUSH/POP/Q
         BZ    READBLK .                    *BRANCH IF NOT
         AR    R15,R14 .                    *LOAD A(AVAILABLE ENTRY)
         MVC   0(256,R15),0(BLKPTR) .       *SAVE CURRENT DATA BLOCK
         AH    R14,H256 .                   *INCREMENT TO NEXT FREE
         CH    R14,H5376 .                  *MORE THAN IN TABLE/Q
         BL    *+6 .                        *BRANCH IF NOT
         DC    H'0' .                       *WHOA
         ST    R14,BLKINDEX .               *SAVE FOR NEXT TIME
         B     READBLK .                    *GO READ NEXT BLK
         SPACE 3 .
POPBLK   EQU   * .
         LM    R14,R15,BLKINDEX .           *LOAD F'INDEX',A(TABLE)
         LTR   R15,R15 .                    *ARE WE USING PUSH/POP/Q
         BZ    READBLK .                    *BRANCH IF NOT
         SH    R14,H256 .                   *BACK UP ONE ENTRY
         BNM   *+6 .                        *TOO FAR BACK = 0C1
         DC    H'0' .                       *STOP
         ST    R14,BLKINDEX .               *SAVE FOR NEXT TIME
         LA    BLKPTR,0(R14,R15) .          *SET POINTER TO BLK
         BR    RETURNR .                    *RETURN
         SPACE 3 .
ADJQUEUE EQU   * .
         LH    R14,NAMELGTH .               *LOAD LENGTH OF DSNAME
         LA    R15,NAMEAREA-1(R14) .        *LOAD BACK-SCAN POINTER
         MVI   NAMEAREA-1,C'.' .            *BE SURE TO STOP
ONCEMORE EQU   * .
         BCTR  R15,0 .                      *BACK-UP ONE COLUMN
         CLI   0(R15),C'.' .                *BACK TO A PERIOD YET/Q
         BE    *+8 .                        *BRANCH OUT IF YES
         BCT   R14,ONCEMORE .               *GO LOOK AT PREVIOUS COLUMN
         BCTR  R14,0 .                      *ADJUST LENGTH DOWN ONE
         STH   R14,NAMELGTH .               *SAVE FOR NEXT TIME
         LH    R14,NOQENTS .                *LOAD NUMBER OF QUEUE ENTR
         BCTR  R14,0 .                      *SUBTRACT ONE
         STH   R14,NOQENTS .                *SAVE FOR LATER USE
         MH    R14,H14 .                    *TIMES LENGTH = DISPLACEMNT
         LA    QUEUEPTR,QTABLE(R14) .       *POINT TO PRIOR ENTRY
         BR    RETURNR .                    *RETURN
         EJECT
*
* PRINT PAGE HEADING ROUTINE
*
HEADING1 EQU   * .
         ST    RETURNR,SAVERTN1 .           *SAVE RETURN ADDRESS
         ZAP   LINECTR,MAXLINES .           *RESET LINE COUNT
         MVI   FORMCTRL,SKPTOCH1 .
         MVC   PRINTWRK+35-L'HDGLINE1/2(L'HDGLINE1),HDGLINE1 .     R002
         MVC   PRINTWRK+70(4),PAGEID .                             R002
         AP    PAGENUMP,P1 .                *ADD ONE TO PAGE COUNTER
         UNPK  PRINTWRK+75(4),PAGENUMP .    *UNPACK INTO PRINT LINER002
         OI    PRINTWRK+78,X'F0' .          *MAKE INTO EBCDIC NUMBER002
         BAL   RETURNR,PRINT .              *PRINT HEADING LINE 1
         MVC   PRINTWRK+35-L'HDGLINE2/2(L'HDGLINE2),HDGLINE2 .     R002
         MVC   PRINTWRK+62(17),HDGLINEA .   *DATE AND TIME         R002
         L     RETURNR,SAVERTN1 .           *RESTORE RETURN ADDRESS
         B     PRINT .                      *PRINT LINE 2 AND RETURN
*
* COLUMN HEADING ROUTINE
*
HEADING2 EQU * .
         ST    RETURNR,SAVERTN3 .           *SAVE RETURN ADDRESS
         MVI   FORMCTRL,SPACE2 .
         MVC   PRINTWRK+9(4),NAMEHDG .
         MVC   PRINTWRK+44(L'RESTOF2),RESTOF2 .CREATE REST OF HEADIR002
         BAL   RETURNR,PRINT .              *PRINT COLUMN HEADINGS
         L     RETURNR,SAVERTN3 .           *RESTORE RETURN ADDRESS
         B     PRINT .                      *BLANK LINE AND RETURN
*
* PRINT ROUTINE
*
PRINT    EQU   * .
*        PUT   PRINTER,PRINTREC             *WRITE PRINT LINE
         PUT   PRINTER,PRINTREC .           *WRITE PRINT LINE
         NI    FORMCTRL,X'30' .             *TURN OFF UNWANTED BITS
         SR    R01,R01 .                    *ZERO REGISTER
         IC    R01,FORMCTRL .               *LOAD MODIFIED CONTROL
         MVC   PRINTREC,PRINTREC-1 .        *BLANK PRINT LINE
         SRL   R01,4 .                      *MOVE TO LOW ORDER 2 BITS
         LA    R01,NMBRLINS(R01) .          *POINT TO NUMBER OF LINES
         SP    LINECTR,0(1,R01) .           *SUBTRACT FROM LINES LEFT
         BPR   RETURNR .                    *NO NEW PAGE NEEDED YET
         ST    RETURNR,SAVERTN2 .           *SAVE RETURN ADDRESS
         BAL   RETURNR,HEADING1 .           *PAGE HEADINGS
         L     RETURNR,SAVERTN2 .           *RESTORE RETURN ASDRESS
         B     HEADING2 .                   *COLUMN HEADINGS AND RETURN
         EJECT
*
* NEWCARD ROUTINE
*
* CHECK TO SEE IF ENOUGH ROOM IS LEFT ON CURRENT CARD
*   IF NOT, PUNCH CURRENT CARD IMAGE AND SET UP NEW AREA
*
CHKSPACE EQU   * .
         LA    R15,COL72 .                  *LOAD END ADDRESS ON CARD
         SR    R15,PCHPTR .                 *SUBTRACT CURRENT ADDRESS
         CR    R06,R15 .                    *IS THERE ROOM ON CARD/Q
         BNHR  RETURNR .                    *RETURN IF ROOM
         MVI   COL72,C'C' .                 *CONT CHAR IN COL 72
*
* INCREMENT SORT COUNTER AND PUNCH THE CARD ROUTINE
*
CNTNPCH  EQU   * .
         AP    SRTCOUNT,P1 .                *ADD ONE TO COUNT
         UNPK  SORTCODE+1(7),SRTCOUNT .     *SORT COUNT IN COLS 74-80
         OI    SORTCODE+7,X'F0' .
*        PUT   PUNCHER,PUNCHREC             *PUNCH CARD OUT
         PUT   PUNCHER,PUNCHREC .           *PUNCH CARD OUT
         MVC   PUNCHREC(72),PUNCHREC-1 .    *BLANK COLUMNS 1-72
         LA    PCHPTR,PARMCONT .            *SET PTR TO COL 16
         BR    RETURNR .
*
* NAME MOVE ROUTINE
*
MOVERTN  EQU   * .
         LA    R14,1 .                      *INCREMENT AMOUNT
         LA    R15,6(,R03) .                *END ADDRESS
         LR    R01,R03 .                    *START ADDRESS
MOVELOOP EQU   * .
         CLI   1(R01),C' ' .                *END OF NAME/Q
         BE    MOVEHIT .                    *BRANCH IF YES
         BXLE  R01,R14,MOVELOOP .           *INCREMENT, TEST, BRANCH
MOVEHIT  EQU   * .
         SR    R01,R03 .                    *END-BEGIN-1=MACH. LENGTH
         EX    R01,MOVENAME .               *MOVE THE NAME
         LA    R05,1(,R01) .                *PUT TRUE LENGTH IN R05
         BR    RETURNR .                    *RETURN
         EJECT
*
* SEE IF DEVICE TYPE NOT FOUND FOR PUNCH OPERATION
*
NOHITEST EQU   * .
         TM    FLAGS,NOHITBIT .             *WERE ALL DEVTYPES FOUND/Q
         BZR   RETURNR .                    *YES, ALL WERE FOUND
         ST    RETURNR,SAVERTN7 .           *SAVE RETURN ADDRESS
         MVI   FORMCTRL,SPACE2 .
         MVC   PRINTWRK(L'DTNFIT),DTNFIT .  *DEVICE TYPE NOT FOUND
         MVC   PRINTWRK+L'DTNFIT+1(L'SPICN),SPICN SPACE PRIVIDED IN CAR
         MVC   PRINTWRK+L'DTNFIT+L'SPICN+2(8),SORTCODE SEQUENCE NUMBER
         BAL   RETURNR,PRINT .                                     R002
         MVC   PRINTWRK+L'DTNFIT+1(L'F6CDN),F6CDN 4 6 CHAR DEVNAME R002
         BAL   RETURNR,PRINT .
         NI    FLAGS,XFF-NOHITBIT .         *RESET BIT
         MVI   RTNCODE+3,X'08' .            *RETURN CODE OF 8
         L     RETURNR,SAVERTN7 .           *RELOAD RETURN ADDRESS
         B     PRINT .                      *BLANK LINE AND RETURN
*
* BUILD INDEX NAME ROUTINE
*
BLDNAME  EQU   * .
         ST    RETURNR,SAVERTN4 .           *SAVE RETURN ADDR
         LA    QUEUEPTR,QTABLE .            *SET PTR ON 1ST ENTRY
         LH    R04,NOQENTS .                *SET LOOP COUNTER
         LA    R06,NAMEAREA .               *SET POINTER TO BUILD AREA
LOOPER   EQU   * .
         LA    R03,QELNAME .                *SET UP PTR TO NAME
         BAL   RETURNR,MOVERTN .            *MOVE NAME TO BUILD AREA
         AR    R06,R05 .                    *INCREMENT PTR TO NAME AREA
         MVI   0(R06),C'.' .                *PERIOD
         LA    R06,1(R06) .                 *INCREMENT PTR TO NAME AREA
         LA    QUEUEPTR,14(QUEUEPTR) .      *INCREMENT QUEUE PTR
         BCT   R04,LOOPER .
         LA    R04,NAMEAREA .
         SR    R06,R04 .                    *COMPUTE LENGTH OF INDEX
         STH   R06,NAMELGTH .
         L     RETURNR,SAVERTN4 .           *RESTORE RETURN ADDRESS
         BR    RETURNR .                    *RETURN
*
* LOCATE NEXT AVAILABLE QUEUE ELEMENT ROUTINE
*
NEXTQEL  EQU   * .
         LH    R03,NOQENTS .
         LA    R03,1(R03) .                 *ADD 1 TO NO IN QUEUE
         TM    DCBOFLGS(R02),X'10' .        *IS DCB OPEN/Q
         STH   R03,NOQENTS .
         BCTR  R03,0 .                      *MINUS 1 TO GET DISPLACEMNT
         MH    R03,H14 .                    *MULTIPLY BY ELEMENT LGTH
         LA    QUEUEPTR,QTABLE(R03) .       *LOCATE 1ST AVAILABLE SLOT
         MVC   QELTTR,TTR .                 *SAVE ADDRESS OF BLK
         MVC   QELNAME,ENTNAME .            *SAVE INDEX NAME
         LR    R15,INDEXPTR .               *LEAVE CURRENT POINTER
         SR    R15,BLKPTR .                 *GET DISPLACEMENT IN BLOCK
         STH   R15,QELDISP .                *SAVE IN TABLE
         BR    RETURNR .                    *RETURN
         EJECT
*
* CLOSE AND FREEPOOL ROUTINE
*
CLOSE    EQU   * .
         BZR   RETURNR .                    *RETURN IF NOT
*        CLOSE ((R02))
         CLOSE ((R02)) .
         TM    DCBBUFCB+2(R02),X'01' .      *DO BUFFER EXIST/Q
         BOR   RETURNR .                    *RETURN IF NO
*        FREEPOOL (R02)
         FREEPOOL (R02) .
         BR    RETURNR .                    *RETURN
         SPACE 3 .
OPENEXIT EQU   * .
         LH    R05,DCBBLKSI(,R01) .         *LOAD BLKSIZE FROM DCB
         LH    R15,DCBLRECL(,R01) .         *LOAD LRECL FROM DCB
         SR    R04,R04 .                    *ZERO FOR DIVISION
         DR    R04,R15 .                    *BLKSIZE/LRECL=BLK FACTOR
         LTR   R05,R05 .                    *AT LEAST ONE LRECL/Q
         BNZ   *+8 .                        *BRANCH IF YES
         LA    R05,1 .                      *MAKE BLKSIZE=LRECL
         MH    R05,DCBLRECL(,R01) .         *BLK FACTOR*LRECL=BLKSIZE
         STH   R05,DCBBLKSI(,R01) .         *STORE INTO DCB
         BR    R14 .                        *RETURN TO FINISH OPEN
         SPACE 3
PARMERR  DC    0F'0' .                                             R003
         BAL   R01,WTPRC16 .                *GO ISSUE WTP          R003
*        WTO   'PARM FIELD IN ERROR',ROUTCDE=(11),MF=L             R003
         WTO   'PARM FIELD IN ERROR',ROUTCDE=(11),MF=L             R003
         EJECT
NOTOPEN1 DC    0F'0' .                                             R003
         BAL   R01,WTPRC16 .                *GO ISSUE WTP          R003
*        WTO   'OPEN FAILED FOR ''SYSPRINT''',ROUTCDE=(11),MF=L    R003
         WTO   'OPEN FAILED FOR ''SYSPRINT''',ROUTCDE=(11),MF=L    R003
WTPRC16  DC    0H'0' .                                             R003
         SVC   35 .                         *PUT IN JOBQUE SMB     R003
         MVI   RTNCODE+3,X'10' .            *SET RETURN CODE
         B     EOFRDR .                     *GET OUT
*
* INVALID FUNCTION CODE
*
ERR01RTN EQU   * .
         MVC   PRINTWRK(L'RCNR),RCNR .      *REQUEST CODE INVALID
         B     FNDCOMON .                   *GO MOVE REST
*
* WRONG BLOCK ROUTINE
*
ERR02RTN EQU   * .
         MVC   PRINTWRK(L'EIRIB),EIRIB .    *ERROR IN READING INDEX BLK
         MVC   PRINTWRK+L'EIRIB+1(L'ICE),ICE INDEX CONTROL ENTRY FOUND
         LA    R14,PRINTWRK+L'EIRIB+L'ICE+2 *OUTPUT LOCATION
         B     FATCOMON .                   *GO MOVE REST
*
* INVALID ENTRY ROUTINE
*
ERR03RTN EQU   * .
         MVC   PRINTWRK(L'IET),IET .        *INVALID ENTRY TYPE FOUND
         LA    R14,PRINTWRK+L'IET+1 .       *OUTPUT LOCATION
         B     FATCOMON .                   *GO MOVE REST
*
* NO DDCARD SUPPLIED FOR SYSCTLG DATA SET
*
ERR04RTN EQU   * .
         MVC   PRINTWRK(L'NDFCV),NDFCV .    *NO DDCARD FOR CATLG VOLUME
         B     FNDCOMON .                   *GO GIVE NEXT PART
*
* NO INDEX CONTROL ENTRY ROUTINE
*
ERR06RTN EQU   * .
         MVC   PRINTWRK(L'NICE),NICE .      *NO INDEX CONTROL ENTRY
         LA    R14,PRINTWRK+L'NICE+1 .      *OUTPUT LOCATION
         B     FATCOMON .                   *GO MOVE REST
*
* INVALID GENERATION INDEX FLAGS ROUTINE
*
ERR07RTN EQU   * .
         MVC   PRINTWRK(L'IFIGI),IFIGI .    INVALID GEN.INDEX FLAGS
         LA    R14,PRINTWRK+L'IFIGI+1 .     *OUTPUT LOCATION
         B     FATCOMON .                   *GO MOVE REST
         EJECT
*
* DDCARD COULD NOT BE OPENED
*
ERR09RTN EQU   * .
         MVC   PRINTWRK(L'CNOD),CNOD .      *COULD NOT OPEN DDCARD
         MVC   PRINTWRK+L'CNOD(8),0(R15) .  *PUT DDNAME INTO PRINTLINE
         MVI   PRINTWRK+L'CNOD+8,C'''' .    *ENDING QUOTE MARK
         MVI   PRINTWRK+L'CNOD+10,C'-' .    *PUT IN A DASH
         B     FNDCOMON .                   *GO MOVE REST
*
* UNIT TYPE FOR SYSCTLG DEVICE COULD NOT BE FOUND IN TABLE
*
ERR10RTN EQU   * .
         MVC   PRINTWRK(L'DTNFIT),DTNFIT .  *DEVICE TYPE NOT FOUND
         MVC   PRINTWRK+L'DTNFIT-1(L'FDN),FDN FOR DDCARD NAMED
         MVC   PRINTWRK+L'DTNFIT+L'FDN-1(8),DDNAME MOVE DDNAME TO PRINT
         MVI   PRINTWRK+L'DTNFIT+L'FDN+8,C'''' ENDING QUOTE MARK
         MVI   PRINTWRK+L'DTNFIT+L'FDN+10,C'-' PUT IN A DASH
         B     FNDCOMON .                   *GO MOVE REST
*
* TOO MANY REQUESTS FOR PUNCHING A CATALOG
*
ERR11RTN EQU   * .
         MVC   PRINTWRK(L'TMPR),TMPR .      *TOO MANY PUNCH REQUESTS
         B     FNDCOMON .                   *GO MOVE REST
FNDCOMON EQU   * .
         MVI   FORMCTRL,SKPTOCH1 .          *PAGE EJECT THEN PRINT R002
         ZAP   LINECTR,MAXLINES .           *NEW PAGE, RESET COUNTER002
         BAL   RETURNR,PRINT .                                     R002
         MVC   PRINTWRK+10(L'FND),FND .     *FOLLOWING NOT DONE -  R002
         MVC   PRINTWRK+L'FND+11(L'FUNCTION),FUNCTION MOVE REQUEST R002
         MVC   PRINTWRK+L'FND+L'FUNCTION+12(L'DEVSER),DEVSER MOVE  R002
         B     ERRWRITE .                   *GIVE MESSAGE
FATCOMON EQU   * .
         MVC   0(L'FAT,R14),FAT .           *FOUND AT TTR
         UNPK  L'FAT+1(7,R14),TTR(4) .      *PUT TTR INTO PRINT LINE
         TR    L'FAT+1(6,R14),HEXTABLE .    *MAKE PRINTABLE
         MVI   L'FAT+7(R14),C' ' .          *BLANK LAST CHARACTER
         MVI   FORMCTRL,SKPTOCH1 .          *PAGE EJECT THEN PRINT R002
         ZAP   LINECTR,MAXLINES .           *NEW PAGE, RESET COUNTER002
         B     ERRWRITE .                   *PRINT MSG AND SET RETCODE
ERRWRITE EQU   * .
         BAL   RETURNR,PRINT .
         MVI   RTNCODE+3,X'08' .            *RETURN CODE OF 8
         TM    READER+DCBOFLGS,X'10' .      *IS INPUT FILE OPEN/Q
         BO    RDCARD .                     *YES, GO GET A CARD
         B     EOFRDR .                     *GET OUT
*
DEVCDMVC MVC   0(0,PCHPTR),6(R01) .
NAMEMOVE MVC   0(0,R06),NAMEAREA .
CVOLMVC  MVC   0(0,PCHPTR),CVOLOP .
MOVENAME MVC   0(0,R06),0(R03) .
NAMEPRNT MVC   PRINTWRK(0),NAMEAREA .
         AIF   ('&SYSTEM' EQ '370').NOT360B
XCLR     XC    0(0,01),0(R01) .         SUBJECT OF EX INSTRUCTION
.NOT360B ANOP
         CNOP  0,4 .
         EJECT
*READER  DCB   DSORG=PS,LRECL=80,EODAD=EOFRDR,MACRF=GL,DDNAME=SYSIN,   X
               BUFNO=1,EXLST=JOBFILE
READER   DCB   DSORG=PS,LRECL=80,EODAD=EOFRDR,MACRF=GL,DDNAME=SYSIN,   X
               BUFNO=1,EXLST=JOBFILE
         EJECT
*PRINTER DCB   DSORG=PS,MACRF=PM,LRECL=080,RECFM=FBA,DDNAME=SYSPRINT,  X
               EXLST=JOBFILE .                                     R002
PRINTER  DCB   DSORG=PS,MACRF=PM,LRECL=080,RECFM=FBA,DDNAME=SYSPRINT,  X
               EXLST=JOBFILE .                                     R002
         EJECT
*PUNCHER DCB   DSORG=PS,LRECL=80,RECFM=FB,MACRF=PM,DDNAME=PCHFILE,     X
               EXLST=JOBFILE
PUNCHER  DCB   DSORG=PS,LRECL=80,RECFM=FB,MACRF=PM,DDNAME=PCHFILE,     X
               EXLST=JOBFILE
         EJECT
* WORK AREAS
*
CNTRLNAM DC    X'0000000000000001'
LINKENT  DC    8X'FF'
BLKINDEX DC    2F'0'
BLKTABLE EQU   BLKINDEX+4 .
JOBFILE  DC    0F'0',X'85',AL3(OPENEXIT)
H1       DC    H'1'
H4       DC    H'4'
H14      DC    H'14'
H256     DC    H'256'
H5376    DC    H'5376'
NOQENTS  DC    H'0'
*
* DEVICE CODE NAME TABLE
*
DEVCDTBL DC    0H'0'
         DC    X'30002001',H'4',C'2311'
         DC    X'30002003',H'4',C'2303'
         DC    X'30002004',H'4',C'2302'
         DC    X'30008001',H'4',C'2400'
         DC    X'3010200E',H'4',C'3380'               SADSC 13OCT83
         DC    X'30402002',H'4',C'2301'
         DC    X'30502006',H'6',C'2305-1'             AFDSC 11MAY78
         DC    X'30502007',H'6',C'2305-2'             AFDSC 11MAY78
         DC    X'30502009',H'4',C'3330'
         DC    X'3050200B',H'4',C'3350'               AFDSC 26MAR81
         DC    X'3050200D',H'6',C'3330-1'             AFDSC 26MAR81
         DC    X'3070200D',H'6',C'3330-1'             AFDSC 26MAR81
         DC    X'30702009',H'4',C'3330'
         DC    X'30C02008',H'4',C'2314'
         DC    X'30E02008',H'4',C'2314'
         DC    X'30808001',H'6',C'2400-1'
         DC    X'30C08001',H'6',C'2400-2'
         DC    X'30C08003',H'6',C'3400-2'             AFDSC 11MAY78
         DC    X'32008003',H'6',C'3400-5'             AFDSC 11MAY78
         DC    X'32108003',H'6',C'3400-6'             AFDSC 11MAY78
         DC    X'34008001',H'6',C'2400-3'
         DC    X'34008003',H'6',C'3400-3'             AFDSC 11MAY78
         DC    X'34208001',H'6',C'2400-4'
         DC    X'34208003',H'6',C'3400-4'             AFDSC 11MAY78
         DC    X'30582009',H'5',C'3330V'              AFDSC 26MAR81
         DC    X'30782009',H'5',C'3330V'              AFDSC 26MAR81
         DC    X'3010200C',H'4',C'3375'                             @KL
         DC    X'3010200E',H'4',C'3380'                             @KL
         DC    X'3010200F',H'4',C'3390'                             @KL
LSTENTRY EQU   * .
PAGEID   DC    C'PAGE'
         DC    C' '                         *MUST PRECEDE ''PUNCHREC''
PUNCHREC DC    CL80' '
PARMCONT EQU   PUNCHREC+15 .
COL72    EQU   PUNCHREC+71 .
SORTCODE EQU   PUNCHREC+72 .
         DC    C' '                         *MUST PRECEDE ''PRINTREC''
PRINTREC DC    CL100' '
         ORG   PRINTREC .
FORMCTRL DC    C' '
PRINTWRK DC    CL99' '
STATHEAD DC    C'SYSCTLG STATISTICS'
BLKHEADS DC    C'INDEX BLOCKS USED   INDEX BLOCKS FREE' .          R002
RESTOF2  DC    C'ENTRY TYPE DEVICE  VOL.ID   SEQ' .                R002
VOLIDHDG EQU   RESTOF2+19 .                                        R002
CVOLOP   DC    C'CVOL=XXXX-X=123456,'
         ORG   CVOLOP+1 .
KVOL     DC    C'VOL='
         ORG
* HWCTTABL = HALF WORD COUNT TABLE MAPS THE LENGTH OF EACH CATALOG R002
*   ENTRY TYPE INTO AN INDEX FOR A BRANCH TABLE.                   R002
NMBRLINS DC    PL1'1,0,3,2' .               *LINES FOR X'40XX60FX'
HWCTTABL DC    AL1(12,16,20,8,24,8,0,4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,X
               0,4,0,0,0,0,0,4)
KALIAS   DC    C'ALIAS='
KBLDA    DC    C'BLDA'
KBLDG    DC    C'BLDG'
KBLDX    DC    C'BLDX'
KCATLG   DC    C'CATLG'
KCONNECT DC    C'CONNECT'
KCVOLPTR DC    C'CVOL PTR'
KDELETE  DC    C'DELETE'
KDSNAME  DC    C'DSNAME='
         ORG   KDSNAME+2 .
NAMEHDG  DC    C'NAME'
         ORG
KEMPTY   DC    C'EMPTY'
KENTRIES DC    C'ENTRIES='
KEQPAREN DC    C'=('
KINDEX   DC    C'INDEX='
KPRINT   DC    C'PRINT'
KPTPCH   DC    C'PTPCH'
KPUNCH   DC    C'PUNCH'
P0       DC    P'0'
P1       DC    P'1'
MAXLINES DC    CL3'061' .                                          R003
HDAT     DC    X'40202120204B202020'
HDGLINEA EQU   HDAT+3
         DC    C'  '
HTIM     DC    X'4021204B20204B2020'
HDGLINE1 DC    C'CATPTPCH - LISTING OF CATALOGED DATA SETS, ALIASES, CVX
               OL POINTERS,'
         ORG   HDGLINE1+32 .
KDATASET DC    C'DATA SET'
         ORG
HDGLINE2 DC    C'AND INDEXES FROM SYSCTLG ON VOLUME 123456'
         ORG   HDGLINE2+L'HDGLINE2-6 .
DEVSER   DC    CL6' '
         ORG
DFLTCVDT DC    C'3330='
PGMEQDD  DC    C'PGM=*.DD'
NDFCV    DC    C'NO DDCARD FOR CATALOG VOLUME -'
EIRIB    DC    C'ERROR IN READING INDEX BLOCK -'
IET      DC    C'INVALID ENTRY TYPE'
NICE     DC    C'NO INDEX CONTROL ENTRY'
         ORG   NICE+3 .
ICE      DC    C'INDEX CONTROL ENTRY'
DTNFIT   DC    C'DEVICE TYPE NOT FOUND IN TABLE -'
SPICN    DC    C'SPACE PROVIDED IN CARD NUMBER'
RCNR     DC    C'REQUEST CODE NOT RECOGNIZED -'
CNOD     DC    C'OPEN FAILED FOR DDCARD NAMED '''
         ORG   CNOD+L'CNOD-18 .
FDN      DC    C'FOR DDCARD NAMED '''
TMPR     DC    C'TOO MANY PUNCH REQUESTS -'
FND      DC    C'FOLLOWING NOT DONE -'
F6CDN    DC    C'FOR 6 CHARACTER DEVICE NAME'
IFIGI    DC    C'INVALID FLAGS IN GEN. INDEX'
         ORG   IFIGI+L'IFIGI-10 .
ALIASOF  DC    C'IS AN ALIAS OF' .                                 R002
GENINDEX DC    C'GEN. NDX MAX NO=' .                               R002
FAT      DC    C'FOUND AT TTR ='
*
* SWITCHES
FLAGS    DC    X'00'
DDMODFR  DC    X'EF'
HEXTABLE EQU   *-X'F0' .                    *ONE OF TWO     DO NOT MOVE
         DC    C'0123456789ABCDEF' .        *TWO OF TWO     DO NOT MOVE
         LTORG
*
SEQNUMCV DS    D
DDNTRYAD DS    F
SAVERTN1 DS    F
SAVERTN2 DS    F
SAVERTN3 DS    F
SAVERTN4 DS    F
SAVERTN5 DS    F
SAVERTN6 DS    F
SAVERTN7 DS    F
SAVERTN8 DS    F
NAMELGTH DS    H
CVOLENTH DS    H
QTABLE   DS    21CL14 .                     *INDEX NAME AND LOC QUEUE
TTR      DS    CL3                          *TRACK AND RECORD ADDR
SAVETTR  DS    CL3
LINECTR  DS    PL2
PAGENUMP DS    PL3
SRTCOUNT DS    PL4
FUNCTION DS    CL5
DDNAME   DS    CL8
         DS    C .                          *MUST PRECEDE 'NAMEAREA'
NAMEAREA DS    CL44 .                       *MUST HAVE 1 BYTE PRIOR
         EJECT
* DSECTS
*
ENTDSECT DSECT
ENTNAME  DS    CL8
ENTTTR   DS    CL3
ENTHWCT  DS    CL1
*
*
GIFLAGS  DS    CL1
GIMXENTS DS    CL1
GICURENT DS    CL2
*
*
         ORG   GIFLAGS .
ALIASTRN DS    CL8
*
*
         ORG   GIFLAGS .
CVOLSRNO DS    CL6
*
         ORG   GIFLAGS .
NCVOLDVT DS    CL4
NCVOLSER DS    CL6
*
         ORG   GIFLAGS .
DSPVOLCT DS    CL2
*
*
QELEMENT DSECT .                            *OVERLAY FOR QUEUE ELEMENTS
QELTTR   DS    CL3,CL1
QELDISP  DS    CL2
QELNAME  DS    CL8
*
*
VOLINFO  DSECT .                            *OVERLAY OF VOLUME INFO
VOLDEVCD DS    CL4
VOLSRNUM DS    CL6
VOLSEQNO DS    CL2
         MEND
         CATPTPCH SYSTEM=370
         END
//*
//ASM2   EXEC PGM=IFOX00,PARM=(NOLOAD,DECK),REGION=768K
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB
//         DD DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSALLDA,SPACE=(1700,(600,100))
//SYSUT2   DD DSN=&&SYSUT2,UNIT=SYSALLDA,SPACE=(1700,(600,100))
//SYSUT3   DD DSN=&&SYSUT3,UNIT=SYSALLDA,SPACE=(1700,(600,100))
//SYSPRINT DD SYSOUT=*
//SYSGO    DD DUMMY
//SYSLIN   DD DUMMY
//SYSPUNCH DD DSN=&&OBJSET,DISP=(MOD,PASS),VOL=REF=*.ASM1.SYSPUNCH
//SYSIN    DD *
         MACRO
         CTLGACCS &SYSTEM=360,&MAXCORE=16777208 .
         LCLA  &I .
         AIF   ('&SYSTEM' EQ '360' OR '&SYSTEM' EQ '370').SYSOK
         MNOTE 8,'SYSTEM=&SYSTEM INCORRECT - MUST BE 360 OR 370'
         MEXIT
.SYSOK   ANOP
         AIF   (&MAXCORE GE 296 AND &MAXCORE LT 16777209).COREOK
         MNOTE 8,'MAXCORE=&MAXCORE INCORRECT - MUST BE NUMERIC AND BETWX
               EEN 296 AND 16777208'
         MEXIT
.COREOK  ANOP
CTLG TITLE '  C A T A L O G   A C C E S S   M E T H O D'
         MNOTE *,'THIS GENERATION HAS SYSTEM=&SYSTEM AND'
         MNOTE *,'   MAXCORE=&MAXCORE'
*
* PURPOSE -
*
*       THE PURPOSE OF THIS PROGRAM IS TO PROVIDE AN ACCESS METHOD TO
*  RETRIEVE CATALOG BLOCKS FROM AN O/S SYSTEM CATALOG EASILY AND
*  CHEAPLY.  ALL ACCESS IS BY THE 'LOCATE' MODE, THAT IS, WITH THE
*  ADDRESS OF THE DATA BLOCK RETURNED IN REGISTER 1.
*
*
* RESTRICTIONS AND WARNINGS -
*
*     CATALOGS ARE NOT SUPPORTED ON DATACELLS
*
*     SINCE THE CATALOG ACCESS METHOD TAKES ALL BUT 4K OF THE AVAILABLE
*  STORAGE, IF ANY OTHER IS TO REMAIN AVAILABLE FOR OTHER PURPOSES IT
*  MUST BE ACQUIRED BEFORE THE OPEN, AND THEN RELEASED AFTER THE OPEN.
*
* INPUTS -
*
*  REGISTERS 0 AND 1 MUST CONTAIN THE FOLLOWING VALUES -
*        OPEN SETS THE READ CCW'S SO THAT ONLY THE DATA PORTION OF
*        RECORDS IS RETURNED WHEN A 'GET' IS REQUESTED.  OPENWKEY SETS
*        THE READ CCW'S SO THAT BOTH THE KEY AND DATA PORTIONS OF
*        RECORDS ARE RETURNED WHEN A 'GET IS REQUESTED.  THE 8 BYTE
*        KEY (IF PRESENTED) IS IN FRONT OF THE 256 BYTE DATA RECORD.
* OPEN     R0=1,R1=A(8 CHARACTER LEFT JUSTIFIED DDNAME TO BE OPENED)
* OPENWKEY R0=2,R1=A(8 CHARACTER LEFT JUSTIFIED DDNAME TO BE OPENED)
* GET      R0=3,R1=ANY VALUE - GET THE NEXT (KEY AND) DATA BLOCK ADDRES
* GETBYTTR R0=4,R1=A(3 BYTE RELATIVE TRACK ADDRESS) - GET THE (KEY AND)
*              DATA BLOCK AT THE SPECIFIED TTR.
* CLOSE    R0=5,R1=ANY VALUE - CLOSE THE FILE
*
* OUTPUTS -
*
*     FOR OPEN AND OPENWKEY, THE DCB WILL BE OPENED
*     FOR GET OR GETBYTTR, THE ADDRESS OF THE REQUESTED DATA BLOCK WILL
*          BE RETURNED IN REGISTER 1.
*     FOR CLOSE, THE DCB WILL BE CLOSED
*
*   AUTHOR         DARRELL D. WILCOX
*   INSTALLATION   KING COUNTY SYSTEMS SERVICES
*                  ROOM E-208 KING COUNTY COURTHOUSE
*                  THIRD AT JAMES STREETS
*                  SEATTLE, WA  98104
*   IF MODIFICATIONS OR CORRECTIONS ARE MADE, I WOULD GREATLY
*        APPRECIATE GETTING A COPY OF THEM.
*
* LATEST REVISION DATE -
*        3/1/74 - R001       INCLUDED 370 INSTRUCTIONS NOT USED BEFORE
*        3/1/74 - R002       ADDED TESTS FOR NON-D.A. AND DATACELLS
*        3/1/74 - R003       REMOVED 256 MINIMUM FROM 360 CODE THAT
*                            ZEROES GETMAINED AREA
         EJECT
* MACRO 'CTLG' USAGE -
*
* ONLY ASSEMBLER LANGUAGE PROGRAMS MAY CALL THIS ACCESS METHOD.
* THE MACRO 'CTLG' IS AVAILABLE TO FACILITATE THE CALLING OF THIS
* PROGRAM.  THE FORMATS ALLOWED ARE DESCRIBED BELOW.
*
*     OPEN REQUEST
*
*        CTLG  OPEN,DDNMSYMB      'OPEN' MUST BE CODED AS SHOWN.
*                                 'DDNMSYMB' IS THE ASSEMBLER SYMBOL OF
*                                 AN 8 CHARACTER LEFT-JUSTIFIED DDNAME
*                                 TO BE OPENED FOR INPUT OF DATA BLOCKS
*                                 ONLY (NO KEYS).
*        CTLG  OPENWKEY,DDNMSYMB  SAME AS ABOVE, BUT OPENED WITH KEYS.
*
*     CLOSE REQUEST
*
*        CTLG  CLOSE              'CLOSE' MUST BE CODED AS SHOWN.
*
*     GET REQUEST
*
*        CTLG  GET                'GET' MUST BE CODED AS SHOWN.  WHEN
*                                 R15 = 0, R1 = A(DATA) OR A(KEY+DATA).
*                                 IF R15 NOT = 0, R1 IS INDETERMINATE.
*                                 SEE 'OPENWKEY' ABOVE.
*        CTLG  GETBYTTR,TTRSYMB   'GETBYTTR' MUST BE CODED AS SHOWN.
*                                 'TTRSYMB' IS THE ASSEMBLER SYMBOL
*                                 OF A 3 BYTE AREA CONTAINING THE
*                                 RELATIVE BLOCK ADDRESS OF THE DESIRED
*                                 DATA BLOCK.  SEE 'OPENWKEY' ABOVE.
*
*     ALTERNATE CODINGS -  WHERE A SECOND OPERAND IS CODED, (1) MAY BE
*                          USED IF R1 CONTAINS THE ADDRESS OF THE
*                          REQUIRED AREA.  (REGNAME) MAY ALSO BE USED
*                          WHERE 'REGNAME' IS A SYMBOLIC REGISTER, IF
*                          'REGNAME' IS NOT R0 OR R14.
*
         EJECT
* RETURN CODES -
*
*        0     REQUESTED SERVICE COMPLETED NORMALLY
*                  NO ERRORS WERE FOUND
*        4     END OF DATA
*        8     DCB NOT OPEN
*                  1) DEVICE IS NOT DIRECT ACCESS
*                  2) DEVICE IS A DATACELL
*                  3) DDCARD IS MISSING
*                  4) DD IS A 'DUMMY' OR 'DSN=NULLFILE'
*        12    MORE THAN ONE VOLUME SERIAL ON DDCARD OR NO DDCARD
*        16    PERMANENT I/O ERROR
*        20    INVALID REQUEST CODE
*                  R0 WAS NOT 1,2,3,4 OR 5
*        24    NOT USED
*        28    INVALID REQUEST SEQUENCE
*                  AN OPEN WAS REQUESTED AND DCB IS ALREADY OPEN
*                       OR
*                  A CLOSE WAS REQUESTED AND DCB IS ALREADY CLOSED
*                       OR
*                  A GET WAS REQUESTED AND
*                       1) END-OF-DATA HAD OCCURRED OR
*                       2) A PERMANENT I/O ERROR OCCURRED OR
*                       3) A DATA BLOCK WAS OF AN INCORRECT LENGTH
*        32    NO SYSCTLG DATASET ON VOLUME
*        36    NO CORE FOR DATA
*                  LESS THAN 4360 CONTIGUOUS BYTES WERE AVAILABLE
*        40    CTLGACCS NOT LINKEDDITED WITH CALLING PROGRAM.  THIS
*                  RETURN CODE IS GIVEN ONLY BY THE 'CTLG' MACRO.
         EJECT
CTLGACCS CSECT
.LOOP    ANOP
R&I      EQU   &I .
&I       SETA  &I+1 .
         AIF   (&I LT 16).LOOP
READON   EQU   X'40' .
KEYS     EQU   X'20' .
RESET    EQU   X'00' .
DCBFDAD  EQU   5 .
DCBBUFCB EQU   21 .
DCBIOBA  EQU   28 .
DCBDDNAM EQU   40 .
DCBDEBAD EQU   44 .
DCBOFLGS EQU   48 .
DVCEND   EQU   B'00001000' .            DEVICE END
CHNLEND  EQU   B'00000100' .            CHANNEL END
UNITECP  EQU   B'00000001' .            UNIT  EXCEPTION
DS4DEVDB EQU   75 .
JFCBTSDM EQU   52 .
JFCBNVOL EQU   117 .
JFCBVOLS EQU   118 .
         EJECT
         STM   R14,R12,12(R13) .        SAVE REGISTERS
         LR    R12,R15 .                LOAD BASE REG
         USING CTLGACCS,R12 .
         ST    R13,SAVE+4 .             SAVE REG13
         LR    R15,R13 .
         LA    R13,SAVE .               NEW SAVE AREA
         ST    R13,8(,R15) .            BACK CHAIN
         AR    R0,R0 .                  DOUBLE REQUEST CODE
         AR    R0,R0 .                  DO IT AGAIN
         BNP   SETRC20 .                NOT PLUS MEANS INVALID
         CH    R0,H20 .                 TEST FOR TOO BIG
         BH    SETRC20 .                TOO BIG IS INVALID
         LR    R15,R0 .                 LOAD INTO INDEX REGISTER
         B     *(R15) .                 GO TO PROPER ROUTINE
         B     OPEN .
         B     OPENWKEY .
         B     GET .
         B     GETBYTTR .
         B     CLOSE .
         EJECT
OPENWKEY EQU   * .
         OI    CNTRL,KEYS .             OPEN WITH KEYS REQUESTED
         MVI   MDL2CCW1,RDKYDATA+MULTITRK SET READ KEY-AND-DATA OPCODE
         LA    R9,264 .                 KEY LENGTH + DATA LENGTH
         B     OPENCOMN .               GO TO COMMON OPEN CODE
OPEN     EQU   * .
         MVI   MDL2CCW1,RDDATA+MULTITRK SET READ-DATA OPCODE IN CCW
         LA    R9,256 .                 DATA LENGTH
OPENCOMN EQU   * .
         TM    DCB+DCBOFLGS,X'10' .     IS DCB ALREADY OPEN/Q
         BO    SETRC28 .                YES, MUST DO CLOSE FIRST
         ST    R9,READREGS+4 .          SAVE FOR LATER
         STH   R9,MDL2CCW1+6 .          STORE LENGTH TO BE READ IN CCW
         MVC   DCB+DCBDDNAM(8),0(R1) .  MOVE DDNAME INTO DCB
         MVI   JFCB+JFCBNVOL,X'00' .    SET NUMBER OF VOLUMES TO ZERO
*        RDJFCB DCB
         RDJFCB DCB .
         SPACE 1
         CLI   JFCB+JFCBNVOL,X'01' .    ONE-AND-ONLY-ONE VOLSER/Q
         BNE   SETRC12 .                MORE THAN ONE, OR NO DDCARD
         MVI   JFCB,X'04' .             FIRST BYTE OF VTOC NAME
         MVC   JFCB+1(43),JFCB .        CREATE VTOC NAME BY PROPOGATION
         L     R14,16 .                 A(CVT)
         L     R14,0(,R14) .            A(TCB POINTERS)
         L     R14,4(,R14) .            A(CURRENT TCB)
         L     R14,12(,R14) .           A(TIOT)
         LA    R15,24 .                 INDEX VALUE TO FIRST ENTRY
TIOTLOOP EQU   * .
         AR    R14,R15 .                ADD LENGTH TO START
         AIF   ('&SYSTEM' NE '370').NOT370B
         ICM   R15,1,0(R14) .           LOAD ENTRY LENGTH          R001
         AGO   .END360B
.NOT370B ANOP
         IC    R15,0(,R14) .            LOAD ENTRY LENGTH
         LTR   R15,R15 .                SET CONDITION CODE
.END360B ANOP
         BZ    SETRC8 .                 BRANCH IF ENTRY NOT FOUND
         CLC   DCB+DCBDDNAM(8),4(R14) . DDCARD NAME THE SAME/Q
         BNE   TIOTLOOP .               BRANCH IF NOT WANTED
         AIF   ('&SYSTEM' NE '370').NOT370C
         ICM   R15,7,17(R14) .          LOAD A(UCB ALLOCATED)
         AGO   .END360C
.NOT370C ANOP
         L     R15,16(,R14) .           LOAD A(UCB ALLOCATED)
         LTR   R15,R15 .                SET CONDITION CODE
.END360C ANOP
         BZ    SETRC8 .                 BRANCH IF DUMMY OR NULLFILE
         CLI   18(R15),X'20' .          IS THIS A D.A. DEVICE/Q    R002
         BNE   SETRC8 .                 BRANCH IF NOT              R002
         CLI   19(R15),X'05' .          IS THIS A DATACELL/Q       R002
         BE    SETRC8 .                 BRANCH YES, NOT SUPPORTED  R002
         AIF   ('&SYSTEM' NE '370').NOT370Z
**       MVC   FW,24(R15) .             MOVE TTR0 OF VTOC TO FULLWORD
         MVC   FW,X'24'(R15) .          MOVE TTR0 OF VTOC           @KL
         AGO   .END360Z                                       JDM
.NOT370Z ANOP                                                 JDM
**       MVC   FW,24(R15) .     MOVE TTR0 OF VTOC TO FULLWORD JDM
         MVC   FW,X'24'(R15) .          MOVE TTR0 OF VTOC           @KL
.END360Z ANOP                                                 JDM
         EJECT
         AIF   ('&SYSTEM' NE '370').NOT370D                        JDM
*        DEVTYPE DCB+DCBDDNAM,DSCB,DEVTAB,RPS                     JDM
         DEVTYPE DCB+DCBDDNAM,DSCB,DEVTAB,RPS                     JDM
.NOT370D ANOP
*        DEVTYPE DCB+DCBDDNAM,DSCB,DEVTAB  GET DEVICE CHARACTERISTICS
         DEVTYPE DCB+DCBDDNAM,DSCB,DEVTAB .GET DEVICE CHARACTERISTICS
.END360D ANOP                                                      JDM
         SPACE 1
         LTR   R15,R15                  DEVTYPE OK ???        JDM
         BNZ   ABND1001                 GOODBYE ALL !!!       JDM
         LH    R1,DSCB+10 .             LOAD TRACKS/CYLINDER
         LTR   R1,R1 .                  WAS DEVTYPE SUCCESSFUL/Q
         BZ    SETRC8 .                 BRANCH IF NOT
         LH    R15,FW .                 LOAD TT OF VTOC ADDRESS
         SR    R14,R14 .                ZERO FOR DIVISION
         DR    R14,R1 .                 HOW MANY CYLINDERS/Q
         STH   R15,CCHHR .              STORE CYLINDER ADDRESS
         STH   R14,CCHHR+2 .            STORE HEAD ADDRESS
         MVI   CCHHR+4,X'01' .          WANT FIRST RECORD ON TRACK
         SPACE 3 .
*        OBTAIN CAMLST3                 GET FORMAT 4 DSCB
         OBTAIN CAMLST3 .               GET FORMAT 4 DSCB
         SPACE 1
         LTR   R15,R15 .                TEST FOR SUCCESSFUL
         BNZ   ABND1000 .               BAD BAD BAD
         SR    R0,R0 .                  ZERO REGISTER ZERO
         IC    R0,DSCB+DS4DEVDB .       LOAD NUMBER OF BLOCKS PER TRACK
         STH   R0,BLKSPER .             SAVE IN A SAFE PLACE
         MVI   JFCB,C' ' .              FIRST BYTE IS BLANK
         MVC   JFCB+1(43),JFCB .        BLANK ENTIRE DSNAME
         MVC   JFCB(7),=C'SYSCTLG' .    PUT CATALOG DSNAME IN JFCB
         OI    JFCB+JFCBTSDM,X'08'+X'02' REQUEST 'NO RETURN TO QUEUE' &
*                                         'NO REVERSE MERGE TO DSCB'
         SPACE 3 .
*        OBTAIN CAMLST1                 GET SYSCTLG DSCB
         OBTAIN CAMLST1 .               GET SYSCTLG DSCB
         SPACE 1
         LTR   R15,R15 .                WAS OBTAIN SUCCESSFUL/Q
         BNZ   SETRC32 .                NO SYSCTLG ON THIS PACK
         SPACE 3 .
*        OPEN  DCB,TYPE=J               OPEN FOR INPUT
         OPEN  DCB,TYPE=J .             OPEN FOR INPUT
         SPACE 1
         TM    DCB+DCBOFLGS,X'10' .     DID IT OPEN OKAY/Q
         BZ    SETRC8 .                 BRANCH IF NOT
         MVC   SAVEIOBA,DCB+DCBIOBA .   SAVE BSAM IOB ADDRESS
         LA    R15,IOB .                LOAD ADDRESS OF MY IOB
         ST    R15,DCB+DCBIOBA .        STORE INTO DCB
         EJECT
* GET 4K FOR BLDL, ABEND, AND ANYBODY ELSE THAT NEEDS IT
*        GETMAIN EC,LV=4096,A=HIGHRBLK
         GETMAIN EC,LV=4096,A=HIGHRBLK .
         SPACE 1
         LTR   R15,R15 .                DID I GET RESERVED STORAGE/Q
         BNZ   SETRC36 .                BRANCH IF NOT
         SPACE 3 .
* DO A GETMAIN FOR ALL STORAGE
*        GETMAIN VC,LA=SIZES,A=COREADDR
         GETMAIN VC,LA=SIZES,A=COREADDR .
         SPACE 1
         LR    R6,R15 .                 SAVE RETURN CODE PAST FREEMAIN
         SPACE 3 .
* RELEASE THE 4K RESERVE
*        FREEMAIN E,LV=4096,A=HIGHRBLK
         FREEMAIN E,LV=4096,A=HIGHRBLK .
         SPACE 1
         LTR   R6,R6 .                  DID I GET THE BUFFER STORAGE/Q
         BNZ   SETRC36 .                NO CORE FOR DATA
         SPACE 3 .
         LM    R14,R15,COREADDR .       LOAD ADDRESS AND LENGTH
         LR    R4,R14 .                 SAVE A(BUFFER AREA)
         LR    R5,R15 .                 SAVE BUFFER AREA LENGTH
         AIF   ('&SYSTEM' NE '370').NOT370A
         SR    R1,R1 .                  USE ZERO FILL
         MVCL  R14,R0 .                 CLEAR GETMAIN AREA
         AGO   .END360A .
.NOT370A ANOP
         LR    R1,R14 .                 LOAD GETMAIN AREA ADDRESS
         AR    R15,R14 .                ADD ADDRESS TO LENGTH = A(END)
         LA    R14,256 .                MAXIMUM LENGTH FOR XC INST.
         SR    R15,R14 .                BACK UP 256 BYTES INTO AREA
         CR    R1,R15 .                 IS END BEFORE START/Q      R003
         BH    *+14 .                   BRANCH LESS THAN 256 BYTES R003
         XC    0(256,R1),0(R1) .        ZERO 256 BYTES OF AREA
         BXLE  R1,R14,*-6 .             BRANCH UNTIL WHOLE AREA ZERO
         AR    R15,R14 .                GET TO VERY END AGAIN
         SR    R15,R1 .                 MINUS NEXT ADDRESS TO ZERO
         BNP   *+10 .                   BRANCH IF NO FRACTION OF 256
         BCTR  R15,0 .                  SUBTRACT 1 FOR EX TO XC INST.
         EX    R15,XCLR .               ZERO REMAINING BYTES
.END360A ANOP
         EJECT
* CALCULATE HOW MANY BUFFERS WE HAVE
         LR    R15,R5 .                 LOAD LENGTH GOTTEN
         SH    R15,H24 .                MINUS SIDE,TIC,RDCOUNT CCWS
         LA    R1,8(,R9) .              L'BUFFER+L'CCW TO FILL BUFFER
         SR    R14,R14 .                ZERO FOR DIVISION
         DR    R14,R1 .                 HOW MANY BUFFERS FIT IN CORE/Q
* SINCE GETMAIN WAS FOR AT LEAST 1 BUFFER, NO TEST FOR ZERO IS MADE
         ST    R15,NUMBBUFS .           SAVE NUMBER OF BUFFERS
         LR    R1,R15 .                 SAVE NUMBER OF BUFFERS IN R15
* GENERATE THE CHANNEL PGM
         SLL   R1,3 .                   TIMES 8 (1 CCW PER BUFFER)
* R1 = NUMBER OF BUFFERS * CCW PGM LENGTH PER BUFFER (8) = NUMBER OF
*        CCW PROGRAM BYTES REQUIRED TO READ DATA TO FILL ALL BUFFERS.
         ST    R4,CPGMADDR .            STORE IN IOB
         MVC   MDL1CCW2+1(3),CPGMADDR+1 MOVE TIC ADDRESS INTO CCW
         MVC   0(16,R4),MDL1CCW1 .      MOVE FIRST TWO CCWS
         LA    R4,16(,R4) .             INCREMENT TO OPEN SPOT IN CHAIN
* R1 = LENGTH OF READ CCW'S + RDCOUNT + START ADDR = BUFFER START ADDR
         LA    R1,8(R1,R4) .            LOAD ADDRESS OF FIRST BUFFER
         ST    R1,BUFFADDR .            STORE FOR LATER USE
         MVC   MDL2CCW1+1(3),BUFFADDR+1 MOVE A(FIRST BUFFER) TO READCCW
         LM    R0,R1,MDL2CCW1 .         LOAD CCW INTO REGISTERS
         LA    R14,8 .                  SET CONSTANT INTO REGISTER
GENCCW   EQU   * .
         STM   R0,R1,0(R4) .            STORE CCW INTO CHANNEL PGM
         AR    R0,R9 .                  INCREMENT ADDRESS TO NEXT BUFFR
         AR    R4,R14 .                 A(NEXT OPEN SPOT IN CCW CHAIN)
         BCT   R15,GENCCW .             BACK FOR NEXT READ CCW
         MVC   0(8,R4),MDL3CCW1 .       MOVE READCOUNT FOR NEXT RECORD
         LA    R0,X'100' .              SET TTRK = 00000100
         ST    R0,FW .                  STORE FOR EXCP CALCULATIONS
         BAL   R7,TTRCNVRT .            GO GET DISK ADDRESS OF BLOCK 1
         BAL   R7,EXCP .                GO FILL BUFFERS
         SR    R1,R9 .                  BACK UP BUFFER ADDRESS FOR
         ST    R1,READREGS .              FIRST GET REQUEST
         LH    R1,BLKSPER .             LOAD DATA BLOCKS PER TRACK
         OI    CNTRL,READON .           OKAY FOR READ NOW
         B     SETRC0 .                 NORMAL ENDING
         EJECT
GET      EQU   * .
         TM    CNTRL,READON .           IS IT OKAY TO READ/Q
         BZ    SETRC28 .                NO, SET INVALID SEQUENCE CODE
         LM    R1,R3,READREGS .         RELOAD REGISTERS
* R1 = A(LAST DATA BLOCK RETURNED TO CALLER)
* R2 = LENGTH OF THE BUFFERS
* R3 = A(LAST BUFFER IN CORE)
         BXLE  R1,R2,STREGS .           GET NEXT LREC
         TM    CHNLSTUS,CHNLEND+DVCEND+UNITECP WAS END OF FILE HIT/Q
         BO    SETRC4 .                 BRANCH IF YES
         MVC   MBBCCHHR+3(5),CCHHR .    SET IOB UP FOR NEXT EXCP
         BAL   R7,EXCP .                GO FILL BUFFERS
         B     SETRC0 .                 GO SET RETURN CODE
STREGS   EQU   * .
         STM   R1,R3,READREGS .         SAVE REGISTERS FOR NEXT GET
         B     SETRC0 .                 NORMAL END
         SPACE 3
GETBYTTR EQU   * .
         TM    CNTRL,READON .           IS IT OKAY TO READ/Q
         BZ    SETRC28 .                NO, SET INVALID SEQUENCE CODE
         SR    R0,R0 .                  ZERO REGISTER 0
         IC    R0,2(,R1) .              LOAD R OF TTR
         MVC   FW(3),0(R1) .            ALIGN TT OF TTR ON HALFWORD
         LH    R1,FW .                  LOAD TT
         MH    R1,BLKSPER .             NUMBER OF BLOCKS ON TT TRKS
         AR    R1,R0 .                  ADD R BLOCKS TO TT*BLKSPER
         C     R1,LOWRBLK .             IS THE BLOCK I WANT IN CORE/Q
         BL    LOCATE .                 BRANCH IF LOWER THAN IN CORE
         C     R1,HIGHRBLK .            IS THE BLOCK I WANT IN CORE/Q
         BNL   LOCATE .                 BRANCH IF TOO HIGH
         S     R1,LOWRBLK .             SUBTRACT BEGIN RELATIVE BLOCKNO
         MH    R1,READREGS+6 .          MULTIPLY BY BUFFER LENGTH
         A     R1,BUFFADDR .            ADD START ADDRESS = BUFFER WANT
         ST    R1,READREGS .            SET GET FOR NEXT SEQUENTIAL
         B     SETRC0 .                 GO SET RETURN CODE
         SPACE 3 .
LOCATE   EQU   * .
         L     R0,FW .                  LOAD TTR0 FOR CONVERT ROUTINE
         BAL   R7,TTRCNVRT .            CHANGE TTR TO MBBCCHHR
         BAL   R7,EXCP .                GO ISSUE I/O REQUEST
         B     SETRC0 .                 GO SET RETURN CODE
         EJECT
CLOSE    EQU   * .
         TM    DCB+DCBOFLGS,X'10' .     IS IT OPEN/Q
         BZ    SETRC28 .                NO
         SR    R15,R15 .                ZERO REGISTER
         C     R15,COREADDR .           SHOULD I DO A FREEMAIN/Q
         BE    NOFREE .                 BRANCH IF NOT
*        FREEMAIN V,A=COREADDR
         FREEMAIN V,A=COREADDR .
         SPACE 1
         XC    COREADDR,COREADDR .      ZERO SO ONLY 1 FREEMAIN DONE
NOFREE   EQU   * .
         MVC   DCB+DCBIOBA(4),SAVEIOBA .RESTORE BSAM IOB ADDRESS
*        CLOSE DCB
         CLOSE DCB .
         SPACE 1
         MVI   CNTRL,RESET .            RESET CONTROL BITS
         B     SETRC0 .                 NORMAL END
         EJECT
SETRC0   EQU   * .
         SR    R15,R15 .                SET RETURN CODE TO ZERO
         B     RETURN .                 RETURN TO THE USER
SETRC4   EQU   * .
         LA    R15,4 .                  SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC8   EQU   * .
         LA    R15,8 .                  SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC12  EQU   * .
         LA    R15,12 .                 SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC16  EQU   * .
         LA    R15,16 .                 SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC20  EQU   * .
         LA    R15,20 .                 SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC28  EQU   * .
         LA    R15,28 .                 SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC32  EQU   * .
         LA    R15,32 .                 SET RETURN CODE
         B     PRERETRN .               GO RESET READ OK SWITCH & EXIT
SETRC36  EQU   * .
         XC    COREADDR,COREADDR .      ZERO TO STOP FREEMAIN IN CLOSE
         LA    R15,36 .                 SET RETURN CODE
PRERETRN EQU   * .
         MVI   CNTRL,RESET .            MUST CLOSE AND OPEN
RETURN   EQU   * .
         L     R13,SAVE+4 .             RELOAD REG 13
         L     R14,12(,R13) .           LOAD RETURN ADDRESS
         LM    R2,R12,28(R13) .         RELOAD REGISTERS
         BR    R14 .                    RETURN TO USER
         EJECT
         CNOP   0,4 .
ABND1000 EQU   * .
         ST    R1,* .
*        ABEND 1000,DUMP
         ABEND 1000,DUMP .
ABND1001 EQU   *                                              JDM
*        ABEND 1001,DUMP                                      JDM
         ABEND 1001,DUMP .                                    JDM
         SPACE 3 .
TTRCNVRT EQU   * .
         STM   R0,R15,SAVE+8 .          NON-STANDARD SAVE
         LR    R8,R13 .                 SAVE SAVE AREA ADDRESS
         L     R1,DCB+DCBDEBAD .        LOAD A(DEB)
         LA    R2,MBBCCHHR .            LOAD OUTPUT ADDRESS
         L     R15,16 .                 A(CVT)
         L     R15,28(,R15) .           A(TTR CONVERT ROUTINE)
         BALR  R14,R15 .
* REGISTERS 0-2 AND 9-15 ARE USED BY TTR CONVERT, AND NOT RESTORED
         LM    R0,R15,8(R8) .           RESTORE REGISTERS
         MVC   CCHHR,MBBCCHHR+3 .       SET UP FOR FIRST GET REQUEST
         BR    R7 .                     RETURN TO USER
         EJECT
EXCP     EQU   * .
         MVC   DCB+DCBFDAD(8),MBBCCHHR .MOVE FULL DISK ADDRESS TO DCB
*        EXCP  IOB
         EXCP  IOB .
         SPACE 1
*        WAIT  ECB=ECB
         WAIT  ECB=ECB .
         SPACE 1
         CLI   ECB,X'7F' .              WAS IT A NORMAL END/Q
         BE    EXCPOKAY .               BRANCH IF NORMAL
         CLI   ECB,X'42' .              WAS IT AN EXTENT VIOLATION/Q
         BE    EXTNTVIO .               YES, END OF CATALOG FOUND
         CLI   ECB,X'44' .              WAS IT INTERCEPTED/Q
         BE    EXCP .                   REISSUE IF SO
         CLI   ECB,X'41' .              WAS IT AN I/O ERROR/Q
         BNE   SETRC16 .                IF NOT, SOME OTHER ERROR
* ECB POSTED WITH I/O ERROR. IF WE GET
*    DEVICE END + CHNNEL END + UNIT EXCEPTION
*    THEN WE FOUND THE END OF THE CATALOG
         TM    CHNLSTUS,DVCEND+CHNLEND+UNITECP .WAS IT AN END OF FILE/Q
         BNO   SETRC16 .                BRANCH IF NOT
EXTNTVIO EQU   * .
         MVI   CHNLSTUS,CHNLEND+DVCEND+UNITECP SET END-OF-FILE STATUS
EXCPOKAY EQU   * .
         L     R3,IOB+8 .               LOAD A(LAST CCW EXEC'D +8)
         LA    R3,0(,R3) .              ZERO HIGH BYTE
         SH    R3,H8 .                  BACK UP ONE CCW LENGTH
         L     R15,CPGMADDR .           LOAD START OF CCW PGM ADDRESS
         LA    R15,16(,R15) .           LOAD A(FIRST READ CCW)
         SR    R3,R15 .                 LENGTH OF READ CCW'S EXECUTED
         BNP   SETRC4 .                 NO BUFFER FILLED = END-OF-FILE
         SRL   R3,3 .                   DIVIDE BY 8 = NUMBER OF READS
         SR    R0,R0 .                  ZERO REGISTER ZERO
         IC    R0,FW+2 .                PICK UP RECORDS ON LAST TRACK
         LH    R1,FW .                  LOAD NUMBER OF FULL TRACKS USED
         MH    R1,BLKSPER .             NUMBER OF BLOCKS ON TRACKS USED
         AR    R1,R0 .                  RELATIVE BLOCK ADDRESS
         ST    R1,LOWRBLK .             SET NEW LOWER LIMIT
         AR    R1,R3 .                  ADD NUMBER NOW IN CORE
         ST    R1,HIGHRBLK .            SAVE
         L     R1,BUFFADDR .            LOAD A(FIRST FILLED BUFFER)
         ST    R1,READREGS .            SAVE FOR LATER
         BCTR  R3,0 .                   MINUS 1 TO GET DISPLACEMENT
         MH    R3,READREGS+6 .          NUMBER TIMES LENGTH OF EACH
         AR    R3,R1 .                  PLUS START = A(LAST BUFFER FULL
         ST    R3,READREGS+8 .          SAVE FOR LATER
         BR    R7 .                     RETURN TO USER
         AIF   ('&SYSTEM' EQ '370').NOT360B
XCLR     XC    0(0,R1),0(R1) .          SUBJECT OF EX INSTRUCTION
.NOT360B ANOP
         EJECT
IOBPREFX DC    0D'0',X'21',AL3(IOBPREFX) DO NOT MOVE THIS OR NEXT 2 CRD
ECB      DC    F'0'
IOB      DC    0D'0',X'42',AL3(0),A(ECB,0,0)
CHNLSTUS EQU   IOB+12 .
CPGMADDR DC    A(0,DCB,0,0)
MBBCCHHR DC    XL8'00'
         SPACE 3 .
SIZES    DC    F'296,&MAXCORE' .
FW       DC    F'0'
JOBFILE  DC    0F'0',X'87',AL3(JFCB)
         SPACE 3 .
*CAMLST1 CAMLST SEARCH,JFCB,JFCB+JFCBVOLS,DSCB
CAMLST1  CAMLST SEARCH,JFCB,JFCB+JFCBVOLS,DSCB .
         SPACE 3 .
*CAMLST3 CAMLST SEEK,CCHHR,JFCB+JFCBVOLS,DSCB
CAMLST3  CAMLST SEEK,CCHHR,JFCB+JFCBVOLS,DSCB .
         EJECT
*DCB     DCB   DSORG=PS,MACRF=R,LRECL=256,BLKSIZE=256,KEYLEN=8,RECFM=F,X
               EXLST=JOBFILE,DDNAME=ANY
DCB      DCB   DSORG=PS,MACRF=R,LRECL=256,BLKSIZE=256,KEYLEN=8,RECFM=F,X
               EXLST=JOBFILE,DDNAME=ANY
          EJECT
         ORG   DCB+DCBBUFCB .
         DC    3X'00'                   PREVENT BUFFER ACQUISITION
         ORG
         SPACE 3 .
H8       DC    H'8'
H20      DC    H'20'
H24      DC    H'24'
CNTRL    DC    X'00'
         SPACE 1
***********************************************************************
*                                                                     *
*   CHANNEL COMMAND AND CHANNNEL COMMAND CODE EQUATES                 *
*                                                                     *
***********************************************************************
         SPACE
SILI     EQU   X'20' .                  SUPPRESS INCORRECT LENGTH INDIC
CHAIN    EQU   X'40' .             COMMAND CODE CHAINING TO NEXT CCW.
         SPACE
SRCHIDEQ EQU   X'31' .                  SEARCH IDENTIFIER EQUAL
TIC      EQU   X'08' .                  TRANSFER IN CHANNEL
RDCOUNT  EQU   X'12' .                  READ COUNT
RDDATA   EQU   X'06' .                  READ DATA
RDKYDATA EQU   X'0E' .                  READ KEY AND DATA
MULTITRK EQU   X'80' .                  MULTIPLE TRACK MODE INDICATOR
MDL1CCW1 CCW   SRCHIDEQ,MBBCCHHR+3,CHAIN+SILI,5 .ONE OF TWO
MDL1CCW2 CCW   TIC,*-8,CHAIN+SILI,1 .       TWO OF TWO
MDL2CCW1 CCW   RDDATA+MULTITRK,0,CHAIN,256 .
MDL3CCW1 CCW   RDCOUNT+MULTITRK,CCHHR,SILI,5 . READ NEXT BLOCK ADDRESS
         SPACE 3 .
JFCB     DS    22D
DSCB     DS    19D
SAVE     DS    18F
COREADDR DS    2F
SAVEIOBA DS    F
NUMBBUFS DS    F
LOWRBLK  DS    F
HIGHRBLK DS    F
BUFFADDR DS    F
READREGS DS    3F
CCHHR    DS    0F,CL5
BLKSPER  DS    H
         MEND
         CTLGACCS SYSTEM=370
         END
//*
//LKED   EXEC PGM=IEWL,PARM=(XREF,LET,LIST,NCAL),
//            REGION=128K,COND=(4,LT)
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1024,(50,20))
//SYSPRINT DD SYSOUT=A
//SYSLMOD  DD DISP=SHR,DSN=SYS2.LINKLIB
//SYSLIN   DD DSN=&&OBJSET,DISP=(OLD,DELETE)
//         DD *
 ENTRY CATPTPCH
 NAME CATPTPCH(R)
/*
//
//SYSLMOD  DD DSN=&&GOSET,UNIT=SYSDA,
//            SPACE=(1024,(50,20,1)),DISP=(MOD,PASS)
