//SY20ZR06 JOB 1,SOFTWARE,MSGLEVEL=(1,1),CLASS=A,MSGCLASS=A
//*
//*  20023/07/21 @kl Assemble COREMAP program
//*
//ASM    EXEC PGM=IEUASM,
//            PARM='DECK,LIST',REGION=768K
//*STEPLIB  DD DISP=SHR,DSN=SYS1.XFASM.LOAD
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=6160
//         DD DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1700,(600,100))
//SYSUT2   DD DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(1700,(300,50))
//SYSUT3   DD DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(1700,(300,50))
//SYSPRINT DD SYSOUT=A,DCB=BLKSIZE=1089
//SYSLIN   DD DUMMY
//SYSGO    DD DUMMY
//SYSPUNCH DD DSN=&&OBJSET,UNIT=SYSDA,SPACE=(80,(200,50)),
//            DISP=(MOD,PASS)
//SYSIN    DD *
         MACRO                                                          00000100
&NAME    CONVERT &OFFSET,&ADDRESS                                       00000200
&NAME    LA    R1,BUFFER+&OFFSET                                        00000300
         LA    R15,&ADDRESS+1                                           00000400
         BAL   R14,BUFFFILL                                             00000500
         MEND                                                           00000600
         MACRO                                                          00000700
&NAME    PGMTYPE  &FLAGS,&ID                                            00000800
         LCLA  &LEN1                                                    00000900
         LCLC  &ID1                                                     00001000
&ID1     SETC ''                                                        00001100
&LEN1    SETA  K'&ID-2                                                  00001200
         AIF   ('&ID'(1,1) EQ '''').OK1                                 00001300
&ID1     SETC    ''''                                                   00001400
&LEN1    SETA  K'&ID                                                    00001500
.OK1     ANOP                                                           00001600
&NAME    TM    PGMFLAGS,&FLAGS                                          00001700
         BZ    *+26                                                     00001800
         MVC   2(&LEN1,R15),=C&ID1&ID&ID1                               00001900
         LTR   R14,R14                                                  00002000
         BNZ   *+8                                                      00002100
         MVI   0(R15),C','                                              00002200
         SR    R14,R14                                                  00002300
         LA    R15,&LEN1+2(R15)                                         00002400
         MEND                                                           00002500
         TITLE 'COREMAP - A PROGRAM TO MAP REGIONS FOR SELECTED TASKS'  00002600
*********************************************************************** 00002700
*                                                                     * 00002800
* PROGRAM NAME- COREMAP                                               * 00002900
*                                                                     * 00003000
* FUNCTION - MAP REGION FOR A SELECTED TASK. THE REGION IS            * 00003100
*            MAPPED AS TO WHERE MODULES ARE LOADED, THE               * 00003200
*            STORAGE ALLOCATED TO SUBPOLLS BELONGING TO EACH          * 00003300
*            TASK IN THE SELECTED TASK, AND THE AMOUNT OF             * 00003400
*            FREE CORE WITHIN THE REGION.                             * 00003500
*                                                                     * 00003600
* INPUT -    R1 POINTER TO PARAMETER AREA SPECIFING THE               * 00003700
*            NAME OF THE TASK TO BE MAPPED.                           * 00003800
*                                                                     * 00003900
* OUTPUT-    FILE 'SYSPRINT' CONTAINS THE CORE MAP.                   * 00004000
*                                                                     * 00004100
* ERROR CONDITIONS- MESSAGE 'NO TASK NAME SPECIFIED' ISSUED           * 00004200
*                   IF NO PARAMETER WAS GIVEN                         * 00004300
*                                                                     * 00004400
*                   MESSAGE 'UNABLE TO LOCATE SELECTED TASK'          * 00004500
*                   ISSUED IF THE SPECIFIED TASK WAS NOT FOUND.       * 00004600
*                                                                     * 00004700
*********************************************************************** 00004800
         EJECT                                                          00004900
RGNBLK   DSECT                          FORMAT OF REGION ELEMENT        00005000
RGNCHAIN DS    A                        CHAIN FIELD                     00005100
RGNPQE   DS    A                        ADDRESS OF PQE FOR REGION BLOCK 00005200
RGNPTR   DS    A                        ADDRESS OF REGION BLOCK         00005300
RGNLEN   DS    F                        LENGTH OF REGION BLOCK          00005400
LRGNBLK  EQU   *-RGNBLK                 LENGTH OF REGION ELEMENT        00005500
         SPACE 2                                                        00005600
COREBLK  DSECT ,                        FORMAT OF SUBPOOL ELEMENT       00005700
CORECHN  DS    A                        CHAIN FIELD                     00005800
COREPTR  DS    A                        ADDRESS OF CORE BLOCK           00005900
CORESPID DS    0X                       SUBPOOL ID OF CORE BLOCK        00006000
CORELEN  DS    F                        LENGTH OF CORE BLOCK            00006100
COREFREE DS    A                        POINTER TO CORE FREE ELEMENT    00006200
LCOREBLK EQU   *-COREBLK                LENGTH OF CORE ELEMENT          00006300
         SPACE 2                                                        00006400
FREEBLK  DSECT ,                        FORMAT OF FREE CORE ELEMENT     00006500
FREECHN  DS    A                        CHAIN FIELD                     00006600
FREEPTR  DS    A                        ADDRESS OF FREE CORE AREA       00006700
FREELEN  DS    F                        LENGTH OF FREE AREA             00006800
LFREEBLK EQU   *-FREEBLK                LENGTH OF FREE ELEMENT          00006900
         SPACE 2                                                        00007000
PGMBLK   DSECT ,                        FORMAT OF PROGRAM ELEMENT       00007100
PGMCHAIN DS    A                        CHAIN FIELD                     00007200
PGMNAME  DS    CL8                      NAME OF PROGRAM                 00007300
PGMADDR  DS    A                        ADDRESS OF PROGRAM              00007400
PGMFLAGS DS    0X                       CDE FLAGS                       00007500
PGMLEN   DS    F                        LENGTH OF PROGRAM               00007600
LPGMBLK  EQU   *-PGMBLK                 LENGTH OF PROGRAM ELEMENT       00007700
         EJECT                                                          00007800
TCB      DSECT                                                          00007900
         IKJTCB                                                         00008000
         EJECT                                                          00008100
LLS      DSECT                          FORMAT OF LOAD LIST ENTRY       00008200
LLSNEXT  DS    A                        ADDRESS OF NEXT ENTRY           00008300
LLSCDE   DS    A                        ADDRESS OF CDE                  00008400
         SPACE 1                                                        00008500
CDE      DSECT                          FORMAT OF CONTENTS DIRECTORY    00008600
CDEFLAGS DS    0X                       CDE FLAGS                       00008700
CDENIP   EQU   X'80'                    MODULE LOADED BY NIP            00008800
CDELOAD  EQU   X'40'                    MODULE BEING LOADED             00008900
CDERENT  EQU   X'20'                    MODULE IS REENTRANT             00009000
CDEREUS  EQU   X'10'                    MODULE IS SERIALLY REUSABLE     00009100
CDENOUSE EQU   X'08'                    MODULE MAY NOT BE REUSED        00009200
CDEMINOR EQU   X'04'                    MINOR CDE (FOR ALIAS)           00009300
CDEJPA   EQU   X'02'                    MODULE IS IN JOB PACK AREA      00009400
CDENOLD  EQU   X'01'                    MODULE IS NOT ONLY-LOADABLE     00009500
CDENEXT  DS    A                        ADDRESS OF NEXT CDE             00009600
CDERB    DS    A                        ADDRESS OF RB                   00009700
CDENAME  DS    CL8                      NAME OF MODULE                  00009800
CDECOUNT DS    0X                       MODULE USE COUNT                00009900
CDEEPT   DS    A                        ADDRESS OF ENTRY POINT          00010000
CDEXL    DS    A                        ADDRESS OF EXTENT LIST          00010100
         SPACE 1                                                        00010200
XL       DSECT                          FORMAT OF EXTENT LIST           00010300
XLLEN    DS    F                        LENGTH OF EXTENT LIST           00010400
XLNUMBER DS    F                        NUMBER OF CSECT ENTRIES         00010500
XLSIZE   DS    F                        SIZE OF CSECT-X                 00010600
XLPTR    DS    A                        ADDRESS OF CSECT-X              00010700
         SPACE 1                                                        00010800
FQE      DSECT                          FORMAT OF FREE QUEUE ELEMENT    00010900
FQENEXT  DS    A                        ADDRESS OF NEXT FQE             00011000
FQESIZE  DS    F                        SIZE OF FREE AREA               00011100
         SPACE 1                                                        00011200
DQE      DSECT                          FORMAT OF DESCRIPTOR QUEUE      00011300
DQEFQE   DS    A                        POINTER TO FIRST FQE            00011400
DQENEXT  DS    A                        POINTER TO NEXT DQE             00011500
DQEADDR  DS    A                        POINTER TO START OF BLOCK       00011600
DQESIZE  DS    F                        SIZE OF BLOCK                   00011700
         SPACE 1                                                        00011800
SPQE     DSECT                          FORMAT OF SUBPOOL QUEUE ELEMENT 00011900
SPQEFLAG DS    0X                       FLAGS                           00012000
SPQESHR1 EQU   X'80'                    SUBPOOL SHARED, NOT OWNED       00012100
SPQELAST EQU   X'40'                    LAST SPQE                       00012200
SPQESHR2 EQU   X'20'                    SUBPOOL SHARED AND OWNED        00012300
SPQENEXT DS    A                        ADDRESS OF NEXT SPQE            00012400
SPQEID   DS    0X                       SUBPOOL ID                      00012500
SPQEDQE  DS    A                        POINTER TO FIRST DQE            00012600
         SPACE 1                                                        00012700
PQE      DSECT                          FORMAT OF PARTITION QUEUE       00012800
PQEFBQEF DS    A                        ADDRESS OF FIRST FBQE           00012900
PQEFBEQL DS    A                        ADDRESS OF LAST FBQE            00013000
PQENEXT  DS    A                        ADDRESS OF NEXT PQE             00013100
PQEPREV  DS    A                        ADDRESS OF PREVIOUS PQE         00013200
PQETCB   DS    A                        ADDRESS OF OWNER TCB            00013300
PQESIZE  DS    F                        SIZE OF REGION                  00013400
PQEPTR   DS    A                        ADDRESS OF REGION               00013500
PQEFLAGS DS    X,XL3                    ROLLOUT FLAGS                   00013600
         EJECT                                                          00013700
COREMAP  CSECT                                                          00013800
         SPACE 2                                                        00013900
R0       EQU   0                                                        00014000
R1       EQU   1                                                        00014100
R2       EQU   2                                                        00014200
R3       EQU   3                                                        00014300
R4       EQU   4                                                        00014400
R5       EQU   5                                                        00014500
R6       EQU   6                                                        00014600
R7       EQU   7                                                        00014700
R8       EQU   8                                                        00014800
R9       EQU   9                                                        00014900
R10      EQU   10                                                       00015000
R11      EQU   11                                                       00015100
R12      EQU   12                                                       00015200
R13      EQU   13                                                       00015300
R14      EQU   14                                                       00015400
R15      EQU   15                                                       00015500
         SPACE 2                                                        00015600
         SAVE  (14,12),,*                                               00015700
         LR    R11,R15                  ESTABLISH BASE REGISTER         00015800
         LA    R12,4095                                                 00015900
         LA    R12,1(R11,R12)                                           00016000
         USING COREMAP,R11,R12                                          00016100
         CNOP  0,4                                                      00016200
         BAL   R15,*+76                 GET NEW SAVE AREA               00016300
         DC    18F'0'                                                   00016400
         ST    R15,8(,R13)                                              00016500
         ST    R13,4(,R15)                                              00016600
         LR    R13,R15                                                  00016700
         SPACE 2                                                        00016800
         LR    R2,R1                    SAVE PARM LIST ADDRESS          00016900
         OPEN  (SYSPRINT,OUTPUT)        OPEN PRINT FILE                 00017000
         TM    SYSPRINT+DCBOFLGS-IHADCB,X'10' DCB OPEN?                 00017100
         BZ    NOPRINT                  NO, ERROR                       00017200
         SPACE 2                                                        00017300
         L     R2,0(R2)                 GET PARAMETER ADDRESS           00017400
         LH    R1,0(R2)                 GET LENGTH OF STRING            00017500
         LTR   R1,R1                    ANY FIELD THERE?                00017600
         BZ    NOPARMS                  ERROR                           00017700
         SPACE 1                                                        00017800
*********************************************************************** 00017900
*              GET SELECTED TASK NAME AS PARAMETER                    * 00018000
*********************************************************************** 00018100
         SPACE 1                                                        00018200
         CH    R1,MAXPRMLN              MAXIMUM NAME LENGTH             00018300
         BH    PARMERR                  ERROR - NAME TOO LONG           00018400
         SPACE 1                                                        00018500
         BCTR  R1,0                                                     00018600
         EX    R1,PARMMOVE              MOVE NAME TO AREA               00018700
         EX    R1,NAMESET                                               00018800
         EJECT                                                          00018900
START    BAL   R14,DISABLE                                              00019000
         SPACE 2                                                        00019100
*********************************************************************** 00019200
*                                                                     * 00019300
*              LOCATE TASK TREE FOR SELECTED TASK                     * 00019400
*                                                                     * 00019500
*********************************************************************** 00019600
         SPACE 2                                                        00019700
         L     R1,16                    GET CVT POINTER                 00019800
         L     R1,0(R1)                 POINTER TO TCB WORDS            00019900
         L     R1,4(R1)                 POINTER TO ACTIVE TASK (ME)     00020000
         SPACE 1                                                        00020100
*********************************************************************** 00020200
*              LOCATE MASTER SCHEDULER TASK                           * 00020300
*********************************************************************** 00020400
         SPACE 1                                                        00020500
MSFIND   L     R2,TCBOTC-TCB(R1)        GET MOTHER TASK (ORIGINATOR)    00020600
         LTR   R2,R2                    IS MOTHER ZERO?                 00020700
         BZ    MSTASK                   YES, THEN THIS IS M.S.          00020800
         LR    R1,R2                    NO, CONTINUE                    00020900
         B     MSFIND                                                   00021000
         SPACE 1                                                        00021100
*********************************************************************** 00021200
*              LOCATE REQUIRED TASK TREE                              * 00021300
*********************************************************************** 00021400
         SPACE 1                                                        00021500
MSTASK   LR    R0,R1                    SAVE M.S. TASK POINTER          00021600
         SPACE 1                                                        00021700
FINDTASK L     R2,TCBTIO-TCB(R1)        GET TIOT ADDRESS                00021800
         CLC   TASKID,0(R2)             THIS REQUIRED TASK?             00021900
         BE    GETTASK                  YES                             00022000
         CLC   TASKID,8(R2)             THIS REQUIRED TASK?             00022100
         BE    GETTASK                  YES                             00022200
         L     R1,TCBTCB-TCB(R1)        GET LOWER PRTY TASK             00022300
         LTR   R1,R1                    ANY THERE?                      00022400
         BNZ   FINDTASK                 YES, CONTINUE SEARCH            00022500
         B     NOTASK                   ERROR - REQUIRED TASK NOT FOUND 00022600
         SPACE 1                                                        00022700
*********************************************************************** 00022800
*              HAVE TASK, LOCATE TOP OF TREE                          * 00022900
*********************************************************************** 00023000
         SPACE 1                                                        00023100
GETTASK  L     R2,TCBOTC-TCB(R1)        GET MOTHER TASK                 00023200
         LTR   R2,R2                    MOTHER TASK EXIST?              00023300
         BZ    HAVETREE                 NO, THE REQUESTED TASK IS M.S.  00023400
         SPACE 1                                                        00023500
         CR    R2,R0                    IS MOTHER M.S.?                 00023600
         BE    HAVETREE                 YES, THEN HAVE TOP OF TREE      00023700
         LR    R1,R2                    NO, CONTINUE TREE SEARCH        00023800
         B     GETTASK                                                  00023900
         SPACE 1                                                        00024000
*********************************************************************** 00024100
*              TOP OF TREE, CREATE REGION ELEMENTS, CORE              * 00024200
*              ELEMENTS, FREE ELEMENTS, AND PROGRAM ELEMENTS          * 00024300
*********************************************************************** 00024400
         SPACE 1                                                        00024500
HAVETREE ST    R1,MAINTASK              SAVE POINTER TO MAIN TASK       00024600
         SPACE 1                                                        00024700
HAVETASK LR    R10,R1                   NEXT TCB POINTER                00024800
         L     R3,TCBPQE-TCB(R10)       GET DPQE POINTER                00024900
         SPACE 1                                                        00025000
         LA    R3,0(R3)                                                 00025100
         LTR   R3,R3                    REGION PRESENT?                 00025200
         BZ    LASTPQE                  NO                              00025300
         SPACE 1                                                        00025400
*********************************************************************** 00025500
*              CREATE REGION ELEMENTS FROM PQES                       * 00025600
*********************************************************************** 00025700
         SPACE 1                                                        00025800
NEXTPQE  L     R3,PQENEXT-PQE(R3)       GET NEXT PQE ADDRESS            00025900
         LA    R3,0(R3)                 CLEAR HIGH BYTE                 00026000
         LTR   R3,R3                    PQE PRESENT?                    00026100
         BZ    LASTPQE                  NO                              00026200
         SPACE 1                                                        00026300
         L     R1,PTRRGN                GET FIRST REGION ELEMENT        00026400
         SPACE 1                                                        00026500
CHECKPQE LTR   R1,R1                    END OF CHAIN?                   00026600
         BZ    HAVEPQE                  YES, ADD NEW REGION ELEMENT     00026700
         C     R3,RGNPQE-RGNBLK(R1)     NO, BLOCK BEEN ACCOUNTED FOR?   00026800
         BE    NEXTPQE                  YES, THEN SKIP REGION BLOCK     00026900
         L     R1,RGNCHAIN-RGNBLK(R1)   GET NEXT REGION ELEMENT         00027000
         B     CHECKPQE                 CHECK THIS ONE                  00027100
         SPACE 1                                                        00027200
HAVEPQE  LA    R0,LRGNBLK               LENGTH OF REGION ELEMENT        00027300
         BAL   R14,GETCORE              OBTAIN CORE                     00027400
         L     R15,PTRRGN+4             POINTER TO LAST REGION ELEMENT  00027500
         ST    R1,RGNCHAIN-RGNBLK(R15)  CHAIN ELEMENTS TOGETHER         00027600
         ST    R1,PTRRGN+4              SAVE NEW POINTER                00027700
         SPACE 1                                                        00027800
         USING RGNBLK,R1                BASE FOR REGION ELEMENT         00027900
         MVC   RGNPTR(4),PQEPTR-PQE(R3) ADDRESS OF REGION AREA          00028000
         MVC   RGNLEN(4),PQESIZE-PQE(R3) SIZE OF AREA                   00028100
         ST    R3,RGNPQE                SET ADDRESS OF PQE              00028200
         B     NEXTPQE                  GET NEXT PQE                    00028300
         DROP  R1                                                       00028400
         SPACE 1                                                        00028500
*********************************************************************** 00028600
*              CREATE CORE ELEMENTS FROM SPQES                        * 00028700
*********************************************************************** 00028800
         SPACE 1                                                        00028900
LASTPQE  L     R2,TCBMSS-TCB(R10)       GET SPQE POINTER                00029000
         SPACE 1                                                        00029100
HAVESPQE LA    R2,0(R2)                 CLEAR HIGH BYTE                 00029200
         LTR   R2,R2                    LAST SPQE?                      00029300
         BZ    LASTSPQE                 YES                             00029400
         TM    SPQEFLAG-SPQE(R2),SPQESHR1 SHARED, NOT OWNED?            00029500
         BO    NEXTSPQE                 YES, SKIP IT                    00029600
         L     R3,SPQEDQE-SPQE(R2)      GET DEQ POINTER                 00029700
         SPACE 1                                                        00029800
HAVEDQE  LA    R3,0(R3)                 CLEAR HIGH BYTE                 00029900
         LTR   R3,R3                    DQE PRESENT?                    00030000
         BZ    NEXTSPQE                 NO, NEXT SPQE                   00030100
         SPACE 1                                                        00030200
         LA    R0,LCOREBLK              LENGTH OF CORE ELEMENT          00030300
         BAL   R14,GETCORE              OBTAIN CORE                     00030400
         L     R15,PTRCORE+4            GET LAST CORE POINTER           00030500
         ST    R1,CORECHN-COREBLK(R15)  ADD NEW ELEMENT                 00030600
         ST    R1,PTRCORE+4             SAVE NEW POINTER                00030700
         USING COREBLK,R1               BASE FOR CORE ELEMENT           00030800
         MVC   COREPTR(4),DQEADDR-DQE(R3) ADDRESS OF BLOCK              00030900
         MVC   CORELEN(4),DQESIZE-DQE(R3) LENGTH OF BLOCK               00031000
         MVC   CORESPID(1),SPQEID-SPQE(R2) SUBPOOL ID OF CORE           00031100
         LA    R5,COREFREE              POINTER FOR FREE ELEMENT        00031200
         DROP  R1                                                       00031300
         L     R4,DQEFQE-DQE(R3)        POINTER TO FQE                  00031400
         EJECT                                                          00031500
*********************************************************************** 00031600
*              CREATE FREE CORE ELEMENTS FROM FQES                    * 00031700
*********************************************************************** 00031800
         SPACE 1                                                        00031900
HAVEFQE  LA    R4,0(R4)                 CLEAR HIGH BYTE                 00032000
         LTR   R4,R4                    FQE PRESENT?                    00032100
         BZ    NEXTDQE                  NO, GET NEXT DQE                00032200
         SPACE 1                                                        00032300
         LA    R0,LFREEBLK              LENGTH OF FREE ELEMENT          00032400
         BAL   R14,GETCORE                                              00032500
         ST    R1,0(R5)                 CHAIN IN NEXT ELEMENT           00032600
         USING FREEBLK,R1               BASE FOR FREE ELEMENT           00032700
         SPACE 1                                                        00032800
         LA    R5,FREECHN               CHAIN ADDRESS                   00032900
         MVC   FREELEN(4),FQESIZE-FQE(R4) LENGTH OF FREE AREA           00033000
         ST    R4,FREEPTR               POINTER TO FREE AREA            00033100
         L     R4,FQENEXT-FQE(R4)       ADDRESS OF NEXT FQE             00033200
         B     HAVEFQE                  NEXT FQE                        00033300
         DROP  R1                                                       00033400
         SPACE 1                                                        00033500
NEXTDQE  L     R3,DQENEXT-DQE(R3)       NEXT DQE POINTER                00033600
         B     HAVEDQE                  PROCESS IT                      00033700
         SPACE 1                                                        00033800
NEXTSPQE L     R2,SPQENEXT-SPQE(R2)     NEXT SPQE POINTER               00033900
         B     HAVESPQE                 PROCESS IT                      00034000
         SPACE 1                                                        00034100
*********************************************************************** 00034200
*              CREATE PROGRAM ELEMENTS FROM LOAD LIST                 * 00034300
*              AND JOB PACK AREA LIST                                 * 00034400
*********************************************************************** 00034500
         SPACE 1                                                        00034600
LASTSPQE L     R2,TCBLLS-TCB(R10)       POINTER TO LOAD LIST            00034700
         SPACE 1                                                        00034800
NEXTLLS  LA    R2,0(R2)                 CLEAR HIGH BYTE                 00034900
         LTR   R2,R2                    MORE IN LIST?                   00035000
         BZ    GETJPQ                   NO, DO JOB PACK AREA            00035100
         SPACE 1                                                        00035200
         L     R3,LLSCDE-LLS(R2)        POINTER TO CDE                  00035300
         BAL   R14,DOCDE                PROCESS THIS CDE                00035400
         L     R2,LLSNEXT-LLS(R2)       NEXT LOAD LIST ENTRY            00035500
         B     NEXTLLS                                                  00035600
         SPACE 1                                                        00035700
GETJPQ   C     R10,TCBJSTCB-TCB(R10)    THIS JOB STEP TCB?              00035800
         BNE   LASTJPQ                  NO, SKIP JOB PACK AREA          00035900
         L     R3,TCBJPQ-TCB(R10)       POINTER TO JOB PACK AREA        00036000
         SPACE 1                                                        00036100
NEXTJPQ  LA    R3,0(R3)                 CLEAR HIGH BYTE                 00036200
         LTR   R3,R3                    ANOTHER CDE?                    00036300
         BZ    LASTJPQ                  NO, END OF JOB PACK             00036400
         BAL   R14,DOCDE                PROCESS THIS CDE                00036500
         L     R3,CDENEXT-CDE(R3)       NEXT CDE POINTER                00036600
         B     NEXTJPQ                                                  00036700
         SPACE 1                                                        00036800
LASTJPQ  DS    0H                                                       00036900
         EJECT                                                          00037000
*********************************************************************** 00037100
*                                                                     * 00037200
*              LOCATE NEXT TCB                                        * 00037300
*                                                                     * 00037400
*                                                                     * 00037500
*********************************************************************** 00037600
         SPACE 2                                                        00037700
         L     R1,TCBLTC-TCB(R10)       GET DAUGHTER TASK               00037800
         LTR   R1,R1                    DOES TASK EXIST?                00037900
         BNZ   HAVETASK                 YES, PROCESS THIS TASK          00038000
         SPACE 2                                                        00038100
GETSIS   C     R10,MAINTASK             WORKING ON TOP OF TREE?         00038200
         BE    ENDTREE                  YES, THEN TREE COMPLETE         00038300
         SPACE 1                                                        00038400
         L     R1,TCBNTC-TCB(R10)       NOT TOP, GET SISTER TASK        00038500
         LTR   R1,R1                    DOES TASK EXIST?                00038600
         BNZ   HAVETASK                 YES, PROCESS SISTER TASK        00038700
         SPACE 1                                                        00038800
         L     R10,TCBOTC-TCB(R10)      END OF LOWER BRANCHES IN TREE,  00038900
*                                       GET MOTHER TASK                 00039000
         B     GETSIS                   GET SISTER TASK                 00039100
         SPACE 3                                                        00039200
ENDTREE  DS    0H                       END OF TASK TREE                00039300
         SPACE 1                                                        00039400
         BAL   R14,ENABLE               ENABLE SYSTEM                   00039500
         EJECT                                                          00039600
*********************************************************************** 00039700
*                                                                     * 00039800
*              MAP OUT CORE                                           * 00039900
*                                                                     * 00040000
*********************************************************************** 00040100
         SPACE 2                                                        00040200
         L     R2,PTRRGN                POINTER TO FIRST REGION ELEMENT 00040300
         LTR   R2,R2                    ANY FOUND?                      00040400
         BZ    NOREGION                 NO, ERROR - CAN'T MAP           00040500
         SPACE 1                                                        00040600
         BAL   R14,CLEARMAP             OBTAIN AND CLEAR MAP AREA       00040700
         SPACE 1                                                        00040800
*        SPIE  PGMCHECK,((1,15))        SET SPIE TO PRINT OUT MAP       00040900
         SPACE 2                                                        00041000
         USING RGNBLK,R2                BASE FOR REGION BLOCK           00041100
         L     R3,PTRCORE               ADDRESS OF FIRST CORE ELEMENT   00041200
MAPCORE  LTR   R3,R3                    ANY MORE ALLOCATED CORE?        00041300
         BZ    NOCORE                   NO                              00041400
         USING COREBLK,R3               BASE FOR CORE ELEMENT           00041500
         CLC   COREPTR,RGNPTR           IS AREA WITHIN REGION?          00041600
         BL    NEXTCORE                 NO, GET NEXT ELEMENT            00041700
         L     R14,RGNPTR               ADDRESS OF REGION BLOCK         00041800
         A     R14,RGNLEN               ADD IN LENGTH                   00041900
         C     R14,COREPTR              PAST END OF REGION?             00042000
         BNH   NEXTCORE                 YES, GET NEXT ELEMENT           00042100
         SPACE 2                                                        00042200
         SR    R14,R14                                                  00042300
         IC    R14,CORESPID             SUBPOOL ID                      00042400
         CVD   R14,DWORD                MAKE DECIMAL                    00042500
         UNPK  DWORD(3),DWORD+6(2)                                      00042600
         OI    DWORD+2,X'F0'            FIX SIGN                        00042700
         LA    R14,DWORD                                                00042800
         LA    R0,2                                                     00042900
SP#LOOP  CLI   0(R14),C'0'              DROP LEADING ZEROS              00043000
         BNE   SP#LOOP1                                                 00043100
         LA    R14,1(R14)                                               00043200
         BCT   R0,SP#LOOP                                               00043300
         SPACE 1                                                        00043400
SP#LOOP1 LA    R1,DWORD+2                                               00043500
         SR    R1,R14                   COMPUTE LENGTH-1                00043600
         EX    R1,MOVESP#               PUT SUBPOOL # IN AREA           00043700
         LA    R1,LSP#+1(R1)            TOTAL LENGTH                    00043800
         STH   R1,SP#AREA               SAVE IN AREA                    00043900
         SPACE 2                                                        00044000
         L     R4,COREFREE              FIRST FREE AREA                 00044100
MAPFREE  LTR   R4,R4                    ANY FREE?                       00044200
         BZ    FIXCORE                  NO, THEN MAP ALLOCATED CORE     00044300
         USING FREEBLK,R4               BASE FOR FREE ELEMENT           00044400
         SPACE 2                                                        00044500
         L     R8,FREEPTR               ADDRESS OF FREE BLOCK           00044600
         L     R9,FREELEN               LENGTH OF FREE BLOCK            00044700
         S     R8,RGNPTR                SUBTRACT REGION START ADDRESS   00044800
         AR    R9,R8                    SET ENDING ADDRESS              00044900
         SPACE 1                                                        00045000
         LR    R15,R8                                                   00045100
         BAL   R14,CALCLNE#                                             00045200
         SPACE 1                                                        00045300
         LR    R15,R9                                                   00045400
         L     R8,SEG#                  SAVE SEGMENT NUMBER             00045500
         L     R9,CHAR#                 SAVE CHARACTER NUMBER           00045600
         BAL   R14,CALCLNE#             CALCULATE LINE NUMBER OF END    00045700
         C     R8,SEG#                  SAME SEGMENT?                   00045800
         BE    FREESEG1                 YES, ONLY ONE SEGMENT           00045900
         OC    CHAR#,CHAR#              END AT START OF SEGMENT?        00046000
         BNZ   FREESEG2                 NO, SPLIT INTO 2 SEGMENTS       00046100
         SPACE 1                                                        00046200
         L     R15,SEG#                 GET SEGMENT NUMBER              00046300
         BCTR  R15,0                    REDUCE BY ONE                   00046400
FREEMORE LA    R0,MAPOFST2              OFFSET FOR END OF SEGMENT       00046500
         ST    R0,CHAR#                 SET CHARACTER NUMBER            00046600
         CR    R15,R8                   SAME SEGMENT?                   00046700
         BE    FREESEG1                 YES, ONLY 1 SEGMENT             00046800
         SPACE 1                                                        00046900
FREESEG2 L     R1,CHAR#                 ENDING CHARACTER POSITION       00047000
         LA    R0,MAPOFSET                                              00047100
         STM   R0,R1,CHAR#              SET CHARACTER POSITIONS         00047200
         SPACE 1                                                        00047300
         BAL   R14,FIXFREE              FIX FREE AREA                   00047400
         L     R15,SEG#                                                 00047500
         BCTR  R15,0                    DOWN BY ONE                     00047600
         ST    R15,SEG#                 SAVE SEGMENT NUMBER             00047700
         B     FREEMORE                 CHECK FOR MORE THAN 1 SEGMENT   00047800
         SPACE 2                                                        00047900
FREESEG1 LR    R0,R9                    STARTING CHARACTER POINTER      00048000
         L     R1,CHAR#                 ENDING NUMBER                   00048100
         STM   R0,R1,CHAR#                                              00048200
         BAL   R14,FIXFREE              FIX LAST FREE AREA              00048300
         SPACE 2                                                        00048400
         L     R4,FREECHN               GET NEXT FREE AREA              00048500
         B     MAPFREE                  MAP THIS FREE AREA              00048600
         DROP  R4                                                       00048700
         SPACE 2                                                        00048800
FIXCORE  DS    0H                                                       00048900
         SPACE 2                                                        00049000
         L     R8,COREPTR               ADDRESS OF CORE BLOCK           00049100
         L     R9,CORELEN               LENGTH OF CORE BLOCK            00049200
         S     R8,RGNPTR                SUBTRACT REGION START ADDRESS   00049300
         LA    R9,0(R9)                 DROP FLAGS BYTE FROM LENGTH     00049400
         AR    R9,R8                    SET ENDING ADDRESS              00049500
         SPACE 1                                                        00049600
         LR    R15,R8                                                   00049700
         BAL   R14,CALCLNE#                                             00049800
         SPACE 1                                                        00049900
         LR    R15,R9                                                   00050000
         L     R8,SEG#                  SAVE SEGMENT NUMBER             00050100
         L     R9,CHAR#                 SAVE CHARACTER NUMBER           00050200
         BAL   R14,CALCLNE#             CALCULATE LINE NUMBER OF END    00050300
         SPACE 1                                                        00050400
FIXCORE1 C     R8,SEG#                  SAME SEGMENT?                   00050500
         LR    R0,R9                    SET START POINTER               00050600
         L     R1,CHAR#                 SET END POINTER                 00050700
         BE    CORESEG1                 ONLY ONE SEGMENT                00050800
         SPACE 1                                                        00050900
         SR    R0,R0                    START OF SEGMENT OFFSET         00051000
         LTR   R1,R1                    END AT START OF NEW SEGMENT?    00051100
         BNZ   CORESEG1                 NO, MAP ALLOCATED CORE          00051200
         SPACE 1                                                        00051300
         L     R15,SEG#                 GET SEGMENT NUMBER              00051400
         BCTR  R15,0                    DROP BY ONE                     00051500
         CR    R8,R15                   IN SAME SEGMENT?                00051600
         LA    R1,MAPOFST2-MAPOFSET     END OF SEGMENT OFFSET           00051700
         ST    R15,SEG#                 SAVE SEGMENT NUMBER             00051800
         BNE   CORESEG1                 NOT SAME AS STARTING SEGMENT    00051900
         LR    R0,R9                    SAME AS START SEGMENT           00052000
*                                       SET STARTING OFFSET             00052100
         SPACE 1                                                        00052200
CORESEG1 STM   R0,R1,CHAR#              SET POINTERS                    00052300
         BAL   R14,CALCSEG#             GET SEGMENT NUMBER              00052400
         LA    R0,LINELEN               LENGTH OF LINE                  00052500
         LR    R4,R1                    COMPUTE ADDRESS OF TOP OF BOX   00052600
         SR    R4,R0                                                    00052700
         AR    R1,R0                    SET 2ND LINE ADDRESS            00052800
         LM    R14,R15,CHAR#            COMPUTE WIDTH OF BOX SEGMENT    00052900
         SR    R15,R14                                                  00053000
         MVI   0(R1),C'-'               SET FILL CHARACTER              00053100
         LR    R14,R15                  SAVE WIDTH OF BOX               00053200
         BCTR  R15,0                    DECREMENT BOX WIDTH FOR MOVE    00053300
         MVI   0(R4),C'_'               TOP OF BOX CHARACTER            00053400
         MVI   LINELEN*MAPLINE#(R4),C'_' BOTTOM FILL CHARACTER          00053500
         SH    R15,=H'2'                IS BOX WIDE ENOUGH TO FILL?     00053600
         BM    CORESEG3                 NO, THEN DON'T FILL             00053700
         EX    R15,FILLCHAR             FILL SECOND LINE                00053800
         LR    R1,R4                    SET TOP OF BOX ADDRESS          00053900
         EX    R15,FILLCHAR             FILL TOP                        00054000
         LA    R1,LINELEN*MAPLINE#(R4)  BOTTOM OF BOX ADDRESS           00054100
         EX    R15,FILLCHAR             FILL IT                         00054200
         LA    R1,LINELEN*2(R4)         POINTER TO SECOND LINE          00054300
         MVI   0(R1),C'<'               LEFT POINTER                    00054400
         LA    R5,1(R15,R1)             POINTER TO RIGHT SIDE           00054500
         MVI   0(R5),C'>'               RIGHT POINTER                   00054600
         SPACE 1                                                        00054700
         LH    R5,SP#AREA               LENGTH OF SUBPOOL ID            00054800
         SR    R14,R5                   IS THERE ROOM IN BOX?           00054900
         BM    CORESEG3                 NO, FORGET ANY ID               00055000
         SRL   R14,1                    CALCULATE OFFSET FOR ID         00055100
         LA    R14,0(R14,R1)            ADDRESS OF ID                   00055200
         BCTR  R14,0                                                    00055300
         BCTR  R5,0                     DECREMENT LENGTH FOR MOVE       00055400
         EX    R5,SETSP#                MOVE IN SUBPOOL ID              00055500
         SPACE 2                                                        00055600
CORESEG3 LA    R5,LINELEN+2(R15,R4)     RIGHT EDGE OF BOX               00055700
         LA    R0,MAPLINE#              NUMBER OF LINES                 00055800
         LA    R4,LINELEN-1(R4)         LEFT EDGE                       00055900
         SPACE 1                                                        00056000
CORESEG4 MVI   0(R4),C' '               FILL IN LEFT SIDE               00056100
         MVI   0(R5),C' '               AND RIGHT SIDE OF BOX           00056200
         LA    R4,LINELEN(R4)                                           00056300
         LA    R5,LINELEN(R5)                                           00056400
         BCT   R0,CORESEG4              IF MORE LINES                   00056500
         SPACE 1                                                        00056600
         L     R15,SEG#                 NEW SEGMENT NUMBER              00056700
         BCTR  R15,0                                                    00056800
         ST    R15,SEG#                                                 00056900
         CR    R8,R15                   END OF MAPPING?                 00057000
         LA    R1,MAPOFST2-MAPOFSET     ENDING ADDRESS                  00057100
         ST    R1,CHAR#                 ENDING POINTER                  00057200
         BNH   FIXCORE1                 CONTINUE MAPPING                00057300
         SPACE 1                                                        00057400
         SPACE 2                                                        00057500
NEXTCORE L     R3,CORECHN               NEXT CORE BLOCK                 00057600
         B     MAPCORE                  CONTINUE WITH NEXT CORE ELEMENT 00057700
         DROP  R3                                                       00057800
         SPACE 2                                                        00057900
NOCORE   DS    0H                                                       00058000
         L     R3,PTRPGMS               ADDRESS OF PROGRAM ELEMENT      00058100
MAPPGM   LTR   R3,R3                    ANY MORE PROGRAMS?              00058200
         BZ    NOPGMS                   NO                              00058300
         USING PGMBLK,R3                BASE FOR PROGRAM ELEMENT        00058400
         CLC   PGMADDR,RGNPTR           IS PROGRAM WITHIN REGION?       00058500
         BL    NEXTPGM                  NO, GET NEXT ELEMENT            00058600
         L     R14,RGNPTR               ADDRESS OF REGION BLOCK         00058700
         A     R14,RGNLEN               ADD IN LENGTH                   00058800
         C     R14,PGMADDR              PAST END OF REGION?             00058900
         BNH   NEXTPGM                  YES, GET NEXT ELEMENT           00059000
         SPACE 2                                                        00059100
         L     R8,PGMADDR               ADDRESS OF PROGRAM              00059200
         L     R9,PGMLEN                LENGTH OF PROGRAM               00059300
         S     R8,RGNPTR                SUBTRACT REGION START ADDRESS   00059400
         LA    R9,0(R9)                 DROP FLAGS BYTE FROM LENGTH     00059500
         AR    R9,R8                    SET ENDING ADDRESS              00059600
         SPACE 1                                                        00059700
         LR    R15,R8                                                   00059800
         BAL   R14,CALCLNE#             CALCULATE SEGMENT NUMBER        00059900
         SPACE 1                                                        00060000
         LR    R15,R9                                                   00060100
         L     R8,SEG#                  SAVE SEGMENT NUMBER             00060200
         L     R9,CHAR#                 SAVE CHARACTER NUMBER           00060300
         BAL   R14,CALCLNE#             CALCULATE LINE NUMBER OF END    00060400
         SPACE 1                                                        00060500
FIXPGM1  C     R8,SEG#                  SAME SEGMENT?                   00060600
         LR    R0,R9                    SET START POINTER               00060700
         L     R1,CHAR#                 SET END POINTER                 00060800
         BE    PGMSEG1                  ONLY ONE SEGMENT                00060900
         SPACE 1                                                        00061000
         SR    R0,R0                    START OF SEGMENT OFFSET         00061100
         LTR   R1,R1                    END AT START OF NEW SEGMENT?    00061200
         BNZ   PGMSEG1                  NO, MAP PROGRAM                 00061300
         SPACE 1                                                        00061400
         L     R15,SEG#                 GET SEGMENT NUMBER              00061500
         BCTR  R15,0                    DROP BY ONE                     00061600
         CR    R8,R15                   SAME AS START SEGMENT?          00061700
         ST    R15,SEG#                 SAVE SEGMENT NUMBER             00061800
         LA    R1,MAPOFST2-MAPOFSET     ENDING OFFSET                   00061900
         BNE   PGMSEG1                  NO, THEN MAP OUT SEGMENT        00062000
         LR    R0,R9                    FIRST SEGMENT-SET START OFFSET  00062100
         SPACE 1                                                        00062200
PGMSEG1  STM   R0,R1,CHAR#              SET POINTERS                    00062300
         BAL   R14,CALCSEG#             GET SEGMENT NUMBER              00062400
         LA    R1,LINELEN*3(R1)         ADJUST LINE POINTER             00062500
         LM    R14,R15,CHAR#            CALCULATE DIFFERENCE            00062600
         SR    R15,R14                  TO GET LINE LENGTH              00062700
         MVI   0(R1),C'*'               FILL CHARACTER FOR NULL POINTER 00062800
         LR    R14,R15                  SAVE VALUE                      00062900
         SH    R15,=H'2'                DROP COUNT BY 2 FOR MOVES       00063000
         BNP   PGMSEG2                  IF NOT ENOUGH IN LINE TO FILL   00063100
         SPACE 1                                                        00063200
         MVI   0(R1),C'-'               SET POINTER CHARACTER           00063300
         BCTR  R15,0                                                    00063400
         EX    R15,FILLCHAR             FILL IN POINTER LINE            00063500
         LA    R15,1(R15)               UP LENGTH                       00063600
         MVI   0(R1),C'<'               SET LEFT POINTER                00063700
         LA    R5,0(R1,R15)             ADDRESS OF RIGHT SIDE           00063800
         MVI   0(R5),C'>'                                               00063900
         SPACE 1                                                        00064000
PGMSEG2  LA    R15,PGMNAME+L'PGMNAME-1  COMPUTE LENGTH OF PROGRAM NAME  00064100
         LA    R0,PGMNAME                                               00064200
PGMSEG5  CLI   0(R15),C' '              BLANK?                          00064300
         BNE   PGMSEG4                  NO, END OF NAME                 00064400
         BCTR  R15,0                                                    00064500
         CR    R15,R0                                                   00064600
         BNE   PGMSEG5                                                  00064700
PGMSEG4  SR    R15,R0                   LENGTH-1 OF NAME                00064800
         SR    R14,R15                  WILL PROGRAM NAME FIT IN?       00064900
         BNP   PGMSEG3                  NO, BYPASS NAME                 00065000
         SH    R14,=H'2'                NEED EXTRA SPACE                00065100
         BP    PGMSEG6                  OK                              00065200
         SR    R14,R14                  SET ZERO OFFSET                 00065300
PGMSEG6  SRL   R14,1                    DIVIDE BY 2 TO GET OFFSET       00065400
         LA    R14,0(R14,R1)            GET OFFSET                      00065500
         EX    R15,SETNAME              PROGRAM NAME TO MAP             00065600
         SPACE 1                                                        00065700
PGMSEG3  L     R15,SEG#                 NEW SEGMENT NUMBER              00065800
         BCTR  R15,0                                                    00065900
         ST    R15,SEG#                                                 00066000
         CR    R8,R15                   END OF MAPPING?                 00066100
         LA    R1,MAPOFST2-MAPOFSET                                     00066200
         ST    R1,CHAR#                 ENDING POINTER                  00066300
         BNH   FIXPGM1                  CONTINUE MAPPING                00066400
         SPACE 2                                                        00066500
NEXTPGM  L     R3,PGMCHAIN              NEXT PROGRAM ELEMENT            00066600
         B     MAPPGM                   CONTINUE WITH NEXT PROGRAM      00066700
         DROP  R3                                                       00066800
         SPACE 2                                                        00066900
NOPGMS   DS    0H                                                       00067000
         SPACE 3                                                        00067100
*********************************************************************** 00067200
*        PRINT OUT MAP                                                * 00067300
*********************************************************************** 00067400
         SPACE 2                                                        00067500
         LA    R1,TITLE                                                 00067600
         BAL   R14,PRINTMAP             PRINT OUT MAP                   00067700
         EJECT                                                          00067800
*********************************************************************** 00067900
*              LIST CORE ALLOCATIONS                                  * 00068000
*********************************************************************** 00068100
         SPACE 1                                                        00068200
         L     R3,PTRCORE               ADDRESS OF FIRST CORE ELEMENT   00068300
         USING COREBLK,R3               BASE FOR ELEMENT                00068400
         LA    R7,TITLESP               ADDRESS OF TITLE                00068500
         LA    R8,1                     CURRENT LINE COUNT              00068600
LISTCOR2 LTR   R3,R3                    ANY MORE ELEMENTS?              00068700
         LA    R6,1                     INDICATE BUFFER TO BE DUMPED    00068800
         BZ    LISTPGMS                 NO, THEN LIST PROGRAMS          00068900
         MVC   BUFFER(2),=C'  '         INITIALIZE BUFFER               00069000
         MVC   BUFFER+2(L'BUFFER-2),BUFFER+1                            00069100
         SR    R0,R0                    CONVERT SUBPOOL ID TO CHARACTER 00069200
         IC    R0,CORESPID                                              00069300
         CVD   R0,DWORD                                                 00069400
         MVC   BUFFER+OFFSPID(L'MASKSPID),MASKSPID                      00069500
         ED    BUFFER+OFFSPID(L'MASKSPID),DWORD+L'DWORD-L'MASKSPID/2    00069600
         SPACE 1                                                        00069700
         CONVERT OFFSPADR,COREPTR                                       00069800
         CONVERT OFFSPLEN,CORELEN                                       00069900
         MVC   BUFFER+OFFSPFRE(4),=C'NONE' INDICATE NO FREE AREAS       00070000
         SPACE 1                                                        00070100
         L     R4,COREFREE              GET ADDRESS OF FREE ELEMENT     00070200
LISTFREE LTR   R4,R4                    ANY FREE CORE?                  00070300
         BZ    LISTCOR1                                                 00070400
         USING FREEBLK,R4                                               00070500
         SPACE 1                                                        00070600
         CONVERT OFFSPFRE,FREEPTR                                       00070700
         CONVERT OFFSPFRL,FREELEN                                       00070800
         BAL   R14,BUFFPRNT             PRINT BUFFER                    00070900
         SR    R6,R6                    INDICATE BUFFER PRINTED         00071000
         L     R4,FREECHN               ADDRESS OF NEXT ELEMENT         00071100
         B     LISTFREE                 LIST THIS ONE                   00071200
         DROP  R4                                                       00071300
         SPACE 2                                                        00071400
LISTCOR1 LTR   R6,R6                    NEED TO PRINT BUFFER?           00071500
         BZ    *+8                      NO                              00071600
         BAL   R14,BUFFPRNT             YES, PRINT BUFFER               00071700
         L     R3,CORECHN               NEXT CORE ELEMENT ADDRESS       00071800
         B     LISTCOR2                 LIST THIS ONE                   00071900
         DROP  R3                                                       00072000
         SPACE 3                                                        00072100
*********************************************************************** 00072200
*              LIST LOADED PROGRAMS                                   * 00072300
*********************************************************************** 00072400
         SPACE 1                                                        00072500
LISTPGMS L     R3,PTRPGMS               ADDRESS OF 1ST PROGRAM ELEMENT  00072600
         USING PGMBLK,R3                BASE FOR ELEMENT                00072700
         LA    R7,TITLEPGM              ADDRESS OF TITLE                00072800
         LTR   R3,R3                    ANY PROGRAMS?                   00072900
         BZ    LISTDONE                 NO, EXIT                        00073000
         LA    R14,1                                                    00073100
         MVI   BUFFER,C'+'              SPACE SUPPRESS                  00073200
         CH    R8,=H'7'                 AT LEAST 5 LINES LEFT?          00073300
         BL    LISTPGM2                 NO, PRINT NEW TITLE             00073400
         LR    R14,R8                                                   00073500
         MVC   BUFFER(L'TITLEPGM),TITLEPGM SET BUFFER AS TITLE          00073600
         MVI   BUFFER,C'-'              SET TRIPLE SPACE                00073700
LISTPGM2 LR    R8,R14                                                   00073800
         BAL   R14,BUFFPRNT                                             00073900
         MVI   BUFFER,C'0'                                              00074000
         SPACE 1                                                        00074100
LISTPGM1 MVC   BUFFER+OFFPGMNM(8),PGMNAME NAME TO BUFFER                00074200
         CONVERT OFFPGMAD,PGMADDR       ADDRESS OF PROGRAM              00074300
         CONVERT OFFPGMLN,PGMLEN        LENGTH OF PROGRAM               00074400
         SPACE 2                                                        00074500
         LA    R14,1                    INDICATE FIRST ATTRIBUTE        00074600
         LA    R15,BUFFER+OFFPGMAT-2    ADDRESS OF ATTRIBUTE LIST       00074700
         SPACE 2                                                        00074800
         PGMTYPE CDENIP,LINKPACK                                        00074900
         PGMTYPE CDEJPA,'JOB PACK'                                      00075000
         PGMTYPE CDERENT,REENTRANT                                      00075100
         PGMTYPE CDEREUS,REUSABLE                                       00075200
         SPACE 2                                                        00075300
         BAL   R14,BUFFPRNT             PRINT BUFFER                    00075400
         L     R3,PGMCHAIN              NEXT PROGRAM ELEMENT            00075500
         LTR   R3,R3                    ANY MORE ELEMENTS?              00075600
         BNZ   LISTPGM1                 YES, LIST NEXT ONE              00075700
         DROP  R3                                                       00075800
LISTDONE DS    0H                                                       00075900
         EJECT                                                          00076000
*********************************************************************** 00076100
*                                                                     * 00076200
*              END OF MAPPING - EXIT                                  * 00076300
*                                                                     * 00076400
*********************************************************************** 00076500
         SPACE 2                                                        00076600
         SR    R15,R15                                                  00076700
         SPACE 2                                                        00076800
EXIT     LR    R2,R15                                                   00076900
         CLOSE SYSPRINT                                                 00077000
         LR    R15,R2                                                   00077100
         SPACE 2                                                        00077200
*OMB     ABEND 4000,DUMP                                                00077300
         L     R13,4(,R13)                                              00077400
         RETURN (14,12),T,RC=(15)                                       00077500
         EJECT                                                          00077600
*********************************************************************** 00077700
*              LISTING SUBROUTINES                                    * 00077800
*********************************************************************** 00077900
         SPACE 2                                                        00078000
BUFFPRNT ST    R14,DWORD                SAVE LINKAGE REGISTER           00078100
         SR    R15,R15                                                  00078200
         CLI   BUFFER,C'+'              SPACE SUPRESS?                  00078300
         BE    BUFFPRT2                 YES                             00078400
         LA    R15,2                                                    00078500
         CLI   BUFFER,C'0'              DOUBLE SPACE?                   00078600
         BE    BUFFPRT2                 YES                             00078700
         LA    R15,3                                                    00078800
         CLI   BUFFER,C'-'              TRIPLE SPACE?                   00078900
         BE    BUFFPRT2                 YES                             00079000
         LA    R15,1                                                    00079100
         CLI   BUFFER,C' '              SINGLE SPACE?                   00079200
         BE    BUFFPRT2                 YES                             00079300
         CLI   BUFFER,C'1'              REQUEST FOR PAGE SKIP?          00079400
         BE    BUFFPRT3                 YES, THEN DO NEW PAGE           00079500
         MVI   BUFFER,C' '              DEFAULT TO SINGLE SPACE         00079600
BUFFPRT2 SR    R8,R15                   SUBTRACT COUNT                  00079700
         BP    BUFFPRT1                 ENOUGH LINES ON PAGE            00079800
         SPACE 1                                                        00079900
BUFFPRT3 IC    R8,0(R7)                 SAVE CARRIAGE CONTROL           00080000
         MVI   0(R7),C'1'               NEW PAGE CHARACTER              00080100
         PUT   SYSPRINT,(R7)            PRINT TITLE                     00080200
         MVI   BUFFER,C'0'              FORCE DOUBLE SPACE              00080300
         STC   R8,0(R7)                 RESTORE CARRIAGE CONTROL        00080400
         LH    R8,LINECNT               SET NUMBER OF LINES/PAGE        00080500
BUFFPRT1 PUT   SYSPRINT,BUFFER          PRINT BUFFER                    00080600
         MVI   BUFFER,C' '                                              00080700
         MVC   BUFFER+1(L'BUFFER-1),BUFFER                              00080800
         L     R14,DWORD                EXIT ADDRESS                    00080900
         BR    R14                      EXIT                            00081000
         SPACE 3                                                        00081100
BUFFFILL MVC   DWORD(3),0(R15)          MOVE IN DATA                    00081200
         MVI   DWORD+3,X'FE'                                            00081300
         UNPK  0(7,R1),DWORD(4)         CONVERT TO CHARACTER            00081400
         TR    0(7,R1),TRTABLE-X'EF'                                    00081500
         LA    R15,5                                                    00081600
BUFFFIL1 CLI   0(R1),C'0'               SUPPRESS LEADING ZEROS          00081700
*        BNER  R14                      NOT LEADING ZERO, EXIT          00081800
         BCR   7,R14                    NOT LEADING ZERO, EXIT          00081800
         MVI   0(R1),C' '               MAKE INTO BLANK                 00081900
         LA    R1,1(R1)                 JUMP ADDRESS                    00082000
         BCT   R15,BUFFFIL1             CONTINUE IF MORE                00082100
         BR    R14                      EXIT                            00082200
         EJECT                                                          00082300
*********************************************************************** 00082400
*              CREATE PROGRAM ELEMENTS FROM CDES                      * 00082500
*********************************************************************** 00082600
         SPACE 1                                                        00082700
DOCDE    LR    R5,R14                   SAVE LINKAGE REGISTER           00082800
*                                       IS THIS A MINOR CDE OR IS THE   00082900
*                                       MODULE IN THE PROCESS OF        00083000
*                                       BEING LOADED??                  00083100
         TM    CDEFLAGS-CDE(R3),CDEMINOR+CDELOAD                        00083200
*        BNZR  R14                      YES, SKIP IT                    00083300
         BCR   7,R14                    YES, SKIP IT                    00083300
         L     R4,CDEXL-CDE(R3)         GET EXTENT LIST POINTER         00083400
         LA    R4,0(R4)                 CLEAR HIGH BYTE                 00083500
         LTR   R4,R4                    EXTENT LIST PRESENT?            00083600
         BZ    NOXL                     NO, SKIP CDE ENTRY              00083700
         SPACE 1                                                        00083800
*        THE FOLLOWING INSTALLED BY MATTEL INC TO PREVENT DUPLICATE     00083900
*        PROGRAN ENTRIES IN PGM PRINT AREA  (06/3)                      00084000
         SPACE 1                                                        00084100
         L     R1,PTRPGMS               GET HEAD OF CHAIN          06/3 00084200
PGMLOOP  EQU   *                                                   06/3 00084300
         LTR   R1,R1                    END OF CHAIN ?             06/3 00084400
         BNP   NODUP                    YES, GET OUT               06/3 00084500
*        LUSE  PGMBLK,R1                                           06/3 00084600
         USING PGMBLK,R1
         CLC   PGMNAME,CDENAME-CDE(R3)  SAME PGM ?                 06/3 00084700
         BNE   PGMINCR                  NO, GO TRY NEXT            06/3 00084800
         CLC   PGMADDR,XLPTR-XL(R4)     REALLY SAME ?              06/3 00084900
         BNE   PGMINCR                  NO, GO TRY NEXT            06/3 00085000
         MVC   PGMFLAGS(1),CDEFLAGS-CDE(R3)  SAVE NEW INFO         06/3 00085100
         B     NOXL                     AND GET OUT                06/3 00085200
PGMINCR  EQU   *                                                   06/3 00085300
         L     R1,PGMCHAIN              GET NEXT BLOCK             06/3 00085400
         B     PGMLOOP                  AND TRY AGAIN              06/3 00085500
*        LDROP R1                                                  06/3 00085600
         DROP  R1
         SPACE 1                                                        00085700
NODUP    EQU   *                                                   06/3 00085800
         LA    R0,LPGMBLK               LENGTH OF PROGRAM ELEMENT       00085900
         BAL   R14,GETCORE              OBTAIN CORE                     00086000
         L     R15,PTRPGMS+4            POINTER TO LAST PROGRAM ELEMENT 00086100
         ST    R1,PGMCHAIN-PGMBLK(R15)  ADD NEW ELEMENT                 00086200
         ST    R1,PTRPGMS+4             SAVE NEW POINTER                00086300
         USING PGMBLK,R1                BASE FOR PROGRAM ELEMENT        00086400
         SPACE 1                                                        00086500
         MVC   PGMNAME(8),CDENAME-CDE(R3) PROGRAM NAME TO ELEMENT       00086600
         MVC   PGMADDR(4),XLPTR-XL(R4)  SET PROGRAM ADDRESS             00086700
         MVC   PGMLEN(4),XLSIZE-XL(R4)  SET SIZE OF PROGRAM             00086800
         MVC   PGMFLAGS(1),CDEFLAGS-CDE(R3) SET CDE FLAGS               00086900
NOXL     BR    R5                       EXIT TO CALLER                  00087000
         DROP  R1                                                       00087100
         EJECT                                                          00087200
*********************************************************************** 00087300
*              OBTAIN AN ELEMENT OF CORE                              * 00087400
*********************************************************************** 00087500
         SPACE 1                                                        00087600
GETCORE  ST    R0,SIZE                  SAVE CORE SIZE                  00087700
         LA    R1,SP#                   GET SUBPOOL NUMBER              00087800
         SLL   R1,24                                                    00087900
         OR    R0,R1                    SET IN R0                       00088000
         SPACE 1                                                        00088100
         GETMAIN R,LV=(0)               GET ELEMENT                     00088200
         L     R15,SIZE                 GET CORE SIZE                   00088300
         BCTR  R15,0                                                    00088400
         EX    R15,CLEAR                                                00088500
         BR    R14                      EXIT TO CALLER                  00088600
         EJECT                                                          00088700
*********************************************************************** 00088800
*              DISABLE SYSTEM DURING SEARCH                           * 00088900
*********************************************************************** 00089000
         SPACE 1                                                        00089100
DISABLE  DS    0H                                                       00089200
         SPACE 1                                                        00089300
*        BAL   R1,DISABLEX              ISSUE KEYZERO SVC               00089400
*        USING *,R1                                                     00089500
*        L     R15,28(R5)               GET CALLERS RB ADDRESS          00089600
*        MVI   16(R15),0                DISABLE CALLERS PSW             00089700
*        SVC   3                                                        00089800
*        DROP  R1                                                       00089900
*ISABLEX SVC   251                                                      00090000
         BR    R14                      EXIT                            00090100
         SPACE 3                                                        00090200
*********************************************************************** 00090300
*              ENABLE SYSTEM AFTER SEARCH                             * 00090400
*********************************************************************** 00090500
         SPACE 1                                                        00090600
ENABLE   DS    0H                                                       00090700
         SPACE 1                                                        00090800
*        BAL   R1,ENABLEX               ISSUE KEYZERO SVC               00090900
*        USING *,R1                                                     00091000
*        L     R15,28(R5)               GET CALLERS RB ADDRESS          00091100
*        MVI   16(R15),X'FF'            ENABLE CALLERS PSW              00091200
*        SVC   3                                                        00091300
*        DROP  R1                                                       00091400
*NABLEX  SVC   251                                                      00091500
         SPACE 1                                                        00091600
         BR    R14                                                      00091700
         EJECT                                                          00091800
*********************************************************************** 00091900
*              MAP OUT FREE AREA                                      * 00092000
*********************************************************************** 00092100
         SPACE 2                                                        00092200
FIXFREE  LR    R15,R14                  SAVE RETURN REGISTER            00092300
         BAL   R14,CALCSEG#             CALCULATE SEGMENT NUMBER        00092400
         SPACE 1                                                        00092500
         L     R14,CHAR#+4              GET OFFSET OF LAST CHARACTER    00092600
         BCTR  R14,0                    REDUCE TO AVOID ROUNDING ERRORS 00092700
         S     R14,CHAR#                SUBTRACT STARTING POSITION      00092800
         MVI   0(R1),C'/'               SET FILL CHARACTER              00092900
         SH    R14,=H'2'                DECREMENT TOTAL LENGTH          00093000
         BNM   FREEOK                                                   00093100
         SR    R14,R14                                                  00093200
         B     FREELESS                                                 00093300
         SPACE 1                                                        00093400
FREEOK   EX    R14,FILLCHAR             FILL IN LINE                    00093500
         LA    R14,1(R14)               UP LENGTH OF AREA               00093600
FREELESS LA    R0,MAPLINE#-2            TOTAL NUMBER OF LINES/SEGMENT   00093700
FREEFILL EX    R14,FILLSEG                                              00093800
         LA    R1,LINELEN(R1)                                           00093900
         BCT   R0,FREEFILL              CONTINUE FILLING                00094000
         BR    R15                      EXIT TO CALLER                  00094100
         EJECT                                                          00094200
*********************************************************************** 00094300
*                                                                     * 00094400
*              OBTAIN NEW MAP AND CLEAR IT                            * 00094500
*                                                                     * 00094600
*********************************************************************** 00094700
         SPACE 2                                                        00094800
         USING RGNBLK,R2                                                00094900
CLEARMAP STM   R14,R12,12(R13)          SAVE ENTRY REGISTERS            00095000
         L     R5,RGNLEN                LENGTH OF REGION BLOCK          00095100
         SR    R4,R4                                                    00095200
         D     R4,#16K                  DIVIDE BY CORE/SEGMENT          00095300
         LTR   R4,R4                    EVEN MULTIPLE?                  00095400
         BZ    *+8                      YES                             00095500
         LA    R5,1(R5)                 NO, ROUND UP                    00095600
         SPACE 1                                                        00095700
         SR    R4,R4                                                    00095800
         LA    R0,MAPLINE#              MULTIPLY BY LINES/SEGMENT       00095900
         MR    R4,R0                                                    00096000
         LA    R5,1(R5)                 ADD 1 LINE FOR TOP OF MAP       00096100
         LA    R0,LINELEN               MULTIPLY BY LENGTH OF ONE LINE  00096200
         MR    R4,R0                                                    00096300
*              R5 ---  SIZE OF CORE NEEDED                              00096400
         ST    R5,MAPSIZE               SAVE MAP SIZE                   00096500
         LA    R0,0(R5)                                                 00096600
         LA    R1,MAPSP#                SUBPOOL NUMBER FOR MAP          00096700
         SLL   R1,24                                                    00096800
         OR    R0,R1                                                    00096900
         SPACE 1                                                        00097000
         GETMAIN R,LV=(0)               GET CORE                        00097100
         SPACE 1                                                        00097200
         LA    R1,0(R1)                                                 00097300
         ST    R1,MAPADDR               SAVE MAP ADDRESS                00097400
         SPACE 1                                                        00097500
         L     R3,RGNPTR                GET BLOCK ADDRESS               00097600
         LA    R4,1                                                     00097700
         LA    R0,LINELEN                                               00097800
         L     R15,MAPSIZE                                              00097900
         MVI   0(R1),C' '               CLEAR FIRST LINE                00098000
         MVC   1(LINELEN-1,R1),0(R1)                                    00098100
         SR    R15,R0                   REDUCE REMAINING LENGTH         00098200
         LA    R14,MAPLINE#-1           NUMBER OF LINES/SEGMENT -1      00098300
         MVI   MAPOFSET+1(R1),C'_'                                      00098400
         MVC   MAPOFSET+2(MAPOFST2-MAPOFSET-2,R1),MAPOFSET+1(R1)        00098500
NEXTCLR  AR    R1,R0                    INCREMENT LINE POINTER          00098600
         SR    R15,R0                   DECREMENT TOTAL LENGTH          00098700
         BNP   CLEARED                                                  00098800
         MVI   0(R1),C' '                                               00098900
         MVC   1(LINELEN-1,R1),0(R1)    CLEA LINE                       00099000
         MVI   MAPOFSET(R1),C' '                                        00099100
         MVI   MAPOFST2(R1),C' '                                        00099200
         BCT   R4,NEXTCLR                                               00099300
         ST    R3,DWORD                                                 00099400
         MVI   DWORD+4,X'FE'                                            00099500
         UNPK  1(7,R1),DWORD+1(4)                                       00099600
         TR    1(7,R1),TRTABLE-X'EF'                                    00099700
         A     R3,#16K                                                  00099800
         LA    R4,MAPLINE#                                              00099900
         SPACE 1                                                        00100000
         B     NEXTCLR                                                  00100100
         SPACE 1                                                        00100200
CLEARED  MVI   0(R1),C' '                                               00100300
         MVC   1(LINELEN-1,R1),0(R1)    CLEAR LAST MAP LINE             00100400
         SPACE 1                                                        00100500
         L     R14,RGNLEN               GET SIZE OF BLOCK               00100600
         SRDL  R14,32                                                   00100700
         D     R14,#16K                                                 00100800
         LTR   R14,R14                  EVEN MULTIPLE                   00100900
         L     R15,#16K                                                 00101000
         BZ    EVEN#                    YES                             00101100
         LR    R15,R14                                                  00101200
         SPACE 1                                                        00101300
EVEN#    LH    R0,CHARMAP               NUMBER BYTES/1 CHAR             00101400
         SR    R14,R14                                                  00101500
         DR    R14,R0                   COMPUTE OFFSET                  00101600
         LR    R0,R15                   SAVE # OF CHARACTERS            00101700
         SR    R14,R14                                                  00101800
         D     R14,=F'4'                NUMBER OF SEPERATION CHARACTERS 00101900
         AR    R15,R0                   TOTAL NUMBER OF CHARACTERS      00102000
         MVI   MAPOFSET(R1),C' '                                        00102100
         SH    R15,=H'3'                                                00102200
         MVI   MAPOFSET+1(R1),C'_'                                      00102300
         EX    R15,FILL                                                 00102400
         LA    R0,LINELEN                                               00102500
         LA    R14,MAPLINE#                                             00102600
         B     CLRLOOP2                                                 00102700
CLRLOOP  L     R14,DWORD                                                00102800
         BCT   R14,CLRLOOP1                                             00102900
         B     CLRDONE                                                  00103000
CLRLOOP1 MVI   MAPOFSET+1(R1),C' '                                      00103100
         MVC   MAPOFSET+2(LINELEN-MAPOFSET-3,R1),MAPOFSET+1(R1)         00103200
CLRLOOP2 ST    R14,DWORD                                                00103300
         LA    R14,MAPOFSET+3(R1,R15)                                   00103400
         MVI   0(R14),C' '                                              00103500
         SR    R1,R0                                                    00103600
         B     CLRLOOP                                                  00103700
         SPACE 2                                                        00103800
CLRDONE  LA    R14,MAPOFSET+3(R15)                                      00103900
         SR    R0,R14                                                   00104000
         LR    R14,R0                                                   00104100
         BCTR  R14,0                                                    00104200
         BCTR  R14,0                                                    00104300
         LA    R1,MAPOFSET+3(R1,R15)                                    00104400
         MVI   0(R1),C' '                                               00104500
         EX    R14,CLRLINE                                              00104600
         LA    R0,LINELEN                                               00104700
         A     R0,MAPADDR                                               00104800
         CR    R1,R0                    IS LINE WITHIN FIRST LINE?      00104900
         BL    CLRDONE1                                                 00105000
         LA    R0,LINELEN-MAPOFST2+1                                    00105100
         SR    R14,R0                                                   00105200
         LA    R1,1(R1)                                                 00105300
         MVI   0(R1),C'_'                                               00105400
         EX    R14,CLRLINE                                              00105500
         LA    R1,2(R14,R1)                                             00105600
         MVI   0(R1),C' '                                               00105700
CLRDONE1 LM    R14,R12,12(R13)          RESTORE REGISTERS               00105800
         BR    R14                      EXIT TO CALLER                  00105900
         DROP  R2                                                       00106000
         EJECT                                                          00106100
*********************************************************************** 00106200
*              CALCULATE SEGMENT NUMBER AND STARTING                  * 00106300
*              OFFSET IN MAP FOR A GIVEN ADDRESS                      * 00106400
*                                                                     * 00106500
*              REGISTER R15 HAS ADDRESS                               * 00106600
*********************************************************************** 00106700
         SPACE 2                                                        00106800
CALCLNE# STM   R14,R12,12(R13)          SAVE REGISTERS AT ENTRY         00106900
         SR    R14,R14                                                  00107000
         D     R14,#16K                 DIVIDE BY 16 K TO LOCATE        00107100
*                                       SEGMENT NUMBER                  00107200
         ST    R15,SEG#                 SET SEGMENT NUMBER              00107300
         SRDL  R14,32                   DIVIDE REMAINER TO GET OFFSET   00107400
         LH    R0,CHARMAP               DIVIDE BY #BYTES/1 CHARACTER    00107500
         DR    R14,R0                                                   00107600
         LTR   R14,R14                                                  00107700
         BZ    *+8                                                      00107800
         LA    R15,1(R15)                                               00107900
         LR    R0,R15                   SAVE NUMBER OF CHARACTERS       00108000
         SR    R14,R14                                                  00108100
         D     R14,=F'4'                NUMBER OF SEPERATION CHARACTERS 00108200
         AR    R15,R0                   TOTAL NUMBER OF CHARACTERS      00108300
         ST    R15,CHAR#                SET OFFSET FROM START OF LINE   00108400
         LM    R14,R12,12(R13)          RESTORE CALLERS REGISTERS       00108500
         BR    R14                      EXIT                            00108600
         SPACE 2                                                        00108700
*********************************************************************** 00108800
*              CALCULATE STARTING ADDRESS WITHIN MAP                  * 00108900
*              FOR A GIVEN SEGMENT AND CHARACTER OFFSET               * 00109000
*                                                                     * 00109100
*              SEGMENT NUMBER IS IN SEG#                              * 00109200
*              CHARACTER OFFSET IS IN CHAR#                           * 00109300
*********************************************************************** 00109400
         SPACE 2                                                        00109500
CALCSEG# STM   R14,R12,12(R13)          SAVE ENTRY REGISTERS            00109600
         L     R15,SEG#                 GET SEGMENT NUMBER              00109700
         SR    R14,R14                                                  00109800
         LA    R0,MAPLINE#              NUMBER OF LINES/SEGMENT OF MAP  00109900
         MR    R14,R0                   GET NUMBER OF LINES TO SKIP     00110000
         LA    R15,1(R15)               ADD 1 FOR TOP LINE              00110100
         LA    R0,LINELEN               LENGTH OF EACH LINE             00110200
         MR    R14,R0                   GET TOTAL NUMBER OF BYTES       00110300
*                                       TO SKIP TO START OF LINE        00110400
         LA    R15,MAPOFSET+1(R15)      ADD OFFSET TO FIRST CHARACTER   00110500
         A     R15,CHAR#                OFFSET TO REQUIRED CHARACTER    00110600
         A     R15,MAPADDR              ADD IN START OF MAP ADDRESS     00110700
         ST    R15,24(R13)              RETURN ADDRESS IN REGISTER 1    00110800
         LM    R14,R12,12(R13)          RELOAD ENTRY REGISTERS          00110900
         BR    R14                      EXIT TO CALLER                  00111000
         EJECT                                                          00111100
*********************************************************************** 00111200
*              ERROR EXITS                                            * 00111300
*********************************************************************** 00111400
         SPACE 2                                                        00111500
NOPRINT  LA    R15,16                   ERROR CODE - MISSING DD CARD    00111600
         B     EXIT                                                     00111700
         SPACE 2                                                        00111800
NOPARMS  PUT   SYSPRINT,MSGPARMS        ERROR MESSAGE                   00111900
         LA    R15,12                   ERROR CODE - PARAMETER ERROR    00112000
         B     EXIT                                                     00112100
         SPACE 2                                                        00112200
PARMERR  PUT   SYSPRINT,MSGPRMER        ERROR MESSAGE                   00112300
         LA    R15,12                   ERROR CODE - PARAMETER ERROR    00112400
         B     EXIT                                                     00112500
         SPACE 2                                                        00112600
NOTASK   BAL   R14,ENABLE               ENABLE SYSTEM                   00112700
         PUT   SYSPRINT,TASKMSG                                         00112800
         LA    R15,8                    ERROR CODE - TASK NOT FOUND     00112900
         B     EXIT                                                     00113000
         SPACE 2                                                        00113100
NOREGION PUT   SYSPRINT,MSGREGN                                         00113200
         LA    R15,8                    ERROR CODE - NO REGION FOUND    00113300
         B     EXIT                                                     00113400
         EJECT                                                          00113500
*********************************************************************** 00113600
*              PROGRAM CHECK PRINT OUT ROUTINE                        * 00113700
*********************************************************************** 00113800
         SPACE 2                                                        00113900
PGMCHECK STM   R14,R12,PGMSAVE          SAVE ENTRY REGISTERS            00114000
         LR    R2,R1                    SAVE PIE ADDRESS                00114100
         LA    R1,TITLE2                                                00114200
         BAL   R14,PRINTMAP             PRINT OUT MAP                   00114300
         CLOSE SYSPRINT                                                 00114400
         MVC   PGMSAVE+72(32),0(R2)     SAVE PIE                        00114500
         ABEND 3000,DUMP                                                00114600
         SPACE 3                                                        00114700
PGMSAVE  DC    18F'0',8F'0'                                             00114800
         EJECT                                                          00114900
*********************************************************************** 00115000
*              MAP PRINT ROUTINE                                      * 00115100
*********************************************************************** 00115200
         SPACE 2                                                        00115300
PRINTMAP STM   R0,R15,PRINTSAV                                          00115400
         LA    R13,PRINTSAV+72                                          00115500
         MVI   0(R1),C'1'               INSURE TITLE STARTS NEW PAGE    00115600
         LR    R0,R1                    SET TITLE ADDRESS               00115700
         L     R3,MAPADDR               ADDRESS OF MAP                  00115800
         LA    R4,LINELEN                                               00115900
         L     R5,MAPSIZE                                               00116000
         AR    R5,R3                                                    00116100
         SR    R5,R4                                                    00116200
         PUT   SYSPRINT,(0)             PUT OUT TITLE                   00116300
         MVI   0(R3),C'-'                                               00116400
MAPPRINT PUT   SYSPRINT,(R3)                                            00116500
         BXLE  R3,R4,MAPPRINT                                           00116600
         LM    R0,R15,PRINTSAV          RESTORE REGISTERS               00116700
         BR    R14                      EXIT                            00116800
         SPACE 3                                                        00116900
PRINTSAV DC    36F'0'                                                   00117000
         EJECT                                                          00117100
*********************************************************************** 00117200
*                                                                     * 00117300
*              CONSTANTS                                              * 00117400
*                                                                     * 00117500
*********************************************************************** 00117600
         SPACE 2                                                        00117700
DWORD    DS    D                                                        00117800
         SPACE 2                                                        00117900
SYSPRINT DCB   DSORG=PS,LRECL=133,RECFM=FBA,DDNAME=SYSPRINT,           X00118000
               EXLST=EXLST,MACRF=PM                                     00118100
         SPACE 2                                                        00118200
         DS    0F                                                       00118300
EXLST    DC    X'85',AL3(OPENEXIT)                                      00118400
#16K     DC    A(16*1024)               16K                             00118500
         SPACE 2                                                        00118600
MAINTASK DC    F'0'                                                     00118700
PTRRGN   DC    A(0,PTRRGN)                                              00118800
PTRCORE  DC    A(0,PTRCORE)                                             00118900
PTRPGMS  DC    A(0,PTRPGMS)                                             00119000
SIZE     DC    F'0'                                                     00119100
MAPADDR  DC    F'0'                                                     00119200
MAPSIZE  DC    F'0'                                                     00119300
CHAR#    DC    2F'0'                                                    00119400
SEG#     DC    F'0'                                                     00119500
SP#      EQU   1                        SUBPOOL NUMBER FOR CORE         00119600
MAPSP#   EQU   2                        SUBPOOL NUMBER FOR MAP          00119700
NAMESET  MVC   TASKNAME(0),2(R2)        ** MOVE NAME TO TITLE **        00119800
PARMMOVE MVC   TASKID(0),2(R2)          ** MOVE PARMS - EXECUTED **     00119900
CLEAR    XC    0(0,R1),0(R1)            ** CLEAR CORE - EXECUTED **     00120000
CLRLINE  MVC   1(0,R1),0(R1)            ** CLEAR LINE - EXECUTED **     00120100
MOVESP#  MVC   SP#AREA+5(0),0(R14)      **MOVE SUBPOOL ID - EXECUTED**  00120200
FILLCHAR MVC   1(0,R1),0(R1)            ** FILL LINE - EXECUTED **      00120300
SETSP#   MVC   1(0,R14),SP#AREA+2       **SUPPLY SUBPOOL ID - EXECUTED* 00120400
SETNAME  MVC   0(0,R14),PGMNAME-PGMBLK(R3) * FILL IN PROGRAM NAME *     00120500
FILLSEG  MVC   LINELEN(0,R1),0(R1)      ** FILL NEXT LINE IN SEGMENT ** 00120600
FILL     MVC   MAPOFSET+2(0,R1),MAPOFSET+1(R1) **FILL LINE - EXECUTED** 00120700
MAXPRMLN DC    H'8'                     MAXIMUM LENGTH OF TASKNAME      00120800
CHARMAP  DC    H'256'                   BYTES/MAP CHAR                  00120900
         SPACE 2                                                        00121000
MASKSPID DC    X'40202120'              MASK FOR EDITING SUBPOOL ID     00121100
LINECNT  DC    H'56'                    LINE COUNT FOR OUTPUT           00121200
         SPACE 2                                                        00121300
SP#AREA  DC    H'0',C'SP XXX'                                           00121400
LSP#     EQU   3                        LENGTH OF BASIC SECTION         00121500
TITLE    DC    CL133'1'                                                 00121600
         ORG   TITLE+1                                                  00121700
         DC    C'MAP OF REGION FOR TASK ----> '                         00121800
TASKNAME DC    CL8' '                                                   00121900
         ORG                                                            00122000
         SPACE 2                                                        00122100
TITLE2   DC    CL133'1MAP OF REGION AT TIME OF PROGRAM CHECK'           00122200
         SPACE 2                                                        00122300
TITLESP  DC    CL133'0SUBPOOL ID     BLOCK ADDRESS     LENGTH          X00122400
               FREE AREA     LENGTH'                                    00122500
TITLEPGM DC CL133'0PROGRAM NAME     ADDRESS     LENGTH     ATTRIBUTES'  00122600
BUFFER   DS    CL133                                                    00122700
         SPACE 2                                                        00122800
TASKMSG  DC    CL133'-'                                                 00122900
         ORG   TASKMSG+1                                                00123000
TASKID   DC    CL8' ',C' --- TASK NOT FOUND'                            00123100
         ORG                                                            00123200
         SPACE 2                                                        00123300
MSGREGN  DC    CL133'-TASK HAS NO REGION'                               00123400
         SPACE 2                                                        00123500
MSGPARMS DC    CL133'-NO TASK ID GIVEN (PARM FIELD MISSING)'            00123600
         SPACE 2                                                        00123700
MSGPRMER DC    CL133'-TASK ID (PARAMETER FIELD) TOO LONG'               00123800
         EJECT                                                          00123900
*********************************************************************** 00124000
*              EQUATED VALUES                                         * 00124100
*********************************************************************** 00124200
         SPACE 1                                                        00124300
LINELEN  EQU   133                                                      00124400
MAPLINE# EQU   6                                                        00124500
TRTABLE  DC    C' 0123456789ABCDEF'                                     00124600
MAPOFSET EQU   10                                                       00124700
MAPOFST2 EQU   MAPOFSET+80                                              00124800
         SPACE 2                                                        00124900
OFFSPID  EQU   3                        OFFSET FOR SUBPOOL ID IN BUFFER 00125000
OFFSPADR EQU   19                       SUBPOOL ADDRESS IN BUFFER       00125100
OFFSPLEN EQU   34                       OFFSET FOR SUBPOOL LENGTH       00125200
OFFSPFRE EQU   52                       OFFSET FOR FREE ADDRESS         00125300
OFFSPFRL EQU   64                       OFFSET FOR FREE LENGTH          00125400
OFFPGMNM EQU   4                        OFFSET FOR PROGRAM NAME         00125500
OFFPGMAD EQU   19                       OFFSET FOR PROGRAM ADDRESS      00125600
OFFPGMLN EQU   30                       OFFSET FOR PROGRAM LENGTH       00125700
OFFPGMAT EQU   41                       OFFSET FOR ATTRIBUTE LIST       00125800
         EJECT                                                          00125900
*********************************************************************** 00126000
*              DCB OPEN EXIT ROUTINE                                  * 00126100
*********************************************************************** 00126200
         SPACE 2                                                        00126300
         USING IHADCB,R1                                                00126400
OPENEXIT LH    R2,DCBBLKSI              GET BLOCKSIZE                   00126500
         LH    R0,DCBLRECL              GET LOGICAL RECORD SIZE         00126600
         LTR   R2,R2                    BLOCKSIZE GIVEN?                00126700
         BZ    SETBLKSI                 NO, SET DEFAULT=LRECL           00126800
         SRDL  R2,32                    BLOCKSIZE EVEN MULTIPLE OF      00126900
         DR    R2,R0                    RECORD SIZE?                    00127000
         LTR   R2,R2                                                    00127100
*        BZR   R14                      YES, EXIT                       00127200
         BCR   8,R14                    YES, EXIT                       00127200
         MR    R2,R0                    NO, ROUND DOWN TO MULTIPLE      00127300
         LR    R0,R3                                                    00127400
SETBLKSI STH   R0,DCBBLKSI              SET BLOCKSIZE                   00127500
         BR    R14                      EXIT                            00127600
         DROP  R1                                                       00127700
         EJECT                                                          00127800
         DCBD  DSORG=PS                                                 00127900
         END                                                            00128000
//LKED   EXEC PGM=IEWL,PARM=(XREF,LET,LIST,NCAL,MAP),
//            REGION=128K,COND=(4,LT,ASM)
//SYSLIN   DD DSN=&&OBJSET,DISP=(OLD,DELETE)
//         DD DDNAME=SYSIN
//SYSLMOD  DD DSN=SYS1.LINKLIB,DISP=SHR
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1024,(50,20))
//SYSPRINT DD SYSOUT=A
//SYSIN    DD *
 NAME COREMAP(R)
//

