//SY20ZR05 JOB 1,SOFTWARE,REGION=128K,CLASS=A,MSGCLASS=A          
//ASM1   EXEC PGM=IFOX00,PARM='DECK'  
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=19040
//         DD  DISP=SHR,DSN=SYS1.MODGEN
//SYSUT1   DD   DSN=&&SYSUT1,UNIT=SYSALLDA,SPACE=(1700,(600,100))  
//SYSUT2   DD   DSN=&&SYSUT2,UNIT=SYSALLDA,SPACE=(1700,(600,100))  
//SYSUT3   DD   DSN=&&SYSUT3,UNIT=SYSALLDA,SPACE=(1700,(600,100))  
//SYSPRINT DD   SYSOUT=*                                           
//SYSGO    DD   DUMMY                                              
//SYSLIN   DD   DUMMY                                              
//SYSPUNCH DD   DSN=&&OBJSET,UNIT=SYSALLDA,SPACE=(1700,(600,100)), 
//         DISP=(NEW,PASS)                                         
//SYSIN    DD   *
         MACRO                                                          00004000
&LABEL   IEFSAVER    &P1                                                00006000
 AIF ('&LABEL' EQ '').A0                                                00008000
&LABEL   DS    0H                                                       00010000
.A0      ANOP                                                           00012000
         GETMAIN R,LV=72          GET NEW SAVE AREA                     00014000
         XC    0(72,1),0(1)       ZERO SAVE AREA                        00016000
         ST    13,4(0,1)          CHAIN SAVE AREAS TOGETHER             00018000
         ST    1,8(0,13)          CHAIN SAVE AREAS TOGETHER             00020000
         LR    13,1               PTR TO SAVE AREA                      00022000
         AIF   ('&P1' EQ '').A                                          00024000
         ST    13,&P1             PTR TO CURRENT SAVE AREA              00026000
.A       ANOP                                                           00028000
         MEND                                                           00030000
         SPACE 4                                                        00032000
         MACRO                                                          00034000
&LABEL   IEFRELSE    &P1                                                00036000
 AIF ('&LABEL' EQ '').A0                                                00038000
&LABEL   DS    0H                                                       00040000
.A0      ANOP                                                           00042000
         LR    1,13               SET UP TO FREE AREA                   00044000
         L     13,4(0,13)         RESTORE PTR TO PREV SAVE AREA         00046000
         AIF   ('&P1' EQ '').A                                          00048000
         ST    13,&P1             PTR TO PREVIOUS SAVE AREA             00050000
.A       ANOP                                                           00052000
         FREEMAIN R,LV=72,A=(1)   RELEASE OLD SAVE AREA                 00054000
         MEND                                                           00056000
         MACRO                                                          00060000
         REGEQU                                                         00062000
R0       EQU   0                                                        00066000
R1       EQU   1                                                        00068000
R2       EQU   2                                                        00070000
R3       EQU   3                                                        00072000
R4       EQU   4                                                        00074000
R5       EQU   5                                                        00076000
R6       EQU   6                                                        00078000
R7       EQU   7                                                        00080000
R8       EQU   8                                                        00082000
R9       EQU   9                                                        00084000
R10      EQU   10                                                       00086000
R11      EQU   11                                                       00088000
R12      EQU   12                                                       00090000
R13      EQU   13                                                       00092000
R14      EQU   14                                                       00094000
R15      EQU   15                                                       00094000
         MEND                                                           00100000
         EJECT ,
TDEV     TITLE 'DEVICE TYPE ANALYZER'                                   00001000
         PRINT NOGEN                                                    00002000
DEVTABLE CSECT                ESTABLISH CSECT                           00003000
         SAVE  (14,12),,*     SAVE REGISTERS                            00004000
         LR    R12,R15        SET BASE                                  00005000
         LA    R11,2048(,R12) SET SECOND BASE                           00006000
         LA    R11,2048(,R11) ...                                       00007000
         USING DEVTABLE,R12,R11 INFORM ASSEMBLER                        00008000
         IEFSAVER ,           LINK SAVE AREAS                           00009000
*                                                                       00010000
         CALL  PUTOPEN        GO OPEN UP PRINT FILE                     00011000
DEVLOOP  CALL  LOADDEVT       GO LOAD DEVICE TABLES                     00012000
         CALL  READCARD       READ A CONTROL CARD                       00013000
         TM    SWITCH,EOF     IS IT END OF FILE                         00014000
         BO    DEVBACK        YES. GO TERMINATE                         00015000
         CALL  PROCCARD       GO PROCESS THE CARD                       00016000
         B     DEVLOOP        GO AROUND AGAIN                           00017000
*                                                                       00018000
DEVBACK  CALL  CLOSEUP        GO CLOSE FILES, ETC.                      00019000
*                                                                       00020000
         IEFRELSE ,           FREE UP SAVE AREA                         00021000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00022000
         EJECT                                                          00023000
         ENTRY BLDL           MAKE NAME AVAILABLE                       00024000
BLDL     SAVE  (14,12),,*     SAVE REGISTERS                            00025000
         LR    R12,R15        ESTABLISH BASE                            00026000
         USING BLDL,R12       INFORM ASSEMBLER                          00027000
         IEFSAVER ,           LINK UP                                   00028000
*                                                                       00029000
         BLDL  ZAPLIB,BUILDLST  FIND DEVICE TABLES                      00030000
         B     *+4(R15)       FIND RETURN CODE                          00031000
         B     GOODBLDL       NO PROBLEMS                               00032000
         B     NOTFOUND       TABLES NOT FOUND                          00033000
         B     BLDLERR        I/O ERROR                                 00034000
*                                                                       00035000
GOODBLDL DS    0H                                                       00036000
         NI    DEVMASKT+22,B'00111111'  FORCE NOT-REUS/NOT-RENT         00037000
         NI    DEVNAMET+22,B'00111111'  ...                             00038000
         CLI   Z,0            WAS MASK TABLE IN PRIVATE LIBRARY         00039000
         BNE   WRONGLIB       NO                                        00040000
         CLI   Z@,0           WAS NAME TABLE IN PRIVATE LIBRARY         00041000
         BNE   WRONGLIB       NO                                        00042000
         B     TERM           ALL OK                                    00043000
*                                                                       00044000
NOTFOUND DS    0H                                                       00045000
         MVC   LINE(L'MISSMEM),MISSMEM SAY MISSING MEMBER               00046000
         MVI   LINE-1,C'0'    DOUBLE SPACE                              00047000
         CALL  PUT            PUT OUT THE MESSAGE                       00048000
         CALL  CLOSEUP        CLOSE ALL FILES                           00049000
         ABEND 3              QUIT QUICKLY                              00050000
*                                                                       00051000
BLDLERR  DS    0H                                                       00052000
         MVC   LINE(L'BLDERR),BLDERR  SAY BLDL I/O ERROR                00053000
         MVI   LINE-1,C'0'    DOUBLE SPACE                              00054000
         CALL  PUT            PUT OUT THE LINE                          00055000
         CALL  CLOSEUP        CLOSE ALL FILES                           00056000
         ABEND 3              QUIT QUICKLY                              00057000
*                                                                       00058000
WRONGLIB DS    0H                                                       00059000
         MVC   LINE(L'WRONG),WRONG  SAY WRONG LIBRARY                   00060000
         MVI   LINE-1,C'0'    DOUBLE SPACE                              00061000
         CALL  PUT            GO PUT OUT THE MESSAGE                    00062000
         CALL  CLOSEUP        CLOSE ALL FILES                           00063000
         ABEND 4              QUIT QUICKLY                              00064000
*                                                                       00065000
TERM     DS    0H                                                       00066000
         IEFRELSE ,           UNLINK                                    00067000
         RETURN (14,12),T,RC=0                                          00068000
         EJECT                                                          00069000
         ENTRY LOADDEVT       MAKE NAME AVAILABLE                       00070000
LOADDEVT SAVE  (14,12),,*     SAVE REGISTERS                            00071000
         LR    R12,R15        SET A BASE                                00072000
         USING LOADDEVT,R12   INFORM ASSEMBLER                          00073000
         IEFSAVER ,           LINK SAVE AREAS                           00074000
*                                                                       00075000
DELNAME  DELETE DE=DEVNAMET   DELETE DEVICE NAME TABLE                  00076000
         LTR   R15,R15        WHAT HAPPENED                             00077000
         BZ    DELNAME        ASSURE NAME TABLE IS COMPLETELY OUT       00078000
DELMASK  DELETE DE=DEVMASKT   DELETE DEVICE MASK TABLE                  00079000
         LTR   R15,R15        AGAIN SEE WHAT HAPPENED                   00080000
         BZ    DELMASK        DELETE TILL ALL GONE                      00081000
*                                                                       00082000
         CLOSE ZAPLIB         ASSURE ZAPLIB IS CLOSED                   00083000
*                                                                       00084000
         OPEN  ZAPLIB         TRY TO OPEN ZAPLIB                        00085000
         LA    R1,ZAPLIB      ADDRESSIBILITY                            00086000
         USING IHADCB,R1      INFORM ASSEMBLER                          00087000
         TM    DCBOFLGS,DCBOFOPN  DID DCB OPEN                          00088000
         BO    ZAPOPEN        MUST HAVE                                 00089000
         MVC   LINE(L'MISSZAP),MISSZAP  SAY DD CARD MISSING             00090000
         MVI   LINE-1,C'0'    DOUBLE SPACE                              00091000
         CALL  PUT            GO PUT OUT THE LINE                       00092000
         CALL  CLOSEUP        CLOSE ALL FILES                           00093000
         ABEND 2              QUIT QUICKLY                              00094000
         DROP  R1             REMIND OURSELVES                          00095000
*                                                                       00096000
ZAPOPEN  CALL  BLDL           GO ISSUE BLDL                             00097000
         LOAD  DE=DEVMASKT,DCB=ZAPLIB  LOAD THE DEVICE MASK TABLE       00098000
         ST    R0,ADDRMASK    SAVE THE ADDRESS                          00099000
         LOAD  DE=DEVNAMET,DCB=ZAPLIB  LOAD THE DEVICE NAME TABLE       00100000
         ST    R0,ADDRNAME    SAVE THE ADDRESS                          00101000
         CALL  ANALDEV        SET UP TABLE INFO                         00102000
*                                                                       00103000
         IEFRELSE ,           FREE UP SAVE AREA                         00104000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00105000
         EJECT                                                          00106000
         ENTRY ANALDEV        MAKE NAME AVAILABLE                       00107000
ANALDEV  SAVE  (14,12),,*     SAVE REGISTERS                            00108000
         LR    R12,R15        SET A BASE                                00109000
         USING ANALDEV,R12    INFORM ASSEMBLER                          00110000
         IEFSAVER ,           LINK SAVE AREAS                           00111000
*                                                                       00112000
         L     R15,DEVMASKT+24  LOAD LENGTH OF TABLE                    00113000
         SRL   R15,8          ISOLATE THE LENGTH                        00114000
         SH    R15,=H'4'      LESS HEADER                               00115000
         ST    R15,MASKLEN    SAVE TABLE LENGTH                         00116000
         LR    R2,R15         COPY LENGTH OF DEVICE MASK TABLE          00117000
         SRA   R2,2           CONVERT TO WORDS                          00118000
         L     R5,ADDRMASK    ADDRESS OF MASK TABLE                     00119000
         LA    R14,4(,R5)     ADDRESS OF FIRST MASK ENTRY               00120000
         ST    R14,MASK#1     SAVE FIRST MASK ENTRY ADDRESS             00121000
         L     R1,ADDRNAME    ADDRESS OF DEVNAMET                       00122000
         CLC   0(2,R5),2(R1)  DO LENGTHS MATCH                          00123000
         BNE   MISMATCH       NO. GIVE ERROR                            00124000
         LA    R1,4(,R1)      FIRST ENTRY ADDRESS                       00125000
         ST    R1,NAME#1      SAVE ADDRESS                              00126000
         LH    R4,0(,R5)      NUMBER OF ENTRIES IN TABLE                00127000
         BCTR  R4,0           LESS ONE                                  00128000
         MH    R4,=H'12'      TWELVE BYTES PER ENTRY                    00129000
         LA    R1,0(R4,R1)    ADDRESS OF LAST ENTRY                     00130000
         ST    R1,NAMEEND     SAVE LAST ENTRY ADDRESS                   00131000
         LH    R4,2(,R5)      NUMBER OF ENTRIES AGAIN                   00132000
         SRDA  R2,32          SET FOR DIVIDE                            00133000
         DR    R2,R4          NUMBER OF WORDS PER ENTRY                 00134000
         SH    R3,=H'2'       MASK WORDS PER ENTRY                      00135000
         ST    R3,MASKWORD    SAVE FOR FUTURE USE                       00136000
         LR    R0,R15         GET LENGTH AGAIN                          00137000
         SRDA  R0,32          SET FOR DIVIDE                            00138000
         DR    R0,R4          BYTES PER ENTRY                           00139000
         ST    R1,MASKENTY    SAVE FOR POSTERITY                        00140000
         LA    R1,4(R15,R5)   END OF TABLE ADDRESS                      00141000
         S     R1,MASKENTY    LAST ENTRY ADDRESS                        00142000
         ST    R1,MASKEND     STASH FOR FUTURE USE                      00143000
         MVC   ALLDISK+8(4),4(R1)  GET 'ALL DISK' DEVTYPE               00144000
         CALL  GETMASK        GO DO GETMAIN FOR SKELETON MASK           00145000
*                                                                       00146000
         IEFRELSE ,           FREE UP SAVE AREA                         00147000
         RETURN (14,12),T,RC=0  GOBACK                                  00148000
*                                                                       00149000
MISMATCH MVI   LINE-1,C'0'    SET DOUBLE SPACE                          00150000
         MVC   LINE(L'MMATCH),MMATCH  MOVE MISMATCH MESSAGE TO LINE     00151000
         CALL  PUT            PUT OUT THE LINE                          00152000
         CALL  CLOSEUP        CLOSE ALL FILES                           00153000
         ABEND 5              QUIT QUICKLY                              00154000
         EJECT                                                          00155000
         ENTRY GETMASK        MAKE NAME AVAILABLE                       00156000
GETMASK  SAVE  (14,12),,*     SAVE REGISTERS                            00157000
         LR    R12,R15        SET A BASE                                00158000
         USING GETMASK,R12    INFORM ASSEMBLER                          00159000
         IEFSAVER ,           LINK SAVE AREAS                           00160000
*                                                                       00161000
         L     R0,MASKENTY    LENGTH OF MASK                            00162000
         L     R1,MADDR       ADDRESS OF SKELETON MASK                  00163000
         LTR   R1,R1          IS THERE ONE                              00164000
         BZ    GETMAIN        NO. FIRST TIME THROUGH                    00165000
         FREEMAIN R,LV=(0),A=(1)  FREE UP THE AREA                      00166000
*                                                                       00167000
GETMAIN  DS    0H                                                       00168000
         L     R0,MASKENTY    GET LENGTH OF ENTRY                       00169000
         GETMAIN R,LV=(0)     GET A SKELETON MASK                       00170000
         ST    R1,MADDR       SAVE ADDRESS OF SKELETON                  00171000
*                                                                       00172000
         IEFRELSE ,           FREE UP SAVE AREAS                        00173000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00174000
         EJECT                                                          00175000
         ENTRY PROCTABL       MAKE NAME AVAILABLE                       00176000
PROCTABL SAVE  (14,12),,*     SAVE REGISTERS                            00177000
         LR    R12,R15        SET BASE                                  00178000
         USING PROCTABL,R12   INFORM ASSEMBLER                          00179000
         IEFSAVER ,           LINK SAVE AREAS                           00180000
*                                                                       00181000
         LM    R7,R9,NAME#1   NAME TABLE INDEXING                       00182000
         LM    R3,R5,MASK#1   LOOP CONTROL                              00183000
PROCLOOP ST    R3,ADDRENTY    SAVE CURRENT DEVMASKT ENTRY               00184000
         ST    R7,ADDRNENT    SAVE CURRENT DEVNAMET ENTRY               00185000
         CALL  PROCENTY       PROCESS THE ENTRY                         00186000
         BXLE  R7,R8,*+8      BUMP TO NEXT DEVNAMET ENTRY               00187000
         LA    R7,ALLDISK     USE PSEUDO-ENTRY LAST TIME THROUGH        00188000
         BXLE  R3,R4,PROCLOOP PROCESS ALL THE ENTRIES                   00189000
*                                                                       00190000
         IEFRELSE ,           FREE UP SAVE AREA                         00191000
         RETURN (14,12),T,RC=0 BACK TO CALLER                           00192000
         EJECT                                                          00193000
         ENTRY ZAPDRVR        MAKE NAME AVAILABLE                       00194000
ZAPDRVR  SAVE  (14,12),,*     SAVE REGISTERS                            00195000
         LR    R12,R15        SET A BASE                                00196000
         USING ZAPDRVR,R12    INFORM ASSEMBLER                          00197000
         IEFSAVER ,           LINK SAVE AREAS                           00198000
*                                                                       00199000
         CALL  ZAPDRVR2       GO OPEN FILES                             00200000
         XC    UNITCNT,UNITCNT  CLEAR UNIT COUNT                        00201000
         L     R1,MASKENTY    GET LENGTH OF ENTRY                       00202000
         BCTR  R1,0           LESS ONE FOR EXECUTE                      00203000
         L     R2,MADDR       GET ADDRESS OF SKELETON MASK              00204000
         EX    R1,XC          CLEAR THE MASK                            00205000
         MVC   SAVECARD,CARD  SAVE THE ZAP CONTROL CARD                 00206000
         PUT   ZAPIN,SAVECARD-1  PUT OUT ZAP CARD AS COMMENT            00207000
         CALL  READCARD       GO READ A CARD                            00208000
         TM    SWITCH,EOF     DID WE GET EOF                            00209000
         BO    NOZAP          YES. ERROR                                00210000
         CLC   =C'UCB',CARD   IS IT A UCB CONTROL CARD                  00211000
         BNE   NOZAP          NO. ERROR                                 00212000
         MVC   LINE+20(L'CARD),CARD  COPY CARD TO OUTPUT LINE           00213000
         CALL  PUT            PUT OUT THE CARD                          00214000
*                                                                       00215000
SCANIT   CALL  SCANUCB        GO SCAN THE UCB CONTROL CARD              00216000
         B     *+4(R15)       CHECK RETURN CODE                         00217000
         B     *+8            ALL OK                                    00218000
         B     NOZAP          SIGNAL ERROR                              00219000
*                                                                       00220000
         PUT   ZAPIN,CARD-1   PUT OUT THE CARD AS ZAP COMMENT           00221000
         CALL  READCARD       GO READ ANOTHER CARD                      00222000
         TM    SWITCH,EOF     IS IT EOF                                 00223000
         BO    DOZAP          YES. GO PERFORM ZAP                       00224000
         CLC   =CL7'UCB',CARD IS IT A UCB CARD                          00225000
         BE    SCANIT         YES. GO SCAN THE UCB CARD                 00226000
         OI    SWITCH,REREAD  SET TO REREAD THE CARD                    00227000
*                                                                       00228000
DOZAP    CALL  ZAPDRVR3       DROP DOWN A LEVEL                         00229000
         CALL  LINKZAP        GO LINK TO SUPERZAP                       00230000
         B     DRVRBACK       BACK TO CALLER                            00231000
*                                                                       00232000
NOZAP    MVC   LINE-1(L'INVALID),INVALID  PUT MESSAGE IN LINE           00233000
         CALL  PUT            PRINT THE ERROR                           00234000
         OI    SWITCH,REREAD  SAY REREAD THE CARD                       00235000
*                                                                       00236000
DRVRBACK DS    0H                                                       00237000
         IEFRELSE ,           FREE UP SAVE AREA                         00238000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00239000
         EJECT                                                          00240000
         ENTRY ZAPDRVR2       MAKE NAME AVAILABLE                       00241000
ZAPDRVR2 SAVE  (14,12),,*     SAVE REGISTERS                            00242000
         LR    R12,R15        SET A BASE                                00243000
         USING ZAPDRVR2,R12   INFORM ASSEMBLER                          00244000
         IEFSAVER ,           LINK SAVE AREAS                           00245000
*                                                                       00246000
         OPEN  (ZAPIN,OUTPUT) OPEN SUPERZAP SYSIN FILE                  00247000
         LA    R1,ZAPIN       ADDRESS THE DCB                           00248000
         USING IHADCB,R1      INFORM ASSEMBLER                          00249000
         TM    DCBOFLGS,DCBOFOPN  DID DCB OPEN                          00250000
         BZ    BADZAPIN       NO. MISSING DD CARD                       00251000
         DROP  R1             NO LONGER NEEDED                          00252000
         PUT   ZAPIN,DUMPMASK CREATE A DUMP CONTROL CARD                00253000
 PUT     ZAPIN,NAMEMASK       CREATE A NAME CONTROL CARD                00254000
*                                                                       00255000
         IEFRELSE ,           FREE UP SAVE AREA                         00256000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00257000
*                                                                       00258000
BADZAPIN MVC   LINE-1(L'MISSIN),MISSIN MISSING DD CARD MESSAGE          00259000
         CALL  PUT            PRINT THE MESSAGE                         00260000
         CALL  CLOSEUP        CLOSE ALL FILES                           00261000
         ABEND 6              QUIT QUICKLY                              00262000
*                                                                       00263000
BADZAP   MVC   LINE-1(L'NOTCALLD),NOTCALLD MOVE MESSAGE                 00264000
         CALL  PUT            PRINT THE LINE                            00265000
         CALL  CLOSEUP        CLOSE EVERYTHING                          00266000
         ABEND 6              QUIT QUICKLY                              00267000
         EJECT                                                          00268000
         ENTRY ZAPDRVR3       MAKE NAME AVAILABLE                       00269000
ZAPDRVR3 SAVE  (14,12),,*     SAVE REGISTERS                            00270000
         LR    R12,R15        SET BASE                                  00271000
         USING ZAPDRVR3,R12   INFORM ASSEMBLER                          00272000
         IEFSAVER ,           LINK SAVE AREAS                           00273000
*                                                                       00274000
         LM    R3,R5,=A(SAVECARD+7,8,SAVECARD+64)  LOOP CONTROL         00275000
DRVR3BGN CLC   =CL8' ',0(R3)  IS IT THE END OF THE CARD YET             00276000
         BE    DRVR3BAK       YES. GO QUIT                              00277000
         ST    R3,ADDFIELD    SAVE THE ADDRESS OF NAME TO CHANGE        00278000
         MVC   WTG,=V(ZAPGEN) SAY GENERATE ZAP CARDS                    00279000
         CALL  FINDENTY       GO PROCESS THIS ENTRY                     00280000
         BXLE  R3,R4,DRVR3BGN LOOP TILL END OF CARD                     00281000
*                                                                       00282000
DRVR3BAK DS    0H                                                       00283000
         PUT   ZAPIN,DUMPMASK DUMP AFTER ZAP                            00284000
         CLOSE ZAPIN          CLOSE ZAP SYSIN FILE                      00285000
         FREEPOOL ZAPIN       CLEAN UP BUFFER SITUATION                 00286000
         IEFRELSE ,           FREE UP SAVE AREA                         00287000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00288000
         EJECT                                                          00289000
         ENTRY ZAPGEN         MAKE NAME AVAILABLE                       00290000
ZAPGEN   SAVE  (14,12),,*     SAVE REGISTERS                            00291000
         LR    R12,R15        SET BASE                                  00292000
         USING ZAPGEN,R12     INFORM ASSEMBLER                          00293000
         IEFSAVER ,           LINK SAVE AREAS                           00294000
*                                                                       00295000
         MVC   NEWMASK,ADDRENTY  OLD ENTRY IS MASK FOR VER              00296000
         MVC   ZAPVERB,=C'VER'  GENERATE A VER CARD                     00297000
         CALL  ZAPVER         GENERATE THE SUPERZAP CARDS               00298000
         MVC   NEWMASK,MADDR  USE NEW MASK FOR REP CARDS                00299000
         MVC   ZAPVERB,=C'REP'  GENERATE A REP THIS TIME                00300000
         CALL  ZAPVER         GENERATE THE REP CARDS                    00301000
*                                                                       00302000
         IEFRELSE ,           FREE UP SAVE AREA                         00303000
         RETURN (14,12),T,RC=0  BACK TO USER                            00304000
         EJECT                                                          00305000
         ENTRY ZAPVER         MAKE NAME AVAILABLE                       00306000
ZAPVER   SAVE  (14,12),,*     SAVE REGISTERS                            00307000
         LR    R12,R15        SET A BASE                                00308000
         USING ZAPVER,R12     INFORM ASSEMBLER                          00309000
         IEFSAVER ,           LINK SAVE AREAS                           00310000
*                                                                       00311000
         L     R3,ADDRENTY    ADDRESS OF THIS MASK ENTRY                00312000
         S     R3,ADDRMASK    CALCULATE DISPLACEMENT                    00313000
         L     R5,NEWMASK     ADDRESS OF MASK TO USE                    00314000
         L     R6,MASKWORD    MASK WORDS PER ENTRY                      00315000
         LA    R6,2(,R6)      WORDS PER ENTRY                           00316000
*                                                                       00317000
VERLOOP  MVC   ZAPCARD,ZAPCARD-1  CLEAR THE CARD TO BUILD               00318000
         ST    R3,TEMP        STORE DISPLACEMENT FOR CONVERSION         00319000
         UNPK  H5,TEMP+2(3)   CONVERT TO HEX                            00320000
         TR    H5(4),HEXTABLE ...                                       00321000
         MVC   ZAPCARD+1(3),ZAPVERB  SAY VER OR REP                     00322000
         MVC   ZAPCARD+5(4),H5  MOVE IN DISPLACEMENT                    00323000
         UNPK  H9,0(5,R5)     CONVERT TO HEX                            00324000
         TR    H9(8),HEXTABLE ...                                       00325000
         MVC   ZAPCARD+11(8),H9  MOVE MASK TO CARD                      00326000
         PUT   ZAPIN,ZAPCARD  PUT OUT THE CARD                          00327000
         LA    R3,4(,R3)      BUMP DISPLACEMENT                         00328000
         LA    R5,4(,R5)      BUMP TO NEXT MASK WORD                    00329000
         BCT   R6,VERLOOP     PUT OUT THE WHOLE MASK                    00330000
*                                                                       00331000
         IEFRELSE ,           FREE UP SAVE AREA                         00332000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00333000
         EJECT                                                          00334000
         ENTRY LINKZAP        MAKE NAME AVAILABLE                       00335000
LINKZAP  SAVE  (14,12),,*     SAVE REGISTERS                            00336000
         LR    R12,R15        SAVE REGISTERS                            00337000
         USING LINKZAP,R12    INFORM ASSEMBLER                          00338000
         IEFSAVER ,           LINK SAVE AREAS                           00339000
*                                                                       00340000
         LINK  EP=SUPERZAP    INVOKE SUPERZAP                           00341000
         IEFRELSE ,           FREE UP SAVE AREA                         00342000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00343000
         EJECT                                                          00344000
         ENTRY FINDENTY       MAKE NAME AVAILABLE                       00345000
FINDENTY SAVE  (14,12),,*     SAVE REGISTERS                            00346000
         LR    R12,R15        SET A BASE                                00347000
         USING FINDENTY,R12   INFORM ASSEMBLER                          00348000
         IEFSAVER ,           LINK SAVE AREAS                           00349000
*                                                                       00350000
         L     R2,ADDFIELD    CURRENT INPUT FIELD                       00351000
*                                                                       00352000
         LM    R7,R9,NAME#1   DEVNAMET CONTROL REGISTERS                00353000
         LM    R3,R5,MASK#1   DEVMASKT CONTROL REGISTERS                00354000
FINDLOOP CLC   0(8,R2),0(R7)  IS THIS THE ENTRY                         00355000
         BNE   FINDBXLE       NO. GO TRY NEXT ENTRY                     00356000
         ST    R3,ADDRENTY    STORE MASK ENTRY ADDRESS                  00357000
         ST    R7,ADDRNENT    STORE NAME ENTRY ADDRESS                  00358000
         L     R2,MADDR       LOAD SKELETON MASK ADDRESS                00359000
         MVC   4(4,R2),4(R3)  COPY DEVTYPE TO SKELETON                  00360000
         L     R15,WTG        LOAD ADDRESS TO CALL                      00361000
         CALL  (15)           CALL PROCESSING ROUTINE                   00362000
         B     FINDBACK       ALL DONE THIS FIELD                       00363000
FINDBXLE BXLE  R7,R8,*+8      BUMP TO NEXT NAME TABLE ENTRY             00364000
         LA    R7,ALLDISK     POINT TO PSEUDO-ENTRY LAST TIME THROUGH   00365000
         BXLE  R3,R4,FINDLOOP PROCESS ALL MASK ENTRIES                  00366000
*                                                                       00367000
         MVC   LINE-1(L'MISSFLD),MISSFLD  PUT IN MISSING NAME MESSAGE   00368000
         MVC   LINE(8),0(R2)  MOVE DEVNAME TO MESSAGE                   00369000
         CALL  PUT            PUT OUT THE MESSAGE                       00370000
*                                                                       00371000
FINDBACK DS    0H                                                       00372000
         IEFRELSE ,           FREE UP SAVE AREAS                        00373000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00374000
         EJECT                                                          00375000
         ENTRY PROCENTY       MAKE NAME AVAILABLE                       00376000
PROCENTY SAVE  (14,12),,*     SAVE REGISTERS                            00377000
         LR    R12,R15        SET A BASE                                00378000
         USING PROCENTY,R12   INFORM ASSEMBLER                          00379000
         IEFSAVER ,           LINK SAVE AREAS                           00380000
*                                                                       00381000
         CALL  ENTHEAD        PUT OUT THE HEADER FOR THIS ENTRY         00382000
         XC    UNITCNT,UNITCNT  CLEAR UNIT COUNTER                      00383000
         MVC   LINECTL,=A(LINE+2)  REFRESH PRINT LINE CONTROL REGISTER  00384000
         L     R3,ADDRENTY    GET ADDRESS OF CURRENT ENTRY              00385000
         L     R4,CVTPTR      GET CVT ADDRESS                           00386000
         USING CVTDSECT,R4    INFORM ASSEMBLER                          00387000
         L     R4,CVTILK2     ADDRESS OF UCB ADDRESSES                  00388000
         DROP R4              CLEAN UP                                  00389000
         LA    R2,32          32 BITS PER WORD                          00390000
         LA    R6,8(,R3)      ADDRESS OF FIRST MASK WORD                00391000
         L     R8,0(,R6)      FIRST MASK WORD                           00392000
UNITLOOP LH    R7,0(,R4)      LOAD UCB ADDRESS                          00393000
         LTR   R7,R7          IS IT END OF UCB TABLE                    00394000
         BM    UNITDONE       YES. ALL DONE                             00395000
         LTR   R8,R8          IS THIS MASK BIT ON                       00396000
         BNM   NOUNIT         NO                                        00397000
         LTR   R7,R7          IS THIS VALID UCB ADDRESS                 00398000
         BNZ   *+8            OK                                        00399000
         LA    R7,BADUCB      LOAD PSEUDO-UCB ADDRESS                   00400000
         ST    R7,CURNTUCB    CURRENT UCB ADDRESS                       00401000
         CALL  PRTUNIT        PRINT OUT THE INFO                        00402000
NOUNIT   DS    0H                                                       00403000
         SLL   R8,1           SHIFT IN NEXT MASK BIT                    00404000
         BCT   R2,SAMEWORD    DO ALL 32 BITS                            00405000
         LA    R2,32          RESET COUNTER                             00406000
         LA    R6,4(,R6)      POINT TO NEXT WORD                        00407000
         L     R8,0(,R6)      GET NEXT WORD                             00408000
SAMEWORD LA    R4,2(,R4)      NEXT UCB POINTER                          00409000
         B     UNITLOOP       GO THROUGH ENTIRE UCB TABLE               00410000
*                                                                       00411000
UNITDONE DS    0H                                                       00412000
         CLC   LINE,LINE-1    IS LINE BLANK                             00413000
         BE    NOPUT          YES. DO NOT PUT IT OUT                    00414000
         CALL  PUT            FLUSH LAST LINE                           00415000
NOPUT    DS    0H                                                       00416000
         IEFRELSE ,           FREE SAVE AREA                            00417000
         RETURN (14,12),T,RC=0  GOBACK                                  00418000
         EJECT                                                          00419000
         ENTRY ENTHEAD        MAKE NAME AVAILABLE                       00420000
ENTHEAD  SAVE  (14,12),,*     SAVE REGISTERS                            00421000
         LR    R12,R15        SET BASE                                  00422000
         USING ENTHEAD,R12    INFORM ASSEMBLER                          00423000
         IEFSAVER ,           LINK SAVE AREAS                           00424000
*                                                                       00425000
         CP    LINECNT,=P'52' ARE WE TOO CLOSE TO BOTTOM OF PAGE        00426000
         BNH   *+10           NO.                                       00427000
         ZAP   LINECNT,=P'58' YES. FORCE OVERFLOW                       00428000
*                                                                       00429000
         L     R3,ADDRENTY    ADDRESS OF CURRENT MASK ENTRY             00430000
         L     R4,ADDRNENT    ADDRESS OF CURRENT NAME ENTRY             00431000
         MVC   LINE(8),0(R4)  MOVE NAME TO PRINT LINE                   00432000
         UNPK  LINE+10(9),4(5,R3)  MOVE DEVTYPE TO PRINT LINE           00433000
         TR    LINE+10(8),HEXTABLE  COMPLETE HEX CONVERSION             00434000
         MVI   LINE+18,C' '   BLANK GARBAGE BYTE                        00435000
         L     R0,0(,R3)      PICK UP NUMBER OF UCB'S                   00436000
         CVD   R0,DOUBLE      CONVERT TO DECIMAL                        00437000
         MVC   LINE+20(3),=X'202120'  EDIT MASK                         00438000
         ED    LINE+19(4),DOUBLE+6  MOVE NUMBER TO LINE                 00439000
         MVC   LINE+24(5),=C'UCB''S'  MOVE LABEL TO LINE                00440000
         CH    R0,=H'1'       IS THERE ONLY ONE UCB                     00441000
         BNE   *+10           NO                                        00442000
         MVC   LINE+27(2),=CL2' ' YES. MAKE SINGULAR                    00443000
         MVI   LINE-1,C'0'    DOUBLE SPACE THE HEADER                   00444000
         CALL  PUT            PUT OUT THE HEADER                        00445000
         CALL  PUT            PUT OUT A BLANK LINE                      00446000
*                                                                       00447000
         IEFRELSE ,           FREE UP SAVE AREA                         00448000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00449000
         EJECT                                                          00450000
         ENTRY TURNON         MAKE NAME AVAILABLE                       00451000
TURNON   SAVE  (14,12),,*     SAVE REGISTERS                            00452000
         LR    R12,R15        SET A BASE                                00453000
         USING TURNON,R12     INFORM ASSEMBLER                          00454000
         IEFSAVER ,           LINK SAVE AREAS                           00455000
*                                                                       00456000
         L     R1,CVTPTR      GET CVT ADDRESS                           00457000
         USING CVTDSECT,R1    ADDRESS CVT                               00458000
         L     R1,CVTILK2     UCB LOOKUP TABLE ADDRESS                  00459000
         DROP  R1             NO LONGER AVAILABLE                       00460000
*                                                                       00461000
         SR    R6,R6          UCB COUNTER                               00462000
         L     R3,ADDRUCB     ADDRESS OF UCB VALUE TO LOCATE            00463000
*                                                                       00464000
TURNLOOP LH    R4,0(,R1)      NEXT UCB ADDRESS                          00465000
         LTR   R4,R4          TEST UCB ADDRESS                          00466000
         BM    TURNBAD        END OF TABLE WITHOUT A HIT                00467000
         BZ    TURNLEND       HOLE IN THE TABLE (VALID)                 00468000
         USING UCBDSECT,R4    ADDRESS THE UCB                           00469000
         CLC   UCBNAME,0(R3)  IS THIS THE UCB                           00470000
         DROP  R4             CLEAN UP                                  00471000
         BNE   TURNLEND       UCB NOT FOUND. GO TRY NEXT ONE            00472000
         SRDA  R6,32          SET UCB INDEX FOR DIVIDE                  00473000
         D     R6,=F'8'       CONVERT TO BITS AND BYTES                 00474000
         L     R2,MADDR       GET SKELETON MASK ADDRESS                 00475000
         LA    R2,8(R7,R2)    ADDRESS OF BYTE WITHIN MASK               00476000
         IC    R6,BITTABLE(R6)  CHOOSE THE CORRECT BIT                  00477000
         EX    R6,TM          IS THIS UCB ALREADY ON                    00478000
         BO    TURNDUP        YES. GIVE ERROR MESSAGE                   00479000
         EX    R6,OI          TURN ON THE BIT                           00480000
         L     R15,UNITCNT    GET THE UNIT COUNT                        00481000
         LA    R15,1(,R15)    BUMP IT ONE                               00482000
         ST    R15,UNITCNT    PUT IT BACK                               00483000
         L     R2,MADDR       GET SKELETON MASK ADDRESS                 00484000
         ST    R15,0(,R2)     SET UNIT COUNT IN SKELETON                00485000
*                                                                       00486000
         IEFRELSE ,           FREE UP SAVE AREA                         00487000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00488000
*                                                                       00489000
TURNLEND LA    R1,2(,R1)      NEXT UCB TABLE ENTRY                      00490000
         LA    R6,1(,R6)      ONE MORE UCB TO COUNT                     00491000
         B     TURNLOOP       GO AROUND THE LOOP                        00492000
*                                                                       00493000
TURNBAD  MVC   LINE-1(L'NOUCB),NOUCB  PUT ERROR MESSSAGE IN LINE        00494000
TURNMSG  MVC   LINE(3),0(R3)  PUT UCB NAME INTO MESSAGE                 00495000
         CALL  PUT            PUT OUT THE ERROR MESSAGE                 00496000
         IEFRELSE ,           FREE UP SAVE AREA                         00497000
         RETURN (14,12),T,RC=4  RETURN BAD UCB                          00498000
*                                                                       00499000
TURNDUP  MVC   LINE-1(L'DUPUCB),DUPUCB  MOVE MESSAGE TO LINE            00500000
         B     TURNMSG        GO PUT IT OUT                             00501000
         EJECT                                                          00502000
         ENTRY SCANUCB        MAKE NAME AVAILABLE                       00503000
SCANUCB  SAVE  (14,12),,*     SAVE REGISTERS                            00504000
         LR    R12,15         SET A BASE                                00505000
         USING SCANUCB,R12    INFORM ASSEMBLER                          00506000
         IEFSAVER ,           LINK SAVE AREAS                           00507000
*                                                                       00508000
         LM    R3,R5,=A(CARD+7,8,CARD+63)  SCAN CONTROL                 00509000
*                                                                       00510000
SCANLOOP CLC   =CL8' ',0(R3)  IS IT END OF SCAN YET                     00511000
         BE    SCANBACK       YES                                       00512000
         ST    R3,ADDRUCB     SAVE UCB ADDRESS                          00513000
         CLI   3(R3),C'-'     IS IT A RANGE OF UCB'S                    00514000
         BE    RANGE          YES. GO PROCESS THE RANGE                 00515000
         CALL  TURNON         TURN ON THE BIT FOR THIS UCB              00516000
         B     *+4(R15)       TEST RETURN CODE                          00517000
         B     SCANBXLE       ALL OK                                    00518000
         B     SCANERR        GIVE ERROR MESSAGE                        00519000
*                                                                       00520000
RANGE    CALL  UCBRANGE       GO PROCESS THE UCB RANGE                  00521000
         B     *+4(R15)       TEST RETURN CODE                          00522000
         B     SCANBXLE       ALL OK                                    00523000
         B     SCANERR        GIVE ERROR MESSAGE                        00524000
*                                                                       00525000
SCANBXLE BXLE  R3,R4,SCANLOOP  CONTINUE ACROSS THE CARD                 00526000
SCANBACK IEFRELSE ,           FREE UP SAVE AREA                         00527000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00528000
*                                                                       00529000
SCANERR  IEFRELSE ,           FREE UP SAVE AREA                         00530000
         RETURN (14,12),T,RC=4  GIVE ERROR RETURN                       00531000
         EJECT                                                          00532000
         ENTRY UCBRANGE       MAKE NAME AVAILABLE                       00533000
UCBRANGE SAVE  (14,12),,*     SAVE REGISTERS                            00534000
         LR    R12,R15        SET A BASE                                00535000
         USING UCBRANGE,R12   INFORM ASSEMBLER                          00536000
         IEFSAVER ,           LINK SAVE AREAS                           00537000
*                                                                       00538000
         L     R3,ADDRUCB     GET ADDRESS OF UCB FIELD                  00539000
         TRT   0(3,R3),HEXTEST  IS IT VALID HEX CODE                    00540000
         BNZ   RANGEBAD       NO. GIVE ERROR                            00541000
         TRT   4(3,R3),HEXTEST  CHECK END OF RANGE                      00542000
         BNZ   RANGEBAD       BAD HEX CODE                              00543000
         MVC   HEXW1,0(R3)    COPY BEGINNING OF RANGE                   00544000
         MVC   HEXW2,4(R3)    COPY END OF RANGE                         00545000
         TR    HEXW1(6),HEXTRAN  BEGIN CONVERSION TO BINARY             00546000
         PACK  HEXUCB(3),HEXW1(4)  COMPLETE CONVERSION                  00547000
         PACK  HEXUCB+2(3),HEXW2(4) ...                                 00548000
         CLC   HEXUCB(2),HEXUCB+2  IS FIRST UCB GREATER THAN SECOND     00549000
         BH    RANGEBAD       YES. ERROR                                00550000
RANGEL   UNPK  RANGEUCB(4),HEXUCB(3)  UCB BACK TO CHARACTER             00551000
         TR    RANGEUCB(3),HEXTABLE  ...                                00552000
         LA    R0,RANGEUCB    NEW UCB ADDRESS                           00553000
         ST    R0,ADDRUCB     PASS TO BIT TURNON ROUTINE                00554000
         CALL  TURNON         TURN ON THE BIT                           00555000
         B     *+4(R15)       TEST RETURN CODE                          00556000
         B     *+8            ALL OK                                    00557000
         B     RANGEBAD       SAY BAD RANGE                             00558000
         LH    R1,HEXUCB      GET UCB ADDRESS                           00559000
         LA    R1,1(,R1)      BUMP IT                                   00560000
         STH   R1,HEXUCB      PUT IT BACK                               00561000
         CH    R1,HEXUCB+2    ARE WE DONE                               00562000
         BNH   RANGEL         NO. GO AROUND AGAIN                       00563000
         IEFRELSE ,           FREE UP SAVE AREA                         00564000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00565000
*                                                                       00566000
RANGEBAD MVC   LINE-1(L'RANGEMES),RANGEMES MOVE ERROR MESSAGE           00567000
         CALL  PUT            PRINT ERROR MESSAGE                       00568000
         IEFRELSE ,           FREE UP SAVE AREA                         00569000
         RETURN (14,12),T,RC=4  GIVE ERROR RETURN                       00570000
         EJECT                                                          00571000
         ENTRY PRTUNIT        MAKE NAME AVAILABLE                       00572000
PRTUNIT  SAVE  (14,12),,*     SAVE REGISTERS                            00573000
         LR    R12,R15        SET BASE                                  00574000
         USING PRTUNIT,R12    INFORM ASSEMBLER                          00575000
         IEFSAVER ,           LINK SAVE AREAS                           00576000
*                                                                       00577000
         L     R2,CURNTUCB    LOAD UCB ADDRESS                          00578000
         USING UCBDSECT,R2    INFORM ASSEMBER                           00579000
         LM    R3,R5,LINECTL  LOAD LINE CONTROL REGISTERS               00580000
         MVC   0(3,R3),UCBNAME MOVE IN UCB NAME                         00581000
         BXLE  R3,R4,PRTBACK  BUMP TO NEXT SLOT                         00582000
         CALL  PUT            LINE IS FULL. PUT IT                      00583000
         LA    R3,LINE+2      RESET TO BEGINNING OF LINE                00584000
PRTBACK  ST    R3,LINECTL     SAVE CONTROL REGISTER FOR NEXT ENTRY      00585000
*                                                                       00586000
         IEFRELSE ,           FREE SAVE AREA                            00587000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00588000
         DROP  R2             CLEAN UP                                  00589000
         EJECT                                                          00590000
         ENTRY PUTOPEN        MAKE NAME AVAILABLE                       00591000
PUTOPEN  SAVE  (14,12),,*     SAVE REGISTERS                            00592000
         LR    R12,R15        SET BASE                                  00593000
         USING PUTOPEN,R12    INFORM ASSEMBLER                          00594000
         IEFSAVER ,           LINK SAVE AREAS                           00595000
*                                                                       00596000
         OPEN  (SYSPRINT,OUTPUT)  OPEN THE OUTPUT FILE                  00597000
         USING IHADCB,R1      ADDRESS THE DCB                           00598000
         LA    R1,SYSPRINT    SET THE BASE                              00599000
         TM    DCBOFLGS,DCBOFOPN  DID DCB OPEN                          00600000
         BZ    PUTABEND       NO. GO ABEND                              00601000
         TIME  DEC            GET TIME AND DATE                         00602000
         STM   R0,R1,TIME     SAVE TIME AND DATE                        00603000
         ED    LINETIME,TIME  PUT TIME INTO OUTPUT LINE                 00604000
         ED    LINEDATE,DATE+1  PUT DATE INTO OUTPUT LINE               00605000
*                                                                       00606000
         IEFRELSE ,           FREE SAVE AREA                            00607000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00608000
*                                                                       00609000
PUTABEND ABEND 1              MISSING SYSPRINT DD CARD                  00610000
         EJECT                                                          00611000
PUTEXIT  DS    0H                                                       00612000
         USING PUTEXIT,R15    BASE FOR EXIT                             00613000
         STM   R2,R3,SAVET    SAVE WORK REGISTERS                       00614000
         LH    R2,DCBBLKSI    GET BLKSIZE                               00615000
         LTR   R2,R2          WAS ONE SPECIFIED                         00616000
         BNZ   *+8            YES                                       00617000
         LH    R2,DCBLRECL    USE LRECL AS BLKSIZE                      00618000
         SRDA  R2,32          SET FOR DIVIDE                            00619000
         LH    R0,DCBLRECL    GET LRECL                                 00620000
         DR    R2,R0          BLOCKING FACTOR                           00621000
         LTR   R2,R2          IS BLKSIZE EVEN MULTIPLE OF LRECL         00622000
         STH   R0,DCBBLKSI    USE LRECL IF NOT                          00623000
         BNZ   EXITBACK       NOT EVEN MULTIPLE                         00624000
         LTR   R3,R3          IS BLKSIZE LESS THAN LRECL                00625000
         BZ    EXITBACK       YES. USE LRECL                            00626000
         MR    R2,R0          CALCULATE BLOCKSIZE                       00627000
         STH   R3,DCBBLKSI    PUT BLKSIZE BACK                          00628000
EXITBACK LM    R2,R3,SAVET    RESTORE WORK REGISTERS                    00629000
         BR    R14            BACK TO OPEN                              00630000
*                                                                       00631000
SAVET    DS    2A                                                       00632000
         DROP  R1,R15         CLEAN UP                                  00633000
         EJECT                                                          00634000
         ENTRY PUT            MAKE NAME AVAILABLE                       00635000
PUT      SAVE  (14,12),,*     SAVE REGISTERS                            00636000
         LR    R12,R15        SET BASE                                  00637000
         USING PUT,R12        INFORM ASSEMBLER                          00638000
         IEFSAVER ,           LINK SAVE AREAS                           00639000
*                                                                       00640000
         CLI   LINE-1,C'0'    IS IT DOUBLE SPACE                        00641000
         BNE   *+10           NO                                        00642000
         AP    LINECNT,=P'1'  YES. COMPENSATE FOR EXTRA LINE            00643000
         AP    LINECNT,=P'1'  ADD ONE TO LINE COUNTER                   00644000
         CP    LINECNT,=P'58' COMPARE TO LINE LIMIT                     00645000
         BNH   SAMEPAGE       STAY ON SAME PAGE                         00646000
         AP    PAGECNT,=P'1'                                            00647000
         MVC   LINEPAGE,=X'40202120'  MOVE IN EDIT MASK                 00648000
         ED    LINEPAGE,PAGECNT  MOVE PAGE COUNT TO OUTPUT LINE         00649000
         PUT   SYSPRINT,HEADER-1  PUT OUT THE HEADER                    00650000
         MVI   LINE-1,C'0'    DOUBLE SPACE AFTER HEADER                 00651000
         ZAP   LINECNT,=P'3'  RESET LINE COUNTER                        00652000
SAMEPAGE PUT   SYSPRINT,LINE-1  PUT OUT THE LINE                        00653000
         MVI   LINE-1,C' '    SINGLE SPACE THE NEXT LINE                00654000
         MVC   LINE,LINE-1    LEAVE LINE BLANK                          00655000
*                                                                       00656000
         IEFRELSE ,           FREE UP SAVE AREA                         00657000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00658000
         EJECT                                                          00659000
         ENTRY READCARD       MAKE NAME AVAILABLE                       00660000
READCARD SAVE  (14,12),,*     SAVE REGISTERS                            00661000
         LR    R12,R15        SET BASE                                  00662000
         USING READCARD,R12   INFORM ASSEMBLER                          00663000
         IEFSAVER ,           CHAIN SAVE AREAS                          00664000
*                                                                       00665000
         LA    R2,SYSIN       ADDRESS DCB                               00666000
         USING IHADCB,R2      INFORM ASSEMBLER                          00667000
         TM    SWITCH,PENDEOF+EOF  SHOULD WE PRESENT EOF                00668000
         BNZ   EODAD2         BY ALL MEANS                              00669000
         TM    SWITCH,REREAD  SHOULD WE REREAD CARD                     00670000
         BO    REREADIT       YES. GO REREAD IT                         00671000
         TM    DCBOFLGS,DCBOFOPN  IS DCB OPEN                           00672000
         BO    ISSUEGET       YES. GET A CARD                           00673000
         OPEN  SYSIN          OPEN UP SYSIN                             00674000
         TM    DCBOFLGS,DCBOFOPN  DID IT OPEN                           00675000
         BZ    EODAD1         NO. SIMULATE IMMEDIATE EOF                00676000
ISSUEGET GET   SYSIN,CARD     GET A CARD                                00677000
         MVC   DCBEODAD+1(3),=AL3(EODAD2)  SET FOR SECOND TIME ET. AL.  00678000
         B     GETBACK        RETURN TO CALLER                          00679000
REREADIT NI    SWITCH,255-REREAD  TURN OFF REREAD                       00680000
         B     GETBACK        BACK TO CALLER                            00681000
EODAD1   MVC   CARD,=CL80'LIST'  SIMULATE LIST CONTROL CARD             00682000
         OI    SWITCH,PENDEOF LEAVE EOF PENDING                         00683000
         B     GETBACK        RETURN TO CALLER                          00684000
EODAD2   NI    SWITCH,255-PENDEOF  NO LONGER PENDING EOF                00685000
         OI    SWITCH,EOF     ... BUT A REAL ONE                        00686000
*                                                                       00687000
GETBACK  DS    0H                                                       00688000
         IEFRELSE ,           FREE UP SAVE AREA                         00689000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00690000
         DROP  R2                                                       00691000
         EJECT                                                          00692000
         ENTRY PROCCARD       MAKE NAME AVAILABLE                       00693000
PROCCARD SAVE  (14,12),,*     SAVE REGISTERS                            00694000
         LR    R12,R15        SET A BASE                                00695000
         USING PROCCARD,R12   INFORM ASSEMBLER                          00696000
         IEFSAVER ,           LINK SAVE AREAS                           00697000
*                                                                       00698000
         CLC   =CL7'EJECT',CARD  IS IT AN EJECT CARD                    00699000
         BNE   PRINTIT        NO. GO PRINT IT                           00700000
         ZAP   LINECNT,=P'58' FORCE NEW PAGE                            00701000
         B     CARDBACK       ...AND RETURN                             00702000
*                                                                       00703000
PRINTIT  DS    0H                                                       00704000
         MVC   LINE+20(L'CARD),CARD  MOVE CARD TO OUTPUT LINE           00705000
         MVI   LINE-1,C'0'    FORCE DOUBLE SPACE                        00706000
         CALL  PUT            LIST THE CONTROL CARD                     00707000
*                                                                       00708000
         CLC   =CL7'LIST',CARD  IS IT A LIST CONTROL CARD               00709000
         BNE   TESTZAP        NO. GO SEE IF ITS IS A ZAP CARD           00710000
         CLC   =CL8' ',CARD+7 IS IT A LISTALL FUNCTION                  00711000
         BNE   LISTSPEC       NO                                        00712000
LISTALL  CALL  PROCTABL       GO LIST WHOLE TABLE                       00713000
         B     CARDBACK       BACK TO CALLER                            00714000
LISTSPEC CALL  SPECLIST       LIST ONLY REQUESTED ENTRIES               00715000
         B     CARDBACK       ... AND RETURN                            00716000
*                                                                       00717000
TESTZAP  DS    0H                                                       00718000
         CLC   =CL7'ZAP',CARD IS IT A ZAP CONTROL CARD                  00719000
         BNE   BADCARD        NO. MUST BE A BAD CARD                    00720000
         CALL  ZAPDRVR        CALL ZAP DRIVER ROUTINE                   00721000
         B     CARDBACK       GO RETURN                                 00722000
*                                                                       00723000
BADCARD  MVC   LINE-1(L'BADMSG),BADMSG  FILL IN ERROR MESSAGE           00724000
         CALL  PUT            PUT OUT THE MESSAGE                       00725000
*                                                                       00726000
CARDBACK DS    0H                                                       00727000
         IEFRELSE ,           FREE UP SAVE AREA                         00728000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00729000
         EJECT                                                          00730000
         ENTRY CLOSEUP        MAKE NAME AVAILABLE                       00731000
CLOSEUP  SAVE  (14,12),,*     SAVE REGISTERS                            00732000
         LR    R12,R15        SET A BASE                                00733000
         USING CLOSEUP,R12    INFORM ASSEMBER                           00734000
         IEFSAVER ,           LINK SAVE AREAS                           00735000
*                                                                       00736000
         CLOSE (SYSPRINT,,SYSIN,,ZAPLIB)  CLOSE ALL FILES               00737000
         USING IHADCB,R1      ADDRESS DCB                               00738000
         LA    R1,SYSPRINT    ADDRESS SYSPRINT                          00739000
         TM    DCBBUFCB+3,1   ARE BUFFERS FREE                          00740000
         BO    FREESYSN       YES. GO FREE SYSIN                        00741000
         FREEPOOL SYSPRINT    FREE THE BUFFERS                          00742000
FREESYSN LA    R1,SYSIN       ADDRESS SYSIN                             00743000
         TM    DCBBUFCB+3,1   ARE BUFFERS FREE                          00744000
         BO    FREELM         YES. GO DELETE DEVICE TABLES              00745000
         FREEPOOL SYSIN       FREE SYSIN BUFFERS                        00746000
FREELM   DELETE DE=DEVNAMET   DELETE DEVICE NAME TABLE                  00747000
         DELETE DE=DEVMASKT   DELETE DEVICE MASK TABLE                  00748000
*                                                                       00749000
         IEFRELSE ,           FREE UP SAVE AREAS                        00750000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00751000
         DROP  R1                                                       00752000
         EJECT                                                          00753000
         ENTRY SPECLIST       MAKE NAME AVAILABLE                       00754000
SPECLIST SAVE  (14,12),,*     SAVE REGISTERS                            00755000
         LR    R12,R15        SET A BASE                                00756000
         USING SPECLIST,R12   INFORM ASSEMBLER                          00757000
         IEFSAVER ,           LINK SAVE AREAS                           00758000
*                                                                       00759000
         LM    R3,R5,=A(CARD+7,8,CARD+63)  LOOP CONTROL                 00760000
SPECBGN  CLC   =CL8' ',0(R3)  IS FIELD BLANK                            00761000
         BE    SPECBACK       YES. QUIT                                 00762000
         ST    R3,ADDFIELD    SAVE ADDRESS OF FIELD                     00763000
         MVC   WTG,=A(PROCENTY)  SET BRANCH TO LIST ROUTINE             00764000
         CALL  FINDENTY       FIND ENTRY FOR THIS FIELD                 00765000
*                                                                       00766000
SPECLOOP BXLE  R3,R4,SPECBGN  SEARCH ALL FIELDS                         00767000
*                                                                       00768000
SPECBACK DS    0H                                                       00769000
         IEFRELSE ,           FREE UP SAVE AREA                         00770000
         RETURN (14,12),T,RC=0  BACK TO CALLER                          00771000
         TITLE 'DEVICE NAME TABLE FORMATTER - DSECTS'                   00772000
         DCBD  DSORG=PS,DEVD=(DA,TA)                                    00773000
CVTDSECT DSECT                                                          00774000
         CVT   SYS=MVT                                                  00775000
UCBDSECT DSECT                                                          00776000
         IEFUCBOB                                                       00777000
*                                                                       00778000
DEVTABLE CSECT                RESUME CSECT                              00779000
         TITLE 'DEVICE NAME TABLE FORMATTER - DATA AREA'                00780000
         REGEQU                                                         00781000
         LTORG                                                          00782000
         DS    0D             ALIGNMENT                                 00783000
DOUBLE   DS    PL8            A DOUBLE WORD FOR CVD                     00784000
HEXTABLE EQU   *-C'0'         VIRTUAL ORIGIN OF HEXTABLE                00785000
         DC    C'0123456789ABCDEF'  HEX TRANSLATE TABLE                 00786000
H9       DS    PL9            UNPK WORK AREA                            00787000
H5       DS    PL5            UNPK WORK AREA                            00788000
TEMP     DS    F              UNPK WORK AREA                            00789000
NEWMASK  DS    A              ADDRESS OF MASK FOR REP AND VER CARDS     00790000
RANGEUCB DS    CL4            CURRENT UCB IN RANGE                      00791000
HEXUCB   DS    XL5            UCB RANGE WORK AREA                       00792000
HEXW1    DS    XL3            HEX TO BINARY PACK AREA                   00793000
HEXW2    DS    XL3            HEX TO BINARY PACK AREA                   00794000
HEXTRAN  EQU   *-C'A'         VIRTUAL ORIGIN OF HEX TO BINARY TABLE     00795000
         DC    X'0A0B0C0D0E0F'                                          00796000
         ORG   HEXTRAN+C'0'   POSITION FOR NUMERICS                     00797000
         DC    C'0123456789'                                            00798000
HEXTEST  DC    256X'FF'       VALID HEX DIGIT TESTER                    00799000
         ORG   HEXTEST+C'A'   POSITION FOR LETTERS                      00800000
         DC    6X'00'         ACCEPT A-F                                00801000
         ORG   HEXTEST+C'0'   POSITION FOR DIGITS                       00802000
         DC    10X'00'        ACCEPT 0-9                                00803000
         ORG   ,              BUMP OVER TABLE                           00804000
ADDRMASK DS    A              ADDRESS OF DEVICE MASK TABLE              00805000
MASK#1   DS    A            / FIRST MASK TABLE ENTRY ADDRESS            00806000
MASKENTY DS    F           /  NUMBER OF BYTES IN EACH ENTRY             00807000
MASKEND  DS    A          /   ADDRESS OF LAST TABLE ENTRY               00808000
NAME#1   DS    A            / ADDRESS OF FIRST NAME FIELD ENTRY         00809000
NAMEENTY DC    F'12'       /  NUMBER OF BYTES IN EACH ENTRY             00810000
NAMEEND  DS    A          /   ADDRESS OF LAST NAME FIELD ENTRY          00811000
MASKLEN  DS    F              LENGTH OF DEVICE MASK TABLE LESS 4        00812000
MASKWORD DS    F              NUMBER OF WORDS IN EACH MASK              00813000
ADDRNAME DS    A              ADDRESS OF DEVICE NAME TABLE              00814000
ADDRENTY DS    A              ADDRESS OF CURRENT MASK TABLE ENTRY       00815000
ADDRNENT DS    A              ADDRESS OF CURRENT NAME TABLE ENTRY       00816000
UNITCNT  DS    F              NUMBER OF UNITS THIS UCB                  00817000
CURNTUCB DS    A              ADDRESS OF CURRENT UCB                    00818000
ADDRUCB  DS    A              ADDRESS OF NAME OF UCB BEING LOCATED      00819000
ADDFIELD DS    A              ADDRESS OF CURRENT FIELD ON INPUT CARD    00820000
MADDR    DC    A(0)           ADDRESS OF SKELETON MASK ENTRY            00821000
WTG      DS    V              BRANCH ADDRESS FOR COMMON ROUTINE         00822000
LINECTL  DC    A(LINE+2,4,LINE+117) PRINT CONTROL REGISTERS             00823000
BADUCB   EQU   *-(UCBNAME-UCBDSECT)                                     00824000
         DC    C'BAD'         DEVICE ADDRESS FOR BAD UCB                00825000
ALLDISK  DC    C'*ALLDISK',XL4'0' PSEUDO-DEVNAMET ENTRY FOR ALL DISK    00826000
BITTABLE DC    X'8040201008040201'  BITS ZERO THROUGH SEVEN             00827000
BUILDLST DS    0D                                                       00828000
         DC    H'2'           TWO ENTRIES IN LIST                       00829000
         DC    AL2(DEVNAMET-DEVMASKT)   WORST CASE LENGTH               00830000
DEVMASKT DC    CL8'DEVMASKT'  DEVICE MASK TABLE                         00831000
TTR      DS    XL3            TTR OF MODULE                             00832000
CONCAT#  DS    FL1            CONCATENATION NUMBER                      00833000
Z        DS    FL1            LIBRARY INDICATOR                         00834000
C        DS    BL1            TYPE ETC.                                 00835000
USERDATA DC    XL62'0'        USER INFO                                 00836000
DEVNAMET DC    CL8'DEVNAMET'  DEVICE NAME TABLE                         00837000
TTR@     DS    XL3            TTR OF MODULE                             00838000
CONCAT#@ DS    FL1            CONCATENATION NUMBER                      00839000
Z@       DS    FL1            LIBRARY INDICATOR                         00840000
C@       DS    BL1            TYPE ETC.                                 00841000
USERDAT@ DC    XL62'0'        USER INFO                                 00842000
*                                                                       00843000
         EJECT                                                          00844000
SYSPRINT DCB   DDNAME=DEVPRINT,DSORG=PS,MACRF=PM,                      X00845000
               LRECL=121,RECFM=FBA,EXLST=PUTLIST                        00846000
*                                                                       00847000
         DS    0F                                                       00848000
PUTLIST  DC    X'85',AL3(PUTEXIT)  DCB EXIT LIST                        00849000
*                                                                       00850000
LINECNT  DC    P'99'          LINES ON CURRENT PAGE                     00851000
PAGECNT  DC    P'000'         CURRENT PAGE NUMBER                       00852000
         DC    C' '           CARRIAGE CONTROL                          00853000
LINE     DC    CL120' '       OUTPUT LINE                               00854000
         DC    C'1'           CARRIAGE CONTROL                          00855000
HEADER   DC    CL120' '       PAGE HEADER                               00856000
         ORG   HEADER         RESET LOCATION COUNTER                    00857000
         DC    C'UTCC DEVNAMET/DEVMASKT UTILITY'                        00858000
         ORG   HEADER+120-28  SET FOR NUMBERING                         00859000
LINEDATE DC    X'4020204B202020'  DATE EDIT MASK                        00860000
         DC    C'  '          PAD                                       00861000
LINETIME DC    X'4021207A20204B2020'  TIME EDIT MASK                    00862000
         DC    C'  PAGE'      PAGE LABEL                                00863000
LINEPAGE DC    X'40202120'    PAGE NUMBER EDIT MASK                     00864000
*                                                                       00865000
TIME     DS    A            / TIME OF DAY                               00866000
DATE     DS    A           /  DATE                                      00867000
         EJECT                                                          00868000
MISSMEM  DC    C'DEVNAMET OR DEVMASKT MISSING FROM LIBRARY'             00869000
BLDERR   DC    C'I/O ERROR IN BLDL FOR DEVICE TABLES'                   00870000
WRONG    DC    C'DEVICE TABLES FOUND IN STEPLIB/LINKLIB'                00871000
MISSZAP  DC    C'ZAPLIB DD CARD MISSING'                                00872000
MMATCH   DC    C'DEVNAMET/DEVMASKT LENGTHS MISMATCH'                    00873000
BADMSG   DC    C'0** INVALID CONTROL CARD'                              00874000
MISSFLD  DC    C'0XXXXXXXX NOT FOUND IN DEVNAMET'                       00875000
INVALID  DC    C'0MISSING OR INVALID UCB CONTROL CARD'                  00876000
NOUCB    DC    C'0XXX UCB NOT FOUND'                                    00877000
DUPUCB   DC    C'0XXX UCB DUPLICATED IN INPUT'                          00878000
MISSIN   DC    C'0ZAPIN DD CARD MISSING'                                00879000
NOTCALLD DC    C'0SUPERZAP NOT INVOKED DUE TO CONTROL CARD ERROR'       00880000
RANGEMES DC    C'0INVALID UCB RANGE'                                    00881000
         EJECT                                                          00882000
XC       XC    0(*-*,R2),0(R2)  CLEAR MASK WORK AREA                    00883000
OI       OI    0(R2),*-*      SET MASK BIT                              00884000
TM       TM    0(R2),*-*      TEST UCB MASK BIT ALREADY ON              00885000
         EJECT                                                          00886000
ZAPLIB   DCB   DDNAME=SYSLIB,DSORG=PO,MACRF=E                           00887000
*                                                                       00888000
ZAPIN    DCB   DDNAME=SYSIN,DSORG=PS,RECFM=FB,                         X00889000
               LRECL=80,EXLST=INLIST,MACRF=PM                           00890000
*                                                                       00891000
INLIST   DC    0A(0),X'85',AL3(INEXIT)                                  00892000
*                                                                       00893000
INEXIT   DS    0H                                                       00894000
         USING IHADCB,R1      ADDRESS DCB                               00895000
         OC    DCBBLKSI,DCBBLKSI  DID USER SPECIFY BLKSIZE              00896000
         BCR   7,R14          YES. RETURN TO OPEN                       00897000
         USING INEXIT,R15     TO ADDRESS LITERAL                        00898000
         MVC   DCBBLKSI,=H'800'  MEDIUM BLOCKING DEFAULT                00899000
         BR    R14            BACK TO OPEN                              00900000
         DROP  R1,R15         CLEAN UP                                  00901000
         LTORG                PUT THE LITERAL HERE                      00902000
         EJECT                                                          00903000
SYSIN    DCB   DDNAME=DEVIN,MACRF=GM,LRECL=80,                         X00904000
               RECFM=FB,EXLST=GETLIST,EODAD=EODAD1,                    X00905000
               DSORG=PS                                                 00906000
*                                                                       00907000
GETLIST  DC    0A(0),X'85',AL3(GETEXIT)  SYSIN EXIT LIST                00908000
*                                                                       00909000
GETEXIT  DS    0H                                                       00910000
         USING IHADCB,R1      ADDRESS DCB                               00911000
         OC    DCBBLKSI,DCBBLKSI  DID USER SPECIFY BLKSIZE              00912000
         BCR   7,R14          YES. EXIT                                 00913000
         MVC   DCBBLKSI,DCBLRECL  ASSUME UNBLOCKED                      00914000
         BR    R14            CONTINUE OPEN                             00915000
*                                                                       00916000
ZAPVERB  DS    CL3            VER OR REP INDICATOR                      00917000
         DC    C' '           BLANK TO PROPOGATE                        00918000
ZAPCARD  DS    CL80           SUPERZAP CARD BUFFER                      00919000
         DC    C'*'           WHEN MAKING CARD COMMENT                  00920000
CARD     DS    CL80           INPUT BUFFER                              00921000
         DC    C'*'           WHEN MAKING CARD COMMENT                  00922000
SAVECARD DS    CL80           SAVE AREA FOR INPUT BUFFER                00923000
DUMPMASK DC    CL80'  DUMP  DEVMASKT'                                   00924000
NAMEMASK DC    CL80'  NAME   DEVMASKT'                                  00925000
SWITCH   DC    B'0'           SYSIN SWITCHES                            00926000
REREAD   EQU   X'80'          REREAD LAST INPUT CARD                    00927000
EOF      EQU   X'40'          EOF HAS OCCURRED                          00928000
PENDEOF  EQU   X'20'          PRESENT EOF TO NEXT READ                  00929000
*                                                                       00930000
         END                                                            00931000
/*
//LKED     EXEC PGM=HEWLF064,PARM='LIST,MAP,NCAL'                    
//STEPLIB  DD  DISP=SHR,DSN=SYS2.LINKLIB                             
//SYSUT1   DD  UNIT=SYSALLDA,SPACE=(TRK,(5,5))                       
//SYSPRINT DD  SYSOUT=*                                              
//SYSPUNCH DD  DSN=&&OBJSET,DISP=(OLD,DELETE)                        
//SYSLMOD  DD  DISP=SHR,DSN=SYS2.LINKLIB                             
//SYSLIN   DD  *                                                     
 INCLUDE SYSPUNCH                                                    
 NAME  DEVTABLE(R)                                                   
/*                                                                   
//
//
