//SY20ZR05 JOB 1,SOFTWARE,MSGLEVEL=(1,1),CLASS=A,MSGCLASS=A
//STEP1   EXEC ASMFCL
//ASM.SYSLIB DD DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=3360
//           DD DISP=SHR,DSN=SYS1.MODGEN
//ASM.SYSIN  DD *
         TITLE 'DISPLAY UCB'
*
*
*
*
*        ROUTINE SEARCHES CVTILK2 FOR REPLY UCB/VOLSER AND
*              DISPLAYS THE UCB
*
*        COMMAND   -
*
*        TERM INPUT - VOLSER/UNIT ADDRESS
*
* CHANGE ACTIVITY      =                                              *
*                                                                     *
*   FLAG  DATE        BY    DESCRIPTION                               *
*   ----  ----------  ----  ----------------------------------------  *
*
         EJECT
UCB00    CSECT
*
R0       EQU   0                       --- REGISTER EQUATES ---
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         EJECT ,
         SAVE  (14,12),,*          SAVE CALLER'S REGISTERS
         LR    R12,R15             SET BASE REGISTER
         USING UCB00,R12           ADDRESSABILITY FOR PROGRAM
         GETMAIN R,LV=LWORKA       GET WORK STORAGE
         LR    R15,R13             SET UP
         LR    R13,R1               SAVE
         ST    R15,4(,R13)           AREA
         ST    R13,8(,R15)            CHAIN
         USING WORKA,R13           ADDRESSABILITY FOR WORK AREA
         B     @START             GO PROCESS COMMAND.
@START   DS    0H                 START OF USER PGM PROCESSING.
*
*        LOOK  AT VOLSER/UNIT REQUESTED
*
         TITLE 'TRACE CVTILK2 UCB CHAIN'
*
*        SET UP FOR UCB LOOK UP
*
#SETUP   DS    0H
*----------------------------------------------------------------*
         L     R1,4(,R13)          RESTORE R1
         L     R3,24(,R1)           AT ENTRY
         L     R1,0(,R1)           POINT TO TSO COMMAND BUFFER
         USING CPPL,R3             ADDRESSABILITY FOR CPPL
         EJECT ,
*----------------------------------------------------------------*
*        BUILD IOPL.                                             *
*----------------------------------------------------------------*
         L     R14,CPPLUPT         GET ADDRESS OF UPT
         L     R15,CPPLECT         GET ADDRESS OF ECT
         LA    R1,IOPLAREA         POINT TO AREA FOR IOPL
         USING IOPL,R1             ADDRESSABILITY FOR IOPL
         STM   R14,R15,IOPLUPT     SET ADDRESS OF UPT/ECT IN IOPL
         LA    R0,ECBIO            GET I/O ECB ADDRESS
         ST    R0,IOPLECB          SET ECB ADDDRESS IN IOPL
         LA    R0,PUTBLOCK         GET ADDRESS OF PUTLINE PARM BLOCK
         ST    R0,IOPLIOPB         SET PARM BLOCK ADDRESS IN IOPL
         DROP  R1                  END IOPL ADDRESSABILITY
         SPACE 1
*----------------------------------------------------------------*
*        BUILD PARSE PARAMETER LIST.                             *
*----------------------------------------------------------------*
         LA    R1,PPLSECT          POINT TO PARSE PARAMETER LIST
         USING PPL,R1              MAKE PPL ADDRESSABLE
         STM   R14,R15,PPLUPT      SET ADDRESS OF UPT/ECT IN PPL
         LA    R0,ECBPARS          POINT TO ECB FOR PARSE
         ST    R0,PPLECB           SET ECB ADDDRESS IN PPL
         MVC   PPLPCL,APCLMAIN     PARAMETER CNTL LIST POINTER TO PPL
         LA    R0,APDLMAIN         POINTER TO FULLWORD FOR PDL ADDRESS
         ST    R0,PPLANS           SET PDL POINTER POINTER IN PPL
         MVC   PPLCBUF,CPPLCBUF    MOVE COMMAND BUFFER ADDRESS TO PPL
         ST    R13,PPLUWA          SAVE WORK AREA ADDRESS IN PPL
         DROP  R1                  END PPL ADDRESSABILITY
         DROP  R3                  END CPPL ADDRESSABILITY
         EJECT ,
******************************************************************
*                                                                *
*        CALLPARS:                                               *
*                                                                *
*        SET UP AND PERFORM PARSE OF COMMAND OPERANDS, THEN      *
*        CHECK RETURN CODE FROM PARSE.  IF PARSE ERROR,          *
*        BRANCH TO ROUTINE TO ISSUE ERROR MESSAGE.               *
*                                                                *
*        R4  = PARSE DESCRIPTOR LIST (PDL) - SET IN THIS         *
*              ROUTINE.                                          *
*                                                                *
******************************************************************
         SPACE 1
CALLPARS DS    0H                  PERFORM PARSE OF COMMAND
         XC    ECBPARS,ECBPARS     CLEAR PARSE ECB
         NI    FLAG1,255-F1VOL     LIFT VOLSER FLAG
*        CALLTSSR EP=IKJPARS,      CALL TSO PARSE
*              MF=(E,PPLSECT)       USING PARSE PARAMETER LIST
         LA    R1,PPLSECT          POINT TO PARSE PARAMETER LIST
         LINK  EP=IKJPARS          CALL TSO PARSE
         LTR   R15,R15             WAS PARSE SUCCESSFUL?
         BNZ   PARSERR             ERROR IF PARSE FAILED
         SPACE 1
*---------------------------------------------------------------------*
*        PARSE WAS SUCCESSFUL.  GET ADDRESS OF PARSE DESCRIPTOR       *
*        LIST WHICH WAS BUILT BY PARSE.                               *
*---------------------------------------------------------------------*
PARSGOOD DS    0H                  HERE IF PARSE COMPLETED SUCCESSFULLY
         L     R4,APDLMAIN         GET ADDRESS OF PDL
         USING PDLMAIN,R4          ADDRESSABILITY OF PDL
         L     R1,BPARM+0          POINT TO VALUE
         LH    R0,BPARM+4          GET LENGTH
         L     R1,BPARM+0          POINT TO VALUE
         LH    R15,BPARM+4         GET LENGTH
         TM    FLAG1,F1VOL         IS PARM VOLSER?
         BO    DOVOL               BRANCH IF VOLSER
         B     DODEVNUM            ELSE IT'S A DEVICE NUMBER
         EJECT ,
         AIF   (T'CVTILK2 EQ 'U').FOO5
CVTILK2  EQU   CVTLLTRM,4
.FOO5    ANOP  ,
         EJECT ,
******************************************************************
*                                                                *
*        SEARCH UCB LOOKUP TABLE BY DEVICE NUMBER.               *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        INITIALIZE FOR DEVICE NUMBER SEARCH.                    *
*----------------------------------------------------------------*
DODEVNUM DS    0H                  SCAN BY DEVICE NUMBER
         L     R15,CVTPTR          GET CVT ADDRESS
         USING CVT,R15             ADDRESSABILITY FOR CVT
         L     R1,CVTILK2          POINT TO UCB LOOKUP TABLE
         DROP  R15                 END CVT ADDRESSABILITY
         SPACE 1
*----------------------------------------------------------------*
*        LOOP THROUGH UCB LOOKUP TABLE.                          *
*----------------------------------------------------------------*
DODEV1   DS    0H                  LOOP THROUGH UCB LOOKUP TABLE
         XR    R4,R4               LOAD UCB ADDRESS
         ICM   R4,3,0(R1)           FROM LOOKUP TABLE
         LTR   R4,R4               NULL ENTRY?
         BZ    DODEV2              BRANCH IF NULL ENTRY
         CL    R4,=X'0000FFFF'     END OF LOOKUP TABLE?
*        CLM   R4,3,=X'FFFF'       END OF LOOKUP TABLE?
         BE    DODEV3              BRANCH IF END OF TABLE
         USING UCBOB,R4            ADDRESSABILITY FOR UCB
         MVC   DWORK(2),UCBCHA     Get UCB device number
         NI    DWORK,X'0F'         Remove flag bits
         CLC   DWORK(2),DEVNUM     IS THIS THE UCB WE WANT?
         BE    DODEV4              BRANCH IF SO
         SPACE 1
*----------------------------------------------------------------*
*        ADVANCE TO NEXT LOOKUP TABLE ENTRY AND BRANCH           *
*        BACK TO THE TOP OF THE LOOP TO PROCESS IT.              *
*----------------------------------------------------------------*
DODEV2   DS    0H                  ADVANCE TO NEXT ENTRY
         LA    R1,2(,R1)           POINT TO NEXT ENTRY
         B     DODEV1              BACK TO LOOK AT IT
         SPACE 1
*----------------------------------------------------------------*
*        THE ENTIRE UCB LOOKUP TABLE HAS BEEN SEARCHED           *
*        WITHOUT FINDING A MATCH FOR THE SPECIFIED DEVICE        *
*        NUMBER.  GO ISSUE AN ERROR MESSAGE.                     *
*----------------------------------------------------------------*
DODEV3   DS    0H                  DEVICE NUMBER NOT MATCHED
         MVC   EMSGTEXT,M105       SET "NO UCB" TEXT
         B     #NTFOUND            GO ISSUE ERROR MESSAGE
         SPACE 1
M105     DC    CL72'UCB11105I NO UCB FOR DEVICE NUMBER'
         SPACE 1
*----------------------------------------------------------------*
*        A UCB HAS BEEN FOUND MATCHING THE SPECIFIED             *
*        DEVICE NUMBER.                                          *
*----------------------------------------------------------------*
DODEV4   DS    0H                  FOUND IT
         B     #CLEAR              BRANCH TO PROCESS
         EJECT ,
******************************************************************
*                                                                *
*        SEARCH UCB LOOKUP TABLE BY VOLUME SERIAL.               *
*                                                                *
******************************************************************
         SPACE 1
*----------------------------------------------------------------*
*        INITIALIZE FOR SEARCH BY VOLSER.                        *
*----------------------------------------------------------------*
DOVOL    DS    0H                  PARM IS VOLSER
         L     R15,CVTPTR          GET CVT ADDRESS
         USING CVT,R15             ADDRESSABILITY FOR CVT
         L     R1,CVTILK2          POINT TO UCB LOOKUP TABLE
         DROP  R15                 END CVT ADDRESSABILITY
         SPACE 1
*----------------------------------------------------------------*
*        LOOP THROUGH UCB LOOKUP TABLE.                          *
*----------------------------------------------------------------*
DOVOL1   DS    0H                  LOOP THROUGH UCB LOOKUP TABLE
         XR    R4,R4               LOAD UCB ADDRESS
         ICM   R4,3,0(R1)           FROM LOOKUP TABLE
         BZ    DOVOL2              BRANCH IF NULL ENTRY
         CLM   R4,3,=X'FFFF'       END OF LOOKUP TABLE?
         BE    DOVOL3              BRANCH IF END OF TABLE
         USING UCBOB,R4            ADDRESSABILITY FOR UCB
         CLC   UCBVOLI,VOLSER      IS THIS THE UCB WE WANT?
         BE    DOVOL4              BRANCH IF SO
         SPACE 1
*----------------------------------------------------------------*
*        ADVANCE TO NEXT LOOKUP TABLE ENTRY AND BRANCH           *
*        BACK TO THE TOP OF THE LOOP TO PROCESS IT.              *
*----------------------------------------------------------------*
DOVOL2   DS    0H                  ADVANCE TO NEXT ENTRY
         LA    R1,2(,R1)           POINT TO NEXT ENTRY
         B     DOVOL1              BACK TO LOOK AT IT
         SPACE 1
*----------------------------------------------------------------*
*        THE ENTIRE UCB LOOKUP TABLE HAS BEEN SEARCHED           *
*        WITHOUT FINDING A MATCH FOR THE SPECIFIED VOLSER.       *
*        GO ISSUE AN ERROR MESSAGE                               *
*----------------------------------------------------------------*
DOVOL3   DS    0H                  SPECIFIED VOLSER NOT MATCHED
         MVC   EMSGTEXT,M106       SET "VOLUME NOT MOUNTED" TEXT
         B     #NTFOUND            GO ISSUE ERROR MESSAGE
         SPACE 1
M106     DC    CL72'UCB11106I VOLUME NOT MOUNTED'
         SPACE 1
*----------------------------------------------------------------*
*        A UCB HAS BEEN FOUND MATCHING THE SPECIFIED             *
*        VOLSER.                                                 *
*----------------------------------------------------------------*
DOVOL4   DS    0H                  FOUND IT
         B     #CLEAR              BRANCH TO PROCESS
         SPACE 1
*
*        VOLSER NOT FOUND
*
#NTFOUND DS    0H
         LA    R15,LSERRMSG        GET MESSAGE SEGMENT LENGTH
         STH   R15,EMSGLEN         SET IN SEGMENT
         XC    EMSGOFF,EMSGOFF     SHOW BASE SEGMENT
         LA    R15,SERRMSG         POINT TO MESSAGE SEGMENT
         ST    R15,OLDSEG1P        SET SEGMENT ADDRESS IN OLD
         MVC   OLDNSEG,=F'1'       SHOW ONE MESSAGE SEGMENT
         XC    ECBIO,ECBIO         CLEAR ECB
         PUTLINE OUTPUT=(OLD,TERM,SINGLE,INFOR),                       +
               TERMPUT=(EDIT,WAIT,NOHOLD,NOBREAK),                     +
               MF=(E,IOPLAREA)
         B     RETURN              DONE
         EJECT ,
*
*        FORMAT DISPLAY LINES
*
#CLEAR   DS    0H
         MVC   LNTXT,BLANKS        REINITIALIZE LINE
         LR    R5,R4               COPY COMMON SECTION ADDRESS
         USING UCBOB,R4            ADDRESSABILITY FOR UCB
         SPACE 1
         MVC   DWORK(2),UCBCHA     CONVERT
         MVI   DWORK+2,X'0F'        DEVICE
         NI    DWORK,X'0F'           NUMBER
         UNPK  HEXWK1(5),DWORK(3)     TO
         TR    HEXWK1(5),HEXTB2        PRINTABLE
         MVC   @UCBUNT,HEXWK1           AND SET IN DISPLAY
         SPACE 1
         CLI   UCBTBYT3,UCB3DACC   DIRECT ACCESS?
         BE    #ONLINE
         CLI   UCBTBYT3,UCB3TAPE   TAPE?
         BNE   #DEVTYPE
*
#ONLINE  DS    0H
         TM    UCBSTAT,UCBONLI     IS DEVICE ONLINE?
         BZ    #DEVTYPE
         MVC   @UCBVOL,UCBVOLI     MOVE VOLSER
*
*        TEST FOR DEVICE DEPENDENCY
*
#DEVTYPE DS    0H
         LA    R15,4               COMMUNICATIONS DEVICE IS 4 LINES
         MVC   @UCBTYP,KCOMM       ASSUME COMMUNICATIONS DEVICE
         CLI   UCBTBYT3,UCB3COMM   COMMUNICATIONS DEVICE?
         BE    #SEGMENT            BRANCH IF COMMUNICATIONS DEVICE
         LA    R15,5               UR DEVICE IS 5 LINES
         MVC   @UCBTYP,KUR         ASSUME UNIT RECORD DEVICE
         CLI   UCBTBYT3,UCB3UREC   UNIT RECORD DEVICE?
         BE    #SEGMENT            BRANCH IF UNIT RECORD
         LA    R15,6               TAPE/DASD DEVICES ARE 6 LINES
         MVC   @UCBTYP,KTAPE       ASSUME DEVICE IS TAPE
         CLI   UCBTBYT3,UCB3TAPE   TAPE ?
         BE    #SEGMENT            BRANCH IF TAPE
         MVC   @UCBTYP,KDASD       ASSUME DEVICE IS DASD
         CLI   UCBTBYT3,UCB3DACC   DIRECT ACCESS DEVICE?
         BE    #SEGMENT            BRANCH IF DASD
         LA    R15,6               DISPLAY DEVICES ARE 6 LINES
         MVC   @UCBTYP,KDISP       ASSUME DISPLAY DEVICE
         CLI   UCBTBYT3,UCB3DISP   DISPLAY DEVICE?
         BE    #SEGMENT            BRANCH IF DISPLAY
         MVC   @UCBTYP,KUNK        ELSE SAY UNKNOWN DEVICE
*
*        PREPARE COMMON SYSGEN SEGMENT FOR DISPLAY
*
#SEGMENT DS    0H
         BAL   R14,#FORMAT         FORMAT COMMON SEGMENT
         SPACE 1
*----------------------------------------------------------------*
*        IF THIS IS A TAPE DEVICE, FORMAT UCB TAPE               *
*        DEVICE EXTENSION.                                       *
*----------------------------------------------------------------*
         CLI   UCBTBYT3,UCB3TAPE   TAPE ?
         BNE   RETURN              DONE IF NOT
         MVC   @UCBADR2+2(L'KEXTTAPE),KEXTTAPE
         XC    LNRDW,LNRDW         CLEAR RDW TO ZEROES
         LA    R0,L'LNTXT+L'LNRDW  GET TOTAL LENGTH OF LINE
         STCM  R0,3,LNRDW           AND SET IN RDW
         XC    ECBIO,ECBIO         CLEAR PUTLINE ECB
         PUTLINE OUTPUT=(LINE,TERM,SINGLE,DATA),                       +
               TERMPUT=(EDIT,WAIT,NOHOLD,NOBREAK),                     +
               MF=(E,IOPLAREA)
         MVC   LNTXT,BLANKS        REINITIALIZE LINE
         L     R5,UCBXTN           GET ADDRESS OF TAPE EXTENSION
         LA    R15,3               TAPE EXTENSION IS 3 LINES
         BAL   R14,#FORMAT         FORMAT TAPE EXTENSION
         DROP  R4                  END UCB ADDRESSABILITY
         EJECT ,
*----------------------------------------------------------------*
*        FREE WORK AREA AND EXIT.                                *
*----------------------------------------------------------------*
RETURN   DS    0H                  FREE WORK AREA AND RETURN
         LR    R1,R13              SAVE WORK AREA ADDR FOR FREEMAIN
         L     R13,4(,R13)         RESTORE CALLER'S SAVE AREA ADDRESS
         FREEMAIN R,A=(1),         FREE WORK                           +
               LV=LWORKA            AREA STORAGE
         RETURN (14,12),RC=0       RETURN TO CALLER
         EJECT ,
*******************************************************************
*                                                                 *
*        PARSERR:                                                 *
*                                                                 *
*        INVOKE GNRLFAIL SERVICE ROUTINE (IKJEFF19) TO            *
*        ISSUE MESSAGE FOR BAD RETURN CODE FROM PARSE.            *
*                                                                 *
*        R15 = (AT ENTRY) RETURN CODE FROM PARSE.                 *
*                                                                 *
*        PARSE RETURN CODES ARE:                                  *
*                                                                 *
*               0 - PARSE COMPLETED SUCESSFULLY.                  *
*               4 - COMMAND PARAMETERS WERE INCOMPLETE            *
*                   AND PARSE WAS UNABLE TO PROMPT.               *
*               8 - PARSE DID NOT COMPLETE.  AN ATTENTION         *
*                   INTERRUPT OCCURRED DURING PARSE PROCESSING.   *
*              12 - PARSE PARAMETER BLOCK CONTAINS INVALID        *
*                   INFORMATION.                                  *
*              16 - PARSE ISSUED A GETMAIN BUT NO SPACE WAS       *
*                   AVAILABLE.                                    *
*              20 - A VALIDITY CHECKING ROUTINE REQUESTED         *
*                   TERMINATION.                                  *
*              24 - CONFLICTING PARAMETERS WERE FOUND ON IKJTERM, *
*                   IKJOPER, OR IKJRSVWD MACRO.                   *
*              28 - TERMINAL HAS BEEN DISCONNECTED.               *
*                                                                 *
*******************************************************************
         SPACE 1
PARSERR  DS    0H                  ERROR OCCURRED IN PARSE
         C     R15,=F'4'           ERROR BECAUSE UNABLE TO PROMPT?
         BE    PARSERRX            GO RETURN IF SO
         C     R15,=F'20'          VALIDITY CHECK REQUEST ERROR?
         BE    PARSERRX            RETURN IF SO
         SPACE 1
PARSERRX DS    0H                  EXIT FROM PARSE ERROR ROUTINE
         LA    R15,20              SET RC = 20
         ST    R15,RETCODE          TO INDICATE PARSE ERROR
         B     RETURN              TAKE A POWDER
         TITLE 'S U B R O U T I N E S'
*
*        FORMAT DISPLAY LINE(S)
*
#FORMAT  DS    0H
         SPACE 1
*-----------------------------------------------------------------*
*        FORMAT STARTING ADDRESS FOR THIS LINE.                   *
*-----------------------------------------------------------------*
         ST    R5,DWORK+4              UCB ADDRESS
         UNPK  @UCBADR1,DWORK+4(5)     SET
         TR    @UCBHEX1,@VECTRAN       DISPLAY
         MVI   @UCBFIL1,C' '           CHAR
         SPACE 1
*-----------------------------------------------------------------*
*        FORMAT FIRST WORD OF DATA IN HEX.                        *
*-----------------------------------------------------------------*
         UNPK  @UCBADR2,0(5,R5)        DATA CONTENTS
         TR    @UCBHEX2,@VECTRAN       SET
         MVI   @UCBFIL2,C' '           DISPLAY
         SPACE 1
*-----------------------------------------------------------------*
*        FORMAT SECOND WORD OF DATA IN HEX.                       *
*-----------------------------------------------------------------*
         UNPK  @UCBADR3,4(5,R5)        CHAR
         TR    @UCBHEX3,@VECTRAN
         MVI   @UCBFIL3,C' '
         SPACE 1
*-----------------------------------------------------------------*
*        FORMAT DATA AS CHARACTERS.                               *
*-----------------------------------------------------------------*
         MVI   @UCBAST1,C'*'       BRACKET LEFT END OF CHARS
         MVC   @UCBDPLY,0(R5)      COPY DATA IN CHAR FORMAT
         TR    @UCBDPLY,@VECTRAN   TRANSLATE UNPRINTABLES TO "."
         MVI   @UCBAST2,C'*'       BRACKET RIGHT END OF CHARS
         SPACE 1
*-----------------------------------------------------------------*
*        CALL PUTLINE TO DISPLAY THE LINE.                        *
*-----------------------------------------------------------------*
          LR   R10,R14
          LR   R11,R15
         XC    LNRDW,LNRDW         CLEAR RDW TO ZEROES
         LA    R0,L'LNTXT+L'LNRDW  GET TOTAL LENGTH OF LINE
         STCM  R0,3,LNRDW           AND SET IN RDW
         XC    ECBIO,ECBIO         CLEAR PUTLINE ECB
         PUTLINE OUTPUT=(LINE,TERM,SINGLE,DATA),                       +
               TERMPUT=(EDIT,WAIT,NOHOLD,NOBREAK),                     +
               MF=(E,IOPLAREA)
          LR   R14,R10
          LR   R15,R11
         SPACE 1
*-----------------------------------------------------------------*
*        LOOP BACK TO DO NEXT LINE.                               *
*-----------------------------------------------------------------*
         LA    R5,8(R5)            POINT TO NEXT DOUBLEWORD OF INPUT
         MVC   LNTXT,BLANKS        REINITIALIZE LINE
         BCT   R15,#FORMAT         BACK TO DO NEXT LINE
         SPACE 1
*-----------------------------------------------------------------*
*        ALL LINES DONE, RETURN TO CALLER.                        *
*-----------------------------------------------------------------*
         BR    R14                 ALL LINES DONE, RETURN TO CALLER
         EJECT ,
*******************************************************************
*                                                                 *
*        VALPARM:                                                 *
*                                                                 *
*        PARSE VALIDITY CHECK EXIT FOR DEVICE NUMBER/             *
*        VOLUME SERIAL PARM.                                      *
*                                                                 *
*******************************************************************
**       PUSH  USING               SAVE USING STATUS
**       DROP  ,                   END ALL ADDRESSABILITY
         DROP  R12                 END MAIN PROGRAM ADDRESSABILITY
         DROP  R13                 END WORK AREA ADDRESSABILITY
VALPARM  DS    0H                  DEVNUM VALIDITY CHECK EXIT
         SAVE  (14,12)             SAVE CALLER'S REGISTERS
         LR    R11,R13             SAVE CALLER'S SAVE AREA ADDRESS
         USING VALPARM,R15         TEMPORARY ADDRESSABILITY
         L     R12,=A(UCB00)       RESTORE BASE REGISTER
         DROP  R15                 END TEMPORARY ADDRESSABILITY
         USING UCB00,R12           RESTORE MAIN ADDRESSABILITY
         L     R13,4(,R1)          RESTORE WORK AREA ADDRESS
         USING WORKA,R13           ADDRESSABILITY FOR WORK AREA
         LR    R10,R1              SAVE R1
         L     R4,0(,R1)           POINT TO PDL
         USING BPARM,R4            ADDRESSABILITY FOR PDE
         L     R1,BPARM+0          POINT TO VALUE
         LH    R15,BPARM+4         GET LENGTH
         CH    R15,=H'3'           IF PARM
         BL    VALVOL               IS SHORTER THAN THREE BYTES
         CH    R15,=H'4'             OR LONGER THAN FOUR BYTES
         BH    VALVOL                 TREAT AS VOLSER
         NI    FLAG1,255-F1VOL     ELSE LIFT VOLSER FLAG
         MVC   HEXWK1,=CL7' '      BLANK WORK AREA
         BCTR  R15,0               DECREMENT LENGTH FOR EX
         EX    R15,MVCDEV          COPY DEVICE NUMBER
         L     R14,=A(TTABVHEX)    POINT TO TRANSLATE TABLE
         EX    R15,TRTHEX          VERIFY VALID DIGITS
*         BNZ   VALBAD              SET ERROR IF NOT VALID
         BNZ   VALVOL              Treat as volser if not valid digits
         TR    HEXWK1,HEXTB        ADJUST
         EX    R15,PACKDEV         PACK DEVICE NUMBER
         L     R15,DWORK+4         GET DEVICE NUMBER
         SRL   R15,4                SHIFT OUT SIGN
         STH   R15,DEVNUM            AND SAVE FOR SCAN
         STH   R15,DWORK           CONVERT
         MVI   DWORK+2,X'0F'        DEVICE
         UNPK  HEXWK1(5),DWORK(3)    NUMBER
         TR    HEXWK1(5),HEXTB2       TO PRINTABLE
         MVC   RDEVNUM,HEXWK1          AND SAVE FOR DISPLAY
         B     VALGOOD             GO TAKE GOOD EXIT
         SPACE 1
VALVOL   DS    0H                  TREAT AS VOLSER
         OI    FLAG1,F1VOL         SET VOLSER FLAG
         MVC   VOLSER,=CL6' '      BLANK VOLSER
         BCTR  R15,0               DECREMENT LENGTH FOR EX
         EX    R15,MVCVOL          COPY VOLSER
         B     VALGOOD             GO TAKE GOOD EXIT
         SPACE 1
VALGOOD  DS    0H                  SET GOOD RETURN CODE
         XR    R15,R15             SET RC=0
         B     VALEXIT             GO TO EXIT
         SPACE 1
VALBAD   DS    0H                  SET BAD RETURN CODE
         LA    R15,4               SET RC=4
         B     VALEXIT             GO TO EXIT
         SPACE 1
VALEXIT  DS    0H                  EXIT FROM VALIDITY CHECK EXIT
         LR    R13,R11             RESTORE CALLER'S SAVE AREA ADDR
         RETURN (14,12),RC=(15)    RETURN TO PARSE
         SPACE 1
TRTHEX   TRT   HEXWK1(*-*),0(R14)  ** EXECUTED
MVCDEV   MVC   HEXWK1(*-*),0(R1)   ** EXECUTED
MVCVOL   MVC   VOLSER(*-*),0(R1)   ** EXECUTED
PACKDEV  PACK  DWORK,HEXWK1(*-*)   ** EXECUTED
**       POP   USING               RESTORE USING STATUS
         EJECT ,
*******************************************************************
*                                                                 *
*        CONSTANTS AND LITERALS.                                  *
*                                                                 *
*******************************************************************
         SPACE 1
APCLMAIN DC    A(PCLMAIN)          ADDRESS OF PCL FOR MAIN PARSE CALL
BLANKS   DC    CL80' '             UTILITY BLANKS
KTAPE    DC    CL16'Tape'
KCOMM    DC    CL16'Communications'
KCTC     DC    CL16'CTC'
KDASD    DC    CL16'Direct Access'
KDISP    DC    CL16'Display'
KUR      DC    CL16'Unit Record'
KCHARRD  DC    CL16'Character Reader'
KUNK     DC    CL16'Unknown'
KEXTCOM  DC    C'Common Extension'
KEXTTAPE DC    C'Magnetic Tape Extension'
         EJECT ,
*******************************************************************
*                                                                 *
*        CONSTRUCT PARSE PARAMETER CONTROL LIST (PCL) CSECT       *
*        AND PARAMETER DESCRIPTOR LIST (PDL) DSECT FOR MAIN       *
*        PARSE OF COMMAND OPERANDS.                               *
*                                                                 *
*******************************************************************
         SPACE 1
**       PUSH  PRINT
         PRINT GEN
PCLMAIN  IKJPARM DSECT=PDLMAIN
         SPACE 1
BPARM    IKJIDENT 'DEVICE NUMBER OR VOLSER',                           +
               MAXLNTH=6,                                              +
               FIRST=ANY,                                              +
               OTHER=ANY,                                              +
               VALIDCK=VALPARM,                                        +
               PROMPT='DEVICE NUMBER OR VOLSER'
         SPACE 1
         IKJENDP
**       POP   PRINT
         PRINT NOGEN
         EJECT ,
         SPACE 1
         TITLE 'WORKING STORAGE'
*
         LTORG
         SPACE 1
*----------------------------------------------------------------*
*        TRANSLATE TABLE TO CONVERT PRINTABLE HEX                *
*        DIGITS "A" THROUGH "F' TO X'FA' THROUGH X'FF'.          *
*----------------------------------------------------------------*
HEXTB    DC    256C'0'
         ORG   HEXTB+C'A'
         DC    X'FAFBFCFDFEFF'
         ORG   HEXTB+C' '
         DC    C'0'
         ORG   HEXTB+C'0'
         DC    C'0123456789'
         ORG   ,
         SPACE 1
*----------------------------------------------------------------*
*        TRANSLATE TABLE TO CONVERT X'FA' THROUGH X'FF'          *
*        TO PRINTABLE HEX DIGITS "A" THROUGH "F".                *
*----------------------------------------------------------------*
HEXTB2   DS    0XL256
         DC    (C'0')C'0'
         DC    C'0123456789ABCDEF'
HEXTB2A  EQU   *-HEXTB2
LHEXTB2  EQU   L'HEXTB2
         DC    (LHEXTB2-HEXTB2A)C'0'
         SPACE 1
*----------------------------------------------------------------*
*        TRANSLATE TABLE TO VALIDATE HEX DIGITS.                 *
*----------------------------------------------------------------*
TTABVHEX DS    0XL256
         DC    (C'A')X'FF'
         DC    6X'00'
TTABVHXA EQU   *-TTABVHEX
         DC    (C'0'-TTABVHXA)X'FF'
         DC    10X'00'
TTABVHXB EQU   *-TTABVHEX
LTTABVHX EQU   L'TTABVHEX
         DC    (LTTABVHX-TTABVHXB)X'FF'
         SPACE 1
*----------------------------------------------------------------*
*        TRANSLATE TABLE TO FIND FIRST BLANK.                    *
*----------------------------------------------------------------*
TTABBLNK DS    0XL256
         DC    (C' ')X'00'
         DC    C' '
TTABBLNA EQU   *-TTABBLNK
LTTABBLN EQU   L'TTABBLNK
         DC    (LTTABBLN-TTABBLNA)X'00'
         SPACE 1
*----------------------------------------------------------------*
*        TRANSLATE TABLE TO REPLACE UNPRINTABLE CHARACTERS       *
*        WITH PERIODS.                                           *
*----------------------------------------------------------------*
@VECTRAN DC    64C'.',C' ',128C'.',C'ABCDEFGHI',7C'.',C'JKLMNOPQR'
         DC    8C'.',C'STUVWXYZ',6C'.',C'0123456789ABCDEF'
         EJECT ,
CVT      DSECT ,
         CVT   SYS=MVT
         IKJCPPL ,
         IKJIOPL ,
         IKJPPL
PPLLEN   EQU   *-PPL
         EJECT ,
UCB      DSECT ,
*        IEFUCBOB ,
***********************************************************************
*
*              U N I T   C O N T R O L   B L O C K
*
***********************************************************************
*
*       STATUS
*
*             RELEASE 20.2, 5/21/71, LEVEL=3
*             RELEASE 21, 6/25/71, LEVEL=2
*
*       FUNCTION
*
*         A UNIT CONTROL BLOCK
*           INCORPORATING A SYSTEM RESOURCE TABLE
*             RECORDS THE STATUS OF
*               A PHYSICAL INPUT OUTPUT DEVICE ADDRESS
*             IS CREATED AND INITIALIZED DURING SYSTEM GENERATION
*             RESIDES IN THE NUCLEUS BELOW 32 K
*             POINTS TO A DEVICE TYPE DEPENDENT EXTENSION
*               RESIDING HIGHER IN THE NUCLEUS
*             IS POINTED TO BY THE UCB LOOKUP TABLE INDEXED BY
*               A FUNCTION OF THE CHANNEL CONTROL UNIT DEVICE ADDRESS
*             MAY BE POINTED TO BY TASK INPUT OUTPUT TABLES
*               AND DATA EXTENT BLOCKS
*             CONTAINS INDICES INTO TABLES FOR
*               DEVICE STATISTICS ATTENTION LOGICAL CHANNEL
*             MAY POINT TO AND BE POINTED TO BY REQUEST QUEUE ELEMENTS
*
*       ENTRY
*
*             IEFUCBOB
*
*       INPUT
*
*             BAL: DSECT
*             BSL: DCL (UCBPTR, UCBDCPTR) PTR
*
*       OUTPUT
*
*             SYSGEN INDEPENDENT COMMON SECTION
*               INCLUDING UCBTYP WORD
*             DEVICE DEPENDENT SEGMENT (ONE OF THE FOLLOWING)
*               DIRECT ACCESS (EXCEPT DATACELL) AND MAGNETIC TAPE
*               DATACELL
*                 (INCLUDING TEN CELL DESCRIPTIONS SUBMAPPED BELOW)
*               UNIT RECORD WITH UNIVERSAL CHARACTER SET
*               GRAPHICS (EXCEPT M85 CRT CONSOLE)
*               TAPE CARTRIDGE READER AND OPTICAL READER
*             CELL DESCRIPTION FOR ONE OF THE TEN CELLS
*               IN THE DATACELL DEVICE SEGMENT ABOVE
*             UCB EXTENSION (ONE OF THE FOLLOWING)
*               DIRECT ACCESS
*               MAGNETIC TAPE
*               TAPE CARTRIDGE READER
*               OPTICAL READER
*               UNIVERSAL CHARACTER SET
*             M65 MULTIPROCESSING PREFIX
*               (CONTIGUOUSLY PRECEDING COMMON SECTION)
*
*       ATTRIBUTES
*
*             BILINGUAL
*
***********************************************************************
*
*       SYSGEN-INDEPENDENT
*       COMMON SECTION
*
         DS    0D -                    UNIT CONTROL BLOCK PROPER
*
UCBOB    EQU   * -                     UCBPTR -> UCBOB
*
***********************************************************************
*
UCBJBNR  DS    B -                     INTERNAL JOB ID
UCBKEY   EQU   X'F0' -                 JOB PROTECTION KEY
*                                        (SET FOR RETAIN OR PASS)
UCBDEM   EQU   X'02' -                 DEMOUNT AND RETAIN OR PASS
*                                        (SET DURING DEVICE ALLOC)
UCBMONT  EQU   X'01' -                 MOUNT AND RETAIN OR PASS
*                                        (SET DURING DEVICE ALLOC)
UCBFL5   DS    B -                     FLAGS
UCBTICBT EQU   X'20' -                 CHANNEL END AND/OR DEVICE END
*                                      OR MOUNT CONDITION PENDING.
*                                      USED ONLY WITH PTF.       ICB289
UCBVSDR  EQU   X'10' -                 DEVICE HAS VARIABLE LENGTH SDRS
UCBEXTSN EQU   X'08' -                 UCBNBRSN CONTAINS LENGTH AND
*                                        UCBSNADR ADDRESS OF SENSE INFO
UCBNALOC EQU   X'04' -                 DEVICE NOT ALLOCABLE
*                                        BECAUSE OWNED BY OLTEP
UCBALTCU EQU   X'02' -                 DEVICE HAS ALTERNATE CU ADDRESS
UCBALTPH EQU   X'01' -                 DEVICE HAS ALTERNATE PATH
UCBID    DS    C -                     UCB ID (FF)
UCBSTAT  DS    B -                     DEVICE STATUS
UCBONLI  EQU   X'80' -                 DEVICE ONLINE
UCBCHGS  EQU   X'40' -                 DEVICE TO BE VARIED OFFLINE
UCBRESV  EQU   X'20' -                 VOLUME RESERVED
UCBUNLD  EQU   X'10' -                 UNLOAD PENDING
UCBALOC  EQU   X'08' -                 DEVICE ALLOCATED
UCBPRES  EQU   X'04' -                 VOLUME PERMANENTLY RESIDENT
UCBSYSR  EQU   X'02' -                 EITHER SYSTEM RESIDENCE
*                                        OR PRIMARY CONSOLE
UCBDADI  EQU   X'01' -                 EITHER STANDARD TAPE LABELS
*                                        VERIFIED OR ALTERNATE CONSOLE
UCBCHA   DS    B -                     CHANNEL ADDRESS FLAGS
UCBHIO   EQU   X'80' -                 HALT I/O
UCBMOD   EQU   X'40' -                 STATUS MODIFIER
UCBDSNS  EQU   X'20' -                 DELAYED SENSE
UCBDHIO  EQU   X'10' -                 DELAYED HALT I/O
UCBCHANA EQU   X'0F' -                 CHANNEL ADDRESS
UCBUA    DS    FL1 -                   UNIT ADDRESS
UCBFL1   DS    B -                     FLAGS
UCBBUSYD EQU   X'80' -                 DEVICE BUSY
UCBNOTRD EQU   X'40' -                 DEVICE NOT READY
UCBUSING EQU   X'20' -                 CHANNEL PROGRAM EXECUTED
*                                        AND NOT YET POSTED COMPLETE
UCBINTER EQU   X'10' -                 DEVICE END ERROR
*                                        AFTER CHANNEL END
*                                        (IOB INTERCEPT)
UCBNOTRC EQU   X'08' -                 CONTROL UNIT BUSY
UCBSTS   EQU   X'06' -                 DEVICE STATUS
*/       01    UCBNTRAN                DIRECT ACCESS ARM SEEKING
*                                        (IOS STANDALONE CP EXECUTED)
*                                        OR TC RECEIVE STATUS
*                                        (INHIBIT HIO)
*/       11    UCBTRANS                DIRECT ACCESS DATA TRANSFER
*                                        (USER CP EXECUTING)
UCBERR   EQU   X'01' -                 ERROR ROUTINE USING DEVICE
*                                        EXCLUSIVELY
UCBDTI   DS    FL1 -                   DEVICE TABLE INDEX
UCBETI   DS    FL1 -                   ERROR TABLE INDEX
*                                        (ERROR ROUTINE SUFFIX)
UCBSTI   DS    FL1 -                   STATUS TABLE INDEX
*                                        (*10 = STATAB INDEX)
UCBLCI   DS    FL1 -                   LOGICAL CHANNEL WORD TABLE INDEX
*                                        (*8 = LCHTAB INDEX)
UCBATI   DS    FL1 -                   ATTENTION TABLE (ANTAB) INDEX
UCBWGT   DS    B -                     FLAGS AND CHANNEL MASK
UCBIN    EQU   X'80' -                 SYSIN
UCBOUT   EQU   X'40' -                 SYSOUT
UCBPUB   EQU   X'20' -                 ASSUME PUBLIC VOLUME
UCBREW   EQU   X'10' -                 REWIND COMMAND
UCBPATH  EQU   X'0F' -                 INOPERATIVE PATHS
UCBPATH0 EQU   X'08' -                 PRIMARY PATH INOPERATIVE
UCBPATH1 EQU   X'04' -                 OPTIONAL PATH 1 INOPERATIVE
UCBPATH2 EQU   X'02' -                 OPTIONAL PATH 2 INOPERATIVE
UCBPATH3 EQU   X'01' -                 OPTIONAL PATH 3 INOPERATIVE
UCBNAME  DS    CL3 -                   EBCDIC UNIT NAME
UCBTYP   DS    0CL4 -                  DEVICE DESCRIPTION
UCBTBYT1 DS    B -                     MODEL BITS
UCB1FEA0 EQU   X'80' -                 BIT 0
UCB1FEA1 EQU   X'40' -                 BIT 1
UCB1FEA2 EQU   X'20' -                 BIT 2
UCB1FEA3 EQU   X'10' -                 BIT 3
UCB1FEA4 EQU   X'08' -                 BIT 4
UCB1FEA5 EQU   X'04' -                 BIT 5
UCB1FEA6 EQU   X'02' -                 BIT 6
UCB1FEA7 EQU   X'01' -                 BIT 7
UCBTBYT2 DS    B -                     OPTION FLAGS
UCB2OPT0 EQU   X'80' -                 FLAG 0
UCB2OPT1 EQU   X'40' -                 FLAG 1
UCB2OPT2 EQU   X'20' -                 FLAG 2
UCB2OPT3 EQU   X'10' -                 FLAG 3
UCB2OPT4 EQU   X'08' -                 FLAG 4
UCB2OPT5 EQU   X'04' -                 FLAG 5
UCB2OPT6 EQU   X'02' -                 FLAG 6
UCB2OPT7 EQU   X'01' -                 FLAG 7
UCBTBYT3 DS    B -                     CLASS BITS
UCB3TAPE EQU   X'80' -                 TAPE
UCB3COMM EQU   X'40' -                 COMMUNICATIONS
UCB3DACC EQU   X'20' -                 DIRECT ACCESS
UCB3DISP EQU   X'10' -                 DISPLAY
UCB3UREC EQU   X'08' -                 UNIT RECORD
UCB3CHAR EQU   X'04' -                 CHARACTER READER
UCBTBYT4 DS    C -                     DEVICE CODE
UCBLTS   DS    CL2 -                   LAST REQUEST ELEMENT
UCBSNS   DS    CL2 -                   SENSE INFORMATION
*
SRTEJBNR EQU   UCBJBNR -               ALIAS
SRTEMNT  EQU   UCBMONT -               ALIAS
SRTESTAT EQU   UCBSTAT -               ALIAS
SRTEONLI EQU   UCBONLI -               ALIAS
SRTECHGS EQU   UCBCHGS -               ALIAS
SRTERESV EQU   UCBRESV -               ALIAS
SRTEUNLD EQU   UCBUNLD -               ALIAS
SRTEALOC EQU   UCBALOC -               ALIAS
SRTEPRES EQU   UCBPRES -               ALIAS
SRTESYSR EQU   UCBSYSR -               ALIAS
SRTEDADI EQU   UCBDADI -               ALIAS
UCBFL2   EQU   UCBFL1 -                ALIAS (UCBCHA WAS ONCE UCBFL1)
*
***********************************************************************
*
*        DEVICE-DEPENDENT UCB SEGMENTS
*
UCBDEV   EQU   *
*
***********************************************************************
*
*             DIRECT ACCESS (2300)
*             (EXCEPT DATA CELL)
*             AND MAGNETIC TAPE (2400)
*             UCB SEGMENT
*
         ORG   UCBDEV -                DEVICE-DEPENDENT SEGMENT
*
***********************************************************************
*
UCBSENSE DS    0CL4 -                  ADDITIONAL SENSE INFORMATION FOR
*                                      DEVICES WITH SIX SENSE BYTES
UCBSENSB DS    0A -                    SAME AS UCBSENSA BELOW
UCBSENSN DS    FL1 -                   NUMBER OF EXPANDED SENSE BYTES
UCBSENSA DS    AL3 -                   ADDRESS OF EXPANDED SENSE
*                                      INFORMATION
UCBVOLI  DS    CL6 -                   VOLUME SERIAL NUMBER
UCBSTAB  DS    B -                     VOLUME STATUS
UCBBSVL  EQU   X'80' -                 NOT SHARABLE
UCBBVSC  EQU   X'40' -                 RESERVED
UCBBALB  EQU   X'20' -                 MORE VOLUME LABEL PROCESSING
UCBPRSRS EQU   X'20' -                 THIS DEVICE WAS SPECIFIED IN
*                                      PRESRES BUT WAS NOT MOUNTED AT
*                                      IPL
UCBBPRV  EQU   X'10' -                 PRIVATE USE
UCBBPUB  EQU   X'08' -                 PUBLIC USE
UCBBSTR  EQU   X'04' -                 STORAGE USE (DA)
*                                        ANSI LABEL (MT)
UCBBJLB  EQU   X'02' -                 JOBLIB VOLUME (DA)
UCBBNUL  EQU   X'01' -                 MCS MOUNT/DEMOUNT MSGS ISSUED
*                                        (MESSAGE IDS IN UCBFSER) (MT)
*                                        CONTROL VOLUME (DA)
UCBDMCT  DS    B -                     VOLUME USE BYTE
UCBMOUNT EQU   X'80' -                 MOUNTED OR REQUEST ISSUED
*                                        (OFF MEANS MOUNT VERIFIED)
UCBDMC   EQU   X'7F' -                 NUMBER OF OPEN DCBS
UCBVTOC  DS    0CL4 -                  TTR0 OF VTOC (DA)
UCBFSCT  DS    H -                     DATASET SEQUENCE COUNT (MT)
UCBFSEQ  DS    H -                     DATASET SEQUENCE NUMBER (MT)
UCBFSER  DS    0CL8 -                  DATASET SERIAL NUMBER
*                                        (MT AFTER OPEN) OR
*                                        MESSAGE IDS  (MT BEFORE OPEN)
*                                        PLUS TWO RESERVED BYTES (MT)
UCBSQC   DS    FL1 -                   NUMBER OF RESERVE MACROS
*                                        (DA INCLUDING DATACELL)
UCBDVRES DS    FL1 -                   DEVICE RESERVATION (SHARED DASD)
*                                        (DA INCLUDING DATACELL)
*                                        SET TO UCBSQC AFTER GOOD SIO
UCBRQESV DS    H -                     ADDRESS OF RQE TO VERIFY
*                                        VOL SER NUMBER IN UCB
*                                        (SET FROM UCBLTS AFTER
*                                        UNSOLICITED DEVICE END)
*                                        (DA INCLUDING DATACELL)
UCBORSVA DS    0A -                    ADDRESS OF DEB FOR FIRST USER
*                                        ON QUEUE FOR DEVICE
*                                        (DA INCLUDING DATACELL)
UCBFL4   DS    B -                     FLAGS (DA INCLUDING DATACELL)
UCBDAV   EQU   X'F8' -                 VOLUME VERIFICATION FLAGS
UCBMNT   EQU   X'80' -                 VOL SER VERIFIER ISSUED MOUNT
UCBVVRTN EQU   X'40' -                 VOL SER VERIFIER IN CONTROL
UCBFT    EQU   X'20' -                 FIRST VERIFIER ENTRY FOR VOL
UCBTCC   EQU   X'10' -                 ALTERNATE TRACK PROCEDURE
*                                        HANDLING VOL LABEL
UCBVER   EQU   X'08' -                 VERIFIER VERIFIED VOL
UCBORCNT EQU   X'07' -                 NUMBER OF REQUESTS FOR DEVICE
*                                        FROM FIRST USER ON QUEUE
UCBORSVB DS    AL3 -                   ADDRESS OF DEB FOR FIRST USER
*                                        ON QUEUE FOR DEVICE
*                                        (DA INCLUDING DATACELL)
UCBSKA   DS    0CL8 -                  MBBCCHHR OF LAST SEEK
*                                        (DA INCLUDING DATACELL)
UCBXTN   DS    0A -                    ADDRESS OF UCB EXTENSION (MT)
UCBVOPT  DS    B -                     VOLUME STATISTIC FLAGS
UCBESV   EQU   X'80' -                 ESV RECORDS KEPT
UCBEVA   EQU   X'40' -                 EVA RECORDS MAY BE KEPT
UCBESVC  EQU   X'20' -                 ESV RECORDS SENT TO CONSOLE
*                                        AS OPPOSED TO SYS1.MAN
UCBERPC  EQU   X'10' -                 ERROR RECOVERY PROC IN CONTROL
UCBESVE  EQU   X'08' -                 ESV RECORD ISSUED FOR VOLUME
*                                        BECAUSE OF EOV
UCBASMDE EQU   X'01' -                 UNSOLICITED DEVICE END OCCURRED
*                                      ON 3420                   ICB277
UCBXTNB  DS    AL3 -                   ADDRESS OF UCB EXTENSION (MT)
*                                        (MAP BELOW)
         DS    CL4 -                   UCBSKA PADDING (NOT IN UCB)
*                                         NO LONGER EXISTS (MT)
UCBECBB  DS    0A -                    ECB ADDRESS (DA)
UCBUSER  DS    FL1 -                   NUMBER OF CURRENT USERS (DA)
UCBECBA  DS    AL3 -                   ECB ADDRESS (DA)
UCBEXT   DS    0A -                    ADDRESS OF UCB EXTENSION (DA)
*                                        (MAPPED BELOW)
UCBWKADB DS    A -                     ALIAS
*
SRTEVOLI EQU   UCBVOLI -               ALIAS
SRTESTAB EQU   UCBSTAB -               ALIAS
SRTEBSVL EQU   UCBBSVL -               ALIAS
SRTEBVSC EQU   UCBBVSC -               ALIAS
SRTEBALB EQU   UCBBALB -               ALIAS
SRTEBPRV EQU   UCBBPRV -               ALIAS
SRTEBPUB EQU   UCBBPUB -               ALIAS
SRTEBSTR EQU   UCBBSTR -               ALIAS
SRTEASCI EQU   UCBBSTR -               ALIAS
UCBASCI  EQU   SRTEASCI -              ALIAS
SRTEBVQS EQU   SRTEBSTR -              ALIAS
SRTEBJLB EQU   UCBBJLB -               ALIAS
SRTEBNUL EQU   UCBBNUL -               ALIAS
SRTEDMCT EQU   UCBDMCT -               ALIAS
SRTEFSCT EQU   UCBFSCT -               ALIAS
SRTEFSEQ EQU   UCBFSEQ -               ALIAS
SRTEUSER EQU   UCBUSER -               ALIAS
SRTEECBA EQU   UCBECBA -               ALIAS
*
***********************************************************************
*
*             DATA CELL (2321)
*             UCB SEGMENT
*
         ORG   UCBDEV -                DEVICE-DEPENDENT SEGMENT
*
***********************************************************************
*
UCBSEN   DS    CL4 -                   MORE SENSE INFORMATION
UCBERPA  DS    CL12 -                  ERROR RECOVERY WORK AREA A
UCBDASD  DS    CL16 -                  DATA CELL FIELDS MAPPED BY
*                                        UCBSQC (1 BYTE)
*                                        UCBDVRES (1 BYTE)
*                                        UCBRQESV (2 BYTES)
*                                        UCBFL4 (1 FLAG BYTE)
*                                        UCBORSVA/B (3 BYTES)
*                                        UCBSKA (8 BYTES)
*                                        UNDER DIRECT ACCESS ABOVE
UCBCELLS DS    0CL160 -                CELL DESCRIPTIONS (MAPPED BELOW)
UCBCELL0 DS    CL16 -                  CELL 0
UCBCELL1 DS    CL16 -                  CELL 1
UCBCELL2 DS    CL16 -                  CELL 2
UCBCELL3 DS    CL16 -                  CELL 3
UCBCELL4 DS    CL16 -                  CELL 4
UCBCELL5 DS    CL16 -                  CELL 5
UCBCELL6 DS    CL16 -                  CELL 6
UCBCELL7 DS    CL16 -                  CELL 7
UCBCELL8 DS    CL16 -                  CELL 8
UCBCELL9 DS    CL16 -                  CELL 9
UCBDC    DS    0A -                    ADDRESS OF DATACELL UCB EXT
*                                        (MAPPED BELOW)
UCBWKADA DS    A -                     ALIAS
*
***********************************************************************
*
*             UNIT RECORD WITH
*             UNIVERSAL CHARACTER SET (1403, 3211)
*             UCB SEGMENT
*
         ORG   UCBDEV -                DEVICE-DEPENDENT SEGMENT
*
***********************************************************************
*
UCBNBRSN DS    FL1 -                   LENGTH OF SENSE INFO (3211)
UCBSNADR DS    AL3 -                   ADDR OF SENSE INFO --
*                                        THAT OF UCBSNS (1403)
*                                        OR UCBSNSXT (3211)
UCBXTADR DS    A -                     ADDR OF UCS UCB EXTENSION
*
***********************************************************************
*
*             GRAPHICS EXCEPT
*             M85 CRT CONSOLE
*             UCB SEGMENT
*
         ORG   UCBDEV -                DEVICE-DEPENDENT SEGMENT
*
***********************************************************************
*
UCBSENS  DS    CL2 -                   MORE SENSE INFORMATION
UCBOPEN  DS    FL1 -                   NUMBER OF OPEN DCBS
UCBGCB   DS    C -                     GRAPHIC CONTROL BYTE
UCBTEB   DS    A -                     ADDRESS OF TASK ENTRY BLOCK
UCBSTART DS    A -                     RESTART ADDRESS
UCBBTA   DS    0A -                    ADDRESS OF BUFFER TABLE
UCBDI    DS    FL1 -                   DEVICES ON A CONTROL UNIT
*                                        TO WHICH BUFFER SECTIONS
*                                        ARE ASSIGNED
UCBBTB   DS    AL3 -                   ADDRESS OF BUFFER TABLE
*
***********************************************************************
*
*             TAPE CARTRIDGE READER (2495)
*             AND OPTICAL READER (1285, 1287, 1288)
*             UCB SEGMENT
*
         ORG   UCBDEV -                DEVICE-DEPENDENT SEGMENT
*
***********************************************************************
*
UCBCRWKA DS    A -                     ADDRESS OF UCB EXTENSION
*                                        FOR THIS DEVICE
*                                        (MAPPED BELOW)
*
***********************************************************************
*
*       CELL DESCRIPTION
*       FOR UCBCELL0/.../9
*       IN DATACELL (2321)
*
         ORG   UCBUSER
*
UCBDCLL  EQU   * -                     UCBDCPTR -> UCBDCLL
*
***********************************************************************
*
UCBDCELL DS    0CL16 -                 ONE OF TEN CELLS
*
UCBDBBNR DS    H -                     BIN NUMBER
UCBDSTAB DS    B -                     VOLUME STATUS BYTE B
*                                        (ANALOGOUS TO UCBSTAB)
UCBDBSVL EQU   X'80' -                 NOT SHARABLE
UCBDBPRS EQU   X'20' -                 THIS DEVICE WAS SPECIFIED IN
*                                      PRESRES BUT WAS NOT MOUNTED AT
*                                      IPL
UCBDBPRV EQU   X'10' -                 PRIVATE USE
UCBDBPUB EQU   X'08' -                 PUBLIC USE
UCBDBSTR EQU   X'04' -                 STORAGE USE
UCBDBJLB EQU   X'02' -                 JOBLIB VOLUME
UCBDBNUL EQU   X'01' -                 CONTROL VOLUME
UCBDSTAT DS    B -                     CELL/BIN STATUS
*                                        (ANALOGOUS TO UCBSTAT)
UCBDNORM EQU   X'80' -                 ONLINE WITH NORMAL CELL
*                                        (NOT OFFLINE OR BALLAST)
UCBDRESV EQU   X'20' -                 RESERVED CELL
UCBDUNLD EQU   X'10' -                 UNLOAD PENDING
UCBDALOC EQU   X'08' -                 BIN ALLOCATED
UCBDPRES EQU   X'04' -                 CELL PERMANENTLY RESIDENT
UCBDVOLI DS    CL6 -                   VOLUME SERIAL NUMBER
UCBDJBNR DS    FL1 -                   INTERNAL JOB NUMBER
UCBDDMCT DS    FL1 -                   NUMBER OF OPEN DCBS FOR THIS
*                                      CELL (BITS 1-7)
UCBDDMNT EQU   X'80' -                 IF 0, MOUNT VERIFICATION HAS
*                                      BEEN PERFORMED ---
*                                      IF 1, MOUNT REQUEST HAS BEEN
*                                      ISSUED
UCBDVTOC DS    CL3 -                   TTR OF VTOC
UCBDUSER DS    FL1 -                   CURRENT NUMBER OF DATASETS
*
DATACELL EQU   UCBDCELL -              ALIAS
DCELBBNR EQU   UCBDBBNR -              ALIAS
DCELSTAB EQU   UCBDSTAB -              ALIAS
DCELSTAT EQU   UCBDSTAT -              ALIAS
DCELVOLI EQU   UCBDVOLI -              ALIAS
DCELJBNR EQU   UCBDJBNR -              ALIAS
DCELDMCT EQU   UCBDDMCT -              ALIAS
DCELVTOC EQU   UCBDVTOC -              ALIAS
DCELUSER EQU   UCBDUSER -              ALIAS
*
***********************************************************************
*
*       UNIT CONTROL BLOCK EXTENSIONS
*
***********************************************************************
*
*             DIRECT ACCESS (2300)
*             UCB EXTENSION
*
UCBDA    DSECT ,                       UCBEXT -> UCBDA
*
***********************************************************************
*
         DS    CL104 -                 OFFSET
UCBERP   DS    CL40 -                  ERROR RECOVERY WORK AREA
UCBOVFLW DS    CL40 -                  TRACK OVERFLOW WORK AREA
*                                        (OPTIONAL)
*
***********************************************************************
*
*             MAGNETIC TAPE (2400)
*             UCB EXTENSION
*
UCBMT    DSECT ,                       UCBXTN -> UCBMT
*
***********************************************************************
*
UCBROR   DS    CL8 -                   READ OPPOSITE DIRECTION
*                                        RECOVERY CCW
UCBSUM   DS    0BL2 -                  VOLUME STATISTICS UPDATE MASK
UCBSUMA  DS    B -                     FIRST BYTE
UCBSUMTR EQU   X'80' -                 UPDATE TEMP READ ERRORS
UCBSUMTW EQU   X'40' -                 UPDATE TEMP WRITE ERRORS
UCBSUMSC EQU   X'30' -                 SIO COUNTER POSITION
UCBSUMPR EQU   X'08' -                 UPDATE PERM READ ERRORS
UCBSUMPW EQU   X'04' -                 UPDATE PERM WRITE ERRORS
UCBSUMNB EQU   X'02' -                 UPDATE NOISE BLOCKS COUNTER
UCBSUMB  DS    B -                     SECOND BYTE
UCBSUMEG EQU   X'C0' -                 ERASE GAP COUNTER POSITION
UCBSUMCA EQU   X'30' -                 CLEANER ACTION COUNTER POSITION
UCBTRT   DS    FL1 -                   TEMP READ ERROR THRESHOLD
*                                        (IF ZERO THEN EVA ABSENT)
UCBTWT   DS    FL1 -                   TEMP WRITE ERROR THRESHOLD
*                                        (IF ZERO THEN EVA ABSENT)
UCBTR    DS    FL1 -                   TEMP READ ERROR COUNT
UCBTW    DS    FL1 -                   TEMP WRITE ERROR COUNT
UCBSIO   DS    H -                     SIO COUNT
UCBPR    DS    FL1 -                   PERM READ ERROR COUNT
UCBPW    DS    FL1 -                   PERM WRITE ERROR COUNT
UCBNB    DS    FL1 -                   NOISE BLOCK COUNT
UCBMS    DS    CL1 -                   MODE SET OPERATION CODE FOR DATA
*                                      BLOCKS ON 3420            ICB277
UCBERG   DS    H -                     ERASE GAP COUNT
UCBCLN   DS    H -                     CLEANER ACTION COUNT
*
***********************************************************************
*
*             TAPE CARTRIDGE READER (2495)
*             UCB EXTENSION
*
UCBTCR   DSECT ,                       UCBCRWKA -> UCBTCR
*
***********************************************************************
*
UCBTCERP DS    0CL24 -                 ERROR RECOVERY CHANNEL PROGRAM
UCBRCCW1 DS    D -                     RETRY CCW 1
UCBRCCW2 DS    D -                     RETRY CCW 2
UCBRCCW3 DS    D -                     RETRY CCW 3
UCBCSWSA DS    CL8 -                   CSW SAVE AREA
*
***********************************************************************
*
*            OPTICAL READER (1285, 1287, 1288)
*            UCB EXTENSION
*
UCBOR    DSECT ,                       UCBCRWKA -> UCBOR
*
***********************************************************************
*
UCBCRDDC DS    FL1 -                   DATA CHECK ERROR COUNT
UCBCRILC DS    FL1 -                   INCORRECT LENGTH ERROR COUNT
UCBCRECC DS    FL1 -                   EQUIPMENT CHECK ERROR COUNT
         DS    CL5 -                   RESERVED
*
***********************************************************************
*
*              UNIT RECORD WITH
*              UNIVERSAL CHARACTER SET (1403, 3211)
*              UCB EXTENSION
*
UCBUCS   DSECT ,                       UCBXTADR -> UCBUCS
*
***********************************************************************
*
UCBUCSID DS    CL4 -                   ID OF UCS IMAGE IN BUFFER
UCBUCSOP DS    B -                     FORMAT OF UCS IMAGE IN BUFFER
*                                        (O FOR OPTION)
UCBUCSO1 EQU   X'80' -                 DEFAULT IMAGE
UCBUCSO2 EQU   X'40' -                 FOLD MODE
UCBUCSPE EQU   X'01' -                 IMAGE HAS PARITY ERROR (3211)
UCBFCBOP DS    B -                     RESERVED (1403) OR FLAGS (3211)
*                                        (O FOR OPTION)
UCBFCBO1 EQU   X'80' -                 FCB DEFAULT IMAGE
         DS    X -                     RESERVED
UCBERCNT DS    FL1 -                   COUNT OF ERRORS THAT HAVE
*                                      OCCURRED (3211)
UCBFCBID DS    CL4 -                   FCB IMAGE ID
UCBERADR DS    A -                     ADDR OF ERP LOGOUT AREA
*
***********************************************************************
*
*              3211 SENSE INFORMATION UCB EXTENSION
*
*        THIS EXTENSION IS POINTED TO BY THE UCBSNADR FIELD OF THE
*        UCB AND IS NOT CONTIGUOUS TO THE UCB.
*
UCBSNINF DSECT ,
*
***********************************************************************
*
UCBSNSXT DS    CL6 -                   SENSE INFORMATION
         DS    XL2 -                   RESERVED
*
***********************************************************************
*
*       MODEL 65 MULTIPROCESSING UCB PREFIX
*
UCBM65MP DSECT , -                     UCBPTR-4 IF MP65
*
***********************************************************************
*
UCBFL3   DS    B -                     M65MP FLAGS
UCBACU   EQU   X'80' -                 ALTERNATE CONTROL UNITS EXIST
UCBHIOB  EQU   X'20' -                 CPU B TO USE HIO
UCBHIOA  EQU   X'10' -                 CPU A TO USE HIO
UCBSIOB  EQU   X'08' -                 CPU B ISSUED LAST SIO
UCBNOB   EQU   X'02' -                 NO PATH TO CPU B
UCBNOA   EQU   X'01' -                 NO PATH TO CPU A
         DS    CL2 -                   RESERVED
UCBMPFLG DS    B -                     FLAGS
UCBRIC   EQU   X'20' -                 DURING NIP - DEVICE IS RESERVED
*                                      TO IPLED CPU
UCBRNIC  EQU   X'10' -                 DURING NIP - DEVICE IS RESERVED
*                                      TO NON-IPLED CPU
UCBNRO   EQU   X'04' -                 DURING NIP - DEVICE IS NOT
*                                      RESERVED BECAUSE OF OPERATOR'S
*                                      REQUEST
UCBPROC  EQU   X'02' -                 USED BY PROCESSING PROGRAMS
UCBIPL   EQU   X'01' -                 DEVICE OFFLINE AT IPL
*
***********************************************************************
*
*              U N I T   C O N T R O L   B L O C K
*
***********************************************************************
*
         EJECT ,
WORKA    DSECT
SAVEA    DS    18F                 PROGRAM SAVE AREA
DWORK    DS    D                   DOUBLEWORD WORK AREA
RETCODE  DS    F                   RETURN CODE FROM PROGRAM
         SPACE 1
HEXWK1   DS    CL7                 DEVICE NUMBER WORK AREA
         SPACE 1
DEVNUM   DS    H                   DEVICE NUMBER FOR UCB LOOKUP
RDEVNUM  DS    CL4                 DEVICE NUMBER FROM UCB LOOKUP
VOLSER   DS    CL6                 VOLSER FOR UCB LOOKUP
         SPACE 1
*---------------------------------------------------------------------*
*        FLAGS.                                                       *
*---------------------------------------------------------------------*
FLAG1    DS    XL1                 FLAG BYTE
F1VOL    EQU   X'80'               -- TREAT PARM AS VOLSER
         DS    XL3                 RESERVED
         SPACE 1
*---------------------------------------------------------------------*
*        EVENT CONTROL BLOCKS.                                        *
*---------------------------------------------------------------------*
ECBPARS  DS    F                   ECB FOR PARSE
ECBIO    DS    F                   ECB FOR PUTLINE
         SPACE 1
*---------------------------------------------------------------------*
*        ANCHOR FOR PARSE DESCRIPTOR LIST.                            *
*---------------------------------------------------------------------*
APDLMAIN DS    A                   ADDRESS OF PDL FROM MAIN PARSE CALL
         SPACE 1
*-----------------------------------------------------------------*
*        AREA FOR PARSE PARAMETER LIST.                           *
*-----------------------------------------------------------------*
PPLSECT  DS    0F                  AREA FOR PARSE PARAMETER LIST
         ORG   PPLSECT+PPLLEN
         SPACE 1
*-----------------------------------------------------------------*
*        AREA FOR TSO INPUT/OUTPUT PARAMETER LIST.                *
*-----------------------------------------------------------------*
IOPLAREA DS    4F                  AREA FOR I/O PARAMETER LIST
         SPACE 1
*-----------------------------------------------------------------*
*        AREA FOR TSO PUTLINE PARAMETER BLOCK.                    *
*-----------------------------------------------------------------*
PUTBLOCK PUTLINE MF=L              PUTLINE PARAMETER BLOCK
         SPACE 1
*-----------------------------------------------------------------*
*        AREA FOR OUTPUT LINE.                                    *
*-----------------------------------------------------------------*
LINE     DS    0F
LNRDW    DS    0A
LNRDWLEN DS    H
LNRDWRSV DS    H
LNTXT#   DS    0C
         DS    CL1
@UCBADR1 DS    0CL9
@UCBHEX1 DS    CL8
@UCBFIL1 DS    CL2
@UCBADR2 DS    0CL9
@UCBHEX2 DS    CL8
@UCBFIL2 DS    CL1
@UCBADR3 DS    0CL9
@UCBHEX3 DS    CL8
@UCBFIL3 DS    CL2
@UCBAST1 DS    CL1
@UCBDPLY DS    CL8
@UCBAST2 DS    CL3
@UCBUNT  DS    CL4
         DS    CL1
@UCBVOL  DS    CL6
         DS    CL2
@UCBTYP  DS    CL16
LNTXTL   EQU   *-LNTXT#
         ORG   LNTXT#
LNTXT    DS    CL(LNTXTL)
         ORG   ,
         SPACE 1
*-----------------------------------------------------------------*
*        AREA FOR PUTLINE ERROR MESSAGE OLD.                      *
*-----------------------------------------------------------------*
OLD      DS    0F                  OUTPUT LINE DESCRIPTOR
OLDNSEG  DS    F                   NUMBER OF MESSAGE SEGMENTS
OLDSEG1P DS    A(*-*)              POINTER TO MESSAGE SEGMENT 1
         SPACE 1
*-----------------------------------------------------------------*
*        AREA FOR ERROR MESSAGE SEGMENTS.                         *
*-----------------------------------------------------------------*
SERRMSG  DS    0F                  ERROR MESSAGE SEGMENT
EMSGLEN  DS    AL2(LSERRMSG)       LENGTH OF SEGMENT
EMSGOFF  DS    AL2(0)              OFFSET = 0 MEANS BASE SEGMENT
EMSGTEXT DS    CL72' '             TEXT OF ERROR MESSAGE
LSERRMSG EQU   *-SERRMSG           SYMBOLIC LENGTH OF SEGMENT
LWORKA   EQU   *-WORKA             SYMBOLIC LENGTH OF WORK AREA
         END   ,
//*
//LKED.SYSLMOD DD DISP=SHR,DSN=SYS1.LINKLIB
//LKED.SYSIN   DD *
 NAME UCB(R)
//
