//SY20ZR05 JOB 1,SOFTWARE,MSGLEVEL=(1,1),CLASS=A,MSGCLASS=A
//ASM    EXEC PGM=IFOX00,PARM='NOLOAD,DECK,RENT',REGION=256K
//STEPLIB  DD DISP=SHR,DSN=SYS2.LINKLIB
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=3360
//         DD DISP=SHR,DSN=SYS1.MODGEN
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD UNIT=SYSDA,SPACE=(TRK,(90,30))
//SYSUT2   DD UNIT=SYSDA,SPACE=(TRK,(90,30))
//SYSUT3   DD UNIT=SYSDA,SPACE=(TRK,(90,30))
//SYSGO    DD DUMMY
//SYSLIN   DD DUMMY
//SYSPUNCH DD UNIT=SYSDA,SPACE=(TRK,(90,30)),DISP=(NEW,PASS),
//            DSN=&&OBJSET
//SYSIN    DD *
WHO      TITLE '    ''WHO'' COMMAND FOR TSO'
***********************************************************************
*                                                                     *
*                                                                     *
* Module name          =  WHO                                         *
*                                                                     *
*                                                                     *
* Descriptive name     =  TSO WHO command.                            *
*                                                                     *
*                                                                     *
* Function             =  To display a message on the user's          *
*                         TSO terminal with information about         *
*                         the TSO userid, terminal ID, SMF system     *
*                         ID, day of the week, date and current       *
*                         time.                                       *
*                                                                     *
*                                                                     *
* Notes                =  See below.                                  *
*                                                                     *
*   Dependencies       =  TSO Terminal Status Block (TSB) format;     *
*                         TSO Terminal Job Block (TJB) format; TSO    *
*                         Relogon Buffer (RLB) format.                *
*                                                                     *
*   Registers          =  Not documented.                             *
*                                                                     *
*   Patch space        =  None.                                       *
*                                                                     *
*                                                                     *
* Module type          =  CSECT                                       *
*                                                                     *
*   Processor          =  OS/VS System Assembler                      *
*                                                                     *
*   Module size        =  See assembly listing.                       *
*                                                                     *
*   Attributes         =                                              *
*     Location         =  Linklist data set                           *
*     State            =  Problem                                     *
*     Key              =  User                                        *
*     Mode             =  Task                                        *
*     Serialization    =  None                                        *
*     Type             =  Reentrant                                   *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
* Change activity      =                                              *
*                                                                     *
*   Flag  Date        Description                                     *
*   ----  ----------  --------------------------------------------    *
*   $D17  2006/08/16  @kl Refit for OS/360.                           *
*   $D16  2002/02/15  @kl Refit for OS/VS2 3.8.                       *
*   $D15  2001/03/14  @kl Move CVTOSLVL tests after check to see      *
*                         if CVTOSLVL exists.                         *
*   $D14  2001/03/14  @kl Fix terminal length calculation to          *
*                         make the correct assumptions in the         *
*                         event of an eight-character terminal name.  *
*   $D13  2001/01/18  @JH   OS/390 IDENTIFICATION LOGIC.              *
*   $D12  1997/10/02  Year 2000 support: widen years to four-digits,  *
*                     find weekday correctly, document julian date    *
*                     to Gregorian date conversion routine.           *
*   $D11  1997/02/07  Change PSAANEW to PSAAOLD for MVS/ESA SP V5.    *
*        $D10   - DISPLAY INVOKING SUBSYSTEM NAME.                    *
*        $D09   - DISPLAY 'MVS/ESA' IF ESA SYSTEM.                    *
*        KL08   - ENSURE PUTLINE PARAMETER BLOCK HAS TERMPUT     @KL08*
*                 OPTIONS VALIDLY INITIALIZED  01/06/86          @KL08*
*        KL07   - FIX KL06 CHANGES TO INCLUDE KL03  07/31/85          *
*        KL06   - USE PUTLINE INSTEAD OF TPUT  06/15/84               *
*        KL05   - ADD SYSTEM ID AND OS VERSION  06/08/84              *
*        KL04   - USE HALLMARK AUTHORIZATION INTERFACE  06/08/84      *
*        KL03   - INSURE CORRECT ACCESS TO USERID INFORMATION         *
*                 EVEN IF NOT INVOKED DIRECTLY BY USER  11/19/82      *
*        KL02   - ALLOW VAM SUPPORT OPTIONALLY TO BE INCLUDED         *
*                 BY SPECIFING 'SYSPARM=VAM' AT ASSEMBLY 09/15/81     *
*        KL01   - ADD VAM SUPPORT, CLEAN UP DOCUMENTATION  08/19/81   *
*        KL00   - SOURCE PROGRAM  05/15/80                            *
*                                                                     *
*                                                                     *
***********************************************************************
         SPACE 3
         EJECT
***********************************************************************
*                                                                     *
*        Define register equates, addressing and residency mode.      *
*                                                                     *
***********************************************************************
         SPACE 1
WHO      CSECT
         SPACE 1
R0       EQU    0
R1       EQU    1
R2       EQU    2
R3       EQU    3
R4       EQU    4
R5       EQU    5
R6       EQU    6
R7       EQU    7
R8       EQU    8
R9       EQU    9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         TITLE '    ''WHO'' COMMAND - INITIALIZATION'
***********************************************************************
*                                                                     *
*        INITIALIZATION.                                              *
*                                                                     *
*        R10 - PROGRAM BASE REGISTER                                  *
*        R13 - BASE FOR GETMAINED WORK AREA INCLUDING SAVE AREA       *
*                                                                     *
*        WORKREGS - R0, R1, R2, R14                                   *
*                                                                     *
***********************************************************************
         SPACE 1
**       PRINT NOGEN
         SAVE  (14,12),,           SAVE CALLER'S REGISTERS             *
               WHO-&SYSDATE-&SYSTIME-$D17                          @D17
         LR    R10,R15             SET OUR BASE REGISTER
         USING WHO,R10             TELL THE ASSEMBLER
         LR    R2,R1               SAVE PARM POINTER              @KL03
         LA    R0,LWHOWORK         SET LENGTH OF WORK AREA
         GETMAIN R,LV=(0)          GET STORAGE FOR WORK AREA
         USING WHOWORK,R13         ADDRESSABILITY FOR WORK AREA
         LR    R15,R13             SET UP...
         LR    R13,R1              ...SAVE
         ST    R15,SAVEA+4         ...AREA
         ST    R13,8(,R15)         ...CHAIN
         TITLE '    ''WHO'' COMMAND - FIND DATE, TIME, AND DAY OF WEEK'
***********************************************************************
*                                                                     *
*        ISSUE 'TIME' MACRO AND EXTRACT YEAR.                         *
*                                                                     *
*        WORKREGS - R0, R1, R6                                        *
*                                                                     *
***********************************************************************
         SPACE 1
DTRTN    DS    0H                       GET DATE/TIME AND FIND YEAR
         TIME  DEC                      GET TIME AND DATE
         ST    R0,STIME                 SAVE TIME
         LR    R6,R1                    GET DAYS IN R6
         SLL   R6,16                    ...
         SRL   R6,16                    ...
*                                  R1 = 0cyydddF                   @D12
         XR    R0,R0               ISOLATE 0C                      @D12
         SLDL  R0,8                 IN R0                          @D12
         SRL   R1,8+16               AND YY IN R1                  @D12
*                                  r0 = 0000000c                   @D12
*                                  r1 = 000000yy                   @D12
         AH    R0,=H'19'           ADJUST 0C                       @D12
         MH    R0,=H'100'           FOR 20TH CENTURY BASE          @D12
         SLL   R1,4                     MAKE SIGN POSITIVE
         LA    R1,X'0F'(,R1)            ...
         XC    DBLWORD,DBLWORD          CLEAR WORK AREA
         ST    R1,DBLWORD+4             SAVE DECIMAL YEAR IN WORK AREA
         CVB   R1,DBLWORD               CONVERT YEAR TO BINARY
         AR    R1,R0               ADD IN CENTURY                  @D12
         XC    DBLWORD,DBLWORD          CLEAR WORK AREA
         ST    R6,DBLWORD+4             SAVE DEC DAYS IN WORK AREA
         CVB   R6,DBLWORD               CONVERT JULIAN DAYS TO BINARY
         CVD   R1,DBLWORD               CONVERT YEAR TO DECIMAL
         UNPK  WYEAR(4),DBLWORD+4(4)    UNPACK...                  @D12
         OI    WYEAR+3,X'F0'            ...AND FORMAT IT           @D12
         EJECT
***********************************************************************
*                                                                     *
*        Call DOW subroutine to find the day of the week.             *
*                                                                     *
*        R2  -  Binary year yyyy                                      *
*        R6  -  Binary day of year ddd                                *
*                                                                     *
*        Registers passed to subroutine:                              *
*          R1  = Binary year yyyy                                     *
*          R0  = Binary day of year ddd                               *
*          R15 = Not used                                             *
*                                                                     *
*        Registers returned by subroutine:                            *
*          R1  = Unchanged                                            *
*          R0  = Unchanged                                            *
*          R15 = Index of weekday (0=Sunday, 1=Monday...)             *
*                                                                     *
*        Workregs - R0, R1, R14, R15                                  *
*                                                                     *
***********************************************************************
         SPACE 1                                                   @D12
         LR    R2,R1               Save binary year in R2          @D12
         LR    R0,R6               Set binary day in R0            @D12
         LA    R15,DOW             Point to subroutine             @D12
         BALR  R14,R15             Call day-of-week subroutine     @D16
         MH    R15,=Y(DAYOFWKL)    Find index into                 @D12
         LA    R15,DAYOFWK(R15)     day of week segment table      @D12
         ST    R15,OLD3A           Set segment address in OLD      @D17
         EJECT ,                                                   @D12
***********************************************************************
*                                                                     *
*        Call FINDMDAY subroutine to convert MVS julian date          *
*        to Gregorian.                                                *
*                                                                     *
*        R2  -  Binary year yyyy                                      *
*        R6  -  Binary day of year ddd                                *
*                                                                     *
*        Registers passed to subroutine:                              *
*          R1  = Binary year yyyy                                     *
*          R0  = Binary day of year ddd                               *
*          R15 = Not used                                             *
*                                                                     *
*        Registers returned by subroutine:                            *
*          R1  = Gregorian month                                      *
*          R0  = Gregorian day                                        *
*          R15 = Unchanged                                            *
*                                                                     *
***********************************************************************
         SPACE 1                                                   @D12
         LR    R1,R2               Set binary year in R1           @D12
         LR    R0,R6               Set binary day in R0            @D12
         LA    R15,FINDMDAY        Point to subroutine             @D12
         BALR  R14,R15             Call Gregorian date subroutine  @D16
         CVD   R1,DBLWORD               Format                     @D12
         UNPK  WDAY(2),DBLWORD+6(2)      day in                    @D12
         OI    WDAY+1,X'F0'               message                  @D12
         CVD   R0,DBLWORD               Format                     @D12
         UNPK  WMONTH(2),DBLWORD+6(2)    month in                  @D12
         OI    WMONTH+1,X'F0'             message                  @D12
         EJECT
***********************************************************************
*                                                                     *
*        EDIT TIME-OF-DAY INTO PRINTABLE FORMAT.                      *
*                                                                     *
*        WORKREGS - R0                                                *
*                                                                     *
***********************************************************************
         SPACE 1
EDITTIME DS    0H                       EDIT TIME
         MVI   STIME+3,X'F0'            ELIMINATE SIGN
         L     R0,STIME                 LOP OFF...
         SRL   R0,4                     ...INSIGNIFICANT
         ST    R0,STIME                 ...LOW-ORDER 4 BITS
         MVC   TWORK(10),TPIC           MOVE IN EDIT PICTURE FOR TIME
         ED    TWORK(10),STIME          EDIT IN TIME
         MVC   INS3CTXT,TWORK+2         MOVE TIME INTO HEADER      @D17
         TITLE '    ''WHO'' COMMAND - INITIALIZE MESSAGE LINES'
***********************************************************************
*                                                                     *
*        INITIALIZE OUTPUT MESSAGE LINES TO BLANKS.                   *
*                                                                     *
*        WORKREGS -                                                   *
*                                                                     *
***********************************************************************
         SPACE 1
INITMSG  DS    0H                         INITIALIZE MESSAGE LINES
         SPACE 1
         EJECT
***********************************************************************
*                                                                     *
*        Initialize insert segments for line 1.                       *
*                                                                     *
***********************************************************************
         SPACE 1                                                  @KL06
         LA    R15,OLD1SEG         GET NUMBER OF SEGMENTS         @KL06
         ST    R15,OLD1NUMB        SET NUMBER OF SEGMENTS IN OLD  @KL06
         SPACE 1                                                  @KL06
         LA    R15,3+4             GET LENGTH OF INSERT SEGMENT   @KL06
         STH   R15,INS1ALEN        PUT LENGTH IN SEGMENT          @KL06
         LA    R15,OFFS1A          GET OFFSET FOR INSERT          @KL06
         STH   R15,INS1AOFF        PUT OFFSET IN SEGMENT          @KL06
         LA    R15,INSERT1A        GET ADDRESS OF SEGMENT         @KL06
         ST    R15,OLD1A           PUT SEGMENT ADDRESS IN OLD     @KL06
         SPACE 1
         LA    R15,6+4             GET LENGTH OF INSERT SEGMENT   @KL06
         STH   R15,INS1BLEN        PUT LENGTH IN SEGMENT          @KL06
         LA    R15,OFFS1B          GET OFFSET FOR INSERT          @KL06
         STH   R15,INS1BOFF        PUT OFFSET IN SEGMENT          @KL06
         LA    R15,INSERT1B        GET ADDRESS OF SEGMENT         @KL06
         ST    R15,OLD1B           PUT SEGMENT ADDRESS IN OLD     @KL06
         SPACE 1
         LA    R15,4+4             GET LENGTH OF INSERT SEGMENT   @KL06
         STH   R15,INS1CLEN        PUT LENGTH IN SEGMENT          @KL06
         LA    R15,OFFS1C          GET OFFSET FOR INSERT          @KL06
         STH   R15,INS1COFF        PUT OFFSET IN SEGMENT          @KL06
         LA    R15,INSERT1C        GET ADDRESS OF SEGMENT         @KL06
         ST    R15,OLD1C           PUT SEGMENT ADDRESS IN OLD     @KL06
         EJECT
***********************************************************************
*                                                                     *
*        Initialize insert segments for line 2.                       *
*                                                                     *
***********************************************************************
         SPACE 1
         LA    R15,OLD2SEG         GET NUMBER OF SEGMENTS         @KL06
         ST    R15,OLD2NUMB        SET NUMBER OF SEGMENTS IN OLD  @KL06
         SPACE 1                                                  @KL06
         LA    R15,7+4             GET LENGTH OF INSERT SEGMENT   @KL06
         STH   R15,INS2ALEN        PUT LENGTH IN SEGMENT          @KL06
         LA    R15,OFFS2A          GET OFFSET FOR INSERT          @KL06
         STH   R15,INS2AOFF        PUT OFFSET IN SEGMENT          @KL06
         LA    R15,INSERT2A        GET ADDRESS OF SEGMENT         @KL06
         ST    R15,OLD2A           PUT SEGMENT ADDRESS IN OLD     @KL06
         SPACE 1
         LA    R15,LINS2B+4        GET LENGTH OF INSERT SEGMENT   @KL06
         STH   R15,INS2BLEN        PUT LENGTH IN SEGMENT          @KL06
         LA    R15,OFFS2B          GET OFFSET FOR INSERT          @KL06
         STH   R15,INS2BOFF        PUT OFFSET IN SEGMENT          @KL06
         LA    R15,INSERT2B        GET ADDRESS OF SEGMENT         @KL06
         ST    R15,OLD2B           PUT SEGMENT ADDRESS IN OLD     @KL06
         EJECT
***********************************************************************
*                                                                     *
*        Initialize insert segments for line 3.                       *
*                                                                     *
***********************************************************************
         SPACE 1
         LA    R15,OLD3SEG         GET NUMBER OF SEGMENTS          @D17
         ST    R15,OLD3NUMB        SET NUMBER OF SEGMENTS IN OLD   @D17
         SPACE 1                                                  @KL06
         LA    R15,LINS3B+4        GET LENGTH OF INSERT SEGMENT    @D17
         STH   R15,INS3BLEN        PUT LENGTH IN SEGMENT           @D17
         LA    R15,OFFS3B          GET OFFSET FOR INSERT           @D17
         STH   R15,INS3BOFF        PUT OFFSET IN SEGMENT           @D17
         MVI   INS3BDL1,C'/'       SET DELIMITERS...               @D17
         MVI   INS3BDL2,C'/'       ...IN DATE                      @D17
         LA    R15,INSERT4B        GET ADDRESS OF SEGMENT          @D10
         ST    R15,OLD3B           PUT SEGMENT ADDRESS IN OLD      @D17
         SPACE 1
         LA    R15,LINS3C+4        GET LENGTH OF INSERT SEGMENT    @D17
         STH   R15,INS3CLEN        PUT LENGTH IN SEGMENT           @D17
         LA    R15,OFFS3C          GET OFFSET FOR INSERT           @D17
         STH   R15,INS3COFF        PUT OFFSET IN SEGMENT           @D17
         LA    R15,INSERT4C        GET ADDRESS OF SEGMENT          @D10
         ST    R15,OLD3C           PUT SEGMENT ADDRESS IN OLD      @D17
         EJECT
***********************************************************************
*                                                                     *
*        Initialize the OLD for displaying the message.               *
*                                                                     *
***********************************************************************
         SPACE 1                                                  @KL06
         LA    R15,MSG1SEG         GET ADDRESS OF BASE SEGMENT
         ST    R15,OLD1BASE        PUT BASE SEGMENT ADDRESS IN OLD
         SPACE 1                                                  @KL06
         LA    R15,MSG2SEG         GET ADDRESS OF BASE SEGMENT
         ST    R15,OLD2BASE        PUT BASE SEGMENT ADDRESS IN OLD
         SPACE 1                                                   @D10
         LA    R15,MSG3SEG         GET ADDRESS OF BASE SEGMENT     @D17
         ST    R15,OLD3BASE        PUT BASE SEGMENT ADDRESS IN OLD @D17
         TITLE '    ''WHO'' COMMAND - GET TSO USERID'
***********************************************************************
*                                                                     *
*        GET USERID OF TSO USER                                       *
*                                                                     *
*        R2  - ADDRESS OF PSCB                                        *
*                                                                     *
*        WORKREGS -                                                   *
*                                                                     *
***********************************************************************
         SPACE 1
TSOUSER  DS    0H                  WE ARE USING TSO
         MVC   INS1ATXT,KTSU       Show we're a TSO user           @D17
         LA    R15,4+L'KTSU        Get length of user type         @D17
         STH   R15,INS1ALEN        SET LENGTH IN MESSAGE SEGMENT  @KL06
         L     R1,CVTPTR           Get                             @D17
         L     R1,0(,R1)            address                        @D17
         L     R1,4(,R1)             of our TCB                    @D17
         USING TCB,R1              MAKE TCB ADDRESSABLE           @KL03
         L     R1,TCBJSTCB         CHAIN UP TO THE JOB STEP TCB   @KL03
         L     R1,TCBJSCB          POINT TO JSCB                  @KL03
         USING IEZJSCB,R1          ADDRESSABILITY FOR JSCB        @KL03
         L     R2,JSCBPSCB         GET PSCB ADDRESS               @KL03
         USING PSCB,R2             MAKE PSCB ADDRESSABLE
         MVC   INS1BTXT(7),PSCBUSER   SET USERID IN MESSAGE       @KL06
         XR    R15,R15             CLEAR LENGTH REGISTER          @KL06
         IC    R15,PSCBUSRL        GET LENGTH OF USERID           @KL06
         LA    R15,4(,R15)         ADJUST FOR SEGMENT PREFIX      @KL06
         STH   R15,INS1BLEN        SET LENGTH IN MESSAGE SEGMENT  @KL06
         DROP  R1                  END JSCB ADDRESSABILITY        @KL07
         LA    R1,IOPLAREA         POINT TO IOPL                  @KL06
         USING IOPL,R1             MAKE IOPL ADDRESSABLE          @KL06
         L     R15,PSCBUPT         GET UPT ADDRESS                @KL07
         ST    R15,IOPLUPT         SET UPT ADDRESS IN IOPL        @KL06
         L     R14,PSCBRLGB        POINT TO RELOGON BUFFER        @KL07
         USING RLGB,R14            MAKE RELOGON BUFFER ADDRESSABLE@KL07
         L     R15,RLGBECT         GET ECT ADDRESS                @KL07
         ST    R15,IOPLECT         SET ECT ADDRESS IN IOPL        @KL06
         DROP  R14                 END RLGB ADDRESSABILITY        @KL07
         LA    R15,ECB             GET ADDRESS OF ECB             @KL06
         ST    R15,IOPLECB         SET ECB ADDRESS IN IOPL        @KL06
         LA    R15,PUTBLOCK        GET ADDRESS OF PUTLINE PARM BLOCKL06
         ST    R15,IOPLIOPB        SET PARM BLOCK ADDRESS IN IOPL @KL06
         DROP  R1                  END IOPL ADDRESSABILITY        @KL06
         B     BUILDTID            GO BUILD TERMID ID
         SPACE 1
         DROP  R2                  END PSCB ADDRESSABILITY        @KL07
         TITLE '    ''WHO'' COMMAND - BUILD TCAM LINE ADDRESS FOR TSO U*
               SER'
***********************************************************************
*                                                                     *
*        BUILD TERMINAL ID FOR A TSO/TCAM USER                        *
*                                                                     *
*        Workregs = R0, R1, R14, R15.                                 *
*                                                                     *
***********************************************************************
         SPACE 1
BUILDTID DS    0H                  BUILD TERMINAL ID
         MVC   EXTR,MEXTR          Copy model EXTRACT parm list    @D17
         EXTRACT EXTRANS,          Issue EXTRACT macro             @D17+
               MF=(E,EXTR)          to get TJID from system        @D17
         L     R15,CVTPTR          Point to CVT                    @D17
         USING CVT,R15             Addressability for CVT          @D17
         L     R15,CVTTSCVT        Get address of TSCVT            @D17
         USING TSCVT,R15           Addressability for TSCVT        @D17
         L     R1,TSCVTTJB         Point to TJB table              @D17
         LA    R0,TJBEND-TJB       Calculate length of TJB         @D17
         MH    R0,EXTRANS+2         times our TJID                 @D17
         AR    R1,R0                 and point to our TJB          @D17
         DROP  R15                 End TSCVT addressability        @D17
         USING TJB,R1              Addressability for TJB          @D17
         LH    R0,TJBLINE          Get binary line address         @D17
         DROP  R1                  End TJB addressability          @D17
         STH   R0,DBLWORD          Store address in work area      @D17
         UNPK  DBLWORD+3(5),DBLWORD(3) UNPACK THE ADDRESS
         MVC   INS1CTXT,DBLWORD+4  MOVE UNPACKED ADDRESS TO LINE  @KL06
         TR    INS1CTXT,TRT-240    TRANSLATE TO EBCDIC            @KL06
         TITLE '    ''WHO'' COMMAND - BUILD MESSAGE LINE 1'
***********************************************************************
*                                                                     *
*        BUILD MESSAGE LINE 1.                                        *
*                                                                     *
***********************************************************************
         SPACE 1
BUILD1   DS    0H                  BUILD FIRST MESSAGE LINE
         SPACE 1                                                   @D17
*----------------------------------------------------------------* @D17
*        Calculate job name/userid length.                       * @D17
*----------------------------------------------------------------* @D17
         LA    R1,INS1BTXT+L'INS1BTXT                              @D17+
                                   Default for 8 character job name@D17
         TRT   INS1BTXT,BLANKTBL   Calculate                       @D17
         LA    R15,INS1BTXT         length                         @D17
         SR    R1,R15                of job name                   @D17
         LA    R1,4(,R1)              and adjust for prefix        @D17
         STH   R1,INS1BLEN         Set length in message segment   @D17
         SPACE 1                                                   @D17
*----------------------------------------------------------------* @D17
*        Calculate job type length.                              * @D17
*----------------------------------------------------------------* @D17
         LA    R1,L'INS1ATXT                                       @D17
LOOP1    DS    0H                                                  @D17
         LA    R14,INS1ATXT-1(R1)                                  @D17
         CLI   0(R14),C' '                                         @D17
         BNE   DONE1                                               @D17
         BCT   R1,LOOP1                                            @D17
DONE1    DS    0H                                                  @D17
         LA    R1,INS1ATXT-INS1ALEN(,R1)                           @D17
         STH   R1,INS1ALEN         Set length in message segment   @D17
         SPACE 1                                                   @D17
*----------------------------------------------------------------* @D17
*        Calculate terminal ID length.                           * @D17
*----------------------------------------------------------------* @D17
         LA    R1,3                Set terminal ID length = 3      @D17
         LA    R1,4(,R1)           ADJUST FOR SEGMENT PREFIX      @KL06
         STH   R1,INS1CLEN         SET LENGTH IN MESSAGE SEGMENT  @KL06
         TITLE '    ''WHO'' COMMAND - BUILD MESSAGE LINE 2'
***********************************************************************
*                                                                     *
*        BUILD MESSAGE LINE 2.                                        *
*                                                                     *
***********************************************************************
         SPACE 1
BUILD2   DS    0H                  BUILD SECOND MESSAGE LINE
         L     R15,CVTPTR          POINT TO CVT                   @KL05
         USING CVT,R15             ADDRESSABILITY FOR CVT         @KL05
         SPACE 1                                                   @D15
*---------------------------------------------------------------------*
*        Set system type in message.                                  *
*---------------------------------------------------------------------*
         MVC   INS2ATXT(L'KMVT),KMVT  Assume system is MVT         @D17
         LA    R1,L'KMVT+4         Length of token for adjust      @D17
         CLI   CVTDCB,CVT4MS1+CVT4MPS  Is this M65MP?              @D17
         BNE   BUILD2B             Branch if not M65MP             @D17
         MVC   INS2ATXT(L'KMPS),KMPS  Show system is M65MP         @D17
         LA    R1,L'KMPS+4         Length of token for adjust      @D17
BUILD2B  DS    0H
         STH   R1,INS2ALEN         SET LENGTH IN MESSAGE SEGMENT  @KL06
         SPACE 1                                                   @D15
*---------------------------------------------------------------------*
*        Set system name in message.                                  *
*---------------------------------------------------------------------*
         L     R15,CVTSMCA         POINT TO SMCA                  @KL05
         LTR   R15,R15             Is SMCA present?                @D17
         BZ    DOTPUTS             Skip system name if not         @D17
         USING SMCABASE,R15        MAKE SMCA ADDRESSABLE          @KL05
         MVC   INS2BTXT(4),SMCASID MOVE IN SMF SYSTEM ID          @KL06
         LA    R1,4+4              GET LENGTH OF SID              @KL06
         STH   R1,INS2BLEN         SET LENGTH IN MESSAGE SEGMENT  @KL06
         DROP  R15                 END SMCA ADDRESSABILITY        @KL05
         TITLE '    ''WHO'' COMMAND - WRITE MESSAGE LINES TO TERMINAL'
***********************************************************************
*                                                                     *
*        WRITE MESSAGE LINES TO THE TERMINAL.                         *
*                                                                     *
***********************************************************************
         SPACE 1
DOTPUTS  DS    0H                  WRITE LINES TO THE TERMINAL
         SPACE 1                                                   @D10
DOTPUT1  DS    0H                  WRITE LINE 1                    @D10
         XC    ECB,ECB             CLEAR ECB                      @KL06
         PUTLINE OUTPUT=(OLD1,TERM,SINGLE,INFOR),                 @KL08*
               TERMPUT=(EDIT,WAIT,NOHOLD,NOBREAK),                @KL08*
               MF=(E,IOPLAREA)                                    @KL08
         SPACE 1                                                   @D10
DOTPUT2  DS    0H                  WRITE LINE 2                    @D10
         XC    ECB,ECB             CLEAR ECB                      @KL06
         PUTLINE OUTPUT=(OLD2,TERM,SINGLE,INFOR),                 @KL08*
               TERMPUT=(EDIT,WAIT,NOHOLD,NOBREAK),                @KL08*
               MF=(E,IOPLAREA)                                    @KL08
         SPACE 1                                                   @D10
DOTPUT3  DS    0H                  WRITE LINE 3                    @D10
         XC    ECB,ECB             CLEAR ECB                      @KL06
         PUTLINE OUTPUT=(OLD3,TERM,SINGLE,INFOR),                  @D17+
               TERMPUT=(EDIT,WAIT,NOHOLD,NOBREAK),                @KL08*
               MF=(E,IOPLAREA)                                    @KL08
         TITLE '    ''WHO'' COMMAND - EXIT'
***********************************************************************
*                                                                     *
*        FREE WORK AREA AND EXIT.                                     *
*                                                                     *
*        R13 - BASE FOR GETMAINED WORK AREA - FREED                   *
*        R14 - RETURN ADDRESS                                         *
*        R15 - RETURN CODE                                            *
*                                                                     *
*        WORKREGS - R0, R1, R2                                        *
*                                                                     *
***********************************************************************
         SPACE 1
RETURN0  DS    0H                  HERE FOR NORMAL RETURN
         XR    R2,R2               SET RC = 0
         B     RETURN              JOIN COMMON RETURN LOGIN
         SPACE 1
RETURN4  DS    0H                  HERE IF ERROR
         LA    R2,4                SET RC = 4
         B     RETURN              GO TO COMMON RETURN LOGIC
         SPACE 1
RETURN   DS    0H                  JOIN HERE TO EXIT
         LR    R1,R13              GET WORK AREA POINTER FOR FREEMAIN
         LA    R0,LWHOWORK         GET LENGTH OF WORK AREA
         L     R13,SAVEA+4         RESTORE SAVE AREA POINTER
         FREEMAIN R,LV=(0),A=(1)   FREE WORK AREA
         LR    R15,R2              SET RETURN CODE IN R15
         RETURN (14,12),RC=(15)    BACK TO CALLER
         TITLE '    DOW subroutine to find day of week'            @D12
***********************************************************************
*                                                                     *
*                                                                     *
* Subroutine           =  DOW                                         *
*                                                                     *
*   Purpose            =  To find the day of the week given an        *
*                         MVS julian date (year and day of year).     *
*                                                                     *
*   Linkage            =  Via BALR R14,R15                            *
*                                                                     *
*   Comments           =                                              *
*                                                                     *
*       This subroutine uses Zeller's Congruence to determine         *
*       the weekday for a specified MVS julian date.  The basic       *
*       algorithm is:                                                 *
*                                                                     *
*         weekday = dayofyear - 1 + year + 4 + int((year + 3) / 4);   *
*         if (year > 1800)                                            *
*           weekday = weekday - int((year - 1701) / 100);             *
*           weekday = weekday + int((year - 1601) / 400);             *
*         endif                                                       *
*         if (year > 1752)                                            *
*           weekday = weekday + 3;                                    *
*         endif                                                       *
*         weekday = weekday mod 7;                                    *
*         return(weekday);                                            *
*                                                                     *
*       Because the MVS TIME DEC format 0CYYDDDF can't express        *
*       a year before 1900, the tests to handle years prior to        *
*       implementation of the Gregorian calendar can be               *
*       removed.  The resulting algorithm becomes:                    *
*                                                                     *
*         weekday = dayofyear + year                                  *
*                   + int((year + 3) / 4)                             *
*                   - int((year - 1701) / 100)                        *
*                   + int((year - 1601) / 400)                        *
*                   + 6;                                              *
*         weekday = weekday mod 7;                                    *
*         return(weekday);                                            *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
***********************************************************************
*                                                                     *
*                                                                     *
*   Input data         =                                              *
*       R0     = Year YYYY in binary.                                 *
*       R1     = Day of year DDD in binary.                           *
*       R2-9   = Not applicable                                       *
*       R10    = Main program base register                           *
*       R11-14 = Not applicable                                       *
*       R15    = Entry address                                        *
*                                                                     *
*   Registers saved    =  R0 - R15.                                   *
*                                                                     *
*   Register usage     =                                              *
*       R0     = Work register                                        *
*       R1     = Work register                                        *
*       R2     = Year passed by caller                                *
*       R3-13  = Not modified                                         *
*       R14    = Work register                                        *
*       R15    = Work register                                        *
*                                                                     *
*   Registers restored =  R14, R0 - R12.                              *
*                                                                     *
*   Output data        =                                              *
*       R0-14  = Same values as at entry                              *
*       R15    = Index of weekday (0 = Sunday, 1 = Monday, ...)       *
*                                                                     *
*   Exit (normal)      =  Return to caller BR R14.                    *
*     Output           =  Index of day of week in R15.                *
*     Return code      =  Not applicable                              *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,                                                   @D12
***********************************************************************
*                                                                     *
*        DOW:  Subroutine to find the day of the week.                *
*                                                                     *
***********************************************************************
         SPACE 1                                                   @D12
DOW      DS    0H                  Day of week subroutine          @D12
         STM   R14,R12,12(R13)     Save caller's registers         @D16
         LR    R2,R1               Save year in R2                 @D12
         LR    R15,R0              Copy day                        @D12
         AR    R15,R2              Day+Year                        @D12
         SPACE 1                                                   @D12
         LR    R1,R2               Set year in R1                  @D12
         A     R1,=F'3'            Year+3                          @D12
         SRL   R1,2                int((Year+3)/4)                 @D12
         AR    R15,R1              Day+Year+int((Year+3)/4) in R15 @D12
         SPACE 1                                                   @D12
         LR    R0,R2               Set year                        @D12
         SRDL  R0,32                in R1                          @D12
         S     R1,=F'1701'         Year-1701                       @D12
         D     R0,=F'100'          (Year-1701)/100                 @D12
         SR    R15,R1              Day+Year+int((Year/3))/4        @D12+
                                    +int((Year-1701)/100) in R15   @D12
         SPACE 1                                                   @D12
         LR    R0,R2               Set year                        @D12
         SRDL  R0,32                in R1                          @D12
         S     R1,=F'1601'         Year-1601                       @D12
         D     R0,=F'400'          (Year-1601)/400                 @D12
         AR    R15,R1              Day+Year+int((Year/3)/4)        @D12+
                                    -int((Year-1701)/100)          @D12+
                                    +int((Year-1601)/400) in R15   @D12
         SPACE 1                                                   @D12
         A     R15,=F'6'           Day+Year+int((Year/3)/4)        @D12+
                                    +int((Year-1701)/100)          @D12+
                                    +int((Year-1601)/400)          @D16
*                                   +6 in R15                      @D16
         SPACE 1                                                   @D12
         XR    R14,R14             Calculate weekday               @D12
         D     R14,=F'7'            as result mod 7                @D12
         LR    R15,R14             Set weekday in R15              @D12
         L     R14,12(,R13)        Restore return address          @D16
         LM    R0,R12,20(R13)      Restore R0-R12                  @D16
         BR    R14                 Return to caller                @D16
         TITLE '    FINDMDAY subroutine to convert MVS julian date to G+
               regorian month and day'                             @D12
***********************************************************************
*                                                                     *
*                                                                     *
* Subroutine           =  FINDMDAY                                    *
*                                                                     *
*   Purpose            =  To convert MVS julian date (year and day    *
*                         of year) to Gregorian month and day.        *
*                                                                     *
*   Linkage            =  Via BALR R14,R15.                           *
*                                                                     *
*   Comments           =                                              *
*                                                                     *
*       The algorithm used in this routine was adapted from           *
*       an algorithm called "Tableless Date Conversion" in            *
*       Communications of the ACM, Volume 13, Number 10,              *
*       October 1970.  The basic algorithm is:                        *
*                                                                     *
*         if (year is a leap year)                                    *
*           t = 1;                                                    *
*         else                                                        *
*           t = 0;                                                    *
*         endif                                                       *
*         if (dayofyear > (59 + t))                                   *
*           dayofmonth = dayofyear + 2 - t;                           *
*         else                                                        *
*           dayofmonth = dayofyear;                                   *
*         endif                                                       *
*         month = int(((dayofmonth + 91) * 100) / 3055);              *
*         dayofmonth = (dayofmonth + 91) - int((month * 3055) / 100); *
*         month = month - 2;                                          *
*         return(month, dayofmonth);                                  *
*                                                                     *
*       Note that the current implementation of this algorithm        *
*       doesn't include logic to handle centenary years that          *
*       aren't leap years.  While it will work for the 21st           *
*       Century, it will break in 2100.                               *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,                                                   @D12
***********************************************************************
*                                                                     *
*                                                                     *
*   Input data         =                                              *
*       R0     = Year YYYY in binary.                                 *
*       R1     = Day of year DDD in binary.                           *
*       R2-9   = Not applicable                                       *
*       R10    = Main program base register                           *
*       R11-14 = Not applicable                                       *
*       R15    = Entry address                                        *
*                                                                     *
*   Registers saved    =  R0 - R15.                                   *
*                                                                     *
*   Register usage     =                                              *
*       R0     = Work register                                        *
*       R1     = Work register                                        *
*       R2     = Year passed by caller                                *
*       R3-14  = Not modified                                         *
*       R15    = Work register                                        *
*                                                                     *
*   Registers restored =  R2 - R12, R14 - R15.                        *
*                                                                     *
*   Output data        =                                              *
*       R0     = Gregorian day of month in binary                     *
*       R1     = Gregorian month in binary                            *
*       R2-15  = Same values as at entry                              *
*                                                                     *
*   Exit (normal)      =  Return to caller via BR R14.                *
*     Output           =  Gregorian month in R1,                      *
*                         Gregorian day in R0.                        *
*     Return code      =  Not applicable                              *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,                                                   @D12
***********************************************************************
*                                                                     *
*        FINDMDAY:                                                    *
*                                                                     *
*        Subroutine to find Gregorian month and day from              *
*        julian date.                                                 *
*                                                                     *
***********************************************************************
         SPACE 1                                                   @D12
FINDMDAY DS    0H                  Find Gregorian month and day    @D12
         STM   R14,R12,12(R13)     Save caller's registers         @D16
         LR    R2,R0               d = j = day of year in R2       @D12
         XR    R15,R15             Assume it's not a leap year     @D12
         N     R1,=F'3'            Make simple leap year test      @D12
         BNZ   FINDM1              t=0 if not a leap year          @D12
         LA    R15,1                otherwise t=1                  @D12
FINDM1   LA    R1,59(,R15)         (59+t) in R1                    @D12
         CR    R2,R1               Is j>(59+t)?                    @D12
         BNH   FINDM2              Branch if not                   @D12
         A     R2,=F'2'            Otherwise                       @D12
         SR    R2,R15               d=j+2-t in R  2                @D12
FINDM2   A     R2,=F'91'           d+91 in R2                      @D12
         LR    R1,R2                and in R1                      @D12
         M     R0,=F'100'          (d+91)*100 in R0-R1             @D12
         D     R0,=F'3055'         m=int(((d+91)*100)/3055)        @D12
         LR    R15,R1               in R1 and R15                  @D12
         M     R14,=F'3055'        int((m*3055)/100)               @D12
         D     R14,=F'100'          in R15                         @D12
         SR    R2,R15              d=(d+91)-int((m*3055)/100)      @D12+
                                    in R2                          @D12
         BCTR  R1,0                Adjust month                    @D12
         BCTR  R1,0                 to m=m-2                       @D12
         LR    R0,R1               Set day d in R0 for return      @D12
         LR    R1,R2               Set month m in R1 for return    @D12
         LM    R14,R15,12(R13)     Restore R14-R15                 @D16
         LM    R2,R12,28(R13)      Restore R2-R12                  @D16
         BR    R14                 Return to caller                @D16
         TITLE '    ''WHO'' COMMAND - CONSTANTS'
***********************************************************************
*                                                                     *
*        CONSTANTS.                                                   *
*                                                                     *
***********************************************************************
         SPACE 1
         SPACE 1
BLANKS   DC    CL8' '                                             @KL05
KMVT     DC    C'OS/360 MVT'       Text for MVT system             @D17
KMPS     DC    C'OS/360 MPS'       Text for MPS system             @D17
         SPACE 1
KTSU     DC    CL12'TSO user'      Insert text for "TSO USER"      @D17
         SPACE 1                                                   @D17
MEXTR#   EXTRACT FIELDS=(TJID),MF=L Model EXTRACT parameter list   @D17
MEXTR    EQU   MEXTR#,*-MEXTR#     Alias with length               @D17
         SPACE 1
TPIC     DC    X'F02120204B20204B2020'  EDIT PICTURE FOR TIME
TRT      DC    CL16'0123456789ABCDEF'   HEX-TO-CHAR TRANSLATE TABLE
         SPACE 1
DAYOFWK  DS    0F                  DAY-OF-WEEK TABLE               @D12
         DC    AL2(4+6),AL2(OFFS3A),CL9'Sunday'                    @D17
DAYOFWKL EQU   *-DAYOFWK                                           @D12
         DC    AL2(4+6),AL2(OFFS3A),CL9'Monday'                    @D17
         DC    AL2(4+7),AL2(OFFS3A),CL9'Tuesday'                   @D12
         DC    AL2(4+9),AL2(OFFS3A),CL9'Wednesday'                 @D17
         DC    AL2(4+8),AL2(OFFS3A),CL9'Thursday'                  @D17
         DC    AL2(4+6),AL2(OFFS3A),CL9'Friday'                    @D17
         DC    AL2(4+8),AL2(OFFS3A),CL9'Saturday'                  @D17
         TITLE '    ''WHO'' COMMAND - MODELS FOR MESSAGE LINES'
***********************************************************************
*                                                                     *
*        MODEL FOR TERMINAL MESSAGE LINES.                            *
*                                                                     *
***********************************************************************
         SPACE 1
*------- BASE SEGMENT FOR MESSAGE LINE 1 -----------------------------*
MSG1SEG  DS    0F                                                 @KL06
         DC    Y(4+LMSG1)          LENGTH OF OUTPUT LINE          @KL06
         DC    Y(0)                RESERVED                       @KL06
MSG1     DC    C' You are '                                       @KL06
OFFS1A   EQU   *-MSG1                                             @KL06
         DC    C' '                                                @D17
OFFS1B   EQU   *-MSG1                                             @KL06
         DC    C' at terminal '                                    @D17
OFFS1C   EQU   *-MSG1                                             @KL06
LMSG1    EQU   *-MSG1                                             @KL06
         SPACE 3                                                  @KL06
*------- BASE SEGMENT FOR MESSAGE LINE 2 -----------------------------*
MSG2SEG  DS    0F                                                 @KL06
         DC    Y(4+LMSG2)          LENGTH OF OUTPUT LINE          @KL06
         DC    Y(0)                RESERVED                       @KL06
MSG2     DC    C'   logged on to '                                @KL06
OFFS2A   EQU   *-MSG2                                             @KL06
         DC    C' system '                                         @D17
OFFS2B   EQU   *-MSG2                                             @KL06
LMSG2    EQU   *-MSG2                                             @KL06
         SPACE 3                                                  @KL06
*------- BASE SEGMENT FOR MESSAGE LINE 3 -----------------------------*
MSG3SEG  DS    0F                                                  @D17
         DC    Y(4+LMSG3)          LENGTH OF OUTPUT LINE           @D17
         DC    Y(0)                RESERVED                       @KL06
MSG3     DC    C'   day '               FIRST PART OF LINE 4       @D17
OFFS3A   EQU   *-MSG3                                              @D17
         DC    C' - date '              SECOND PART OF LINE 4     @KL06
OFFS3B   EQU   *-MSG3                                              @D17
         DC    C' - time '                                        @KL06
OFFS3C   EQU   *-MSG3                                              @D17
LMSG3    EQU   *-MSG3                                              @D17
         EJECT                                                    @KL06
***********************************************************************
*                                                                     *
*        Translate table to find first blank character in string.     *
*                                                                     *
***********************************************************************
         SPACE 1
BLANKTBL DS    0XL256                                             @KL06
         DC    256X'00'                                           @KL06
         ORG   BLANKTBL+C' '                                      @KL06
         DC    C' '                                               @KL06
         ORG   ,                                                  @KL06
         TITLE '    ''WHO'' COMMAND - GETMAINED WORK AREA'
***********************************************************************
*                                                                     *
*        WORK AREA.                                                   *
*                                                                     *
***********************************************************************
         SPACE 1
WHOWORK  DSECT                     WORK AREA
SAVEA    DS    9D                  PROGRAM SAVE AREA
DBLWORD  DS    D                   WORK AREA FOR CVB/CVD
ECB      DS    A                   ECB FOR I/O SERVICE ROUTINE    @KL06
IOPLAREA DC    4F'0'               SPACE FOR IOPL                 @KL06
PUTBLOCK PUTLINE MF=L              BUILD PUTLINE PARAMETER BLOCK  @KL06
USERID   DS    D                   TSO/VAM USER ID (FIRST 7 BYTES)
USERIDL  EQU   USERID+7,2          LENGTH OF USERID
         SPACE 1
         DS    0F                  Force fullword alignment        @D17
EXTR     DS    CL(L'MEXTR)         Area for EXTRACT parm list      @D17
         SPACE 1                                                   @D17
EXTRANS  DS    0F                  EXTRACT answer area
EXTTJID  DS    F                   -- TJID                         @D17
         SPACE 1                                                   @D17
STIME    DS    F                   WORK AREA FOR TIME
TWORK    DS    CL10                EDIT WORK AREA FOR TIME
         SPACE 1
         EJECT
***********************************************************************
*                                                                     *
*        INSERT MESSAGE SEGMENTS FOR LINE 1.                          *
*                                                                     *
***********************************************************************
         SPACE 1
*------- LINE 1 INSERT A:  USER TYPE ---------------------------------*
INSERT1A DS    0F                  INSERT SEGMENT FOR USER TYPE   @KL06
INS1ALEN DS    Y(4+LINS1A)         LENGTH OF INSERT SEGMENT       @KL06
INS1AOFF DS    Y(OFFS1A)           OFFSET FOR INSERT              @KL06
*NS1ATXT DS    CL9                 TEXT OF INSERT                 @KL06
INS1ATXT DS    CL12                Text of insert                  @D17
LINS1A   EQU   *-INS1ATXT          SYMBOLIC LENGTH OF TEXT        @KL06
         SPACE 1
*------- LINE 1 INSERT B:  USERID ------------------------------------*
INSERT1B DS    0F                  INSERT SEGMENT FOR USERID      @KL06
INS1BLEN DS    Y(4+LINS1B)         LENGTH OF INSERT SEGMENT       @KL06
INS1BOFF DS    Y(OFFS1B)           OFFSET FOR INSERT              @KL06
INS1BTXT DS    CL8                 TEXT OF INSERT                  @D17
LINS1B   EQU   *-INS1BTXT          SYMBOLIC LENGTH OF TEXT        @KL06
         SPACE 1
*------- LINE 1 INSERT C:  TERMINAL ID -------------------------------*
INSERT1C DS    0F                  INSERT SEGMENT FOR TERMID      @KL06
INS1CLEN DS    Y(4+LINS1C)         LENGTH OF INSERT SEGMENT       @KL06
INS1COFF DS    Y(OFFS1C)           OFFSET FOR INSERT              @KL06
INS1CTXT DS    CL8                 TEXT OF INSERT                 @KL06
LINS1C   EQU   *-INS1CTXT          SYMBOLIC LENGTH OF TEXT        @KL06
         EJECT
***********************************************************************
*                                                                     *
*        INSERT MESSAGE SEGMENTS FOR LINE 2.                          *
*                                                                     *
***********************************************************************
         SPACE 1
*------- LINE 2 INSERT A:  OS VERSION --------------------------------*
INSERT2A DS    0F                  INSERT SEGMENT FOR OS VERSION  @KL06
INS2ALEN DS    Y(4+LINS2A)         LENGTH OF INSERT SEGMENT       @KL06
INS2AOFF DS    Y(OFFS2A)           OFFSET FOR INSERT              @KL06
INS2ATXT DS    C'OS/360 MPS'       TEXT OF INSERT                  @D17
LINS2A   EQU   *-INS2ATXT          SYMBOLIC LENGTH OF TEXT        @KL06
         SPACE 1
*------- LINE 2 INSERT B:  SMF SYSTEM ID -----------------------------*
INSERT2B DS    0F                  INSERT SEGMENT FOR SYSTEM ID   @KL06
INS2BLEN DS    Y(4+LINS2B)         LENGTH OF INSERT SEGMENT       @KL06
INS2BOFF DS    Y(OFFS2B)           OFFSET FOR INSERT              @KL06
INS2BTXT DS    C'S381'             TEXT OF INSERT                 @KL06
LINS2B   EQU   *-INS2BTXT          SYMBOLIC LENGTH OF TEXT        @KL06
         EJECT ,                                                   @D10
***********************************************************************
*                                                                     *
*        INSERT MESSAGE SEGMENTS FOR LINE 4.                          *
*                                                                     *
***********************************************************************
         SPACE 1
*------- LINE 4 INSERT B:  DATE --------------------------------------*
INSERT4B DS    0F                  INSERT SEGMENT FOR DATE         @D10
INS3BLEN DS    Y(4+LINS3B)         LENGTH OF INSERT SEGMENT        @D17
INS3BOFF DS    Y(OFFS3B)           OFFSET FOR INSERT               @D17
INS3BTXT DS    0CL10               TEXT OF INSERT - DATE           @D17
WYEAR    DS    C'YYYY'               YEAR                          @D12
INS3BDL1 DS    C'/'                  DELIMITER                     @D17
WMONTH   DS    C'MM'                 MONTH                         @D12
INS3BDL2 DS    C'/'                  DELIMITER                     @D17
WDAY     DS    C'DD'                 DAY                           @D12
LINS3B   EQU   *-INS3BTXT          SYMBOLIC LENGTH OF TEXT         @D17
         SPACE 1
*------- LINE 4 INSERT C:  TIME --------------------------------------*
INSERT4C DS    0F                  INSERT SEGMENT FOR TIME         @D10
INS3CLEN DS    Y(4+LINS3C)         LENGTH OF INSERT SEGMENT        @D17
INS3COFF DS    Y(OFFS3C)           OFFSET FOR INSERT               @D17
INS3CTXT DS    CL8                 TEXT OF INSERT - TIME           @D17
LINS3C   EQU   *-INS3CTXT          SYMBOLIC LENGTH OF TEXT         @D17
         EJECT
***********************************************************************
*                                                                     *
*        OUTPUT LINE DESCRIPTORS (OLD).                               *
*                                                                     *
***********************************************************************
         SPACE 1
*------- OLD FOR MESSAGE LINE 1 --------------------------------------*
OLD1     DS    0F                  OLD FOR LINE 1
OLD1NUMB DS    A(OLD1SEG)          NUMBER OF TEXT SEGMENTS
OLD1BASE DS    A(MSG1SEG)          POINTER TO TEXT SEGMENT
OLD1A    DS    A(INSERT1A)         POINTER TO TEXT SEGMENT
OLD1B    DS    A(INSERT1B)         POINTER TO TEXT SEGMENT
OLD1C    DS    A(INSERT1C)         POINTER TO TEXT SEGMENT
OLD1SEG  EQU   (*-OLD1BASE)/4      SYMBOLIC NUMBER OF SEGMENTS
         SPACE 1
*------- OLD FOR MESSAGE LINE 2 --------------------------------------*
OLD2     DS    0F                  OLD FOR LINE 2
OLD2NUMB DS    A(OLD2SEG)          NUMBER OF TEXT SEGMENTS
OLD2BASE DS    A(MSG2SEG)          POINTER TO TEXT SEGMENT
OLD2A    DS    A(INSERT2A)         POINTER TO TEXT SEGMENT
OLD2B    DS    A(INSERT2B)         POINTER TO TEXT SEGMENT
OLD2SEG  EQU   (*-OLD2BASE)/4      SYMBOLIC NUMBER OF SEGMENTS
         SPACE 1                                                   @D10
*------- OLD FOR MESSAGE LINE 3 --------------------------------------*
OLD3     DS    0F                  OLD FOR LINE 3                  @D17
OLD3NUMB DS    A(OLD3SEG)          NUMBER OF TEXT SEGMENTS         @D17
OLD3BASE DS    A(MSG3SEG)          POINTER TO TEXT SEGMENT         @D17
OLD3A    DS    A(DAYOFWK)          POINTER TO TEXT SEGMENT         @D17
OLD3B    DS    A(INSERT4B)         POINTER TO TEXT SEGMENT         @D17
OLD3C    DS    A(INSERT4C)         POINTER TO TEXT SEGMENT         @D17
OLD3SEG  EQU   (*-OLD3BASE)/4      SYMBOLIC NUMBER OF SEGMENTS     @D17
LWHOWORK EQU   *-WHOWORK                LENGTH OF WORK AREA
         SPACE 1                                                   @D12
         DROP  ,                   END ALL ADDRESSABILITY          @D12
         PRINT NOGEN
         TITLE '    ''WHO'' COMMAND FOR TSO - OS COMMUNICATION VECTOR T*
               ABLE (CVT)'
***********************************************************************
*                                                                     *
*        OS SYSTEM MANAGEMENT FACILITIES CONTROL AREA (SMCA).         *
*                                                                     *
***********************************************************************
         SPACE 1
*        IEESMCA
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 01400020
*                                                                     * 01600020
*             SYSTEM MANAGEMENT FACILITIES CONTROL TABLE              * 01800020
*                                                                     * 02000020
*                            S  M  C  A                               * 02200020
*                                                                     * 02400020
*   RELEASE 21, 06/28/71, LEVEL=1                                     * 02450021
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 02600020
*                                                                       02800020
*                   THIS TABLE IS LOCATED IN SQS-SUBPOOL 255            03000020
*                    AND IS POINTED TO BY CVTSMCA                       03200020
*                                                                       03400020
         SPACE 1                                                        03600020
SMCABASE DSECT                                                          03800020
         SPACE 1                                                        04000020
         IEZBITS , -          SYMBOLIC BIT DEFINITIONS                  04050020
         SPACE 1                                                        04100020
SMCAOPT  DS    B -            SMF OPTIONS SELECTED                      04200020
*                             SET AT INITIALIZATION TIME                04400020
SMCAOPT1 EQU   BIT0 -         JOB ACCOUNTING                            04600020
SMCAOPT2 EQU   BIT1 -         STEP ACCOUNTING                           04800020
SMCAEXT  EQU   BIT2 -         DYNAMIC EXITS                             05000020
SMCADSA  EQU   BIT3 -         DATASET ACCOUNTING                  19028 05200020
SMCAVOL  EQU   BIT4 -         VOLUME ACCOUNTING                   19028 05400020
SMCAESV  EQU   BIT5 -         ESV ACCOUNTING                      19028 05600020
SMCATDS  EQU   BIT6 -         TEMPORARY DATA SETS                 19028 05800020
SMCAFGND EQU   BIT7 -         SMF FOREGROUND OPTS BIT             20011 06400020
*                             ZERO- ABOVE BITS DESCRIBE           20011 06600020
*                                   BACKGROUND OPTIONS            20011 06800020
*                             ONE - ABOVE BITS DESCRIBE           20011 07400020
*                                   FOREGROUND OPTIONS            20011 07600020
SMCAMISC DS    B -            MISCELLANEOUS INDICATORS                  08400020
SMCAUSER EQU   BIT0 -         SMF RECORDING REQUESTED                   08600020
SMCAMAN  EQU   BIT1 -         SYS1.MAN DATA SET PRESENT                 08800020
*                             BITS 0 AND 1 MEAN                         09000020
*                             00 - NO RECORDING                         09200020
*                             01 - USER RECORD ONLY                     09400020
*                             10 - INVALID COMBINATION                  09600020
*                             11 - SMF AND USER RECORDING               09800020
SMCAOPI  EQU   BIT2 -         OPI = YES INDICATOR                 20011 10000020
SMCAFIRT EQU   BIT3 -         INDICATES PRIMARY TO BE OPENED            10200020
SMCAPSDP EQU   BIT4 -         PSEUDO-DUMP SWITCH,                       10400020
*                             (DEVICE SWITCHING ONLY)                   10600020
SMCADBSY EQU   BIT5 -         DUMP BUSY - USED BY WRITER ONLY           10800020
SMCABSW  EQU   BIT6 -         BUFFER SWITCH                             11000020
*                             0 - LEFT HALF, 1 - RIGHT HALF             11200020
SMCADUMP EQU   BIT7 -         DUMP BUSY                                 11600020
SMCATOFF DS    H -            SMF TIOT OFFSET FROM BEGINNING OF         12000020
*                             MASTER SCHEDULER TIOT                     12200020
SMCATIOT DS    A -            POINTER TO MASTER SCHEDULER TIOT          12400020
*                                                                       12800020
* THE FOLLOWING FIELDS ARE SET UP BY IPL INITIALIZATION                 13000020
*                                                                       13200020
SMCAJWT  DS    F -            JOB WAIT TIME LIMIT - IN 26 USEC          13400020
*                             TIMER UNITS                               13600020
SMCABUF  DS    0F -           SMF BUFFER SIZE - IN BYTES                13800020
*                             AT INITIALIZATION, IT CONTAINS BUF=VALUE  14000020
SMCABSIZ DS    F -            AFTER IPL, IT CONTAINS THE BUFFER         14200020
*                             WORKING SIZE                              14250020
SMCASID  DS    CL2 -          SYSTEM IDENTIFICATION                     14400020
SMCAMDL  DS    CL2 -          CPU MODEL NUMBER                          14600020
SMCABUFP DS    A -            SMF STARTING BUFFER CORE POINTER          14800020
*                                                                       15200020
* SMF DEVICE CHARACTERISTICS                                            15400020
*                                                                       15600020
*  PRIMARY OR CURRENT RECORDING DEVICE                                  15800020
*                                                                       16000020
SMCAPDEV DS    CL6 -          VOLUME SERIAL NUMBER                      16200020
SMCAPSTA DS    B -            DEVICE STATUS                             16400020
SMCAPNAV EQU   BIT0 -         DATASET NOT AVAILABLE                     16600020
SMCAPTAP EQU   BIT1 -         TAPE DEVICE                               16800020
SMCAPDA  EQU   BIT2 -         DIRECT ACCESS DEVICE                      17000020
SMCAPMTY EQU   BIT3 -         DATASET EMPTY SWITCH                      17200020
SMCAMOD  EQU   BIT4 -         OPEN MOD INDICATOR                        17400020
SMCAPUNT EQU   BIT6 -         DEVICE ADDRESS IS DEFINED                 17600020
SMCAPVOL EQU   BIT7 -         VOLUME SERIAL NO. IS DEFINED              17800020
SMCAPDAR DS    CL3 -          DEVICE ADDRESS - IN EBCDIC                18000020
SMCAPLBL DS    B -            LABEL STATUS                              18200020
*                             BIT 0-4 - RESERVED                        18400020
SMCAPNSL EQU   BIT5 -         NON-STANDARD LABEL (NSL)                  18600020
SMCAPSL  EQU   BIT6 -         STANDARD LABEL (SL)                       18800020
SMCAPNL  EQU   BIT7 -         NO LABEL (NL)                             19000020
SMCAXORY DS    C -            EBCDIC X OR Y CORRESPONDING TO DATA SET   19200020
*                             THAT IS TO RECEIVE THIS ENTRY             19250020
SMCAPDCB DS    A -            POINTER TO PRIME DCB                      19400020
*                                                                       19600020
* ALTERNATE OR OTHER DEVICE                                             19800020
*                                                                       20000020
SMCAADEV DS    CL6 -          VOLUME SERIAL NUMBER                      20200020
SMCASTA  DS    B -            DEVICE STATUS                             20400020
SMCAADAR DS    CL3 -          DEVICE ADDRESS                            20600020
SMCAALBL DS    B -            LABEL STATUS                              20800020
SMCAYORX DS    C -            EBCDIC X OR Y CORRESPONDING TO DATA SET   20850020
*                             THAT IS TO RECEIVE THIS ENTRY             20900020
SMCAADCB DS    A -            POINTER TO ALTERNATE DCB                  21200020
*                                                                       21400020
* SMF ECB'S                                                             21600020
*                                                                       21800020
SMCAWECB DS    CL4 -          WRITE REQUEST ECB.  WAITED UPON BY THE    22000020
*                             SMF WRITER.  POSTED BY IGC0008C WHEN A    22200020
*                             WRITE IS REQUESTED.                       22400020
SMCABECB DS    CL4 -          BUFFER ECB                                22800020
SMCASGWR DS    F -            COUNT OF RECORD SEGMENTS TO BE WRITTEN    23200020
SMCASGFT DS    F -            COUNT OF RECORD SEGMENTS THAT FIT IN      23400020
*                             DATA SET                                  23450020
*                                                                       23800020
* MISCELLANEOUS POINTERS AND COMMUNICATION AREAS                        24000020
*                                                                       24200020
SMCAWAIT DS    2F -           6 HOUR SYSTEM WAIT TIME FROM SUPERVISOR   24400020
*                             IN 26 USEC TIMER UNITS.  FIRST WORD IS    24600020
*                             OVERFLOW FROM SECOND WORD                 24800020
SMCAENTY DS    0CL2 -         THESE SWITCHES GOVERN ENTRY CONDITIONS    25000020
*                             FOR DEVICE SWITCHING/ALLOCATION/          25050020
*                             OPENING ROUTINES                          25100020
SMCAENDI DS    B -            A COMMUNICATION FIELD                     25200020
SMCADSNF EQU   BIT7 -         IF ZERO, DATA SET (X OR Y) WAS FOUND.     25250020
*                             IF ONE, DATA SET (X OR Y) WAS NOT FOUND.  25300020
SMCAENOP DS    C -            ENTRY CODE THAT INDICATES WHICH LOAD OF   25400020
*                             SVC 83 HAS PASSED CONTROL TO CURRENT LOAD 25450020
SMCAFOPT DS    B -            SMF OPTIONS IN TSO/SMF FOREGROUND.  20011 25600020
*                             BIT SETTINGS ARE SAME AS SMCAOPT.   20011 25800020
SMCAENAL DS    X -            *                                         26200020
SMCAWRTP DS    F -            OPTIMUM BUFFER WRITE POINT                26400020
*                                                                       26800020
* XCTL REMOTE LIST USED BY SVC 83                                       27000020
*                                                                       27200020
SMCAXCTL DS    A -            POINTER TO XCTL NAME                      27400020
         DS    A -            DCB POINTER (ALWAYS ZERO)                 27600020
SMCAXNAM DS    CL8 -          XCTL NAME                                 27800020
SMCASWA  DS    B -            SWITCHES                                  28000020
SMCASWAR EQU   BIT0 -         RESERVED                            19028 28200020
SMCADSTR EQU   BIT1 -         DISASTER BIT                        19028 28400020
SMCAOPFL EQU   BIT2 -         SMF DATASET OPEN FAILURE            19028 28600020
SMCANADA EQU   BIT3 -         NEXT ALLOCATION MUST BE DIRECT      19028 28800020
*                             ACCESS                              19028 28850020
SMCANAVL EQU   BIT4 -         NEXT ALLOCATION MUST BE BY VOLUME   19028 29000020
*                             SERIAL                              19028 29050020
SMCAZEOD EQU   BIT5 -         HALT EOD BIT                        19028 29200020
SMCADSSP EQU   BIT6 -         DATASET SPACE CHECK BIT             19028 29400020
SMCADSSW EQU   BIT7 -         DATASET SWITCH BIT                  19028 29600020
SMCASWB  DS    B -            SPARE                                     29800020
SMCASWC  DS    B -            SPARE                                     30000020
SMCASWD  DS    B -            SPARE                                     30200020
SMCADSTM DS    CL8 -          TIME OF DISASTER                          30400020
SMCADSCT DS    F -            COUNT OF LOST RECORDS                     30600020
SMCAPOST DS    H -            RESERVED                            20011 30800020
SMCATJID DS    CL2 -          CURRENT TASK TJID                   20011 31000020
SMCAEND  EQU   *                                                        31200020
SMCASIZE EQU   SMCAEND-SMCABASE - SIZE OF SMCA TABLE                    31400020
TDEVSIZE EQU   SMCAADEV-SMCAPDEV - SIZE OF DEVICE ENTRY                 31600020
         TITLE '    ''WHO'' COMMAND FOR TSO - OS COMMUNICATION VECTOR T*
               ABLE (CVT)'
***********************************************************************
*                                                                     *
*        OS COMMUNICATION VECTOR TABLE (CVT).                         *
*                                                                     *
***********************************************************************
         SPACE 1
CVT      DSECT ,                                                   @D17
         CVT   ,                                                   @D17
         TITLE '    ''WHO'' COMMAND FOR TSO - TSO Terminal Job Block (T+
               JB)'
****************************************************************** @D17
*                                                                * @D17
*        TSO Terminal Job Block (TJB).                           * @D17
*                                                                * @D17
****************************************************************** @D17
         SPACE 1                                                   @D17
         PRINT GEN                                                 @D17
         IKJTJB ,                                                  @D17
         TITLE '    ''WHO'' COMMAND FOR TSO - OS COMMAND SCHEDULING CON*
               TROL BLOCK (CSCB)'
***********************************************************************
*                                                                     *
*        OS COMMAND SCHEDULING CONTROL BLOCK (CSCB).                  *
*                                                                     *
***********************************************************************
         SPACE 1
CSCB     DSECT
         IEECHAIN
         TITLE '    ''WHO'' COMMAND FOR TSO - OS TASK CONTROL BLOCK (TC*
               B'
***********************************************************************
*                                                                     *
*        OS TASK CONTROL BLOCK (TCB).                                 *
*                                                                     *
***********************************************************************
         SPACE 1
         IKJTCB
         TITLE '    ''WHO'' COMMAND FOR TSO - OS JOB STEP CONTROL BLOCK*
                (JSCB)'                                           @KL03
***********************************************************************
*                                                                     *
*        OS JOB STEP CONTROL BLOCK (JSCB).                            *
*                                                                     *
***********************************************************************
         SPACE 1                                                  @KL03
         IEZJSCB                                                  @KL03
         TITLE '    ''WHO'' COMMAND FOR TSO - TSO Communications Vector+
                Table (TSCVT)'                                     @D17
****************************************************************** @D17
*                                                                * @D17
*        TSO Communications Vector Table (TSCVT).                * @D17
*                                                                * @D17
****************************************************************** @D17
         SPACE 1                                                   @D17
         IKJTSCVT ,                                                @D17
         TITLE '    ''WHO'' COMMAND FOR TSO - TSO COMMAND PROCESSOR PAR*
               AMETER LIST (CPPL)'
***********************************************************************
*                                                                     *
*        TSO COMMAND PROCESSOR PARAMETER LIST (CPPL).                 *
*                                                                     *
***********************************************************************
         SPACE 1
         IKJCPPL
         TITLE '    ''WHO'' COMMAND FOR TSO - TSO I/O PARAMETER LIST (I*
               OPL)'
***********************************************************************
*                                                                     *
*        TSO I/O PARAMETER LIST (IOPL).                               *
*                                                                     *
***********************************************************************
         SPACE 1
         IKJIOPL
         TITLE '    ''WHO'' COMMAND FOR TSO - TSO PROTECTED STEP CONTRO*
               L BLOCK (PSCB)'
***********************************************************************
*                                                                     *
*        TSO PROTECTED STEP CONTROL BLOCK (PSCB).                     *
*                                                                     *
***********************************************************************
         SPACE 1
         IKJPSCB
         TITLE '    ''WHO'' COMMAND FOR TSO - TSO RELOGON BUFFER (RLGB)*
               '                                                  @KL07
***********************************************************************
*                                                                     *
*        TSO RELOGON BUFFER (RLGB).                                   *
*                                                                     *
***********************************************************************
         SPACE 1
         IKJRLGB DSECT=YES,PREFIX=RLGB                            @KL07
         END
//*
//LKED   EXEC PGM=IEWL,PARM=(XREF,LET,LIST,NCAL,RENT,REUS,REFR),
//            REGION=128K,COND=(4,LT,ASM)
//SYSLMOD  DD DISP=SHR,DSN=SYS2.LINKLIB
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1024,(50,20))
//SYSPRINT DD SYSOUT=A
//SYSLIN   DD DSN=&&OBJSET,DISP=(OLD,DELETE)
//        DD *
 NAME WHO(R)
//
