//G09REBLD JOB ASP,'G09REBUILD-REBULD',MSGLEVEL=(1,1),CLASS=A
//*********************************************************************
//*                                                                 ***
//*    Job:      G09REBUILD                                         ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  Build ASP distribution libraries                   ***
//*              ASP.PSGLIB, ASP.MAC320 and ASP.SOURCE              ***
//*              from ASPV32 tape.                                  ***
//*    Update:   2006/08/18                                         ***
//*                                                                 ***
//*********************************************************************
//*
//REBULD PROC SER=,DSN=,FILE=,SPACE=,DISP=,
//            DISK=3330,TAPE=TAPE,SOUT=DUMMY
//*
//*    SER=  VOLID OF OUTPUT DISK
//*    DSN=  DSNAME OF OUTPUT DATASET
//*    FILE= FILE NUMBER OF INPUT TAPE FILE
//*    SPACE=SPACE FOR DSN DATASET IN THE FORM '(CYL,(X,Y,Z))'
//*    DISP= FINAL DISPOSITION FOR DSN DATASET  (I.E. DISP=KEEP)
//*    DISK= SYMBOLIC NAME OR ADDRESS OF DISK DRIVE
//*    TAPE= SYMBOLIC NAME OR ADDRESS OF TAPE DRIVE
//*    SOUT= SYSOUT PARAMETER FOR SYSPRINT (I.E. SOUT='SYSOUT=A')
//*          CAN ALSO BE SPECIFIED AS:
//*           SOUT='DSN=SOUT,UNIT=TAPE9,DISP=(OLD),LABEL=(1,NL)'
//*
//STEP1 EXEC PGM=IEBUPDTE,PARM=NEW
//SYSPRINT DD &SOUT,
//            SPACE=(CYL,(10,5))
//SYSUT2   DD DSN=&DSN,
//            UNIT=&DISK,
//            VOL=SER=&SER,
//            DISP=(&DISP),
//            SPACE=&SPACE,
//            DCB=(RECFM=FB,LRECL=80,BLKSIZE=3360)
//SYSIN    DD DSN=DSN&FILE,
//            UNIT=&TAPE, UNIT=(&TAPE,,DEFER),
//            VOL=(,RETAIN,SER=ASPV32),
//            LABEL=(&FILE,NL),
//            DISP=(OLD,KEEP),
//            DCB=(RECFM=FB,LRECL=80,BLKSIZE=8000)
//       PEND
//PSGLIB EXEC PROC=REBULD,SER=ASPSUP,DSN='ASP.PSGLIB',
//            FILE=8,SPACE='(CYL,(6,,10))',DISP='OLD'
//MAC320 EXEC PROC=REBULD,SER=ASPSUP,DSN='ASP.MAC320',
//            FILE=9,SPACE='(CYL,(15,,25))',DISP='OLD'
//SOURCE EXEC PROC=REBULD,SER=ASPSUP,DSN='ASP.SOURCE',
//            FILE=10,SPACE='(CYL,(70,,25))',DISP='OLD'
//
