//G14PREM  JOB 1,'G14PREGEN-MVT',REGION=150K,MSGLEVEL=(1,1),CLASS=A
//*********************************************************************
//*                                                                 ***
//*    Job:      G14PREGEN-MVT                                      ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  ASP pre-sysgen job for MVT.                        ***
//*    Update:   2006/08/18                                         ***
//*                                                                 ***
//*********************************************************************
//*
//******************************************************************************
//* ASP 3.2   PREGEN JOB FOR MVT REL 21.6 , 21.7 AND 21.8                      *
//******************************************************************************
//*
//******************************************************************************
//* NOTE1 - APPLICABLE TO PRE MVT 21.8 RELEASES                                *
//*      BEFORE RUNNING THE PREGEN JOB CHANGE THE FOLLOWING SEQUENCE NUMBERS   *
//*      IN MACRO SGIEC202: PREGEN JOB IS SET UP FOR REL 21.8.                 *
//*       SEQUENCE NUMBER 11286321 MUST BE 11140000 FOR PRE 21.8 GENS          *
//*       SEQUENCE NUMBER 11286322 MUST BE 11150017 FOR PRE 21.8 GENS          *
//*----------------------------------------------------------------------------*
//* NOTE2 - APPLICABLE TO POSTGEN PROCESSING (MODULE IFG0552X)                 *
//*     THE POSTGEN JOB WILL LINKEDIT A SPECIAL VERSION OF MODULE IFG0552X     *
//*     INTO SYS1.SVCLIB,THUS REPLACING THE SUPPLIED MODULE. A SUBSEQUENT ASP  *
//*     SUPERZAP WILL THEN MODIFY THIS MODULE. IF REL 21.8 WITHOUT OS PTF      *
//*     5591 IS BEING INSTALLED,THE POSTGEN JOB MAY BE RUN AS IS. OTHERWISE,   *
//*     IF REL 21.8 WITH OS PTF 5591 OR PRE REL 21.8 SYSTEMS ARE BEING         *
//*     INSTALLED,ALTER THE POSTGEN JOB AS FOLLOWS:                            *
//*       1)  DELETE STEP R21LEOV FROM POSTGEN JCL. STEP CONTAINS 6 STATEMENTS *
//*           HAVING 'EOV' IN POSITIONS 78-80.                                 *
//*       2)  DELETE SYSIN DATA TO STEP R21LEOV FROM POSTGEN JOB.SYSIN         *
//*           DATA AND DELIMITER COMPRISES 24 STATEMENTS.THE FIRST AND LAST    *
//*           STATEMENTS HAVE 'EOV' IN POSITIONS 78-80.                        *
//******************************************************************************
//*
//******************************************************************************
//*      THE JOB STEPS ARE AS FOLLOWS :                                        *
//* STEP0 - Compresses SYS1.GENLIB, SYS1.MODGEN and SYS1.MODGEN2               *
//* STEP1 - UPDATES MACROS FROM SYS1.GENLIB                                    *
//* STEP2 - UPDATES MACROS FROM SYS1.MODGEN                                    *
//* STEP3 - UPDATES MACROS FROM SYS1.MODGEN2                                   *
//* STEP4 - Compresses SYS1.GENLIB, SYS1.MODGEN and SYS1.MODGEN2               *
//* STEP5 - LINKEDITS THE MODULE 'ASPSVC',A TYPE ONE SVC,INTO SYS1.ASP         *
//******************************************************************************
//*      THE SYMBOLIC PARAMETERS REPRESENT THE FOLLOWING :                     *
//* DLIB    - VOLSER OF VOLUME CONTAINING SYSGEN MACROS                        *
//* DLUNIT  - UNIT TYPE OF DLIB VOLUME                                         *
//* ASPVOL  - VOLSER OF VOLUME FOR ALLOCATING ASP DATA SETS                    *
//* DAUNIT  - UNIT TYPE OF ASPVOL                                              *
//* MODGEN2 - NAME OF DATA SET CONTAINING NIP MACRO                            *
//* OUTCLAS - THE CLASS TO WHICH THE SYSOUT INFORMATION IS TO BE DIRECTED      *
//******************************************************************************
//*
//PREGEN PROC DLIB=ASPDLB,DLUNIT=3330,ASPVOL=,DAUNIT=3330,
// MODGEN2=MODGEN2,
// OUTCLAS=A
//*
//STEP0   EXEC PGM=IEBCOPY
//SYSUT3   DD UNIT=SYSDA,SPACE=(CYL,10)
//SYSUT4   DD UNIT=SYSDA,SPACE=(CYL,10)
//GENLIB   DD DSN=SYS1.GENLIB,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//MODGEN   DD DSN=SYS1.MODGEN,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//MODGEN2  DD DSN=SYS1.&MODGEN2,DISP=SHR,UNIT=&DLUNIT,VOL=SER=&DLIB
//SYSPRINT DD SYSOUT=&OUTCLAS
//*
//STEP1   EXEC PGM=IEBUPDTE
//SYSUT1   DD DSN=SYS1.GENLIB,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//SYSUT2   DD DSN=SYS1.GENLIB,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//SYSPRINT DD SYSOUT=&OUTCLAS
//*
//STEP2   EXEC PGM=IEBUPDTE
//SYSUT1   DD DSN=SYS1.MODGEN,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//SYSUT2   DD DSN=SYS1.MODGEN,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//SYSPRINT DD SYSOUT=&OUTCLAS
//*
//STEP3   EXEC PGM=IEBUPDTE
//SYSUT1   DD DSN=SYS1.&MODGEN2,DISP=SHR,UNIT=&DLUNIT,VOL=SER=&DLIB
//SYSUT2   DD DSN=SYS1.&MODGEN2,DISP=SHR,UNIT=&DLUNIT,VOL=SER=&DLIB
//SYSPRINT DD SYSOUT=&OUTCLAS
//*
//STEP4   EXEC PGM=IEBCOPY,COND=(0,NE)
//SYSUT3   DD UNIT=SYSDA,SPACE=(CYL,10)
//SYSUT4   DD UNIT=SYSDA,SPACE=(CYL,10)
//GENLIB   DD DSN=SYS1.GENLIB,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//MODGEN   DD DSN=SYS1.MODGEN,UNIT=&DLUNIT,DISP=SHR,VOL=SER=&DLIB
//MODGEN2  DD DSN=SYS1.&MODGEN2,DISP=SHR,UNIT=&DLUNIT,VOL=SER=&DLIB
//SYSPRINT DD SYSOUT=&OUTCLAS
//*
//STEP5   EXEC PGM=IEWL,PARM='NCAL,LIST,LET,XREF'
//SYSPRINT DD SYSOUT=&OUTCLAS
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(TRK,(20,10))
//SYSLMOD  DD DSN=SYS1.ASP,DISP=(,KEEP),UNIT=&DAUNIT,VOL=SER=&ASPVOL,
// SPACE=(3625,(4,4,1))
//SYSLIN   DD DDNAME=SYSIN
// PEND
//******************************************************************************
//*      THE FOLLOWING IS A SAMPLE EXEC CARD
//*RE EXEC PREGEN,DLUNIT=2314,ASPVOL=DLIB02,DAUNIT=2314
//******************************************************************************
//PRE EXEC PREGEN,DLUNIT=3330,ASPVOL=ASPDLB,DAUNIT=3330
//******************************************************************************
//STEP0.SYSIN  DD *
 COPY I=GENLIB,O=GENLIB
 COPY I=MODGEN,O=MODGEN
 COPY I=MODGEN2,O=MODGEN2
/*
//******************************************************************************
//STEP1.SYSIN DD *
./       CHANGE  NAME=IODEVICE
         GBLB  &CTCDEVS(768)                                   @AA32703 00421000
         AIF   ('&FEATURE(&A)' EQ 'CTC').CTCFEAT  BR IF CTC SPECD **ASP 09875000
.CTCFEAT MNOTE *,'        CHANNEL TO CHANNEL DEVICE'              **ASP 10090000
&CTCDEVS(&I) SETB 1                                            @AA32703 10091000
         AGO   .MORE1                                             **ASP 10092000
&A       SETA  1                                                  **ASP 24610000
         AIF   ('&FEATURE(&A)' NE 'CTC').NOCTC  BR IF NOT CTC     **ASP 24611000
         MNOTE *,'        CHANNEL TO CHANNEL ADAPTER'             **ASP 24612000
&CTCDEVS(&I) SETB 1                                            @AA32703 24613000
.NOCTC   ANOP                                                     **ASP 24614000
./       CHANGE  NAME=SGIEC202
         GBLB  &CTCDEVS(768)                                   @AA32703 00061000
         LCLB  &CTCPRES                                           **ASP 00530000
.H01     AIF   (&CTCDEVS(&COUNTB)).CTCFEAT   BR IF CTC DEVICE   AA32703 11286321
         AIF   (NOT &SGDF01B(&COUNTB)).SETYPA     BR IF 9 TRACK   **ASP 11286322
         AIF   (NOT &CTCDEVS(&COUNTB)).UCBOPUT                 @AA32703 12370000
         AGO   .CTCFEAT                                           **ASP 12380000
.CTCFEAT ANOP       SET CTC FEATURE BIT AND CHECK DEVICE TABLE    **ASP 12390000
&CTCPRES SETB  1                   INDICATE CTC PRESENCE          **ASP 12390010
&LCHCNT  SETA  &LCHCNT+4           SET CTC BIT IN OPT FEATURES    **ASP 12390020
&ENTCNT  SETA  1                   INITIALIZE COUNT               **ASP 12390030
.CTCCONT AIF   ('&TYPTAB(&ENTCNT)' EQ 'CTC').CTCDEV  BR IF CTC    **ASP 12390040
&ENTCNT  SETA  &ENTCNT+1           UPDATE ENTRY COUNT             **ASP 12390050
         AIF   (&ENTCNT LE &TYPCNT).CTCCONT  BR IF MORE TYPES     **ASP 12390060
&TYPCNT  SETA  &TYPCNT+1           ADD ONE FOR CTC DEVICE TYPE    **ASP 12390070
&TYPTAB(&TYPCNT) SETC 'CTC'        INSERT CTC INTO TABLE          **ASP 12390080
.CTCDEV  ANOP                                                     **ASP 12390090
         AIF   (NOT &SGSUPRB(26)).CTCNOLT NEED OLTEP ADJUSTMENT         12390092
&ENTCNT  SETA  (&SGDCLSB(70)+&ENTCNT) YES ADJUST ENTCNT                 12390094
.CTCNOLT ANOP                                                           12390096
&DEVTAB  SETA  &ENTCNT*8-8         COMPUTE DEVTAB INDEX FOR UCB   **ASP 12390100
         AGO   .SETYPA             GO SET UCB TYPE FIELD          **ASP 12390110
         AIF   (NOT &CTCPRES).NOCTC  SKIP IOS ADDITIONS IF NO CTC **ASP 15276100
         PUNCH ' IECCTC &I,&TWOBS' INCLUDE ASP IOS MODS           **ASP 15276118
.NOCTC   ANOP                                                     **ASP 15277118
/*
//STEP2.SYSIN DD *
./       ADD   NAME=IECCTC
         MACRO                                                          00000000
         IECCTC  &CTLPRG,&TBASE                                         00001000
.*             &CTLPRG VALUES ARE 1,2 INDICATING MFT,MVT RESPCTVLY      00002000
*--------------------------------------------------------------------*  00011000
*                                                                     * 00012000
*              CLEAR NOT READY FOR CTC TAPE DEVICES                   * 00013000
*                                                                     * 00014000
*--------------------------------------------------------------------*  00015000
CTCENQ   L     APBSRG,ENQAD        GET ADDRESS OF ENQUEUE ROUTINE **ASP 00016000
         TM    UCBTYP+2(UCBREG),X'80' IS THIS A TAPE           @AA23757 00017000
         BZ    CTCENQ20 -          NO,GO ENQUE REQUEST         @AA23757 00018000
         TM    UCBFL1(UCBREG),UCBNRY IS THE DEVICE NOT READY   @AA23757 00019000
         BZ    CTCENQ10 -          NO,CHECK CHANNEL MASK       @AA23757 00020000
         NI    UCBFL1(UCBREG),X'FF'-UCBNRY TURN OFF NOT READY      *ASP 00021000
         B     XCP010A -           GO RETRY THE REQUEST            *ASP 00022000
CTCENQ10 TM    CHMSK,X'FF' -       ANY RESTART BITS ON         @AA23757 00023000
         BZ    CTCENQ20 -          NO,GO ENQUE REQUEST         @AA23757 00024000
         LH    WKREG1,CTCMUCB -    GET MASTER CTC UCB ADDR     @AA23757 00025000
         LTR   WKREG1,WKREG1 -     IS ADDR VALID               @AA23757 00026000
         BZ    CTCENQ20 -          NO,GO ENQUE REQUEST         @AA23757 00026100
         IC    ICREG,UCBCHA(WKREG1) GET CTC CHANNEL ADDR       @AA23757 00026200
         N     ICREG,CTCMASK -     CLEAR UNWANTED BITS         @AA23757 00026300
         SLL   ICREG,2 -           MULTIPLY CHAN ADDR BY 4     @AA23757 00026400
         LA    WKREG1,IECCST(ICREG) POINT AT CHANNEL TABLE     @AA23757 00026500
         OC    CHMSK(1),LCTMSK(WKREG1) TURN ON CTC CHAN MASK   @AA23757 00026600
         SR    ICREG,ICREG -       CLEAR IC REG                @AA23757 00026700
CTCENQ20 B     XCPENQ-XCPPNQ(APBSRG) GO ENQUE REQUEST          @AA23757 00027000
         TITLE 'CHANNEL TO CHANNEL ADAPTER START I/O MODULE'      **ASP 00028000
*---------------------------------------------------------------------* 00029000
*                                                                     * 00030000
*        CHECK ADAPTER AVAILABILITY - INSERT DSTL IF REQUIRED         * 00031000
*        LINK TO USERS SIO APPENDAGE - SET SECONDARY UCB BUSY         * 00032000
*        LINK TO IOS TO DO THE SIO - FREE THE PROPER UCB(S)           * 00033000
*        UPDATE THE DSTL IF REQUIRED AND EXIT TO IOS POST SIO         * 00034000
*                                                                     * 00035000
*---------------------------------------------------------------------* 00036000
         SPACE 2                                                  **ASP 00037000
CTCSIO   DS    0H -                                               **ASP 00038000
CTCSIO10 LH    UCBREG,TSTUCB(TSTREG) - ASSURE VALIDITY OF UCBREG  **ASP 00042000
         LH    WKREG2,CTCMUCB -    POINT TO ADAPTER UCB           **ASP 00043000
         TM    UCBTYP+2(UCBREG),X'80' IS REQ FOR A TAPE DEVICE     *ASP 00043100
         BC    8,CNSLREQ -         NO,BR,MUST BE CONSOE            *ASP 00043200
         TM    CTCMONSW,MNMTENA1 - IS THE DEVICE USABLE        @AA27462 00043300
         BC    1,CNSLREQ -         YES GO ON WITH REQUEST          *ASP 00043400
CTCABEND MVI   IOBCOD(IOBREG),PERMER SET PERMANENT ERROR IN IOB    *ASP 00043420
CTCNOIO  DS    0H -                                            @AA33546 00043430
         LH    UAREG,UCBCHA(UCBREG) - RELOAD CHAN/UNIT ADDRESS @AA34010 00043435
         N     UAREG,ADDRMSK -        CLEAR HI ORDER BYTE      @AA34010 00043436
         MVI   CSWLOC+4,CSWCHE+CSWDVE - SET CHAN & DEV END IN CSW **ASP 00043440
         TM    *,X'FF' -           GENERATE A SIO CC OF CSW STORD **ASP 00043460
         LA    LNKRG3,CTCPIO -     POINT TO PIO ENTRY POINT             00043470
         B     LASPPIO -           GO TO IOS FOR POST SIO CLEANUP **ASP 00043480
CNSLREQ  LTR   WKREG2,WKREG2 -     IS THE MASTER CTC AVAILABLE     *ASP 00043500
         BZ    CTCCTLCM -          NO,DONT START REQ           @AA33546 00043700
         TM    UCBFL1(WKREG2),UCBBSY - IS THE ADAPTER BUSY        **ASP 00044000
         BO    CTCBUSY -           YES,DONT START REQ          @AM00431 00045000
         TM    CTCMONSW,MNASPABN - IS ASP ABENDING             @AA27462 00045100
         BO    CTCBUSY -           YES,DONT START REQ          @AM00431 00045200
         LA    WKREG2,UCBTYP-2(UCBREG) - POINT TO DSTL FOR REQEST **ASP 00046000
         L     WKREG1,IOBST-1(IOBREG) - POINT TO CHANNEL PROGRAM  **ASP 00047000
         CLC   CTCLAST,0(WKREG2) - IS REQ FOR DEVICE LAST USED          00048000
         BE    CTCSIO20 -          YES, GO SET THE CAW            **ASP 00049000
         MVC   CTCCUR,0(WKREG2) -  NO, SET DSTL AS CURRENT              00050000
         MVC   CTCMODE(1),DCBMODE(DCBREG) MOVE IN MODE BYTE       **ASP 00050100
         TM    DCBMACRF(DCBREG),X'80' IS THIS EXCP                **ASP 00050150
         BZ    NOTEXCP -           NO,BRANCH                      **ASP 00050200
         MVC   CTCLRECL(5),DSHEXCP FILL IN DATA FOR EXCP          **ASP 00050250
         TM    DCBMACRF(DCBREG),X'40' IS THE RECFM AVAILABLE      **ASP 00050300
         BO    XCPRECFM -          YES,BRANCH                     **ASP 00050350
         B     EXCP -                                             **ASP 00050400
NOTEXCP  MVC   CTCBLKSI,DCBBLKSI(DCBREG) MOVE IN BLOCKSIZE        **ASP 00050450
         MVC   CTCLRECL,DCBLRECL(DCBREG) MOVE IN THE LRECL        **ASP 00050500
XCPRECFM MVC   CTCRECFM,DCBRECFM(DCBREG) MOVE IN THE RECFM        **ASP 00050550
EXCP     DS    0H -                                               **ASP 00050600
         ST    WKREG1,CTCTIC -     POINT TIC TO USER CHANNEL PROG **ASP 00051000
         MVI   CTCTIC,TICOP -      RESTORE TIC OP CODE            **ASP 00052000
         LA    WKREG1,CTCDSTLW -   POINT TO DSTL WRITE CCW        **ASP 00053000
CTCSIO20 ST    WKREG1,CAWLOC -     STORE CHAN PROG ADDR INTO CAW  **ASP 00054000
         TM    IOBFL1(IOBREG),IOBERR - IS ERR ROUTINE IN CONTROL  **ASP 00055000
         BO    CTCSIO30 -          YES, DON'T GO TO APPENDAGE     **ASP 00056000
         L     APBSRG,DEBAPG-1(DEBREG) - POINT TO APPENDAGE VECTR **ASP 00057000
         L     APBSRG,APGSIO(APBSRG) - POINT TO SIO APPENDAGE     **ASP 00058000
         BALR  LNKRG2,APBSRG -     LINK TO APPENDAGE ROUTINE      **ASP 00059000
         B     CTCSIO30 -          NORMAL RETURN, GO DO SIO       **ASP 00060000
         LA    LNKRG2,INT025 -     ERROR RETURN, DEQ THE REQUEST  **ASP 00061000
         NI    UCBFL1(UCBREG),X'FF'-UCBASK-UCBDTR-UCBCUB-UCBPST - **ASP 00062000
         B     XCPPDQ -            RESET UCB AND EXIT TO DEQUEUE  **ASP 00063000
CTCSIO30 NI    UCBCHA(UCBREG),X'FF'-UCBHLT-UCBSMD - RESET HIO/SMD **ASP 00064000
         NI    UCBFL1(UCBREG),X'FF'-UCBCUB-UCBNRY - RESET CUB/NRY **ASP 00065000
         STH   TSTREG,UCBLTS(UCBREG) - CHAIN RQE FROM SECONDARY   **ASP 00067000
         LH    UCBREG,CTCMUCB -    POINT TO THE ADAPTER UCB       **ASP 00068000
         LH    UAREG,UCBCHA(UCBREG) -LOAD CTC UNIT ADDR IN UAREG   *ASP 00069000
         N     UAREG,ADDRMSK -     CLEAR HIGH ORDER BYTE          **ASP 00069100
CTCSIO35 LA    LNKRG3,CTCPIO -     POINT TO POST SIO ROUTINE      **ASP 00071000
CTCSIO40 CLI   ATNTAB+4,X'FF' -    IS THIS A LASP SYSTEM          **ASP 00077000
         BNE   XCP110 -            NO, LINK TO IOS TO DO THE SIO  **ASP 00078000
         MVZ   CAWLOC(1),TSTKEY(TSTREG) - SET USER PROTECT KEY    **ASP 00080000
.ASPSIO4 STH   TSTREG,UCBLTS(UCBREG) - CHAIN RQE FROM ADAPTER UCB **ASP 00083000
         L     APBSRG,ATNTAB+4 -   POINT TO LASP I/O ROUTINE      **ASP 00084000
         BAL   LNKRG3,8(APBSRG) -  GO PROCESS LASP SIO            **ASP 00085000
         SR    WKREG1,WKREG1 -     GENERATE A SIO CC OF STARTED   **ASP 00086000
         BAL   LNKRG3,LASPPIO -    GO TO IOS FOR POST SIO CLEANUP **ASP 00087000
CTCPIO   EQU   * -                                                **ASP 00088000
.ASPSIO5 BC    8,CTCPIO10 -        GO UPDATE DSTL IF SIO SUCESFUL **ASP 00089000
         BC    4,CTCPIO5           IF CC=1 CONTINE TESTING              00089100
         BC    1,CTCSIO35 -        CC=3 GO RETRY                 **ASP  00089120
         LH    UCBREG,TSTUCB(TSTREG) POINT TO SECONDARY CTC UCB         00089150
         STH   TSTREG,UCBLTS(UCBREG) CHAIN RQE FROM SECONDARY     **ASP 00089200
         BR    LNKRG3              RETURN TO IOS                        00089300
CTCPIO5  EQU   *                                                        00089400
         TM    CSWLOC+4,CSWCHE -   DOES CSW SHOW CHANNEL END      **ASP 00090000
         BO    CTCPIO10 -          YES, TREAT AS SUCCESSFUL SIO   **ASP 00091000
         TM    CSWLOC+4,CSWATN -   WAS AN ATTENTION RECEIVED      **ASP 00094000
         BO    CTCPIO20 -          YES, LET IOS POST SIO HANDLE   **ASP 00095000
         NI    UCBFL1(UCBREG),X'FF'-UCBPST-UCBBSY - FREE ADAPTER  **ASP 00096000
         LH    UCBREG,TSTUCB(TSTREG) POINT TO SECONDARY CTC UCB         00097000
         B     CTCPIO20 -          DON'T UPDATE DSTL              **ASP 00098000
CTCPIO10 MVC   CTCLAST,CTCCUR -    UPDATE DATA SET TITLE LABEL    **ASP 00099000
         LH    WKREG1,TSTUCB(TSTREG) - POINT TO SECONDARY UCB     **ASP 00099100
         OI    UCBFL1(WKREG1),UCBPST+UCBBSY - SET SECONDARY ACTIV **ASP 00099200
CTCPIO20 TM    IOBCC(IOBREG),IOBCC3 - RESTORE CC PRIOR TO EXIT    **ASP 00100000
         LA    LNKRG3,XCPPIO -     POINT TO IOS POST SIO ROUTINE  **ASP 00101000
         BR    LNKRG3 -            EXIT TO IOS                    **ASP 00102000
CTCCTLCM L     WKREG1,IOBST-1(IOBREG) -    GET CCW ADDR        @AA33546 00102050
         TM    CCWFLG(WKREG1),X'C0' -      DATA/COMMAND CHAIN  @AA33546 00102060
         BC    4+1,CTCBUSY -               YES,ENQUEUE REQ     @AA33546 00102070
         LA    WKREG2,CTCOPCOD -           COMMAND TABLE ADDR  @AA33546 00102080
         LA    WKREG3,CTCOPNUM -           NUM OF ENTRIES      @AA33546 00102090
CTCNXTOP CLC   0(1,WKREG1),0(WKREG2) -     SELECTED COMMAND    @AA33546 00102100
         BE    CTCNOIO -                   YES,POST COMPLETE   @AA33546 00102110
         LA    WKREG2,1(WKREG2) -          INCREMENT COUNT     @AA33546 00102120
         BCT   WKREG3,CTCNXTOP -           LOOP UNTIL DONE     @AA33546 00102130
CTCBUSY  DS    0H -                                            @AA33546 00102190
         IECLNK1 ,BC,15,SELBSY,0,LNKRG1,,&TBASE                @AM00431 00102200
         SPACE 3                                                  **ASP 00103000
CTCDSTLW CCW   X'FD',CTCCUR,X'60',8 WRITE CURRENT DSTL     ASPHDR **ASP 00104000
CTCTIC   CCW   TICOP,0,0,0 -       TRANSFER TO USER CHANNEL PROG  **ASP 00105000
CTCSNCCW CCW   SENSOP,CTCSNBYT,X'20',1 - OBTAIN SENSE BYTE        **ASP 00106000
CTCCUR   DC    H'0' -              CURRENT DSTL UNIT       ASPHDR **ASP 00107000
CTCLRECL DC    H'0' -              DSTL LRECL              ASPHDR **ASP 00107100
CTCBLKSI DC    H'0' -              DSTL BLKSIZE            ASPHDR **ASP 00107200
CTCRECFM DC    XL1'00',X'00' -     DSTL RECFM              ASPHDR **ASP 00107300
CTCMODE  EQU   CTCCUR+7                                       DSH **ASP 00107400
DCBLRECL EQU   82 -                                        ASPHDR **ASP 00107500
DCBBLKSI EQU   62 -                                        ASPHDR **ASP 00107600
DCBRECFM EQU   36 -                                        ASPHDR **ASP 00107700
DCBMODE  EQU   16                                             DSH **ASP 00107800
DCBMACRF EQU   42 -                                               **ASP 00107900
DSHEXCP  DC    XL5'C5E7C3D7C0' -                                  **ASP 00107950
CTCLAST  DC    AL2(0) -            DSTL FOR LAST SECCESSFUL REQ   **ASP 00108000
CTCMASK  DC    1F'15' -            MASK FOR CTC CHANNEL ADDR   @AA23757 00108100
CTCMUCB  DC    H'0'                 - POINTER TO ADAPTER UCB      **ASP 00109000
CTCOUCB  DC    H'0' -              SECONDARY CTC POINTER       @AM00431 00110000
CTCMONSW DC    X'00'               SW BYTE FOR CTC MONITOR              00110100
CTCCCWL  DC    H'8' -              LENGTH OF A CCW                **ASP 00111000
CTCSNBYT DC    X'00' -             ADAPTER SENSE BYTE             **ASP 00112000
CTCLASP  DC    X'00' -             LOCAL/REAL MAIN INDICATOR      **ASP 00115000
CTCOPCOD DC    X'07' -                     REW COMMAND         @AA33546 00115100
         DC    X'0F' -                     RUN COMMAND         @AA33546 00115101
         DC    X'1F' -                     WTM COMMAND         @AA33546 00115102
CTCOPNUM EQU   *-CTCOPCOD -                NUM OF COMM CODES   @AA33546 00115120
CTCPATCH DC    10F'12837827' -     PATCH AREA                     **ASP 00116000
         SPACE 3                                               @AA27462 00116100
*        DEFINITION OF CTCMONSW                                @AA27462 00116200
MNMTENA1 EQU   X'80' -             MAINTASK ENABLED            @AA27462 00116300
MNMTENA2 EQU   X'40' -             MAINTASK ENABLED            @AA27462 00116400
MNSWCOMP EQU   X'10' -             CONSOLE SWITCH COMPLETE     @AA27462 00116500
MNASPABN EQU   X'08' -             ASP ABENDING                @AA27462 00116600
MNHOTIPL EQU   X'04' -             HOT IPL                     @AA27462 00116700
MNSWFAIL EQU   X'02' -             CONSOLE SWITCH FAILED       @AA27462 00116800
MNCTCBSY EQU   X'01' -             CTC BUSY                    @AA27462 00116900
         TITLE 'CHANNEL TO CHANNEL ADAPTER TRAP ROUTINE'          **ASP 00117000
*---------------------------------------------------------------------* 00118000
*                                                                     * 00119000
*        SET UNIT EXCEPTION AT EOF - FREE SECONDARY & ADAPTER UCBS    * 00120000
*                                                                     * 00122000
*---------------------------------------------------------------------* 00123000
         SPACE 2                                                  **ASP 00124000
CTCTRP   DS    0H -                                               **ASP 00125000
         TM    CTCMONSW,MNMTENA1 - ARE CTC TAPES ENABLED       @AA27462 00125100
         BC    8,CTCTRP10 -        NO,SKIP RELOAD OF UCBREG     AA23168 00125200
         LH    UCBREG,CTCOUCB -    RELOAD UCBREG WITH MASTER   @AM00431 00126031
CTCTRP10 NI    CTCMONSW,X'FF'-MNCTCBSY - TURN OFF CTCBUSY FLAG @AA27462 00129030
         CH    UCBREG,TSTUCB(TSTREG) - WAS THE I/O ON THE CONSOLE **ASP 00129130
         BCR   8,LNKRG2 -          YES, EXIT TO IOS               **ASP 00130000
         NI    UCBFL1(UCBREG),UCBBSY - RESET ALL BUT BSY IN ADPTR **ASP 00131000
         LH    UCBREG,TSTUCB(TSTREG) - POINT TO UCB FOR THIS REQ  **ASP 00132000
         NI    UCBFL1(UCBREG),X'FF'-UCBBSY - RESET BUSY IN SCNDRY **ASP 00133000
         LH    WKREG1,CSWLOC+6 -   GET RESIDUAL BYTE COUNT        **ASP 00134000
         LTR   WKREG1,WKREG1 -     IS THE RESIDUAL ZERO           **ASP 00135000
         BZ    CTCTRP30 -          YES, NO EOF/GO INCR BLK COUNT  **ASP 00136000
         TM    CSWLOC+4,CSWCHE+CSWDVE - CHAN AND DEV END IN CSW   **ASP 00137000
         BNO   CTCTRP30 -          NO, NO EOF/GO INCR BLK COUNT   **ASP 00138000
         L     WKREG1,CSWLOC -     POINT TO THE NEXT CCW          **ASP 00139000
         SH    WKREG1,CTCCCWL -    BACK UP TO CCW JUST EXECUTED   **ASP 00140000
         TM    0(WKREG1),X'01' -   WAS IT A WRITE                 **ASP 00141000
         BO    CTCTRP30 -          YES, NO EOF/GO INCR BLK COUNT  **ASP 00142000
         CLC   6(2,WKREG1),CSWLOC+6 - DOES RESIDUAL CNT = INITIAL **ASP 00143000
         BNE   CTCTRP30 -          NO, NO EOF/GO INCR BLK COUNT   **ASP 00144000
CTCTRP20 OI    IOBCSW+4(IOBREG),CSWUEX - SET UNIT XCEPTION IN IOB **ASP 00161000
CTCTRP30 L     WKREG1,DCBBLK(DCBREG) - OBTAIN DCB BLOCK COUNT     **ASP 00162000
         AH    WKREG1,IOBBCI(IOBREG) - INCREMENT IT               **ASP 00163000
         ST    WKREG1,DCBBLK(DCBREG) - STORE UPDATED COUNT        **ASP 00164000
         BR    LNKRG2 -            EXIT TO IOS                    **ASP 00165000
*********************************************************************** 00165100
*                                                                     * 00165200
*        THE FOLLOWING CODE PROVIDES SPECIAL INTERRUPT HANDLING       * 00165300
*        FOR ASP CTC DEVICES                                          * 00165350
*                                                                     * 00165400
*********************************************************************** 00165500
CTCINTH  CLI   ATNTAB+4,X'FF' -    IS THIS SUPPORT             **ASP    00166000
         BE    CTCLINT -           YES,BRANCH                  **ASP    00167000
         TM    CSWLOC+4,CSWATN -   IS THIS REALLY ATTENTION    **ASP    00170000
         BZ    INT013 -            NO,GO TO O/S                **ASP    00171000
         LA    WKREG1,CTCSNCCW -   POINT AT ADAPTER SENSE CCW     **ASP 00172000
         ST    WKREG1,CAWLOC -     STORE CCW ADDR & 0 KEY IN CAW  **ASP 00173000
CTCATN10 SIO   0(UAREG) -          START SENSE COMMAND            **ASP 00174000
         BC    3,CTCATN10 -        RE-ISSUE IF ADAPTER BUSY       **ASP 00175000
CTCATN20 TIO   0(UAREG) -          TEST SENSE OPERATION STATUS    **ASP 00176000
         BC    8+2+1,CTCATN20 -    LOOP UNTIL CSW STORED          **ASP 00177000
         TM    CSWLOC+4,CSWDVE -   HAS DEVICE END OCCURED         **ASP 00178000
         BZ    CTCATN20 -          NO, LOOP UNTIL IT DOES         **ASP 00179000
         CLI   CTCSNBYT,X'07' -    IS THIS A NORMAL ATTN       @AM00431 00179100
         BE    INTATT2 -           YES GO TO ATN HANDLER       @AM00431 00179200
         CLI   CTCSNBYT,X'F7' -    IS THIS IPL RESPONSE        @AM00431 00180000
         BNE   CTCAERR -           NO,BR ON ERR CONDITION      @AA19292 00181000
         LH    WKREG1,CTCMUCB -    GET MASTER CTC UCB ADR          *ASP 00182000
         LTR   WKREG1,WKREG1 -     TEST FOR UCB ADDR VALID         *ASP 00183000
         BNZ   INT013 -            IGNORE INTERRUPT            @AM00431 00184000
         STH   UCBREG,CTCMUCB -    MAKE THIS RESPONDER MASTER      *ASP 00185000
         STH   UCBREG,CTCOUCB -    SAVE SECOND CTC POINTER     @AM00431 00186000
         B     INTATT2 -           GO TO ATTN HANDLER          **ASP    00190000
CTCLINT  CH    UCBREG,CTCOUCB -    IS INTRPT ON MASTER CTC     @AM00431 00191000
         BNE   CTCRINT -           NO GO TO ASP                **ASP    00192000
         CLI   CSWLOC+4,X'04' -    IS THIS DE FROM HIO         **ASP    00193000
         BNE   INTATT1 -           NO GO  TO INT HANDLER       **ASP    00194000
         B     INT013 -            YES,GO SKIP INT HANDLING    **ASP    00195000
CTCRINT  L     APBSRG,CTCATN -     GET POINTER TO CTC ATN ROUTINE **ASP 00196000
         LTR   APBSRG,APBSRG -     IS POINTER VALID            **ASP    00197000
         BZ    INT013 -            NO,RETURN                   **ASP    00198000
         BALR  LNKRG2,APBSRG -     GO TO CTC ATN ROUTINE       **ASP    00199000
         B     INT013 -            RETURN                      **ASP    00200000
CTCAERR  MVC   CTCSNBYT+1(1),CTCSNBYT TRACE LAST SENSE DATA    @AA19292 00200100
         MVI   CTCSNBYT,X'F7' -    INSERT FAKE SENSE DATA      @AA19292 00200200
         HDV   0(UAREG) -          HALT THE CTC                @AA19292 00200300
         BC    11,CTCATN20 -       GO DO TIO TILL CSW STOREED  @AA19292 00200400
         B     INT013 -            RETURN TO INTR HANDLER      @AA19292 00200500
         TITLE 'TEST CHANNEL AND CHANNEL SEARCH ROUTINES IN IOS'  **ASP 00201000
         MEND                                                           00202000
./       CHANGE  NAME=IECINT
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 21770519
         CLI   UCBTYP+1(UCBREG),4 -IS THE ERROR ON A CTC UNIT     **ASP 21771019
         BNE   INT031 -            NO, GO TO AB. END APG. EXIT    **ASP 21771519
         LH    WKREG1,TSTUCB(TSTREG) - GET ADDR OF SECONDARY UCB  **ASP 21772019
         MVI   UCBFL1(WKREG1),0 -  RESET ALL FLAGS IN SECONDARY   **ASP 21772519
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 47250019
INTATT   CLI   UCBTYP+1(UCBREG),X'04' IS THIS CTC INTERRUPT    **ASP    47250500
         BE    CTCINTH -           YES BRANCH                  **ASP    47251000
INTATT1  TM    CSWLOC+4,CSWCHE+CSWDVE -                        **ASP    47252000
         CLI   ATNTAB+4,X'FF' -    IS THIS A LASP SYSTEM          **ASP 47532019
         BNE   NOTLASP -           NO, DO NOT ATTEMPT POSTING ASP **ASP 47533019
         LR    ICREG,APBSRG -      YES, SAVE ATTN RTN EP ADDRESS  **ASP 47534019
         L     APBSRG,ATNTAB+4 -   POINT TO CONTRAP ENTRY POINT   **ASP 47535019
NOTLASP  EQU   * -                                                **ASP 47536019
         SR    ICREG,ICREG -       CLEAR ICREG                    **ASP 47671019
*        FOLLOWING CODE MODIFIED FOR ASP                           ASP  72731030
         BC    8,ASPINTER          NO,BYPASS ASP CODE              ASP  72800019
         TM    UCBFL1(UCBREG),UCBNRY IS DEVICE READY                ASP 72801030
         BNO   INTER7C -           BRANCH IF YES                    ASP 72802030
         TM    UCBTYP+2(UCBREG),X'88' IS DEVICE UR OR TAPE          ASP 72803030
         BZ    INTER7C -           BRANCH IF NOT                    ASP 72804030
         TM    44(DCBREG),X'01' -  ASP REQUESTED IO                 ASP 72805030
         BNO   INTER7C -           BRANCH IF NOT                    ASP 72806030
         OI    DCBFL(DCBREG),DCBPER SET PERM ERROR                  ASP 72807030
         IECLNK1 ,LA,LNKRG1,INT027,,,,&TBASE                            72807131
         B     INT057 -            TO ABN APG                       ASP 72808030
ASPINTER DS    0H                                                  ASP  72809030
./       CHANGE  NAME=IECIOS
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 02531519
         CLI   ATNTAB+4,X'FF' -    IS THIS A LASP SYSTEM          **ASP 02532019
         BNE   NOASPPST -          NO, DON'T ATTEMPT POSTING ASP  **ASP 02532519
         LR    LCHREG,LNKRG2 -     SAVE IOS LINKAGE REG           **ASP 02533019
         LR    ICREG,APBSRG -      SAVE POST EP ADDRESS           **ASP 02533519
         L     APBSRG,ATNTAB+4 -   POINT TO CONTRAP ENTRY POINT   **ASP 02534019
         BAL   LNKRG2,4(0,APBSRG) -ENTER CONTRAP FOR POSS ASP PST **ASP 02534519
         LR    LNKRG2,LCHREG -     RESTORE IOS LINKAGE REGISTER   **ASP 02535019
         LR    APBSRG,ICREG -      RESTORE POST EP ADDRESS        **ASP 02535519
         SR    ICREG,ICREG -       CLEAR ICREG                    **ASP 02536019
NOASPPST EQU   * -                                                **ASP 02536519
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 04650019
         BR    LNKRG2 -            NOP KEY ZERO REQ FOR DEBS      **ASP 04660019
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 06041019
         CLI   UCBTYP+1(UCBREG),X'04'  IS THIS A CTC DEVICE       **ASP 06042019
         BNE   XERX02 -            IF NO DONT CLEAR UCB FLGS      **ASP 06042119
         LH    LNKRG3,CTCMUCB -    POINT TO PRIMARY CTC UCB       **ASP 06042219
         NI    CTCMONSW,X'FF'-MNCTCBSY - TURN OFF CTCBUSY FLAG @AA27462 06042330
         MVI   UCBFL1(LNKRG3),0 -  CLEAR ALL FLAGS IN ADAPTER UCB **ASP 06043019
CTCATN   DC    F'0' -              ASP CTC ATN ENTRY               *ASP 77158030
CTCINDX  EQU   CTCATN-ATNTAB -     VALUE OF CTC ATN INDEX         **ASP 77158130
         SPACE 2                                                   *ASP 77159030
./       CHANGE  NAME=IECIOSB
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 76081020
         CLI   UCBTYP+1(HINREG),X'04' - IS THIS REQST FOR CTC DEV **ASP 76081520
         BNE   NOCTCHIO -          NO, PROCEED NORMALLY           **ASP 76082020
         TM    UCBTYP+2(HINREG),X'88' IS THIS TAPE OR UNIT REC    **ASP 76082130
         BC    9,NOCTCHIO          NO BRANCH NOT CTC              **ASP 76082230
         L     HUAREG,CTCADCON -   GET POINTER TO CTC UCB ADCON   **ASP 76082520
         NI    4(HUAREG),X'FE' -   TURN OFF CTCBUSY FLAG           *ASP 76082630
         LH    HUAREG,0(HUAREG) -  POINT TO THE ADAPTER UCB       **ASP 76083020
         OI    UCBCHA(HUAREG),UCBHLT - INDICATE HIO ISSUED        **ASP 76083520
         NI    UCBFL1(HUAREG),X'FF'-UCBBSY-UCBPST-UCBDTR-UCBASK - **ASP 76084020
         LH    HUAREG,UCBCHA(HUAREG) - OBTAIN UNIT ADDRESS        **ASP 76084520
         N     HUAREG,ADMSK -      CLEAR HIGH ORDER BITS          **ASP 76085020
         B     HIO002 -            GO ISSUE HIO                   **ASP 76086520
NOCTCHIO EQU   * -                                                **ASP 76087020
CTCADCON DC    A(CTCMUCB) -        ADDRESS OF THE CTC UCB ADCON   **ASP 89121020
./       CHANGE  NAME=IECTBL
         AIF   ('&TYPE(&COUNT)' EQ 'CTC').CTCFIFO                 **ASP 12600500
.CTCFIFO ANOP                                                     **ASP 75000100
**  CHANNEL TO CHANNEL ADAPTER ENTRY WITH FIFO QUEUEING           **ASP 75000110
         DC    AL2(CTCENQ-IOSBASE) FIFO QUEUEING FOR CTC          **ASP 75000120
         DC    AL2(CTCSIO-IOSBASE) SIO CODE FOR CTC               **ASP 75000130
         DC    AL2(CTCTRP-IOSBASE) TRAP CODE FOR CTC              **ASP 75000140
         DC    AL2(NORMSEN-IOSBASE) SENSE ENTRY FOR CTC           **ASP 75000150
         AGO   .TSTLOOP                                           **ASP 75000160
./       CHANGE  NAME=IECXCP
         ENTRY CTCMUCB                                             *ASP 02012030
         ENTRY ATNTAB                                              *ASP 02013030
         ENTRY CTCMONSW                                            *ASP 02014030
         ENTRY CTCATN                                              *ASP 02015030
**************** THE FOLLOWING INSTRUCTIONS MODIFIED FOR ASP *******ASP 74762019
LASPPIO  BALR  WKREG1,0 -          GET RIGHT HALF OF PSW          **ASP 74860019
         BC    15,INTATT -         TO ATTENTION ROUTINE           **ASP 82200019
./       CHANGE  NAME=IECXTCH
         ENTRY LASPTCH                                                  62000030
LASPTCH  B     LASPTCH1 -          BYPASS LASP TCH CODE                 62001030
         CLI   UCBTYP+1(UCBREG),4 -IS THIS A CTC DEVICE                 62002030
         BNE   LASPTCH1 -          NO,BRANCH                            62003030
         TM    UCBTYP+2(UCBREG),X'88' IS THIS A TAPE OR CONSOLE         62004030
         BM    XCPTCH3A -          YES SKIP TCH FOR LOCAL MAIN          62005030
LASPTCH1 EQU   *                                                        62006030
./       CHANGE  NAME=IEAQNU
         TM    PIOPSW+1,X'F1' -    IS INTRUPT IN KEY 0 SUPRVSR STATE    06380000
         L     XNPI1,AIORGSW       GET ADDR OF IOS SWITCH      @AA28026 06416021
         TM    1(XNPI1),X'F0'      I/O INTERRUPT ACTIVE        @AA28026 06417021
         BNZ   PLOGADR             YES GOTO ABTERM             @AA28026 06418021
AIORGSW  DC    A(IORGSW)           ADDRESS OF IOS SWITCH       @AA28026 06794621
/*
//STEP3.SYSIN DD *
./       CHANGE  NAME=IEAANIP
         LA    R6,CONSIN -         GET POINTER TO CONSOLE NAME     *ASP 07204030
         L     R15,CTCINIT -       GET ADDRESS OF CTC INIT ROUTINE *ASP 07205030
         BALR  R5,R15 -            GO TO CTC INIT ROUTINE          *ASP 07206030
CTCINIT  DC    V(CTCNMCS)                                          *ASP 07211030
         NI    UCBESTAT(CNR4),X'7F' MARK CONSOLE OFFLINE IN ADVANCE*ASP 08387130
         CLI   UCBTYP+1(CNR4),4 -  IS THIS A CTC DEVICE            *ASP 08387230
         BNE   NOTCTC -            NO,BRANCH                       *ASP 08387330
         TM    CONSWIT,NMCNSWIT -  IS THIS STILL MASTER CONS SEARCH*ASP 08387430
         BC    5,NOTMASTR -        NO,SKIP TIO OF CTC,LEAVE OFFLINE*ASP 08387530
         L     15,CTCINITM -       LOAD POINTER TO CTC INIT ROUTINE*ASP 08387630
         BALR  CNR5,15 -           GO TO CTC INIT ROUTINE          *ASP 08387730
NOTCTC   EQU   * -                                                 *ASP 08387830
NOTMASTR EQU   *                                                   *ASP 08394030
CTCINITM DC    V(CTCMCS)                                           *ASP 08492020
         CLI   UCBTYP+1(R9),4 -    IS THIS A CTC DEVICE           **ASP 12657020
         BE    CTCRDY -            YES,MARK IT READY              **ASP 12658020
CTCRDY   EQU   *                                                  **ASP 12685020
CTCRDY   EQU   *                                                  **ASP 12706020
************************************************************** @AA30864 61992120
*  THE FOLLOWING CODE HAS BEEN ADDED FOR ASP TO CLEAR A        @AA30864 61992220
*  POSSIBLE BUSY CONDITION WHICH MAY OCCUR ON THE CTC WHILE    @AA30864 61992320
*  IPL'ING. IF NIP HAS INITIATED AN I/O OPERATION AND CSW      @AA30864 61992420
*  STATUS IS RETURNED INDICATING ATTENTION AND BUSY, A SENSE   @AA30864 61992520
*  COMMAND MUST BE ISSUED TO CLEAR THE CONDITION TO ALLOW      @AA30864 61992620
*  NIP TO COMPLETE ITS I/O OPERATION.                          @AA30864 61992720
************************************************************** @AA30864 61992820
         CLI   CSWSTAT,X'90'       MAY BE CTC IF ATTN AND BUSY @AA30864 61992920
         BNE   CSWNOCTC            CONT- NOT ATTN AND BUSY     @AA30864 61993020
         L     R7,CAW              SAVE CURRENT CAW FOR RETRY  @AA30864 61993120
         MVC   CAW(4),IEASNCAW     SET CAW FOR SENSE OPERATION @AA30864 61993220
         SIO   0(10)               EXECUTE THE SENSE           @AA30864 61993320
SENSCTCS TIO   0(10)                                           @AA30864 61993420
         BC    3,SENSCTCS          WAIT FOR STATUS             @AA30864 61993520
         ST    R7,CAW              RESTORE CAW FOR ORIG I/O    @AA30864 61993620
         B     IEACON02            RESTART ORIGINAL I/O        @AA30864 61993720
CSWNOCTC DS    0H                  CONT HERE IF NOT ATTN/BUSY  @AA30864 61993820
************************************************************** @AA30864 61993920
/*
//******************************************************************************
//STEP4.SYSIN  DD *
 COPY I=GENLIB,O=GENLIB
 COPY I=MODGEN,O=MODGEN
 COPY I=MODGEN2,O=MODGEN2
/*
//******************************************************************************
//STEP5.OBJ320 DD DISP=SHR,DSN=ASP.OBJ320,UNIT=SYSDA,VOL=SER=ASPSUP
//STEP5.SYSIN DD *
 INCLUDE OBJ320(MVTSVC)
         NAME  ASPSVC(R)
/*
//
