//G15STGE1 JOB 1,'G15STAGE1',CLASS=A,MSGCLASS=A,MSGLEVEL=(1,1)
//*********************************************************************
//*                                                                 ***
//*    Job:      G15STAGE1                                          ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  Run SYSGEN stage 1.                                ***
//*    Update:   2006/08/25                                         ***
//*                                                                 ***
//*    Changes:  2006/08/25 Enabled SMARTNIP.                       ***
//*              2006/08/04 Changed 1052 CTCs 03F-05F to 2400s      ***
//*                         on channel 6.                           ***
//*              2006/07/09 Added printers 11E and 11F              ***
//*              2006/07/06 Moved tape CTCs to 660-68F              ***
//*              2006/07/06 Added 1052 CTC at 03F, 04F, 05F         ***
//*              2006/06/25 Changed CTC console from 020 to 02F     ***
//*                                                                 ***
//*********************************************************************
//*
//*  Consoles:
//*
//*  ! CUA ! Devt ! Type                  ! Alternate   !
//*  !-----+------+-----------------------+-------------!
//*  ! 010 ! 3158 ! OS Master             ! 02F         !
//*  ! 02F ! CTC  ! OS Secons             ! 010         !
//*  ! 009 ! 3215 ! OS Secons             ! 01F         !
//*  ! 01F ! 3215 ! OS Secons/ASP Console ! 009         !
//*  ! 30E ! 1403 ! OS Secons/Hardcopy    ! 010         !
//*  ! 014 ! 3277 ! ASP Console           ! 01F         !
//*  ! 30F ! 1403 ! ASP MLOG              ! 01F         !
//*
//*
//*  Printers (UCS):
//*
//*  !      ! Channel 0 ! Channel 1 ! Channel 2 ! Channel 3 !
//*  ! Devt ! Cua - Cua ! Cua - Cua ! Cua - Cua ! Cua - Cua !
//*  !------+-----------+-----------+-----------+-----------!
//*  ! 1403 ! 00E - 00F ! 10E - 10F !           ! 30E - 30F !
//*  ! 3211 !           ! 102 - 103 !           !           !
//*
//*
//*  Printers (Non-UCS):
//*
//*  !      ! Channel 0 ! Channel 1 ! Channel 2 ! Channel 3 !
//*  ! Devt ! Cua - Cua ! Cua - Cua ! Cua - Cua ! Cua - Cua !
//*  !------+-----------+-----------+-----------+-----------!
//*  ! 1403 !           ! 11E - 11F !           !           !
//*
//*
//*  Card Readers/Punches:
//*
//*  !      ! Channel 0 ! Channel 1 ! Channel 2 ! Channel 3 !
//*  ! Devt ! Cua - Cua ! Cua - Cua ! Cua - Cua ! Cua - Cua !
//*  !------+-----------+-----------+-----------+-----------!
//*  ! 2540R! 00C       ! 10C       !           !           !
//*  ! 2540P! 00D       ! 10D       !           !           !
//*
//*
//*  Display Terminals (including display consoles)
//*
//*  !      ! Channel 0 ! Channel 1 ! Channel 2 ! Channel 3 !
//*  ! Devt ! Cua - Cua ! Cua - Cua ! Cua - Cua ! Cua - Cua !
//*  !------+-----------+-----------+-----------+-----------!
//*  ! 3158 ! 010       !           !           !           !
//*  ! 3270 ! 011       !           !           !           !
//*  ! 3270 ! 014       !           !           !           !
//*  ! 3270 ! 0C0 - 0CF !           !           ! 3C0 - 3CF !
//*
//*
//*  DASD devices
//*
//*  !      ! Channel 0 ! Channel 1 ! Channel 2 ! Channel 3 !
//*  ! Devt ! Cua - Cua ! Cua - Cua ! Cua - Cua ! Cua - Cua !
//*  !------+-----------+-----------+-----------+-----------!
//*  ! 2311 !           ! 120 - 137 !           !           !
//*  ! 2314 !           ! 130 - 137 ! 230 - 237 ! 330 - 337 !
//*  ! 3330 !           ! 150 - 15F ! 250 - 25F ! 350 - 35F !
//*
//*
//*  Tape devices
//*
//*  !      ! Channel 5 !
//*  ! Devt ! Cua - Cua !
//*  !------+-----------+
//*  ! 3420 ! 580 - 58F !
//*
//*
//*  ASP 1052 CTC
//*
//*  !      ! Channel 0 !
//*  ! Devt ! Cua - Cua !
//*  !------+-----------!
//*  ! 1052 ! 02F       !
//*
//*
//*  ASP 2400 CTCs
//*
//*  !      ! Channel 6 !
//*  ! Devt ! Cua - Cua !
//*  !------+-----------!
//*  ! 2401 ! 63F       !
//*  ! 2401 ! 64F       !
//*  ! 2401 ! 65F       !
//*  ! 2401 ! 660 - 66F !
//*  ! 2401 ! 670 - 67F !
//*  ! 2401 ! 680 - 68F !
//*
//*
//*  BSC devices
//*
//*  !      ! Channel 0 !
//*  ! Devt ! Cua - Cua !
//*  !------+-----------!
//*  ! BSC1 ! 090 - 097 !
//*  ! BSC2 ! 0A0 - 0A7 !
//*  ! BSC3 ! 0B0 - 0B7 !
//*
//*
//*  HASP pseudodevices
//*
//*  !      ! Channel 7 !
//*  ! Devt ! Cua - Cua !
//*  !------+-----------!
//*  ! 2540R! 700 - 71F !
//*  ! 1403 ! 720 - 767 !
//*  ! 2540P! 770 - 77F !
//*  ! 2520 ! 780 - 78F !
//*
//*********************************************************************
//*
//STAGE1   EXEC PGM=IEUASM,PARM='LIST,NOLOAD,DECK,NOXREF',REGION=256K
//SYSPRINT DD  SYSOUT=A
//*SYSLIB   DD  DSN=SYS1.ASPMOD,UNIT=3330,VOL=SER=ASPDLB,DISP=SHR
//SYSLIB    DD  DSN=SYS1.GENLIB,UNIT=3330,VOL=SER=ASPDLB,DISP=SHR
//*SYSPUNCH DD  DUMMY,DCB=BLKSIZE=80
//SYSPUNCH DD  UNIT=00D,DCB=BLKSIZE=80
//SYSUT1   DD  UNIT=SYSDA,SPACE=(CYL,(35,10)) ,VOL=SER=WORK01
//SYSUT2   DD  UNIT=SYSDA,SPACE=(CYL,(35,10)) ,VOL=SER=WORK02
//SYSUT3   DD  UNIT=SYSDA,SPACE=(CYL,(50,10)) ,VOL=SER=WORK02
//SYSIN    DD  *
R218  TITLE '    MVT Release 21.8 Stage 1 system generation for ASP'
*====================================================================*
*                                                                    *
*        Include sysgen globals.                                     *
*                                                                    *
*====================================================================*
          PRINT OFF
          COPY SGGBLPAK
          GBLB  &SGHOLDB                  "TYPRUN=HOLD" flag for jobs
          PRINT ON
               SPACE 1
*====================================================================*
*                                                                    *
*        Set override to permit generation of up to 768              *
*        I/O devices.                                                *
*                                                                    *
*====================================================================*
*&LIMIT(1) SETB 1                           Allow 248 devices
&LIMIT(3) SETB  1                          Allow 768 devices
*&SGMENTB(16) SETB 1                        Set diagnostic override
               SPACE 1
*====================================================================*
*                                                                    *
*        Set flag to generate "TYPRUN=HOLD" on stage 2               *
*        JOB cards.                                                  *
*                                                                    *
*====================================================================*
*&SGHOLDB SETB  1                          Set hold flag
               SPACE 1
*====================================================================*
*                                                                    *
*        Enable DEVSTAT option (SMARTNIP).  Note that usermod        *
*        TMVT801 modifies NIP to restrict DEVSTAT processing         *
*        to DASD and real tape devices.                              *
*                                                                    *
*====================================================================*
&SGMENTB(87) SETB  1                       Set SMARTNIP flag
               EJECT ,
*====================================================================*
*                                                                    *
*        Control program.                                            *
*                                                                    *
*====================================================================*
               SPACE 1
    CTRLPROG   TYPE=MVT,                   MVT system                  +
               ADDTRAN=15,                 Additional transient areas  +
               FETCH=PCI,                  PCI program fetch           +
               HIARCHY=EXCLUDE,            No storage hierarchies      +
               MAXIO=10,                   Max concurrent I/Os         +
               OPTIONS=(SERVAID),          Include service aids        +
               OVERLAY=ASYCHRON,           Asynch overlay supervisor   +
               QSPACE=24,                  SQA size in 2K blocks       +
               WARN=0                      No power warning feature
               EJECT ,
*====================================================================*
*                                                                    *
*        Central processor.                                          *
*                                                                    *
*====================================================================*
               SPACE 1
    CENPROCS   MODEL=158,                  CPU model                   +
               FEATURE=PROTECT,            Storage protection          +
               INSTSET=UNIV                Universal instruction set
               EJECT ,
*====================================================================*
*                                                                    *
*        Supervisor.                                                 *
*                                                                    *
*====================================================================*
               SPACE 1
    SUPRVSOR   ASCII=INCTRAN,              ASCII translation           +
               OPTIONS=(APR,               Alternate path retry        +
               CCH,                        Channel check handler       +
               COMM,                       Issue msgIEA101A at IPL     +
               DDR,                        Dynamic device reconfig     +
               IDENTIFY,                   Include IDENTIFY            +
               ONLNTEST,                   Include OLTEP               +
               PROTECT,                    Storage protection          +
               RER,                        Tape reduced error recovery +
               TRSVCTBL),                  Resident SVC TTR table      +
               RESIDNT=(ATTACH,            ATTACH is resident          +
               RENTCODE,                   Modules can be resident     +
               TRSVC),                     T3/4 SVCs can be resident   +
               SER=MCH,                    Hardware error recovery     +
               TIMER=JOBSTEP,              All timing functions        +
               TRACE=200,                  Trace table size            +
               USERERR=YES,                User error exits            +
               WAIT=MULTIPLE               Multiple event wait
               EJECT ,
*====================================================================*
*                                                                    *
*        Job scheduler                                               *
*                                                                    *
*====================================================================*
               SPACE 1
    SCHEDULR   TYPE=MVT,                   MVT system                  +
               ACCTRTN=SMF,                Include SMF                 +
               ALTCONS=02F,                Master console's alternate  +
               CONOPTS=(MCS,EXIT),         Multiple Console Support    +
               CONSOLE=010,                Master console address      +
               ESV=NO,                     No volume error statistics  +
               EVA=NO,                     No error volume analysis    +
               HARDCPY=(30E,ALL,CMDS),     Hardcopy log options        +
               INITQBF=10,                 Buffers for SYSJOBQE tracks +
               JOBQFMT=12,                 Job queue logical track size+
               JOBQLMT=650,                Reserved job queue records  +
               JOBQTMT=60,                 Reserved job queue records  +
               JOBQWTP=10,                 WTP job queue records       +
               MINPART=68,                 Minimum partition size      +
               OPTIONS=(LOG,               Include system log          +
               RJE,                        Include RJE                 +
               CRJE,                       Include CRJE                +
               TSO),                       Include TSO                 +
               PFK=12,                     PF keys for master console  +
               REPLY=30,                   Number of reply elements    +
               ROUTCDE=(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16),       +
               STARTI=AUTO,                Start initiator at IPL      +
               SUBMITQ=50,                 JOBQ tracks for FIB jobs    +
               WTLBFRS=10,                 Write-to-log buffers        +
               WTLCLSS=L,                  Write-to-log output class   +
               WTOBFRS=150                 WTO buffers
               EJECT ,
*====================================================================*
*                                                                    *
*        Secondary console definitions.                              *
*                                                                    *
*====================================================================*
               SPACE 1
    SECONSLE   CONSOLE=02F,ALTCONS=010,ROUTCDE=ALL,VALDCMD=(1,2,3)
    SECONSLE   CONSOLE=011,                                            +
               ALTCONS=010,                                            +
               ROUTCDE=ALL,                                            +
               VALDCMD=(1,2,3),                                        +
               PFK=12,                                                 +
               USE=FC
    SECONSLE   CONSOLE=009,ALTCONS=01F,ROUTCDE=ALL,VALDCMD=(1,2,3)
    SECONSLE   CONSOLE=01F,ALTCONS=009,ROUTCDE=ALL,VALDCMD=(1,2,3)
    SECONSLE   CONSOLE=O-30E
               EJECT ,
*====================================================================*
*                                                                    *
*        Optional access methods and data sets.                      *
*                                                                    *
*====================================================================*
               SPACE 1
    DATAMGT    ACSMETH=(BDAM,ISAM,BTAM,TCAM)
    DCMLIB
    GRAPHICS   PORRTNS=INCLUDE,GSP=EXCLUDE
    HELP
    IMAGELIB
    MACLIB     EXCLUDE=(QTAM,GPS,OCR)
    PARMLIB
    PROCLIB
    SORTLIB
    SORTMERG   SIZE=65536,RECTYPE=(FIXED,VAR,LONG),                    X
               CNTLFLD=(MULTIPLE),                                     X
               MESSAGE=(PRINTER,ALL),                                  +
               SORTDEV=(2311,2314,2301)
    SYSUTILS   SIZE=64K
    TELCMLIB
    UADS
    UCS        UNIT=1403,IMAGE=(AN,PN,TN),DEFAULT=(AN,PN,TN)
    UCS        UNIT=3211,IMAGE=(P11,T11),DEFAULT=(P11,T11)
               EJECT ,
*====================================================================*
*                                                                    *
*        Compilers and libraries.                                    *
*                                                                    *
*====================================================================*
               SPACE 1
    ALGOL
    ALGLIB
    ASSEMBLR   DESIGN=F
    CHECKER    TYPE=FORTRAN,DESIGN=H
    CHECKER    TYPE=PL1
    CMDLIB
    COBOL      DESIGN=E
    COBOL      DESIGN=U
    COBLIB     DESIGN=E
    COBLIB     DESIGN=U
    FORTRAN    DESIGN=G
    FORTRAN    DESIGN=H,SIZE=256K
    FORTLIB    DESIGN=H
    PL1        DESIGN=F
    PL1LIB
    RPG
               EJECT ,
*====================================================================*
*                                                                    *
*        Linkage editor and loader.                                  *
*                                                                    *
*====================================================================*
               SPACE 1
    EDITOR     DESIGN=F128,SIZE=128K
    LOADER
               EJECT ,
*====================================================================*
*                                                                    *
*        TSO options.                                                *
*                                                                    *
*====================================================================*
               SPACE 1
    OUTPUT     CLASS=(A,A)
               EJECT ,
*====================================================================*
*                                                                    *
*        Channel, control unit and device definitions.               *
*                                                                    *
*====================================================================*
               SPACE 1
*--------------------------------------------------------------------*
*        Channel 0:  Unit record, 3270, BSC.                         *
*--------------------------------------------------------------------*
    CHANNEL   ADDRESS=0,TYPE=MULTIPLEXOR
    IOCONTRL  ADDRESS=008,UNIT=2821,MODEL=5
    IODEVICE  ADDRESS=009,UNIT=3215
    IODEVICE  ADDRESS=00C,UNIT=2540R,MODEL=1
    IODEVICE  ADDRESS=00D,UNIT=2540P,MODEL=1
    IODEVICE  ADDRESS=00E,UNIT=1403,MODEL=N1,FEATURE=(UNVCHSET)
    IODEVICE  ADDRESS=00F,UNIT=1403,MODEL=N1,FEATURE=(UNVCHSET)
    IODEVICE  ADDRESS=010,UNIT=3158
    IODEVICE  ADDRESS=011,UNIT=3158
    IODEVICE  ADDRESS=014,UNIT=3158
    IODEVICE  ADDRESS=01F,UNIT=3215
    IOCONTRL  ADDRESS=090,UNIT=2703
    IODEVICE  ADDRESS=(090,8),UNIT=BSC1,ADAPTER=BSCA
    IOCONTRL  ADDRESS=0A0,UNIT=2703
    IODEVICE  ADDRESS=(0A0,8),UNIT=BSC2,FEATURE=(AUTOCALL,AUTOANSR),   +
               ADAPTER=BSCA
    IOCONTRL  ADDRESS=0B0,UNIT=2703
    IODEVICE  ADDRESS=(0B0,8),UNIT=BSC3,FEATURE=(AUTOPOLL),            +
               ADAPTER=BSCA
    IOCONTRL  ADDRESS=0C0,UNIT=3272,MODEL=2
    IODEVICE  ADDRESS=(0C0,8),UNIT=3277,MODEL=2,                       +
               FEATURE=(AUDALRM,EBKY3277,NUMLOCK,DOCHAR,KB78KEY)
*--------------------------------------------------------------------*
*        Channel 1:  Unit record, DASD.                              *
*--------------------------------------------------------------------*
    CHANNEL   ADDRESS=1,TYPE=BLKMPXR
    IOCONTRL  ADDRESS=102,UNIT=3811
    IODEVICE  ADDRESS=102,UNIT=3211
    IOCONTRL  ADDRESS=103,UNIT=3811
    IODEVICE  ADDRESS=103,UNIT=3211
    IOCONTRL  ADDRESS=108,UNIT=2821,MODEL=5
    IODEVICE  ADDRESS=10C,UNIT=2540R,MODEL=1
    IODEVICE  ADDRESS=10D,UNIT=2540P,MODEL=1
    IODEVICE  ADDRESS=10E,UNIT=1403,MODEL=N1,FEATURE=(UNVCHSET)
    IODEVICE  ADDRESS=10F,UNIT=1403,MODEL=N1,FEATURE=(UNVCHSET)
    IOCONTRL  ADDRESS=118,UNIT=2821,MODEL=5
    IODEVICE  ADDRESS=11E,UNIT=1403,MODEL=N1
    IODEVICE  ADDRESS=11F,UNIT=1403,MODEL=N1
    IOCONTRL  ADDRESS=120,UNIT=2841
    IODEVICE  ADDRESS=(120,8),UNIT=2311
    IODEVICE  ADDRESS=(130,8),UNIT=2314
    IODEVICE  ADDRESS=(150,8),UNIT=3330
    IODEVICE  ADDRESS=(158,8),UNIT=3330
*--------------------------------------------------------------------*
*        Channel 2:  DASD.                                           *
*--------------------------------------------------------------------*
    CHANNEL   ADDRESS=2,TYPE=BLKMPXR
    IODEVICE  ADDRESS=(230,8),UNIT=2314
    IODEVICE  ADDRESS=(250,8),UNIT=3330
    IODEVICE  ADDRESS=(258,8),UNIT=3330
*--------------------------------------------------------------------*
*        Channel 3:  DASD, unit record, 3270.                        *
*--------------------------------------------------------------------*
    CHANNEL   ADDRESS=3,TYPE=BLKMPXR
    IOCONTRL  ADDRESS=308,UNIT=2821,MODEL=5
    IODEVICE  ADDRESS=30E,UNIT=1403,MODEL=N1,FEATURE=(UNVCHSET)
    IODEVICE  ADDRESS=30F,UNIT=1403,MODEL=N1,FEATURE=(UNVCHSET)
    IODEVICE  ADDRESS=(330,8),UNIT=2314
    IODEVICE  ADDRESS=(350,8),UNIT=3330
    IODEVICE  ADDRESS=(358,8),UNIT=3330
    IOCONTRL  ADDRESS=3C0,UNIT=3272,MODEL=2
    IODEVICE  ADDRESS=(3C0,8),UNIT=3277,MODEL=2,                       +
               FEATURE=(AUDALRM,EBKY3277,NUMLOCK,DOCHAR,KB78KEY)
*--------------------------------------------------------------------*
*        Channel 5:  Tape.                                           *
*--------------------------------------------------------------------*
    CHANNEL   ADDRESS=5,TYPE=BLKMPXR
    IOCONTRL  ADDRESS=580,UNIT=3803,MODEL=2
    IODEVICE  ADDRESS=(580,8),UNIT=3420,FEATURE=OPT1600,MODEL=6
    IOCONTRL  ADDRESS=588,UNIT=3803,MODEL=2
    IODEVICE  ADDRESS=(588,8),UNIT=3420,FEATURE=OPT1600,MODEL=6
               EJECT ,
*====================================================================*
*                                                                    *
*        Esoteric unit names.                                        *
*                                                                    *
*====================================================================*
               SPACE 1
    UNITNAME  NAME=TAPE,                                               +
               UNIT=((580,8),(588,8))    3420
    UNITNAME  NAME=SYSALLDA,                                           +
               UNIT=((150,8),(158,8),    3330                          +
               (250,8),(258,8),          3330                          +
               (350,8),(358,8),          3330                          +
               (130,8),                  2314                          +
               (230,8),                  2314                          +
               (330,8),                  2314                          +
               (120,8))                  2311
    UNITNAME  NAME=SYSDA,                                              +
               UNIT=((150,8),(158,8),    3330                          +
               (250,8),(258,8),          3330                          +
               (350,8),(358,8))          3330
    UNITNAME  NAME=DISK,                                               +
               UNIT=((150,8),(158,8),    3330                          +
               (250,8),(258,8),          3330                          +
               (350,8),(358,8))          3330
    UNITNAME  NAME=SYSSQ,                                              +
               UNIT=((150,8),(158,8),    3330                          +
               (250,8),(258,8),          3330                          +
               (350,8),(358,8))          3330
    UNITNAME  NAME=SORT,                                               +
               UNIT=((130,8),            2314                          +
               (230,8),                  2314                          +
               (330,8))                  2314
    UNITNAME  NAME=SORTWORK,                                           +
               UNIT=((130,8),            2314                          +
               (230,8),                  2314                          +
               (330,8))                  2314
    UNITNAME  NAME=SORTWK,                                             +
               UNIT=((130,8),            2314                          +
               (230,8),                  2314                          +
               (330,8))                  2314
    UNITNAME  NAME=BSC1,                                               +
               UNIT=((090,8))            Nonswitched point-to-point BSC
    UNITNAME  NAME=BSC2,                                               +
               UNIT=((0A0,8))            Switched point-to-point BSC
    UNITNAME  NAME=BSC3,                                               +
               UNIT=((0B0,8))            Nonswitched multipoint BSC
               EJECT ,
*====================================================================*
*                                                                    *
*        ASP-related definitions.                                    *
*                                                                    *
*        o  SVCTABLE adds an SVC table entry for the ASP             *
*           type 1 SVC, SVC 246.                                     *
*        o  RESMODS includes the ASP SVC in the nucleus.             *
*        o  Device 02F is a 1052 CTC for intersystem                 *
*           communication.  It is defined as the master              *
*           console's alternate to give ASP a hook to capture        *
*           console traffic.                                         *
*        o  Devices 63F, 64F and 65F are 2400 channel to             *
*           channel adapters for intersystem communication           *
*           with other ASP systems when this system acts as          *
*           an ASP support processor.                                *
*        o  Devices (660,661,...,68E,68F) are 2400 channel           *
*           to channel adapters for spooled I/O.                     *
*        o  UNITNAME defines an esoteric for the 2400 CTCs.          *
*                                                                    *
*====================================================================*
               SPACE 1
    SVCTABLE  SVC-246-T1-S0
    RESMODS   PDS=SYS1.ASP,MEMBERS=(ASPSVC)
    IODEVICE  ADDRESS=02F,UNIT=1052,MODEL=7,FEATURE=CTC
    CHANNEL   ADDRESS=6,TYPE=BLKMPXR
    IOCONTRL  ADDRESS=638,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=63F,UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=648,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=64F,UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=658,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=65F,UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=660,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=(660,8),UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=668,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=(668,8),UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=670,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=(670,8),UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=678,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=(678,8),UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=680,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=(680,8),UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    IOCONTRL  ADDRESS=688,UNIT=2803,MODEL=1,FEATURE=7-TRACK
    IODEVICE  ADDRESS=(688,8),UNIT=2401,MODEL=1,FEATURE=(CTC,7-TRACK)
    UNITNAME  NAME=CTC,                                                +
               UNIT=((660,8),(668,8),    CTC                           +
               (670,8),(678,8),          CTC                           +
               (680,8),(688,8))          CTC
               EJECT ,
*====================================================================*
*                                                                    *
*          HASP-related definitions.                                 *
*                                                                    *
*        o  SVCTABLE adds an SVC table entry for the HASP            *
*           type 1 SVC, SVC 220.                                     *
*        o  Devices 700-70F are HASP pseudoreader devices.           *
*           700 is reserved for HASP HOSRDR use.                     *
*        o  Devices 720-74F are HASP pseudoprinter devices.          *
*           720 is reserved for HASP use in retrieving SMBs.         *
*        o  Devices 770-77F are HASP pseudopunch devices.            *
*        o  Devices 780-78F are HASP internal readers.               *
*        o  UNITNAME macros for R, A, B and INTRDR define            *
*           esoterics required by HASP for pseudodevices.            *
*                                                                    *
*====================================================================*
               SPACE 1
    SVCTABLE  SVC-220-T1-S0                      HASP SVC
    CHANNEL   ADDRESS=7,TYPE=BLKMPXR             HASP pseudo devices
    IODEVICE  ADDRESS=(700,16),UNIT=HASP-2540R   Pseudo readers
    IODEVICE  ADDRESS=(720,48),UNIT=HASP-1403    Pseudo printers
    IODEVICE  ADDRESS=(770,16),UNIT=HASP-2540P   Pseudo punches
    IODEVICE  ADDRESS=(780,16),UNIT=HASP-2520    Internal readers
    UNITNAME  UNIT=((701,15)),NAME=R             Pseudo readers
    UNITNAME  UNIT=((721,47)),NAME=A             Pseudo printers
    UNITNAME  UNIT=((770,16)),NAME=B             Pseudo punches
    UNITNAME  UNIT=((780,16)),NAME=INTRDR        Internal readers
               EJECT ,
*====================================================================*
*                                                                    *
*        User SVCs.                                                  *
*                                                                    *
*====================================================================*
               SPACE 1
    SVCTABLE  SVC-248-T4-S0
               EJECT ,
*====================================================================*
*                                                                    *
*        Generate.                                                   *
*                                                                    *
*====================================================================*
               SPACE 1
    PRINT      NOGEN
    GENTSO     GENTYPE=ALL,                Full system generation      +
               ASMPRT=ON,                  Print sysgen assemblies     +
               INDEX=MVT1,                 High level qualifier        +
               LEPRT=(LIST,XREF),          LKED system print options   +
               LNKNAME=3330,               LINKLIB device type         +
               LNKVOL=ASPRES,              LINKLIB volser              +
               OBJPDS=SYS1.OBJPDS,         Sysgen work PDS             +
               RESNAME=3330,               Sysres device type          +
               RESTYPE=3330,               Sysres device type          +
               RESVOL=ASPRES,              Sysres volser               +
               UT1SDS=SYS1.SYSUT1,         Sysgen work SDS             +
               UT2SDS=SYS1.SYSUT2,         Sysgen work SDS             +
               UT3SDS=SYS1.SYSUT3,         Sysgen work SDS             +
               UT4SDS=SYS1.SYSUT4          Sysgen work SDS
    END
//
    GENTSO     GENTYPE=ALL,                Full system generation      +
    GENTSO     GENTYPE=(IO,1),             I/O generation              +
               INDEX=SYS1,                 High level qualifier        +
