//G17POSTM JOB A,'G17POSTGEN-MVT',MSGCLASS=A,CLASS=A,COND=(7,LT)
//*********************************************************************
//*                                                                 ***
//*    Job:      G17POSTGEN-MVT                                     ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  ASP post-sysgen job for MVT.                       ***
//*    Update:   2006/08/18                                         ***
//*                                                                 ***
//*********************************************************************
//*
//*-----------------------------------------------------------------***
//*      RENAME IGG0190A IN SYS1.SVCLIB TO IGG0190$.                ***
//*-----------------------------------------------------------------***
//CTLPRG  EXEC PGM=ASPPROGM,
//             PARM='&REL,&RENAME,3330,ASPRES'
//STEPLIB  DD DISP=SHR,UNIT=SYSDA,VOL=SER=ASPSUP,DSN=ASP.ASPPGMS
//SYSPRINT DD SYSOUT=A
//SVCLIB   DD DSN=SYS1.SVCLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSIN    DD DSN=&&CTLCARDS,UNIT=SYSDA,SPACE=(TRK,(1,1))
//*
//*-----------------------------------------------------------------***
//*      LINK ASP-SUPPLIED VERSION OF IFG0192Z CTC OPEN SVC.        ***
//*-----------------------------------------------------------------***
//R21LSVC EXEC PGM=IEWL,PARM='NCAL,LIST,XREF,LET,RENT'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=&&UT1,UNIT=SYSDA,SPACE=(CYL,(5,1))
//SYSLMOD  DD DSN=SYS1.SVCLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//OBJ320   DD DSN=ASP.OBJ320,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPSUP
//SYSLIN   DD DDNAME=SYSIN
//SYSIN    DD *
  INCLUDE OBJ320(MVT0192Z)
 NAME  IFG0192Z(R)
/*
//*
//*-----------------------------------------------------------------***
//*      LINK ASP-SUPPLIED VERSION OF IFG0552X IF PTF               ***
//*      US05591 IS NOT INSTALLED.                                  ***
//*-----------------------------------------------------------------***
//R21LEOV EXEC PGM=IEWL,PARM='NCAL,LIST,XREF,LET,RENT'                       EOV
//SYSPRINT DD SYSOUT=A                                                       EOV
//SYSUT1   DD DSN=&&UT1,UNIT=SYSDA,SPACE=(CYL,(5,1))                         EOV
//SYSLMOD  DD DSN=SYS1.SVCLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES             EOV
//OBJ320   DD DSN=ASP.OBJ320,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPSUP
//SYSLIN   DD *
 INCLUDE OBJ320(IFG0552X)
 NAME IFG0552X(R)
/*                                                                           EOV
//*
//*-----------------------------------------------------------------***
//*      EXPAND LOAD MODULE IEFW21SD CSECT IEFW21SD USING           ***
//*      DELINK PROGRAM.                                            ***
//*-----------------------------------------------------------------***
//R21DLNK1 EXEC PGM=DELINK
//STEPLIB  DD DISP=SHR,UNIT=SYSDA,VOL=SER=ASPSUP,DSN=ASP.ASPPGMS
//SYSPRINT DD SYSOUT=A
//SYSLIB   DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSPUNCH DD DSN=&&TEMP21Q,DISP=(,PASS),UNIT=SYSDA,
// SPACE=(CYL,(1,1))
//SYSIN    DD *
> IEFW21SD IEFW21SD X'538'
/*
//*
//*-----------------------------------------------------------------***
//*      RELINK EXPANDED IEFW21SD INTO SYS1.LINKLIB.                ***
//*-----------------------------------------------------------------***
//R21RLNK1 EXEC PGM=IEWL,PARM='NCAL,LIST,XREF,LET'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=&&UT1,UNIT=SYSDA,SPACE=(CYL,(5,1))
//SYSLMOD  DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSLIN   DD DSN=&&TEMP21Q,DISP=(OLD,DELETE)
//         DD DDNAME=SYSIN
//SYSIN    DD *
 INCLUDE SYSLMOD(IEFW21SD)
 ALIAS   IEFVM1,IEFXA,IEFVMCVL
 ENTRY   IEFW21SD
 SETSSI 00200000
 NAME    IEFW21SD(R)
/*
//*
//*-----------------------------------------------------------------***
//*      EXPAND LOAD MODULE IEFSD061 CSECT IEFW42SD USING           ***
//*      DELINK PROGRAM.                                            ***
//*-----------------------------------------------------------------***
//R21DLNK2 EXEC PGM=DELINK
//STEPLIB  DD DISP=SHR,UNIT=SYSDA,VOL=SER=ASPSUP,DSN=ASP.ASPPGMS
//SYSPRINT DD SYSOUT=A
//SYSLIB   DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSPUNCH DD DSN=&&TEMP42Q,DISP=(,PASS),UNIT=SYSDA,
// SPACE=(CYL,(1,1))
//SYSIN    DD *
> IEFSD061 IEFW42SD X'1B0'
/*
//*
//*-----------------------------------------------------------------***
//*      RELINK EXPANDED IEFSD061 INTO SYS1.LINKLIB.                ***
//*-----------------------------------------------------------------***
//R21RLNK2 EXEC PGM=IEWL,PARM='NCAL,LIST,XREF,LET,RENT'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=&&UT1,UNIT=SYSDA,SPACE=(CYL,(5,1))
//SYSLMOD  DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSLIN   DD DSN=&&TEMP42Q,DISP=(OLD,DELETE)
//         DD DDNAME=SYSIN
//SYSIN    DD *
 INCLUDE SYSLMOD(IEFSD061)
 ALIAS IEFSD064,IEFW42SD,IEFSD104
 ENTRY IEFSD061
 SETSSI 00200000
 NAME IEFSD061(R)
/*
//*
//*-----------------------------------------------------------------***
//*      EXPAND LOAD MODULE IGC0003E CSECT IGC0003E USING           ***
//*      DELINK PROGRAM.                                            ***
//*-----------------------------------------------------------------***
//R21DLNK3 EXEC PGM=DELINK
//STEPLIB  DD DISP=SHR,UNIT=SYSDA,VOL=SER=ASPSUP,DSN=ASP.ASPPGMS
//SYSPRINT DD SYSOUT=A
//SYSLIB   DD DSN=SYS1.SVCLIB,UNIT=SYSDA,VOL=SER=ASPRES,DISP=SHR
//SYSPUNCH DD DSN=&&TEMP63Q,DISP=(,PASS),UNIT=SYSDA,SPACE=(TRK,1)
//SYSIN    DD *
> IGC0003E IGC0003E X'360'
/*
//*
//*-----------------------------------------------------------------***
//*      RELINK EXPANDED IGC0003E INTO SYS1.SVCLIB.                 ***
//*-----------------------------------------------------------------***
//R21RLNK3 EXEC PGM=IEWL,PARM='NCAL,LIST,XREF,LET,RENT'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=&&UT1,UNIT=SYSDA,SPACE=(TRK,2)
//SYSLMOD  DD DSN=SYS1.SVCLIB,UNIT=SYSDA,VOL=SER=ASPRES,DISP=SHR
//SYSLIN   DD DSN=&&TEMP63Q,DISP=(OLD,DELETE)
//         DD DDNAME=SYSIN
//SYSIN    DD *
 SETSSI 00200000
 NAME IGC0003E(R)
/*
//*
//*-----------------------------------------------------------------***
//*      EXPAND LOAD MODULE IEFLOCDQ CSECT IEFLOCDQ USING           ***
//*      DELINK PROGRAM.                                            ***
//*-----------------------------------------------------------------***
//DLNKLOC EXEC PGM=DELINK
//STEPLIB  DD DISP=SHR,UNIT=SYSDA,VOL=SER=ASPSUP,DSN=ASP.ASPPGMS
//SYSPRINT DD SYSOUT=A
//SYSLIB   DD DSN=SYS1.CI505,UNIT=SYSDA,VOL=SER=ASPDLB,DISP=SHR
//SYSPUNCH DD DSN=&&LOCTEMP,DISP=(,PASS),UNIT=SYSDA,SPACE=(TRK,(5,5))
//SYSIN    DD *
>  IEFLOCDQ IEFLOCDQ X'520'
/*
//*
//*-----------------------------------------------------------------***
//*      RELINK EXPANDED IEFLOCDQ INTO SYS1.LINKLIB.                ***
//*-----------------------------------------------------------------***
//RLNKLOC  EXEC PGM=IEWL,PARM='LIST,XREF,NCAL,REFR,LET'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=&&UT1,UNIT=SYSDA,SPACE=(CYL,(2,1))
//SYSLMOD  DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSLIN   DD DSN=&&LOCTEMP,DISP=(SHR,DELETE)
//         DD DDNAME=SYSIN
//SYSIN    DD *
 INCLUDE SYSLMOD(IEFLOCDQ)
 ALIAS LOC,LOCCAN,LOCDQ
 ENTRY  IEFLOCDQ
 NAME IEFLOCDQ(R)
/*
//*
//*-----------------------------------------------------------------***
//*      ZAPS FOR SVCLIB.                                           ***
//*-----------------------------------------------------------------***
//R21ZSVC  EXEC PGM=IMASPZAP
//STEPLIB  DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSPRINT DD SYSOUT=A
//SYSLIB   DD DSN=SYS1.SVCLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSIN    DD *
*   2002/11/10 @KL CHANGE XCTL TABLE ENTRY TO POINT TO IFG0192Z CTC OPEN
 NAME    IFG0193A IFG0193A
 VER     03DC  F3C2         DC C'3B',0C'           ID OF IFG0193B
 REP     03DC  F2E9         DC C'2Z',0C'           ID OF IFG0192Z
 IDRDATA ASP
**********************************************************************
*   PREVENT WRONG VOLUME MOUNTED PROCESSING  FOR CTC DEVICES
 NAME   IFG0194C IFG0194C
 VER    0080  4770,30A8     BNE  ODA71200          DEMOUNT WRONG VOLUME
 VER    01B6  0000,0000     VERIFY PATCH AREA
 VER    01BA  0000,0000     VERIFY PATCH AREA
 VER    01BE  0000,0000     VERIFY PATCH AREA
 REP    0080  4770,31B4     B    TO PATCH AREA
 REP    01B6  9504,A011     CLI  UCBTBYT2,X'04'    IS IT CTC?
 REP    01BA  4770,30A8     BNE  ODA71200          NO,DEMOUNT WRONG VOLUME
 REP    01BE  47F0,3102     B    ODA71600          ABEND CALLER
 IDRDATA ASP
**********************************************************************
*   2002/11/17 @kl PREVENT SENSE OPERATION ON CTC DEVICE BY TAPE OPEN
 NAME   IFG0194H IFG0194H
 VER    023E  45B0,3326     BAL  RB,OTA14400
 VER    0296  45B0,3326     BAL  RB,OTA14400
 VER    03E0  0000,0000     VERIFY THE PATCH AREA
 VER    03E4  0000,0000     VERIFY THE PATCH AREA
 VER    03E8  0000,0000     VERIFY THE PATCH AREA
 REP    023E  45B0,33DE     BAL  TO PATCH AREA
 REP    0296  45B0,33DE     BAL  TO PATCH AREA
 REP    03E0  9504,A011     CLI  UCBTBYT2,X'04'    CTC DEVICE?
 REP    03E4  4780,3364     BE   OTA14800          SKIP SENSE IF SO
 REP    03E8  47F0,3326     B    OTA14400          ELSE GO DO SENSE
 IDRDATA ASP
**********************************************************************
*   2002/11/17 @kl TREAT CTC AS SEPARATE DEVICE TYPE FOR
*                  CONCATENATION OF UNLIKE DEVICES
*        FOLLOWING ZAP ADDED FOR REL 21.8
*  NOTE THIS ZAP IS DEPENDENT UPON IFG0552X BEING PREVIOUSLY LINK
*  EDITED FROM THE OBJECT MODULE AVAILABLE ON THIS JOB STREAM. THE
*  STANDARD REL 21.8 IFG0552X DOES NOT HAVE A PATCH AREA.
 NAME   IFG0552X IFG0552X
 VER    01A8  4700,31A6   BC  0,*
 VER    01AC  4700,31AA   BC  0,*
 REP    01A8  9504,E011   CLI  UCBTBYT2,X'04' IS THIS CTC
 REP    01AC  4780,338A   BE  ECM62800  YES,ABEND USER
 IDRDATA ASP
**********************************************************************
*   2002/11/10 @KL CHANGE ABDUMP MAX BLKSIZE FROM 1632 TO 882
 NAME   IGC0L05A IGC0L05A
 VER    035A 0660
 REP    035A 0372
 IDRDATA ASP
**********************************************************************
*   CHANGE ABEND DCB BLKSIZE FROM 1632 TO 882
 NAME   IGC0801C IGC0801C  CHANGE ABEND DCB BLKSIZE FROM 1632 TO 882
 VER    02AE 0660
 REP    02AE 0372
 IDRDATA ASP
**********************************************************************
*   2002/11/10 @KL ZAP TO REMOVE THE BACK SPACE CHARACTER CHECK
 NAME   IGC0107B IEECVPM
 VER    00DE 4780C0EC        BE    PMBKSL
 VER    00F2 4770C100        BNE   *+16
 REP    00DE 4770C0EC        BNE   PMBKSL
 REP    00F2 47F0C100        B     *+16
 IDRDATA ASP
**********************************************************************
*   2006/07/02 @KL ZAP TO PREVENT REMOVAL OF X'15' NEWLINE CHARACTERS
 NAME   IGC0107B IEECVPM
 VER    02A0 4770C2A6        BNE   A0002A8   Continue if not newline
 REP    02A0 47F0C2A6        B     A0002A8   Skip changing newline to blank
 IDRDATA ASP
**********************************************************************
*   ZAP TO BYPASS SECOND TRANSLATE WHEN SECOND QUOTE IS FOUND IN MESSAGE
 NAME   IGC5403D IEE5403D
 VER    00DC  478030AC
 REP    00DC  478030E2
 IDRDATA ASP
**********************************************************************
*   CREATE CALLING SEQUENCE FOR RESIDENT ROUTINE
*   WHICH PLACES JOBNAME IN WTO TEXT
 NAME   IGC0003E IGC0003E   MICROFICHE NAME IS IEEMVWTO (REL 21.7 MCS)
 VER    01D6  58F0,A03C
 VER    0320  4040          VERIFY THE PATCH AREA
 VER    0322  4040,4040     VERIFY THE PATCH AREA
 VER    0326  4040          VERIFY THE PATCH AREA
 VER    0328  4040          VERIFY THE PATCH AREA
 VER    032A  4040,4040     VERIFY THE PATCH AREA
 VER    032E  4040,4040     VERIFY THE PATCH AREA
 REP    01D6  47F0,B31E     B    SVC245 ENTER SVC CALLING SEQUENCE
 REP    0320  1831          LR   R3,R1  SAVE R1 ACROSS SVC ROUTINE
 REP    0322  41F0,000C     LA   R15,12 FUNCTION CODE FOR SVC ENTRY POINT
 REP    0326  0AF6          SVC  246   ENTER RESIDENT ROUTINE
 REP    0328  1813          LR   R1,R3  RESTORE R1 (WQE ADDR)
 REP    032A  58F0,A03C     L    R15,UCMWQEND PTR TO LAST WQE ON CHAIN
 REP    032E  47F0,B1D8     B    LINKWQE+4 CONTINUE IN MAINLINE CODE
 IDRDATA ASP
**********************************************************************
//*
//*-----------------------------------------------------------------***
//*      ZAPS FOR LINKLIB.                                          ***
//*-----------------------------------------------------------------***
//R21ZLNK  EXEC PGM=IMASPZAP
//STEPLIB  DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSPRINT DD SYSOUT=A
//SYSLIB   DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSIN    DD *
*   ISSUE THE ASP UNIT ISOLATION SVC
 NAME   IEFW21SD IEFW21SD
 VER    00A6  5840C010            L   R4,LCTJCTAD    LOAD JCT ADDR FROM LCT
 VER    0520  40404040            VERIFY PATCH AREA
 VER    0524  4040,4040           VERIFY THE PATCH AREA
 VER    0528  4040,4040           VERIFY THE PATCH AREA
 VER    052C  4040                VERIFY THE PATCH AREA
 VER    052E  4040,4040           VERIFY THE PATCH AREA
 REP    00A6  47F0951A            B   PATCH
 REP    0520  5840C010            EXECUTE OVERLAID INSTRUCTION
 REP    0524  41104008            LA  R1,JCTJNAME    POINT TO JOBNAME
 REP    0528  41F00010            LA  R15,16         INDICATE ALLOCATE ENTRY
 REP    052C  0AF6                SVC 246            ISSUE UNIT ISOL SVC
 REP    052E  47F090A4            B   MAINLINE       RETURN
 IDRDATA ASP
**********************************************************************
*   ISSUE THE ASP UNIT ISOLATION SVC
 NAME   IEFSD061 IEFW42SD
 VER    006A  915C,3005           TM  JCTJSTAT,INCMSTS+JCTJOBFL+JCTABEND+JCTSTP
 VER    018C  4040,4040           INSURE DELINK EXPANSION
 REP    006A  47F0,9186           B  PATCH AREA
 REP    018C  41F0,0014           LA  R15,20
 REP    0190  4110,3008           LA  R1,JCTJNAME
 REP    0194  0AF6                SVC  246
 REP    0196  915C,3005           TM  - - -  OVERLAID INSTRUCTION
 REP    019A  47F0,9068           B  MAINLINE
 IDRDATA ASP
**********************************************************************
*   NOP R/I SVC 34 FOR EXPRESS CANCEL (21.0)
 NAME   IEFVHA  IEFVHH
 VER    04E6  4780B53E      BE  C9          BRANCH AROUND CANCEL CMD
 REP    04E6  47F0B53E      B   C9
 IDRDATA ASP
***********************************************************************
*   ADD MAINTASK NAME TO SYSTEM TASK TBL
 NAME   IEEVLNKT  IEEVLNKT        ADD MAINTASK NAME TO SYSTEM TASK TBL
 VER    0018  C9C8D2D9D1C2C7D5    IHKRJBGN  RJE READER TASK
 REP    0018  D4C1C9D5E3C1E2D2    MAINTASK  ASP TASK ON MAIN
 IDRDATA ASP
***********************************************************************
*   THE FOLLOWING ZAP ELIMINATES REDUNDANT POSTING OF IDLE O/S INITIATORS
 NAME   IEFQMNQ2 IEFQMNQ2   MICROFISCHE NAME IEFQMNQQ
 VER    010E  1817          LR  R1,R7       LOAD ADDR OF ECB
 VER    0110  1B00          SR  0,0         SET CODE VALUE OF 0
 VER    0112  41101000      LA  R1,0(R1)    CLER HIGH ORDR BYTE
 VER    0116  0A02          SVC 2
 VER    0118  58770004      L   R7,4(R7)    LOAD ADDR OF NXT CTO AREA
 VER    011C  47F0          BC  15,QMENQ015 BR TO TEST NEXT TASK
 REP    010E  41107000      LA  R1,0(R7)    GET ECB ADDR
 REP    0112  1B00          SR  0,0         SET CODE VALUE OF 0
 REP    0114  0A02          SVC 2
 REP    0116  D20290217005  MVC             MOVE QCR
 REP    011C  47F0815C      B   QMENQ050    BR TO CHECK TRACK STACKING
 IDRDATA ASP
**********************************************************************
*   THE FOLLOWING CODE BYPASSES REWIND UNLOAD FOR CTC TAPE DEVICES
 NAME   IEFWD000 IEFWD002   MICROFICHE NAME IS IEFWD000 (21.8)
 VER    006E  9140,D006     TM  UCBFLG2,NOTREADY
 VER    0424  4110,1000     VERIFY PATCH AREA
 REP    006E  47F0,9422     B  XPS757
*      THE FOLLOWING PATCH OVERLAYS CODE USED FOR PCP ONLY
 REP    0424  9504,D011     CLI  UCBTBYT2,CTC  CTC DEVICE?
 REP    0428  078E          BCR  8,R14  YES-RETURN
 REP    042A  9140,D006     TM  UCBFLG2,NOTREADY  TAPE NOT READY?
 REP    042E  071E          BCR  CONES,R14  YES-RETURN
 REP    0430  47F0,9072     B  MAINLINE  RETURN TO MAINSTREAM
 IDRDATA ASP
***********************************************************************
*   THE FOLLOWING ZAP PREVENTS A 30A ABEND WHEN ASP USES
*   THE O/S READER INTERPRETER
 NAME   IEFVH1
 VER    01A0  4720B108         BC  2,J02
 REP    01A0  4700             NOP
 IDRDATA ASP
/*
//*
//*-----------------------------------------------------------------***
//*      STAGE READER/INTERPRETER MODULES IN TEMPORARY LIBRARY.     ***
//*-----------------------------------------------------------------***
//TEMPRI   EXEC PGM=IEWL,PARM='XREF,LIST,NCAL,RENT,REFR'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD SPACE=(CYL,(1,1)),UNIT=SYSDA
//SYSLMOD  DD UNIT=SYSDA,DSN=&&TEMPRI,SPACE=(CYL,(5,1,5)),DISP=(,PASS)
//DD1      DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSLIN   DD DDNAME=SYSIN
//TEMPRI.SYSIN DD *
  INCLUDE DD1(IEFVHA)
  ALIAS IEFVHCB,IEFVHREP,IEFVHF
  ENTRY   IEFVHA
 NAME     IEFVHA(R)
  INCLUDE DD1(IEFMVTHR)
  ALIAS   IEFHRFK2
 NAME     IEFMVTHR(R)
  INCLUDE DD1(IEFMVTJA)
  ALIAS   IEFVJA
  ENTRY   IEFVJA
 NAME     IEFMVTJA(R)
  INCLUDE DD1(IEFVINA)
  ENTRY   IEFVINA
 NAME     IEFVINA(R)
  INCLUDE DD1(IEZDCODE)
 NAME     IEZDCODE(R)
/*
//*
//*-----------------------------------------------------------------***
//*      MAKE READER/INTERPRETER MODULES LOOK REENTRANT.            ***
//*-----------------------------------------------------------------***
//RENTCODE EXEC PGM=PDSEDIT
//STEPLIB  DD DISP=SHR,UNIT=SYSDA,VOL=SER=ASPSUP,DSN=ASP.ASPPGMS
//LINKLIB  DD DSN=&&TEMPRI,DISP=(SHR,PASS)
//*
//*-----------------------------------------------------------------***
//*      LINK MODIFIED R/I MODULES BACK INTO SYS1.LINKLIB.          ***
//*-----------------------------------------------------------------***
//RILINK   EXEC PGM=IEWL,PARM='XREF,LIST,NCAL,RENT,REFR'
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD UNIT=SYSDA,SPACE=(CYL,(2,1))
//DD1      DD DSN=&&TEMPRI,DISP=(OLD,PASS)
//SYSLMOD  DD DSN=SYS1.LINKLIB,UNIT=SYSDA,DISP=SHR,VOL=SER=ASPRES
//SYSLIN   DD DDNAME=SYSIN
//SYSIN    DD *
  INCLUDE DD1(IEFVHA)
  ALIAS IEFVHCB
  ALIAS IEFVHREP
  ALIAS IEFVHF
  ENTRY IEFVHA
 NAME   IEFVHA(R)
  INCLUDE DD1(IEFMVTHR)
  ALIAS IEFHRFK2
 NAME   IEFMVTHR(R)
  INCLUDE DD1(IEFMVTJA)
  ALIAS IEFVJA
  ENTRY IEFVJA
 NAME   IEFMVTJA(R)
  INCLUDE DD1(IEFVINA)
  ENTRY IEFVINA
 NAME   IEFVINA(R)
  INCLUDE DD1(IEZDCODE)
 NAME   IEZDCODE(R)
/*
//*
//*-----------------------------------------------------------------***
//*      UPDATE TTR LIST IN SYS1.SVCLIB.                            ***
//*-----------------------------------------------------------------***
//IOSUP   EXEC PGM=IEHIOSUP,PARM=TSO
//STEPLIB  DD DSN=SYS1.LINKLIB,VOL=SER=ASPRES,UNIT=SYSDA,DISP=SHR
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=SYS1.SVCLIB,UNIT=SYSDA,DISP=OLD,VOL=SER=ASPRES
//
