//G20PARML JOB  1,'G20PARMLIB',CLASS=A,MSGLEVEL=(1,1)
//*********************************************************************
//*                                                                 ***
//*    Job:      G20PARMLIB                                         ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  Update SYS1.PARMLIB on new system with ASP         ***
//*              parms, PRESRES list, SMF, TSO parameters,          ***
//*              COMMND00.                                          ***
//*    Update:   2006/09/02                                         ***
//*                                                                 ***
//*********************************************************************
//*
//UPDTE  EXEC PGM=IEBUPDTE,PARM=NEW
//SYSPRINT DD  SYSOUT=A
//SYSUT2   DD  DISP=SHR,DSN=SYS1.PARMLIB,UNIT=SYSDA,VOL=SER=ASPRES
//SYSIN    DD  DATA
./ ADD NAME=ASPFMT
*/********************************************************************/
*/*                                                                  */
*/*    MEMBER:      ASPFMT                                           */
*/*    PURPOSE:     ASP START TYPE AND TRACK INITIALIZATION          */
*/*                 PARAMETERS FOR COLD START WITH FORMAT.           */
*/*    UPDATE:      2006/07/03                                       */
*/*                                                                  */
*/********************************************************************/
*
*/*------------------------------------------------------------------*/
*/*    "COLDSTART" AND "FORMAT" ASPIO PARAMETERS FOR COLD            */
*/*    START WITH FORMAT.                                            */
*/*------------------------------------------------------------------*/
COLDSTART
FORMAT,DDNAME=QUEUE1
*
./ ADD NAME=ASPCOLD
*/********************************************************************/
*/*                                                                  */
*/*    MEMBER:      ASPCOLD                                          */
*/*    PURPOSE:     ASP START TYPE AND TRACK INITIALIZATION          */
*/*                 PARAMETERS FOR COLD START WITHOUT FORMAT.        */
*/*    UPDATE:      2006/07/03                                       */
*/*                                                                  */
*/********************************************************************/
*
*/*------------------------------------------------------------------*/
*/*    "COLDSTART" AND "TRACK" ASPIO PARAMETERS FOR COLD             */
*/*    START WITHOUT FORMAT.                                         */
*/*------------------------------------------------------------------*/
COLDSTART
TRACK,DDNAME=QUEUE1
*
./ ADD NAME=ASPWARM
*/********************************************************************/
*/*                                                                  */
*/*    MEMBER:      ASPWARM                                          */
*/*    PURPOSE:     ASP START TYPE AND TRACK INITIALIZATION          */
*/*                 PARAMETERS FOR WARM START.                       */
*/*    UPDATE:      2006/07/03                                       */
*/*                                                                  */
*/********************************************************************/
*
*/*------------------------------------------------------------------*/
*/*    "RESTART" AND "TRACK" ASPIO PARAMETERS FOR WARM START.        */
*/*------------------------------------------------------------------*/
RESTART
TRACK,DDNAME=QUEUE1
*
./ ADD NAME=ASPLOCAL
*/********************************************************************/
*/*                                                                  */
*/*    MEMBER:      ASPLOCAL                                         */
*/*    PURPOSE:     ASP INITIALIZATION PARAMETERS FOR LOCAL MAIN.    */
*/*    UPDATE:      2006/09/02                                       */
*/*                                                                  */
*/********************************************************************/
*
*/*------------------------------------------------------------------*/
*/*    RESIDUAL ASPIO PARAMETERS.                                    */
*/*------------------------------------------------------------------*/
BUFFER,BUFSIZE=1952,RECORDS=6,IOBS=3,DASD=3330,AMOUNT=60,TAT=FULL
OPTIONS,ADDSAVE=32,DUMP=ASP,TRACE=500
ASPCORE,MINCORE=18K,MARGCORE=20K,ASPOOL=1
ENDASPIO
*
*/*------------------------------------------------------------------*/
*/*    JOB SELECTION MODES FOR MAINS.                                */
*/*------------------------------------------------------------------*/
SELECT,NAME=ASP1,MINIT=6,MBAR=15,DISPLAY=MLOG,SBAR=15,SDEPTH=255
*
*/*------------------------------------------------------------------*/
*/*    ASP1 LOCAL MAIN.                                              */
*/*------------------------------------------------------------------*/
*ADAPTER= is MPADAPT and MPDEVADD, MAINCTC= is MPCTC
MAINPROC,NAME=ASP1,ID=ASP1,MDEST=M1,SYSTEM=LOCAL,SMFID=AS,MODEL=SP1,   +
ADAPTER=02F,MAINCTC=02F,                                               +
SELECT=ASP1,CTCCUA=(6,7,8),JOBCLASS=(B,C)
DEVICE,STYPE=MAIN,GTYPE=SYS,SUPPORT=(02F,ASP1,M1,ON)
*
*/*------------------------------------------------------------------*/
*/*    CLASS AND GROUP DEFINITION.                                   */
*/*------------------------------------------------------------------*/
CLASS,NAME=ASPBATCH,GROUP=ASPBATCH
CLASS,NAME=A,GROUP=ASPBATCH
CLASS,NAME=B,GROUP=ASPBATCH
CLASS,NAME=C,GROUP=ASPBATCH
CLASS,NAME=D,GROUP=ASPBATCH
CLASS,NAME=E,GROUP=ASPBATCH
CLASS,NAME=F,GROUP=ASPBATCH
CLASS,NAME=G,GROUP=ASPBATCH
CLASS,NAME=H,GROUP=ASPBATCH
CLASS,NAME=I,GROUP=ASPBATCH
CLASS,NAME=J,GROUP=ASPBATCH
CLASS,NAME=K,GROUP=ASPBATCH
CLASS,NAME=L,GROUP=ASPBATCH
CLASS,NAME=M,GROUP=ASPBATCH
CLASS,NAME=N,GROUP=ASPBATCH
CLASS,NAME=O,GROUP=ASPBATCH
CLASS,NAME=P,GROUP=ASPBATCH
CLASS,NAME=Q,GROUP=ASPBATCH
CLASS,NAME=R,GROUP=ASPBATCH
CLASS,NAME=S,GROUP=ASPBATCH
CLASS,NAME=T,GROUP=ASPBATCH
CLASS,NAME=U,GROUP=ASPBATCH
CLASS,NAME=V,GROUP=ASPBATCH
CLASS,NAME=W,GROUP=ASPBATCH
CLASS,NAME=X,GROUP=ASPBATCH
CLASS,NAME=Y,GROUP=ASPBATCH
CLASS,NAME=Z,GROUP=ASPBATCH
CLASS,NAME=0,GROUP=ASPBATCH
CLASS,NAME=1,GROUP=ASPBATCH
CLASS,NAME=2,GROUP=ASPBATCH
CLASS,NAME=3,GROUP=ASPBATCH
CLASS,NAME=4,GROUP=ASPBATCH
CLASS,NAME=5,GROUP=ASPBATCH
CLASS,NAME=6,GROUP=ASPBATCH
CLASS,NAME=7,GROUP=ASPBATCH
CLASS,NAME=8,GROUP=ASPBATCH
CLASS,NAME=9,GROUP=ASPBATCH
*GROUP,NAME=ASPBATCH,EXRESC=(ASP1,3,,IPL,MANUAL),PRTY=1
*GROUP,NAME=ASPBATCH,EXRESC=(ASP1,3,,DYNAMIC,MANUAL),PRTY=1
GROUP,NAME=ASPBATCH,EXRESC=(ASP1,0,,DYNAMIC,DYNAMIC),PRTY=1
*
*/*------------------------------------------------------------------*/
*/*    ASP1 DEVICES.                                                 */
*/*------------------------------------------------------------------*/
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(580,TA580,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(580,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(581,TA581,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(581,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(582,TA582,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(582,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(583,TA583,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(583,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(584,TA584,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(584,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(585,TA585,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(585,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(586,TA586,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(586,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(587,TA587,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(587,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(588,TA588,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(588,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(589,TA589,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(589,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(589,TA58A,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58A,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58B,TA58B,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58B,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58C,TA58C,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58C,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58D,TA58D,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58D,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58E,TA58E,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58E,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58F,TA58F,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58F,ASP1,S1)
*
*/*------------------------------------------------------------------*/
*/*    MDS.                                                          */
*/*------------------------------------------------------------------*/
SETNAME,MTYPE=24009,NAMES=(TAPE,3400-3,3400-5,3400-6,2400-3)
SETPARAM,ADDRSORT=YES,ALLOCATE=AUTO,DEPTH=255,MDSLOG=M1,REMOUNT=1
*
*/*------------------------------------------------------------------*/
*/*    READER/INTERPRETER.                                           */
*/*------------------------------------------------------------------*/
DEVICE,STYPE=OSRDR,SUPPORT=(NONE,RI1),GTYPE=ARI
*DEVICE,STYPE=OSRDR,SUPPORT=(NONE,RI2),GTYPE=ARI
RIDATSTN,SYS1.PROCLIB,SYS1.LINKLIB,SYS1.MACLIB,SYS1.SVCLIB
RIDATSTN,ASP.PSGLIB,ASP.MACINT,ASP.MACDUMMY,ASP.SOURCE
RI,BLDL=(ASMFC,ASMFCL,ASMFCLG),TAFETCH=S8,DAFETCH=S9
RIPARM,PARM=(00099905001024925631SYSDA   E00011A)
*
*/*------------------------------------------------------------------*/
*/*    CONSOLES.                                                     */
*/*------------------------------------------------------------------*/
CONSOLE,DDNAME=CN01F,TYPE=3215,UNIT=01F,DEPTH=99,DEST=OUTPUT,MAIN=ASP1,+
ALTCON=CN014
CONSOLE,DDNAME=CN014,TYPE=3277,UNIT=014,TIME=0,DEST=OUTPUT,MAIN=ASP1,  +
ALTCON=CN01F,DEPTH=99
CONSOLE,DDNAME=CN30F,TYPE=1403,UNIT=30F,DEPTH=99,DEST=MLG,MAIN=ASP1
*
*/*------------------------------------------------------------------*/
*/*    CONSOLE PROGRAM FUNCTION KEY DEFINITION.                      */
*/*------------------------------------------------------------------*/
PFK,K=1,M=<*I A>
PFK,K=2,M=<*I S>
*
*/*------------------------------------------------------------------*/
*/*    SUPPORT DEVICES.                                              */
*/*------------------------------------------------------------------*/
DEVICE,GTYPE=RDR,STYPE=2540P,SUPPORT=(00C,RD1,UR)
DEVICE,GTYPE=PUN,STYPE=2540R,SUPPORT=(00D,PU1,UR)
DEVICE,GTYPE=PRT,STYPE=1403,SUPPORT=(00E,PR1,UR)
DEVICE,STYPE=IJMP,SUPPORT=(NONE,IJASP1),GTYPE=IJM
DEVICE,STYPE=ACMP,SUPPORT=(NONE,ACASP1),GTYPE=ACM
*
*/*------------------------------------------------------------------*/
*/*    PRINT SETUP.                                                  */
*/*------------------------------------------------------------------*/
PRINTER,NAME=PR1,UCS=YES,FORMS=(YES,1PART),CARRIAGE=6#IN,              +
TRAIN=(NO,TN)
SYSOUT,CLASS=A
SYSOUT,CLASS=B,TYPE=PUNCH,COPIES=1
SYSOUT,CLASS=K,TYPE=PUNCH
SYSOUT,CLASS=T,TYPE=TSO
*
*/*------------------------------------------------------------------*/
*/*    RESIDENCY OPTIONS.                                            */
*/*------------------------------------------------------------------*/
RESCTLBK,RQ=10,ASG=10,FCT=05,VUT=05
RESIDENT,MODULE=JSS
RESIDENT,MODULE=MDSALLOC
RESIDENT,MODULE=ISNET
RESIDENT,MODULE=DJCUPDAT
RESIDENT,MODULE=RICBSCAN
RESIDENT,MODULE=RICONTL
RESIDENT,MODULE=IEFVHA
*
*/*------------------------------------------------------------------*/
*/*    STANDARDS.                                                    */
*/*------------------------------------------------------------------*/
STANDARDS,LINES=(100,W),CARDS=(50,W),FORMS=1PART,CARRIAGE=6#IN,        +
TRAIN=TN,FLOCATE=YES,DLOCATE=YES,CLASS=B,FAILURE=CANCEL,               +
NOPU=H,                                                                X
SEQCHK=YES,                                                            X
SQS=3K,NJPNAME=ASP,CONSBUF=50,MLOG=YES
*/*------------------------------------------------------------------*/
*/*    RJP.                                                          */
*/*------------------------------------------------------------------*/
*      /*------ NO RJP DEVICES DEFINED ------------------------------*/
*
*/*------------------------------------------------------------------*/
*/*    END OF ASP INITIALIZATION PARMS.                              */
*/*------------------------------------------------------------------*/
ENDINISH
*
*/*------------------------------------------------------------------*/
*/*    IPL TEXT FOR ASP1 LOCAL MAIN.                                 */
*/*------------------------------------------------------------------*/
IPL,NAME=ASP1,TYPE=MVT
IPL,END
./ ADD NAME=ASPREAL
*/********************************************************************/
*/*                                                                  */
*/*    MEMBER:      ASPREAL                                          */
*/*    PURPOSE:     ASP INITIALIZATION PARAMETERS FOR COMPLEX        */
*/*                 WITH LOCAL MAIN AND REAL MAINS.                  */
*/*    UPDATE:      2006/09/02                                       */
*/*                                                                  */
*/********************************************************************/
*
*/*------------------------------------------------------------------*/
*/*    RESIDUAL ASPIO PARAMETERS.                                    */
*/*------------------------------------------------------------------*/
BUFFER,BUFSIZE=1952,RECORDS=6,IOBS=3,DASD=3330,AMOUNT=60,TAT=FULL
OPTIONS,ADDSAVE=32,DUMP=ASP,TRACE=500
ASPCORE,MINCORE=18K,MARGCORE=20K,ASPOOL=1
ENDASPIO
*
*/*------------------------------------------------------------------*/
*/*    JOB SELECTION MODES FOR MAINS.                                */
*/*------------------------------------------------------------------*/
SELECT,NAME=ASP1,MINIT=6,MBAR=15,DISPLAY=MLOG,SBAR=15,SDEPTH=255
SELECT,NAME=ASP2,MINIT=6,MBAR=15,DISPLAY=MLOG,SBAR=15,SDEPTH=255
SELECT,NAME=ASP3,MINIT=6,MBAR=15,DISPLAY=MLOG,SBAR=15,SDEPTH=255
*
*/*------------------------------------------------------------------*/
*/*    ASP1 LOCAL MAIN.                                              */
*/*------------------------------------------------------------------*/
*ADAPTER= is MPADAPT and MPDEVADD, MAINCTC= is MPCTC
MAINPROC,NAME=ASP1,ID=ASP1,MDEST=M1,SYSTEM=LOCAL,SMFID=AS,MODEL=SP1,   +
ADAPTER=02F,MAINCTC=02F,                                               +
SELECT=ASP1,CTCCUA=(6,7,8),JOBCLASS=(B,C)
DEVICE,STYPE=MAIN,GTYPE=SYS,SUPPORT=(02F,ASP1,M1,ON)
*
*/*------------------------------------------------------------------*/
*/*    ASP2 REAL MAIN.                                               */
*/*------------------------------------------------------------------*/
*ADAPTER= is MPADAPT and MPDEVADD, MAINCTC= is MPCTC
MAINPROC,NAME=ASP2,ID=ASP2,MDEST=M2,SYSTEM=REAL,SMFID=AS,MODEL=SP2,    +
ADAPTER=63F,MAINCTC=63F,                                               +
SELECT=ASP2,CTCCUA=(6,7,8),JOBCLASS=(B,C)
DEVICE,STYPE=MAIN,GTYPE=SYS,SUPPORT=(63F,ASP2,M2,OFF)
*
*/*------------------------------------------------------------------*/
*/*    ASP3 REAL MAIN.                                               */
*/*------------------------------------------------------------------*/
*ADAPTER= is MPADAPT and MPDEVADD, MAINCTC= is MPCTC
MAINPROC,NAME=ASP3,ID=ASP3,MDEST=M3,SYSTEM=REAL,SMFID=AS,MODEL=SP3,    +
ADAPTER=64F,MAINCTC=64F,                                               +
SELECT=ASP2,CTCCUA=(6,7,8),JOBCLASS=(B,C)
DEVICE,STYPE=MAIN,GTYPE=SYS,SUPPORT=(64F,ASP3,M3,OFF)
*
*/*------------------------------------------------------------------*/
*/*    CLASS AND GROUP DEFINITION.                                   */
*/*------------------------------------------------------------------*/
CLASS,NAME=ASPBATCH,GROUP=ASPBATCH
CLASS,NAME=A,GROUP=ASPBATCH
CLASS,NAME=B,GROUP=ASPBATCH
CLASS,NAME=C,GROUP=ASPBATCH
CLASS,NAME=D,GROUP=ASPBATCH
CLASS,NAME=E,GROUP=ASPBATCH
CLASS,NAME=F,GROUP=ASPBATCH
CLASS,NAME=G,GROUP=ASPBATCH
CLASS,NAME=H,GROUP=ASPBATCH
CLASS,NAME=I,GROUP=ASPBATCH
CLASS,NAME=J,GROUP=ASPBATCH
CLASS,NAME=K,GROUP=ASPBATCH
CLASS,NAME=L,GROUP=ASPBATCH
CLASS,NAME=M,GROUP=ASPBATCH
CLASS,NAME=N,GROUP=ASPBATCH
CLASS,NAME=O,GROUP=ASPBATCH
CLASS,NAME=P,GROUP=ASPBATCH
CLASS,NAME=Q,GROUP=ASPBATCH
CLASS,NAME=R,GROUP=ASPBATCH
CLASS,NAME=S,GROUP=ASPBATCH
CLASS,NAME=T,GROUP=ASPBATCH
CLASS,NAME=U,GROUP=ASPBATCH
CLASS,NAME=V,GROUP=ASPBATCH
CLASS,NAME=W,GROUP=ASPBATCH
CLASS,NAME=X,GROUP=ASPBATCH
CLASS,NAME=Y,GROUP=ASPBATCH
CLASS,NAME=Z,GROUP=ASPBATCH
CLASS,NAME=0,GROUP=ASPBATCH
CLASS,NAME=1,GROUP=ASPBATCH
CLASS,NAME=2,GROUP=ASPBATCH
CLASS,NAME=3,GROUP=ASPBATCH
CLASS,NAME=4,GROUP=ASPBATCH
CLASS,NAME=5,GROUP=ASPBATCH
CLASS,NAME=6,GROUP=ASPBATCH
CLASS,NAME=7,GROUP=ASPBATCH
CLASS,NAME=8,GROUP=ASPBATCH
CLASS,NAME=9,GROUP=ASPBATCH
*GROUP,NAME=ASPBATCH,EXRESC=(ASP1,3,,IPL,MANUAL),PRTY=1
*GROUP,NAME=ASPBATCH,EXRESC=(ASP1,3,,DYNAMIC,MANUAL),PRTY=1
GROUP,NAME=ASPBATCH,PRTY=1,                                            +
EXRESC=(ASP1,0,,DYNAMIC,DYNAMIC),                                      +
EXRESC=(ASP2,0,,DYNAMIC,DYNAMIC),                                      +
EXRESC=(ASP3,0,,DYNAMIC,DYNAMIC)
*
*/*------------------------------------------------------------------*/
*/*    ASP1 DEVICES.                                                 */
*/*------------------------------------------------------------------*/
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(580,TA580,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(580,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(581,TA581,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(581,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(582,TA582,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(582,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(583,TA583,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(583,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(584,TA584,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(584,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(585,TA585,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(585,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(586,TA586,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(586,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(587,TA587,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(587,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(588,TA588,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(588,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(589,TA589,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(589,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(589,TA58A,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58A,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58B,TA58B,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58B,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58C,TA58C,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58C,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58D,TA58D,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58D,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58E,TA58E,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58E,ASP1,S1)
DEVICE,STYPE=24009,GTYPE=TA9,GNAME=LOCAL,SUPPORT=(58F,TA58F,LOG,ON),   +
MSTATUS=(TA),MTYPE=24009,MAIN=(58F,ASP1,S1)
*
*/*------------------------------------------------------------------*/
*/*    MDS.                                                          */
*/*------------------------------------------------------------------*/
SETNAME,MTYPE=24009,NAMES=(TAPE,3400-3,3400-5,3400-6,2400-3)
SETPARAM,ADDRSORT=YES,ALLOCATE=AUTO,DEPTH=255,MDSLOG=M1,REMOUNT=1
*
*/*------------------------------------------------------------------*/
*/*    READER/INTERPRETER.                                           */
*/*------------------------------------------------------------------*/
DEVICE,STYPE=OSRDR,SUPPORT=(NONE,RI1),GTYPE=ARI
*DEVICE,STYPE=OSRDR,SUPPORT=(NONE,RI2),GTYPE=ARI
RIDATSTN,SYS1.PROCLIB,SYS1.LINKLIB,SYS1.MACLIB,SYS1.SVCLIB
RIDATSTN,ASP.PSGLIB,ASP.MACINT,ASP.MACDUMMY,ASP.SOURCE
RI,BLDL=(ASMFC,ASMFCL,ASMFCLG),TAFETCH=S8,DAFETCH=S9
RIPARM,PARM=(00099905001024925631SYSDA   E00011A)
*
*/*------------------------------------------------------------------*/
*/*    CONSOLES.                                                     */
*/*------------------------------------------------------------------*/
CONSOLE,DDNAME=CN01F,TYPE=3215,UNIT=01F,DEPTH=99,DEST=OUTPUT,MAIN=ASP1,+
ALTCON=CN014
CONSOLE,DDNAME=CN014,TYPE=3277,UNIT=014,TIME=0,DEST=OUTPUT,MAIN=ASP1,  +
ALTCON=CN01F,DEPTH=99
CONSOLE,DDNAME=CN30F,TYPE=1403,UNIT=30F,DEPTH=99,DEST=MLG,MAIN=ASP1
*
*/*------------------------------------------------------------------*/
*/*    CONSOLE PROGRAM FUNCTION KEY DEFINITION.                      */
*/*------------------------------------------------------------------*/
PFK,K=1,M=<*I A>
PFK,K=2,M=<*I S>
*
*/*------------------------------------------------------------------*/
*/*    SUPPORT DEVICES.                                              */
*/*------------------------------------------------------------------*/
DEVICE,GTYPE=RDR,STYPE=2540P,SUPPORT=(00C,RD1,UR)
DEVICE,GTYPE=PUN,STYPE=2540R,SUPPORT=(00D,PU1,UR)
DEVICE,GTYPE=PRT,STYPE=1403,SUPPORT=(00E,PR1,UR)
DEVICE,STYPE=IJMP,SUPPORT=(NONE,IJASP1),GTYPE=IJM
DEVICE,STYPE=IJMP,SUPPORT=(NONE,IJASP2),GTYPE=IJM
DEVICE,STYPE=IJMP,SUPPORT=(NONE,IJASP3),GTYPE=IJM
DEVICE,STYPE=ACMP,SUPPORT=(NONE,ACASP1),GTYPE=ACM
DEVICE,STYPE=ACMP,SUPPORT=(NONE,ACASP2),GTYPE=ACM
DEVICE,STYPE=ACMP,SUPPORT=(NONE,ACASP3),GTYPE=ACM
*
*/*------------------------------------------------------------------*/
*/*    PRINT SETUP.                                                  */
*/*------------------------------------------------------------------*/
PRINTER,NAME=PR1,UCS=YES,FORMS=(YES,1PART),CARRIAGE=6#IN,              +
TRAIN=(NO,TN)
SYSOUT,CLASS=A
SYSOUT,CLASS=B,TYPE=PUNCH,COPIES=1
SYSOUT,CLASS=K,TYPE=PUNCH
SYSOUT,CLASS=T,TYPE=TSO
*
*/*------------------------------------------------------------------*/
*/*    RESIDENCY OPTIONS.                                            */
*/*------------------------------------------------------------------*/
RESCTLBK,RQ=10,ASG=10,FCT=05,VUT=05
RESIDENT,MODULE=JSS
RESIDENT,MODULE=MDSALLOC
RESIDENT,MODULE=ISNET
RESIDENT,MODULE=DJCUPDAT
RESIDENT,MODULE=RICBSCAN
RESIDENT,MODULE=RICONTL
RESIDENT,MODULE=IEFVHA
*
*/*------------------------------------------------------------------*/
*/*    STANDARDS.                                                    */
*/*------------------------------------------------------------------*/
STANDARDS,LINES=(100,W),CARDS=(50,W),FORMS=1PART,CARRIAGE=6#IN,        +
TRAIN=TN,FLOCATE=YES,DLOCATE=YES,CLASS=B,FAILURE=CANCEL,               +
NOPU=H,                                                                X
SEQCHK=YES,                                                            X
SQS=3K,NJPNAME=ASP,CONSBUF=50,MLOG=YES
*/*------------------------------------------------------------------*/
*/*    RJP.                                                          */
*/*------------------------------------------------------------------*/
*      /*------ NO RJP DEVICES DEFINED ------------------------------*/
*
*/*------------------------------------------------------------------*/
*/*    END OF ASP INITIALIZATION PARMS.                              */
*/*------------------------------------------------------------------*/
ENDINISH
*
*/*------------------------------------------------------------------*/
*/*    IPL TEXT FOR ASP1 LOCAL MAIN.                                 */
*/*------------------------------------------------------------------*/
IPL,NAME=ASP1,TYPE=MVT
*
*/*------------------------------------------------------------------*/
*/*    IPL TEXT FOR ASP2 REAL MAIN.                                  */
*/*------------------------------------------------------------------*/
IPL,NAME=ASP2,TYPE=MVT
*
*/*------------------------------------------------------------------*/
*/*    IPL TEXT FOR ASP3 REAL MAIN.                                  */
*/*------------------------------------------------------------------*/
IPL,NAME=ASP3,TYPE=MVT
IPL,END
./ ADD NAME=PRESRES
ASPRES,0,2,3330,       MOUNT=RESIDENT  USE=PRIVATE
ASPDLB,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
ASPSUP,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
ASP320,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
MVTDLB,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
ASPQVS,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
SPOOL1,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
PERMA0,1,0,3330,N      MOUNT=RESERVED  USE=STORAGE  SKIP IPL MOUNT MSG
PERMA1,1,0,3330,N      MOUNT=RESERVED  USE=STORAGE  SKIP IPL MOUNT MSG
PERM01,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
PERM02,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
DLIB01,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
WORKA0,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORKA1,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORKA2,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORKA3,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORK00,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORK01,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORK02,1,1,3330,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
WORK03,1,0,3330,N      MOUNT=RESERVED  USE=STORAGE  SKIP IPL MOUNT MSG
SORTA0,1,1,2314,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
SORTA1,1,1,2314,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
SORTA2,1,1,2314,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
SORTA3,1,1,2314,N      MOUNT=RESERVED  USE=PUBLIC   SKIP IPL MOUNT MSG
MFTR33,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
MVTRES,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
SY1RES,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
VRESA0,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
VDLIB0,1,2,3330,N      MOUNT=RESERVED  USE=PRIVATE  SKIP IPL MOUNT MSG
./ ADD NAME=SMFDEFLT
   OPT=2,          SYSTEM,JOB AND STEP DATA COLLECTION
   EXT=YES,        USER EXITS ARE TO BE TAKEN
   JWT=15,         MAXIMUM CONTINUOUS WAIT TIME IS 15 MIN/STEP
   BUF=400,        A MINIMUM 400 BYTE BUFFER IS DEFINED
   SID=AS,         SYSTEM ID
   MDL=P1,          IS ASP1
   OPI=NO,         DO NOT PERMIT OPERATOR INTERVENTION
   MAN=NONE,       DO NOT RECORD USER AND SYSTEM RECORDS
   PRM=ASPRES,     SYS1.MANX IS ON ASPRES
   ALT=ASPRES      SYS1.MANY IS ON ASPRES
./ ADD NAME=IKJPRM00
TS      TERMAX=16                                                       00010000
TS      REGNMAX=1                                                       00020000
TS      MAP=50                                                          00030000
TS      REGSIZE(1)=(400K,64K)                                           00040000
TS      LPA=(IKJPTGT,IKJSCAN,IKJEFT02,IKJEFT25)                         00050000
TS      LPA=(IKJPARS)                                                   00060000
DRIVER  AVGSERVICE PREEMPT SUBQUEUES(1)=3                               00070000
DRIVER  CYCLES(1,1)=0                                                   00080000
DRIVER  CYCLES(1,2)=0                                                   00090000
DRIVER  CYCLES(1,3)=0                                                   00100000
DRIVER  MAXOCCUPANCY(1,1)=2500                                          00110000
DRIVER  MINSLICE(1,1)=450                                               00120000
DRIVER  MAXOCCUPANCY(1,2)=4500                                          00130000
DRIVER  MINSLICE(1,2)=750                                               00140000
DRIVER  MAXOCCUPANCY(1,3)=4500                                          00150000
DRIVER  MINSLICE(1,3)=4500                                              00160000
DRIVER  SERVICE(1,1)=450                                                00170000
DRIVER  SERVICE(1,2)=1500                                               00180000
DRIVER  SERVICE(1,3)=6000                                               00190000
TIOC    BUFSIZE=240                                                     00200000
TIOC    BUFFERS=120                                                     00210000
TIOC    OWAITHI=24                                                      00220000
TIOC    OWAITLO=4                                                       00230000
TIOC    INLOCKHI=24                                                     00240000
TIOC    INLOCKLO=2                                                      00250000
TIOC    SLACK=01                                                        00260000
TIOC    RESVBUF=10                                                      00270000
TIOC    USERCHG=99                                                      00280000
./ ADD NAME=LNKLST00
SYS1.LINKLIB,SYS2.LINKLIB
./ ADD NAME=COMMND00
COM='MONITOR JOBNAMES,T     **** FROM COMMND00 AT IPL'
COM='MONITOR DSNAME         **** FROM COMMND00 AT IPL'
COM='START ASP              **** FROM COMMND00 AT IPL'
./ ADD NAME=COMMND01
COM='MONITOR JOBNAMES,T     **** FROM COMMND01 AT IPL'
COM='MONITOR DSNAME         **** FROM COMMND01 AT IPL'
COM='START HASP             **** FROM COMMND01 AT IPL'
./ ENDUP
/*
//
