//G21PROCL JOB 1,'G21PROCLIB',CLASS=A,MSGLEVEL=(1,1)
//*********************************************************************
//*                                                                 ***
//*    Job:      G21PROCLIB                                         ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  Update SYS1.PROCLIB on new system with procs       ***
//*              for ASP, MT, TCAM, TSO, JQD, WTRZ, S; modify       ***
//*              RDR defaults.                                      ***
//*    Update:   2006/08/19                                         ***
//*                                                                 ***
//*********************************************************************
//*
//UPDTE    EXEC PGM=IEBUPDTE,PARM=NEW
//SYSPRINT DD  SYSOUT=A
//SYSUT2   DD  DISP=SHR,DSN=SYS1.PROCLIB,UNIT=SYSDA,VOL=SER=ASPRES
//SYSIN    DD  DATA
./ ADD NAME=ASP
//ASP     PROC  START=WARM,PARMS=LOCAL
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  ASP                                              ***
//*    PURPOSE:    EXECUTE ASP SUPPORT PROCESSOR TASK.              ***
//*    UPDATE:     2006/08/18                                       ***
//*                                                                 ***
//*********************************************************************
//*
//IEFPROC EXEC PGM=ASPINTK,TIME=1440,DPRTY=(15,0),REGION=512K
//STEPLIB  DD UNIT=3330,VOL=SER=ASPSUP,DISP=SHR,DSN=ASP.VERSON32
//*-----------------------------------------------------------------***
//*    ASP CHECKPOINT AND SPOOL FILES.                              ***
//*-----------------------------------------------------------------***
//CHKPNT   DD  UNIT=SYSDA,DISP=SHR,VOL=SER=ASPQVS,DSN=ASP.CHK1
//QUEUE1   DD  UNIT=SYSDA,DISP=SHR,VOL=SER=ASPQVS,DSN=ASP.QUE1
//*-----------------------------------------------------------------***
//*    PRINTED OUTPUT FROM ASP INITIALIZATION.                      ***
//*-----------------------------------------------------------------***
//ASPOUT   DD UNIT=11E
//*-----------------------------------------------------------------***
//*    DUMP AND SNAP DD STATEMENTS.                                 ***
//*-----------------------------------------------------------------***
//ASPSNAP  DD UNIT=AFF=ASPOUT,DCB=BLKSIZE=882
//ASPSADMP DD UNIT=AFF=ASPOUT
//ASPABEND DD SYSOUT=Z,SPACE=(CYL,(10,2)),DCB=BLKSIZE=882
//SYSABEND DD SYSOUT=Z,SPACE=(CYL,(10,2)),DCB=BLKSIZE=882
//*-----------------------------------------------------------------***
//*    READER/INTERPRETER DD STATEMENTS.                            ***
//*-----------------------------------------------------------------***
//IEFRDER  DD DUMMY
//IEFDATA  DD DUMMY
//IEFPDSI  DD DSN=SYS1.PROCLIB,DISP=SHR
//*-----------------------------------------------------------------***
//*    NJP LINES.                                                   ***
//*-----------------------------------------------------------------***
//*NJPL0    DD UNIT=050
//*NJPL2    DD UNIT=052
//*-----------------------------------------------------------------***
//*    DISK READER DATA SET.                                        ***
//*-----------------------------------------------------------------***
//ASPDRDS  DD DISP=SHR,DSN=ASP.DRDS
//*-----------------------------------------------------------------***
//*    ASP PARAMETER INPUT.                                         ***
//*-----------------------------------------------------------------***
//ASPIN    DD DISP=SHR,DSN=SYS1.PARMLIB(ASP&START)
//         DD DISP=SHR,DSN=SYS1.PARMLIB(ASP&PARMS)
./ ADD NAME=MT
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  MT                                               ***
//*    PURPOSE:    EXECUTE ASP MAINTASK.                            ***
//*    UPDATE:     2006/08/18                                       ***
//*                                                                 ***
//*********************************************************************
//*
//MT    PROC  MTVOL=ASPSUP,                                            +00000000
//            DISK=3330,                                               +00002000
//            SYSDA=SYSDA,                                             +00003000
//            ASPUT1=ASPSUP,                                           +00004000
//            ASPUT2=ASPSUP,                                           +00005000
//            ASPUT3=ASPSUP                                             00006000
//IEFPROC EXEC PGM=MAINTASK,REGION=128K,DPRTY=(15,10),PARM='AD'
//STEPLIB  DD DSN=ASP.MAINTASK,                                        +00008000
//            DISP=SHR,                                                +00009000
//            UNIT=&DISK,                                              +00010000
//            VOL=SER=&MTVOL                                            00011000
//*SYSABEND DD DDNAME=IEFRDER                                           00012000
//SYSUDUMP DD UNIT=11F
//SNAPDD   DD UNIT=AFF=SYSUDUMP
//ASPDATA  DD DUMMY                                                     00015000
//CTCDD    DD UNIT=(CTC,,DEFER),                                       +00016000
//            LABEL=(,NL)                                               00017000
//ADSG01   DD UNIT=&SYSDA,                                             +00018000
//            DISP=OLD,                                                +00019000
//            VOL=SER=&ASPUT1,                                         +00020000
//            SPACE=(CYL,(1,1))                                         00021000
//ADSG02   DD UNIT=&SYSDA,                                             +00022000
//            DISP=OLD,                                                +00023000
//            VOL=SER=&ASPUT2,                                         +00024000
//            SPACE=(CYL,(1,1))                                         00025000
//ADSG03   DD UNIT=&SYSDA,                                             +00026000
//            DISP=OLD,                                                +00027000
//            VOL=SER=&ASPUT3,                                         +00028000
//            SPACE=(CYL,(1,1))                                         00029000
//ADCTC    DD UNIT=(CTC,,DEFER)                                         00030000
//ASPQRDR  DD UNIT=(CTC,,DEFER),                                       +00031000
//            LABEL=(,NL),                                             +00032000
//            VOL=SER=CTCRDR,                                          +00033000
//            DSN=ASP.QRDR                                              00034000
//ASPQWTR  DD UNIT=(CTC,,DEFER),                                       +00035000
//            LABEL=(,NL)                                               00036000
//OUTDATA  DD DUMMY                                                     00037000
//CTCDD2   DD UNIT=(CTC,,DEFER),                                       +00038000
//            LABEL=(,NL),                                             +00039000
//            DCB=BLKSIZE=760                                           00040000
//IEELOGX  DD DUMMY                                                     00041000
//IEELOGY  DD DUMMY                                                     00042000
./ ADD NAME=TCAM
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  TCAM                                             ***
//*    PURPOSE:    EXECUTE TCAM.                                    ***
//*    UPDATE:     2006/08/18                                       ***
//*                                                                 ***
//*********************************************************************
//*
//TCAM     EXEC PGM=IEDQTCAM,ROLL=(NO,NO),TIME=1440,DPRTY=(15,15),      00010000
//             REGION=256K                                              00020000
//SYSABEND DD  SYSOUT=A,SPACE=(CYL,(20,10),RLSE)                        00030000
//L3270A   DD  UNIT=0C0                                                 00040000
//         DD  UNIT=0C1                                                 00050000
//         DD  UNIT=3C0                                                 00060000
./ ADD NAME=TSO
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  TSO                                              ***
//*    PURPOSE:    EXECUTE TSO SCHEDULER.                           ***
//*    UPDATE:     2006/07/10                                       ***
//*                                                                 ***
//*********************************************************************
//*
//TSO      EXEC PGM=IKJEAT00,ROLL=(NO,NO),TIME=1440,DPRTY=(13,13)       00010000
//STEPLIB  DD  DISP=SHR,DSN=SYS1.CMDLIB                                 00020000
//SYSUADS  DD  DISP=SHR,DSN=SYS1.UADS                                   00030000
//SYSPARM  DD  DISP=SHR,DSN=SYS1.PARMLIB                                00040000
//SYSLBC   DD  DISP=SHR,DSN=SYS1.BRODCAST                               00050000
//SYSWAP00 DD  DISP=SHR,DSN=SYS1.SWAP0                                  00060000
//IEFPDSI  DD  DISP=SHR,DSN=SYS1.PROCLIB                                00070000
//*
./ ADD NAME=IKJACCNT
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  IKJACCNT                                         ***
//*    PURPOSE:    TSO LOGON PROCEDURE.                             ***
//*    UPDATE:     2006/08/18                                       ***
//*                                                                 ***
//*********************************************************************
//*
//IKJACCNT EXEC PGM=IKJEFT01,ROLL=(NO,NO),TIME=1440                     00010000
//SYSHELP  DD  DISP=SHR,DSN=SYS1.HELP                                   00020000
//SYSLBC   DD  DISP=SHR,DSN=SYS1.BRODCAST                               00030000
//DD1      DD  DYNAM                                                    00040000
//DD2      DD  DYNAM                                                    00050000
//DD3      DD  DYNAM                                                    00060000
//DD4      DD  DYNAM                                                    00070000
//DD5      DD  DYNAM                                                    00080000
//DD6      DD  DYNAM                                                    00090000
//DD7      DD  DYNAM                                                    00100000
//DD8      DD  DYNAM                                                    00110000
//DD9      DD  DYNAM                                                    00120000
//DD10     DD  DYNAM                                                    00130000
//DD11     DD  DYNAM                                                    00140000
//DD12     DD  DYNAM                                                    00150000
./ ADD NAME=JQD
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  JQD                                              ***
//*    PURPOSE:    EXECUTE OS JOB QUEUE DUMP PROGRAM.               ***
//*    UPDATE:     2006/07/11                                       ***
//*                                                                 ***
//*********************************************************************
//*
//IEFPROC EXEC PGM=IMCOSJQD,REGION=256K
//SYSPRINT DD  SYSOUT=A
//OSJQDIN  DD  DDNAME=IEFRDER
//OSJQDOUT DD  SYSOUT=A,SPACE=(CYL,(30,10))
//IEFRDER  DD  DISP=SHR,DSN=SYS1.SYSJOBQE
./ ADD NAME=WTRZ
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  WTRZ                                             ***
//*    PURPOSE:    EXECUTE DUMMY WRITER PROCEDURE.                  ***
//*    UPDATE:     2006/07/11                                       ***
//*                                                                 ***
//*********************************************************************
//*
//IEFPROC  EXEC PGM=IEFSD080,PARM='PZ',REGION=20K,ROLL=(NO,NO)
//IEFRDER   DD  DUMMY,DCB=(LRECL=133,RECFM=FM,BLKSIZE=133)
./ ADD NAME=S
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  S                                                ***
//*    PURPOSE:    FORCE DEALLOCATION.                              ***
//*    UPDATE:     2006/07/11                                       ***
//*                                                                 ***
//*********************************************************************
//*
//IEFPROC EXEC PGM=IEFBR14
//* THIS PROCEDURE IS ACTIVATED BY A 'START DEALLOC' COMMAND TO
//* EXECUTE IEFBR14 CAUSING ALLOCATION TO DEALLOCATE A
//* DEVICE SPECIFIED ON A PREVIOUS 'VARY OFFLINE' COMMAND.
./ ADD NAME=RDR
//*********************************************************************
//*                                                                 ***
//*    PROCEDURE:  RDR                                              ***
//*    PURPOSE:    OS READER PROCEDURE.                             ***
//*    UPDATE:     2006/07/10                                       ***
//*                                                                 ***
//*********************************************************************
//*
//IEFPROC   EXEC     PGM=IEFIRC,               READER FIRST LOAD       ,00010000
//             REGION=64K,                     READER BASIC REGION     ,00020000
//  PARM='80103012003024912811SYSDA   E00011A'  DEFAULT OPTIONS         00030000
//*       BPPTTTOOOMMMIIICCCRLSSSSSSSSAAAAEFH   PARM FIELD  A35852      00040000
//*       B    PROGRAMMER NAME AND ACCOUNT NUMBER NOT NEEDED            00050000
//*              PROGRAM CAN BE ROLLED OUT                              00060000
//*       PP   PRIORITY=01                                              00070000
//*       TTT  JOB STEP INTERVAL=30 MINUTES                             00080000
//*       OOO  PRIMARY SYSOUT SPACE=120 TRACKS (ORIGINALLY 50)          00090000
//*       MMM  SECONDARY SYSOUT SPACE=30 TRACKS (ORIGINALLY 10)         00100000
//*       III  READER/INTERPRETER DISPATCHING PRIORITY=249              00110000
//*       CCC  JOB STEP DEFAULT REGION=128K                             00120000
//*       R    DISPLAY AND EXECUTE COMMANDS=1                           00130000
//*       L    BYPASS LABEL OPTION=1                                    00140000
//*       SSSSSSSS  SYSOUT UNIT NAME=SYSDA                              00150000
//*       AAAA COMMAND AUTHORITY FOR MCS=E000-ALL COMMANDS          MCS 00160000
//*              MUST BE AUTHORIZED                                 MCS 00170000
//*       EF   JCL AND ALLOCATION MESSAGE LEVEL DEFAULTS=11      A35852 00180000
//*            H----DEFAULT MSGCLASS                              19006 00190000
//IEFRDER   DD  UNIT=2400,                       9 TRK TAPE            ,00200000
//             LABEL=(,NL),                      UNLABELED             ,00210000
//             VOLUME=SER=SYSIN,                 VOLUME NAME           ,00220000
//             DISP=OLD,                OLD DATA SET             A25722,00230000
//             DCB=(BLKSIZE=80,RECFM=F,BUFL=80,BUFNO=1)                 00240000
//IEFPDSI      DD  DSNAME=SYS1.PROCLIB,          PROCEDURE LIBRARY     ,00250000
//             DISP=SHR                                            I272 00260000
//IEFDATA      DD     UNIT=SYSDA,                SPOOL DEVICE          ,00270000
//             SPACE=(80,(500,500),RLSE,CONTIG),     AMOUNT            ,00280000
//  DCB=(BUFNO=2,LRECL=80,BLKSIZE=80,RECFM=F,BUFL=80,DSORG=PS)    22591 00290000
./ ENDUP
/*
//
