//G26INTK  JOB 1,G26ASPINTK,MSGLEVEL=(1,1),CLASS=A,MSGCLASS=A
//*********************************************************************
//*                                                                 ***
//*    Job:      G26ASPINTK                                         ***
//*    Product:  MVT 21.8 with ASP V3.2.                            ***
//*    Purpose:  Install ASPINTK front end for ASPNUC on new        ***
//*              system.                                            ***
//*    Update:   2006/08/18                                         ***
//*                                                                 ***
//*********************************************************************
//*
/*JOBPARM LINES=9999
//*MAIN LINES=100
//ASM    EXEC PGM=IFOX00,
//            PARM='DECK,LIST',REGION=768K
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=19040,
//            UNIT=SYSDA,VOL=SER=ASPRES
//         DD DISP=SHR,DSN=ASP.MAC320,
//            UNIT=SYSDA,VOL=SER=ASPSUP
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1700,(600,100))
//SYSUT2   DD DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(1700,(300,50))
//SYSUT3   DD DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(1700,(300,50))
//SYSPRINT DD SYSOUT=A
//SYSLIN   DD DUMMY
//SYSGO    DD DUMMY
//SYSPUNCH DD DSN=&&OBJSET,UNIT=SYSDA,SPACE=(80,(200,50)),
//            DISP=(MOD,PASS)
//SYSIN    DD *
         PRINT OFF
         MACRO
&LABEL   EMSG &NUM,&TEXT
.*---------------------------------------------------------------*
.*       Macro to generate abend code/message text tables.       *
.*---------------------------------------------------------------*
         GBLC  &ENUM(256),&ETEXT(256)
         GBLA  &ECOUNT
         LCLA  &TXTLN
         LCLA  &I,&ANUMLN
         LCLC  &ANUM,&ATXT
&TXTLN   SETA  K'&TEXT-2
         AIF   ('&NUM' EQ 'END').GEN
         AIF   (&TXTLN LE 80).OK1
         MNOTE 8,'Message text exceeds 80 characters'
         MEXIT ,
.OK1     ANOP  ,
&ECOUNT  SETA  &ECOUNT+1
&ANUM    SETC  '0000&NUM'
&ANUMLN  SETA   K'&ANUM
&ENUM(&ECOUNT) SETC '&ANUM'(&ANUMLN-3,&ANUMLN) '&NUM'
&ATXT    SETC  '&TEXT'(2,K'&TEXT-2)
&ETEXT(&ECOUNT) SETC '&ATXT'
         MEXIT ,
.GEN     ANOP  ,
.*
.*---------------------------------------------------------------*
.*       Loop through abend codes.                               *
.*---------------------------------------------------------------*
         EJECT ,
******************************************************************
*                                                                *
*        Message lookup table.                                   *
*                                                                *
******************************************************************
         SPACE 1
MSGTBL   DS    0H                     MESSAGE LOOKUP TABLE
.LKLOOP  ANOP  ,                   . Top of lookup table loop
&I       SETA  &I+1                . Increment entry counter
         AIF   (&I GT &ECOUNT).LKEND    . Quit if done
&ANUM    SETC  '&ENUM(&I)'         . Get abend code
         DC    A(&ANUM,TXT&ANUM) -    CODE, MESSAGE ADDRESS
         AGO   .LKLOOP
.LKEND   ANOP  ,                   . End of lookup table
MSGTBLE  DC    X'FFFFFFFF,FFFFFFFF' - END OF MESSAGE LOOKUP TABLE
.*
.*---------------------------------------------------------------*
.*       Loop through message text entries.                      *
.*---------------------------------------------------------------*
         EJECT ,
******************************************************************
*                                                                *
*        Message text.                                           *
*                                                                *
******************************************************************
         SPACE 1
&I       SETA  0                   . Zero table entry counter
.TXLOOP  ANOP  ,                   . Top of text loop
&I       SETA  &I+1                . Increment text entry counter
         AIF   (&I GT &ECOUNT).GENEND  . Quit if all text done
&ANUM    SETC  '&ENUM(&I)'         . Get abend code for label
&ATXT    SETC  '&ETEXT(&I)'        . Get message text
&TXTLN   SETA  K'&ATXT-1           . Set machine length of text
TXT&ANUM DC    AL1(&TXTLN)         TEXT LENGTH - 1
         DC    C'&ATXT'            TEXT
         AGO   .TXLOOP             . Loop through text table
.GENEND  ANOP  ,                   . End of text table generation
         MEND
         PRINT ON
***********************************************************************
*                                                                     *
*                                                                     *
* Module name          =  ASPINTK                                     *
*                                                                     *
*                                                                     *
* Descriptive name     =  ASP job step task program.                  *
*                                                                     *
*                                                                     *
* Function             =  This is the job step task for ASP.  It      *
*                         attaches the ASP nucleus, waits for         *
*                         it to complete, and issues appropriate      *
*                         messages at termination.   If ASPNUC        *
*                         abended, ASPINTK also abends (unless        *
*                         the abend is a user 0009, which is          *
*                         what ASP issues when the operator           *
*                         issues a *RETURN command).                  *
*                                                                     *
*                                                                     *
* Notes                =  See below.                                  *
*                                                                     *
*   Dependencies       =  None.                                       *
*                                                                     *
*   Registers          =  Not documented.                             *
*                                                                     *
*   Patch space        =  None.                                       *
*                                                                     *
*                                                                     *
* Module type          =  CSECT                                       *
*                                                                     *
*   Processor          =  OS System Assembler                         *
*                                                                     *
*   Module size        =  See assembly listing.                       *
*                                                                     *
*   Attributes         =                                              *
*     Location         =  Linklist data set                           *
*     State            =  Supervisor                                  *
*     Key              =  Zero                                        *
*     Mode             =  Task                                        *
*     Serialization    =  None                                        *
*     Type             =  Not reentrant                               *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
ASPINTK  CSECT ,
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         PRINT GEN
         EJECT ,
*----------------------------------------------------------------*
*        Program initialization.                                 *
*----------------------------------------------------------------*
         SAVE  (14,12),,ASPINTK    SAVE CALLER'S REGISTERS
         LR    R12,R15             SET BASE REGISTER
         USING ASPINTK,R12         ADDRESSABILITY FOR PROGRAM
         ST    R13,SAVEAREA+4      SAVE PREVIOUS SAVE AREA PTR
         LR    R15,R13             SAVE POINTER
         LA    R13,SAVEAREA        POINT TO NEW SAVE AREA
         ST    R13,8(0,R15)        SAVE NEW SAVE AREA PTR
         SPACE 1
*----------------------------------------------------------------*
*        Attach ASPNUC, wait for it to complete, and detach it.  *
*----------------------------------------------------------------*
         XC    ASPECB,ASPECB       CLEAR THE ECB
         ATTACH EP=ASPNUC,ECB=ASPECB,JSTCB=YES,SM=SUPV
         ST    R1,ASPTCB           SAVE ASPNUC TCB ADDRESS
         SPACE 1
*----------------------------------------------------------------*
*        Test attach return code.  Issue message and abend if    *
*        attach failed.                                          *
*----------------------------------------------------------------*
         LTR   R7,R15              SUCCESSFUL ATTACH?
         BZ    WAIT                YES, WAIT FOR ASPNUC TO END
         WTO   'INTK01 ASPINTK UNABLE TO ATTACH ASPNUC',               +
               ROUTCDE=(2,10),DESC=4 NOTIFY OPERATOR
         LH    R15,RSN3000         SET REASON CODE
         LR    R0,R7               SET ATTACH ERROR CODE IN R0
         L     R1,C2FBDUMP         GET COMPLETION CODE FOR DUMP
         ABEND (1)                 ABEND WITH DUMP
         SPACE 1
*----------------------------------------------------------------*
*        Attach was successful.  Wait for ASPNUC to end.         *
*----------------------------------------------------------------*
WAIT     DS    0H
         WAIT  ECB=ASPECB          WAIT FOR ASPNUC TERMINATION
         SPACE 1
*----------------------------------------------------------------*
*        ASPNUC has ended.  Test for normal return or *RETURN    *
*        command (a user 0009 abend).                            *
*----------------------------------------------------------------*
         L     R0,ASPECB           PICK UP COMPLETION CODE
         LTR   R0,R0               TEST FOR NORMAL RETURN
         BZ    EXIT                NORMAL RETURN FROM ASPNUC
         L     R0,ASPECB           PICK UP COMPLETION CODE
         N     R0,USERMASK         CLEAR ALL BUT USER CODE
         LA    R15,ASPDM009        Get completion code for *RETURN
         CR    R0,R15              'USER 009' = *RETURN ?
         BNE   ABND                NO, GO ABEND
         SPACE 1
*----------------------------------------------------------------*
*        ASPNUC ended normally, or *RETURN command was issued.   *
*        Issue message, clean up and exit.                       *
*----------------------------------------------------------------*
EXIT     DS    0H                  RETURN TO SENDER
         WTO   'INTK03 ASP TERMINATION COMPLETE',                      +
               ROUTCDE=(2,10),DESC=4
         DETACH ASPTCB             DETACH ASPNUC TCB
         L     R13,SAVEAREA+4      RESTORE SAVE AREA POINTER
         XR    R15,R15             SET RC=0
         RETURN (14,12),RC=(15)    RETURN
         SPACE 1
*---------------------------------------------------------------------*
*        ASPNUC abended.  Format the completion code.                 *
*---------------------------------------------------------------------*
ABND     DS    0H                  HERE TO ABEND
         L     R0,ASPECB           GET COMPLETION CODE IN R0
         SPACE 1
*----------------------------------------------------------------*
*        Isolate system completion code in R0 and user           *
*        completion code in R1.                                  *
*----------------------------------------------------------------*
         SLL   R0,8                SSSUUU00 IN R0
         SRDL  R0,20               00000SSS IN R0  UUUXXXXX IN R1
         SRL   R1,20               00000UUU IN R1
         SPACE 1
*----------------------------------------------------------------*
*        Format user completion code into message.               *
*----------------------------------------------------------------*
         CVD   R1,DWORK            CONVERT USER CC TO PACKED
         OI    DWORK+7,X'0F'       UNPACK USER CC
         UNPK  MSGCODEU,DWORK       INTO MESSAGE
         LR    R3,R1               Save user completion code in R3
         SPACE 1
*----------------------------------------------------------------*
*        Format system completion code into message.             *
*----------------------------------------------------------------*
         STH   R0,DWORK            SET SYSTEM CC IN WORK AREA
         MVI   DWORK+2,X'0F'       SET DUMMY SIGN FOR UNPACK
         UNPK  DWORK+3(5),DWORK(3) UNPACK SYSTEM ABEND CODE
         MVC   MSGCODES,DWORK+4    MOVE SYSTEM CC TO MESSAGE
         TR    MSGCODES,HEXTRAN-240  TRANSLATE HEX TO CHARACTER
         SPACE 1
*----------------------------------------------------------------*
*        Issue abend message.                                    *
*----------------------------------------------------------------*
         WTO   MF=(E,MSGABEND)     NOTIFY OPERATOR
         SPACE 1
         LA    R2,MSGTBL           Point to start of message table
         SPACE 1
*----------------------------------------------------------------*
*        Loop through message table to find match for            *
*        user abend code.                                        *
*----------------------------------------------------------------*
MSGLOOP  DS    0H                  Loop through message table
         CLC   XFF,0(R2)           End of table?
         BE    DONE                Done if so
         CL    R3,0(R2)            Is this the entry we want?
         BE    MSGFOUND            Branch if so
         LA    R2,8(,R2)           Else point to next table entry
         B     MSGLOOP             Do next message
         SPACE 1
*----------------------------------------------------------------*
*        Table entry found for abend code.  Build and            *
*        issue WTO using message text for abend code.            *
*----------------------------------------------------------------*
MSGFOUND DS    0H                  Found in table
         L     R15,4(,R2)          Point to message
         XR    R14,R14             Clear a register
         IC    R14,0(,R15)         Get message length
         EX    R14,MOVETXT         Copy message text
         LH    R0,MSG              Set
         AR    R14,R0               length
         LA    R14,1(,R14)           for
         STH   R14,MSG                WTO
         LA    R14,MSG(R14)        Point past WTO text
         MVC   0(4,R14),CODES      Set routing/descriptor codes
         WTO   MF=(E,MSG)          Display message
         B     DONE
         SPACE 1
MOVETXT  MVC   OUT(*-*),1(R15)     ** Executed move **
DONE     DS    0H
         SPACE 1
*----------------------------------------------------------------*
*        Determine if we should dump.  A dump is taken for       *
*        any abend except a user 0010.                           *
*----------------------------------------------------------------*
         L     R0,ASPECB           PICK UP COMPLETION CODE
         LR    R3,R0               SAVE ABEND CODE
         LA    R15,ASPDM010        Get completion code for user 0010
         CR    R0,R15              'USER 010' = NO DUMP WANTED?
         BE    ABNNODMP            YES, GO DO IT
         SPACE 1
*----------------------------------------------------------------*
*        Abend with dump.                                        *
*----------------------------------------------------------------*
         L     R1,C2FBDUMP         GET COMPLETION CODE FOR DUMP
         ABEND (1)                 ABEND WITH DUMP
         SPACE 1
*----------------------------------------------------------------*
*        Abend without dump.                                     *
*----------------------------------------------------------------*
ABNNODMP DS    0H
         L     R1,C2FB             GET COMPLETION CODE FOR NO DUMP
         ABEND (1)                 ABEND WITHOUT DUMP
         SPACE 1
*----------------------------------------------------------------*
*        Constants and work areas.                               *
*----------------------------------------------------------------*
DWORK    DS    D                   DOUBLEWORD WORK AREA
SAVEAREA DS    18F                 PROGRAM SAVE AREA
         DS    0F
C2FBDUMP DC    X'802FB000'         ABEND 2FB WITH DUMP
C2FB     DC    X'002FB000'         ABEND 2FB WITHOUT DUMP
ASPECB   DS    F                   ASPNUC ECB
ASPTCB   DS    A                   ADDRESS OF ASPNUC TCB
         DS    0F
USERMASK DC    XL4'FFF'            Mask to CLEAR ALL BUT USER CODE
         DS    0H
RSN3000  DC    X'3000'             REASON CODE 3000
MSGABEND WTO   'INTK02 ASPNUC ABEND - SYSTEM=XXX USER=XXXX',           +
               ROUTCDE=(2,10),DESC=4,MF=L
         ORG   MSGABEND+29+4
MSGCODES DS    CL3                 SYSTEM COMPLETION CODE
         ORG   MSGABEND+38+4
MSGCODEU DS    CL4                 USER COMPLETION CODE
         ORG   ,
MSG      WTO   'INTK04 ',MF=L,ROUTCDE=(2,10)
         DS    CL128
OUT      EQU   MSG+4+7,120
CODES    DC    X'00004040'         ROUTCDE=(2,10)
XFF      DC    X'FFFFFFFF'         End of table indicator
HEXTRAN  DC    C'0123456789ABCDEF'
         EJECT ,
******************************************************************
*                                                                *
*        Define messages for user abend codes.                   *
*                                                                *
******************************************************************
         SPACE 1
 EMSG 001,'INITCARD: TERMINAL ERRORS IN INITIALIZATION DECK'
 EMSG 002,'NOT ENOUGH CORE TO INITIALIZE ASP'
 EMSG 003,'INITDATA: UNEXPECTED EOF READING INITIALIZATION DECK'
 EMSG 004,'INITCNS: TERMINAL ERRORS IN INITIALIZATION PARM ANALYSIS'
 EMSG 005,'INITRTNS: DUMP ON EXACT INISH MSG'
 EMSG 006,'ERROR READING CHKPNT RECORD IN RESTART PROCESSING'
 EMSG 007,'STAE FAILURE'
 EMSG 008,'OPERATOR ISSUED *DUMP'
 EMSG 010,'PRTSETUP OBTAINED PRINTER WITHOUT A PRTABLE ENTRY'
 EMSG 011,'INITCKIO: ASP SPOOL CHECKPOINT ERROR'
 EMSG 012,'ERROR DURING SPOOL CHECKPOINT VALIDATION'
 EMSG 019,'ACDS: COULD NOT FIND ACDS-CREATED MSVDATA'
 EMSG 020,'IJPEND: COULD NOT FIND IJP CREATED MSVDATA'
 EMSG 030,'RESMGMT: AN INVALID RESOURCE NAME WAS GIVEN'
 EMSG 040,'JOBCONT: ILLEGAL JCT ACCESS'
 EMSG 041,'JOBCONTL: INVALID PRIORITY FOR JCT ACCESS'
 EMSG 042,'JOBCONTL: EXCESSIVE LENGTH FOR TAADD'
 EMSG 043,'JOBCONTL: TAPUT WITHOUT TAGET'
 EMSG 044,'JOBCONTL: TADEL WITHOUT TAGET'
 EMSG 045,'JOBCONTL: RESQUEUE MANAGEMENT ERRORS'
 EMSG 050,'ASPCONTL: ATIME WITHOUT ENTER ADDRESS'
 EMSG 051,'JSSDR: RETURN TO JSSDR WITH SAVEAREAS OUTSTANDING'
 EMSG 080,'ALDADEL: CANNOT LOAD MODULE - DOES NOT EXIST'
 EMSG 081,'ALDADEL: CANNOT LOAD MODULE - PERM I/O ERROR'
 EMSG 090,'LOGOUT: CANNOT FIND SE IN JDAB'
 EMSG 091,'LOGOUT: FUNCTION IS NOT LOGGED IN'
 EMSG 100,'ABENDMON: RECURSION IN THE SPIE ROUTINE'
 EMSG 101,'ABENDMON: UNRECOVERABLE DSP FAILURE'
 EMSG 102,'ABENDMON: PRG CHK BTWN AWAIT AND FCT SCAN'
 EMSG 103,'ABENDMON: STAE EXIT TOOK GOOD DUMP'
 EMSG 104,'RICONTL: COULD NOT READ OS CONTROL BLOCK'
 EMSG 105,'DJCUPDAT: NCB FOR ENDING JOB NOT FOUND'
 EMSG 130,'CONSOLES: ERROR IN CONSOLE STATUS TABLE'
 EMSG 131,'CONSINPT: DSP MESSAGE APPENDAGE ABENDED'
 EMSG 132,'CONSQMGR: BAD MESSAGE PARAMETERS'
 EMSG 133,'CONSINPT: DSP TERMINATED VIA OPERATOR FAIL CMND'
 EMSG 140,'ASAVERTN: BUSY RETURN FROM AGETMAIN FOR SAVE AREA'
 EMSG 700,'ASPIO: AOPEN DONE, FDB ADDRESS IN FD'
 EMSG 701,'ASPIO: MULTIPLE FILE, NO FD ENTRY'
 EMSG 702,'ASPIO: READING BEYOND DATA, MULTIPLE INPUT FILE'
 EMSG 703,'ASPIO: NO BUFFER ADDRESS IN FDB FOR AWRITE'
 EMSG 704,'ASPIO: BAD TRACK ADDRESS TO I/O ROUTINES'
 EMSG 705,'ASPIO: BAD BUFFER ADDRESS TO PUTBUF ROUTINE'
 EMSG 706,'ASPIO: ACLOSE WITHOUT FD ENTRY, NO AOPEN'
 EMSG 707,'ASPIO: DEDICATED BA''S, NO BA''S AVAILABLE'
 EMSG 708,'IONUC: NO EOD IN BUFFER ON ACLOSE FOLL AOPEND'
 EMSG 709,'ASPIO: INSUFFICIENT DED BUFFERS'
 EMSG 710,'ASPIO: DUPLICATE TRACK'
 EMSG 711,'ASPIO: ALOCATE ON CLOSED FILE'
 EMSG 712,'ASPIO: BAD COUNT ON ALOCATE OR ABLOCK'
 EMSG 713,'ASPIO: ILLEGAL FDB TO APURGE'
 EMSG 714,'ASPIO: TRACK TO APURGE, NOT IN STT'
 EMSG 715,'ASPIO: ILLEGAL AOPEND, FILE ALREADY OPEN'
 EMSG 716,'ASPIO: NO EOD IN LAST DATA BUFFER, AOPEND'
 EMSG 717,'ASPIO: TWO LOCATES WITHOUT A BLOCK'
 EMSG 718,'ASPIO: TWO BLOCKS WITHOUT A LOCATE'
 EMSG 719,'ASPIO: INPUT FILE, DEDICATED BA''S, BAD BA'
 EMSG 720,'ASPIO: BACKSPACE RECORD ON CLOSED FILE'
 EMSG 721,'ASPIO: BAD CC IN BUF DURING BACKR'
 EMSG 722,'IOERREC: END-OF-EXTENT ERROR ON ASP Q'
 EMSG 723,'IODATA: BAD LTH ON MOVEDATA CALL'
 EMSG 724,'JSSDR: RETURN TO JSSDR WITH OPEN ASP FILE'
 EMSG 725,'TRACKS: NO TRKS FOR RESTART'
 EMSG 799,'TRACKS: JBTCOUNT TOO LARGE'
 EMSG 750,'IOERREC: DCB ADDRESS IN IOB IS NOT VALID'
 EMSG 751,'IOERREC: READ FOR DATA BUFFER NO GOOD'
 EMSG 760,'IOERREC: UNCORRECTABLE READ ERROR ON ASP QUEUE'
 EMSG 800,'TRACKS: ERROR OBTAINING IOB, IOB AREA DESTROYED'
 EMSG 900,'RJPGET: RETURN +8 TO LINE MGR'
 EMSG 901,'RJPGET: RETURN +4 TO LINE MGR'
 EMSG END
         EJECT ,
         ASPDUMPS ,
         END   ,
//*
//LKED   EXEC PGM=IEWL,PARM=(XREF,LET,LIST,NCAL),
//            REGION=128K,COND=(4,LT,ASM)
//SYSLMOD  DD UNIT=3330,VOL=SER=ASPSUP,
//         DISP=SHR,DSN=ASP.VERSON32
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1024,(50,20))
//SYSPRINT DD SYSOUT=A
//SYSLIN   DD DSN=&&OBJSET,DISP=(OLD,DELETE)
//         DD *
 NAME ASPINTK(R)
/*
//
