//SY20ZR08 JOB 1,IEFTB700,MSGLEVEL=(1,1),CLASS=A,MSGCLASS=A
//ASM    EXEC PGM=IEUASM,
//            PARM='DECK,LIST,RENT',REGION=768K
//SYSLIB   DD DISP=SHR,DSN=SYS1.MACLIB,DCB=BLKSIZE=6160,
//            UNIT=SYSDA,VOL=SER=ASPRES
//         DD DISP=SHR,DSN=SYS1.MODGEN,UNIT=SYSDA,VOL=SER=ASPDLB
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1700,(600,100))
//SYSUT2   DD DSN=&&SYSUT2,UNIT=SYSDA,SPACE=(1700,(300,50))
//SYSUT3   DD DSN=&&SYSUT3,UNIT=SYSDA,SPACE=(1700,(300,50))
//SYSPRINT DD SYSOUT=A
//SYSLIN   DD DUMMY
//SYSGO    DD DUMMY
//SYSPUNCH DD DSN=&&OBJSET,UNIT=SYSDA,SPACE=(80,(200,50)),
//            DISP=(MOD,PASS)
//SYSIN    DD *
         TITLE '    IEFTB700 - INTERFACE TO IEFACTRT'
***********************************************************************
*                                                                     *
*                                                                     *
* Module name          =  IEFTB700                                    *
*                                                                     *
*                                                                     *
* Descriptive name     =  Interface to IEFACTRT.                      *
*                                                                     *
*                                                                     *
* Function             =  To replace the IBM-supplied IEFACTRT        *
*                         module in IEFSD061, and link dynamically    *
*                         to a user-supplied IEFACTRT module in       *
*                         LPA or a linklist library.                  *
*                                                                     *
*                                                                     *
* Notes                =  See below.                                  *
*                                                                     *
*   Dependencies       =  None.                                       *
*                                                                     *
*   Registers          =  Not documented.                             *
*                                                                     *
*   Patch space        =  None.                                       *
*                                                                     *
*                                                                     *
* Module type          =  CSECT                                       *
*                                                                     *
*   Processor          =  OS System Assembler                         *
*                                                                     *
*   Module size        =  See assembly listing.                       *
*                                                                     *
*   Attributes         =                                              *
*     Location         =  Part of IEFSD061 load module                *
*     State            =  Supervisor                                  *
*     Key              =  Zero                                        *
*     Mode             =  Task                                        *
*     Serialization    =  None                                        *
*     Type             =  Reentrant                                   *
*                                                                     *
*                                                                     *
***********************************************************************
         EJECT ,
******************************************************************
*                                                                *
*        Define external symbols and register equates.           *
*                                                                *
******************************************************************
         SPACE 1
IEFTB700 CSECT
IEFACTRT EQU   IEFTB700
         ENTRY IEFACTRT
         SPACE 1
R0       EQU    0
R1       EQU    1
R2       EQU    2
R3       EQU    3
R4       EQU    4
R5       EQU    5
R6       EQU    6
R7       EQU    7
R8       EQU    8
R9       EQU    9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
         TITLE '    IEFTB700 - INTERFACE TO IEFACTRT'
*----------------------------------------------------------------*
*        Program initialization.                                 *
*----------------------------------------------------------------*
         SAVE  (14,12),,*          Save caller's registers
         LR    R11,R15             Set base register
         USING IEFTB700,R11        Addressability for program
         EJECT ,
*----------------------------------------------------------------*
*        Get storage for work area.                              *
*----------------------------------------------------------------*
         LA    R0,LWORKA           Set length for GETMAIN
         GETMAIN R,LV=(0)          Get work area storage
         LR    R3,R1               Set work area base address
         USING WORKA,R3            Addressability for work area
         SPACE 1
*----------------------------------------------------------------*
*        Initialize for active LPA queue search.                 *
*----------------------------------------------------------------*
         LA    R1,KACTRT           Point to module name
         L     R15,CVTPTR          Get CVT address
         USING CVTMAP,R15          Addressability for CVT
         L     R15,CVTQLPAQ        Get active LPAQ address
         DROP  R15                 End CVT addressability
         SPACE 1
*----------------------------------------------------------------*
*        Loop searching active LPA queue for IEFACTRT.           *
*----------------------------------------------------------------*
LPAQLOOP DS    0H                  Top of LPA queue search loop
         LTR   R15,R15             End of LPAQ?
         BZ    CKLINK              Yes, module not found in LPA
         CLC   8(8,R15),0(R1)      Is this CDE for module?
         BE    LPAFOUND            Yes, module found in LPA
         L     R15,0(,R15)         Else point to next CDE on chain
         LA    R15,0(,R15)         Clear high-order byte
         B     LPAQLOOP            Back to look at next CDE
         SPACE 1
*----------------------------------------------------------------*
*        IEFACTRT was found in active LPA queue.  Point          *
*        R13 to our save area, chain save areas and link         *
*        to IEFACTRT.                                            *
*----------------------------------------------------------------*
LPAFOUND DS    0H                  Found IEFACTRT in LPA
         LA    R15,LINKPRM         Point to LINK parm list
         LR    R14,R13             Save caller's save area address
         LA    R13,SAVEA           Point to our save area
         ST    R14,4(,R13)         Chain
         ST    R13,8(,R14)          save areas
         MVC   LINKPRM,MLINKPRM    Copy model LINK parm list
         LM    R0,R1,20(R14)       Restore R0-R1 at entry
         LM    R4,R10,36(R14)      Restore R4-R10 at entry
         LA    R14,KACTRT          Get EPLOC address
         ST    R14,0(,R15)         Store in LINK parm list
         LINK  SF=(E,(15))         Link to IEFACTRT
         SPACE 1
*----------------------------------------------------------------*
*        Back from IEFACTRT.  Unchain save areas and save        *
*        R15 - R0 returned by IEFACTRT in our caller's save      *
*        area.  Then go to free work area and exit.              *
*----------------------------------------------------------------*
         L     R13,4(,R13)         Restore save area pointer
         STM   R15,R1,16(R13)      Save R15 through R1
         B     FREEWORK            Go free work area and exit
         SPACE 1
*----------------------------------------------------------------*
*        IEFACTRT was not found in LPA.  Issue BLDL against      *
*        link list.                                              *
*----------------------------------------------------------------*
CKLINK   DS    0H
         L     R15,CVTPTR          Get CVT address
         USING CVTMAP,R15          Addressability for CVT
         L     R1,CVTLINK          Get link list DCB address
         DROP  R15                 End CVT addressability
         XC    BLDLAREA,BLDLAREA   Zero BLDL list area
         LA    R0,1                Set entry count
         STH   R0,BLDLCC            in list
         LA    R0,58               Set entry length
         STH   R0,BLDLLL            in list
         MVC   BLDLNAME,KACTRT     Set module name in list
         LA    R0,BLDLAREA         Point to BLDL list area
         BLDL  (1),(0)             Issue BLDL
         LTR   R15,R15             Was module found in link list?
         BNZ   NOTFOUND            Skip link if not
         SPACE 1
*----------------------------------------------------------------*
*        IEFACTRT was found in a link list library.              *
*        Point R13 to our save area, chain save areas            *
*        and link to IEFACTRT.                                   *
*----------------------------------------------------------------*
         LA    R2,BLDLAREA+4       Point to list entry
         LA    R15,LINKPRM         Point to link parm list
         LR    R14,R13             Save caller's save area address
         LA    R13,SAVEA           Point to our save area
         ST    R14,4(,R13)         Chain
         ST    R13,8(,R14)          save areas
         MVC   LINKPRM,MLINKPRM    Copy model LINK parm list
         LM    R0,R1,20(R14)       Restore R0-R1 at entry
         LM    R4,R10,36(R14)      Restore R4-R10 at entry
         LINK  DE=(R2),            Link                                +
               SF=(E,(15))          to IEFACTRT
         SPACE 1
*----------------------------------------------------------------*
*        Back from IEFACTRT.  Unchain save areas and save        *
*        R15 - R0 returned by IEFACTRT in our caller's save      *
*        area.                                                   *
*----------------------------------------------------------------*
         L     R13,4(,R13)         Restore save area pointer
         STM   R15,R1,16(R13)      Save R15 through R1
         SPACE 1
*----------------------------------------------------------------*
*        Free work area storage.                                 *
*----------------------------------------------------------------*
FREEWORK DS    0H
         LA    R0,LWORKA           Set length for FREEMAIN
         LR    R1,R3               Set address for FREEMAIN
         FREEMAIN R,LV=(0),A=(1)   Free work area storage
         DROP  R3                  End work area addressability
         SPACE 1
*----------------------------------------------------------------*
*        Restore caller's registers and return.                  *
*----------------------------------------------------------------*
RETURN   DS    0H                  Return to caller
         RETURN (14,12)            Restore registers and return
         SPACE 1
*----------------------------------------------------------------*
*        IEFACTRT was not found.  Zero R15 and R1 in caller's    *
*        save area to permit current job to continue and SMF     *
*        record to be written, then go to exit.                  *
*----------------------------------------------------------------*
NOTFOUND DS    0H                  IEFACTRT not found
         XR    R15,R15             Get a zero
         ST    R15,16(,R13)        Zero returned R15
         ST    R15,24(,R13)         and returned R1
         B     RETURN              Go return to caller
         EJECT ,
*----------------------------------------------------------------*
*        Constants and literals.                                 *
*----------------------------------------------------------------*
KACTRT   DC    CL8'IEFACTRT'       Name for module search
MLINKPRM LINK  SF=L                Model LINK parm list
LLINKPRM EQU   *-MLINKPRM          Length of LINK parm list
         LTORG ,                   Literal pool
         SPACE 1
*----------------------------------------------------------------*
*        Getmained work area.                                    *
*----------------------------------------------------------------*
WORKA    DSECT ,                   Getmained work area
BLDLAREA DS    CL64                Area for BLDL list
         ORG   BLDLAREA            Remap BLDL list
BLDLCC   DS    H                   -- BLDL entry count
BLDLLL   DS    H                   -- BLDL entry length
BLDLNAME DS    CL8                 -- BLDL member name
         ORG   ,
SAVEA    DS    18F                 Program save area
         DS    0F                  Force fullword alignment
LINKPRM  DS    CL(LLINKPRM)        Area for LINK parm list
         DS    0D                  Force doubleword alignment
LWORKA   EQU   *-WORKA             Symbolic length of work area
         EJECT ,
*----------------------------------------------------------------*
*        Map the CVT.                                            *
*----------------------------------------------------------------*
CVT      DSECT ,                   Begin CVT DSECT
         CVT   SYS=MVT             Map CVT
         END   ,
//*
//LKED   EXEC PGM=IEWL,
//            REGION=200K,COND=(4,LT,ASM),
//            PARM='NCAL,LIST,XREF,LET,RENT,REFR,REUS,MAP'
//SYSLMOD  DD DISP=OLD,UNIT=SYSDA,VOL=SER=ASPRES,DSN=SYS1.LINKLIB
//SYSPUNCH DD DSN=&&OBJSET,DISP=(OLD,DELETE)
//SYSUT1   DD DSN=&&SYSUT1,UNIT=SYSDA,SPACE=(1024,(50,20))
//SYSPRINT DD SYSOUT=A
//SYSLIN   DD *
 INCLUDE SYSPUNCH
 REPLACE IEFACTRT
 INCLUDE SYSLMOD(IEFSD061)
 ALIAS IEFSD064
 ALIAS IEFW42SD
 ALIAS IEFSD104
 ENTRY IEFSD061
 NAME IEFSD061(R)
//
