//SY20ZR13 JOB 1,THAS802,MSGLEVEL=(1,1),
// CLASS=A,MSGCLASS=A,REGION=768K
//*
//*   PROBLEM DESCRIPTION(S):
//*     THAS802 -
//*       Add HASP pseudo-device support to stage 1 and stage 2
//*       system generation macros.
//*
//*   APARS FIXED: THAS802
//*
//*   COMPONENT:  360S-CI505-EBB2218
//*
//*   SPECIAL CONDITIONS:
//*     IOGEN:  An I/O generation is required for implementation
//*       of the functionality added by this usermod.
//*       GENTYPE = IO
//*
//*   COMMENTS:
//*     LAST CHANGE:  2006/08/28
//*
//*     SYS1.GENLIB and SYS1.MODGEN are updated by this usermod.
//*
//*     SGGBLPAK has to be replaced rather than updated because the 
//*       IBM-supplied source doesn't have sequence numbers on every
//*       record.  The version supplied by this usermod is the 768
//*       device version (SGPAK768).
//*
//*     Due to the size of the IODEVICE macro, updates to SYS1.GENLIB
//*       are made to a temporary data set.  The macros to be updated
//*       are then deleted from SYS1.GENLIB, SYS1.GENLIB is compressed,
//*       and the updated macros are copied to SYS1.GENLIB.
//*
//*     THE FOLLOWING MODULES AND/OR MACROS ARE AFFECTED BY THIS USERMOD:
//*
//*     MACROS
//*       IECIUCB
//*       IODEVICE
//*       SGIEC202
//*       SGGBLPAK
//*
//MODGEN  EXEC PGM=IEBUPDTE,PARM=MOD,REGION=128K
//SYSPRINT DD  SYSOUT=A
//SYSUT1   DD  DISP=SHR,DSN=SYS1.MODGEN,UNIT=SYSDA,VOL=SER=ASPDLB
//SYSUT2   DD  DISP=SHR,DSN=SYS1.MODGEN,UNIT=SYSDA,VOL=SER=ASPDLB
//SYSIN    DD  DATA
./ CHANGE NAME=IECIUCB
.******* Start of code for HASP pseudo-device support ******** @THAS802 18150200
         AIF   ('&TYPE' NE 'SUD').NOTSUD                     * @THAS802 18150201
         DC    AL1(&STATAB,&LCHN),XL2'0100'  STAT,LCH,ATN,CK * @THAS802 18150202
         DC    CL3'&DEVADDR',XL4'&TYPEA',F'0'                * @THAS802 18150203
         AGO   .END                                          * @THAS802 18150204
.NOTSUD  ANOP                                                * @THAS802 18150205
.******* End of code for HASP pseudo-device support ********** @THAS802 18150206
./ ENDUP
/*
//GENLIB  EXEC PGM=IEBUPDTE,PARM=MOD,REGION=128K,COND=(0,NE)
//SYSPRINT DD  SYSOUT=A
//SYSUT1   DD  DISP=SHR,DSN=SYS1.GENLIB,UNIT=SYSDA,VOL=SER=ASPDLB
//SYSUT2   DD  DSN=SYS1.GENTEMP,
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=3120),
//             SPACE=(TRK,(60,30,2)),
//             UNIT=SYSDA,DISP=(NEW,CATLG)
//SYSIN    DD  DATA
./ CHANGE NAME=IODEVICE
.******* Start of code for HASP pseudo-device support ******** @THAS802 07000200
         AIF   (K'&UNIT LT 5).IUN99    GREATER THAN 5 CHAR?  * @THAS802 07000201
         AIF   ('&UNIT'(1,5) EQ 'HASP-').IUN01 GO IF HASP DEV* @THAS802 07000202
.IUN99   ANOP                                                * @THAS802 07000203
.******* End of code for HASP pseudo-device support ********** @THAS802 07000204
.******* Start of code for HASP pseudo-device support ******** @THAS802 07140200
.IUN01   ANOP                    **** HASP PSEUDO DEVICES **** @THAS802 07140201
&UNPSUDO(&I) SETB 1              INDICATE PSEUDO DEVICE.     * @THAS802 07140202
         AIF   (K'&UNIT NE 9).IUN10    LOOK FOR 10 BYTE TYPES* @THAS802 07140203
&OA      SETC  '&UNIT'(6,4)                                  * @THAS802 07140204
         AIF   ('&OA' NE '1442').IUN02      NOT 1442         * @THAS802 07140205
&SGDEVTP(&I) SETA 3               SET LOW BYTE DEV TYPE      * @THAS802 07140206
         MNOTE *,'     HASP 1442 PUNCH'                      * @THAS802 07140207
         AGO   .IUN90                                        * @THAS802 07140208
.IUN02   AIF   ('&OA' NE '2520').IUN03                       * @THAS802 07140209
&SGDEVTP(&I) SETA 5                                          * @THAS802 07140210
         MNOTE *,'     HASP 2520 PUNCH'                      * @THAS802 07140211
         AGO   .IUN90                                        * @THAS802 07140212
.IUN03   AIF   ('&OA' NE '1403').IUN04                       * @THAS802 07140213
&SGDEVTP(&I) SETA 8                                          * @THAS802 07140214
         MNOTE *,'     HASP 1403 PRINTER'                    * @THAS802 07140215
         AGO   .IUN90                                        * @THAS802 07140216
.IUN04   AIF   ('&OA' NE '1443').IUN99                       * @THAS802 07140217
&SGDEVTP(&I) SETA 10                                         * @THAS802 07140218
         MNOTE *,'     HASP 1443 PRINTER'                    * @THAS802 07140219
         AGO   .IUN90                                        * @THAS802 07140220
.IUN10   AIF   (K'&UNIT NE 10).IUN99   INVALID DEV TYPE.     * @THAS802 07140221
&OA      SETC  '&UNIT'(6,5)                                  * @THAS802 07140222
         AIF   ('&OA' NE '2540R').IUN11                      * @THAS802 07140223
&SGDEVTP(&I) SETA 1                                          * @THAS802 07140224
         MNOTE *,'     HASP 2540 READER '                    * @THAS802 07140225
         AGO   .IUN90                                        * @THAS802 07140226
.IUN11   AIF   ('&OA' NE '2540P').IUN99                      * @THAS802 07140227
&SGDEVTP(&I) SETA 2                                          * @THAS802 07140228
         MNOTE *,'     HASP 2540 PUNCH  '                    * @THAS802 07140229
.IUN90   ANOP                                                * @THAS802 07140230
&SGETABA(&I) SETA &SGDEVTP(&I)   SET DEV TYP LOW BYTE.       * @THAS802 07140231
&SGDEVTP(&I) SETA X'500008'           SET DEV TYP HIGH BYTES.* @THAS802 07140232
&SGDEVB(1) SETB 1  SET FOR DEV TAB INSP                      * @THAS802 07140233
         AGO   .DD     HANDLE SAME AS DUMMY DEVICE.          * @THAS802 07140234
.******* End of code for HASP pseudo-device support ********** @THAS802 07140235
./ CHANGE NAME=SGIEC202
.******* Start of code for HASP pseudo-device support ******** @THAS802 08920200
         AIF   (NOT &UNPSUDO(&COUNTB)).IUNX1                 * @THAS802 08920201
&THISDEV SETC  'DUM'              CALL IT A DUMMY DEVICE.    * @THAS802 08920202
         AGO   .QOPCK                                        * @THAS802 08920203
.IUNX1   ANOP                                                * @THAS802 08920204
.******* End of code for HASP pseudo-device support ********** @THAS802 08920205
.******* Start of code for HASP pseudo-device support ******** @THAS802 14070200
         AIF   (NOT &UNPSUDO(&COUNTB)).IUNX2                 * @THAS802 14070201
&TYPC    SETC  'SUD'         INDICATE PSEUDODEV FOR UCB MACRO* @THAS802 14070202
.IUNX2   ANOP                                                * @THAS802 14070203
.******* End of code for HASP pseudo-device support ********** @THAS802 14070204
.******* Start of code for HASP pseudo-device support ******** @THAS802 14100200
         AIF   ('&TYPC' NE 'SUD').IUNX3                      * @THAS802 14100201
&TYPC    SETC  'DUM'         SET IT BACK TO DUMMY DEV TYPE.  * @THAS802 14100202
.IUNX3   ANOP                                                * @THAS802 14100203
.******* End of code for HASP pseudo-device support ********** @THAS802 14100204
./ REPL NAME=SGGBLPAK
 GBLA &SGTESTA(2),&HEX,&SGCTRLA(2),&SGFORTA(8),&SGSUPRA(2)              00160020
 GBLA &SGUNNMA(514),&SGCNTRA(10),&SGDADRA(768),&SGCBLEA(2)              00180095
 GBLA &SGCPRGA(23),&SGOPCHA,&SGDASDA,&SGACTR                            00200095
 GBLA &IEALOA,&IEAHIA,&IEALMTA,&SGPL11A(10),&SGSTMGA,&SGMAXDV           00240000
 GBLA &SGCBLFA(3),&SGMAXA(3),&SGFORLA(5),&SGCBLUA(3)                    00280018
 GBLA &SGSCHDA(20),&SGUTSZA,&SGALGOA(1),&SG2314A,&SG5450A,&SGSCNYA(2)   00320021
 GBLA &SGSCHAA(12),&SGSCNPA(31),&SGAR01A(31),&SGAR02A(31),&SGAR03A(31)  00324021
 GBLA &SGAR04A(31),&SGAR05A(31),&SGAR06A(31),&SGAR07A(31),&SGAR08A(31)  00324821
 GBLA &SGAR09A(31),&SGAR10A(31),&SGAR11A(31),&SGAR12A(31)               00325621
 GBLA &SG3330A,&SG2305A,&SGTGRIA(32),&SGTGROA(32)                       00332021
 GBLA &SG3505A,&SG3525A                                                 00336021
 GBLA &SGCKPA(6),&SG2321A,&SG2311A,&SGLDRA,&SGCPRNA(1),&SGBSCA          00360019
 GBLA &SGCPRPA(104),&SGLINKA(8),&SGSCNXA,&SGSCNZA                       00400017
 GBLA &SGDNBFA(768),&SGDEVTP(768),&SGETABA(768)                         00410095
 GBLA &SGCUN1A(255)                                                     00420095
 GBLA &SGGJUA(15),&SGGJCA(11)                                           00430095
 GBLA &SGEDITA(25),&SGTSOPA(4),&SGMODA(1),&SGEDT2A(25),&SGEDT3A(25)     00449421
 GBLA &SGEDT4A(25),&SGEDT5A(25)                                         00453221
 GBLB &SGGJCB(8),&SGLDRB(5)                                             00460095
 GBLB &SGCHANB(240),&SGQUITB,&SGMENTB(89),&SGSUPRB(48),&SGCPRGB(14)     00470000
 GBLB &SGUNU1B(255),&SGUNU2B(255),&SGUNU3B(255),&SGUNU4B(255)           00480095
 GBLB &SGUNU5B(255),&SGUNU6B(255),&SGUNU7B(255),&SGUNU8B(255)           00500095
 GBLB &SGUNM1B(255),&SGUNM2B(255),&SGUNM3B(255),&SGUNM4B(255)           00520095
 GBLB &SGUNM6B(255),&SGUNF4B(255),&SGUNF5B(255),&SGUNT3B(255)           00540095
 GBLB &SGUNF6B(255)                                                     00560095
 GBLB &SGUNF1B(255),&SGUNF2B(255),&SGUNF3B(255),&SGUNM5B(255)           00580095
 GBLB &SGUNT1B(255),&SGUNT2B(255),&SGTESTB(6)                           00600095
 GBLB &SGSCHDB(44),&SGDMGTB(5),&SGCPUB(54),&SGSTMGB(17),&SGDCLSB(83)    00690021
 GBLB &SGUCSIB(12),&SGUCSDB(12),&SGCKPB(56),&SGCBLUB(24)                00710017
 GBLB &SGUCSEB(2),&SG2CSIB(5),&SG2CSDB(5)                               00716020
 GBLB &SGDT01B(768),&SGDT02B(768),&SGDT03B(768),&SGDT04B(768),&LIMIT(4) 00720095
 GBLB &SGDT05B(768),&SGDT06B(768),&SGDT07B(768),&SGDT08B(768)           00730095
 GBLB &SGDT12B(768),&SG3410B(768)                                       00740095
 GBLB  &SGBRSTB(16)                                                     00750095
 GBLB &SGDU01B(768),&SGDU02B(768),&SGDU03B(768),&SGDU04B(768)           00760095
 GBLB &SGDU05B(768),&SGDU06B(768),&SGDU07B(768),&SGDU08B(768)           00770095
 GBLB &SGDU09B(768),&SGDU10B(768),&SGDU11B(768)                         00780095
 GBLB &SGDM01B(768),&SGDM02B(768),&SGDM03B(768),&SGDM04B(768)           00790095
 GBLB &SGDM05B(768),&SGDM06B(768),&SGDM07B(768),&SGDM08B(768)           00800095
 GBLB &SGDM09B(768),&SGOPSUB(768),&SG2321B(768),&SGDASWB(768)           00810095
 GBLB &SGDF01B(768),&SGDF02B(768),&SGDF03B(768),&SGDF04B(768)           00820095
 GBLB &SGDF05B(768),&SGDF06B(768),&SGDF07B(768),&SGDF08B(768)           00830095
 GBLB &SGDF09B(768),&SGDF10B(768),&SGDF11B(768),&SGDF12B(768)           00840095
 GBLB &SGDF13B(768),&SGDF14B(768),&SGDF15B(768)                         00850095
 GBLB &SGDAP1B(768),&SGDAP2B(768),&SGDAP3B(768)                         00860095
 GBLB &SGDAP4B(768),&SGDAP5B(768),&SGDAP6B(768),&SGDRQ1B(768)           00870095
 GBLB &SGDAP7B(768),&SGDAP8B(768),&SGDAP9B(768),&SGDAPAB(768)           00880095
 GBLB &SGDAPBB(768),&SGDAPCB(768),&SGDAPDB(768),&SGDAPEB(768)           00900095
 GBLB &SGDAPFB(768)                                                     00920095
 GBLB &SGDRQ2B(768)                                                     00940095
 GBLB &SGDAD1B(768),&SGDAD2B(768),&SGDAD3B(768),&SGDAD4B(768)           00960095
 GBLB &SGDAD5B(768),&SGDAD6B(768),&SGDAD7B(768),&SGDAD8B(768)           00980095
 GBLB &SGDSQ1B(768),&SGDSQ2B(768),&SGTRMDB(768),&SGSVCAB(255)           01000095
 GBLB &SGCOBLB(4),&SGSVCBB(255),&SGSVCCB(255),&SGSVCDB(255),&SGMALB(11) 01040021
 GBLB &SGSVCEB(255),&SGSVCFB(255),&SGFORTB(52),&SGLINKB(19),&SGCBLEB(6) 01080019
 GBLB &SGCBLFB(11),&SGLOADB(3),&SGOVERB(4),&SGASSEB(3),&SGPL11B(160)    01120000
 GBLB &SGCTRLB(16),&GETB(3),&SGFORLB(5),&SGGRPHB(4),&SGALGOB(5)         01160018
 GBLB &SGCHK1B(2),&SGPTOPB(1),&SGNODEV,&SGMOD1B(5),&SGMOD2B(5)          01183017
 GBLB  &SGMOD3B(5),&SGMOD4B(5),&SGMOD5B(5),&SGMOD6B(5)                  01189021
 GBLB &SGMOD7B(5),&SGMOD8B(5),&SGMOD9B(5),&SGMODAB(5),&SGMODBB(5)       01191400
 GBLB &SGSIZ1B(5),&SGSIZ2B(5),&SGSIZ3B(5),&SGSIZ4B(5),&SGSIZ5B(5)       01195000
 GBLB &SGSIZ6B(5),&SGSIZ7B(5),&SGSIZ8B(5),&SGSIZ9B(5),&SGSIZ0B(5)       01197000
 GBLB &SGEMULB(1),&SGUTILB(3)                                           01199000
 GBLB &SGSER1B(5),&SGSER2B(5),&SGSER3B(5),&SGSER4B(5),&SGMCSTB(4)       01201017
 GBLB &SGSCHRB(16),&SGSCHOB(16),&SGSCHHB(16),&SGLCPB(1)                 01208018
     GBLB &SGCKPLB(4),&SGCKFTB(4)                                       01210019
 GBLB &SGRT01B(31),&SGRT02B(31),&SGRT03B(31),&SGRT04B(31),&SGRT05B(31)  01212017
 GBLB &SGRT06B(31),&SGRT07B(31),&SGRT08B(31),&SGRT09B(31),&SGRT10B(31)  01214017
 GBLB &SGRT11B(31),&SGRT12B(31),&SGRT13B(31),&SGRT14B(31),&SGRT15B(31)  01216017
 GBLB &SGRT16B(31),&SGCMD1B(31),&SGCMD2B(31),&SGCMD3B(31),&SGCMD4B(31)  01218017
 GBLB &SGSCSDB(31),&SGSCMSB(31)                                         01218821
 GBLB &SGDUMMY(768),&SGDEVB(1),&SGTYPEB(96)                             01220095
         GBLB  &UNPSUDO(768)                                   @THAS802 01230296
         GBLB  &SGITELB(8)                                       ITEL   01230496
 GBLC &SGGJCC(11),&SGLDRC(3)                                            01240095
 GBLC &SGRESMC(11),&SGUNNMC(100),&SGCTRLC(66)                           01260095
 GBLC &SGCPRGC(26)                                                      01280017
 GBLC &SGSCHDC(15),&EBCDIC,&SGLNKLC(21),&SGSVCLC(51)                    01300095
 GBLC &SGCNTRU,&SGSCNCC(31),&SGSCNAC(31)                                01320095
 GBLC &SGCLASC(1),&SGEDITC(25),&SGEDT2C(25),&SGEDT3C(25),&SGEDT4C(25)   01331021
 GBLC &SGEDT5C(25),&SGEDT6C(25),&SGEDT7C(25)                            01333421
./ ENDUP
/*
//*
//SCRATCH EXEC PGM=IEHPROGM,REGION=128K,COND=(0,NE)
//SYSPRINT DD  SYSOUT=A
//ASPDLB   DD  DISP=OLD,UNIT=SYSDA,VOL=SER=ASPDLB
//SYSIN    DD  *
 SCRATCH DSNAME=SYS1.GENLIB,VOL=3330=ASPDLB,MEMBER=IODEVICE
 SCRATCH DSNAME=SYS1.GENLIB,VOL=3330=ASPDLB,MEMBER=SGIEC202
 SCRATCH DSNAME=SYS1.GENLIB,VOL=3330=ASPDLB,MEMBER=SGGBLPAK
/*
//COMPRESS EXEC PGM=IEBCOPY,REGION=128K,COND=(0,NE)
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DISP=SHR,DSN=SYS1.GENLIB,
//            UNIT=SYSDA,VOL=SER=ASPDLB
//SYSUT2   DD DISP=SHR,DSN=SYS1.GENLIB,
//            UNIT=SYSDA,VOL=SER=ASPDLB
//SYSIN    DD DUMMY
//*
//COPY    EXEC PGM=IEBCOPY,REGION=128K,COND=(0,NE)
//SYSPRINT DD SYSOUT=A
//SYSUT1   DD DSN=SYS1.GENTEMP,DISP=OLD
//SYSUT2   DD DISP=SHR,DSN=SYS1.GENLIB,
//            UNIT=SYSDA,VOL=SER=ASPDLB
//SYSIN    DD *
 COPY INDD=SYSUT1,OUTDD=SYSUT2
//*
//DELETE  EXEC PGM=IEFBR14,REGION=128K,COND=(0,NE)
//SYSUT1   DD DSN=SYS1.GENTEMP,DISP=(OLD,DELETE)
//
