<?php
/*
http://www.bad-behavior.ioerror.us/

Bad Behavior - detects and blocks unwanted Web accesses
Copyright (C) 2005 Michael Hampton

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// This file is the entry point for Bad Behavior.

if (!defined('MEDIAWIKI')) die();

// Settings you can adjust for Bad Behavior.
$bb2_settings_defaults = array(
	'log_table' => $wgDBprefix . 'bad_behavior',
	'display_stats' => true,
	'strict' => false,
	'verbose' => false
);

define('BB2_CWD', dirname(__FILE__));

// Bad Behavior callback functions.

// Return current time in the format preferred by your database.
function bb2_db_date() {
	return gmdate('Y-m-d H:i:s');
}

// Return affected rows from most recent query.
function bb2_db_affected_rows($result) {
	return wfAffectedRows($result);
}

// Escape a string for database usage
function bb2_db_escape($string) {
	// FIXME SECURITY: Get a straight answer from somebody on how MW escapes stuff
	return addslashes($string);
}

// Return the number of rows in a particular query.
function bb2_db_num_rows($result) {
	return wfNumRows($result);
}

// Run a query and return the results, if any.
// Should return FALSE if an error occurred.
function bb2_db_query($query) {
	$bb2_last_query = wfQuery($query, DB_WRITE);
	return $bb2_last_query;
}

// Return all rows in a particular query.
// Should contain an array of all rows generated by calling mysql_fetch_assoc()
// or equivalent and appending the result of each call to an array.
function bb2_db_rows($result) {
	$rows = array();
	while ($row = wfFetchRow($result)) {
		$rows[] = $row;
	}
	return $rows;
}

// Return emergency contact email address.
function bb2_email() {
	global $wgEmergencyContact;
	return $wgEmergencyContact;
}

// This Bad Behavior-related function is a stub. You can help MediaWiki by expanding it.
// retrieve settings from database
function bb2_read_settings() {
	global $bb2_settings_defaults;
	return $bb2_settings_defaults;
}

// This Bad Behavior-related function is a stub. You can help MediaWiki by expanding it.
// write settings to database
function bb2_write_settings($settings) {
	return;
}

// In some configurations automatic table creation may fail with the message
// You must update your load-balancing configuration.
// You can create the table manually (see query in
// bad-behavior/database.inc.php) and add this line to your LocalSettings.php:
//
//   define('BB2_NO_CREATE', true);

// installation
function bb2_install() {
	$settings = bb2_read_settings();
	if (defined('BB2_NO_CREATE')) return;
	bb2_db_query(bb2_table_structure($settings['log_table']));
}

// Return the top-level relative path of wherever we are (for cookies)
function bb2_relative_path() {
	// TODO: This might not be the best way, but it seems to work
	global $wgScript;
	return dirname($wgScript) . "/";
}

// Cute timer display
function bb2_mediawiki_timer(&$parser, &$text) {
	global $bb2_timer_total;
	$text = "<!-- Bad Behavior " . BB2_VERSION . " run time: " . number_format(1000 * $bb2_timer_total, 3) . " ms -->" . $text;
}

function bb2_mediawiki_entry() {
	global $bb2_timer_total;

	$bb2_mtime = explode(" ", microtime());
	$bb2_timer_start = $bb2_mtime[1] + $bb2_mtime[0];

	if (php_sapi_name() != 'cli') {
		require_once(BB2_CWD . "/bad-behavior/core.inc.php");
		bb2_install();	// FIXME: see above
		$settings = bb2_read_settings();
		bb2_start($settings);
	}

	$bb2_mtime = explode(" ", microtime());
	$bb2_timer_stop = $bb2_mtime[1] + $bb2_mtime[0];
	$bb2_timer_total = $bb2_timer_stop - $bb2_timer_start;
}

require_once(BB2_CWD . "/bad-behavior/version.inc.php");
$wgExtensionCredits['other'][] = array(
	'name' => 'Bad Behavior',
	'version' => BB2_VERSION,
	'author' => 'Michael Hampton',
	'description' => 'Detects and blocks unwanted Web accesses',
	'url' => 'http://www.bad-behavior.ioerror.us/'
);

$wgHooks['ParserAfterTidy'][] = 'bb2_mediawiki_timer';
$wgExtensionFunctions[] = 'bb2_mediawiki_entry';

?>
