<?php
/*
Plugin Name: Challenge
Plugin URI: http://lordchaos.dominatus.net/wordpress-plugin-challenge
Description: Based on and improved over Steve Herod's "Did you pass math?" plugin, Challenge restricts comment spam by throwing the commenter a challenge.  Default challenge is an addition and multiplication math question involving three random numbers.  The challenge and the answer can also be user defined.  They can be of anything, including PHP-evaluatable mathematical expressions.  This plugin can also be used to ensure the commenter's basic intelligence before he/she/it leaves a comment.
Author: Lordchaos
Version: 1.1
Author URI: http://lordchaos.dominatus.net
*/

/*
Copyright (C) 2006 Lordchaos

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

http://www.gnu.org/licenses/gpl.txt

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

add_action ('admin_menu', 'challenge_admin');

function challenge_admin () {
	add_options_page('Challenge Plugin Settings','Challenge', 6, __FILE__, 'challenge_optionspanel');
}

function challenge_optionspanel() {
?>
	<h2>Challenge Options</h2>
<?php
	$updated = false;

	if (isset($_POST['challenge_question'])) $updated = true;
	else if (isset($_POST['challenge_questionpos'])) $updated = true;	
	else if (isset($_POST['challenge_answer'])) $updated = true;
	else if (isset($_POST['challenge_answerpos'])) $updated = true;
	else if (isset($_POST['challenge_wronganswer'])) $updated = true;
	else if (isset($_POST['challenge_noanswer'])) $updated = true;
	
	if ($updated) {
		update_option('challenge_question', $_POST['challenge_question']);
		update_option('challenge_questionpos', $_POST['challenge_questionpos']);
		update_option('challenge_answer', $_POST['challenge_answer']);
		update_option('challenge_answerpos', $_POST['challenge_answerpos']);
		update_option('challenge_wronganswer', $_POST['challenge_wronganswer']);
		update_option('challenge_noanswer', $_POST['challenge_noanswer']);
		echo '<div class="updated"><p><strong>Options saved.</strong></p></div>';
	}
	
	$challenge_wronganswer = 	get_option('challenge_wronganswer');
	$challenge_noanswer =		get_option('challenge_noanswer');
	$challenge_question = 		get_option('challenge_question');
	$challenge_answer =		get_option('challenge_answer');
	$challenge_questionpos = 	get_option('challenge_questionpos');
	$challenge_answerpos =		get_option('challenge_answerpos');

	$questionpos_selection['above'] = '';
	$questionpos_selection['below'] = '';
	$questionpos_selection['left'] = '';
	$questionpos_selection['right'] = '';
	if ($challenge_questionpos != '') $questionpos_selection[$challenge_questionpos] = ' selected="yes"';

	$answerpos_selection['url'] = '';
	$answerpos_selection['comment'] = '';
	if ($challenge_answerpos != '') $answerpos_selection[$challenge_answerpos] = ' selected="yes"';	
?>

	<div class="wrap">
	<form name="form" method="post" action="<?php echo $_SERVER['REQUEST_URI']; ?>">

	<fieldset class="options">
		<legend>Challenge &amp; Answer</legend>
		<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<tr valign="top">
			<th width="20%" scope="row">Question:</th>
			<td><input name="challenge_question" type="text" id="challenge_question" size="80" value="<?php echo $challenge_question; ?>" />
				<br>Default question is a randomized math question involved adding and multiplying three numbers.  You can also type in any question.  HTML code may be used.  
			<br>For a math question, insert an expression in the question within [ ] brackets.  The [ ] expression must be in the format <i>%variable=expression</i>, where <i>expression</i> must be PHP-evaluatable .  For example, specifying
			<blockquote>What is the sum of [%R1=rand(0,10)] and [%R2=rand(0,10)]?</blockquote>
			will produce: "What is the sum of 3 and 4?", "...0 and 10?", "...5 and 2?", etc, and the variables $R1 and $R2 will be remembered (for use in matching the answer, see below).
		</td>
	</tr>
	<tr valign="top">
		<th width="20%" scope="row">Question Position:</th>
		<td><select name="challenge_questionpos" id="challenge_questionpos" value="<?php echo $challenge_questionpos; ?>" />
				<option<?php echo $questionpos_selection['above']; ?>>above</option>
				<option<?php echo $questionpos_selection['left']; ?>>left</option>
				<option<?php echo $questionpos_selection['right']; ?>>right</option>
				<option<?php echo $questionpos_selection['below']; ?>>below</option>
			</select><br>Where the challenge question will appear beside the answer box</td>
		</tr>
		<tr valign="top">
			<th width="20%" scope="row">Answer:</th>
			<td><input name="challenge_answer" type="text" id="challenge_answer" size="80" value="<?php echo $challenge_answer; ?>" />
				<br>Default answer is the answer to the default math question.  If you specify a question of your own, you must also specify the answer here.  Answer is not restricted in language or to a single word, and multiple answers can also be specified.  For example, when below is specified
				<blockquote>yes maybe yeah of course I guess so yup</blockquote>
				Any <i>squential match</i> to the above words will have answered the challenge.
				<br>For answer to a math question, type in a PHP-evaluatable expression containing the variables defined in the question.
				For example, the answer to the above example can be written as:
				<blockquote>%R1 + %R2</blockquote>
				and the result of will be matched with the answer given by the user. Answer matching is always case-insensitive. 	
			</td>
		</tr>
		<tr valign="top">
			<th width="20%" scope="row">Answer Position:</th>
			<td><select name="challenge_answerpos" id="challenge_answerpos" value="<?php echo $challenge_answerpos; ?>" />
				<option value="url"<?php echo $answerpos_selection['url']; ?>>before comment text</option>
				<option value="comment"<?php echo $answerpos_selection['comment']; ?>>after comment text</option>
			</select><br>Where the answer box will appear in the comment area</td>
		</tr>
		</table>
	</fieldset>
	<fieldset class="options">
		<legend>Responses</legend>
		<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<tr valign="top">
			<th width="20%" scope="row">Wrong Answer:</th>
			<td><input name="challenge_wronganswer" type="text" id="challenge_wronganswer" size="80" value="<?php echo $challenge_wronganswer; ?>" /><br>Default is "You have failed the challenge!"</td>
		</tr>
		<tr valign="top">
			<th width="20%" scope="row">No Answer:</th>
			<td><input name="challenge_noanswer" type="text" id="challenge_noanswer" size="80" value="<?php echo $challenge_noanswer; ?>" /><br>Default is "Answer the challenge!"</td>
		</tr>
		</table>
	</fieldset>
		
	<p class="submit">
	  <input type="submit" name="Submit" value="Update Settings &raquo;" />
	</p>
	</form>
	</div>
<?php 
}

if (!class_exists('Challenge')) {
@session_start();

class Challenge
{
    var $_k2 = false;			//Change false to true if you are using the k2 theme
    var $_no_session_cookies = false;	//Change false to true to turn off the requirement for session cookies 
	
    function Challenge()
    {
        add_action('comment_form', array(&$this, 'comment_form'));	
        add_action('comment_post', array(&$this, 'comment_post'));	
    }
    
    function comment_form()
    {
        global $wpdb, $user_ID, $_SERVER;

	// If the user is logged in, dont prompt for code
        if (isset($user_ID)) {
            return $post_ID;
        }

	$challenge_question = 		get_option('challenge_question');
	$challenge_answer =		get_option('challenge_answer');
	$challenge_questionpos = 	get_option('challenge_questionpos');
	$challenge_answerpos =		get_option('challenge_answerpos');

	if ($challenge_questionpos == '') $challenge_questionpos = 'above';
	if ($challenge_answerpos == '') $challenge_answerpos = 'url';
	
	if ($challenge_question == '' || $challenge_answer == '') {

		// default question
		
		$operand1 = rand(0,10);
	       	$operand2 = rand(0,10);
		$operand3 = rand(0,10);
		$op = rand(0,1);

		$answer = 0;
		if ($op == 0)
		{
		  $answer = $operand1 * $operand2 + $operand3;
		  $question = "%operand1 &times; %operand2 + %operand3 = ?";	
		}
		else if ($op == 1)
		{
		  $answer = $operand1 + $operand2 * $operand3;
		  $question = "%operand1 + %operand2 &times; %operand3 = ?";	
		}
		
		$question = str_replace("%operand1",$operand1,$question);
		$question = str_replace("%operand2",$operand2,$question);
        	$question = str_replace("%operand3",$operand3,$question);
	}
	else {
		$question = $challenge_question;
		$answer = $challenge_answer;
		if (preg_match_all("/\[(\%.+) *= *(.+)\]/U", $challenge_question, $matches, PREG_SET_ORDER) != 0) {
			foreach ($matches as $var_exp) {
				eval("\$evaled=" . $var_exp[2] . ";");
				$question = str_replace($var_exp[0], $evaled, $question); 
				$answer = str_replace($var_exp[1], $evaled, $answer);
			}
			eval("\$answer=" . $answer . ";");
		}
	}
?>
        <div id="answerdiv">
    	    <p><br>
<?php
	if ($challenge_questionpos == 'left' || $challenge_questionpos == 'above') {
    		echo '<label for="answer">' . $question . '</label>';     
		if ($challenge_questionpos == 'above') echo '<br>';
	}
?>
            <input type="text" name="answer" id="answer" size="6" tabindex="4" /> 
<?php
	if ($challenge_questionpos == 'right' || $challenge_questionpos == 'below') {
    		if ($challenge_questionpos == 'below') echo '<br>';
		echo '<label for="answer">' . $question . '</label>';     
	}

       	if ($this->_no_session_cookies)
 	{
?>           
	<input type="hidden" name="no_session" id="no_session" size="6" tabindex="4" value="<?php echo $answer; ?>" />
<?php
	}
?>
            </p>
        </div>
        
         <script type="text/javascript">
            var commentField = document.getElementById("<?php echo $challenge_answerpos; ?>");
            var submitp = commentField.parentNode;
            var answerDiv = document.getElementById("answerdiv");	    
            submitp.appendChild(answerDiv, commentField);
        </script>
        
        <?php
        
        $_SESSION['CHALLENGE_ANSWER'] = $answer;        
        return $post_ID;
    }

    function comment_post($post_ID)
    {
        global $wpdb, $user_ID, $_POST, $_SESSION, $comment_type, $comment_count_cache;

        $answer = $_POST['answer'];
	$entry_id= $_POST['comment_post_ID'];
	$no_session_answer = $_POST['no_session'];
	$challenge_noanswer = get_option('challenge_noanswer');
	$challenge_wronganswer = get_option('challenge_wronganswer');

	$wronganswer = "You have failed the challenge!";
	$noanswer = "Answer the challenge!";
	
	if ($challenge_noanswer != '') $noanswer = $challenge_noanswer;
	if ($challenge_wronganswer != '') $wronganswer = $challenge_wronganswer;
				
        // If the user is not logged in check the security code
        if ( !$user_ID  && ($comment_type === '')) {
            // puke on an empty code
            if ( '' == $answer ) {            
      		$wpdb->query("DELETE FROM {$wpdb->comments} WHERE comment_ID = {$post_ID}"); //roll back  
      		//Recount the comments
      		$count = $wpdb->get_var("select count(*) from $wpdb->comments where comment_post_id = {$entry_id} and comment_approved = '1'");	
		//$wpdb->query("update $wpdb->posts set comment_count = $count where ID = {$entry_id}");
		$comment_count_cache[$entry_id]--;
  		if ($this->_k2) {
  			fail( __($noanswer) );
  		}
  		else {
               		die( __($noanswer) );
               	}
            }

	    $correct_answer = $_SESSION['CHALLENGE_ANSWER'];
            // verify the code against the session cookie or hidden var.
            if ((stristr($correct_answer,$answer) == FALSE) || 
	    	($this->_no_session_cookies && (stristr($correct_answer,$no_session_answer)==FALSE))) {

		$wpdb->query("DELETE FROM {$wpdb->comments} WHERE comment_ID = {$post_ID}"); //roll back  
              	//Recount the comments
      		$count = $wpdb->get_var("select count(*) from $wpdb->comments where comment_post_id = {$entry_id} and comment_approved = '1'");	
		//$wpdb->query("update $wpdb->posts set comment_count = $count where ID = {$entry_id}");
		$comment_count_cache[$entry_id]--;
  		if ($this->_k2) {
  			fail( __($wronganswer) );
  		}
  		else {
               		die( __($wronganswer) );
               	}
            } else {
		//Clean up
                unset($_SESSION['CHALLENGE_ANSWER']);
            }
        }
        return $post_ID;
    }
    
}
		

}   //end if

$challenge = new Challenge();

?>
