
<chapter>
<chaptertitle>ALGEBRA REFERENCE</chaptertitle>


<section>
<sectiontitle>Basic identities</sectiontitle>

<index>Algebraic identities</index>

<image>11018.png</image>

<para>
Note: while division by zero is popularly thought to be equal to infinity, this is not technically true.  In some practical applications it may be helpful to think the result of such a fraction <italic>approaching</italic> positive infinity as a positive denominator <italic>approaches</italic> zero (imagine calculating current I=E/R in a circuit with resistance approaching zero -- current would approach infinity), but the actual fraction of anything divided by zero is undefined in the scope of either real or complex numbers.
</para>

</section>




<section>
<sectiontitle>Arithmetic properties</sectiontitle>

<index>Properties, arithmetic</index>

<subsection>
<subsectiontitle>The associative property</subsectiontitle>

<para>
In addition and multiplication, terms may be arbitrarily <italic>associated</italic> with each other through the use of parentheses:
</para>

<image>11019.png</image>

</subsection>



<subsection>
<subsectiontitle>The commutative property</subsectiontitle>

<para>
In addition and multiplication, terms may be arbitrarily interchanged, or <italic>commutated</italic>:
</para>

<image>11020.png</image>

</subsection>




<subsection>
<subsectiontitle>The distributive property</subsectiontitle>

<image>11021.png</image>

</subsection>

</section>





<section>
<sectiontitle>Properties of exponents</sectiontitle>

<index>Properties, exponents</index>

<image>11022.png</image>

</section>



<section>
<sectiontitle>Radicals</sectiontitle>

<index>Properties, radicals </index>

<subsection>
<subsectiontitle>Definition of a radical</subsectiontitle>

<para>
When people talk of a "square root," they're referring to a radical with a root of 2.  This is mathematically equivalent to a number raised to the power of 1/2.  This equivalence is useful to know when using a calculator to determine a strange root.  Suppose for example you needed to find the fourth root of a number, but your calculator lacks a "4th root" button or function.  If it has a y<superscript>x</superscript> function (which any scientific calculator should have), you can find the fourth root by raising that number to the 1/4 power, or x<superscript>0.25</superscript>.
</para>

<image>11023.png</image>

<para>
It is important to remember that when solving for an <italic>even</italic> root (square root, fourth root, etc.) of any number, there are <italic>two</italic> valid answers.  For example, most people know that the square root of nine is three, but <italic>negative</italic> three is also a valid answer, since (-3)<superscript>2</superscript> = 9 just as 3<superscript>2</superscript> = 9.
</para>

</subsection>



<subsection>
<subsectiontitle>Properties of radicals</subsectiontitle>

<image>11024.png</image>

</subsection>

</section>





<section>
<sectiontitle>Important constants</sectiontitle>

<index>Constants, mathematical</index>

<subsection>
<subsectiontitle>Euler's number</subsectiontitle>

<para>
Euler's constant is an important value for exponential functions, especially scientific applications involving decay (such as the decay of a radioactive substance).  It is especially important in calculus due to its uniquely self-similar properties of integration and differentiation.
</para>

<literal>
e approximately equals:
2.71828 18284 59045 23536 02874 71352 66249 77572 47093 69996
</literal>
 
<image>11025.png</image>

</subsection>



<subsection>
<subsectiontitle>Pi</subsectiontitle>

<para>
Pi (<pi>) is defined as the ratio of a circle's circumference to its diameter.
</para>

<literal>
Pi approximately equals:
3.14159 26535 89793 23846 26433 83279 50288 41971 69399 37511
</literal>

<bigspace>
                                 
<para>
<bold>Note:</bold> For both Euler's constant (<italic>e</italic>) and pi (<pi>), the spaces shown between each set of five digits have no mathematical significance.  They are placed there just to make it easier for your eyes to "piece" the number into five-digit groups when manually copying.
</para>

</subsection>

</section>





<section>
<sectiontitle>Logarithms</sectiontitle>


<subsection>
<subsectiontitle>Definition of a logarithm</subsectiontitle>

<index>Logarithm</index>

<image>11026.png</image>

<para>
"log" denotes a common logarithm (base = 10), while "ln" denotes a natural logarithm (base = e).
</para>

</subsection>




<subsection>
<subsectiontitle>Properties of logarithms</subsectiontitle>

<image>11027.png</image>

<index>Transform function, definition of</index>

<para>
These properties of logarithms come in handy for performing complex multiplication and division operations.  They are an example of something called a <italic>transform function</italic>, whereby one type of mathematical operation is transformed into another type of mathematical operation that is simpler to solve.  Using a table of logarithm figures, one can multiply or divide numbers by adding or subtracting their logarithms, respectively. then looking up that logarithm figure in the table and seeing what the final product or quotient is. 
</para>

<index>Slide rule</index>

<para>
Slide rules work on this principle of logarithms by performing multiplication and division through addition and subtraction of distances on the slide.
</para>

<image>01044.png</image>

<para>
Marks on a slide rule's scales are spaced in a logarithmic fashion, so that a linear positioning of the scale or cursor results in a nonlinear indication as read on the scale(s).  Adding or subtracting lengths on these logarithmic scales results in an indication equivalent to the product or quotient, respectively, of those lengths.
</para>

<para>
Most slide rules were also equipped with special scales for trigonometric functions, powers, roots, and other useful arithmetic functions.
</para>

</subsection>

</section>




<section>
<sectiontitle>Factoring equivalencies</sectiontitle>

<index>Factoring</index>

<image>11028.png</image>

</section>



<section>
<sectiontitle>The quadratic formula</sectiontitle>

<index>Quadratic formula</index>

<image>11029.png</image>

</section>




<section>
<sectiontitle>Sequences</sectiontitle>

<index>Sequences</index>
<index>Arithmetic sequence</index>
<index>Common difference</index>
<index>Difference, common</index>

<subsection>
<subsectiontitle>Arithmetic sequences</subsectiontitle>

<para>
An <italic>arithmetic sequence</italic> is a series of numbers obtained by adding (or subtracting) the same value with each step.  A child's counting sequence (1, 2, 3, 4, . . .) is a simple arithmetic sequence, where the <italic>common difference</italic> is 1: that is, each adjacent number in the sequence differs by a value of one.  An arithmetic sequence counting only even numbers (2, 4, 6, 8, . . .) or only odd numbers (1, 3, 5, 7, 9, . . .) would have a common difference of 2.
</para>

<para>
In the standard notation of sequences, a lower-case letter "a" represents an element (a single number) in the sequence.  The term "a<subscript>n</subscript>" refers to the element at the n<superscript>th</superscript> step in the sequence.  For example, "a<subscript>3</subscript>" in an even-counting (common difference = 2) arithmetic sequence starting at 2 would be the number 6, "a<subscript></subscript>" representing 4 and "a<subscript>1</subscript>" representing the starting point of the sequence (given in this example as 2).
</para>

<para>
A capital letter "A" represents the <italic>sum</italic> of an arithmetic sequence.  For instance, in the same even-counting sequence starting at 2, A<subscript>4</subscript> is equal to the sum of all elements from a<subscript>1</subscript> through a<subscript>4</subscript>, which of course would be 2 + 4 + 6 + 8, or 20.
</para>

<image>11030.png</image>

</subsection>




<subsection>
<subsectiontitle>Geometric sequences</subsectiontitle>

<index>Geometric sequence</index>
<index>Common ratio</index>
<index>Ratio, common</index>

<para>
A <italic>geometric sequence</italic>, on the other hand, is a series of numbers obtained by multiplying (or dividing) by the same value with each step.  A binary place-weight sequence (1, 2, 4, 8, 16, 32, 64, . . .) is a simple geometric sequence, where the <italic>common ratio</italic> is 2: that is, each adjacent number in the sequence differs by a <italic>factor</italic> of two.  
</para>

<image>11031.png</image>

</subsection>

</section>



<section>
<sectiontitle>Factorials</sectiontitle>

<index>Factorial</index>
<index>! (factorial)</index>

<subsection>
<subsectiontitle>Definition of a factorial</subsectiontitle>

<para>
Denoted by the symbol "!" after an integer; the product of that integer and all integers in descent to 1.
</para>

<para>
Example of a factorial:
</para>

<image>11032.png</image>

</subsection>




<subsection>
<subsectiontitle>Strange factorials</subsectiontitle>

<image>11033.png</image>

</subsection>

</section>



<section>
<sectiontitle>Solving simultaneous equations</sectiontitle>

<index>Simultaneous equations</index>
<index>Systems of linear equations</index>

<para>
The terms <italic>simultaneous equations</italic> and <italic>systems of equations</italic> refer to conditions where two or more unknown variables are related to each other through an equal number of equations.  Consider the following example:
</para>

<image>11068.png</image>

<para>
For this set of equations, there is but a single combination of values for <typewriter>x</typewriter> and <typewriter>y</typewriter> that will satisfy both.  Either equation, considered separately, has an infinitude of valid <typewriter>(x,y)</typewriter> solutions, but <italic>together</italic> there is only one.  Plotted on a graph, this condition becomes obvious:
</para>

<image>11069.png</image>

<para>
Each line is actually a continuum of points representing possible <typewriter>x</typewriter> and <typewriter>y</typewriter> solution pairs for each equation.  Each equation, separately, has an infinite number of ordered pair (<typewriter>x</typewriter>,<typewriter>y</typewriter>) solutions.  There is only one point where the two linear functions <typewriter>x + y = 24</typewriter> and <typewriter>2x - y = -6</typewriter> intersect (where one of their many independent solutions happen to work for both equations), and that is where <typewriter>x</typewriter> is equal to a value of 6 and <typewriter>y</typewriter> is equal to a value of 18.
</para>

<para>
Usually, though, graphing is not a very efficient way to determine the simultaneous solution set for two or more equations.  It is especially impractical for systems of three or more variables.  In a three-variable system, for example, the solution would be found by the point intersection of three planes in a three-dimensional coordinate space -- not an easy scenario to visualize.
</para>


<subsection>
<subsectiontitle>Substitution method</subsectiontitle>

<index>Substitution method, simultaneous equations</index>

<para>
Several algebraic techniques exist to solve simultaneous equations.  Perhaps the easiest to comprehend is the <italic>substitution</italic> method.  Take, for instance, our two-variable example problem:
</para>

<image>11068.png</image>

<para>
In the substitution method, we manipulate one of the equations such that one variable is defined in terms of the other:
</para>

<image>11070.png</image>

<para>
Then, we take this new <italic>definition</italic> of one variable and <italic>substitute</italic> it for the same variable in the other equation.  In this case, we take the definition of <typewriter>y</typewriter>, which is <typewriter>24 - x</typewriter> and substitute this for the <typewriter>y</typewriter> term found in the other equation:
</para>

<image>11071.png</image>

<para>
Now that we have an equation with just a single variable (<typewriter>x</typewriter>), we can solve it using "normal" algebraic techniques:
</para>

<image>11072.png</image>

<para>
Now that <typewriter>x</typewriter> is known, we can plug this value into any of the original equations and obtain a value for y.  Or, to save us some work, we can plug this value (6) into the equation we just generated to define <typewriter>y</typewriter> in terms of <typewriter>x</typewriter>, being that it is already in a form to solve for <typewriter>y</typewriter>:
</para>

<image>11073.png</image>

<para>
Applying the substitution method to systems of three or more variables involves a similar pattern, only with more work involved.  This is generally true for any method of solution: the number of steps required for obtaining solutions increases rapidly with each additional variable in the system.
</para>

<para>
To solve for three unknown variables, we need at least three equations.  Consider this example:
</para>

<image>11074.png</image>

<para>
Being that the first equation has the simplest coefficients (1, -1, and 1, for <typewriter>x</typewriter>, <typewriter>y</typewriter>, and <typewriter>z</typewriter>, respectively), it seems logical to use it to develop a definition of one variable in terms of the other two.  In this example, I'll solve for <typewriter>x</typewriter> in terms of <typewriter>y</typewriter> and <typewriter>z</typewriter>:
</para>

<image>11075.png</image>

<para>
Now, we can substitute this definition of <typewriter>x</typewriter> where <typewriter>x</typewriter> appears in the other two equations:
</para>

<image>11076.png</image>

<para>
Reducing these two equations to their simplest forms:
</para>

<image>11077.png</image>

<para>
So far, our efforts have reduced the system from three variables in three equations to two variables in two equations.  Now, we can apply the substitution technique again to the two equations <typewriter>4y - z = 4</typewriter> and <typewriter>-3y + 4z = 36</typewriter> to solve for either <typewriter>y</typewriter> or <typewriter>z</typewriter>.  First, I'll manipulate the first equation to define <typewriter>z</typewriter> in terms of <typewriter>y</typewriter>:
</para>

<image>11078.png</image>

<para>
Next, we'll substitute this definition of <typewriter>z</typewriter> in terms of <typewriter>y</typewriter> where we see <typewriter>z</typewriter> in the other equation:
</para>

<image>11079.png</image>

<para>
Now that <typewriter>y</typewriter> is a known value, we can plug it into the equation defining <typewriter>z</typewriter> in terms of <typewriter>y</typewriter> and obtain a figure for <typewriter>z</typewriter>:
</para>

<image>11080.png</image>

<para>
Now, with values for <typewriter>y</typewriter> and <typewriter>z</typewriter> known, we can plug these into the equation where we defined <typewriter>x</typewriter> in terms of <typewriter>y</typewriter> and <typewriter>z</typewriter>, to obtain a value for <typewriter>x</typewriter>:
</para>

<image>11081.png</image>

<para>
In closing, we've found values for <typewriter>x</typewriter>, <typewriter>y</typewriter>, and <typewriter>z</typewriter> of 2, 4, and 12, respectively, that satisfy all three equations.
</para>

</subsection>



<subsection>
<subsectiontitle>Addition method</subsectiontitle>

<index>Addition method, simultaneous equations</index>

<para>
While the substitution method may be the easiest to grasp on a conceptual level, there are other methods of solution available to us.  One such method is the so-called <italic>addition</italic> method, whereby equations are added to one another for the purpose of canceling variable terms.
</para>

<para>
Let's take our two-variable system used to demonstrate the substitution method:
</para>

<image>11068.png</image>

<para>
One of the most-used rules of algebra is that you may perform any arithmetic operation you wish to an equation so long as you do it <italic>equally to both sides</italic>.  With reference to addition, this means we may add any quantity we wish to both sides of an equation -- so long as its the <italic>same</italic> quantity -- without altering the truth of the equation.
</para>

<para>
An option we have, then, is to add the corresponding sides of the equations together to form a new equation.  Since each equation is an expression of equality (the same quantity on either side of the <typewriter>=</typewriter> sign), adding the left-hand side of one equation to the left-hand side of the other equation is valid so long as we add the two equations' right-hand sides together as well.  In our example equation set, for instance, we may add <typewriter>x + y</typewriter> to <typewriter>2x - y</typewriter>, and add <typewriter>24</typewriter> and <typewriter>-6</typewriter> together as well to form a new equation.  What benefit does this hold for us?  Examine what happens when we do this to our example equation set:
</para>

<image>11082.png</image>

<para>
Because the top equation happened to contain a positive <typewriter>y</typewriter> term while the bottom equation happened to contain a negative <typewriter>y</typewriter> term, these two terms canceled each other in the process of addition, leaving no <typewriter>y</typewriter> term in the sum.  What we have left is a new equation, but one with only a single unknown variable, <typewriter>x</typewriter>!  This allows us to easily solve for the value of <typewriter>x</typewriter>:
</para>

<image>11083.png</image>

<para>
Once we have a known value for <typewriter>x</typewriter>, of course, determining <typewriter>y</typewriter>'s value is a simply matter of substitution (replacing <typewriter>x</typewriter> with the number <typewriter>6</typewriter>) into one of the original equations.  In this example, the technique of adding the equations together worked well to produce an equation with a single unknown variable.  What about an example where things aren't so simple?  Consider the following equation set:
</para>

<image>11084.png</image>

<para>
We could add these two equations together -- this being a completely valid algebraic operation -- but it would not profit us in the goal of obtaining values for <typewriter>x</typewriter> and <typewriter>y</typewriter>:
</para>

<image>11085.png</image>

<para>
The resulting equation still contains two unknown variables, just like the original equations do, and so we're no further along in obtaining a solution.  However, what if we could manipulate one of the equations so as to have a negative term that <italic>would</italic> cancel the respective term in the other equation when added?  Then, the system would reduce to a single equation with a single unknown variable just as with the last (fortuitous) example.  
</para>

<para>
If we could only turn the <typewriter>y</typewriter> term in the lower equation into a <typewriter>- 2y</typewriter> term, so that when the two equations were added together, both <typewriter>y</typewriter> terms in the equations would cancel, leaving us with only an <typewriter>x</typewriter> term, this would bring us closer to a solution.  Fortunately, this is not difficult to do.  If we <italic>multiply</italic> each and every term of the lower equation by a <typewriter>-2</typewriter>, it will produce the result we seek:
</para>

<image>11086.png</image>

<para>
Now, we may add this new equation to the original, upper equation:
</para>

<image>11087.png</image>

<para>
Solving for <typewriter>x</typewriter>, we obtain a value of <typewriter>3</typewriter>:
</para>

<image>11088.png</image>

<para>
Substituting this new-found value for <typewriter>x</typewriter> into one of the original equations, the value of <typewriter>y</typewriter> is easily determined:
</para>

<image>11089.png</image>

<para>
Using this solution technique on a three-variable system is a bit more complex.  As with substitution, you must use this technique to reduce the three-equation system of three variables down to two equations with two variables, then apply it again to obtain a single equation with one unknown variable.  To demonstrate, I'll use the three-variable equation system from the substitution section:
</para>

<image>11074.png</image>

<para>
Being that the top equation has coefficient values of <typewriter>1</typewriter> for each variable, it will be an easy equation to manipulate and use as a cancellation tool.  For instance, if we wish to cancel the <typewriter>3x</typewriter> term from the middle equation, all we need to do is take the top equation, multiply each of its terms by <typewriter>-3</typewriter>, then add it to the middle equation like this:
</para>

<image>11090.png</image>

<para>
We can rid the bottom equation of its <typewriter>-5x</typewriter> term in the same manner: take the original top equation, multiply each of its terms by <typewriter>5</typewriter>, then add that modified equation to the bottom equation, leaving a new equation with only <typewriter>y</typewriter> and <typewriter>z</typewriter> terms:
</para>

<image>11091.png</image>

<para>
At this point, we have two equations with the same two unknown variables, <typewriter>y</typewriter> and <typewriter>z</typewriter>:
</para>

<image>11092.png</image>

<para>
By inspection, it should be evident that the <typewriter>-z</typewriter> term of the upper equation could be leveraged to cancel the <typewriter>4z</typewriter> term in the lower equation if only we multiply each term of the upper equation by <typewriter>4</typewriter> and add the two equations together:
</para>

<image>11093.png</image>

<para>
Taking the new equation <typewriter>13y = 52</typewriter> and solving for <typewriter>y</typewriter> (by dividing both sides by <typewriter>13</typewriter>), we get a value of <typewriter>4</typewriter> for <typewriter>y</typewriter>.  Substituting this value of <typewriter>4</typewriter> for <typewriter>y</typewriter> in either of the two-variable equations allows us to solve for <typewriter>z</typewriter>.  Substituting both values of <typewriter>y</typewriter> and <typewriter>z</typewriter> into any one of the original, three-variable equations allows us to solve for <typewriter>x</typewriter>.  The final result (I'll spare you the algebraic steps, since you should be familiar with them by now!) is that <typewriter>x = 2</typewriter>, <typewriter>y = 4</typewriter>, and <typewriter>z = 12</typewriter>.
</para>

</subsection>

</section>




<section>
<sectiontitle>Contributors</sectiontitle>

<para>
Contributors to this chapter are listed in chronological order of their contributions, from most recent to first.  See Appendix 2 (Contributor List) for dates and contact information.
</para>

<para>
<bold>Chirvasuta Constantin</bold> (April 2, 2003): Pointed out error in quadratic equation formula.
</para>

</section>


</chapter>

<pagebreak>

