
<chapter>
<chaptertitle>COLOR CODES</chaptertitle>
<proofread>

<section>
<sectiontitle>Resistor Color Codes </sectiontitle>

<para>
Components and wires are coded with colors to identify their value and function.
</para>



<index>Resistor color codes</index>

<image>11066.png</image>

<para>
The colors brown, red, green, blue, and violet are used as tolerance codes on 5-band resistors only.  All 5-band resistors use a colored tolerance band.  The blank (20%) "band" is only used with the "4-band" code (3 colored bands + a blank "band").
</para>

<bigspace>

<image>11067.png</image>



<subsection>
<subsectiontitle>Example #1</subsectiontitle>

<image>11012.png</image>

<para>
A resistor colored <italic>Yellow-Violet-Orange-Gold</italic> would be 47 k<OMEGA> with a tolerance of +/- 5%.
</para>

</subsection>



<subsection>
<subsectiontitle>Example #2</subsectiontitle>

<image>11013.png</image>

<para>
A resistor colored <italic>Green-Red-Gold-Silver</italic> would be 5.2 <OMEGA> with a tolerance of +/- 10%.
</para>

</subsection>



<subsection>
<subsectiontitle>Example #3</subsectiontitle>

<image>11014.png</image>

<para>
A resistor colored <italic>White-Violet-Black</italic> would be 97 <OMEGA> with a tolerance of +/- 20%.  When you see only three color bands on a resistor, you know that it is actually a 4-band code with a blank (20%) tolerance band.
</para>

</subsection>



<subsection>
<subsectiontitle>Example #4</subsectiontitle>

<image>11015.png</image>

<para>
A resistor colored <italic>Orange-Orange-Black-Brown-Violet</italic> would be 3.3 k<OMEGA> with a tolerance of +/- 0.1%. 
</para>

</subsection>



<subsection>
<subsectiontitle>Example #5</subsectiontitle>

<image>11016.png</image>

<para>
A resistor colored <italic>Brown-Green-Grey-Silver-Red</italic> would be 1.58 <OMEGA> with a tolerance of +/- 2%.
</para>

</subsection>




<subsection>
<subsectiontitle>Example #6</subsectiontitle>

<image>11017.png</image>

<para>
A resistor colored <italic>Blue-Brown-Green-Silver-Blue</italic> would be 6.15 <OMEGA> with a tolerance of +/- 0.25%.
</para>

</subsection>


</section>


<section>
<sectiontitle>Wiring Color Codes </sectiontitle>

<para>
Wiring for AC and DC power distribution branch circuits are color coded for identification of individual  wires. In some jurisdictions all wire colors are specified in legal documents. In other jurisdictions, only a few conductor colors are so codified. In that case, local custom dictates the ``optional'' wire colors.
</para>



<para>
<bold>IEC, AC:</bold> Most of Europe abides by IEC (International Electrotechnical Commission) wiring color codes for AC  branch circuits. These are listed in  Table<ref>wire.tbl below</ref>. The older color codes in the table reflect the previous style which did not account for proper phase rotation. The protective ground wire (listed as green-yellow) is green with yellow stripe.
</para>


<table>wire.tbl<caption>IEC (most of Europe) AC power circuit wiring color codes.</caption>

<tabular>{|l|l|l|l|}

<hr>

<tr>
<th>Function</th><th>label</th><th>Color, IEC</th><th>Color, old IEC </th>
</tr>
<hr>

<tr>
<td>Protective earth</td><td>PE</td><td>green-yellow</td><td>green-yellow</td>
</tr>


<tr>
<td>Neutral</td><td>N</td><td>blue</td><td>blue</td>
</tr>


<tr>
<td>Line, single phase</td><td>L</td><td>brown</td><td>brown or black</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L1</td><td>brown</td><td>brown or black</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L2</td><td>black</td><td>brown or black</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L3</td><td>grey</td><td>brown or black</td>
</tr>
<hr>

</tabular>
</table>

<bigspace>

<para>
<bold>UK, AC:</bold> The United Kingdom now follows the IEC AC wiring color codes.  Table<ref>wire2.tbl below</ref> lists these along with the obsolete domestic color codes. For adding new colored wiring to existing old colored wiring see Cook. <cite>PCk</cite>
</para>


<table>wire2.tbl<caption>UK AC power circuit wiring color codes.</caption>

<tabular>{|l|l|l|l|}

<hr>

<tr>
<th>Function</th><th>label</th><th>Color, IEC</th><th>Old UK color</th>
</tr>
<hr>

<tr>
<td>Protective earth</td><td>PE</td><td>green-yellow</td><td>green-yellow</td>
</tr>


<tr>
<td>Neutral</td><td>N</td><td>blue</td><td>black</td>
</tr>


<tr>
<td>Line, single phase</td><td>L</td><td>brown</td><td>red</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L1</td><td>brown</td><td>red</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L2</td><td>black</td><td>yellow</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L3</td><td>grey</td><td>blue</td>
</tr>
<hr>

</tabular>
</table>

<bigspace>

<para>
<bold>US, AC:</bold>The US National Electrical Code only mandates white (or grey) for the neutral power conductor and bare copper, green, or green with yellow stripe for the protective ground. In principle any other colors except these may be used for the power conductors. The colors adopted as local practice are shown in Table<ref>wire3.tbl below</ref>. Black, red, and  blue are used for 208 VAC three-phase; brown, orange and yellow are used for 480 VAC. Conductors larger than #6 AWG are only available in black and are color taped at the ends.
</para>



<table>wire3.tbl<caption>US AC power circuit wiring color codes.</caption>

<tabular>{|l|l|l|l|}

<hr>

<tr>
<th>Function</th><th>label</th><th>Color, common</th><th>Color, alternative</th>
</tr>
<hr>

<tr>
<td>Protective ground</td><td>PG</td><td>bare, green, or green-yellow </td><td>green</td>
</tr>


<tr>
<td>Neutral</td><td>N</td><td>white</td><td> grey</td>
</tr>


<tr>
<td>Line, single phase</td><td>L</td><td>black or red (2nd hot)</td><td><sp></td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L1</td><td>black</td><td>brown</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L2</td><td>red</td><td>orange</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L3</td><td>blue</td><td>yellow</td>
</tr>
<hr>

</tabular>
</table>


<para>
<bold>Canada:</bold> Canadian wiring is governed by the CEC (Canadian Electric Code).  See Table<ref>wire6.tbl below</ref>. The protective ground is green or green with yellow stripe. The neutral is white, the hot (live or active) single phase wires are black , and red in the case of a second active. Three-phase lines are red, black, and blue.
</para>

<table>wire6.tbl<caption>Canada AC power circuit wiring color codes.</caption>

<tabular>{|l|l|l|}

<hr>

<tr>
<th>Function</th><th>label</th><th>Color, common</th>
</tr>
<hr>

<tr>
<td>Protective ground</td><td>PG</td><td>green or green-yellow</td>
</tr>


<tr>
<td>Neutral</td><td>N</td><td>white</td>
</tr>


<tr>
<td>Line, single phase</td><td>L</td><td>black or red (2nd hot)</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L1</td><td>red</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L2</td><td>black</td>
</tr>


<tr>
<td>Line, 3-phase</td><td>L3</td><td>blue</td>
</tr>
<hr>

</tabular>
</table>


<para>
<bold>IEC, DC:</bold> DC power installations, for example, solar power and computer data centers, use color coding which follows the AC standards. The IEC color standard for DC power cables is listed in Table<ref>wire4.tbl below</ref>, adapted from Table 2, Cook. <cite>PCk</cite>
</para>


<table>wire4.tbl<caption>IEC  DC power circuit wiring color codes.</caption>

<tabular>{|l|l|l|}

<hr>

<tr>
<th>Function</th><th>label</th><th>Color</th>
</tr>
<hr>

<tr>
<td>Protective earth</td><td>PE</td><td>green-yellow</td>
</tr>


<tr>
<th><sp>2-wire unearthed DC Power System</th><th><sp></th><th><sp></th>
</tr>
<hr>

<tr>
<td>Positive</td><td>L+</td><td>brown</td>
</tr>

<tr>
<td>Negative</td><td>L-</td><td>grey</td>
</tr>
<hr>

<tr>
<th><sp>2-wire earthed DC Power System</th><th><sp></th><th><sp></th>
</tr>
<hr>

<tr>
<td>Positive (of a negative earthed) circuit</td><td>L+</td><td>brown</td>
</tr>

<tr>
<td>Negative (of a negative earthed) circuit</td><td>M</td><td>blue</td>
</tr>

<tr>
<td>Positive (of a positive earthed) circuit</td><td>M</td><td>blue</td>
</tr>

<tr>
<td>Negative (of a positive earthed) circuit</td><td>L-</td><td>grey</td>
</tr>
<hr>

<tr>
<th><sp>3-wire earthed DC Power System</th><th><sp></th><th><sp></th>
</tr>
<hr>

<tr>
<td>Positive</td><td>L+</td><td>brown</td>
</tr>

<tr>
<td>Mid-wire</td><td>M</td><td>blue</td>
</tr>

<tr>
<td>Negative</td><td>L-</td><td>grey</td>
</tr>
<hr>

</tabular>
</table>


<para>
<bold>US DC power:</bold> The US National Electrical Code (for both AC and DC) mandates that the grounded neutral conductor of a power system be white or grey. The protective ground must be bare, green or green-yellow striped. Hot (active) wires may be any other colors except these. However, common practice (per local electrical inspectors) is for the first hot (live or active) wire to be black and the second hot to be red. The recommendations in Table<ref>wire5.tbl below</ref> are by Wiles. <cite>JWi</cite> He makes no recommendation for ungrounded power system colors. Usage of the ungrounded system is discouraged for safety. However, red (+) and black (-) follows the coloring of the grounded systems in the table.
</para>


<table>wire5.tbl<caption>US  recommended DC power circuit wiring color codes.</caption>

<tabular>{|l|l|l|}

<hr>

<tr>
<th>Function</th><th>label</th><th>Color</th>
</tr>
<hr>

<tr>
<td>Protective ground</td><td>PG</td><td>bare, green, or green-yellow</td>
</tr>


<tr>
<th><sp>2-wire ungrounded DC Power System</th><th><sp></th><th><sp></th>
</tr>
<hr>

<tr>
<td>Positive</td><td>L+</td><td>no recommendation (red)</td>
</tr>

<tr>
<td>Negative</td><td>L-</td><td>no recommendation (black)</td>
</tr>
<hr>

<tr>
<th><sp>2-wire grounded DC Power System</th><th><sp></th><th><sp></th>
</tr>
<hr>

<tr>
<td>Positive (of a negative grounded) circuit</td><td>L+</td><td>red</td>
</tr>

<tr>
<td>Negative (of a negative grounded) circuit</td><td>N</td><td>white</td>
</tr>

<tr>
<td>Positive (of a positive grounded) circuit</td><td>N</td><td>white</td>
</tr>

<tr>
<td>Negative (of a positive grounded) circuit</td><td>L-</td><td>black</td>
</tr>
<hr>

<tr>
<th><sp>3-wire grounded DC Power System</th><th><sp></th><th><sp></th>
</tr>
<hr>

<tr>
<td>Positive</td><td>L+</td><td>red</td>
</tr>

<tr>
<td>Mid-wire (center tap)</td><td>N</td><td>white</td>
</tr>

<tr>
<td>Negative</td><td>L-</td><td>black</td>
</tr>
<hr>

</tabular>
</table>






</section>


<thebibliography>

<bibitem>[PCk]Paul Cook, ``Harmonised colours and alphanumeric marking'', IEE Wiring Matters, Spring 2004 at <url>http://www.iee.org/Publish/WireRegs/IEE_Harmonized_colours.pdf[http://www.iee.org/Publish/WireRegs/IEE_Harmonized_colours.pdf]</url></bibitem> 

<bibitem>[JWi]John Wiles, ``Photovoltaic Power Systems and the National Electrical Code: Suggested Practices'', Southwest Technology Development Institute, New Mexico State University, March 2001 at <url>http://www.re.sandia.gov/en/ti/tu/Copy%20of%20NEC2000.pdf[http://www.re.sandia.gov/en/ti/tu/Copy%20of%20NEC2000.pdf]</url></bibitem> 

</thebibliography>


</chapter>

<pagebreak>

