" Vim syntax file
" Language:	SubML (Substitutionary Markup Language -- Tony Kuphaldt)
" Last change:	01/18/2003
" Don't laugh at this . . . please.

" Remove any old syntax stuff hanging around
syn clear

" Tag pairs
syn match smlTagSet "<book>" 
syn match smlTagSet "</book>"
syn match smlTagSet "<chapter>" 
syn match smlTagSet "</chapter>" 
syn match smlTagSet "<section>" 
syn match smlTagSet "</section>" 
syn match smlTagSet "<subsection>" 
syn match smlTagSet "</subsection>" 
syn match smlTagSet "<subsubsection>" 
syn match smlTagSet "</subsubsection>" 
syn match smlTagSet "<para>"
syn match smlTagSet "</para>"
syn match smlTagSet "<itemize>"
syn match smlTagSet "</itemize>"
syn match smlTagSet "<item>"
syn match smlTagSet "</item>"
syn match smlTagSet "<comment>"
syn match smlTagSet "</comment>"

" Individual tags
syn match smlSingleTag "<TeX>"
syn match smlSingleTag "<LaTeX>"
syn match smlSingleTag "<lt>"
syn match smlSingleTag "<gt>"
syn match smlSingleTag "<bigspace>"
syn match smlSingleTag "<pagebreak>"
syn match smlSingleTag "<copyright>"
syn match smlSingleTag "<angle>"
syn match smlSingleTag "<integral>"
syn match smlSingleTag "<partial>"
syn match smlSingleTag "<infinity>"
syn match smlSingleTag "<minus>"
syn match smlSingleTag "<doubledash>"
syn match smlSingleTag "<alpha>"
syn match smlSingleTag "<beta>"
syn match smlSingleTag "<gamma>"
syn match smlSingleTag "<GAMMA>"
syn match smlSingleTag "<delta>"
syn match smlSingleTag "<DELTA>"
syn match smlSingleTag "<epsilon>"
syn match smlSingleTag "<varepsilon>"
syn match smlSingleTag "<zeta>"
syn match smlSingleTag "<eta>"
syn match smlSingleTag "<theta>"
syn match smlSingleTag "<THETA>"
syn match smlSingleTag "<vartheta>"
syn match smlSingleTag "<iota>"
syn match smlSingleTag "<kappa>"
syn match smlSingleTag "<lambda>"
syn match smlSingleTag "<LAMBDA>"
syn match smlSingleTag "<mu>"
syn match smlSingleTag "<nu>"
syn match smlSingleTag "<xi>"
syn match smlSingleTag "<XI>"
syn match smlSingleTag "<pi>"
syn match smlSingleTag "<PI>"
syn match smlSingleTag "<rho>"
syn match smlSingleTag "<varrho>"
syn match smlSingleTag "<sigma>"
syn match smlSingleTag "<SIGMA>"
syn match smlSingleTag "<varsigma>"
syn match smlSingleTag "<tau>"
syn match smlSingleTag "<upsilon>"
syn match smlSingleTag "<UPSILON>"
syn match smlSingleTag "<phi>"
syn match smlSingleTag "<PHI>"
syn match smlSingleTag "<varphi>"
syn match smlSingleTag "<chi>"
syn match smlSingleTag "<psi>"
syn match smlSingleTag "<PSI>"
syn match smlSingleTag "<omega>"
syn match smlSingleTag "<OMEGA>"
syn match smlSingleTag "<a`>"
syn match smlSingleTag "<A`>"
syn match smlSingleTag "<a'>"
syn match smlSingleTag "<A'>"
syn match smlSingleTag "<a^>"
syn match smlSingleTag "<A^>"
syn match smlSingleTag "<a\">"
syn match smlSingleTag "<A\">"
syn match smlSingleTag "<a\~>"
syn match smlSingleTag "<A\~>"
syn match smlSingleTag "<ao>"
syn match smlSingleTag "<Ao>"
syn match smlSingleTag "<c,>"
syn match smlSingleTag "<C,>"
syn match smlSingleTag "<e`>"
syn match smlSingleTag "<E`>"
syn match smlSingleTag "<e'>"
syn match smlSingleTag "<E'>"
syn match smlSingleTag "<e^>"
syn match smlSingleTag "<E^>"
syn match smlSingleTag "<e\">"
syn match smlSingleTag "<E\">"
syn match smlSingleTag "<i`>"
syn match smlSingleTag "<I`>"
syn match smlSingleTag "<i'>"
syn match smlSingleTag "<I'>"
syn match smlSingleTag "<i^>"
syn match smlSingleTag "<I^>"
syn match smlSingleTag "<i\">"
syn match smlSingleTag "<I\">"
syn match smlSingleTag "<n\~>"
syn match smlSingleTag "<N\~>"
syn match smlSingleTag "<o`>"
syn match smlSingleTag "<O`>"
syn match smlSingleTag "<o'>"
syn match smlSingleTag "<O'>"
syn match smlSingleTag "<o^>"
syn match smlSingleTag "<O^>"
syn match smlSingleTag "<o\">"
syn match smlSingleTag "<O\">"
syn match smlSingleTag "<o\~>"
syn match smlSingleTag "<O\~>"
syn match smlSingleTag "<u`>"
syn match smlSingleTag "<U`>"
syn match smlSingleTag "<u'>"
syn match smlSingleTag "<U'>"
syn match smlSingleTag "<u^>"
syn match smlSingleTag "<U^>"
syn match smlSingleTag "<u\">"
syn match smlSingleTag "<U\">"
syn match smlSingleTag "<!>"
syn match smlSingleTag "<?>"


" Special text formatting
syn region smlSpecial start="<italic\>" end="</italic>"
syn region smlSpecial start="<bold\>" end="</bold>"
syn region smlSpecial start="<underline\>" end="</underline>"
syn region smlSpecial start="<subscript\>" end="</subscript>"
syn region smlSpecial start="<superscript\>" end="</superscript>"
syn region smlSpecial start="<typewriter\>" end="</typewriter>"

" Image, Index, and Url tag sets
syn region smlImage start="<image>" end="</image>"
syn region smlImage start="<index>" end="</index>"
syn region smlImage start="<url>" end="</url>"

" Quotations and Literal blocks
syn region smlQuotation start="<quotation>" end="</quotation>"
syn region smlQuotation start="<literal>" end="</literal>"

" Title tag sets
syn region smlTitle start="<chaptertitle>" end="</chaptertitle>"
syn region smlTitle start="<sectiontitle>" end="</sectiontitle>"
syn region smlTitle start="<subsectiontitle>" end="</subsectiontitle>"
syn region smlTitle start="<subsubsectiontitle>" end="</subsubsectiontitle>"


let b:current_syntax = "sml"

  hi smlTagSet term=bold ctermfg=darkred guifg=darkred
  hi smlSingleTag term=italic ctermfg=green guifg=green
  hi smlSpecial term=bold ctermfg=cyan guifg=cyan
  hi smlImage term=underline ctermfg=blue guifg=blue
  hi smlTitle term=underline ctermfg=magenta guifg=magenta
  hi smlQuotation term=underline ctermfg=darkblue guifg=darkblue


" vim: ts=8 sts=8 sw=8 noet:
