
<chapter>
<chaptertitle>PHYSICS OF CONDUCTORS AND INSULATORS</chaptertitle>


<section>
<sectiontitle>Introduction</sectiontitle>

<index>Conductor</index>
<index>Insulator</index>

<para>
By now you should be well aware of the correlation between electrical conductivity and certain types of materials.  Those materials allowing for easy passage of free electrons are called <italic>conductors</italic>, while those materials impeding the passage of free electrons are called <italic>insulators</italic>.
</para>

<index>Atomic structure</index>
<index>Nucleus</index>
<index>Shell, electron</index>
<index>Physics, quantum</index>
<index>Quantum physics</index>

<para>
Unfortunately, the scientific theories explaining why certain materials conduct and others don't are quite complex, rooted in quantum mechanical explanations in how electrons are arranged around the nuclei of atoms.  Contrary to the well-known "planetary" model of electrons whirling around an atom's nucleus as well-defined chunks of matter in circular or elliptical orbits, electrons in "orbit" don't really act like pieces of matter at all.  Rather, they exhibit the characteristics of both particle and wave, their behavior constrained by placement within distinct zones around the nucleus referred to as "shells" and "subshells."  Electrons can occupy these zones only in a limited range of energies depending on the particular zone and how occupied that zone is with other electrons.  If electrons really did act like tiny planets held in orbit around the nucleus by electrostatic attraction, their actions described by the same laws describing the motions of real planets, there could be no real distinction between conductors and insulators, and chemical bonds between atoms would not exist in the way they do now.  It is the discrete, "quantitized" nature of electron energy and placement described by quantum physics that gives these phenomena their regularity.
</para>

<index>Electron, free</index>

<para>
When an electron is free to assume higher energy states around an atom's nucleus (due to its placement in a particular "shell"), it may be free to break away from the atom and comprise part of an electric current through the substance.  If the quantum limitations imposed on an electron deny it this freedom, however, the electron is considered to be "bound" and cannot break away (at least not easily) to constitute a current.  The former scenario is typical of conducting materials, while the latter is typical of insulating materials.
</para>

<index>Valence</index>
<index>Semiconductor</index>

<para>
Some textbooks will tell you that an element's conductivity or nonconductivity is exclusively determined by the number of electrons residing in the atoms' outer "shell" (called the <italic>valence</italic> shell), but this is an oversimplification, as any examination of conductivity versus valence electrons in a table of elements will confirm.  The true complexity of the situation is further revealed when the conductivity of molecules (collections of atoms bound to one another by electron activity) is considered.  
</para>

<para>
A good example of this is the element carbon, which comprises materials of vastly differing conductivity: graphite and diamond.  Graphite is a fair conductor of electricity, while diamond is practically an insulator (stranger yet, it is technically classified as a <italic>semiconductor</italic>, which in its pure form acts as an insulator, but can conduct under high temperatures and/or the influence of impurities).  Both graphite and diamond are composed of the exact same types of atoms: carbon, with 6 protons, 6 neutrons and 6 electrons each.  The fundamental difference between graphite and diamond being that graphite molecules are flat groupings of carbon atoms while diamond molecules are tetrahedral (pyramid-shaped) groupings of carbon atoms.  
</para>

<para>
If atoms of carbon are joined to other types of atoms to form compounds, electrical conductivity becomes altered once again.  Silicon carbide, a compound of the elements silicon and carbon, exhibits nonlinear behavior: its electrical resistance decreases with increases in applied voltage!  Hydrocarbon compounds (such as the molecules found in oils) tend to be very good insulators.  As you can see, a simple count of valence electrons in an atom is a poor indicator of a substance's electrical conductivity.
</para>

<index>Electron gas</index>

<para>
All metallic elements are good conductors of electricity, due to the way the atoms bond with each other.  The electrons of the atoms comprising a mass of metal are so uninhibited in their allowable energy states that they float freely between the different nuclei in the substance, readily motivated by any electric field.  The electrons are so mobile, in fact, that they are sometimes described by scientists as an <italic>electron gas</italic>, or even an <italic>electron sea</italic> in which the atomic nuclei rest.  This electron mobility accounts for some of the other common properties of metals: good heat conductivity, malleability and ductility (easily formed into different shapes), and a lustrous finish when pure.
</para>

<para>
Thankfully, the physics behind all this is mostly irrelevant to our purposes here.  Suffice it to say that some materials are good conductors, some are poor conductors, and some are in between.  For now it is good enough to simply understand that these distinctions are determined by the configuration of the electrons around the constituent atoms of the material.
</para>

<para>
An important step in getting electricity to do our bidding is to be able to construct paths for electrons to flow with controlled amounts of resistance.  It is also vitally important that we be able to prevent electrons from flowing where we don't want them to, by using insulating materials.  However, not all conductors are the same, and neither are all insulators.  We need to understand some of the characteristics of common conductors and insulators, and be able to apply these characteristics to specific applications.
</para>

<para>
Almost all conductors possess a certain, measurable resistance (special types of materials called <italic>superconductors</italic> possess absolutely no electrical resistance, but these are not ordinary materials, and they must be held in special conditions in order to be super conductive).  Typically, we assume the resistance of the conductors in a circuit to be zero, and we expect that current passes through them without producing any appreciable voltage drop.  In reality, however, there will almost always be a voltage drop along the (normal) conductive pathways of an electric circuit, whether we want a voltage drop to be there or not:
</para>

<image>00277.png</image>

<para>
In order to calculate what these voltage drops will be in any particular circuit, we must be able to ascertain the resistance of ordinary wire, knowing the wire size and diameter.  Some of the following sections of this chapter will address the details of doing this.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Electrical conductivity of a material is determined by the configuration of electrons in that materials atoms and molecules (groups of bonded atoms).</item>
<item>All normal conductors possess resistance to some degree.</item>
<item>Electrons flowing through a conductor with (any) resistance will produce some amount of voltage drop across the length of that conductor.</item>
</itemize>

</section>







<section>
<sectiontitle>Conductor size</sectiontitle>

<para>
It should be common-sense knowledge that liquids flow through large-diameter pipes easier than they do through small-diameter pipes (if you would like a practical illustration, try drinking a liquid through straws of different diameters).  The same general principle holds for the flow of electrons through conductors: the broader the cross-sectional area (thickness) of the conductor, the more room for electrons to flow, and consequently, the easier it is for flow to occur (less resistance).
</para>

<index>Wire, solid and stranded</index>

<para>
Electrical wire is usually round in cross-section (although there are some unique exceptions to this rule), and comes in two basic varieties: solid and stranded.  Solid copper wire is just as it sounds: a single, solid strand of copper the whole length of the wire.  Stranded wire is composed of smaller strands of solid copper wire twisted together to form a single, larger conductor.  The greatest benefit of stranded wire is its mechanical flexibility, being able to withstand repeated bending and twisting much better than solid copper (which tends to fatigue and break after time).
</para>

<para>
Wire size can be measured in several ways.  We could speak of a wire's diameter, but since its really the cross-sectional <italic>area</italic> that matters most regarding the flow of electrons, we are better off designating wire size in terms of area.  
</para>

<image>00278.png</image>

<para>
The wire cross-section picture shown above is, of course, not drawn to scale.  The diameter is shown as being 0.1019 inches.  Calculating the area of the cross-section with the formula Area = <pi>r<superscript>2</superscript>, we get an area of 0.008155 square inches:
</para>

<image>10214.png</image>

<index>Mil</index>
<index>Unit, mil</index>

<para>
These are fairly small numbers to work with, so wire sizes are often expressed in measures of thousandths-of-an-inch, or <italic>mils</italic>.  For the illustrated example, we would say that the diameter of the wire was 101.9 mils (0.1019 inch times 1000).  We could also, if we wanted, express the area of the wire in the unit of square mils, calculating that value with the same circle-area formula, Area = <pi>r<superscript>2</superscript>:
</para>

<image>00279.png</image>

<para>

</para>

<bigspace>

<image>10215.png</image>

<index>Circular mil</index>
<index>Cmil</index>
<index>Unit, cmil</index>
<index>Mil, circular</index>

<para>
However, electricians and others frequently concerned with wire size use another unit of area measurement tailored specifically for wire's circular cross-section.  This special unit is called the <italic>circular mil</italic> (sometimes abbreviated <italic>cmil</italic>).  The sole purpose for having this special unit of measurement is to eliminate the need to invoke the factor <pi> (3.1415927 . . .) in the formula for calculating area, plus the need to figure wire <italic>radius</italic> when you've been given <italic>diameter</italic>.  The formula for calculating the circular-mil area of a circular wire is very simple:
</para>

<image>10216.png</image>

<para>
Because this is a unit of <italic>area</italic> measurement, the mathematical power of 2 is still in effect (doubling the width of a circle will <italic>always</italic> quadruple its area, no matter what units are used, or if the width of that circle is expressed in terms of radius or diameter).  To illustrate the difference between measurements in square mils and measurements in circular mils, I will compare a circle with a square, showing the area of each shape in both unit measures:
</para>

<image>00280.png</image>

<para>
And for another size of wire:
</para>

<image>00281.png</image>

<para>
Obviously, the circle of a given diameter has less cross-sectional area than a square of width and height equal to the circle's diameter: both units of area measurement reflect that.  However, it should be clear that the unit of "square mil" is really tailored for the convenient determination of a square's area, while "circular mil" is tailored for the convenient determination of a circle's area: the respective formula for each is simpler to work with.  It must be understood that both units are valid for measuring the area of a shape, no matter what shape that may be.  The conversion between circular mils and square mils is a simple ratio: there are <pi> (3.1415927 . . .) square mils to every 4 circular mils.
</para>

<index>Wire Gauge</index>
<index>Gauge, wire size</index>

<para>
Another measure of cross-sectional wire area is the <italic>gauge</italic>.  The gauge scale is based on whole numbers rather than fractional or decimal inches.  The larger the gauge number, the skinnier the wire; the smaller the gauge number, the fatter the wire.  For those acquainted with shotguns, this inversely-proportional measurement scale should sound familiar.  
</para>

<index>AWG (American Wire Gauge)</index>
<index>B&S (Brown and Sharpe)</index>
<index>SWG (British Standard Wire Gauge)</index>
<index>MWG (Steel Music Wire Gauge)</index>

<para>
The table at the end of this section equates gauge with inch diameter, circular mils, and square inches for solid wire.  The larger sizes of wire reach an end of the common gauge scale (which naturally tops out at a value of 1), and are represented by a series of zeros.  "3/0" is another way to represent "000," and is pronounced "triple-ought."  Again, those acquainted with shotguns should recognize the terminology, strange as it may sound.  To make matters even more confusing, there is more than one gauge "standard" in use around the world.  For electrical conductor sizing, the <italic>American Wire Gauge</italic> (AWG), also known as the <italic>Brown and Sharpe</italic> (B&S) gauge, is the measurement system of choice.  In Canada and Great Britain, the <italic>British Standard Wire Gauge</italic> (SWG) is the legal measurement system for electrical conductors.  Other wire gauge systems exist in the world for classifying wire diameter, such as the <italic>Stubs</italic> steel wire gauge and the <italic>Steel Music Wire Gauge</italic> (MWG), but these measurement systems apply to non-electrical wire use.
</para>

<para>
The American Wire Gauge (AWG) measurement system, despite its oddities, was designed with a purpose: for every three steps in the gauge scale, wire area (and weight per unit length) approximately doubles.  This is a handy rule to remember when making rough wire size estimations!
</para>

<para>
For <italic>very</italic> large wire sizes (fatter than 4/0), the wire gauge system is typically abandoned for cross-sectional area measurement in thousands of circular mils (MCM), borrowing the old Roman numeral "M" to denote a multiple of "thousand" in front of "CM" for "circular mils."  The following table of wire sizes does not show any sizes bigger than 4/0 gauge, because <italic>solid</italic> copper wire becomes impractical to handle at those sizes.  Stranded wire construction is favored, instead.
</para>

<bigspace>

<para>
<bold>Soild copper wire table:</bold><ref>cuwire2.tbl below</ref>
</para>

<table>cuwire2.tbl<caption>Soild copper wire table:</caption>
<tabular>{|l|l|l|l|l|}
<hr>

<tr>
<th>Size</th><th>Diameter</th><th>Cross-sectional</th><th>area</th><th>Weight</th>
</tr>
<tr>
<th>AWG</th><th>inches</th><th>cir. mils</th><th>sq. inches</th><th>lb/1000 ft</th>
</tr>

<hr>

<tr>
<td>4/0</td><td>0.4600</td><td>211,600</td><td>0.1662</td><td>640.5</td>
</tr>
<tr>
<td>3/0</td><td>0.4096</td><td>167,800</td><td>0.1318</td><td>507.9</td>
</tr>
<tr>
<td>2/0</td><td>0.3648</td><td>133,100</td><td>0.1045</td><td>402.8</td>
</tr>
<tr>
<td>1/0</td><td>0.3249</td><td>105,500</td><td>0.08289</td><td>319.5</td>
</tr>
<tr>
<td>1</td><td>0.2893</td><td>83,690</td><td>0.06573</td><td>253.5</td>
</tr>
<tr>
<td>2</td><td>0.2576</td><td>66,370</td><td>0.05213</td><td>200.9</td>
</tr>
<tr>
<td>3</td><td>0.2294</td><td>52,630</td><td>0.04134</td><td>159.3</td>
</tr>
<tr>
<td>4</td><td>0.2043</td><td>41,740</td><td>0.03278</td><td>126.4</td>
</tr>
<tr>
<td>5</td><td>0.1819</td><td>33,100</td><td>0.02600</td><td>100.2</td>
</tr>
<tr>
<td>6</td><td>0.1620</td><td>26,250</td><td>0.02062</td><td>79.46</td>
</tr>
<tr>
<td>7</td><td>0.1443</td><td>20,820</td><td>0.01635</td><td>63.02</td>
</tr>
<tr>
<td>7</td><td>0.1443</td><td>20,820</td><td>0.01635</td><td>63.02</td>
</tr>
<tr>
<td>8</td><td>0.1285</td><td>16,510</td><td>0.01297</td><td>49.97</td>
</tr>
<tr>
<td>9</td><td>0.1144</td><td>13,090</td><td>0.01028</td><td>39.63</td>
</tr>
<tr>
<td>10</td><td>0.1019</td><td>10,380</td><td>0.008155</td><td>31.43</td>
</tr>
<tr>
<td>11</td><td>0.09074</td><td>8,234</td><td>0.006467</td><td>24.92</td>
</tr>
<tr>
<td>12</td><td>0.08081</td><td>6,530</td><td>0.005129</td><td>19.77</td>
</tr>
<tr>
<td>13</td><td>0.07196</td><td>5,178</td><td>0.004067</td><td>15.68</td>
</tr>
<tr>
<td>14</td><td>0.06408</td><td>4,107</td><td>0.003225</td><td>12.43</td>
</tr>
<tr>
<td>15</td><td>0.05707</td><td>3,257</td><td>0.002558</td><td>9.858</td>
</tr>
<tr>
<td>16</td><td>0.05082</td><td>2,583</td><td>0.002028</td><td>7.818</td>
</tr>
<tr>
<td>17</td><td>0.04526</td><td>2,048</td><td>0.001609</td><td>6.200</td>
</tr>
<tr>
<td>18</td><td>0.04030</td><td>1,624</td><td>0.001276</td><td>4.917</td>
</tr>
<tr>
<td>19</td><td>0.03589</td><td>1,288</td><td>0.001012</td><td>3.899</td>
</tr>
<tr>
<td>20</td><td>0.03196</td><td>1,022</td><td>0.0008023</td><td>3.092</td>
</tr>
<tr>
<td>21</td><td>0.02846</td><td>810.1</td><td>0.0006363</td><td>2.452</td>
</tr>
<tr>
<td>22</td><td>0.02535</td><td>642.5</td><td>0.0005046</td><td>1.945</td>
</tr>
<tr>
<td>23</td><td>0.02257</td><td>509.5</td><td>0.0004001</td><td>1.542</td>
</tr>
<tr>
<td>23</td><td>0.02257</td><td>509.5</td><td>0.0004001</td><td>1.542</td>
</tr>
<tr>
<td>24</td><td>0.02010</td><td>404.0</td><td>0.0003173</td><td>1.233</td>
</tr>
<tr>
<td>25</td><td>0.01790</td><td>320.4</td><td>0.0002517</td><td>0.9699</td>
</tr>
<tr>
<td>26</td><td>0.01594</td><td>254.1</td><td>0.0001996</td><td>0.7692</td>
</tr>
<tr>
<td>27</td><td>0.01420</td><td>201.5</td><td>0.0001583</td><td>0.6100</td>
</tr>
<tr>
<td>28</td><td>0.01264</td><td>159.8</td><td>0.0001255</td><td>0.4837</td>
</tr>
<tr>
<td>29</td><td>0.01126</td><td>126.7</td><td>0.00009954</td><td>0.3836</td>
</tr>
<tr>
<td>30</td><td>0.01003</td><td>100.5</td><td>0.00007894</td><td>0.3042</td>
</tr>
<tr>
<td>31</td><td>0.008928</td><td>79.70</td><td>0.00006260</td><td>0.2413</td>
</tr>
<tr>
<td>32</td><td>0.007950</td><td>63.21</td><td>0.00004964</td><td>0.1913</td>
</tr>
<tr>
<td>33</td><td>0.007080</td><td>50.13</td><td>0.00003937</td><td>0.1517</td>
</tr>
<tr>
<td>34</td><td>0.006305</td><td>39.75</td><td>0.00003122</td><td>0.1203</td>
</tr>
<tr>
<td>35</td><td>0.005615</td><td>31.52</td><td>0.00002476</td><td>0.09542</td>
</tr>
<tr>
<td>36</td><td>0.005000</td><td>25.00</td><td>0.00001963</td><td>0.07567</td>
</tr>
<tr>
<td>37</td><td>0.004453</td><td>19.83</td><td>0.00001557</td><td>0.06001</td>
</tr>
<tr>
<td>38</td><td>0.003965</td><td>15.72</td><td>0.00001235</td><td>0.04759</td>
</tr>
<tr>
<td>39</td><td>0.003531</td><td>12.47</td><td>0.000009793</td><td>0.03774</td>
</tr>
<tr>
<td>40</td><td>0.003145</td><td>9.888</td><td>0.000007766</td><td>0.02993</td>
</tr>
<tr>
<td>41</td><td>0.002800</td><td>7.842</td><td>0.000006159</td><td>0.02374</td>
</tr>
<tr>
<td>42</td><td>0.002494</td><td>6.219</td><td>0.000004884</td><td>0.01882</td>
</tr>
<tr>
<td>43</td><td>0.002221</td><td>4.932</td><td>0.000003873</td><td>0.01493</td>
</tr>
<tr>
<td>44</td><td>0.001978</td><td>3.911</td><td>0.000003072</td><td>0.01184</td>
</tr>
<hr>
</tabular>
</table>

<bigspace>


<index>Busbar</index>

<para>
For some high-current applications, conductor sizes beyond the practical size limit of round wire are required.  In these instances, thick bars of solid metal called <italic>busbars</italic> are used as conductors.  Busbars are usually made of copper or aluminum, and are most often uninsulated.  They are physically supported away from whatever framework or structure is holding them by insulator standoff mounts.  Although a square or rectangular cross-section is very common for busbar shape, other shapes are used as well.  Cross-sectional area for busbars is typically rated in terms of circular mils (even for square and rectangular bars!), most likely for the convenience of being able to directly equate busbar size with round wire.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Electrons flow through large-diameter wires easier than small-diameter wires, due to the greater cross-sectional area they have in which to move.</item>
<item>Rather than measure small wire sizes in inches, the unit of "mil" (1/1000 of an inch) is often employed.</item>
<item>The cross-sectional area of a wire can be expressed in terms of square units (square inches or square mils), circular mils, or "gauge" scale.</item>
<item>Calculating square-unit wire area for a circular wire involves the circle area formula:</item>
<item><image>10217.png</image></item>
<item>Calculating circular-mil wire area for a circular wire is much simpler, due to the fact that the unit of "circular mil" was sized just for this purpose: to eliminate the "pi" and the d/2 (radius) factors in the formula.</item>
<item><image>10218.png</image></item>
<item>There are <pi> (3.1416) square mils for every 4 circular mils.</item>
<item>The <italic>gauge</italic> system of wire sizing is based on whole numbers, larger numbers representing smaller-area wires and vice versa.  Wires thicker than 1 gauge are represented by zeros: 0, 00, 000, and 0000 (spoken "single-ought," "double-ought," "triple-ought," and "quadruple-ought."</item>
<item>Very large wire sizes are rated in thousands of circular mils (MCM's), typical for busbars and wire sizes beyond 4/0.</item>
<item><italic>Busbars</italic> are solid bars of copper or aluminum used in high-current circuit construction.  Connections made to busbars are usually welded or bolted, and the busbars are often bare (uninsulated), supported away from metal frames through the use of insulating standoffs.</item>
</itemize>

</section>








<section>
<sectiontitle>Conductor ampacity</sectiontitle>

<index>Ampacity</index>
<index>Conductor ampacity</index>

<para>
The smaller the wire, the greater the resistance for any given length, all other factors being equal.  A wire with greater resistance will dissipate a greater amount of heat energy for any given amount of current, the power being equal to P=I<superscript>2</superscript>R.
</para>

<para>
Dissipated power in a resistance manifests itself in the form of heat, and excessive heat can be damaging to a wire (not to mention objects near the wire!), especially considering the fact that most wires are insulated with a plastic or rubber coating, which can melt and burn.  Thin wires will, therefore, tolerate less current than thick wires, all other factors being equal.  A conductor's current-carrying limit is known as its <italic>ampacity</italic>.
</para>

<index>National Electrical Code</index>
<index>NEC</index>

<para>
Primarily for reasons of safety, certain standards for electrical wiring have been established within the United States, and are specified in the National Electrical Code (NEC).  Typical NEC wire ampacity tables will show allowable maximum currents for different sizes and applications of wire.  Though the melting point of copper theoretically imposes a limit on wire ampacity, the materials commonly employed for insulating conductors melt at temperatures far below the melting point of copper, and so practical ampacity ratings are based on the thermal limits <italic>of the insulation</italic>.  Voltage dropped as a result of excessive wire resistance is also a factor in sizing conductors for their use in circuits, but this consideration is better assessed through more complex means (which we will cover in this chapter).  A table derived from an NEC listing is shown for example:
</para>

<bigspace>



<para>
<bold>Ampacities of copper wire:</bold><ref>ampacity2.tbl below</ref>
</para>

<table>ampacity2.tbl<caption>Ampacities of copper wire, in free air at 30<superscript>o</superscript> C:</caption>
<tabular>{|l|l|l|l|}
<hr>

<tr>
<th></th><th></th><th>INSULATION TYPE:</th><th></th>
</tr>
<tr>
<th></th><th>RUW, T</th><th>THW, THWN</th><th>FEP, FEPB</th>
</tr>
<tr>
<th></th><th>TW</th><th>RUH</th><th>THHN, XHHW</th>
</tr>
<hr>
<tr>
<th>Size</th><th>Current Rating</th><th>Current Rating</th><th>Current Rating</th>
</tr>
<tr>
<th>AWG</th><th>@ 60 degrees C</th><th> @ 75 degrees C</th><th> @ 90 degrees C</th>
</tr>
<hr>

<tr>
<td>20</td><td>*9</td><td></td><td>*12.5</td>
</tr>
<tr>
<td>18</td><td>*13</td><td></td><td>18</td>
</tr>
<tr>
<td>16</td><td>*18</td><td></td><td>24</td>
</tr>
<tr>
<td>14</td><td>25</td><td>30</td><td>35</td>
</tr>
<tr>
<td>12</td><td>30</td><td>35</td><td>40</td>
</tr>
<tr>
<td>10</td><td>40</td><td>50</td><td>55</td>
</tr>
<tr>
<td>8</td><td>60</td><td>70</td><td>80</td>
</tr>
<tr>
<td>6</td><td>80</td><td>95</td><td>105</td>
</tr>
<tr>
<td>4</td><td>105</td><td>125</td><td>140</td>
</tr>
<tr>
<td>2</td><td>140</td><td>170</td><td>190</td>
</tr>
<tr>
<td>1</td><td>165</td><td>195</td><td>220</td>
</tr>
<tr>
<td>1/0</td><td>195</td><td>230</td><td>260</td>
</tr>
<tr>
<td>2/0</td><td>225</td><td>265</td><td>300</td>
</tr>
<tr>
<td>3/0</td><td>260</td><td>310</td><td>350</td>
</tr>
<tr>
<td>4/0</td><td>300</td><td>360</td><td>405</td>
</tr>
<hr>

</tabular>
</table>

<para>
* = estimated values; normally, these small wire sizes are not manufactured with these insulation types, <ref>ampacity2.tbl above</ref>.
</para>

<bigspace>

<para>
Notice the substantial ampacity differences between same-size wires with different types of insulation.  This is due, again, to the thermal limits (60<superscript>o</superscript>, 75<superscript>o</superscript>, 90<superscript>o</superscript>) of each type of insulation material.  
</para>

<para>
These ampacity ratings are given for copper conductors in "free air" (maximum typical air circulation), as opposed to wires placed in conduit or wire trays.  As you will notice, the table fails to specify ampacities for small wire sizes. This is because the NEC concerns itself primarily with power wiring (large currents, big wires) rather than with wires common to low-current electronic work.
</para>

<para>
There is meaning in the letter sequences used to identify conductor types, and these letters usually refer to properties of the conductor's insulating layer(s).  Some of these letters symbolize individual properties of the wire while others are simply abbreviations.  For example, the letter "T" by itself means "thermoplastic" as an insulation material, as in "TW" or "THHN."  However, the three-letter combination "MTW" is an abbreviation for <italic>Machine Tool Wire</italic>, a type of wire whose insulation is made to be flexible for use in machines experiencing significant motion or vibration.
</para>

<bigspace>


<para>
<bold>Wire insulation codes:</bold><ref>inwirec.tbl below</ref>
</para>

<table>inwirec.tbl<caption>Soild copper wire table:</caption>
<tabular>{|l|l|}

<hr>

<tr>
<th>Code</th><th>Insulation Material</th>
</tr>
<hr>
<tr>
<td>C</td><td>Cotton</td>
</tr>
<tr>
<td>FEP</td><td>Fluorinated Ethylene Propylene</td>
</tr>
<tr>
<td>MI</td><td>Mineral (magnesium oxide)</td>
</tr>
<tr>
<td>PFA</td><td>Perfluoroalkoxy</td>
</tr>
<tr>
<td>R</td><td>Rubber (sometimes Neoprene)</td>
</tr>
<tr>
<td>S</td><td>Silicone "rubber"</td>
</tr>
<tr>
<td>SA</td><td>Silicone-asbestos</td>
</tr>
<tr>
<td>T</td><td>Thermoplastic</td>
</tr>
<tr>
<td>TA</td><td>Thermoplastic-asbestos</td>
</tr>
<tr>
<td>TFE</td><td>Polytetrafluoroethylene ("Teflon")</td>
</tr>
<tr>
<td>X</td><td>Cross-linked synthetic polymer</td>
</tr>
<tr>
<td>Z</td><td>Modified ethylene tetrafluoroethylene</td>
</tr>
<hr>
<tr>
<th></th><th>Heat rating</th>
</tr>
<hr>
<tr>
<td>H</td><td>75 degrees Celsius</td>
</tr>
<tr>
<td>HH</td><td> 90 degrees Celsius</td>
</tr>
<hr>
<tr>
<th></th><th>Outer covering ("jacket")</th>
</tr>
<hr>
<tr>
<td>N</td><td>Nylon</td>
</tr>
<hr>
<tr>
<th></th><th>Special service conditions</th>
</tr>
<hr>
<tr>
<td>U</td><td>Underground</td>
</tr>
<tr>
<td>W</td><td>Wet</td>
</tr>
<tr>
<td>-2</td><td>90 degrees Celsius and wet</td>
</tr>
<hr>

</tabular>
</table>



<bigspace>

<para>
Therefore, a "THWN" conductor has <bold>T</bold>hermoplastic insulation, is <bold>H</bold>eat resistant to 75<superscript>o</superscript> Celsius, is rated for <bold>W</bold>et conditions, and comes with a <bold>N</bold>ylon outer jacketing.
</para>

<para>
Letter codes like these are only used for general-purpose wires such as those used in households and businesses.  For high-power applications and/or severe service conditions, the complexity of conductor technology defies classification according to a few letter codes.  Overhead power line conductors are typically bare metal, suspended from towers by glass, porcelain, or ceramic mounts known as insulators.  Even so, the actual construction of the wire to withstand physical forces both static (dead weight) and dynamic (wind) loading can be complex, with multiple layers and different types of metals wound together to form a single conductor.  Large, underground power conductors are sometimes insulated by paper, then enclosed in a steel pipe filled with pressurized nitrogen or oil to prevent water intrusion.  Such conductors require support equipment to maintain fluid pressure throughout the pipe.
</para>

<para>
Other insulating materials find use in small-scale applications.  For instance, the small-diameter wire used to make electromagnets (coils producing a magnetic field from the flow of electrons) are often insulated with a thin layer of enamel.  The enamel is an excellent insulating material and is very thin, allowing many "turns" of wire to be wound in a small space.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Wire resistance creates heat in operating circuits.  This heat is a potential fire ignition hazard.</item>
<item>Skinny wires have a lower allowable current ("ampacity") than fat wires, due to their greater resistance per unit length, and consequently greater heat generation per unit current.</item>
<item>The National Electrical Code (NEC) specifies ampacities for power wiring based on allowable insulation temperature and wire application.</item>
</itemize>

</section>







<section>
<sectiontitle>Fuses</sectiontitle>

<index>Fuse</index>

<para>
Normally, the ampacity rating of a conductor is a circuit design limit never to be intentionally exceeded, but there is an application where ampacity exceedence is expected: in the case of <italic>fuses</italic>.
</para>

<para>
A fuse is nothing more than a short length of wire designed to melt and separate in the event of excessive current.  Fuses are always connected in series with the component(s) to be protected from overcurrent, so that when the fuse <italic>blows</italic> (opens) it will open the entire circuit and stop current through the component(s).  A fuse connected in one branch of a parallel circuit, of course, would not affect current through any of the other branches.
</para>

<para>
Normally, the thin piece of fuse wire is contained within a safety sheath to minimize hazards of arc blast if the wire burns open with violent force, as can happen in the case of severe overcurrents.  In the case of small automotive fuses, the sheath is transparent so that the fusible element can be visually inspected.  Residential wiring used to commonly employ screw-in fuses with glass bodies and a thin, narrow metal foil strip in the middle.  A photograph showing both types of fuses is shown here:
</para>

<image>50026.jpg</image>

<para>
Cartridge type fuses are popular in automotive applications, and in industrial applications when constructed with sheath materials other than glass.  Because fuses are designed to "fail" open when their current rating is exceeded, they are typically designed to be replaced easily in a circuit.  This means they will be inserted into some type of holder rather than being directly soldered or bolted to the circuit conductors.  The following is a photograph showing a couple of glass cartridge fuses in a multi-fuse holder:
</para>

<image>50027.jpg</image>

<para>
The fuses are held by spring metal clips, the clips themselves being permanently connected to the circuit conductors.  The base material of the fuse holder (or <italic>fuse block</italic> as they are sometimes called) is chosen to be a good insulator.
</para>

<para>
Another type of fuse holder for cartridge-type fuses is commonly used for installation in equipment control panels, where it is desirable to conceal all electrical contact points from human contact.  Unlike the fuse block just shown, where all the metal clips are openly exposed, this type of fuse holder completely encloses the fuse in an insulating housing:
</para>

<image>50028.jpg</image>

<index>Circuit breaker</index>
<index>Bimetallic strip</index>

<para>
The most common device in use for overcurrent protection in high-current circuits today is the <italic>circuit breaker</italic>.  Circuit breakers are specially designed switches that automatically open to stop current in the event of an overcurrent condition.  Small circuit breakers, such as those used in residential, commercial and light industrial service are thermally operated.  They contain a <italic>bimetallic strip</italic> (a thin strip of two metals bonded back-to-back) carrying circuit current, which bends when heated.  When enough force is generated by the bimetallic strip (due to overcurrent heating of the strip), the trip mechanism is actuated and the breaker will open.  Larger circuit breakers are automatically actuated by the strength of the magnetic field produced by current-carrying conductors within the breaker, or can be triggered to trip by external devices monitoring the circuit current (those devices being called <italic>protective relays</italic>).
</para>

<para>
Because circuit breakers don't fail when subjected to overcurrent conditions -- rather, they merely open and can be re-closed by moving a lever -- they are more likely to be found connected to a circuit in a more permanent manner than fuses.  A photograph of a small circuit breaker is shown here:
</para>

<image>50029.jpg</image>

<para>
From outside appearances, it looks like nothing more than a switch.  Indeed, it could be used as such.  However, its true function is to operate as an overcurrent protection device.
</para>

<index>Fusible link</index>

<para>
It should be noted that some automobiles use inexpensive devices known as <italic>fusible links</italic> for overcurrent protection in the battery charging circuit, due to the expense of a properly-rated fuse and holder.  A fusible link is a primitive fuse, being nothing more than a short piece of rubber-insulated wire designed to melt open in the event of overcurrent, with no hard sheathing of any kind.  Such crude and potentially dangerous devices are never used in industry or even residential power use, mainly due to the greater voltage and current levels encountered.  As far as this author is concerned, their application even in automotive circuits is questionable.
</para>

<para>
The electrical schematic drawing symbol for a fuse is an S-shaped curve:
</para>

<image>00282.png</image>

<para>
Fuses are primarily rated, as one might expect, in the unit for current: amps.  Although their operation depends on the self-generation of heat under conditions of excessive current by means of the fuse's own electrical resistance, they are engineered to contribute a negligible amount of extra resistance to the circuits they protect.  This is largely accomplished by making the fuse wire as short as is practically possible.  Just as a normal wire's ampacity is not related to its length (10-gauge solid copper wire will handle 40 amps of current in free air, regardless of how long or short of a piece it is), a fuse wire of certain material and gauge will blow at a certain current no matter how long it is.  Since length is not a factor in current rating, the shorter it can be made, the less resistance it will have end-to-end.  
</para>

<para>
However, the fuse designer also has to consider what happens after a fuse blows: the melted ends of the once-continuous wire will be separated by an air gap, with full supply voltage between the ends.  If the fuse isn't made long enough on a high-voltage circuit, a spark may be able to jump from one of the melted wire ends to the other, completing the circuit again:
</para>

<image>00283.png</image>

<para>

</para>

<bigspace>

<image>00284.png</image>

<para>
Consequently, fuses are rated in terms of their voltage capacity as well as the current level at which they will blow.
</para>

<para>
Some large industrial fuses have replaceable wire elements, to reduce the expense.  The body of the fuse is an opaque, reusable cartridge, shielding the fuse wire from exposure and shielding surrounding objects from the fuse wire.
</para>

<index>Inrush current</index>
<index>Current, inrush</index>
<index>Slow-blow fuse</index>

<para>
There's more to the current rating of a fuse than a single number.  If a current of 35 amps is sent through a 30 amp fuse, it may blow suddenly or delay before blowing, depending on other aspects of its design.  Some fuses are intended to blow very fast, while others are designed for more modest "opening" times, or even for a delayed action depending on the application.  The latter fuses are sometimes called <italic>slow-blow</italic> fuses due to their intentional time-delay characteristics.  
</para>

<para>
A classic example of a slow-blow fuse application is in electric motor protection, where <italic>inrush</italic> currents of up to ten times normal operating current are commonly experienced every time the motor is started from a dead stop.  If fast-blowing fuses were to be used in an application like this, the motor could never get started because the normal inrush current levels would blow the fuse(s) immediately!  The design of a slow-blow fuse is such that the fuse element has more mass (but no more ampacity) than an equivalent fast-blow fuse, meaning that it will heat up slower (but to the same ultimate temperature) for any given amount of current.
</para>

<index>Semiconductor fuse</index>

<para>
On the other end of the fuse action spectrum, there are so-called <italic>semiconductor fuses</italic> designed to open very quickly in the event of an overcurrent condition.  Semiconductor devices such as transistors tend to be especially intolerant of overcurrent conditions, and as such require fast-acting protection against overcurrents in high-power applications.
</para>

<index>Conductor, "hot"</index>
<index>Conductor, "neutral"</index>

<para>
Fuses are always supposed to be placed on the "hot" side of the load in systems that are grounded.  The intent of this is for the load to be completely de-energized in all respects after the fuse opens.  To see the difference between fusing the "hot" side versus the "neutral" side of a load, compare these two circuits:
</para>

<image>00285.png</image>

<para>

</para>

<bigspace>

<image>00286.png</image>

<para>
In either case, the fuse successfully interrupted current to the load, but the lower circuit fails to interrupt potentially dangerous voltage from either side of the load to ground, where a person might be standing.  The first circuit design is much safer.
</para>

<para>
As it was said before, fuses are not the only type of overcurrent protection device in use.  Switch-like devices called circuit breakers are often (and more commonly) used to open circuits with excessive current, their popularity due to the fact that they don't destroy themselves in the process of breaking the circuit as fuses do.  In any case, though, placement of the overcurrent protection device in a circuit will follow the same general guidelines listed above: namely, to "fuse" the side of the power supply <italic>not</italic> connected to ground.
</para>

<para>
Although overcurrent protection placement in a circuit may determine the relative shock hazard of that circuit under various conditions, it must be understood that such devices were never intended to guard against electric shock.  Neither fuses nor circuit breakers were designed to open in the event of a person getting shocked; rather, they are intended to open only under conditions of potential conductor overheating.  Overcurrent devices primarily protect the conductors of a circuit from overtemperature damage (and the fire hazards associated with overly hot conductors), and secondarily protect specific pieces of equipment such as loads and generators (some fast-acting fuses are designed to protect electronic devices particularly susceptible to current surges).  Since the current levels necessary for electric shock or electrocution are much lower than the normal current levels of common power loads, a condition of overcurrent is not indicative of shock occurring.  There are other devices designed to detect certain shock conditions (ground-fault detectors being the most popular), but these devices strictly serve that one purpose and are uninvolved with protection of the conductors against overheating.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>A <italic>fuse</italic> is a small, thin conductor designed to melt and separate into two pieces for the purpose of breaking a circuit in the event of excessive current.</item>
<item>A <italic>circuit breaker</italic> is a specially designed switch that automatically opens to interrupt circuit current in the event of an overcurrent condition.  They can be "tripped" (opened) thermally, by magnetic fields, or by external devices called "protective relays," depending on the design of breaker, its size, and the application.</item>
<item>Fuses are primarily rated in terms of maximum current, but are also rated in terms of how much voltage drop they will safely withstand after interrupting a circuit.</item>
<item>Fuses can be designed to blow fast, slow, or anywhere in between for the same maximum level of current.</item>
<item>The best place to install a fuse in a grounded power system is on the ungrounded conductor path to the load.  That way, when the fuse blows there will only be the grounded (safe) conductor still connected to the load, making it safer for people to be around.</item>
</itemize>

</section>








<section>
<sectiontitle>Specific resistance</sectiontitle>

<index>Specific resistance</index>
<index>Resistance, specific</index>

<para>
Conductor ampacity rating is a crude assessment of resistance based on the potential for current to create a fire hazard.  However, we may come across situations where the voltage drop created by wire resistance in a circuit poses concerns other than fire avoidance.  For instance, we may be designing a circuit where voltage across a component is critical, and must not fall below a certain limit.  If this is the case, the voltage drops resulting from wire resistance may cause an engineering problem while being well within safe (fire) limits of ampacity:
</para>

<image>00287.png</image>

<para>
If the load in the above circuit will not tolerate less than 220 volts, given a source voltage of 230 volts, then we'd better be sure that the wiring doesn't drop more than 10 volts along the way.  Counting both the supply and return conductors of this circuit, this leaves a maximum tolerable drop of 5 volts along the length of each wire.  Using Ohm's Law (R=E/I), we can determine the maximum allowable resistance for each piece of wire:
</para>

<image>10220.png</image>

<para>
We know that the wire length is 2300 feet for each piece of wire, but how do we determine the amount of resistance for a specific size and length of wire?  To do that, we need another formula:
</para>

<image>10221.png</image>

<para>
This formula relates the resistance of a conductor with its specific resistance (the Greek letter "rho" (<rho>), which looks similar to a lower-case letter "p"), its length ("l"), and its cross-sectional area ("A").  Notice that with the length variable on the top of the fraction, the resistance value increases as the length increases (analogy: it is more difficult to force liquid through a long pipe than a short one), and decreases as cross-sectional area increases (analogy: liquid flows easier through a fat pipe than through a skinny one).  Specific resistance is a constant for the type of conductor material being calculated.
</para>

<para>
The specific resistances of several conductive materials can be found in the following table.  We find copper near the bottom of the table, second only to silver in having low specific resistance (good conductivity):
</para>

<bigspace>

                                                                      
<para>
<bold>Specific resistance table:</bold><ref>cspr2.tbl below</ref>
</para>

<table>cspr2.tbl<caption>Specific resistance at 20<superscript>o</superscript> C:</caption>
<tabular>{|l|l|l|l|}
<hr>
<tr>
<th>Material</th><th>Element/Alloy</th><th>(ohm-cmil/ft)</th><th>(ohm-cm<cdot>10<superscript>-6</superscript>)</th>
</tr>
<hr>
<tr>
<td>Nichrome</td><td>Alloy</td><td>675</td><td>112.2</td>
</tr>
<tr>
<td>Nichrome V</td><td>Alloy</td><td>650</td><td>108.1</td>
</tr>
<tr>
<td>Manganin</td><td>Alloy</td><td>290</td><td>48.21</td>
</tr>
<tr>
<td>Constantan</td><td>Alloy</td><td>272.97</td><td>45.38</td>
</tr>
<tr>
<td>Steel*</td><td>Alloy</td><td>100</td><td>16.62</td>
</tr>
<tr>
<td>Platinum</td><td>Element</td><td>63.16</td><td>10.5</td>
</tr>
<tr>
<td>Iron</td><td>Element</td><td>57.81</td><td>9.61</td>
</tr>
<tr>
<td>Nickel</td><td>Element</td><td>41.69</td><td>6.93</td>
</tr>
<tr>
<td>Zinc</td><td>Element</td><td>35.49</td><td>5.90</td>
</tr>
<tr>
<td>Molybdenum</td><td>Element</td><td>32.12</td><td>5.34</td>
</tr>
<tr>
<td>Tungsten</td><td>Element</td><td>31.76</td><td>5.28</td>
</tr>
<tr>
<td>Aluminum</td><td>Element</td><td>15.94</td><td>2.650</td>
</tr>
<tr>
<td>Gold</td><td>Element</td><td>13.32</td><td>2.214</td>
</tr>
<tr>
<td>Copper</td><td>Element</td><td>10.09</td><td>1.678</td>
</tr>
<tr>
<td>Silver</td><td>Element</td><td>9.546</td><td>1.587</td>
</tr>
<hr>

</tabular>

<tabular>{|l|}
<tr>
<htmlo><td><sp><sp><sp><sp>*<sp><sp><sp><sp><sp><sp> =<sp><sp> <sp>Steel <sp><sp>alloy <sp><sp>at <sp><sp>99.5% <sp><sp><sp>iron, <sp><sp>0.5% <sp><sp><sp>carbon<sp><sp><sp><sp><sp></td></htmlo>
<tex><td>* = Steel alloy at 99.5% iron, 0.5% carbon<sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp></td></tex>
</tr>
<hr>
</tabular>

</table>

<bigspace>


<para>
Notice that the figures for specific resistance in the above table are given in the very strange unit of "ohms-cmil/ft" (<OMEGA>-cmil/ft),  This unit indicates what units we are expected to use in the resistance formula (R=<rho>l/A).  In this case, these figures for specific resistance are intended to be used when length is measured in feet and cross-sectional area is measured in circular mils.  
</para>

<para>
The metric unit for specific resistance is the ohm-meter (<OMEGA>-m), or ohm-centimeter (<OMEGA>-cm), with 1.66243 x 10<superscript>-9</superscript> <OMEGA>-meters per <OMEGA>-cmil/ft (1.66243 x 10<superscript>-7</superscript> <OMEGA>-cm per <OMEGA>-cmil/ft).  In the <OMEGA>-cm column of the table, the figures are actually scaled as <mu><OMEGA>-cm due to their very small magnitudes.  For example, iron is listed as 9.61 <mu><OMEGA>-cm, which could be represented as 9.61 x 10<superscript>-6</superscript> <OMEGA>-cm.  
</para>

<para>
When using the unit of <OMEGA>-meter for specific resistance in the R=<rho>l/A formula, the length needs to be in meters and the area in square meters.  When using the unit of <OMEGA>-centimeter (<OMEGA>-cm) in the same formula, the length needs to be in centimeters and the area in square centimeters.
</para>

<para>
All these units for specific resistance are valid for any material (<OMEGA>-cmil/ft, <OMEGA>-m, or <OMEGA>-cm).  One might prefer to use <OMEGA>-cmil/ft, however, when dealing with round wire where the cross-sectional area is already known in circular mils.  Conversely, when dealing with odd-shaped busbar or custom busbar cut out of metal stock, where only the linear dimensions of length, width, and height are known, the specific resistance units of <OMEGA>-meter or <OMEGA>-cm may be more appropriate.
</para>

<para>
Going back to our example circuit, we were looking for wire that had 0.2 <OMEGA> or less of resistance over a length of 2300 feet.  Assuming that we're going to use copper wire (the most common type of electrical wire manufactured), we can set up our formula as such:
</para>

<image>10222.png</image>

<para>
Algebraically solving for A, we get a value of 116,035 circular mils.  Referencing our solid wire size table, we find that "double-ought" (2/0) wire with 133,100 cmils is adequate, whereas the next lower size, "single-ought" (1/0), at 105,500 cmils is too small.  Bear in mind that our circuit current is a modest 25 amps.  According to our ampacity table for copper wire in free air, 14 gauge wire would have sufficed (as far as <italic>not</italic> starting a fire is concerned).  However, from the standpoint of voltage drop, 14 gauge wire would have been very unacceptable.
</para>

<para>
Just for fun, let's see what 14 gauge wire would have done to our power circuit's performance.  Looking at our wire size table, we find that 14 gauge wire has a cross-sectional area of 4,107 circular mils.  If we're still using copper as a wire material (a good choice, unless we're <italic>really</italic> rich and can afford 4600 feet of 14 gauge silver wire!), then our specific resistance will still be 10.09 <OMEGA>-cmil/ft:
</para>

<image>10223.png</image>

<para>
Remember that this is 5.651 <OMEGA> per 2300 feet of 14-gauge copper wire, and that we have two runs of 2300 feet in the entire circuit, so <italic>each</italic> wire piece in the circuit has 5.651 <OMEGA> of resistance:
</para>

<image>00288.png</image>

<para>
Our total circuit wire resistance is 2 times 5.651, or 11.301 <OMEGA>.  Unfortunately, this is <italic>far</italic> too much resistance to allow 25 amps of current with a source voltage of 230 volts.  Even if our load resistance was 0 <OMEGA>, our wiring resistance of 11.301 <OMEGA> would restrict the circuit current to a mere 20.352 amps!  As you can see, a "small" amount of wire resistance can make a big difference in circuit performance, especially in power circuits where the currents are much higher than typically encountered in electronic circuits.
</para>

<para>
Let's do an example resistance problem for a piece of custom-cut busbar.  Suppose we have a piece of solid aluminum bar, 4 centimeters wide by 3 centimeters tall by 125 centimeters long, and we wish to figure the end-to-end resistance along the long dimension (125 cm).  First, we would need to determine the cross-sectional area of the bar:
</para>

<image>10224.png</image>

<para>
We also need to know the specific resistance of aluminum, in the unit proper for this application (<OMEGA>-cm).  From our table of specific resistances, we see that this is 2.65 x 10<superscript>-6</superscript> <OMEGA>-cm.  Setting up our R=<rho>l/A formula, we have:
</para>

<image>10225.png</image>

<para>
As you can see, the sheer thickness of a busbar makes for <italic>very</italic> low resistances compared to that of standard wire sizes, even when using a material with a greater specific resistance. 
</para>

<para>
The procedure for determining busbar resistance is not fundamentally different than for determining round wire resistance.  We just need to make sure that cross-sectional area is calculated properly and that all the units correspond to each other as they should.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Conductor resistance increases with increased length and decreases with increased cross-sectional area, all other factors being equal.</item>
<item><italic>Specific Resistance</italic> ("<rho>") is a property of any conductive material, a figure used to determine the end-to-end resistance of a conductor given length and area in this formula: R = <rho>l/A</item>
<item>Specific resistance for materials are given in units of <OMEGA>-cmil/ft or <OMEGA>-meters (metric).  Conversion factor between these two units is 1.66243 x 10<superscript>-9</superscript> <OMEGA>-meters per <OMEGA>-cmil/ft, or 1.66243 x 10<superscript>-7</superscript> <OMEGA>-cm per <OMEGA>-cmil/ft.</item>
<item>If wiring voltage drop in a circuit is critical, exact resistance calculations for the wires must be made before wire size is chosen.</item>
</itemize>

</section>







<section>
<sectiontitle>Temperature coefficient of resistance</sectiontitle>

<index>Temperature coefficient of resistance</index>
<index>Resistance, temperature coefficient of</index>

<para>
You might have noticed on the table for specific resistances that all figures were specified at a temperature of 20<superscript>o</superscript> Celsius.  If you suspected that this meant specific resistance of a material may change with temperature, you were right!
</para>

<para>
Resistance values for conductors at any temperature other than the standard temperature (usually specified at 20 Celsius) on the specific resistance table must be determined through yet another formula:
</para>

<image>10226.png</image>

<para>
The "alpha" (<alpha>) constant is known as the <italic>temperature coefficient of resistance</italic>, and symbolizes the resistance change factor per degree of temperature change.  Just as all materials have a certain specific resistance (at 20<superscript>o</superscript> C), they also <italic>change</italic> resistance according to temperature by certain amounts.  For pure metals, this coefficient is a positive number, meaning that resistance <italic>increases</italic> with increasing temperature.  For the elements carbon, silicon, and germanium, this coefficient is a negative number, meaning that resistance <italic>decreases</italic> with increasing temperature.  For some metal alloys, the temperature coefficient of resistance is very close to zero, meaning that the resistance hardly changes at all with variations in temperature (a good property if you want to build a precision resistor out of metal wire!).  The following table gives the temperature coefficients of resistance for several common metals, both pure and alloy:
</para>

<bigspace>


<para>
<bold>Temperature coefficient table:</bold><ref>tcr2.tbl below</ref>
</para>

<table>tcr2.tbl<caption>Temperature coefficient (<alpha>) per degree C:</caption>
<tabular>{|l|l|l|}
<hr>

<tr>
<th>Material</th><th>Element/Alloy</th><th>Temp. coefficient</th>
</tr>
<hr>
<tr>
<td>Nickel</td><td>Element</td><td>0.005866</td>
</tr>
<tr>
<td>Iron</td><td>Element</td><td>0.005671</td>
</tr>
<tr>
<td>Molybdenum</td><td>Element</td><td>0.004579</td>
</tr>
<tr>
<td>Tungsten</td><td>Element</td><td>0.004403</td>
</tr>
<tr>
<td>Aluminum</td><td>Element</td><td>0.004308</td>
</tr>
<tr>
<td>Copper</td><td>Element</td><td>0.004041</td>
</tr>
<tr>
<td>Silver</td><td>Element</td><td>0.003819</td>
</tr>
<tr>
<td>Platinum</td><td>Element</td><td>0.003729</td>
</tr>
<tr>
<td>Gold</td><td>Element</td><td>0.003715</td>
</tr>
<tr>
<td>Zinc</td><td>Element</td><td>0.003847</td>
</tr>
<tr>
<td>Steel*</td><td>Alloy</td><td>0.003</td>
</tr>
<tr>
<td>Nichrome</td><td>Alloy</td><td>0.00017</td>
</tr>
<tr>
<td>Nichrome V</td><td>Alloy</td><td>0.00013</td>
</tr>
<tr>
<td>Manganin</td><td>Alloy</td><td>0.000015</td>
</tr>
<tr>
<td>Constantan</td><td>Alloy</td><td><plusminus>0.000074</td>
</tr>
<hr>
</tabular>

<tabular>{|l|}
<tr>
<htmlo><td>*<sp><sp> = <sp>S<sp>teel alloy at 99.5% <sp><sp><sp>iron, 0.5% <sp><sp><sp>carbon<sp></td></htmlo>
<tex><td>* = Steel alloy at 99.5% iron, 0.5% carbon<sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp><sp></td></tex>
</tr>
<hr>

</tabular>
</table>

<bigspace>


<para>
Let's take a look at an example circuit to see how temperature can affect wire resistance, and consequently circuit performance:
</para>

<image>00289.png</image>

<para>
This circuit has a total wire resistance (wire 1 + wire 2) of 30 <OMEGA> at standard temperature.  Setting up a table of voltage, current, and resistance values we get:
</para>

<image>10227.png</image>

<para>
At 20<superscript>o</superscript> Celsius, we get 12.5 volts across the load and a total of 1.5 volts (0.75 + 0.75) dropped across the wire resistance.  If the temperature were to rise to 35<superscript>o</superscript> Celsius, we could easily determine the change of resistance for each piece of wire.  Assuming the use of copper wire (<alpha> = 0.004041) we get:
</para>

<image>10228.png</image>

<para>
Recalculating our circuit values, we see what changes this increase in temperature will bring:
</para>

<image>10229.png</image>

<para>
As you can see, voltage across the load went down (from 12.5 volts to 12.42 volts) and voltage drop across the wires went up (from 0.75 volts to 0.79 volts) as a result of the temperature increasing.  Though the changes may seem small, they can be significant for power lines stretching miles between power plants and substations, substations and loads.  In fact, power utility companies often have to take line resistance changes resulting from seasonal temperature variations into account when calculating allowable system loading.
</para>


<itemize>
<item><bold>REVIEW:</bold></item>
<item>Most conductive materials change specific resistance with changes in temperature.  This is why figures of specific resistance are always specified at a standard temperature (usually 20<superscript>o</superscript> or 25<superscript>o</superscript> Celsius).</item>
<item>The resistance-change factor per degree Celsius of temperature change is called the <italic>temperature coefficient of resistance</italic>.  This factor is represented by the Greek lower-case letter "alpha" (<alpha>).</item>
<item>A positive coefficient for a material means that its resistance increases with an increase in temperature.  Pure metals typically have positive temperature coefficients of resistance.  Coefficients approaching zero can be obtained by alloying certain metals.</item>
<item>A negative coefficient for a material means that its resistance decreases with an increase in temperature.  Semiconductor materials (carbon, silicon, germanium) typically have negative temperature coefficients of resistance.</item>
<item>The formula used to determine the resistance of a conductor at some temperature other than what is specified in a resistance table is as follows:</item>
<item><image>10226.png</image></item>
</itemize>

</section>







<section>
<sectiontitle>Superconductivity</sectiontitle>

<index>Superconductor</index>
<index>Zero, absolute</index>

<para>
Conductors lose all of their electrical resistance when cooled to super-low temperatures (near absolute zero, about -273<superscript>o</superscript> Celsius).  It must be understood that superconductivity is not merely an extrapolation of most conductors' tendency to gradually lose resistance with decreasing temperature; rather, it is a sudden, quantum leap in resistivity from finite to nothing.  <italic>A superconducting material has absolutely zero electrical resistance, not just some small amount</italic>.
</para>

<para>
Superconductivity was first discovered by H. Kamerlingh Onnes at the University of Leiden, Netherlands in 1911.  Just three years earlier, in 1908, Onnes had developed a method of liquefying helium gas, which provided a medium with which to supercool experimental objects to just a few degrees above absolute zero.  Deciding to investigate changes in electrical resistance of mercury when cooled to this low of a temperature, he discovered that its resistance dropped to <italic>nothing</italic> just below the boiling point of helium.
</para>

<index>Superfluidity</index>
<index>Cooper pairs</index>

<para>
There is some debate over exactly how and why superconducting materials superconduct.  One theory holds that electrons group together and travel in pairs (called <italic>Cooper pairs</italic>) within a superconductor rather than travel independently, and that has something to do with their frictionless flow.  Interestingly enough, another phenomenon of super-cold temperatures, <italic>superfluidity</italic>, happens with certain liquids (especially liquid helium), resulting in frictionless flow of molecules. 
</para>

<para>
Superconductivity promises extraordinary capabilities for electric circuits.  If conductor resistance could be eliminated entirely, there would be no power losses or inefficiencies in electric power systems due to stray resistances.  Electric motors could be made almost perfectly (100%) efficient.  Components such as capacitors and inductors, whose ideal characteristics are normally spoiled by inherent wire resistances, could be made ideal in a practical sense.  Already, some practical superconducting conductors, motors, and capacitors have been developed, but their use at this present time is limited due to the practical problems intrinsic to maintaining super-cold temperatures.
</para>

<index>Transition temperature</index>
<index>Temperature, transition</index>

<para>
The threshold temperature for a superconductor to switch from normal conduction to superconductivity is called the <italic>transition temperature</italic>.  Transition temperatures for "classic" superconductors are in the cryogenic range (near absolute zero), but much progress has been made in developing "high-temperature" superconductors which superconduct at warmer temperatures.  One type is a ceramic mixture of yttrium, barium, copper, and oxygen which transitions at a relatively balmy -160<superscript>o</superscript> Celsius.  Ideally, a superconductor should be able to operate within the range of ambient temperatures, or at least within the range of inexpensive refrigeration equipment.
</para>

<index>kelvin (temperature scale)</index>
<index>Unit, kelvin</index>

<para>
The critical temperatures for a few common substances are shown here in this table.  Temperatures are given in  kelvins, which has the same incremental span as degrees Celsius (an increase or decrease of 1 kelvin is the same amount of temperature change as 1<superscript>o</superscript> Celsius), only offset so that 0 K is absolute zero.  This way, we don't have to deal with a lot of negative figures.
</para>

<bigspace>


<para>
<bold>Critical temperature, superconductors</bold><ref>critical2.tbl below</ref>
</para>

<table>critical2.tbl<caption>Critical temperatures given in Kelvins</caption>
<tabular>{|l|l|l|}
<hr>

<tr>
<th>Material</th><th>Element or Alloy</th><th>Critical temperature(K)</th>
</tr>
<hr>

<tr>
<td>Aluminum</td><td>Element</td><td>1.20</td>
</tr>

<tr>
<td>Cadmium</td><td>Element</td><td>0.56</td>
</tr>

<tr>
<td>Lead</td><td>Element</td><td>7.2</td>
</tr>

<tr>
<td>Mercury</td><td>Element</td><td>4.16</td>
</tr>

<tr>
<td>Niobium</td><td>Element</td><td>8.70</td>
</tr>

<tr>
<td>Thorium</td><td>Element</td><td>1.37</td>
</tr>

<tr>
<td>Tin</td><td>Element</td><td>3.72</td>
</tr>

<tr>
<td>Titanium</td><td>Element</td><td>0.39</td>
</tr>

<tr>
<td>Uranium</td><td>ELement</td><td>1.0</td>
</tr>

<tr>
<td>Zinc</td><td>Element</td><td>0.91</td>
</tr>

<tr>
<td>Niobium/Tin</td><td>Alloy</td><td>18.1</td>
</tr>

<tr>
<td>Cupric sulphide</td><td>Compound</td><td>1.6</td>
</tr>

<hr>

</tabular>
</table>



<bigspace>

<index>Meissner effect</index>
<index>Effect, Meissner</index>

<para>
Superconducting materials also interact in interesting ways with magnetic fields.  While in the superconducting state, a superconducting material will tend to exclude all magnetic fields, a phenomenon known as the <italic>Meissner effect</italic>.  However, if the magnetic field strength intensifies beyond a critical level, the superconducting material will be rendered non-superconductive.  In other words, superconducting materials will lose their superconductivity (no matter how cold you make them) if exposed to too strong of a magnetic field.  In fact, the presence of <italic>any</italic> magnetic field tends to lower the critical temperature of any superconducting material: the more magnetic field present, the colder you have to make the material before it will superconduct.   
</para>

<para>
This is another practical limitation to superconductors in circuit design, since electric current through any conductor produces a magnetic field.  Even though a superconducting wire would have zero resistance to oppose current, there will still be a <italic>limit</italic> of how much current could practically go through that wire due to its critical magnetic field limit.
</para>
 
<para>
There are already a few industrial applications of superconductors, especially since the recent (1987) advent of the yttrium-barium-copper-oxygen ceramic, which only requires liquid nitrogen to cool, as opposed to liquid helium.  It is even possible to order superconductivity kits from educational suppliers which can be operated in high school labs (liquid nitrogen not included).  Typically, these kits exhibit superconductivity by the Meissner effect, suspending a tiny magnet in mid-air over a superconducting disk cooled by a bath of liquid nitrogen.
</para>

<para>
The zero resistance offered by superconducting circuits leads to unique consequences.  In a superconducting short-circuit, it is possible to maintain large currents indefinitely with zero applied voltage!  
</para>

<image>00290.png</image>

<index>Perpetual motion machine</index>
<index>Motion, perpetual</index>
<index>Over-unity machine</index>

<para>
Rings of superconducting material have been experimentally proven to sustain continuous current for years with no applied voltage.  So far as anyone knows, there is no theoretical time limit to how long an unaided current could be sustained in a superconducting circuit.  If you're thinking this appears to be a form of <italic>perpetual motion</italic>, you're correct!  Contrary to popular belief, there is no law of physics prohibiting perpetual motion; rather, the prohibition stands against any machine or system generating more energy than it consumes (what would be referred to as an <italic>over-unity</italic> device).  At best, all a perpetual motion machine (like the superconducting ring) would be good for is to <italic>store</italic> energy, not <italic>generate</italic> it freely!
</para>

<index>Junction, Josephson</index>
<index>Josephson junction</index>
<index>Transistor</index>

<para>
Superconductors also offer some strange possibilities having nothing to do with Ohm's Law.  One such possibility is the construction of a device called a Josephson Junction, which acts as a relay of sorts, controlling one current with another current (with no moving parts, of course).  The small size and fast switching time of Josephson Junctions may lead to new computer circuit designs: an alternative to using semiconductor transistors.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Superconductors are materials which have absolutely zero electrical resistance.</item>
<item>All presently known superconductive materials need to be cooled far below ambient temperature to superconduct.  The maximum temperature at which they do so is called the <italic>transition temperature</italic>.</item>
</itemize>

</section>







<section>
<sectiontitle>Insulator breakdown voltage</sectiontitle>

<index>Insulator</index>

<para>
The atoms in insulating materials have very tightly-bound electrons, resisting free electron flow very well.  However, insulators cannot resist indefinite amounts of voltage.  With enough voltage applied, <italic>any</italic> insulating material will eventually succumb to the electrical "pressure" and electron flow will occur.  However, unlike the situation with conductors where current is in a linear proportion to applied voltage (given a fixed resistance), current through an insulator is quite nonlinear: for voltages below a certain threshold level, virtually no electrons will flow, but if the voltage exceeds that threshold, there will be a rush of current.   
</para>

<index>Breakdown, insulation</index>

<para>
Once current is forced through an insulating material, <italic>breakdown</italic> of that material's molecular structure has occurred.  After breakdown, the material may or may not behave as an insulator any more, the molecular structure having been altered by the breach.  There is usually a localized "puncture" of the insulating medium where the electrons flowed during breakdown.
</para>

<index>Dielectric strength</index>

<para>
Thickness of an insulating material plays a role in determining its breakdown voltage, otherwise known as <italic>dielectric strength</italic>.  Specific dielectric strength is sometimes listed in terms of volts per mil (1/1000 of an inch), or kilovolts per inch (the two units are equivalent), but in practice it has been found that the relationship between breakdown voltage and thickness is not exactly linear.  An insulator three times as thick has a dielectric strength slightly less than 3 times as much.  However, for rough estimation use, volt-per-thickness ratings are fine.
</para>

<bigspace>

<literal>

</literal>

<bigspace>

<para>
<bold>Dielectric strength:</bold><ref>dielectric2.tbl below</ref>
</para>

<table>dielectric2.tbl<caption>Dielectric strength in kilovolts per inch (kV/in):</caption>
<tabular>{|l|l|}
<hr>
<tr>
<th>Material*</th><th>Dielectric strength</th>
</tr>
<hr>
<tr>
<td>Vacuum</td><td>20</td>
</tr>
<tr>
<td>Air</td><td>20 to 75</td>
</tr>
<tr>
<td>Porcelain</td><td>40 to 200</td>
</tr>
<tr>
<td>Paraffin Wax</td><td>200 to 300</td>
</tr>
<tr>
<td>Transformer Oil</td><td>400</td>
</tr>
<tr>
<td>Bakelite</td><td>300 to 550</td>
</tr>
<tr>
<td>Rubber</td><td>450 to 700</td>
</tr>
<tr>
<td>Shellac</td><td>900</td>
</tr>
<tr>
<td>Paper</td><td>1250</td>
</tr>
<tr>
<td>Teflon</td><td>1500</td>
</tr>
<tr>
<td>Glass</td><td>2000 to 3000</td>
</tr>
<tr>
<td>Mica</td><td>5000</td>
</tr>
<hr>
</tabular>
</table>



<para>
* = Materials listed are specially prepared for electrical use, <ref>dielectric2.tbl above</ref>.
</para>





<bigspace>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>With a high enough applied voltage, electrons can be freed from the atoms of insulating materials, resulting in current through that material.</item>
<item>The minimum voltage required to "violate" an insulator by forcing current through it is called the <italic>breakdown voltage</italic>, or <italic>dielectric strength</italic>.</item>
<item>The thicker a piece of insulating material, the higher the breakdown voltage, all other factors being equal.</item>
<item>Specific dielectric strength is typically rated in one of two equivalent units: volts per mil, or kilovolts per inch.</item>
</itemize>

</section>






<section>
<sectiontitle>Data</sectiontitle>

<para>
Tables of specific resistance and temperature coefficient of resistance for elemental materials (not alloys) were derived from figures found in the 78<superscript>th</superscript> edition of the <italic>CRC Handbook of Chemistry and Physics</italic>.
</para>

<para>
Table of superconductor critical temperatures derived from figures found in the 21<superscript>st</superscript> volume of <italic>Collier's Encyclopedia</italic>, 1968.
</para>

</section>




<section>
<sectiontitle>Contributors</sectiontitle>

<para>
Contributors to this chapter are listed in chronological order of their contributions, from most recent to first.  See Appendix 2 (Contributor List) for dates and contact information.
</para>

<para>
<bold>Aaron Forster</bold> (February 18, 2003): Typographical error correction.
</para>

<para>
<bold>Jason Starck</bold> (June 2000): HTML document formatting, which led to a much better-looking second edition.
</para>

</section>


</chapter>

<pagebreak>

