
<chapter>
<chaptertitle>MAGNETISM AND ELECTROMAGNETISM</chaptertitle>


<section>
<sectiontitle>Permanent magnets</sectiontitle>

<index>Magnetism</index>
<index>Lodestone</index>
<index>Magnetite</index>

<para>
Centuries ago, it was discovered that certain types of mineral rock possessed unusual properties of attraction to the metal iron.  One particular mineral, called <italic>lodestone</italic>, or <italic>magnetite</italic>, is found mentioned in very old historical records (about 2500 years ago in Europe, and much earlier in the Far East) as a subject of curiosity.  Later, it was employed in the aid of navigation, as it was found that a piece of this unusual rock would tend to orient itself in a north-south direction if left free to rotate (suspended on a string or on a float in water).  A scientific study undertaken in 1269 by Peter Peregrinus revealed that steel could be similarly "charged" with this unusual property after being rubbed against one of the "poles" of a piece of lodestone.
</para>

<para>
Unlike electric charges (such as those observed when amber is rubbed against cloth), magnetic objects possessed two poles of opposite effect, denoted "north" and "south" after their self-orientation to the earth.  As Peregrinus found, it was impossible to isolate one of these poles by itself by cutting a piece of lodestone in half: each resulting piece possessed its own pair of poles:
</para>

<image>00302.png</image>

<para>
Like electric charges, there were only two types of poles to be found: north and south (by analogy, positive and negative).  Just as with electric charges, same poles repel one another, while opposite poles attract.  This force, like that caused by static electricity, extended itself invisibly over space, and could even pass through objects such as paper and wood with little effect upon strength.
</para>

<para>
The philosopher-scientist Rene Descartes noted that this invisible "field" could be mapped by placing a magnet underneath a flat piece of cloth or wood and sprinkling iron filings on top.  The filings will align themselves with the magnetic field, "mapping" its shape.  The result shows how the field continues unbroken from one pole of a magnet to the other:
</para>

<image>00303.png</image>

<index>Field force</index>
<index>Field flux</index>

<para>
As with any kind of field (electric, magnetic, gravitational), the total quantity, or effect, of the field is referred to as a <italic>flux</italic>, while the "push" causing the flux to form in space is called a <italic>force</italic>.  Michael Faraday coined the term "tube" to refer to a string of magnetic flux in space (the term "line" is more commonly used now).  Indeed, the measurement of magnetic field flux is often defined in terms of the number of flux lines, although it is doubtful that such fields exist in individual, discrete lines of constant value.
</para>

<index>Permanent magnet</index>
<index>Magnet, permanent</index>

<para>
Modern theories of magnetism maintain that a magnetic field is produced by an electric charge in motion, and thus it is theorized that the magnetic field of a so-called "permanent" magnets such as lodestone is the result of electrons within the atoms of iron spinning uniformly in the same direction.  Whether or not the electrons in a material's atoms are subject to this kind of uniform spinning is dictated by the atomic structure of the material (not unlike how electrical conductivity is dictated by the electron binding in a material's atoms).  Thus, only certain types of substances react with magnetic fields, and even fewer have the ability to permanently sustain a magnetic field.
</para>

<para>
Iron is one of those types of substances that readily magnetizes.  If a piece of iron is brought near a permanent magnet, the electrons within the atoms in the iron orient their spins to match the magnetic field force produced by the permanent magnet, and the iron becomes "magnetized."  The iron will magnetize in such a way as to incorporate the magnetic flux lines into its shape, which attracts it toward the permanent magnet, no matter which pole of the permanent magnet is offered to the iron:
</para>

<image>00304.png</image>

<para>
The previously unmagnetized iron becomes magnetized as it is brought closer to the permanent magnet.  No matter what pole of the permanent magnet is extended toward the iron, the iron will magnetize in such a way as to be attracted toward the magnet:
</para>

<image>00305.png</image>

<index>Ferromagnetism</index>
<index>Paramagnetism</index>
<index>Diamagnetism</index>

<para>
Referencing the natural magnetic properties of iron (Latin = "ferrum"), a <italic>ferromagnetic</italic> material is one that readily magnetizes (its constituent atoms easily orient their electron spins to conform to an external magnetic field force).  All materials are magnetic to some degree, and those that are not considered ferromagnetic (easily magnetized) are classified as either <italic>paramagnetic</italic> (slightly magnetic) or <italic>diamagnetic</italic> (tend to exclude magnetic fields).  Of the two, diamagnetic materials are the strangest.  In the presence of an external magnetic field, they actually become slightly magnetized in the opposite direction, so as to repel the external field!
</para>

<image>00306.png</image>

<index>Retentivity</index>

<para>
If a ferromagnetic material tends to retain its magnetization after an external field is removed, it is said to have good <italic>retentivity</italic>.  This, of course, is a necessary quality for a permanent magnet.
</para>


<itemize>
<item><bold>REVIEW:</bold></item>
<item><italic>Lodestone</italic> (also called <italic>Magnetite</italic>) is a naturally-occurring "permanent" magnet mineral.  By "permanent," it is meant that the material maintains a magnetic field with no external help.  The characteristic of any magnetic material to do so is called <italic>retentivity</italic>.</item>
<item><italic>Ferromagnetic</italic> materials are easily magnetized.</item>
<item><italic>Paramagnetic</italic> materials are magnetized with more difficulty.</item>
<item><italic>Diamagnetic</italic> materials actually tend to repel external magnetic fields by magnetizing in the opposite direction.</item>
</itemize>

</section>








<section>
<sectiontitle>Electromagnetism</sectiontitle>

<para>
The discovery of the relationship between magnetism and electricity was, like so many other scientific discoveries, stumbled upon almost by accident.  The Danish physicist Hans Christian Oersted was lecturing one day in 1820 on the <italic>possibility</italic> of electricity and magnetism being related to one another, and in the process demonstrated it conclusively by experiment in front of his whole class!  By passing an electric current through a metal wire suspended above a magnetic compass, Oersted was able to produce a definite motion of the compass needle in response to the current.  What began as conjecture at the start of the class session was confirmed as fact at the end.  Needless to say, Oersted had to revise his lecture notes for future classes!  His serendipitous discovery paved the way for a whole new branch of science: electromagnetics.
</para>

<index>Left-hand rule</index>
<index>Rule, left-hand</index>

<para>
Detailed experiments showed that the magnetic field produced by an electric current is always oriented perpendicular to the direction of flow.  A simple method of showing this relationship is called the <italic>left-hand rule</italic>.  Simply stated, the left-hand rule says that the magnetic flux lines produced by a current-carrying wire will be oriented the same direction as the curled fingers of a person's left hand (in the "hitchhiking" position), with the thumb pointing in the direction of electron flow: 
</para>

<image>00307.png</image>

<para>
The magnetic field encircles this straight piece of current-carrying wire, the magnetic flux lines having no definite "north" or "south' poles.
</para>

<para>
While the magnetic field surrounding a current-carrying wire is indeed interesting, it is quite weak for common amounts of current, able to deflect a compass needle and not much more.  To create a stronger magnetic field force (and consequently, more field flux) with the same amount of electric current, we can wrap the wire into a coil shape, where the circling magnetic fields around the wire will join to create a larger field with a definite magnetic (north and south) polarity:
</para>

<image>00308.png</image>

<index>Magnetomotive force</index>
<index>Force, magnetomotive</index>

<para>
The amount of magnetic field force generated by a coiled wire is proportional to the current through the wire multiplied by the number of "turns" or "wraps" of wire in the coil.  This field force is called <italic>magnetomotive force</italic> (mmf), and is very much analogous to electromotive force (E) in an electric circuit.
</para>

<index>Electromagnetism</index>

<para>
An <italic>electromagnet</italic> is a piece of wire intended to generate a magnetic field with the passage of electric current through it.  Though all current-carrying conductors produce magnetic fields, an electromagnet is usually constructed in such a way as to maximize the strength of the magnetic field it produces for a special purpose.  Electromagnets find frequent application in research, industry, medical, and consumer products.
</para>

<index>Electric motor</index>
<index>Motor, electric</index>
<index>Relay</index>

<para>
As an electrically-controllable magnet, electromagnets find application in a wide variety of "electromechanical" devices: machines that effect mechanical force or motion through electrical power.  Perhaps the most obvious example of such a machine is the <italic>electric motor</italic>.  
</para>

<para>
Another example is the <italic>relay</italic>, an electrically-controlled switch.  If a switch contact mechanism is built so that it can be actuated (opened and closed) by the application of a magnetic field, and an electromagnet coil is placed in the near vicinity to produce that requisite field, it will be possible to open and close the switch by the application of a current through the coil.  In effect, this gives us a device that enables elelctricity to control electricity:
</para>

<image>00394.png</image>

<para>
Relays can be constructed to actuate multiple switch contacts, or operate them in "reverse" (energizing the coil will <italic>open</italic> the switch contact, and unpowering the coil will allow it to spring closed again).
</para>

<image>00395.png</image>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>When electrons flow through a conductor, a magnetic field will be produced around that conductor.</item>
<item>The left-hand rule states that the magnetic flux lines produced by a current-carrying wire will be oriented the same direction as the curled fingers of a person's left hand (in the "hitchhiking" position), with the thumb pointing in the direction of electron flow.</item>
<item>The magnetic field force produced by a current-carrying wire can be greatly increased by shaping the wire into a coil instead of a straight line.  If wound in a coil shape, the magnetic field will be oriented along the axis of the coil's length.</item>
<item>The magnetic field force produced by an electromagnet (called the <italic>magnetomotive force</italic>, or mmf), is proportional to the product (multiplication) of the current through the electromagnet and the number of complete coil "turns" formed by the wire.</item>
</itemize>

</section>







<section>
<sectiontitle>Magnetic units of measurement</sectiontitle>

<index>Field intensity</index>
<index>Flux density</index>
<index>Reluctance</index>
<index>Permeability</index>

<para>
If the burden of two systems of measurement for common quantities (English vs. metric) throws your mind into confusion, this is not the place for you!  Due to an early lack of standardization in the science of magnetism, we have been plagued with no less than three complete systems of measurement for magnetic quantities.
</para>

<index>Ohm's Law</index>
<index>Joule's Law</index>

<para>
First, we need to become acquainted with the various quantities associated with magnetism.  There are quite a few more quantities to be dealt with in magnetic systems than for electrical systems.  With electricity, the basic quantities are Voltage (E), Current (I), Resistance (R), and Power (P).  The first three are related to one another by Ohm's Law (E=IR ; I=E/R ; R=E/I), while Power is related to voltage, current, and resistance by Joule's Law (P=IE ; P=I<superscript>2</superscript>R ; P=E<superscript>2</superscript>/R).
</para>

<para>
With magnetism, we have the following quantities to deal with:
</para>

<bigspace>

<para>
<bold>Magnetomotive Force</bold> -- The quantity of magnetic field force, or "push."  Analogous to electric voltage (electromotive force).
</para>

<bigspace>

<para>
<bold>Field Flux</bold> -- The quantity of total field effect, or "substance" of the field.  Analogous to electric current.
</para>

<bigspace>

<para>
<bold>Field Intensity</bold> -- The amount of field force (mmf) distributed over the length of the electromagnet.  Sometimes referred to as <italic>Magnetizing Force</italic>.
</para>

<bigspace>

<para>
<bold>Flux Density</bold> -- The amount of magnetic field flux concentrated in a given area.
</para>

<bigspace>

<para>
<bold>Reluctance</bold> -- The opposition to magnetic field flux through a given volume of space or material.  Analogous to electrical resistance.
</para>

<bigspace>

<para>
<bold>Permeability</bold> -- The specific measure of a material's acceptance of magnetic flux, analogous to the specific resistance of a conductive material (<rho>), except inverse (greater permeability means easier passage of magnetic flux, whereas greater specific resistance means more difficult passage of electric current).
</para>

<bigspace>

<index>Metric system, cgs</index>
<index>Metric system, mks</index>
<index>Metric system, rmks</index>
<index>Metric system, Systeme International (SI)</index>
<index>Cgs, metric system</index>
<index>Mks, metric system</index>
<index>Rmks, metric system</index>
<index>SI (Systeme International), metric system</index>

<para>
But wait . . . the fun is just beginning!  Not only do we have more quantities to keep track of with magnetism than with electricity, but we have several different systems of unit measurement for each of these quantities.  As with common quantities of length, weight, volume, and temperature, we have both English and metric systems.  However, there is actually more than one metric system of units, and multiple metric systems are used in magnetic field measurements!  One is called the <italic>cgs</italic>, which stands for <bold>C</bold>entimeter-<bold>G</bold>ram-<bold>S</bold>econd, denoting the root measures upon which the whole system is based.  The other was originally known as the <italic>mks</italic> system, which stood for <bold>M</bold>eter-<bold>K</bold>ilogram-<bold>S</bold>econd, which was later revised into another system, called <italic>rmks</italic>, standing for <bold>R</bold>ationalized <bold>M</bold>eter-<bold>K</bold>ilogram-<bold>S</bold>econd.  This ended up being adopted as an international standard and renamed <italic>SI</italic> (<bold>S</bold>ysteme <bold>I</bold>nternational). 
</para>

<index>Gilbert</index>
<index>Unit, gilbert</index>
<index>Maxwell</index>
<index>Unit, maxwell</index>
<index>Oersted</index>
<index>Unit, oersted</index>
<index>Gauss</index>
<index>Unit, gauss</index>
<index>Weber</index>
<index>Unit, weber</index>
<index>Tesla</index>
<index>Unit, tesla</index>
<index>H, symbol for magnetic field intensity</index>
<index>B, symbol for magnetic flux density</index>

<image>10233.png</image>

<para>
And yes, the <mu> symbol is really the same as the metric prefix "micro."  I find this especially confusing, using the exact same alphabetical character to symbolize both a specific quantity and a general metric prefix!
</para>

<index>Ohm's Law, for magnetic circuits</index>

<para>
As you might have guessed already, the relationship between field force, field flux, and reluctance is much the same as that between the electrical quantities of electromotive force (E), current (I), and resistance (R).  This provides something akin to an Ohm's Law for magnetic circuits:
</para>

<image>10234.png</image>

<para>
And, given that permeability is inversely analogous to specific resistance, the equation for finding the reluctance of a magnetic material is very similar to that for finding the resistance of a conductor:
</para>

<image>10235.png</image>

<para>
In either case, a longer piece of material provides a greater opposition, all other factors being equal.  Also, a larger cross-sectional area makes for less opposition, all other factors being equal.
</para>

<index>Varistor</index>

<para>
The major caveat here is that the reluctance of a material to magnetic flux actually <italic>changes</italic> with the concentration of flux going through it.  This makes the "Ohm's Law" for magnetic circuits nonlinear and far more difficult to work with than the electrical version of Ohm's Law.  It would be analogous to having a resistor that changed resistance as the current through it varied (a circuit composed of <italic>var</italic>istors instead of <italic>res</italic>istors).
</para>

</section>








<section>
<sectiontitle>Permeability and saturation</sectiontitle>

<para>
The nonlinearity of material permeability may be graphed for better understanding.  We'll place the quantity of field intensity (H), equal to field force (mmf) divided by the length of the material, on the horizontal axis of the graph.  On the vertical axis, we'll place the quantity of flux density (B), equal to total flux divided by the cross-sectional area of the material.  We will use the quantities of field intensity (H) and flux density (B) instead of field force (mmf) and total flux (<PHI>) so that the shape of our graph remains independent of the physical dimensions of our test material.  What we're trying to do here is show a mathematical relationship between field force and flux for <italic>any</italic> chunk of a particular substance, in the same spirit as describing a material's <italic>specific resistance</italic> in ohm-cmil/ft instead of its actual <italic>resistance</italic> in ohms.
</para>

<image>00309.png</image>

<index>Normal magnetization curve</index>
<index>Saturation</index>

<para>
This is called the <italic>normal magnetization curve</italic>, or <italic>B-H curve</italic>, for any particular material.  Notice how the flux density for any of the above materials (cast iron, cast steel, and sheet steel) levels off with increasing amounts of field intensity.  This effect is known as <italic>saturation</italic>.  When there is little applied magnetic force (low H), only a few atoms are in alignment, and the rest are easily aligned with additional force.  However, as more flux gets crammed into the same cross-sectional area of a ferromagnetic material, fewer atoms are available within that material to align their electrons with additional force, and so it takes more and more force (H) to get less and less "help" from the material in creating more flux density (B).  To put this in economic terms, we're seeing a case of diminishing returns (B) on our investment (H).  Saturation is a phenomenon limited to iron-core electromagnets.  Air-core electromagnets don't saturate, but on the other hand they don't produce nearly as much magnetic flux as a ferromagnetic core for the same number of wire turns and current.
</para>

<index>Hysteresis</index>

<para>
Another quirk to confound our analysis of magnetic flux versus force is the phenomenon of magnetic <italic>hysteresis</italic>.  As a general term, hysteresis means a lag between input and output in a system upon a change in direction.  Anyone who's ever driven an old automobile with "loose" steering knows what hysteresis is: to change from turning left to turning right (or vice versa), you have to rotate the steering wheel an additional amount to overcome the built-in "lag" in the mechanical linkage system between the steering wheel and the front wheels of the car.  In a magnetic system, hysteresis is seen in a ferromagnetic material that tends to stay magnetized after an applied field force has been removed (see "retentivity" in the first section of this chapter), if the force is reversed in polarity.
</para>

<para>
Let's use the same graph again, only extending the axes to indicate both positive and negative quantities.  First we'll apply an increasing field force (current through the coils of our electromagnet).  We should see the flux density increase (go up and to the right) according to the normal magnetization curve:
</para>

<image>00310.png</image>

<para>
Next, we'll stop the current going through the coil of the electromagnet and see what happens to the flux, leaving the first curve still on the graph:
</para>

<image>00311.png</image>

<para>
Due to the retentivity of the material, we still have a magnetic flux with no applied force (no current through the coil).  Our electromagnet core is acting as a permanent magnet at this point.  Now we will slowly apply the same amount of magnetic field force in the <italic>opposite</italic> direction to our sample: 
</para>

<image>00312.png</image>

<para>
The flux density has now reached a point equivalent to what it was with a full positive value of field intensity (H), except in the negative, or opposite, direction.  Let's stop the current going through the coil again and see how much flux remains:
</para>

<image>00313.png</image>

<para>
Once again, due to the natural retentivity of the material, it will hold a magnetic flux with no power applied to the coil, except this time its in a direction opposite to that of the last time we stopped current through the coil.  If we re-apply power in a positive direction again, we should see the flux density reach its prior peak in the upper-right corner of the graph again:
</para>

<image>00314.png</image>

<para>
The "S"-shaped curve traced by these steps form what is called the <italic>hysteresis curve</italic> of a ferromagnetic material for a given set of field intensity extremes (-H and +H).  If this doesn't quite make sense, consider a hysteresis graph for the automobile steering scenario described earlier, one graph depicting a "tight" steering system and one depicting a "loose" system:
</para>

<image>00315.png</image>

<para>

</para>

<bigspace>

<image>00316.png</image>

<para>
Just as in the case of automobile steering systems, hysteresis can be a problem.  If you're designing a system to produce precise amounts of magnetic field flux for given amounts of current, hysteresis may hinder this design goal (due to the fact that the amount of flux density would depend on the current <italic>and</italic> how strongly it was magnetized before!).  Similarly, a loose steering system is unacceptable in a race car, where precise, repeatable steering response is a necessity.  Also, having to overcome prior magnetization in an electromagnet can be a waste of energy if the current used to energize the coil is alternating back and forth (AC).  The area within the hysteresis curve gives a rough estimate of the amount of this wasted energy.
</para>

<index>Ferrite </index>

<para>
Other times, magnetic hysteresis is a desirable thing.  Such is the case when magnetic materials are used as a means of storing information (computer disks, audio and video tapes).  In these applications, it is desirable to be able to magnetize a speck of iron oxide (ferrite) and rely on that material's retentivity to "remember" its last magnetized state.  Another productive application for magnetic hysteresis is in filtering high-frequency electromagnetic "noise" (rapidly alternating surges of voltage) from signal wiring by running those wires through the middle of a ferrite ring.  The energy consumed in overcoming the hysteresis of ferrite attenuates the strength of the "noise" signal.  Interestingly enough, the hysteresis curve of ferrite is quite extreme: 
</para>

<image>00317.png</image>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>The permeability of a material changes with the amount of magnetic flux forced through it.</item>
<item>The specific relationship of force to flux (field intensity H to flux density B) is graphed in a form called the <italic>normal magnetization curve</italic>.</item>
<item>It is possible to apply so much magnetic field force to a ferromagnetic material that no more flux can be crammed into it.  This condition is known as magnetic <italic>saturation</italic>.</item>
<item>When the <italic>retentivity</italic> of a ferromagnetic substance interferes with its re-magnetization in the opposite direction, a condition known as <italic>hysteresis</italic> occurs.</item>
</itemize>

</section>








<section>
<sectiontitle>Electromagnetic induction</sectiontitle>

<index>Electromagnetic induction</index>
<index>Induction, electromagnetic</index>

<para>
While Oersted's surprising discovery of electromagnetism paved the way for more practical <italic>applications</italic> of electricity, it was Michael Faraday who gave us the key to the practical <italic>generation</italic> of electricity: electromagnetic induction.  Faraday discovered that a voltage would be generated across a length of wire if that wire was exposed to a perpendicular magnetic field flux of changing intensity.
</para>

<para>
An easy way to create a magnetic field of changing intensity is to move a permanent magnet next to a wire or coil of wire.  Remember: the magnetic field must increase or decrease in intensity <italic>perpendicular</italic> to the wire (so that the lines of flux "cut across" the conductor), or else no voltage will be induced:
</para>

<image>00318.png</image>

<para>
Faraday was able to mathematically relate the rate of change of the magnetic field flux with induced voltage (note the use of a lower-case letter "e" for voltage.  This refers to <italic>instantaneous</italic> voltage, or voltage at a specific point in time, rather than a steady, stable voltage.):
</para>

<index>Instantaneous value</index>
<index>e, symbol for instantaneous voltage</index>

<image>10236.png</image>

<index>Calculus</index>

<para>
The "d" terms are standard calculus notation, representing rate-of-change of flux over time.  "N" stands for the number of turns, or wraps, in the wire coil (assuming that the wire is formed in the shape of a coil for maximum electromagnetic efficiency).
</para>

<para>
This phenomenon is put into obvious practical use in the construction of electrical generators, which use mechanical power to move a magnetic field past coils of wire to generate voltage.  However, this is by no means the only practical use for this principle.
</para>

<index>Self-induction</index>
<index>Inductor</index>

<para>
If we recall that the magnetic field produced by a current-carrying wire was always perpendicular to that wire, and that the flux intensity of that magnetic field varied with the amount of current through it, we can see that a wire is capable of inducing a voltage <italic>along its own length</italic> simply due to a change in current through it.  This effect is called <italic>self-induction:</italic> a changing magnetic field produced by changes in current through a wire inducing voltage along the length of that same wire.  If the magnetic field flux is enhanced by bending the wire into the shape of a coil, and/or wrapping that coil around a material of high permeability, this effect of self-induced voltage will be more intense.  A device constructed to take advantage of this effect is called an <italic>inductor</italic>, and will be discussed in greater detail in the next chapter.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>A magnetic field of changing intensity perpendicular to a wire will induce a voltage along the length of that wire.  The amount of voltage induced depends on the rate of change of the magnetic field flux and the number of turns of wire (if coiled) exposed to the change in flux.</item>
<item>Faraday's equation for induced voltage: e = N(d<PHI>/dt)</item>
<item>A current-carrying wire will experience an induced voltage along its length if the current changes (thus changing the magnetic field flux perpendicular to the wire, thus inducing voltage according to Faraday's formula).  A device built specifically to take advantage of this effect is called an <italic>inductor</italic>.</item>
</itemize>

</section>







<section>
<sectiontitle>Mutual inductance</sectiontitle>

<index>Mutual inductance</index>
<index>Inductance, mutual</index>

<para>
If two coils of wire are brought into close proximity with each other so the magnetic field from one links with the other, a voltage will be generated in the second coil as a result.  This is called <italic>mutual inductance:</italic> when voltage impressed upon one coil induces a voltage in another.
</para>

<index>Transformer</index>

<para>
A device specifically designed to produce the effect of mutual inductance between two or more coils is called a <italic>transformer</italic>.
</para>

<image>50005.jpg</image>

<para>
The device shown in the above photograph is a kind of transformer, with two concentric wire coils.  It is actually intended as a precision standard unit for mutual inductance, but for the purposes of illustrating what the essence of a transformer is, it will suffice.  The two wire coils can be distinguished from each other by color: the bulk of the tube's length is wrapped in green-insulated wire (the first coil) while the second coil (wire with bronze-colored insulation) stands in the middle of the tube's length.  The wire ends run down to connection terminals at the bottom of the unit.  Most transformer units are not built with their wire coils exposed like this.
</para>

<para>
Because magnetically-induced voltage only happens when the magnetic field flux is <italic>changing</italic> in strength relative to the wire, mutual inductance between two coils can only happen with alternating (changing -- AC) voltage, and not with direct (steady -- DC) voltage.  The only applications for mutual inductance in a DC system is where some means is available to switch power on and off to the coil (thus creating a <italic>pulsing</italic> DC voltage), the induced voltage peaking at every pulse.
</para>

<para>
A very useful property of transformers is the ability to transform voltage and current levels according to a simple ratio, determined by the ratio of input and output coil turns.  If the energized coil of a transformer is energized by an AC voltage, the amount of AC voltage induced in the unpowered coil will be equal to the input voltage multiplied by the ratio of output to input wire turns in the coils.  Conversely, the current through the windings of the output coil compared to the input coil will follow the opposite ratio: if the voltage is increased from input coil to output coil, the current will be decreased by the same proportion.  This action of the transformer is analogous to that of mechanical gear, belt sheave, or chain sprocket ratios:
</para>

<image>00319.png</image>

<para>
A transformer designed to output more voltage than it takes in across the input coil is called a "step-up" transformer, while one designed to do the opposite is called a "step-down," in reference to the transformation of voltage that takes place.  The current through each respective coil, of course, follows the exact opposite proportion. 
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Mutual inductance is where the magnetic field generated by a coil of wire induces voltage in an adjacent coil of wire.</item>
<item>A <italic>transformer</italic> is a device constructed of two or more coils in close proximity to each other, with the express purpose of creating a condition of mutual inductance between the coils.</item>
<item>Transformers only work with <italic>changing</italic> voltages, not steady voltages.  Thus, they may be classified as an AC device and not a DC device.</item>
</itemize>

</section>




<section>
<sectiontitle>Contributors</sectiontitle>

<para>
Contributors to this chapter are listed in chronological order of their contributions, from most recent to first.  See Appendix 2 (Contributor List) for dates and contact information.
</para>

<para>
<bold>Jason Starck</bold> (June 2000): HTML document formatting, which led to a much better-looking second edition.
</para>

</section>


</chapter>

<pagebreak>

