
<comment>Created 06/01/2005 (DC)</comment>
<comment>Modified 02/09/2005 (DC) Floating figures w/ captions </comment>
<comment>images used, diagrams, 02418.eps to </comment>

<chapter>
<chaptertitle>AC MOTORS</chaptertitle>

<para>
<bold>Original author: Dennis Crunkilton</bold>
</para>


<image>02418.png<caption>Conductors of squirrel cage induction motor removed from rotor.</caption></image>

<section>
<sectiontitle>Introduction</sectiontitle>

<index>Tesla, Nikola</index>
<index>Motor, AC</index>
<index>AC motor</index>

<para>
After the introduction of the DC electrical distribution system by Edison in the United States, a gradual transition to the more economical AC system commenced. Lighting worked as well on AC as on DC. Transmission of electrical energy covered longer distances at lower loss with alternating current. However, motors were a problem with alternating current. Initially, AC motors were constructed like DC motors. Numerous problems were encountered due to changing magnetic fields, as compared to the static fields in DC motor field coils.
</para>


<tex>
<image>02419.png<caption>AC electric motor family diagram.</caption></image>
</tex>

<htmlo>
<image>02420.png<caption>AC electric motor family diagram.</caption></image>
</htmlo>


<para>
Charles  P. Steinmetz contributed to solving these problems with his investigation of hysteresis losses in iron armatures. Nikola Tesla envisioned an entirely new type of motor when he visualized a spinning turbine, not spun by water or steam, but by a rotating magnetic field. His new type of motor, the AC induction motor, is the workhorse of industry to this day. Its ruggedness and simplicity (Figure<ref>02418.png above</ref>)  make for long life, high reliability, and low maintenance. Yet small brushed AC motors, similar to the DC variety, persist in small appliances along with small Tesla induction motors. Above one horsepower (750 W), the Tesla motor reigns supreme.
</para>

<para>
Modern solid state electronic circuits drive <italic>brushless DC motors</italic> with AC waveforms generated from a DC source. The brushless DC motor, actually an AC motor, is replacing the conventional brushed DC motor in many applications. And, the <italic>stepper motor</italic>, a digital version of motor, is driven by alternating current square waves, again, generated by solid state circuitry <tex>Figure<ref>02419.png above</ref></tex> <htmlo>Figure<ref>02420.png above</ref></htmlo> shows the family tree of the AC motors described in this chapter.
</para>


<para>
Cruise ships and other large vessels replace reduction geared drive shafts with large multi-megawatt generators and motors. Such has been the case with diesel-electric locomotives on a smaller scale for many years.
</para>

<image>02421.png<caption>Motor system level diagram.</caption></image>

<para>
At the system level, (Figure<ref>02421.png above</ref>) a motor takes in electrical energy in terms of a potential difference and a current flow, converting it to mechanical work. Alas, electric motors are not 100% efficient. Some of the electric energy is lost to heat, another form of energy, due to I<superscript>2</superscript>R losses in the motor windings. The heat is an undesired byproduct of the conversion. It must be removed from the motor and may adversely affect longevity. Thus, one goal is to maximize motor efficiency, reducing the heat loss.  AC motors also have some losses not encountered by DC motors: hysteresis and eddy currents.
</para>



<subsection>
<subsectiontitle><sp>Hysteresis and Eddy Current </subsectiontitle>

<para>
Early designers of AC motors encountered problems traced to losses unique to alternating current magnetics. These problems were encountered when adapting 
DC motors to AC operation. Though few AC motors today bear any resemblance to DC motors,  these problems  had to be solved before AC motors of any type  could be properly designed before they were built.
</para>

<index>Eddy current</index>

<para>
Both rotor and stator cores of AC motors are composed of a stack of insulated laminations. The laminations are coated with insulating varnish before stacking and bolting into the final form. <italic>Eddy currents</italic> are minimized by breaking the potential conductive loop into smaller less lossy segments. (Figure<ref>02422.png below</ref>)  The current loops look like shorted transformer secondary turns. The thin isolated laminations break these loops. Also, the silicon (a semiconductor) added to the alloy used in the laminations increases  electrical resistance which decreases the magnitude of eddy currents.
</para>

<image>02422.png<caption>Eddy currents in iron cores.</caption></image>

<para>
If the laminations are made of silicon alloy grain oriented steel,  <italic>hysteresis</italic> losses are minimized. Magnetic hysteresis is a lagging behind of magnetic field strength as compared to magnetizing force. If a soft iron nail is temporarily magnetized by a solenoid, one would expect the nail to lose the magnetic field once the solenoid is de-energized. However, a small amount of <italic>residual magnetization</italic>,  B<subscript>r</subscript>  due to hysteresis  remains. (Figure<ref>02423.png below</ref>)  An alternating current has to expend energy, -H<subscript>c</subscript> the <italic>coercive force</italic>, in overcoming  this residual magnetization before it can magnetize the core back to zero, let alone in the opposite direction. Hysteresis loss is encountered each time the polarity of the AC reverses. The loss is proportional to the area enclosed by the hysteresis loop on the B-H curve. ``Soft'' iron alloys have lower losses than ``hard'' high carbon steel alloys. Silicon grain oriented steel, 4% silicon, rolled to preferentially orient the grain or crystalline structure, has still lower losses.
</para>

<image>02423.png<caption>Hysteresis curves for low and high loss alloys.</caption></image>

<para>
Once Steinmetz's Laws of hysteresis could predict iron core losses, it was possible to design AC motors which performed as designed. This was akin to being able to design a bridge ahead of time that would not collapse once it was actually built. This knowledge of eddy current and hysteresis was first applied to building AC commutator motors similar to their DC counterparts. Today this is but a minor category of AC motors. Others invented new types of AC motors bearing little resemblance to their DC kin.
</para>

</subsection>


</section>

<section>
<sectiontitle><sp>Synchronous Motors</sectiontitle>

<index>Synchronous motor</index>
<index>Motor, AC, synchronous</index>
<index>Motor, synchronous</index>

<para>
Single phase synchronous motors are available in small sizes for applications requiring precise timing such as time keeping, (clocks) and tape players. Though battery powered quartz regulated clocks are widely available, the AC line operated variety has better long term accuracy<doubledash> over a period of months. This is due to power plant operators purposely maintaining the long term accuracy of the frequency of the AC distribution system. If it falls behind by a few cycles, they will make up the lost cycles of AC so that clocks lose no time. 
</para>

<para>
Above 10 Horsepower (10 kW) the higher efficiency and leading powerfactor make large synchronous motors useful in industry. Large synchronous motors are a few percent more efficient than the more common induction motors. Though, the synchronous motor is more complex.
</para>

<para>
Since motors and generators are similar in construction, it should be possible to use a generator as a motor, conversely, use a motor as a generator. A synchronous motor is similar to an alternator with a rotating field. The figure below shows small alternators with a permanent magnet rotating field. This figure<ref>02424.png below</ref> could either be two paralleled and synchronized alternators driven by a mechanical energy source, or an alternator driving a synchronous motor. Or, it could be two motors, if an external power source were connected. The point is that in either case the rotors must run at the same nominal frequency, and be in phase with each other.  That is, they must be <italic>synchronized</italic>. The procedure for synchronizing two alternators is to (1) open the switch, (2) drive both alternators at the same rotational rate, (3) advance or retard the phase of one unit until both AC outputs are in phase, (4) close the switch before they drift out of phase. Once synchronized, the alternators will be locked to each other, requiring considerable torque to break one unit loose (out of synchronization) from the other.
</para>

<image>02424.png<caption>Synchronous motor running in step with alternator.</caption></image>

<para>
If more torque in the direction of rotation is applied to the rotor of one of the above rotating alternators, the angle of the rotor will advance (opposite of (3)) with respect to the magnetic field in the stator coils while still synchronized and the rotor will deliver energy to the AC line like an alternator. The rotor will also be advanced with respect to the rotor in the other alternator. If a load such as a brake is applied to one of the above units, the angle of the rotor will lag the stator field as at (3), extracting energy from the AC line, like a motor.  If excessive torque  or drag is applied, the rotor will exceed the maximum <italic>torque angle</italic>   advancing or lagging  so much that synchronization is lost. Torque is developed only when synchronization of the motor is maintained.
</para>

<para>
In the case of a small synchronous motor in place of the alternator Figure<ref>02424.png above</ref> right, it is not necessary to go through the elaborate synchronization procedure for alternators. However, the synchronous motor is not self starting and must still be brought up to the approximate alternator electrical speed before it will lock (synchronize) to the generator rotational rate. Once up to speed, the synchronous motor will maintain synchronism with the AC power source and develop torque.
</para>

<image>02425.png<caption>Sinewave drives synchronous motor.</caption></image>

<para>
Assuming that the motor is up to synchronous speed, as the sine wave changes to  positive in Figure<ref>02425.png above</ref> (1), the lower north coil pushes the north rotor pole, while the upper south coil attracts that rotor north pole. In a similar manner the rotor south pole is repelled by the upper south coil and attracted to the lower north coil. By the time that the sine wave reaches a peak at (2), the torque holding the north pole of the rotor up is at a maximum. This torque decreases as the sine wave decreases to 0 V<subscript>DC</subscript> at (3) with the torque at a minimum. 
</para>

<para>
As the sine wave changes to  negative between (3&4), the lower south coil pushes the south rotor pole, while attracting rotor north rotor pole.   In a similar manner the rotor north pole is repelled by the upper north coil and attracted to the lower south coil. At (4) the sinewave reaches a negative peak with holding torque again at a maximum. As the sine wave changes from negative to  0 V<subscript>DC</subscript> to positive, The process repeats for a new cycle of sine wave.
</para>

<para>
Note, the above figure illustrates the rotor position for a no-load condition (<alpha>=0<superscript>o</superscript>). In actual practice, loading the rotor will cause the rotor to lag the positions shown by angle <alpha>. This angle increases with loading until the maximum motor torque is reached at <alpha>=90<superscript>o</superscript> electrical. Synchronization and torque are lost beyond this angle.
</para>

<para>
The current in the coils of a single phase synchronous motor pulsates while alternating polarity. If the permanent magnet rotor speed is close to the frequency of this alternation, it synchronizes to this alternation. Since the coil field pulsates and does not rotate, it is necessary to bring the permanent magnet rotor up to speed with an auxiliary motor. This is a small induction motor similar to those in the next section.
</para>

<image>02426.png<caption>Addition of field poles decreases speed.</caption></image>

<para>
A 2-pole (pair of N-S poles) alternator will generate a 60 Hz sine wave when rotated at 3600 rpm (revolutions per minute). The 3600 rpm corresponds to 60 revolutions per second. A similar 2-pole permanent magnet synchronous motor will also rotate at 3600 rpm. A lower speed motor may be constructed by adding more pole pairs. A 4-pole motor would rotate at 1800 rpm, a 12-pole motor at 600 rpm. The style of construction shown (Figure<ref>02426.png above)</ref>) is for illustration. Higher efficiency higher torque multi-pole stator synchronous motors actually have multiple poles in the rotor. 
</para>

<image>02427.png<caption>One-winding 12-pole synchronous motor.</caption></image>


<para>
Rather than wind 12-coils for a 12-pole motor, wind a single coil with twelve interdigitated steel poles pieces as shown in Figure<ref>02427.png above</ref>. Though the polarity of the coil alternates due to the appplied AC, assume that the top is temporarily north, the bottom south. Pole pieces route the south flux from the bottom and outside of the coil to the top. These 6-souths are interleaved with 6-north tabs bent up from the top of the steel pole piece of the coil. Thus, a permanent magnet rotor bar will encounter 6-pole pairs corresponding to 6-cycles of AC in one physical rotation of the bar magnet. The rotation speed will be 1/6 of the electrical speed of the AC. Rotor speed will be 1/6 of that experienced with a 2-pole synchronous motor. Example: 60 Hz would rotate a 2-pole motor at 3600 rpm, or 600 rpm for a 12-pole motor.  
</para>

<image>[scale=2]52017.jpg<caption>Reprinted by permission of  Westclox History at <url>http://www.clockHistory.com[www.clockHistory.com]</url></caption><label>52017.jpg</label></image>
<comment>Above image too small scale it larger-200%</comment>

<para>
The stator (Figure <ref>52017.jpg above</ref>) shows a 12-pole Westclox synchronous clock motor. Construction is similar to the previous figure with a single coil. The one coil style of construction is economical for low torque motors. This 600 rpm motor drives reduction gears  moving clock hands.
</para>

<para>
If the Westclox motor were to run at 600 rpm from a 50 Hz power source, how many poles would be required? A 10-pole motor would have 5-pairs of N-S poles. It would rotate at 50/5 = 10 rotations per second or 600 rpm (10 s<superscript>-1</superscript> x 60 s/minute.)
</para>

<image>[scale=2]52018.jpg<caption>Reprinted by permission of Westclox History at <url>http://www.clockHistory.com[www.clockHistory.com]</url></caption><label>52018.jpg</label></image>
<comment>Above image too small scale it larger-200%</comment>


<para>
The rotor (Figure<ref>52018.jpg above</ref>)  consists of a permanent magnet bar and a steel induction motor cup. The synchronous motor bar rotating within the pole tabs keeps accurate time. The induction motor cup outside of the bar magnet fits outside and over the tabs for self starting.  At one time non-self-starting motors without the induction motor cup were manufactured.
</para>

<para>
A 3-phase synchronous motor as shown in  Figure<ref>02428.png below</ref> generates an electrically  rotating field in the stator. Such motors are not self starting if started from a fixed frequency power source such as 50 or 60 Hz as found in an industrial setting. Furthermore, the rotor is not a permanent magnet as shown below for the multi-horsepower (multi-kilowatt) motors used in industry, but an electromagnet.  Large industrial synchronous motors are more efficient than induction motors. They are used when constant speed is required. Having a leading power factor, they can correct the AC line for a lagging power factor.
</para>

<para>
The three phases of stator excitation add vectorially to produce a single resultant magnetic field which rotates f/2n times per second, where f is the power line frequency, 50 or 60 Hz for industrial power line operated motors. The number of poles is n. For rotor speed in rpm, multiply by 60.
</para>

<table>
<literal>
<sp>       S = f120/n
<sp>                               
<sp>       where: S = rotor speed in rpm
<sp>              f = AC line frequency
<sp>              n = number of poles per phase
</literal>
</table>

<para>
The 3-phase 4-pole (per phase) synchronous motor (Figure<ref>02428.png below</ref>)  will rotate at 1800 rpm with 60 Hz power or 1500 rpm with 50 Hz power. If the coils are energized one at a time in the sequence <phi>-1, <phi>-2, <phi>-3, the rotor should point to the corresponding poles in turn. Since the sine waves actually overlap, the resultant field will rotate, not in steps, but smoothly. For example, when the <phi>-1 and <phi>-2 sinewaves coincide, the field will be at a peak pointing between these poles. The bar magnet rotor shown is only appropriate for small motors. The rotor with multiple magnet poles (below right) is used in any efficient motor driving a substantial load. These will be slip ring fed electromagnets in large industrial motors. Large industrial synchronous motors are self started by embedded squirrel cage conductors in the armature, acting like an induction motor. The electromagnetic armature is only energized after the rotor is brought up to near synchronous speed.
</para>

<image>02428.png<caption>Three phase, 4-pole synchronous motor</caption></image>

<para>
Small multi-phase synchronous motors (Figure<ref>02428.png above</ref>) may be started by ramping the drive frequency from zero to the final running frequency.  The multi-phase drive signals are generated by electronic circuits, and will be square waves in all but the most demanding applications. Such motors are known as brushless DC motors. True synchronous motors are driven by sine waveforms. Two or three phase drive may be used by supplying the appropriate number of windings in the stator. Only 3-phase is shown above.
</para>

<bigspace>
<image>02429.png<caption>Electronic synchronous motor</caption></image>
<bigspace>

<para>
The block diagram (Figure<ref>02429.png above</ref>) shows the drive electronics associated with a low voltage (12 V<subscript>DC</subscript>) synchronous motor. These motors have a <italic> position sensor</italic> integrated within the motor, which provides a low level  signal with a frequency proportional to the  speed of rotation of the motor. The position sensor could be as simple as solid state magnetic field sensors such as <italic>Hall effect</italic> devices providing commutation (armature current direction) timing to the drive electronics.  The position sensor could be a high resolution angular sensor such as a <hyperlink>resolver[resolver]</hyperlink>, 
<comment>split for double ref</comment> an <hyperlink>inductosyn[inductosyn][AC_12.html]</hyperlink> (magnetic encoder), or an optical encoder.
</para>

<para>
If constant and accurate speed of rotation is required, (as for a disk drive) a <italic>tachometer</italic> and <italic>phase locked loop</italic> may be  included. (Figure<ref>02430.png below</ref>) This tachometer signal, a pulse train proportional to motor speed, is fed back to a phase locked loop, which compares the tachometer frequency and phase to a stable reference frequency source such as a crystal oscillator. 
</para>

<image>02430.png<caption>Phase locked loop controls synchronous motor speed.</caption></image>

<index>Motor, DC, brushless</index> 
<index>Brushless DC motor</index>
<index>Ripple torque</index>

<para>
A motor driven by square waves of current, as provided by simple Hall effect sensors, is known as a <italic>brushless DC motor</italic>. This type of motor has higher <italic>ripple torque</italic> torque variation through a shaft revolution than a sine wave driven motor. This is not a problem for many applications. Though, we are primarily interested in synchronous motors in this section.
</para>

<bigspace>
<image>02431.png<caption>Motor ripple torque and mechanical analog.</caption></image><bigspace>


<para>
Ripple torque, or cogging is caused by magnetic attraction of the rotor poles to the stator pole pieces. (Figure<ref>02431.png above</ref>)  Note that there are no stator coils, not even a motor. The PM rotor may be rotated by hand but will encounter attraction to the pole pieces when near them. This is analogous to the mechanical situation. Would ripple torque be a problem for a motor used in a tape player? Yes, we do not want the motor to alternately speed and slow as it moves audio tape past a tape playback head. Would ripple torque be a problem for a fan motor? No.
</para>

<index>Resolver</index>
<index>Optical encoder</index>
<index>Magnetic encoder</index>
<index>Encoder, optical</index>
<index>Encoder, magnetic</index>

<image>02432.png<caption>Windings distributed in a belt produce a more sinusoidal field.</caption></image>


<para>
If a motor is driven by sinewaves of current synchronous with the motor back emf, it is classified as a synchronous AC motor, regardless of whether the drive waveforms are generated by electronic means.  A synchronous motor will generate a sinusoidal back emf if the stator magnetic field has a sinusoidal distribution. It will be more sinusoidal if pole windings are  distributed in a belt (Figure<ref>02432.png above</ref>) across many  slots instead of concentrated on one large pole (as drawn in most of our simplified illustrations). This arrangement cancels many of the stator field odd harmonics. Slots having fewer windings at the edge of the phase winding may share the space with other phases. 
<comment>Split for 2-ref tags</comment>
Winding belts may take on an alternate concentric form as shown in Figure<ref>02487.png below</ref>.  
</para>

<htmlo>
<image>02487.png<caption>Concentric belts.</caption></image>
</htmlo>


<para>
For  a 2-phase motor, driven by a sinewave,  the torque is constant throughout a revolution by the trigonometric identity:

</para>

<literal>
<sp>
<sp>        sin<superscript>2</superscript><theta> + cos<superscript>2</superscript><theta> = 1
<sp>
</literal>


<para>
The generation and synchronization of the drive waveform requires a more precise rotor position indication than provided by the Hall effect sensors used in brushless DC motors. A <italic>resolver</italic>, or <italic>optical or magnetic encoder</italic> provides resolution of hundreds to thousands of parts (pulses) per revolution. A resolver provides analog angular position signals in the form of  signals proportional to the sine and cosine of shaft angle. Encoders provide a digital angular position indication in either serial or parallel format. The sine wave drive may actually be from a PWM, <italic>Pulse Width Modulator</italic>, a high efficiency method of approximating a sinewave with a digital waveform. (Figure<ref>02433.png below</ref>)   Each phase requires drive electronics for this wave form phase-shifted by the appropriate amount per phase.
</para>

<bigspace>
<image>02433.png<caption>PWM approximates a sinewave.</caption></image><bigspace>

<para>
Synchronous motor efficiency is higher than that of induction motors. The synchronous motor can also be smaller, especially if high energy permanent magnets are used in the rotor. The advent of modern solid state electronics makes it possible to drive these motors at variable speed. Induction motors are mostly used in railway traction. However, a small synchronous motor, which mounts inside a drive wheel, makes it attractive for such applications. The <italic>high temperature superconducting</italic> version of this motor is one fifth to one third the weight of a copper wound motor.<cite>1</cite> The largest experimental superconducting synchronous motor is capable of driving a naval destroyer class ship. In all these applications the electronic variable speed drive is essential.
</para>


<para>
The variable speed drive must also reduce the drive voltage at low speed due to decreased inductive reactance at lower frequency. To develop maximum torque, the rotor needs to lag the stator field direction by 90<superscript>o</superscript>. Any more, it loses synchronization. Much less results in reduced torque. Thus, the position of the rotor needs to be known accurately. And the position of the rotor with respect to the stator field needs to be calculated, and controlled. This type of control is known as <italic>vector phase control</italic>. It is implemented with a fast microprocessor driving a pulse width modulator for the stator phases.
</para>

<para>
The stator of a synchronous motor is the same as that of the more popular induction motor. As a result the industrial grade electronic speed control used with induction motors is also applicable to large industrial synchronous motors.
</para>

<para>
If the rotor and stator of a conventional rotary synchronous motor are unrolled, a synchronous linear motor results. This type of motor is applied to precise high speed linear positioning.<cite>2</cite>
</para>


<para>
A larger version of the linear synchronous motor with a movable carriage containing high energy NdBFe permanent magnets is being developed to launch aircraft from naval aircraft carriers.<cite>3</cite>
</para>


</section>

<section>
<sectiontitle>Synchronous condenser</sectiontitle>
<index>Synchronous condenser</index>


<para>
Synchronous motors load the power line with a leading power factor. This is often useful in cancelling out the more commonly encountered lagging power factor caused by induction motors and other inductive loads. Originally, large industrial synchronous motors came into wide use because of this ability to correct the lagging power factor of induction motors. 
</para>

<para>
This leading power factor can be exaggerated by removing the mechanical load and <italic>over exciting</italic> the field of the synchronous motor. Such a device is known as a <italic>synchronous condenser</italic>. Furthermore, the leading power factor can be adjusted by varying the field excitation. This makes it possible to nearly cancel an arbitrary lagging power factor to unity by paralleling the lagging load with a synchronous motor. A synchronous condenser is  operated in a borderline condition between a motor and a generator with no mechanical load to fulfill this function. It can compensate either a leading or lagging power factor, by absorbing or supplying reactive power to the line. This enhances power line voltage regulation.
</para>


<para>
Since a synchronous condenser does not supply a torque, the output shaft may be dispensed with and the unit easily enclosed in a gas tight shell. The synchronous condenser may then be filled with hydrogen to aid cooling and reduce windage losses. Since the density of hydrogen is 7% of that of air, the windage loss for a hydrogen filled unit is 7% of that encountered in air. Furthermore, the thermal conductivity of hydrogen is ten times that of air. Thus, heat removal is ten times more efficient. As a result, a hydrogen filled synchronous condenser can be driven harder than an air cooled unit, or it may be physically smaller for a given capacity. There is no explosion hazard as long as the hydrogen concentration is maintained above 70%, typically above 91%.
</para>

<para>
The efficiency of long power transmission lines may be increased by placing synchronous condensers along the line to compensate lagging currents caused by line inductance. More real power may be transmitted through a fixed size line if the power factor is brought closer to unity by synchronous condensers absorbing reactive power.
</para>


<para>
The ability of synchronous condensers to absorb or produce reactive power on a transient basis stabilizes the power grid against short circuits and other transient fault conditions. Transient sags and dips of milliseconds duration are stabilized. This supplements longer response times of quick acting voltage regulation and excitation of generating equipment. The synchronous condenser aids voltage regulation by drawing leading current when the line voltage sags, which increases generator excitation thereby restoring line voltage. (Figure<ref>02434.png below</ref>) A capacitor bank does not have this ability.
</para>

<image>02434.png<caption>Synchronous condenser improves power line voltage regulation.</caption></image>

<para>
The capacity of a synchronous condenser can be increased by replacing the copper wound iron field rotor with an ironless rotor of <italic>high temperature superconducting wire</italic>, which must be cooled to the liquid nitrogen boiling point of 77<superscript>o</superscript>K (-196<superscript>o</superscript>C). The superconducting wire carries 160 times the current of comparable copper wire, while producing a flux density of 3 Teslas or higher. An iron core would saturate at 2 Teslas in the rotor air gap. Thus, an iron core, approximate <mu><subscript>r</subscript>=1000, is of no more use than air, or any other material with a relative permeability <mu><subscript>r</subscript>=1, in the rotor. Such a machine is said to have considerable additional transient ability to supply reactive power to troublesome loads like metal melting arc furnaces. The manufacturer describes it as being a ``reactive power shock absorber''. Such a synchronous condenser has a higher power density (smaller physically) than a switched capacitor bank. The ability to absorb or produce reactive power on a transient basis stabilizes the overall power grid against fault conditions. 
</para>



</section>

<section>
<sectiontitle>Reluctance motor</sectiontitle>

<index>Switched reluctance motor</index>
<index>Variable reluctance motor</index>
<index>Reluctance motor</index>
<index>Motor, reluctance</index>
<index>Motor, switched reluctance</index>
<index>Motor, variable reluctance</index>
<index>Variable reluctance stepper motor</index>
<index>Stepper motor, variable reluctance</index>
<index>motor, stepper, variable reluctance</index>


<para>
The <italic>variable reluctance motor</italic> is based on the principle that an unrestrained piece of iron will move to complete a magnetic flux path with  minimum <italic>reluctance</italic>, the magnetic analog of electrical resistance. (Figure<ref>02435.png below</ref>)
</para>




<subsection>
<subsectiontitle>Synchronous reluctance</subsectiontitle>

<para>
If the rotating field of a large synchronous motor with salient poles is de-energized, it will still develop 10 or 15% of synchronous torque. This is due to variable reluctance throughout a rotor revolution. There is no practical application for a large synchronous reluctance motor. However, it is practical in small sizes.
</para>

<para>
If slots are cut into the conductorless rotor of an induction motor, corresponding to the stator slots, a <italic>synchronous reluctance motor</italic>  results. It starts like an induction motor but runs with a small amount of synchronous torque. The synchronous torque is due to changes in reluctance of the magnetic path from the stator through the rotor as the slots align. This motor is an inexpensive means of developing a moderate synchronous torque. Low power factor, low pull-out torque, and low efficiency are characteristics of the direct power line driven variable reluctance motor. Such was the status of the variable reluctance motor for a century before the development of semiconductor power control.
</para>

</subsection>


<subsection>
<subsectiontitle>Switched reluctance</subsectiontitle>

<para>
If an iron  rotor with poles, but  without any conductors, is fitted to a multi-phase stator, a <italic>switched reluctance motor</italic>, capable of synchronizing with the stator field results. When a stator coil pole pair is energized, the rotor will move to the lowest magnetic reluctance path. (Figure<ref>02435.png below</ref>)  A switched reluctance motor is also known as a variable reluctance motor. The reluctance of the rotor to stator flux path varies with the position of the rotor.
</para>

<image>02435.png<caption>Reluctance is a function of rotor position in a variable reluctance motor.</caption></image>

<para>
Sequential switching (Figure<ref>02436.png below</ref>) of the stator phases moves the rotor from one position to the next. The mangetic flux seeks the path of least reluctance, the magnetic analog of electric resistance. This is an over simplified rotor and waveforms to illustrate operation. 
</para>

<image>02436.png<caption>Variable reluctance motor, over-simplified operation.</caption></image>

<para>
If one end of each 3-phase winding of the switched reluctance motor is brought out via a common lead wire, we can explain operation as if it were a stepper motor. (Figure<ref>02436.png above</ref>)  The other coil connections are successively pulled to ground, one at a time, in a <italic>wave drive</italic> pattern. This attracts the rotor to the clockwise rotating magnetic field in 60<superscript>o</superscript> increments.
</para>


<para>
Various waveforms may drive variable reluctance motors. (Figure<ref>02511.png below</ref>) Wave drive (a) is simple, requiring only a single ended unipolar  switch. That is, one which only switches in one direction. More torque is provided by the bipolar drive (b), but requires a bipolar switch. The power driver must pull alternately high and low. Waveforms (a & b) are applicable to the stepper motor version of the variable reluctance motor. For smooth vibration free operation the 6-step approximation of a sine wave (c) is desirable and easy to generate. Sine wave drive (d) may be generated by a pulse width modulator (PWM), or drawn from the power line. 
</para>


<image>02511.png<caption>Variable reluctance motor drive waveforms: (a)  unipolar wave drive, (b) bipolar full step (c) sinewave (d) bipolar 6-step.</caption></image>

<para>
Doubling the number of stator poles decreases the rotating speed and increases torque. This might eliminate a gear reduction drive.  A variable reluctance motor intended to move in discrete steps, stop, and start is a <italic>variable reluctance stepper motor</italic>, covered in another section. If smooth rotation is the goal, there is an electronic driven version of the switched reluctance motor. Variable reluctance motors or steppers actually use rotors like those in Figure<ref>02437.png below</ref>.
</para>




</subsection>


<comment>move this to motor drivers in Vol 3</comment>

<subsection>
<subsectiontitle>Electronic driven variable reluctance motor </subsectiontitle>

<para>
Variable reluctance motors are poor performers when direct power line driven. However, microprocessors and solid state power drive makes this motor an economical high performance solution in some high volume applications.
</para>

<para>
Though difficult to control, this motor is easy to spin. Sequential switching of the field coils creates a rotating magnetic field which drags the irregularly shaped rotor around with it as it seeks out the lowest magnetic reluctance path. The relationship between torque and stator current is highly nonlinear-- difficult to control.</para>

<image>02437.png<caption>Electronic driven variable reluctance motor.</caption></image>

<para>
An electronic driven variable reluctance motor (Figure<ref>02438.png below</ref>)  resembles a brushless DC motor without a permanent magnet rotor. This makes the motor simple and inexpensive. However, this is offset by the cost of the electronic control, which is not nearly as simple as that for a brushless DC motor. 
</para>

<para>
While the variable reluctance motor is simple, even more so than an induction motor, it is difficult to control. Electronic control solves this problem and makes it practical to drive the motor well above and below the power line frequency. A variable reluctance  motor driven by a <italic>servo</italic>, an electronic feedback system, controls  torque and speed, minimizing ripple torque. Figure<ref>02438.png below</ref>

</para>

<image>02438.png<caption>Electronic driven variable reluctance motor.</caption></image>

<para>
This is the opposite of the high ripple torque desired in stepper motors. Rather than a stepper, a variable reluctance motor is optimized for continuous high speed rotation with minimum ripple torque. It is necessary to measure the rotor position with a rotary position sensor like an optical or magnetic encoder, or derive this from monitoring the stator back EMF. A microprocessor performs complex calculations for switching the windings at the proper time with solid state devices. This must be done precisely to minimize audible  noise and ripple torque. For lowest ripple torque, winding current must be monitored and controlled. The strict drive requirements make this motor only practical for high volume applications like energy efficient vacuum cleaner motors, fan motors, or pump motors. One such vacuum cleaner uses a compact high efficiency electronic driven 100,000 rpm fan motor. The simplicity of the motor compensates for the drive electronics cost. No brushes, no commutator, no rotor windings, no permanent magnets, simplifies motor manufacture. The efficiency of this electronic driven motor can be  high. But, it requires considerable optimization, using specialized design techniques, which is only justified for large manufacturing volumes.
</para>

<bigspace>
<bold>Advantages</bold>
<itemize>
<item>Simple construction- no brushes, commutator, or permanent magnets, no Cu or Al in the rotor.</item>
<item>High efficiency and reliability compared to conventional AC or DC motors.</item>
<item>High starting torque.</item>
<item>Cost effective compared to bushless DC motor in high volumes.</item>
<item>Adaptable to very high ambient temperature.</item>
<item>Low cost accurate speed control possible if volume is high enough.</item>
</itemize>

<bold>Disadvantages</bold>
<itemize>
<item>Current versus torque is highly  nonlinear</item>
<item>Phase switching must be precise to minimize ripple torque</item>
<item>Phase current must be controlled to minimize ripple torque</item>
<item>Acoustic and electrical noise</item>
<item>Not applicable to low volumes due to complex control issues</item>
</itemize>


</subsection>

</section>



<section>
<sectiontitle>Stepper motors</sectiontitle>

<index>Stepper motor</index>

<para>
A <italic>stepper motor</italic> is a ``digital'' version of the electric motor. The rotor moves in discrete steps as commanded, rather than rotating continuously like a conventional motor. When stopped but energized, a <italic>stepper</italic> (short for stepper motor) holds its load steady with a <italic>holding torque</italic>. Wide spread acceptance of the stepper motor within the last two decades was driven by the ascendancy of digital electronics. Modern solid state driver electronics was a key to its success. And, microprocessors readily interface to stepper motor driver circuits.
</para>

<para>
Application wise, the predecessor of the stepper motor was the servo motor. Today this is a higher cost solution to high performance motion control applications. The expense and complexity of a servomotor is due to the additional system components: position sensor and  error amplifier. (Figure<ref>02439.png below</ref>) It is still the way to position heavy loads beyond the grasp of lower power steppers. High acceleration or unusually high accuracy still requires a servo  motor.  Otherwise, the default is the stepper due to low cost, simple drive electronics, good accuracy, good torque, moderate speed, and low cost.

</para>
<image>02439.png<caption>Stepper motor vs servo motor.</caption></image>

<para>
A stepper motor positions the read-write heads in a floppy drive.  They were once used for the same purpose in harddrives. However, the high speed and accuracy required of modern harddrive head positioning dictates the use of a linear servomotor (voice coil). 
</para>

<para>
The servo amplifier is a linear amplifier with some difficult to integrate discrete components. A considerable design effort is required to optimize the servo amplifier gain vs phase response to the mechanical components. The stepper motor drivers are less complex solid state switches, being either ``on'' or ``off''. Thus, a stepper motor controller is less complex and costly than a servo motor controller. 
</para>

<para>
Slo-syn synchronous motors can run from AC line voltage like a single-phase permanent-capacitor induction motor. The capacitor generates a 90<superscript>o</superscript> second phase. With the direct line voltage, we have a 2-phase drive.   Drive waveforms of <italic>bipolar</italic> (<plusminus>) square waves of 2-24V are more common these days. The bipolar magnetic fields may also be generated from <italic>unipolar</italic> (one polarity) voltages applied to alternate ends of a center tapped winding. (Figure<ref>02440.png below</ref>) In other words, DC can be switched to the motor so that it sees AC. As the windings are energized in sequence, the rotor synchronizes with the consequent stator magnetic field. Thus, we treat stepper motors as a class of AC synchronous motor. 
</para>

<image>02440.png<caption>Unipolar drive of center tapped coil at (b), <sp> emulates AC current in single coil at (a).</caption></image>

<subsection>
<subsectiontitle>Characteristics </subsectiontitle>

<para>
Stepper motors are rugged and inexpensive because the rotor contains no winding slip rings, or commutator. The rotor is a cylindrical solid, which may also have either salient poles or fine teeth. More often than not the rotor is a permanent magnet. Determine that the rotor is a permanent magnet by unpowered hand rotation showing <italic>detent torque</italic>, torque pulsations. Stepper motor coils are wound within a laminated stator, except for <italic>can stack</italic> construction. There may be as few as two winding phases or as many as five. These phases are frequently split  into pairs. Thus, a 4-pole stepper motor may have two phases composed of in-line pairs of poles spaced 90<superscript>o</superscript> apart. There may also be multiple pole pairs per phase. For example a 12-pole stepper has 6-pairs of poles, three pairs per phase.
</para>

<para>
Since stepper motors do not necessarily rotate continuously, there is no horsepower rating. If they do rotate continuously, they do not even approach a sub-fractional hp rated capability. They are truly small low power devices compared to other motors. They have torque ratings to a thousand  in-oz (inch-ounces) or ten n-m (newton-meters) for a 4 kg size unit. A small ``dime'' size stepper has a torque of a hundredth of a newton-meter or a few inch-ounces. Most steppers are a few inches in diameter with a fraction of a n-m or a few in-oz torque. The torque available is a function of motor speed, load inertia, load torque, and drive electronics as illustrated on the <italic>speed vs torque curve</italic>. (Figure<ref>02441.png below</ref>)  An energized, holding stepper has a relatively high <italic>holding torque</italic> rating. There is less torque available for a running motor, decreasing to zero at some high speed. This speed is frequently not attainable due to mechanical resonance of the motor load combination.
</para>

<image>02441.png<caption>Stepper speed characteristics.</caption></image>

<para>
Stepper motors move one step at a time, the <italic>step angle</italic>, when the drive waveforms are changed. The step angle is related to motor construction details: number of coils, number of poles, number of teeth. It can be from 90<superscript>o</superscript> to 0.75<superscript>o</superscript>, corresponding to 4 to 500 steps per revolution. Drive electronics may halve the step angle by moving the rotor in <italic>half-steps</italic>.
</para>

<para>

Steppers cannot achieve the speeds on the speed torque curve instantaneously. The <italic>maximum start frequency</italic> is the highest rate at which a stopped and unloaded stepper can be started. Any load will make this parameter unattainable. In practice, the step rate is ramped up during starting from well below the maximum start frequency.  When stopping a stepper motor, the step rate may be decreased before stopping.
</para> 

<para>
 The maximum torque at which a stepper can start and stop is the <italic>pull-in torque</italic>. This torque load on the stepper is due to frictional (brake) and inertial (flywheel) loads on the motor shaft. Once the motor is up to speed, <italic>pull-out torque</italic> is the maximum sustainable torque without losing steps. 
</para>

<para>
There are three types of stepper motors in order of increasing complexity: variable reluctance, permanent magnet, and hybrid. The variable reluctance stepper has s solid soft steel rotor with salient poles. The permanent magnet stepper has a cylindrical permanent magnet rotor. The hybrid stepper has soft steel teeth added to the permanent magnet rotor for a smaller step angle.
</para>

</subsection>



<subsection>
<subsectiontitle>Variable reluctance stepper</subsectiontitle>

<index>Variable reluctance stepper motor</index>
<index>Stepper motor, variable reluctance</index>
<index>Motor, stepper, variable reluctance</index>

<para>
A <italic>variable reluctance stepper motor</italic> relies upon magnetic flux seeking the lowest reluctance path through a magnetic circuit. This means that an irregularly shaped soft magnetic rotor will move to complete a magnetic circuit, minimizing the length of any high reluctance air gap. The stator typically has three windings distributed between pole pairs , the rotor four salient poles, yielding a 30<superscript>o</superscript> step angle.(Figure<ref>02442.png below</ref>)  A de-energized stepper with no detent torque when hand rotated is identifiable as a variable reluctance type stepper.
</para>

<image>02442.png<caption>Three phase and four phase variable reluctance stepper motors.</caption></image>

<para>
The drive waveforms for the 3-<phi> stepper can be seen in the ``Reluctance motor'' section. The drive for a 4-<phi> stepper is shown in Figure<ref>02443.png below</ref>. Sequentially switching the stator phases produces a rotating magnetic field which the rotor follows. However, due to the lesser number of rotor poles, the rotor moves less than the stator angle for each step. For a variable reluctance stepper motor, the step angle is given by:
</para>

<bigspace>
<literal>
<sp>      <THETA><subscript>S</subscript> = 360<superscript>o</superscript>/N<subscript>S</subscript>
<sp>      <THETA><subscript>R</subscript> = 360<superscript>o</superscript>/N<subscript>R</subscript>
<sp>      <THETA><subscript>ST</subscript> =  <THETA><subscript>R</subscript> -  <THETA><subscript>S</subscript> 
<sp>      where:  <THETA><subscript>S</subscript> = stator angle,          <THETA><subscript>R</subscript> = Rotor angle,     <THETA><subscript>ST</subscript> = step angle 
<sp>              N<subscript>S</subscript> = number stator poles,    N<subscript>P</subscript> = number rotor poles


</literal>


<image>02443.png<caption>Stepping sequence for variable reluctance stepper.</caption></image>


<para>
In Figure<ref>02443.png above</ref>, moving from <phi><subscript>1</subscript> to  <phi><subscript>2</subscript>, etc., the stator magnetic field rotates clockwise. The rotor moves counterclockwise (CCW). Note what does not happen! The dotted rotor tooth does not move to the next stator tooth. Instead, the <phi><subscript>2</subscript> stator field attracts a different tooth in moving the rotor CCW, which is a smaller angle (15<superscript>o</superscript>) than the stator angle of 30<superscript>o</superscript>.  The rotor tooth angle of 45<superscript>o</superscript> enters into the calculation by the above equation. The rotor moved CCW to the next rotor tooth at 45<superscript>o</superscript>, but it aligns with a CW by 30<superscript>o</superscript> stator tooth. Thus, the actual step angle is the difference between a  stator angle of 45<superscript>o</superscript> and a rotor angle of 30<superscript>o</superscript> . How far would the stepper rotate if the rotor and stator had the same number of teeth? Zero-- no rotation.
</para>

<para>
Starting at rest with phase <phi><subscript>1</subscript> energized, three pulses are required (<phi><subscript>2</subscript>, <phi><subscript>3</subscript>, <phi><subscript>4</subscript>) to align the ``dotted'' rotor tooth to the next CCW stator tooth, which is 45<superscript>o</superscript>. With 3-pulses per stator tooth, and 8-stator teeth, 24-pulses or steps move the rotor through 360<superscript>o</superscript>. 
</para>


<para>
By reversing the sequence of pulses, the direction of rotation is reversed above right. The direction, step rate, and number of steps are controlled by a stepper motor controller feeding a driver or amplifier. This could be combined into a single circuit board. The controller could be a microprocessor or a specialized integrated circuit. The driver is not a linear amplifier, but a simple on-off switch capable of high enough current to energize the stepper. In principle, the driver could be a relay or even a toggle switch for each phase. In practice, the driver is either discrete transistor switches or an integrated circuit. Both driver and controller may be combined into a single integrated circuit accepting a direction command and step pulse. It outputs current to the proper phases in sequence.
</para>

<image>02444.png<caption>Variable reluctance stepper motor.</caption></image>

<para>
Disassemble a reluctance stepper to view the internal components. Otherwise,  we show the internal construction of a variable reluctance stepper motor in Figure<ref>02444.png above</ref>. The rotor has protruding poles so that they may be attracted to the rotating stator field as it is switched. An actual motor, is much longer than our simplified illustration. 

<image>02445.png<caption>Variable reluctance stepper drives lead screw.</caption></image>


<para>
The shaft is frequently fitted with a drive screw. (Figure<ref>02445.png above</ref>) This may move the heads of a floppy drive upon command by the floppy drive controller. 
</para>
</para>


<para>
Variable reluctance stepper motors are applied when only a moderate level of torque is required and a coarse step angle is adequate. A screw drive, as used in a floppy disk drive is such an application. When the controller powers-up, it does not know the position of the carriage. However, it can drive the carriage toward the optical interrupter, calibrating the position at which the knife edge cuts the interrupter as ``home''. The controller counts step pulses from this position. As long as the load torque does not exceed the motor torque, the controller will know the carriage position.
</para>

<bigspace>
<bold>Summary: variable reluctance stepper motor</bold>

<itemize>
<item>The rotor is a soft iron cylinder with salient (protruding) poles.</item>
<item>This is the least complex, most inexpensive stepper motor.</item>
<item>The only type stepper with no detent torque in hand rotation of a de-energized motor shaft.</item>
<item>Large step angle</item>
<item>A lead screw is often mounted to the shaft for linear stepping motion.</item>
</itemize>


</subsection>

<subsection>
<subsectiontitle>Permanent magnet stepper </subsectiontitle>

<index>Permanent magnet stepper motor</index>
<index>stepper motor, permanent magnet</index>
<index>motor, stepper, permanent magnet</index>

<para>
A <italic>permanent magnet stepper motor</italic> has a cylindrical permanent magnet rotor. The stator usually has two windings. The windings could be center tapped to allow for a <italic>unipolar</italic> driver circuit where the polarity of the magnetic field is changed by switching a voltage from one end to the other of the winding. A <italic>bipolar</italic> drive of alternating polarity is required to power windings without the center tap. A pure permanent magnet stepper usually has a large step angle. Rotation of the shaft of a de-energized motor exhibits detent torque. If the detent angle is large, say 7.5<superscript>o</superscript> to 90<superscript>o</superscript>, it is likely a permanent magnet stepper rather than a hybrid stepper (next subsection).
</para>


<para>
Permanent magnet stepper motors require phased alternating currents applied to the two (or more) windings. In practice, this is almost always square waves generated from DC by solid state electronics. <italic>Bipolar</italic> drive is square waves alternating between (+) and (-) polarities, say, +2.5 V to -2.5 V.  <italic>Unipolar</italic> drive supplies a (+) and (-) alternating  magnetic flux to the coils  developed from a pair of positive square waves applied to opposite ends of a center tapped coil. The timing of the bipolar or unipolar wave is wave drive, full step, or half step.
</para>


<subsubsection>
<subsubsectiontitle>Wave drive </subsubsectiontitle>



<image>02446.png<caption>PM wave drive sequence (a) <phi><subscript>1</subscript>+ ,<sp><sp> (b) <phi><subscript>2</subscript>+ ,<sp><sp> (c) <phi><subscript>1</subscript>- ,<sp><sp>(d) <phi><subscript>2</subscript>-.</caption></image>

<para>
Conceptually, the simplest drive is <italic>wave drive</italic>. (Figure<ref>02446.png above</ref>) The rotation sequence left to right is positive <phi>-1 points rotor north pole up, (+) <phi>-2 points rotor north right, negative <phi>-1 attracts rotor north down, (-) <phi>-2 points rotor left. The wave drive waveforms below show that only one coil is energized at a time. While simple, this does not produce as much torque as other drive techniques.
</para>


<image>02447.png<caption>Waveforms: bipolar wave drive.</caption></image>

<para>
The waveforms (Figure<ref>02447.png above</ref>) are bipolar because both polarities , (+) and (-) drive the stepper. The coil magnetic field reverses because the polarity of the drive current reverses.</para>

<image>02448.png<caption>Waveforms: unipolar wave drive.</caption></image>

<para>
The (Figure<ref>02448.png above</ref>) waveforms are unipolar because only one polarity is required. This simplifies the drive electronics, but requires twice as many drivers. There are twice as many waveforms because a pair of (+) waves is required to produce an alternating magnetic field by application to opposite ends of a center tapped coil. The motor requires alternating magnetic fields. These may be produced by either unipolar or bipolar waves. However, motor coils must have center taps for unipolar drive. 
</para>

<para>
Permanent magnet stepper motors are manufactured with various lead-wire configurations. (Figure<ref>02449.png below</ref>)
</para>

<image>02449.png<caption>Stepper motor wiring diagrams.</caption></image>

<para>
The 4-wire motor can only be driven by bipolar waveforms. The 6-wire motor, the most common arrangement, is intended for unipolar drive because of the center taps. Though, it may be driven by bipolar waves if the center taps are ignored. The 5-wire motor can only be driven by unipolar waves, as the common center tap interferes if both windings are energized simultaneously. The 8-wire configuration is rare, but provides maximum flexibility. It may be wired for unipolar drive as for the 6-wire or 5-wire motor. A pair of coils may be connected in series for high voltage bipolar low current drive, or in parallel for low voltage high current drive. 
</para>

<index>Bifilar winding, stepper motor</index> 
<index>Stepper motor, bifilar winding</index> 

<para>
A <italic>bifilar winding</italic> is produced by winding the coils with two wires in parallel, often a red and green enamelled wire. This method produces exact 1:1 turns ratios for center tapped windings. This winding method is applicable to all but the 4-wire arrangement above.
</para>


</subsubsection>



<subsubsection>
<subsubsectiontitle>Full step drive </subsubsectiontitle>

<para>
<italic>Full step</italic> drive provides more torque than wave drive because both coils are energized at the same time. This attracts the rotor poles midway between the two field poles. (Figure<ref>02450.png below</ref>)
</para>


<image>02450.png<caption>Full step, bipolar drive.</caption></image>

<para>
Full step bipolar drive as shown in Figure<ref>02450.png above</ref> has the same step angle as wave drive. Unipolar drive (not shown) would require a pair of unipolar waveforms for each of the above bipolar waveforms applied to the ends of a center tapped winding. Unipolar drive uses a less complex, less expensive driver circuit. The additional cost of bipolar drive is justified when more torque is required.
</para>

</subsubsection>


<subsubsection>
<subsubsectiontitle>Half step drive</subsubsectiontitle>

<para>
The step angle for a given stepper motor geometry is cut in half with <italic>half step</italic> drive. This corresponds to twice as many step pulses per revolution. (Figure<ref>02451.png below</ref>) Half stepping provides greater resolution in  positioning of the motor shaft. For example, half stepping the motor moving the print head across the paper of an inkjet printer would double the dot density.
</para>


<image>02451.png<caption>Half step, bipolar drive.</caption></image>

<para>
Half step drive is a combination of wave drive and full step drive with one winding energized, followed by both windings energized, yielding twice as many steps. The unipolar waveforms for half step drive are shown above. The rotor aligns with the field poles as for wave drive and between the poles as for full step drive. 
</para>


<para>
Microstepping is possible with specialized controllers. By varying the currents to the windings sinusoidally many microsteps can be interpolated between the normal  positions.
</para>


</subsubsection>


<subsubsection>
<subsubsectiontitle>Construction </subsubsectiontitle>

<para>
The contruction of a permanent magnet stepper motor is considerably different from the drawings above. It is desirable to increase the number of poles beyond that illustrated to produce a smaller step angle. It is also desirable to reduce the number of windings, or at least not increase the number of windings for ease of manufacture.
</para>

<index>Stepper motor, can stack</index>
<index>Can stack, stepper motor</index>

<image>02452.png<caption>Permanent magnet stepper motor, 24-pole  can-stack construction.</caption></image>

<para>
The permanent magnet stepper (Figure<ref>02452.png above</ref>) only has two windings, yet has 24-poles in each of two phases. This style of construction is known as <italic>can stack</italic>. A phase winding is  wrapped with a mild steel shell, with fingers brought to the center. One phase, on a transient basis,  will have a north side and a south side. Each side wraps around to the center of the doughnut with twelve interdigitated fingers for a total of 24 poles. These alternating north-south fingers will attract the permanent magnet rotor. If the polarity of the phase were reversed, the rotor would jump 360<superscript>o</superscript>/24 = 15<superscript>o</superscript>. We do not know which direction, which is not useful. However, if we energize <phi>-1 followed by <phi>-2, the rotor will move 7.5<superscript>o</superscript> because the <phi>-2 is offset (rotated) by 7.5<superscript>o</superscript> from <phi>-1. See below for offset. And, it will rotate in a reproducible direction if the phases are alternated. Application of any of the above waveforms will rotate the permanent magnet rotor.
</para>

<para>
Note that the rotor is a gray ferrite ceramic cylinder magnetized in the 24-pole pattern shown. This can be viewed with magnet viewer film or iron filings applied to a paper wrapping. Though, the colors will be green for both north and south poles with the film. 
</para>

<image>02453.png<caption>(a) External view of can stack, <sp><sp>(b) field offset detail.</caption></image>

<para>
Can-stack style construction of a PM stepper is distinctive and easy to identify by the stacked ``cans''. (Figure<ref>02453.png above</ref>) Note the rotational offset between the two phase sections. This is key to making the rotor follow the switching of the fields between the two phases.
</para>


</subsubsection>

</subsection>

<bigspace>
<bold>Summary: permanent magnet stepper motor</bold>

<itemize>
<item>The rotor is a permanent magnet, often a ferrite sleeve magnetized with numerous poles.</item>
<item>Can-stack construction provides numerous poles from a single coil with interleaved fingers of soft iron.</item>
<item>Large to moderate step angle.</item>
<item>Often used in computer printers to advance paper.</item>
</itemize>

<subsection>
<subsectiontitle>Hybrid stepper motor</subsectiontitle>

<index>Hybrid stepper motor</index>

<index>Stepper motor, hybrid</index>
<index>Bifilar winding, stepper motor</index>
<index>Stepper motor, bifilar winding</index>
<index>Motor, stepper, hybrid</index>

<para>
The <italic>hybrid stepper motor</italic> combines features of both the variable reluctance stepper and the permanent magnet stepper to produce a smaller step angle. The rotor is a cylindrical permanent magnet, magnetized along the axis with radial soft iron teeth (Figure<ref>02454.png below</ref>). The stator coils are wound on alternating poles with corresponding teeth. There are typically two winding phases distributed between pole pairs. This winding may be center  tapped  for unipolar drive. The center tap is achieved by a <italic>bifilar winding</italic>, a pair of wires wound physically in parallel, but wired in series. The north-south poles of a phase swap polarity when the phase drive current is reversed. Bipolar drive is required for un-tapped windings.
</para>



<image>02454.png<caption>Hybrid stepper motor.</caption></image>

<para>
Note that the 48-teeth on one rotor section are offset by half a pitch from the other. See rotor pole detail above. This rotor tooth offset is also shown below. Due to this offset, the rotor effectively has 96 interleaved poles of opposite polarity. This offset allows for rotation in 1/96 th of a revolution steps by reversing the field polarity of one phase. Two phase windings are common as shown above and below. Though, there could be as many as five phases.
</para>

<para>
The stator teeth on the 8-poles correspond to the 48-rotor teeth, except for missing teeth in the space between the poles. Thus, one pole of the rotor, say the south pole, may align with the stator in 48 distinct positions. However, the teeth of the south pole are offset from the north teeth by half a tooth. Therefore, the rotor may align with the stator in 96 distinct positions. This half tooth offset shows in the rotor pole detail above, or Figure<ref>02445.png below</ref>.
</para>

<para>
As if this were not complicated enough, the stator main poles are divided into two phases (<phi>-1, <phi>-2). These stator phases are offset from one another by one-quarter of a tooth. This detail is only discernable on the  schematic diagrams below. The result is that the rotor moves in steps of a quarter of a tooth when the phases are alternately energized. In other words, the rotor moves in 2<times>96=192 steps per revolution for the above stepper. 
</para>

<para>
The above drawing is representative of an actual hybrid stepper motor. However, we provide a simplified pictorial and schematic representation  (Figure<ref>02455.png below</ref>) to illustrate details not obvious above. Note the reduced number of coils and teeth in rotor and stator for simplicity. In the next two figures, we attempt to illustrate the quarter tooth rotation produced by the two stator phases offset by a quarter tooth, and the rotor half tooth offset. The quarter tooth stator offset in conjunction with drive current timing  also defines direction of rotation.
</para>


<image>02455.png<caption>Hybrid stepper motor schematic diagram.</caption></image>

<bold>Features of hybrid stepper schematic</bold> (Figure<ref>02455.png above</ref>)

<itemize>
<item>The top of the permanent magnet rotor is the south pole, the bottom north.</item>
<item>The rotor north-south teeth are offset by half a tooth.</item>

<item>If the <phi>-1 stator is temporarily energized north top, south bottom.</item>
<item>The top <phi>-1 stator teeth align north to rotor top south teeth.</item>
<item>The bottom <phi>-1' stator teeth align south to rotor bottom north teeth.</item>

<item>Enough torque applied to the shaft to overcome the hold-in torque would move the rotor by one tooth.</item>
<item>If the polarity of <phi>-1 were reversed, the rotor would move by one-half tooth, direction unknown. The alignment would be south stator top to north rotor bottom, north stator bottom to south rotor.</item>
<item>The <phi>-2 stator teeth are not aligned with the rotor teeth when <phi>-1 is energized. In fact, the <phi>-2 stator teeth are offset by one-quarter tooth. This will allow for rotation by that amount if <phi>-1 is de-energized and <phi>-2 energized. Polarity of <phi>-1 and <phi>-2 drive determines direction of rotation.</item>
</itemize>



<image>02456.png<caption>Hybrid stepper motor rotation sequence.</caption></image>


<bold>Hybrid stepper motor rotation</bold> (Figure<ref>02456.png above</ref>)

<itemize>
<item>Rotor top is permanent magnet south, bottom north. Fields <phi>-1, <phi>-2 are switchable: on, off, reverse.</item>

<item><bold>(a)</bold> <phi>-1=on=north-top, <phi>-2=off. <bold>Align (top to bottom):</bold> <phi>-1 stator-N:rotor-top-S, <phi>-1' stator-S: rotor-bottom-N. Start position, rotation=0.</item>

<item><bold>(b)</bold> <phi>-1=off, <phi>-2=on. <bold>Align (right to left):</bold> <phi>-2 stator-N-right:rotor-top-S, <phi>-2' stator-S: rotor-bottom-N. Rotate 1/4 tooth, total rotation=1/4 tooth.</item>

<item><bold>(c)</bold> <phi>-1=reverse(on), <phi>-2=off. <bold>Align (bottom to top):</bold> <phi>-1 stator-S:rotor-bottom-N, <phi>-1' stator-N:rotor-top-S. Rotate 1/4 tooth from last position. Total rotation from start: 1/2 tooth.</item>

<item>Not shown: <phi>-1=off, <phi>-2=reverse(on). <bold>Align (left to right):</bold> Total rotation: 3/4 tooth.</item>
<item>Not shown: <phi>-1=on, <phi>-2=off (same as (a)). <bold>Align (top to bottom): </bold>Total rotation 1-tooth.</item>

</itemize>


<para>
An un-powered stepper motor with detent torque is either a permanent magnet stepper or a hybrid stepper. The hybrid stepper will have a small step angle, much less than the 7.5<superscript>o</superscript> of permanent magnet steppers.  The step angle could be a fraction of a degree, corresponding to a few hundred steps per revolution.
</para>


<bigspace>
<bold>Summary: hybrid stepper motor</bold>


<itemize>
<item>The step angle is smaller than variable reluctance or permanent magnet steppers.</item>
<item>The rotor is a permanent magnet with fine teeth. North and south teeth are offset by half a tooth for a smaller step angle.</item>
<item>The stator poles have matching fine teeth of the same pitch as the rotor.</item>
<item>The stator windings are divided into no less than two phases.</item>
<item>The poles of one stator windings are offset by a quarter tooth for an even smaller step angle.</item>
</itemize>



</subsection>




</section>

<section>
<sectiontitle>Brushless DC motor</sectiontitle>

<index>Brushless DC motor</index>
<index>Motor, DC, brushless</index> 

<para>Brushless DC motors were developed from conventional brushed DC motors with the availability of solid state power semiconductors. So, why do we discuss brushless DC motors in a chapter on AC motors? Brushless DC motors are similar to AC synchronous motors. The major difference is that synchronous motors develop a sinusoidal back EMF, as compared to a rectangular, or trapezoidal, back EMF for brushless DC motors.  Both have stator created rotating magnetic fields producing torque in a magnetic rotor. 
</para>

<para>

Synchronous motors are usually large multi-kilowatt size, often with electromagnet rotors. True synchronous motors are considered to be single speed, a submultiple of the powerline frequency. Brushless DC motors tend to be small-- a few watts to tens of watts, with permanent magnet rotors. The speed of a brushless DC motor is not fixed unless driven by a phased locked loop slaved to a reference frequency. The style of construction is either cylindrical or pancake. (Figures<ref>02457.png </ref>
<comment>split</comment>
and <ref>02458.png below</ref>)

</para>

<image>02457.png<caption>Cylindrical construction: (a) outside rotor,  (b) inside rotor.</caption></image>

<para>
The most usual construction, cylindrical,  can take on two forms (Figure<ref>02457.png above</ref>).  The most common cylindrical style is with the rotor on the inside, above right. This style motor is used in hard disk drives. It is also possible to put the rotor on the outside surrounding the stator. Such is the case with brushless DC fan motors, sans the shaft. This style of construction may be short and fat. However, the direction of the magnetic flux is radial with respect to the rotational axis.
</para>

<image>02458.png<caption>Pancake motor construction: (a) single stator, (b) double stator.</caption></image>

<para>High torque pancake motors may have stator coils on both sides of the rotor (Figure<ref>02458.png above</ref>-b).

<comment>We have split the paragraph because we have two ref-tags. Can only handle one per line in sml2latx.sed. It still looks like one P in output</comment>

Lower torque applications like floppy disk drive motors suffice with a stator coil on one side of the rotor, (Figure<ref>02458.png above</ref>-a). The direction of the magnetic flux is axial, that is, parallel to the axis of rotation.
</para>

<para>The commutation function may be performed by various shaft  position sensors: optical encoder, magnetic encoder (resolver, synchro, etc), or Hall effect magnetic sensors. Small inexpensive motors use Hall effect sensors. (Figure<ref>02459.png below</ref>) A Hall effect sensor is a semiconductor device where the electron flow is affected by a  magnetic field perpendicular to the direction of current flow.. It looks like a four terminal variable resistor network. The voltages at the two outputs are complementary. Application of a magnetic field to the sensor causes a small voltage change at the output. The Hall output may drive a comparator to provide for more stable drive to the power device. Or, it may drive a compound transistor stage if properly biased. More modern Hall effect sensors may contain an integrated  amplifier, and digital circuitry. This 3-lead device may directly drive the power transistor feeding a phase winding.  The sensor must be mounted close to the permanent magnet rotor to sense its position.
</para>

<image>02459.png<caption>Hall effect sensors commutate 3-<phi> brushless DC motor.</caption></image>

<para>The simple cylindrical 3-<phi> motor Figure<ref>02459.png above</ref> is commutated by a Hall effect device for each of the three stator phases. The changing position of the permanent magnet rotor is sensed by the Hall device as the polarity of the passing rotor pole changes. This Hall signal is amplified so that the stator coils are driven with the proper current.  Not shown here, the Hall signals may be processed by combinatorial logic for more efficient drive waveforms. 
</para>



<para>
The above cylindrical motor could drive a harddrive if it were equipped with a phased locked loop (PLL) to maintain constant speed. Similar circuitry could drive the pancake floppy disk drive motor (Figure<ref>02460.png below</ref>). Again, it would need a PLL to maintain constant speed.
</para>


<image>02460.png<caption>Brushless pancake motor</caption></image>

<para>
The 3-<phi> pancake motor (Figure<ref>02460.png above</ref>)  has 6-stator poles and 8-rotor poles. The rotor is a flat ferrite ring magnetized with eight axially magnetized alternating poles. We do not show that the rotor is capped by a mild steel plate for mounting to the bearing in the middle of the stator. The steel plate also helps complete the magnetic circuit. The stator poles are also mounted atop a steel plate, helping to close the magnetic circuit. The flat stator coils are trapezoidal to more closely fit the coils, and approximate the rotor poles.  The 6-stator coils comprise three winding phases. 
</para>

<para>
If the three stator phases were successively energized, a rotating magnetic field would be generated. The permanent magnet rotor would follow as in the case of a synchronous motor.  A two pole rotor would follow this field at the same rotation rate as the rotating field.  However, our 8-pole rotor will rotate at a  submultiple of this rate due the the extra poles in the rotor.
</para>

<para>
The brushless DC fan motor (Figure<ref>02461.png below</ref>) has these feature:
</para>



<image>02461.png<caption>Brushless fan motor, 2-<phi>.</caption></image>
<itemize>
<item>The stator has 2-phases distributed between 4-poles</item>
<item>There are 4-salient poles with no windings to eliminate zero torque points.</item>
<item>The rotor has four main drive poles.</item>

<item>The rotor has 8-poles superimposed to help eliminate zero torque points.</item>
<item>The Hall effect sensors are spaced at 45<superscript>o</superscript> physical.</item>
<item>The fan housing is placed atop the rotor, which is placed over the stator.</item>
</itemize>



<para>
The goal of a brushless fan motor is to minimize the cost of manufacture. This is an incentive to move lower performance products from a 3-<phi> to a 2-<phi> configuration. Depending on how it is driven, it may be called a 4-<phi> motor. 
</para>

<para>
You may recall that conventional DC motors cannot have an even number of armature poles (2,4, etc) if they are to be self-starting, 3,5,7 being common. Thus, it is possible for a hypothetical 4-pole motor to come to rest at a torque minima, where it cannot be started from rest. The addition of the four small salient poles with no windings superimposes a ripple torque upon the torque vs position curve. When this ripple torque is added to normal energized-torque curve, the result is that torque minima are partially removed. This makes it possible to start the motor for all possible stopping positions. The addition of eight permanant magnet poles to the normal 4-pole permanent magnet rotor superimposes a small second harmonic ripple torque upon the normal 4-pole ripple torque. This further removes the torque minima. As long as the torque minima does not drop to zero, we should be able to start the motor. The more successful we are in removing the torque minima, the easier the motor starting. 
</para>


<para>
The 2-<phi> stator requires that the Hall sensors be spaced apart by 90<superscript>o</superscript> electrical. If the rotor was a 2-pole rotor, the Hall sensors would be placed 90<superscript>o</superscript> physical. Since we have a 4-pole permanent magnet rotor, the sensors must be placed 45<superscript>o</superscript> physical to achieve the 90<superscript>o</superscript> electrical spacing. Note Hall spacing above. The majority of the torque is due to the interaction of the inside stator 2-<phi> coils with the 4-pole section of the rotor. Moreover, the 4-pole section of the rotor must be on the bottom so that the Hall sensors will sense the proper commutation signals. The 8-poles rotor section is only for improving motor starting.
</para>


<image>02462.png<caption>Brushless DC motor 2-<phi> push-pull drive.</caption></image>


<para>
In Figure<ref>02462.png above</ref>, the 2-<phi> push-pull drive (also known as 4-<phi> drive) uses two Hall effect sensors to drive four windings. The sensors are spaced 90<superscript>o</superscript> electrical apart, which is 90<superscript>o</superscript> physical for a single pole rotor. Since the Hall sensor has two complementary outputs, one sensor provides commutation for two opposing windings.
</para>


</section>





<section> 

<sectiontitle>Tesla polyphase induction motors </sectiontitle>

<index>Poly-phase induction motor</index>
<index>Induction motor, poly-phase</index>

<para>
Most AC motors are induction motors. Induction motors are favored due to their ruggedness and simplicity.  In fact, 90% of industrial motors are induction motors.
</para>


<index>Tesla, Nikola</index>
<index>Induction motor, 2-phase</index>

<para>
Nikola Tesla conceived the basic principals of the polyphase induction motor in 1883, and had a half horsepower (400 watt) model by 1888. Tesla sold the manufacturing rights to George Westinghouse for $65,000.
</para>


<para>
Most large ( <gt> 1 hp or 1 kW) industrial motors are <italic>poly-phase induction motors</italic>. By poly-phase, we mean that the stator contains multiple distinct windings per motor pole, driven by corresponding time shifted sine waves. In practice, this is two or three phases. Large industrial motors are 3-phase. While we include numerous illustrations of two-phase motors for simplicity, we must emphasize that nearly all poly-phase motors are three-phase.   By <italic>induction motor</italic>, we mean that the stator windings induce a current flow in the rotor conductors, like a transformer, unlike a brushed DC commutator motor.
</para>


<subsection>
<subsectiontitle>Construction</subsectiontitle>

<para>
An induction motor is composed of a rotor, known as an armature, and a stator containing windings connected to a poly-phase energy source as shown in Figure<ref>02463.png below</ref>. The simple 2-phase induction motor below is similar to the 1/2 horsepower motor which Nikola Tesla introduced in 1888.
</para>

<para>
<image>02463.png<caption>Tesla polyphase induction motor.</caption></image>
</para>

<para>
The stator in Figure<ref>02463.png above</ref> is wound with pairs of coils corresponding to the phases of electrical energy available. The 2-phase induction motor stator above has 2-pairs of coils, one pair for each of the two phases of AC. The individual coils of a pair are connected in series and correspond to the opposite poles of an electromagnet. That is, one coil corresponds to a N-pole, the other to a S-pole until the phase of AC changes polarity. The other pair of coils is oriented 90<superscript>o</superscript> in space to the first pair.  This  pair of coils is connected to AC shifted in time by 90<superscript>o</superscript> in the case of a 2-phase motor. In Tesla's time, the source of the two phases of AC was a 2-phase alternator.
</para>

<para>
The stator in Figure<ref>02463.png above</ref> has <italic>salient</italic>, obvious protruding poles, as used on Tesla's early induction motor. This design is used to this day for sub-fractional horsepower motors (<lt>50 watts).
<comment>split for two ref-tags</comment>
However, for larger motors less torque pulsation and higher efficiency results if the coils are embedded into slots cut into the stator laminations. (Figure<ref>02464.png below</ref>)
</para>

<para>
<image>02464.png<caption>Stator frame showing slots for windings.</caption></image>
</para>

<para>
 The stator laminations are thin insulated rings with slots punched from sheets of  electrical grade  steel. A stack of these is secured by end screws, which may also hold the end housings. </para>


<para>
<image>02465.png<caption>Stator with (a) 2-<phi> and (b) 3-<phi> windings.</caption></image>
</para>

<para>
In  Figure<ref>02465.png above</ref>, the windings for both a two-phase motor and a three-phase motor have been installed in the stator slots.  The coils are wound on an external fixture, then worked into the slots. Insulation wedged between the coil periphery and the slot protects against abrasion.
</para>

<para>
Actual stator windings are more complex than the  single windings per pole in  Figure<ref>02465.png above</ref>. Comparing the 2-<phi> motor to Tesla's 2-<phi> motor with salient poles, the number of coils is the same.   In actual large motors, a pole winding,  is divided into identical coils inserted into many smaller slots than above. 
<comment>split for two ref-tags</comment>
This group is called a <italic>phase belt</italic>. See Figure<ref>02432.png below</ref>.  The distributed coils of the phase belt cancel some of the odd harmonics, producing a more sinusoidal magnetic field distribution across the pole. This is shown in the synchronous motor section. The slots at the edge of the pole may have fewer turns than the other slots. Edge slots may contain windings from two phases. That is, the phase belts overlap. 
</para>

<htmlo>
<comment>html only, repeated in synchronous motors section. not in latex</comment>
<image>02432.png<caption></caption></image>
</htmlo>



<para>
The key to the popularity of the AC induction motor is simplicity as evidenced by the simple rotor (Figure<ref>02466.png below</ref>). The rotor consists of a shaft, a steel laminated rotor, and an embedded copper or aluminum <italic>squirrel cage</italic>, shown at (b) removed from the rotor. As compared to a DC motor armature, there is no commutator. This eliminates the brushes, arcing, sparking, graphite dust, brush adjustment and replacement, and re-machining of the commutator.
</para>

<image>02466.png<caption>Laminated rotor with (a) embedded squirrel cage, (b) conductive cage removed from rotor.</caption></image>

<index>Eddy current</index>

<para>
The squirrel cage conductors may be skewed, twisted, with respsect to the shaft. The misalignment with the stator slots reduces torque pulsations.
</para>

<para>
Both rotor and stator cores are composed of a stack of insulated laminations. The laminations are coated with insulating oxide or varnish to minimize eddy current losses. The alloy used in the laminations is selected for low hysteresis losses.
</para>

</subsection>


<subsection>
<subsectiontitle>Theory of operation </subsectiontitle>

<index>Lenz's Law</index>

<para>
A short explanation of operation is that the stator creates a rotating magnetic field which drags the rotor around.
</para>

<para>
The theory of operation of induction motors is based on a rotating magnetic field. One means of creating a rotating magnetic field is to rotate a permanent magnet as shown in Figure<ref>02467.png below</ref>. If the moving magnetic lines of flux cut a conductive disk, it will follow the motion of the magnet. The lines of flux cutting the conductor will induce a voltage, and consequent current flow, in the conductive disk. This current flow creates an electromagnet whose polarity opposes the motion of the permanent magnet-- <italic>Lenz's Law</italic>. The polarity of the electromagnet is such that it pulls against the permanent magnet. The disk follows with a little less speed than the permanent magnet.
</para>

<image>02467.png<caption>Rotating magnetic field produces torque in conductive disk.</caption></image>

<index>Speedometer, eddy current</index>
<index>Eddy current speedometer</index>

<para>
The torque developed by the disk is proportional to the number of flux lines cutting the disk and the rate at which it cuts the disk. If the disk were to spin at the same rate as the permanent magnet, there would be no flux cutting the disk, no induced current flow, no electromagnet field, no torque. Thus, the disk speed will always fall behind that of the rotating permanent magnet, so that lines of flux cut the disk induce a current, create an electromagnetic field in the disk, which follows the permanent magnet. If a load is applied to the disk, slowing it,  more torque will be developed as more lines of flux cut the disk. Torque is proportional to <italic>slip</italic>, the degree to which the disk falls behind the rotating magnet. More slip corresponds to more flux cutting the conductive disk, developing more torque. 
</para>

<para>
An analog automotive eddy current speedometer is based on the principle illustrated above. With the disk restrained by a spring, disk and needle deflection is proportional to magnet rotation rate.
</para>

<para>
A rotating magnetic field is created by two coils placed at right angles to each other, driven by currents which are 90<superscript>o</superscript> out of phase. This should not be surprising if you are familiar with oscilloscope Lissajous patterns.
</para>

<image>02468.png<caption>Out of phase (90<superscript>o</superscript>) sine waves produce circular Lissajous pattern.</caption></image>


<para>
In Figure<ref>02468.png above</ref>,  a circular Lissajous is produced by driving the horizontal and vertical oscilloscope inputs with 90<superscript>o</superscript> out of phase sine waves. Starting at (a) with maximum ``X'' and minimum ``Y'' deflection, the trace moves up  and left toward (b). Between (a) and (b) the two waveforms are equal to 0.707 V<subscript>pk</subscript> at 45<superscript>o</superscript>. This point (0.707, 0.707) falls on the radius of the circle between (a) and (b)  The trace moves to  (b) with minimum ``X'' and maximum ``Y'' deflection.  With maximum negative ``X'' and minimum ``Y'' deflection, the trace moves to (c). Then with minimum ``X'' and  maximum negative ``Y'', it moves to (d), and on back to (a), completing one cycle.  
</para>


<image>02469.png<caption>X-axis sine and Y-axis cosine  trace circle.</caption></image>

<para>
Figure<ref>02469.png above</ref> shows the two 90<superscript>o</superscript> phase shifted sine waves applied to oscilloscope deflection  plates which are at right angles in space. If this were not the case, a one dimensional line would display. The combination of  90<superscript>o</superscript> phased sine waves and right angle deflection, results in a two dimensional pattern-- a circle. This circle is traced out by a counterclockwise rotating electron beam.
</para>


<para>
For reference, Figure<ref>02470.png below</ref>shows why in-phase sine waves will not produce a circular pattern. Equal ``X'' and ``Y'' deflection moves the illuminated spot from the origin at (a) up to right (1,1) at (b), back down left to origin at (c),down left  to (-1.-1) at (d), and back up right to origin. The line is produced by equal deflections along both axes; y=x is a straight line.
</para>

<image>02470.png<caption>No circular motion from in-phase waveforms.</caption></image>

<para>
If a pair of 90<superscript>o</superscript> out of phase sine waves produces a circular Lissajous, a similar pair of currents should be able to produce a circular rotating magnetic field. Such is the case for a 2-phase motor. By analogy three windings placed 120<superscript>o</superscript> apart in space, and fed with corresponding 120<superscript>o</superscript> phased currents will also produce a rotating magnetic field.
</para>

<image>02471.png<caption>Rotating magnetic field from 90<superscript>o</superscript> phased sinewaves.</caption></image>

<para>
As the 90<superscript>o</superscript> phased sinewaves, Figure<ref>02471.png above</ref>, progress from points (a) through (d), the magnetic field rotates counterclockwise  (figures a-d) as follows:
</para>

<itemize>
<item>(a) <phi>-1 maximum, <phi>-2 zero </item>
<item>(a') <phi>-1 70%, <phi>-2 70% </item>
<item>(b) <phi>-1 zero, <phi>-2 maximum</item>
<item>(c) <phi>-1 maximum negative, <phi>-2 zero</item>
<item>(d) <phi>-1 zero, <phi>-2 maximum negative </item>
</itemize>

<subsubsection>
<subsubsectiontitle>Motor speed </subsubsectiontitle>

<index>Synchronous speed, induction motor</index>
<index>Motor, induction, speed</index>
<index>Induction motor speed</index>
<index>Motor, induction, synchronous speed</index>
<index>Induction motor synchronous speed</index>

<para>
The rotation rate of a stator rotating magnetic field is related to the number of pole pairs per stator phase. The ``full speed'' Figure<ref>02472.png below</ref>  has a total of six poles or three pole-pairs and three phases. However,there is but one pole pair per phase-- the number we need. The magnetic field will rotate once per sine wave cycle. In the case of 60 Hz power, the field rotates at 60 times per second or 3600 revolutions per minute (rpm). For 50 Hz power, it rotates at 50 rotations per second, or 3000 rpm.  The 3600 and 3000 rpm, are the <italic>synchronous speed</italic> of the motor. Though the rotor of an induction motor never achieves this speed, it certainly is an upper limit. If we double the number of motor poles, the synchronous speed is cut in half because the magnetic field rotates 180<superscript>o</superscript> in space for 360<superscript>o</superscript> of electrical sine wave.
</para>

<image>02472.png<caption>Doubling the stator poles halves the synchronous speed.</caption></image>

<para>
The synchronous speed is given by:
</para>

<quotation>N<subscript>s</subscript> = 120<cdot>f/P</quotation>
<quotation>N<subscript>s</subscript> = synchronous speed in rpm</quotation>
<quotation>f = frequency of applied power, Hz</quotation>
<quotation>P = total number of poles per phase, a multiple of 2</quotation>

<literal>
<bold>Example:</bold>
</literal>

<para>
The ``half speed'' Figure<ref>02472.png above</ref>  has four poles per phase (3-phase). The synchronous speed for 50 Hz power is:
</para>

<quotation>
S = 120<cdot>50/4 = 1500 rpm
</quotation>

<para>
The short explanation of the induction motor is that the rotating magnetic field produced by the stator drags the rotor around with it.
</para>

<index>Induction motor slip</index>
<index>Motor, induction, slip</index>

<para>
The  longer more correct explanation is that the stator's magnetic field induces an alternating current into the rotor squirrel cage conductors which constitutes a transformer secondary. This induced rotor current in turn creates a magnetic field. The rotating stator magnetic field interacts with this rotor field. The rotor field attempts to align with the rotating stator field. The result is rotation of the squirrel cage rotor. If there were no mechanical motor torque load, no bearing, windage, or other losses, the rotor would rotate at the synchronous speed. However, the <italic>slip</italic> between the rotor and the synchronous speed stator field develops torque. It is the magnetic flux cutting the rotor conductors as it slips which develops torque. Thus, a loaded motor will slip in proportion to the mechanical load. If the rotor were to run at synchronous speed, there would be no stator flux cutting the rotor, no current induced in the rotor, no torque.
</para>

</subsubsection>

<subsubsection>
<subsubsectiontitle>Torque </subsubsectiontitle>
<index>Motor, induction, torque</index>
<index>Induction motor torque</index>

<para>
When power is first applied to the motor, the rotor is at rest, while the stator magnetic field rotates at the synchronous speed N<subscript>s</subscript>. The stator field is cutting the rotor at the synchronous speed N<subscript>s</subscript>. The current induced in the rotor shorted turns is maximum, as is the frequency of the current, the line frequency. As the rotor speeds up, the rate at which stator flux cuts the rotor is the difference between synchronous speed N<subscript>s</subscript> and actual rotor speed N, or (N<subscript>s</subscript> - N). The ratio of actual flux cutting the rotor to synchronous speed is defined as <italic>slip</italic>:
</para>

<quotation>
s = (N<subscript>s</subscript> - N)/N<subscript>s</subscript>
</quotation>

<quotation>
where: N<subscript>s</subscript> = synchronous speed,<sp><sp> N = rotor speed
</quotation>

<para>
The frequency of the current induced into the rotor conductors is only as high as the line frequency at motor start, decreasing as the rotor approaches synchronous speed. <italic>Rotor frequency</italic> is given by:
</para>

<quotation>
f<subscript>r</subscript> = s<cdot>f
</quotation>

<quotation>
where: s = slip,<sp><sp>  f = stator power line frequency
</quotation>

<para>
Slip at 100% torque is typically 5% or less in induction motors. Thus for f = 50 Hz line frequency, the frequency of the induced current in the rotor f<subscript>r</subscript> = 0.05<cdot>50 = 2.5 Hz. Why is it so low? The stator magnetic field rotates at 50 Hz. The rotor speed is 5% less. The rotating magnetic field is only cutting the rotor at 2.5 Hz. The 2.5 Hz is the difference between the synchronous speed and the actual rotor speed. If the rotor spins a little faster, at the synchronous speed, no flux will cut the rotor at all, f<subscript>r</subscript> = 0.
</para>

<image>02473.png<caption>Torque and speed vs %Slip. %N<subscript>s</subscript>=%Synchronous Speed.</caption></image>

<para>
The Figure<ref>02473.png above</ref> graph shows that starting torque known as <italic>locked rotor torque</italic> (LRT) is higher than 100% of the <italic>full load torque</italic> (FLT), the safe continuous torque rating. The locked rotor torque is about 175% of FLT for the example motor graphed above.  Starting current known as <italic>locked rotor current</italic> (LRC) is 500% of <italic>full load current</italic> (FLC), the safe  running current. The current is high because this is analogous to a shorted secondary on a transformer. As the rotor starts to rotate the torque may decrease a bit for certain classes of motors to a value known as the <italic>pull up torque</italic>. This is the lowest value of torque ever encountered by the starting motor. As the rotor  gains 80% of synchronous speed, torque increases from 175% up to 300% of the full load torque. This <italic>breakdown torque</italic> is due to the larger than normal  20% slip. The current has decreased only slightly at this point, but will decrease rapidly beyond this point. As the rotor accelerates to within a few percent of synchronous speed, both torque and current will decrease substantially. Slip will be only a few percent during normal operation. For a running motor, any portion of the torque curve below 100% rated torque is normal. The motor load determines the operating point on the torque curve. While the motor torque and current may exceed 100% for a few seconds during starting, continuous operation above 100% can damage the motor.  Any motor torque load above the breakdown torque will stall the motor. The torque, slip, and current will approach zero for a ``no mechanical torque'' load condition. This condition is analogous to an open secondary transformer.
</para>

<para>
There are several basic induction motor designs (Figure<ref>02474.png below</ref>)  showing consideable variation from the torque curve above. The different designs are optimized for starting and running different types of loads.  The locked rotor torque (LRT) for various motor designs and sizes ranges from 60% to 350% of full load torque (FLT).  Starting current or locked rotor current (LRC) can range from 500% to 1400% of full load current (FLC). This current draw can present a starting problem for large induction motors.
</para>

</subsubsection>

<subsubsection>
<subsubsectiontitle>NEMA design classes</subsubsectiontitle>

<index>Motor, induction, NEMA designs</index>
<index>NEMA induction motor designs</index>
<index>Induction motor, NEMA designs</index>

<para>
Various standard  classes (or designs) for motors, corresponding to the torque curves (Figure<ref>02474.png below</ref>)  have been developed to better drive various type loads. The National Electrical Manufacturers Association (NEMA) has specified motor classes A, B, C, and D to meet these drive requirements. Similar International Electrotechnical Commission (IEC) classes N and H correspond to NEMA B and C designs respectively.
</para>

<image>02474.png<caption>Characteristics for NEMA designs.</caption></image>

<para>
All motors, except class D, operate at %5 slip or less at full load.
</para>

<itemize>
<item><bold>Class B (IEC Class N)</bold> motors are the default motor to use in most applications. With a starting torque of LRT = 150% to 170% of FLT, it can start most loads, without excessive starting current (LRT). Efficiency and power factor are high. It typically drives pumps, fans, and machine tools.</item>
<item><bold>Class A</bold> starting torque is the same as class B. Drop out torque and starting current (LRT)are higher. This motor handles transient overloads as encountered in injection molding machines.</item>
<item><bold>Class C (IEC Class H)</bold> has higher starting torque than class A and B at LRT = 200% of FLT. This motor is applied to hard-starting loads which need to be driven at constant speed like conveyors, crushers, and reciprocating pumps and compressors. </item>
<item><bold>Class D</bold> motors have the highest starting torque (LRT) coupled with low starting current due to high slip ( 5% to 13% at FLT). The high slip results in lower speed. Speed regulation is poor. However, the motor excels at driving highly variable speed loads like those requiring an energy storage flywheel. Applications include punch presses, shears, and elevators.</item>
<item><bold>Class E</bold> motors are a higher efficiency version of class B.</item>
<item><bold>Class F</bold> motors have much lower LRC, LRT, and break down torque than class B. They drive constant easily started loads.</item>
</itemize>

</subsubsection>


<subsubsection>
<subsubsectiontitle>Power factor </subsubsectiontitle>

<index>Power factor, induction motor</index>
<index>Motor, induction, power factor</index>
<index>Induction motor, power factor</index>


<para>
Induction motors present a lagging (inductive) power factor to the power line.The power factor in large fully loaded high speed  motors can be as favorable as 90% for large high speed motors. At 3/4 full load the largest high speed motor power factor can be 92%. The power factor for small low speed motors can be as low as 50%.  At starting, the power factor can be in the range of 10% to 25%, rising as the rotor achieves speed.
</para>

<para>
Power factor (PF) varies considerably with the motor mechanical load (Figure<ref>02475.png below</ref>). An unloaded motor is analogous to a transformer with no resistive load on the secondary. Little resistance is reflected from the secondary (rotor) to the primary (stator). Thus the power line sees a reactive load, as low as 10% PF.  As the rotor is loaded an increasing resistive component is reflected from rotor to stator, increasing the power factor.
</para>

<image>02475.png<caption>Induction motor power factor and efficiency.</caption></image>

</subsubsection>

<subsubsection>
<subsubsectiontitle>Efficiency</subsubsectiontitle>
<index>Motor, induction, efficiency</index>
<index>Induction motor efficiency</index>

<para>
Large three phase motors are more efficient than smaller 3-phase motors, and most all single phase motors. Large induction motor efficiency can be as high as 95% at full load, though 90% is more common. Efficiency for a lightly loaded or no-load induction motor is poor because most of the current is involved with maintaining magnetizing flux. As the torque load is increased, more current is consumed in generating torque, while current associated with magnetizing remains fixed. Efficiency at 75% FLT can be slightly higher than that at 100% FLT. Efficiency is decreased a few percent at 50% FLT, and decreased a few more percent at 25% FLT. Efficiency only becomes poor below 25% FLT. The variation of efficiency with loading is shown in Figure<ref>02475.png above</ref>  
</para>

<para>
Induction motors are typically oversized to guarantee that their mechanical load can be started and driven under all operating conditions. If a polyphase motor is loaded at less than 75% of rated torque where efficiency peaks, efficiency suffers only slightly down to 25% FLT. 
</para>

</subsubsection>

</subsection>


<subsection>
<subsectiontitle>Nola power factor corrector</subsectiontitle>
<index>Nola power factor corrector</index>
<index>Motor, power factor corrector</index>

<para>
Frank Nola of NASA proposed a power factor corrector (PFC) as an energy saving device for single phase induction motors in the late 1970's. It is based on the premise that a less than fully loaded induction motor is less efficient and has a lower power factor than a fully loaded motor. Thus, there is energy to be saved in partially loaded motors, 1-<phi> motors in particular. The energy consumed in maintaining the stator magnetic field is relatively fixed with respect to load changes. While there is nothing to be saved in a fully loaded motor, the voltage to a partially loaded motor may be reduced to decrease the energy required to maintain the magnetic field. This will increase power factor and efficiency. This was a good concept for the notoriously inefficient  single phase motors for which it was intended.
</para>

<para>
This concept is not very applicable to large 3-phase motors. Because of their high efficiency (90%+), there is not much energy to be saved. Moreover, a 95% efficient motor is still 94% efficient at 50% full load torque (FLT) and 90% efficient at 25% FLT. The potential energy savings in going from 100% FLT to 25% FLT is the difference in efficiency 95% - 90% = 5%. This is not 5% of the full load wattage but 5% of the wattage at the reduced load. The Nola power factor corrector might be applicable to a 3-phase motor which idles most of the time (below 25% FLT), like a punch press. The pay-back period for the expensive electronic controller has been estimated to be unattractive for most applications. Though, it might be economical as part of an electronic motor starter or speed Control. <cite>7</cite>
</para>

</subsection>

<hypertarget>sfig[]</hypertarget>
<subsection>
<subsectiontitle>Induction motor alternator</subsectiontitle>


<index>Alternator, induction</index>
<index>Induction alternator</index>
<index>Generator, induction</index>
<index>Induction generator</index>

<para>
An induction motor may function as an alternator if it is driven by a torque at greater than 100% of the synchronous speed. (Figure<ref>02476.png below</ref>) This corresponds to a few % of ``negative'' slip, say -1% slip. This means that as we are rotating the motor faster than the synchronous speed, the rotor is advancing 1% faster than the stator rotating magnetic field. It normally lags by 1% in a motor. Since the rotor is cutting the stator magnetic field in the opposite direction (leading), the rotor induces a voltage into the stator feeding electrical energy back into the power line. 
</para>

<image>02476.png<caption>Negative torque makes induction motor into generator.</caption></image>

<para>
Such an <italic>induction generator</italic> must be excited by a ``live'' source of 50 or 60 Hz power. No power can be generated in the event of a power company  power failure. This type of alternator appears to be unsuited as a standby power source. As an auxiliary power wind turbine generator, it has the advantage of not requiring an automatic power failure disconnect switch to protect repair crews. It is fail-safe.
</para>

<para>
Small remote (from the power grid) installations may be made self-exciting by placing capacitors in parallel with the stator phases. If the load is removed residual magnetism may generate a small amount of current flow. This current is allowed to flow by the capacitors without dissipating power. As the generator is brought up to full speed, the current flow increases to supply a magnetizing current to the stator. The load may be applied at this point. Voltage regulation is poor. An induction motor may be converted to a self-excited generator by the addition of capacitors.<cite>6</cite>
</para>

<para>
Start up procedure is to bring the  wind turbine up to speed in motor mode by application of normal power line voltage to the stator. Any wind induced turbine speed in excess of synchronous speed will develop negative torque, feeding power back into the power line, reversing the normal direction of the electric kilowatt-hour meter. Whereas an induction motor presents a lagging power factor to the power line, an induction alternator presents a leading power factor. Induction generators are not widely used in conventional power plants. The speed of the steam turbine drive is steady and controllable as required by synchronous alternators.  Synchronous alternators are also more efficient.
<para>

</para>
The speed of a wind turbine is difficult to control, and subject to wind speed variation by gusts. An induction alternator is better able to cope with these  variations due to the inherent slip. This stresses the gear train and mechanical components less than a synchronous genertor.  However, this allowable speed variation only amounts to about 1%. Thus, a direct line connected induction generator is considered to be fixed-speed in a wind turbine. See <hyperlink>dfig[Doubly-fed induction generator]</hyperlink> for a true variable speed alternator.  Multiple generators or multiple windings on a common shaft may be switched to provide a high and low speed to accomodate variable wind conditions.
</para>

</subsection> 


<subsection>
<subsectiontitle>Motor starting and speed control</subsectiontitle>
<index>Motor, induction, starting</index>
<index>Induction motor starting</index>

<para>
Some induction motors can draw over 1000% of full load current during starting; though, a few hundred percent is more common. Small motors of a few kilowatts or smaller can be started by direct connection to the power line. Starting larger motors can cause line voltage sag, affecting other loads.  Motor-start rated circuit breakers (analogous to slow blow fuses) should replace standard circuit breakers for starting  motors of a few kilowatts. This breaker accepts  high over-current for the duration of starting. 
</para>

<image>02477.png<caption>Autotransformer induction motor starter.</caption></image>

<para>
Motors over 50 kW use motor starters to reduce line current from several hundred to a few hundred percent of full load current.  An intermittent duty autotransformer may  reduce the stator voltage for a fraction of a minute during the start interval, followed by application of full line voltage as in Figure<ref>02477.png above</ref>. Closure of the S contacts applies reduced voltage during the start interval. The S contacts open and the R contacts close after starting. This reduces starting current to, say, 200% of full load current. Since the autotransformer is only used for the short start interval, it may be sized considerably smaller than a continuous duty unit. 
</para>


<subsubsection>
<subsubsectiontitle>Running 3-phase motors on 1-phase</subsubsectiontitle>
<index>add-a-phase, AC motor</index>

<para>
Three-phase motors will run on single phase as readily as single phase motors. The only problem for either motor is starting. Sometimes 3-phase motors are purchased for use on single phase if three-phase provisioning is anticipated. The power rating needs to be 50% larger than for a comparable single phase motor to make up for one unused winding. Single phase is applied to a pair of windings simultanous with a start capacitor in series with the third winding. The start switch is opened in Figure<ref>02519.png below</ref> upon motor start. Sometimes a smaller capacitor than the start capacitor is retained while running.
</para>

<image>02519.png<caption>Starting a three-phase motor on single phase.</caption></image>

<index>static phase converter</index>

<para>
The circuit in Figure<ref>02519.png above</ref>  for running a three-phase motor on single phase is known as a <italic>static phase converter</italic> if the motor shaft is not loaded. Moreover, the motor acts as a 3-phase generator. Three phase power may be tapped off from the three stator windings for powering other 3-phase equipment. The capacitor supplies a <italic>synthetic</italic> phase approximately midway <angle>90<superscript>o</superscript> between the  <angle>180<superscript>o</superscript> single phase power source terminals for starting. While running, the motor generates  approximately standard 3-<phi>, as shown in Figure<ref>02519.png above</ref>.  Matt Isserstedt shows a complete design for powering a home machine shop. <cite>8</cite>
</para>



<image>02520.png<caption>Self-starting static phase converter. Run capacitor = 25-30<mu>F per HP. Adapted from Figure 7, Hanrahan <cite>9</cite></caption></image>

<para>
Since a static phase converter has no torque load, it may be started with a capacitor considerably smaller than a normal start capacitor. If it is small enough, it may be left in circuit as a run-capacitor. See Figure<ref>02520.png above</ref>. However, smaller run-capacitors result in better 3-phase power output as in Figure<ref>02521.png below</ref>. Moreover, adjustment of these capacitors to equalize the currents as measured in the three phases results in the most efficient machine.<cite>9</cite>  However, a large start capacitor is required for about a second to quickly start the converter. Hanrahan provides construction details.<cite>9</cite>
</para>

<image>02521.png<caption>More efficient static phase converter. Start capacitor = 50-100<mu>F/HP. Run capacitors = 12-16<mu>F/HP. Adapted from Figure 1, Hanrahan <cite>9</cite></caption></image>



</subsubsection>

<subsubsection>
<subsubsectiontitle>Multiple fields </subsubsectiontitle>

<index>Motor, induction, speed</index>
<index>Induction motor speed</index>

<para>
Induction motors may contain multiple field windings, for example a 4-pole and an 8-pole winding corresponding to 1800 and 900 rpm synchronous speeds. Energizing one field or the other is less complex than rewiring the stator coils in Figure<ref>02478.png below</ref>.
</para>

<image>02478.png<caption>Multiple fields allow speed change.</caption></image>

<para>
If the field is segmented with leads brought out, it may be rewired (or switched) from 4-pole to 2-pole as shown above for a 2-phase motor. The  22.5<superscript>o</superscript> segments are switchable to 45<superscript>o</superscript> segments. Only the wiring for one phase is shown above for clarity. Thus, our induction motor may run at multiple speeds. When switching the above  60 Hz motor from 4 poles to 2 poles the synchronous speed increases from 1800 rpm to 3600 rpm.  If the motor is driven by 50 Hz, what would be the corresponding 4-pole and 2-pole synchronous speeds? 
</para>

<quotation>N<subscript>s</subscript> = 120f/P = 120*50/4 = 1500 rpm (4-pole)</quotation>
<quotation>N<subscript>s</subscript> = 3000 rpm (2-pole)</quotation>
</subsubsection>


<subsubsection>
<subsubsectiontitle>Variable voltage</subsubsectiontitle>

<para>
The speed of small squirrel cage induction motors for applications such as driving fans, may be changed by reducing the line voltage. This reduces the torque available to the load which reduces the speed. (Figure<ref>02479.png below</ref>)
</para>

<image>02479.png<caption>Variable voltage controls induction motor speed.</caption></image>


</subsubsection>



<subsubsection>
<subsubsectiontitle>Electronic speed control </subsubsectiontitle>

<index>Induction motor, speed control</index>
<index>Motor, induction, speed control</index>
<index>Speed control, induction motor</index>

<para>
Modern solid state electronics increase the options for speed control. By changing the 50 or 60 Hz line frequency to higher or lower values, the synchronous speed of the motor may be changed. However, decreasing the frequency of the current fed to the motor also decreases reactance X<subscript>L</subscript> which increases the stator current. This may cause the stator magnetic circuit to saturate with disastrous results. In practice, the voltage to the motor needs to be decreased when frequency is decreased.
</para>

<image>02480.png<caption> Electronic variable speed drive.</caption></image>

<para>
Conversely, the drive frequency may be increased to increase the synchronous speed of the motor. However, the voltage needs to be increased to overcome increasing reactance to keep current up to a normal value and maintain torque.
The inverter (Figure<ref>02480.png above</ref>)  approximates sinewaves to the motor with pulse width modulation outputs. This is a chopped waveform which is either on or off, high or low, the percentage of ``on'' time corresponds to the instantaneous sine wave voltage.
</para>

<para>
Once electronics is  applied to induction  motor control, many control methods are available, varying from the simple to complex:
</para>

</subsubsection>

<bigspace>
<bold>Summary: Speed control</bold>
<itemize>
<item><italic>Scaler Control</italic> Low cost method described above to control only voltage and frequency, without feedback.</item>
<item><italic>Vector Control</italic> Also known as vector phase control. The flux  and torque producing components of stator current are measured or estimated on a real-time basis to enhance the motor torque-speed curve. This is computation intensive.</item>
<item><italic>Direct Torque Control</italic> An elaborate adaptive motor model allows more direct control of flux and torque without feedback. This method quickly responds to load changes. </item>
</itemize>



<bigspace>
<bold>Summary: Tesla polyphase induction motors</bold>

<itemize>
<item>A <italic>polyphase induction motor</italic> consists of a polyphase winding embedded in a laminated  stator and a conductive squirrel cage embedded in a laminated rotor.</item>
<item>Three phase currents flowing within the stator create a rotating magnetic field which induces a current, and consequent magnetic field in the rotor. Rotor torque is developed as the rotor slips a little behind the rotating stator field.</item>
<item>Unlike single phase motors, polyphase induction motors are <italic>self-starting.</italic></item>
<item><italic>Motor starters</italic> minimize loading of the power line while providing a larger starting torque than required during running. Line current reducing <italic>starters</italic> are only required for large motors.</item>
<item>Three phase motors will run on single phase, if started.</item>
<item>A <italic>static phase converter</italic> is a three phase motor running on single phase having no shaft load, generating a 3-phase output.</item>
<item><italic>Multiple field windings</italic> can be rewired for multiple discrete motor speeds by changing the number of poles.</item>
</itemize>


</subsection>


<subsection>
<subsectiontitle>Linear induction motor</subsectiontitle>

<index>Linear induction motor</index>
<index>Induction motor, linear</index>

<para>
The wound stator and the squirrel cage rotor of an induction motor may be cut at the circumference and unrolled into a linear induction motor. The direction of linear travel is controlled by the sequence of the drive to the stator phases. 
</para>

<para>
The linear induction motor has been proposed as a drive for high speed passenger trains. Up to this time, the linear induction motor with the accompanying magnetic repulsion levitation system required for a smooth ride has been too costly for all but experimental installations.  However, the linear induction motor is scheduled to replace steam driven  catapult aircraft launch systems on the next generation of naval aircraft carrier, CVNX-1, in 2013. This will increase efficiency and reduce maintenance.<cite>4</cite>
<cite>5</cite>
</para>

</subsection>

</section>

<section>
<sectiontitle>Wound rotor induction motors </sectiontitle>
<index>Wound rotor induction motor</index>
<index>Motor, induction, wound rotor</index>
<index>Induction motor, wound rotor</index>

<para>
A <italic>wound rotor</italic> induction motor has a stator like the squirrel cage induction motor, but a rotor with insulated windings brought out via slip rings and brushes. However, no power is applied to the slip rings. Their sole purpose is to allow resistance to be placed in series with the rotor windings while starting. (Figure<ref>02481.png below</ref>) This resistance is shorted out once the motor is started to make the rotor look electrically like the squirrel cage counterpart.
</para>

<image>02481.png<caption>Wound rotor induction motor.</caption></image>

<para>
Why put resistance in series with the rotor?  Squirrel cage induction motors draw 500% to over 1000% of full load current (FLC) during starting. 
While this is not a severe problem for small motors, it is for large (10's of kW) motors. Placing resistance in series with the rotor windings not only decreases start current, locked rotor current (LRC), but also increases the starting torque, locked rotor torque (LRT). Figure<ref>02482.png below</ref>  shows that by increasing the rotor resistance from R<subscript>0</subscript> to R<subscript>1</subscript> to  R<subscript>2</subscript>, the breakdown torque peak is shifted left to zero speed.Note that this torque peak is much higher than the starting torque available with no rotor resistance (R<subscript>0</subscript>).  Slip is proportional to rotor resistance, and pullout torque is proportional to slip. Thus, high torque is produced while starting.
</para>

<image>02482.png<caption>Breakdown torque peak is shifted to zero speed by increasing rotor resistance.</caption></image>

<para>
The resistance decreases the torque available at full running speed. But that resistance is shorted out by the time the rotor is started. A shorted rotor operates like a squirrel cage rotor. Heat generated during starting is mostly dissipated external to the motor in the starting resistance. The complication and maintenance associated with brushes and slip rings is a disadvantage of the wound rotor as compared to the simple squirrel cage rotor.
</para>

<para>
This motor is suited for starting high inertial loads. A high starting resistance makes the high pull out torque available at zero speed. For comparison, a squirrel cage rotor only exhibits pull out (peak) torque at 80% of its synchronous speed.
</para>

<subsection>
<subsectiontitle>Speed control</subsectiontitle>

<index>Induction motor, speed control</index>
<index>Motor, induction, speed control</index>
<index>Speed control,induction motor</index>

<para>
Motor speed may be varied  by putting variable resistance back into the rotor circuit. This reduces rotor current and speed. The high starting torque available at zero speed, the down shifted break down torque, is not available at high speed. See R<subscript>2</subscript> curve at 90% Ns, Figure<ref>02483.png below</ref>. Resistors R<subscript>0</subscript>R<subscript>1</subscript>R<subscript>2</subscript>R<subscript>3</subscript> increase in value from zero. A higher resistance at R<subscript>3</subscript> reduces the speed further. Speed regulation is poor with respect to changing torque loads. This speed control technique is only useful over a range of 50% to 100% of full speed. Speed control works well with variable speed loads like elevators and printing presses.
</para>

<image>02483.png<caption>Rotor resistance controls speed of wound rotor induction motor.</caption></image>

</subsection>


<subsection>
<hypertarget>dfig[]</hypertarget>
<subsectiontitle>Doubly-fed induction generator</subsectiontitle>

<index>Doubly fed induction generator</index>
<index>Alternator, induction</index>
<index>Induction alternator</index>
<index>Generator, induction</index>
<index>Induction generator</index>


<para>
We previously described a squirrel cage induction motor acting like a generator if driven faster than the synchronous speed. (See <hyperlink>sfig[Induction motor alternator]</hyperlink>) This is a <italic>singly-fed induction generator</italic>, having electrical connections only to the stator windings. A wound rotor induction motor may also act as a generator when driven above the synchronous speed. Since there are connections to both the stator and rotor, such a machine is known as a <italic>doubly-fed induction generator</italic> (DFIG).
</para>

<image>02512.png<caption>Rotor resistance allows over-speed of doubly-fed induction generator.</caption></image>

<para>
The singly-fed induction generator only had a usable slip range of 1% when driven by troublesome wind torque. Since the speed of a wound rotor induction motor may be controlled over a range of 50-100% by inserting resistance in the rotor, we may expect the same  of the doubly-fed induction generator. Not only can we slow the rotor by 50%, we can also overspeed it by 50%. That is, we can vary the speed of a doubly fed induction generator by <plusminus>50% from the synchronous speed. In actual practice, <plusminus>30% is more practical.
</para>


<para>
If the generator over-speeds, resistance placed in the rotor circuit will absorb excess energy while the stator feeds constant 60 Hz to the power line. (Figure<ref>02512.png above</ref>) In the case of under-speed, negative resistance inserted into the rotor circuit can make up the energy deficit, still allowing the stator to feed the power line with 60 Hz power. 
</para>

<image>02513.png<caption>Converter recovers energy from rotor of doubly-fed induction generator.</caption></image>

<para>
In actual practice, the rotor resistance may be replaced by a converter (Figure<ref>02513.png above</ref>) absorbing power from the rotor, and feeding power into the power line instead of dissipating it. This improves the efficiency of the generator.
</para> 


<image>02514.png<caption>Converter borrows energy from power line for rotor of doubly fed induction generator, allowing it to function well under synchronous speed.</caption></image>


<para>
The converter may ``borrow'' power from the line for the under-speed rotor, which passes it on to the stator. (Figure<ref>02514.png above</ref>) The borrowed power, along with the larger shaft energy,  passes  to the stator which is connected to the power line. The stator appears to be supplying 130% of power to the line.  Keep in mind that the rotor ``borrows'' 30%, leaving, leaving the line with 100% for the theoretical lossless DFIG. 

</para>


</subsection>



<bigspace>
<bold>Wound rotor induction motor qualities.</bold>
<itemize>
<item>Excellent starting torque for high inertia loads.</item>
<item>Low starting current compared to squirrel cage induction motor.</item>
<item>Speed is resistance variable over 50% to 100% full speed.</item>
<item>Higher maintenance of brushes and slip rings compared to squirrel cage motor.</item>
<item>The generator version of the wound rotor machine is known as a <italic>doubly-fed induction generator</italic>, a variable speed machine.</item>
</itemize>

</section>




<section>
<sectiontitle>Single-phase induction motors</sectiontitle>

<index>Induction motor, single phase</index>

<para>
A three phase motor may be run from a single phase power source. (Figure<ref>02484.png below</ref>) However, it will not self-start.  It may be hand started in either direction, coming up to speed in a few seconds. It will only develop 2/3 of the 3-<phi> power rating because one winding is not used.  
</para>


<image>02484.png<caption>3-<phi>motor runs from 1-<phi> power,  but does not start.</caption></image>

<para>
The single coil of a single phase induction motor does not produce a rotating magnetic field, but a pulsating field reaching maximum intensity at 0<superscript>o</superscript> and 180<superscript>o</superscript> electrical. (Figure<ref>02485.png below</ref>)
</para>

<image>02485.png<caption>Single phase stator produces a nonrotating, pulsating magnetic field.</caption></image>

<para>
Another view is that the single coil excited by a single phase current produces two counter rotating magnetic field phasors, coinciding twice per revolution at 0<superscript>o</superscript> (Figure<ref>02485.png above</ref>-a) and 180<superscript>o</superscript> (figure e). When the phasors rotate to  90<superscript>o</superscript> and -90<superscript>o</superscript> they cancel in figure b. At 45<superscript>o</superscript> and -45<superscript>o</superscript> (figure c) they are partially additive along the +x axis and cancel along the y axis. An analogous situation exists in figure d.  The sum of these two phasors is a phasor stationary in space, but alternating polarity in time. Thus, no starting torque is developed.
</para>

<para>
However, if the rotor is rotated forward at a bit less than the synchronous speed, it will develop maximum torque at 10% slip with respect to the forward rotating phasor. Less torque will be developed above or below 10% slip. The rotor will see 200% - 10% slip with respect to the counter rotating magnetic field phasor. Little torque (see torque vs slip curve) other than a double frequency ripple is developed from the counter rotating phasor. Thus, the single phase coil will develop torque, once the rotor is started. If the rotor is started in the reverse direction, it will develop a similar large torque as it nears the speed of the backward rotating phasor. 
</para>


<para>
Single phase induction motors have a copper or aluminum squirrel cage embedded in a cylinder of steel laminations, typical of poly-phase induction motors.
</para>

<subsection>
<subsectiontitle>Permanent-split capacitor motor </subsectiontitle>

<index>Motor, permanent-split capacitor</index>

<para>
One way to solve the single phase problem is to build a 2-phase motor, deriving 2-phase power from single phase. This requires a motor with two windings spaced apart 90<superscript>o</superscript> electrical, fed with two phases of current displaced 90<superscript>o</superscript> in time. This is called a permanent-split capacitor motor in Figure<ref>02486.png below</ref>.  
</para>

<image>02486.png<caption>Permanent-split capacitor induction motor.</caption></image>

<para>
This type of motor suffers increased current magnitude and backward time shift as the motor comes up to speed, with torque pulsations at full speed. The solution is to keep the capacitor (impedance) small to minimize losses.  The losses are less than for a shaded pole motor. This motor configuration works well up to 1/4 horsepower (200watt), though, usually applied to smaller motors. The direction of the motor is easily reversed by switching the capacitor in series with the  other winding. This type of motor can be adapted for use as a servo motor, described elsewhere is this chapter.
</para>


<image>02487.png<caption>Single phase induction motor with embedded stator coils.</caption></image>

<para>
Single phase induction motors may have coils embedded into the stator as shown in Figure<ref>02487.png above</ref>  for larger size motors. Though, the smaller sizes use less complex to build concentrated windings with salient poles.
</para>

</subsection>


<subsection>
<subsectiontitle>Capacitor-start induction motor </subsectiontitle>

<index>Motor, capacitor-start</index>


<para>
In Figure<ref>02488.png below</ref> a larger capacitor may be used to start a single phase induction motor via the auxiliary winding if it is switched out by a centrifugal switch once the motor is up to speed. Moreover, the auxiliary winding may be many more turns of  heavier wire than used in a resistance split-phase motor to mitigate excessive temperature rise. The result is that more starting torque is available for heavy loads like air conditioning compressors. This motor configuration works so well that it is available in multi-horsepower (multi-kilowatt) sizes.
</para>

<image>02488.png<caption>Capacitor-start induction motor.</caption></image>
<para>

</para>

</subsection>

<subsection>
<subsectiontitle>Capacitor-run motor induction motor </subsectiontitle>

<index>Motor, capacitor-run</index>

<para>
A variation of the capacitor-start motor (Figure<ref>02489.png below</ref>) is to start the motor with a relatively large capacitor for high starting torque, but leave a smaller value capacitor in place after starting to improve running characteristics while not drawing excessive current. The additional complexity of the capacitor-run motor is justified for larger size motors.
</para>

<image>02489.png<caption>Capacitor-run motor induction motor.</caption></image>

<para>
A motor starting capacitor may be a double-anode non-polar electrolytic capacitor which could be two + to + (or - to -) series connected polarized  electrolytic capacitors.  Such AC rated electrolytic capacitors have such high losses that they can only be used for intermittent duty (1 second on, 60 seconds off) like motor starting. A capacitor for motor running must not be of electrolytic construction, but a lower loss polymer type.
</para>

</subsection>


<subsection>
<subsectiontitle>Resistance split-phase induction motor</subsectiontitle>

<index>Motor, split-phase</index>

<para>
If an auxiliary winding of much fewer turns of  smaller wire is placed at 90<superscript>o</superscript> electrical to the main winding, it can start a single phase induction motor. (Figure<ref>02490.png below</ref>) With lower inductance and higher resistance, the current will experience less phase shift than the main winding. About 30<superscript>o</superscript> of phase difference may be obtained. This coil produces a moderate starting torque, which is disconnected by a centrifugal switch at 3/4 of synchronous speed. This simple (no capacitor) arrangement serves well for motors up to 1/3 horsepower (250 watts) driving easily started loads. 
</para>

<image>02490.png<caption>Resistance split-phase induction motor.</caption></image>

<para>
This motor has more starting torque than a shaded pole motor (next section), but not as much as a two phase motor built from the same parts. The current density in the auxiliary winding is so high during starting that the consequent rapid temperature rise precludes frequent restarting or slow starting loads.
</para>

</subsection>


<subsection>
<subsectiontitle>Nola power factor corrector</subsectiontitle>
<index>Nola power factor corrector</index>
<index>Motor, power factor corrector</index>
<index>Induction motor power factor corrector</index>


<para>
Frank Nola of NASA proposed a power factor corrector for improving the efficiency of AC induction motors in the mid 1970's. It is based on the premise that induction motors are inefficient at less than full load. This inefficiency correlates with a low power factor. The less than unity power factor is due to magnetizing current required by the stator. This fixed current is a larger proportion of total motor current as motor load is decreased. At light load, the full magnetizing current is not required. It could be reduced by decreasing the applied voltage, improving the power factor and efficiency. The power factor corrector senses power factor, and decreases motor voltage, thus restoring a higher power factor and decreasing losses.
</para>

<para>
Since single-phase motors are about 2 to 4 times as inefficient as three-phase motors, there is potential energy savings for 1-<phi> motors. There is no savings for a fully loaded motor since all the stator magnetizing current is required.  The voltage cannot be reduced. But there is potential savings from a less than fully loaded motor. A nominal 117 VAC motor is designed to work at as high  as 127 VAC, as low as 104 VAC. That means that it is not fully loaded when operated at greater than 104 VAC, for example, a 117 VAC refrigerator. It is safe for the power factor controller to lower the line voltage to 104-110 VAC. The higher the initial line voltage, the greater the potential savings. Of course, if the power company delivers closer to 110 VAC, the motor will  operate more efficiently without any add-on device.
</para>

<para>
Any substantially idle, 25% FLC or less,  single phase induction motor is a candidate for a PFC. Though, it needs to operate a large number of hours per year. And the more time it idles, as in a lumber saw, punch press, or conveyor, the greater the possibility of paying for the controller in a few years operation. It should be easier to pay for it by a factor of three as compared to the more efficient 3-<phi>-motor. The cost of a PFC cannot be recovered for a motor operating only a few hours per day. <cite>7</cite>
</para>


</subsection>

<bigspace>
<bold>Summary: Single-phase induction motors</bold>

<itemize>
<item> <italic>Single-phase induction motors</italic> are not self-starting without an auxiliary stator winding driven by an out of phase current of near 90<superscript>o</superscript>. Once started the auxiliary winding is optional.</item>
<item>The auxiliary winding of a <italic>permanent-split capacitor motor</italic> has a capacitor in series with it during starting and running. </item>
<item>A <italic>capacitor-start induction motor</italic> only has a capacitor in series with the auxiliary winding during starting. </item>
<item>A <italic>capacitor-run motor</italic> typically has a large non-polarized electrolytic capacitor in series with the auxiliary winding for starting, then a smaller non-electrolytic capacitor during running. </item>
<item>The auxiliary winding of a <italic>resistance split-phase motor</italic> develops a phase difference versus the main winding during starting by virtue of the difference in resistance. </item>
</itemize>

</section>





<section>
<sectiontitle><sp>Other specialized motors</sectiontitle>


<subsection>
<subsectiontitle><sp>Shaded pole induction motor </subsectiontitle>

<index>Motor, shaded pole</index>

<para>
An easy way to provide starting torque to a single phase motor is to embed a shorted turn in each pole at 30<superscript>o</superscript> to 60<superscript>o</superscript> to the main winding. (Figure<ref>02491.png below</ref>) Typically 1/3 of the pole is enclosed by a bare copper strap. These shading coils produce a time lagging damped flux spaced 30<superscript>o</superscript> to 60<superscript>o</superscript> from the main field. This lagging flux with the undamped main component, produces a rotating field with a small torque to start the rotor. 
</para>


<image>02491.png<caption>Shaded pole induction motor, (a) dual coil design, (b) smaller single coil version.</caption></image>

<para>
Starting torque is so low that shaded pole motors are only manufactured in smaller sizes, below 50 watts. Low cost and simplicity suit this motor to small fans, air circulators, and other low torque applications. Motor speed can be lowered by switching reactance in series to limit current and torque, or by switching motor coil taps as in Figure<ref>02492.png below</ref>.
</para>

<image>02492.png<caption>Speed control of shaded pole motor.</caption></image>

</subsection>

<subsection>
<subsectiontitle><sp>2-phase  servo motor</subsectiontitle>

<index>Motor, AC servo</index>

<para>
A <italic>servo motor</italic> is typically part of a feedback loop containing electronic, mechanical, and electrical components. The servo loop is a means of controlling the motion of an object via the motor.  A requirement of many such systems is fast response. To reduce acceleration robbing inertia, the iron core is removed from the rotor leaving only a shaft mounted aluminum cup to rotate. (Figure<ref>02493.png below</ref>) The iron core is reinserted within the cup as a static (non-rotating) component to complete the magnetic circuit. Otherwise, the construction is typical of a two phase motor. The low mass rotor can accelerate more rapidly than a squirrel cage rotor.
</para>

<image>02493.png<caption>High acceleration 2-<phi> AC servo motor.</caption></image>

<para>
One phase is connected to the single phase line; the other is driven by an amplifier. One of the windings is driven by a 90<superscript>o</superscript> phase shifted waveform. In the above figure, this is accomplished by a series capacitor in the power line winding. The other winding is driven by a variable amplitude sine wave to control motor speed. The phase of the waveform may invert (180<superscript>o</superscript> phase shift) to reverse the direction of the motor. This variable sine wave is the output of an error amplifier. See synchro CT  section for example. Aircraft control surfaces may be positioned by 400 Hz 2-<phi> servo motors.
</para>

</subsection>


<subsection>
<subsectiontitle><sp>Hysteresis motor</subsectiontitle>

<index>Motor, hysteresis</index>

<para>
If the low hysteresis Si-steel laminated rotor of an induction motor is replaced by a slotless windingless cylinder of hardened magnet steel, hysteresis, or lagging behind of rotor magnetization, is greatly accentuated. The resulting low torque synchronous motor develops constant torque from stall to synchronous speed. Because of the low torque, the hysteresis motor is only available in very small sizes, and is only used for constant speed applications like clock drives, and formerly, phonograph turntables.
</para>

</subsection>


<subsection>
<subsectiontitle><sp>Eddy current clutch </subsectiontitle>


<index>Eddy current clutch</index>
<para>
If the stator of an induction motor or a synchronous motor is mounted to rotate independently of the rotor, an eddy current clutch results. The coils are excited with DC and attached to the mechanical load. The squirrel cage rotor is attached to the driving motor. The drive motor is started with no DC excitation to the clutch. The DC excitation is adjusted from zero to the desired final value providing a continuously and smoothly variable  torque. The operation of the eddy current clutch is similar to an analog eddy current automotive speedometer.
</para>

</subsection>

<bigspace>
<bold>Summary: Other specialized motors</bold>

<itemize>
<item>The <italic>shaded pole induction motor</italic>, used in under 50 watt low torque applications, develops a second phase from shorted turns in the stator.</item>
<item><italic> Hysteresis motors</italic> are a small low torque synchronous motor once used in clocks and phonographs.</item>
<item>The <italic>eddy current clutch</italic> provides an adjustable torque. </item>
</itemize>

</section>


<section>
<sectiontitle><sp>Selsyn (synchro) motors </sectiontitle>
<index>Selsyn</index>
<index>Synchro (selsyn)</index>

<comment>synchros USN http://www.tpub.com/content/neets/14187/index.htm</comment>
<comment>synchros British  www.atra.mod.uk/atra/rsabst/pdf/Z/Ctrl-Synchros.pdf</comment>

<para>
Normally, the rotor windings of a wound rotor induction motor are shorted out after starting. During starting, resistance may be placed in series with the rotor windings to limit starting current.  If these windings are connected to a common starting resistance, the two rotors will remain synchronized during starting. (Figure<ref>02494.png below</ref>)  This is useful for printing presses and draw bridges, where two motors need to be synchronized during starting.  Once started, and the rotors are shorted, the synchronizing torque is absent.  The higher the resistance during starting, the higher the synchronizing torque for a pair of motors. If the starting resistors are removed, but the rotors still paralleled, there is no starting torque. However there is a substantial synchronizing torque.  This is a <italic>selsyn</italic>, which is an abbreviation for ``self synchronous''.
</para>

<image>02494.png<caption>Starting wound rotor induction motors from common resistors.</caption></image>

<para>
The rotors may be  stationary. If one rotor is moved through an angle <theta>, the other selsyn shaft will move through an angle <theta>. If drag is applied to one selsyn, this will be felt when attempting to rotate the other shaft. While multi-horsepower (multi-kilowatt) selsyns exist, the main appplication is small units of a few watts for instrumentation applications-- remote position indication.
</para>

<image>02495.png<caption>Selsyns without starting resistance.</caption></image>

<para>
Instrumentation selsyns have no use for starting resistors. (Figure<ref>02495.png above</ref>) They are not intended to be self rotating. Since the rotors are not shorted out nor resistor loaded, no starting torque is developed. However, manual rotation of one shaft will produce an unbalance in the rotor currents until the parallel unit's shaft follows. Note that a common source of three phase power is applied to both stators. 
<comment>Split for 2-ref tags</comment>
Though we show three phase rotors above, a single phase powered  rotor is sufficient as shown in Figure<ref>02496.png below</ref>.
</para>

<subsection>
<subsectiontitle>Transmitter - receiver</subsectiontitle>
<index>Selsyn, transmitter</index>
<index>Selsyn, receiver</index>
<index>Synchro, transmitter</index>
<index>Synchro, receiver</index>

<para>
Small instrumentation selsyns, also known as <italic>synchros</italic>, use single phase paralleled, AC energized rotors, retaining the 3-phase paralleled stators, which are not externally energized. (Figure<ref>02496.png below</ref>)  Synchros function as rotary transformers. If the rotors of both the <italic>torque transmitter</italic> (TX) and <italic>torque receiver</italic> (RX) are at the same angle, the phases of the induced stator voltages will be identical for both, and no current will flow. Should one rotor be displaced from the other, the stator phase voltages will differ between transmitter and receiver. Stator current will flow developing torque. The receiver shaft is electrically slaved to the transmitter shaft. Either the transmitter or receiver shaft may be rotated to turn the opposite unit.
</para>

<image>02496.png<caption>Synchros have single phase powered rotors.</caption></image>

<para>
Synchro stators are wound with 3-phase windings brought out to external terminals. The single rotor winding of a torque transmitter or receiver is brought out by brushed slip rings. Synchro transmitters and receivers are electrically identical. However, a synchro receiver has inertial damping built in. A synchro torque transmitter may be substituted for a torque receiver.
</para>

<para>
Remote position sensing is the main synchro application. (Figure<ref>02497.png below</ref>) For example, a synchro transmitter coupled to a radar antenna indicates antenna position on an indicator in a control room. A synchro transmitter coupled to a weather vane indicates wind direction at a remote console.  Synchros are available for use with 240 Vac 50 Hz, 115 Vac 60 Hz, 115 Vac 400 Hz, and  26 Vac 400 Hz power.
</para>

<image>02497.png<caption>Synchro application: remote position indication.</caption></image>

</subsection>

<subsection>
<subsectiontitle><sp>Differential transmitter - receiver </subsectiontitle>
<index>Selsyn, differential transmitter</index>
<index>Synchro, differential transmitter</index>

<para>
<italic></italic>
A <italic>synchro differential transmitter</italic> (TDX) has both a three phase rotor and stator. (Figure<ref>02498.png below</ref>) A synchro differential transmitter adds a shaft angle input to an electrical angle input on the rotor inputs, outputting the sum on the stator outputs. This stator electrical angle may be displayed by sending it to an RX.  For example, a synchro receiver displays the position of a radar antenna relative to a ship's bow. The addition of a ship's compass heading by a synchro differential transmitter, displays antenna postion on an RX relative to true north, regardless of ship's heading. Reversing the S1-S3 pair of stator leads between a TX and TDX subtracts angular positions.
</para>

<image>02498.png<caption>Torque differential transmitter (TDX).</caption></image>

<para>
A shipboard radar antenna coupled to a synchro transmitter encodes the antenna angle with respect to ship's bow. (Figure<ref>02499.png below</ref>) It is desired to display the antenna position with respect to true north.  We need to add the ships heading from a gyrocompass to the bow-relative antenna position to display antenna angle with respect to true north. <angle>antenna + <angle>gyro
</para>

<image>02499.png<caption>Torque differential transmitter application: angular addition. </caption></image>

<para>
<sp><sp><sp><sp><sp><sp><sp><sp><angle>antenna-N =  <angle>antenna + <angle>gyro
</para>

<para>
<sp><sp><sp><sp><sp><sp><sp><sp><angle>rx = <angle>tx + <angle>gy
</para>

<para>
For example, ship's heading is <angle>30<superscript>o</superscript>, antenna position relative to ship's bow is <angle>0<superscript>o</superscript>, <angle>antenna-N is:
</para>

<para>
<sp><sp><sp><sp><sp><sp><sp><sp><angle>rx = <angle>tx + <angle>gy
</para>

<para>
<sp><sp><sp><sp><sp><sp><sp><sp><angle>30<superscript>o</superscript> = <angle>30<superscript>o</superscript> + <angle>0<superscript>o</superscript>
</para>

<para>
Example, ship's heading is <angle>30<superscript>o</superscript>, antenna position relative to ship's bow is <angle>15<superscript>o</superscript>, <angle>antenna-N  is: 
</para>

<para>
<sp><sp><sp><sp><sp><sp><sp><sp><angle>45<superscript>o</superscript> = <angle>30<superscript>o</superscript> + <angle>15<superscript>o</superscript>
</para>


<subsubsection>
<subsubsectiontitle><sp>Addition vs subtraction </subsubsectiontitle>

<para>
For reference we show the wiring diagrams for subtraction and addition of shaft angles using both TDX's (Torque Differential Transmitter) and TDR's (Torque Differential Receiver). The TDX has a torque angle input on the shaft, an electrical angle input on the three stator connections, and an electrical angle output on the three rotor connections. The TDR has electrical angle inputs on both the stator and rotor. The angle output is a torque on the TDR shaft. The difference between a TDX and a TDR is that the TDX is a torque transmitter and the TDR a torque receiver.
</para>

<image>02500.png<caption>TDX subtraction.</caption></image>
<para>

The torque inputs in Figure<ref>02500.png above</ref>  are TX and TDX. The torque output angular difference is TR.
</para>

<image>02501.png<caption>TDX Addition.</caption></image>
<para>
The torque inputs in Figure<ref>02501.png above</ref>   are TX and TDX. The torque output angular sum is TR.
</para>
<image>02502.png<caption>TDR subtraction.</caption></image>
<para>
The torque inputs in Figure<ref>02502.png above</ref> are TX<subscript>1</subscript> and TX<subscript>2</subscript>. The torque output angular difference is TDR.
</para>
<image>02503.png<caption>TDR addition.</caption></image>
<para>
The torque inputs in Figure<ref>02503.png above</ref>   are TX<subscript>1</subscript> and TX<subscript>2</subscript>. The torque output angular sum is TDR.
</para>




</subsubsection>


</subsection>


<subsection>
<subsectiontitle><sp>Control transformer </subsectiontitle>
<index>Control transformer, synchro</index>
<index>CT, control transformer, synchro</index>
<index>Synchro, control transformer</index>


<para>
A variation of the  synchro transmitter is the <italic>control transformer</italic>. It has three equally spaced stator windings like a TX.  Its rotor is wound with more turns than a transmitter or receiver to make it more sensitive at detecting a  null as it is rotated, typically, by a <italic>servo</italic> system.  The CT (Control Transformer) rotor output is zero when it is oriented at a angle right angle to the stator magnetic field vector. Unlike a TX or RX, the CT neither transmits nor receives torque. It is simply a sensitive angular position detector.
</para>

<image>02504.png<caption>Control transformer (CT) detects servo null.</caption></image>

<index>Servo motor, AC</index>
<index>Motor, AC, servo</index>


<para>
In Figure<ref>02504.png above</ref>, the  shaft of the TX is set to the desired position of the radar antenna. The servo system will cause the servo motor to drive the antenna to the commanded position. The CT compares the commanded to actual position and signals the servo amplifier to drive the motor until that commanded angle is achieved.
</para>

<image>02505.png<caption>Servo uses CT to sense antenna position null</caption></image>

<para>
When the control transformer rotor detects a null at 90<superscript>o</superscript> to the axis of the stator field, there is no rotor output. Any rotor displacement produces an AC error voltage proportional to displacement.  A <italic>servo</italic> (Figure<ref>02505.png above</ref>) seeks to minimize the error between a commanded and measured variable due to negative feedback. The control transformer compares the shaft angle to the stator magnetic field angle, sent by the TX stator.  When it measures a minimum, or null, the servo has driven the antenna and control transformer rotor to the commanded position. There is no error between measured and commanded position, no CT, control transformer, output to be amplified. The <italic>servo motor</italic>, a 2-phase motor, stops rotating. However, any CT detected error drives the amplifier which drives the motor until the error is minimized. This corresponds to the servo system having driven the antenna coupled CT to match the angle commanded by the TX.
</para>



<para>
The servo motor may drive a reduction gear train and be large compared to the TX and CT synchros. However, the poor efficiency of AC servo motors limits them to smaller loads. They are also difficult to control since they are constant speed devices. However, they can be controlled to some extent by varying the voltage to one phase with  line voltage on the other phase. Heavy loads are more efficiently driven by large DC servo motors.
</para>

<para>
Airborne applications use 400Hz components-- TX, CT, and servo motor. Size and weight of the AC magnetic components is inversely proportional to frequency. Therefore, use of 400 Hz components for aircraft applications, like moving control surfaces, saves size and weight.
</para>

</subsection>


<subsection>
<subsectiontitle><sp>Resolver</subsectiontitle>
<index>Synchro, resolver</index>
<index>Resolver, synchro</index>
<hypertarget>resolver[]</hypertarget>

<para>
A <italic>resolver</italic> (Figure<ref>02506.png below</ref>) has two stator windings placed at 90<superscript>o</superscript> to each other, and a single rotor winding driven by alternating current. A resolver is used for polar to rectangular conversion. An angle input at the rotor shaft produces rectangular co-ordinates sin<theta> and cos<theta> proportional voltages on the stator windings.
</para>

<image>02506.png<caption>Resolver converts shaft angle to sine and cosine of angle.</caption></image>

<para>
For example, a black-box within a radar encodes the distance to a target as a sine wave proportional voltage V, with the bearing angle as a shaft angle. Convert to X and Y co-ordinates. The sine wave is fed to the rotor of a resolver. The bearing angle shaft is coupled to the resolver shaft. The coordinates (X, Y) are available on the resolver stator coils:
<quotation>
X=V(cos(<angle>bearing)) 
</quotation>

<quotation>
Y=V(sin(<angle>bearing)) 
</quotation>

The Cartesian coordinates (X, Y) may be plotted on a map display.

</para>

<para>
A TX (torque transmitter) may be adapted for service as a resolver. (Figure<ref>02507.png below</ref>)
</para>

<image>02507.png<caption>Scott-T converts 3-<phi> to 2-<phi> enabling TX to perform resolver function.</caption></image>

<index>Scott-T transformer</index>
<index>Transformer, Scott-T</index>

<para>
It is possible to derive resolver-like quadrature angular components from a synchro transmitter by using a <italic>Scott-T</italic> transformer. The three TX outputs, 3-phases, are processed by a <italic> Scott-T</italic> transformer into a pair of quadrature components. See <hyperlink>scott[Scott-T][AC_9.html]</hyperlink>  chapter 9 for details.
</para>

<para>
There is also a linear version of the resolver known as an  <hyperlink>inductosyn[inductosyn][AC_12.html]</hyperlink>. The rotary version of the <italic>inductosyn</italic> has a finer resolution than a resolver.
</para>

</subsection>

<bigspace>
<bold>Summary:  Selsyn (synchro) motors</bold>
<itemize>

<item>A <italic>synchro</italic>, also known as a <italic>selsyn</italic>, is a rotary transformer used to transmit shaft torque.</item>
<item>A TX, <italic>torque transmitter</italic>, accepts a torque input at its shaft for transmission on three-phase electrical outputs.</item>
<item>An RX, <italic>torque receiver</italic>, accepts a three-phase electrical representation of an angular input for conversion to a torque output at its shaft. Thus, TX transmits a torque from an input shaft to a remote RX output shaft.</item>
<item>A TDX, <italic>torque differential transmitter</italic>, sums an electrical angle input with a shaft angle input producing an electrical angle output</item>
<item>A TDR, <italic>torque differential receiver, </italic> sums two electrical angle inputs producing a shaft angle output</item>
<item>A CT, <italic>control transformer</italic>, detects a null when the rotor is positioned at a right angle to the stator angle input. A CT is typically a component of a servo-- feedback system.</item>
<item>A <italic>Resolver</italic> outputs a quadrature  sin(<theta>) and cos(<theta>) representation of the shaft angle input instead of a three-phase output. </item>
<item>The three-phase output of a TX is converted to a resolver style output by a <italic>Scott-T transformer</italic>.</item>
</itemize>

</section>



<section>
<sectiontitle><sp>AC commutator motors </sectiontitle>
<index>Motor, AC commutator</index>


<para>
Charles Proteus Steinmetz's first job after arriving in America was to investigate problems encountered in the design of the alternating current version of the brushed commutator motor. The situation was so bad that motors could not be designed ahead of the actual construction. The success or failure of a motor design was not known until after it was actually built at great expense and tested.  He formulated the laws of magnetic <italic>hysteresis</italic> in finding a solution.  Hysteresis is a lagging behind of the magnetic field strength as compared to the magnetizing force. This produces a loss not present in DC magnetics. Low hysteresis alloys and breaking the alloy into thin insulated <italic>laminations</italic> made it possible to accurately design AC commutator motors before building.

</para>

<para>
AC commutator motors, like comparable DC motors, have higher starting torque and higher speed than AC induction motors. The series motor operates well above the synchronous speed of a conventional AC motor. AC commutator motors may be either single-phase or poly-phase. The single-phase AC version suffers a double line frequency torque pulsation, not present in poly-phase motor. Since a commutator motor can operate at much higher speed than an induction motor, it can output more power than a similar size induction motor. However commutator motors are not as maintenance free as induction motors, due to brush and commutator wear.
</para>


<subsection>
<subsectiontitle><sp>Single phase series motor </subsectiontitle>

<index>Motor, AC series</index>

<para>
If a DC series motor equipped with a laminated field is connected to AC, the lagging reactance of the field coil will considerably reduce the field current. While such a motor will rotate, operation is marginal.  While starting, armature windings connected to commutator segments shorted by the brushes look like shorted transformer turns to the field. This results in considerable arcing and sparking at the brushes as the armature begins to turn. This is less of a problem as speed increases, which shares the arcing and sparking between commutator segments.  The lagging reactance and arcing brushes are only tolerable in very small uncompensated series AC motors operated at high speed. Series AC motors smaller than hand drills and kitchen mixers may be uncompensated. (Figure<ref>02508.png below</ref>)
</para>


<image>02508.png<caption>Uncompensated series AC motor.</caption></image>

</subsection>

<comment><index>Compensated series AC motor</index></comment>
<index>Motor, AC, compensated series motor</index>

<subsection>
<subsectiontitle><sp>Compensated series motor </subsectiontitle>

<para>

The arcing and sparking is mitigated by placing a <italic>compensating winding</italic> in the stator in series with the armature positioned so that its magnetomotive force (mmf)  cancels out the armature AC mmf. (Figure<ref>02509.png below</ref>)  A smaller motor air gap and fewer field turns reduces lagging reactance in series with the armature improving the power factor. All but very small AC commutator motors employ compensating windings. Motors as large as those employed in a kitchen mixer, or larger,  use compensated stator windings.
</para>

<image>02509.png<caption>Compensated series AC motor.</caption></image>

</subsection>

<subsection>
<subsectiontitle><sp>Universal motor </subsectiontitle>

<index>Universal AC motor</index> 
<index>Motor, AC, universal</index>


<para>
It is possible to design small (under 300 watts) <italic>universal motors</italic> which run from either DC or AC.  Very small universal motors may be uncompensated. Larger higher speed universal motors use a compensating winding. A motor will run slower on AC than DC due to the reactance encountered with AC. However, the peaks of the sine waves saturate the magnetic path reducing total flux below the DC value, increasing the speed of the ``series'' motor. Thus, the offsetting effects result in a nearly constant speed from DC to 60 Hz. Small line operated appliances, such as drills, vacuum cleaners, and mixers, requiring  3000 to 10,000 rpm use universal motors. Though, the development of solid state rectifiers and inexpensive permanent magnets is making the DC permanent magnet motor a viable alternative.
</para>

</subsection>

<subsection>
<subsectiontitle><sp>Repulsion motor </subsectiontitle>
<index>Repulsion motor</index>
<index>Motor, repulsion</index>

<para>
A repulsion motor (Figure<ref>02510.png below</ref>) consists of a field directly connected to the AC line voltage and a pair of shorted brushes offset by 15<superscript>o</superscript>to 25<superscript>o</superscript> from the field axis. The field induces a current flow into the shorted armature whose magnetic field opposes that of the field coils. Speed can be conrolled by rotating the brushes with respect to the field axis. This motor has superior commutation below synchronous speed, inferior commutation above synchronous speed. Low starting current produces high starting torque.
</para>

<image>02510.png<caption>Repulsion AC motor.</caption></image>

</subsection>

<subsection>
<subsectiontitle><sp>Repulsion start induction motor </subsectiontitle>

<index>Repulsion start induction motor</index>
<index>Motor, repulsion start induction</index>
<index>Induction motor, repulsion start</index>


<para>
When an induction motor drives a hard starting load like a compressor, the high starting torque of the repulsion motor may be put to use. The induction motor rotor windings are brought out to commutator segments for starting by a pair of shorted brushes. At near running  speed, a centrifugal switch shorts out all commutator segments, giving the effect of a squirrel cage rotor .  The brushes may also be lifted to prolong bush life. Starting torque is 300% to 600% of the full speed value as compared to under 200% for a pure induction motor.
</para>

</subsection>

<bigspace>
<bold>Summary: AC commutator motors</bold>
<itemize>
<item>The <italic>single phase series motor</italic> is an attempt to build a motor like a DC commutator motor. The resulting motor is only practical in the smallest sizes.</item>
<item>The addition of a compensating winding yields the <italic>compensated series motor</italic>, overcoming excessive commutator sparking. Most AC commutator motors are this type. At high speed this motor provides more power than a same-size induction motor, but is not maintenance free.</item>
<item>It is possible to produce small appliance motors powered by either AC or DC. This is known as a <italic>universal motor</italic>.</item>
<item>The AC line is directly connected to the stator of a <italic>repulsion motor </italic> with the commutator shorted by the brushes.</item>
<item>Retractable shorted brushes may start a wound rotor induction motor. This is known as a <italic>repulsion start induction motor</italic>.</item>
</itemize>


</section>


<thebibliography>


<bibitem>[1]``American Superconductor achieves full power of 5MW Ship motor'', at <url>http://www.spacedaily.com/news/energy-tech-04zzn.html[www.spacedaily.com/news/energy-tech-04zzn.html]</url></bibitem> 

<bibitem>[2]``Linear motor applications guide'', (Aerotech, Inc., Pittsburg, PA)  <url>http://www.aerotech.com/products/PDF/LMAppGuide.pdf [www.aerotech.com/products/PDF/LMAppGuide.pdf]</url>opt_txt</bibitem>

<bibitem>[3]``Linear motor outperforms steam-piston catapults'', Design News, <url>http://www.designnews.com/index.asp?layout=article&articleid=CA151563&cfd=1[www.designnews.com/index.asp?layout=article&articleid=CA151563&cfd=1]</url></bibitem> 

<bibitem>[4]``Future Aircraft Carrier - CVF, Navy Matters'', <url>http://navy-matters.beedall.com/cvf3-2.htm [http://navy-matters.beedall.com<allowbreak>/cvf3-2.htm]</url></bibitem>

<bibitem>[5]Bill Schweber, ``Electronics poised to replace steam-powered aircraft launch system'',  EDN, (4/11/2002). <url>http://www.edn.com/article/CA207108.html?pubdate=04%2F11%2F2002[www.edn.com/article/CA207108.html?pubdate=04%2F11%2F2002]</url></bibitem>

<bibitem>[6]``Operating 60 cycle motors as generators'', Red Rock Energy <url>http://www.redrok.com/cimtext.pdf[www.redrok.com/cimtext.pdf]</url></bibitem>

<bibitem>[7]``Energy Saver systems for Induction motors'',  M Photonics Ltd, P.O. Box 13 076, Christchurch, New Zealand at
<url>http://www.lmphotonics.com/energy.htm[http://www.lmphotonics.com/energy.htm]</url></bibitem>

<bibitem>[8] Matt Isserstedt``Building an Auto-Start Rotary Three Phase Converter'', May 2008, at <url>http://www.metalwebnews.com/howto/phase-converter/phase-converter.html[http://www.metalwebnews.com/howto/phase-converter/phase-converter.html]</url></bibitem>

<bibitem>[9]Jim Hanrahan``Building a Phase Converter'', December 1995, at <url>http://www.metalwebnews.com/howto/ph-conv/ph-conv.html[http://www.metalwebnews.com/howto/ph-conv/ph-conv.html]</url></bibitem>


</thebibliography>


</chapter>


<pagebreak>


