<comment>Modified 02/09/2005 (DC) Floating figures w/ captions </comment>

<chapter>
<chaptertitle>BASIC AC THEORY</chaptertitle>


<section>
<sectiontitle>What is alternating current (AC)?</sectiontitle>

<index>AC</index>
<index>Alternating current</index>
<index>DC</index>
<index>Direct current</index>

<para>
Most students of electricity begin their study with what is known as <italic>direct current</italic> (DC), which is electricity flowing in a constant direction, and/or possessing a voltage with constant polarity.  DC is the kind of electricity made by a battery (with definite positive and negative terminals), or the kind of charge generated by rubbing certain types of materials against each other.
</para>
 
<para>
As useful and as easy to understand as DC is, it is not the only ``kind'' of
electricity in use.  Certain sources of electricity (most notably, rotary
electro-mechanical generators) naturally produce voltages alternating in
polarity, reversing positive and negative over time.  Either as a voltage
switching polarity or as a current switching direction back and forth, this
``kind'' of electricity is known as Alternating Current (AC): Figure<ref>02001.png below</ref>
</para>
 
<image>02001.png<caption>Direct vs alternating current</caption></image> 

<para>
Whereas the familiar battery symbol is used as a generic symbol for any DC voltage source, the circle with the wavy line inside is the generic symbol for any AC voltage source.
</para>
 
<para>
One might wonder why anyone would bother with such a thing as AC.  It is true that in some cases AC holds no practical advantage over DC.  In applications where electricity is used to dissipate energy in the form of heat, the polarity or direction of current is irrelevant, so long as there is enough voltage and current to the load to produce the desired heat (power dissipation).  However, with AC it is possible to build electric generators, motors and power distribution systems that are far more efficient than DC, and so we find AC used predominately across the world in high power applications.  To explain the details of why this is so, a bit of background knowledge about AC is necessary.
</para>
 
<index>Alternator</index>
<index>Electromagnetic induction</index>
<index>Induction, electromagnetic</index>

<para>
If a machine is constructed to rotate a magnetic field around a set of stationary wire coils with the turning of a shaft, AC voltage will be produced across the wire coils as that shaft is rotated, in accordance with Faraday's Law of electromagnetic induction.  This is the basic operating principle of an AC generator, also known as an <italic>alternator</italic>: Figure<ref>02002.png below</ref>
</para>

<image>02002.png<caption>Alternator operation</caption></image> 

<para>
Notice how the polarity of the voltage across the wire coils reverses as the opposite poles of the rotating magnet pass by.  Connected to a load, this reversing voltage polarity will create a reversing current direction in the circuit.  The faster the alternator's shaft is turned, the faster the magnet will spin, resulting in an alternating voltage and current that switches directions more often in a given amount of time.
</para>
 
<index>Generator</index>
<index>Brush, generator</index>

<para>
While DC generators work on the same general principle of electromagnetic
induction, their construction is not as simple as their AC counterparts.  With
a DC generator, the coil of wire is mounted in the shaft where the magnet is on
the AC alternator, and electrical connections are made to this spinning coil
via stationary carbon ``brushes'' contacting copper strips on the rotating
shaft.  All this is necessary to switch the coil's changing output polarity to
the external circuit so the external circuit sees a constant polarity:
Figure<ref>02003.png below</ref>
</para>

<image>02003.png<caption>DC generator operation</caption></image> 

<para>
The generator shown above will produce two pulses of voltage per revolution of the shaft, both pulses in the same direction (polarity).  In order for a DC generator to produce <italic>constant</italic> voltage, rather than brief pulses of voltage once every 1/2 revolution, there are multiple sets of coils making intermittent contact with the brushes.  The diagram shown above is a bit more simplified than what you would see in real life.
</para>
 
<para>
The problems involved with making and breaking electrical contact with a moving coil should be obvious (sparking and heat), especially if the shaft of the generator is revolving at high speed.  If the atmosphere surrounding the machine contains flammable or explosive vapors, the practical problems of spark-producing brush contacts are even greater.  An AC generator (alternator) does not require brushes and commutators to work, and so is immune to these problems experienced by DC generators.
</para>
 
<para>
The benefits of AC over DC with regard to generator design is also reflected in electric motors.  While DC motors require the use of brushes to make electrical contact with moving coils of wire, AC motors do not.  In fact, AC and DC motor designs are very similar to their generator counterparts (identical for the sake of this tutorial), the AC motor being dependent upon the reversing magnetic field produced by alternating current through its stationary coils of wire to rotate the rotating magnet around on its shaft, and the DC motor being dependent on the brush contacts making and breaking connections to reverse current through the rotating coil every 1/2 rotation (180 degrees).
</para>
 
<index>Mutual induction</index>
<index>Induction, mutual</index>
<index>Transformer</index>

<para>
So we know that AC generators and AC motors tend to be simpler than DC
generators and DC motors.  This relative simplicity translates into greater
reliability and lower cost of manufacture.  But what else is AC good for?
Surely there must be more to it than design details of generators and motors!
Indeed there is.  There is an effect of electromagnetism known as
<italic>mutual induction</italic>, whereby two or more coils of wire placed so
that the changing magnetic field created by one induces a voltage in the
other.  If we have two mutually inductive coils and we energize one coil with
AC, we will create an AC voltage in the other coil.  When used as such, this
device is known as a <italic>transformer</italic>: Figure<ref>02004.png below</ref>
</para>

<image>02004.png<caption>Transformer ``transforms'' AC voltage and current.</caption></image> 

<index>Transformer coils, primary and secondary</index>
<index>Primary transformer coil</index>
<index>Secondary transformer coil</index>

<para>
The fundamental significance of a transformer is its ability to step voltage up
or down from the powered coil to the unpowered coil.  The AC voltage induced in
the unpowered (``secondary'') coil is equal to the AC voltage across the powered
(``primary'') coil multiplied by the ratio of secondary coil turns to primary
coil turns.  If the secondary coil is powering a load, the current through the
secondary coil is just the opposite: primary coil current multiplied by the
ratio of primary to secondary turns.  This relationship has a very close
mechanical analogy, using torque and speed to represent voltage and current,
respectively: Figure<ref>02005.png below</ref>
</para>

<image>02005.png<caption>Speed multiplication gear train steps torque down and speed up. Step-down transformer steps voltage down and current up.</caption></image> 

<para>
If the winding ratio is reversed so that the primary coil has less turns than
the secondary coil, the transformer ``steps up'' the voltage from the source
level to a higher level at the load: Figure<ref>02006.png below</ref>
</para>

<image>02006.png<caption>Speed reduction gear train steps torque up and speed down. Step-up transformer steps voltage up and current down.</caption></image>

<para>
The transformer's ability to step AC voltage up or down with ease gives AC an advantage unmatched by DC in the realm of power distribution in figure<ref>02007.png below</ref>.  When transmitting electrical power over long distances, it is far more efficient to do so with stepped-up voltages and stepped-down currents (smaller-diameter wire with less resistive power losses), then step the voltage back down and the current back up for industry, business, or consumer use.
</para>
 
<image>02007.png<caption>Transformers enable efficient long distance high voltage transmission of electric energy.</caption></image> 
 
<para>
Transformer technology has made long-range electric power distribution practical.  Without the ability to efficiently step voltage up and down, it would be cost-prohibitive to construct power systems for anything but close-range (within a few miles at most) use.
</para>
 
<para>
As useful as transformers are, they only work with AC, not DC.  Because the phenomenon of mutual inductance relies on <italic>changing</italic> magnetic fields, and direct current (DC) can only produce steady magnetic fields, transformers simply will not work with direct current.  Of course, direct current may be interrupted (pulsed) through the primary winding of a transformer to create a changing magnetic field (as is done in automotive ignition systems to produce high-voltage spark plug power from a low-voltage DC battery), but pulsed DC is not that different from AC.  Perhaps more than any other reason, this is why AC finds such widespread application in power systems.
</para>
 
<itemize>
<item><bold>REVIEW:</bold></item>
<item>DC stands for ``Direct Current,'' meaning voltage or current that maintains constant polarity or direction, respectively, over time.</item>
<item>AC stands for ``Alternating Current,'' meaning voltage or current that changes polarity or direction, respectively, over time.</item>
<item>AC electromechanical generators, known as <italic>alternators</italic>, are of simpler construction than DC electromechanical generators.</item>
<item>AC and DC motor design follows respective generator design principles very closely.</item>
<item>A <italic>transformer</italic> is a pair of mutually-inductive coils used to convey AC power from one coil to the other.  Often, the number of turns in each coil is set to create a voltage increase or decrease from the powered (primary) coil to the unpowered (secondary) coil.</item>
<item>Secondary voltage = Primary voltage (secondary turns / primary turns)</item>
<item>Secondary current = Primary current (primary turns / secondary turns)</item>
</itemize>


</section>





<section>
<sectiontitle>AC waveforms</sectiontitle>


 
<index>Sine wave</index>
<index>Wave, sine</index> 

<para>
When an alternator produces AC voltage, the voltage switches polarity over time, but does so in a very particular manner.  When graphed over time, the ``wave'' traced by this voltage of alternating polarity from an alternator takes on a distinct shape, known as a <italic>sine wave</italic>: Figure<ref>02008.png below</ref>
</para>
 
<image>02008.png<caption>Graph of AC voltage over time (the sine wave).</caption></image>

<index>Sine function</index>
<index>Function, sine</index>
 
<para>
In the voltage plot from an electromechanical alternator, the change from one polarity to the other is a smooth one, the voltage level changing most rapidly at the zero (``crossover'') point and most slowly at its peak.  If we were to graph the trigonometric function of ``sine'' over a horizontal range of 0 to 360 degrees, we would find the exact same pattern as in Table<ref>sine.tbl below</ref>.
</para>


<table>sine.tbl<caption>Trigonometric ``sine'' function.</caption>
<tabular>{|r|r|r||r|r|r|}
<hr>

<tr>
<th>Angle (<superscript>o</superscript>)</th><th>sin(angle)</th><th>wave</th><th>Angle (<superscript>o</superscript>)</th><th>sin(angle)</th><th>wave</th>
</tr>
<hr>

<tr>
<td>0</td><td>0.0000</td><td>zero</td><td>180</td><td>0.0000</td><td>zero</td>
</tr>
<tr>
<td>15</td><td>0.2588</td><td>+</td><td>195</td><td>-0.2588</td><td>-</td>
</tr>
<tr>
<td>30</td><td>0.5000</td><td>+</td><td>210</td><td>-0.5000</td><td>-</td>
</tr>
<tr>
<td>45</td><td>0.7071</td><td>+</td><td>225</td><td>-0.7071</td><td>-</td>
</tr>
<tr>
<td>60</td><td>0.8660</td><td>+</td><td>240</td><td>-0.8660</td><td>-</td>
</tr>
<tr>
<td>75</td><td>0.9659</td><td>+</td><td>255</td><td>-0.9659</td><td>-</td>
</tr>
<tr>
<td>90</td><td>1.0000</td><td>+peak</td><td>270</td><td>-1.0000</td><td>-peak</td>
</tr>
<tr>
<td>105</td><td>0.9659</td><td>+</td><td>285</td><td>-0.9659</td><td>-</td>
</tr>
<tr>
<td>120</td><td>0.8660</td><td>+</td><td>300</td><td>-0.8660</td><td>-</td>
</tr>
<tr>
<td>135</td><td>0.7071</td><td>+</td><td>315</td><td>-0.7071</td><td>-</td>
</tr>
<tr>
<td>150</td><td>0.5000</td><td>+</td><td>330</td><td>-0.5000</td><td>-</td>
</tr>
<tr>
<td>165</td><td>0.2588</td><td>+</td><td>345</td><td>-0.2588</td><td>-</td>
</tr>
<tr>
<td>180</td><td>0.0000</td><td>zero</td><td>360</td><td>0.0000</td><td>zero</td>
</tr>

<hr>

</tabular>
</table>


<bigspace>

<para>
The reason why an electromechanical alternator outputs sine-wave AC is due to the physics of its operation.  The voltage produced by the stationary coils by the motion of the rotating magnet is proportional to the rate at which the magnetic flux is changing perpendicular to the coils (Faraday's Law of Electromagnetic Induction).  That rate is greatest when the magnet poles are closest to the coils, and least when the magnet poles are furthest away from the coils.  Mathematically, the rate of magnetic flux change due to a rotating magnet follows that of a sine function, so the voltage produced by the coils follows that same function.
</para>
 
<index>Cycle</index>

<para>
If we were to follow the changing voltage produced by a coil in an alternator from any point on the sine wave graph to that point when the wave shape begins to repeat itself, we would have marked exactly one <italic>cycle</italic> of that wave.  This is most easily shown by spanning the distance between identical peaks, but may be measured between any corresponding points on the graph.  The degree marks on the horizontal axis of the graph represent the domain of the trigonometric sine function, and also the angular position of our simple two-pole alternator shaft as it rotates: Figure<ref>02009.png below</ref>
</para>
 
<image>02009.png<caption>Alternator voltage as function of shaft position (time).</caption></image> 
 
<index>Period</index>
 
<para>
Since the horizontal axis of this graph can mark the passage of time as well as shaft position in degrees, the dimension marked for one cycle is often measured in a unit of time, most often seconds or fractions of a second.  When expressed as a measurement, this is often called the <italic>period</italic> of a wave.  The period of a wave in degrees is <italic>always</italic> 360, but the amount of time one period occupies depends on the rate voltage oscillates back and forth.
</para>
 
<index>Frequency</index>
<index>Hertz, unit</index>
<index>Unit, Hertz</index>

<para>
A more popular measure for describing the alternating rate of an AC voltage or current wave than <italic>period</italic> is the rate of that back-and-forth oscillation.  This is called <italic>frequency</italic>.  The modern unit for frequency is the Hertz (abbreviated Hz), which represents the number of wave cycles completed during one second of time.  In the United States of America, the standard power-line frequency is 60 Hz, meaning that the AC voltage oscillates at a rate of 60 complete back-and-forth cycles every second.  In Europe, where the power system frequency is 50 Hz, the AC voltage only completes 50 cycles every second.  A radio station transmitter broadcasting at a frequency of 100 MHz generates an AC voltage oscillating at a rate of 100 <italic>million</italic> cycles every second.
</para>

<index>CPS, unit</index>
<index>Unit, CPS</index>
<index>Celsius, unit</index>
<index>Unit, Celsius</index>
<index>Centigrade, unit</index>
<index>Unit, Centigrade</index>

<para>
Prior to the canonization of the Hertz unit, frequency was simply expressed as ``cycles per second.''  Older meters and electronic equipment often bore frequency units of ``CPS'' (Cycles Per Second) instead of Hz.  Many people believe the change from self-explanatory units like CPS to Hertz constitutes a step backward in clarity.  A similar change occurred when the unit of ``Celsius'' replaced that of ``Centigrade'' for metric temperature measurement.  The name Centigrade was based on a 100-count (``Centi-'') scale (``-grade'') representing the melting and boiling points of H<subscript>2</subscript>O, respectively.  The name Celsius, on the other hand, gives no hint as to the unit's origin or meaning.
</para>
 
<para>
Period and frequency are mathematical reciprocals of one another.  That is to say, if a wave has a period of 10 seconds, its frequency will be 0.1 Hz, or 1/10 of a cycle per second:
</para>

<image>12002.png</image> 

<index>Oscilloscope</index>
<index>ECG</index>
<index>EKG</index>
<index>Electrocardiograph</index>

<para>
An instrument called an <italic>oscilloscope</italic>, Figure<ref>02410.png below</ref>, is used to display a changing voltage over time on a graphical screen.  You may be familiar with the appearance of an <italic>ECG</italic> or <italic>EKG</italic> (electrocardiograph) machine, used by physicians to graph the oscillations of a patient's heart over time.  The ECG is a special-purpose oscilloscope expressly designed for medical use.  General-purpose oscilloscopes have the ability to display voltage from virtually any voltage source, plotted as a graph with time as the independent variable.  The relationship between period and frequency is very useful to know when displaying an AC voltage or current waveform on an oscilloscope screen.  By measuring the period of the wave on the horizontal axis of the oscilloscope screen and reciprocating that time value (in seconds), you can determine the frequency in Hertz.
</para>
 
<image>02410.png<caption>Time period of sinewave is shown on oscilloscope.</caption></image> 

<index>Sound waves</index>

<para>
Voltage and current are by no means the only physical variables subject to variation over time.  Much more common to our everyday experience is <italic>sound</italic>, which is nothing more than the alternating compression and decompression (pressure waves) of air molecules, interpreted by our ears as a physical sensation.  Because alternating current is a wave phenomenon, it shares many of the properties of other wave phenomena, like sound.  For this reason, sound (especially structured music) provides an excellent analogy for relating AC concepts.
</para>
 
<index>Pitch (musical)</index>

<para>
In musical terms, frequency is equivalent to <italic>pitch</italic>.  Low-pitch notes such as those produced by a tuba or bassoon consist of air molecule  vibrations that are relatively slow (low frequency).  High-pitch notes such as those produced by a flute or whistle consist of the same type of vibrations in the air, only vibrating at a much faster rate (higher frequency). Figure<ref>02276.png below</ref> is a table showing the actual frequencies for a range of common musical notes.
</para>

<image>02276.png<caption>The frequency in Hertz (Hz) is shown for various musical notes.</caption></image> 

<para>
Astute observers will notice that all notes on the table bearing the same letter designation are related by a frequency ratio of 2:1.  For example, the first frequency shown (designated with the letter ``A'') is 220 Hz.  The next highest ``A'' note has a frequency of 440 Hz -- exactly twice as many sound wave cycles per second.  The same 2:1 ratio holds true for the first A sharp (233.08 Hz) and the next A sharp (466.16 Hz), and for all note pairs found in the table.
</para>
 
<index>Octave</index>

<para>
Audibly, two notes whose frequencies are exactly double each other sound remarkably similar.  This similarity in sound is musically recognized, the shortest span on a musical scale separating such note pairs being called an <italic>octave</italic>.  Following this rule, the next highest ``A'' note (one  octave above 440 Hz) will be 880 Hz, the next lowest ``A'' (one octave below 220 Hz) will be 110 Hz.  A view of a piano keyboard helps to put this scale into  perspective: Figure<ref>02277.png below</ref>
</para>

<index>Keyboard, piano</index>
<index>Piano</index>
 
<image>02277.png<caption>An octave is shown on a musical keyboard.</caption></image>
 
<para>
As you can see, one octave is equal to <italic>seven</italic> white keys' worth of distance on a piano keyboard.  The familiar musical mnemonic (doe-ray-mee-fah-so-lah-tee) -- yes, the same pattern immortalized in the whimsical Rodgers and Hammerstein song sung in <underline>The Sound of Music</underline> -- covers one octave from C to C. 
</para>
 
<para>
While electromechanical alternators and many other physical phenomena naturally
produce sine waves, this is not the only kind of alternating wave in
existence.  Other ``waveforms'' of AC are commonly produced within electronic
circuitry.  Here are but a few sample waveforms and their common designations
in figure<ref>02010.png below</ref></para>
 
<image>02010.png<caption>Some common waveshapes (waveforms).</caption></image> 

<index>Square wave</index>
<index>Wave, square</index>
<index>Triangle wave</index> 
<index>Wave, triangle</index>
<index>Sawtooth wave</index> 
<index>Wave, sawtooth</index>
<index>Sinusoidal</index>
<index>Non-sinusoidal</index>

<para>
These waveforms are by no means the only kinds of waveforms in existence.  They're simply a few that are common enough to have been given distinct names.  Even in circuits that are supposed to manifest ``pure'' sine, square, triangle, or sawtooth voltage/current waveforms, the real-life result is often a distorted version of the intended waveshape.  Some waveforms are so complex that they defy classification as a particular ``type'' (including waveforms associated with many kinds of musical instruments).  Generally speaking, any waveshape bearing close resemblance to a perfect sine wave is termed <italic>sinusoidal</italic>, anything different being labeled as <italic>non-sinusoidal</italic>.  Being that the waveform of an AC voltage or current is crucial to its impact in a circuit, we need to be aware of the fact that AC waves come in a variety of shapes.
</para>
  
<itemize>
<item><bold>REVIEW:</bold></item>
<item>AC produced by an electromechanical alternator follows the graphical shape of a sine wave.</item>
<item>One <italic>cycle</italic> of a wave is one complete evolution of its shape until the point that it is ready to repeat itself.</item>
<item>The <italic>period</italic> of a wave is the amount of time it takes to complete one cycle.</item>
<item><italic>Frequency</italic> is the number of complete cycles that a wave completes in a given amount of time.  Usually measured in Hertz (Hz), 1 Hz being equal to one complete wave cycle per second.</item>
<item>Frequency = 1/(period in seconds)</item>
</itemize>

</section>





<section>
<sectiontitle>Measurements of AC magnitude</sectiontitle>

<para>
So far we know that AC voltage alternates in polarity and AC current alternates in direction.  We also know that AC can alternate in a variety of different ways, and by tracing the alternation over time we can plot it as a ``waveform.''  We can measure the rate of alternation by measuring the time it takes for a wave to evolve before it repeats itself (the ``period''), and express this as cycles per unit time, or ``frequency.''  In music, frequency is the same as <italic>pitch</italic>, which is the essential property distinguishing one note from another.
</para>
 
<para>
However, we encounter a measurement problem if we try to express how large or small an AC quantity is.  With DC, where quantities of voltage and current are generally stable, we have little trouble expressing how much voltage or current we have in any part of a circuit.  But how do you grant a single measurement of magnitude to something that is constantly changing?
</para>
 
<index>Amplitude</index>
<index>Magnitude</index>
<index>Peak</index>
<index>Crest</index>
<index>Amplitude, peak</index>

<para>
One way to express the intensity, or magnitude (also called the <italic>amplitude</italic>), of an AC quantity is to measure its peak height on  a waveform graph.  This is known as the <italic>peak</italic> or    <italic>crest</italic> value of an AC waveform: Figure<ref>02011.png below</ref></para>
 
<image>02011.png<caption>Peak voltage of a waveform.</caption></image>
 
<index>Peak-to-peak</index>
<index>Amplitude, peak-to-peak</index>

<para>
Another way is to measure the total height between opposite peaks.  This is known as the <italic>peak-to-peak</italic> (P-P) value of an AC waveform:  Figure<ref>02012.png below</ref>
</para>

<image>02012.png<caption>Peak-to-peak voltage of a waveform.</caption></image> 

<para>
Unfortunately, either one of these expressions of waveform amplitude can be misleading when comparing two different types of waves.  For example, a square wave peaking at 10 volts is obviously a greater amount of voltage for a greater amount of time than a triangle wave peaking at 10 volts.  The effects of these two AC voltages powering a load would be quite different: Figure<ref>02013.png below</ref>
</para>
 
<image>02013.png<caption>A square wave produces a greater heating effect than the same peak voltage triangle wave.</caption></image>
 
<index>Average amplitude, AC</index>
<index>Amplitude, average</index>

<para>
One way of expressing the amplitude of different waveshapes in a more equivalent fashion is to mathematically average the values of all the points on a waveform's graph to a single, aggregate number.  This amplitude measure is known simply as the <italic>average</italic> value of the waveform.  If we average all the points on the waveform algebraically (that is, to consider  their <italic>sign</italic>, either positive or negative), the average value for most waveforms is technically zero, because all the positive points cancel out all the negative points over a full cycle: Figure<ref>02412.png below</ref>
</para>

<image>02412.png<caption>The average value of a sinewave is zero.</caption></image> 

<para>
This, of course, will be true for any waveform having equal-area portions above and below the ``zero'' line of a plot.  However, as a <italic>practical</italic> measure of a waveform's aggregate value, ``average'' is usually defined as the mathematical mean of all the points' <italic>absolute values</italic> over a cycle.  In other words, we calculate the practical average value of the waveform by considering all points on the wave as positive quantities, as if the waveform looked like this: Figure<ref>02413.png below</ref>
</para>

<image>02413.png<caption>Waveform seen by AC ``average responding'' meter.</caption></image>

<para>
Polarity-insensitive mechanical meter movements (meters designed to respond equally to the positive and negative half-cycles of an alternating voltage or current) register in proportion to the waveform's (practical) average value, because the inertia of the pointer against the tension of the spring naturally averages the force produced by the varying voltage/current values over time.  Conversely, polarity-sensitive meter movements vibrate uselessly if exposed to AC voltage or current, their needles oscillating rapidly about the zero mark, indicating the true (algebraic) average value of zero for a symmetrical waveform.  When the ``average'' value of a waveform is referenced in this text, it will be assumed that the ``practical'' definition of average is intended unless otherwise specified.
</para>

<para>
Another method of deriving an aggregate value for waveform amplitude is based on the waveform's ability to do useful work when applied to a load resistance.  Unfortunately, an AC measurement based on work performed by a waveform is not the same as that waveform's ``average'' value, because the <italic>power</italic> dissipated by a given load (work performed per unit time) is not directly proportional to the magnitude of either the voltage or current impressed upon it.  Rather, power is proportional to the <italic>square</italic> of the voltage or current applied to a resistance (P = E<superscript>2</superscript>/R, and P = I<superscript>2</superscript>R).  Although the mathematics of such an amplitude measurement might not be straightforward, the utility of it is.
</para>
 
<para>
Consider a bandsaw and a jigsaw, two pieces of modern woodworking equipment.  Both types of saws cut with a thin, toothed, motor-powered metal blade to cut wood.  But while the bandsaw uses a continuous motion of the blade to cut, the  jigsaw uses a back-and-forth motion.  The comparison of alternating current (AC) to direct current (DC) may be likened to the comparison of these two saw types: Figure<ref>02014.png below</ref>
</para>
 
<image>02014.png<caption>Bandsaw-jigsaw analogy of DC vs AC.</caption></image> 

<para>
The problem of trying to describe the changing quantities of AC voltage or current in a single, aggregate measurement is also present in this saw analogy: how might we express the speed of a jigsaw blade?  A bandsaw blade moves with a constant speed, similar to the way DC voltage pushes or DC current moves with a constant magnitude.  A jigsaw blade, on the other hand, moves back and forth, its blade speed constantly changing.  What is more, the back-and-forth motion of any two jigsaws may not be of the same type, depending on the mechanical design of the saws.  One jigsaw might move its blade with a sine-wave motion, while another with a triangle-wave motion.  To rate a jigsaw based on its <italic>peak</italic> blade speed would be quite misleading when comparing one jigsaw to another (or a jigsaw with a bandsaw!).  Despite the fact that these different saws move their blades in different manners, they are equal in one respect: they all cut wood, and a quantitative comparison of this common function can serve as a common basis for which to rate blade speed.
</para>
 
<para>
Picture a jigsaw and bandsaw side-by-side, equipped with identical blades (same tooth pitch, angle, etc.), equally capable of cutting the same thickness of the same type of wood at the same rate.  We might say that the two saws were equivalent or equal in their cutting capacity.  Might this comparison be used to assign a ``bandsaw equivalent'' blade speed to the jigsaw's back-and-forth blade motion; to relate the wood-cutting effectiveness of one to the other?  This is the general idea used to assign a ``DC equivalent'' measurement to any AC voltage or current: whatever magnitude of DC voltage or current would produce the same amount of heat energy dissipation through an equal resistance:Figure<ref>02015.png below</ref>
</para>

<image>02015.png<caption>An RMS voltage produces the same heating effect as a the same DC voltage</caption></image> 
 
<index>Root-Mean-Square</index>
<index>RMS</index>
<index>Equivalent, AC to DC</index>
<index>DC equivalent, AC measurement</index>
<index>Amplitude, RMS</index>

<para>
In the two circuits above, we have the same amount of load resistance (2 <OMEGA>) dissipating the same amount of power in the form of heat (50 watts), one powered by AC and the other by DC.  Because the AC voltage source pictured above is equivalent (in terms of power delivered to a load) to a 10 volt DC battery, we would call this a ``10 volt'' AC source.  More specifically, we would denote its voltage value as being 10 volts <italic>RMS</italic>.  The qualifier ``RMS'' stands for <italic>Root Mean Square</italic>, the algorithm used to obtain the DC equivalent value from points on a graph (essentially, the procedure consists of squaring all the positive and negative points on a waveform graph, averaging those squared values, then taking the square root of that average to obtain the final answer).  Sometimes the alternative terms <italic>equivalent</italic> or <italic>DC equivalent</italic> are used instead of ``RMS,'' but the quantity and principle are both the same.
</para>
 
<para>
RMS amplitude measurement is the best way to relate AC quantities to DC quantities, or other AC quantities of differing waveform shapes, when dealing with measurements of electric power.  For other considerations, peak or peak-to-peak measurements may be the best to employ.  For instance, when determining the proper size of wire (ampacity) to conduct electric power from a source to a load, RMS current measurement is the best to use, because the principal concern with current is overheating of the wire, which is a function of power dissipation caused by current through the resistance of the wire.  However, when rating insulators for service in high-voltage AC applications, peak voltage measurements are the most appropriate, because the principal concern here is insulator ``flashover'' caused by brief spikes of voltage, irrespective of time.
</para>
 
<index>D'Arsonval meter movement</index>
<index>Weston meter movement</index>
<index>Iron-vane meter movement</index>
<index>True-RMS meter</index>

<para>
Peak and peak-to-peak measurements are best performed with an oscilloscope, which can capture the crests of the waveform with a high degree of accuracy due to the fast action of the cathode-ray-tube in response to changes in voltage.  For RMS measurements, analog meter movements (D'Arsonval, Weston, iron vane, electrodynamometer) will work so long as they have been calibrated in RMS figures.  Because the mechanical inertia and dampening effects of an electromechanical meter movement makes the deflection of the needle naturally proportional to the <italic>average</italic> value of the AC, not the true RMS value, analog meters must be specifically calibrated (or mis-calibrated, depending on how you look at it) to indicate voltage or current in RMS units.  The accuracy of this calibration depends on an assumed waveshape, usually a sine wave.
</para>

<para>
Electronic meters specifically designed for RMS measurement are best for the task.  Some instrument manufacturers have designed ingenious methods for determining the RMS value of any waveform.  One such manufacturer produces ``True-RMS'' meters with a tiny resistive heating element powered by a voltage proportional to that being measured.  The heating effect of that resistance element is measured thermally to give a true RMS value with no mathematical calculations whatsoever, just the laws of physics in action in fulfillment of the definition of RMS.  The accuracy of this type of RMS measurement is independent of waveshape.
</para>
 
<para>
For ``pure'' waveforms, simple conversion coefficients exist for equating Peak, Peak-to-Peak, Average (practical, not algebraic), and RMS measurements to one another: Figure<ref>02016.png below</ref>
</para>
 
<image>02016.png<caption>Conversion factors for common waveforms.</caption></image> 
 
<index>Crest factor</index>
<index>Factor, crest</index>
<index>Form factor</index>
<index>Factor, form</index>

<para>
In addition to RMS, average, peak (crest), and peak-to-peak measures of an AC waveform, there are ratios expressing the proportionality between some of these fundamental measurements.  The <italic>crest factor</italic> of an AC waveform, for instance, is the ratio of its peak (crest) value divided by its RMS value.  The <italic>form factor</italic> of an AC waveform is the ratio of its RMS value divided by its average value. Square-shaped waveforms always have crest and form factors equal to 1, since the peak is the same as the RMS and average values. Sinusoidal waveforms have an RMS value of 0.707 (the reciprocal of the square root of 2) and a form factor of 1.11 (0.707/0.636). Triangle- and sawtooth-shaped waveforms have RMS values of 0.577 (the reciprocal of square root of 3) and  form factors of 1.15 (0.577/0.5).
</para>

<para>
Bear in mind that the conversion constants shown here for peak, RMS, and average amplitudes of sine waves, square waves, and triangle waves hold true only for <italic>pure</italic> forms of these waveshapes.  The RMS and average values of distorted waveshapes are not related by the same ratios: Figure<ref>02017.png below</ref>
</para>
 
<image>02017.png<caption>Arbitrary waveforms have no simple conversions.</caption></image> 

<para>
This is a very important concept to understand when using an analog D'Arsonval meter movement to measure AC voltage or current.  An analog D'Arsonval movement, calibrated to indicate sine-wave RMS amplitude, will only be accurate when measuring pure sine waves.  If the waveform of the voltage or current being measured is anything but a pure sine wave, the indication given by the meter will not be the true RMS value of the waveform, because the degree of needle deflection in an analog D'Arsonval meter movement is proportional to the <italic>average</italic> value of the waveform, not the RMS.  RMS meter calibration is obtained by ``skewing'' the span of the meter so that it displays a small multiple of the average value, which will be equal to be the RMS value for a particular waveshape and <italic>a particular waveshape only</italic>.  
</para>
 
<para>
Since the sine-wave shape is most common in electrical measurements, it is the waveshape assumed for analog meter calibration, and the small multiple used in the calibration of the meter is 1.1107 (the form factor: 0.707/0.636: the ratio of RMS divided by average for a sinusoidal waveform).  Any waveshape other than a pure sine wave will have a different ratio of RMS and average values, and thus a meter calibrated for sine-wave voltage or current will not indicate true RMS when reading a non-sinusoidal wave.  Bear in mind that this limitation applies only to simple, analog AC meters not employing ``True-RMS'' technology.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>The <italic>amplitude</italic> of an AC waveform is its height as depicted on a graph over time.  An amplitude measurement can take the form of peak, peak-to-peak, average, or RMS quantity.</item>
<item><italic>Peak</italic> amplitude is the height of an AC waveform as measured from the zero mark to the highest positive or lowest negative point on a graph.  Also known as the <italic>crest</italic> amplitude of a wave.</item>
<item><italic>Peak-to-peak</italic> amplitude is the total height of an AC waveform as measured from maximum positive to maximum negative peaks on a graph.  Often abbreviated as ``P-P''.</item>
<item><italic>Average</italic> amplitude is the mathematical ``mean'' of all a waveform's points over the period of one cycle.  Technically, the average amplitude of any waveform with equal-area portions above and below the ``zero'' line on a graph is zero.  However, as a practical measure of amplitude, a waveform's average value is often calculated as the mathematical mean of all the points' <italic>absolute values</italic> (taking all the negative values and considering them as positive).  For a sine wave, the average value so calculated is approximately 0.637 of its peak value.</item>
<item>``RMS'' stands for <italic>Root Mean Square</italic>, and is a way of expressing an AC quantity of voltage or current in terms functionally equivalent to DC.  For example, 10 volts AC RMS is the amount of voltage that would produce the same amount of heat dissipation across a resistor of given value as a 10 volt DC power supply.  Also known as the ``equivalent'' or ``DC equivalent'' value of an AC voltage or current.  For a sine wave, the RMS value is approximately 0.707 of its peak value.</item>
<item>The <italic>crest factor</italic> of an AC waveform is the ratio of its peak (crest) to its RMS value.</item>
<item>The <italic>form factor</italic> of an AC waveform is the ratio of its RMS value to its average value.</item>
<item>Analog, electromechanical meter movements respond proportionally to the <italic>average</italic> value of an AC voltage or current.  When RMS indication is desired, the meter's calibration must be ``skewed'' accordingly.  This means that the accuracy of an electromechanical meter's RMS indication is dependent on the purity of the waveform: whether it is the exact same waveshape as the waveform used in calibrating.</item>
</itemize>
 
</section>






<section>
<sectiontitle>Simple AC circuit calculations</sectiontitle>

<para>
Over the course of the next few chapters, you will learn that AC circuit measurements and calculations can get very complicated due to the complex nature of alternating current in circuits with inductance and capacitance. However, with simple circuits (figure<ref>02018.png below</ref>) involving nothing more than an AC power source and resistance, the same laws and rules of DC apply simply and directly.</para>

<image>02018.png<caption>AC circuit calculations for resistive circuits are the same as for DC.</caption></image> 

<para>

</para>

<bigspace>

<image>12003.png</image> 
 
<index>Ohm's Law</index>
<index>Kirchhoff's Voltage Law</index>
<index>KVL</index>
<index>Kirchhoff's Current Law</index>
<index>KCL</index>

<para>
Series resistances still add, parallel resistances still diminish, and the Laws of Kirchhoff and Ohm still hold true.  Actually, as we will discover later on, these rules and laws <italic>always</italic> hold true, its just that we have to express the quantities of voltage, current, and opposition to current in more advanced mathematical forms.  With purely resistive circuits, however, these complexities of AC are of no practical consequence, and so we can treat the numbers as though we were dealing with simple DC quantities.
</para>
 
<para>
Because all these mathematical relationships still hold true, we can make use of our familiar ``table'' method of organizing circuit values just as with DC:
</para>

<image>12004.png</image> 

<para>
One major caveat needs to be given here: all measurements of AC voltage and current must be expressed in the same terms (peak, peak-to-peak, average, or RMS).  If the source voltage is given in peak AC volts, then all currents and voltages subsequently calculated are cast in terms of peak units.  If the source voltage is given in AC RMS volts, then all calculated currents and voltages are cast in AC RMS units as well.  This holds true for <italic>any</italic> calculation based on Ohm's Laws, Kirchhoff's Laws, etc.  Unless otherwise stated, all values of voltage and current in AC circuits are generally assumed to be RMS rather than peak, average, or peak-to-peak.  In some areas of electronics, peak measurements are assumed, but in most applications (especially industrial electronics) the assumption is RMS.
</para>
  
<itemize>
<item><bold>REVIEW:</bold></item>
<item>All the old rules and laws of DC (Kirchhoff's Voltage and Current Laws, Ohm's Law) still hold true for AC.  However, with more complex circuits, we may need to represent the AC quantities in more complex form.  More on this later, I promise!</item>
<item>The ``table'' method of organizing circuit values is still a valid analysis tool for AC circuits.</item>
</itemize>

</section>





<section>
<sectiontitle>AC phase</sectiontitle>
 
<index>Phase</index>

<para>
Things start to get complicated when we need to relate two or more AC voltages or currents that are out of step with each other.  By ``out of step,'' I mean that the two waveforms are not synchronized: that their peaks and zero points do not match up at the same points in time.  The graph in figure<ref>02019.png below</ref>  illustrates an example of this. 
</para>
 
<image>02019.png<caption>Out of phase waveforms</caption></image> 

<index>Phase shift</index>

<para>
The two waves shown above (A versus B) are of the same amplitude and frequency, but they are out of step with each other.  In technical terms, this is called a <italic>phase shift</italic>.  Earlier we saw how we could plot a ``sine wave'' by calculating the trigonometric sine function for angles ranging from 0 to 360 degrees, a full circle.  The starting point of a sine wave was zero amplitude at zero degrees, progressing to full positive amplitude at 90 degrees, zero at 180 degrees, full negative at 270 degrees, and back to the starting point of zero at 360 degrees.  We can use this angle scale along the horizontal axis of our waveform plot to express just how far out of step one wave is with another: Figure<ref>02020.png below</ref>
</para>
 
<image>02020.png<caption>Wave A leads wave B by 45<superscript>o</superscript></caption></image> 

<para>
The shift between these two waveforms is about 45 degrees, the ``A'' wave being ahead of the ``B'' wave.  A sampling of different phase shifts is given in the following graphs to better illustrate this concept: Figure<ref>02021.png below</ref>
</para>
 
<image>02021.png<caption>Examples of phase shifts.</caption></image> 

<index>Lagging phase shift</index>
<index>Leading phase shift</index>

<para>
Because the waveforms in the above examples are at the same frequency, they will be out of step by the same angular amount at every point in time.  For this reason, we can express phase shift for two or more waveforms of the same frequency as a constant quantity for the entire wave, and not just an expression of shift between any two particular points along the waves.  That is, it is safe to say something like, ``voltage 'A' is 45 degrees out of phase with voltage 'B'.''  Whichever waveform is ahead in its evolution is said to be <italic>leading</italic> and the one behind is said to be <italic>lagging</italic>.
</para>
 
<para>
Phase shift, like voltage, is always a measurement relative between two things.  There's really no such thing as a waveform with an <italic>absolute</italic> phase measurement because there's no known universal reference for phase.  Typically in the analysis of AC circuits, the voltage waveform of the power supply is used as a reference for phase, that voltage stated as ``xxx volts at 0 degrees.''  Any other AC voltage or current in that circuit will have its phase shift expressed in terms relative to that source voltage.
</para>
 
<index>Number, complex</index>
<index>Complex number</index>

<para>
This is what makes AC circuit calculations more complicated than DC.  When applying Ohm's Law and Kirchhoff's Laws, quantities of AC voltage and current must reflect phase shift as well as amplitude.  Mathematical operations of addition, subtraction, multiplication, and division must operate on these quantities of phase shift as well as amplitude.  Fortunately, there is a mathematical system of quantities called <italic>complex numbers</italic> ideally suited for this task of representing amplitude and phase.
</para>
 
<para>
Because the subject of complex numbers is so essential to the understanding of AC circuits, the next chapter will be devoted to that subject alone.
</para>
  
<itemize>
<item><bold>REVIEW:</bold></item>
<item><italic>Phase shift</italic> is where two or more waveforms are out of step with each other.</item>
<item>The amount of phase shift between two waves can be expressed in terms of degrees, as defined by the degree units on the horizontal axis of the waveform graph used in plotting the trigonometric sine function.</item>
<item>A <italic>leading</italic> waveform is defined as one waveform that is ahead of another in its evolution.  A <italic>lagging</italic> waveform is one that is behind another.  Example:</item>
<item>
<image>02022.png</image> 
</item>
<item>Calculations for AC circuit analysis must take into consideration both amplitude and phase shift of voltage and current waveforms to be completely accurate.  This requires the use of a mathematical system called <italic>complex numbers</italic>.</item>
</itemize>

</section>






<section>
<sectiontitle>Principles of radio</sectiontitle>

<index>Radio</index> 
<index>Radio wave</index>

<para>
One of the more fascinating applications of electricity is in the generation of invisible ripples of energy called <italic>radio waves</italic>.  The limited scope of this lesson on alternating current does not permit full exploration of the concept, some of the basic principles will be covered.
</para>
 
<para>
With Oersted's accidental discovery of electromagnetism, it was realized that electricity and magnetism were related to each other.  When an electric current was passed through a conductor, a magnetic field was generated perpendicular to the axis of flow.  Likewise, if a conductor was exposed to a change in magnetic flux perpendicular to the conductor, a voltage was produced along the length of that conductor.  So far, scientists knew that electricity and magnetism always seemed to affect each other at right angles.  However, a major discovery lay hidden just beneath this seemingly simple concept of related perpendicularity, and its unveiling was one of the pivotal moments in modern science.
</para>
 
<index>Electric field</index>
<index>Field, electric</index>
<index>Magnetic field</index> 
<index>Field, magnetic</index>

<para>
This breakthrough in physics is hard to overstate.  The man responsible for this conceptual revolution was the Scottish physicist James Clerk Maxwell (1831-1879), who ``unified'' the study of electricity and magnetism in four relatively tidy equations.  In essence, what he discovered was that electric and magnetic <italic>fields</italic> were intrinsically related to one another, with or without the presence of a conductive path for electrons to flow.  Stated more formally, Maxwell's discovery was this:
</para>

<bigspace>

<para>
<bold>A changing electric field produces a perpendicular magnetic field</bold>, and
</para>
 
<para>
<bold>A changing magnetic field produces a perpendicular electric field</bold>.
</para>
 
<bigspace>

<index>Electromagnetic wave</index> 
<index>Wave, electromagnetic</index>

<para>
All of this can take place in open space, the alternating electric and magnetic fields supporting each other as they travel through space at the speed of light.  This dynamic structure of electric and magnetic fields propagating through space is better known as an <italic>electromagnetic wave</italic>.
</para>
 
<index>Antenna</index>
 
<para>
There are many kinds of natural radiative energy composed of electromagnetic waves.  Even light is electromagnetic in nature.  So are X-rays and ``gamma'' ray radiation.  The only difference between these kinds of electromagnetic radiation is the frequency of their oscillation (alternation of the electric and magnetic fields back and forth in polarity).  By using a source of AC voltage and a special device called an <italic>antenna</italic>, we can create electromagnetic waves (of a much lower frequency than that of light) with ease.
</para>
 
<index>Dipole antenna</index>
<index>Loop antenna</index>

<para>
An antenna is nothing more than a device built to produce a dispersing electric or magnetic field.  Two fundamental types of antennae are the <italic>dipole</italic> and the <italic>loop</italic>: Figure<ref>02023.png below</ref>
</para>
 
<image>02023.png<caption>Dipole and loop antennae</caption></image> 

<para>
While the dipole looks like nothing more than an open circuit, and the loop a short circuit, these pieces of wire are effective radiators of electromagnetic fields when connected to AC sources of the proper frequency.  The two open wires of the dipole act as a sort of capacitor (two conductors separated by a dielectric), with the electric field open to dispersal instead of being concentrated between two closely-spaced plates.  The closed wire path of the loop antenna acts like an inductor with a large air core, again providing ample opportunity for the field to disperse away from the antenna instead of being concentrated and contained as in a normal inductor.  
</para>
 
<para>
As the powered dipole radiates its changing electric field into space, a changing magnetic field is produced at right angles, thus sustaining the electric field further into space, and so on as the wave propagates at the speed of light.  As the powered loop antenna radiates its changing magnetic field into space, a changing electric field is produced at right angles, with the same end-result of a continuous electromagnetic wave sent away from the antenna.  Either antenna achieves the same basic task: the controlled production of an electromagnetic field.
</para>
 
<para>
When attached to a source of high-frequency AC power, an antenna acts as a <italic>transmitting</italic> device, converting AC voltage and current into electromagnetic wave energy.  Antennas also have the ability to intercept electromagnetic waves and convert their energy into AC voltage and current.  In this mode, an antenna acts as a <italic>receiving</italic> device: Figure<ref>02024.png below</ref>
</para>
 
<image>02024.png<caption>Basic radio transmitter and receiver</caption></image> 

<para>
While there is <italic>much</italic> more that may be said about antenna technology, this brief introduction is enough to give you the general idea of what's going on (and perhaps enough information to provoke a few experiments).
</para>
  
<itemize>
<item><bold>REVIEW:</bold></item>
<item>James Maxwell discovered that changing electric fields produce perpendicular magnetic fields, and vice versa, even in empty space.</item>
<item>A twin set of electric and magnetic fields, oscillating at right angles to each other and traveling at the speed of light, constitutes an <italic>electromagnetic wave</italic>.</item>
<item>An <italic>antenna</italic> is a device made of wire, designed to radiate a changing electric field or changing magnetic field when powered by a high-frequency AC source, or intercept an electromagnetic field and convert it to an AC voltage or current.</item>
<item>The <italic>dipole</italic> antenna consists of two pieces of wire (not touching), primarily generating an electric field when energized, and secondarily producing a magnetic field in space.</item>
<item>The <italic>loop</italic> antenna consists of a loop of wire, primarily generating a magnetic field when energized, and secondarily producing an electric field in space.</item>
</itemize>

</section>




<section>
<sectiontitle>Contributors</sectiontitle>

<para>
Contributors to this chapter are listed in chronological order of their contributions, from most recent to first.  See Appendix 2 (Contributor List) for dates and contact information.
</para>

<para>
<bold>Harvey Lew</bold> (February 7, 2004): Corrected typographical error: ``circuit'' should have been ``circle''.
</para>

<para>
<bold>Duane Damiano</bold> (February 25, 2003): Pointed out magnetic polarity error in DC generator illustration.
</para>

<para>
<bold>Mark D. Zarella</bold> (April 28, 2002): Suggestion for improving explanation of ``average'' waveform amplitude.
</para>

<para>
<bold>John Symonds</bold> (March 28, 2002): Suggestion for improving explanation of the unit ``Hertz.''
</para>

<para>
<bold>Jason Starck</bold> (June 2000): HTML document formatting, which led to a much better-looking second edition.
</para>

</section>






</chapter>


<pagebreak>

