
<comment> Added Scott-T subsection 09/18/2005 (DC)</comment>
<comment> Added to Air core transformers subsection 09/18/2005 (DC)</comment>
<comment> Added Spice-Nutmeg plots 04/30/2005 (DC)</comment>
<comment> images used 02131.png -02163.png</comment>
<comment>02278.png, 02295.png</comment>
<comment>02305.png-2316.png, 02334.png 02336.png, 02340-02346.png</comment>
<comment>02411.png</comment>
<comment>12100.png-12108.png, 12138.png -12140.png</comment>
<comment>22039.png -22040.png</comment>
<chapter>
<chaptertitle>TRANSFORMERS</chaptertitle>

<section>
<sectiontitle>Mutual inductance and basic operation</sectiontitle>

<para>
Suppose we were to wrap a coil of insulated wire around a loop of ferromagnetic material and energize this coil with an AC voltage source: (Figure<ref>02305.png below</ref> (a))
</para>

<image>02305.png<caption>Insulated winding on ferromagnetic loop has inductive reactance, limiting AC current.</caption></image> 

<para>
As an inductor, we would expect this iron-core coil to oppose the applied voltage with its inductive reactance, limiting current through the coil as predicted by the equations X<subscript>L</subscript> = 2<pi>fL and I=E/X (or I=E/Z).  For the purposes of this example, though, we need to take a more detailed look at the interactions of voltage, current, and magnetic flux in the device.
</para>

<para>
Kirchhoff's voltage law describes how the algebraic sum of all voltages in a loop must equal zero. In this example, we could apply this fundamental law of electricity to describe the respective voltages of the source and of the inductor coil. Here, as in any one-source, one-load circuit, the voltage dropped across the load must equal the voltage supplied by the source, assuming zero voltage dropped along the resistance of any connecting wires. In other words, the load (inductor coil) must produce an opposing voltage equal in magnitude to the source, in order that it may balance against the source voltage and produce an algebraic loop voltage sum of zero. From where does this opposing voltage arise? If the load were a resistor (Figure<ref>02305.png above</ref> (b)), the voltage drop originates from electrical energy loss, the ``friction'' of electrons flowing through the resistance. With a perfect inductor (no resistance in the coil wire), the opposing voltage comes from another mechanism: the <italic>reaction</italic> to a changing magnetic flux in the iron core. When AC current changes, flux <PHI> changes. Changing flux induces a counter EMF.
</para>

<para>
Michael Faraday discovered the mathematical relationship between magnetic flux (<PHI>) and induced voltage with this equation:
</para>

<image>12138.png</image> 

<para>
The instantaneous voltage (voltage dropped at any instant in time) across a wire coil is equal to the number of turns of that coil around the core (N) multiplied by the instantaneous rate-of-change in magnetic flux (d<PHI>/dt) linking with the coil.  Graphed, (Figure<ref>02306.png below</ref>) this shows itself as a set of sine waves (assuming a sinusoidal voltage source), the flux wave 90<superscript>o</superscript> lagging behind the voltage wave:
</para>

<image>02306.png<caption>Magnetic flux lags applied voltage by 90<superscript>o</superscript> because flux is proportional to a rate of change, d<PHI>/dt.</caption></image> 

<index>MMF</index>
<index>Magnetomotive force</index>
<index>Reluctance</index>

<para>
Magnetic flux through a ferromagnetic material is analogous to current through a conductor: it must be motivated by some force in order to occur.  In electric circuits, this motivating force is voltage (a.k.a. electromotive force, or EMF).  In magnetic ``circuits,'' this motivating force is <italic>magnetomotive force</italic>, or <italic>mmf</italic>.  Magnetomotive force (mmf) and magnetic flux (<PHI>) are related to each other by a property of magnetic materials known as <italic>reluctance</italic> (the latter quantity symbolized by a strange-looking letter ``R''):
</para>

<image>12139.png</image> 

<index>Amp-turn, unit</index>
<index>Unit, amp-turn</index>

<para>
In our example, the mmf required to produce this changing magnetic flux (<PHI>) must be supplied by a changing current through the coil.  Magnetomotive force generated by an electromagnet coil is equal to the amount of current through that coil (in amps) multiplied by the number of turns of that coil around the core (the SI unit for mmf is the <italic>amp-turn</italic>).  Because the mathematical relationship between magnetic flux and mmf is directly proportional, and because the mathematical relationship between mmf and current is also directly proportional (no rates-of-change present in either equation), the current through the coil will be in-phase with the flux wave as in  (Figure<ref>02307.png below</ref>)
</para>

<image>02307.png<caption>Magnetic flux, like current,  lags applied voltage by 90<superscript>o</superscript>.</caption></image> 

<index>Self-inductance</index>
<index>Magnetizing current</index>

<para>
This is why alternating current through an inductor lags the applied voltage waveform by 90<superscript>o</superscript>: because that is what is required to produce a changing magnetic flux whose rate-of-change produces an opposing voltage in-phase with the applied voltage.  Due to its function in providing magnetizing force (mmf) for the core, this current is sometimes referred to as the <italic>magnetizing current</italic>.
</para>

<index>Distortion, inductor current</index>

<para>
It should be mentioned that the current through an iron-core inductor is not perfectly sinusoidal (sine-wave shaped), due to the nonlinear B/H magnetization curve of iron.  In fact, if the inductor is cheaply built, using as little iron as possible, the magnetic flux density might reach high levels (approaching saturation), resulting in a magnetizing current waveform that looks something like Figure<ref>02336.png below</ref>
</para>

<image>02336.png<caption>As flux density approaches saturation, the magnetizing current waveform becomes distorted.</caption></image> 

<para>
When a ferromagnetic material approaches magnetic flux saturation, disproportionately greater levels of magnetic field force (mmf) are required to deliver equal increases in magnetic field flux (<PHI>).  Because mmf is proportional to current through the magnetizing coil (mmf = NI, where ``N'' is the number of turns of wire in the coil and ``I'' is the current through it), the large increases of mmf required to supply the needed increases in flux results in large increases in coil current.  Thus, coil current increases dramatically at the peaks in order to maintain a flux waveform that isn't distorted, accounting for the bell-shaped half-cycles of the current waveform in the above plot.  
</para>

<index>Exciting current</index>

<para>
The situation is further complicated by energy losses within the iron core.  The effects of hysteresis and eddy currents conspire to further distort and complicate the current waveform, making it even less sinusoidal and altering its phase to be lagging slightly less than 90<superscript>o</superscript> behind the applied voltage waveform.  This coil current resulting from the sum total of all magnetic effects in the core (d<PHI>/dt magnetization plus hysteresis losses, eddy current losses, etc.) is called the <italic>exciting current</italic>.  The distortion of an iron-core inductor's exciting current may be minimized if it is designed for and operated at very low flux densities.  Generally speaking, this requires a core with large cross-sectional area, which tends to make the inductor bulky and expensive.  For the sake of simplicity, though, we'll assume that our example core is far from saturation and free from all losses, resulting in a perfectly sinusoidal exciting current.
</para>

<para>
As we've seen already in the inductors chapter, having a current waveform 90<superscript>o</superscript> out of phase with the voltage waveform creates a condition where power is alternately absorbed and returned to the circuit by the inductor.  If the inductor is perfect (no wire resistance, no magnetic core losses, etc.), it will dissipate zero power.
</para>

<index>Primary coil</index>
<index>Coil, primary</index>
<index>Secondary coil</index>
<index>Coil, secondary</index>

<para>
Let us now consider the same inductor device, except this time with a second coil (Figure<ref>02308.png below</ref>) wrapped around the same iron core.  The first coil will be labeled the <italic>primary</italic> coil, while the second will be labeled the <italic>secondary</italic>:
</para>

<image>02308.png<caption>Ferromagnetic core with primary coil (AC driven) and secondary coil.</caption></image> 

<para>
If this secondary coil experiences the same magnetic flux change as the primary (which it should, assuming perfect containment of the magnetic flux through the common core), and has the same number of turns around the core, a voltage of equal magnitude and phase to the applied voltage will be induced along its length.  In the following graph, (Figure<ref>02309.png below</ref>) the induced voltage waveform is drawn slightly smaller than the source voltage waveform simply to distinguish one from the other:
</para>

<image>02309.png<caption>Open circuited secondary sees the same flux <PHI> as the primary. Therefore induced secondary voltage e<subscript>s</subscript> is the same magnitude and phase  as the primary voltage e<subscript>p.</subscript></caption></image> 

<index>Mutual inductance</index>
<index>M, symbol for mutual inductance</index>

<para>
This effect is called <italic>mutual inductance</italic>: the induction of a voltage in one coil in response to a change in current in the other coil.  Like normal (self-) inductance, it is measured in the unit of Henrys, but unlike normal inductance it is symbolized by the capital letter ``M'' rather than the letter ``L'':
</para>

<image>12140.png</image> 

<para>
No current will exist in the secondary coil, since it is open-circuited.  However, if we connect a load resistor to it, an alternating current will go through the coil, in-phase with the induced voltage (because the voltage across a resistor and the current through it are <italic>always</italic> in-phase with each other). (Figure<ref>02310.png below</ref>)
</para>

<image>02310.png<caption>Resistive load on secondary has voltage and current in-phase.</caption></image> 

<para>
At first, one might expect this secondary coil current to cause additional magnetic flux in the core.  In fact, it does not.  If more flux were induced in the core, it would cause more voltage to be induced voltage in the primary coil (remember that e = d<PHI>/dt).  This cannot happen, because the primary coil's induced voltage must remain at the same magnitude and phase in order to balance with the applied voltage, in accordance with Kirchhoff's voltage law.  Consequently, the magnetic flux in the core cannot be affected by secondary coil current.  However, what <italic>does</italic> change is the amount of mmf in the magnetic circuit.
</para>

<para>
Magnetomotive force is produced any time electrons move through a wire.  Usually, this mmf is accompanied by magnetic flux, in accordance with the mmf=<PHI>R ``magnetic Ohm's Law'' equation.  In this case, though, additional flux is not permitted, so the only way the secondary coil's mmf may exist is if a counteracting mmf is generated by the primary coil, of equal magnitude and opposite phase.  Indeed, this is what happens, an alternating current forming in the primary coil -- 180<superscript>o</superscript> out of phase with the secondary coil's current -- to generate this counteracting mmf and prevent additional core flux.  Polarity marks and current direction arrows have been added to the illustration to clarify phase relations:  (Figure<ref>02311.png below</ref>)
</para>

<image>02311.png<caption>Flux remains constant with application of a load. However, a counteracting mmf is produced by the loaded secondary.</caption></image> 

<para>
If you find this process a bit confusing, do not worry.  Transformer dynamics is a complex subject.  What is important to understand is this: when an AC voltage is applied to the primary coil, it creates a magnetic flux in the core, which induces AC voltage in the secondary coil in-phase with the source voltage.  Any current drawn through the secondary coil to power a load induces a corresponding current in the primary coil, drawing current from the source.
</para>

<index>Exciting current</index>

<para>
Notice how the primary coil is behaving as a load with respect to the AC voltage source, and how the secondary coil is behaving as a source with respect to the resistor.  Rather than energy merely being alternately absorbed and returned the primary coil circuit, energy is now being <italic>coupled</italic> to the secondary coil where it is delivered to a dissipative (energy-consuming) load.  As far as the source ``knows,'' its directly powering the resistor.  Of course, there is also an additional primary coil current lagging the applied voltage by 90<superscript>o</superscript>, just enough to magnetize the core to create the necessary voltage for balancing against the source (the <italic>exciting current</italic>).
</para>

<index>Transformer</index>

<para>
We call this type of device a <italic>transformer</italic>, because it transforms electrical energy into magnetic energy, then back into electrical energy again.  Because its operation depends on electromagnetic induction between two stationary coils and a magnetic flux of changing magnitude and ``polarity,'' transformers are necessarily AC devices.  Its schematic symbol looks like two inductors (coils) sharing the same magnetic core:  (Figure<ref>02131.png below</ref>)
</para>

<image>02131.png<caption>Schematic symbol for transformer consists of two inductor symbols, separated by lines indicating a ferromagnetic core.</caption></image> 

<para>
The two inductor coils are easily distinguished in the above symbol.  The pair of vertical lines represent an iron core common to both inductors.  While many transformers have ferromagnetic core materials, there are some that do not, their constituent inductors being magnetically linked together through the air.  
</para>

<para>
The following photograph shows a power transformer of the type used in gas-discharge lighting.  Here, the two inductor coils can be clearly seen, wound around an iron core.  While most transformer designs enclose the coils and core in a metal frame for protection, this particular transformer is open for viewing and so serves its illustrative purpose well: (Figure<ref>52002.jpg below</ref>)
</para>

<image>52002.jpg<caption>Example of a gas-discharge lighting transformer.</caption></image> 

<para>
Both coils of wire can be seen here with copper-colored varnish insulation.  The top coil is larger than the bottom coil, having a greater number of ``turns'' around the core.  In transformers, the inductor coils are often referred to as <italic>windings</italic>, in reference to the manufacturing process where wire is <italic>wound</italic> around the core material.  As modeled in our initial example, the powered inductor of a transformer is called the <italic>primary</italic> winding, while the unpowered coil is called the <italic>secondary</italic> winding.  
</para>

<para>
In the next photograph, Figure<ref>52012.jpg below</ref>, a transformer is shown cut in half, exposing the cross-section of the iron core as well as both windings.  Like the transformer shown previously, this unit also utilizes primary and secondary windings of differing turn counts.  The wire gauge can also be seen to differ between primary and secondary windings.  The reason for this disparity in wire gauge will be made clear in the next section of this chapter.  Additionally, the iron core can be seen in this photograph to be made of many thin sheets (laminations) rather than a solid piece.  The reason for this will also be explained in a later section of this chapter.
</para>

<image>52012.jpg<caption>Transformer cross-section cut  shows core and windings.</caption></image> 

<index>Winding, primary</index>
<index>Winding, secondary</index>

<para>
It is easy to demonstrate simple transformer action using SPICE, setting up the primary and secondary windings of the simulated transformer as a pair of ``mutual'' inductors. (Figure<ref>02132.png below</ref>)  The coefficient of magnetic field coupling is given at the end of the ``<typewriter>k</typewriter>'' line in the SPICE circuit description, this example being set very nearly at perfection (1.000).  This coefficient describes how closely ``linked'' the two inductors are, magnetically.  The better these two inductors are magnetically coupled, the more efficient the energy transfer between them should be. 
</para>

<image>02132.png<caption>Spice circuit for coupled inductors.</caption></image> 

<table>
<literal>
transformer
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12 
rbogus2 5 0 9e12  
l1 2 0 100      
l2 3 5 100     
** This line tells SPICE that the two inductors  
** l1 and l2 are magnetically ``linked'' together
k l1 l2 0.999          
vi1 3 4 ac 0      
rload 4 5 1k    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal>
</table>

<para>
Note: the R<subscript>bogus</subscript> resistors are required to satisfy certain quirks of SPICE.  The first breaks the otherwise continuous loop between the voltage source and L<subscript>1</subscript> which would not be permitted by SPICE.  The second provides a path to ground (node 0) from the secondary circuit, necessary because SPICE cannot function with any ungrounded circuits.
</para>

<table>
<literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   9.975E-03   Primary winding
<sp>
freq          v(3,5)      i(vi1)      
6.000E+01     9.962E+00   9.962E-03   Secondary winding
</literal>
</table>

<para>
Note that with equal inductances for both windings (100 Henrys each), the AC voltages and currents are nearly equal for the two.  The difference between primary and secondary currents is the magnetizing current spoken of earlier: the 90<superscript>o</superscript> lagging current necessary to magnetize the core.  As is seen here, it is usually very small compared to primary current induced by the load, and so the primary and secondary currents are almost equal.  What you are seeing here is quite typical of transformer efficiency.  Anything less than 95% efficiency is considered poor for modern power transformer designs, and this transfer of power occurs with no moving parts or other components subject to wear. 
</para>

<para>
If we decrease the load resistance so as to draw more current with the same amount of voltage, we see that the current through the primary winding increases in response.  Even though the AC power source is not directly connected to the load resistance (rather, it is electromagnetically ``coupled''), the amount of current drawn from the source will be almost the same as the amount of current that would be drawn if the load were directly connected to the source.  Take a close look at the next two SPICE simulations, showing what happens with different values of load resistors:
</para>

<table>
<literal>
transformer   
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
l1 2 0 100      
l2 3 5 100      
k l1 l2 0.999   
vi1 3 4 ac 0    
** Note load resistance value of 200 ohms
rload 4 5 200        
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal>
</table>


<table>
<literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   4.679E-02
<sp>
freq          v(3,5)      i(vi1)      
6.000E+01     9.348E+00   4.674E-02
</literal>
</table>

<para>
Notice how the primary current closely follows the secondary current.  In our first simulation, both currents were approximately 10 mA, but now they are both around 47 mA.  In this second simulation, the two currents are closer to equality, because the magnetizing current remains the same as before while the load current has increased.  Note also how the secondary voltage has decreased some with the heavier (greater current) load.  Let's try another simulation with an even lower value of load resistance (15 <OMEGA>):
</para>

<table>
<literal>
transformer   
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
l1 2 0 100      
l2 3 5 100      
k l1 l2 0.999   
vi1 3 4 ac 0    
rload 4 5 15    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal>
</table>

<table>
<literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   1.301E-01
<sp>
freq          v(3,5)      i(vi1)      
6.000E+01     1.950E+00   1.300E-01
</literal>
</table>


<index>Inductance, leakage</index>
<index>Leakage inductance</index>

<para>
Our load current is now 0.13 amps, or 130 mA, which is substantially higher than the last time.  The primary current is very close to being the same, but notice how the secondary voltage has fallen well below the primary voltage (1.95 volts versus 10 volts at the primary).  The reason for this is an imperfection in our transformer design: because the primary and secondary inductances aren't <italic>perfectly</italic> linked (a <typewriter>k</typewriter> factor of 0.999 instead of 1.000) there is ``stray'' or ``<italic>leakage</italic>'' inductance.  In other words, some of the magnetic field isn't linking with the secondary coil, and thus cannot couple energy to it: (Figure<ref>02312.png below</ref>)
</para>

<image>02312.png<caption>Leakage inductance is due to magnetic flux not cutting both windings.</caption></image> 

<para>
Consequently, this ``leakage'' flux merely stores and returns energy to the source circuit via self-inductance, effectively acting as a series impedance in both primary and secondary circuits.  Voltage gets dropped across this series impedance, resulting in a reduced load voltage: voltage across the load ``sags'' as load current increases. (Figure<ref>02313.png below</ref>)
</para>

<image>02313.png<caption>Equivalent circuit models leakage inductance as series inductors independent of the ``ideal transformer''.</caption></image> 

<para>
If we change the transformer design to have better magnetic coupling between the primary and secondary coils, the figures for voltage between primary and secondary windings will be much closer to equality again:
</para>

<table>
<literal>
transformer  
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
l1 2 0 100 
l2 3 5 100
** Coupling factor = 0.99999 instead of 0.999
k l1 l2 0.99999   
vi1 3 4 ac 0    
rload 4 5 15    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal>
</table>


<table>
<literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   6.658E-01

freq          v(3,5)      i(vi1)      
6.000E+01     9.987E+00   6.658E-01
</literal>
</table>


<index>Inductance, leakage</index>
<index>Leakage inductance</index>

<para>
Here we see that our secondary voltage is back to being equal with the primary, and the secondary current is equal to the primary current as well.  Unfortunately, building a real transformer with coupling this complete is very difficult.  A compromise solution is to design both primary and secondary coils with less inductance, the strategy being that less inductance overall leads to less ``leakage'' inductance to cause trouble, for any given degree of magnetic coupling inefficiency.  This results in a load voltage that is closer to ideal with the same (high current heavy) load and the same coupling factor:
</para>

<table>
<literal>
transformer
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
** inductance = 1 henry instead of 100 henrys   
l1 2 0 1
l2 3 5 1
k l1 l2 0.999   
vi1 3 4 ac 0    
rload 4 5 15    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal>
</table>

<table>
<literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   6.664E-01

freq          v(3,5)      i(vi1)      
6.000E+01     9.977E+00   6.652E-01
</literal>
</table>


<para>
Simply by using primary and secondary coils of less inductance, the load voltage for this heavy load (high current) has been brought back up to nearly ideal levels (9.977 volts).  At this point, one might ask, ``If less inductance is all that's needed to achieve near-ideal performance under heavy load, then why worry about coupling efficiency at all?  If its impossible to build a transformer with perfect coupling, but easy to design coils with low inductance, then why not just build all transformers with low-inductance coils and have excellent efficiency even with poor magnetic coupling?''
</para>

<para>
The answer to this question is found in another simulation: the same low-inductance transformer, but this time with a lighter load (less current) of 1 k<OMEGA> instead of 15 <OMEGA>:
</para>

<table>
<literal>
transformer 
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
l1 2 0 1
l2 3 5 1
k l1 l2 0.999   
vi1 3 4 ac 0    
rload 4 5 1k    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal>
</table>

<table>
<literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   2.835E-02

freq          v(3,5)      i(vi1)      
6.000E+01     9.990E+00   9.990E-03
</literal>
</table>

<para>
With lower winding inductances, the primary and secondary voltages are closer to being equal, but the primary and secondary currents are not.  In this particular case, the primary current is 28.35 mA while the secondary current is only 9.990 mA: almost three times as much current in the primary as the secondary.  Why is this?  With less inductance in the primary winding, there is less inductive reactance, and consequently a much larger magnetizing current.  A substantial amount of the current through the primary winding merely works to magnetize the core rather than <italic>transfer</italic> useful energy to the secondary winding and load.
</para>

<para>
An ideal transformer with identical primary and secondary windings would manifest equal voltage and current in both sets of windings for any load condition.  In a perfect world, transformers would transfer electrical power from primary to secondary as smoothly as though the load were directly connected to the primary power source, with no transformer there at all.  However, you can see this ideal goal can only be met if there is <italic>perfect</italic> coupling of magnetic flux between primary and secondary windings.  Being that this is impossible to achieve, transformers must be designed to operate within certain expected ranges of voltages and loads in order to perform as close to ideal as possible.  For now, the most important thing to keep in mind is a transformer's basic operating principle: the transfer of power from the primary to the secondary circuit via electromagnetic coupling.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item><italic>Mutual inductance</italic> is where the magnetic flux of two or more inductors are ``linked'' so that voltage is induced in one coil proportional to the rate-of-change of current in another.</item>
<item>A <italic>transformer</italic> is a device made of two or more inductors, one of which is powered by AC, inducing an AC voltage across the second inductor.  If the second inductor is connected to a load, power will be electromagnetically coupled from the first inductor's power source to that load.</item>
<item>The powered inductor in a transformer is called the <italic>primary winding</italic>.  The unpowered inductor in a transformer is called the <italic>secondary winding</italic>.</item>
<item>Magnetic flux in the core (<PHI>) lags 90<superscript>o</superscript> behind the source voltage waveform.  The current drawn by the primary coil from the source to produce this flux is called the <italic>magnetizing current</italic>, and it also lags the supply voltage by 90<superscript>o</superscript>.</item>
<item>Total primary current in an unloaded transformer is called the <italic>exciting current</italic>, and is comprised of magnetizing current plus any additional current necessary to overcome core losses.  It is never perfectly sinusoidal in a real transformer, but may be made more so if the transformer is designed and operated so that magnetic flux density is kept to a minimum.</item>
<item>Core flux induces a voltage in any coil wrapped around the core.  The induces voltage(s) are ideally in- phase with the primary winding source voltage and share the same waveshape.</item>
<item>Any current drawn through the secondary winding by a load will be ``reflected'' to the primary winding and drawn from the voltage source, as if the source were directly powering a similar load.</item>
</itemize>

</section>






<section>
<sectiontitle>Step-up and step-down transformers</sectiontitle>

<para>
So far, we've observed simulations of transformers where the primary and secondary windings were of identical inductance, giving approximately equal voltage and current levels in both circuits.  Equality of voltage and current between the primary and secondary sides of a transformer, however, is not the norm for all transformers.  If the inductances of the two windings are not equal, something interesting happens:
</para>

<table><literal>
transformer   
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
l1 2 0 10000    
l2 3 5 100      
k l1 l2 0.999   
vi1 3 4 ac 0    
rload 4 5 1k    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal></table>


<table><literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   9.975E-05    Primary winding

freq          v(3,5)      i(vi1)      
6.000E+01     9.962E-01   9.962E-04    Secondary winding
</literal></table>


<index>Ratio, transformer</index>
<index>Transformer ratio</index>

<para>
Notice how the secondary voltage is approximately ten times less than the primary voltage (0.9962 volts compared to 10 volts), while the secondary current is approximately ten times greater (0.9962 mA compared to 0.09975 mA).  What we have here is a device that steps voltage <italic>down</italic> by a factor of ten and current <italic>up</italic> by a factor of ten: (Figure<ref>02133.png below</ref>)
</para>

<image>02133.png<caption>Turns ratio of 10:1 yields 10:1 primary:secondary voltage ratio and 1:10 primary:secondary current ratio.</caption></image> 

<para>

</para>


<index>Transformer, step-up</index>
<index>Transformer, step-down</index>

<para>
This is a very useful device, indeed.  With it, we can easily multiply or divide voltage and current in AC circuits.  Indeed, the transformer has made long-distance transmission of electric power a practical reality, as AC voltage can be ``stepped up'' and current ``stepped down'' for reduced wire resistance power losses along power lines connecting generating stations with loads.  At either end (both the generator and at the loads), voltage levels are reduced by transformers for safer operation and less expensive equipment.  A transformer that increases voltage from primary to secondary (more secondary winding turns than primary winding turns) is called a <italic>step-up</italic> transformer.  Conversely, a transformer designed to do just the opposite is called a <italic>step-down</italic> transformer. 
</para>

<para>
Let's re-examine a photograph shown in the previous section: (Figure<ref>52012b.jpg below</ref>)
</para>



<image>52012.jpg<caption>Transformer cross-section showing primary and secondary windings is a few inches tall (approximately 10 cm).</caption><label>52012b.jpg</label></image>

<para>
This is a step-down transformer, as evidenced by the high turn count of the primary winding and the low turn count of the secondary.  As a step-down unit, this transformer converts high-voltage, low-current power into low-voltage, high-current power.  The larger-gauge wire used in the secondary winding is necessary due to the increase in current.  The primary winding, which doesn't have to conduct as much current, may be made of smaller-gauge wire.
</para>

<para>
In case you were wondering, it <italic>is</italic> possible to operate either of these transformer types backwards (powering the secondary winding with an AC source and letting the primary winding power a load) to perform the opposite function: a step-up can function as a step-down and visa-versa.  However, as we saw in the first section of this chapter, efficient operation of a transformer requires that the individual winding inductances be engineered for specific operating ranges of voltage and current, so if a transformer is to be used ``backwards'' like this it must be employed within the original design parameters of voltage and current for each winding, lest it prove to be inefficient (or lest it be <italic>damaged</italic> by excessive voltage or current!).
</para>

<para>
Transformers are often constructed in such a way that it is not obvious which wires lead to the primary winding and which lead to the secondary.  One convention used in the electric power industry to help alleviate confusion is the use of ``H'' designations for the higher-voltage winding (the primary winding in a step-down unit; the secondary winding in a step-up) and ``X'' designations for the lower-voltage winding.  Therefore, a simple power transformer will have wires labeled ``H<subscript>1</subscript>'', ``H<subscript>2</subscript>'', ``X<subscript>1</subscript>'', and ``X<subscript>2</subscript>''.  There is usually significance to the numbering of the wires (H<subscript>1</subscript> versus H<subscript>2</subscript>, etc.), which we'll explore a little later in this chapter.
</para>

<index>Conservation of Energy, Law of</index>

<para>
The fact that voltage and current get ``stepped'' in opposite directions (one up, the other down) makes perfect sense when you recall that power is equal to voltage times current, and realize that transformers cannot <italic>produce</italic> power, only convert it.  Any device that could output more power than it took in would violate the <italic>Law of Energy Conservation</italic> in physics, namely that energy cannot be created or destroyed, only converted.  As with the first transformer example we looked at, power transfer efficiency is very good from the primary to the secondary sides of the device.  
</para>

<index>Motor/generator set</index>

<para>
The practical significance of this is made more apparent when an alternative is considered: before the advent of efficient transformers, voltage/current level conversion could only be achieved through the use of motor/generator sets.  A drawing of a motor/generator set reveals the basic principle involved: (Figure<ref>02295.png below</ref>)
</para>

<image>02295.png<caption>Motor generator illustrates the basic principle of the transformer.</caption></image> 

<para>
In such a machine, a motor is mechanically coupled to a generator, the generator designed to produce the desired levels of voltage and current at the rotating speed of the motor.  While both motors and generators are fairly efficient devices, the use of both in this fashion compounds their inefficiencies so that the overall efficiency is in the range of 90% or less.  Furthermore, because motor/generator sets obviously require moving parts, mechanical wear and balance are factors influencing both service life and performance.  Transformers, on the other hand, are able to convert levels of AC voltage and current at very high efficiencies with no moving parts, making possible the widespread distribution and use of electric power we take for granted.
</para>

<para>
In all fairness it should be noted that motor/generator sets have not necessarily been obsoleted by transformers for <italic>all</italic> applications.  While transformers are clearly superior over motor/generator sets for AC voltage and current level conversion, they cannot convert one frequency of AC power to another, or (by themselves) convert DC to AC or visa-versa.  Motor/generator sets can do all these things with relative simplicity, albeit with the limitations of efficiency and mechanical factors already described.  Motor/generator sets also have the unique property of kinetic energy storage: that is, if the motor's power supply is momentarily interrupted for any reason, its angular momentum (the inertia of that rotating mass) will maintain rotation of the generator for a short duration, thus isolating any loads powered by the generator from ``glitches'' in the main power system.
</para>

<para>
Looking closely at the numbers in the SPICE analysis, we should see a correspondence between the transformer's ratio and the two inductances.  Notice how the primary inductor (l1) has 100 times more inductance than the secondary inductor (10000 H versus 100 H), and that the measured voltage step-down ratio was 10 to 1.  The winding with more inductance will have higher voltage and less current than the other.  Since the two inductors are wound around the same core material in the transformer (for the most efficient magnetic coupling between the two), the parameters affecting inductance for the two coils are equal except for the number of turns in each coil.  If we take another look at our inductance formula, we see that inductance is proportional to the <italic>square</italic> of the number of coil turns:
</para>

<bigspace><comment>for following equation image</comment>

<image>12100.png</image> 

<para>
So, it should be apparent that our two inductors in the last SPICE transformer example circuit -- with inductance ratios of 100:1 -- should have coil turn ratios of 10:1, because 10 squared equals 100.  This works out to be the same ratio we found between primary and secondary voltages and currents (10:1), so we can say as a rule that the voltage and current transformation ratio is equal to the ratio of winding turns between primary and secondary.
</para>

<image>02134.png<caption>Step-down transformer: (many turns :few turns).</caption></image> 

<para>
The step-up/step-down effect of coil turn ratios in a transformer (Figure<ref>02134.png above</ref>)
<comment>split for multiple refs in one paragraph</comment>
is analogous to gear tooth ratios in mechanical gear systems, transforming values of speed and torque in much the same way: (Figure<ref>02135.png below</ref>)
</para>

<image>02135.png<caption>Torque reducing gear train steps torque down, while stepping speed up.</caption></image> 

<para>
Step-up and step-down transformers for power distribution purposes can be gigantic in proportion to the power transformers previously shown, some units standing as tall as a home.  The following photograph shows a substation transformer standing about twelve feet tall: (Figure<ref>52007.jpg below</ref>)
</para>

<image>52007.jpg<caption>Substation transformer.</caption></image> 

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Transformers ``step up'' or ``step down'' voltage according to the ratios of primary to secondary wire turns.</item>
<item>
<image>12102.png</image> 
</item>
<item>A transformer designed to increase voltage from primary to secondary is called a <italic>step-up</italic> transformer.  A transformer designed to reduce voltage from primary to secondary is called a <italic>step-down</italic> transformer.</item>
<item>The transformation ratio of a transformer will be equal to the square root of its primary to secondary inductance (L) ratio.</item>
<item>
<image>12103.png</image> 
</item>
</itemize>

</section>






<section>
<sectiontitle>Electrical isolation</sectiontitle>

<index>Transformer isolation</index>
<index>Isolation, transformer</index>

<para>
Aside from the ability to easily convert between different levels of voltage and current in AC and DC circuits, transformers also provide an extremely useful feature called <italic>isolation</italic>, which is the ability to couple one circuit to another without the use of direct wire connections.  We can demonstrate an application of this effect with another SPICE simulation: this time showing ``ground'' connections for the two circuits, imposing a high DC voltage between one circuit and ground through the use of an additional voltage source:(Figure<ref>02136.png below</ref>)
</para>

<image>02136.png<caption>Transformer isolates 10 V<subscript>ac</subscript> at  V<subscript>1</subscript> from 250 V<subscript>DC</subscript> at V<subscript>2</subscript>.</caption></image> 


<table><literal>
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
v2 5 0 dc 250   
l1 2 0 10000    
l2 3 5 100      
k l1 l2 0.999   
vi1 3 4 ac 0    
rload 4 5 1k    
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal></table>


<table><literal>
DC voltages referenced to ground (node 0):
(1)    0.0000    (2)    0.0000    (3)  250.0000    
(4)  250.0000    (5)  250.0000

AC voltages:
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   9.975E-05    Primary winding

freq          v(3,5)      i(1)      
6.000E+01     9.962E-01   9.962E-04    Secondary winding
</literal></table>

<bigspace>

<index>Voltage, common-mode</index>
<index>Common-mode voltage</index>

<para>
SPICE shows the 250 volts DC being impressed upon the secondary circuit elements with respect to ground,  (Figure<ref>02136.png above</ref>) but as you can see there is no effect on the primary circuit (zero DC voltage) at nodes 1 and 2, and the transformation of AC power from primary to secondary circuits remains the same as before.  The impressed voltage in this example is often called a <italic>common-mode</italic> voltage because it is seen at more than one point in the circuit with reference to the common point of ground.  The transformer isolates the common-mode voltage so that it is not impressed upon the primary circuit at all, but rather isolated to the secondary side.  For the record, it does not matter that the common-mode voltage is DC, either.  It could be AC, even at a different frequency, and the transformer would isolate it from the primary circuit all the same.
</para>

<index>Isolation transformer</index>

<para>
There are applications where electrical isolation is needed between two AC circuit without any transformation of voltage or current levels.  In these instances, transformers called <italic>isolation transformers</italic> having 1:1 transformation ratios are used.  A benchtop isolation transformer is shown in Figure<ref>52006.jpg below</ref>.
</para>

<image>52006.jpg<caption>Isolation transformer isolates power out from the power line.</caption></image> 

<itemize>
<item><bold>REVIEW:</bold></item>
<item>By being able to transfer power from one circuit to another without the use of interconnecting conductors between the two circuits, transformers provide the useful feature of <italic>electrical isolation</italic>.</item>
<item>Transformers designed to provide electrical isolation without stepping voltage and current either up or down are called <italic>isolation transformers</italic>.</item>
</itemize>

</section>






<section>
<sectiontitle>Phasing</sectiontitle>

<index>Phase, transformer</index>

<para>
Since transformers are essentially AC devices, we need to be aware of the phase relationships between the primary and secondary circuits.  Using our SPICE example from before, we can plot the waveshapes (Figure<ref>22039.png below</ref>) for the primary and secondary circuits and see the phase relations for ourselves:
</para>

<bigspace>
<table><literal>
spice transient analysis file for use with nutmeg:

transformer
v1 1 0 sin(0 15 60 0 0)
rbogus1 1 2 1e-12
v2 5 0 dc 250
l1 2 0 10000
l2 3 5 100
k l1 l2 0.999
vi1 3 4 ac 0
rload 4 5 1k
.tran 0.5m 17m
.end
 
nutmeg commands:
setplot tran1
plot v(2) v(3,5)
</literal></table>


<comment>legend:</comment>
<comment>*: v(2)     Primary voltage </comment>  
<comment>+: v(3,5)   Secondary voltage</comment>
<comment>time       v(2)</comment>    
<comment>( *)----------     -10         -5          0          5         10</comment>
<comment>(+)-----------     -10         -5          0          5         10</comment>
<comment>- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -</comment>
<comment>0.000E+00  0.000E+00 .          .          x          .          .</comment>
<comment>1.000E-03  3.675E+00 .          .          .    + *   .          .</comment>
<comment>2.000E-03  6.803E+00 .          .          .          . + *      .</comment>
<comment>3.000E-03  9.008E+00 .          .          .          .      +*  .</comment>
<comment>4.000E-03  9.955E+00 .          .          .          .          x</comment>
<comment>5.000E-03  9.450E+00 .          .          .          .        *+.</comment>
<comment>6.000E-03  7.672E+00 .          .          .          .    * +   .</comment>
<comment>7.000E-03  4.804E+00 .          .          .         *.+         .</comment>
<comment>8.000E-03  1.245E+00 .          .          .  *  +    .          .</comment>
<comment>9.000E-03 -2.474E+00 .          .     * +  .          .          .</comment>
<comment>1.000E-02 -5.864E+00 .         *+          .          .          .</comment>
<comment>1.100E-02 -8.390E+00 .    *+    .          .          .          .</comment>
<comment>1.200E-02 -9.779E+00 .x         .          .          .          .</comment>
<comment>1.300E-02 -9.798E+00 +*         .          .          .          .</comment>
<comment>1.400E-02 -8.390E+00 .   +*     .          .          .          .</comment>
<comment>1.500E-02 -5.854E+00 .       + *.          .          .          .</comment>
<comment>1.600E-02 -2.479E+00 .          .    + *   .          .          .</comment>
<comment>1.700E-02  1.246E+00 .          .          .+ *       .          .</comment>
<comment>1.800E-02  4.795E+00 .          .          .       + *.          .</comment>
<comment>1.900E-02  7.686E+00 .          .          .          .   + *    .</comment>
<comment>2.000E-02  9.451E+00 .          .          .          .        x .</comment>
<comment>2.100E-02  9.937E+00 .          .          .          .          x</comment>
<comment>2.200E-02  9.025E+00 .          .          .          .       *+ .</comment>
<comment>2.300E-02  6.802E+00 .          .          .          .  *+      .</comment>
<comment>2.400E-02  3.667E+00 .          .          .      * + .          .</comment>
<comment>2.500E-02 -1.487E-03 .          .          * +        .          .</comment>
<comment>2.600E-02 -3.658E+00 .          .   * +    .          .          .</comment>
<comment>2.700E-02 -6.814E+00 .      * + .          .          .          .</comment>
<comment>2.800E-02 -9.026E+00 .  *+      .          .          .          .</comment>
<comment>2.900E-02 -9.917E+00 *+         .          .          .          .</comment>
<comment>3.000E-02 -9.511E+00 .x         .          .          .          .</comment>
<comment>- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -</comment>



<comment>legend:</comment>
<comment>*: i(v1)   Primary current</comment>
<comment>+: i(vi1)  Secondary current</comment>  
<comment>time      i(v1)</comment>   
<comment>( *)--------- -2.000E-04   -1.000E-04      0   1.000E-04  2.000E-04</comment>
<comment>(+)---------- -1.000E-03   -5.000E-04      0   5.000E-04  1.000E-03</comment>
<comment>- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -</comment>
<comment>0.000E+00  0.000E+00 .          .          x          .          .</comment>
<comment>1.000E-03 -2.973E-05 .          .     +   *.          .          .</comment>
<comment>2.000E-03 -6.279E-05 .        + .    *     .          .          .</comment>
<comment>3.000E-03 -8.772E-05 .   +      . *        .          .          .</comment>
<comment>4.000E-03 -1.008E-04 +          *          .          .          .</comment>
<comment>5.000E-03 -9.954E-05 .+         *          .          .          .</comment>
<comment>6.000E-03 -8.522E-05 .    +     . *        .          .          .</comment>
<comment>7.000E-03 -5.919E-05 .         +.     *    .          .          .</comment>
<comment>8.000E-03 -2.500E-05 .          .       + *.          .          .</comment>
<comment>9.000E-03  1.212E-05 .          .          . *  +     .          .</comment>
<comment>1.000E-02  4.736E-05 .          .          .     *    .+         .</comment>
<comment>1.100E-02  7.521E-05 .          .          .       *  .     +    .</comment>
<comment>1.200E-02  9.250E-05 .          .          .         *.         +.</comment>
<comment>1.300E-02  9.648E-05 .          .          .         *.          +</comment>
<comment>1.400E-02  8.602E-05 .          .          .        * .      +   .</comment>
<comment>1.500E-02  6.362E-05 .          .          .     *    . +        .</comment>
<comment>1.600E-02  3.177E-05 .          .          .  *  +    .          .</comment>
<comment>1.700E-02 -4.998E-06 .          .          x          .          .</comment>
<comment>1.800E-02 -4.136E-05 .          .  +    *  .          .          .</comment>
<comment>1.900E-02 -7.246E-05 .     +    .   *      .          .          .</comment>
<comment>2.000E-02 -9.331E-05 . +        .*         .          .          .</comment>
<comment>2.100E-02 -1.019E-04 +          *          .          .          .</comment>
<comment>2.200E-02 -9.651E-05 . +        *          .          .          .</comment>
<comment>2.300E-02 -7.749E-05 .     +    .  *       .          .          .</comment>
<comment>2.400E-02 -4.842E-05 .          . +    *   .          .          .</comment>
<comment>2.500E-02 -1.275E-05 .          .         x.          .          .</comment>
<comment>2.600E-02  2.428E-05 .          .          .  *  +    .          .</comment>
<comment>2.700E-02  5.761E-05 .          .          .     *    .+         .</comment>
<comment>2.800E-02  8.261E-05 .          .          .        * .       +  .</comment>
<comment>2.900E-02  9.514E-05 .          .          .         *.         +.</comment>
<comment>3.000E-02  9.487E-05 .          .          .         *.         +.</comment>
<comment>- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -</comment>

<bigspace>

<image>22039.png<caption>Secondary voltage V(3,5) is in-phase with primary voltage V(2), and stepped down by factor of ten.</caption></image> 
<bigspace>

<para>
In going from primary, V(2), to secondary, V(3,5), the voltage was stepped down by a factor of ten, (Figure<ref>22039.png above</ref>)
<comment>split for multiple refs in one paragraph</comment>
, and  the current was stepped up by a factor of 10. (Figure<ref>22040.png below</ref>) 
<comment>split for multiple refs in one paragraph</comment>
Both current (Figure<ref>22040.png below</ref>)
<comment>split for multiple refs in one paragraph</comment>
and voltage (Figure<ref>22039.png above</ref>) waveforms are in-phase in going from primary to secondary.
</para>

<table><literal>
nutmeg commands:
setplot tran1
plot I(L1#branch) I(L2#branch)
</literal></table>
<image>22040.png<caption>Primary and secondary currents are in-phase. Secondary current is stepped up by a factor of ten.</caption></image>



<para>
It would appear that both voltage and current for the two transformer windings are in-phase with each other, at least for our resistive load.  This is simple enough, but it would be nice to know <italic>which way</italic> we should connect a transformer in order to ensure the proper phase relationships be kept.  After all, a transformer is nothing more than a set of magnetically-linked inductors, and inductors don't usually come with polarity markings of any kind.  If we were to look at an unmarked transformer, we would have no way of knowing which way to hook it up to a circuit to get in-phase (or 180<superscript>o</superscript> out-of-phase) voltage and current: (Figure<ref>02137.png below</ref>)
</para>

<image>02137.png<caption>As a practical matter, the polarity of a transformer can be ambiguous.</caption></image> 

<index>Dot convention, transformer</index>

<para>
Since this is a practical concern, transformer manufacturers have come up with a sort of polarity marking standard to denote phase relationships.  It is called the <italic>dot convention</italic>, and is nothing more than a dot placed next to each corresponding leg of a transformer winding: (Figure<ref>02138.png below</ref>)
</para>

<image>02138.png<caption>A pair of dots indicates like polarity. </caption></image> 

<para>
Typically, the transformer will come with some kind of schematic diagram labeling the wire leads for primary and secondary windings.  On the diagram will be a pair of dots similar to what is seen above.  Sometimes dots will be omitted, but when ``H'' and ``X'' labels are used to label transformer winding wires, the subscript numbers are supposed to represent winding polarity.  The ``1'' wires (H<subscript>1</subscript> and X<subscript>1</subscript>) represent where the polarity-marking dots would normally be placed.
</para>

<para>
The similar placement of these dots next to the top ends of the primary and secondary windings tells us that whatever instantaneous voltage polarity seen across the primary winding will be the same as that across the secondary winding.  In other words, the phase shift from primary to secondary will be zero degrees.
</para>

<para>
On the other hand, if the dots on each winding of the transformer do <italic>not</italic> match up, the phase shift will be 180<superscript>o</superscript> between primary and secondary, like this: (Figure<ref>02139.png below</ref>)
</para>

<image>02139.png<caption>Out of phase: primary red to dot, secondary black to dot.</caption></image> 

<para>
Of course, the dot convention only tells you which end of each winding is which, relative to the other winding(s).  If you want to reverse the phase relationship yourself, all you have to do is swap the winding connections like this: (Figure<ref>02140.png below</ref>)
</para>

<image>02140.png<caption>In phase: primary red to dot, secondary red to dot.</caption></image> 

<itemize>
<item><bold>REVIEW:</bold></item>
<item>The phase relationships for voltage and current between primary and secondary circuits of a transformer are direct: ideally, zero phase shift.</item>
<item>The <italic>dot convention</italic> is a type of polarity marking for transformer windings showing which end of the winding is which, relative to the other windings.</item>
</itemize>

</section>





<section>
<sectiontitle>Winding configurations</sectiontitle>

<para>
Transformers are very versatile devices.  The basic concept of energy transfer between mutual inductors is useful enough between a single primary and single secondary coil, but transformers don't have to be made with just two sets of windings.  Consider this transformer circuit: (Figure<ref>02141.png below</ref>)
</para>

<image>02141.png<caption>Transformer with multiple secondaries, provides multiple output voltages.</caption></image> 

<index>Vacuum tube</index>
<index>Tube, vacuum</index>

<para>
Here, three inductor coils share a common magnetic core, magnetically ``coupling'' or ``linking'' them together.  The relationship of winding turn ratios and voltage ratios seen with a single pair of mutual inductors still holds true here for multiple pairs of coils.  It is entirely possible to assemble a transformer such as the one above (one primary winding, two secondary windings) in which one secondary winding is a step-down and the other is a step-up.  In fact, this design of transformer was quite common in vacuum tube power supply circuits, which were required to supply low voltage for the tubes' filaments (typically 6 or 12 volts) and high voltage for the tubes' plates (several hundred volts) from a nominal primary voltage of 110 volts AC.  Not only are voltages and currents of completely different magnitudes possible with such a transformer, but all circuits are electrically isolated from one another.
</para>
<image>52010.jpg<caption>Photograph of multiple-winding transformer with six windings, a primary and five secondaries.</caption></image> 

<para>
The transformer in Figure<ref>52010.jpg above</ref> is intended to provide both high and low voltages necessary in an electronic system using vacuum tubes.  Low voltage is required to power the filaments of vacuum tubes, while high voltage is required to create the potential difference between the plate and cathode elements of each tube.  One transformer with multiple windings suffices elegantly to provide all the necessary voltage levels from a single 115 V source.  The wires for this transformer (15 of them!) are not shown in the photograph, being hidden from view.
</para>

<para>
If electrical isolation between secondary circuits is not of great importance, a similar effect can be obtained by ``tapping'' a single secondary winding at multiple points along its length, like  Figure<ref>02142.png below</ref>.
</para>

<image>02142.png<caption>A single tapped secondary provides multiple voltages.</caption></image> 

<para>
A tap is nothing more than a wire connection made at some point on a winding between the very ends.  Not surprisingly, the winding turn/voltage magnitude relationship of a normal transformer holds true for all tapped segments of windings.  This fact can be exploited to produce a transformer capable of multiple ratios: (Figure<ref>02143.png below</ref>)
</para>

<image>02143.png<caption>A tapped secondary using a switch to select one of many possible voltages.</caption></image> 

<index>Variable transformer</index>
<index>Transformer, variable</index>

<para>
Carrying the concept of winding taps further, we end up with a ``variable transformer,'' where a sliding contact is moved along the length of an exposed secondary winding, able to connect with it at any point along its length.  The effect is equivalent to having a winding tap at every turn of the winding, and a switch with poles at every tap position: (Figure<ref>02144.png below</ref>)
</para>

<image>02144.png<caption>A sliding contact on the secondary continuously varies the secondary voltage.</caption></image> 

<para>
One consumer application of the variable transformer is in speed controls for model train sets, especially the train sets of the 1950's and 1960's.  These transformers were essentially step-down units, the highest voltage obtainable from the secondary winding being substantially less than the primary voltage of 110 to 120 volts AC.  The variable-sweep contact provided a simple means of voltage control with little wasted power, much more efficient than control using a variable resistor!
</para>

<index>Switch, tap</index>
<index>Tap switch</index>

<para>
Moving-slide contacts are too impractical to be used in large industrial power transformer designs, but multi-pole switches and winding taps are common for voltage adjustment.  Adjustments need to be made periodically in power systems to accommodate changes in loads over months or years in time, and these switching circuits provide a convenient means.  Typically, such ``tap switches'' are not engineered to handle full-load current, but must be actuated only when the transformer has been de-energized (no power).
</para>

<index>Autotransformer</index>

<para>
Seeing as how we can tap any transformer winding to obtain the equivalent of several windings (albeit with loss of electrical isolation between them), it makes sense that it should be possible to forego electrical isolation altogether and build a transformer from a single winding.  Indeed this is possible, and the resulting device is called an <italic>autotransformer</italic>:  (Figure<ref>02145.png below</ref>)
</para>

<image>02145.png<caption>This autotransformer steps voltage up with a single tapped winding, saving copper, sacrificing isolation.</caption></image> 

<para>
The autotransformer depicted above performs a voltage step-up function.  A step-down autotransformer would look something like Figure<ref>02146.png below</ref>.
</para>

<image>02146.png<caption>This auto transformer steps voltage down with a single copper-saving tapped winding.</caption></image> 

<index>Boosting, transformer connection</index>
<index>Bucking, transformer connection</index>

<para>
Autotransformers find popular use in applications requiring a slight boost or reduction in voltage to a load.  The alternative with a normal (isolated) transformer would be to either have just the right primary/secondary winding ratio made for the job or use a step-down configuration with the secondary winding connected in series-aiding (``boosting'') or series-opposing (``bucking'') fashion.  Primary, secondary, and load voltages are given to illustrate how this would work.
</para>

<para>
First, the ``boosting'' configuration.  In Figure<ref>02147.png below</ref>  the secondary coil's polarity is oriented so that its voltage directly adds to the primary voltage.
</para>

<image>02147.png<caption>Ordinary transformer wired as an autotransformer to boost the line voltage.</caption></image> 

<para>
Next, the ``bucking'' configuration.  In Figure<ref>02148.png below</ref> the secondary coil's polarity is oriented so that its voltage directly subtracts from the primary voltage:
</para>

<image>02148.png<caption>Ordinary transformer wired as an autotransformer to buck the line voltage down.</caption></image> 

<para>
The prime advantage of an autotransformer is that the same boosting or bucking function is obtained with only a single winding, making it cheaper and lighter to manufacture than a regular (isolating) transformer having both primary and secondary windings.
</para>

<index>Variac</index>

<para>
Like regular transformers, autotransformer windings can be tapped to provide variations in ratio.  Additionally, they can be made continuously variable with a sliding contact to tap the winding at any point along its length.  The latter configuration is popular enough to have earned itself its own name: the <italic>Variac</italic>. (Figure<ref>02149.png below</ref>)
</para>

<image>02149.png<caption>A variac is an autotransformer with a sliding tap.</caption></image> 

<para>
Small variacs for benchtop use are popular pieces of equipment for the electronics experimenter, being able to step household AC voltage down (or sometimes up as well) with a wide, fine range of control by a simple twist of a knob.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item>Transformers can be equipped with more than just a single primary and single secondary winding pair.  This allows for multiple step-up and/or step-down ratios in the same device.</item>
<item>Transformer windings can also be ``tapped:'' that is, intersected at many points to segment a single winding into sections.</item>
<item>Variable transformers can be made by providing a movable arm that sweeps across the length of a winding, making contact with the winding at any point along its length.  The winding, of course, has to be bare (no insulation) in the area where the arm sweeps.</item>
<item>An autotransformer is a single, tapped inductor coil used to step up or step down voltage like a transformer, except without providing electrical isolation.</item>
<item>A <italic>Variac</italic> is a variable autotransformer.</item>
</itemize>

</section>





<section>
<sectiontitle>Voltage regulation</sectiontitle>

<index>Voltage regulation</index>

<para>
As we saw in a few SPICE analyses earlier in this chapter, the output voltage of a transformer varies some with varying load resistances, even with a constant voltage input.  The degree of variance is affected by the primary and secondary winding inductances, among other factors, not the least of which includes winding resistance and the degree of mutual inductance (magnetic coupling) between the primary and secondary windings.  For power transformer applications, where the transformer is seen by the load (ideally) as a constant source of voltage, it is good to have the secondary voltage vary as little as possible for wide variances in load current.
</para>

<para>
The measure of how well a power transformer maintains constant secondary voltage over a range of load currents is called the transformer's <italic>voltage regulation</italic>.  It can be calculated from the following formula:
</para>

<image>12104.png</image> 

<para>
``Full-load'' means the point at which the transformer is operating at maximum permissible secondary current.  This operating point will be determined primarily by the winding wire size (ampacity) and the method of transformer cooling.  Taking our first SPICE transformer simulation as an example, let's compare the output voltage with a 1 k<OMEGA> load versus a 200 <OMEGA> load (assuming that the 200 <OMEGA> load will be our ``full load'' condition).  Recall if you will that our constant primary voltage was 10.00 volts AC:
</para>


<table>
<literal>
freq          v(3,5)      i(vi1)      
6.000E+01     9.962E+00   9.962E-03    Output with 1k ohm load

freq          v(3,5)      i(vi1)      
6.000E+01     9.348E+00   4.674E-02    Output with 200 ohm load
</literal>
</table>


<para>
Notice how the output voltage decreases as the load gets heavier (more current).  Now let's take that same transformer circuit and place a load resistance of extremely high magnitude across the secondary winding to simulate a ``no-load'' condition: (See "transformer" spice list")
</para>

 
<table><literal>
transformer    
v1 1 0 ac 10 sin
rbogus1 1 2 1e-12       
rbogus2 5 0 9e12
l1 2 0 100      
l2 3 5 100      
k l1 l2 0.999   
vi1 3 4 ac 0    
rload 4 5 9e12  
.ac lin 1 60 60 
.print ac v(2,0) i(v1)  
.print ac v(3,5) i(vi1) 
.end    
</literal></table>


<table><literal>
freq          v(2)        i(v1)       
6.000E+01     1.000E+01   2.653E-04

freq          v(3,5)      i(vi1)      
6.000E+01     9.990E+00   1.110E-12   Output with (almost) no load
</literal></table>


<para>
So, we see that our output (secondary) voltage spans a range of 9.990 volts at (virtually) no load and 9.348 volts at the point we decided to call ``full load.''  Calculating voltage regulation with these figures, we get:
</para>

<image>12105.png</image> 

<para>
Incidentally, this would be considered rather poor (or ``loose'') regulation for a power transformer.  Powering a simple resistive load like this, a good power transformer should exhibit a regulation percentage of less than 3%.  Inductive loads tend to create a condition of worse voltage regulation, so this analysis with purely resistive loads was a ``best-case'' condition.
</para>

<para>
There are some applications, however, where poor regulation is actually desired.  One such case is in discharge lighting, where a step-up transformer is required to initially generate a high voltage (necessary to ``ignite'' the lamps), then the voltage is expected to drop off once the lamp begins to draw current.  This is because discharge lamps' voltage requirements tend to be much lower after a current has been established through the arc path.  In this case, a step-up transformer with poor voltage regulation suffices nicely for the task of conditioning power to the lamp.
</para>

<para>
Another application is in current control for AC arc welders, which are nothing more than step-down transformers supplying low-voltage, high-current power for the welding process.  A high voltage is desired to assist in ``striking'' the arc (getting it started), but like the discharge lamp, an arc doesn't require as much voltage to sustain itself once the air has been heated to the point of ionization.  Thus, a decrease of secondary voltage under high load current would be a good thing.  Some arc welder designs provide arc current adjustment by means of a movable iron core in the transformer, cranked in or out of the winding assembly by the operator.  Moving the iron slug away from the windings reduces the strength of magnetic coupling between the windings, which diminishes no-load secondary voltage <italic>and</italic> makes for poorer voltage regulation.
</para>

<index>Ferroresonant transformer</index>
<index>Transformer, ferroresonant</index>

<para>
No exposition on transformer regulation could be called complete without mention of an unusual device called a <italic>ferroresonant transformer</italic>.  ``Ferroresonance'' is a phenomenon associated with the behavior of iron cores while operating near a point of magnetic saturation (where the core is so strongly magnetized that further increases in winding current results in little or no increase in magnetic flux).  
</para>

<index>Tank circuit</index>

<para>
While being somewhat difficult to describe without going deep into electromagnetic theory, the ferroresonant transformer is a power transformer engineered to operate in a condition of persistent core saturation.  That is, its iron core is ``stuffed full'' of magnetic lines of flux for a large portion of the AC cycle so that variations in supply voltage (primary winding current) have little effect on the core's magnetic flux density, which means the secondary winding outputs a nearly constant voltage despite significant variations in supply (primary winding) voltage.  Normally, core saturation in a transformer results in distortion of the sinewave shape, and the ferroresonant transformer is no exception.  To combat this side effect, ferroresonant transformers have an auxiliary secondary winding paralleled with one or more capacitors, forming a resonant circuit tuned to the power supply frequency.  This ``tank circuit'' serves as a filter to reject harmonics created by the core saturation, and provides the added benefit of storing energy in the form of AC oscillations, which is available for sustaining output winding voltage for brief periods of input voltage loss (milliseconds' worth of time, but certainly better than nothing).   (Figure<ref>02278.png below</ref>)
</para>

<image>02278.png<caption>Ferroresonant transformer provides voltage regulation of the output.</caption></image> 

<para>
In addition to blocking harmonics created by the saturated core, this resonant circuit also ``filters out'' harmonic frequencies generated by nonlinear (switching) loads in the secondary winding circuit and any harmonics present in the source voltage, providing ``clean'' power to the load.
</para>

<para>
Ferroresonant transformers offer several features useful in AC power conditioning: constant output voltage given substantial variations in input voltage, harmonic filtering between the power source and the load, and the ability to ``ride through'' brief losses in power by keeping a reserve of energy in its resonant tank circuit.  These transformers are also highly tolerant of excessive loading and transient (momentary) voltage surges.  They are so tolerant, in fact, that some may be briefly paralleled with unsynchronized AC power sources, allowing a load to be switched from one source of power to another in a ``make-before-break'' fashion with no interruption of power on the secondary side!
</para>

<para>
Unfortunately, these devices have equally noteworthy disadvantages: they waste a lot of energy (due to hysteresis losses in the saturated core), generating <italic>significant</italic> heat in the process, and are intolerant of frequency variations, which means they don't work very well when powered by small engine-driven generators having poor speed regulation.  Voltages produced in the resonant winding/capacitor circuit tend to be very high, necessitating expensive capacitors and presenting the service technician with very dangerous working voltages.  Some applications, though, may prioritize the ferroresonant transformer's advantages over its disadvantages.  Semiconductor circuits exist to ``condition'' AC power as an alternative to ferroresonant devices, but none can compete with this transformer in terms of sheer simplicity.
</para>

<itemize>
<item><bold>REVIEW:</bold></item>
<item><italic>Voltage regulation</italic> is the measure of how well a power transformer can maintain constant secondary voltage given a constant primary voltage and wide variance in load current.  The lower the percentage (closer to zero), the more stable the secondary voltage and the better the regulation it will provide.</item>
<item>A <italic>ferroresonant</italic> transformer is a special transformer designed to regulate voltage at a stable level despite wide variation in input voltage.</item>
</itemize>

</section>





<section>
<sectiontitle>Special transformers and applications</sectiontitle>


<subsection>
<subsectiontitle>Impedance matching</subsectiontitle>



<para>
Because transformers can step voltage and current to different levels, and because power is transferred equivalently between primary and secondary windings, they can be used to ``convert'' the impedance of a load to a different level.  That last phrase deserves some explanation, so let's investigate what it means.
</para>

<para>
The purpose of a load (usually) is to do something productive with the power it dissipates.  In the case of a resistive heating element, the practical purpose for the power dissipated is to heat something up.  Loads are engineered to safely dissipate a certain maximum amount of power, but two loads of equal power rating are not necessarily identical.  Consider these two 1000 watt resistive heating elements: (Figure<ref>02151.png below</ref>)
</para>

<image>02151.png<caption>Heating elements dissipate 1000 watts, at different voltage and current ratings.</caption></image> 

<para>
Both heaters dissipate exactly 1000 watts of power, but they do so at different voltage and current levels (either 250 volts and 4 amps, or 125 volts and 8 amps).  Using Ohm's Law to determine the necessary resistance of these heating elements (R=E/I), we arrive at figures of 62.5 <OMEGA> and 15.625 <OMEGA>, respectively.  If these are AC loads, we might refer to their opposition to current in terms of impedance rather than plain resistance, although in this case that's all they're composed of (no reactance).  The 250 volt heater would be said to be a higher impedance load than the 125 volt heater.
</para>

<para>
If we desired to operate the 250 volt heater element directly on a 125 volt power system, we would end up being disappointed.  With 62.5 <OMEGA> of impedance (resistance), the current would only be 2 amps (I=E/R; 125/62.5), and the power dissipation would only be 250 watts (P=IE; 125 x 2), or one-quarter of its rated power.  The impedance of the heater and the voltage of our source would be mismatched, and we couldn't obtain the full rated power dissipation from the heater.
</para>

<para>
All hope is not lost, though.  With a step-up transformer, we could operate the 250 volt heater element on the 125 volt power system like Figure<ref>02150.png below</ref>.
</para>

<image>02150.png<caption>Step-up transformer operates 1000 watt 250 V  heater from 125 V power source</caption></image> 

<index>Impedance matching</index>

<para>
The ratio of the transformer's windings provides the voltage step-up <italic>and</italic> current step-down we need for the otherwise mismatched load to operate properly on this system.  Take a close look at the primary circuit figures: 125 volts at 8 amps.  As far as the power supply ``knows,'' its powering a 15.625 <OMEGA> (R=E/I) load at 125 volts, not a 62.5 <OMEGA> load!  The voltage and current figures for the primary winding are indicative of 15.625 <OMEGA> load impedance, not the actual 62.5 <OMEGA> of the load itself.  In other words, not only has our step-up transformer transformed voltage and current, but it has transformed <italic>impedance</italic> as well.
</para>

<para>
The transformation ratio of impedance is the square of the voltage/current transformation ratio, the same as the winding inductance ratio:
</para>

<image>12106.png</image> 

<para>
This concurs with our example of the 2:1 step-up transformer and the impedance ratio of 62.5 <OMEGA> to 15.625 <OMEGA> (a 4:1 ratio, which is 2:1 squared).  Impedance transformation is a highly useful ability of transformers, for it allows a load to dissipate its full rated power even if the power system is not at the proper voltage to directly do so.
</para>

<index>Maximum Power Transfer Theorem</index>
<index>Theorem, Maximum Power Transfer</index>
<index>Thevenin's Theorem</index>
<index>Theorem, Thevenin's</index>
<index>Norton's Theorem</index>
<index>Theorem, Norton's</index>

<para>
Recall from our study of network analysis the <italic>Maximum Power Transfer Theorem</italic>, which states that the maximum amount of power will be dissipated by a load resistance when that load resistance is equal to the Thevenin/Norton resistance of the network supplying the power.  Substitute the word ``impedance'' for ``resistance'' in that definition and you have the AC version of that Theorem.  If we're trying to obtain theoretical maximum power dissipation from a load, we must be able to properly match the load impedance and source (Thevenin/Norton) impedance together.  This is generally more of a concern in specialized electric circuits such as radio transmitter/antenna and audio amplifier/speaker systems.  Let's take an audio amplifier system and see how it works:  (Figure<ref>02153.png below</ref>)
</para>

<image>02153.png<caption>Amplifier with impedance of 500 <OMEGA> drives 8 <OMEGA> at much less than maximum power.</caption></image> 

<para>
With an internal impedance of 500 <OMEGA>, the amplifier can only deliver full power to a load (speaker) also having 500 <OMEGA> of impedance.  Such a load would drop higher voltage and draw less current than an 8 <OMEGA> speaker dissipating the same amount of power.  If an 8 <OMEGA> speaker were connected directly to the 500 <OMEGA> amplifier as shown, the <italic>impedance mismatch</italic> would result in very poor (low peak power) performance.  Additionally, the amplifier would tend to dissipate more than its fair share of power in the form of heat trying to drive the low impedance speaker.
</para>

<para>
To make this system work better, we can use a transformer to match these mismatched impedances.  Since we're going from a high impedance (high voltage, low current) supply to a low impedance (low voltage, high current) load, we'll need to use a step-down transformer: (Figure<ref>02152.png below</ref>)
</para>

<image>02152.png<caption>Impedance matching transformer matches 500 <OMEGA> amplifier to 8 <OMEGA> speaker for maximum efficiency.</caption></image> 

<index>Impedance matching</index>

<para>
To obtain an impedance transformation ratio of 500:8, we would need a winding ratio equal to the square root of 500:8 (the square root of 62.5:1, or 7.906:1).  With such a transformer in place, the speaker will load the amplifier to just the right degree, drawing power at the correct voltage and current levels to satisfy the Maximum Power Transfer Theorem and make for the most efficient power delivery to the load.  The use of a transformer in this capacity is called <italic>impedance matching</italic>. 
</para>

<para>
Anyone who has ridden a multi-speed bicycle can intuitively understand the principle of impedance matching.  A human's legs will produce maximum power when spinning the bicycle crank at a particular speed (about 60 to 90 revolution per minute).  Above or below that rotational speed, human leg muscles are less efficient at generating power.  The purpose of the bicycle's ``gears'' is to impedance-match the rider's legs to the riding conditions so that they always spin the crank at the optimum speed.  
</para>

<para>
If the rider attempts to start moving while the bicycle is shifted into its ``top'' gear, he or she will find it very difficult to get moving.  Is it because the rider is weak?  No, its because the high step-up ratio of the bicycle's chain and sprockets in that top gear presents a mismatch between the conditions (lots of inertia to overcome) and their legs (needing to spin at 60-90 RPM for maximum power output).  On the other hand, selecting a gear that is too low will enable the rider to get moving immediately, but limit the top speed they will be able to attain.  Again, is the lack of speed an indication of weakness in the bicyclist's legs?  No, its because the lower speed ratio of the selected gear creates another type of mismatch between the conditions (low load) and the rider's legs (losing power if spinning faster than 90 RPM).  It is much the same with electric power sources and loads: there must be an impedance match for maximum system efficiency.  In AC circuits, transformers perform the same matching function as the sprockets and chain (``gears'') on a bicycle to match otherwise mismatched sources and loads.
</para>

<para>
Impedance matching transformers are not fundamentally different from any other type of transformer in construction or appearance.  A small impedance-matching transformer (about two centimeters in width) for audio-frequency applications is shown in the following photograph: (Figure<ref>52003.jpg below</ref>)
</para>

<image>52003.jpg<caption>Audio frequency impedance matching transformer.</caption></image> 

<para>
Another impedance-matching transformer can be seen on this printed circuit board, in the upper right corner, to the immediate left of resistors R<subscript>2</subscript> and R<subscript>1</subscript>.  It is labeled ``T1'': (Figure<ref>52005.jpg below</ref>)
</para>

<image>52005.jpg<caption>Printed circuit board mounted audio impedance matching transformer, top  right.</caption></image> 

</subsection>

<subsection>
<subsectiontitle>Potential transformers </subsectiontitle>


<para>
Transformers can also be used in electrical instrumentation systems.  Due to transformers' ability to step up or step down voltage and current, and the electrical isolation they provide, they can serve as a way of connecting electrical instrumentation to high-voltage, high current power systems.  Suppose we wanted to accurately measure the voltage of a 13.8 kV power system (a very common power distribution voltage in American industry): (Figure<ref>02154.png below</ref>)
</para>

<image>02154.png<caption>Direct measurement of high voltage by a voltmeter is a potential safety hazard.</caption></image> 

<para>
Designing, installing, and maintaining a voltmeter capable of directly measuring 13,800 volts AC would be no easy task.  The safety hazard alone of bringing 13.8 kV conductors into an instrument panel would be severe, not to mention the design of the voltmeter itself.  However, by using a precision step-down transformer, we can reduce the 13.8 kV down to a safe level of voltage at a constant ratio, and isolate it from the instrument connections, adding an additional level of safety to the metering system: (Figure<ref>02155.png below</ref>)
</para>

<image>02155.png<caption>Instrumentation application:``Potential transformer'' precisely scales dangerous high voltage to a safe value applicable to a  conventional voltmeter.</caption></image> 

<index>Potential transformer</index>
<index>PT</index>

<para>
Now the voltmeter reads a precise fraction, or ratio, of the actual system voltage, its scale set to read as though it were measuring the voltage directly.  The transformer keeps the instrument voltage at a safe level and electrically isolates it from the power system, so there is no direct connection between the power lines and the instrument or instrument wiring.  When used in this capacity, the transformer is called a <italic>Potential Transformer</italic>, or simply <italic>PT</italic>.
</para>

<para>
Potential transformers are designed to provide as accurate a voltage step-down ratio as possible.  To aid in precise voltage regulation, loading is kept to a minimum: the voltmeter is made to have high input impedance so as to draw as little current from the PT as possible.  As you can see, a fuse has been connected in series with the PT's primary winding, for safety and ease of disconnecting the PT from the circuit.  
</para>

<para>
A standard secondary voltage for a PT is 120 volts AC, for full-rated power line voltage.  The standard voltmeter range to accompany a PT is 150 volts, full-scale.  PT's with custom winding ratios can be manufactured to suit any application.  This lends itself well to industry standardization of the actual voltmeter instruments themselves, since the PT will be sized to step the system voltage down to this standard instrument level. 
</para>
</subsection>

<subsection>
<subsectiontitle>Current transformers</subsectiontitle>

<para>
Following the same line of thinking, we can use a transformer to step down current through a power line so that we are able to safely and easily measure high system currents with inexpensive ammeters.  Of course, such a transformer would be connected in series with the power line, like (Figure<ref>02156.png below</ref>).
</para>

<image>02156.png<caption>Instrumentation application: ``Current transformer'' steps high current down to a value applicable to a conventional ammeter.</caption></image> 

<index>Current transformer</index>
<index>CT</index>

<para>
Note that while the PT is a step-down device, the <italic>Current Transformer</italic> (or <italic>CT</italic>) is a step-up device (with respect to voltage), which is what is needed to step <italic>down</italic> the power line current.  Quite often, CTs are built as doughnut-shaped devices through which the power line conductor is run, the power line itself acting as a single-turn primary winding:  (Figure<ref>52008.jpg below</ref>)
</para>

<image>52008.jpg<caption>Current conductor to be measured is threaded through the opening. Scaled down current is available on wire leads.</caption></image> 

<para>
Some CTs are made to hinge open, allowing insertion around a power conductor without disturbing the conductor at all.  The industry standard secondary current for a CT is a range of 0 to 5 amps AC.  Like PT's, CTs can be made with custom winding ratios to fit almost any application.  Because their ``full load'' secondary current is 5 amps, CT ratios are usually described in terms of full-load primary amps to 5 amps, like this:
</para>

<image>12107.png</image> 

<para>
The ``doughnut'' CT shown in the photograph has a ratio of 50:5.  That is, when the conductor through the center of the torus is carrying 50 amps of current (AC), there will be 5 amps of current induced in the CT's winding.
</para>

<para>
Because CTs are designed to be powering ammeters, which are low-impedance loads, and they are wound as voltage step-up transformers, they should never, <italic>ever</italic> be operated with an open-circuited secondary winding.  Failure to heed this warning will result in the CT producing extremely high secondary voltages, dangerous to equipment and personnel alike.  To facilitate maintenance of ammeter instrumentation, short-circuiting switches are often installed in parallel with the CT's secondary winding, to be closed whenever the ammeter is removed for service: (Figure<ref>02157.png below</ref>)
</para>

<image>02157.png<caption>Short-circuit switch allows ammeter to be removed from an active current transformer circuit.</caption></image> 

<para>
Though it may seem strange to <italic>intentionally</italic> short-circuit a power system component, it is perfectly proper and quite necessary when working with current transformers.
</para>

</subsection>

<subsection>
<subsectiontitle>Air core transformers</subsectiontitle>



<para>
Another kind of special transformer, seen often in radio-frequency circuits, is the <italic>air core</italic> transformer. (Figure<ref>02334.png below</ref>)  True to its name, an air core transformer has its windings wrapped around a nonmagnetic form, usually a hollow tube of some material.  The degree of coupling (mutual inductance) between windings in such a transformer is many times less than that of an equivalent iron-core transformer, but the undesirable characteristics of a ferromagnetic core (eddy current losses, hysteresis, saturation, etc.) are completely eliminated.  It is in high-frequency applications that these effects of iron cores are most problematic.</para>

<image>02334.png<caption>Air core transformers may be wound on cylindrical (a) or toroidal (b) forms. Center tapped primary with secondary (a). Bifilar winding on toroidal form (b).</caption></image> 

<para>
The inside tapped solenoid winding, (Figure (a)<ref>02334.png above</ref>),  without the over winding, could match unequal impedances when DC isolation is not required. When isolation is required the over winding is added over one end of the main winding. Air core transformers are used at radio frequencies when iron core losses are too high. Frequently air core transformers are paralleled with a capacitor to tune it to resonance. The over winding is connected between a radio antenna and ground for one such application. The secondary is tuned to resonance with a variable capacitor. The output may be taken from the tap point for amplification or detection. Small millimeter size air core transformers are used in radio receivers. The largest radio transmitters may use meter sized coils. Unshielded air core solenoid  transformers are mounted at right angles to each other to prevent stray coupling.
</para>

<para>
Stray coupling is minimized when the transformer is wound on a toroid form. (Figure (b)<ref>02334.png above</ref>) Toroidal air core transformers also show a higher degree of coupling, particularly for <italic>bifilar</italic> windings. Bifilar windings are wound from a slightly twisted pair of wires. This implies a 1:1 turns ratio. Three or four wires may be grouped for 1:2 and other integral ratios. Windings do not have to be bifilar. This allows arbitrary turns ratios. However, the degree of coupling suffers. Toroidal air core transformers are rare except for VHF (Very High Frequency) work. Core materials other than air such as powdered iron or ferrite are preferred for lower radio frequencies.
</para>

</subsection>


<subsection>
<subsectiontitle>Tesla Coil </subsectiontitle>

<index>Tesla Coil</index>
<index>Tesla, Nikola</index>
<index>Coil, Tesla</index>
<index>Skin effect</index>

<para>
One notable example of an air-core transformer is the <italic>Tesla Coil</italic>, named after the Serbian electrical genius Nikola Tesla, who was also the inventor of the rotating magnetic field AC motor, polyphase AC power systems, and many elements of radio technology.  The Tesla Coil is a resonant, high-frequency step-up transformer used to produce extremely high voltages.  One of Tesla's dreams was to employ his coil technology to distribute electric power without the need for wires, simply broadcasting it in the form of radio waves which could be received and conducted to loads by means of antennas.  The basic schematic for a Tesla Coil is shown in Figure<ref>02158.png below</ref>.
</para>

<image>02158.png<caption>Tesla Coil: A few heavy primary turns, many secondary turns.</caption></image> 

<para>
The capacitor, in conjunction with the transformer's primary winding, forms a tank circuit.  The secondary winding is wound in close proximity to the primary, usually around the same nonmagnetic form.  Several options exist for ``exciting'' the primary circuit, the simplest being a high-voltage, low-frequency AC source and spark gap: (Figure<ref>02159.png below</ref>)
</para>

<image>02159.png<caption>System level diagram of Tesla coil with spark gap drive.</caption></image> 

<para>
The purpose of the high-voltage, low-frequency AC power source is to ``charge'' the primary tank circuit.  When the spark gap fires, its low impedance acts to complete the capacitor/primary coil tank circuit, allowing it to oscillate at its resonant frequency.  The ``RFC'' inductors are ``Radio Frequency Chokes,'' which act as high impedances to prevent the AC source from interfering with the oscillating tank circuit.
</para>

<para>
The secondary side of the Tesla coil transformer is also a tank circuit, relying on the parasitic (stray) capacitance existing between the discharge terminal and earth ground to complement the secondary winding's inductance.  For optimum operation, this secondary tank circuit is tuned to the same resonant frequency as the primary circuit, with energy exchanged not only between capacitors and inductors during resonant oscillation, but also back-and-forth between primary and secondary windings.  The visual results are spectacular: (Figure<ref>52001.jpg below</ref>)
</para>

<image>52001.jpg<caption>High voltage high frequency discharge from Tesla coil.</caption></image> 

<para>
Tesla Coils find application primarily as novelty devices, showing up in high school science fairs, basement workshops, and the occasional low budget science-fiction movie.
</para>

<para>
It should be noted that Tesla coils can be extremely dangerous devices.  Burns caused by radio-frequency (``RF'') current, like all electrical burns, can be very deep, unlike skin burns caused by contact with hot objects or flames.  Although the high-frequency discharge of a Tesla coil has the curious property of being beyond the ``shock perception'' frequency of the human nervous system, this does not mean Tesla coils cannot hurt or even kill you!  I strongly advise seeking the assistance of an experienced Tesla coil experimenter if you would embark on building one yourself.
</para>

</subsection>


<subsection>
<subsectiontitle>Saturable reactors </subsectiontitle>

<para>

</para>



<index>Amplifier</index>

<para>
So far, we've explored the transformer as a device for converting different levels of voltage, current, and even impedance from one circuit to another.  Now we'll take a look at it as a completely different kind of device: one that allows a small electrical signal to exert <italic>control</italic> over a much larger quantity of electrical power.  In this mode, a transformer acts as an <italic>amplifier</italic>.
</para>

<index>Saturable reactor</index>

<para>
The device I'm referring to is called a <italic>saturable-core reactor</italic>, or simply <italic>saturable reactor</italic>.  Actually, it is not really a transformer at all, but rather a special kind of inductor whose inductance can be varied by the application of a DC current through a second winding wound around the same iron core.  Like the ferroresonant transformer, the saturable reactor relies on the principle of magnetic saturation.  When a material such as iron is completely saturated (that is, all its magnetic domains are lined up with the applied magnetizing force), additional increases in current through the magnetizing winding will not result in further increases of magnetic flux.
</para>

<para>
Now, inductance is the measure of how well an inductor opposes changes in current by developing a voltage in an opposing direction.  The ability of an inductor to generate this opposing voltage is directly connected with the change in magnetic flux inside the inductor resulting from the change in current, and the number of winding turns in the inductor.  If an inductor has a saturated core, no further magnetic flux will result from further increases in current, and so there will be no voltage induced in opposition to the change in current.  In other words, an inductor loses its inductance (ability to oppose changes in current) when its core becomes magnetically saturated.
</para>

<para>
If an inductor's inductance changes, then its reactance (and impedance) to AC current changes as well.  In a circuit with a constant voltage source, this will result in a change in current: (Figure<ref>02160.png below</ref>)
</para>

<image>02160.png<caption>If L changes in inductance, Z<subscript>L</subscript> will correspondingly change, thus changing the circuit current.</caption></image> 

<para>
A saturable reactor capitalizes on this effect by forcing the core into a state of saturation with a strong magnetic field generated by current through another winding.  The reactor's ``power'' winding is the one carrying the AC load current, and the ``control'' winding is one carrying a DC current strong enough to drive the core into saturation: (Figure<ref>02161.png below</ref>)
</para>

<image>02161.png<caption>DC, via the control winding, saturates the core. Thus, modulating the power winding inductance, impedance, and current.</caption></image> 

<para>
The strange-looking transformer symbol shown in the above schematic represents a saturable-core reactor, the upper winding being the DC control winding and the lower being the ``power'' winding through which the controlled AC current goes.  Increased DC control current produces more magnetic flux in the reactor core, driving it closer to a condition of saturation, thus decreasing the power winding's inductance, decreasing its impedance, and increasing current to the load.  Thus, the DC control current is able to exert <italic>control</italic> over the AC current delivered to the load.
</para>

<para>
The circuit shown would work, but it would not work very well.  The first problem is the natural transformer action of the saturable reactor: AC current through the power winding will induce a voltage in the control winding, which may cause trouble for the DC power source.  Also, saturable reactors tend to regulate AC power only in one direction: in one half of the AC cycle, the mmf's from both windings add; in the other half, they subtract.  Thus, the core will have more flux in it during one half of the AC cycle than the other, and will saturate first in that cycle half, passing load current more easily in one direction than the other.  Fortunately, both problems can be overcome with a little ingenuity: (Figure<ref>02162.png below</ref>)
</para>

<image>02162.png<caption>Out of phase DC control windings allow symmetrical of control AC.</caption></image> 

<para>
Notice the placement of the phasing dots on the two reactors: the power windings are ``in phase'' while the control windings are ``out of phase.''  If both reactors are identical, any voltage induced in the control windings by load current through the power windings will cancel out to zero at the battery terminals, thus eliminating the first problem mentioned.  Furthermore, since the DC control current through both reactors produces magnetic fluxes in different directions through the reactor cores, one reactor will saturate more in one cycle of the AC power while the other reactor will saturate more in the other, thus equalizing the control action through each half-cycle so that the AC power is ``throttled'' symmetrically.  This phasing of control windings can be accomplished with two separate reactors as shown, or in a single reactor design with intelligent layout of the windings and core.
</para>

<index>Magnetic amplifier</index>
<index>Amplifier, magnetic</index>

<para>
Saturable reactor technology has even been miniaturized to the circuit-board level in compact packages more generally known as <italic>magnetic amplifiers</italic>.  I personally find this to be fascinating: the effect of amplification (one electrical signal controlling another), normally requiring the use of physically fragile vacuum tubes or electrically ``fragile'' semiconductor devices, can be realized in a device both physically and electrically rugged.  Magnetic amplifiers do have disadvantages over their more fragile counterparts, namely size, weight, nonlinearity, and bandwidth (frequency response), but their utter simplicity still commands a certain degree of appreciation, if not practical application.
</para>

<index>Transductor</index>

<para>
Saturable-core reactors are less commonly known as ``saturable-core inductors'' or <italic>transductors</italic>. 
</para>
</subsection>


<subsection>
<subsectiontitle>Scott-T transformer</subsectiontitle>
<index>Scott-T transformer</index>
<index>transformer, Scott-T</index>
<hypertarget>scott[]</hypertarget>

<para>
Nikola Tesla's original polyphase power system was based on simple to build 2-phase components. However, as transmission distances increased, the more transmission line efficient 3-phase system became more prominent. Both 2-<phi> and 3-<phi> components coexisted for a number of years. The Scott-T transformer connection allowed 2-<phi> and 3-<phi> components like motors and alternators to be interconnected. Yamamoto and Yamaguchi:  
</para>

<quotation>In 1896, General Electric built a 35.5 km (22 mi) three-phase transmission line operated at 11 kV to transmit power to Buffalo, New York, from the Niagara Falls Project. The two-phase generated power was changed to
three-phase by the use of Scott-T transformations. <cite>MYA</cite></quotation>


<image>02414.png<caption>Scott-T transformer converts 2-<phi> to 3-<phi>, or vice versa.</caption></image>

<para>
The Scott-T transformer set,  Figure<ref>02414.png above</ref>, consists of a center tapped transformer T1 and an 86.6% tapped transformer T2 on the 3-<phi> side of the circuit. The primaries of both transformers are connected to the 2-<phi> voltages. One end of the T2 86.6% secondary winding is a 3-<phi> output, the other end is connected to the T1 secondary center tap. Both ends of the T1 secondary are the other two 3-<phi> connections.
</para>

<para>
Application of 2-<phi> Niagara generator power produced a 3-<phi> output for the more efficient 3-<phi> transmission line. More common these days is the application of 3-<phi> power to produce a 2-<phi> output for driving an old 2-<phi> motor.
</para>

<para>
In Figure<ref>02415.png below</ref>, we use vectors in both polar and complex notation to prove that the Scott-T converts a pair of 2-<phi> voltages to 3-<phi>. First, one of the 3-<phi> voltages is identical to a 2-<phi> voltage due to the 1:1 transformer T1 ratio, V<subscript>P12</subscript>= V<subscript>2P1</subscript>. The T1 center tapped secondary produces opposite polarities of 0.5V<subscript>2P1</subscript> on the secondary ends. This <angle>0<superscript>o</superscript> is vectorially  subtracted from T2 secondary voltage due to the KVL equations  V<subscript>31</subscript>, V<subscript>23</subscript>. The T2 secondary voltage is 0.866V<subscript>2P2</subscript> due to the 86.6% tap. Keep in mind that this 2nd phase of the 2-<phi> is <angle>90<superscript>o</superscript>. This 0.866V<subscript>2P2</subscript> is added at V<subscript>31</subscript>, subtracted at V<subscript>23</subscript> in the KVL equations.
</para>

<image>02415.png<caption>Scott-T transformer 2-<phi> to 3-<phi> conversion equations.</caption></image>

<para>
We show ``DC'' polarities all over this AC only circuit, to keep track of the Kirchhoff voltage loop polarities. Subtracting <angle>0<superscript>o</superscript> is equivalent to adding <angle>180<superscript>o</superscript>.  The bottom line is when we add 86.6% of <angle>90<superscript>o</superscript> to 50% of <angle>180<superscript>o</superscript> we get <angle>120<superscript>o</superscript>. Subtracting 86.6% of <angle>90<superscript>o</superscript> from 50% of <angle>180<superscript>o</superscript> yields <angle>-120<superscript>o</superscript> or <angle>240<superscript>o</superscript>. 
</para>

<image>02416.png<caption>Graphical explanation of equations in Figure<ref>02415.png previous</ref>.</caption></image>

<para>
In Figure<ref>02416.png above</ref> we graphically show the 2-<phi> vectors at (a). At (b) the vectors are scaled by transformers T1 and T2 to 0.5 and 0.866 respectively. At (c)    1<angle>120<superscript>o</superscript> = -0.5<angle>0<superscript>o</superscript> + 0.866<angle>90<superscript>o</superscript>, and 1<angle>240<superscript>o</superscript> = -0.5<angle>0<superscript>o</superscript> - 0.866<angle>90<superscript>o</superscript>. The three output phases are  1<angle>120<superscript>o</superscript> and 1<angle>240<superscript>o</superscript> from (c), along with input 1<angle>0<superscript>o</superscript> (a).  
</para>

</subsection>



<subsection>
<subsectiontitle>Linear Variable Differential Transformer</subsectiontitle>
<index>linear variable differential transformer</index>
<index>LVDT</index>

<para>
A <italic>linear variable differential transformer</italic> (LVDT) has an AC driven primary wound between two secondaries on a cylindrical air core form. (Figure<ref>02417.png below</ref>) A movable ferromagnetic slug converts displacement to a variable voltage by changing the coupling between the driven primary and secondary windings. The LVDT is a displacement or distance measuring transducer. Units are available for measuring displacement over a distance of a fraction of a millimeter to a half a meter. LVDT's are rugged and dirt resistant compared to linear optical encoders.
</para>

<image>02417.png<caption>LVDT: linear variable differential transformer.</caption></image>


<para>
The excitation voltage is in the range of 0.5 to 10 VAC at a frequency of 1 to 200 Khz. A ferrite core is suitable at these frequencies. It is extended outside the body by an non-magnetic rod.  As the core is moved toward the top winding, the voltage across this coil increases due to increased coupling, while the voltage on the bottom coil decreases. If the core is moved toward the bottom winding, the voltage on this coil increases as the voltage decreases across the top coil. Theoretically, a centered slug yields equal voltages across both coils. In practice leakage inductance prevents the null from dropping all the way to 0 V.
</para>

<para>
With a centered slug, the series-opposing wired secondaries cancel yielding V<subscript>13</subscript> = 0. Moving the slug up increases V<subscript>13</subscript>.  Note that it is in-phase with with  V<subscript>1</subscript>, the top winding, and 180<superscript>o</superscript> out of phase with V<subscript>3</subscript>, bottom winding.  
</para>

<para>
Moving the slug down from the center position increases V<subscript>13</subscript>.  However, it is 180<superscript>o</superscript> out of phase with with  V<subscript>1</subscript>, the top winding, and in-phase  with V<subscript>3</subscript>, bottom winding. Moving the slug from top to bottom shows a minimum at the center point, with a 180<superscript>o</superscript> phase reversal in passing the center.  
</para>

</subsection>


<itemize>
<item><bold>REVIEW:</bold></item>
<item>Transformers can be used to transform impedance as well as voltage and current.  When this is done to improve power transfer to a load, it is called <italic>impedance matching</italic>.</item>
<item>A <italic>Potential Transformer</italic> (PT) is a special instrument transformer designed to provide a precise voltage step-down ratio for voltmeters measuring high power system voltages.</item>
<item>A <italic>Current Transformer</italic> (CT) is another special instrument transformer designed to step down the current through a power line to a safe level for an ammeter to measure.</item>
<item>An <italic>air-core</italic> transformer is one lacking a ferromagnetic core.</item>
<item>A <italic>Tesla Coil</italic> is a resonant, air-core, step-up transformer designed to produce very high AC voltages at high frequency.</item>
<item>A <italic>saturable reactor</italic> is a special type of inductor, the inductance of which can be controlled by the DC current through a second winding around the same core.  With enough DC current, the magnetic core can be saturated, decreasing the inductance of the power winding in a controlled fashion.</item>
<item>A <italic>Scott-T transformer</italic> converts 3-<phi> power to 2-<phi> power and vice versa.</item>
<item>A <italic>linear variable differential transformer</italic>, also known as an LVDT, is a distance measuring device. It has a movable ferromagnetic core to vary the coupling between the excited primary and a pair of secondaries.</item>
</itemize>

</section>


<section>
<sectiontitle>Practical considerations</sectiontitle>

<subsection>
<subsectiontitle>Power capacity</subsectiontitle>

<para>
As has already been observed, transformers must be well designed in order to achieve acceptable power coupling, tight voltage regulation, and low exciting current distortion.  Also, transformers must be designed to carry the expected values of primary and secondary winding current without any trouble.  This means the winding conductors must be made of the proper gauge wire to avoid any heating problems.  An ideal transformer would have perfect coupling (no leakage inductance), perfect voltage regulation, perfectly sinusoidal exciting current, no hysteresis or eddy current losses, and wire thick enough to handle any amount of current.  Unfortunately, the ideal transformer would have to be infinitely large and heavy to meet these design goals.  Thus, in the business of <italic>practical</italic> transformer design, compromises must be made.
</para>

<para>
The transformer iron core must be sized to support the total flux without undue saturation. The volt-amp rating  and  magnetic properties of the  core material  determines the total permissible flux, A larger core with fewer turns of larger diameter wire is required for a higher volt-amp rated transformer. Too few turns for a particular core size will cause magnetic saturation of the core, which causes excessive current and heating.
</para>


<para>
Additionally, winding conductor insulation is a concern where high voltages are encountered, as they often are in step-up and step-down power distribution transformers.  Not only do the windings have to be well insulated from the iron core, but each winding has to be sufficiently insulated from the other in order to maintain electrical isolation between windings.
</para>

<index>Volt-amp</index>
<index>Unit, volt-amp</index>

<para>
Respecting these limitations, transformers are rated for certain levels of primary and secondary winding voltage and current, though the current rating is usually derived from a volt-amp (VA) rating assigned to the transformer.  For example, take a step-down transformer with a primary voltage rating of 120 volts, a secondary voltage rating of 48 volts, and a VA rating of 1 kVA (1000 VA).  The maximum winding currents can be determined as such:
</para>

<image>12108.png</image> 

<para>
Sometimes windings will bear current ratings in amps, but this is typically seen on small transformers.  Large transformers are almost always rated in terms of winding voltage and VA or kVA.
</para>

</subsection>


<subsection>
<subsectiontitle>Winding design </subsectiontitle>

<para>
The number of turns in a transformer secondary is easily calculated based on the voltage ratio and primary turns Ns=Np(Vs/Vp). The problem is the determination of the number of primary turns for an iron core power transformer. The magnetic flux density and the crossection area of an iron core determines the minimum number of turns in the primary. Other factors inlcude primary voltage and frequency, allowable temperature rise above ambient. The purpose of this section is to determine the minimum number of primary turns for a given core size.
</para>


<image>12151.png<caption>Transformer core area</caption></image>


<para>
<bold>Design transformer core and windings</bold>
</para>

<itemize>
<item>Start with one of: desired volt-amp rating, or known core area </item>

  <itemize>

  <item><bold>Desired VA:</bold> Calculate the required cross section area A' for a core.  equation (1) Table <ref>12152.png below</ref>. </item>

  <item><bold>Known core area:</bold> For an on hand core, measure and calculate A' according to Table <ref>12151.png above</ref>. 
Calculate VA that the core will support with equation (2) Table <ref>12152.png below</ref>.</item>

   </itemize>

<item>Consulting Table <ref>cir-mils.tbl below</ref>, select the next higher VA line than your core VA. Select the flux density B from that line.  </item>

<item>Calculate Np primary turns with equation (3), using either A or A' part of equation (3) Table <ref>12152.png below</ref>.</item>

<item>Wire size</item>

  <itemize>

  <item>Consulting Table <ref>cir-mils.tbl below</ref>, same line as before, extract cir-mil/Amp value. This is how many circular-mils per Amp of cross section is required for the primary on the core.</item>

  <item>Wire area cir-mil = Ip * cir-mil/Amp from Table <ref>cir-mils.tbl below</ref>.</item>

  <item>Select an AWG wire size corresponding to the above Wire area cir-mil in See <hyperlink>AWGcm[Volume V - Reference, Ch 1 Useful Equations, Wire sizing for inductors][../Ref/REF_1.html]</hyperlink> Choose a line with the next larger circular-mil value.  The corresponding AWG is the size for the primary winding</item>
  </itemize>

<item>Choose Es the secondary voltage. Equation (5)  Table <ref>12152.png below</ref> gives the number of secondary turns. Note the 1.05 factor corrects for losses in a practical transformer</item>

<item>Is = Ip(Ep/Es)</item>

<item>Determine AWG wire size for the secondary similar to the procedure for Primary wire size, using the same cir-mil/Amp value. </item>

</itemize>

<bigspace>

<image>12152.png<caption>Transformer design equations, after ITT <cite>RDR</cite> </caption></image>

<bigspace>

<table>cir-mils.tbl<caption>Transformer core and wire sizing. After ITT<cite>RDR</cite></caption>
<tabular>{|l|l|l|l|}
<hr>

<tr>
<td>VA</td><td>B</td><td>Amp/sq-in</td><td>cir-mil/Amp</td>
</tr>
<tr>
<td>24</td><td>13,500</td><td>2330</td><td>545</td>
</tr>
<tr>
<td>37</td><td>13,000</td><td>2130</td><td>596</td>
</tr>
<tr>
<td>54</td><td>13,000</td><td>2030</td><td>626</td>
</tr>
<tr>
<td>82</td><td>12,500</td><td>1800</td><td>706</td>
</tr>
<tr>
<td>110</td><td>12,000</td><td>1770</td><td>718</td>
</tr>
<tr>
<td>145</td><td>12,000</td><td>1600</td><td>794</td>
</tr>
<tr>
<td>195</td><td>11,000</td><td>1500</td><td>847</td>
</tr>
<tr>
<td>525</td><td>10,500</td><td>1220</td><td>1041</td>
</tr>

<hr>
</tabular>
</table>




<para>
Table <ref>cir-mils2.tbl below</ref> shows the results of calculations for the various cores in the table
 <ref>cir-mils.tbl above</ref>.
</para>


<itemize>
<item>VA volt-amps and Flux Denisty B - copied from Table <ref>cir-mils.tbl above</ref>)</item>
<item>Core area A' sq-in - result from equation (1)</item>
<item>Core area A sq-in - result from equation (1b)</item>
<item>Current Density Amp/sq-in -  Amp/sq-in from <cite>RDR</cite></item>
<item>Converted current density Amp/sq-in to cir-mil/Amp - cir-mil/Amp = (1.27e6)/(Amp/sq-in)</item>
<item>Turns Pri. Np - Calculated from equation (3)</item>
<item>wire area cir-mil - Calculated: (Current Density cir-mil/Amp)*(Ip), Ip from equation (4) </item>
<item>AWG size of primary wire corresponding to <hyperlink>AWGcm[Volume V - Reference, Ch 1 Useful Equations, Wire sizing for inductors][../Ref/REF_1.html]</hyperlink></item>
</itemize>





<comment>Link to circular-mils to AWG  <hyperlink>AWGcm[Table][../Ref/REF_1.html]</hyperlink> Volume V - Reference, Ch 1 Useful Equations, Wire sizing for inductors</comment>


<table>cir-mils2.tbl<caption>Transformer core and wire sizing for example cores</caption>
<tabular>{|l|l|l|l|l|l|l|l|l|}
<hr>

<tr>
<td>VA</td><td>Flux</td><td>Core</td><td>Core</td><td>Current</td><td>Current</td><td>Turns</td><td>wire</td><td>A</td>
</tr>
<tr>
<td></td><td>Density</td><td>Area</td><td>Area</td><td>Density</td><td>Density</td><td>pri.</td><td>area</td><td>W</td>
</tr>
<tr>
<td>Ep*Ip</td><td>B</td><td>A' sq-in</td><td> A sq-cm</td><td>Amp/sq-in</td><td>cir-mil/Amp</td><td>Np</td><td>cir-mil</td><td>G</td>
</tr>
<tr>
<td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
</tr>
<hr>
<tr>
<td>24</td><td>13,500</td><td>0.878</td><td>5.665</td><td>2330</td><td>545</td><td>589</td><td>109</td><td>29</td>
</tr>
<tr>
<td>37</td><td>13,000</td><td>1.09</td><td>7.032</td><td>2130</td><td>596</td><td>493</td><td>184</td><td>27</td>
</tr>
<tr>
<td>54</td><td>13,000</td><td>1.317</td><td>8.497</td><td>2030</td><td>626</td><td>408</td><td>282</td><td>25</td>
</tr>
<tr>
<td>82</td><td>12,500</td><td>1.623</td><td>10.471</td><td>1800</td><td>706</td><td>344</td><td>482</td><td>23</td>
</tr>
<tr>
<td>110</td><td>12,000</td><td>1.88</td><td>12.129</td><td>1770</td><td>718</td><td>309</td><td>658</td><td>21</td>
</tr>
<tr>
<td>145</td><td>12,000</td><td>2.158</td><td>13.923</td><td>1600</td><td>794</td><td>270</td><td>959</td><td>20</td>
</tr>
<tr>
<td>195</td><td>11,000</td><td>2.503</td><td>16.148</td><td>1500</td><td>847</td><td>254</td><td>1376</td><td>18</td>
</tr>
<tr>
<td>525</td><td>10,500</td><td>4.106</td><td>26.49</td><td>1220</td><td>1041</td><td>162</td><td>4554</td><td>13</td>
</tr>

<hr>
</tabular>
</table>

</subsection>



<subsection>
<subsectiontitle>Energy losses</subsectiontitle>

<para>
When transformers transfer power, they do so with a minimum of loss.  As it was stated earlier, modern power transformer designs typically exceed 95% efficiency.  It is good to know where some of this lost power goes, however, and what causes it to be lost. 
</para>

<para>
There is, of course, power lost due to resistance of the wire windings.  Unless superconducting wires are used, there will always be power dissipated in the form of heat through the resistance of current-carrying conductors.  Because transformers require such long lengths of wire, this loss can be a significant factor.  Increasing the gauge of the winding wire is one way to minimize this loss, but only with substantial increases in cost, size, and weight.
</para>

<index>Eddy current loss</index>

<para>
Resistive losses aside, the bulk of transformer power loss is due to magnetic effects in the core.  Perhaps the most significant of these ``core losses'' is <italic>eddy-current loss</italic>, which is resistive power dissipation due to the passage of induced currents through the iron of the core.  Because iron is a conductor of electricity as well as being an excellent ``conductor'' of magnetic flux, there will be currents induced in the iron just as there are currents induced in the secondary windings from the alternating magnetic field.  These induced currents -- as described by the perpendicularity clause of Faraday's Law  -- tend to circulate through the cross-section of the core perpendicularly to the primary winding turns.  Their circular motion gives them their unusual name: like eddies in a stream of water that circulate rather than move in straight lines.
</para>

<para>
Iron is a fair conductor of electricity, but not as good as the copper or aluminum from which wire windings are typically made.  Consequently, these ``eddy currents'' must overcome significant electrical resistance as they circulate through the core.  In overcoming the resistance offered by the iron, they dissipate power in the form of heat.  Hence, we have a source of inefficiency in the transformer that is difficult to eliminate. 
</para>

<para>
This phenomenon is so pronounced that it is often exploited as a means of heating ferrous (iron-containing) materials.  The photograph of  (Figure<ref>52016.jpg below</ref>) shows an ``induction heating'' unit raising the temperature of a large pipe section.  Loops of wire covered by high-temperature insulation encircle the pipe's circumference, inducing eddy currents within the pipe wall by electromagnetic induction.  In order to maximize the eddy current effect, high-frequency alternating current is used rather than power line frequency (60 Hz).  The box units at the right of the picture produce the high-frequency AC and control the amount of current in the wires to stabilize the pipe temperature at a pre-determined ``set-point.''
</para>

<image>52016.jpg<caption>Induction heating: Primary insulated winding induces current into lossy iron pipe (secondary).</caption></image> 

<index>Laminated iron core</index>
<index>Transformer core, laminated</index>

<para>
The main strategy in mitigating these wasteful eddy currents in transformer cores is to form the iron core in sheets, each sheet covered with an insulating varnish so that the core is divided up into thin slices.  The result is very little width in the core for eddy currents to circulate in: (Figure<ref>02163.png below</ref>)
</para>

<image>02163.png<caption>Dividing the iron core into thin insulated laminations minimizes eddy current loss.</caption></image> 

<index>Transformer core, powdered iron</index>

<index>400 Hz AC power, aircraft</index>

<para>
<italic>Laminated</italic> cores like the one shown here are standard in almost all low-frequency transformers.  Recall from the photograph of the transformer cut in half that the iron core was composed of many thin sheets rather than one solid piece.  Eddy current losses increase with frequency, so transformers designed to run on higher-frequency power (such as 400 Hz, used in many military and aircraft applications) must use thinner laminations to keep the losses down to a respectable minimum.  This has the undesirable effect of increasing the manufacturing cost of the transformer.
</para>

<index>Powdered iron core</index>

<para>
Another, similar technique for minimizing eddy current losses which works better for high-frequency applications is to make the core out of iron powder instead of thin iron sheets.  Like the lamination sheets, these granules of iron are individually coated in an electrically insulating material, which makes the core nonconductive except for within the width of each granule.  Powdered iron cores are often found in transformers handling radio-frequency currents.
</para>

<index>Hysteresis</index>

<para>
Another ``core loss'' is that of magnetic <italic>hysteresis</italic>.  All ferromagnetic materials tend to retain some degree of magnetization after exposure to an external magnetic field.  This tendency to stay magnetized is called ``hysteresis,'' and it takes a certain investment in energy to overcome this opposition to change every time the magnetic field produced by the primary winding changes polarity (twice per AC cycle).  This type of loss can be mitigated through good core material selection (choosing a core alloy with low hysteresis, as evidenced by a ``thin'' B/H hysteresis curve), and designing the core for minimum flux density (large cross-sectional area).
</para>

<para>
Transformer energy losses tend to worsen with increasing frequency.  The skin effect within winding conductors reduces the available cross-sectional area for electron flow, thereby increasing effective resistance as the frequency goes up and creating more power lost through resistive dissipation.  Magnetic core losses are also exaggerated with higher frequencies, eddy currents and hysteresis effects becoming more severe.  For this reason, transformers of significant size are designed to operate efficiently in a limited range of frequencies.  In most power distribution systems where the line frequency is very stable, one would think excessive frequency would never pose a problem.  Unfortunately it does, in the form of harmonics created by nonlinear loads.
</para>

<para>
As we've seen in earlier chapters, nonsinusoidal waveforms are equivalent to additive series of multiple sinusoidal waveforms at different amplitudes and frequencies.  In power systems, these other frequencies are whole-number multiples of the fundamental (line) frequency, meaning that they will always be higher, not lower, than the design frequency of the transformer.  In significant measure, they can cause severe transformer overheating.  Power transformers can be engineered to handle certain levels of power system harmonics, and this capability is sometimes denoted with a ``K factor'' rating.  
</para>

</subsection>



<subsection>
<subsectiontitle>Stray capacitance and inductance</subsectiontitle>

<index>Resonance, transformer and inductor</index>

<para>
Aside from power ratings and power losses, transformers often harbor other undesirable limitations which circuit designers must be made aware of.  Like their simpler counterparts -- inductors -- transformers exhibit capacitance due to the insulation dielectric between conductors: from winding to winding, turn to turn (in a single winding), and winding to core.  Usually this capacitance is of no concern in a power application, but small signal applications (especially those of high frequency) may not tolerate this quirk well.  Also, the effect of having capacitance along with the windings' designed inductance gives transformers the ability to <italic>resonate</italic> at a particular frequency, definitely a design concern in signal applications where the applied frequency may reach this point (usually the resonant frequency of a power transformer is well beyond the frequency of the AC power it was designed to operate on).
</para>

<para>
Flux containment (making sure a transformer's magnetic flux doesn't escape so as to interfere with another device, and making sure other devices' magnetic flux is shielded from the transformer core) is another concern shared both by inductors and transformers.  
</para>

<index>Inductance, leakage</index>
<index>Leakage inductance</index>

<para>
Closely related to the issue of flux containment is leakage inductance.  We've already seen the detrimental effects of leakage inductance on voltage regulation with SPICE simulations early in this chapter.  Because leakage inductance is equivalent to an inductance connected in series with the transformer's winding, it manifests itself as a series impedance with the load.  Thus, the more current drawn by the load, the less voltage available at the secondary winding terminals.  Usually, good voltage regulation is desired in transformer design, but there are exceptional applications.  As was stated before, discharge lighting circuits require a step-up transformer with ``loose'' (poor) voltage regulation to ensure reduced voltage after the establishment of an arc through the lamp.  One way to meet this design criterion is to engineer the transformer with flux leakage paths for magnetic flux to bypass the secondary winding(s).  The resulting leakage flux will produce leakage inductance, which will in turn produce the poor regulation needed for discharge lighting.
</para>

</subsection>



<subsection>
<subsectiontitle>Core saturation</subsectiontitle>

<para>
Transformers are also constrained in their performance by the magnetic flux limitations of the core.  For ferromagnetic core transformers, we must be mindful of the saturation limits of the core.  Remember that ferromagnetic materials cannot support infinite magnetic flux densities: they tend to ``saturate'' at a certain level (dictated by the material and core dimensions), meaning that further increases in magnetic field force (mmf) do not result in proportional increases in magnetic field flux (<PHI>).
</para>

<para>
When a transformer's primary winding is overloaded from excessive applied voltage, the core flux may reach saturation levels during peak moments of the AC sinewave cycle.  If this happens, the voltage induced in the secondary winding will no longer match the wave-shape as the voltage powering the primary coil.  In other words, the overloaded transformer will <italic>distort</italic> the waveshape from primary to secondary windings, creating harmonics in the secondary winding's output.  As we discussed before, harmonic content in AC power systems typically causes problems.
</para>

<index>Transformer, peaking</index>
<index>Peaking transformer</index>

<para>
Special transformers known as <italic>peaking transformers</italic> exploit this principle to produce brief voltage pulses near the peaks of the source voltage waveform.  The core is designed to saturate quickly and sharply, at voltage levels well below peak.  This results in a severely cropped sine-wave flux waveform, and secondary voltage pulses only when the flux is changing (below saturation levels): (Figure<ref>02314.png below</ref>)
</para>

<image>02314.png<caption>Voltage and flux waveforms for a peaking transformer.</caption></image> 

<para>
Another cause of abnormal transformer core saturation is operation at frequencies lower than normal.  For example, if a power transformer designed to operate at 60 Hz is forced to operate at 50 Hz instead, the flux must reach greater peak levels than before in order to produce the same opposing voltage needed to balance against the source voltage.  This is true even if the source voltage is the same as before. (Figure<ref>02340.png below</ref>)
</para>

<image>02340.png<caption>Magnetic flux is higher in a transformer core driven by 50 Hz as compared to 60 Hz for the same voltage. </caption></image> 

<para>
Since instantaneous winding voltage is proportional to the instantaneous magnetic flux's <italic>rate of change</italic> in a transformer, a voltage waveform reaching the same peak value, but taking a longer amount of time to complete each half-cycle, demands that the flux maintain the same rate of change as before, but for longer periods of time.  Thus, if the flux has to climb at the same rate as before, but for longer periods of time, it will climb to a greater peak value. (Figure<ref>02341.png below</ref>)
</para>

<index>Derivative, calculus</index>
<index>Integral, calculus</index>

<para>
Mathematically, this is another example of calculus in action.  Because the voltage is proportional to the flux's rate-of-change, we say that the voltage waveform is the <italic>derivative</italic> of the flux waveform, ``derivative'' being that calculus operation defining one mathematical function (waveform) in terms of the rate-of-change of another.  If we take the opposite perspective, though, and relate the original waveform to its derivative, we may call the original waveform the <italic>integral</italic> of the derivative waveform.  In this case, the voltage waveform is the derivative of the flux waveform, and the flux waveform is the integral of the voltage waveform.
</para>

<para>
The integral of any mathematical function is proportional to the area accumulated underneath the curve of that function.  Since each half-cycle of the 50 Hz waveform accumulates more area between it and the zero line of the graph than the 60 Hz waveform will -- and we know that the magnetic flux is the integral of the voltage -- the flux will attain higher values in Figure<ref>02341.png below</ref>.
</para>

<image>02341.png<caption>Flux changing at the same rate rises to a higher level at 50 Hz than at 60 Hz.</caption></image> 

<para>
Yet another cause of transformer saturation is the presence of DC current in the primary winding.  Any amount of DC voltage dropped across the primary winding of a transformer will cause additional magnetic flux in the core.  This additional flux ``bias'' or ``offset'' will push the alternating flux waveform closer to saturation in one half-cycle than the other. (Figure<ref>02342.png below</ref>)
</para>

<image>02342.png<caption>DC in primary, shifts the waveform peaks toward the upper saturation limit.</caption></image> 

<para>
For most transformers, core saturation is a very undesirable effect, and it is avoided through good design: engineering the windings and core so that magnetic flux densities remain well below the saturation levels.  This ensures that the relationship between mmf and <PHI> is more linear throughout the flux cycle, which is good because it makes for less distortion in the magnetization current waveform.  Also, engineering the core for low flux densities provides a safe margin between the normal flux peaks and the core saturation limits to accommodate occasional, abnormal conditions such as frequency variation and DC offset.
</para>

</subsection>



<subsection>
<subsectiontitle>Inrush current</subsectiontitle>

<index>Inrush current, transformer</index>
<index>Transformer inrush current</index>

<para>
When a transformer is initially connected to a source of AC voltage, there may be a substantial surge of current through the primary winding called <italic>inrush current</italic>.   (Figure<ref>02346.png below</ref>) This is analogous to the inrush current exhibited by an electric motor that is started up by sudden connection to a power source, although transformer inrush is caused by a different phenomenon.
</para>

<para>
We know that the rate of change of instantaneous flux in a transformer core is proportional to the instantaneous voltage drop across the primary winding.  Or, as stated before, the voltage waveform is the derivative of the flux waveform, and the flux waveform is the integral of the voltage waveform.  In a continuously-operating transformer, these two waveforms are phase-shifted by 90<superscript>o</superscript>. (Figure<ref>02307b.png below</ref>)  Since flux (<PHI>) is proportional to the magnetomotive force (mmf) in the core, and the mmf is proportional to winding current, the current waveform will be in-phase with the flux waveform, and both will be lagging the voltage waveform by 90<superscript>o</superscript>:
</para>

<comment>note the re-used image below. It requires label tags. Above it is called out by the label between the tags, not the automatic image number.</comment>

<image>02307.png<caption>Continuous steady-state operation: Magnetic flux, like current,  lags applied voltage by 90<superscript>o</superscript>.</caption><label>02307b.png</label></image> 

<para>
Let us suppose that the primary winding of a transformer is suddenly connected to an AC voltage source at the exact moment in time when the instantaneous voltage is at its positive peak value.  In order for the transformer to create an opposing voltage drop to balance against this applied source voltage, a magnetic flux of rapidly increasing value must be generated.  The result is that winding current increases rapidly, but actually no more rapidly than under normal conditions: (Figure<ref>02343.png below</ref>)
</para>

<image>02343.png<caption>Connecting transformer to line at AC volt peak: Flux increases rapidly from zero, same as steady-state operation.</caption></image> 

<para>
Both core flux and coil current start from zero and build up to the same peak values experienced during continuous operation.  Thus, there is no ``surge'' or ``inrush'' or current in this scenario. (Figure<ref>02343.png above</ref>)

</para>

<para>
Alternatively, let us consider what happens if the transformer's connection to the AC voltage source occurs at the exact moment in time when the instantaneous voltage is at zero.  During continuous operation (when the transformer has been powered for quite some time), this is the point in time where both flux and winding current are at their negative peaks, experiencing zero rate-of-change (d<PHI>/dt = 0 and di/dt = 0).  As the voltage builds to its positive peak, the flux and current waveforms build to their maximum positive rates-of-change, and on upward to their positive peaks as the voltage descends to a level of zero:
</para>

<image>02344.png<caption>Starting at e=0 V is not the same as running continuously in  Figure<ref>02307.png above.</ref> These expected waveforms are incorrect-- <PHI> and i should start at zero.</caption></image> 

<para>
A significant difference exists, however, between continuous-mode operation and the sudden starting condition assumed in this scenario: during continuous operation, the flux and current levels were at their negative peaks when voltage was at its zero point; in a transformer that has been sitting idle, however, both magnetic flux and winding current should start at <italic>zero</italic>.  When the magnetic flux increases in response to a rising voltage, it will increase from zero upward, not from a previously negative (magnetized) condition as we would normally have in a transformer that's been powered for awhile.  Thus, in a transformer that's just ``starting,'' the flux will reach approximately twice its normal peak magnitude as it ``integrates'' the area under the voltage waveform's first half-cycle: (Figure<ref>02345.png below</ref>)
</para>

<image>02345.png<caption>Starting at e=0 V, <PHI> starts at initial condition <PHI>=0, increasing to twice the normal value, assuming it doesn't saturate the core.</caption></image> 

<para>
In an ideal transformer, the magnetizing current would rise to approximately twice its normal peak value as well, generating the necessary mmf to create this higher-than-normal flux.  However, most transformers aren't designed with enough of a margin between normal flux peaks and the saturation limits to avoid saturating in a condition like this, and so the core will almost certainly saturate during this first half-cycle of voltage.  During saturation, disproportionate amounts of mmf are needed to generate magnetic flux.  This means that winding current, which creates the mmf to cause flux in the core, will disproportionately rise to a value <italic>easily exceeding</italic> twice its normal peak: (Figure<ref>02346.png below</ref>)
</para>

<image>02346.png<caption>Starting at e=0 V, Current also increases to twice the normal value for an unsaturated core, or considerably higher in the (designed for) case of saturation.</caption></image> 

<para>
This is the mechanism causing inrush current in a transformer's primary winding when connected to an AC voltage source.  As you can see, the magnitude of the inrush current strongly depends on the exact time that electrical connection to the source is made.  If the transformer happens to have some residual magnetism in its core at the moment of connection to the source, the inrush could be even more severe.  Because of this, transformer overcurrent protection devices are usually of the ``slow-acting'' variety, so as to tolerate current surges such as this without opening the circuit.
</para>

</subsection>



<subsection>
<subsectiontitle>Heat and Noise</subsectiontitle>

<index>Magnetostriction</index>
<index>Noise, transformer</index>

<para>
In addition to unwanted electrical effects, transformers may also exhibit undesirable physical effects, the most notable being the production of heat and noise.  Noise is primarily a nuisance effect, but heat is a potentially serious problem because winding insulation will be damaged if allowed to overheat.  Heating may be minimized by good design, ensuring that the core does not approach saturation levels, that eddy currents are minimized, and that the windings are not overloaded or operated too close to maximum ampacity.  
</para>

<para>
Large power transformers have their core and windings submerged in an oil bath to transfer heat and muffle noise, and also to displace moisture which would otherwise compromise the integrity of the winding insulation.  Heat-dissipating ``radiator'' tubes on the outside of the transformer case provide a convective oil flow path to transfer heat from the transformer's core to ambient air: (Figure<ref>02411.png below</ref>)
</para>

<image>02411.png<caption>Large power transformers are submerged in heat dissipating insulating oil.</caption></image> 

<para>
Oil-less, or ``dry,'' transformers are often rated in terms of maximum operating temperature ``rise'' (temperature increase beyond ambient) according to a letter-class system: A, B, F, or H.  These letter codes are arranged in order of lowest heat tolerance to highest: 
</para>

<index>Class, transformer heat rating</index>

<itemize>
<item><bold>Class A:</bold> No more than 55<superscript>o</superscript> Celsius winding temperature rise, at 40<superscript>o</superscript> Celsius (maximum) ambient air temperature.</item>
<item><bold>Class B:</bold> No more than 80<superscript>o</superscript> Celsius winding temperature rise, at 40<superscript>o</superscript> Celsius (maximum)ambient air temperature.</item>
<item><bold>Class F:</bold> No more than 115<superscript>o</superscript> Celsius winding temperature rise, at 40<superscript>o</superscript> Celsius (maximum)ambient air temperature.</item>
<item><bold>Class H:</bold> No more than 150<superscript>o</superscript> Celsius winding temperature rise, at 40<superscript>o</superscript> Celsius (maximum)ambient air temperature.</item>
</itemize>

<para>
Audible noise is an effect primarily originating from the phenomenon of <italic>magnetostriction</italic>: the slight change of length exhibited by a ferromagnetic object when magnetized.  The familiar ``hum'' heard around large power transformers is the sound of the iron core expanding and contracting at 120 Hz (twice the system frequency, which is 60 Hz in the United States) -- one cycle of core contraction and expansion for every peak of the magnetic flux waveform -- plus noise created by mechanical forces between primary and secondary windings.  Again, maintaining low magnetic flux levels in the core is the key to minimizing this effect, which explains why ferroresonant transformers -- which must operate in saturation for a large portion of the current waveform -- operate both hot and noisy.
</para>

<para>
Another noise-producing phenomenon in power transformers is the physical reaction force between primary and secondary windings when heavily loaded.  If the secondary winding is open-circuited, there will be no current through it, and consequently no magneto-motive force (mmf) produced by it.  However, when the secondary is ``loaded'' (current supplied to a load), the winding generates an mmf, which becomes counteracted by a ``reflected'' mmf in the primary winding to prevent core flux levels from changing.  These opposing mmf's generated between primary and secondary windings as a result of secondary (load) current produce a repulsive, physical force between the windings which will tend to make them vibrate.  Transformer designers have to consider these physical forces in the construction of the winding coils, to ensure there is adequate mechanical support to handle the stresses.  Under heavy load (high current) conditions, though, these stresses may be great enough to cause audible noise to emanate from the transformer.
</para>

</subsection>






<itemize>
<item><bold>REVIEW:</bold></item>
<item>Power transformers are limited in the amount of power they can transfer from primary to secondary winding(s).  Large units are typically rated in VA (volt-amps) or kVA (kilo volt-amps).</item>
<item>Resistance in transformer windings contributes to inefficiency, as current will dissipate heat, wasting energy.</item>
<item>A winding design goal is to determine the minimum numper of primary turns and wire size that will not saturate and overheat the core.</item>
<item>Magnetic effects in a transformer's iron core also contribute to inefficiency.  Among the effects are <italic>eddy currents</italic> (circulating induction currents in the iron core) and <italic>hysteresis</italic> (power lost due to overcoming the tendency of iron to magnetize in a particular direction).</item>
<item>Increased frequency results in increased power losses within a power transformer.  The presence of harmonics in a power system is a source of frequencies significantly higher than normal, which may cause overheating in large transformers.</item>
<item>Both transformers and inductors harbor certain unavoidable amounts of capacitance due to wire insulation (dielectric) separating winding turns from the iron core and from each other.  This capacitance can be significant enough to give the transformer a natural <italic>resonant frequency</italic>, which can be problematic in signal applications.</item>
<item><italic>Leakage inductance</italic> is caused by magnetic flux not being 100% coupled between windings in a transformer.  Any flux not involved with <italic>transferring</italic> energy from one winding to another will store and release energy, which is how (self-) inductance works.  Leakage inductance tends to worsen a transformer's voltage regulation (secondary voltage ``sags'' more for a given amount of load current).</item>
<item>Magnetic <italic>saturation</italic> of a transformer core may be caused by excessive primary voltage, operation at too low of a frequency, and/or by the presence of a DC current in any of the windings.  Saturation may be minimized or avoided by conservative design, which provides an adequate margin of safety between peak magnetic flux density values and the saturation limits of the core.</item>
<item>Transformers often experience significant <italic>inrush currents</italic> when initially connected to an AC voltage source.  Inrush current is most severe when connection to the AC source is made at the moment instantaneous source voltage is zero.</item>
<item>Noise is a common phenomenon exhibited by transformers -- especially power transformers -- and is primarily caused by <italic>magnetostriction</italic> of the core.  Physical forces causing winding vibration may also generate noise under conditions of heavy (high current) secondary winding load.</item>
</itemize>

</section>




<section>
<sectiontitle>Contributors</sectiontitle>

<para>
Contributors to this chapter are listed in chronological order of their contributions, from most recent to first.  See Appendix 2 (Contributor List) for dates and contact information.
</para>

<para>
<bold>Bart Anderson</bold> (January 2004): Corrected conceptual errors regarding Tesla coil operation and safety.
</para>

<para>
<bold>Jason Starck</bold> (June 2000): HTML document formatting, which led to a much better-looking second edition.
</para>

</section>


<thebibliography>
<bibitem>[MYA]Mitsuyoshi Yamamoto, Mitsugi Yamaguchi, ``Electric Power In Japan, Rapid Electrification a Century Ago'',  EDN, (4/11/2002). <url>http://www.ieee.org/organizations/pes/public/2005/mar/peshistory.html[http://www.ieee.org/organizations/pes/public/2005/mar/peshistory.html]</url></bibitem>

<bibitem>[RDR]``Reference Data for Radio Engineers, pp 274  ITT, 1956. </bibitem>
</thebibliography>

</chapter>

<pagebreak>

