// *********************************************************************************
// *********************************************************************************
// ***********                                                                                          **********
// ***********    DATEI.H  -  ROUTINEN ZUR VERWALTUNG DER FILES    **********
// ***********                                                                                          **********
// *********************************************************************************
// *********************************************************************************
#include"datei.H"

int filelength(int handle)
{
    int aktpos=lseek(handle,0,SEEK_CUR);
    int laenge=lseek(handle,0,SEEK_END);
    lseek(handle,aktpos,SEEK_SET);
    return(laenge);
}

int readable(const char *name)
{
  int handle;
  cout << "readable: "<<name<<endl;
  handle=open(name,O_RDONLY);
  if (handle==-1)
    return 0;
  close(handle);
  return 1;
}

int open_check(const char *name,int accessflags)
{
#ifdef DEBUG_datei_H
  cout << "open_check: "<<name<<endl;
#endif
  int handle;
  if ((handle = open(name, accessflags)) == -1)
    {
      string msg("open_check: Fehler beim ffnen der Datei: \"");
      msg+=name;
      msg+='"';
      fatalfehler(msg.c_str());
    }
  return(handle);
}


int creat_check(const char *name,mode_t mode)
{
#ifdef DEBUG_datei_H
  cout << "creat_check: "<<name<<endl;
#endif

    int handle;
    if ((handle = creat(name,mode))==-1) 
	{
	    string msg("creat_check: Fehler beim erstellen der Datei: ");
	    msg+=name;
	    fatalfehler(msg.c_str());
	}
    return(handle);
}

void read_check(int handle,char *buf,int len)
{
#ifdef DEBUG_datei_H
  cout <<"read_check\n";
#endif
	if (read(handle,buf,len)!=len)
		fatalfehler("read_check: Fehler beim Lesen aus der Datei!");
}


void write_check(int handle,char *buf,int len)
{
#ifdef DEBUG_datei_H
  cout <<"write_check\n";
#endif
	if (write(handle,buf,len)!=len)
		fatalfehler("write_check: Fehler beim Schreiben in die Datei");
}


iotype *make_file_to_io_check(const char *name)
{
  int handle=open_check(name,O_RDONLY);
  string fehler("Datei: ");
  fehler+=name;
  fehler+=" :\n";
  int32 buffersize=filelength(handle);
  char *buffer=new char[buffersize];
  read_check(handle,buffer,buffersize);
  close(handle);
  iotype *neues=new iotype(buffer,buffersize);
  neues->setstandardfehler(&fehler);
  neues->set_read_mode();
  return(neues);
}

void make_io_to_file_check(iotype *ioptr,const char *name,mode_t mode)
{
  int handle=creat_check(name,mode);
  write_check(handle,ioptr->get_buffer(),ioptr->get_buffersize());
  close(handle);
}

int filecmp(char *name1,char *name2)
{
  struct stat st1,st2;
  stat(name1,&st1);
  stat(name2,&st2);
  if ((st1.st_size!=st2.st_size)||(st1.st_mtime!=st2.st_mtime))
    return(1);
  return(0);
}






