// Welche Includes debuggen ? *************************************************
#define DEBUG
#define DEBUG_sprite_H
#define DEBUG_listen_H
#define DEBUG_communic_H
// Welche Includes debuggen ? *************************************************

#include <unistd.h>
#include <sys/stat.h>


#include "terminal.H"

#define vgax 640
#define vgay 480


#include "scrX11.H"

void hilfe()
{
    printf("\nWrong Parameters ! ************************************************************\n\nUsage:\ndieb inputfile outputfile [transparent_color [nontransflag]]\n\n");
    
    printf("inputfile must be the filename of a picture in pcx-format, ppm-format or spr-format\n");
    printf("outputfile is the filename of the destination sprite.\n\n"); 
    printf("dieb is a grabber which detects the sprite automatically. He searches the most\nupper,lower,left and right points which differ from the transparent color.\n");
    printf("dieb only saves a transparent sprite if the transcolor is in the sprite !\nDefault: transcolor=0\n\n");
   
    printf("If nontransflag is different from 0 the transparent_color will only be used\nto detect the sprite. It's a kind of background color then but it won't\nbe transparent anymore. You shouldn't set the nontransflag.\n\n");
    printf("Keyboard Commands:\nq,a,o,p Move the source picture\nQ,A,O,P Move the 'middle' of the destination sprite\ny,x,Y,X Change the size of the destination sprite\nSPACE   Save the sprite.\n");
    printf("\nAttention: Everytime you press SPACE a sprite is saved.\n"); 
    printf("           If the destination file allready exists it will be destroyed !\n");
    printf("Exmaple:   'dieb test.pcx 1.spr'\n");
}


int main(int argc,char **argv)
{
    // Parameterliste korrekt ???
    if ((argc<3)||(argc>5)) 
	{
	    hilfe();
	    exit(1);
	}
    char transcolor=0;
    if (argc>=4)
	transcolor=atoi(argv[3]);
    char nontransflag=0;
    if (argc>=5)
	nontransflag=atoi(argv[4]);
    
    // Source - Sprite anhand PCX-File initen *********************
    init_allsprites_kette("palette.ppm");
    spritetype *source;
    string filename(argv[1]);
    iotype *ioptr=make_file_to_io_check(argv[1]);
    if (filename.length()<4)
      {
	cout << "Strange filename ??\n";
	hilfe();
	exit(1);
      }
    string suffix(filename.c_str()+filename.length()-4);
    if (!strcmp("pcx",suffix.c_str()))
      source=ladepcx_to_sprite_linear_nontransparenttype(ioptr,0,0);
    else
      source=spritetype::create(ioptr,CFG_TEXT_MODE);
    delete ioptr;
    int aktx=0;
    int akty=0;
    int minx=source->sx;
    int maxx=0;
    int miny=source->sy;
    int maxy=0;
    // todo eigentlich net so toll !!
    source->mx=0;
    source->my=0;
    for (akty=0;akty<source->sy;akty++)
	{
	    for (aktx=0;aktx<source->sx;aktx++)
		{
		  char farbe;
		  if (source->getpixel_clip(aktx,akty,&farbe))
		    fatalfehler("dieb.C: This error isn't possible?");
		  if (farbe!=transcolor)
		    {
		      if (aktx<minx)
			minx=aktx;
		      if (aktx>maxx)
			maxx=aktx;
		      if (akty<miny)
			miny=akty;
		      if (akty>maxy)
			maxy=akty;
		    }
		}
	}
    int midx=(minx+maxx)/2;
    int midy=(miny+maxy)/2;
    aktx=-midx;
    akty=-midy;
    
    sprite_linear_nontransparent_screentype vscreen(0,0,vgax,vgay,(vgax-1)/2,(vgay-1)/2,"palette.ppm",NULL);
    
    int aktsx=maxx-minx+1;
    int aktsy=maxy-miny+1;
    int aktmx=midx-minx;
    int aktmy=midy-miny;
    char rahmenfarbe=31;
    char mdotfarbe=32;
    sprite_linear_transparenttype dest(aktsx,aktsy,aktmx,aktmy,transcolor);
    if (dest.spritecheck())
	fatalfehler("POS 0\n");

    // Zielstream 
    iotype iosave;
    
    int taste;
    do{
	vscreen.clearsprite(transcolor);
	
	source->copysprite_clip(aktx,akty,&vscreen);
	
	//	if (vscreen.spritecheck())
	//	    fatalfehler("POS 1\n");
	
	if (aktsx<1)
	    aktsx=1;
//	    else if (aktsx>vgax)
//		aktsx=vgax-1;
	if (aktsy<1)
	    aktsy=1;
//	    else if (aktsy>=vgay)
//		aktsy=vgay-1;
	dest.resize(aktsx,aktsy,transcolor);
	dest.mx=aktmx;
	dest.my=aktmy;
	dest.malerechteck(-aktmx,-aktmy,aktsx,aktsy,rahmenfarbe);

	if (dest.spritecheck())
	    fatalfehler("POS 2\n");
	
	dest.copysprite_clip(0,0,&vscreen);
	cout << "Vscreen mx:" <<vscreen.mx << " my:" << vscreen.my<<endl;
	vscreen.putpixel(0,0,mdotfarbe);

	vscreen.map();
	
	if (dest.spritecheck())
	    fatalfehler("POS 3\n");
	//	if (vscreen.spritecheck())
	//	    fatalfehler("POS 4\n");
	
	taste=getchar();
	if (taste==113)
	    akty--;
	else if (taste==97)
	    akty++;
	else if (taste==111)
	    aktx--;
	else if (taste==112)
	    aktx++;
	else if (taste==81)
	    aktmy--;
	else if (taste==65)
	    aktmy++;
	else if (taste==79)
	    aktmx--;
	else if (taste==80)
	    aktmx++;
	else if (taste==121)
	    aktsy--;
	else if (taste==89)
	    aktsy++;
	else if (taste==120)
	    aktsx--;
	else if (taste==88)
	    aktsx++;
	else if (taste==32)
	    {
	      dest.clearsprite(transcolor);
	      source->copysprite_clip(aktx,akty,&dest);
	      if ((!nontransflag)&&(dest.farbeinsprite(transcolor)))
		{
		  // Transparent
		  dest.change(&iosave);
		  cout <<"sprite_lineartransparenttype: saved to buffer\n";
		  if (dest.spritecheck())
		    fatalfehler("POS 5\n");
		  //			if (vscreen.spritecheck())
		  //			    fatalfehler("POS 6\n");
		}    
	      else
		{
		  sprite_linear_nontransparenttype newdest(aktsx,aktsy,aktmx,aktmy);
		  source->copysprite_clip(aktx,akty,&newdest);
		  newdest.change(&iosave);
		  cout <<"sprite_linear_nontransparenttype: saved to buffer\n";
		  if (dest.spritecheck())
		    fatalfehler("POS 5\n");
		  //			if (vscreen.spritecheck())
		  //			    fatalfehler("POS 6\n");
		  if (newdest.spritecheck())
		    fatalfehler("POS 7\n");
		}
	    }
    }while(taste!=27);
    
    int handle=creat_check(argv[2],S_IWRITE|S_IRUSR|S_IRGRP|S_IROTH|S_IFREG);
    write_check(handle,iosave.get_buffer(),iosave.get_buffersize());
    close(handle);
    
    delete source;
    
    spritetype *spri=spritetype::create(argv[2]);
    aktx=0;
    akty=0;
    
    int changex=0;
    int changey=0;
    int con=RAND_MAX/3;
    do{
	changex+=(random()/con)-1;
	changey+=(random()/con)-1;
	changex-=3*aktx/vgax;
	changey-=3*akty/vgay;
	aktx+=changex;
	akty+=changey;
	vscreen.clearsprite(0);
	spri->copysprite_clip(aktx,akty,&vscreen);
	vscreen.map();
    }while(!kbhit());
    deinit_allsprites_kette();
    exit(0);
}



