#include "sprite01.H"

#include <string>

// *************************************** MAIN ****************************
// *************************************** MAIN ****************************
// *************************************** MAIN ****************************
// *************************************** MAIN ****************************
// *************************************** MAIN ****************************
// *************************************** MAIN ****************************

void hilfe()
{
  cout <<"ppmtospr: convert ppm files to sprfiles\n"
       << "ppmtospr [filename1] [-map filename2] [-output filename3]\n"
       << "filename1: the input ppmfile\n"
       << "filename2: the maping ppmfile\n"
       << "filename3: the ouput sprfile\n"
       << "if no filename1 is given the picture is read from standard input\n"
       << "if no filename2 is given output will be a nontransparent sprite\n"
       << "if no filename3 is given the outputfilename will only differ in the suffix\n"
       << "Example: ppmtospr 'test.ppm -map test_map.ppm -output test.spr'\n\n";
  exit(1);
}

int main(int argc,char **argv)
{
  iotype *ioptr=NULL;
  string file1;
  string file2;
  string file3;
  string aktparam;
  if (argc>6)
    hilfe();
  for (int a=1;a<argc;a++)
    {
      aktparam=argv[a];
      if (aktparam=="-map")
	{
	  a++;
	  if (a>=argc)
	    hilfe();
	  file2=argv[a];
	}
      else if (aktparam=="-output")
	{
	  a++;
	  if (a>=argc)
	    hilfe();
	  file3=argv[a];
	}
      else
	if (file1=="")
	  file1=aktparam;
	else
	  hilfe();
    }

  init_allsprites_kette("../palette.ppm");

  if (file1=="")
    {
      cout <<"Using standard input\n";
      cout <<"Sorry not yet implemented !!\n";
      exit(1);
    }
  else
    {
      cout <<"Using input file "<<file1<<endl;
      ioptr=make_file_to_io_check(file1.c_str());
    }
  spritetype *source=spritetype::create(ioptr,CFG_TEXT_MODE);
  cout << "input ppmfile middle: "<<source->mx<<","<<source->my<<endl;

  delete ioptr;
  if (strcmp(source->getheaderstring(),"sprite_ppmtype"))
    {    
      cout <<"inputfile is a "<<source->getheaderstring()<<endl;
      fatalfehler("inputfile must be a ppm file");
    }
  iotype iosave;
  if (file2=="")
    {
      cout <<"Nontransparent sprite will be generated\n";
      sprite_linear_nontransparenttype dest(source->sx,source->sy,source->mx,source->my);
      source->copysprite_clip(0,0,&dest);
      cout <<"Sprite middle is "<<dest.mx<<","<<dest.my<<endl;
      dest.change(&iosave);
    }
  else
    {
      cout <<"Using maping file "<<file2<<endl;
      ioptr=make_file_to_io_check(file2.c_str());
      spritetype *map=spritetype::create(ioptr,CFG_TEXT_MODE);
      delete ioptr;
      if (strcmp(map->getheaderstring(),"sprite_ppmtype"))
	{
	  cout <<"mapingfile is a "<<source->getheaderstring()<<endl;
	  fatalfehler("mapingfile must be a ppm file");
	}
      if ((source->sx!=map->sx)||(source->sy!=map->sy)||(source->mx!=map->mx)||(source->my!=map->my))
	fatalfehler("inputfile must have the same size as the maping file");
      uint8 black=allsprites_ketteptr->paletteptr->black();
      uint8 white=allsprites_ketteptr->paletteptr->white();
      if (!((sprite_ppmtype *)map)->farbeinsprite(black))
	{
	  cout <<"Nontransparent sprite will be generated\n";
	  cout <<"Sorry not yet implemented !!\n";
	  exit(1);
	}
      else
	{
	  cout <<"Transparent sprite will be generated\n";
	  // Search for unused color
	  int16 unused=-1;
	  for (int16 aktc=0;aktc<256;aktc++)
	    {
	      if (!((sprite_ppmtype *)source)->farbeinsprite((char)aktc))
		{	    
		  unused=aktc;
		  cout << "Found unused color => transparent color is "<<unused<<endl;
		  break;
		}
	    }
	  if (unused==-1)
	    fatalfehler("Can't generate transparent sprite because inputfile uses all colors !");
	  sprite_linear_transparenttype dest(source->sx,source->sy,source->mx,source->my,(char)unused);
	  source->copysprite_clip(0,0,&dest);
	  // mapfile benutzen um transparente Punkte zu malen
	  for (int32 akty=0;akty<dest.sy;akty++)
	    for (int32 aktx=0;aktx<dest.sx;aktx++)
	      {
		char farbe;
		if (map->getpixel_clip(aktx-dest.mx,akty-dest.my,&farbe))
		  fatalfehler("ppmtospr.C::main: This error isn't possible?");
		if (farbe==black)
		  dest.putpixel_clip(aktx-dest.mx,akty-dest.my,(char)unused);
	      }
	  // todo Mittelpunkt ???
	  dest.minimize();
	  cout <<"Sprite middle is "<<dest.mx<<","<<dest.my<<endl;
	  dest.change(&iosave);
	}	  
      delete map;
    }
  delete source;
  if (file3=="")
    {
      uint pos=file1.find('.');
      if (pos==string::npos)
	fatalfehler("main: illegal filename suffix needed ->see also help");
      string prefix(file1,0,pos);
      file3=prefix+".spr";
    }
  cout << "Using output file "<<file3<<endl;
  make_io_to_file_check(&iosave,file3.c_str(),S_IWRITE|S_IRUSR|S_IRGRP|S_IROTH|S_IFREG);

  deinit_allsprites_kette();
  exit(0);
}

