/*

  This is the Interface for sprite01.H which supports it for X11

  Written by Jens Thiele in June 1996
  Changed: Feb 1997
  EMAIL:   info39@dulzian.gris.uni-tuebingen.de

*/

#ifndef _scrX11_H
#define _scrX11_H

#include "sprite01.H"            // My spritetool
#include <X11/Xlib.h>            // This is the X-Protokol Interface (you need it!)
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h> // This is the X-Protokol Shared Memory Ext.
#include <sys/ipc.h>             // Also needed for SHM
#include <sys/shm.h>


// Achtung:
// Es werden nur Resize Events automatisch verarbeitet !!!
// D.h. es muss eine neue Routine verarbeite_input definiert werden
// die auch die Mausclicks verarbeitet ansonsten liefert der calc() dass
// ein Event nicht verarbeitet wurde bzw. unbekannt ist

class sprite_linear_nontransparent_screentype 
    : public sprite_linear_nontransparenttype
{
public:
  // Typeinfo -Achtung statisch wird nicht vererbt !!! =>benutze getheaderstring() muss aber public sein!
  static const char *headerstring;
  const char *getheaderstring(){return headerstring;}

  // _x , _y   Position des Fensters (wird normalerweise vom Windowmanager nicht benutzt !)
  // _sx , _sy Breite und Hhe des Fensters (muss ein vielfaches von 4 sein !)
  // _mx , _my Mittelpunkt des Fensters
  // _palette  Name des ppm-Bildes das die Palette enthaelt (Falls kein Name angegeben wird,
  //           wird keine Palette geladen 
  // _scrname  Name des Fensters (fr den Windowmanager => steht in der Titelleiste des Fensters)
  // _dpyname  Display Name (Name des X-Servers)
  sprite_linear_nontransparent_screentype(int32 _x,int32 _y,int32 _sx,int32 _sy,
					  int32 _mx,int32 _my,
					  const char *_palette=NULL,const char *_scrname=NULL,
					  const char *_dpyname=NULL);
  ~sprite_linear_nontransparent_screentype();

  // Bild anzeigen
  void map();
  // Teilbild anzeigen
  void map_box(int32 _x,int32 _y,int32 _sx,int32 _sy);
  // is now in sprite01.H  void map(const rechtecktype &r){map_box(-r.mx,-r.my,r.sx,r.sy);}

  // Palette anzeigen
  void showpal(palettetype *pal);

  // Never use it !! => fatalfehler
  int spritecheck();

  // Resize the Screen
  virtual void resize(int32 x,int32 y);

  // Should be synced if screen is mapped ?
  int sync;

  // Wandle X-Event in einen Stream um !!! s.h. menu.H
  istream *get_input();
  // Get Stream with output messages
  istream &get_output();
  // Verarbeite den Input Stream !! s.h. menu.H
  virtual int verarbeite_input(istream *ist);

  // get all events and use them 0<=> everytging fine !0<=> close me
  virtual int calc();
protected:
  // Standardmaessig wird das ganze Fenster neu gemalt
  virtual void verarbeite_expose_event();
  // buffer
  strstreambuf *buffer;
  // output stream 
  ostream *ausgabe;
  // input stream
  istream *eingabe;

private:
  // Holt den naechsten Event aus der Eventqueue
  XEvent *get_event();

  // Allociert einen Shared Memory Bereich
  void new_sprite_buffer(int32 _sx,int32 _sy);
  // Gibt den Shared Memory wieder frei
  void delete_sprite_buffer();

  // Check Events for Resize ! (XResizeRedirectEvent)
  //  int verarbeite_resize_event(XEvent *event);

  Display *dpy;                   // Display means screen ("hardware / connect to server")
  XShmSegmentInfo xshminfo;       // Shared Mem
  Window win;                     // Window ID
  XSizeHints *sizeptr;
  int scr;                        // Screen of Display ("Terminal")
  int depth;                      // ColorDepth
  long window_eventmask;          // Which Events I get
  //  Pixmap bild;                    // Alternate: XImage *
  XImage *bild;
  GC aktgc;                 
  palettetype *scrpal;            // Zeiger auf die Palette (mein Palettenobjekt)
  Colormap cmap;                  // Die dazugehoerige X-Palette
  int cmapaktive;                 // Wird die Palette angezeigt ?
  // Remap Table for 8 Bit mode   // (todo now private colormap !)
  // uint8 remap8[256];
  // Remap Table for 32 Bit mode  // todo 32Bit geht grad net !! wegen Pixmap statt XImage
  uint32 remap32[256];
  // spritebuffer for 32Bit mode (pointer to shm segment intern 8bit anyway =>char *sprite !)
  uint32 *sprite32;
};

#endif









