
#include "datei.H"
#include "iotype.H"
#include "listen2.H"

class strings_zeigerelemtype : public zeigerelemtype<strings_zeigerelemtype>
{
public:
    stringtype kl1;
    stringtype kl2;
    float test;

    strings_zeigerelemtype(iotype *ioptr,int8 mode)
    {load(ioptr,mode);}

    load(iotype *ioptr,int8 mode)
    {
	cfgtype *cfgptr=choose_cfgtype(ioptr,mode);
	cfgptr->read_string_check(&kl1);
	cfgptr->read_string_check(&kl2);
	cfgptr->read_float_check(&test);
	delete cfgptr;
    }

    save(iotype *ioptr,int8 mode)
    {
	cfgtype *cfgptr=choose_cfgtype(ioptr,mode);
	cfgptr->write_string(&kl1);
	cfgptr->write_string(&kl2);
	cfgptr->write_float(test);
	delete cfgptr;
    }
};

machekette_io_lstype(strings)
strings_kette_io_lstype strings_kette;

void savetotext(char *name,iotype *io)
{
    io->clear();
    strings_kette.save(io,CFG_TEXT_MODE);
    int handle=creat_check(name,S_IRUSR|S_IRGRP|S_IROTH|S_IFREG);
    write_check(handle,io->buffer,io->buffersize);
    close(handle);
};

int main()
{
    iotype *io;
    int handle;

    // Aus Textfile laden
    io=make_file_to_io_check("test.text");
    strings_kette.load(io,CFG_TEXT_MODE);
    
/* Alternativ zum laden !!
    strings_kette_auto_iotype strings_kette;
    strings_zeigerelemtype *neues=new strings_zeigerelemtype();
    neues->test=3.3377;
    neues->kl1.link("HALLO save One !!");
    neues->kl2.link("Hallo save two !");
    strings_kette.zeiger_push(neues);
    */

    // In Textfile saven
    savetotext("test.sav1",io);

    // In Binaerfile saven
    io->clear();
    strings_kette.save(io,CFG_BINAER_MODE);
    handle=creat_check("test.binaer.sav",S_IRUSR|S_IRGRP|S_IROTH|S_IFREG);
    write_check(handle,io->buffer,io->buffersize);
    close(handle);

    strings_kette.clear();

    // Aus Binaerfile laden
    delete io;
    io=make_file_to_io_check("test.binaer.sav");
    strings_kette.load(io,CFG_BINAER_MODE);

    // In Textfile saven
    savetotext("test.sav2",io);
    return(0);
}
