/*
 *  draw.c - drawing part
 *
 *  Copyright (C) 2003 Draghicioiu Mihai Andrei <misuceldestept.go.ro>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <time.h>
#include <X11/Xlib.h>

#include "dockapp.h"
#include "options.h"

void draw_window()
{
 struct tm *atm;
 time_t     atime;
 char day[3], month[3];
 int n;

 atime = time(NULL);
 atm = localtime(&atime);
 sscanf(ctime(&atime), "%s %s", day, month);
 if(opt_ampm)
 {
  XCopyArea(display, letters, buffer, gc,
            72, 0, 6, 6, 51, 42); /* M */
  if(atm->tm_hour > 12)
  {
   atm->tm_hour -= 12;
   XCopyArea(display, letters, buffer, gc,
             90, 0, 6, 6, 45, 42); /* P */
  }
  else
  {
   XCopyArea(display, letters, buffer, gc,
             0, 0, 6, 6, 45, 42); /* A */
  }
 }
 if(atm->tm_hour>9)
  XCopyArea(display, bignums, buffer, gc,
            (atm->tm_hour / 10) * 8, 0, 8, 12, 7, 29);
 else
  XCopyArea(display, bignums, buffer, gc,
            80, 0, 8, 12, 7, 29);
 XCopyArea(display, bignums, buffer, gc,
           (atm->tm_hour % 10) * 8, 0, 8, 12, 16, 29);
 XCopyArea(display, bignums, buffer, gc,
           (atm->tm_min / 10) * 8, 0, 8, 12, 27, 29);
 XCopyArea(display, bignums, buffer, gc,
           (atm->tm_min % 10) * 8, 0, 8, 12, 36, 29);
 XCopyArea(display, numbers, buffer, gc,
           (atm->tm_sec / 10) * 6, 0, 6, 6, 46, 35);
 XCopyArea(display, numbers, buffer, gc,
           (atm->tm_sec % 10) * 6, 0, 6, 6, 52, 35);
 for(n=0;n<3;n++)
 {
  XCopyArea(display, letters, buffer, gc,
            (day[n] > 90 ? day[n] - 97 : day[n] - 65)*6, 0,
	    6, 6, 7+n*6, 51);
  XCopyArea(display, letters, buffer, gc,
            (month[n] > 90 ? month[n] - 97 : month[n] - 65)*6, 0,
	    6, 6, 39+n*6, 51);
 }
 XCopyArea(display, numbers, buffer, gc,
           (atm->tm_mday / 10) * 6, 0, 6, 6, 26, 51);
 XCopyArea(display, numbers, buffer, gc,
           (atm->tm_mday % 10) * 6, 0, 6, 6, 32, 51);
 update_window();
 XSync(display, False);
}
