#include "help.h"

char namestack[STACKSIZE];
char *strcpy(), *strcat(), *getenv();
int tgetnum();
struct direct *readdir();
DIR *opendir();
char **environ;	/* environment, for forks */
bool info_user;
int termwidth = DEFTERMWIDTH;
int termheight = DEFTERMHEIGHT;
/*
 *union wait statusp;
 */
int statusp;

void termsize(termwidth,termheight)
    int *termwidth, *termheight;
 {
    char capbuf[1024];
    if (tgetent (getenv("TERM"), capbuf) == 1) {
	*termwidth = tgetnum("co");
	if (*termwidth <= 0) *termwidth = DEFTERMWIDTH;
	else if (*termwidth > MAXTERMWIDTH) *termwidth = MAXTERMWIDTH;
	*termheight = tgetnum("li");
	if (*termheight <= 0) *termheight = DEFTERMHEIGHT; }
 }

/* **************************************************************
 * init_funky - initialize funky stuff, and save startup values
 *
 *         This routine starts up breaking for ESC, and
 *   saves the initial tchars structure.
 */
void init_funky()
 {
    char *malloc();

    if ( isatty(0) ) {
	init_tchars = (struct tchars *) malloc (sizeof(struct tchars));
	here_tchars = (struct tchars *) malloc (sizeof(struct tchars));
	ioctl(0,TIOCGETC,init_tchars);
	ioctl(0,TIOCGETC,here_tchars);
	here_tchars->t_brkc = '\033';
	ioctl(0,TIOCSETC,here_tchars); }
    return;
  }

void logout(n)
    int n;
 {
    exit(0);
 }

/* *************************************************************
 * findtopics: find the topics available in this directory
 *
 *	This routine does a directory of help options.
 *	The number of subtopics found is returned, along with
 *  a pointer to a null-terminated vector of string pointers.
 */

int findtopics(dname,topics,nbuf)
    char *dname;
    char **topics,**nbuf;
  {
    int i,j,totalnames;
    char *index();
    char *s1,*thisname,*nxcnt;
    char **nxtname;
    struct direct *filedat;
    DIR *dirp;

    nxcnt = *nbuf;
    dirp = opendir(dname);
    if (dirp == NULL) return(0);

    for (nxtname=topics, totalnames=0; totalnames < (MAXNAMES-1) ; ) {
	filedat = readdir(dirp);
	if (filedat == NULL) break;
	thisname = filedat->d_name;
	if ( *thisname == '.') continue;
	if ( (s1 = index(thisname,'.')) != NULLS) {
	    if (strcmp(s1, HELPEXT) == 0) {
		*s1 = '\0';
		*(nxcnt++) = 'H'; }
	    else if ( strcmp(s1, MANEXT) == 0) {
		*s1 = '\0';
		*(nxcnt++) = 'M'; }
	    else if ( strcmp(s1, LISTEXT) == 0)
		continue;
	    else {
		*(nxcnt++) = 'F';
		*nxtname++ = nxcnt; }}
	else {
	    *(nxcnt++) = 'D'; }
	*nxtname++ = nxcnt; 
	strcpy(nxcnt,thisname);
	nxcnt += (strlen(thisname) + 1);
	totalnames++; }
    *nxtname++ = NULLS;
    *nbuf = nxcnt;
    closedir(dirp);

    if (totalnames == 0) return(0);

    /* sort the names in ascending order with exchange algorithm */
    for (i=0; i < totalnames-1; i++)
	for (j=i+1; j <totalnames; j++)
	    if (strcasecmp(topics[i],topics[j]) > 0) {
		thisname = topics[i];
		topics[i] = topics[j];
		topics[j] = thisname; }
    return(totalnames);
  }

 /* ***************************************************************
  * existtopic: return true if a match match exists
  */

bool existtopic(src,vec)
    char *src;
    char **vec;
 {
    char *m[MAXMATCHES];
    int i,j,slen;

    if ( (slen = strlen(src)) == 0 ) return(0);  

    for (i=0, j=0; vec[i] != NULLS && j < MAXMATCHES; i++) {
	if  ( strcasecmp(src,vec[i]) == 0 ) {   /* exact match! */
	    m[0] = vec[i];  j = 1;
	    break; }
	else if ( strncasecmp(src,vec[i],slen) == 0   && 
		  strlen(vec[i]) >= slen )
	    m[j++] = vec[i]; }
    m[j] = NULLS;
    return(j > 0);
 }

 /* ***************************************************************
  * matchtopics: return all matches of a string in a vector.
  *
  *	This routine accepts a string and a vector of strings. 
  *  The string is supposed to be an abbreviation of one or more
  *  strings in the vector.  The full versions of the strings are
  *  placed in a another vector (which is in a static area) and
  *  a pointer to that vector returned.  Note that the input
  *  vector of pointers must have NULL as its terminating element.
  *  The output vector will also terminate with NULL.
  *	NOTE: The vector returned contains pointers into the input
  *  vector.  Do not, therefore, mess with the contents of the output
  *  vector.
  *
  *  If NULL is returned, nothing matched, or there was some other
  *  error.
  */

int matchtopics(src,vec,mx)
    char *src;
    char **vec, **mx;
 {
    char *m[MAXMATCHES];
    int i,j,slen;

    if ( (slen = strlen(src)) == 0 ) return(0);  

    for (i=0, j=0; vec[i] != NULLS && j < MAXMATCHES; i++) {
	if  ( strcasecmp(src,vec[i]) == 0 ) {   /* exact match! */
	    m[0] = vec[i];  j = 1;
	    break; }
	else if ( strncasecmp(src,vec[i],slen) == 0   && 
		  strlen(vec[i]) >= slen )
	    m[j++] = vec[i]; }
    m[j] = NULLS;
    for (i=0; i <= j; mx[i] = m[i], i++);
    return(j);
 }

/* **************************************************************
 * makewvec: make a vector of words, up to N of them
 *
 *    This routine uses index to simply parse a string
 *  made up of (possibly) several blank-separated words.
 *  The words are stored into the slots of a vector, as pointers
 *  into the original string.  Therefore, the original string
 *  is destroyed.
 */
 makewvec(sstr, rvec, veccnt)
     char *sstr;
     char **rvec;
     int veccnt;
 {
    int mcnt = 0;
    int done = 0;
    char *s1, *s2, *index();

    if (strlen(sstr) == 0) {
	rvec[0] = NULL; }
    else {
	/* skip leading whitespace */
	for(s1=sstr; iswhite(*s1); s1++);
	for(mcnt = 0, done = 0; !done; ) {
	    s2 = index(s1,' ');
	    if (s2 == NULL) s2 = index(s1,'	');
	    if (s2 == NULL) s2 = index(s1,'\n');
	    if (s2 != NULL) *s2 = '\0';
	    if (strlen(s1) > 0) {
		rvec[mcnt] = s1;
		mcnt++; }
	    if (mcnt >= veccnt) break;
	    if (s2 == NULL) done = 1;
	    else {
		/* skip more white space */
		for(s1 = s2+1; iswhite(*s1); s1++);
		if (*s1 == '\0') done = 1; }}
	rvec[mcnt] = NULL; }
    return(mcnt);
 }

int morechan()
 {
    int pid;
    int filedes[2];
    pipe(filedes);
#ifdef USG
    pid = fork();
#else
    pid = vfork();    /* fork 2 copies of us */
#endif
    if (pid < 0)  {
        fflush(stdout);
	perror("help: fork");
	_exit(1); }
    else if (pid == 0)  { /* we are child
	char linebuf[MAXLINELEN], minibuf[2];
	int row = 0;
	int inf;
	close(filedes[1]);
	inf = fdopen(filedes[0]);
	while (1) {
	    fgets(linebuf,MAXLINELEN,inf);
	    if (strlen(linebuf) <= 0) _exit(0);
	    row++;
	    if (row >= termheight) {
		puts(more_for_help);
		fflush(stdout);
		fgets(minibuf,2,stdin);
		row = 0;
	    puts(linebuf); }}
    else {          /* we are parent, wait for child */
	close(filedes[0]);
	return(filedes[1]); }  
 }

void printlist(vec,namecnt)
     char **vec;
     int namecnt;
  {
    int i,j,k;
    int longlen, namewidth, rowcnt, colcnt;
    char *s1;
    static char row[MAXTERMWIDTH+1];

    longlen = 0;
    for (i=0; i < namecnt; i++ )
        longlen = ((k=strlen(vec[i]))>longlen)?k:longlen;

    /* here print the names out in nice columns */
    namewidth = longlen + COLUMNSPACE;
    rowcnt = termwidth / namewidth;
    colcnt = (namecnt + (rowcnt-1)) / rowcnt ;
    if (colcnt <= 0) colcnt = 1;

    if (rowcnt >= 1) {
	for (i=0; i < colcnt ; i++ ) {
	    for (k=0; k < termwidth; row[k++] = ' ');
	    row[k] = '\0';
	    for (j=0, s1 = row; 
		    (i+j) < namecnt; 
		    j += colcnt) {
		row[strlen(row)] = ' ';
		strcpy(s1,vec[i+j]);
		s1 = s1 + namewidth; }
	    printf("    %s\n",row); }}
    else {
	for (i=0; i < namecnt; i++)
	    printf("%s\n",vec[i]); }
  }

 /* *****************************************************************
  * fkoff: fork a process and return the exit status of the process.
  *
  *    This routine takes a command line separated into words, and
  *  uses vfork(2) and execve(2) to quickly run the program.
  *
  *  This is a simplified version of the fkoff() routine from dcon(8).
  *  Here, a program name and up to four arguments may be passed in.
  *  If one of them is null, FINE, but the fifth 
  *
  */

int fkoff(prg,arg1,arg2,arg3,arg4)
    char *prg, *arg1, *arg2, *arg3, *arg4;
 {
    char *command, *malloc(), *argvec[6];
    int pid,i;

    for (i=0; i < 6; argvec[i++] = NULLS);
    argvec[0] = prg;
    argvec[1] = arg1;
    argvec[2] = arg2;
    argvec[3] = arg3;
    argvec[4] = arg4;
    if (argvec[0] == NULLS) return(-1);
    command = malloc ((unsigned) strlen(argvec[0]) + 1);
    strcpy(command,argvec[0]);

    Set_Tc_Init( (fileno(stdin)) ) ;
#ifdef USG
    pid = fork();
#else
    pid = vfork();    /* fork 2 copies of us */
#endif
    if (pid < 0)  {
        fflush(stdout);
	perror("help: fork");
	Set_Tc_Here( (fileno(stdin)) ) ; 
	return(0); }
    else if (pid == 0)  { /* we are child, execve the program. */
/*        dup2(fileno(output,fileno(stdout)); /* Change stdout... */
	execve(command,argvec,environ);
	_exit(1); }
    else {          /* we are parent, wait for child */
	wait((union wait *) 0);
	Set_Tc_Here( (fileno(stdin)) ) ; }
    return(0);
 }


void writelog(t)
    char *t;
 {
    int d;
    if ((d = open (LOGFILE, O_WRONLY | O_APPEND)) != -1) {
        write (d, (info_user ? "info " : "help "), 5);
	write (d, t, strlen(t));
	write (d, "\n", 1);
	close(d); }
    else perror("open");
 }

 /* **************************************************************
  *	This routine sends a help file to more(1).  A string
  *  is passed in, which is the name of a help.  If the string
  *  is nil, then just use the name .both.
  *	The return value is -1 if no help file is accessible, 
  *  0 if the more(1) command was called okay with fkoff();
  */

void printhelp(dir,hs)
    char *dir, *hs;
 {
    char filename[MAXNAMELEN];

    strcpy(filename,dir);
    strcat(filename,"/");
    if (hs == NULLS) {
	writelog(dir);
	strcat(filename,HELPEXT);
	if (info_user)
	    fkoff (INFOPROGRAM, INFOPROGOPTS, filename, NULLS, NULLS);
	else fkoff (VIEWPROGRAM, VIEWPROGOPTS1, VIEWPROGOPTS2, filename, NULLS);
	return; }
    else {
	strcat(filename,hs);
	writelog(filename);
	switch (hs[-1]) {
	    case 'H': {
		strcat(filename,HELPEXT);
		if (info_user)
		    fkoff (INFOPROGRAM, INFOPROGOPTS, filename, NULLS, NULLS);
		else fkoff (VIEWPROGRAM, VIEWPROGOPTS1, VIEWPROGOPTS2, filename, NULLS);
		return; }
	    case 'M': {
		strcat(filename,MANEXT);
		if (info_user)
		    fkoff (INFOMANPROGRAM, filename, NULLS, NULLS, NULLS);
		else fkoff (MANPROGRAM, filename, NULLS, NULLS, NULLS);
		return; }
	    case 'D': {
		return; }
	    default: {}}}
 }

/* ****************************************************************
 * takeit: ask user whether to take next topic, return t or f
 *
 *	This routine takes a message, with format, and asks the 
 *  user whether he wants to do the action, not do the action,
 *  or quit the cycle of actions.
 *	y - return  0
 *	n - return  1
 *	k - return  0
 *	e - return  1
 *	q - return -1
 *	? - tell what y, n, and q do.
 *     <CR> - carriage return
 *
 *	Naturally, case is insignificant.
 */

int takeit(tvec)
    char **tvec;
 {
    char ans[40];
    char *fgets();

    while (1) {
	char **w;
	printf(next_subtopic);
	for (w = tvec; *w; w++) printf (" %s", *w);
	printf (" --- %s ", want_to_read);
	if (fgets(ans, 39, stdin) == NULL) exit(1);  /* abort */
	isupper(*ans)?(*ans=tolower(*ans)):0;
	switch (*ans) {
	    case 'n': ;
	    case 'e':
		return 1;
	    case 'y': ;
	    case 'k': ;
	    case '\n':
		return 0;
	    case 'q': ;
	    case 's':
		return -1;
	    default:
		printf(ynq_advice); }}
 }

 /* ****************************************************************
  * help2: descend recursive help tree and provide some
  *	     user services.
  *
  *  This routine climbs recursively around an n-tree of documentation
  *  files and directories.  The routine printhelp() outputs a file of
  *  help text, the routine findtopics finds out all subtopics.
  *
  *  Return values:
  *      0: normal return
  *     -1: quit
  */

int help2(pvec,args,oldnbuf)
    char **pvec;
    char *oldnbuf;
    char **args;
 {
    char *nbuf;
    char *svec[MAXDEPTH], *topics[MAXNAMES], *matches[MAXMATCHES], *newpvec[MAXDEPTH];
    char dname[MAXPATHLEN];
    char **p, **q;
    int ntopics,nmatches;
    int i;
    nbuf = oldnbuf;
    for (p = args, q = svec; *p; p++, q++) *q = *p;
    *q = NULLS;
    strcpy(dname,".");
    for (p = pvec; *p; p++) {
	strcat(dname,"/");
	strcat(dname,*p); }
    ntopics = findtopics(dname,topics,&nbuf);
    if (svec == NULL || *svec == NULLS ) {
	switch (takeit(pvec)) {
	    case -1:
		return -1;
	    case 0:
		printf("\n");
		printhelp(dname,NULLS);
		printf("\n");
		if (ntopics) {
		    printf ("%s\n", subtopics);
		    printlist(topics,ntopics);
		    printf("\n"); }
		return 0;
	    case 1:
		return 0; }}
    nmatches = matchtopics (*svec, topics, matches);
    if (! nmatches) return 0;
    for (p = pvec, q = newpvec; *p; p++, q++) *q = *p;
    *(q+1) = NULLS;
    for (i = 0; i < nmatches; i++) {
	*q = matches[i];
	if (matches[i][-1] == 'D') {
	    switch (help2 (newpvec, svec + 1, nbuf)) {
		case -1:
		    return -1;
		case  0:
		    continue; }}
	else {
	    switch (takeit(newpvec)) {
		case -1:
		    return -1;
		case 0:
		    printf("\n");
		    printhelp (dname, matches[i]);
		    printf("\n");
		    continue;
		case 1:
		    continue; }}}
    return 0;
 }

 /* ****************************************************************
  * help1: descend recursive help tree and provide some
  *	     user services.
  *
  *  This routine climbs recursively around an n-tree of documentation
  *  files and directories.  The routine printhelp() outputs a file of
  *  help text, the routine findtopics finds out all subtopics.
  *
  *  Return values:
  *      0: normal return
  *     -1: quit
  */

int help1(pvec,args,oldnbuf)
    char **pvec;
    char *oldnbuf;
    char **args;
 {
    char *nbuf;
    char *svec[MAXDEPTH], *topics[MAXNAMES], *matches[MAXMATCHES];
    char dname[MAXPATHLEN];
    char **p, **q;
    int ntopics,nmatches;
    nbuf = oldnbuf;
    for (p = args, q = svec; *p; p++, q++) *q = *p;
    *q = NULLS;
    strcpy(dname,".");
    for (p = pvec; *p; p++) {
	strcat(dname,"/");
	strcat(dname,*p); }
    ntopics = findtopics(dname,topics,&nbuf);
    if ( svec == NULL || *svec == NULLS) {
	printf("\n");
	printhelp(dname,NULLS);
	printf("\n");
	if (ntopics) {
	    printf ("%s\n", subtopics);
	    printlist(topics,ntopics);
	    printf("\n"); }
	else return 0; }
    while (1) {
	char answer[MAXLINELEN];
	if (*svec != NULLS) {
	    nmatches = matchtopics (*svec, topics, matches);
	    if (! nmatches) {
		printf ("%s '",subsorry);
		for (p = pvec; *p; p++) printf ("%s ", *p);
		printf ("%s'\n", *svec);
		printf ("%s\n", topiclist);
		printlist(topics,ntopics);
		printf("\n"); }
	    else {
		int i;
		char *newpvec[MAXDEPTH];
		for (p = pvec, q = newpvec; *p; p++, q++) *q = *p;
		*(q+1) = NULLS;
		for (i = 0; i < nmatches; i++) {
		    *q = matches[i];
		    if (matches[i][-1] == 'D') {
			switch ((nmatches > 1 ? help2 : help1) (newpvec, svec + 1, nbuf)) {
			    case -1:
				return -1;
			    case  0:
				continue; }}
		    else {
			switch (nmatches > 1 ? takeit(newpvec) : 0) {
			    case -1:
				return -1;
			    case 0:
				printf("\n");
				printhelp (dname, matches[i]);
				printf("\n");
				continue;
			    case 1:
				continue; }}}}}

	/* now, prompt and wait for user response */
	printf ("%s ", prompt);
	for (p = pvec; *p; p++) printf ("%s ", *p);
	if ( fgets(answer, MAXLINELEN-1, stdin) == NULL ) {
	    puts("\n");
	    exit(1); }
	if (makewvec(answer,svec,MAXDEPTH) == 0) return 0;
	if (**svec == '?') {
	    printf ("\n%s\n", topiclist);
	    printlist(topics,ntopics);
	    printf("\n");
	    *svec = NULLS; }}
 }

main(argc,argv)
    int argc;
    char **argv;
 {
    char *helpdir;
    char *pvec0 = NULLS;

    /* termsize (&termwidth, &termheight); */
    info_user = (getuid() == INFOUID);
    helpdir = (info_user ? INFODIR : HELPDIR);
    if (chdir(helpdir) < 0) {
	fprintf(stderr,help_not_found,helpdir);
	exit(1); }
    /* init_funky(); */
    if (info_user) {
	int p;
	p = fork();
	if (p > 0) {
	    time_t t;
	    time_t time();
	    struct stat ttystat;
	    signal(SIGCHLD,logout);
	    while (1) {
		sleep(SLEEPTIME);
		time(&t);
		fstat(fileno(stdin),&ttystat);
		if (ttystat.st_atime < t - LOGINMAX) logout(0); }}}
    help1 (&pvec0, argv + 1, namestack);
    exit(0);
 }
