/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** 
** Test code for flx_return_button.c 
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "forms.h" 
#include "flx.h" 


void exit();
void testCB();


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void main (int argc, char **argv)
{
 
    FL_FORM *main_form;
    FL_OBJECT *obj, *ret;
    FL_IOPT control;       
    int version, revision;
       
     
    /* Make sure the distribution is consistent wrt version numbers */
    if (FL_INCLUDE_VERSION != fl_library_version(&version, &revision)) {
       fprintf(stderr,"*** Header/library version mismatch!\n");
       fprintf(stderr,"    Header: %d.%d\n", FL_VERSION, FL_REVISION);
       fprintf(stderr,"    Library: %d.%d\n", version, revision);
       exit(1);
    }

         
    /* Set some defaults and initialize the library */
    control.buttonFontSize = 12;
    control.labelFontSize  = 12;
    control.borderWidth    = -2;
        
    fl_set_defaults(FL_PDButtonFontSize|
                    FL_PDLabelFontSize|
                    FL_PDBorderWidth,
                    &control);
    
    fl_initialize (&argc, argv, "flx_return_button", 0, 0);

 
    main_form = fl_bgn_form(FL_UP_BOX, 300, 110);

        obj = flx_add_return_button(FLX_NORMAL_BUTTON, 
            30, 40, 100, 30, "Accept");
        fl_set_object_lstyle(obj, FL_BOLD_STYLE);
        fl_set_object_callback(obj, testCB, 0);
              
        obj = fl_add_button(FL_NORMAL_BUTTON, 165, 40, 100, 30, "Cancel");
        fl_set_object_lstyle(obj, FL_BOLD_STYLE);
        fl_set_object_callback(obj, exit, 0);

    fl_end_form();

    fl_show_form(main_form, FL_PLACE_CENTERFREE, 
                    FL_FULLBORDER, "flx_return_button");

    do {
       ret = fl_do_forms();
    } while (ret != NULL);

    fl_hide_form(main_form);
    exit(0);


}


void testCB(FL_OBJECT *ob, long data)
{
    printf("Accept button pressed\n");

}
