/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** 
** Test code for flx_show_dialog.c 
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "forms.h" 
 
void exit();
static void TestCB(FL_OBJECT *ob, long data);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void main (int argc, char **argv)
{
 
    FL_FORM *main_form;
    FL_OBJECT *obj, *ret;
    FL_IOPT control;       
    int version, revision;
   
    int w, h;    
    
     
    /* Make sure the distribution is consistent wrt version numbers */
    if (FL_INCLUDE_VERSION != fl_library_version(&version, &revision)) {
       fprintf(stderr,"*** Header/library version mismatch!\n");
       fprintf(stderr,"    Header: %d.%d\n", FL_VERSION, FL_REVISION);
       fprintf(stderr,"    Library: %d.%d\n", version, revision);
       exit(1);
    }

         
    /* Set some defaults and initialize the library */
    control.buttonFontSize  = 12;
    control.labelFontSize   = 12;
    control.borderWidth     = -1;
        
    fl_set_defaults(FL_PDButtonFontSize|
                    FL_PDLabelFontSize|
                    FL_PDBorderWidth,
                    &control);
    
    fl_initialize (&argc, argv, "test", 0, 0);

 
    main_form = fl_bgn_form(FL_UP_BOX, 220, 90);
    
        obj = fl_add_button(FL_NORMAL_BUTTON, 
            10, 10, 200, 30, "flx_show_dialog");
        fl_set_object_callback(obj, TestCB, 0);

        obj = fl_add_button(FL_NORMAL_BUTTON, 
            10, 50, 200, 30, "Dismiss");
        fl_set_object_callback(obj, exit, 0);

    fl_end_form();

    fl_show_form(main_form, FL_PLACE_CENTERFREE, 
                    FL_FULLBORDER, "flx_show_dialog test");

    do {
       ret = fl_do_forms();
    } while (ret != NULL);

    fl_hide_form(main_form);
    exit(0);


}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void TestCB(FL_OBJECT *ob, long data)
{
    int x;
    
    x = -1;


    flx_set_dialog_lcol(FL_BLACK);
    flx_set_dialog_color(FL_COL1, FL_RED);   
    flx_set_dialog_bgcolor(FL_COL1);   
    flx_set_dialog_font(FL_BOLD_STYLE, FL_NORMAL_SIZE);
    
    x = flx_show_dialog("error", "An Error Occurred!");
    printf("error dialog: return value = %d\n", x);
    
    x = flx_show_dialog("info", "Some Info");
    printf("info dialog: return value = %d\n", x);

    x = flx_show_dialog("question", "A Question?");
    printf("question dialog: return value = %d\n", x);

    x = flx_show_dialog("message", "A Message");
    printf("message dialog: return value = %d\n", x);

    x = flx_show_dialog("warning", "Warning: Invalid Filename!");
    printf("warning dialog: return value = %d\n", x);
     

}
