/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** 
** Test code for flx_sort_browser.c 
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "forms.h" 



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void bCB(FL_OBJECT *ob, long data)
{
    FL_OBJECT *browser = (FL_OBJECT *) ob->u_vdata;

    printf("Sorting...");
    flx_sort_browser(browser, 0);   
    printf("done\n");
}    

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
void QuitCB(FL_OBJECT *ob, long data)
{ 
    fl_finish();
    exit (0);

}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
int main(int argc, char **argv)
{
    FL_FORM *form;
    FL_OBJECT *browser;
    FL_OBJECT *obj;
        
    fl_initialize (&argc, argv, "", 0, 0);
    
    
    form = fl_bgn_form(FL_UP_BOX, 440, 250);
  
    browser = fl_add_browser(FL_HOLD_BROWSER, 
        20, 20, 400, 165, "");
    fl_set_browser_fontstyle(browser, FL_BOLD_STYLE);
    fl_set_browser_fontsize(browser, FL_NORMAL_SIZE);

    fl_add_browser_line(browser, "Line 1");
    fl_add_browser_line(browser, "Line 9");
    fl_add_browser_line(browser, "Line 5");
    fl_add_browser_line(browser, "Line 2");
    fl_add_browser_line(browser, "A: this line should be on top");
    fl_add_browser_line(browser, "z: this line should be on bottom");
    fl_add_browser_line(browser, "Some line in the middle");
    fl_add_browser_line(browser, "Sorting is case-sensitive!");

    obj = fl_add_button(FL_NORMAL_BUTTON, 
	20, 200, 70, 30, "Sort"); 
    fl_set_object_lstyle(obj, FL_BOLD_STYLE);
    fl_set_object_callback(obj, bCB, 0);
    obj->u_vdata = (void *) browser; 

    obj = fl_add_button(FL_NORMAL_BUTTON, 
	100, 200, 70, 30, "Quit"); 
    fl_set_object_lstyle(obj, FL_BOLD_STYLE);
    fl_set_object_callback(obj, QuitCB, 0);

    fl_end_form();
    
     
    fl_show_form(form, FL_PLACE_CENTERFREE, 
        FL_FULLBORDER, "flx_sort_browser test");

    for (;;)
        fl_do_forms();

    fl_hide_form(form);


    return(0);
} 
