/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
**
** flx: Extensions for the xforms library
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the Free
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* 1001 <= class numbers <= 4999 */

#ifndef FLX_H
#define FLX_H



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** 
** flx_return_button
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
** Class number for flx_return_button
*/
#define FLX_RETURN_BUTTON    3501

/* 
** Defined button types 
*/   
#define FLX_NORMAL_BUTTON    0
#define FLX_ROUNDED3D_BUTTON 1
#define FLX_OVAL3D_BUTTON    2


extern FL_OBJECT *flx_create_return_button(int, FL_Coord, FL_Coord,
    FL_Coord, FL_Coord, const char *);
                                       
extern FL_OBJECT *flx_add_return_button(int, FL_Coord, FL_Coord,
    FL_Coord, FL_Coord, const char *);



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
** 
** flx_help_dialog
**
** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

extern FL_FORM *flx_help_dialog(const char *help_text);


#endif /* FLX_H */
